<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'ইনস্টল হওয়ার কাছাকাছি ';
$string['action'] = 'কাজ';
$string['actions'] = 'কাজ';
$string['active'] = 'সক্রিয়';
$string['activeusers'] = 'সক্রিয় ব্যবহারকারী';
$string['activities'] = 'কার্জকলাপ';
$string['activities_help'] = 'কার্যক্রম যেমন ফোরাম, কুইজ, উইকি, সক্রিয় করে ইন্টারএ্যক্টিভ বিষয়বস্তুকে পাঠ্যক্রমে যুক্ত হবার জন্য।';
$string['activity'] = 'কার্জকলাপ';
$string['activityclipboard'] = '<b>{$a}</b> কাজটি স্থানান্ত্রিত হচ্ছে';
$string['activityiscurrentlyhidden'] = 'দুঃখিত, এই কাজটি বর্তমানে লুকানো';
$string['activitymodule'] = 'মডিউল কার্যকলাপ';
$string['activitymodules'] = 'মডিউল কার্যকলাপ';
$string['activityreport'] = 'রিপোর্ট কার্যকলাপ';
$string['activityreports'] = 'রিপোর্ট কার্যকলাপ';
$string['activityselect'] = 'অন্যত্র সরানোর জন্য এই কাজটি নির্বাচিত করুন';
$string['activitysince'] = 'কাজটি {$a} থেকে';
$string['activityweighted'] = 'মাখাপিছু ব্যবহারকারীর কার্যক্রম';
$string['add'] = 'যোগ';
$string['addactivity'] = 'একটি কার্যক্রম যোগ ';
$string['addadmin'] = 'প্রশাসক যোগ';
$string['addblock'] = 'একটি ব্লক যোগ';
$string['addcomment'] = 'একটি মতামত যোগ';
$string['addcountertousername'] = 'ব্যবহারকারীর নামের সাথে নম্বর যোগ করে ব্যবহারকারী তৈরি';
$string['addcreator'] = 'পাঠ্যক্রম নির্মাতা যোগ';
$string['adddots'] = 'যোগ...';
$string['added'] = '{$a} যোগ হয়েছে';
$string['addedrecip'] = '{$a} নতুন গ্রাহক যোগ হয়েছে';
$string['addedrecips'] = '{$a} নতুন গ্রাহকবৃন্দ যোগ হয়েছে';
$string['addedtogroup'] = '"{$a}" গ্রুপে যোগ হয়েছে';
$string['addedtogroupnot'] = '"{$a}" গ্রুপে যোগ হবে না';
$string['addedtogroupnotenrolled'] = '{$a} গ্রুপে যুক্ত হয়নি, কারণ পাঠ্যক্রমের তালিকাভূক্ত নয়';
$string['addfilehere'] = 'এখানে ফাইল (গুলি) সংযোজন করুন';
$string['addinganew'] = 'নতুন {$a} যোগ হচ্ছে';
$string['addinganewto'] = 'নতুন {$a->what} যোগ হচ্ছে {$a->to} সাথে';
$string['addingdatatoexisting'] = 'বিদ্যমান উপাত্তের সাথে উপাত্ত যোগ হচ্ছে';
$string['addlinkhere'] = 'এখানে লিংক সংযোজন করুন';
$string['addnewcategory'] = 'নতুন বিভাগ যোগ';
$string['addnewcourse'] = 'নতুন পাঠ্যক্রম যোগ';
$string['addnewuser'] = 'নতুন ব্যবহারকারী যোগ';
$string['addnousersrecip'] = 'যুক্ত করুন গ্রাহক তালিকায় যাদের এই {$a} প্রবেশাধিকারের সুযোগ নেই';
$string['addpagehere'] = 'এখানে পৃষ্ঠা সংযোজন করুন';
$string['addresource'] = 'রিসোর্স যোগ...';
$string['address'] = 'ঠিকানা';
$string['addstudent'] = 'শিক্ষার্থী যোগ';
$string['addsubcategory'] = 'উপ-বিভাগ যোগ করুন';
$string['addteacher'] = 'শিক্ষক যোগ';
$string['admin'] = 'প্রশাসক';
$string['adminhelpaddnewuser'] = 'স্বহস্তে একটি নতুন ব্যবহারকরীর একাউন্ট তৈরি করতে';
$string['adminhelpassignadmins'] = 'এই সাইটের মধ্যে প্রশাসক যেকোন কিছু করতে এবং যেখানে খুশি যেতে পারে';
$string['adminhelpassigncreators'] = 'পাঠ্যক্রম নির্মাতা নতুন পাঠ্যক্রম তৈরি করতে পারে';
$string['adminhelpassignsiteroles'] = 'নির্ধারিত সাইট রোল সুনির্দিষ্ট ব্যবহারকারীগণকে প্রয়োগ ';
$string['adminhelpassignstudents'] = 'কোন পাঠ্যক্রমে যান এবং প্রশাসক মেনু থেকে শিক্ষার্থী যোগ করুন ';
$string['adminhelpauthentication'] = 'আপনি অভ্যন্তরীণ ব্যবহারকারী একাউন্ট অথবা বাহ্যিক ডাটাবেস ব্যাবহার করতে পারেন';
$string['adminhelpbackup'] = 'স্বয়ংক্রিয় ব্যাকআপ ও তাদের সময়সূচি কনফিগার';
$string['adminhelpconfiguration'] = 'সাইটটি দেখতে কেমন এবং কিভাবে কাজ করে তা কনফিগার';
$string['adminhelpconfigvariables'] = 'ভেরিয়েবল কনফিগার যেগুলো সাইটের সাধারণ অপারেশনকে প্রভাবিত করে ';
$string['adminhelpcourses'] = 'পাঠ্যক্রম এবং বিভাগ নির্ণয় করুন এবং তাদের জন্য জনবল নির্দিষ্ট করুন, অমীমাংসিত পাঠ্যক্রম সম্পাদনা';
$string['adminhelpeditorsettings'] = 'HTML সম্পাদকের জন্য প্রাথমিক সেটিংস নির্নয়';
$string['adminhelpedituser'] = 'ব্যবহারকারী একাউন্টের লিষ্ট ব্রাউজ এবং তাদের কোন একটি সম্পাদনা ';
$string['adminhelpenvironment'] = 'আপনার সার্ভার স্যুটের বর্তমান এবং ভবিষ্যৎ ইনস্টলেশন চাহিদা কি তা পরীক্ষা করুন';
$string['adminhelpfailurelogs'] = 'ব্যর্থ লগইনের লগগুলো ব্রাউজ';
$string['adminhelplanguage'] = 'বর্তমান ভাষা প্যাক পরীক্ষা ও সম্পাদনা চলছে';
$string['adminhelplogs'] = 'এই সাইটের সকল কার্যক্রমের লগগুলো ব্রাউজ ';
$string['adminhelpmanageblocks'] = 'ইনস্টলকৃত ব্লক ও তাদের সেটিংস নিয়ন্ত্রণ করুন';
$string['adminhelpmanagedatabase'] = 'সরাসরি ডাটাবেসে প্রবেশ (সাবধান!)';
$string['adminhelpmanagefilters'] = 'টেক্সট ফিল্টার এবং এ সম্পর্কিত সেটিংস নির্বাচন';
$string['adminhelpmanagemodules'] = 'ইনস্টলকৃত মডিউল এবং তাদের সেটিংস নিয়ন্ত্রণ';
$string['adminhelpmanageroles'] = 'রোলসমূহ তৈরি ও নির্ণয় করুন যেগুলো ব্যবহারকারীদের জন্য প্রয়োগ হতে পারে';
$string['adminhelpmymoodle'] = 'ব্যবহারকারীদের জন্য মাই মডুল ব্লক কনফিগার';
$string['adminhelpreports'] = 'সাইট লেভেল প্রতিবেদন';
$string['adminhelpsitefiles'] = 'সাধারণ ফাইলের মুদ্রণ অথবা বাহ্যিক ব্যাকআপের আপলোড';
$string['adminhelpsitesettings'] = 'সাইটের প্রথম পৃষ্ঠাটি কেমন তা নির্ণয়';
$string['adminhelpstickyblocks'] = 'মডুল-প্রশস্ত সরু ব্লকগুলো কনফিগার';
$string['adminhelpthemes'] = 'সাইটটি দেখতে (রং, ফন্ট  ইত্যাদি) কেমন নির্বাচন করুন';
$string['adminhelpuploadusers'] = 'নতুন ব্যবহারকারী একাউন্ট আমদানি পাঠ্য ফাইল থেকে';
$string['adminhelpusers'] = 'আপনার ব্যবহারকারী নির্ণয় এবং প্রমাণীকরণ প্রতিষ্ঠা করুন';
$string['adminhelpxmldbeditor'] = 'XMLDB ফাইলসমূহ সম্পাদনার জন্য ইন্টারফেস। শুধুমাত্র ডেভেলপারদের জন্য।';
$string['administration'] = 'প্রশাসন';
$string['administrationsite'] = 'সাইট প্রশাসন';
$string['administrator'] = 'প্রশাসক';
$string['administratordescription'] = 'প্রশাসক সাইটটিতে সাধারণ ভাবে যা কিছু করতে পারেন, সমস্ত পাঠ্যক্রমের অন্তর্ভূক্ত।';
$string['administrators'] = 'প্রশাসক';
$string['administratorsall'] = 'সকল প্রশাসক';
$string['administratorsandteachers'] = 'সকল প্রশাসক এবং শিক্ষক';
$string['advanced'] = 'উচ্চ পর্যায়ের';
$string['advancedfilter'] = 'উচ্চ পর্যায়ের অনুসন্ধান';
$string['advancedsettings'] = 'উচ্চ পর্যায়ের সেটিংস';
$string['again'] = 'আবার';
$string['aimid'] = 'লক্ষ্য আইডি';
$string['ajaxuse'] = 'এ্যজাক্স এবং জাভাস্ক্রিপ্ট';
$string['all'] = 'সকল';
$string['allactions'] = 'সকল কাজ';
$string['allactivities'] = 'সকল কার্যকলাপ';
$string['allchanges'] = 'সকল পরিবর্তন';
$string['alldays'] = 'সমস্ত দিন';
$string['allfieldsrequired'] = 'সকল ফিল্ড প্রয়োজনীয়';
$string['allfiles'] = 'সকল ফাইল';
$string['allgroups'] = 'সকল গ্রুপ';
$string['alllogs'] = 'সকল লগ';
$string['allmods'] = 'সকল {$a}';
$string['allow'] = 'অনুমোদন করুন';
$string['allowinternal'] = 'অভ্যন্তরীণ নিয়মগুলোও অনুমোদন করুন';
$string['allownone'] = 'কোনটিই অনুমোদন করবেন না';
$string['allownot'] = 'অনুমোদন করবেন না';
$string['allparticipants'] = 'সকল অংশগ্রহকারী';
$string['allteachers'] = 'সকল শিক্ষক';
$string['alphanumerical'] = 'শুধুমাত্র আলফানিউমেরিক অক্ষরসমূহ থাকতে পারে, হাইফেন (-) অথবা দাঁড়ি (। )';
$string['alreadyconfirmed'] = 'নিবন্ধন ইতোমধ্যে অনুমোদিত হয়েছে';
$string['always'] = 'সর্বদা';
$string['and'] = '{$a->এক} এবং {$a->দুই}';
$string['answer'] = 'উত্তর';
$string['any'] = 'যেকেউ';
$string['approve'] = 'সমর্থন';
$string['areyousuretorestorethis'] = 'আপনি কি চালিয়ে যেতে চান?';
$string['areyousuretorestorethisinfo'] = 'পরবর্তিতে এই প্রক্রিয়ায় আপনার অধিকার থাকবে এই ব্যাকআপ বিদ্যমান পাঠ্যক্রম সাথে অথবা তৈরিকৃত একটি পূর্নাঙ্গ নতুন পাঠ্যক্রমের সাথে যুক্ত করার।';
$string['asc'] = 'উর্দ্ধগামী';
$string['assessment'] = 'নিরূপন';
$string['assignadmins'] = 'প্রশাসক বরাদ্দ';
$string['assigncreators'] = 'নির্মাতা বরাদ্দ';
$string['assignsiteroles'] = 'সাইট-প্রশস্ত রোল বরাদ্দ';
$string['authenticateduser'] = 'প্রমাণীকৃত ব্যবহারকারী';
$string['authenticateduserdescription'] = 'ব্যবহারকারীর সকল লগ';
$string['authentication'] = 'প্রমাণীকরণ';
$string['authenticationplugins'] = 'প্রমাণীকরণ প্লাগইন';
$string['autosubscribe'] = 'স্বয়ংক্রিয়-গ্রাহক ফোরাম';
$string['autosubscribeno'] = 'না: ফোরামে আমাকে স্বয়ংক্রিয় গ্রাহক করবেন না';
$string['autosubscribeyes'] = 'হ্যাঁ: যখন আমি পোষ্ট করবো, সেই ফোরামে আমাকে গ্রাহক করবেন';
$string['availability'] = 'সহজলভ্যতা';
$string['availablecourses'] = 'সহজলভ্য পাঠ্যক্রমসমূহ';
$string['back'] = 'ফেরা';
$string['backto'] = '{$a}তে ফেরা';
$string['backtocourselisting'] = 'পাঠ্যক্রম লিষ্টে ফেরা';
$string['backtopageyouwereon'] = 'আপনার সচলকৃত পৃষ্ঠায় ফেরা';
$string['backtoparticipants'] = 'প্রাপকদের তালিকায় ফেরা';
$string['backup'] = 'ব্যাকআপ';
$string['backupactivehelp'] = 'স্বয়ংক্রিয় ব্যাকআপ নির্বাচন করতে পারেন অথবা নাও করতে পারেন।';
$string['backupcancelled'] = 'ব্যাকআপ বাতিল হয়েছে';
$string['backupcoursefileshelp'] = 'যদি সক্রিয় হয় তাহলে পাঠ্যক্রম ফাইলগুলো স্বয়ংক্রিয় ব্যাকআপের সাথে যুক্ত হবে ';
$string['backupdate'] = 'ব্যাকআপ তারিখ';
$string['backupdatenew'] = '&nbsp; {$a->ট্যাগ} হল এখন {$a->কাজের দিন}, {$a->mday} {$a->মাস} {$a->বছর}<br />';
$string['backupdateold'] = '{$a->ট্যাগ} ছিল {$a->কাজের দিন}, {$a->mday} {$a->মাস} {$a->বছর}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'ব্যাকআপ বিস্তারিত';
$string['backupexecuteathelp'] = 'পছন্দ করুন যে সময়ে স্বয়ংক্রিয় ব্যাকআপ চলা উচিৎ তখন।';
$string['backupfailed'] = 'আপনার কিছু পাঠ্যক্রম সংরক্ষন হয় নাই!!';
$string['backupfilename'] = 'ব্যাকআপ';
$string['backupfinished'] = 'ব্যাকআপ সফলভাবে সম্পন্ন হয়েছে';
$string['backupfromthissite'] = 'এই সাইটের ব্যাকআপ তৈরি হয়েছে?';
$string['backupgradebookhistoryhelp'] = 'যদি সক্রিয় হয় তবে গ্রডবুক ইতিহাস স্বয়ংক্রিয় ব্যাকআপে যুক্ত হবে। লক্ষ্য করুন যে এই কাজ চলার জন্য গ্রড ইতিহাস কখনও নিস্ক্রিয় হবেনা সার্ভার সেটিংসে (নিস্ক্রিয়গ্রেডইতিহাস)';
$string['backupincludemoduleshelp'] = 'নির্বাচন করুন স্বয়ংক্রিয় ব্যাকআপে আপনি পাঠ্যক্রম মডিউল যুক্ত করতে চান কি না, ব্যবহারকারী ডাটা সাথে নিয়ে অথবা ব্যতীত ';
$string['backupincludemoduleuserdatahelp'] = 'নির্বাচন করুন স্বয়ংক্রিয় ব্যাকআপের মধ্যে আপনি মডিউল ব্যবহারকারী ডাটা যুক্ত করতে চান কি না।';
$string['backupkeephelp'] = 'প্রতি পাঠ্যক্রমের জন্য কতগুলো সম্প্রতিক ব্যাকআপ আপনি রাখতে চান? ( স্বয়ংক্রিয় ভাবে পুরাতন একটি মুছতে থাকবে )';
$string['backuplogdetailed'] = 'সম্পািদত কার্যবিবরণীর বিবরণ';
$string['backuploglaststatus'] = 'শেষ সম্পািদত কার্যবিবরণী';
$string['backupmissinguserinfoperms'] = 'টীকাঃ এই ব্যাকআপ কোন ব্যবহারকারী ডাটা ধারন করে না। অনুশীলন এবং কর্মশালা কার্যসমূহ এই ব্যাকআপটিতে যুক্ত হবে না, যতক্ষণ ঐ মডিউলগুলো এই ধরনের ব্যাকআপের সােথ উপযুক্ত না হয়';
$string['backupnext'] = 'পরবর্তী ব্যাকআপ';
$string['backupnonisowarning'] = 'সতর্কীকরণঃ এই ব্যাকআপটি মডুলের ( প্রি ১.৬ ) একটি নন-ইউনিকোড সংস্করন। যদি এই ব্যাকআপটি কোন নন-আই এস ও-৮৮৫৯-১ লিপি ধারন করে তাহলে সেগুলো বিকৃত হতে পারে। যদি আপনি সেগুলো পূর্বাবস্থায় সংরক্ষন করার চেষ্টা করুন মডুলের এই ইউনিকোড সংস্করনে। দেখুন <a href="http://docs.moodle.org/en/Backup_FAQ"> ব্যাকআপ FAQ</a> আরো বিস্তারিত তথ্য কিভাবে ব্যাকআপটি পুনরূদ্ধার করবেন সঠিকভাবে।';
$string['backuporiginalname'] = 'ব্যাকআপ নাম ';
$string['backuproleassignments'] = 'ব্যাকআপ ভূমিকা বরাদ্দ এই ভূমিকাসমূহের ';
$string['backupsavetohelp'] = 'আপনি যে ডিরেক্টরীতে ব্যাকআপ ফাইলসমূহ সংরক্ষন করতে চান তার সম্পূর্ন পাথ <br />(খালি রাখুন এর পূর্বনির্ধারিত ডিরেক্টরীতে সংরক্ষন করার জন্য )';
$string['backupsitefileshelp'] = 'সক্রিয় হলে সাইট ফাইলসমূহ যেগুলো পাঠ্যক্রমে ব্যবহার হচ্ছে তা স্বয়ংক্রিয় ব্যাকআপের সাথে যুক্ত হবে ';
$string['backuptakealook'] = 'দয়া করে আপনার ব্যাকআপ লগ দেখুনঃ
  {$a} এর মধ্যে';
$string['backupuserfileshelp'] = 'ব্যবহারকারী ফাইলসমূহ স্বয়ংক্রিয় ব্যাকআপের সাথে যুক্ত হওয়া উচিৎ কিনা তা নির্বাচন করুন';
$string['backupversion'] = 'ব্যাকআপ সংস্করন';
$string['block'] = 'ব্লক';
$string['blockconfiga'] = '{$a} ব্লকটি কনফিগার হচ্ছে';
$string['blockconfigbad'] = 'এই ব্লকটি সঠিকভাবে বাস্তবায়িত হয়নি এবং এজন্য কনফিগারেশন ইন্টারফেস সরবরাহ করতে পারছে না।';
$string['blocks'] = 'ব্লক';
$string['blocksaddedit'] = 'ব্লক যোগ/সম্পাদনা ';
$string['blockseditoff'] = 'ব্লক সম্পাদনা বন্ধ';
$string['blocksediton'] = 'ব্লক সম্পাদনা চালু';
$string['blocksetup'] = 'ব্লক টেবিলসমূহ নির্ধারণ করুন';
$string['blocksuccess'] = 'সঠিকভাবে {$a} টেবিলসমূহ সেট আপ হয়েছে';
$string['brief'] = 'বিস্তারিত';
$string['bycourseorder'] = 'পাঠ্যক্রম নির্দেশ অনুযায়ী';
$string['byname'] = '{$a} অনুযায়ী';
$string['bypassed'] = 'বাইপাসড';
$string['cachecontrols'] = 'ক্যাশ নিয়ন্ত্রনসমূহ';
$string['cancel'] = 'বাতিল';
$string['cancelled'] = 'বাতিল হয়েছে';
$string['categories'] = 'পাঠ্যক্রম বিভাগসমূহ';
$string['category'] = 'বিভাগ';
$string['categoryadded'] = '\'{$a}\' বিভাগটি যোগ হয়েছে';
$string['categorycontents'] = 'উপবিভাগসমূহ এবং পাঠ্যক্রমসমূহ';
$string['categorycurrentcontents'] = '{$a} এর বিষয়বস্তু';
$string['categorydeleted'] = ' \'{$a}\' বিভাগটি মোছা হয়েছে';
$string['categoryduplicate'] = '\'{$a}\' নামের বিভাগটি ইতোমধ্যে বিদ্যমান!';
$string['categorymodifiedcancel'] = 'বিভাগ পরিবর্তিত হয়েছে! দয়া করে বাতিল করে নতুন করে চেষ্টা করুন।';
$string['categoryname'] = 'বিভাগ নাম';
$string['categoryupdated'] = '{$a} বিভাগটি হালনাগাদ হয়েছিল।';
$string['changedpassword'] = 'পাসওয়ার্ড পরিবর্তন করা হয়েছে।';
$string['changepassword'] = 'পাসওয়ার্ড পরিবর্তন করুন';
$string['changesmadereallygoaway'] = 'আপনি পরিবর্তন সম্পাদন করেছেন। আপনি কি সংযোগ রক্ষা করতে চান এবং পরিবর্তনগুলি হারিয়েছেন?';
$string['changessaved'] = 'পরিবর্তন সংরক্ষন হয়েছে।';
$string['check'] = 'পরীক্ষা করা';
$string['checkall'] = 'সব পরীক্ষা করুন';
$string['checkingbackup'] = 'ব্যাকআপ পরীক্ষা করা হচ্ছে';
$string['checkingcourse'] = 'পাঠ্যক্রম পরীক্ষা করা হচ্ছে';
$string['checkingforbbexport'] = 'ব্ল্যাকবোর্ড এক্সপোর্টের জন্য পরীক্ষা করা হচ্ছে';
$string['checkinginstances'] = 'ইনস্ট্যান্স পরীক্ষা করা হচ্ছে';
$string['checkingsections'] = 'সেশন পরীক্ষা করা হচ্ছে';
$string['checklanguage'] = 'ভাষা পরীক্ষা';
$string['checknone'] = 'কোনটি পরীক্ষা নয়';
$string['childcoursenotfound'] = 'শিশু পাঠ্যক্রম পাওয়া যায় নাই!';
$string['childcourses'] = 'শিশু পাঠ্যক্রমসমূহ';
$string['choose'] = 'নির্বাচন করুন';
$string['choosecourse'] = 'একটি পাঠ্যক্রম নির্বাচন করুন';
$string['choosedots'] = 'নির্বাচন করুন...';
$string['chooselivelogs'] = 'অথবা বর্তমান কার্যক্রম পর্যবেক্ষন করুন';
$string['chooselogs'] = 'নির্বাচন করুন আপনি কোন লগটি দেখতে চান';
$string['choosereportfilter'] = 'রিপোর্টটির জন্য ফিল্টার নির্বাচন করুন';
$string['choosetheme'] = 'থীম নির্বাচন করুন';
$string['chooseuser'] = 'ব্যবহারকারী নির্বাচন করুন';
$string['city'] = 'শহর/ টাউন';
$string['clambroken'] = 'আপনার প্রশাসক ফাইল আপলোডের ভাইরাস পরীক্ষা সক্রিয় করেছেন কিন্তু কিছু ভুল কনফিগার করেছেন। <br /> আপনার ফাইল আপলোড সফল হয়নি। আপনার প্রশাসক তাদেরকে অবহিত করার জন্য ইমেইল করেছে যেন তারা এটি নির্ধারণ করতে পারে।<br /> পরবর্তীতে এই ফাইল আপলোড করার চেষ্টা করা যেতে পারে।';
$string['clamdeletedfile'] = 'ফাইলটি মুছে ফেলা হয়েছে';
$string['clamdeletedfilefailed'] = 'ফাইলটি মোছা যাবে না';
$string['clamemailsubject'] = '{$a} :: ক্লাম AV ঘোষনা';
$string['clamfailed'] = 'ক্লাম AV চলতে অক্ষম। ফিরতি ত্রুটি বার্তা ছিল {$a}। এখানে ক্লাম থেকে আউটপুটঃ';
$string['clamlost'] = 'মডুল কনফিগার হয়েছে ফাইল আপলোডে ক্লাম চালানোর জন্য, কিন্তু পাথটি যোগান দেয়া হয়েছে ক্লাম AV কে, {$a}, তা অকার্যকর।';
$string['clamlostandactinglikevirus'] = 'তদুপরি, মুডল কনফিগার করা হয়েছে যাতে করে যদি ক্লাম চলতে ব্যর্থ হয়, ফাইলগুলো ভাইরাসের মতো আচরন করবে। এটির মূলত মানে হল কোন শিক্ষার্থী ফাইল আপলোড করতে পারবে না যতক্ষন না আপনি এটি নির্ধারণ করে দেন।';
$string['clammovedfile'] = 'ফাইলটি সরানো হয়েছে আপনার নির্ধারিত কুয়ারানটাইন ডিরেক্টরীতে, নতুন স্থানটি হল {$a}';
$string['clammovedfilebasic'] = 'ফাইলটি সরানো হয়েছে কুয়ারানটাইন ডিরেক্টরীতে।';
$string['clamquarantinedirfailed'] = 'ফাইলটি সরাতে পারবেন না আপনার নির্ধারিত কুয়ারানটাইন ডিরেক্টরীতে, {$a}। আপনাকে এটি নির্ধারন করে দিতে হবে ফাইলগুলো মোছা হবে যদি তাদেরকে সংক্রমিত অবস্থায় পাওয়া যায়।';
$string['clamunknownerror'] = 'এটা ছিল ক্লামের সাথে একটা অপরিচিত ক্রটি।';
$string['cleaningtempdata'] = 'অস্থায়ী ডাটা পরিষ্কার হচ্ছে';
$string['clear'] = 'পরিষ্কার করা';
$string['clickhelpiconformoreinfo'] = '...চলমান...সম্পূর্ণ আর্টিকেল পড়ার জন্য সাহায্যকারী আইকনে ক্লিক করুন';
$string['clickhere'] = 'এখানে ক্লিক করুন...';
$string['clicktochangeinbrackets'] = 'স্ট্রিং একটি প্লেসহোল্ডার ধারন করেছে';
$string['clicktohideshow'] = 'প্রসারণ কিংবা গুটানোর জন্য ক্লিক';
$string['closewindow'] = 'এই উইন্ডোটি বন্ধ করুন';
$string['collapseall'] = 'সব গুটিয়ে ফেলুন';
$string['commentincontext'] = 'এই সমালোচনাটি বিষয়বস্তুতে খুঁজুন';
$string['comments'] = 'সমালোচনা';
$string['commentsnotenabled'] = 'মন্তব্য সরজ্ঞাম সক্রিয় নয়';
$string['commentsrequirelogin'] = 'এই সমালোচনাটি দেখার জন্য আপনাকে লগইনের প্রয়োজন হবে';
$string['comparelanguage'] = 'বর্তমান ভাষাটি তুলনা এবং সম্পাদনা করুন';
$string['complete'] = 'সম্পন্ন করা';
$string['completereport'] = 'রিপোর্টি সম্পন্ন';
$string['configuration'] = 'কনফিগারেশন';
$string['confirm'] = 'নিশ্চিত করুন';
$string['confirmcheckfull'] = 'আপনি পূর্ণভাবে নিশ্চিত যে আপনি {$a} নিশ্চিত করবেন?';
$string['confirmed'] = 'আপনার নিবন্ধন নিশ্চিত হয়েছে';
$string['confirmednot'] = 'আপনার নিবন্ধন এখনও নিশ্চিত হয় নাই!';
$string['content'] = 'বিষয়বস্তু';
$string['continue'] = 'চালিয়ে যান';
$string['continuetocourse'] = 'আপনার পাঠ্যক্রমে প্রবেশের জন্য এখানে ক্লিক করুন';
$string['convertingwikitomarkdown'] = 'উইকি থেকে মার্কডাউনে রূপান্তর হচ্ছে';
$string['cookiesenabled'] = 'আপানার ব্রাউজারে কুকিস অবশ্যই সক্রিয় থাকবে';
$string['cookiesenabled_help'] = 'এই সাইটে দুটো কুকিস ব্যবহার হচ্ছেঃ

 অপরিহার্য একটি হল সেশন কুকিস, সাধারনভাবে বলয় হয় মুডলসেশন। আপনার ব্রাইজারে এই কুকিসটি আপনাকে সক্রিয় রাখতে হবে আপনার লগইন পৃষ্ঠা থেকে পৃষ্ঠায় অবিচ্ছন্নতা ও রক্ষনাবেক্ষণ সরবরাহ করার জন্য। যখন আপনি লগ আউট অথবা ব্রাউজার বন্ধ করবেন এই কুকিসটি নষ্ট হবে (আপনার ব্রাউজারে এবং সার্ভারে)।

 অন্য কুকিসটি প্রকৃত পক্ষে সুবিধার জন্য, সাধারণভাবে MOODLEID বলা হয়। এটি শুধুমাত্র ব্রাউজারের অভ্যন্তরের আপনার ব্যবহারকারী নাম মনে রাখে। এটির মানে যখন আপনি এই সাইটে ফিরবেন লগইন পৃষ্ঠার ব্যবহারকারী ফিল্ডটি আপনার জন্য ইতিমধ্যে পূর্ণ হবে। এটি আপনার জন্য নিরাপদ এই কুকিসের জঞ্জাল সরানোর জন্য - শুধুমাত্র আপনাকে প্রতিবার লগইন করার সময় আপনার ব্যবহারকারীর নাম প্রতিবার টাইপ করতে হবে। ';
$string['cookiesnotenabled'] = 'দুঃজনকভাবে, বর্তমানে আপানার ব্রাউজারে কুকিসগুলো সক্রিয় নেই';
$string['copy'] = 'অনুলিপি';
$string['copyasnoun'] = 'অনুলিপি';
$string['copyingcoursefiles'] = 'পাঠ্যক্রম ফাইলসমূহ অনুলিপি হচ্ছে';
$string['copyingsitefiles'] = 'পাঠ্যক্রমে ব্যবহৃত সাইট ফাইলসমূহ অনুলিপি হচ্ছে';
$string['copyinguserfiles'] = 'ব্যবহারকারী ফাইলসমূহ অনুলিপি হচ্ছে';
$string['copyingzipfile'] = 'জিপ ফাইল অনুলিপি হচ্ছে';
$string['copyrightnotice'] = 'স্বত্বাধিকার নোটিশ';
$string['coresystem'] = 'সিস্টেম';
$string['cost'] = 'মূল্য';
$string['costdefault'] = 'পূর্বনির্ধারিত মূল্য';
$string['counteditems'] = '{$a->গণনা করা} {$a->আইটেম}';
$string['country'] = 'দেশ';
$string['course'] = 'পাঠ্যক্রম';
$string['courseadministration'] = 'পাঠ্যক্রম প্রশাসন';
$string['courseapprovedemail'] = 'আপনার আবেদনকৃত পাঠ্যক্রম, {$a->নাম}, অনুমোদন পেয়েছে এবং আপনাকে করা হয়েছে একজন {$a->শিক্ষক}। আপনার নতুন পাঠ্যক্রমে প্রবেশের জন্য, যান  {$a->url}';
$string['courseapprovedemail2'] = 'আপনার আবেদনকৃত পাঠ্যক্রম, {$a->নাম}, অনুমোদন পেয়েছে। আপনার নতুন পাঠ্যক্রমে প্রবেশের জন্য, যান {$a->url}';
$string['courseapprovedfailed'] = 'পাঠ্যক্রম অনুমোদন সংরক্ষণ ব্যর্থ হয়েছে!';
$string['courseapprovedsubject'] = 'আপনার পাঠ্যক্রম অনুমোদিত হয়েছে!';
$string['courseavailable'] = 'এই পাঠ্যক্রম শিক্ষার্থীদের জন্য সহজলভ্য';
$string['courseavailablenot'] = 'এই পাঠ্যক্রম শিক্ষার্থীদের জন্য সহজলভ্য নয়';
$string['coursebackup'] = 'পাঠ্যক্রম ব্যাকআপ';
$string['coursecategories'] = 'পাঠ্যক্রম বিভাগসমূহ';
$string['coursecategory'] = 'পাঠ্যক্রম বিভাগ';
$string['coursecategorydeleted'] = 'মোছা হয়েছে পাঠ্যক্রম বিভাগ {$a}';
$string['coursecategory_help'] = 'এই সেটিংসটি নির্ধারন করে বিভাগ যেখানে পাঠ্যক্রমটি পাঠ্যক্রম লিষ্টে প্রদর্শন করবে।';
$string['coursecompletion'] = 'পাঠ্যক্রম সম্পূর্ণকরণ';
$string['coursecompletions'] = 'পাঠ্যক্রম সম্পূর্ণকরণ';
$string['coursecreators'] = 'পাঠ্যক্রম নির্মাতা';
$string['coursecreatorsdescription'] = 'পাঠ্যক্রম নির্মাতারা নতুন পাঠ্যক্রম নির্মান করতে পারে।';
$string['coursedeleted'] = 'মুছে ফেলা হয়েছে পাঠ্যক্রম {$a}';
$string['coursedisplay'] = 'কোর্স লে আউট';
$string['coursedisplay_multi'] = 'এক পৃষ্ঠায় একটি সেকশন প্রদর্শন';
$string['coursedisplay_single'] = 'এক পৃষ্ঠায় সকল সেকশন প্রদর্শন';
$string['coursefiles'] = 'উত্তরাধিকার পাঠ্যক্রম ফাইলসমূহ';
$string['coursefilesedit'] = 'উত্তরাধিকার পাঠ্যক্রম ফাইলসমূহ সম্পাদনা';
$string['coursefileswarning'] = 'পাঠ্যক্রম ফাইলসমূহ অবলোপ করা হয়েছে ';
$string['coursefileswarning_help'] = 'পাঠ্যক্রম ফাইলসমূহ অবলোপ মুডল ২.০ থেকে, দয়া করে বিকল্প হিসাবে যতটা সম্ভব বাহ্যিক ভান্ডার ব্যবহার করুন।';
$string['courseformatdata'] = 'পাঠ্যক্রম বিন্যাস ডাটা';
$string['courseformats'] = 'পাঠ্যক্রম বিন্যাস';
$string['coursegrades'] = 'পাঠ্যক্রম গ্রেড';
$string['coursehelpcategory'] = 'পাঠ্যক্রম লিষ্টে পাঠ্যক্রমের অবস্থান এবং শিক্ষার্থীর খোঁজার জন্য সহজ করতে পারে।';
$string['coursehelpforce'] = 'পাঠ্যক্রম গ্রুপ মোডে জোর করুন পাঠ্যক্রমের প্রতিটি কার্যপ্রনালীতে।';
$string['coursehelpformat'] = 'পাঠ্যক্রম প্রধান পৃষ্ঠা এই বিন্যাসে প্রদর্শিত হবে।';
$string['coursehelphiddensections'] = 'কিভাবে পাঠ্যক্রমের অভ্যন্তরে লুকায়িত সেশনগুলো শিক্ষার্থীদের দেখানো হবে।';
$string['coursehelpmaximumupload'] = 'সবচেয়ে বড় আয়তনের ফাইল নির্ধারণ করুন যা এই পাঠ্যক্রমে আপলোড করা যায়, সাইট-প্রশস্থ সেটিংস নিয়ন্ত্রিত।';
$string['coursehelpnewsitemsnumber'] = 'সাম্প্রতিক আইটেমগুলোর সংখ্যা পাঠ্যক্রম হোম পেজে দৃশ্যমান, একটি নিউজ বাক্সে ডানপাশের নিচে  <br/>(0 মানে লিউজ বাক্স প্রদর্শিত হয় নাই)।';
$string['coursehelpnumberweeks'] = 'সপ্তাহ/টপিক প্রদর্শিত হচ্ছে পাঠ্যক্রম মেইন পৃষ্ঠায়।';
$string['coursehelpshowgrades'] = 'গ্রেডবুকের প্রদর্শন সক্রিয় করুন। পৃথক কার্যপ্রনালীতে গ্রেডবুকের প্রদর্শন রোধ করতে পারে না।';
$string['coursehidden'] = 'এই পাঠ্যক্রম বর্তমানে শিক্ষার্থীদের জন্য বিদ্যমান নয়';
$string['courseinfo'] = 'পাঠ্যক্রম তথ্য';
$string['courselegacyfiles'] = 'উত্তরাধিকার পাঠ্যক্রম ফাইলসমূহ';
$string['courselegacyfiles_help'] = 'পাঠ্যক্রম ফাইলসমূহের অঞ্চল মুডল ১.৯ এবং পূর্বের পশ্চাৎ উপযুক্ততা প্রদান করে। এই অঞ্চলের সকল ফাইল পাঠ্যক্রমের সকল অংশগ্রহনকারীদের জন্য সর্বদা অভিগম্য (আপনি সেগুলো পছন্দ করেন আর না করেন) এবং কোন পথ নেই জানার যে মুডলের কোথায় ঐ সকল ফাইল ব্যবহৃত হচ্ছে।

 যদি আপনি এই অঞ্চল পাঠ্যক্রম ফাইলসমূহ সংরক্ষন করার কাজে ব্যবহার করেন, আপনি প্রকাশ করতে পারেন আপনাকে সংখ্যার গোপনীয়তা এবং নিরাপত্তা প্রসঙ্গে, ব্যাকআপের অনুপস্থিত ফাইলসমূহ সম্পর্কে ভাল অভিজ্ঞতা, পাঠ্যক্রম আমদানি এবং যেকোন সময়ে বিষয়বস্তু ভাগ ও পুনরায়-ব্যবহার। এজন্য এর সাপেক্ষে বলা যায় যে,  আপনি এই অঞ্চল ব্যবহার করবেন না যতক্ষন না আপনি বাস্তবিকপক্ষে জানছেন যে আপনি কি করছেন।

লিচের লিংকটি এই সম্পর্কে আরো তথ্য প্রদান করে এবং মুডল ২ এর ফাইল গুলোর নিয়ন্ত্রনে কিছু ভাল পথ আপনাকে দেখাবে।';
$string['courselegacyfiles_link'] = 'কোর্সফাইলস২';
$string['coursemessage'] = 'বার্তা পাঠ্যক্রম ব্যবহারকারী';
$string['coursenotaccessible'] = 'এই পাঠ্যক্রম সর্বসাধারণের প্রবেশ অনুমোদন করে না';
$string['courseoverview'] = 'পাঠ্যক্রম সারসংক্ষেপ';
$string['courseoverviewgraph'] = 'পাঠ্যক্রম সারসংক্ষেপ লেখচিত্র';
$string['courseprofiles'] = 'পাঠ্যক্রম বৃত্তান্ত';
$string['coursereasonforrejecting'] = 'আপনার এই অনুরোধ বাতিলের কারনসমূহ ';
$string['coursereasonforrejectingemail'] = 'অনুরোধকারীর নিকট এটি ই-মেইল হবে ';
$string['coursereject'] = 'পাঠ্যক্রম অনুরোধটি বাতিল করুন';
$string['courserejected'] = 'পাঠ্যক্রম বাতিল হয়েছে এবং অনুরোধকারীকে অবিহিত করা হয়েছে।';
$string['courserejectemail'] = 'দুঃখিত, আপনার অনুরোধকৃত পাঠ্যক্রম বাতিল হয়েছে এখানে কারন প্রদান করা হলঃ

{$a}';
$string['courserejectreason'] = 'আপনার এই পাঠ্যক্রম বাতিল কারনসমূহের রুপরেখা<br />(অনুরোধকারীর নিকট এটি ই-মেইল হবে )';
$string['courserejectsubject'] = 'আপনার পাঠ্যক্রম বাতিল করা হয়েছে';
$string['coursereport'] = 'পাঠ্যক্রম রিপোর্ট';
$string['coursereports'] = 'পাঠ্যক্রম রিপোর্ট';
$string['courserequest'] = 'পাঠ্যক্রম অনুরোধ';
$string['courserequestdetails'] = 'আপনার অনুরোধকৃত পাঠ্যক্রমের বিস্তারিত ';
$string['courserequestfailed'] = 'কিছু কারনের জন্য, আপনার পাঠ্যক্রম আবেদন সংরক্ষন হয় নাই ';
$string['courserequestintro'] = 'আপনার জন্য একটি পাঠ্যক্রম তৈরি করা হবে তার আবেদন করতে এই ফরমটি ব্যবহার করুন। <br />অনুমোদিত যত তথ্য দ্বারা সম্ভব চেষ্টা করুন পূর্ণ করার <br /> প্রশাসন আপনার এই পাঠ্যক্রম চাওয়ার কারন বুঝবে';
$string['courserequestreason'] = 'পাঠ্যক্রম চাওয়ার কারনসমূহ';
$string['courserequestsuccess'] = 'আপনার পাঠ্যক্রম অনুরোধটি সফলভাবে সম্পন্ন হয়েছে। কিছু দিনের মধ্যে ফলাফল হিসাবে একটা ই-মেইল প্রত্যাশিত ';
$string['courserequestsupport'] = 'সমর্থক তথ্য প্রশাসনকে সাহায্য করে এই অনুরোধ মূল্যয়ন করার ';
$string['courserestore'] = 'পাঠ্যক্রম পুনরুদ্ধার';
$string['courses'] = 'পাঠ্যক্রমসমূহ';
$string['coursesectionsummaries'] = 'পাঠ্যক্রম সেশন সারসংক্ষেপ';
$string['coursesettings'] = 'পাঠ্যক্রম পূর্বনির্ধারিত সেটিংস';
$string['coursesmovedout'] = 'পাঠ্যক্রমসমূহ অপসারণ হয়েছে {$a} থেকে';
$string['coursespending'] = 'পাঠ্যক্রম মুলতবি অনুমোদন';
$string['coursestart'] = 'পাঠ্যক্রম শুরু';
$string['coursesummary'] = 'পাঠ্যক্রম সারসংক্ষেপ';
$string['coursesummary_help'] = 'পাঠ্যক্রম সারসংক্ষেপ পাঠ্যক্রম লিষ্টে প্রদর্শিত হবে। একটি কোর্স অনুসন্ধান অনুসন্ধান করে পাঠ্যক্রম সারসংক্ষেপ টেক্সট অতিরিক্ত পাঠ্যক্রম নামের সাথে।';
$string['courseupdates'] = 'পাঠ্যক্রম হালনাগাদ';
$string['create'] = 'তৈরি';
$string['createaccount'] = 'আমার নতুন এ্যাকাউন্ট তৈরি করুন ';
$string['createcategory'] = 'বিভাগ তৈরি ';
$string['createfolder'] = 'একটি ফোল্ডার তৈরি করুন {$a} তে';
$string['createuser'] = 'ব্যবহারকারী তৈরী করুন';
$string['createuserandpass'] = 'আপনার ব্যবহারকারী নাম ও পাসওয়ার্ড নির্বাচন করুন';
$string['createziparchive'] = 'ZIP আর্কাইভ তৈরি করুন ';
$string['creatingblocks'] = 'ব্লক তৈরি হচ্ছে';
$string['creatingblocksroles'] = 'ব্লক স্তর ভূমিকা বরাদ্দ ও অগ্রাহ্যসমূহ তৈরি হচ্ছে';
$string['creatingblogsinfo'] = 'ব্লক তথ্য তৈরি হচ্ছে';
$string['creatingcategoriesandquestions'] = 'বিভাগ ও প্রশ্ন সমূহ তৈরি হচ্ছে';
$string['creatingcoursemodules'] = 'কোর্স মডিউল তৈরি হচ্ছে';
$string['creatingcourseroles'] = 'পাঠ্যক্রম স্তর ভূমিকা বরাদ্দ ও অগ্রাহ্যসমূহ তৈরি হচ্ছে';
$string['creatingevents'] = 'ইভেন্ট তৈরি হচ্ছে';
$string['creatinggradebook'] = 'গ্রেডবুক তৈরি হচ্ছে';
$string['creatinggroupings'] = 'গ্রুপিং তৈরি হচ্ছে';
$string['creatinggroupingsgroups'] = 'গ্রুপসমূহকে গ্রুপিং এ যুক্ত করা হচ্ছে';
$string['creatinggroups'] = 'গ্রুপ তৈরি হচ্ছে';
$string['creatinglogentries'] = 'লগ এন্ট্রি তৈরি হচ্ছে';
$string['creatingmessagesinfo'] = 'বার্তা তথ্য তৈরি হচ্ছে';
$string['creatingmodroles'] = 'মডিউল স্তর ভূমিকা বরাদ্দ ও অগ্রাহ্যসমূহ তৈরি হচ্ছে';
$string['creatingnewcourse'] = 'নতুন পাঠ্যক্রম তৈরি হচ্ছে';
$string['creatingrolesdefinitions'] = 'ভূমিকাসমূহের সংজ্ঞা তৈরি হচ্ছে';
$string['creatingscales'] = 'স্কেল তৈরি হচ্ছে';
$string['creatingsections'] = 'সেশন তৈরি হচ্ছে';
$string['creatingtemporarystructures'] = 'সাময়িক সংগঠন তৈরি হচ্ছে';
$string['creatinguserroles'] = 'ব্যবহারকারীর স্তর ভূমিকা বরাদ্দ ও অগ্রাহ্যসমূহ তৈরি হচ্ছে';
$string['creatingusers'] = 'ব্যবহারকারী তৈরি হচ্ছে';
$string['creatingxmlfile'] = 'XML ফাইল তৈরি হচ্ছে';
$string['currency'] = 'মুদ্রা';
$string['currentcourse'] = 'চলমান কোর্স';
$string['currentcourseadding'] = 'সম্প্রতি পাঠ্যক্রম, এতে ডাটা যুক্ত হচ্ছে';
$string['currentcoursedeleting'] = 'সম্প্রতি পাঠ্যক্রম, প্রথমে এটি অপসারন হচ্ছে';
$string['currentlanguage'] = 'সম্প্রতি ভাষা';
$string['currentlocaltime'] = 'আপনার বর্তমান স্থানীয় সময়';
$string['currentlyselectedusers'] = 'বর্তমানের নির্বাচিত ব্যবহারকারী';
$string['currentpicture'] = 'বর্তমান ছবি';
$string['currentrelease'] = 'বর্তমান মুক্তিকৃত তথ্য';
$string['currentversion'] = 'বর্তমান সংস্করণ';
$string['databasechecking'] = 'মুডল ডাটাবেস আপগ্রেড হচ্ছে সংস্করণ {$a->oldversion} থেকে {$a->newversion}...';
$string['databaseperformance'] = 'ডাটাবেস কার্যকারিতা';
$string['databasesetup'] = 'ডাটাবেস যুক্ত হচ্ছে';
$string['databasesuccess'] = 'ডাটাবেস সফলভাবে আপগ্রেড হয়েছে';
$string['databaseupgradebackups'] = 'ব্যাকআপ সংস্করণ হল এখন {$a}';
$string['databaseupgradeblocks'] = 'ব্লক সংস্করণ হল এখন {$a}';
$string['databaseupgradegroups'] = 'গ্রুপ সংস্করণ হল এখন {$a}';
$string['databaseupgradelocal'] = 'স্থানীয় ডাটাবেস কাস্টমাইজেশন সংস্করণ হল এখন {$a}';
$string['databaseupgrades'] = 'ডাটাবেস আপগ্রেড হচ্ছে';
$string['date'] = 'তারিখ';
$string['datechanged'] = 'তারিখ পরিবর্তন হয়েছে';
$string['datemostrecentfirst'] = 'তারিখ-সবচেয়ে সাম্প্রতিক প্রথমে';
$string['datemostrecentlast'] = 'তারিখ-সবচেয়ে সাম্প্রতিক শেষে';
$string['day'] = 'দিন';
$string['days'] = 'দিনগুলো';
$string['decodinginternallinks'] = 'অভ্যন্তরীণ লিংক উদ্ধার হচ্ছে';
$string['default'] = 'পূর্বনির্ধারিত';
$string['defaultcoursestudent'] = 'শিক্ষার্থী';
$string['defaultcoursestudentdescription'] = 'সাধারনত পাঠ্যক্রমের সাথে শিক্ষার্থীদের কিছু বিশেষ সুবিধা আছে ';
$string['defaultcoursestudents'] = 'শিক্ষার্থীরা';
$string['defaultcoursesummary'] = 'এখানে সংক্ষিপ্ত ও আকর্ষনীয় একটা অনুচ্ছেদ লিখুন যা পাঠ্যক্রম বিষয়ে ধারনা দেয়';
$string['defaultcourseteacher'] = 'শিক্ষক';
$string['defaultcourseteacherdescription'] = 'শিক্ষকবৃন্দ পাঠ্যক্রমে যা কিছু খুশি করতে পারে, যেমন কার্যকলাপ এবং শিক্ষার্থীদের গ্রেডিং পরিবর্তন';
$string['defaultcourseteachers'] = 'শিক্ষকবৃন্দ';
$string['delete'] = 'অপসারণ';
$string['deleteablock'] = 'ব্লক অপসারণ করুন';
$string['deleteall'] = 'সবকিছু অপসারণ করুন';
$string['deleteallcannotundo'] = 'সবকিছু অপসারণ করুন -ফেরানো যাবে না';
$string['deleteallcomments'] = 'সকল মন্তব্য মুছে ফেলুন';
$string['deleteallratings'] = 'সকল মূল্যায়ন মুছে ফেলুন';
$string['deletecategory'] = ' বিভাগ:{$a} মুছে ফেলুন ';
$string['deletecategorycheck'] = 'আপনি কি সম্পূর্ণভাবে নিশ্চিত আপনি পূর্ণভাবে মুছে ফেলতে চান এই বিভাগ <b>\'{$a}\'</b>?<br /> এটি  সকল পাঠ্যক্রম উর্ধ্বস্থ বিভাগে একটি অথবা বিবিধে সরাবে ';
$string['deletecategorycheck2'] = 'যদি আপনি এই বিভাগটি মুছে ফেলেন, আপনাকে  এর ধারনকৃত পাঠ্যক্রম এবং উপবিভাগের সাথে কি করতে হবে তা নির্বাচনের প্রয়োজন হবে';
$string['deletecategoryempty'] = 'এই বিভাগটি খালি';
$string['deletecheck'] = 'মুছবেন {$a} ?';
$string['deletecheckfiles'] = 'আপনি কি সম্পূর্ণভাবে নিশ্চিত আপনি পূর্ণভাবে মুছে ফেলতে চান এই ফাইলগুলো';
$string['deletecheckfull'] = 'আপনি কি সম্পূর্ণভাবে নিশ্চিত আপনি পূর্ণভাবে মুছে ফেলতে চান {$a} ?';
$string['deletecheckwarning'] = 'আপনি ফাইলগুলো মুছে ফেলতে যাচ্ছেন';
$string['deletecomment'] = 'এই মন্তব্য মুছে ফেলুন';
$string['deletecompletely'] = 'সম্পূর্ণভাবপ মুছুন';
$string['deletecourse'] = 'পাঠ্যক্রমটি মুছুন';
$string['deletecoursecheck'] = 'আপনি কি সম্পূর্ণভাবে নিশ্চিত আপনি পূর্ণভাবে মুছে ফেলতে চান এই পাঠ্যক্রম এবং এর ধারনকৃত সকল ডাটা?';
$string['deleted'] = 'মুছে ফেলা হয়েছে';
$string['deletedactivity'] = '{$a} মুছে ফেলা হয়েছে';
$string['deletedcourse'] = '{$a} সম্পূর্ণরূপে মুছে ফেলা হয়েছে';
$string['deletednot'] = '{$a} অপসারণ করতে পারে নাই !';
$string['deletelogs'] = 'লগগুলো মুছুন';
$string['deleteselected'] = 'নির্বাচিত মুছুন';
$string['deleteselectedkey'] = 'নির্বাচিত কী মুছুন';
$string['deletingcourse'] = ' {$a} মুছে ফেলা হচ্ছে';
$string['deletingexistingcoursedata'] = 'বিদ্যমান পাঠ্যক্রম ডাটা মুছে ফেলা হচ্ছে';
$string['deletingolddata'] = 'পুরাতন ডাটা মুছে ফেলা হচ্ছে';
$string['department'] = 'বিভাগ';
$string['desc'] = 'নিম্নক্রম';
$string['description'] = 'বর্ণনা';
$string['deselectall'] = 'সব অনির্বাচিত করুন';
$string['detailedless'] = 'স্বল্প বর্ণিত হয়েছে';
$string['detailedmore'] = 'বিশদ বর্ণিত হয়েছে';
$string['directory'] = 'ডিরেক্টরী';
$string['disable'] = 'নিষ্ক্রিয়';
$string['disabledcomments'] = 'মন্তব্যগুলো নিষ্ক্রিয় রয়েছে';
$string['displayingfirst'] = 'শুধুমাত্র প্রথম {$a->count} {$a->things} গুলো প্রদর্শিত হয়েছে  ';
$string['displayingrecords'] = '{$a} রেকর্ডগুলো প্রদর্শিত হচ্ছে';
$string['displayingusers'] = 'ব্যবহারকারী {$a->start} to {$a->end} প্রদর্শিত হচ্ছে';
$string['displayonpage'] = 'পৃষ্ঠার উপরে প্রদর্শন';
$string['documentation'] = 'মুডল ফাইলবদ্ধকরণ';
$string['down'] = 'নিচের দিক';
$string['download'] = 'ডাউনলোড করুন';
$string['downloadall'] = 'সব ডাউনলোড করুন';
$string['downloadexcel'] = 'এক্সেল বিন্যাসে ডাউনলোড করুন';
$string['downloadfile'] = 'ফাইল ডাউনলোড করুন';
$string['downloadods'] = 'ODS বিন্যাসে ডাউনলোড করুন';
$string['downloadtext'] = 'টেক্সট বিন্যাসে ডাউনলোড করুন';
$string['doyouagree'] = 'শর্তগুলো আপনি কি পড়েছেন এবং সেগুলো বুঝেছেন? ';
$string['duplicate'] = 'প্রতিলিপি';
$string['duplicatinga'] = 'প্রতিলিপি হচ্ছে: {$a}';
$string['edhelpaspellpath'] = 'সম্পাদকে বানান পরীক্ষক ব্যবহার করতে, আপনার আবশ্যই থাকতে হবে <strong>aspell 0.50</strong> অথবা পরবর্তীতে সার্ভারে ইনস্টল করা হয়েছে, এবং  আপনাকে সুনির্দিষ্টভাবে পথ উল্লেখ করা উচিৎ  aspell বাইনারিতে সঠিক প্রবেশাধিকারের জন্য। ইউনিক্স/লিনাক্স সিস্টেমে, এই পথটি সাধারনত <strong>/usr/bin/aspell</strong>, অথবা অন্য কিছু। ';
$string['edhelpbgcolor'] = 'সংজ্ঞার্থ নির্ণয় করুন সম্পাদনা এলাকার পটভূমির রঙ।<br /> বৈধ মানগুলো হলো, উদাহরণসরূপ: #FFFFFF হল সাদা রং';
$string['edhelpcleanword'] = 'এই সেটিংস সক্রিয় অথবা নিক্রিয় করে শব্দ সুনির্দিষ্ট বিন্যাস পরিশ্রুত করে';
$string['edhelpenablespelling'] = 'সক্রিয় অথবা নিষ্ক্রিয় বানান পরীক্ষা করা হচ্ছে। যখন সক্রিয় হয়েছে, <strong>aspell</strong> অবশ্যই সার্ভারে ইনস্টল করা হয়েছে। দ্বিতীয় মানটি হল <strong>পূর্বনির্ধারিত অভিধান</strong>। এই মানটি ব্যবহৃত হবে যদি aspell এর অভিধান না থাকে ব্যবহারকারীদের নিজস্ব ভাষায়';
$string['edhelpfontfamily'] = 'ফন্ট-ফ্যমিলি বৈশিষ্ট্য হল ফন্ট-ফ্যমিলি নামের তালিকা এবং /অথবা সামগ্রিক ফ্যমিলি নাম।  ফ্যমিলি নাম অবশ্যই বিভক্ত হবে কমা দ্বারা।';
$string['edhelpfontlist'] = 'সম্পাদকের নিম্ন প্রসারন মেনু দ্বারা ফন্ট নির্বাচন করুন';
$string['edhelpfontsize'] = 'পূর্বনির্ধারিত ফন্টের আকার বিন্যাশ করে ফন্টের আকার।<br /> বৈধ মানগুলো হল যেমন: মাঝারি, বড়, ছোট, larger, 10pt, 11px';
$string['edit'] = 'সম্পাদন করুন';
$string['edita'] = '{$a} সম্পাদন করুন';
$string['editcategorysettings'] = 'বিভাগ সেটিংসমূহ সম্পাদন করুন';
$string['editcategorythis'] = 'এই বিভাগ সম্পাদন করুন';
$string['editcoursesettings'] = 'পাঠ্যক্রম সেটিংসমূহ সম্পাদন করুন';
$string['editfiles'] = 'ফাইলসমূহ সম্পাদন করুন';
$string['editgroupprofile'] = 'গ্রুপ বৃত্তান্ত সম্পাদন করুন';
$string['editinga'] = '{$a} সম্পাদিত হচ্ছে ';
$string['editingteachershort'] = 'সম্পাদক';
$string['editlock'] = 'এই মান সম্পাদন যোগ্য নয়!';
$string['editmyprofile'] = 'বৃত্তান্ত সম্পাদন করুন';
$string['editorbgcolor'] = 'পটভূমি-রং';
$string['editorcleanonpaste'] = 'প্রতিলেপন করে Word HTML পরিষ্কার করুন';
$string['editorcommonsettings'] = 'সাধারণ সেটিংস';
$string['editordefaultfont'] = 'পূর্বনির্ধারিত ফন্ট';
$string['editorenablespelling'] = 'বানান পরীক্ষক সক্রিয় করুন';
$string['editorfontlist'] = 'ফন্ট লিষ্ট';
$string['editorfontsize'] = 'পূর্বনির্ধারিত ফন্টের আকার';
$string['editorresettodefaults'] = 'পূর্বনির্ধারিত মানগুলো পুন:বিন্যাস করুন';
$string['editorsettings'] = 'সম্পাদক সেটিংসমূহ';
$string['editorshortcutkeys'] = 'শর্টকার্ট কী সম্পাদক';
$string['editsettings'] = 'সেটিংসমূহ সম্পাদন করুন';
$string['editsummary'] = 'সারসংক্ষেপ সম্পাদন করুন';
$string['editthisactivity'] = 'এই কার্য সম্পাদন করুন';
$string['editthiscategory'] = 'এই বিভাগ সম্পাদন করুন';
$string['edituser'] = 'ব্যবহারকারী এ্যকাউন্ট সম্পাদন করুন';
$string['email'] = 'ই-মেইল ঠিকানা';
$string['emailactive'] = 'ইমেইল সক্রিয় হয়েছে';
$string['emailagain'] = 'ইমেইল (পুনরায়)';
$string['emailcharset'] = 'ইমেইল ক্যারেক্টারসেট';
$string['emailconfirm'] = 'আপনার একাউন্ট নিশ্চিত করুন';
$string['emailconfirmation'] = 'সালাম {$a->firstname},

 একটি নতুন একাউন্ট অনুরোধ হয়েছে \'{$a->sitename}\'
 আপনার ইমেইল ঠিকানা দ্বারা।

আপনার নতুন একাউন্টটি নিশ্চিত করতে দয়া করে এই ওয়েব ঠিকানায় যান:

{$a->link}

 অধিকাংশ মেইল প্রোগ্রামে, এটি নীল লিঙ্কে প্রদর্শিত হয়
 যেখানে আপনি ক্লিক করে সচল করতে পারেন। যদি এটি কাজ না করে
তাহলে আপনার ওয়েব ব্রাউজার উইন্ডোর শীর্ষে ঠিকানা লাইনে  ঠিকানাটি অনুলিপি ও প্রতিলিপি করুন।

 যদি আপনার সাহায্যের প্রয়োজন হয়, দয়া করে যোগাযোগ করুন সাইট প্রশাসকে,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}:একাউন্ট স্বীকৃত';
$string['emailconfirmsent'] = '<p> একটি ইমেইল পাঠানো হয়েছে আপনার ঠিকানায়  <b>{$a}</b></p>
   <p> এটি আপনার নিবন্ধন সম্পন্ন করতে কিছু সহজ নির্দেশনা আছে। </p>
   <p> যদি চালিয়ে যাবার জন্য কঠিন লাগে, আপনার সাইট প্রশাসকে যোগাযোগ করুন।</p>';
$string['emaildigest'] = 'ই-মেইল সারসঙ্কলন সম্বলিত বইয়ের ধরন';
$string['emaildigestcomplete'] = 'সম্পন্ন করা (পূর্ণ ডাক সম্বলিত প্রাত্যাহিক ইমেইল  )';
$string['emaildigestoff'] = 'কোন সারসংক্ষেপ নেই ( এককইমেইল প্রতি প্রকাশিত ফোরামে )';
$string['emaildigestsubjects'] = 'বিষয়সমূহ (প্রাত্যাহিক ইমেইল শুধুমাত্র বিষয়সমূহ দ্বারা)';
$string['emaildisable'] = 'এই ইমেইল ঠিকানা নিস্ক্রিয় হয়েছে';
$string['emaildisableclick'] = 'এখানে ক্লিক করুন সকল ইমেইল এই ঠিকানায় প্রেরণ হওয়া থেকে নিস্ক্রিয় করতে';
$string['emaildisplay'] = 'ইমেইল প্রদর্শন';
$string['emaildisplaycourse'] = 'অনুমোদন করুন শুধুমাত্র অন্যান্য পাঠ্যক্রম সদস্যকে আমার ইমেইল ঠিকানা দেখার জন্য';
$string['emaildisplayno'] = ' আমার ইমেইল ঠিকানা আড়াল করুন সবার থেকে';
$string['emaildisplayyes'] = ' আমার ইমেইল ঠিকানা দেখান দিন সবাইকে';
$string['emailenable'] = 'এই ইমেইল ঠিকানাটি সক্রিয়';
$string['emailenableclick'] = 'এখানে ক্লিক করুন সকল ইমেইল এই ঠিকানায় প্রেরণ হওয়া সক্রিয় করতে';
$string['emailexists'] = 'এই ইমেইল ঠিকানা ইতোমধ্যে নিবন্ধিত';
$string['emailformat'] = 'ইমেইল বিন্যাস';
$string['emailmustbereal'] = 'নোট: আপনার ইমেইল ঠিকানা অবশ্যই বাস্তবিক হবে';
$string['emailnotallowed'] = 'এই ডেমেইনগুলোতে ইমেইল ঠকানাগুলোর অনুমোদন নেই ({$a})';
$string['emailnotfound'] = 'ইমেইল ঠিকানাটি ডাটাবেসে পাওয়া যায় নাই';
$string['emailonlyallowed'] = 'এই ইমেইল তাদের একটি নয় যাদের অনুমোদন আছে ({$a})';
$string['emailpasswordchangeinfo'] = 'সালাম {$a->firstname},

 কোন একজন ( হয়তো আপনি) অনুরোধ করেছেন একটি নতুন পাসওয়ার্ড আপনার জন্য
একাউন্ট সচল \'{$a->sitename}\'।

 আপনার পাসওয়ার্ড পরিবর্তন করার জন্য দয়া করে নিম্নোক্ত ওয়েব ঠিকানায় যান:

{$a->link}

 অধিকাংশ মেইল প্রোগ্রামে, এটি নীল লিঙ্কে প্রদর্শিত হয়
 যেখানে আপনি ক্লিক করে সচল করতে পারেন। যদি এটি কাজ না করে
তাহলে আপনার ওয়েব ব্রাউজার উইন্ডোর শীর্ষে ঠিকানা লাইনে  ঠিকানাটি অনুলিপি ও প্রতিলিপি করুন।

 যদি আপনার সাহায্যের প্রয়োজন হয়, দয়া করে যোগাযোগ করুন সাইট প্রশাসকে,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'সালাম {$a->firstname},

 কোন একজন ( হয়তো আপনি) অনুরোধ করেছেন একটি নতুন পাসওয়ার্ড আপনার জন্য
একাউন্ট সচল \'{$a->sitename}\'।

 দু:খজনকভাবে এই সাইটে চলমান আপনার একাউন্ট নিস্ক্রিয় করা হয়েছে এবং যা পুনর্বিন্যাস করতে পারবে না।
দয়া করে যোগাযোগ করুন সাইট প্রশাসকে,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'সালাম {$a->firstname},

 কোন একজন ( হয়তো আপনি) অনুরোধ করেছেন একটি নতুন পাসওয়ার্ড আপনার জন্য
একাউন্ট সচল \'{$a->sitename}\'।

 দু:খজনকভাবে এই সাইটে পাসওয়ার্ড পুনর্বিন্যাস করতে পারবে না।
দয়া করে যোগাযোগ করুন সাইট প্রশাসকে,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: পাসওয়ার্ড তথ্য পরিবর্তন করুন';
$string['emailpasswordconfirmation'] = 'সালাম {$a->firstname},

 কোন একজন ( হয়তো আপনি) অনুরোধ করেছেন একটি নতুন পাসওয়ার্ড আপনার জন্য
একাউন্ট সচল \'{$a->sitename}\'।

 এটি নিশ্চিত করার জন্য এবং নতুন পাসওয়ার্ডটি আপনাকে মেইলের মাধ্যমে প্রেরিত হয়েছে।
দয়া করে নিম্নোক্ত ওয়েব ঠিকানায় যান:

{$a->link}

 অধিকাংশ মেইল প্রোগ্রামে, এটি নীল লিঙ্কে প্রদর্শিত হয়
 যেখানে আপনি ক্লিক করে সচল করতে পারেন। যদি এটি কাজ না করে
তাহলে আপনার ওয়েব ব্রাউজার উইন্ডোর শীর্ষে ঠিকানা লাইনে  ঠিকানাটি অনুলিপি ও প্রতিলিপি করুন।

 যদি আপনার সাহায্যের প্রয়োজন হয়, দয়া করে যোগাযোগ করুন সাইট প্রশাসকে,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: পাসওয়ার্ড তথ্য পরিবর্তন করুন';
$string['emailpasswordconfirmmaybesent'] = '<p> যদি আপনি সঠিক ব্যবহারকারী নাম অথবা ইমেইল ঠিকানা প্রদান করেন তাহলে একটি ইমেইল পাঠানো হয়েছে আপনাকে</p>
   <p> এটি আপনার নিবন্ধন সম্পন্ন করতে কিছু সহজ নির্দেশনা আছে। </p>
   <p> যদি চালিয়ে যাবার জন্য কঠিন লাগে, আপনার সাইট প্রশাসকে যোগাযোগ করুন।</p>';
$string['emailpasswordconfirmsent'] = '<p> একটি ইমেইল পাঠানো হয়েছে আপনার ঠিকানায়  <b>{$a}</b>.
<br /> এই পাসওয়ার্ড পরিবর্তন নিশ্চিত ও সম্পন্ন করতে এটিতে সহজ নির্দেশনা আছে।
যদি চালিয়ে যাবার জন্য কঠিন লাগে, আপনার সাইট প্রশাসকে যোগাযোগ করুন।</p>';
$string['emailpasswordsent'] = 'পাসওয়ার্ড পরিবর্তন নিশ্চিত করার জন্য আপনাকে ধন্যবাদ <p> আপনার নতুন পাসওয়ার্ড সম্বলিত একটি ইমেইল পাঠানো হয়েছে আপনার ঠিকানায় <br /><b>{$a->email}</b>.<br />
 নতুন পাসওয়ার্ডটি স্বয়ংক্রিভাবে তৈরি হয়েছে - আপনার মনে হয়
<a href="{$a->link}">আপনার পাসওয়ার্ড পরিবর্তন করুন</a> সহজ মনে রাখার চেয়ে।';
$string['enable'] = 'সক্রিয়';
$string['encryptedcode'] = 'এনক্রিপ্টকৃত কোড';
$string['english'] = 'ইংরেজি ';
$string['entercourse'] = 'পাঠ্যক্রমে প্রবেশের জন্য ক্লিক করুন';
$string['enteremail'] = 'আপনার ইমেইল ঠিকানা দিন';
$string['enteremailaddress'] = 'আপনার ইমেইল ঠিকানায় প্রবেশ করুন আপনার
  পাসওয়ার্ড পুনঃনির্ধারণ করার জন্য এবং নতুন পাসওয়ার্ডটি আপনাকে ইমেইলের মাধ্যমে পাঠানে হল।';
$string['enterusername'] = 'আপনার ব্যবহারকারীনাম দিন';
$string['entries'] = 'প্রবেশ';
$string['error'] = 'ত্রুটি ';
$string['errorcreatingactivity'] = 'সক্রিয়তা \'{$a}\'এর একটি ঘটনা তৈরি করতে অক্ষম';
$string['errorfiletoobig'] = 'ফাইল {$a} বাইটের সীমার চেয়ে বৃহত্তর ছিল';
$string['errornouploadrepo'] = 'এই সাইটটির জন্য কোনও আপলোড ভান্ডার সক্রিয় নাই';
$string['errorwhenconfirming'] = 'আপনাকে এখনও নিশ্চিত করা হয় নাই কারন একটি ত্রুটি হয়েছে। যদি আপনি এখঅনে ইমেইলের লিঙ্কে ক্লিক করেন, নিশ্চিত করুন যে আপনার ইমেইল লাইন ভাঙ্গা অথবা মোড়ানো হয়নি। আপনি কোটে এবং প্রতিলিপি করে লিঙ্কটি সঠিকভাবে পুন:নির্মান করতে পারেন ';
$string['everybody'] = 'প্রত্যেকে';
$string['executeat'] = 'কার্যকর হবে';
$string['existing'] = 'বিদ্যমান';
$string['existingadmins'] = 'বিদ্যমান প্রশাসক';
$string['existingcourse'] = 'বিদ্যমান পাঠ্যক্রম';
$string['existingcourseadding'] = 'বিদ্যমান পাঠ্যক্রম, এতে ডাটা যোগ করা হচ্ছে';
$string['existingcoursedeleting'] = 'বিদ্যমান পাঠ্যক্রম, এটাকে প্রথমে মুছে ফেলা হচ্ছে';
$string['existingcreators'] = 'বিদ্যমান পাঠ্যক্রম নির্মাতা';
$string['existingstudents'] = 'তালিকাভূক্ত শিক্ষার্থী';
$string['existingteachers'] = 'বিদ্যমান শিক্ষক';
$string['expandall'] = 'সকল প্রসারণ করুন';
$string['explanation'] = 'ব্যাখ্যা';
$string['extendenrol'] = 'বর্ধিত তালিকাভূক্তি ( স্বতন্ত্র)';
$string['extendperiod'] = 'বর্ধিত মেয়াদ';
$string['failedloginattempts'] = '{$a->attempts} লগইন ব্যর্থ হয়েছে আপনার শেষ লগইন থেকে';
$string['failedloginattemptsall'] = '{$a->attempts} লগইন ব্যর্থ হয়েছে  {$a->accounts} এ্যকাউন্টসমূহ';
$string['feedback'] = 'মন্তব্য';
$string['file'] = 'ফাইল';
$string['fileexists'] = 'সেখানে ইতোমধ্যে একটি ফাইল {$a} নামে রয়েছে';
$string['filemissing'] = '{$a} অনুপস্থিত';
$string['files'] = 'ফাইলসমূহ';
$string['filesfolders'] = 'ফাইল/ফোল্ডার';
$string['filetoolarge'] = 'আপলোডের জন্য অনেক বড়';
$string['fileuploadwithcontent'] = 'ফাইলের ভিতরের উপাদান মান আপলোড কর অন্তর্ভুক্ত করে না';
$string['filloutallfields'] = 'দয়া করে এই ফর্মের সকল ফিন্ড ভরাট করুন';
$string['filter'] = 'ফিল্টার';
$string['findmorecourses'] = 'খুঁজুন আরও পাঠ্যক্রমসমূহ...';
$string['firstaccess'] = 'প্রথম প্রবেশাধিকার ';
$string['firstname'] = 'নামের প্রথম অংশ';
$string['firsttime'] = 'এখানে কি আপনার প্রথম বার?';
$string['folder'] = 'ফোল্ডার';
$string['folderclosed'] = 'ফোল্ডার বন্ধ হয়েছে';
$string['folderopened'] = 'ফোল্ডার খোলা হয়েছে';
$string['followingoptional'] = 'নিম্নোক্ত আইটেমগুলো ঐচ্ছিক';
$string['followingrequired'] = 'নিম্নোক্ত আইটেমগুলো আবশ্যকীয় ';
$string['force'] = 'জোর করে';
$string['forcelanguage'] = 'ফোর্স ভাষা';
$string['forceno'] = 'জোর করবেন না';
$string['forcepasswordchange'] = 'জোর পূর্বক পাসওয়ার্ড পরিবর্তন';
$string['forcepasswordchangecheckfull'] = 'আপনি কি সম্পূর্নভাবে জোর পূর্বক একটি পাসওয়ার্ড পরিবর্তন করতে চান {$a} তে  ?';
$string['forcepasswordchange_help'] = 'যদি এই চেকবক্স চিহ্নিত থাকে, ব্যবহারকারী অনুপ্রেরিত হবে তাদের পরবর্তী লগইনে পাসওয়ার্ড পরিবর্তনের জন্য';
$string['forcepasswordchangenot'] = 'জোর পূর্বক একটি পাসওয়ার্ড {$a} তে পরিবর্তন পারবে না';
$string['forcepasswordchangenotice'] = 'আপনার এগিয়ে যাবার জন্য পাসওয়ার্ড পরিবর্তন অাবশ্যিক';
$string['forcetheme'] = 'ফোর্স থীম';
$string['forgotaccount'] = 'পাসওয়ার্ড হারিয়েছেন?';
$string['forgotten'] = 'আপানার ব্যবহারকারী নাম অথবা পাসওয়ার্ড ভুলে গেছেন?';
$string['forgottenduplicate'] = 'ইমেইল ঠিকানাটি বন্টন হয়েছে বিভিন্ন একাউন্টে, দয়া করে বিকল্প ব্যবহারকারী নাম দিন';
$string['forgotteninvalidurl'] = 'অকার্যকর পাসওয়ার্ড পুনঃনির্ধারণ করুন URL';
$string['format'] = 'বিন্যাস';
$string['format_help'] = 'পাঠ্যক্রম বিন্যাসটি নির্ধারন করে পাঠ্যক্রম পৃষ্ঠার বহির্বিন্যাস।

* SCORM বিন্যাস - প্রদর্শনের জন্য প্রথম নির্বাচিত পাঠ্যক্রম পৃষ্ঠার একটি SCORM প্যাকেজ (একটি বিকল্প ব্যবহারের SCORM/AICC মডিউল )
*সামাজিক রীতি - একটি ফোরাম প্রদর্শিত হয় পাঠ্যক্রম পৃষ্ঠায়
* আলোচ্য বিন্যাস- পাঠ্যক্রম পৃষ্ঠাটি বিষয় সেশনে সাজানো থাকে
* সাপ্তাহিক বিন্যাস- পাঠ্যক্রম পৃষ্ঠাটি সাপ্তাহিক সেশনে সাজানো থাকে,সাথে পাঠ্যক্রম শুরুর তারিখ শুরু হয় প্রথম সপ্তাহে';
$string['formathtml'] = 'HTML ফরম্যাট';
$string['formatmarkdown'] = 'চিহ্নিত বিন্যাস';
$string['formatplain'] = 'সরল টেক্সট বিন্যাস';
$string['formattext'] = 'মুডল স্বয়ংক্রিয় বিন্যাস';
$string['formattexttype'] = 'বিন্যাস করা হচ্ছে';
$string['framesetinfo'] = 'এই ফ্রেমসেট ফাইল ধারণ করে:';
$string['from'] = 'থেকে';
$string['frontpagecategorycombo'] = 'কমবো তালিকা';
$string['frontpagecategorynames'] = 'বিভাগসমূহের তালিকা';
$string['frontpagecourselist'] = 'পাঠ্যক্রমসমূহের তালিকা';
$string['frontpagedescription'] = 'সম্নুখ পৃষ্ঠার বর্ণনা';
$string['frontpagedescriptionhelp'] = 'সাইটের এই বর্ণনা প্রদর্শিত হবে সম্নুখ পৃষ্ঠায়';
$string['frontpageformat'] = 'সম্নুখ পৃষ্ঠার বিন্যাস';
$string['frontpageformatloggedin'] = 'লগইনের সময় সম্নুখ পৃষ্ঠার বিন্যাস ';
$string['frontpagenews'] = 'নিউজ আইটেম';
$string['frontpagesettings'] = 'সন্মুখ পৃষ্ঠার সেটিংস';
$string['fulllistofcourses'] = 'সকল পাঠ্যক্রমসমূহ';
$string['fullname'] = 'পূর্ণ নাম';
$string['fullnamecourse'] = 'পাঠ্যক্রম পূর্ণ নাম ';
$string['fullnamecourse_help'] = 'পাঠ্যক্রমের পূর্ণ নামটি প্রদর্শিত হবে পাঠ্যক্রমের প্রতি পৃষ্ঠা এবং পাঠ্যক্রমের লিষ্টের শীর্ষে ';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'ব্যবহারকারীর পূর্ণ নাম';
$string['fullprofile'] = 'সম্পূর্ণ বৃত্তান্ত';
$string['fullsitename'] = 'সম্পূর্ণ সাইট নাম';
$string['functiondisabled'] = 'সেই ফাংশনালিটি বর্তমানে নিস্ক্রিয় রয়েছে';
$string['general'] = 'সাধারণ';
$string['geolocation'] = 'অক্ষাংশ-দ্রাঘিমাংশ';
$string['gettheselogs'] = 'এই লগগুলো পাওয়া';
$string['go'] = 'যান';
$string['gpl'] = 'কপিরাইট (C) 1999 onwards  Martin Dougiamas  (http://moodle.com)

 এই প্রোগ্রাম মুক্ত সফটওয়ার; আপনি এটি বিতরন এবং/অথবা পরিবর্তন করতে পারেন
 এর শর্তাবলী GNU সাধারণ পাবলিক লাইসেন্সের আওতায় মুক্ত সফটওয়ার ফাউন্ডেশন কর্তৃক মুদ্রিত; লাইসেন্সের সংস্করণ ২, অথবা
(আপনার অপশন) যেকোন পরবর্তী সংস্করণ।

 এই প্রোগ্রাম এ আশায় বিতরন হয়েছে যে এটি সাহায্য করতে থাকবে,
 কিন্তু কোন ওয়ারেন্টি ছাড়াই; এমনকি কোন নির্দিষ্ট লক্ষ্যের
 মার্সেন্টাবিলিটি অথবা ফিটনেসের ইঙ্গিতপূর্ণ ওয়ারেন্টি ব্যতীত।

সম্পূর্ন বিস্তারিত তথ্যের জন্য মুডল লাইসেন্সের তথ্য পৃষ্ঠা দেখুন:
http://docs.moodle.org/en/License';
$string['gpl3'] = 'কপিরাইট (C) 1999 onwards  Martin Dougiamas  (http://moodle.com)

 এই প্রোগ্রাম মুক্ত সফটওয়ার; আপনি এটি বিতরন এবং/অথবা পরিবর্তন করতে পারেন
 এর শর্তাবলী GNU সাধারণ পাবলিক লাইসেন্সের আওতায় মুক্ত সফটওয়ার ফাউন্ডেশন কর্তৃক মুদ্রিত; লাইসেন্সের সংস্করণ ৩, অথবা
(আপনার অপশন) যেকোন পরবর্তী সংস্করণ।

 এই প্রোগ্রাম এ আশায় বিতরন হয়েছে যে এটি সাহায্য করতে থাকবে,
 কিন্তু কোন ওয়ারেন্টি ছাড়াই; এমনকি কোন নির্দিষ্ট লক্ষ্যের
 মার্সেন্টাবিলিটি অথবা ফিটনেসের ইঙ্গিতপূর্ণ ওয়ারেন্টি ব্যতীত।

সম্পূর্ন বিস্তারিত তথ্যের জন্য মুডল লাইসেন্সের তথ্য পৃষ্ঠা দেখুন:
http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL লাইসেন্স';
$string['grade'] = 'গ্রেড';
$string['grades'] = 'গ্রেড';
$string['gravatarenabled'] = 'href= " http://www.gravatar.com " > Gravatar</a> এই সাইটটি কির জন্য সক্রিয় করা হয়েছে। যদি আপনি Gravatar থেকে আপনার জন্য একটি বৃত্তান্ত ছবি লোড করতে একটি বৃত্তান্ত ছবি Moodle আপলোড করেন না পেতে চেষ্টা করেন।';
$string['group'] = 'গ্রুপ';
$string['groupadd'] = 'নতুন গ্রুপ সংযুক্ত করুন';
$string['groupaddusers'] = 'নির্বাচিত গ্রুপে সংযুক্ত করুন';
$string['groupextendenrol'] = 'তালিকাভূক্তি বর্ধিত করুন (সাধারণ)';
$string['groupfor'] = 'গ্রুপের জন্য';
$string['groupinfo'] = 'নির্বাচিত গ্রুপ সম্পর্কিত তথ্য';
$string['groupinfoedit'] = 'গ্রুপ সেটিংসমূহ সম্পাদন করুন';
$string['groupinfomembers'] = 'নির্বাচিত সদস্যগন সম্পর্কিত তথ্য';
$string['groupinfopeople'] = 'নির্বাচিত জনগন সম্পর্কিত তথ্য';
$string['groupmembers'] = 'গ্রুপ সদস্যবৃন্দ';
$string['groupmemberssee'] = 'গ্রুপ সদস্যবৃন্দ দেখুন';
$string['groupmembersselected'] = 'নির্বাচিত গ্রুপের সদস্যবৃন্দ';
$string['groupmode'] = 'গ্রুপ মোড ';
$string['groupmodeforce'] = 'ফোর্স গ্রুপ মোড';
$string['groupmy'] = 'আমার গ্রুপ';
$string['groupnonmembers'] = 'ব্যাক্তিবর্গ গ্রুপে নাই';
$string['groupnotamember'] = 'দুংখিত, আপনি ঐ গ্রুপের সদস্য নন';
$string['grouprandomassign'] = 'এলোেমেলোভাবে  সকলকে গ্রুপে ধার্য করুন';
$string['groupremove'] = 'অপসারণ করুন নির্বাচিত গ্রুপ';
$string['groupremovemembers'] = 'অপসারণ করুন নির্বাচিত সদস্যবৃন্দ';
$string['groups'] = 'গ্রুপ';
$string['groupsnone'] = 'কোন গ্রুপ নেই';
$string['groupsseparate'] = 'গ্রুপসমূহকে আলাদা করুন';
$string['groupsvisible'] = 'গ্রুপসমূহকে দৃশ্যমান করুন';
$string['guest'] = 'অতিথি';
$string['guestdescription'] = 'অতিথিদের ন্যূনতম কিচু অধিকার আছে এবং  সাধারণভাবে যে কোন জায়গায় লিখা দিতে পারে না';
$string['guestskey'] = 'অতিথিদের অনুমোদন করুন যাদের কী আছে';
$string['guestsno'] = 'অতিথিদের ভিতরে অনুমোদন করবেন না';
$string['guestsnotallowed'] = 'দু:খিত,  \'{$a}\' অতিথিদের প্রবেশের অনুমোদন দেয় না';
$string['guestsyes'] = 'অতিথিদের অনুমোদন করুন কী ব্যতীত';
$string['guestuser'] = 'অতিথি ব্যবহারকারী';
$string['guestuserinfo'] = 'এই ব্যবহারকারী একজন বিশেষ ব্যবহারকারী যার অনুমোতি আছে কিছে কোর্সের শুধুমাত্র পড়া প্রবেশাধিকার';
$string['help'] = 'সহায়িকা';
$string['helpprefix2'] = ' {$a} সাথে সহায়িকা';
$string['helpwiththis'] = 'এই সাথে সহায়িকা';
$string['hiddenassign'] = 'লুকানো বরাদ্দকৃত কাজ';
$string['hiddenfromstudents'] = 'লুকানো শিক্ষার্থীদের থেকে';
$string['hiddensections'] = 'লুকানো সেশন';
$string['hiddensectionscollapsed'] = 'লুকানো সেশনগুলো গুটালো অবস্থায় দেখা যাচ্ছে';
$string['hiddensections_help'] = 'এই সেটিংস নির্ধারন করে শিক্ষর্থীদের লুকানো সেশনগুলো গুটালো অবস্থায় দেখানো হবে কিনা  (সম্ভবত একটি পাঠ্যক্রমের জন্য সাপ্তাহিক বিন্যাস নির্দেশ করে ছুটির দিন ) অথবা সম্পুর্নরূপে লুকানো।';
$string['hiddensectionsinvisible'] = 'লুকানো সেশনগুলো সম্পূর্ণভাবে অদৃশ্য';
$string['hide'] = 'আড়াল করুন ';
$string['hideadvancedsettings'] = 'উচ্চ পর্যায়ের সেটিংসমূহ আড়াল করুন';
$string['hidepicture'] = 'ছবি আড়াল করুন';
$string['hidesection'] = '{$a }সেশনটি আড়াল করুন';
$string['hidesettings'] = 'সেটিংসমূহ আড়াল করুন';
$string['hideshowblocks'] = 'ব্লক আড়াল করুন অথবা দেখান';
$string['hits'] = 'আঘাত করুন';
$string['hitsoncourse'] = '{$a->coursename}উপর আঘাত করুন {$a->username} দ্বারা';
$string['hitsoncoursetoday'] = 'আজকে {$a->coursename} উপর আঘাত করুন {$a->username} দ্বারা ';
$string['home'] = 'হোম';
$string['hour'] = 'ঘন্টা';
$string['hours'] = 'ক্ষণ';
$string['howtomakethemes'] = 'কিভাবে নতুন থিম তৈরি করতে হয়';
$string['htmleditor'] = 'HTML সম্পাদক ব্যবহার করুন';
$string['htmleditoravailable'] = 'HTML সম্পাদকটি বিদ্যমান';
$string['htmleditordisabled'] = 'আপনি আপনার ব্যবহারকারী বৃত্তান্তে HTML সম্পাদকটি নিস্ক্রিয় করেছেন';
$string['htmleditordisabledadmin'] = 'এই সাইটে প্রশাসক HTML সম্পাদকটি নিস্ক্রিয় করেছেন';
$string['htmleditordisabledbrowser'] = 'HTML সম্পাদকটি বিদ্যমান নয় কারন আপনার ওয়েব ব্রাউজার উপযুক্ত নয়';
$string['htmlfilesonly'] = 'শুধমাত্র HTML ফাইল সমূহ';
$string['htmlformat'] = 'নান্দনিক HTML ফরম্যাট';
$string['icon'] = 'আইকন ';
$string['icqnumber'] = 'আই সি কিউ নাম্বার';
$string['idnumber'] = 'আইডি নাম্বার';
$string['idnumbercourse'] = 'পাঠ্যক্রম আইডি নাম্বার';
$string['idnumbercoursecategory'] = 'শ্রেণীবিভাগ আই-ডি সংখ্যা';
$string['idnumbercoursecategory_help'] = 'একটি বিষয় শ্রেণীর আই-ডি সংখ্যা কেবল ব্যবহার করা হয় যখন বাহ্যিক সিস্টেমের বিরুদ্ধে শ্রেণী মিলছে এবং সাইটে যেখানে ইচ্ছা প্রদর্শন করা হয় না। যদি শ্রেণী একটি সরকারী কোড নাম এইটি ঢোকেতে পারে, মাঠ অন্যথায় ফাঁকা ছেড়ে চলে যা যাবে।';
$string['idnumbercourse_help'] = 'কোন পাঠ্যক্রমের আইডি নাম্বার ব্যবহৃত হয় যখন পাঠ্যক্রমের সাথে বাইরের কোন সিস্টেম সমতুল্য করা হয় এবং সাইটের কোথাও প্রদর্শিত হয় না। যদি পাঠ্যক্রমটির একটি অফিসিয়াল কোড নাম থাকে তখন এটি দেয়া হয়। অন্যথায় ক্ষেত্রটি খালি থাকতে পারে।';
$string['idnumbergroup'] = 'গ্রুপ আই-ডি সংখ্যা';
$string['idnumbergroup_help'] = 'একটি শ্রেণীর আই-ডি সংখ্যা কেবল ব্যবহার করা হয় যখন বাহ্যিক সিস্টেমের বিরুদ্ধে শ্রেণী মিলছে এবং সাইটে যেখানে ইচ্ছা প্রদর্শন করা হয় না। যদি শ্রেণী একটি সরকারী কোড নাম এইটি ঢোকেতে পারে, মাঠ অন্যথায় ফাঁকা ছেড়ে চলে যা যাবে।';
$string['idnumbergrouping'] = 'আই-ডি সংখ্যা দলবদ্ধ করছে';
$string['idnumbergrouping_help'] = 'একটি শ্রেণীবিভাগের আই-ডি সংখ্যা কেবল ব্যবহার করা হয় যখন বাহ্যিক সিস্টেমের বিরুদ্ধে শ্রেণীবিভাগ মিলছে এবং সাইটে যেখানে ইচ্ছা প্রদর্শন করা হয় না। যদি শ্রেণীবিভাগ একটি সরকারী কোড নাম এইটি ঢোকেতে পারে, মাঠ অন্যথায় ফাঁকা ছেড়ে চলে যা যাবে।';
$string['idnumbermod'] = 'আইডি নাম্বার';
$string['idnumbermod_help'] = 'আইডি নাম্বারের সেটিংস প্রদান করে শনাক্তকারী পথ গ্রেড হিসাব কার্যপ্রনালীর জন্য। যদি কার্যপ্রনালী গ্রেড হিসাবের সাথে যুক্ত না হয় তাহলে আইডি নাম্বার ক্ষেত্র খালি থাকতে পারে।

আইডি নাম্বারটি গ্রেডবুকেও নির্ধারিত হতে পারে, যদিও শুধুমাত্র কার্যপ্রনালী সেটিংসমূহ পৃষ্ঠায় এটি সম্পাদন করা যায়';
$string['idnumbertaken'] = 'এই আইডি নাম্বার ইতোমধ্যে নেয়া হয়েছে';
$string['imagealt'] = 'ছবি বর্ণনা';
$string['import'] = 'ইম্পোর্ট';
$string['importdata'] = 'পাঠ্যক্রম ডাটা ইম্পোর্ট করুন';
$string['importdataexported'] = 'সাফল্যের সাথে ডাটা এক্সপোর্ট হয়েছে \'থেকে\' পাঠ্যক্রম।<br /> \'টু\' পাঠ্যক্রমে ইম্পোর্ট করতে চালিয়ে যান';
$string['importdatafinished'] = 'ইম্পোর্ট সম্পন্ন! চালিয়ে যান আপনার পাঠ্যক্রম';
$string['importdatafrom'] = 'একটি পাঠ্যক্রম খুঁজুন ডাটা ইম্পোর্ট থেকে:';
$string['inactive'] = 'নিস্ক্রিয়';
$string['include'] = 'যুক্ত করুন';
$string['includeallusers'] = 'সকল ব্যবহারকারী যুক্ত করুন';
$string['includecoursefiles'] = 'পাঠ্যক্রম ফাইলসমূহ যুক্ত করুন';
$string['includecourseusers'] = 'পাঠ্যক্রম ব্যবহারকারী যুক্ত করুন';
$string['included'] = 'যুক্ত হয়েছে';
$string['includelogentries'] = 'লগ এন্ট্রি যুক্ত করুন';
$string['includemodules'] = 'মডিউলসমূহ যুক্ত করুন';
$string['includemoduleuserdata'] = 'মডিউল ব্যবহারকারী ডাটা যুক্ত করুন';
$string['includeneededusers'] = 'প্রয়োজনীয় ব্যবহারকারীেূদর যুক্ত করুন';
$string['includenoneusers'] = 'কোন ব্যবহারকারীেূদর যুক্ত করবেন না';
$string['includeroleassignments'] = 'ভূমিকা নির্দেশাবলী যুক্ত করুন';
$string['includesitefiles'] = 'এই পাঠ্যক্রমে ব্যবহৃত সাইট ফাইলসমূহ যুক্ত করুন';
$string['includeuserfiles'] = 'ব্যবহারকারী ফাইলসমূহ যুক্ত করুন';
$string['increasesections'] = 'অনুচ্ছেদের সংখ্যা বৃদ্ধি করুন';
$string['info'] = 'তথ্য';
$string['institution'] = 'প্রতিষ্ঠান';
$string['instudentview'] = 'শিক্ষার্থী দৃশ্যপট';
$string['interests'] = 'আগ্রহের বিষয়';
$string['interestslist'] = 'আগ্রহের বিষয়ের তালিকা';
$string['interestslist_help'] = 'আগ্রহের বিষয়গুলো দিন কমা দিয়ে আলাদা করুন। আপনার আগ্রহের বিষয়গুলো বৃত্তান্ত পৃষ্ঠায় ট্যাগ রূপে প্রদর্শিত হবে।';
$string['invalidemail'] = 'অকার্যকর ইমেইল ঠিকানা';
$string['invalidlogin'] = 'অকার্যকর লগইন, দয়া করে আবার চেষ্টা করুন';
$string['invalidusername'] = 'ব্যবহারকারীনামে ধারন করতে পারে আলফানিউমেরিক ছোট হাতের অক্ষরসমূহ, আন্ডারস্কোর(_), হাই-পেন(-), পিরিয়ড(.) অথবা এ্যাট সিম্বল(@)';
$string['invalidusernameupload'] = 'অকার্যকর ব্যবহারকারী নাম';
$string['ip_address'] = 'IP অ্যাড্রেস';
$string['jump'] = 'অবস্থান পরিবর্তনের পরিমাণ';
$string['jumpto'] = 'যান';
$string['keep'] = 'রাখুন';
$string['keepsearching'] = 'অনুসন্ধান চালিয়ে যান';
$string['langltr'] = 'ভাষা অভিমুখ বাম-থেকে-ডানে';
$string['langrtl'] = 'ভাষা অভিমুখ ডান-থেকে-বামে';
$string['language'] = 'ভাষা';
$string['languagegood'] = 'এই ভাষা প্যাক উপরের তারিখ পর্যন্ত';
$string['lastaccess'] = 'সর্বশেষ প্রবেশাধিকার ';
$string['lastedited'] = 'সর্বশেষে সম্পাদিত হয়েছে';
$string['lastlogin'] = 'সর্বশেষ লগইন';
$string['lastmodified'] = 'সর্বশেষ পরিবর্তন';
$string['lastname'] = 'পদবি';
$string['lastyear'] = 'গতবছর';
$string['latestlanguagepack'] = 'চুড়ান্ত ভাষা প্যাক অনুসন্ধান করুন মুডল.অর্গে';
$string['layouttable'] = 'বহির্বিন্যাস সারণি';
$string['leavetokeep'] = 'বর্তমান পাসওয়ার্ড রাখার জন্য খালি রাখুন';
$string['legacythemeinuse'] = 'এই সাইটটি আপনার নিকট উপযুক্ততা মোডে প্রদর্শিত হচ্ছে কারন আপনার ব্রাউজার অধিক পুরাতন।';
$string['license'] = 'লাইসেন্স';
$string['licenses'] = 'লাইসেন্স';
$string['liketologin'] = 'আপনি কি এখন লগইন করতে চান সম্পূর্ন ব্যবহারকারী একাউন্ট নিয়ে?';
$string['list'] = 'তালিকা';
$string['listfiles'] = '{$a} ভিতরে ফাইলসমূহের তালিকা';
$string['listofallpeople'] = 'সকল ব্যাক্তিবর্গের তালিকা';
$string['listofcourses'] = 'কোর্সের তালিকা';
$string['local'] = 'স্থানীয়';
$string['localplugins'] = 'স্থানীয় পোর্ট';
$string['localpluginsmanage'] = 'স্থানীয় পোর্ট ম্যনেজ করুন';
$string['location'] = 'অবস্থান';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'আপনি লগইন করেছেন এমন {$a} ';
$string['loggedinasguest'] = 'আপনি বর্তমানে ব্যবহার করছেন অতিথি প্রবেশাধিকার';
$string['loggedinnot'] = 'আপনি লগইন নেই';
$string['login'] = 'লগইন করুন';
$string['loginalready'] = 'আপনি ইতোমধ্যে লগইন হয়েছেন';
$string['loginas'] = 'লগইন করুন এভাবে';
$string['loginaspasswordexplain'] = 'আপনাকে বিশেষ "লগইনএ্যাজ পাসওয়ার্ড" দিতে হবে এই বৈশিষ্ট্যটি ব্যবহার করার জন্যে।<br />যদি আপনি এটি না জানেন, আপনার সার্ভার প্রশাসকে জিজ্ঞাসা করুন।</p>';
$string['login_failure_logs'] = 'লগইন ব্যর্থতার লগসমূহ';
$string['loginguest'] = 'অতিথি হিসাবে লগইন করুন';
$string['loginsite'] = 'সাইটটিতে লগইন করুন';
$string['loginsteps'] = 'সালাম! পাঠ্যক্রমে সম্পূর্ণ প্রবেশাধিকারের জন্য আপনার
 কয়েক মিনিট সময় লাগবে এই ওয়েব সাইটে আপনার জন্য নতুন একটা একাউন্ট তৈরি করতে।
 প্রত্যেক সতন্ত্র পাঠ্যক্রমসমূহেও থাকতে পারে একটি প্রাক্তন
 "তালিকাভূক্ত কী", যেটির পরবর্তীতে কখনও প্রয়োজন হবে না
 পদক্ষেপটি:
   <ol>
   <li>ভরাট করুন <a href="{$a}"> নতুন একাউন্ট </a> ফরম সাথে আপনার বিস্তারিত তথ্য।</li>
   <li> একটি ইমেইল অচিরেই আপনার ইমেইল ঠিকানায় পাঠানে হবে।</li>
   <li> আপনার ইমেইলটি পড়ুন, এবং ওয়েব লিঙ্কে ক্লিক করুন যা এটি ধারন করে। </li>
   <li> আপনার একাউন্টটি নিশ্চিত হবে এবং আপনি লগইন হবেন।</li>
   <li> এখন, যে পাঠ্যক্রমে আপনি অংশগ্রহন করতে চান তা নির্বাচন করুন।</li>
   <li> যদি আপনাকে "তালিকাভূক্ত কী"  এর জন্য প্ররোচিত করা হয় ব্যবহার করবেন একটি যেটি আপনার শিক্ষক আপনাকে দিয়েছেন। এটি আপনাকে এই
 পাঠ্যক্রমে তালিকাভূক্ত করবে।</li>
   <li> আপনি এখন পাঠ্যক্রমে সম্পূর্ণ প্রবেশাধিকার করতে পারেন। এখন থেকে আপনার প্রয়োজন হবে
 আপনার ব্যক্তিগত ব্যবহারকারী নাম এবং পাসওয়ার্ড (এই  পৃষ্ঠার ফরম)
 কোন পাঠ্যক্রমে লগইন এবং প্রবেশাধিকারের জন্য আপনাকে তালিকাভুক্ত হতে হবে।</li>
   </ol>';
$string['loginstepsnone'] = '<p>সালাম!</p>
<p>পাঠ্যক্রমে সম্পূর্ণ প্রবেশাধিকারের জন্য আপনার নিজস্ব একটা একাউন্ট তৈরি করা লাগবে।</p>
<p> আপনাদের সকলের তৈরি করার দরকার হবে একটি ব্যবহারকারী নাম ও পাসওয়ার্ড এবং এটি  ব্যবহার করুন এই পৃষ্ঠার ফরমে!</p>
<p> যদি কেউ ইতোমধ্যে আপনার ব্যবহারকারী নাম নির্বাচন করে থাকে তাহলে আপনাকে আবার চেষ্টার জন্য ভিন্ন ব্যবহারকারী নাম দিতে হবে।</p>';
$string['loginto'] = '{$a} লগইন করুন';
$string['logout'] = 'লগআউট করুন';
$string['logoutconfirm'] = 'আপনি কি সত্যিই লগআউট করতে চান?';
$string['logs'] = 'লগসমূহ';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">আরও</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">আরও</a> ]';
$string['lookback'] = 'পিছনে দেখুন';
$string['mailadmins'] = 'প্রশাসককে অবহিত করুন';
$string['mailstudents'] = 'শিক্ষার্থীদের  অবহিত করুন';
$string['mailteachers'] = 'শিক্ষকদের  অবহিত করুন';
$string['makeafolder'] = 'ফোল্ডার তৈরি করুন';
$string['makeeditable'] = 'যদি আপনি তৈরি করেন \'{$a}\' সম্পাদনযোগ্য ওয়েব সার্ভার প্রসেসের সাহায্যে তাহলে আপনি সরাসরি সম্পাদন করতে পারবেন এই ফাইলটি এই পৃষ্ঠা থেকে';
$string['makethismyhome'] = 'এটি আমার পূর্বনির্ধারিত হোম পৃষ্ঠা হিসাবে তৈরি করুন';
$string['manageblocks'] = 'ব্লক';
$string['managecourses'] = 'পাঠ্যক্রম নিয়ন্ত্রন করুন';
$string['managedatabase'] = 'ডাটাবেস';
$string['manageeditorfiles'] = 'ফাইলসমূহ নিয়ন্ত্রন করুন যেগুলো সম্পাদক ব্যবহার করেছেন ';
$string['managefilters'] = 'ফিল্টার';
$string['managemodules'] = 'মডিউল';
$string['manageroles'] = 'কার্যকলাপ এবং সম্মতি';
$string['markedthistopic'] = 'এই বিষয়টি হাইলাইটকৃত হয়েছে বর্তমান বিষয় হিসেেব';
$string['markthistopic'] = 'এই বিষয়টি হাইলাইট করুন বর্তমান বিষয় হিসেেব';
$string['matchingsearchandrole'] = 'সমতুল্য করুন \'{$a->search}\' এবং {$a->role}';
$string['maxfilesize'] = 'নতুন ফাইলসমূহের সর্বোচ্চ আকার: {$a}';
$string['maxfilesreached'] = 'আপনাকে {$a} file(sএর একটি সর্বোচ্চ যুক্ত করতে অনুমোদন করা হয়) এই পদটিতে';
$string['maximumchars'] = '{$a} অক্ষরসমূহের সর্বোচ্চ ';
$string['maximumgrade'] = 'সর্বোচ্চ গ্রেড';
$string['maximumgradex'] = 'সর্বোচ্চ গ্রেড: {$a}';
$string['maximumshort'] = 'সর্বোচ্চ';
$string['maximumupload'] = 'সর্বোচ্চ আপলোডের আকার';
$string['maximumupload_help'] = 'এই সেটিংস নির্ধারণ করে সবচেয়ে বড় আকারের ফাইল যেটি পাঠ্যক্রমে আপলোড করা হবে, সাইট- প্রশস্ত সেটিংস দ্বারা নিয়ন্ত্রিত যা একজন প্রশাসক নির্ধারণ করেন। আরোফফাইলির আকার নিয়ন্ত্রণের জন্য সর্বোচ্চ আপলোডের আকার সেটিংসও  মডিউলের এ্যাক্টিভিটি সংযুক্ত করে থাকে।';
$string['maxnumberweeks'] = 'weeks/topicsএর সংখ্যার জন্য সর্বোচ্চ';
$string['maxnumberweeks_desc'] = 'এইটি সর্বোচ্চ অপশনস নিয়ন্ত্রণ করে যে তে আবির্ভূত হয় " weeks/topicsএর সংখ্যা " কোর্সের জন্য মানসমূহ।';
$string['maxnumcoursesincombo'] = 'ব্রাউজ করুন<a href="{$a-> link} " > {$a- > numberofcourses} কোর্স</a>।';
$string['maxsize'] = 'সর্বোচ্চ আকার: {$a}';
$string['maxsizeandareasize'] = 'নতুন ফাইলের জন্য সর্বোচ্চ আকৃতি: {$a- > size}, সর্বোপরি সীমা: {$a- > areasize}';
$string['maxsizeandattachments'] = 'নতুন ফাইলের জন্য সর্বোচ্চ আকৃতি: {$a- > size}, সর্বোচ্চ সংযুক্তি: {$a- > attachments}';
$string['maxsizeandattachmentsandareasize'] = 'নতুন ফাইলের জন্য সর্বোচ্চ আকৃতি: {$a- > size}, সর্বোচ্চ সংযুক্তি: {$a- > attachments}, সর্বোপরি সীমা: {$a- > areasize}';
$string['memberincourse'] = 'পাঠ্যক্রমটির ব্যাক্তিবর্গ';
$string['messagebody'] = 'বার্তার মূল অংশ';
$string['messagedselectedusers'] = 'নির্বাচিত ব্যবহারকারীদেরকে বার্তা দেয়া হয়েছে এবং গ্রাহক তালিকাটি পুনর্বিন্যাস করা হয়েছে।';
$string['messagedselectedusersfailed'] = 'নির্বাচিত ব্যবহারকারীদের বার্তা পাঠানোর সময় কিছু ত্রুটি হয়েছে। হয়তো কেউ কেউ ইমেইলটি পেয়েছে।';
$string['messageprovider:availableupdate'] = 'প্রাপ্তিসাধ্য সাম্প্রতিকীকরন বিজ্ঞপ্তি';
$string['messageprovider:backup'] = 'ব্যাকআপ বিজ্ঞপ্তি';
$string['messageprovider:courserequestapproved'] = 'বিষয় সৃষ্টি অনুরোধ অনুমোদন বিজ্ঞপ্তি';
$string['messageprovider:courserequested'] = 'বিষয় সৃষ্টি অনুরোধ বিজ্ঞপ্তি';
$string['messageprovider:courserequestrejected'] = 'বিষয় সৃষ্টি অনুরোধ প্রত্যাখান বিজ্ঞপ্তি';
$string['messageprovider:errors'] = 'সাইটে গুরুত্বপূর্ণ ত্রুটি আছে';
$string['messageprovider:errors_help'] = 'এগুলো হল গুরুত্বপূর্ণ ত্রুটি যা একজন প্রশাসকের জানা উচিৎ';
$string['messageprovider:instantmessage'] = 'ব্যবহারকারীদের মধ্যে ব্যক্তিগত বার্তাসমূহ ';
$string['messageprovider:instantmessage_help'] = 'এই সেশন কনফিগার করে বার্তাগুলোর কি অবস্থা যেগুলো এই সাইটে অন্যান্য ব্যবহারকারীগণ থেকে আপনাকে সরাসরি প্রেরিত।';
$string['messageprovider:notices'] = 'অল্প ত্রুটি সম্পর্কিত ঘোষনা ';
$string['messageprovider:notices_help'] = 'এগুলো হল ঘোষনা যা দেখে একজন প্রশাসক আকর্ষিত হবেন।';
$string['messageselect'] = 'বার্তা গ্রাহক হিসাবে এই ব্যবহারকারী নির্বাচন করুন ';
$string['messageselectadd'] = 'একটি বার্তা প্রেরণ';
$string['migratinggrades'] = 'গ্রেড মাইগ্রেটিং হচ্ছে';
$string['min'] = 'মিনিট';
$string['mins'] = 'মিনিট';
$string['minute'] = 'মিনিট';
$string['minutes'] = 'মিনিট';
$string['miscellaneous'] = 'বিবিধ';
$string['missingcategory'] = 'আপনার একটি বিভাগ নির্বাচনের প্রয়োজন।';
$string['missingcity'] = 'শহর/টাউন অনুপস্থিত ';
$string['missingcountry'] = 'দেশ অনুপস্থিত ';
$string['missingdescription'] = 'বর্ণনা অনুপস্থিত ';
$string['missingemail'] = 'ইমেইল ঠিকানা অনুপস্থিত ';
$string['missingfirstname'] = 'দেয়া নাম অনুপস্থিত ';
$string['missingfromdisk'] = 'ডিস্ক থেকে অনুপস্থিত';
$string['missingfullname'] = 'সম্পূর্ণ নাম অনুপস্থিত ';
$string['missinglastname'] = 'পদবি অনুপস্থিত ';
$string['missingname'] = 'নাম অনুপস্থিত ';
$string['missingnewpassword'] = 'নতুন পাসওয়ার্ড অনুপস্থিত ';
$string['missingpassword'] = 'পাসওয়ার্ড অনুপস্থিত দেখাচ্ছে';
$string['missingrecaptchachallengefield'] = ' reCAPTCHA প্রতিদ্বন্দ্বিতা ক্ষেত্র অনুপস্থিত ';
$string['missingreqreason'] = 'কারন অনুপস্থিত ';
$string['missingshortname'] = 'সংক্ষিপ্ত নাম অনুপস্থিত ';
$string['missingshortsitename'] = 'ছোট সাইট নাম অনুপস্থিত';
$string['missingsitedescription'] = 'সাইট বর্ণনা অনুপস্থিত ';
$string['missingsitename'] = 'সাইট নাম অনুপস্থিত ';
$string['missingstrings'] = 'অনুবাদহীন শব্দসমূহ অথবা বাক্যাংশ পরীক্ষা';
$string['missingstudent'] = 'কিছু নির্বাচন করতে হবেই';
$string['missingsummary'] = 'সারমর্ম অনুপস্থিত ';
$string['missingteacher'] = 'কিছু নির্বাচন করতে হবেই';
$string['missingurl'] = 'URL অনুপস্থিত ';
$string['missingusername'] = 'ব্যবহারকারী নাম অনুপস্থিত';
$string['modchooserdisable'] = 'সক্রিয়তা বাছাইকারক বন্ধ';
$string['modchooserenable'] = 'সক্রিয়তা বাছাইকারক';
$string['moddoesnotsupporttype'] = 'মডিউল {$a- > modname} ধরন {$a- > type}এর আপলোড সমর্থন করে না';
$string['modified'] = 'পরিবর্তিত হয়েছে';
$string['moduleintro'] = 'বর্ণনা';
$string['modulesetup'] = 'মডিউল টেবিলসমূহ সেটিং আপ করুন';
$string['modulesuccess'] = '{$a} টেবিলসমূহ সেটিং আপ ঠকমত করা হয়েছে';
$string['month'] = 'মাস';
$string['months'] = 'মাসগুলি';
$string['moodledocs'] = 'মুডল ডকস';
$string['moodledocslink'] = 'এই পৃষ্ঠার জন্য মুডল ডকস';
$string['moodlerelease'] = 'মুডল রিলিজ';
$string['moodleversion'] = 'মুডল সংস্করণ';
$string['more'] = 'আরও';
$string['morehelp'] = 'আরও সহায়তা';
$string['moreinformation'] = 'এই ত্রুটি সম্পর্কিত আরও তথ্য ';
$string['moreprofileinfoneeded'] = 'দয়া করে আপনার সম্পর্কে আরও আমাদের জানান';
$string['mostrecently'] = 'একেবারে সাম্প্রতিক';
$string['move'] = 'সরানো';
$string['movecategorycontentto'] = 'সরিয়ে নিন';
$string['movecategoryto'] = 'বিভাগ সরিয়ে নিন:';
$string['movecontentstoanothercategory'] = 'অন্য বিভাগে বিষয়বস্তুসমূহ সরান';
$string['movecourseto'] = 'পাঠ্যক্রম সরিয়ে নিন:';
$string['movedown'] = 'এগিয়ে যাওয়া';
$string['movefilestohere'] = 'ফাইলগুলো এখানে সরান';
$string['movefull'] = '{$a} এই অবস্থানে সরান ';
$string['movehere'] = 'এখানে সরান';
$string['moveleft'] = 'বামে সরান';
$string['moveright'] = 'ডানে সরান';
$string['movesection'] = '{$a} সেশনটি সরান';
$string['moveselectedcoursesto'] = 'নির্বাচিত পাঠ্যক্রমসমূহ সরিয়ে নিন:';
$string['movetoanotherfolder'] = 'অন্য ফোল্ডারে সরিয়ে নিন';
$string['moveup'] = 'উপরে ওঠান';
$string['msnid'] = 'MSN আইডি';
$string['mustchangepassword'] = 'নতুন পাসওয়ার্ডটি অবশ্যই বর্তমানটি থেকে ভিন্ন হবে';
$string['mustconfirm'] = 'আপনাকে আপনার লগইন নিশ্চিত করা প্রয়োজন';
$string['mycourses'] = 'আমার পাঠ্যক্রম';
$string['myfiles'] = 'আমার একান্ত ফাইলসমূহ';
$string['myfilesmanage'] = 'আমার একান্ত ফাইলসমূহ নিয়ন্ত্রন';
$string['myhome'] = 'আমার হোম';
$string['mymoodledashboard'] = 'মাই মুডল ড্যাশবোর্ড';
$string['myprofile'] = 'আমার বৃত্তান্ত';
$string['name'] = 'নাম';
$string['nameforlink'] = 'এই সংযোগ ডাক দিতে আপনিটি কি চান?';
$string['nameforpage'] = 'এই পাতা ডাক দিতে আপনিটি কি চান?';
$string['navigation'] = 'ন্যাভিগেশন';
$string['needed'] = 'প্রয়োজন হয়েছিল';
$string['never'] = 'কখনো নয়';
$string['neverdeletelogs'] = 'লগসমূহ কখনো মুছবেন না';
$string['new'] = 'নতুন';
$string['newaccount'] = 'নতুন একাউন্ট';
$string['newcourse'] = 'নতুন পাঠ্যক্রম';
$string['newpassword'] = 'নতুন পাসওয়ার্ড';
$string['newpasswordfromlost'] = '<strong>নোটিশ:</strong> আপনার <strong>বর্তমান পাসওয়ার্ড</strong> আপনাকে প্রেরণ করা হবে <strong>দ্বিতীয়ত</strong> দুটি ইমেইল পাসওয়ার্ড পুনরুদ্ধার প্রসেসের অংশ হিসাবে। এই পর্দার পরবর্তীতে যাবার পূর্বে নিশ্চিত করুন আপনি আপনার প্রতিস্থাপন পাসওয়ার্ড পেয়েছেন। ';
$string['newpassword_help'] = 'নতুন পাসওয়ার্ড দিন অথবা বর্তমান পাসওয়ার্ড রাখার জন্য খালি রাখুন।';
$string['newpasswordtext'] = 'সালাম {$a->firstname},

 আপনার এখানে \'{$a->firstname}\' একাউন্ট পাসওয়ার্ড পুনর্বিন্যাস করা হয়েছে
আপনার নতুন অস্থায়ী একটি পাসওয়ার্ড প্রদত্ত হয়েছে।

আপনার বর্তমান লগইন তথ্য এখন:
   ব্যবহারকারীনাম: {$a->username}
   পাসওয়ার্ড: {$a->newpassword}

দয়া করে পাসওয়ার্ড পরিবর্তনের জন্য এই পৃষ্ঠায় যান:‌
  {$a->link}

অধিকাংশ মেইল প্রোগ্রামে, এটি নীল লিঙ্কে প্রদর্শিত হয়
 যেখানে আপনি ক্লিক করে সচল করতে পারেন। যদি এটি কাজ না করে,
তাহলে আপনার ওয়েব ব্রাউজার উইন্ডোর শীর্ষে ঠিকানা লাইনে  ঠিকানাটি অনুলিপি ও প্রতিলিপি করুন.

চিয়ার্স  \'{$a->sitename}\'প্রশাসক থেকে,
{$a->signoff}';
$string['newpicture'] = 'নতুন ছবি';
$string['newpicture_help'] = 'নতুন ছবি যোগ করতে, ব্রাউজ করুন এবং চিত্র নির্বাচন করুন (JPG অথবা PNG বিন্যাসে) তারপর "হালনাগাদ বৃত্তান্তে" ক্লিক করুন। চিত্রটি বর্গক্ষেত্ররুপে ছাঁটতে হবে এবং পুনরাকৃতি হবে ১০০x১০০ পিক্সেলে।';
$string['newsitem'] = 'সংবাদ আইটেম';
$string['newsitems'] = 'সংবাদ আইটেম';
$string['newsitemsnumber'] = 'প্রদর্শনের জন্য সংবাদ আইটেম';
$string['newsitemsnumber_help'] = 'এই সেটিংস নির্ধারণ করে পাঠ্যক্রম পৃষ্ঠায় সর্বশেষ সংবাদ ব্লকে কতগুলো সাম্প্রতিক আইটেম দৃশ্যমান হয়। যদি নির্ধারণ করা হয় "০ সংবাদ আইটেম" তাহলে সর্বশেষ সংবাদ ব্লক প্রদর্শিত হবে না।';
$string['newuser'] = 'নতুন ব্যবহারকারী';
$string['newusernewpasswordsubj'] = 'নতুন ব্যবহারকারী একাউন্ট';
$string['newusernewpasswordtext'] = 'সালাম {$a->firstname},

 আপনার জন্য একটি নতুন একাউন্ট তৈরি করা হয়েছে এখানে \'{$a->sitename}\'
এবং আপনার নতুন অস্থায়ী একটি পাসওয়ার্ড প্রদত্ত হয়েছে।

আপনার বর্তমান লগইন তথ্য এখন:
   ব্যবহারকারীনাম: {$a->username}
   পাসওয়ার্ড: {$a->newpassword}
       (আপনি আপনার পাসওয়ার্ড পরিবর্তন করতে পারবেন
        যখন আপনি প্রথমবারের জন্য লগইন করবেন)

 শুরুর জন্য ব্যবহার করুন \'{$a->sitename}\', লগইন এখানে
   {$a->link}

অধিকাংশ মেইল প্রোগ্রামে, এটি নীল লিঙ্কে প্রদর্শিত হয়
 যেখানে আপনি ক্লিক করে সচল করতে পারেন। যদি এটি কাজ না করে,
তাহলে আপনার ওয়েব ব্রাউজার উইন্ডোর শীর্ষে ঠিকানা লাইনে  ঠিকানাটি অনুলিপি ও প্রতিলিপি করুন.

চিয়ার্স  \'{$a->sitename}\'প্রশাসক থেকে,
{$a->signoff}';
$string['newusers'] = 'নতুন ব্যবহারকারীরা';
$string['newwindow'] = 'নতুন উইন্ডো';
$string['next'] = 'পরবর্তী';
$string['nextsection'] = 'পরবর্তী সেশন';
$string['no'] = 'না';
$string['noblockstoaddhere'] = 'এখানে কোন ব্লক নেই যা আপনি এই পৃষ্ঠায় সংযুক্ত করতে পারেন।';
$string['nobody'] = 'কেউ না';
$string['nochange'] = 'কোন পরিবর্তন  নয়';
$string['nocomments'] = 'কোন মন্তব্য নাই';
$string['nocourses'] = 'কোন পাঠ্যক্রম নয়';
$string['nocoursesfound'] = 'কোন পাঠ্যক্রম পাওয়া যায় নাই \'{$a}\' শব্দ ভান্ডারে';
$string['nocoursesyet'] = 'কোন পাঠ্যক্রম নাই এই বিভাগে';
$string['nodstpresets'] = 'প্রশাসক ডে-লাইট সাশ্রয় সময় সাপোর্ট সক্রিয় করেন নাই।';
$string['nofilesselected'] = 'পুনরুদ্ধার করার জন্য কোন ফাইল নির্বাচিত করা হয় নাই';
$string['nofilesyet'] = 'এখনো কোন ফাইল আপনার পাঠ্যক্রমে আপলোড করা হয় নাই';
$string['nograde'] = 'কোনো গ্রেড নেই';
$string['nohelpforactivityorresource'] = 'এই পুঁজিটি অথবা সক্রিয়তার সঙ্গে কোনও সাহায্য বর্তমানে সহযোগ নাই';
$string['noimagesyet'] = 'এখনো কোন ছবি আপনার পাঠ্যক্রমে আপলোড করা হয় নাই';
$string['nologsfound'] = 'কোন লগ পাওয়া যাচ্ছে না';
$string['nomatchingusers'] = 'কোন ব্যবহারকারী \'{$a}\' সাথে মিলে না';
$string['nomorecourses'] = 'আর কোন সমতুল্য পাঠ্যক্রম পাওয়া যাবে না ';
$string['nomoreidnumber'] = 'বিরোধ পরিহারে আইডি নম্বর ব্যবহার হচ্ছে না';
$string['none'] = 'কোনটি না';
$string['noneditingteacher'] = 'অসম্পাদিত শিক্ষক';
$string['noneditingteacherdescription'] = 'অসম্পাদিত শিক্ষকবৃন্দ শিক্ষা দিতে পারে পাঠ্যক্রম এবং গ্রড শিক্ষর্থীদের, কিন্তু কার্যকলাপের পরিবর্তন নাও হতে পারে।';
$string['nonstandard'] = 'অনাদর্শ';
$string['nopendingcourses'] = 'অনুমোদনের জন্য কোন পাঠ্যক্রম বাকি নেই';
$string['nopotentialadmins'] = 'কোন সম্ভাব্য প্রশাসক নেই ';
$string['nopotentialcreators'] = 'কোন সম্ভাব্য পাঠ্যক্রম নির্মাতা নেই';
$string['nopotentialstudents'] = 'কোন সম্ভাব্য শিক্ষার্থী নেই';
$string['nopotentialteachers'] = 'কোন সম্ভাব্য শিক্ষকবৃন্দ নেই ';
$string['norecentactivity'] = 'সম্প্রতিক কার্যকলাপ নেই';
$string['noreplybouncemessage'] = 'আপনি নো-রিপ্লে ইমেইল ঠিকানায় রিপ্লে করেছেন। যদি আপনি একটি ফোরাম পোষ্টে রিপ্লের চেষ্টা করেন, অনুগ্রহ করে রিপ্লের পরিবর্তে {$a} ফোরাম ব্যবহার করুন।

নিচে আপনার ইমেইলের বিষয়বস্তুঃ';
$string['noreplybouncesubject'] = '{$a} - বাউন্সড ইমেইল।';
$string['noreplyname'] = 'এই ইমেইলে উত্তর দিবেন না';
$string['noresults'] = 'ফলাফল নেই';
$string['normal'] = 'সাধারণ';
$string['normalfilter'] = 'সাধারণ অনুসন্ধান';
$string['nosite'] = 'সাইট-স্তর পাঠ্যক্রম পাওয়া যায় নাই';
$string['nostudentsfound'] = 'কোন {$a} পাওয়া যায় নাই';
$string['nostudentsingroup'] = 'এই গ্রুপে এখনো কোন শিক্ষার্থী নেই';
$string['nostudentsyet'] = 'এই পাঠ্যক্রমে এখনো কোন শিক্ষার্থী তালিকাভুক্ত হয় নাই';
$string['nosuchemail'] = 'এ ধরনের ইমেইল ঠিকানা নেই';
$string['notavailable'] = 'বিদ্যমান নয়';
$string['noteachersyet'] = 'এই পাঠ্যক্রমে এখনো কোন শিক্ষকবৃন্দ নেই';
$string['notenrolled'] = '{$a} এই পাঠ্যক্রমে তালিকাভুক্ত হয় নাই।';
$string['notenrolledprofile'] = 'এই বৃত্তান্ত বিদ্যমান নয় কেননা এই ব্যবহারকারী এই পাঠ্যক্রমে তালিকাভুক্ত হয় নাই';
$string['noteusercannotrolldatesoncontext'] = '<strong>টীকা:</strong> রোল তারিখের ক্ষমতা নিস্ক্রিয় হয়েছে যখন এই ব্যাকআপ পুনরুদ্ধার হচ্ছিল কারণ আপনার আবশ্যকীয় সম্মতির অভাব ছিল।';
$string['noteuserschangednonetocourse'] = '<strong>টীকা:</strong> পাঠ্যক্রম ব্যবহারকারীদের প্রয়োজন হবে পুনরুদ্ধারের ব্যবহারকারী ডাটা পুনরুদ্ধার করার সময় (কার্যকলাপে, ফাইলে, অথবা বার্তায়)। এই সেটিংসটি আপনার জন্য পরিবর্তন হয়েছে। ';
$string['nothingnew'] = 'নতুন কিছুই নেই আপনার শেষ লগইন থেকে ';
$string['nothingtodisplay'] = 'প্রদর্শনের জন্য কিছুই নেই';
$string['notice'] = 'নোটিশ';
$string['noticenewerbackup'] = 'এই ব্যাকআপ ফাইল মুডলের {$a->backuprelease} ({$a->backupversion}) সাথে তৈরি হয়েছে এবং এটি বর্তমান ইনস্টলকৃত মডুল {$a->serverrelease} ({$a->serverversion}) থেকে নতুন। এটির কারনে কিছু অসংগতি হতে পারে কারন ব্যাকআপ ফাইলের পশ্চাৎ উপযুক্ততা গ্রহন করতে পারে না।';
$string['notifications'] = 'প্রজ্ঞাপন';
$string['notifyloginfailuresmessage'] = '{$a->সময়}, আইপিঃ {$a->ip}, ব্যবহারকারীঃ {$a->তথ্য}';
$string['notifyloginfailuresmessageend'] = 'আপনি {$a}/report/log/index.php?id=1&তে এই কার্যবিবরণীগুলি দেখতে পারেন; chooselog=1& modid=site_errors।';
$string['notifyloginfailuresmessagestart'] = 'এখানে {$a} ব্যর্থ লগইন চেষ্টার লিষ্ট যা সর্বশেষ আপানাকে অবহিত করা হয়েছিল';
$string['notifyloginfailuressubject'] = '{$a} :: ব্যর্থ লগইন ঘোষণা';
$string['notincluded'] = 'সংযুক্ত নয়';
$string['notingroup'] = 'দুখিত, এই কার্যকলাপ দেখার জন্য আপনাকে গ্রুপের একজন অংশ হতে হবে।';
$string['notpublic'] = 'সর্বসাধারন নয়!';
$string['nousersfound'] = 'কোন ব্যবহারকারী পাওয়া যায় নাই';
$string['nousersmatching'] = 'সমতুল্য \'{$a}\' কোন ব্যবহারকারী পাওয়া যায় নাই';
$string['nousersyet'] = 'এখনো কোন ব্যবহারকারী নাই';
$string['novalidcourses'] = 'প্রদর্শনের জন্য কোন বৈধ পাঠ্যক্রম নেই';
$string['now'] = 'এখন';
$string['numattempts'] = '{$a} লগইনের চেষ্টা ব্যর্থ হয়েছে';
$string['numberofcourses'] = 'পাঠ্যক্রমের সংখ্যা';
$string['numberweeks'] = 'সপ্তাহ/টপিকের সংখ্যা';
$string['numdays'] = '{$a} দিন';
$string['numhours'] = '{$a} ঘন্টা';
$string['numletters'] = '{$a} পত্র';
$string['numminutes'] = '{$a} মিনিট';
$string['nummonths'] = '{$a} মাস';
$string['numseconds'] = '{$a} সেকেন্ড';
$string['numviews'] = '{$a} মতামত';
$string['numweeks'] = '{$a} সপ্তাহ';
$string['numwords'] = '{$a} শব্দ';
$string['numyears'] = '{$a} বছর';
$string['ok'] = 'ঠিক আছে';
$string['oldpassword'] = 'বর্তমান পাসওয়ার্ড';
$string['olduserdirectory'] = 'এটি পুরাতন ব্যবহারকারীদের ডিরেক্টরি, এবং ভবিষ্যতে লাগবে না। আপনি নিরাপদে এটি মুছতে পারেন। ফাইলটিতে যা রয়েছে তা অনুলিপি হয়েছে নতুন ব্যবহারকারী ডিরেক্টরিতে।';
$string['opentoguests'] = 'অতিথি প্রবেশাধিকার';
$string['optional'] = 'ঐচ্ছিক';
$string['options'] = 'বিকল্পগুলি';
$string['order'] = 'বিন্যাস';
$string['originalpath'] = 'আসল পথ';
$string['other'] = 'অন্যান্য';
$string['outline'] = 'সীমারেখা';
$string['outlinereport'] = 'সীমারেখা রিপোর্ট';
$string['page'] = 'পৃষ্ঠা';
$string['pageheaderconfigablock'] = '%fullname% এ ব্লক কনফিগার হচ্ছে';
$string['pagepath'] = 'পৃষ্ঠার পথ';
$string['pageshouldredirect'] = 'এই পৃষ্ঠা স্বয়ংক্রিভাবে রিডিরেক্ট হওয়া উচিৎ। যদি কিছু না ঘটে অনুগ্রহ করে চলমান নিচের লিঙ্ক ব্যবহার করুন।';
$string['parentcategory'] = 'উর্ধ্বস্থ বিভাগ';
$string['parentcoursenotfound'] = 'উর্ধ্বস্থ পাঠ্যক্রম পাওয়া যায় নাই';
$string['parentfolder'] = 'উর্ধ্বস্থ ফোল্ডার';
$string['participants'] = 'অংশগ্রহণকারীরা';
$string['participantslist'] = 'অংশগ্রহণকারীদের তালিকা';
$string['participationratio'] = 'অংশগ্রহণকারী অনুপাত';
$string['participationreport'] = 'অংশগ্রহণকারী রিপোর্ট';
$string['password'] = 'পাসওয়ার্ড';
$string['passwordchanged'] = 'পাসওয়ার্ড পরিবর্তন হয়েছে';
$string['passwordconfirmchange'] = 'পাসওয়ার্ড নিশ্চিতকরণ পরিবর্তন ';
$string['passwordextlink'] = 'নিম্নোক্ত লিঙ্কটি আপনার হারানো পাসওয়ার্ড পুনরুদ্ধারের জন্য দেয়া হয়েছে। এটি আপনাকে মুডলের বাইরে নিয়ে যাবে।';
$string['passwordforgotten'] = 'ভুলে যাওয়া পাসওয়ার্ড';
$string['passwordforgotteninstructions'] = 'আপনার বিস্তারিত অবশ্যই ব্যবহারকারী ডাটাবেসে পাওয়া যাবে। অনুগ্রহ করে দিন <strong>যেকোন একটি</strong> আপনার ব্যবহারকারী নাম অথবা আপনার রেজিষ্টারকৃত ইমেইল ঠিকানা উপযুক্ত বাক্সে। দুটি একসাথে দেয়ার প্রয়োজন নেই।';
$string['passwordforgotteninstructions2'] = 'আপনার পাসওয়ার্ড পুনঃনির্ধারণ করার জন্য, নিম্নে প্রদান করুন আপনার ব্যবহারকারী নাম অথবা ইমেইল ঠিকানা। যদি আপনাকে আমরা ডাটাবেসে পাই, একটি ইমেইল প্রেরিত হবে আপনার ইমেইল ঠিকানায়, সাথে নির্দেশসহ আবার কিভাবে প্রবেশাধিকার পাওয়া যায়। ';
$string['passwordnohelp'] = 'আপনার হারানো পাসওয়ার্ড খোঁজার জন্য বিদ্যমান কোন সহায়তা নেই। অনুগ্রহ করে আপনার মুডল প্রশাসকে যোগাযোগ করুন।';
$string['passwordrecovery'] = 'হ্যাঁ, আমাকে লগইনে সহায়তা করুন';
$string['passwordsdiffer'] = 'এই পাসওয়ার্ডগুলো মিলল না';
$string['passwordsent'] = 'পাসওয়ার্ড প্রেরিত হয়েছে';
$string['passwordsenttext'] = '<p>একটি ইমেইল প্রেরিত হয়েছে আপনার ইমেইল ঠিকানায় {$a->email}।</p>
   <p><b> অনুগ্রহ করে আপনার ইমেইল পরীক্ষা করুন আপনার নতুন পাসওয়ার্ডের জন্য</b></p>
   <p>নতুন পাসওয়ার্ডটি স্বয়ংক্রিভাবে তৈরি হয়েছে, সুতরাং আপনি চাইলে
   <a href="{$a->link}">এটি পরিবর্তন করতে পারেন যা মনে রাখা থেকে সহজ হবে</a>.</p>';
$string['path'] = 'পাথ';
$string['pathnotexists'] = 'আপনার সার্ভারে পাথের অস্তিত্ব নেই।';
$string['pathslasherror'] = 'পাথ এর সমাপ্তি শ্লাস দিয়ে হতে পারে না।';
$string['paymentinstant'] = 'নিম্নের বোতামটি মূল্য প্রদান এবং ক্ষণিকের মধ্যে তালিকাভূক্ত হবার জন্য ব্যবহার করুন!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> অমীমাংসিত</small>)';
$string['paymentrequired'] = 'এই পাঠ্যক্রমে প্রবেশের জন্য মূল্য প্রদান করা প্রয়োজন';
$string['payments'] = 'মূল্য প্রদান';
$string['paymentsorry'] = 'মূল্য প্রদানের জন্য আপনাকে ধন্যবাদ! দুঃখজনকভাবে আপনার মূল্য প্রদান প্রক্রিয়া এখনো সম্পন্ন হয় নাই, এবং আপনি এখনো পাঠ্যক্রমে প্রবেশের জন্য নিবন্ধিত হন নাই "{$a->সম্পূর্ণ নাম}"। অনুগ্রহ করে  কিছু সময় পাঠ্যক্রমে চেষ্টা চালান, কিন্তু আপনার চালাতে যদি সমস্যা হয় অনুগ্রহ করে সতর্ক করুন {$a->শিক্ষককে} অথবা সাইট প্রশাসককে';
$string['paymentthanks'] = 'মূল্য প্রদানের জন্য আপনাকে ধন্যবাদ! আপনি এখন আপনার পাঠ্যক্রমে তালিকাভূক্ত হয়েছেনঃ<br />"{$a}"';
$string['pendingrequests'] = 'অমীমাংসিত অনুরোধ';
$string['periodending'] = 'মেয়াদ শেষ হচ্ছে ({$a})';
$string['personal'] = 'ব্যক্তিগত';
$string['personalprofile'] = 'ব্যক্তিগত বৃত্তান্ত';
$string['phone'] = 'ফোন';
$string['phone2'] = 'মোবাইল ফোন';
$string['phpinfo'] = 'পিএইচপি তথ্য';
$string['pictureof'] = '{$a} এর ছবি';
$string['pictureofuser'] = 'ব্যবহারকারী ছবি ';
$string['pleaseclose'] = 'অনুগ্রহ করে এখনই উইন্ডোটি বন্ধ করুন।';
$string['pleasesearchmore'] = 'অনুগ্রহ করে আরও কিছু অনুসন্ধান করুন';
$string['pleaseusesearch'] = 'অনুগ্রহ করে অনুসন্ধান ব্যবহার করুন';
$string['plugin'] = 'প্লাগইন';
$string['plugincheck'] = 'প্লাগইন পরীক্ষা';
$string['plugindeletefiles'] = '\'{$a->নাম}\' প্লাগইন সংশ্লিষ্ট সকল ডাটা ডাটাবেস থেকে মুছে ফেলা হয়েছে। প্লাগইনের নিজস্ব রি-ইনস্টল রোধ করতে, আপনাকে এই ডিরেক্টরি মুছে ফেলা উচিৎ আপনার সার্ভার থেকেঃ {$a->ডিরেক্টরি}';
$string['pluginsetup'] = 'প্লাগইন টেবিলের সেটিং আপ';
$string['policyaccept'] = 'আমি বুঝি এবং মত দিলাম  ';
$string['policyagree'] = 'এই সাইটের ব্যবহার চালিয়ে যাবার জন্য আপনার এই নীতিমালায় মত থাকা উচিৎ। আপনি কি রাজি?';
$string['policyagreement'] = 'সাইট নীতিমালা চুক্তি';
$string['policyagreementclick'] = 'সাইট নীতিমালা চুক্তির লিঙ্ক';
$string['popup'] = 'পপআপ';
$string['popupwindow'] = 'নতুন উইন্ডোতে ফাইল খোলা';
$string['popupwindowname'] = 'পপআপ উইন্ডো';
$string['post'] = 'পোষ্ট';
$string['posts'] = 'পোষ্ট';
$string['potentialadmins'] = 'সম্ভাব্য প্রশাসক';
$string['potentialcreators'] = 'সম্ভাব্য পাঠ্যক্রম নির্মাতা';
$string['potentialstudents'] = 'সম্ভাব্য শিক্ষার্থী';
$string['potentialteachers'] = 'সম্ভাব্য শিক্ষকবৃন্দ';
$string['preferences'] = 'পছন্দসমূহ';
$string['preferredlanguage'] = 'পছন্দসই ভাষা';
$string['preferredtheme'] = 'পছন্দসই থীম';
$string['preprocessingbackupfile'] = 'প্রিপ্রসেসিং ব্যাকআপ ফাইল';
$string['preview'] = 'প্রাকদর্শন';
$string['previewhtml'] = 'HTML ফরম্যাট প্রাকদর্শন';
$string['previeworchoose'] = 'থীম প্রাকদর্শন অথবা নির্বাচন করুন';
$string['previous'] = 'পূর্ববর্তী ';
$string['previouslyselectedusers'] = 'পূর্বের নির্বাচিত ব্যবহারকারীরা \'{$a}\' মিলছে না';
$string['previoussection'] = 'পূর্ববর্তী সেশন';
$string['primaryadminsetup'] = 'প্রশাসক একাউন্ট সেটআপ';
$string['profile'] = 'বৃত্তান্ত';
$string['profilenotshown'] = 'এই বৃত্তান্ত বর্ণনা প্রদর্শিত হবে না যতক্ষণ না পর্যন্ত এই ব্যক্তি নূন্যতম একটি পাঠ্যক্রমে তালিকাভূক্ত হচ্ছে।';
$string['publicprofile'] = 'পাবলিক প্রোফাইল';
$string['publicsitefileswarning'] = 'টীকাঃ এখানে রাখা ফাইলগুলোতে যে কেউ প্রবেশের অধিকার রাখে';
$string['publicsitefileswarning2'] = 'টীকাঃ এখানে রাখা ফাইলগুলোতে যে কেউ প্রবেশের অধিকার রাখে যারা জানে (অথবা অনুমান করতে পারে) URLটি। নিরাপত্তার জন্য, জানা দরকার যে, যে কোন যত দ্রুত সম্ভব ব্যাকআপ ফাইল মোছা তাদের পুনরুদ্ধার করার পর।';
$string['publicsitefileswarning3'] = 'টীকাঃ এখানে রাখা ফাইলগুলোতে যে কেউ প্রবেশের অধিকার রাখে যারা জানে (অথবা অনুমান করতে পারে) URLটি। <br />নিরাপত্তার জন্য, ব্যাকআপ ফাইল সংরক্ষণ করা উচিৎ শুধুমাত্র ব্যাকআপ ডাটা ফোল্ডারে।';
$string['publish'] = 'প্রকাশ';
$string['question'] = 'প্রশ্ন';
$string['questionsinthequestionbank'] = 'প্রশ্ন ব্যাংকে প্রশ্নসমূহ';
$string['readinginfofrombackup'] = 'ব্যাকআপ থেকে তথ্য পড়ছে';
$string['readme'] = 'রিডমি';
$string['recentactivity'] = 'সম্প্রতিক কার্যকলাপ';
$string['recentactivityreport'] = 'সম্পূর্ণ রিপোর্ট সম্প্রতিক কার্যকলাপের...';
$string['recipientslist'] = 'গ্রাহক তালিকা';
$string['recreatedcategory'] = 'বিভাগ {$a}পুনঃসৃষ্টি হয়েছে';
$string['redirect'] = 'প্রত্যাবর্তন';
$string['reducesections'] = 'অনুচ্ছেদের সংখ্যা কমান';
$string['refresh'] = 'রিফ্রেশ করুন';
$string['refreshingevents'] = 'ইভেন্ট রিফ্রেশ হচ্ছে';
$string['registration'] = 'মুডল নিবন্ধন';
$string['registrationcontact'] = 'জনসাধারণ থেকে পরিচিতি';
$string['registrationcontactno'] = 'না, আমি সাইট লিষ্টিং এ পরিচিতি ফরম চাই না ';
$string['registrationcontactyes'] = 'হ্যাঁ, সম্ভব্য মুডলের জন্য আমাকে পরিচিতি করতে একটি ফরম সরবরাহ করুন ';
$string['registrationemail'] = 'ইমেইল প্রজ্ঞাপণ';
$string['registrationinfo'] = '<p> এই পৃষ্ঠা আপনার মুডল সাইটের সাথে মুডল.অর্গের নিবন্ধন করতে আপনাকে অনুমতি দেয়। নিবন্ধন মুক্ত।
 নিবন্ধনের মূল সুবিধা হল এই আপনাকে লো-ভলিউম মেইলিং তালিকায় আপনাকে যুক্ত করা হবে
গুরুত্বপূর্ণ প্রজ্ঞাপণ যেমন নিরাপত্তা সংকেত এবং নতুন প্রকাশিত মুডল।</p>
<p>নিয়ম অনুযায়ী, আপনার তথ্য একান্ত ভাবে রাখা হবে, এবং কখনো কাউকেই বিক্রয় বা বিলি করা হবে না। শুধুমাত্র
 এই তথ্য আহরনের কারন হল সহায়ক উদ্দেশ্যে, এবং সামগ্রিকভাবে মুডল কমিউনিটির একটি পরিসংখ্যান সংক্রান্ত
 ধারনা গঠনে সাহায্য করা।</p>
<p>যদি আপনি নির্বাচন করেন, আপনি আপনার সাইট নাম, দেশ এবং ইউআরএল মুডল সাইটের জনাসাধারন লিষ্টে যুক্ত করার জন্য অনুমতি দিতে পারেন।</p>
<p>সকল নতুন নিবন্ধন তালিকায় যুক্ত হবার পূর্বে ম্যনুয়ালি যাচাইকৃত, কিন্তু একবার যদি আপনি যোগ করেন আপনি আপনার নিবন্ধন হালনাগাদ করতে পারবেন (এবং আপনার প্রবেশ থাকবে জনাসাধারন লিষ্টে) যে কোন সময় এই ফরমটি পুনঃজমা করে।</p>';
$string['registrationinfotitle'] = 'নিবন্ধন তথ্য';
$string['registrationno'] = 'না, আমি কোন ইমেইল গ্রহণ করতে চাই না';
$string['registrationsend'] = 'নিবন্ধন তথ্য মুডল.অর্গে পাঠান ';
$string['registrationyes'] = 'হ্যাঁ, অনুগ্রহ করে আমাকে অবহিত করুন জরুরী বিষয়ে';
$string['reject'] = 'প্রত্যাখান';
$string['rejectdots'] = 'প্রত্যাখান...';
$string['reload'] = 'রিলোড';
$string['remoteappuser'] = 'রিমোট {$a} ব্যবহারকারী';
$string['remove'] = 'অপসারণ';
$string['removeadmin'] = 'প্রশাসক অপসারণ  ';
$string['removecreator'] = 'পাঠ্যক্রম নির্মাতা অপসারণ';
$string['removestudent'] = 'শিক্ষার্থী অপসারণ';
$string['removeteacher'] = 'শিক্ষক অপসারণ';
$string['rename'] = 'নামান্তর';
$string['renamefileto'] = 'নামান্তর <b>{$a}</b>';
$string['report'] = 'রিপোর্ট';
$string['reports'] = 'রিপোর্টসমূহ';
$string['repositories'] = 'ভান্ডারসমূহ';
$string['requestcourse'] = 'পাঠ্যক্রম অনুরোধ';
$string['requestedby'] = 'অনুরোধ করেছেন';
$string['requestedcourses'] = 'অনুরোধকৃত পাঠ্যক্রমসমূহ';
$string['requestreason'] = 'পাঠ্যক্রম অনুরোধের কারণ';
$string['required'] = 'আবশ্যকীয় ';
$string['requirespayment'] = 'এই পাঠ্যক্রমে প্রবেশাধিকারের জন্য প্রদেয় টাকার অঙ্ক প্রয়োজন';
$string['reset'] = 'পুনর্বিন্যাস';
$string['resetcomponent'] = 'কম্পোনেন্ট';
$string['resetcourse'] = 'পুনর্বিন্যাস পাঠ্যক্রম ';
$string['resetinfo'] = 'এই পৃষ্ঠা আপনাকে ব্যবহারকারী ডাটার একটি পাঠ্যক্রম খালি করার অনুমোদন দেয়, যতক্ষণ কার্যকলাপ ও অন্যান্য সেটিংসমূহ বজায় থাকে। অনুগ্রহ করে সতর্ক হন কারণ নিম্নের আইটেম নির্বাচন এবং
এই পৃষ্ঠা জমা দেয়ার জন্য এই পাঠ্যক্রম থেকে আপনার নির্বাচিত ব্যবহারকারী ডাটা আপনি চিরতরে মুছে দিবেন!';
$string['resetnotimplemented'] = 'পুনর্বিন্যাস বাস্তবায়িত হয় নাই';
$string['resetstartdate'] = 'শুরুর তারিখ পুনর্বিন্যাস';
$string['resetstatus'] = 'অবস্থা';
$string['resettask'] = 'কাজ';
$string['resettodefaults'] = 'বিদ্যমান পুনর্বিন্যাস ';
$string['resource'] = 'রিসোর্স দ্বন্দ্ব';
$string['resourcedisplayauto'] = 'স্বয়ংক্রিয়';
$string['resourcedisplaydownload'] = 'জোর পূর্বক ডাউনলোড';
$string['resourcedisplayembed'] = 'সন্নিবেশ করা';
$string['resourcedisplayframe'] = 'ফ্রেমে';
$string['resourcedisplaynew'] = 'নতুন উইন্ডো';
$string['resourcedisplayopen'] = 'খোলা';
$string['resourcedisplaypopup'] = 'পপ-আপে';
$string['resources'] = 'রিসোর্স দ্বন্দ্ব';
$string['resources_help'] = 'রিসোর্স দ্বন্দ্বের প্রকার সক্রিয় করে প্রায় যে কোন ধরনের ওয়েব বিষয়বস্তু যা পাঠ্যক্রমে সন্নিবিষ্ট হতে যাচ্ছে।';
$string['restore'] = 'পুনরুদ্ধার';
$string['restorecancelled'] = 'পুনরুদ্ধার বাতিল হয়েছে';
$string['restorecannotassignroles'] = 'পুনরুদ্ধারের প্রয়োজন ভূমিকা ধার্য করা এবং আপনার এটি করার অনুমতি নেই';
$string['restorecannotcreateorassignroles'] = 'পুনরুদ্ধারের প্রয়োজন ভূমিকা নির্মান অথবা ধার্য করা এবং আপনার এটি করার অনুমতি নেই';
$string['restorecannotcreateuser'] = 'পুনরুদ্ধারের প্রয়োজন ব্যাকআপ ফাইল থেকে \'{$a}\' ব্যবহারকারী তৈরী করা এবং আপনার এটি করার অনুমতি নেই';
$string['restorecannotoverrideperms'] = 'পুনরুদ্ধারের প্রয়োজন অগ্রাহ্যকর অনুমোদন এবং আপনার এটি করার অনুমতি নেই';
$string['restorecoursenow'] = 'এখনই পুনরুদ্ধার এই পাঠ্যক্রম!';
$string['restoredaccount'] = 'একাউন্ট পুনরুদ্ধার হয়েছে';
$string['restoredaccountinfo'] = 'এই একাউন্ট অন্য সার্ভার থেকে ইম্পোর্টকৃত এবং পাসওয়ার্ডটি হারিয়ে গেছে। ইমেইলের মাধ্যমে নতুন পাসওয়ার্ড নির্ধারণের জন্য, অনুগ্রহ করে ক্লিক করুন "চলবে"';
$string['restorefinished'] = 'পুনরুদ্ধার সফলভাবে সম্পন্ন হয়েছে';
$string['restoreto'] = 'পুনরুদ্ধার করুন';
$string['restoretositeadding'] = 'সতর্কীকরণঃ আপনি সাইট ফ্রন্ট পৃষ্ঠাটি পুনরুদ্ধার করতে যাচ্ছেন, এতে ডাটা যোগ হচ্ছে!';
$string['restoretositedeleting'] = 'সতর্কীকরণঃ আপনি সাইট ফ্রন্ট পৃষ্ঠাটি পুনরুদ্ধার করতে যাচ্ছেন, প্রথমে এটি হতে ডাটা মোছা হচ্ছে!';
$string['restoreuserconflict'] = 'ব্যাকআপ ফাইল থেকে ব্যবহারকারী \'{$a}\' পুনরুদ্ধারের চেষ্টা দ্বন্দ্ব ঘটাবে';
$string['restoreuserinfofailed'] = 'পুনরুদ্ধার প্রসেস বন্ধ হয়েছে কারণ আপনার ব্যবহারকারী ডাটা পুনরুদ্ধারের অনুমোদন নেই ';
$string['restoreusersprecheck'] = 'ব্যবহারকারী ডাটা পরীক্ষা করা হচ্ছে';
$string['restoreusersprecheckerror'] = 'ব্যবহারকারী ডাটা পরীক্ষা করার সময় কিছু সমস্যা সনাক্ত হয়েছে ';
$string['restricted'] = 'সীমাবদ্ধ';
$string['returningtosite'] = 'এই ওয়েব সাইটে ফেরা হচ্ছে?';
$string['returntooriginaluser'] = '{$a} এ ফেরা';
$string['revert'] = 'প্রত্যাবর্তন';
$string['role'] = 'ভূমিকা';
$string['rolemappings'] = 'ভূমিকা ম্যাপিং';
$string['rolerenaming'] = 'ভূমিকা পুনঃনামকরণ হচ্ছে';
$string['rolerenaming_help'] = 'এই সেটিং পাঠ্যক্রমে ভূমিকায় ব্যবহৃত প্রদর্শিত নামের পরিবর্তনে অনুমতি প্রদান করে। শুধুমাত্র প্রদর্শিত নাম পরিবর্তিত হয়- ভূমিকা অনুমোদন প্রভাবিত হয় না। নতুন ভূমিকা নামসমূহ পাঠ্যক্রম অংশগ্রহণকারী পৃষ্ঠায় এবং পাঠ্যক্রমের অন্যত্র দৃশ্যমান হয়। যদি পুনঃনামকরণকৃত ভূমিকা এক হয় যা প্রশাসক নির্বাচিত করেছে পাঠ্যক্রম ব্যবস্থাপক ভূমিকা হিসাবে, তাহলে নতুন ভূমিকা নাম দৃশ্যমান হবে পাঠ্যক্রম লিষ্টের অংশ হিসাবে।';
$string['roles'] = 'ভূমিকা';
$string['rss'] = 'আরএসএস';
$string['rssarticles'] = 'আরএসএস সম্প্রতিক আর্টিকেলের সংখ্যা ';
$string['rsserror'] = 'আরএসএস ডাটার ত্রুটি পড়ছে';
$string['rsserrorauth'] = 'আপনার আরএসএস লিঙ্কে বৈধ প্রমাণীকরণ টোকেন নেই।';
$string['rsserrorguest'] = 'এই ফিড অতিথি প্রবেশাধিকার ব্যবহার করে ডাটাতে প্রবেশাধিকারের জন্য , কিন্তু অতিথির অনুমোদন নেই ডাটা পড়ার। প্রদর্শন করুন মূল অবস্থান যেখান থেকে বৈধ ব্যবহারকারী হিসাবে ফিড এসেছে (URL) এবং সেখান থেকে নতুন একটা আরএসএস লিঙ্ক গ্রহণ করুন।';
$string['rsskeyshelp'] = 'নিরাপত্তা এবং গোপনীয়তা নিশ্চিতকরণ করতে, আর.এস.এস. feed ইউ.আর.এল একটি বিশেষ প্রতীক ধারণ করে যে ের জন্য ব্যবহারকারী তারা সনাক্ত করে। এইটির আর.এস.এস. হয়ে তে Moodle তারা তথ্য উদ্ধার করার এলাকা accessing থেকে অন্যান্য ব্যবহারকারী প্রতিরোধ কর জোগান দেয় না।</p><p> এই প্রতীকটি Moodleএর প্রথম বার আপনার তথ্য উদ্ধার করা একটি অঞ্চল সয়ংক্রিয়ভাবে তৈরি করা হয় যে একটি আর.এস.এস. feed তৈরি করে। যদি আপনি অনুভব করেন যে আপনার আর.এস.এস. feed প্রতীক রিসেট সংযোগ এখানে ক্লিক করার মধ্যে কিছু রাস্তা আপনার একটি নতুন একটিতে অনুরোধ করা হয়েছে compromise। দয়া করে নোট যে আপনার বর্তমান আর.এস.এস. feed ইউ.আর.এল তারপর অবৈধ হন।';
$string['rsstype'] = 'এই কার্যপ্রনালীর আরএসএস ফিড';
$string['saveandnext'] = 'সংরক্ষণ এবং প্রদর্শন পরবর্তী ';
$string['savechanges'] = 'সংরক্ষণ পরিবর্তন';
$string['savechangesanddisplay'] = 'সংরক্ষণ এবং প্রদর্শন';
$string['savechangesandreturntocourse'] = 'সংরক্ষণ এবং পাঠ্যক্রমে ফেরত';
$string['savecomment'] = 'সমালোচনা সংরক্ষণ';
$string['savedat'] = 'সংরক্ষিত হয়েছেঃ';
$string['savepreferences'] = 'পছন্দসমূহ সংরক্ষণ ';
$string['saveto'] = 'সংরক্ষণ করুন';
$string['scale'] = 'স্কেল';
$string['scale_help'] = 'একটি স্কেল একটি কার্যকলাপের মূল্যায়ন অথবা গ্রেডিং কার্যকারিতার পথ প্রদান করে। এটি নির্ধারণ করা হয় মানসমূহের ক্রম লিষ্ট দ্বারা, যার পরিসীমা ঋনাত্মক থেকে ধনাত্মক, কমা দ্বারা পৃথক, উদাহরণ সরূপ "হতাশাদায়ক, ভাল নয়, মোটামুটি ভাল, ভাল, খুব ভাল, চমৎকার!" ';
$string['scale_link'] = 'গ্রেড/স্কেল';
$string['scales'] = 'স্কেল';
$string['scalescustom'] = 'স্বনির্ধারিত স্কেল';
$string['scalescustomcreate'] = 'নতুন স্কেল যোগ';
$string['scalescustomno'] = 'কোন স্বনির্ধারিত স্কেল এখনো তৈরি করা হয় নাই';
$string['scalesstandard'] = 'আদর্শ স্কেল';
$string['scalestandard'] = 'আদর্শ স্কেল';
$string['scalestandard_help'] = 'একটি আদর্শ স্কেলে সাইট-প্রশস্ত বিদ্যমান, সকল পাঠ্যক্রমের জন্য।';
$string['scalestandard_link'] = 'গ্রেড/স্কেল';
$string['scalestip'] = 'স্বনির্ধারিত স্কেল তৈরির জন্য, আপনার পাঠ্যক্রম প্রশাসন মেনুতে \'স্কেলস...\' লিঙ্ক  ব্যবহার করুন।';
$string['scalestip2'] = 'স্বনির্ধারিত স্কেলস তৈরির জন্য, পাঠ্যক্রম প্রশাসন মেনুতে গ্রেড লিঙ্ক ক্লিক করুন, তারপর সম্পাদনা নির্বাচন করুন, স্কেলস।';
$string['schedule'] = 'সময়সূিচ';
$string['screenshot'] = 'স্ক্রীনশট';
$string['search'] = 'অনুসন্ধান';
$string['searchagain'] = 'আবার অনুসন্ধান';
$string['searchbyemail'] = 'ইমেইল ঠিকানা দিয়ে অনুসন্ধান';
$string['searchbyusername'] = 'ব্যবহারকারী নাম দিয়ে অনুসন্ধান';
$string['searchcourses'] = 'পাঠ্যক্রমসমূহ অনুসন্ধান';
$string['searchhelp'] = 'আপনি গুণিতক শব্দসমূহ এখনই অনুসন্ধান করতে পারেন।<br /><br />শব্দঃ টেক্সটের অভ্যন্তরে এই শব্দের যেকোন অনুরূপ খুঁজুন।<br />+শব্দঃ শুধুমাত্র যথার্থ সমতুল্য শব্দসমূহ খুঁজে পাওয়া যাবে।<br />-শব্দঃ এই শব্দ ধারন করে এমন ফলাফল যুক্ত করবেন না। ';
$string['search_help'] = 'টেক্সটে এক বা একাধিক শব্দের প্রাথমিক অনুসন্ধানের জন্য, তাদেরকে কমা দ্বারা পৃথক করে টাইপ করুন। ব্যবহৃত দুটি অক্ষর অপেক্ষা সকল শব্দসমূহ বড়।

 উচ্চ পর্যায়ের অনুসন্ধানের জন্য, অনুসন্ধান বোতাম চাপুন  উচ্চ পর্যায়ের অনুসন্ধান ফরমে প্রবেশাধিকারের জন্য অনুসন্ধান বাক্সে কোন কিছু টাইপ ব্যতীত।';
$string['searchoptions'] = 'অনুসন্ধান অপশন';
$string['searchresults'] = 'অনুসন্ধান ফলাফল';
$string['sec'] = 'সেকেন্ড';
$string['seconds'] = 'সেকেন্ড';
$string['secondstotime172800'] = '২ দিন';
$string['secondstotime259200'] = '৩ দিন';
$string['secondstotime345600'] = '৪ দিন';
$string['secondstotime432000'] = '৫ দিন';
$string['secondstotime518400'] = '৬ দিন';
$string['secondstotime604800'] = '১ সপ্তাহ';
$string['secondstotime86400'] = '১ দিন';
$string['secretalreadyused'] = 'পাসওয়ার্ড পরিবর্তন নিশ্চিত লিঙ্ক ইতোমধ্যে ব্যবহৃত হয়েছে, পাসওয়ার্ড পরিবর্তন হয় নাই। ';
$string['secs'] = 'সেকেন্ড';
$string['section'] = 'সেশন';
$string['sectionname'] = 'সেশন নাম';
$string['sections'] = 'সেশন';
$string['sectionusedefaultname'] = 'পূর্বনির্ধারিত সেশন নাম ব্যবহার';
$string['seealsostats'] = 'আরো দেখুনঃ স্টাটিসটিকস';
$string['selctauser'] = 'ব্যাবহারকারী নির্বাচন করুন';
$string['select'] = 'নির্বাচন করুন';
$string['selectacountry'] = 'দেশ নির্বাচন করুন';
$string['selectacourse'] = 'কোর্স নির্বাচন করুন';
$string['selectacoursesite'] = 'কোর্স বা সাইট নির্বাচন করুন';
$string['selectagroup'] = 'গ্রুপ নির্বাচন করুন';
$string['selectall'] = 'সব নির্বাচন';
$string['selectamodule'] = 'অনুগ্রহ করে একটি কার্যকলাপ মডিউল নির্বাচন করুন';
$string['selectanaction'] = 'একটি কার্য নির্বাচন করুন';
$string['selectanoptions'] = 'বিকল্পগুলি নির্বাচন করুন';
$string['selectaregion'] = 'অঞ্চল নির্বাচন';
$string['selectdefault'] = 'পূর্বনির্ধারিত নির্বাচন';
$string['selectedfile'] = 'নির্বাচিত ফাইল';
$string['selectednowmove'] = 'সরানোর জন্য {$a} ফাইলসমূহ নির্বাচিত হয়েছে। এখন গন্তব্য ফোল্ডারে যান এবং চাপুন \'ফাইল সারান এখান থেকে';
$string['selectfiles'] = 'ফাইল নির্বাচন';
$string['selectmoduletoviewhelp'] = 'এর সাহায্য দেখতে একটি মডিউল নির্বাচন করুন।';
$string['selectnos'] = 'সকল \'না\' নির্বাচন করুন';
$string['selectperiod'] = 'মেয়াদ নির্বাচন';
$string['senddetails'] = 'আমার বিস্তারিত তথ্য ইমেইলের মাধ্যমে প্রেরণ';
$string['separate'] = 'পৃথক';
$string['separateandconnected'] = 'জানার পৃথক এবং সংযুক্ত উপায়';
$string['separateandconnectedinfo'] = 'পৃথক এবং সংযুক্ত তত্ত্বের উপর ভিত্তি করে স্কেল গঠিত। এই তত্ত্ব বর্ণনা করে দুটি ভিন্ন পথ যা আমরা মূল্যায়ন করতে এবং শিখতে পারি আমাদের দেখা ও শোনা বিষয়গুলো সম্পর্কে।<ul><li><strong> পৃথক জ্ঞাতকরা</strong> যতদুর সম্ভব উদ্দেশ্য অবস্থান করে আবেগ ও অনুভূতি যুক্ত ব্যতীত। অন্যান্য ব্যাক্তিবর্গের সাথে আলোচনার ক্ষেত্রে, তারা তাদের নিজস্ব চিন্তাগুলো সমর্থন করতে পছন্দ করে, যুক্তি দিয়ে অন্যের চিন্তার দূর্বলতা খোঁজে।</li><li><strong>সংযুক্ত জ্ঞাতকরা</strong> অন্যান্য ব্যাক্তিবর্গের তুলনায় অনেক সংবেদনশীল। তারা আত্মনিবিষ্ট ক্ষমতায় দক্ষ, এবং প্রশ্ন শোনা ও জিজ্ঞাসার প্রবণতা দেখায় যতক্ষণ না পর্যন্ত তারা অনুভব করে তারা যুক্ত করতে পারবে এবং "বিষয়গুলো বোঝে তাদের প্রদর্শিত পয়েন্টে"। তারা শেখার চেষ্টা করে অভিজ্ঞতাগুলো বিনিময় করে যা জ্ঞানের নেতৃত্ব হিসেবে তারা অন্যান্য ব্যাক্তিবর্গের মাঝে পায়।</li></ul>';
$string['servererror'] = 'একটি ত্রুটি সার্ভারের সঙ্গে যোগাযোগ করার সময় ঘটেছিল';
$string['serverlocaltime'] = 'সার্ভার স্থানীয় সময়';
$string['setcategorytheme'] = 'বিভাগভিত্তিক থীম নির্ধারণ';
$string['settings'] = 'সেটিংসমূহ';
$string['shortname'] = 'ডাক নাম';
$string['shortnamecollisionwarning'] = '[*] = এই ডাক নাম ইতোমধ্যে একটি পাঠ্যক্রমে ব্যবহৃত হয়েছে এবং পরিবর্তিত করার প্রয়োজন হবে অনুমোদনের সময়।';
$string['shortnamecourse'] = 'পাঠ্যক্রম ডাক নাম';
$string['shortnamecourse_help'] = 'পাঠ্যক্রম ডাক নামটি ন্যাভিগেশনে প্রদর্শিত হচ্ছে এবং ব্যবহৃত হচ্ছে পাঠ্যক্রম ইমেইল বার্তার বিষয় লাইনে।';
$string['shortnametaken'] = 'ডাক নাম ইতোমধ্যে অন্য পাঠ্যক্রমে ({$a}) ব্যবহৃত হয়েছে';
$string['shortnameuser'] = 'ব্যবহারকারী ডাক নাম';
$string['shortsitename'] = 'সাইটের জন্য ডাক নাম (উদাহরণ একক শব্দ)';
$string['show'] = 'প্রদর্শন';
$string['showactions'] = 'কার্যকলাপ প্রদর্শন';
$string['showadvancedsettings'] = 'উচ্চ পর্যায়ের সেটিংসমূহ প্রদর্শন';
$string['showall'] = 'সব {$a} প্রদর্শন ';
$string['showallcourses'] = 'সকল পাঠ্যক্রম প্রদর্শন ';
$string['showallusers'] = 'সকল ব্যবহারকারী প্রদর্শন ';
$string['showblockcourse'] = 'পাঠ্যক্রমে ধারনকৃত ব্লকের তালিকা প্রদর্শন';
$string['showcomments'] = 'সমালোচনা প্রদর্শন/আড়াল ';
$string['showcommentsnonjs'] = 'সমালোচনা প্রদর্শন';
$string['showdescription'] = 'কোর্স পৃষ্ঠায় বিবরণ প্রদর্শন করুন';
$string['showdescription_help'] = 'যদি সক্রিয়, ভূমিকা / বর্ণনা সক্রিয়তা / পুঁজিতে সংযোগের নিচে বিষয় পাতা মাত্রে উপরে প্রদর্শন করা হবে।';
$string['showgrades'] = 'শিক্ষার্থীদের গ্রেডবুক প্রদর্শন করুন';
$string['showgrades_help'] = 'পাঠ্যক্রমের অনেক কার্যকলাপ গ্রেডকে অনুমোদন দেয় নির্ধারণ করার। এই সেটিংস নিরূপণ করে পাঠ্যক্রম প্রশাসন ব্লকে গ্রেড লিঙ্কের মাধ্যমে পাঠ্যক্রমের জন্য কোন শিক্ষার্থী তাদের সকল গ্রেডের তালিকা প্রদর্শন করতে পারে কিনা।';
$string['showlistofcourses'] = 'পাঠ্যক্রমসমূহের তালিকা প্রদর্শন';
$string['showmodulecourse'] = 'পাঠ্যক্রমসমূহের ধারনকৃত কার্যকলাপের তালিকা প্রদর্শন';
$string['showonly'] = 'শুধু প্রদর্শন';
$string['showperpage'] = '{$a}প্রদর্শন প্রতি পৃষ্ঠায়';
$string['showrecent'] = 'সাম্প্রতিক কার্যকলাপ প্রদর্শন';
$string['showreports'] = 'কার্যকলাপ রিপোর্ট প্রদর্শন';
$string['showreports_help'] = 'প্রত্যেক অংশগ্রহণকারীর জন্য কার্যক্রম রিপোর্ট বিদ্যমান যা পাঠ্যক্রমে তাদের কার্যক্রম প্রদর্শন করে। ';
$string['showsettings'] = 'সেটিংসমূহ প্রদর্শন';
$string['showtheselogs'] = 'এই লগগুলো প্রদর্শন';
$string['showthishelpinlanguage'] = 'এই সহায়তা প্রদর্শন: {$a} ভাষায়';
$string['since'] = 'থেকে';
$string['sincelast'] = 'শেষ লগইন থেকে';
$string['site'] = 'সাইট';
$string['sitedefault'] = 'সাইট পূর্বনির্ধারিত';
$string['siteerrors'] = 'সাইট ইরোর';
$string['sitefiles'] = 'সাইট ফাইলসমূহ';
$string['sitefilesused'] = 'এই পাঠ্যক্রমে ব্যবহৃত সাইট ফাইলসমূহ ';
$string['sitehome'] = 'সাইট হোম';
$string['sitelegacyfiles'] = 'উত্তরাধিকার সাইট ফাইলসমূহ';
$string['sitelogs'] = 'সাইট লগসমূহ';
$string['sitenews'] = 'সাইট সংবাদ';
$string['sitepages'] = 'সাইট পৃষ্টাসমূহ';
$string['sitepartlist'] = 'আপনার আবশ্যকীয় অনুমোদন নেই অংশগ্রহকারীদের তালিকা প্রদর্শনের';
$string['sitepartlist0'] = 'আপনাকে অংশগ্রহকারীদের তালিকা দেখার অনুমোদনে জন্য অবশ্যই একজন সাইট শিক্ষক হতে হবে';
$string['sitepartlist1'] = 'আপনাকে অংশগ্রহকারীদের তালিকা দেখার অনুমোদনে জন্য অবশ্যই একজন শিক্ষক হতে হবে';
$string['sites'] = 'সাইটসমূহ';
$string['sitesection'] = 'একটি টপিক সেশন যোগ';
$string['sitesettings'] = 'সাইট সেটিংসমূহ';
$string['siteteachers'] = 'সাইট শিক্ষনবৃন্দ';
$string['size'] = 'আকার';
$string['sizeb'] = 'বাইট';
$string['sizegb'] = 'জিবি';
$string['sizekb'] = 'কেবি';
$string['sizemb'] = 'এমবি';
$string['skipped'] = 'বাদ পড়েছে';
$string['skypeid'] = 'স্কাইপ আইডি';
$string['socialheadline'] = 'সামাজিক ফোরাম - একেবারে নতুন টপিক ';
$string['someallowguest'] = 'কিছু পাঠ্যক্রম অতিথি প্রবেশাধিকার অনুমোদন করতে পারে';
$string['someerrorswerefound'] = 'কিছু তথ্য অনুপস্থিত অথবা ভুল হয়েছে। বিস্তারিত নিম্নে দেখুন।';
$string['sortby'] = 'এই অনুযায়ী সাজান';
$string['sortbyx'] = '{$a} আরোহী অনুযায়ী সাজান';
$string['sortbyxreverse'] = '{$a}অবরোহী অনুযায়ী সাজান';
$string['sourcerole'] = 'উৎস ভূমিকা';
$string['specifyname'] = 'আপনাকে অবশ্যই একটি নাম সুনির্দিষ্টভাবে উল্লেখ করতে হবে';
$string['standard'] = 'আদর্শ';
$string['starpending'] = '([*] = পাঠ্যক্রম অমীমাংসিত অনুমোদন)';
$string['startdate'] = 'পাঠ্যক্রম শুরুর তারিখ';
$string['startdate_help'] = 'এই সেটিংস নিরূপণ করে প্রথম সপ্তাহে আরম্ভ করা একটি পাঠ্যক্রমের সাপ্তাহিক বিন্যাস। এটি আরো নিরূপণ করে প্রারম্ভিক সময় যেখানে পাঠ্যক্রম কার্যকলাপের লগসমূহ বিদ্যমান।';
$string['startingfrom'] = 'থেকে চলছে';
$string['startsignup'] = 'নতুন একাউন্ট তৈরি';
$string['state'] = 'রাষ্ট্র/প্রদেশ';
$string['statistics'] = 'পরিসংখ্যান';
$string['statisticsgraph'] = 'পরিসংখ্যানিক লেখচিত্র';
$string['stats'] = 'পরিসংখ্যান';
$string['statslogins'] = 'লগইন';
$string['statsmodedetailed'] = 'বিস্তারিত (ব্যবহারকারী) প্রদর্শন';
$string['statsmodegeneral'] = 'সাধারণ প্রদর্শন';
$string['statsnodata'] = 'পাঠ্যক্রম এবং সময় মেয়াদের ঐ সমাবেশের জন্য কোন বিদ্যমান ডাটা নেই।';
$string['statsnodatauser'] = 'পাঠ্যক্রম, ব্যবহারকারী এবং সময় মেয়াদের ঐ সমাবেশের জন্য কোন বিদ্যমান ডাটা নেই।';
$string['statsoff'] = 'পরিসংখ্যান বর্তমানে সক্রিয় নেই।';
$string['statsreads'] = 'মতামত';
$string['statsreport1'] = 'লগইন';
$string['statsreport10'] = 'ব্যবহারকারী কার্যক্রম';
$string['statsreport11'] = 'সর্বাধিক সক্রিয় পাঠ্যক্রমসমূহ';
$string['statsreport12'] = 'সর্বাধিক সক্রিয় পাঠ্যক্রমসমূহ (মূল্যবান)';
$string['statsreport13'] = 'সর্বাধিক অংশগ্রহনকারী পাঠ্যক্রমসমূহ (তালিকা)';
$string['statsreport14'] = 'সর্বাধিক অংশগ্রহনকারী পাঠ্যক্রমসমূহ (মতামত/পোষ্ট)';
$string['statsreport2'] = 'মতামত (সকল ভূমিকা)';
$string['statsreport3'] = 'পোষ্ট (সকল ভূমিকা)';
$string['statsreport4'] = 'সকল কার্যক্রম (সকল ভূমিকা)';
$string['statsreport5'] = 'সকল কার্যক্রম (মতামত ও পোষ্ট)';
$string['statsreport7'] = 'ব্যবহারকারী কার্যক্রম (মতামত ও পোষ্ট)';
$string['statsreport8'] = 'সকল ব্যবহারকারী কার্যক্রম';
$string['statsreport9'] = 'লগইন (সাইট পাঠ্যক্রম)';
$string['statsreportactivity'] = 'সকল কার্যক্রম (সকল ভূমিকা)';
$string['statsreportactivitybyrole'] = 'সকল কার্যক্রম (মতামত ও পোষ্ট)';
$string['statsreportforuser'] = 'জন্য';
$string['statsreportlogins'] = 'লগইন';
$string['statsreportreads'] = 'মতামত (সকল ভূমিকা)';
$string['statsreporttype'] = 'রিপোর্ট ধরণ';
$string['statsreportwrites'] = 'পোষ্ট (সকল ভূমিকা)';
$string['statsstudentactivity'] = 'শিক্ষার্থী কার্যক্রম';
$string['statsstudentreads'] = 'শিক্ষার্থী মতামত';
$string['statsstudentwrites'] = 'শিক্ষার্থী পোষ্ট';
$string['statsteacheractivity'] = 'শিক্ষক কার্যক্রম';
$string['statsteacherreads'] = 'শিক্ষক মতামত';
$string['statsteacherwrites'] = 'শিক্ষক পোষ্ট';
$string['statstimeperiod'] = 'সময় সীমা - শেষ';
$string['statsuniquelogins'] = 'একক লগইন';
$string['statsuseractivity'] = 'সকল কার্যক্রম';
$string['statsuserlogins'] = 'লগইন';
$string['statsuserreads'] = 'মতামত';
$string['statsuserwrites'] = 'পোষ্ট';
$string['statswrites'] = 'পোষ্ট';
$string['status'] = 'অবস্থা';
$string['stringsnotset'] = 'নিম্নোক্ত স্ট্রিংগুলো {$a} তে নির্ধারিত নয়';
$string['studentnotallowed'] = 'দুঃখিত, কিন্তু আপনি \'{$a}\' হিসেবে এই পাঠ্যক্রমে প্রবেশ করতে পারবেন না';
$string['students'] = 'শিক্ষার্থীবৃন্দ';
$string['studentsandteachers'] = 'শিক্ষার্থীবৃন্দ এবং শিক্ষকবৃন্দ';
$string['subcategories'] = 'উপ-বিভাগসমূহ';
$string['submit'] = 'জমা';
$string['success'] = 'সাফল্য';
$string['summary'] = 'সারসংক্ষেপ';
$string['summary_help'] = 'একটি সারসংক্ষেপের ধারণা হল সংক্ষিপ্ত টেক্সট যা টপিক অথবা সপ্তাহের অন্তর্ভূক্ত কার্যক্রমের জন্য শিক্ষার্থীদের তৈরি করে। টেক্সটি পাঠ্যক্রম পৃষ্ঠায় সেশন নামের নিচে প্রদর্শিত হচ্ছে।';
$string['summaryof'] = '{$a} এর সারসংক্ষেপ';
$string['supplyinfo'] = 'আরও বিস্তারিত';
$string['switchdevicedefault'] = 'প্রমিত থিমের সুইচ';
$string['switchdevicerecommended'] = 'আপনার ডিভাইসের জন্য সুপারিশকৃত থিমের সুইচ';
$string['switchrolereturn'] = 'আমার সাধারণ ভূমিকায় ফিরে যান';
$string['switchroleto'] = 'পরিবর্তন করুন ভূমিকা...';
$string['tag'] = 'ট্যাগ';
$string['tagalready'] = 'এই ট্যাগ ইতোমধ্যে বিদ্যমান';
$string['tagmanagement'] = 'যোগ/মোছা ট্যাগ ...';
$string['tags'] = 'ট্যাগ';
$string['targetrole'] = 'লক্ষ্য ভূমিকা';
$string['teacheronly'] = 'শুধুমাত্র  {$a} এর জন্য';
$string['teacherroles'] = '{$a} ভুমিকা';
$string['teachers'] = 'শিক্ষকবৃন্দ';
$string['textediting'] = 'যখন টেক্সট সম্পাদনা হচ্ছে';
$string['texteditor'] = 'আদর্শ ওয়েব রূপ ব্যবহার';
$string['textformat'] = 'সরল টেক্সট বিন্যাস';
$string['thanks'] = 'ধন্যবাদ';
$string['theme'] = 'থীম';
$string['themes'] = 'থীম';
$string['themesaved'] = 'নতুন থীম সংরক্ষিত হয়েছে';
$string['therearecourses'] = '{$a} কোর্স আছে';
$string['thereareno'] = 'এই পাঠ্যক্রম কোন {$a} নেই';
$string['thiscategorycontains'] = 'এই বিভাগ ধারণ করে';
$string['time'] = 'সময়';
$string['timezone'] = 'সময় অঞ্চল';
$string['to'] = 'প্রতি';
$string['tocreatenewaccount'] = 'নতুন একাউন্ট তৈরিতে বাদ দিন';
$string['today'] = 'আজ';
$string['todaylogs'] = 'আজকের লগ';
$string['toeveryone'] = 'প্রত্যেককে';
$string['toomanybounces'] = 'ঐ ইমেইল ঠিকানা অনেক বার বাউন্সড হয়েছে। আপনার <b>অবশ্যই</b> চালিয়ে যাওয়া জন্য এটি পরিবর্তন করতে হবে।';
$string['toomanytoshow'] = 'প্রদর্শনের জন্য বেশি সংখ্যক ব্যবহাকারী।';
$string['toomanyusersmatchsearch'] = 'বেশি সংখ্যক ব্যবহাকারী ({$a->গণনা করা}) মিলে যায় \'{$a->অনুসন্ধান করুন}';
$string['toomanyuserstoshow'] = 'প্রদর্শনের জন্য বেশি সংখ্যক ব্যবহাকারী ({$a})।';
$string['toonly'] = 'শুধুমাত্র {$a} তে';
$string['top'] = 'শীর্ষ';
$string['topic'] = 'টপিক';
$string['topichide'] = 'এই টপিক {$a} হতে আড়াল করুন';
$string['topicoutline'] = 'টপিক সীমারেখা';
$string['topicshow'] = 'এই টপিক {$a} এ প্রদর্শন করুন';
$string['total'] = 'সর্বমোট';
$string['trackforums'] = 'ফোরাম ট্র্যাকিং';
$string['trackforumsno'] = 'নাঃ আমার দেখা পেষ্টের ট্র্যাক রাখবেন না';
$string['trackforumsyes'] = 'হ্যাঁ: আমার জন্য নতুন পোষ্টগুলো হাইলাইট করুন';
$string['trysearching'] = 'অনুসন্ধানের চেষ্টা হচ্ছে ব্যতিত।';
$string['turneditingoff'] = 'সম্পাদনা বন্ধ';
$string['turneditingon'] = 'সম্পাদনা চালু';
$string['undecided'] = 'অমীমাংসিত';
$string['unfinished'] = 'অসম্পন্ন';
$string['unknowncategory'] = 'অজানা বিভাগ';
$string['unlimited'] = 'প্রচুর';
$string['unpacking'] = 'আনপ্যকিং {$a}';
$string['unsafepassword'] = 'অনিরাপদ পাসওয়ার্ড - অন্য কিছু চেষ্টা করুন';
$string['untilcomplete'] = 'সম্পন্ন না হওয়া পর্যন্ত';
$string['unusedaccounts'] = 'এ্যকাউন্ট {$a} দিনের বেশি অব্যবহৃত হয়ে আছে স্বয়ংক্রিভাবে তালিকা বাতিল হয়েছে।';
$string['unzip'] = 'আনজিপ';
$string['unzippingbackup'] = 'ব্যাকআপ আনজিপ হচ্ছে';
$string['up'] = 'উপরে';
$string['update'] = 'হালনাগাদ';
$string['updated'] = '{$a} হালনাগাদ হয়েছে';
$string['updatemymoodleoff'] = 'এই পৃষ্ঠা কাষ্টমাইজ করা বন্ধ করুন';
$string['updatemymoodleon'] = 'এই পৃষ্ঠা কাষ্টমাইজ করুন';
$string['updatemyprofile'] = 'হালনাগাদ বৃত্তান্ত';
$string['updatesevery'] = 'প্রত্যেক {$a} সেকেন্ডে হালনাগাদ';
$string['updatethis'] = '{$a} হালনাগাদ করুন';
$string['updatethiscourse'] = 'এই পাঠ্যক্রম হালনাগাদ করুন';
$string['updatinga'] = 'হালনাগাদ করা হচ্ছেঃ {$a} ';
$string['updatingain'] = 'হালনাগাদ করা হচ্ছে {$a->কি} ভিতরে {$a->ভিতরে}';
$string['upload'] = 'আপলোড';
$string['uploadafile'] = 'একটি ফাইল আপলোড';
$string['uploadcantwrite'] = 'ডিস্কে ফাইল লেখা ব্যর্থ হয়েছে';
$string['uploadedfile'] = 'ফাইল সফলভাবে আপলোড হয়েছে';
$string['uploadedfileto'] = '{$a->ফাইল} টি {$a->ডিরেক্টরি} তে আপলোড হয়েছে    ';
$string['uploadedfiletoobig'] = 'দুঃখিত, কিন্তু ঐ ফাইলের আকার অনেক বড় ( সীমা হল {$a} বাইট )';
$string['uploadextension'] = 'ফাইল আপলোড একটি পিএইচপি বর্ধিতাংশের দ্বারা থেমেছিল';
$string['uploadfailednotrecovering'] = 'আপনার ফাইল আপলোড ব্যর্থ হয়েছে কারণ ফাইলের কোন একটিতে সমস্যা আছে, {$a->নাম}।<br /> সমস্যার লগগুলো এখানেঃ<br />{$a->problem}<br />পুনরুদ্ধার হচ্ছে না।';
$string['uploadfilelog'] = '{$a} ফাইলের লগ আপলোড ';
$string['uploadformlimit'] = 'আপলোডকৃত ফাইল {$a} আকারের দ্বারা সর্বোচ্চ আকৃতি সীমা অতিক্রম করেছিল নিযুক্ত করেছিল';
$string['uploadlabel'] = 'শিরোনামঃ';
$string['uploadnewfile'] = 'নতুন ফাইল আপলোড';
$string['uploadnofilefound'] = 'কোন ফাইল পাওয়া যায় নাই - আপনি কি নিশ্চিত আপনি আপলোডের জন্য একটি নির্বাচন করেছেন?';
$string['uploadnotallowed'] = 'আপলোডের আনুমোদন নেই';
$string['uploadnotempdir'] = 'একটি অস্থায়ী ফোল্ডার অনুপস্থিত';
$string['uploadoldfilesdeleted'] = 'আপনার আপলোড অঞ্চলের পুরাতন ফাইল মুছে ফেলা হয়েছে';
$string['uploadpartialfile'] = 'ফাইল শুধুমাত্র অংশিকভাবে আপলোড হয়েছিল';
$string['uploadproblem'] = 'একটি অপরিচিত সমস্যা হয়েছে \'{$a}\' ফাইল আপলোডের সময় ( সম্ভবত এটি বেশ বড় ছিল?)';
$string['uploadrenamedchars'] = 'ফাইলের নতুন নামকরন হয়েছে {$a->পুরাতননাম} থেকে {$a->নতুননাম} অকার্যকর অক্ষরের কারনে।';
$string['uploadrenamedcollision'] = 'ফাইলের নতুন নামকরন হয়েছে {$a->পুরাতননাম} থেকে {$a->নতুননাম} কারন সেখানে ফাইল নামের দ্বন্দ্ব আছে।';
$string['uploadserverlimit'] = 'আপলোডকৃত ফাইল সার্ভারের নির্ধারিত সর্বোচ্চ আকার সীমা অতিক্রম করেছে';
$string['uploadthisfile'] = 'এই ফাইল আপলোড';
$string['url'] = 'URL';
$string['used'] = 'ব্যবহৃত হয়েছে';
$string['usedinnplaces'] = '{$a} স্থানে ব্যবহৃত হয়েছে';
$string['usemessageform'] = 'অথবা নির্বাচিত শিক্ষার্থীদের বার্তা প্রেরণ করার জন্য নিম্নের ফরমটি ব্যবহার করুন';
$string['user'] = 'ব্যবহারকারী';
$string['userconfirmed'] = '{$a} নিশ্চিত হয়েছে';
$string['usercurrentsettings'] = 'আমার বৃত্তান্ত সেটিংসমূহ';
$string['userdata'] = 'ব্যবহারকারী ডাটা';
$string['userdeleted'] = 'এই ব্যবহারকারী এ্যকাউন্ট মুছে ফেলা হয়েছে';
$string['userdescription'] = 'বর্ণনা';
$string['userdescription_help'] = 'এই বাক্স আপনাকে আপনার সম্পর্কিত কিছু টেক্সট দিতে সক্রিয় করে যা পরে অন্যদের প্রদর্শনের জন্য আপনার বৃত্তান্ত পৃষ্ঠায় প্রদর্শিত হবে।';
$string['userdetails'] = 'ব্যবহারকারী বিস্তারিত';
$string['userfiles'] = 'ব্যবহারকারী ফাইলসমূহ';
$string['userlist'] = 'ব্যবহারকারী তালিকা';
$string['username'] = 'ব্যবহারকারীনাম';
$string['usernameemailmatch'] = 'ব্যবহারকারীনাম এবং ইমেইল ঠিকানাটি একই ব্যবহারকারী সম্পর্কিত নয়।';
$string['usernameexists'] = 'এই ব্যবহারকারীনাম ইতোমধ্যে বিদ্যমান, অন্য কিছু নির্বাচন করুন';
$string['usernamelowercase'] = 'শুধুমাত্র ছোট হাতের অক্ষরগুলো অনুমোদিত';
$string['usernamenotfound'] = 'ডাটাবেস ব্যবহারকারীনাম পাওয়া যায় নাই।';
$string['usernameoremail'] = 'ব্যবহারকারীনাম অথবা ইমেইল ঠিকানার যে কোন একটি দিন';
$string['usernotconfirmed'] = '{$a} নিশ্চিত করতে পারে নাই';
$string['userpic'] = 'ব্যবহারকারী ছবি';
$string['users'] = 'ব্যবহারকারী';
$string['userselectorautoselectunique'] = 'যদি অনুসন্ধানে শুধু একজন ব্যবহারকারী মিল পায়, স্বয়ংক্রিভাবে তাদেরকে নির্বাচন করুন';
$string['userselectorpreserveselected'] = 'নির্বাচিত ব্যবহারকারীদের রাখুন, যদিও তারা আর অনুসন্ধানে মিলবে না';
$string['userselectorsearchanywhere'] = 'ব্যবহারকারীর নামের যে কোন খানে অনুসন্ধান টেক্সটটি মিল করুন ';
$string['usersnew'] = 'নতুন ব্যবহারকারীরা';
$string['usersnoaccesssince'] = 'এর চেয়ে বেশি নিস্ক্রিয়';
$string['userswithfiles'] = 'ব্যবহারকারী সাথে ফাইল ';
$string['useruploadtype'] = 'ব্যবহারকারী আপলোডের ধরণঃ {$a}';
$string['userviewingsettings'] = '{$a} জন্য বৃত্তান্ত সেটিংসমূহ';
$string['userzones'] = 'ব্যবহারকারী অঞ্চলসমূহ';
$string['usetheme'] = 'থিম ব্যবহার';
$string['usingexistingcourse'] = 'বিদ্যমান পাঠ্যক্রম ব্যবহৃত হচ্ছে';
$string['valuealreadyused'] = 'এই মান ইতোমধ্যে ব্যবহৃত হয়েছে।';
$string['version'] = 'সংস্করণ';
$string['view'] = 'প্রদর্শন';
$string['viewallcourses'] = 'সকল পাঠ্যক্রম প্রদর্শন';
$string['viewallcoursescategories'] = 'সকল পাঠ্যক্রম এবং বিভাগ প্রদর্শন';
$string['viewfileinpopup'] = 'পপআপ উইন্ডোতে ফাইল প্রদর্শন';
$string['viewprofile'] = 'বৃত্তান্ত প্রদর্শন';
$string['views'] = 'পদর্শন';
$string['viewsolution'] = 'সমাধান প্রদর্শন';
$string['virusfound'] = 'মনোযোগ প্রশাসক! Clam AV বিষয় {$a- > course}এর জন্য {$a- > user}এর মধ্যে একটি ফাইলে একটি ভাইরাস খুঁজে পেয়েছে আপলোড করেছে। clamscanএর বেলুতো এখানে:';
$string['virusfoundlater'] = 'একটি ফাইল আপনি {$a->তারিখ} এ আপলোড করেছেন {$a->ফাইলনাম} ফাইল নামে {$a->পাঠ্যক্রম} পাঠ্যক্রমের জন্য তার মধ্যে একটি ভাইরাস পাওয়া গেছে। এখানে আপনার ফাইলের কি অবস্থা তার একটি একটি সারসংক্ষেপঃ

{$a->করণীয়}

যদি এটি প্রদানযোগ্য কাজ হয়, আপনি এটি পুনঃপ্রদান করতে পারেন যাতে আপনার শিক্ষক এটি দেখতে পারে।';
$string['virusfoundlateradmin'] = 'প্রশাসকের দৃষ্টি আকর্ষণ! একটি ফাইল {$a->তারিখ} এ আপলোড করেছে {$a->ফাইলনাম} ফাইল নামে {$a->পাঠ্যক্রম} পাঠ্যক্রমের জন্য ব্যবহারকারী {$a->ব্যবহারকারী}দ্বারা তার মধ্যে একটি ভাইরাস পাওয়া গেছে। এখানে আপনার ফাইলের কি অবস্থা তার একটি একটি সারসংক্ষেপঃ

{$a->করণীয়}

ব্যবহারকারীকে অবহিত করা হয়েছে।';
$string['virusfoundlateradminnolog'] = 'প্রশাসকের দৃষ্টি আকর্ষণ! একটি ফাইল আপলোড করা হয়েছে {$a->ফাইলনাম} ফাইল নামে তার মধ্যে একটি ভাইরাস পাওয়া গেছে। মুডল অপারগ ছিল এই ফাইল পুনঃসমাধান করে এর আসল আপলোডকারীকে ফেরত পাঠানো।

এখানে আপনার ফাইলের কি অবস্থা তার একটি একটি সারসংক্ষেপঃ

{$a->করণীয়}';
$string['virusfoundsubject'] = '{$a}: ভাইরাস পাওয়া গেছে';
$string['virusfounduser'] = 'যে ফাইলটি আপনি আপলোড করেছেন, {$a->ফাইলনাম}, একটি ভাইরাস চেকার দ্বারা স্ক্যান হয়েছে এবং আক্রান্ত দেখা যাচ্ছে! আপনার ফাইল আপলোড সফল হয় নাই।';
$string['virusplaceholder'] = 'এই আপলোডকৃত ফাইলে একটি ভাইরাস দেখা যাচ্ছে এবং অপসারণ অথবা মুছে ফেলা হয়েছে এবং ব্যবহারকারী অবহিত হয়েছে।';
$string['visible'] = 'দৃশ্যমান';
$string['visible_help'] = 'এই সেটিংসটি নিরূপন করে পাঠ্যক্রমের লিষ্টে পাঠ্যক্রম দৃশ্যমান হয় কি না। শিক্ষক এবং প্রশাসক দূরত্ব থেকে ব্যবহারকারীর অনুমোদন নেই পাঠ্যক্রমটিতে প্রবেশের।   ';
$string['visibletostudents'] = '{$a} এ দৃশ্যমান';
$string['warning'] = 'সতর্ক সংকেত';
$string['warningdeleteresource'] = 'সতর্কীকরণঃ {$a} রিসোর্স দ্বন্দ্বে সিদ্ধান্তের জন্য পাঠানো হয়েছে। আপনি কি রিসোর্স দ্বন্দ্বটি হালনাগাদ করতে চান?';
$string['webpage'] = 'ওয়েব পেজ';
$string['week'] = 'সপ্তাহ';
$string['weekhide'] = '{$a} থেকে এই সপ্তাহ আড়াল করুন';
$string['weeklyoutline'] = 'সাপ্তাহিক রূপরেখা';
$string['weeks'] = 'সপ্তাহগুলি';
$string['weekshow'] = 'এই সপ্তাহে {$a} প্রদর্শন করুন';
$string['welcometocourse'] = 'স্বাগতম {$a}';
$string['welcometocoursetext'] = 'স্বাগতম {$a->পাঠ্যক্রমনাম}!

যদি আপনি ইতোমধ্যে তা না করে থাকেন, আপনার বৃত্তান্ত পৃষ্ঠা আপনার সম্পাদনা করা উচিৎ এই কারনে যে আমরা অাপনার সম্পর্কে আরো জানতে পারিঃ

  {$a->profileurl}';
$string['whattocallzip'] = 'আপনি কি চান ZIP ফাইলটিকে কল করতে?';
$string['whattodo'] = 'কি করি';
$string['windowclosing'] = 'এই উইন্ডো স্বয়ংক্রিভাবে বন্ধ হওয়া উচিৎ। যদি না হয়, অনুগ্রহ করে বন্ধ করুন এখনই।';
$string['withchosenfiles'] = 'নির্বাচিত ফাইলের সাথে';
$string['withdisablednote'] = '{$a} (নিষ্ক্রিয়)';
$string['withoutuserdata'] = 'ব্যবহারকারী ডাটা ব্যতীত';
$string['withselectedusers'] = 'নির্বাচিত ব্যবহারকারীদের সাথে...';
$string['withselectedusers_help'] = '* বার্তা প্রেরণ - এক অথবা ততোধিক অংশগ্রহণকারীকে বার্তা পাঠানোর জন্য‌
* একটি নতুন টীকা যোগ - একটি নির্বাচিত অংশগ্রহণকারী সাথে টীকা যোগ করার জন্য
* একটি সাধারণ টীকা যোগ - একের অধিক অংশগ্রহণকারীর সাথে একই টীকা যোগ করার জন্য
* বর্ধিতাংশ তালিকাভুক্তি (প্রত্যেকে) - বর্ধিতাংশের একটি নির্বাচিত শিক্ষার্থী পাঠ্যক্রমটিতে প্রবেশাধিকার, এমনকি যখন একটি তালিকাভুক্তি মেয়াদ নির্ধারণ হয়
*  বর্ধিতাংশ তালিকাভুক্তি (সাধারণ) - বর্ধিতাংশের একের অধিক শিক্ষার্থী পাঠ্যক্রমটিতে প্রবেশাধিকার একই মূল্য মানের সাহায্যে';
$string['withuserdata'] = 'ব্যবহারকারী ডাটার সাথে';
$string['wordforstudent'] = 'আপনার শব্দ শিক্ষার্থীর জন্য ';
$string['wordforstudenteg'] = 'উদাহরণ শিক্ষার্থী, অংশগ্রহণকারী ইত্যাদি';
$string['wordforstudents'] = 'আপনার শব্দ শিক্ষার্থীদের জন্য ';
$string['wordforstudentseg'] = 'উদাহরণ শিক্ষার্থীরা, অংশগ্রহণকারীরা ইত্যাদি';
$string['wordforteacher'] = 'আপনার শব্দ শিক্ষকের জন্য ';
$string['wordforteachereg'] = 'উদাহরণ শিক্ষক, গৃহশিক্ষক, সহায়তাকারী ইত্যাদি';
$string['wordforteachers'] = 'আপনার শব্দ শিক্ষকবৃন্দের জন্য';
$string['wordforteacherseg'] = 'উদাহরণ শিক্ষকবৃন্দ, গৃহশিক্ষকবৃন্দ, সহায়তাকারীরা ইত্যাদি';
$string['writingblogsinfo'] = 'ব্লগ তথ্য লেখা হচ্ছে';
$string['writingcategoriesandquestions'] = 'বিভাগ ও প্রশ্ন লেখা হচ্ছে';
$string['writingcoursedata'] = 'পাঠ্যক্রম ডাটা লেখা হচ্ছে';
$string['writingeventsinfo'] = 'ইভেন্ট তথ্য লেখা হচ্ছে';
$string['writinggeneralinfo'] = 'সাধারণ তথ্য লেখা হচ্ছে';
$string['writinggradebookinfo'] = 'গ্রেডবুক তথ্য লেখা হচ্ছে';
$string['writinggroupingsgroupsinfo'] = 'গ্রুপিংস-গ্রুপস তথ্য লেখা হচ্ছে';
$string['writinggroupingsinfo'] = 'গ্রুপিংস তথ্য লেখা হচ্ছে';
$string['writinggroupsinfo'] = 'গ্রুপস তথ্য লেখা হচ্ছে';
$string['writingheader'] = 'শীর্ষচরণ লেখা হচ্ছে';
$string['writingloginfo'] = 'লগ তথ্য লেখা হচ্ছে';
$string['writingmessagesinfo'] = 'বার্তা তথ্য লেখা হচ্ছে';
$string['writingmoduleinfo'] = 'মডিউল তথ্য লেখা হচ্ছে';
$string['writingscalesinfo'] = 'স্কেল তথ্য লেখা হচ্ছে';
$string['writinguserinfo'] = 'ব্যবহারকারী তথ্য লেখা হচ্ছে';
$string['wrongpassword'] = 'এই ব্যবহারকারী জন্য ভুল পাসওয়ার্ড';
$string['yahooid'] = 'Yahoo আইডি';
$string['year'] = 'বছর';
$string['years'] = 'বছর';
$string['yes'] = 'হ্যাঁ';
$string['youareabouttocreatezip'] = 'আপনি  ZIP ফাইল কন্টেনিং তৈরির প্রায় কাছাকাছি ';
$string['youaregoingtorestorefrom'] = 'আপনি পুনরুদ্ধার প্রসেস তৈরির প্রায় কাছাকাছি ';
$string['youneedtoenrol'] = 'ঐ কাজ সম্পাদনের জন্য আপনাকে এই পাঠ্যক্রমে তালিকাভূক্তির প্রয়োজন।';
$string['yourlastlogin'] = 'আপনার শেষ লগইন ছিল';
$string['yourself'] = 'নিজের';
$string['yourteacher'] = 'আপনার {$a}';
$string['yourwordforx'] = 'আপনার শব্দ \'{$a}\' জন্য ';
$string['zippingbackup'] = 'ব্যাকআপ জিপ হচ্ছে';
