<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'প্রবেশাধিকার প্রত্যাখ্যাত';
$string['accounts'] = 'অ্যাকাউন্ট';
$string['addcategory'] = 'একটি বিভাগ যোগ করুন';
$string['additionalhtml'] = 'অতিরিক্ত এইচটিএমএল';
$string['additionalhtml_desc'] = 'এই মানসমূহ এইচটিএমএল উল্লেখ করতে আপনাকে অনুমোদন করে যে আপনি প্রতি পাতাতে চান যোগ করুন। আপনি এইচটিএমএল নিযুক্ত করতে পারেন যে পাতার জন্য মাথা ট্যাগের মধ্যে যোগ করা হবে, দেহ ট্যাগের পরে তৎক্ষণাত খোলা হয়েছে, অথবা সংস্থা ট্যাগার পূর্বে তৎক্ষণাত বন্ধ করা হয়।<br /> করা কি এইটি প্রতি পাতা আপনাকে প্রথা হেডার অথবা footers অনুমোদন করে যোগ করে, অথবা গুগল Analytics খুব সহজভাবের মত পরিষেবার জন্য সমর্থন যোগ করুন এবং আপনারের স্বাধীন থিম বেছে নিয়েছিল।';
$string['additionalhtmlfooter'] = 'পূর্বে BODY বন্ধ করা হয়েছিল';
$string['additionalhtmlfooter_desc'] = 'ভিতরের উপাদান সংস্থা ট্যাগার পূর্বে প্রতি পাতা অধিকারের দিকে এখানে যোগ করা হবে বন্ধ করা হবে।';
$string['additionalhtmlhead'] = 'HEAD এর মধ্যে';
$string['additionalhtmlhead_desc'] = 'ভিতরের উপাদান প্রতি পাতার জন্য HEAD tag এর তলাতে এখানে যোগ করা হবে।';
$string['additionalhtml_heading'] = 'অতিরিক্ত এইচটিএমএল প্রতি পাতাতে যোগ করা হয়েছিল।';
$string['additionalhtmltopofbody'] = 'যখন বডি হয় উম্মুক্ত';
$string['additionalhtmltopofbody_desc'] = 'ভিতরের উপাদান আরম্ভ সংস্থা ট্যাগের পরে প্রতি পাতা তৎক্ষণাতের দিকে এখানে যোগ করা হবে।';
$string['admincategory'] = 'ক্যাটাগরিঃ {$a}';
$string['adminseesall'] = 'প্রশাসন সব দেখে';
$string['adminseesallevents'] = 'প্রশাসক সব ইভেন্ট দেখে';
$string['adminseesownevents'] = 'প্রশাসকরা অন্যান্য ব্যবহারকারীর মতই';
$string['advancedfeatures'] = 'উচ্চপর্যায়ের বৈশিষ্ট্য';
$string['allcountrycodes'] = 'সব দেশের কোড';
$string['allowbeforeblock'] = 'অনুমোদিত তালিকা প্রথমে প্রক্রিয়াধীন করা হবে';
$string['allowbeforeblockdesc'] = 'পূর্বনির্ধারিতভাবে, ব্লককৃত IP তালিকার ভুক্তিগুলো প্রথমে মেলানো হয়। এই অপশনটি সক্রিয় করা হলে, অনুমোদিত IP তালিকার ভুক্তিগুলো ব্লককৃত তালিকার আগে প্রক্রিয়াধীন করা হবে।';
$string['allowblockstodock'] = 'ব্লককে ডক ব্যবহার করার অনুমোদন দেয়া হবে';
$string['allowcategorythemes'] = 'শ্রেণীবিভাগের থীম অনুমোদন';
$string['allowcoursethemes'] = 'কোর্সের থীম অনুমোদন';
$string['allowediplist'] = 'IP তালিকা অনুমোদন';
$string['allowemailaddresses'] = 'অনুমোদনকৃত ইমেইল ডোমেইন';
$string['allowframembedding'] = 'ফ্রেম সন্নিবেশন অনুমোদন করুন';
$string['allowframembedding_help'] = 'বাহ্যিক স্থানে কাঠামোতে এই সাইটটির সন্নিবেশন অনুমোদন করুন। নিরাপত্তা কারণের জন্য এই বৈশিষ্ট্যটির সক্রিয় করা হচ্ছে সুপারিশ করা হচ্ছে না।';
$string['allowguestmymoodle'] = 'আমার Moodle তে অতিথির ব্রাউজিং অনুমোদিত';
$string['allowobjectembed'] = 'EMBED ও OBJECT ট্যাগ অনুমোদন';
$string['allowthemechangeonurl'] = 'URL এ থীম পরিবর্তন অনুমোদন';
$string['allowuserblockhiding'] = 'ব্যবহারকারীকে ব্লক আড়াল করার অনুমোদন';
$string['allowuserswitchrolestheycantassign'] = 'ভূমিকাহীন ব্যবহারকারীদের ভূমিকা পরিবর্তন করার অনুমোদন';
$string['allowuserthemes'] = 'ব্যবহারকারী থীম অনুমোদন';
$string['antivirus'] = 'অ্যান্টি-ভাইরাস';
$string['appearance'] = 'অবয়ব';
$string['aspellpath'] = 'অ্যাস্পেলের পাথ';
$string['authentication'] = 'প্রমাণীকরণ';
$string['authpreventaccountcreation'] = 'গণনা সৃষ্টি প্রতিরোধ করুন যখন authenticating';
$string['authpreventaccountcreation_help'] = 'কখন একটি ব্যবহারকারী authenticatesয়, সাইটে একটি গণনা সয়ংক্রিয়ভাবে তৈরি করা হয় যদি এইটি এখনও রয়েছে না। যদি একটি বাহ্যিক ডেটাবেস, যেমন এল-ডি-এ-পি, পরিচয় প্রমাণ প্রক্রিয়ার জন্য ব্যবহার করা হয়, কিন্তু আপনি একটি বিদ্যমান গণনা, কেবলের সঙ্গে ব্যবহারকারীতে সাইটে তথ্য উদ্ধার করা নিয়ন্ত্রণ করতে ইচ্ছা করুন তারপর এই পছন্দটির সক্রিয় করা উচিত। নতুন অ্যাকাউন্ট হ তৈরি করতে নিজহাতে প্রয়োজন বোধ করবে অথবা আপলোড ব্যবহারকারী হয়ে বৈশিষ্ট্যয়। নোট যে এই মানসমূহটি MNet পরিচয় প্রমাণ প্রক্রিয়াতে প্রয়োগ করে না।';
$string['authsettings'] = 'প্রমাণীকরণ ব্যবস্থাপনা';
$string['autolang'] = 'স্বয়ংক্রিয় ভাষা শনাক্তকরণ';
$string['autologinguests'] = 'অতিথিদের স্বয়ংক্রিয়-লগইন';
$string['availablelicenses'] = 'বিদ্যমান লাইসেন্স';
$string['availableto'] = 'যেখানে বিদ্যমান';
$string['backgroundcolour'] = 'স্বচ্ছ রং';
$string['backups'] = 'ব্যাকআপ';
$string['backup_shortname'] = 'ব্যাকআপ ফাইলের নামে বিষয় নাম ব্যবহার করুন';
$string['backup_shortnamehelp'] = 'ব্যাকআপ ফাইলের নামের খন্ড হিসেবে বিষয় নাম ব্যবহার করুন।';
$string['badwordsconfig'] = 'কমা দিয়ে পৃথককৃত খারাপ শব্দের তালিকা এখানে দিন।';
$string['badwordsdefault'] = 'স্বনির্ধারিত তালিকা ফাঁকা থাকলে, ল্যাংগুয়েজ প্যাক থেকে পূর্বনির্ধারিত তালিকা ব্যবহার করা হবে।';
$string['badwordslist'] = 'স্বনির্ধারিত খারাপ শব্দের তালিকা';
$string['blockediplist'] = 'ব্লককৃত IP\'র তালিকা';
$string['blockeditingmenu'] = 'সম্পাদনা মেনু বন্ধ';
$string['blockinstances'] = 'দৃষ্টান্ত';
$string['blockmultiple'] = 'একাধিক';
$string['blockprotect'] = 'প্রতিরক্ষা করা উদাহরণ';
$string['blockprotect_help'] = 'যদি আপনি বনধ্,এর একটি নির্দিষ্ট ধরন লক করেন তারপর no-one যোগ করতে সক্ষম হবেন অথবা উদাহরণ মুছে ফেলুন। (আপনি, বিষয়ের, পুনরায় আনলক করেন যদি আপনি instances. সম্পাদনা করতে প্রয়োজন বোধ করেন)

এইটি দিক নির্নয়ের মত প্রতিরক্ষা কর বাধা দিতে উদ্দেশ্য থাকা হয় এবং মানসমূহ যেটি পিছনে পেতে খুব শক্ত আছে যদি দৈবক্রমে মুছে ফেলা হয়েছে।';
$string['blocksettings'] = 'ব্লক ব্যবস্থাপনা';
$string['blockunprotect'] = 'অরক্ষিত';
$string['bloglevel'] = 'ব্লগের দৃশ্যমানতা';
$string['bookmarkadded'] = 'বুকমার্ক যোগ করা হয়েছে।';
$string['bookmarkalreadyexists'] = 'আপনি এই পৃষ্ঠাটি ইতিমধ্যেই বুকমার্ক করেছেন।';
$string['bookmarkdeleted'] = 'বুকমার্ক মুছে ফেলা হয়েছে।';
$string['bookmarkthispage'] = 'এই পৃষ্ঠা বুকমার্ক';
$string['cacheapplication'] = 'অ্যাপলিকেশন ক্যাশ';
$string['cacheapplicationhelp'] = 'ক্যাশ-কৃত পদগুলো সমস্ত ব্যবহারকারী জন্য ভাগাভাগি করা হচ্ছে এবং একটি বদ্ধপরিকর ttlএর দ্বারা তামাদি হন।';
$string['cachejs'] = 'ক্যাশে জাভাস্ক্রিপ্ট';
$string['cachejs_help'] = 'জাভাস্ক্রিপ্টের ক্যাশিং ও সংকোচন পৃষ্ঠা লোড হওয়ার গতিকে অনেকাংশে বৃদ্ধি করে। প্রোডাকশন সাইটের জন্য এটি জোড়ালোভাবে সুপারিশ করা হচ্ছে। ডেভেলপাররা হয়ত এই বৈশিষ্ট্যটি নিষ্ক্রিয় করতে চাইবেন।';
$string['cacherequest'] = 'অনুরোধ ক্যাশ';
$string['cacherequesthelp'] = 'ব্যবহারকারী নির্দিষ্ট ক্যাশ যে তামাদি হয় যখন অনুরোধ সম্পূর্ণ।এলাকা প্রতিস্থাপন করতে Designed যেখানে আমরা স্থির জমিয়ে রাখে ব্যবহার করছি।';
$string['cachesession'] = 'সেশন ক্যাশ';
$string['cachesessionhelp'] = 'ব্যবহারকারী নির্দিষ্ট ক্যাশ যে তামাদি হয় যখন ব্যবহারকারী অধিবেশন শেষ। অধিবেশন bloat/strain aleviateতে Designed।';
$string['cachesettings'] = 'ক্যাশ মানসমূহ';
$string['cachetext'] = 'টেক্সট ক্যাশে লাইফটাইম';
$string['caching'] = 'ক্যাসিং';
$string['calendarexportsalt'] = 'ক্যালেন্ডার এক্সপোর্ট সল্ট';
$string['calendarsettings'] = 'ক্যালেন্ডার';
$string['calendar_weekend'] = 'ছুটির দিন';
$string['cannotdeletemodfilter'] = 'আপনি \'{$a->filter}\' আনইনস্টল করতে পারেন না কারণ এটি \'{$a->module}\' মডিউলের অংশ।';
$string['cannotuninstall'] = '{$a} আন-ইনষ্টলকৃত নয়';
$string['cfgwwwrootslashwarning'] = 'আপনি config.php ফাইলে $CFG->wwwroot ভুলভাবে নির্দেশ করেছেন। আপনি শেষে \'/\' চিহ্ন দিয়েছেন। অনুগ্রহ করে এটি অপসারণ করুন, নতুবা আপনি <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a> এর মত অস্বাভাবিক বাগের সম্মুখীন হতে পারেন।';
$string['cfgwwwrootwarning'] = 'আপনি config.php ফাইলে $CFG->wwwroot ভুলভাবে নির্দেশ করেছেন। আপনি এই পৃষ্ঠায় প্রবেশ করার জন্য যে URL ব্যবহার করেছেন, এটি তার সাথে মেলেনি। অনুগ্রহ করে এটি সঠিক করুন, নতুবা আপনি <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a> এর মত অস্বাভাবিক বাগের সম্মুখীন হতে পারেন।';
$string['change'] = 'পরিবর্তন';
$string['checkboxno'] = 'না';
$string['checkboxyes'] = 'হ্যাঁ';
$string['choosefiletoedit'] = 'সম্পাদনার জন্য ফাইল নির্বাচন';
$string['clamfailureonupload'] = 'ক্ল্যামে AV ব্যর্থ';
$string['cleanup'] = 'পরিষ্কার';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'ত্রুটি, "{$a->option}"-র জন্য "{$a->value}" ভুল মান ';
$string['cliincorrectvalueretry'] = 'ভুল মান, অনুগ্রহ করে আবার চেষ্টা করুন';
$string['clistatusdisabled'] = 'অবস্থা: নিষ্ক্রিয়';
$string['clistatusenabled'] = 'অবস্থা: সক্রিয়';
$string['clistatusenabledlater'] = 'অবস্থা: CLI রক্ষণাবেক্ষণ মোড {$a} সক্রিয় করা হবে';
$string['clitypevalue'] = 'ধরনের মান';
$string['clitypevaluedefault'] = 'ধরনের মান, পূর্বনির্ধারিত মান ({$a}) ব্যবহার করতে এন্টার (Enter) চাপুন';
$string['cliunknowoption'] = 'অচেনা অপশন:
  {$a}
অনুগ্রহ করে --সহায়তা অপশন ব্যবহার করুন।';
$string['cliupgradefinished'] = 'কমান্ড লাইনের আপগ্রেড সফলভাবে সম্পন্ন হয়েছে।';
$string['cliupgradenoneed'] = 'কোনও উন্নতকরণ ইনস্টলকৃত সংস্করণ {$a}এর জন্য প্রয়োজন বোধ করেনি। যেকোন উপায়ে আসের জন্য ধন্যবাদ!';
$string['cliyesnoprompt'] = 'y (মানে হ্যাঁ) বা n (মানে না) টাইপ করুন';
$string['commentsperpage'] = 'প্রতি পৃষ্ঠায় প্রদর্শিত কমেন্ট';
$string['commonfiltersettings'] = 'পরিশোধকের সাধারণ সেটিং';
$string['commonsettings'] = 'সাধারণ সেটিং';
$string['componentinstalled'] = 'উপাদান ইনস্টল করা হয়েছে';
$string['computedfromlogs'] = '{$a}\'র লগ থেকে গণনা করা হয়েছে।';
$string['condifmodeditdefaults'] = 'আপনি নতুন কোন কাজ তৈরি করার সময় থেকে এখানে নির্ধারিত মানগুলো পূর্বনির্ধারিত মান হিসেবে সক্রিয়তা সেটিং এ ব্যবহৃত হবে। এখানে কোন কোন সক্রিয়তা সেটিং উচ্চপর্যায়ের হিসেবে বিবেচিত হবে আপনি সেটাও নির্ধারণ করতে পারেন।';
$string['confeditorhidebuttons'] = 'HTML সম্পাদকে যেসব বোতাম আড়াল রাখতে চান সেগুলো নির্বাচন করুন।';
$string['configallcountrycodes'] = 'এখানে কিছু দেশের তালিকা রয়েছে যা বিভিন্ন জায়গায় নির্বাচিত হবে, উদাহরণস্বরূপ ব্যবহারকারীর প্রোফাইলে। এটি ফাঁকা (পূর্বনির্ধারিত) থাকলে, স্ট্যান্ডার্ড ইংরেজি ল্যাংগুয়েজ প্যাকের countries.php ফাইলে বিদ্যমান তালিকা ব্যবহৃত হবে। এই তালিকাটি ISO 3166-1 থেকে নেয়া। অন্যথায়, আপনি কমা দ্বারা পৃথককৃত কোডের তালিকা নির্ধারণ করে দিতে পারেন, উদাহরণস্বরূপ \'GB,FR,ES\'। আপনি যদি নতুন, কোন নন-স্ট্যান্ডার্ড কোড যোগ করেন, আপনাকে এটা \'en\' এবং আপনার ল্যাংগুয়েজ প্যাকের অধীনে countries.php ফাইলে যোগ করতে হবে।';
$string['configallowassign'] = 'বাম দিকে ভূমিকা রয়েছে এমন কয়েকজনকে আপনি কলামের ভূমিকায় আরও কয়েকজনকে নিয়োগ দেয়ার অনুমতি দিতে পারেন';
$string['configallowblockstodock'] = 'এটি সক্রিয় করা হলে এবং নির্বাচিত থীম দ্বারা সমর্থিত হলে, ব্যবহারকারীরা ব্লকগুলোকে বিশেষ ডকে সরাতে পারবেন।';
$string['configallowcategorythemes'] = 'আপনি এটি সক্রিয় করলে, ক্যাটাগরি লেভেলে থীম নির্ধারণ করা যাবে। এটি সব চাইল্ড ক্যাটাগরি ও কোর্সে প্রভাব ফেলবে যদি না তাদের থীম বিশেষভাবে নির্ধারণ করা হয়। সতর্কীকরণ: ক্যাটাগরি থীম সক্রিয় করার ফলে কার্য-সম্পাদন প্রভাবিত হতে পারে।';
$string['configallowcoursethemes'] = 'আপনি এটি সক্রিয় করলে, কোর্সসমূহ নিজস্ব থীম নির্ধারণ করার অনুমোদন পাবে।  কোর্সের থীম অন্যান্য সব নির্বাচিত থীম (সাইট, ব্যবহারকারী, বা সেশন থীম) উপেক্ষা করবে';
$string['configallowemailaddresses'] = 'আপনি যদি নির্দিষ্ট ডোমেইনের সব নতুন ইমেইলের ঠিকানা নিয়ন্ত্রণ করতে চান, তাবে সেগুলো এখানে ফাঁকাস্থান দ্বারা বিভাজিত তালিকা হিসেবে দিন।  অন্যান্য সব ডোমেইন প্রত্যাখ্যান করা হবে।  সাবডোমেইন অনুমোদন করতে হলে ডোমেইনের নামের আগে \'.\' যোগ করুন। উদাহরণ <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'যদি সক্রিয় অতিথি আমার Moodle উপলব্ধি করতে পারে, অন্যথা অতিথি সাইট সদর পাতাতে প্রর্তাবর্তন হয়।';
$string['configallowobjectembed'] = 'নিরাপত্তা পরিমাপের জন্য পূর্বনির্ধারিতভাবে, সাধারণ ব্যবহারকারীরা তাদের HTML ফাইলের পাঠ্যে সুনির্দিষ্ট EMBED এবং OBJECT ট্যাগ ব্যবহার করে মাল্টিমিডিয়া (যেমন ফ্ল্যাশ) সন্নিবেশ করতে পারেন না (যদিও মিডিয়া প্লাগইন পরিশোধক ব্যবহার করে নিরাপদভাবেই এটা করা সম্ভব)।  আপনি এই ট্যাগগুলো অনুমোদন করতে চাইলে এই অপশনটি সক্রিয় করুন।';
$string['configallowoverride'] = 'আপনি বাম দিকে ভূমিকা পালনকারী কয়েকজনকে কলামের কিছু ভূমিকা উপেক্ষা করার অনুমোদন দিতে পারেন';
$string['configallowoverride2'] = 'বাম কলামের ভূমিকা দিয়ে কোন কোন ভূমিকা উপেক্ষা করা হবে তা নির্বাচন করুন।<br />মনে রাখবেন এই সেটিংসমূহ শুধুমাত্র সেইসব ব্যবহারকারীর জন্য প্রয়োগ করা হবে যাদের মুডল/ভূমিকা:উপেক্ষা বা মুডল/ভূমিকা:নিরাপদ উপেক্ষা করার অনুমতি রয়েছে।';
$string['configallowswitch'] = 'ব্যবহারকারীদের বিদ্যমান ভূমিকার উপর নির্ভর করে, তারা কোন ভূমিকায় পরিবর্তন করতে পারবেন তা নির্বাচন করুন। এই টেবিলে ভুক্তি থাকা ছাড়াও, ভূমিকা পরিবর্তন করতে একজন ব্যবহারকারীর মুডল/ভূমিকা:ভূমিকা পরিবর্তনের ক্ষমতা থাকতে হবে।<br />মনে রাখবেন যে ভূমিকা পরিবর্তন করা শুধুমাত্র তাদের জন্যই সম্ভব যাদের মুডল/কোর্স:দেখার ক্ষমতা রয়েছে, এবং যাদের মুডল/সাইট:যেকোন কিছু করার ক্ষমতা নেই, এজন্য এই টেবিলের কিছু কলাম নিষ্ক্রিয় রাখা হয়েছে।';
$string['configallowthemechangeonurl'] = 'যদি সক্রিয়, থিম হয় যোগ করার মধ্যে পরিবর্তন করা যাবে:<br /> যেকোন Moodle ইউআরএলে ?theme=themename (eg: mymoodlesite com/?theme=afterburner) অথবা<br /> যেকোন অভ্যন্তরীণ Moodle ইউআরএলে &theme=themename (eg: mymoodlesite.com/course/view.php?id=2&theme=afterburner)।';
$string['configallowuserblockhiding'] = 'এই সাইটের সাইড ব্লকগুলো ব্যবহারকারীকে আড়াল/প্রদর্শন করার জন্য অনুমোদন করা হবে কি?  প্রতিটি ভঙ্গুর ব্লকের অবস্থা মনে রাখার জন্য এই বৈশিষ্ট্যটি জাভাস্ক্রিপ্ট ও কুকি ব্যবহার করে, এবং শুধুমাত্র ব্যবহারকারীর দৃশ্যপটে প্রভাব ফেলে।';
$string['configallowuserswitchrolestheycantassign'] = 'পূর্বনির্ধারিতভাবে, ভূমিকা পরিবর্তন করার জন্য ব্যবহারকারীদের মুডল/ভূমিকা:আরোপিত থাকা আবশ্যক। এই সেটিং সক্রিয় করার ফলে এই আবশ্যকতা অপসারিত হবে, এবং শুধুমাত্র "ভূমিকা আরোপ অনুমোদন" টেবিলের সেটিংসমূহ থেকে "যে ভূমিকায় পরিবর্তন করা হবে" নিম্ন প্রসারন মেনুতে বিদ্যমান ভূমিকাসমূহ নির্ধারিত হবে।
"ভূমিকা আরোপ অনুমোদন" টেবিলের সেটিংসমূহে ব্যবহারকারীদের বিদ্যমান ভূমিকা থেকে আরও অধিক ক্ষমতাসম্পন্ন ভূমিকায় পরিবর্তন করার অনুমোদন না দেয়ার জন্য সুপারিশ করা হচ্ছে।';
$string['configallowuserthemes'] = 'আপনি এটি সক্রিয় করলে, ব্যবহারকারীরা তাদের নিজস্ব থীম নির্ধারণ করার অনুমোদন পাবে।  ব্যবহারকারীর থীম সাইট থীম (কিন্তু কোর্স থীম নয়) উপেক্ষা করবে';
$string['configallusersaresitestudents'] = 'সাইটের সামনের পৃষ্ঠার কার্যকলাপের জন্য, সব ব্যবহারকারীকে কি শিক্ষার্থী হিসাবপ বিবেচনা করা হবে? উত্তর যদি "হ্যাঁ" হয় তবে, নিশ্চিত করা যেকোনো অ্যাকাউন্ট ঐসব কার্যকলাপে অংশগ্রহন করার জন্য অনুমোদিত। উত্তর যদি "না" হয় তবে, কেবলমাত্র যেসব ব্যবহারকারী আগে যারা কমপক্ষে একটি কোর্সে অংশগ্রহন করেছে তারাই সামনের পৃষ্ঠার কার্যকলাপে অংশগ্রহন করতে পারবে। সামনের পৃষ্ঠার কার্যকলাপে কেবলমাত্র বিশেষভাবে নিয়োজিত শিক্ষকগন শিক্ষক হিসাবে কাজ করতে পারবে।';
$string['configauthenticationplugins'] = 'অনুগ্রহ করে আপনি যে প্রমাণীকরণ প্লাগইন ব্যবহার করতে চান তা নির্বাচন করুন এবং ক্রমানুসারে সাজান।';
$string['configautolang'] = 'ব্রাউজার সেটিং থেকে পূর্বনির্ধারিত ভাষা শনাক্ত করা হবে, এটি নিষ্ক্রিয় থাকলে সাইটের পূর্বনির্ধারিত ভাষা ব্যবহৃত হবে।';
$string['configautologinguests'] = 'অতিথি হিসেবে কোর্সে প্রবেশ করার সময় দর্শনার্থীদের স্বয়ংক্রিয়ভাবে অতিথি হিসেবে লগইন করা উচিত কি?';
$string['configbloglevel'] = 'এই মানসমূহটিতে স্তর নিয়ন্ত্রণ করতে আপনাকে অনুমোদন করে যেটি ব্যবহারকারী এই সাইটটি দেখা হয় ব্লগিং করে। নোট যে তারা প্রদর্শক পোস্টারের সর্বোচ্চ প্রসঙ্গ উল্লেখ করে না অথবা ব্লগ পোষ্টের ধরন। Blogs নিষ্ক্রিয় ও সম্পূর্ণভাবে যদি আপনি না চান।';
$string['configcachetext'] = 'বড় সাইটের অথবা যে সাইটে টেক্সট ফিল্টার ব্যবহার করা হয়, এ সেটিং ব্যবহার করে কাজ দ্রুত করা যাবে। এখানে নির্দিষ্ট করা সময়ে টেক্সটের অনুলিপি তাদের প্রক্রিয়াজাত অবস্থায় পুনরায় পাওয়া যাবে। এটাকে খুব ছোট করে নির্ধারন করলে জিনিসগুলো একটু নিচু নিচু দেখাবে, কিন্তু খুব বড় করে নির্ধারন করলে টেক্সট রিফ্রেশ করতে অনেক সময় লাগবে (নতুন লিঙ্কসহ, উদাহরণস্বরূপ)। ';
$string['configcalendarcustomexport'] = 'ক্যালেন্ডারে নিজস্ব তারিখ সীমা এক্সপোর্ট করতে সক্রিয় করুন';
$string['configcalendarexportsalt'] = 'ক্যালেন্ডার এক্সপোর্ট করার জন্য ব্যবহৃত প্রমাণীকরণ টোকেনের নিরাপত্তা বৃদ্ধির জন্য এই এলোমেলো পাঠ্য ব্যবহার করা হয়। অনুগ্রহ করে মনে রাখবেন যে আপনি এই হ্যাশ সল্ট পরিবর্তন করলে বর্তমান সব টোকেন অকার্যকর হয়ে যাবে।';
$string['configclamactlikevirus'] = 'ফাইলগুলোকে ভাইরাস হিসেবে বিবেচনা করা হবে';
$string['configclamdonothing'] = 'ফাইলগুলোকে ত্রুটিহীন হিসেবে বিবেচনা করা হবে';
$string['configclamfailureonupload'] = 'যদি আপনি আপলোডকৃত ফাইল স্ক্যান করতে clam কনফিগার করিয়েছেন, কিন্তু এইটি বেঠিকভাবে কনফিগার করাওয়া হয় অথবা কিছু অজানা কারণের জন্য চালাতে ব্যর্থ হয়, কত করার এইটি আচরণ করা উচিত? যদি আপনি viruses\'এর মত \'Treat ফাইল বেছে নিন, তাদেরকে অঞ্চলের দিকে চলা হবে quarantineওয়া হবে, অথবা মুছে ফেলেছিল। যদি আপনি OK\' হিসেবে \'Treat ফাইল বেছে নিন, ফাইল স্বাভাবিকের মত গন্তব্য ডিরেক্টরীতে চলা হবে। হয় রাস্তা, অ্যাডমিন সেই clamটি সতর্ক করবে ব্যর্থ হবে। যদি আপনি viruses\'এর মত \'Treat ফাইল বেছে নিন এবং কিছু কারণ clamএর জন্য চালাতে ব্যর্থ হয় (সাধারণত কারণ আপনি একটি অবৈধ pathtoclam ঢুকিয়েছে), ফাইল যে প্রদত্ত অঞ্চলে আপলোড করা হয় চলা হয় quarantineওয়া হয়, অথবা মুছে ফেলেছিল। এই মানসমূহ কির সঙ্গে সতর্কটি।';
$string['configconvertformat'] = '<i>latex</i>, <i>dvips</i> এবং <i>convert</i> বিদ্যমান থাকলে, ছবি উল্লিখিত ফরম্যাটে তৈরি হবে। যদি তা না হয়, mimeTeX ব্যবহার করা হবে এবং এটি GIF ফরম্যাটের ছবি তৈরি করবে।';
$string['configcookiehttponly'] = 'নতুন পিএইচপি 5 2 0 বৈশিষ্ট্য সক্রিয় করে- ব্রাউজার প্রকৃত এইচটিটিপি আবেদনের সঙ্গে cookie পাঠাতে কেবল র্নিদেশ দেওয়াওয়া হয়, কুকির ভাষা scriptingের মধ্যে উপলভ্য না। এইটি সমস্ত ব্রাউজারে সমর্থন করা হয় না এবং এইটি বর্তমান কোডের সঙ্গে সম্পূর্ণভাবে সঙ্গতিপূর্ণ না। এইটি XSS আক্রমণের কিছু ধরন প্রতিরোধ করতে সাহায্য করে।';
$string['configcookiesecure'] = 'যদি সার্ভার কুকি নিরাপদ করার সক্রিয় কর পাঠাতে সংযোগ এইটি কেবল গ্রহণ করা হচ্ছে এইচটিটিপিএসওয়া হচ্ছে সুপারিশ করা হচ্ছে। যদি সক্রিয় দয়া করে সেই ওয়েবটি সার্ভার এইচটিটিপি নিশ্চিত করছে গ্রহণ করছে না:/ অথবা এইচটিটিপিএসে উপর স্থায়ী দিক পরিবর্তন নিযুক্ত করেছিল:/ সম্বোধন করা। কখন<em> wwwroot</em> সম্বোধন করা এইচটিটিপিএসের সঙ্গে শুরু করে না:/ এই মানসমূহটি বন্ধ সয়ংক্রিয়ভাবে বদলাওয়া হয়।';
$string['configcountry'] = 'যদি আপনি একটি দেশ, এখানে নিযুক্ত করেছিলেন তারপর এই দেশটি নতুন ব্যবহারকারী অ্যাকাউন্টে ডিফল্টের মধ্যে নির্বাচন করা হবে। একটি দেশ বেছে নিতে ব্যবহারকারী বাধ্য করতে, এই নিষ্ক্রিয়করণটি মাত্র ছেড়ে চলে যায়।';
$string['configcourseoverviewfilesext'] = 'কোর্স সারাংশ এক্সটেনশন ফাইলে একটি কমা চিহ্ন দ্বারা বিভাজিত তালিকা আছে.';
$string['configcourseoverviewfileslimit'] = 'সর্বোচ্চ সংখ্যক ফাইল ওই কোর্স ফাইলে সংযুক্ত করা যাবে';
$string['configcourserequestnotify'] = 'নতুন কোর্সের অনুরোধ করা হলে যে ব্যবহারকারীকে জানানো হবে তার ব্যবহারকারী নাম টাইপ করুন।';
$string['configcourserequestnotify2'] = 'নতুন কোন কোর্সের অনুরোধ করা হলে যেসব ব্যবহারকারীদের জানানো হবে। এখানে শুধুমাত্র সেইসব ব্যবহারকারীর তালিকা রয়েছে যারা কোর্সের অনুরোধ অনুমোদন করতে পারবেন।';
$string['configcoursesperpage'] = 'একটি বিষয় তালিকাতে প্রতি পাতায় প্রদর্শন করতে কোর্সের সংখ্যা ঢোকান।';
$string['configcourseswithsummarieslimit'] = 'একটি সহজতর তালিকাতে পিছনে পড়ার পূর্বে সারসংক্ষেপ সহ একটি বিষয় তালিকাতে প্রদর্শন করতে কোর্সের সর্বোচ্চ সংখ্যা।';
$string['configcronclionly'] = 'এটি নির্ধারণ করা হলে, ক্রন স্ক্রিপ্ট ওয়েবের পরিবর্তে শুধুমাত্র কমান্ড লাইন থেকে চালানো যাবে।  এটি নিম্নে নির্ধারিত ক্রন পাসওয়ার্ড উপেক্ষা করে।';
$string['configcronremotepassword'] = 'এইটি অভিপ্রায় করে যে ক্রন পিএইচপি লিপি ইউআরএলের নিম্নলিখিত আকার ব্যবহার করে শব্দচাবি সরাবরাহ কর ব্যতীত একটি ওয়েব ব্রাউজার থেকে চালা যাবে না:<pre> এইচটিটিপি: //site.example.com/admin</pre> যদি এইটি ফাঁকা ছেড়ে চলে যাওয়া হয়, কোনও শব্দচাবি প্রয়োজন বোধ করা হয় না।';
$string['configcurlcache'] = 'cURL থেকে প্রস্থানের সময়, সেকেন্ডে।';
$string['configcustommenuitems'] = 'আপনি থীমের মধ্যে হ দেখেতে একটি প্রথা মেনু এখানে কনফিগার করতে পারেন। প্রত্যেক লাইন কিছু মেনু লেখা, একটি সংযোগ ইউআরএলির গঠিত হয় (ঐচ্ছিক) এবং একটি টুলটিপ শিরোনাম (ঐচ্ছিক), পাইপ অক্ষরের মধ্যে আলাদা করেছিল। আপনি hyphens ব্যবহার করে একটি কাঠামো উল্লেখ করতে পারেন। উদাহরণের জন্য:
<pre>
Moodle community|http://moodle.org
-Moodle free support|http://moodle.org/support
-Moodle development|http://moodle.org/development
--Moodle Tracker|http://tracker.moodle.org
--Moodle Docs|http://docs.moodle.org
-Moodle News|http://moodle.org/news
Moodle company
-Moodle commercial hosting|http://moodle.com/hosting
-Moodle commercial support|http://moodle.com/support
</pre>';
$string['configdbsessions'] = 'যদি সক্রিয়, এই মানসমূহটি বর্তমান সেশনের সম্বন্ধে তথ্য সংরক্ষণ করতে ডেটাবেস ব্যবহার করবে। এইটি large/busy স্থানের জন্য বিশেষভাবে কার্যকর অথবা স্থান সার্ভারের গুচ্ছে নির্মাণ করা হয়। স্থান এই সর্বাপেক্ষার জন্যটির নিষ্ক্রিয় সম্ভবত ছেড়ে চলে যাওয়া উচিত সুতরাং যে সার্ভার ডিস্ক বদলে ব্যবহার করা হয়। নোট যে এই মানসমূহটি সমস্ত বর্তমান ব্যবহারকারী এখন পরিবর্তন করবে প্রস্থান করবে (আপনি সহ)। যদি আপনি আমার cnfতে মাই-এস-কিউ-এল দয়া করে সেই \'max_allowed_packet\'টি ব্যবহার করছেন নিশ্চিত করছেন (অথবা আমার ini) অন্তত ৪ মেগা।';
$string['configdebug'] = 'আপনি যদি এটা চালু করেন তবে, PHP এর error_reporting বৃদ্ধি পায়, ফলে আরও সতর্কবার্তা মুদ্রিত হয়। এটা কেবল ডেভেলপারদের জন্য উপকারী।';
$string['configdebugdisplay'] = 'নিযুক্ত করুন, ত্রুটি reporting এইচটিএমএল পাতাতে যাবে। এইটি practical, সাধারণে কিন্তু বিরতি এক্স-এইচ-টি-এম-এল, JS, কুকি এবং এইচটিটিপি হেডার। to বন্ধ নিযুক্ত করুন, এইটি আপনার সার্ভার কার্যবিবরণী, allowing ভাল ত্রুটিমুক্তকরণে আউটপুট পাঠাবে। পিএইচপি মানসমূহ error_log নিয়ন্ত্রণ করে যেটি তে এইটি কার্যবিবরণী লেখে যায়।';
$string['configdebugpageinfo'] = 'পৃষ্ঠার পাদদেশে তথ্য দেখতে চাইলে সক্রিয় করুন।';
$string['configdebugsmtp'] = 'SMTP সার্ভারে ইমেইল পাঠানের সময় ভার্বোস ডিবাগ তথ্য সক্রিয়।';
$string['configdebugvalidators'] = 'পাতা পাদটীকাতে বাহ্যিক validator সার্ভারে লিঙ্ক রাখতে যদি আপনাকে সক্রিয় করুন চান। আপনি ব্যবহারকারীর নামের সঙ্গে নতুন ব্যবহারকারী তৈরি করতে প্রয়োজন বোধ করতে পারেন<em> w3cvalidator</em>, এবং অতিথী তথ্য উদ্ধার করা সক্রিয় করুন। এই পরিবর্তন সার্ভারে unauthorized তথ্য উদ্ধার করা অনুমোদন করতে পারে, উৎপাদন স্থানে সক্রিয় করেন না!';
$string['configdefaulthomepage'] = 'লগকৃত ব্যবহারকারীদের জন্য প্রধান পাতা নির্দেশ করে';
$string['configdefaultrequestcategory'] = 'ব্যবহারকারীদের অনুরোধকৃত কোর্সগুলো স্বয়ংক্রিয়ভাবে ক্যাটেগরিতে বসবে।';
$string['configdefaultrequestedcategory'] = 'যদি অনুমোদন করা হয়, তবে অনুরোধকৃত কোর্সগুলো ক্যাটেগরিতে বসবে।';
$string['configdefaultuserroleid'] = 'ব্যবহারকারীতে সমস্ত logged সাইট স্তরে ভূমিকা আপনার,এর সক্ষমতা এখানে দেওয়া হবে উল্লেখ করা হবে, যেকোন অন্যান্য ভূমিকা তাদের সাথে দে যেত। ডিফল্ট Authenticated ব্যবহারকারী ভূমিকা। নোট যে এইটি অন্যান্য ভূমিকা তারা যদি না আপনাকে সক্ষমতার সঙ্গে সংঘাতে জড়িয়ে পড়বে নিষিদ্ধ করবে না, এইটি মাত্র নিশ্চিতকরণ করে যে সমস্ত ব্যবহারকারীর সক্ষমতা রয়েছে যে বিষয় স্তরে assignable নয় (eg পোষ্ট ব্লগ এন্ট্রি, নিজের বর্ষপঞ্জি, ইত্যাদি পরিচালনা করুন)।';
$string['configdeleteincompleteusers'] = 'এরপরে, পুরাতন অসম্পূর্ন সেটাপ মুছে যাবে।';
$string['configdeleteunconfirmed'] = 'যদি আপনি ই-মেল পরিচয় প্রমাণ প্রক্রিয়া ব্যবহার করছেন, এইটির মধ্যে পর্যায়কাল যেটি একটি সাড়া ব্যবহারকারী থেকে গ্রহণ করা হবে। এই পর্যায়কালের পরেটি, পুরনো অসমর্থিত অ্যাকাউন্ট মুছে ফেলা হয়।';
$string['configdenyemailaddresses'] = 'নির্দিষ্ট ডোমেন থেকে ই-মেল ঠিকানা অস্বীকার করতে একই রাস্তাতে তাদেরকে এখানে তালিকাভুক্ত করে। সমস্ত অন্যান্য ডোমেন গ্রহণ করা হবে। subdomains অস্বীকার করতে একটি preceding \' \'এর সঙ্গে ডোমেন যোগ করে। eg<strong> hotmail com ইয়্যাহু co uk বসবাস করা com</strong>';
$string['configdisableuserimages'] = 'ব্যবহারকারী প্রোফাইল ছবি পরিবর্তনের ক্ষমতা নিষ্ক্রিয়।';
$string['configdisplayloginfailures'] = 'এটি লগইন ব্যর্থ নির্বাচিত ব্যবহারকারীদের তথ্য দেখাবে।';
$string['configdndallowtextandlinks'] = 'সক্রিয় করুন অথবা dragging নিষ্ক্রিয় করুন এবং draggingএর পাশাপাশি একটি বিষয় পাতা,এর ওপর লেখা এবং লিঙ্কের dropping এবং ফাইলের dropping। নোট যে আলাদা ব্রাউজারের মধ্যে ফায়ারফক্স অথবার দিকে লেখার dragging unreliable এবং কোনও ডেটাতে ফলস্বরূপ উদ্ভূত হতে নাও পেরেছিল আপলোড করছিল, অথবা বিকৃত লেখা আপলোড করছিল।';
$string['configdocroot'] = 'Moodle Docsতে Defines রাস্তা। আপনি এইটি পরিবর্তন করতে পারেন যদি আপনি আপনার নিজের প্রথা অনলাইন ডকুমেনটেশন রাখতে ইচ্ছা করেন।, উপরোন্তুটি যদি আপনি করেন যে, নিশ্চিত করেন যে আপনার ডকুমেনটেশনের পাথ http://docs.moodle.org ফরম্যাটে অনুসরণ করেন: /।';
$string['configdoctonewwindow'] = 'এটি সক্রিয় করা হলে, মুডল ডক একটি নতুন উইন্ডোতে খুলবে।';
$string['configeditordictionary'] = 'ব্যবহারকারীর নিজের ভাষার জন্য অ্যাসপেলের যদি কোনো অভিধান না থাকে তবে যদি এ মান ব্যবহৃত হয়।';
$string['configeditorfontlist'] = 'এডিটরের ড্রপ-ডাউন তালিকায় দেখানোর জন্য ফন্ট নির্বাচন করুন।';
$string['configemailchangeconfirmation'] = 'ব্যবহারকারী যখন তাদের প্রোফাইলে ইমেইল ঠিকানা পরিবর্তন করে তখন একটি ইমেইল নিশ্চিতকরণ ধাপ থাকা আবশ্যক।';
$string['configenableajax'] = 'এই মানসমূহটি সাইট জুড়ে AJAXএর ব্যবহার নিয়ন্ত্রণ করে। AJAX নিশ্চিত ক্রিয়া যেমন টেনে নিয়ে যাওয়া এবং বিন্দুর জন্য প্রয়োজন বোধ করা হয়।';
$string['configenableblogs'] = 'এই সুইচটি তাদের নিজের ব্লগের সঙ্গে সমস্ত সাইট ব্যবহারকারী জোগান দেয়।';
$string['configenablecalendarexport'] = 'ক্যালেন্ডারে এক্সপোর্ট বা সাবস্ক্রাইব করতে সক্রিয় করুন।';
$string['configenablecomments'] = 'কমেন্ট সক্রিয়';
$string['configenablecourserequests'] = 'এটি কোন কোর্স তৈরির ব্যাপারে ব্যবহারকারীকে অনুরোধে সক্রিয় করে।';
$string['configenabledevicedetection'] = 'মোবাইল, স্মার্টফোন, ট্যাবলেট অথবা ডিফল্ট ডিভাইসের সনাক্তকরণ সক্রিয় করে (ডেস্কটপ পিসি, ল্যাপটপ, ইত্যাদি) থীম এবং অন্যান্য বৈশিষ্ট্যের অ্যাপলিকেশনের জন্য।';
$string['configenablegroupmembersonly'] = 'যদি সক্রিয়, ক্রিয়াকলাপে তথ্য উদ্ধার করা সদসবৃন্দ কেবল দলবদ্ধ করতে নিয়ন্ত্রণ করা যাবে। এইটি একটি অধিক সার্ভার লোডে ফলস্বরূপ উদ্ভূত হতে পারে। যোগে, গ্রেডবুক শ্রেণীবিভাগের নিশ্চিতকরণ করতে একটি নিশ্চিত রাস্তাতে স্থাপন করা উচিত যে ক্রিয়াকলাপ নন-গ্রুপ সদসবৃন্দ থেকে গোপন করা হয়।';
$string['configenablemobilewebservice'] = 'আধিকারিক Moodle app অথবা অন্যান্য app আবেদন করে এইটির জন্য চলমান চাকরি সক্রিয় করুন। আরও বেশি তথ্যের জন্য, {$a} পড়ুন';
$string['configenablerssfeeds'] = 'এই সুইচটি সাইট জুড়ে আর.এস.এস. সক্রিয় করবে জোগান দে থেকেবে। যেকোন পরিবর্তন আপনি প্রকৃতপক্ষে দেখতে স্বতন্ত্র মডিউলে আর.এস.এস. সক্রিয় করতে খুব প্রয়োজন বোধ করবে জোগান দেবে- অ্যাডমিন কনফিগারেশনের অধীনে মডিউল মানসমূহে যান।';
$string['configenablerssfeedsdisabled'] = 'এইটি প্রাপ্তিসাধ্য নয় কারণ আর.এস.এস. feeds সমস্ত স্থানে নিষ্ক্রিয় আছে। তাদেরকে সক্রিয় করতে, অ্যাডমিন কনফিগারেশনের অধীনে চলক মানসমূহে যান।';
$string['configenablerssfeedsdisabled2'] = 'সার্ভার ধাপে RSS ফিড নিস্ক্রিয়। Server/RSS এ আপনার এটা সক্রিয় করা উচিত।';
$string['configenablesafebrowserintegration'] = 'এইটি quiz মানসমূহে \'Browser security\' ক্ষেত্রে পছন্দ \'Require তালায়ুক্ত বাক্স পরীক্ষা Browser\' যোগ করে সংগঠিত করে। http://www.islamic-awareness.org/Quran/Contrad/External/haman.html দেখুন: আরও বেশি তথ্যের জন্য //www.safeexambrowser.org।';
$string['configenablestats'] = 'যদি আপনি \'হ্যাঁ\' এখানে বেছে নিন, Moodle এর cronjob কার্যবিবরণী প্রসেস করবেন এবং কিছু পরিসংখ্যান সমবেত হন। আপনার সাইটে যানচলাচলের পরিমাণে নির্ভর করছে, এইটি ক্ষনকালের জন্য গ্রহণ করতে পারে। যদি আপনি এইটি সক্রিয় করেন, আপনি কিছু উৎসাহজনক গ্রাফ দেখতে সক্ষম হবেন এবং আপনার কোর্সের প্রত্যেকের সম্বন্ধে পরিসংখ্যান, একটি sitewide ভিত্তি অথবা।';
$string['configenabletrusttext'] = 'ডিফল্ট Moodleএর মধ্যে চিরন্তন thoroughly পরিচ্ছন্ন লেখা যে যেকোন সম্ভব খারাপ লিপি, মিডিয়া ইত্যাদি সরিয়ে দিতে ব্যবহারকারী থেকে আসয় যে একটি নিরাপত্তা ঝুঁকি। Trusted ভিতরের উপাদান পদ্ধতি নির্দিষ্ট ব্যবহারকারী দেওয়ার একটি রাস্তা যে আপনি interference ব্যতীত তাদের ভিতরের উপাদানে এই বৈশিষ্ট্য অন্তর্ভুক্ত করতে সামর্থ্য বিশ্বাস করুন অগ্রসর হন। এই পদ্ধতি সক্রিয় করতে টি, আপনি প্রথম এই মানসমূহটি সক্রিয় করতে প্রয়োজন বোধ করুন, এবং তারপর একটি নির্দিষ্ট Moodle ভূমিকাতে প্রদান Trusted ভিতরের উপাদান অনুমতি। টেক্সট তৈরি করেছিল অথবা যেমন ব্যবহারকারীর মধ্যে আপলোডকৃত trusted হিসেবে চিহ্নিত করা হবে এবং প্রদর্শন করা কির পূর্বে পরিষ্কার করা হবে না।';
$string['configenablewebservices'] = 'ওয়েব পরিষেবা এই Moodleএর দিকে কার্যবিবরণী লেখতে অন্যান্য সিস্টেমটি সক্রিয় করে এবং ক্রিয়াকর্ম কর্ম সম্পাদন করুন। অতিরিক্ত নিরাপত্তা এই বৈশিষ্ট্যের জন্যটির নিষ্ক্রিয় যদি না আপনাকে এইটি সত্যি ব্যবহার করা উচিত।';
$string['configenablewsdocumentation'] = 'ওয়েব পরিষেবা ডকুমেনটেশনের auto-generation সক্রিয় করুন। একটি ব্যবহারকারী তার নিরাপত্তা চাবি পাতা {$a}ে তার নিজের ডকুমেনটেশনে উপলব্ধি করতে পারে। এইটি সক্রিয় প্রোটোকল কেবলের জন্য ডকুমেনটেশন প্রদর্শন করে।';
$string['configerrorlevel'] = 'PHP সতর্কীকরণ এর পরিমান নির্বাচন যা আপনি প্রদর্শন করতে চান। সাধারন যা তাই সর্বোৎকৃষ্ট।';
$string['configexportlookahead'] = 'এক্সপোর্টের সময় এগিয়ে নেয়ার দিন দেখুন';
$string['configexportlookback'] = 'এক্সপোর্টের সময় পিছিয়ে নেয়ার দিন দেখুন';
$string['configextendedusernamechars'] = 'তাদের usernamesতে যেকোন অক্ষর ব্যবহার করতে ছাত্রগণ অনুমোদন করতে এই মানসমূহটি সক্রিয় করুন (নোট এইটি তাদের প্রকৃত নামগুলো প্রভাবিত করে না)। ডিফল্ট " মিথ্যা " যেটি নম্বর শব্দ যুক্ত ছোটহাতের অক্ষর হতে usernames নিয়ন্ত্রণ করে, আন্ডারস্কোরেন (_), hyphen (-), পর্যায়কাল (।) চিহ্নে অথবা (@)।';
$string['configextramemorylimit'] = 'কিছু স্ক্রিপ্ট যেমন অনুসন্ধান, ব্যাকআপ/পুনরূদ্ধার অথবা ক্রন এর জন্য আরও মেমরি দরকার। বড় সাইটের জন্য উচ্চ মান নির্ধারণ।';
$string['configfilterall'] = 'শিরোনাম, টাইটেল, দিক নির্নয় বাঁধা দেয়া এবং সহ ফিল্টার সমস্ত পঙ্‌ক্তি, সুতরাং এইটি বেশির ভাগ কার্যকর যখন multilang ফিল্টার ব্যবহার করছে, এইটি অন্যথায় ছোট লাভের জন্য আপনার সাইটে অতিরিক্ত লোড মাত্র তৈরি করবে।';
$string['configfiltermatchoneperpage'] = 'স্বয়ংক্রিয় যুক্তকরণ ফিল্টার সম্পূর্ণ পাতা প্রথম অনুরূপ লেখা ঘটনার জন্য একটি একক সংযোগ কেবল উৎ‍পাদন করবে খুঁজে পাবে। সমস্ত অন্যান্য উপেক্ষা করা হয়।';
$string['configfiltermatchonepertext'] = 'স্বয়ংক্রিয় যুক্তকরণ ফিল্টার লেখার প্রত্যেক পদে প্রথম অনুরূপ লেখা ঘটনার জন্য একটি একক সংযোগ কেবল উৎ‍পাদন করবে খুঁজে পাবে (উদাঃ, পুঁজি, বনধ্) পাতা। সমস্ত অন্যান্য উপেক্ষা করা হয়। এই মানসমূহটি উপেক্ষা করা হয় যদি একটি প্রতি পাতা মানসমূহ<i> হ্যাঁ</i>।';
$string['configfilteruploadedfiles'] = 'তাদেরকে প্রদর্শন করার পূর্বে ফিল্টারের সঙ্গে প্রসেস সমস্ত আপলোডকৃত এইচটিএমএল এবং লেখা ফাইল, সমস্তে এইচটিএমএল ফাইল অথবা কোনটিও নয় কেবল আপলোড করেছিল।';
$string['configforcelogin'] = 'সাধারণভাবে, সাইট এবং বিষয় তালিকার সদর পাতা (কিন্তু কোর্স না) সাইটের দিকে লগ লেখা ব্যতীত জনগণের মধ্যে পড়া যাবে। যদি আপনি সাইট,ে তারা যেকিছুর পূর্বে লগিন করতে জনগণ বাধ্য করতে চান তারপর আপনার এই মানসমূহটি সক্রিয় করা উচিত।';
$string['configforceloginforprofiles'] = 'একটি প্রকৃত হিসেবে লগিনতে এই মানসমূহ শক্তিসমূহ জনগণ (non-guest) যেকোন ব্যবহারকারীর বৃত্তান্ত দেখার পূর্বে গণনা। যদি আপনি নিষ্ক্রিয় এই মানসমূহটি, আপনি খুঁজে পেতে পারেন যে কিছু ব্যবহারকারী বিজ্ঞাপণ পোষ্ট করেন (spam) তাদের প্রোফাইলে অথবা অন্যান্য বেমানান ভিতরের উপাদান, যেটি তারপর পুরো বিশ্বে দৃশ্যমান।';
$string['configfrontpage'] = 'নির্বাচিত আইটেম সাইটের সামনের পৃষ্ঠায় প্রদর্শিত হবে।';
$string['configfrontpagecourselimit'] = 'সর্বোচ্চ সংখ্যক কোর্স';
$string['configfrontpagecourselimithelp'] = 'এই সাইটের প্রথম পৃষ্ঠা কোর্স তালিকায় সর্বাধিক সংখ্য কোর্স প্রদর্শিত হবে.';
$string['configfrontpageloggedin'] = 'ব্যবহারকারী যখন লগ ইন করবে তখন উপরে নির্বাচিত আইটেম সাইটের সামনের পাতায় প্রদর্শিত হবে।';
$string['configfullnamedisplay'] = 'এইটি সংজ্ঞায়িত করে যেমন নামগুলো দেখাওয়া হয় যখন তাদেরকে পূর্ণে প্রদর্শন করা হয়। সর্বাপেক্ষা mono-lingual স্থান সর্বাপেক্ষা পারদর্শী মানসমূহের জন্য ডিফল্ট " প্রথম নাম + পদবি ", কিন্তু আপনি surnames একবারে গোপন করতে বেছে নিতে পারেন, অথবা সিদ্ধান্ত নিতে বর্তমান ভাষা প্যাক পর্যন্ত এইটি ছেড়ে চলে যেতে (কিছু ভাষার আলাদা প্রথা রয়েছে)।';
$string['configgeoipfile'] = 'GeoIP সিটি বাইনারি ডেটার অবস্থান দাখিল করে। এই ফাইলটি Moodle বন্টনের খন্ড নয় এবংের থেকে আলাদাভাবে অর্জন করা উচিত <a href="http://www.maxmind.com/"> MaxMind</a>। আপনি হয় ক্রয় করা একটি বাণিজ্যিক সংস্করণ অথবা মুক্ত সংস্করণ ব্যবহার করেন।<br /> সহজভাবে ডাউনলোড করে <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" > এইচটিটিপি: //www.maxmind.com/download/geoip/database</a> এবং ের দিকে এইটি নিষ্কাশন করুন " {$a} " আপনার সার্ভারে ডিরেক্টরী।';
$string['configgetremoteaddrconf'] = 'যদি আপনার সার্ভার একটি বিপরীত প্রক্সির পেছনে, আপনি উল্লেখ করতে এই মানসমূহটি ব্যবহার করতে পারে যেটি এইচটিটিপি হেডার প্রত্যন্ত আই.পি. সম্বোধন করা ধারণ করতে বিশ্বাস করা যাবে। হেডার অর্ডারে পড়ে, প্রথম একটি ব্যবহার করছে যে প্রাপ্তিসাধ্য।';
$string['configgradebookroles'] = 'এই মানসমূহটি নিয়ন্ত্রণ করতে আপনাকে অনুমোদন করে যে gradebook এ আবির্ভূত হয়। ব্যবহারকারী সেই বিষয়টির জন্য gradebook এ দেখেতে একটি বিষয়ে এই ভূমিকাগুলির অন্তত একটি রাখতে প্রয়োজন বোধ করে।';
$string['configgradeexport'] = 'স্তর রপ্তানি করার জন্য যেটি রপ্তানি বিন্যাস আপনার প্রাথমিক পদ্ধতি বেছে নিন gradebookন। নির্বাচিত প্লাগিন তারপর নিযুক্ত করেছিল এবং একটি ব্যবহার করুন " শেষ রপ্তানীকৃত " প্রতি স্তরের জন্য মাঠ। উদাহরণের জন্য, এইটি হ হিসেবে রপ্তানীকৃত রেকর্ডে ফলস্বরূপ উদ্ভূত হতে পেরেছিল সনাক্ত করছিল " নতুন " অথবা " আপডেটকৃত "। যদি আপনি এইের সম্বন্ধে নিশ্চিতটি নন তারপর সাময়িক ছুটি সবকিছু unchecked।';
$string['confighiddenuserfields'] = 'বিষয় শিক্ষক/প্রশাসক এর চেয়ে অন্যান্য ব্যবহারকারী অন্যান্য থেকে গোপন করতে যেটি ব্যবহারকারী তথ্য ক্ষেত্র আপনাকে নির্বাচন করুন ইচ্ছা করুন। এইটি ছাত্র গোপনীয়তা বৃদ্ধি করবে। একাধিক ক্ষেত্র নির্বাচন করতে CTRL চাবী মূখ্য ধরুন।';
$string['configidnumber'] = 'এই পছন্দটি উল্লেখ করে কিনা (একটি) ব্যবহারকারী সমস্তে একটি আই-ডি সংখ্যার জন্য জিজ্ঞাসা করা হয় না, (b) ব্যবহারকারী একটি আই-ডি সংখ্যার জন্য জিজ্ঞাসা করা হয় কিন্তু এইটি কি ফাঁকা ছেড়ে চলে যেতে পারে অথবা (সি) ব্যবহারকারী একটি আই-ডি সংখ্যার জন্য জিজ্ঞাসা করা হয় এবং এইটি কি ফাঁকা ছেড়ে চলে যেতে পারে না। যদি প্রদত্ত ব্যবহারকারীর আই-ডি সংখ্যা তাদের বৃত্তান্তে প্রদর্শন করা হয়।';
$string['configintro'] = 'এই পাতা আপনিটি কনফিগারেশন চলকের একটি সংখ্যা উল্লেখ করতে পারে যে আপনার সার্ভারে Moodle কাজ সঠিকভাবে সাহায্য করে তৈরি করে। এইটি কির সম্বন্ধে খুব অধিক উদ্ধিগ্ন হয় না- ডিফল্ট অবস্থায় সুন্দর সাধারণত কাজ করবে এবং আপনি এই পাতাটিতে চিরন্তন পিছনে পরবর্তী কালে আসতে পারেন এবং এই মানসমূহ পরিবর্তন করুন।';
$string['configintroadmin'] = 'এই পাতা আপনারেটি আপনার প্রধান প্রশাসক গণনা কনফিগার করা উচিত যেটির সাইটের ওপর সম্পূর্ণ নিয়ন্ত্রণ থাকবে।আপনাকে এইটি একটি নিরাপদ ব্যবহারকারীর নাম এবং শব্দচাবি ও একটি বৈধ ই-মেল সম্বোধন করা নিশ্চিত করুন। আপনি আরও বেশি অ্যাডমিন অ্যাকাউন্ট পরবর্তী কালে তৈরি করতে পারেন।';
$string['configintrosite'] = 'This page allows you to configure the front page and name of this new site.  You can come back here later to change these settings any time using the Administration menus.';
$string['configiplookup'] = 'When you click on an IP address (such as 34.12.222.93), such as in the logs, you are shown a map with a best guess of where that IP is located.  There are different plugins for this that you can choose from, each has benefits and disadvantages.';
$string['configkeeptagnamecase'] = 'যে ব্যবহারকারী এটি তৈরি করেছে তার দেওয়া প্রকৃত অক্ষরের ছাঁদ ঠিক রাখার জন্য নাম ট্যাগ করতে চাইলে এটি নির্বাচন করুন';
$string['configlang'] = 'সম্পূর্ণ সাইটটির জন্য পূর্বনির্ধারিত ভাষা নির্বাচন করুন। ব্যবহারকারীরা ভাষার মেনু বা তাদের ব্যক্তিগত প্রোফাইলের সেটিং ব্যবহার করে এই সেটিং উপেক্ষা করতে পারেন।';
$string['configlanglist'] = 'Leave this blank to allow users to choose from any language you have in this installation of Moodle.  However, you can shorten the language menu by entering a comma-separated list of language codes that you want.  For example:  en,es_es,fr,it';
$string['configlangmenu'] = 'Choose whether or not you want to display the general-purpose language menu on the home page, login page etc.  This does not affect the user\'s ability to set the preferred language in their own profile.';
$string['configlangstringcache'] = 'Caches all the language strings into compiled files in the data directory.  If you are translating Moodle or changing strings in the Moodle source code then you may want to switch this off.  Otherwise leave it on to see performance benefits.';
$string['configlatinexcelexport'] = 'এনকোডিং এক্সেল এক্সপোর্ট নির্বাচন।';
$string['configlocale'] = 'Choose a sitewide locale - this will override the format and language of dates for all language packs (though names of days in calendar are not affected). You need to have this locale data installed on your operating system (eg for linux en_US.UTF-8 or es_ES.UTF-8). In most cases this field should be left blank.';
$string['configloginhttps'] = 'Turning this on will make Moodle use a secure https connection just for the login page (providing a secure login), and then afterwards revert back to the normal http URL for general speed.  CAUTION: this setting REQUIRES https to be specifically enabled on the web server - if it is not then YOU COULD LOCK YOURSELF OUT OF YOUR SITE.';
$string['configloglifetime'] = 'This specifies the length of time you want to keep logs about user activity.  Logs that are older than this age are automatically deleted.  It is best to keep logs as long as possible, in case you need them, but if you have a very busy server and are experiencing performance problems, then you may want to lower the log lifetime. Values lower than 30 are not recommended because statistics may not work properly.';
$string['configlookahead'] = 'লুক এহেড এর দিন বাকি';
$string['configmaxbytes'] = 'This specifies a maximum size that uploaded files can be throughout the whole site. This setting is limited by the PHP settings post_max_size and upload_max_filesize, as well as the Apache setting LimitRequestBody. In turn, maxbytes limits the range of sizes that can be chosen at course level or module level. If \'Server Limit\' is chosen, the server maximum allowed by the server will be used.';
$string['configmaxconsecutiveidentchars'] = 'পাসওয়ার্ড এই ক্রমিক অনুরূপ অক্ষরের সংখ্যা থেকে বেশি হতে পারবেনা। টিক চিহ্ন নিষ্ক্রিয় করতে 0 ব্যবহার করুন।';
$string['configmaxeditingtime'] = 'এটি ফোরাম পোস্ট পুনরায় সম্পাদন, অভিধানের মন্তব্য ইত্যাদি করতে মানুষ কতটুকু সময় পাবে তা উল্লেখ করে। সাধারনত ৩০ মিনিট একটি ভালো মান।';
$string['configmaxevents'] = 'লুক এহেডের ইভেন্ট';
$string['configmaxusersperpage'] = 'সর্বোচ্চ নম্বর ব্যবহারকারীরা প্রদর্শন ও ব্যবহারকারী কোর্স, দল, জাতিপুঁজ, ওয়েব সার্ভিস ইত্যাদি নির্বাচন করতে পারবে.';
$string['configmessaging'] = 'সাইট ব্যবহারকারীদের মধ্য বার্তাব্যবস্থা সক্রিয় করা হবে কি?';
$string['configmessagingallowemailoverride'] = 'ব্যবহারকারীদের ইমেইল ঠিকানায় ইমেইল বার্তা বিজ্ঞপ্তি তাদের প্রফাইলে অন্য ইমেইল ঠিকানায় পাঠানো জন্য মঞ্জুরি প্রদান করুন';
$string['configmessagingdeletereadnotificationsdelay'] = 'স্থান সংরক্ষণের জন্য ঘোষণা পড়া মুছে ফেলা যাবে। ঘোষণা পড়ার কতক্ষণ পরে তা মুছে ফেলা যাবে?';
$string['configmessaginghidereadnotifications'] = 'বার্তা ইতিহাস প্রদর্শনের সময় ফোরাম পোস্টের মত ঘোষণা পড়া ইভেন্ট আড়াল';
$string['configminpassworddigits'] = 'পাসওয়ার্ড এতগুলো ডিজিটের হওয়া উচিত।';
$string['configminpasswordlength'] = 'পাসওয়ার্ড এতগুলো অক্ষরের হওয়া উচিত।';
$string['configminpasswordlower'] = 'পাসওয়ার্ড এতগুলো ছোট হাতের অক্ষরে হওয়া উচিত।';
$string['configminpasswordnonalphanum'] = 'পাসওয়ার্ড এতগুলো নন অলফা নিউমেরিক অক্ষরের হওয়া উচিত।';
$string['configminpasswordupper'] = 'পাসওয়ার্ড এতগুলো বড় হাতের অক্ষরের হওয়া উচিত।';
$string['configmobilecssurl'] = 'আপনার মোবাইল অ্যাপ্লিকেশন ইন্টারফেসে একটি CSS ফাইল কাস্টমাইজ করা হয়েছে.';
$string['configmodchooserdefault'] = 'ডিফল্ট ব্যবহারকারীকে chooser কার্যকলাপ উপস্থাপনা করা হবে?';
$string['configmycoursesperpage'] = 'ব্যবহারকারীর তালিকায় সর্বোচ্চ প্রদর্শিত কোর্সের সংখ্যা';
$string['configmymoodleredirect'] = 'এ সেটিং অ্যাডমিন নয় এমন কারও জন্য /my এ রিডিরেক্ট করা ফোর্স করে এবং /my দিয়ে শীর্ষ ধাপের সাইট ন্যাভিগেশন প্রতিস্থাপন করে';
$string['configmypagelocked'] = 'এই সেটিংটি অ্যাডমিন নয় এমনদের দ্বারা ডিফল্ট পৃষ্ঠা সম্পাদনা রোধ করে';
$string['confignavcourselimit'] = 'যখন ব্যবহারকারী লগইন করা থাকে না বা কোনো কোর্সে তালিকাভুক্ত থাকে না, তখন ব্যবহারকারীর কাছে প্রদর্শিত কোর্সের সংখ্যা সীমিত করে।';
$string['confignavshowallcourses'] = 'এ সেটিং নিশ্চিত করে যে এ সাইটের সব কোর্স সবসময় ন্যাভিগেশনে প্রদর্শন করা হয়।';
$string['confignavshowcategories'] = 'Show course categories in the navigation bar and navigation blocks. This does not occur with courses the user is currently enrolled in, they will still be listed under mycourses without categories.';
$string['confignotifyloginfailures'] = 'যদি ব্যর্থ লগইন এর রেকর্ড রাখা হয়, তবে ইমেইল ঘোষনা পাঠানো যায়। এ ঘোষনা কে দেখবে?';
$string['confignotifyloginthreshold'] = 'If notifications about failed logins are active, how many failed login attempts by one user or one IP address is it worth notifying about?';
$string['confignotloggedinroleid'] = 'Users who are not logged in to the site will be treated as if they have this role granted to them at the site context.  Guest is almost always what you want here, but you might want to create roles that are less or more restrictive.  Things like creating posts still require the user to log in properly.';
$string['configopentogoogle'] = 'If you enable this setting, then Google will be allowed to enter your site as a Guest.  In addition, people coming in to your site via a Google search will automatically be logged in as a Guest.  Note that this only provides transparent access to courses that already allow guest access.';
$string['configoverride'] = 'config.php-তে নির্ধারিত';
$string['configpasswordpolicy'] = 'Turning this on will make Moodle check user passwords against a valid password policy. Use the settings below to specify your policy (they will be ignored if you set this to \'No\').';
$string['configpathtoclam'] = 'ক্লাম AV এর পাথ। সম্ভবত /usr/bin/clamscan or /usr/bin/clamdscan এর মত কিছু। ক্লাম AV চালানোর জন্য আপনার এটা দরকার।';
$string['configpathtodu'] = 'Path to du. Probably something like /usr/bin/du. If you enter this, pages that display directory contents will run much faster for directories with a lot of files.';
$string['configperfdebug'] = 'এটি চালু করলে, পারফরমেন্স স্ট্যান্ডার্ড রুল বারের পাদদেশে প্রিন্ট হবে';
$string['configprofileroles'] = 'প্রোফাইল এবং অংশগ্রহনকারী পৃষ্ঠায় ভূমিকার তালিকা।';
$string['configprofilesforenrolledusersonly'] = 'To prevent misuse by spammers, profile descriptions of users who are not yet enrolled in any course are hidden. New users must enrol in at least one course before they can add a profile description.';
$string['configprotectusernames'] = 'পূর্বনির্ধারিতভাবে, ব্যবহারকারীর নাম বা পাসওয়ার্ড অনুমান করার জন্য forget_password.php কোনো ইঙ্গিত প্রদ্রশন করে না।';
$string['configproxybypass'] = 'Comma separated list of (partial) hostnames or IPs that should bypass proxy (e.g., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'If this <b>server</b> needs to use a proxy computer (eg a firewall) to access the Internet, then provide the proxy hostname here.  Otherwise leave it blank.';
$string['configproxypassword'] = 'যদি প্রয়োজন হয় তবে প্রক্সির মাধ্যমে ইন্টারনেটে যেতে পাসওয়ার্ড প্রয়োজন হতে পারে, যদি কিছু নাদ থাক তবে খালি (PHP cURL এক্সটেনশন প্রয়োজন)।';
$string['configproxyport'] = 'যদি এই সার্ভারটির প্রক্সি কম্পিউটার প্রয়োজন হয়, তবে এখানে প্রক্সি পোর্ট।';
$string['configproxytype'] = 'ওয়েব প্রক্সির ধরণ (PHP5 এবং cURL এক্সটেনশন প্রয়োজন SOCKS5 সাপোর্টের জন্য)।';
$string['configproxyuser'] = 'যদি প্রয়োজন হয় তবে প্রক্সির মাধ্যমে ইন্টারনেটে যেতে ব্যবহারকারী নাম প্রয়োজন হতে পারে, যদি কিছু নাদ থাক তবে খালি (PHP cURL এক্সটেনশন প্রয়োজন)।';
$string['configquarantinedir'] = 'If you want clam AV to move infected files to a quarantine directory, enter it here. It must be writable by the webserver.  If you leave this blank, or if you enter a directory that doesn\'t exist or isn\'t writable, infected files will be deleted.  Do not include a trailing slash.';
$string['configrecaptchaprivatekey'] = 'String of characters used to communicate between your Moodle server and the recaptcha.net server. Obtain one for this site by visiting http://recaptcha.net';
$string['configrecaptchapublickey'] = 'String of characters used to display the reCAPTCHA element in the signup form. Generated by http://recaptcha.net';
$string['configrequestcategoryselection'] = 'একটি প্রয়োজনীয় কোর্সে বিভাগ নির্বাচনে অনুমতি প্রদান.';
$string['configrequestedstudentname'] = 'অনুরোধকৃত কোর্সের ব্যবহৃত শব্দ';
$string['configrequestedstudentsname'] = 'অনুরোধকৃত কোর্সের ব্যবহৃত শব্দ';
$string['configrequestedteachername'] = 'শিক্ষক কতৃক অনুরোধকৃত কোর্সের ব্যবহৃত শব্দ';
$string['configrequestedteachersname'] = 'শিক্ষক কতৃক অনুরোধকৃত কোর্সের ব্যবহৃত শব্দ';
$string['configrequiremodintro'] = 'Disable this option if you do not want to force users to enter description of each activity.';
$string['configrunclamavonupload'] = 'সক্রিয় করা হলে, clam AV কে সব আপলোডকৃড ফাইল স্ক্যান করতে ব্যবহার করা হয়।';
$string['configrunclamonupload'] = 'Run clam AV on file upload? You will need a correct path in pathtoclam for this to work.  (Clam AV is a free virus scanner that you can get from http://www.clamav.net/)';
$string['configsectioninterface'] = 'ইন্টারফেস';
$string['configsectionmail'] = 'মেইল';
$string['configsectionmaintenance'] = 'রক্ষণাবেক্ষণ';
$string['configsectionmisc'] = 'বিবিধ';
$string['configsectionoperatingsystem'] = 'অপারেটিং সিস্টেম';
$string['configsectionpermissions'] = 'অনুমতি';
$string['configsectionrequestedcourse'] = 'কোর্সের অনুরোধ';
$string['configsectionsecurity'] = 'নিরাপত্তা';
$string['configsectionstats'] = 'পরিসংখ্যান';
$string['configsectionuser'] = 'ব্যবহারকারী';
$string['configsecureforms'] = 'Moodle can use an additional level of security when accepting data from web forms. If this is enabled, then the browser\'s HTTP_REFERER variable is checked against the current form address.  In a very few cases this can cause problems if the user is using a firewall (eg Zonealarm) configured to strip HTTP_REFERER from their web traffic.  Symptoms are getting \'stuck\' on a form. If your users are having problems with the login page (for example) you might want to disable this setting, although it might leave your site more open to brute-force password attacks.  If in doubt, leave this set to \'Yes\'.';
$string['configsessioncookie'] = 'This setting customises the name of the cookie used for Moodle sessions.  This is optional, and only useful to avoid cookies being confused when there is more than one copy of Moodle running within the same web site.';
$string['configsessioncookiedomain'] = 'This allows you to change the domain that the Moodle cookies are available from. This is useful for Moodle customisations (e.g. authentication or enrolment plugins) that need to share Moodle session information with a web application on another subdomain. <strong>WARNING: it is strongly recommended to leave this setting at the default (empty) - an incorrect value will prevent all logins to the site.</strong>';
$string['configsessioncookiepath'] = 'If you need to change where browsers send the Moodle cookies, you can change this setting to specify a subdirectory of your web site.  Otherwise the default \'/\' should be fine.';
$string['configsessiontimeout'] = 'If people logged in to this site are idle for a long time (without loading pages) then they are automatically logged out (their session is ended).  This variable specifies how long this time should be.';
$string['configshowcommentscount'] = 'মন্তব্য গণনা প্রদর্শন, এটির লিংক প্রদর্শনের সময় একটি কোয়পরি দেখাবে';
$string['configshowicalsource'] = 'iCal অনুষ্ঠানের জন্য সোর্স তথ্য দেখান';
$string['configshowsiteparticipantslist'] = 'All of these site students and site teachers will be listed on the site participants list. Who shall be allowed to see this site participants list?';
$string['configsitedefaultlicense'] = 'পূর্বনির্ধারিত সাইট লাইসেন্স';
$string['configsitedefaultlicensehelp'] = 'এ সাইটে কনটেন্ট প্রকাশ করার জন্য পূর্বনির্ধারিত লাইসেন্স';
$string['configsitemaxcategorydepth'] = 'শ্রেণীবিভাগের সর্বোচ্চ গভীরতা';
$string['configsitemaxcategorydepthhelp'] = 'এটা প্রদর্শিত চাইল্ড বিভাগের সর্বোচ্চ ধারণক্ষমতা নির্দিষ্ট করে';
$string['configslasharguments'] = 'Files (images, uploads etc) are provided via a script using \'slash arguments\'. This method allows files to be more easily cached in web browsers, proxy servers etc.  Unfortunately, some PHP servers don\'t allow this method, so if you have trouble viewing uploaded files or images (eg user pictures), disable this setting.';
$string['configsmartpix'] = 'With this on, icons are served through a PHP script that searches the current theme, then all parent themes, then the Moodle /pix folder. This reduces the need to duplicate image files within themes, but has a slight performance cost.';
$string['configstartwday'] = 'সপ্তাহের শুরু';
$string['configstatsfirstrun'] = 'This specifies how far back the logs should be processed <b>the first time</b> the cronjob wants to process statistics. If you have a lot of traffic and are on shared hosting, it\'s probably not a good idea to go too far back, as it could take a long time to run and be quite resource intensive. (Note that for this setting, 1 month = 28 days. In the graphs and reports generated, 1 month = 1 calendar month.)';
$string['configstatsmaxruntime'] = 'Stats processing can be quite intensive, so use a combination of this field and the next one to specify when it will run and how long for.';
$string['configstatsmaxruntime2'] = 'Stats processing can be quite intensive, specify maximum time allowed for gathering of one day of statistics. Maximum number of days processed in one cron execution is 31.';
$string['configstatsmaxruntime3'] = 'Specify the maximum time allowed to calculate the statistics for one day, bearing in mind that stats processing can put a big load on the server. The maximum number of days processed in one cron can be specified below.';
$string['configstatsruntimedays'] = 'Specify the maximum number of days processed in each stats execution. When stats are up-to-date, only one day will be processed, so adjust this value depending of your server load, reducing it if shorter cron executions are needed.';
$string['configstatsruntimestart'] = 'What time should the cronjob that does the stats processing <b>start</b>? Please specify different times if there are multiple Moodles on one physical server.';
$string['configstatsuserthreshold'] = 'If you enter a non-zero,  non numeric value here, for ranking courses, courses with less than this number of enrolled users (all roles) will be ignored';
$string['configstrictformsrequired'] = 'যদি সক্ষম হন, ফর্মে শুধু মাত্র প্রয়োজনীয় ক্ষেত্রগুলোর একটি স্থান বা লাইন বিরতির প্রবেশ করা থেকে ব্যবহারকারীকে আটকানো হবে.';
$string['configstripalltitletags'] = 'অ্যাক্টিভিটি এবং রিসোর্স নামে HTML ট্যাগ অনুমোদন করতে এ সেটিং আনচেক।';
$string['configsupportemail'] = 'This email address will be published to users of this site as the one to email when they need general help (for example, when new users create their own accounts).  If this email is left blank then no such helpful email address is supplied.';
$string['configsupportname'] = 'সাপোর্ট ইমেইল বা ওয়েব ঠিকানার মাধ্যমে সাধারণ সহায়তা দেয় এমন ব্যক্তি বা অন্যান্য সত্ত্বার নাম।';
$string['configsupportpage'] = 'This web address will be published to users of this site as the one to go to when they need general help (for example, when new users create their own accounts).  If this address is left blank then no link will be supplied.';
$string['configthemedesignermode'] = 'Normally all theme images and style sheets are cached in browsers and on the server for a very long time, for performance. If you are designing themes or developing code then you probably want to turn this mode on so that you are not served cached versions.  Warning: this will make your site slower for all users!  Alternatively, you can also reset the theme caches manually from the Theme selection page.';
$string['configthemelist'] = 'Leave this blank to allow any valid theme to be used.  If you want to shorten the theme menu, you can specify a comma-separated list of names here (Don\'t use spaces!).
For example:  standard,orangewhite.';
$string['configtimezone'] = 'You can set the default timezone here.  This is the only the DEFAULT timezone for displaying dates - each user can override this by setting their own in their profile. "Server time" here will make Moodle default to the server\'s operating system setting, but "Server time" in the user profile will make the user default to this timezone setting.  Cronjobs that depend on a time of day to run will use this timezone.';
$string['configuseblogassociations'] = 'কোর্স এবং কোর্স মডিউলের সাথে সম্পৃক্ত হয়ে ব্যবহারকারীর কি কোনো ব্লগ সাজানো উচিত?';
$string['configuseexternalyui'] = 'Instead of using local files, use online files available on Yahoo&#145;s servers. WARNING: This requires an internet connection, or no AJAX will work on your site.';
$string['configuserquota'] = 'ব্যবহারকারী তার ব্যক্তিগত ফাইল এরিয়ায় সর্বোচ্চ যত বাইট সংরক্ষণ করে পারে। {$a->bytes} bytes == {$a->displaysize}';
$string['configusetags'] = 'সক্রিয় করার জন্য কি ট্যাগ ফাংশনালি চালানো হবে?';
$string['configvariables'] = 'চলক';
$string['configverifychangedemail'] = 'Enables verification of changed email addresses using allowed and denied email domains settings. If this setting is disabled the domains are enforced only when creating new users.';
$string['configvisiblecourses'] = 'আড়াল করা ক্যাটেগরিতে কোর্স প্রদর্শন';
$string['configwarning'] = 'সাবধানতার সাথে স্ট্রিং পরিবর্তন - স্ট্রিং মান সমস্যা তৈরি করতে পারে।';
$string['configyuicomboloading'] = 'This options enables combined file loading optimisation for YUI libraries. This setting should be enabled on production sites for performance reasons.';
$string['confirmation'] = 'নিশ্চিতকরণ';
$string['confirmdeletecomments'] = 'আপনি মন্তব্য মুছে ফেলতে চান, নিশ্চিত?';
$string['confirmed'] = 'নিশ্চিত';
$string['convertformat'] = 'আউটপুট ফরম্যাট <i>রূপান্তর</i>';
$string['cookiehttponly'] = 'শুধুমাত্র http কুকি';
$string['cookiesecure'] = 'শুধুমাত্র নিরাপদ কুকি';
$string['country'] = 'পূর্বনির্ধারিত দেশ';
$string['coursecontact'] = 'কোর্সের পরিচিতি';
$string['coursecontact_desc'] = 'This setting allows you to control who appears on the course description. Users need to have at least one of these roles in a course to be shown on the course description for that course.';
$string['courselistshortnames'] = 'বর্ধিত কোর্সের নাম প্রদর্শন করুন';
$string['coursemgmt'] = 'কোর্স যোগ/সম্পাদনা';
$string['courseoverview'] = 'কোর্সের সারসংক্ষেপ';
$string['courserequestnotify'] = 'কোর্সের অনুরোধের ঘোষনা';
$string['courserequestnotifyemail'] = '{$a->user} ব্যবহারকারী {$a->link} এ একটি নতুন কোর্সের জন্য অনুরোধ করেছেন';
$string['courserequests'] = 'কোর্সের অনুরোধ';
$string['courserequestspending'] = 'অনির্ধারিত কোর্সের অনুরোধ';
$string['courses'] = 'কোর্স';
$string['coursesperpage'] = 'প্রতি পৃষ্ঠায় কোর্সের সংখ্যা';
$string['courseswithsummarieslimit'] = 'সারসংক্ষেপ সীমা কোর্স';
$string['creatornewroleid'] = 'নতুন কোর্সে তৈরিকারকের ভূমিকা';
$string['creatornewroleid_help'] = 'যদি ব্যবহারকারীর কোর্স পরিচালনার জন্য ইতোমধ্যেই কোন অনুমতি না থাকে, এই রোল ব্যবহার করে ব্যবহারকারী স্বয়ংক্রিয়ভাবে এনরোল হয়ে যাবে।';
$string['cron'] = 'ক্রন';
$string['cronclionly'] = 'শুধুমাত্র কমান্ড লাইনের মাধ্যমে ক্রন চালানো';
$string['cronerrorclionly'] = 'দুঃখিত, এই পৃষ্ঠার ইন্টারনেট প্রবেশাধিকার প্রশাসক দ্বারা নিষ্ক্রিয় করা হয়েছে।';
$string['cronerrorpassword'] = 'দুঃখিত, আপনার পাসওয়ার্ডটি কার্য়কর নয়';
$string['cron_help'] = 'The cron.php maintenance script assists some of Moodle\'s modules to perform tasks on a scheduled basis, such as mailing out copies of new forum posts. A mechanism is required to run the script regularly e.g. every 5 minutes.';
$string['cron_link'] = 'প্রশাসক/ক্রন';
$string['cronremotepassword'] = 'দূরবর্তী প্রবেশাধিকারের জন্য ক্রন পাসওয়ার্ড';
$string['cronwarning'] = '<a href="cron.php">cron.php maintenance script</a> গত ২৪ ঘন্টায় চালানো হয়নি।';
$string['ctyperecommended'] = 'Installing the optional ctype PHP extension is highly recommended in order to improve site performance, particularly if your site is supporting non-latin languages.';
$string['ctyperequired'] = 'The ctype PHP extension is now required by Moodle, in order to improve site performance and to offer multilingual compatibility.';
$string['curlcache'] = 'cURL ক্যাশে TTL';
$string['curlrecommended'] = 'Installing the optional cURL library is highly recommended in order to enable Moodle Networking functionality.';
$string['curlrequired'] = 'The cURL PHP extension is now required by Moodle, in order to communicate with Moodle repositories.';
$string['curltimeoutkbitrate'] = 'সর্বনিম্ন cURL টাইম আউট বিটরেট (Kbps)';
$string['curltimeoutkbitrate_help'] = 'ইন্টারনেট হতে কন্টেন্ট ডাউনলোডের সময় বিটরেট এত ধীরগতির ছিল যে টাইম আউট দেখাতে হল। টাইম আউট গণনার জন্য HTTP HEAD ফাইল সাইজ জানার অনুরোধ জানায়। HTTP HEAD অনুরোধ বাতিলের জন্য  0 ব্যবহার করুন।';
$string['currenttheme'] = 'বর্তমান থিম';
$string['customcheck'] = 'অন্যান্য পরীক্ষা';
$string['custommenu'] = 'স্বনির্ধারিত মেনু';
$string['custommenuitems'] = 'স্বনির্ধারিত মেনু আইটেম';
$string['datarootsecurityerror'] = '<p><strong>SECURITY WARNING!</strong></p><p>Your dataroot directory is in the wrong location and is exposed to the web. This means that all your private files are available to anyone in the world, and some of them could be used by a cracker to obtain unauthorised administrative access to your site!</p>
<p>You <em>must</em> move dataroot directory ({$a}) to a new location that is not within your public web directory, and update the <code>$CFG->dataroot</code> setting in your config.php accordingly.</p>';
$string['datarootsecuritywarning'] = 'Your site configuration might not be secure. Please make sure that your dataroot directory ({$a}) is not directly accessible via web.';
$string['dbmigrate'] = 'মুডল ডাটাবেস মাইগ্রেশন';
$string['dbmigrateconnecerror'] = 'ডাটাবেসের সাথে সংযুক্ত হতে পারেনি।';
$string['dbmigrateencodingerror'] = 'The database specified has encoding {$a} rather than required UNICODE/UTF8.<br />Please specify another.';
$string['dbmigratepostgres'] = 'It seems that you are using PostgreSQL as the database server. To continue the migration process you need to manually create a new database with encoding "UNICODE"(PostgreSQL 7) or "UTF8" (PostgreSQL 8) to store the migrated data. Please enter your new database connection settings below to continue:';
$string['dbmigratewarning'] = 'Please make sure that you have backed up your Moodle database before commencing this procedure. If you are unsure of how to do that, please contact your system admin. Your Moodle site will be put under maintenance mode after you start the migration process';
$string['dbmigratewarning2'] = '<b>Warning: You are about to start the database migration process. Please be very sure that your entire Moodle database is backed up.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">This database is migrated to a new UTF8 database and deprecated. Please edit your config.php and use the new database for this moodle.</font>';
$string['dbmigrationdupfailed'] = 'Database duplication failed with possible error:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'সেশন তথ্যের জন্য ডাটাবেস ব্যবহার';
$string['debug'] = 'ডিবাগ বার্তা';
$string['debugall'] = 'ALL: সব PHP debug বার্তা প্রদর্শন';
$string['debugdeveloper'] = 'DEVELOPER: ডেভেলপারদের জন্য ডিবাগ বার্তা';
$string['debugdisplay'] = 'ডিবাগ বার্তা প্রদর্শন';
$string['debugging'] = 'ডিবাগিং';
$string['debugminimal'] = 'ন্যূনতম: শুধুমাত্র মারাত্নক ত্রুটি প্রদর্শন করা হবে';
$string['debugnone'] = 'কোনটি না: কোন ত্রুটি বা সতর্কীকরণ প্রদর্শন করা হবে না';
$string['debugnormal'] = 'সাধারণ: ত্রুটি, সতর্কীকরণ ও ঘোষনা প্রদর্শন করা হবে';
$string['debugpageinfo'] = 'পৃষ্ঠার তথ্য প্রদর্শন';
$string['debugsmtp'] = 'ডিবাগ ইমেইল প্রেরণ করা হচ্ছে';
$string['debugstringids'] = 'অরিজিন বা ল্যাঙ্গুয়েজ স্ট্রিং প্রদর্শন';
$string['debugvalidators'] = 'কার্যকর লিংক প্রদর্শন';
$string['defaultcity'] = 'পূর্বনির্ধারিত সিটি';
$string['defaultcity_help'] = 'নতুন ব্যবহারকারী একাউন্ট তৈরি করার সময় এখানে প্রবেশকৃত সিটি পূর্বনির্ধারিত সিটি হবে।';
$string['defaultformatnotset'] = 'ত্রুটি ডিফল্ট কোর্স বিন্যাস নির্ণয় করা হবে. সাইট সেটিংস চেক করুন.';
$string['defaulthomepage'] = 'ব্যবহারকারীদের জন্য পূর্বনির্ধারিত প্রধান পৃষ্ঠা';
$string['defaultrequestcategory'] = 'কোর্স অনুরোধের জন্য পূর্বনির্ধারিত শ্রেণীবিভাগ';
$string['defaultsettinginfo'] = 'পূর্বনির্ধারিত: {$a}';
$string['defaultuserroleid'] = 'সব ব্যবহারকারীর পূর্বনির্ধারিত ভূমিকা';
$string['deleteincompleteusers'] = 'উল্লিখিত সময়ের পর অসম্পূর্ণ ব্যবহারকারীদের মুছে ফেলা হবে';
$string['deleteunconfirmed'] = 'অসম্পূর্ণ ব্যবহারকারী মুছে ফেলা';
$string['deleteuser'] = 'ব্যবহারকারী মুছে ফেলা';
$string['density'] = 'ঘনত্ব';
$string['denyemailaddresses'] = 'ইমেইল ডোমেইন প্রত্যাখ্যাত';
$string['development'] = 'ডেভেলপমেন্ট';
$string['devicedetectregex'] = 'ডিভাইস সনাক্তকরণ রেগুলার এক্সপ্রেশন';
$string['devicedetectregexexpression'] = 'নিয়মিত প্রকাশ';
$string['devicedetectregexvalue'] = 'মান ফিরে যান';
$string['devicetype'] = 'ডিভাইস ধরণ';
$string['disableuserimages'] = 'ব্যবহারকারীর প্রোফাইলের ছবি নিষ্ক্রিয়';
$string['displayerrorswarning'] = 'Enabling the PHP setting <em>display_errors</em> is not recommended on production sites because some error messages may reveal sensitive information about your server.';
$string['displayloginfailures'] = 'লগিন ব্যর্থতা প্রদর্শন';
$string['dndallowtextandlinks'] = 'ড্রাগ এবং ড্রপে টেক্সট/লিঙ্ক আপলোড';
$string['docroot'] = 'মুডল ডক ডকুমেন্ট রুট';
$string['doctonewwindow'] = 'নতুন উইন্ডোতে খুলুন';
$string['download'] = 'ডাউনলোড';
$string['edithelpdocs'] = 'সহায়িকা নথি সম্পাদনা';
$string['editingnoncorelangfile'] = 'You are trying to modify translation of an add-on module/plugin. You can save translation of 3rd party modules in your _local folder only. You may want to move the file with translation into the module\'s lang directory and/or send it to the maintainer of the add-on module.';
$string['editlang'] = '<b>সম্পাদনা</b>';
$string['editorbackgroundcolor'] = 'পটভূমির রং';
$string['editordictionary'] = 'সম্পাদক অভিধান';
$string['editorfontfamily'] = 'ফন্ট ফ্যামিলি';
$string['editorfontlist'] = 'ফন্টের তালিকা';
$string['editorfontsize'] = 'ফন্টের আকার';
$string['editorhidebuttons'] = 'লুকানো বোতাম';
$string['editorkillword'] = 'শব্দ ফরম্যাট ফিল্টার';
$string['editorspelling'] = 'সম্পাদক বানান';
$string['editorspellinghelp'] = 'বানান পরীক্ষণ সক্রিয় বা নিষ্ক্রিয়। সক্রিয় করা হবে, <strong>aspell</strong> অবশ্যই সার্ভারে ইনস্টল করা হবে।';
$string['editstrings'] = 'শব্দ বা শব্দসমষ্টি সম্পাদনা';
$string['emailchangeconfirmation'] = 'ইমেইল পরিবর্তন নিশ্চিতকরণ';
$string['emoticonalt'] = 'বিকল্প পাঠ্য';
$string['emoticoncomponent'] = 'ছবির উপাদান';
$string['emoticonimagename'] = 'ছবির নাম';
$string['emoticons'] = 'ইমোটিকন';
$string['emoticons_desc'] = 'This form defines the emoticons (or smileys) used at your site. To remove a row from the table, save the form with an empty value in any of the required fields. To register a new emoticon, fill the fields in the last blank row. To reset all the fields into default values, follow the link above.

* Text (required) - This text will be replaced with the emoticon image. It must be at least two characters long.
* Image name (required) - The emoticon image file name without the extension, relative to the component pix folder.
* Image component (required) - The component providing the icon.
* Alternative text (optional) - String identifier and component of the alternative text of the emoticon.';
$string['emoticonsreset'] = 'ইমোটিকন সেটিংসমূহকে পূর্বনির্ধারিত মানে পুনঃনির্ধারণ করা হবে';
$string['emoticontext'] = 'পাঠ্য';
$string['emptysettingvalue'] = 'ফাঁকা';
$string['enableajax'] = 'AJAX সক্রিয়';
$string['enableblogs'] = 'ব্লগ সক্রিয় করুন';
$string['enablecalendarexport'] = 'ক্যালেন্ডার এক্সপোর্ট সক্রিয়';
$string['enablecomments'] = 'মন্তব্য সক্রিয়';
$string['enablecourserequests'] = 'কোর্সের অনুরোধ সক্রিয়';
$string['enablecssoptimiser'] = 'CSS এর অপটিমাইজার সক্রিয় করুন';
$string['enabled'] = 'সক্রিয় করুন';
$string['enabledevicedetection'] = 'ডিভাইস সনাক্তকরণ সক্রিয় করুন';
$string['enablegravatar'] = 'Gravatar সক্রিয় করুন';
$string['enablegroupmembersonly'] = 'শুধুমাত্র গ্রুপের সদস্যদের সক্রিয়';
$string['enablemobilewebservice'] = 'মোবাইল ডিভাইসের জন্য ওয়েব সার্ভিস সক্রিয় করুন';
$string['enablerecordcache'] = 'রেকর্ড ক্যাশে সক্রিয়';
$string['enablerssfeeds'] = 'RSS ফিড সক্রিয়';
$string['enablesafebrowserintegration'] = 'নিরাপদ পরীক্ষা ব্রাউজার ইন্টগ্রেশন সক্রিয়';
$string['enablestats'] = 'পরিসংখ্যান সক্রিয়';
$string['enabletgzbackups'] = 'নতুন ব্যাকআপ বিন্যাস সক্রিয় করুন';
$string['enabletrusttext'] = 'বিশ্বস্ত কনটেন্ট সক্রিয়';
$string['enablewebservices'] = 'ওয়েব সার্ভিস সক্রিয়';
$string['enablewsdocumentation'] = 'ওয়েব সার্ভিসের ডকুমেন্টেশন';
$string['enrolinstancedefaults'] = 'পূর্বনির্ধারিত সন্নিবিষ্ট নমুনা';
$string['enrolinstancedefaults_desc'] = 'নতুন কোর্সে পূর্বনির্ধারিত সন্নিবেশ সেটিং';
$string['enrolmultipleusers'] = 'ব্যবহারকারীদের তালিকাভুক্ত করা হবে';
$string['environment'] = 'এনভায়রনমেন্ট';
$string['environmenterrortodo'] = 'মুডল সংস্করণ ইন্সটল করার আগে উপোরক্ত সব এমভায়রনমেন্টজনিত সমস্যার (ত্রুটির) সমাধান করে নিতে হবে!';
$string['environmenterrorupgrade'] = 'সতর্কীকরণ: মুডল সংস্করণ ইন্সটল করার আগে উপোরক্ত সব এমভায়রনমেন্টজনিত সমস্যার (ত্রুটির) সমাধান করে নিতে হবে!';
$string['environmentmustfixsetting'] = 'PHP সেটিং অবশ্যই পরিবর্তন করতে হবে।';
$string['environmentok'] = 'আপনার সার্ভার এনভায়রনমেন্ট সর্বনিম্ন সব আবশ্যকতা পূরণ করে।';
$string['environmentrecommendcustomcheck'] = 'এই পরীক্ষা ব্যর্থ হলে, এটি একটি সম্ভাব্য সমস্যা নির্দেশ করে';
$string['environmentrecommendinstall'] = 'সর্বোত্তম ফলাফলের জন্য এটি ইনস্টল ও সক্রিয় করতে হবে';
$string['environmentrecommendversion'] = '{$a->needed} সংস্করণ সুপারিশকৃত এবং আপনি {$a->current} চালাচ্ছেন';
$string['environmentrequirecustomcheck'] = 'এই পরীক্ষায় অবশ্যই উত্তীর্ণ হতে হবে';
$string['environmentrequireinstall'] = 'অবশ্যই ইনস্টল ও সক্রিয় করতে হবে';
$string['environmentrequireversion'] = '{$a->needed} সংস্করণ আবশ্যক এবং আপনি {$a->current} চালাচ্ছেন';
$string['environmentsettingok'] = 'সুপারিশকৃত সেটিং শনাক্ত করা হয়েছে';
$string['environmentshouldfixsetting'] = 'PHP সেটিং পরিবর্তন করা উচিত।';
$string['environmentxmlerror'] = 'এনভায়রনমেন্ট ডাটা ({$a->error_code}) পড়ার সময় ত্রুটি দেখা দিয়েছে';
$string['errordeletingconfig'] = '\'{$a}\' প্লাগইনের কনফিগারেশন রেকর্ড মুছে ফেলার সময় একটি ত্রুটি দেখা দিয়েছে।';
$string['errorsetting'] = 'উল্লিখিত সেটিং সংরক্ষণ করা যায়নি:';
$string['errorwithsettings'] = 'একটি ত্রুটি ঘটার ফলে কিছু সেটিংস পরিবর্তিত হয়নি।';
$string['everyonewhocan'] = 'প্রত্যেকে \'{$a}';
$string['exceptions'] = 'ব্যতিক্রম';
$string['execpathnotallowed'] = 'config.php এক্সিকিউটেবল পাথের সেটিং নিষ্ক্রিয়';
$string['experimental'] = 'পরীক্ষামূলক';
$string['experimentalsettings'] = 'পরীক্ষামূলক সেটিংসমূহ';
$string['extendedusernamechars'] = 'ব্যবহারকারীর নামে অতিরিক্ত অক্ষর অনুমোদন';
$string['extramemorylimit'] = 'অতিরিক্ত PHP মেমরির সীমা';
$string['fatalmagicquotesruntime'] = '<p>Serious configuration error detected, please notify server administrator.</p><p> To operate properly, Moodle requires that administrator changes PHP settings.</p><p><code>magic_quotes_runtime</code> must be set to <code>off</code>.</p><p>This setting is controlled by editing <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['fatalsessionautostart'] = '<p>Serious configuration error detected, please notify server administrator.</p><p> To operate properly, Moodle requires that administrator changes PHP settings.</p><p><code>session.auto_start</code> must be set to <code>off</code>.</p><p>This setting is controlled by editing <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['filecreated'] = 'নতুন ফাইল তৈরি করা হয়েছে';
$string['filestoredin'] = 'উল্লিখিত ফোল্ডারে ফাইল সংরক্ষণ :';
$string['filestoredinhelp'] = 'যেখানে ফাইলটি সংরক্ষিত হবে';
$string['filterall'] = 'সব স্ট্রিং ফিল্টার';
$string['filtermatchoneperpage'] = 'প্রতি পৃষ্ঠায় ফিল্টার মিল';
$string['filtermatchonepertext'] = 'প্রতি টেক্সটে ফিল্টার মিল';
$string['filters'] = 'পরিশোধক';
$string['filtersettings'] = 'পরিশোধক ব্যবস্থাপনা';
$string['filtersettingsgeneral'] = 'সাধারণ পরিশোধকের সেটিং';
$string['filteruploadedfiles'] = 'পরিশোধকের আপলোডকৃত ফাইল';
$string['forcelogin'] = 'ব্যবহারকারীকে লগইন করার জন্য জোর করা হবে';
$string['forceloginforprofileimage'] = 'ব্যবহারকারীর ছবি দেখতে হলে অবশ্যই ব্যবহারকারীকে লগ ইন করতে হবে';
$string['forceloginforprofileimage_help'] = 'যদি সক্ষম থাকে, ব্যবহাকারী লগইন করার সময় ব্যবহারকারীর প্রফাইল ছবি প্রদর্শন এবং ডিফল্ট ব্যবহারকারীর ছবি সমস্ত ঘোষিত ইমেইলগুলোতে ব্যবহার করা যাবে.';
$string['forceloginforprofiles'] = 'ব্যবহারকারীকে প্রোফাইলের জন্য লগইন করতে জোর করা হবে';
$string['forcetimezone'] = 'পূর্বনির্ধারিত সময় অঞ্চল নির্ধারণ';
$string['frontpage'] = 'প্রথম পৃষ্ঠা';
$string['frontpagebackup'] = 'প্রথম পৃষ্ঠার ব্যাকআপ';
$string['frontpagedefaultrole'] = 'প্রথম পৃষ্ঠার পূর্বনির্ধারিত ভূমিকা';
$string['frontpagefilters'] = 'প্রথম পৃষ্ঠার পরিশোধক';
$string['frontpageloggedin'] = 'লগইন করার সময় প্রথম পৃষ্ঠার আইটেম';
$string['frontpageoverrides'] = 'প্রথম পৃষ্ঠার অনুমতি উপেক্ষা করে';
$string['frontpagequestions'] = 'প্রথম পৃষ্ঠার প্রশ্ন';
$string['frontpagerestore'] = 'প্রথম পৃষ্ঠা পুনরুদ্ধার';
$string['frontpageroles'] = 'প্রথম পৃষ্ঠার ভূমিকা';
$string['frontpagesettings'] = 'প্রথম পৃষ্ঠার সেটিংস';
$string['fullnamedisplay'] = 'সম্পূর্ণ নামের বিন্যাস';
$string['fullnamedisplayprivate'] = 'সম্পূর্ণ নাম বিন্যাস - ব্যক্তিগত';
$string['gdrecommended'] = 'ছবি রূপান্তরের জন্য GD বর্ধিতাংশ ব্যবহার করা হয়, অনুপস্থিত থাকলে কিছু বৈশিষ্ট্য যেমন ব্যবহারকারীর প্রোফাইলের ছবি থাকবে না।';
$string['gdrequired'] = 'GD এক্সটেনশন ইমেজ রূপান্তর জন্য Moodle প্রয়োগ করা আবশ্যক.';
$string['generalsettings'] = 'সাধারণ সেটিংসমূহ';
$string['geoipfile'] = 'GeoIP সিটি ডাটা ফাইল';
$string['getremoteaddrconf'] = 'লগকৃত IP ঠিকানার উৎস';
$string['globalswarning'] = '<p><strong>SECURITY WARNING!</strong></p><p> To operate properly, Moodle requires <br />that you make certain changes to your current PHP settings.</p><p>You <em>must</em> set <code>register_globals=off</code>.</p><p>This setting is controlled by editing your <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file.</p>';
$string['googlemapkey3'] = 'Google Maps-API-V3 কী';
$string['gotofirst'] = 'প্রথম অনুপস্থিত স্ট্রিংয়ে যান';
$string['gradebook'] = 'গ্রেড বই';
$string['gradebookroles'] = 'গ্রেডকৃত ভূমিকা';
$string['gradeexport'] = 'প্রাথমিক গ্রেড এক্সপোর্টের পদ্ধতি';
$string['gravatardefaulturl'] = 'Gravatar ডিফল্ট চিত্র URL';
$string['groupenrolmentkeypolicy'] = 'গ্রুপে তালিকাভুক্তির মূল নীতিমালা';
$string['groupenrolmentkeypolicy_desc'] = 'এটা চালু করলে একটি কার্যকর পাসওয়ার্ড নীতিমালার বিপরীতে মুডল গ্রুপ তালিকাভুক্ত করার কী পরীক্ষা করবে।';
$string['guestroleid'] = 'অতিথিদের ভূমিকা';
$string['guestroleid_help'] = 'This role is automatically assigned to the guest user. It is also temporarily assigned to not enrolled users that enter the course via guest enrolment plugin.';
$string['helpadminseesall'] = 'ক্যালেন্ডারের সব ইভেন্ট অথবা শুধু নিজেদের জন্য যেগুলো উপযোগী তা কি অ্যাডমিন দেখতে পায়?';
$string['helpcalendarcustomexport'] = 'রপ্তানি ক্যালেন্ডারে নিজস্ব রপ্তানির তারিখ ব্যাপ্তি বিকল্পটি সক্রিয় করুন. এই কার্যকর করার আগে অবশ্যই রপ্তানির ক্যালেন্ডার সক্রিয় করতে হবে.';
$string['helpforcetimezone'] = 'আপনি ব্যবহারকারীদের স্বতন্ত্রভাবে তাদের সময় অঞ্চল নির্বাচন করার অনুমোদন দিতে পারেন, অথবা সবার জন্য একটি সময় অঞ্চল নির্ধারণ করে দিতে পারেন।';
$string['helpshowicalsource'] = 'সক্রিয় করা হলে, iCal-আমদানী ইভেন্টে জন্য সাবস্ক্রিপশন নাম এবং লিঙ্ক প্রদর্শিত হবে.';
$string['helpsitemaintenance'] = 'আপগ্রেড ও অন্যান্য কাজের জন্য';
$string['helpstartofweek'] = 'ক্যালেন্ডারে কোন দিন দিয়ে সপ্তাহ শুরু হয়?';
$string['helpupcominglookahead'] = 'পূর্বনির্ধরিতভাবে ক্যালেন্ডার ভবিষ্যতের কতদিনের আসন্ন ইভেন্ট অনুসন্ধান করে?';
$string['helpupcomingmaxevents'] = 'পূর্বনির্ধারিতভাবে পরবর্তী (সর্বোচ্চ) কতটি ইভেন্ট ব্যবহারকারীকে প্রদর্শন করা হবে?';
$string['helpweekenddays'] = 'সপ্তাহের কোন কোন দিন "ছুটির দিন" হিসেবে ধরা হবে এবং ভিন্ন রঙে প্রদর্শিত হবে?';
$string['hiddenuserfields'] = 'ব্যবহারকারী ক্ষেত্র আড়াল';
$string['hidefromall'] = 'সব ব্যবহারকারীর কাছ থেকে আড়াল';
$string['hidefromnone'] = 'কারও কাছ থেকে আড়াল নয়';
$string['hidefromstudents'] = 'শিক্ষার্থীদের কাছ থেকে আড়াল';
$string['htmleditor'] = 'HTML সম্পাদক';
$string['htmleditorsettings'] = 'HTML সম্পাদক সেটিংসমূহ';
$string['htmlsettings'] = 'HTML সেটিংসমূহ';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP নিরাপত্তা';
$string['hubs'] = 'হাব';
$string['iconvrecommended'] = 'সাইটের কার্যকারিতা বৃদ্ধি করতে ঐচ্ছিক ICONV লাইব্রেরি ইনস্টল করার জন্য জরুরিভাবে সুপারিশ করা হচ্ছে, বিশেষত যদি আপনার সাইট ল্যাটিন নয় এমন ভাষাসমূহ সমর্থন করে থাকে।';
$string['iconvrequired'] = 'ICONV বর্ধিতাংশটি ইনস্টল করা প্রয়োজন।';
$string['ignore'] = 'উপেক্ষা';
$string['includemoduleuserdata'] = 'মডিউলের ব্যবহারকারী ডাটা অন্তর্ভুক্ত';
$string['incompatibleblocks'] = 'অসঙ্গতিপূর্ণ ব্লক';
$string['installhijacked'] = 'দুঃখিত, ইনস্টলেশন অবশ্যই আদি IP অ্যাড্রেস থেকে সমাপ্ত হতে হবে।';
$string['installsessionerror'] = 'PHP সেশন আরম্ভ করা যাচ্ছে না, অনুগ্রহ করে পরীক্ষা করুন যে আপনার ব্রাউজার কুকি অনুমোদন করে।';
$string['intlrecommended'] = 'Intl বর্ধিতাংশটি আন্তর্জাতিকায়ন সমর্থন বাড়াতে ব্যবহৃত হয়, যেমন লোক্যাল সম্পর্কিত ক্রমিকায়ন।';
$string['invalidsection'] = 'অকার্যকর অংশ।';
$string['invaliduserchangeme'] = 'Username "changeme" is reserved -- you cannot create an account with it.';
$string['ipblocked'] = 'সাইটটি এই মুহূর্তে বিদ্যমান নেই।';
$string['ipblocker'] = 'IP ব্লকার';
$string['ipblockersyntax'] = 'Put every entry on one line. Valid entries are either full IP address (such as <b>192.168.10.1</b>) which matches a single host; or partial address (such as <b>192.168.</b>) which matches any address starting with those numbers; or CIDR notation (such as <b>231.54.211.0/20</b>); or a range of IP addresses (such as <b>231.3.56.10-20</b>) where the range applies to the last part of the address. Text domain names (like \'example.com\') are not supported. Blank lines are ignored.';
$string['iplookup'] = 'IP অ্যাড্রেস লুকআপ';
$string['iplookupinfo'] = 'By default Moodle uses the free online NetGeo (The Internet Geographic Database) server to lookup location of IP addresses, unfortunately this database is not maintained anymore and may return <em>wildly incorrect</em> data.
It is recommended to install local copy of free GeoLite City database from MaxMind.<br />
IP address location is displayed on simple map or using Google Maps. Please note that you need to have a Google account and apply for free Google Maps API key to enable interactive maps.';
$string['iplookupmaxmindnote'] = 'এই পণ্যটিতে MaxMind দ্বারা তৈরি GeoLite ডাটা রয়েছে, যা <a href="http://www.maxmind.com/">http://www.maxmind.com/</a> থেকে বিদ্যমান।';
$string['keeptagnamecase'] = 'ট্যাগ নাম ক্যাশিং রাখা';
$string['lang'] = 'পূর্বনির্ধারিত ভাষা';
$string['langcache'] = 'ভাষার মেনু ক্যাশে';
$string['langcache_desc'] = 'ভাষা মেনু ক্যাশ করুন। যদি সক্রিয় থাকে, বিদ্যমান অনুবাদের তালিকা ক্যাশ হবে। ইন-বিল্টে ভাষা প্যাক পরিচালনার টুলের মাধ্যমে ভাষা প্যাক ইনস্টল অথবা মুছে ফেলার সময় ক্যাশ স্বয়ংক্রিয়ভাবে রিফ্রেস হবে। যদি আপনি নিজ হাতে ভাষা প্যাকেজ  ইনস্টল করেন তাহলে ক্যাশকৃত তালিকা রিফ্রেস করতে সব ক্যাশ বৈশিষ্ট্য বিশোধিত ব্যবহার করতে হবে।';
$string['langlist'] = 'ভাষার মেনুর ভাষাসমূহ';
$string['langmenu'] = 'ভাষার মেনু প্রদর্শন';
$string['langpackwillbeupdated'] = 'আপগ্রেড করার সময়, মুডল বর্তমানে নির্বাচিত ল্যাংগুয়েজ প্যাক হালনাগাদ করার চেষ্টা করবে।';
$string['langstringcache'] = 'সব ভাষার স্ট্রিং ক্যাশে করা হবে';
$string['languagesettings'] = 'ভাষার সেটিংসমূহ';
$string['latexpreamble'] = 'LaTeX প্রস্তাবনা';
$string['latexsettings'] = 'LaTeX রেন্ডারার সেটিংসমূহ';
$string['latinexcelexport'] = 'এক্সেল এনকোডিং';
$string['legacyfilesaddallowed'] = 'লিগ্যাসি কোর্স ফাইল যোগ করা অনুমতি প্রদান';
$string['legacyfilesinnewcourses'] = 'নতুন কোর্সে উত্তরাধিকারসূত্রে প্রাপ্ত কোর্সের ফাইল';
$string['legacyfilesinnewcourses_help'] = 'By default legacy course files areas are available only in upgraded courses. Please note some features like single activity backup/restore are not compatible with this settings.';
$string['licensesettings'] = 'লাইসেন্সের সেটিংসমূহ';
$string['linkadmincategories'] = 'লিঙ্ক এডমিন বিভাগসমূহ';
$string['loading'] = 'লোড করা হচ্ছে';
$string['localetext'] = 'সাইট ওয়াইড লোক্যাল';
$string['localstringcustomization'] = 'স্থানীয় স্ট্রিংয়ের বৈশিষ্ট্য নির্ধারণ';
$string['location'] = 'অবস্থান';
$string['locationsettings'] = 'অবস্থানের সেটিংসমূহ';
$string['locked'] = 'আবদ্ধ';
$string['lockoutduration'] = 'অ্যাকাউন্ট lockout সময়কাল';
$string['lockoutduration_desc'] = 'এই সময়কাল পরে লক আউট হওয়া এ্যাকাউন্ট স্বয়ংক্রিয়ভাবে উদঘাটিত হবে.';
$string['lockoutemailsubject'] = '{$a} তে আপনার একাউন্ট লক আউট হয়ে ছিল';
$string['lockouterrorunlock'] = 'অবৈধ অ্যাকাউন্ট আনলক সম্পর্কে তথ্য সরবরাহ.';
$string['lockoutthreshold'] = 'অ্যাকাউন্ট lockout থ্রেশহোল্ড';
$string['lockoutwindow'] = 'অ্যাকাউন্ট lockout পর্যবেক্ষণ উইন্ডো';
$string['log'] = 'লগ';
$string['logguests'] = 'গেষ্ট প্রবেশাধিকার লগ';
$string['logguests_help'] = 'শুধুমাত্র গেষ্ট একাউন্ট লগিং হলেই এই সেটিং লগিং সক্রিয় করে কিন্তু ব্যবহারকারী লগ ইন নয়। কার্যকারিতার কারণে উচ্চ পর্যায়ের প্রোফাইলের সাইট এই লগিং নিষ্ক্রিয় করবে। প্রোডাকশন সাইটে এই সেটিং সক্রিয় রাখতে সুপারিশ করা হচ্ছে।';
$string['loginhttps'] = 'লগইন করার জন্য HTTPS ব্যবহার করুন';
$string['loginpageautofocus'] = 'অটোফোকাস লগইন পৃষ্ঠায় ফর্ম';
$string['loginpasswordautocomplete'] = 'লগইন ফর্মে ব্যক্তিগত পাসওয়ার্ডটি স্বয়ংপূর্ণ করা হবে';
$string['loglifetime'] = 'যার জন্য লগ রাখা হবে';
$string['longtimewarning'] = '<b>অনুগ্রহ করে লক্ষ্য করুন যে এই প্রক্রিয়াটিতে দীর্ঘ সময় লাগতে পারে।</b>';
$string['maintenancemode'] = 'রক্ষণাবেক্ষণ মোডে রয়েছে';
$string['maintenancemodeisscheduled'] = '{$a} মিনিটে সাইটে রক্ষনাবেক্ষণ মোড স্যুইচ করা হয়';
$string['maintfileopenerror'] = 'রক্ষণাবেক্ষণের ফাইল খোলার সময় ত্রুটি দেখা দিয়েছে!';
$string['maintinprogress'] = 'রক্ষণাবেক্ষণ চলছে...';
$string['manageformats'] = 'কোর্স বিন্যাস পরিচালনা';
$string['manageformatsgotosettings'] = '{$a} মধ্যে ডিফল্ট বিন্যাস পরিবর্তন করা যাবে';
$string['managelang'] = 'ব্যবস্থাপনা';
$string['managelicenses'] = 'লাইসেন্স ব্যবস্থাপনা';
$string['manageqbehaviours'] = 'আচরণ প্রশ্ন পরিচালনা';
$string['manageqtypes'] = 'প্রশ্নের ধরন ব্যবস্থাপনা';
$string['maturity100'] = 'বেটা';
$string['maturity150'] = 'রিলিজ ক্যান্ডিডেট';
$string['maturity200'] = 'স্থির সংস্করণ';
$string['maturity50'] = 'আলফা';
$string['maturitycorewarning'] = 'আপনি মুডল "{$a}" সংস্করণ হালনাগাদ অথবা ইনস্টল করতে যাচ্ছেন
যা কিনা এখনো প্রোডাকশন হয়েছে হিসেবে বিবেচনা করা হয়না। অনুগ্রহ করে নিশ্চিত হন যে এটি উদ্দেশ্যমূলক
এবং আপনি যা ব্যবহার করছেন তা মুডল সোর্স কোডের সঠিক চেক আউট।';
$string['maxbytes'] = 'আপলোডকৃত ফাইলের সর্বোচ্চ আকার';
$string['maxconsecutiveidentchars'] = 'ধারাবাহিক একই রকম অক্ষর';
$string['maxeditingtime'] = 'পোস্ট সম্পাদনার সর্বোচ্চ সময়';
$string['maxusersperpage'] = 'প্রতি পৃষ্ঠায় সর্বাধিক ব্যবহারকারী';
$string['mbstringrecommended'] = 'সাইটের কার্যকারিতা বৃদ্ধি করতে ঐচ্ছিক MBSTRING লাইব্রেরি ইনস্টল করার জন্য জরুরিভাবে সুপারিশ করা হচ্ছে, বিশেষত যদি আপনার সাইটটি ল্যাটিন নয় এমন ভাষাসমূহ সমর্থন করে।';
$string['mediapluginavi'] = '.avi পরিশোধক সক্রিয়';
$string['mediapluginflv'] = '.flv পরিশোধক সক্রিয়';
$string['mediapluginimg'] = 'লিংককৃত ছবিতে স্বয়ংক্রিয়-সন্নিবেশ সক্রিয়';
$string['mediapluginmov'] = '.mov পরিশোধক সক্রিয়';
$string['mediapluginmp3'] = '.mp3 পরিশোধক সক্রিয়';
$string['mediapluginmpg'] = '.mpg পরিশোধক সক্রিয়';
$string['mediapluginogg'] = '.ogg পরিশোধক সক্রিয়';
$string['mediapluginogv'] = '.ogv পরিশোধক সক্রিয়';
$string['mediapluginram'] = '.ram পরিশোধক সক্রিয়';
$string['mediapluginrm'] = '.rm পরিশোধক সক্রিয়';
$string['mediapluginrpm'] = '.rpm পরিশোধক সক্রিয়';
$string['mediapluginswf'] = '.swf পরিশোধক সক্রিয়';
$string['mediapluginswfnote'] = 'পূর্বনির্ধারিত নিরাপত্তা পরিমাপক হিসেবে, সাধারণ ব্যবহারকারীদের swf ফ্ল্যাশ ফাইল সন্নিবেশ করার অনুমোদন দেয়া উচিত নয়।';
$string['mediapluginwmv'] = '.wmv পরিশোধক সক্রিয়';
$string['mediapluginyoutube'] = 'YouTube লিংকের পরিশোধক সক্রিয়';
$string['messaging'] = 'মেসেজিং সিস্টেম সক্রিয়';
$string['messagingallowemailoverride'] = 'বিজ্ঞপ্তি ইমেল ওভাররাইড';
$string['messagingdeletereadnotificationsdelay'] = 'পড়ার ঘোষনা মুছে ফেলা হবে';
$string['messaginghidereadnotifications'] = 'পড়ার ঘোষনা আড়াল';
$string['minpassworddigits'] = 'অঙ্ক';
$string['minpasswordlength'] = 'পাসওয়ার্ডের দৈর্ঘ্য';
$string['minpasswordlower'] = 'ছোট হাতের অক্ষর';
$string['minpasswordnonalphanum'] = 'আলফানিউমেরিক অক্ষর নয়';
$string['minpasswordupper'] = 'বড়হাতের অক্ষর';
$string['misc'] = 'বিবিধ';
$string['mnetrestore_extusers'] = '<strong>টীকা:</strong> এই ব্যাকআপ ফাইলটিতে দূরবর্তী মুডল নেটওয়ার্ক ব্যবহারকারীর অ্যাকাউন্ট রয়েছে যা এই প্রক্রিয়ার অংশ হিসেবে পুনরুদ্ধার করা হবে।';
$string['mnetrestore_extusers_admin'] = '<strong>Note:</strong> This backup file seems to come from a different Moodle installation and contains remote Moodle Network user accounts. The restore process will try to match the Moodle Network hosts for all created users. Those not matching will be automatically switched to internal authentication (instead of mnet one). The restore log will inform you about that.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Note:</strong> This backup file apparently originates from a different Moodle installation and contains remote Moodle Network user accounts that may fail to restore. This operation is unsupported. If you are certain that it was created on this Moodle installation, or you can ensure that all the needed Moodle Network Hosts are configured, you may want to still try the restore.';
$string['mnetrestore_extusers_noadmin'] = '<strong>টীকা:</strong> এই ব্যাকআপ ফাইলটি ভিন্ন কোন মুডল ইনস্টলেশন থেকে আগত বলে মনে হচ্ছে এবং এতে দূরবর্তী মুডল নেটওয়ার্কের ব্যবহারকারী অ্যাকাউন্ট রয়েছে। আপনি এ ধরনের পুনরুদ্ধার কার্যকর করার জন্য অনুমোদিত নন। সাইট প্রশাসকের সাথে যোগাযোগ করুন অথবা, বিকল্পরূপে, কোন ব্যবহারকারী তথ্য (মডিউল, ফাইল...) ছাড়াই এই কোর্সটি পুনরুদ্ধার করুন';
$string['mnetrestore_extusers_switchuserauth'] = 'মুডল নেটওয়ার্কের দূরবর্তী ব্যবহারকারী {$a->username} ({$a->mnethosturl} থেকে আগত) স্থানীয় {$a->auth} প্রমাণীকরণের ব্যবহারকারী হিসেবে পরিবর্তিত হয়েছে।';
$string['mobile'] = 'মোবাইল';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'ডিফল্ট কার্যকলাপ chooser';
$string['modeditdefaults'] = 'অ্যাক্টিভিটি সেটিংয়ের পূর্বনির্ধারিত মান';
$string['modeditingmenu'] = 'সম্পাদনা মেনুর কার্যকলাপ';
$string['modsettings'] = 'অ্যাক্টিভিটি পরিচালনা';
$string['modulesecurity'] = 'মডিউলের নিরাপত্তা';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Force old multilang syntax: &lt;span&gt; without the class="multilang" and &lt;lang&gt;';
$string['mustenablestats'] = 'এই সাইটে পরিসংখ্যান এখনও সক্রিয় করা হয়নি।';
$string['mycoursesperpage'] = 'কোর্সের সংখ্যা';
$string['mydashboard'] = 'সিস্টেমের পূর্বনির্ধারিত ড্যাশবোর্ড';
$string['mymoodle'] = 'আমার মুডল';
$string['mymoodleredirect'] = 'ব্যবহারকারীদের \'আমার মুডল\' ব্যবহার করতে জোর করা হবে';
$string['mypage'] = 'আমার মুডলের পূর্বনির্ধারিত পৃষ্ঠা';
$string['mypagelocked'] = 'পূর্বনির্ধারিত পৃষ্ঠা আবদ্ধ';
$string['myprofile'] = 'পূর্বনির্ধারিত প্রোফাইল পৃষ্ঠা';
$string['mysql416bypassed'] = 'আপনার সাইট যদি শুধুমাত্র iso-8859-1 (ল্যাটিন) ভাষাসমূহ ব্যবহার করে থাকে, আপনি আপনার বর্তমানে ইনস্টলকৃত MySQL ৪.১.১২ (বা উচ্চতর সংস্করণ) ব্যবহার করা চালিয়ে যেতে পারেন। ';
$string['mysql416required'] = 'মুডল ১.৬ এর জন্য আবশ্যক সর্বনিম্ন সংস্করণ MySQL ৪.১.১৬ যা এই নিশ্চয়তা দেয় যে পরবর্তীতে সব ডাটা UTF-8 এ রূপান্তর করা যাবে।';
$string['navadduserpostslinks'] = 'ব্যবহারকারীর পোস্ট দেখতে লিঙ্ক যোগ করুন';
$string['navcourselimit'] = 'কোর্সের সীমা';
$string['navigationupgrade'] = 'এই আপগ্রেডে দু\'টি নতুন ন্যাভিগেশন ব্লক রয়েছে যা এই ব্লকগুলোকে প্রতিস্থাপন করবে: প্রশাসন, কোর্স, কাজ, এবং অংশগ্রহণকারী।  আপনি যদি ওই ব্লকগুলোতে কোন বিশেষ অনুমোদন নির্ধারণ করে থাকেন তবে আপনার পরীক্ষা করে নিশ্চিত হওয়া উচিত সবকিছু আপনার চাহিদা অনুযায়ী কাজ করছে।';
$string['navshowallcourses'] = 'সব কোর্স প্রদর্শন';
$string['navshowcategories'] = 'কোর্সের শ্রেণীবিভাগ প্রদর্শন';
$string['navshowfrontpagemods'] = 'নেভিগেশনের মধ্যে প্রধান পৃষ্ঠার কার্যকলাপ দেখান';
$string['navshowfullcoursenames'] = 'কোর্সে পুরোনাম দেখান';
$string['navshowmycoursecategories'] = 'আমার কোর্স বিভাগ দেখান';
$string['navsortmycoursessort'] = 'আমার কোর্স বাছাই করুন';
$string['neverdeleteruns'] = 'Never delete runs';
$string['nobookmarksforuser'] = 'আপনার কোন বুকমার্ক নেই।';
$string['nodatabase'] = 'কোন ডাটাবেস নেই';
$string['nomissingstrings'] = 'কোন স্ট্রিং অনুপস্থিত নেই';
$string['nonewsettings'] = 'এই আপগ্রেডের সময় নতুন কোন সেটিংস যোগ করা হয়নি।';
$string['nonexistentbookmark'] = 'আপনি যে বুকমার্কের জন্য অনুরোধ করেছেন তা বিদ্যমান নেই।';
$string['noresults'] = 'কোন ফলাফল পাওয়া যায়নি।';
$string['noroles'] = 'কোন ভূমিকা নেই';
$string['notifications'] = 'ঘোষনা';
$string['notifyloginfailures'] = 'যেখানে ইমেইলের লগইন ব্যর্থ হয়েছে';
$string['notifyloginthreshold'] = 'ইমেইল ঘোষনার থ্রেশহোল্ড';
$string['notloggedinroleid'] = 'দর্শকদের ভূমিকা';
$string['numberofmissingstrings'] = 'অনুপস্থিত স্ট্রিংয়ের সংখ্যা: {$a}';
$string['numberofstrings'] = 'স্ট্রিংয়ের সর্বমোট সংখ্যা: {$a->strings}<br />অনুপস্থিত: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'ঐচ্ছিক OpenSSL লাইব্রেরি ইনস্টল করার জন্য জরুরিভাবে সুপারিশ করা হচ্ছে -- এটি মুডল নেটওয়ার্কের কার্যকারিতা সক্রিয় করে।';
$string['opentogoogle'] = 'গুগলে খুলুন';
$string['optionalmaintenancemessage'] = 'ঐচ্ছিক রক্ষণাবেক্ষণ বার্তা';
$string['order1'] = 'প্রথম';
$string['order2'] = 'দ্বিতীয়';
$string['order3'] = 'তৃতীয়';
$string['order4'] = 'চতুর্থ';
$string['passwordpolicy'] = 'পাসওয়ার্ডের নীতিমালা';
$string['pathconvert'] = '<i>convert</i> বাইনারির পাথ';
$string['pathdvips'] = '<i>dvips</i> বাইনারির পাথ';
$string['pathlatex'] = '<i>latex</i> বাইনারির পাথ';
$string['pathtoclam'] = 'ক্ল্যাম AV পাথ';
$string['pathtodot'] = 'ডটের পাথ';
$string['pathtodot_help'] = 'ডটের পাথ। সম্ভবত যেমন /usr/bin/dot। ডট ফাইল থেকে গ্রাফিক্স জেনারেট করতে, আপনাকে অবশ্যই ডট এক্সিকিউটেবল ইনস্টল করতে হবে এবং তা এখানে চিহ্নিত করতে হবে। মনে রাখবেন যে, এখনকার জন্য এটি শুধুমাত্র মুডলে বিল্ট করা প্রোফাইল বৈশিষ্ট্য (Development->Profiling) দ্বারা ব্যবহৃত হবে।';
$string['pathtodu'] = 'du এর পাথ';
$string['pathtopgdump'] = 'pg_dump এর পাথ';
$string['pathtopgdumpdesc'] = 'আপনার সিস্টেমে একাধিক pg_dump থাকলে শুধুমাত্র প্রবেশ করার জন্য এটি প্রয়োজন হয় (উদাহরণস্বরূপ আপনার যদি postgresql\'র একাধিক সংস্করণ ইনস্টল করা থাকে)';
$string['pathtopgdumpinvalid'] = 'pg_dump এর অকার্যকর পাথ - ভুল পাথ বা চালানো সম্ভব নয়';
$string['pathtopsql'] = 'psql এর পাথ';
$string['pathtopsqldesc'] = 'আপনার সিস্টেমে একাধিক psql থাকলে শুধুমাত্র প্রবেশ করার জন্য এটি প্রয়োজন হয় (উদাহরণস্বরূপ আপনার যদি postgresql\'র একাধিক সংস্করণ ইনস্টল করা থাকে)';
$string['pathtopsqlinvalid'] = 'psql এর অকার্যকর পাথ - ভুল পাথ বা চালানো সম্ভব নয়';
$string['perfdebug'] = 'কার্যকারিতা সম্পর্কিত তথ্যাবলী';
$string['performance'] = 'কার্যকারিতা';
$string['pgcluster'] = 'PostgreSQL ক্লাস্টার';
$string['pgclusterdescription'] = 'কমান্ড লাইন অপারেশনের জন্য PostgreSQL সংস্করণ/ক্লাস্টার প্যারামিটার। আপনার সিস্টেমে যদি শুধুমাত্র একটি postgresql থাকে বা আপনি এটা সম্পর্কে না জানেন, তবে এই ক্ষেত্রটি ফাঁকা রাখুন।';
$string['php50restricted'] = 'PHP ৫.০.x সংস্করণে অনেক ধরনের সমস্যা রয়েছে, অনুগ্রহ করে ৫.১.x সংস্করণে আপগ্রেড করুন অথবা ৪.৩.x বা ৪.৪.x সংস্করণে ডাউনগ্রেড করুন';
$string['php533warning'] = 'PHP 5.3.3 এবং উপরেরদিকে সুপারিশ করা হচ্ছে';
$string['phpfloatproblem'] = 'PHP ভগ্নাংশ নিয়ে কাজ করার সময় অপ্রত্যাশিত সমস্যা দেখা দিয়েছে - {$a}';
$string['pleaserefreshregistration'] = 'আপনার সাইটটি moodle.org\'র সাথে নিবন্ধন করা হয়েছে, {$a} এ, আপনার সর্বশেষ হালনাগাদের পর কোন গুরুত্বপূর্ণ পরিবর্তন হয়ে থাকলে অনুগ্রহ করে নিবন্ধন হালনাগাদ করুন';
$string['pleaseregister'] = 'এই বোতামটি অপসারণ করতে অনুগ্রহ করে আপনার সাইটটি নিবন্ধন করুন';
$string['plugin'] = 'প্লাগইন';
$string['plugins'] = 'প্লাগইন';
$string['pluginscheck'] = 'প্লাগইন নির্ভরতা পরীক্ষা';
$string['pluginscheckfailed'] = '{$a->pluginslist} জন্য নির্ভরতা পরিক্ষা ব্যর্থ';
$string['pluginsoverview'] = 'প্লাগইন ওভারভিউ';
$string['pluginsoverviewsee'] = 'আরও বিবরনে জন্য <a href="{$a->url}">পরিদর্শন প্লাগইন</a> পৃষ্ঠা দেখুন';
$string['profilecategory'] = 'শ্রেণীবিভাগ';
$string['profilecategoryname'] = 'শ্রেণীবিভাগের নাম (অবশ্যই অনন্য হতে হবে)';
$string['profilecategorynamenotunique'] = 'এই শ্রেণীবিভাগের নাম ইতিমধ্যেই ব্যবহৃত হচ্ছে';
$string['profilecommonsettings'] = 'সাধারণ সেটিংসমূহ';
$string['profileconfirmcategorydeletion'] = 'এই শ্রেণীবিভাগে {$a} টি ক্ষেত্র রয়েছে যা উপরের (অথবা শীর্ষ শ্রেণীবিভাগ হলে নিচের) শ্রেণীবিভাগে সরানো হবে।<br />আপনি কি এখনও শ্রেণীবিভাগটি মুছে ফেলতে চান?';
$string['profileconfirmfielddeletion'] = 'এই ক্ষেত্রটিতে {$a} জন ব্যবহারকারীর রেকর্ড রয়েছে যা মুছে যাবে।<br />আপনি কি এখনও ক্ষেত্রটি মুছে ফেলতে চান?';
$string['profilecreatecategory'] = 'প্রোফাইলের নতুন শ্রেণীবিভাগ তৈরি';
$string['profilecreatefield'] = 'প্রোফাইলের নতুন ক্ষেত্র তৈরি:';
$string['profilecreatenewcategory'] = 'নতুন শ্রেণীবিভাগ তৈরি করা হচ্ছে';
$string['profilecreatenewfield'] = 'নতুন একটি প্রোফাইলের ক্ষেত্র &quot;{$a}&quot; তৈরি করা হচ্ছে';
$string['profiledefaultcategory'] = 'অন্যান্য ক্ষেত্র';
$string['profiledefaultchecked'] = 'পূর্বনির্ধারিতভাবে পরীক্ষিত';
$string['profiledefaultdata'] = 'পূর্বনির্ধারিত মান';
$string['profiledeletecategory'] = 'শ্রেণীবিভাগ মুছে ফেলা হচ্ছে';
$string['profiledeletefield'] = 'ক্ষেত্র মুছে ফেলা হচ্ছে';
$string['profiledescription'] = 'ক্ষেত্রের বিবরণ';
$string['profiledscript'] = 'এই স্ক্রিপ্টকে প্রোফাইল করা হয়েছে';
$string['profiledscriptview'] = 'এই স্ক্রিপ্টের জন্য প্রোফাইল তথ্য প্রদর্শন';
$string['profileeditcategory'] = 'শ্রেণীবিভাগ সম্পাদনা করা হচ্ছে: {$a}';
$string['profileeditfield'] = 'প্রোফাইলের ক্ষেত্র সম্পাদনা করা হচ্ছে: {$a}';
$string['profilefield'] = 'প্রোফাইলের ক্ষেত্র';
$string['profilefieldcolumns'] = 'কলাম';
$string['profilefieldispassword'] = 'এটা কি পাসওয়ার্ডের ক্ষেত্র?';
$string['profilefieldlink'] = 'লিংক';
$string['profilefieldlink_help'] = 'পাঠ্যকে লিংকে রূপান্তর করার জন্য, এমন একটি URL দিন যাতে $$ রয়েছে, যেখানে $$ পাঠ্য দ্বারা প্রতিস্থাপিত হবে। উদাহরণস্বরূপ, Twitter ID-কে লিংকে রূপান্তর করতে, http://twitter.com/$$ দিন।';
$string['profilefieldlinktarget'] = 'লিংকের গন্তব্য';
$string['profilefieldmaxlength'] = 'সর্বোচ্চ দৈর্ঘ্য';
$string['profilefieldrows'] = 'সারি';
$string['profilefields'] = 'ব্যবহারকারীর প্রোফাইলের ক্ষেত্র';
$string['profilefieldsize'] = 'প্রদর্শনের আকার';
$string['profileforceunique'] = 'ডাটা অনন্য হতে হবে কি?';
$string['profileinvaliddata'] = 'অকার্যকর মান';
$string['profilelocked'] = 'এই ক্ষেত্রটি কি আবদ্ধ?';
$string['profilemenudefaultnotinoptions'] = 'পূর্বনির্ধারিত মান কোন অপশন নয়';
$string['profilemenunooptions'] = 'কোন মেনু অপশন নেই';
$string['profilemenuoptions'] = 'মেনু অপশন (প্রতি লাইনে একটি)';
$string['profilemenutoofewoptions'] = 'আপনাকে অন্তত ২ টি অপশন দিতে হবে';
$string['profilename'] = 'নাম';
$string['profilenofieldsdefined'] = 'কোন ক্ষেত্র নির্ধারণ করা হয়নি';
$string['profilerequired'] = 'এই ক্ষেত্রটি কি আবশ্যকীয়?';
$string['profileroles'] = 'প্রোফাইলের দৃশ্যমান ভূমিকা';
$string['profilesforenrolledusersonly'] = 'শুধুমাত্র তালিকাভুক্ত ব্যবহারকারীর প্রোফাইল';
$string['profileshortname'] = 'ডাক নাম (অবশ্যই অনন্য হতে হবে)';
$string['profileshortnamenotunique'] = 'এই ডাক নামটি ইতিমধ্যেই ব্যবহৃত হচ্ছে';
$string['profilesignup'] = 'সাইনআপ পৃষ্ঠায় প্রদর্শন করা হবে কি?';
$string['profilespecificsettings'] = 'সুনির্দিষ্ট সেটিংসমূহ';
$string['profilevisible'] = 'এই ক্ষেত্রটি কার কাছে দৃশ্যমান হবে?';
$string['profilevisibleall'] = 'সবার কাছে দৃশ্যমান';
$string['profilevisible_help'] = '* দৃশ্যমান নয় - শুধুমাত্র প্রশাসকের কাছে প্রদর্শনযোগ্য একান্ত তথ্য
* ব্যবহারকারীর কাছে দৃশ্যমান - শুধুমাত্র ব্যবহারকারী ও প্রশাসকের কাছে প্রদর্শনযোগ্য একান্ত তথ্য
* সবার কাছে দৃশ্যমান';
$string['profilevisiblenone'] = 'দৃশ্যমান নয়';
$string['profilevisibleprivate'] = 'ব্যবহারকারীর কাছে দৃশ্যমান';
$string['profiling'] = 'প্রোফাইল করা হচ্ছে';
$string['profilingallowall'] = 'ধারাবাহিকভাবে প্রোফাইল করা হচ্ছে';
$string['profilingallowall_help'] = 'মুডল সেশন সময়কালে আপনি যদি এই সেটিং সক্রিয় করেন তাহলে যেকোন মুহূর্তে যেকোন স্থানে (PGC) সব এক্সিকিউটেড স্ট্রিং এর জন্য আপনি PROFILEALL প্যারামিটার ব্যবহার করে প্রোফাইলিং সক্রিয় করতে পারবেন। একইভাবে, এটি বন্ধ করতে আপনি PROFILEALLSTOP প্যারামিটার ব্যবহার করতে পারেন।';
$string['profilingallowme'] = 'নির্বাচিত প্রোফাইল করা হচ্ছে';
$string['profilingallowme_help'] = 'আপনি যদি এই সেটিং সক্রিয় করেন তাহলে নির্বাচিতভাবে যেকোন মুহূর্তে যেকোন স্থানে (PGC) আপনি PROFILEME প্যারামিটার ব্যবহার করতে পারবেন এবং এই স্ক্রিপ্ট প্রোফাইলিং করতে পারবেন। একইভাবে, প্রোফাইলিং বাধা দিতে আপনি DONTPROFILEME প্যারামিটার ব্যবহার করতে পারেন';
$string['profilingautofrec'] = 'স্বয়ংক্রিয় প্রোফাইলিং';
$string['profilingenabled'] = 'প্রোফাইলিং সক্রিয়';
$string['profilingenabled_help'] = 'আপনি যদি এ সেটিং সক্রিয় করেন তবে, এ সাইটে প্রোফাইলিং ও করতে পারবেন এবং পরবর্তী অপশন কনফিগার করে এ বৈশিষ্ট্য নির্ধারণ করতে পারবেন।';
$string['profilingexcluded'] = 'প্রোফাইলিং বাধা দেওয়া';
$string['profilingexcluded_help'] = '\'এগুলোর প্রোফাইল\' দ্বারা সেটিং নির্ধারিত থাকলে তা থেকে URL এর তালিকা (কমা দিয়ে বিভক্ত, wwwroot সম্পুর্ণ বাদ দেওয়া হবে, কল্যাবল) প্রোফাইল বাদ দেওয়া হবে।';
$string['profilingimportprefix'] = 'প্রফিক্স প্রোফাইলিং আমদানি';
$string['profilingincluded'] = 'এর প্রোফাইল';
$string['profilingincluded_help'] = 'URL এর তালিকা (কমা দিয়ে বিভক্ত, wwwroot সম্পুর্ণ বাদ দেওয়া হবে, কল্যাবল) স্বয়ংক্রিয়ভাবে প্রোফাইল করা হবে। উদাহরণ: /index.php, /course/view.php। যে কোন স্থানে * wildchar ও গ্রহণ করা হবে। উদাহরণ: /mod/forum/*, /mod/*/view.php।';
$string['profilinglifetime'] = 'প্রোফাইলিং চালু রাখুন';
$string['profilinglifetime_help'] = 'পুরানো প্রোফাইলিং চালু তথ্য কতদিন পর্যন্ত রাখতে চান তা উল্লেখ করুন। পুরানোটি পর্যায়ক্রমে ছেঁটে ফোলা হবে। মনে রাখবেন এটি যে কোন \'reference run\' চিহ্নিত প্রোফাইলিং বাদ দেয়।';
$string['protectusernames'] = 'ব্যবহারকারীর নাম সুরক্ষিত';
$string['proxybypass'] = 'প্রক্সি বাইপাস হোস্ট';
$string['proxyhost'] = 'প্রক্সি হোস্ট';
$string['proxypassword'] = 'প্রক্সির পাসওয়ার্ড';
$string['proxyport'] = 'প্রক্সি পোর্ট';
$string['proxytype'] = 'প্রক্সির ধরন';
$string['proxyuser'] = 'প্রক্সির ব্যবহারকারী নাম';
$string['purgecaches'] = 'সব ক্যাশে পার্জ';
$string['purgecachesconfirm'] = 'মুডল থীম, জাভাস্ক্রিপ্ট, ল্যাংগুয়েজ স্ট্রিং, পরিশোধিত পাঠ্য, rss ফিড এবং অন্যান্য আরও অনেক ধরনের ডাটা ক্যাশে করতে পারে।  এই ক্যাশেগুলো পার্জ করা হলে সার্ভার থেকে ওই ডাটা মুছে যাবে এবং ব্রাউজারকে ডাটা পুনরায় লোড করতে জোর করা হবে, যাতে আপনি নিশ্চিত হতে পারেন আপনি বর্তমান কোড ব্যবহার করে উৎপাদিত সর্বশেষ হালনাগাদকৃত মান দেখছেন।  ক্যাশে পার্জ করার ক্ষেত্রে কোন ঝুঁকি নেই, কিন্তু সার্ভার ও ক্লায়েন্ট নতুন তথ্য গণনা এবং ক্যাশে না করা পর্যন্ত আপনার সাইটটি কিছুটা ধীর হয়ে যেতে পারে।';
$string['purgecachesfinished'] = 'সব ক্যাশে পার্জ করা হয়েছে।';
$string['qtyperqpwillberemoved'] = 'আপগ্রেড করার সময়, RQP ধরনের প্রশ্ন অপসারিত হবে। আপনি এই ধরনের প্রশ্ন ব্যবহার করেননি, সুতরাং আপনার কোন সমস্যা হওয়ার কথা নয়। ';
$string['qtyperqpwillberemovedanyway'] = 'আপগ্রেড করার সময়, RQP ধরনের প্রশ্ন অপসারণ করা হবে। আপনার ডাটাবেসে কিছু RQP প্রশ্ন রয়েছে, এবং আপগ্রেড চালিয়ে যাওয়ার আগে http://moodle.org/mod/data/view.php?d=13&amp;rid=797 থেকে এর কোড পুনরায় ইনস্টল না করলে এগুলো কাজ করা বন্ধ করে দেবে।';
$string['quarantinedir'] = 'কুয়ারান্টাইন ডিরেক্টরি';
$string['question'] = 'প্রশ্ন';
$string['questionbehaviours'] = 'প্রশ্ন আচরণ';
$string['questioncwqpfscheck'] = 'কুইজের এক বা একাধিক \'এলোমেলো\' প্রশ্নকে শেয়ার করা ও শেয়ার না করা প্রশ্নের মিশ্রণ থেকে নির্বাচন করার জন্য নির্ধারণ করা হয়েছে। আপনি <a href="{$a->reporturl}">এখানে</a> আরও বিস্তারিত বিবরণ পাবেন এবং <a href="{$a->docsurl}">এখানে</a> মুডল ডকুমেন্ট দেখতে পাবেন।';
$string['questioncwqpfsok'] = 'ভালো। আপনার কুইজে কোন \'এলোমেলো\' প্রশ্ন নেই যা শেয়ার করা ও শেয়ার না করা প্রশ্নের মিশ্রণ থেকে নির্বাচন করার জন্য নির্ধারণ করা হবে। ';
$string['questiontype'] = 'প্রশ্নের ধরন';
$string['questiontypes'] = 'প্রশ্নের ধরন';
$string['recaptchaprivatekey'] = 'ReCAPTCHA প্রাইভেট কী';
$string['recaptchapublickey'] = 'ReCAPTCHA পাবলিক কী';
$string['register'] = 'আপনার সাইটে নিবন্ধন';
$string['registermoodleorg'] = 'যখন আপনার সাইটের সাথে আপনি {$a} নিবন্ধন করবেন';
$string['registerwithmoodleorg'] = 'Moodle.org সঙ্গে নিবন্ধন';
$string['registration'] = 'নিবন্ধন';
$string['registrationwarning'] = 'আপনার সাইটটি এখনও নিবন্ধীকৃত হয় নি.';
$string['releasenoteslink'] = 'মুডলের এই সংস্করণ সম্পর্কিত তথ্যের জন্য, অনুগ্রহ করে অনলাইনে <a target="_blank" href="{$a}">রিলিজ নোট</a> দেখুন';
$string['rememberusername'] = 'ব্যবহারকারীর নাম মনে রাখুন';
$string['reportsmanage'] = 'রির্পোট পরিচালনা';
$string['requestcategoryselection'] = 'বিভাগ নির্বাচন সক্রিয়';
$string['requiredentrieschanged'] = '<strong>গুরুত্বপূর্ণ - অনুগ্রহ করে পড়ুন<br/>(এই সতর্কবার্তাটি শুধুমাত্র এই আপগ্রেডের সময় প্রদর্শিত হবে)</strong><br/>বাগ নির্ধারণ করার জন্য, \'আবশ্যকীয় ভুক্তি\' ও \'সেটিংসমূহ প্রদর্শনের আগের আবশ্যকীয়  ভুক্তি\'র সেটিংসমূহ ব্যবহার করে ডাটাবেস অ্যাক্টিভিটির আচরণ পরিবর্তন করা হবে। ডাটাবেস মডিউল ফোরাম <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">এ পরিবর্তনগুলো সম্পর্কে আরও বিস্তারিত বিবরণ পাবেন</a>। এই সেটিংসমূহের প্রত্যাশিত আচরণ সম্পর্কে জানতে <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">মুডল ডকুমেন্টও</a> পড়তে পারেন।
<br/><br/>এই পরিবর্তন আপনার সিস্টেমের নিম্নোক্ত ডাটাবেসগুলোকে প্রভাবিত করে: (অনুগ্রহ করে এই তালিকাটি এখন সংরক্ষণ করুন, এবং আপগ্রেড করার পর, পরীক্ষা করে দেখুন যে এই অ্যাক্টিভিটিগুলো এখনও শিক্ষকের উদ্দেশ্য অনুযায়ী পদ্ধতিতে কাজ করছে কিনা।)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'কাজের বিবরণ আবশ্যক';
$string['requires'] = 'আবশ্যক';
$string['reverseproxy'] = 'বিপরীত প্রক্সি';
$string['riskconfig'] = 'ব্যবহারকারীরা সাইটের কনফিগারেশন ও আচরণ পরিবর্তন করতে পারেন';
$string['riskconfigshort'] = 'কনফিগারেশন ঝুঁকি';
$string['riskdataloss'] = 'ব্যবহারকারীরা বিপুল পরিমাণের বিষয়বস্তু বা তথ্য ধ্বংস করে দিতে পারে ';
$string['riskdatalossshort'] = 'উপাত্ত হারানোর ঝুঁকি';
$string['riskmanagetrust'] = 'ব্যবহারকারীরা অন্যান্য ব্যবহারকারীর বিশ্বস্ততা সেটিং পরিবর্তন করতে পারেন';
$string['riskmanagetrustshort'] = 'বিশ্বস্ততা ব্যবস্থাপনা';
$string['riskpersonal'] = 'ব্যবহারকারীরা অন্যান্য ব্যবহারকারীদের ব্যক্তিগত তথ্যাবলীতে প্রবেশ করতে পারেন';
$string['riskpersonalshort'] = 'নিরাপত্তা ঝুঁকি';
$string['riskspam'] = 'ব্যবহারকারীরা সাইটের ব্যবহারকারী বা অন্যান্যদের স্প্যাম পাঠাতে পারেন';
$string['riskspamshort'] = 'স্প্যাম ঝুঁকি';
$string['riskxss'] = 'ব্যবহারকারীরা ক্রস-সাইট স্ক্রিপ্টিং (XSS) অনুমোদনকারী ফাইল ও পাঠ্য যোগ করতে পারেন';
$string['riskxssshort'] = 'XSS ঝুঁকি';
$string['roleswithexceptions'] = '{$a->exceptions} সহ, {$a->roles}';
$string['rssglobaldisabled'] = 'সার্ভার লেভেলে নিষ্ক্রিয়';
$string['runclamavonupload'] = 'আপলোডকৃত ফাইলে ক্ল্যাম AV ব্যবহার';
$string['save'] = 'সংরক্ষণ';
$string['savechanges'] = 'পরিবর্তন সংরক্ষণ';
$string['search'] = 'অনুসন্ধান';
$string['searchinsettings'] = 'সেটিংসমূহে অনুসন্ধান';
$string['searchresults'] = 'অনুসন্ধানের ফলাফল';
$string['sectionerror'] = 'সেকশন ত্রুটি!';
$string['secureforms'] = 'অতিরিক্ত ফরম নিরাপত্তা ব্যবহার';
$string['security'] = 'নিরাপত্তা';
$string['selectdevice'] = 'ডিভাইস নির্বাচন';
$string['selecttheme'] = '{$a} ডিভাইসের জন্য থিম নির্বাচন';
$string['server'] = 'সার্ভার';
$string['serverchecks'] = 'সার্ভার পরীক্ষণ';
$string['serverlimit'] = 'সার্ভারের সীমা';
$string['sessionautostartwarning'] = '<p>জটিল কনফিগারেশন ত্রুটি শনাক্ত করা হয়েছে, অনুগ্রহ করে সার্ভার প্রশাসককে জানান।</p><p> মুডলের যথাযথভাবে কাজ করার জন্য, প্রশাসকের দ্বারা PHP সেটিংসমূহ পরিবর্তন করা প্রয়োজন।</p><p><code>session.auto_start</code> অবশ্যই বন্ধ হিসেবে নির্ধারণ <code>করতে হবে</code>।</p><p>সার্ভারের <code>php.ini</code>, Apache/IIS <br />কনফিগারেশন বা <code>.htaccess</code> ফাইলে সম্পাদনা করার মাধ্যমে এই সেটিংসমূহ নিয়ন্ত্রণ করা হয়।</p>';
$string['sessioncookie'] = 'কুকি প্রিফিক্স';
$string['sessioncookiedomain'] = 'কুকি ডোমেইন';
$string['sessioncookiepath'] = 'কুকি পাথ';
$string['sessionhandling'] = 'সেশন পরিচালনা';
$string['sessiontimeout'] = 'সময় উত্তীর্ণ';
$string['settingfileuploads'] = 'সাধারণ অপারেশনের জন্য ফাইল আপলোড করা প্রয়োজন, অনুগ্রহ করে এটি PHP কনফিগারেশনে সক্রিয় করুন।';
$string['settingmemorylimit'] = 'অপর্যাপ্ত মেমরি শনাক্ত করা হয়েছে, অনুগ্রহ করে PHP সেটিংয়ের জন্য মেমরির উচ্চতর সীমা নির্ধারণ করুন।';
$string['settingsafemode'] = 'মুডল নিরাপদ মোডের সাথে পুরোপুরি সঙ্গতিপূর্ণ নয়, অনুগ্রহ করে সার্ভার প্রশাসককে এটি বন্ধ করে দিতে বলুন। নিরাপদ মোডের অধীনে মুডল চালানো সমর্থিত নয়, আপনি এমনটি করলে বিভিন্ন ধরনের সমস্যার সৃষ্টি হবে।';
$string['showcommentscount'] = 'মন্তব্যের গণনা প্রদর্শন';
$string['showdetails'] = 'বিস্তারিত তথ্য প্রদর্শন';
$string['showuseridentity'] = 'ব্যবহারকারীর পরিচয় প্রদর্শন করুন';
$string['simplexmlrequired'] = 'মুডলের এই মুহূর্তে SimpleXML PHP বর্ধিতাংশটি প্রয়োজন।';
$string['sitemaintenance'] = 'সাইটটিতে রক্ষণাবেক্ষণের কাজ চলছে এবং এই মুহূর্তে বিদ্যমান নেই';
$string['sitemaintenancemode'] = 'রক্ষণাবেক্ষণ মোড';
$string['sitemaintenanceoff'] = 'রক্ষণাবেক্ষণ মোড নিষ্ক্রিয় করা হয়েছে এবং সাইটটি আবারও স্বাভাবিকভাবে চলছে';
$string['sitemaintenanceon'] = 'আপনার সাইটটি এই মুহূর্তে রক্ষণাবেক্ষণ মোডে রয়েছে (শুধুমাত্র প্রশাসকরাই সাইটটিতে লগইন বা ব্যবহার করতে পারবেন)।';
$string['sitemaintenancewarning'] = 'আপনার সাইটটি এই মুহূর্তে রক্ষণাবেক্ষণ মোডে রয়েছে (শুধুমাত্র প্রশাসকরাই লগইন করতে পারবেন)।  সাইটটিকে সাধারণ অপারেশনে ফিরিয়ে নিতে, <a href="maintenance.php">রক্ষণাবেক্ষণ মোড নিষ্ক্রিয়</a> করুন।';
$string['sitemaintenancewarning2'] = 'আপনার সাইটটি এই মুহূর্তে রক্ষণাবেক্ষণ মোডে রয়েছে (শুধুমাত্র প্রশাসকরাই লগইন করতে পারবেন)।  সাইটটিকে সাধারণ অপারেশনে ফিরিয়ে নিতে, <a href="{$a}">রক্ষণাবেক্ষণ মোড নিষ্ক্রিয়</a> করুন।';
$string['sitepolicies'] = 'সাইটের নীতিমালা';
$string['sitepolicy'] = 'সাইটের নীতিমালা সংক্রান্ত URL';
$string['sitepolicyguest'] = 'অতিথিদের জন্য সাইটের নীতিমালা সংক্রান্ত URL';
$string['sitepolicyguest_help'] = 'আপনার সাইটে যদি এমন কোন নীতিমালা থাকে যে সব অতিথি ব্যবহারকারীকে সাইট ব্যবহার করার আগে অবশ্যই এটি দেখতে হবে এবং এর সাথে সম্মতি জ্ঞাপন করতে হবে, তবে তার URL এখানে দিন, অন্যথায় ক্ষেত্রটি ফাঁকা রাখুন। এই সেটিং এ যেকোন পাবলিক URL থাকতে পারে। টীকা: forcelogin সেটিংয়ের মাধ্যমে অনিবন্ধিত ব্যবহারকারীদের প্রবেশ প্রতিরোধ করা হতে পারে।';
$string['sitepolicy_help'] = 'আপনার সাইটে যদি এমন কোন নীতিমালা থাকে যে সব নিবন্ধিত ব্যবহারকারীকে সাইট ব্যবহার করার আগে অবশ্যই এটি দেখতে হবে এবং এর সাথে সম্মতি জ্ঞাপন করতে হবে, তবে তার URL এখানে দিন, অন্যথায় ক্ষেত্রটি ফাঁকা রাখুন। এই সেটিং এ যেকোন পাবলিক URL থাকতে পারে।';
$string['sitesectionhelp'] = 'নির্বাচন করা হলে, বিষয় অংশ সাইটের প্রথম পৃষ্ঠায় প্রদর্শিত হবে।';
$string['slasharguments'] = 'স্ল্যাশ আর্গুমেন্ট ব্যবহার';
$string['smartpix'] = 'স্মার্ট পিক্স অনুসন্ধান';
$string['soaprecommended'] = 'ঐচ্ছিক soap বর্ধিতাংশটি ইনস্টল করলে ওয়েব সার্ভিস ও কিছু contrib মডিউলের ক্ষেত্রে ব্যবহার্য হবে।';
$string['sort_fullname'] = 'কোর্সের পুরো নাম';
$string['sort_idnumber'] = 'কোর্সের আইডি নম্বর';
$string['sort_shortname'] = 'কোর্সের ছোটো নাম';
$string['sort_sortorder'] = 'ছোট আদেশ';
$string['spellengine'] = 'বানান ইঞ্জিন';
$string['spelllanguagelist'] = 'ভাষার বানান তালিকা';
$string['splrequired'] = 'মুডলের এই মুহূর্তে SPL PHP বর্ধিতাংশটি প্রয়োজন।';
$string['stats'] = 'পরিসংখ্যান';
$string['statsfirstrun'] = 'সর্বোচ্চ প্রক্রিয়াধীন বিরতি';
$string['statsmaxruntime'] = 'সর্বোচ্চ রানটাইম';
$string['statsmoodleorg'] = 'পরিসংখ্যান';
$string['statsruntimedays'] = 'প্রক্রিয়াকরণ করতে যে কয়দিন লাগবে';
$string['statsruntimestart'] = 'যেখানে চালানো হবে';
$string['statsuserthreshold'] = 'ব্যবহারকারী থ্রেশহোল্ড';
$string['stickyblocks'] = 'স্টিকি ব্লক';
$string['stickyblockscourseview'] = 'কোর্সের পৃষ্ঠা';
$string['stickyblocksduplicatenotice'] = 'আপনি যদি এখানে কোন ব্লক যোগ করেন যা একটি নির্দিষ্ট পৃষ্ঠায় ইতিমধ্যেই বিদ্যমান, তবে এর একটি প্রতিলিপি তৈরি হবে।<br />বিদ্যমান প্রতিলিপিতে সম্পাদনা করা যাবে, কিন্তু শুধুমাত্র পিনকৃত ব্লকটিতেই সম্পাদনা করা যাবে না।';
$string['stickyblocksmymoodle'] = 'আমার মুডল';
$string['stickyblockspagetype'] = 'যে ধরনের পৃষ্ঠা কনফিগার করা হবে';
$string['strictformsrequired'] = 'প্রয়োজনীয় ক্ষেত্রগুলি কঠোর বৈধতা দেওয়া হবে';
$string['stripalltitletags'] = 'সব অ্যাক্টিভিটির নাম থেকে HTML ট্যাগ অপসারণ';
$string['supportcontact'] = 'যোগাযোগ সহায়তা';
$string['supportemail'] = 'সমর্থন ইমেইল';
$string['supportname'] = 'সমর্থনের নাম';
$string['supportpage'] = 'সমর্থন পৃষ্ঠা';
$string['suspenduser'] = 'ব্যবহারকারীর এ্যাকাউন্ট ভঙ্গ করা';
$string['switchlang'] = 'ল্যাংগুয়েজ ডিরেক্টরি পরিবর্তন';
$string['systempaths'] = 'সিস্টেম পাথ';
$string['tablenosave'] = 'টেবিলের উপরের পরিবর্তনগুলো স্বয়ংক্রিয়ভাবে সংরক্ষিত হয়েছে।';
$string['tablesnosave'] = 'টেবিলের উপরের পরিবর্তনগুলো স্বয়ংক্রিয়ভাবে সংরক্ষিত হয়েছে।';
$string['tabselectedtofront'] = 'ট্যাবসহ টেবিলগুলোতে, বর্তমানে নির্বাচিত ট্যাবের সারি সামনে থাকা উচিত';
$string['tabselectedtofronttext'] = 'নির্বাচিত ট্যাবের সারিকে সামনে আনা হবে';
$string['themedesignermode'] = 'থীম ডিজাইনার মোড';
$string['themelist'] = 'থীমের তালিকা';
$string['themenoselected'] = 'কোনো থিম নির্বাচন হয়নি';
$string['themeresetcaches'] = 'থীম ক্যাশে পরিষ্কার';
$string['themeselect'] = 'থিম পরিবর্তন';
$string['themeselector'] = 'থীম নির্বাচক';
$string['themesettings'] = 'থীম সেটিংসমূহ';
$string['therewereerrors'] = 'আপনার উপাত্তে ত্রুটি রয়েছে';
$string['thirdpartylibrary'] = 'লাইব্রেরী';
$string['thirdpartylibrarylocation'] = 'স্থান';
$string['thirdpartylibs'] = 'থার্ড পার্টি লাইব্রেরী';
$string['timezone'] = 'পূর্বনির্ধারিত সময় অঞ্চল';
$string['timezoneforced'] = 'সাইট প্রশাসকের দ্বারা জোর করা হচ্ছে';
$string['timezoneisforcedto'] = 'সব ব্যবহারকারীকে ব্যবহার করতে বাধ্য করা হবে';
$string['timezonenotforced'] = 'ব্যবহারকারীরা তাদের নিজস্ব সময় অঞ্চল নির্বাচন করতে পারবেন';
$string['tokenizerrecommended'] = 'ঐচ্ছিক PHP Tokenizer বর্ধিতাংশটি ইনস্টল করার জন্য সুপারিশ করা হচ্ছে -- এটি মুডল নেটওয়ার্কের কার্যকারিতা বৃদ্ধি করে।';
$string['tools'] = 'অ্যাডমিন টুল';
$string['toolsmanage'] = 'অ্যাডমিন টুল পরিচালনা';
$string['unattendedoperation'] = 'অসম্পাদিত অপারেশন';
$string['unbookmarkthispage'] = 'পৃষ্ঠাটি বুকমার্কহীন করা হবে';
$string['unicoderecommended'] = 'আপনার সব ডাটা ইউনিকোড (UTF-8) এ সংরক্ষণ করার জন্য সুপারিশ করা হচ্ছে। যেসব ডাটাবেসের পূর্বনির্ধারিত অক্ষর সমষ্টি ইউনিকোড হিসেবে রয়েছে সেখানে নতুন ইনস্টলেশন চালাতে হবে।  আপনি যদি আপগ্রেড করেন, তবে অবশ্যই UTF-8 মাইগ্রেশন প্রক্রিয়াটি চালানো উচিত (প্রশাসক পৃষ্ঠা দেখুন)।';
$string['unicoderequired'] = 'আপনাকে আপনার সব ডাটা ইউনিকোড ফরম্যাট (UTF-8) এ সংরক্ষণ করতে হবে। যেসব ডাটাবেসের পূর্বনির্ধারিত অক্ষর সমষ্টি ইউনিকোড হিসেবে রয়েছে সেখানে নতুন ইনস্টলেশন চালাতে হবে।  আপনি যদি আপগ্রেড করেন, তবে অবশ্যই UTF-8 মাইগ্রেশন প্রক্রিয়াটি চালানো উচিত (প্রশাসক পৃষ্ঠা দেখুন)।';
$string['uninstallplugin'] = 'আনইনস্টল';
$string['unlockaccount'] = 'অ্যাকাউন্ট আনলক করুন';
$string['unsettheme'] = 'অনসেট থিম';
$string['unsupported'] = 'অসমর্থিত';
$string['unsuspenduser'] = 'ব্যবহারকারীর অ্যাকাউন্ট সক্রিয় করুন';
$string['updateaccounts'] = 'বিদ্যমান অ্যাকাউন্ট হালনাগাদ';
$string['updateautocheck'] = 'উপলব্ধ আপডেট জন্য স্বয়ংক্রিয়ভাবে পরীক্ষা';
$string['updateautodeploy'] = 'আপডেট স্থাপনার সক্রিয় করুন';
$string['updateavailable'] = 'নতুন মুডোল সংস্করণ উপলব্ধ আছে!';
$string['updateavailabledetailslink'] = 'আরও বিবরণ জন্য {$a->url} দেখুন';
$string['updateavailableinstall'] = 'এই আপডেটে ইনস্টল করুন';
$string['updateavailable_moreinfo'] = 'আরও তথ্য ...';
$string['updateavailablenot'] = 'আপনার Moodle কোড আপ টু ডেট আছে!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = '{$a} সংস্কারণ';
$string['updatecomponent'] = 'উপাদান হালনাগাদ';
$string['updateminmaturity'] = 'প্রয়োজনীয় কোড পরিপক্বতা';
$string['updatenotifications'] = 'বিজ্ঞপ্তি আপডেট';
$string['updatenotificationsubject'] = 'Moodle আপডেট উপলব্ধ ({$a->siteurl})';
$string['updatenotifybuilds'] = 'নতুন ভাবে সম্পর্কে সূচিত করুন';
$string['upgrade197notice'] = '<p>মুডল ১.৯.৭ এ নিরাপত্তা সংক্রান্ত একাধিক সংশোধনী রয়েছে যা আপনার সাইটে ব্যবহারকারীর ডাটা যেমন পাসওয়ার্ড বা ব্যাকআপ সুরক্ষিত রাখে। এর ফলে ব্যাকআপ সম্পর্কিত আপনার সেটিংসমূহ ও অনুমতি পরিবর্তিত হয়ে যেতে পারে।<br />
বিস্তারিত তথ্যের জন্য <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">মুডল ১.৯.৭ রিলিজ নোট</a> দেখুন।</p>';
$string['upgrade197noticesubject'] = 'মুডল ১.৯.৭ আপগ্রেডের নিরাপত্তা বিজ্ঞপ্তি';
$string['upgrade197salt'] = 'পাসওয়ার্ড চুরির ঝুঁকি কমাতে, আপনাকে পাসওয়ার্ড সল্ট নির্ধারণ করার জন্য জরুরিভাবে সুপারিশ করা যাচ্ছে।<br />বিস্তারিত তথ্যের জন্য <a href="{$a}" target="_blank">পাসওয়ার্ড সল্টিং ডকুমেন্টেশন</a> দেখুন।';
$string['upgradeerror'] = '{$a->version} সংস্করণের {$a->plugin} আপগ্রেড করার সময় অজানা ত্রুটি দেখা দিয়েছে, চালিয়ে যাওয়া সম্ভব নয়।';
$string['upgradeforumread'] = 'পঠিত/অপঠিত ফোরাম পোস্ট চিহ্নিত করার জন্য মুডল ১.৫ এ নতুন বৈশিষ্ট্য যোগ করা হয়েছে।<br />এই বৈশিষ্ট্যটি ব্যবহার করার জন্য <a href="{$a}">আপনার টেবিলগুলো হালনাগাদ</a> করা প্রয়োজন।';
$string['upgradeforumreadinfo'] = 'পঠিত/অপঠিত ফোরাম পোস্ট চিহ্নিত করার জন্য মুডল ১.৫ এ একটি নতুন বৈশিষ্ট্য যোগ করা হয়েছে।  এই বৈশিষ্ট্যটি ব্যবহার করতে বিদ্যমান সব পোস্ট ট্র্যাক করার জন্য প্রয়োজনীয় তথ্যাবলীসহ আপনার টেবিলগুলো হালনাগাদ করা প্রয়োজন।  আপনার সাইটের আকারের উপর নির্ভর করে এতে দীর্ঘ সময় (ঘন্টা) লাগতে পারে এবং ডাটাবেসের জন্য অনেকটা কঠিন হতে পারে, সুতরাং এই কাজটি অবসর সময়ে করাই শ্রেয়।  যাহোক, এই আপগ্রেড চলাকালীন সময়েও আপনার সাইট ঠিকমতই কাজ করতে থাকবে এবং ব্যবহারকারীরা কোনভাবে ক্ষতিগ্রস্থ হবে না।  একবার এই প্রক্রিয়া শুরু করলে সেটা শেষ পর্যন্ত করা উচিত (ব্রাউজার উইন্ডো খোলা রেখে)।  উইন্ডো বন্ধ করার মাধ্যমে আপনি যদি প্রক্রিয়াটি বন্ধও করে দেন: চিন্তিত হওয়ার কিছু নেই, আপনি আবার শুরু করতে পারেন।<br /><br />আপনি কি এখনই আপগ্রেড প্রক্রিয়া আরম্ভ করতে চান?';
$string['upgradelogs'] = 'সম্পূর্ণ কার্যকারিতার জন্য, আপনার পুরোনো লগগুলো আপগ্রেড করা প্রয়োজন।  <a href="{$a}">আরও তথ্য</a>';
$string['upgradelogsinfo'] = 'লগ সংরক্ষণের পদ্ধতিতে সম্প্রতি কিছু পরিবর্তন করা হয়েছে।  প্রতিটি কাজের ভিত্তিতে পুরোনো সব লগ দেখার জন্য, আপনার পুরোনো লগগুলো আপগ্রেড করা প্রয়োজন।  আপনার সাইটের উপর নির্ভর করে এতে অনেক সময় লাগতে পারে (যেমন: কয়েক ঘন্টা) এবং বড় সাইটের ডাটাবেসের জন্য অনেক সময় কাজটি অনেক কঠিন হতে পারে।  একবার এই প্রক্রিয়া শুরু করলে সেটা শেষ পর্যন্ত করা উচিত (ব্রাউজার উইন্ডো খোলা রেখে)।  চিন্তিত হওয়ার কিছু নেই - লগ আপগ্রেড করার সময়ও আপনার সাইটটি অন্যান্য মানুষের জন্য ঠিকই কাজ করবে।<br /><br />আপনি কি এখনই আপনার লগগুলো আপগ্রেড করতে চান?';
$string['upgradepluginsinfo'] = 'প্লাগইন আপডেট চলছে';
$string['upgradesettings'] = 'নতুন সেটিং';
$string['upgradesettingsintro'] = 'নিম্নে প্রদর্শিত সেটিংসমূহ সর্বশেষ মুডল আপগ্রেডের সময় যোগ করা হয়েছিলো। প্রয়োজন অনুযায়ী পূর্বনির্ধারিত মান পরিবর্তন করুন এবং পৃষ্ঠার নিচের &quot;পরিবর্তন সংরক্ষণ&quot; বোতামটিতে ক্লিক করুন।';
$string['upgradestalefiles'] = 'মিশ্র Moodle সংস্করণ পাওয়া গেছে, আপগ্রেড চালিয়ে যেতে পারবেন না';
$string['upgradestart'] = 'আপগ্রেড';
$string['upgradesure'] = 'আপনার মুডল ফাইলগুলো পরিবর্তিত হয়েছে, এবং আপনি আপনার সার্ভারকে স্বয়ংক্রিয়ভাবে উল্লিখিত সংস্করণে আপগ্রেড করতে যাচ্ছেন: <br /><br />
<strong>{$a}</strong> <br /><br />
একবার এটা করে ফেললে আপনি আর পিছনে ফিরে যেতে পারবেন না। <br /><br />
অনুগ্রহ করে লক্ষ্য করুন, এই প্রক্রিয়ায় অনেক সময় লাগতে পারে। <br /><br />
আপনি কি নিশ্চিত আপনি সার্ভারটিকে এই সংস্করণে উন্নীত করতে চান?';
$string['upgradetimedout'] = 'আপগ্রেডের সময় উত্তীর্ণ হয়ে গেছে, অনুগ্রহ করে পুনরায় আরম্ভ করুন।';
$string['upgradingdata'] = 'ডাটা আপগ্রেড করা হচ্ছে';
$string['upgradinglogs'] = 'লগ আপগ্রেড করা হচ্ছে';
$string['upgradingversion'] = 'নতুন সংস্করণে আপগ্রেড করা হচ্ছে';
$string['upwards'] = 'উর্ধ্বমুখী';
$string['useblogassociations'] = 'সংযোগ সক্রিয়';
$string['useexternalyui'] = 'অনলাইন YUI লাইব্রেরি ব্যবহার';
$string['user'] = 'ব্যবহারকারী';
$string['userbulk'] = 'বাল্ক ইউজার অ্যাকশন';
$string['userlist'] = 'ব্যবহারকারীর তালিকা ব্রাউজ';
$string['userpolicies'] = 'ব্যবহারকারীর নীতিমালা';
$string['userpreference'] = 'ব্যবহারকারী পছন্দসমূহ';
$string['userquota'] = 'ব্যবহারকারীর নির্ধারিত অংশ';
$string['users'] = 'ব্যবহারকারী';
$string['usesitenameforsitepages'] = 'সাইট পৃষ্ঠার জন্য সাইট নাম ব্যবহার করুন';
$string['usetags'] = 'ট্যাগের কার্যকারিতা সক্রিয়';
$string['validateerror'] = 'এই মান কার্যকর ছিল না:';
$string['verifychangedemail'] = 'ইমেইল পরিবর্তন করার সময় ডোমেইন নিয়ন্ত্রণ করা হবে';
$string['warningcurrentsetting'] = 'বর্তমান মান অকার্যকর: {$a}';
$string['webproxy'] = 'ওয়েব প্রক্সি';
$string['webproxyinfo'] = 'আপনার মুডল সার্ভার সরাসরি ইন্টারনেটের সাথে সংযুক্ত হতে না পারলে নিম্নোক্ত অপশনগুলি পূরণ করুন। এনভায়রনমেন্ট ডাটা, ল্যাংগুয়েজ প্যাক, RSS ফিড, সময় অঞ্চল, ইত্যাদি ডাউনলোড করার জন্য ইন্টারনেটের সাথে সংযুক্ত হওয়া প্রয়োজন।<br /><em>PHP cURL বর্ধিতাংশটি জরুরিভাবে সুপারিশ করা হচ্ছে।</em>';
$string['xmlrpcrecommended'] = 'হাবগুলোর মধ্যে যোগাযোগের জন্য xmlrpc বর্ধিতাংশটি প্রয়োজন, এটি ওয়েব সার্ভিস ও মুডল নেটওয়ার্কিংয়ের জন্যও প্রয়োজনীয়';
$string['yuicomboloading'] = 'YUI কম্বো লোড করা হচ্ছে';
$string['ziprequired'] = 'মুডলে এখন Zip PHP বর্ধিতাংশটি প্রয়োজন, info-ZIP বাইনারি অথবা PclZip লাইব্রেরি পরবর্তীতে আর ব্যবহৃত হবে না।';
