<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'cs', branch 'MOODLE_26_STABLE'
 *
 * @package   badges
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akce';
$string['activate'] = 'Povolit přístup';
$string['activatesuccess'] = 'Přístup k odznakům byl povolen';
$string['addbadgecriteria'] = 'Přidat kritéria odznaku';
$string['addcourse'] = 'Přidat kurzy';
$string['addcourse_help'] = 'Vyberte všechny kurzy, které by měly být přidány k tomuto požadavku na odznak. Podržením klávesy CTRL vyberete více položek.';
$string['addcriteria'] = 'Přidat kritéria';
$string['addcriteriatext'] = 'Chcete-li přidat kritéria, vyberte jednu z možností z rozbalovací nabídky.';
$string['addtobackpack'] = 'Přidat do sbírky';
$string['adminonly'] = 'Tato stránka je přístupná pouze pro administrátory.';
$string['after'] = 'po datu udělení.';
$string['aggregationmethod'] = 'Agregační metoda';
$string['all'] = 'Vše';
$string['allmethod'] = 'Všechny vybrané podmínky jsou splněny';
$string['allmethodactivity'] = 'Všechny vybrané činnosti jsou ukončené';
$string['allmethodcourseset'] = 'Všechny vybrané kurzy jsou ukončené';
$string['allmethodmanual'] = 'Všechny vybrané role udělují odznak';
$string['allmethodprofile'] = 'Všechny vybrané pole profilu byly ukončeny';
$string['allowcoursebadges'] = 'Povolit odznaky kurzu';
$string['allowcoursebadges_desc'] = 'Povolit vytvoření odznaků a jejich udělování v rámci kurzu.';
$string['allowexternalbackpack'] = 'Povolit spojení na externí sbírky odznaků';
$string['allowexternalbackpack_desc'] = 'Umožnit uživatelům nastavit propojení na jejich sbírku odznaků u externího poskytovatele a zobrazovat odznaky z těchto sbírek.

Poznámka: Doporučuje se ponechat tuto možnost vypnutou, pokud na externí webové stránky nelze přistupovat z Internetu (např. kvůli firewallu).';
$string['any'] = 'Aspoň jedna';
$string['anymethod'] = 'Je splněna aspoň jedna z vybraných podmínek';
$string['anymethodactivity'] = 'Je ukončena aspoň jedna z vybraných činností';
$string['anymethodcourseset'] = 'Je ukončen aspoň jeden z vybraných kurzů';
$string['anymethodmanual'] = 'Odznak uděluje aspoň jedna z vybraných rolí';
$string['anymethodprofile'] = 'Je vyplněno aspoň jedno z vybraných polí profilu';
$string['attachment'] = 'Připojit odznak do zprávy';
$string['attachment_help'] = 'Při zaškrtnutí bude odznak přiložen k informačnímu e-mailu pro příjemce';
$string['award'] = 'Udělený odznak';
$string['awardedtoyou'] = 'Získal jsem';
$string['awardoncron'] = 'Byl úspěšně aktivován přístup k odznakům. Odznaky může okamžitě získat příliš mnoho uživatelů. Akce bude nějaký čas trvat, aby byl zachován výkon serveru.';
$string['awards'] = 'Příjemci';
$string['backpackavailability'] = 'Externí ověření odznaku';
$string['backpackbadges'] = 'Počet odznaků: {$a->totalbadges}, počet sbírek: {$a->totalcollections}. <a href="mybackpack.php">Změnit nastavení sbírek</a> .';
$string['backpackconnection'] = 'Spojení sbírky';
$string['backpackdetails'] = 'Nastavení sbírky';
$string['backpackemail'] = 'E-mailová adresa';
$string['backpackemail_help'] = 'E-mailová adresa je spojená se sbírkou. Když jste připojeni, budou všechny odznaky získané na těchto stránkách spojeny s touto e-mailovou adresou.';
$string['backpackimport'] = 'Nastavení importu odznaku';
$string['badgedetails'] = 'Detaily odznaku';
$string['badgeimage'] = 'Obrázek';
$string['badgeimage_help'] = 'Toto je obrázek, který bude použit pro vydání tohoto odznaku.

Chcete-li přidat nový obrázek, vyhledejte a vyberte obraz (ve formátu JPG nebo PNG), pak klikněte na "Uložit změny". Obrázek bude oříznut na čtverec a upraven tak, aby odpovídal požadavkům obrázek odznaku.';
$string['badgeprivacysetting'] = 'Ochrana osobních údajů';
$string['badgeprivacysetting_str'] = 'Automatické zobrazení získaných odznaků na mé profilové stránce';
$string['badgesalt'] = 'Sůl pro hašování e-mailové adresy příjemce';
$string['badgesdisabled'] = 'Na těchto stránkách nejsou odznaky  povoleny.';
$string['badgesearned'] = 'Počet získaných odznaků: {$a}';
$string['badgesettings'] = 'Nastavení odznaků';
$string['badgestatus_0'] = 'Uživatelům není k dispozici';
$string['badgestatus_1'] = 'Uživatelům je k dispozici';
$string['badgestatus_2'] = 'Uživatelům není k dispozici';
$string['badgestatus_3'] = 'Uživatelům je k dispozici';
$string['badgestatus_4'] = 'Archivováno';
$string['badgestoearn'] = 'Počet dostupných odznaků: {$a}';
$string['badgesview'] = 'Odznaky kurzu';
$string['badgeurl'] = 'Vydán odkaz ne odznak';
$string['bawards'] = 'Příjemci  {$a}';
$string['bcriteria'] = 'Kritéria';
$string['bdetails'] = 'Upravit podrobnosti';
$string['bmessage'] = 'Zpráva';
$string['boverview'] = 'Přehled';
$string['bydate'] = 'dokončeno';
$string['clearsettings'] = 'Vymazat nastavení';
$string['completioninfo'] = 'Tento odznak byl vydán pro dokončení:';
$string['completionnotenabled'] = 'Tento kurz nemá povoleno dokončení, takže to nemůže být zařazen kritérií pro odznak . Ukončení kurzu může být povoleno v nastavení kurzu.';
$string['configenablebadges'] = 'Pokud je povoleno, tato funkce umožňuje vytvářet odznaky a udělit je uživatelům.';
$string['configuremessage'] = 'Zpráva o odznaku';
$string['connect'] = 'Spojit';
$string['connected'] = 'Spojeno';
$string['connecting'] = 'Připojování ...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'E-mailová adresa spojená s vydavatelem odznaku.';
$string['copyof'] = 'Kopie {$a}';
$string['coursebadges'] = 'Odznaky';
$string['coursebadgesdisabled'] = 'Na těchto stránkách nejsou povoleny odznaky kurzu.';
$string['coursecompletion'] = 'Studenti musí absolvovat tento kurz';
$string['create'] = 'Nový odznak';
$string['createbutton'] = 'Vytvořit odznak';
$string['creatorbody'] = '<p>{$a->user} splnil všechny požadavky a byl mu udělen odznak. Zobrazit vydané odznaky na {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' byl udělen!';
$string['criteria_0'] = 'Odznak je udělen, když ...';
$string['criteria_1'] = 'Dokončení činnosti';
$string['criteria_1_help'] = 'Umožňuje udělení odznaku uživatelům na základě dokončení souboru činností v rámci kurzu.';
$string['criteria_2'] = 'Ruční vydání dle role';
$string['criteria_2_help'] = 'Umožňuje ruční udělení odznaku uživateli, kteří mají konkrétní roli v rámci systému nebo kurzu.';
$string['criteria_3'] = 'Sociální zapojení';
$string['criteria_3_help'] = 'Sociální';
$string['criteria_4'] = 'Absolvování kurzu';
$string['criteria_4_help'] = 'Umožňuje udělit odznak uživatelům, kteří absolvovali kurz. Kritérium může mít další parametry, jako je například minimální známka a datum dokončení kurzu.';
$string['criteria_5'] = 'Absolvování sady kurzů';
$string['criteria_5_help'] = 'Umožňuje udělit odznak uživatelům, kteří absolvovali sadu kurzů. Každý kurz může mít další parametry, jako je například minimální známka a datum dokončení kurzu.';
$string['criteria_6'] = 'Dokončení profilu';
$string['criteria_6_help'] = 'Umožňuje udělit uživatelům odznak vyplněním stanovených polí v jejich profilu. Vyberte z výchozích nebo vlastních polí profilu, která jsou uživateli dostupná.';
$string['criteriacreated'] = 'Byla vytvořena kritéria odznaků';
$string['criteriadeleted'] = 'Kritéria odznaku byla úspěšně smazána';
$string['criteria_descr'] = 'Studentům je udělen tento odznak, když splní následující požadavky:';
$string['criteria_descr_0'] = 'Studentům je udělen tento odznak, když splní <strong>{$a}</strong> z následujících požadavků.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> z těchto činností jsou dokončeny:';
$string['criteria_descr_2'] = 'Tento odznak musí být udělen uživateli s <strong>{$a}</strong> z následujících rolí:';
$string['criteria_descr_4'] = 'Studenti musí absolvovat kurz';
$string['criteria_descr_5'] = '<strong>{$a}</strong> z následujících kurzů je nutno dokončit:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> z následujících uživatelských profilů je nutno dokončit:';
$string['criteria_descr_bydate'] = '<em>{$a}</em>';
$string['criteria_descr_grade'] = 's minimálním hodnocením <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Dokončeno <strong>{$a}</strong> z:';
$string['criteria_descr_short1'] = 'Dokončeno <strong>{$a}</strong> z:';
$string['criteria_descr_short2'] = 'Uděleno <strong>{$a}</strong> z:';
$string['criteria_descr_short4'] = 'Dokončit kurz';
$string['criteria_descr_short5'] = 'Dokončeno <strong>{$a}</strong> z:';
$string['criteria_descr_short6'] = 'Dokončeno <strong>{$a}</strong> z:';
$string['criteria_descr_single_1'] = 'Následující činnost musí být dokončena:';
$string['criteria_descr_single_2'] = 'Tento odznak udělují uživatelé s některou z následujících rolí:';
$string['criteria_descr_single_4'] = 'Studenti musí absolvovat kurz';
$string['criteria_descr_single_5'] = 'Následující kurz musí být dokončen:';
$string['criteria_descr_single_6'] = 'Následující pole profilu je nutno vyplnit:';
$string['criteria_descr_single_short1'] = 'Ukončeno:';
$string['criteria_descr_single_short2'] = 'Uděleno:';
$string['criteria_descr_single_short4'] = 'Absolvovat kurz';
$string['criteria_descr_single_short5'] = 'Ukončeno:';
$string['criteria_descr_single_short6'] = 'Ukončeno:';
$string['criteriasummary'] = 'Přehled kritérií';
$string['criteriaupdated'] = 'Kritéria odznaku byla úspěšně aktualizována';
$string['criterror'] = 'Aktuální parametry vydání';
$string['criterror_help'] = 'Tato sada polí zobrazuje všechny parametry, které byly původně přidány k tomuto požadavku na odznak, ale jsou již k dispozici. Doporučuje se, aby jste překontrolovali parametry, aby jste se ujistil, že uživatelé mohou získat tento odznak v budoucnu.';
$string['currentimage'] = 'Aktuální obrázek';
$string['currentstatus'] = 'Aktuální stav:';
$string['dateawarded'] = 'Datum udělení';
$string['dateearned'] = 'Datum: {$a}';
$string['day'] = 'Dnů';
$string['deactivate'] = 'Zakázat přístup';
$string['deactivatesuccess'] = 'Přístup k odznakům byl úspěšně zakázán.';
$string['defaultissuercontact'] = 'Výchozí kontaktní údaje vydavatele';
$string['defaultissuercontact_desc'] = 'E-mailová adresa spojená s vydavatelem odznaku.';
$string['defaultissuername'] = 'Jméno vydavatele odznaku';
$string['defaultissuername_desc'] = 'Jméno vydávajícího zástupce nebo orgánu.';
$string['delbadge'] = 'Odstranit odznak';
$string['delconfirm'] = 'Skutečně chcete smazat odznak "{$a}"?';
$string['delcritconfirm'] = 'Skutečně chcete smazat toto kritérium?';
$string['delparamconfirm'] = 'Skutečně chcete smazat tento parametr?';
$string['description'] = 'Popis';
$string['disconnect'] = 'Odpojit';
$string['donotaward'] = 'V současné době není tento odznak aktivní, tak  nemůže být udělen uživatelům. Pokud byste chtěli udělit tento odznak, nastavte jej do stavu aktivní.';
$string['editsettings'] = 'Upravit nastavení';
$string['enablebadges'] = 'Povolit odznaky';
$string['error:backpackdatainvalid'] = 'Data vrácená ze sbírky nejsou platná.';
$string['error:backpackemailnotfound'] = 'E-mail  "{$a}" není spojem se sbírkou odznaků. Musíte <a href="http://backpack.openbadges.org"> pro tento účet vytvořit sbírku</a> nebo se přihlaste s jinou e-mailovou adresou.';
$string['error:backpackloginfailed'] = 'K externí sbírce nemůžete být připojeni z následujícího důvodu: {$a}';
$string['error:backpacknotavailable'] = 'Váš web není přístupný z Internetu, takže všechny odznaky vydané na tomto webu nelze ověřit externí službou sbírky.';
$string['error:backpackproblem'] = 'Došlo k potížím s připojením k poskytovateli služeb sbírky odznaků. Zkuste to prosím později znovu.';
$string['error:badjson'] = 'Pokus o připojení se vrátila neplatná data.';
$string['error:cannotact'] = 'Nelze aktivovat odznak.';
$string['error:cannotawardbadge'] = 'Uživateli nelze udělit odznak .';
$string['error:clone'] = 'Odznak nelze naklonovat.';
$string['error:connectionunknownreason'] = 'Připojení nebylo úspěšné, ale nebyl uveden důvod.';
$string['error:duplicatename'] = 'Odznak s tímto názvem již v systému existuje .';
$string['error:externalbadgedoesntexist'] = 'Odznak nebyl nalezen';
$string['error:guestuseraccess'] = 'V současné době pracujete s právy hosta. Chcete-li zobrazit Odznaky potřebujete být přihlášen svým uživatelským účtem.';
$string['error:invalidbadgeurl'] = 'Neplatný formát adresy URL vydavatele odznaku.';
$string['error:invalidcriteriatype'] = 'Neplatný typ kritéria.';
$string['error:invalidexpiredate'] = 'Datum vypršení platnosti musí být v budoucnosti.';
$string['error:invalidexpireperiod'] = 'Délka platnosti nemůže být záporná nebo mít nulovou hodnotu.';
$string['error:noactivities'] = 'V tomto kurzu nejsou žádné aktivity se sledováním plnění činností';
$string['error:nocourses'] = 'Žádný kurz nemá povoleno absolvování kurzu, proto nelze žádný zobrazit. Absolvování kurzu musí být povoleno v nastavení kurzu.';
$string['error:nogroups'] = '<p> Ve vaší sbírce nejsou k dispozici žádné veřejné kolekce odznaků. </p><p> Jsou zobrazeny pouze veřejné kolekce , <a href="http://backpack.openbadges.org">navštivte svou sbírku</a>  a vytvořte nějakou veřejnou kolekci. </p>';
$string['error:nopermissiontoview'] = 'Nemáte oprávnění k zobrazení příjemců odznak';
$string['error:nosuchbadge'] = 'Odznak s identifikátorem {$a} neexistuje.';
$string['error:nosuchcourse'] = 'Upozornění: Tento kurz již není k dispozici.';
$string['error:nosuchfield'] = 'Upozornění: Tento uživatelský profil již není k dispozici.';
$string['error:nosuchmod'] = 'Upozornění: Tato aktivita již není k dispozici.';
$string['error:nosuchrole'] = 'Upozornění: Tato role již není k dispozici';
$string['error:nosuchuser'] = 'Uživatel s touto e-mailovou adresou nemá účet u připojeného poskytovatele sbírky.';
$string['error:notifycoursedate'] = 'Upozornění: Odznaky spojené s kurzem a dokončenými aktivitami nebudou vydány před začátkem kurzu.';
$string['error:parameter'] = 'Upozornění: Pro hladký průběh vydávání odznaku by měl být vybrán aspoň jeden parametr.';
$string['error:personaneedsjs'] = 'Pro připojení ke sbírce je aktuálně požadován Javascript . Pokud můžete, povolte Javascript a obnovte stránku.';
$string['error:requesterror'] = 'Žádost o připojení selhala (kód chyby {$a}).';
$string['error:requesttimeout'] = 'Žádost o připojení vypršel před dokončením.';
$string['error:save'] = 'Odznak nelze uložit.';
$string['error:userdeleted'] = '{$a->user} (Tento uživatel v {$a->site} již neexistuje)';
$string['evidence'] = 'Evidence';
$string['existingrecipients'] = 'Stávající držitelé odznaku';
$string['expired'] = 'Platnost vypršela';
$string['expiredate'] = 'Platnost odznaku vyprší {$a}.';
$string['expireddate'] = 'Platnost odznaku vypršela {$a}.';
$string['expireperiod'] = 'Platnost odznaku vyprší {$a} den (dnů) poté, co byl vydán.';
$string['expireperiodh'] = 'Platnost odznaku vyprší {$a} hodinu (hodin) poté, co byl vydán.';
$string['expireperiodm'] = 'Platnost odznaku vyprší {$a} minut poté, co byl vydán.';
$string['expireperiods'] = 'Platnost odznaku vyprší {$a} vteřin poté, co byl vydán.';
$string['expirydate'] = 'Datum vypršení platnosti';
$string['expirydate_help'] = 'Volitelně lze platnost odznaků ukončit k určitému datu, nebo lze datum platnosti vypočítat na základě data, kdy byl odznak uživateli vydán.';
$string['externalbadges'] = 'Moje odznaky z jiných webových stránek';
$string['externalbadges_help'] = 'Tato oblast obsahuje odznaky z externí sbírky.';
$string['externalbadgesp'] = 'Odznaky z jiných webových stránek:';
$string['externalconnectto'] = 'Chcete-li zobrazit externí odznaky, musíte se <a href="{$a}">připojit ke sbírce</ a>.';
$string['fixed'] = 'Pevné datum';
$string['hidden'] = 'Skryté';
$string['hiddenbadge'] = 'Bohužel, majitel odznaku nedal tyto informace k dispozici.';
$string['issuancedetails'] = 'Vypršení platnosti odznaku';
$string['issuedbadge'] = 'Informace o vydaném odznaku';
$string['issuerdetails'] = 'Podrobnosti o vydavateli';
$string['issuername'] = 'Jméno vydavatele';
$string['issuername_help'] = 'Jméno vydavatele odznaku.';
$string['issuerurl'] = 'URL vydavatele';
$string['localbadges'] = 'Moje odznaky z webu {$a}';
$string['localbadgesh'] = 'Moje odznaky z tohoto webu';
$string['localbadgesp'] = 'Odznaky od  {$a}:';
$string['localconnectto'] = 'Chcete-li sdílet tyto Odznaky mimo tento web musíte se <a href="{$a}"> připojit ke sbírce</ a>';
$string['makeprivate'] = 'Nastavit jako soukromé';
$string['makepublic'] = 'Zveřejnit';
$string['managebadges'] = 'Správa odznaků';
$string['message'] = 'Zpráva';
$string['messagebody'] = '<p>Obdržel(a) jste odznak „%badgename%“.</p>
<p>Více informací naleznete na adrese %badgelink%.</p>
<p>Odznak si také můžete stáhnout ze stránky {$a}.</p>';
$string['messagesubject'] = 'Blahopřejeme, získali jste odznak!';
$string['method'] = 'Kritérium je splněno, když…';
$string['mingrade'] = 'Požadována minimální známka';
$string['month'] = 'Měsíc(ů)';
$string['mybackpack'] = 'Nastavení mé sbírky';
$string['mybadges'] = 'Moje odznaky';
$string['never'] = 'Nikdy';
$string['newbadge'] = 'Přidat odznak';
$string['newimage'] = 'Nový obrázek';
$string['noawards'] = 'Tento odznak nebyl ještě získán.';
$string['nobackpack'] = 'K tomuto účtu není připojena služba sbírka odznaků.<br/>';
$string['nobackpackbadges'] = 'Ve vybraných sbírkách nejsou žádné odznaky. <a href="mybackpack.php">Přidat další sbírku</a>.';
$string['nobackpackcollections'] = 'Nebyly vybrány žádné sbírky. <a href="mybackpack.php">Přidat sbírku</a>.';
$string['nobadges'] = 'Žádné odznaky nejsou k dispozici.';
$string['nocriteria'] = 'Kritéria pro tento odznak nejsou dosud stanovena.';
$string['noexpiry'] = 'Odznak nemá konec platnosti.';
$string['noparamstoadd'] = 'K tomuto požadavku na odznak nejsou dostupné žádné další parametry.';
$string['notacceptedrole'] = 'Vaše současná role není mezi rolemi, která může ručně vydávat tento odznak. <br/> Pokud chcete vidět uživatele, kteří tento odznak již získali, navštivte stránku {$a} .';
$string['notconnected'] = 'Nepřipojeno';
$string['nothingtoadd'] = 'Neexistují žádná dostupná kritéria pro přidání.';
$string['notification'] = 'Upozornit tvůrce odznaku';
$string['notification_help'] = 'Upozornit zprávou tvůrce odznaku, je-li odznak udělen. Můžete si zvolit, jak často bude notifikace odeslána.

* Nikdy - Neposílat žádná upozornění.
* Pokaždé - Pokaždé, kdy je odznak udělen.
* Denně - Souhrnná zpráva jednou za den.
* Týdně - Souhrnná zpráva jednou za týden.
* Měsíčně - Souhrnná zpráva jednou za měsíc.';
$string['notifydaily'] = 'Denně';
$string['notifyevery'] = 'Pokaždé, když';
$string['notifymonthly'] = 'Měsíčně';
$string['notifyweekly'] = 'Týdně';
$string['numawards'] = 'Tento odznak byl vydán  <a href="{$a->link}">{$a->count}</a> uživatelům.';
$string['numawardstat'] = 'Tento odznak byl vydán {$a} uživatelům.';
$string['overallcrit'] = 'z vybraných kriteriích jsou dokončeny.';
$string['personaconnection'] = 'Přihlaste se pomocí svého e-mailu';
$string['personaconnection_help'] = 'Persona je identifikační systém pomocí vaší e-mailové adresy. Otevřená Sbírka odznaků používá Persona jako systém přihlášení, aby bylo možné připojit se ke Sbírce, potřebujete účet Persona.

Další informace o systému Persona naleznete na <a href="https://login.persona.org/about">https://login.persona.org/about</a>';
$string['potentialrecipients'] = 'Potenciální příjemci odznaku';
$string['recipientdetails'] = 'Podrobnosti o příjemci';
$string['recipientidentificationproblem'] = 'Mezi stávajícími uživateli nelze najít příjemce tohoto odznaku';
$string['recipients'] = 'Příjemci odznaku';
$string['recipientvalidationproblem'] = 'Aktuální uživatel nemůže být ověřen jako příjemce tohoto odznaku.';
$string['relative'] = 'Relativní datum';
$string['requiredcourse'] = 'Do kritéria sady kurzů musí být přidán aspoň jeden kurz.';
$string['reviewbadge'] = 'Zobrazit kritéria odznaku';
$string['reviewconfirm'] = 'Tato akce spustí kontrolu, zda má některý z uživatelů splněny všechny požadavky pro získání odznaku "{$a}". Přejete si pokračovat?';
$string['save'] = 'Uložit';
$string['searchname'] = 'Vyhledat dle jména';
$string['selectaward'] = 'Zvolte roli, která bude moci udělovat tento odznak:';
$string['selectgroup_end'] = 'Jsou zobrazeny pouze veřejné sbírky, <a href="http://backpack.openbadges.org">navštivte nastavení vašich sbírek</a> a vytvořte další veřejné sbírky.';
$string['selectgroup_start'] = 'Které sbírky odznaků se mají zobrazit na těchto stránkách:';
$string['selecting'] = 'S vybranými odznaky…';
$string['setup'] = 'Nastavit připojení';
$string['signinwithyouremail'] = 'Přihlaste se pomocí svého e-mailu';
$string['sitebadges'] = 'Odznaky stránky';
$string['status'] = 'Stav odznaku';
$string['statusmessage_0'] = 'Tento odznak není momentálně pro uživatele dostupný. Pokud chcete, aby jej mohli uživatelé získat, povolte přístup.';
$string['statusmessage_1'] = 'Tento odznak je pro uživatele dostupný. Pro provedení změn v nastavení je nutno nejprve zakázat přístup.';
$string['statusmessage_2'] = 'Tento odznak není momentálně pro uživatele dostupný a jeho kritéria jsou zamknutá. Pokud chcete, aby jej mohli uživatelé získat, povolte přístup.';
$string['statusmessage_3'] = 'Tento odznak je pro uživatele dostupný a jeho kritéria jsou zamknutá.';
$string['statusmessage_4'] = 'Tento odznak je archivován.';
$string['subject'] = 'Předmět zprávy';
$string['variablesubstitution'] = 'Náhrada proměnných ve zprávách.';
$string['variablesubstitution_help'] = 'Ve zprávě odznaku, lze vložit do předmětu a/nebo těla zprávy některé proměnné tak, že budou nahrazeny skutečnými hodnotami v odeslané zprávě . Proměnné by měly být vloženy do textu, přesně tak, jak je uvedeno níže. Mohou být použity následující proměnné:

%badgename%
: tato proměnná bude nahrazena celým jménem odznaku.

%username%
: tato proměnná bude nahrazena celým jménem příjemce.

%badgelink%
: tato proměnná bude nahrazena veřejným URL s informacemi o vydaném odznaku.';
$string['viewbadge'] = 'Zobrazit vydaný odznak';
$string['visible'] = 'Viditelný';
$string['warnexpired'] = '(Platnost odznaku vypršela!)';
$string['year'] = 'Rok(y)';
