<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'ca', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Control d\'accés';
$string['actionaftercorrectanswer'] = 'Acció després d\'una resposta correcta';
$string['actionaftercorrectanswer_help'] = 'Després de respondre correctament una pregunta, hi ha 3 opcions per a  la pàgina següent:

* Normal - Seguiu el camí de la lliçó.
* Mostra una pàgina no vista - Les pàgines es mostren en un ordre aleatori sense mostrar la mateixa pàgina  dues vegades.
* Mostra una pàgina sense contestar - Les pàgines es mostren aleatòriament i es tornen a mostrar les pàgines que contenen preguntes encara no respostes.';
$string['actions'] = 'Accions';
$string['activitylink'] = 'Enllaça a la següent activitat';
$string['activitylink_help'] = '<p>El menú desplegable conté totes les activitats d\'aquest curs. Si en seleccioneu una, al final de la lliçó apareixerà un enllaç a aquesta activitat. </p>';
$string['activitylinkname'] = 'Vés a: {$a}';
$string['activityoverview'] = 'Teniu lliçons pendents.';
$string['addabranchtable'] = 'Afegeix una taula de ramificació';
$string['addanendofbranch'] = 'Afegeix un final de ramificació';
$string['addanewpage'] = 'Afegeix una pàgina nova.';
$string['addaquestionpage'] = 'Afegeix una pàgina de pregunta';
$string['addaquestionpagehere'] = 'Afegeix aquí una pàgina de pregunta';
$string['addbranchtable'] = 'Afegeix una taula de ramificació';
$string['addcluster'] = 'Afegeix un clúster';
$string['addedabranchtable'] = 'S\'ha afegit una taula de ramificació';
$string['addedanendofbranch'] = 'S\'ha afegit un final de ramificació';
$string['addedaquestionpage'] = 'S\'ha afegit una pàgina de pregunta';
$string['addedcluster'] = 'S\'ha afegit un clúster';
$string['addedendofcluster'] = 'S\'ha afegit un final de clúster';
$string['addendofcluster'] = 'Afegeix un final de clúster';
$string['addpage'] = 'Afegeix una pàgina';
$string['anchortitle'] = 'Inici del contingut principal';
$string['and'] = 'i';
$string['answer'] = 'Resposta';
$string['answeredcorrectly'] = 'contestades correctament.';
$string['answersfornumerical'] = 'Les respostes de les preguntes numèriques haurien de ser parells de valors mínims i màxims';
$string['arrangebuttonshorizontally'] = 'Voleu disposar horitzontalment els botons de ramificació?';
$string['attempt'] = 'Intent: {$a}';
$string['attempts'] = 'Intents';
$string['attemptsdeleted'] = 'Intents suprimits';
$string['attemptsremaining'] = 'Us resten {$a} intents';
$string['available'] = 'Disponible des de:';
$string['averagescore'] = 'Puntuació mitjana';
$string['averagetime'] = 'Temps mitjà';
$string['branch'] = 'Ramificació';
$string['branchtable'] = 'Taula de ramificació';
$string['cancel'] = 'Cancel·la';
$string['cannotfindanswer'] = 'Error: no s\'ha pogut trobar la resposta';
$string['cannotfindattempt'] = 'Error: no es pot trobar l\'intent';
$string['cannotfindessay'] = 'Error: no es pot trobar la resposta';
$string['cannotfindfirstgrade'] = 'Error: no es poden trobar les qualificacions';
$string['cannotfindfirstpage'] = 'No es pot trobar la primera pàgina';
$string['cannotfindgrade'] = 'Error: no es poden trobar les qualificacions';
$string['cannotfindnewestgrade'] = 'Error: no es pot trobar la qualificació més recent';
$string['cannotfindnextpage'] = 'Còpia de seguretat de la lliçó: no es pot trobar la pàgina següent';
$string['cannotfindpagerecord'] = 'Final de ramificació: no s\'ha trobat el registre de pàgina';
$string['cannotfindpages'] = 'No es poden trobar les pàgines de la lliçó';
$string['cannotfindpagetitle'] = 'Supressió: no es pot trobar el títol de la pàgina';
$string['cannotfindpreattempt'] = 'No es pot trobar el registre de l\'intent anterior';
$string['cannotfindrecords'] = 'Error: no es poden trobar els registres de la lliçó';
$string['cannotfindtimer'] = 'Error: no es poden trobar els registres del rellotge';
$string['cannotfinduser'] = 'Error: no es poden trobar els usuaris';
$string['canretake'] = '{$a} es pot repetir';
$string['casesensitive'] = 'Utilitzeu expressions regulars';
$string['casesensitive_help'] = 'Marca la casella per utilitzar expressions regulars per analitzar respostes.';
$string['checkbranchtable'] = 'Comprova la taula de ramificació';
$string['checkedthisone'] = 'aquest comprovat.';
$string['checknavigation'] = 'Comprova la navegació';
$string['checkquestion'] = 'Comprova la pregunta';
$string['classstats'] = 'Estadística de classe';
$string['clicktodownload'] = 'Feu clic en aquest enllaç per baixar el fitxer.';
$string['clicktopost'] = 'Feu clic per enviar la vostra qualificació a la llista de puntuacions màximes.';
$string['cluster'] = 'Clúster';
$string['clusterjump'] = 'Pregunta no vista en un clúster';
$string['clustertitle'] = 'Títol del clúster';
$string['collapsed'] = 'Reduït';
$string['comments'] = 'Comentaris';
$string['completed'] = 'Completat';
$string['completederror'] = 'Completeu la lliçó';
$string['completethefollowingconditions'] = 'Heu de completar la condició o condicions següents en la lliçó <b>{$a}</b> abans de continuar.';
$string['conditionsfordependency'] = 'Condició o condicions de dependència';
$string['configactionaftercorrectanswer'] = 'Acció a realitzar per defecte després d\'una resposta correcta';
$string['configmaxanswers'] = 'Nombre màxim per defecte de respostes/branques per pàgina';
$string['configmaxhighscores'] = 'Nombre de puntuacions màximes que es mostren';
$string['configmediaclose'] = 'Mostra un botó "Tanca" a la finestra emergent generada per un fitxer multimèdia enllaçat';
$string['configmediaheight'] = 'Estableix l\'altura de la finestra emergent generada per un fitxer multimèdia enllaçat';
$string['configmediawidth'] = 'Estableix l\'amplada de la finestra emergent generada per un fitxer multimèdia enllaçat';
$string['configslideshowbgcolor'] = 'Color de fons per a la presentació de diapositives, si està habilitada';
$string['configslideshowheight'] = 'Estableix l\'altura de la presentació de diapositives, si està habilitada';
$string['configslideshowwidth'] = 'Estableix l\'amplada de la presentació de diapositives, si està habilitada';
$string['confirmdelete'] = 'Esborra la pàgina';
$string['confirmdeletionofthispage'] = 'Confirma la supressió d\'aquesta pàgina';
$string['congratulations'] = 'Felicitacions: heu arribat al final de la lliçó';
$string['continue'] = 'Continua';
$string['continuetoanswer'] = 'Continua per canviar respostes.';
$string['continuetonextpage'] = 'Continua a la pàgina següent';
$string['correctanswerjump'] = 'Salt de resposta correcta';
$string['correctanswerscore'] = 'Puntuació de resposta correcta';
$string['correctresponse'] = 'Resposta correcta';
$string['createaquestionpage'] = 'Crea una pàgina de preguntes';
$string['credit'] = 'Crèdit';
$string['customscoring'] = 'Puntuació personalitzada';
$string['customscoring_help'] = '<p>Aquesta opció us permetrà puntuar cada resposta amb un valor numèric. Les respostes poden tenir valors negatius o positius. A les preguntes importades se\'ls assignarà automàticament un punt per a les respostes correctes i zero per a les incorrectes, però podeu modificar aquests valors després de la importació. </p>';
$string['deadline'] = 'Data límit';
$string['defaultessayresponse'] = 'El vostre treball ha estat qualificat pel professor del curs.';
$string['deleteallattempts'] = 'Suprimeix tots els intents de la lliçó';
$string['deletedefaults'] = 'S\'han suprimit {$a} registres de valors per defecte de les lliçons';
$string['deletedpage'] = 'S\'ha suprimit la pàgina';
$string['deleting'] = 'S\'està suprimint';
$string['deletingpage'] = 'S\'està suprimint la pàgina: {$a}';
$string['dependencyon'] = 'Dependent de';
$string['dependencyon_help'] = '<p>Aquest paràmetre fa que la lliçó actual depengui del rendiment de l\'estudiant en una altra lliçó d\'aquest curs. Si no es compleixen els requeriments de rendiment, l\'estudiant no tindrà accés a aquesta lliçó.</p>

<p>Les condicions de dependència inclouen:
    <ul>
        <li><b>Temps dedicat:</b> l\'estudiant ha d\'haver dedicat a la lliçó requerida la quantitat de temps que definiu aquí.</li>
        <li><b>Completada:</b> l\'estudiant ha d\'haver completat la lliçó requerida.</li>
        <li><b>Qualificació major de:</b> l\'estudiant ha d\'haver aconseguit una qualificació en la lliçó requerida que sigui millor que la que especifiqueu aquí. </li>
    </ul>
    Podeu utilitzar qualsevol combinació d\'aquestes condicions.
</p>';
$string['description'] = 'Descripció';
$string['detailedstats'] = 'Estadístiques detallades';
$string['didnotanswerquestion'] = 'No heu respost aquesta pregunta.';
$string['didnotreceivecredit'] = 'No heu rebut crèdit';
$string['displaydefaultfeedback'] = 'Mostra la retroacció per defecte';
$string['displaydefaultfeedback_help'] = 'Si s\'activa, quan no es trobi la resposta a una pregunta en particular, es mostrarà la resposta per defecte "Aquesta és la resposta correcta" o "Aquesta és la resposta equivocada" .';
$string['displayhighscores'] = 'Mostra les puntuacions més altes';
$string['displayinleftmenu'] = 'Voleu mostrar-ho al menú esquerre?';
$string['displayleftif'] = 'Visualitza el menú de l\'esquerra només si la qualificació és més gran que';
$string['displayleftif_help'] = 'Aquest paràmetre determina si un estudiant ha d\'obtenir una determinada puntuació abans de veure el menú de l\'esquerra. Això obligarà a l\'estudiant a passar per tota la lliçó en el seu primer intent. Un cop hagi aconseguit la puntuació necessària ja podrà utilitzar el menú de l\'esquerra per la seva revisió.';
$string['displayleftmenu'] = 'Mostra el menú esquerre';
$string['displayleftmenu_help'] = 'Si s\'habilita es mostrarà una llista de pàgines.';
$string['displayofgrade'] = 'Visualització de la qualificació (només estudiants)';
$string['displayreview'] = 'Mostra el botó de revisió d\'una pregunta';
$string['displayreview_help'] = 'Si s\'activa, quan una pregunta es respon incorrectament se li dóna a l\'estudiant l\'opció de provar-ho una altra vegada sense obtenir punts, o bé continuar amb la lliçó.';
$string['displayscorewithessays'] = 'Heu aconseguit {$a->score} punts d\'un màxim de  {$a->tempmaxgrade} de les preguntes qualificades automàticament.<br>Les vostres {$a->essayquestions} preguntes de resposta oberta es qualificaran més endavant i s\'afegiran a la puntuació final.<br /><br />La vostra qualificació actual, sense les preguntes de resposta oberta, és de  {$a->score} sobre {$a->grade}';
$string['displayscorewithoutessays'] = 'La vostra puntuació és {$a->score} (sobre {$a->grade}).';
$string['edit'] = 'Edita';
$string['editingquestionpage'] = 'S\'està editant la pàgina de preguntes {$a}';
$string['editlessonsettings'] = 'Edita els paràmetres de la lliçó';
$string['editpage'] = 'Edita el contingut de la pàgina';
$string['editpagecontent'] = 'Edita els continguts d\'aquesta pàgina';
$string['email'] = 'Correu electrònic';
$string['emailallgradedessays'] = 'Envia per correu TOTES les preguntes obertes qualificades';
$string['emailgradedessays'] = 'Envia per correu les preguntes de resposta oberta qualificades';
$string['emailsuccess'] = 'S\'han enviat correctament els correus';
$string['emptypassword'] = 'La contrasenya no es pot deixar en blanc';
$string['endofbranch'] = 'Final de la ramificació';
$string['endofcluster'] = 'Final de clúster';
$string['endofclustertitle'] = 'Final de clúster';
$string['endoflesson'] = 'Final de la lliçó';
$string['enteredthis'] = 'ho ha escrit.';
$string['entername'] = 'Escriviu un àlies a la llista de puntuacions màximes';
$string['enterpassword'] = 'Escriviu la contrasenya:';
$string['eolstudentoutoftime'] = 'Heu esgotat el vostre temps per completar aquesta lliçó. És possible que la darrera resposta no s\'hagi comptat si l\'heu donada després que s\'hagi acabat el temps.';
$string['eolstudentoutoftimenoanswers'] = 'No heu respost cap pregunta. La vostra puntuació és de 0.';
$string['essay'] = 'Pregunta de resposta oberta';
$string['essayemailmessage'] = '<p>Enunciat de la pregunta:<blockquote>{$a->question}</blockquote></p><p>La vostra resposta:<blockquote><em>{$a->response}</em></blockquote></p><p>Comentaris de {$a->teacher}:<blockquote><em>{$a->comment}</em></blockquote></p><p>Heu obtingut un {$a->earned} sobre {$a->outof} en aquesta pregunta.</p><p>La vostra qualificació en aquesta lliçó ha canviat a {$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p>Informació de les preguntes de resposta oberta:<blockquote>{$a->question}</blockquote></p><p>La vostra resposta:<blockquote><em>{$a->response}</em></blockquote></p><p>Comentaris del professorat:<blockquote><em>{$a->comment}</em></blockquote></p><p>Heu aconseguit {$a->earned} d\'un màxim de {$a->outof} per aquesta pregunta de resposta oberta.</p><p>La vostra qualificació de la lliçó és ara de {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'La vostra qualificació per a la pregunta {$a}';
$string['essays'] = 'Preguntes de resposta oberta';
$string['essayscore'] = 'Puntuació de la pregunta';
$string['fileformat'] = 'Format de fitxer';
$string['finish'] = 'Acaba';
$string['firstanswershould'] = 'La primera resposta hauria de saltar a la pàgina "Correcta"';
$string['firstwrong'] = 'Com que la resposta no és correcta no aconseguiu cap punt. Encara que no obtingueu cap altre punt, voleu seguir provant-ho, ni que sigui per aprendre?';
$string['flowcontrol'] = 'Control de flux';
$string['full'] = 'Expandit';
$string['general'] = 'General';
$string['gotoendoflesson'] = 'Vés al final de la lliçó';
$string['grade'] = 'Qualifica';
$string['gradebetterthan'] = 'Qualificació major de (%)';
$string['gradebetterthanerror'] = 'Heu d\'obtenir una qualificació major de {$a} %';
$string['gradeessay'] = 'Qualifica les preguntes de resposta oberta';
$string['gradeis'] = 'La qualificació és {$a}';
$string['gradeoptions'] = 'Opcions de qualificació';
$string['handlingofretakes'] = 'Gestió de les repeticions';
$string['handlingofretakes_help'] = '<p>Quan a l\'estudiantat se li permet repetir la lliçó, aquesta opció permet al professorat mostrar la qualificació de la lliçó, per exemple a la pàgina de qualificacions, com la <b>mitjana</b>de les qualificacions de tots els intents que es facin, o com la <b>millor</b> qualificació que s\'obtingui.</p>

<p>Aquesta opció es pot canviar en qualsevol moment.</p>';
$string['havenotgradedyet'] = 'Encara no qualificat.';
$string['here'] = 'aquí';
$string['highscore'] = 'Puntuació més alta';
$string['highscores'] = 'Puntuacions més altes.';
$string['hightime'] = 'Temps màxim';
$string['importcount'] = 'S\'estan important {$a} preguntes';
$string['importquestions'] = 'Importa preguntes';
$string['importquestions_help'] = 'Aquesta característica permet la importació de diferents formats de pregunta mitjançant un fitxer de text.';
$string['insertedpage'] = 'S\'ha inserit la pàgina';
$string['invalidfile'] = 'Fitxer no vàlid';
$string['invalidid'] = 'No s\'ha passat un ID de lliçó o de mòdul del curs';
$string['invalidlessonid'] = 'L\'ID de la lliçó no és correcte';
$string['invalidpageid'] = 'L\'ID de la pàgina no és vàlid';
$string['jump'] = 'Salt';
$string['jumps'] = 'Salts';
$string['jumps_help'] = 'Cada resposta (per a preguntes) o descripció (per a les pàgines de ramificació) té el corresponent salt . El salt pot ser relatiu, com a aquesta pàgina o a la pàgina següent, o absoluta, especificant una de les pàgines de la lliçó.';
$string['jumpsto'] = 'Salts a <em>{$a}</em>';
$string['leftduringtimed'] = 'Heu abandonat una lliçó cronometrada.<br />Feu clic a Continua per tornar-la a començar.';
$string['leftduringtimednoretake'] = 'Heu abandonat una lliçó cronometrada i no està permès continuar-la o torna-la a fer.';
$string['leftduringtimedsession'] = 'Heu sortit durant una lliçó programada.';
$string['lesson:addinstance'] = 'Afegeix una lliçó nova';
$string['lessonattempted'] = 'Lliçó intentada';
$string['lessonclosed'] = 'La lliçó es va tancar el {$a}.';
$string['lessoncloses'] = 'Es tanca la lliçó';
$string['lessoncloseson'] = 'La lliçó es tanca el {$a}';
$string['lesson:edit'] = 'Edició d\'activitats de tipus lliçó';
$string['lessonformating'] = 'Formatatge de la lliçó.';
$string['lesson:manage'] = 'Gestió d\'activitats de tipus lliçó';
$string['lessonmenu'] = 'Menú de la lliçó';
$string['lessonnotready'] = 'Encara no es pot entrar en aquesta lliçó. Contacteu amb el vostre {$a}.';
$string['lessonnotready2'] = 'Aquesta lliçó encara no està preparada per a ser oberta.';
$string['lessonopen'] = 'La lliçó s\'obrirà el {$a}.';
$string['lessonopens'] = 'La lliçó s\'obre';
$string['lessonpagelinkingbroken'] = 'No s\'ha trobat la primera pàgina. Deu haver-hi algun error en els enllaços. Contacteu amb l\'administrador.';
$string['lessonstats'] = 'Estadístiques de la lliçó';
$string['linkedmedia'] = 'Fitxer enllaçat';
$string['loginfail'] = 'Accés denegat, torneu-ho a provar...';
$string['lowscore'] = 'Puntuació més baixa';
$string['lowtime'] = 'Temps més baix';
$string['manualgrading'] = 'Qualifica preguntes de resposta oberta';
$string['matchesanswer'] = 'Coincideix amb la resposta';
$string['matching'] = 'Emparellament';
$string['matchingpair'] = 'Parella de {$a}';
$string['maxgrade'] = 'Màxima qualificació';
$string['maxgrade_help'] = '<p>Aquest valor determina la qualificació màxima que es pot obtenir en la lliçó. L\'escala és de 0 a 100%. Aquest valor es pot modificar en qualsevol moment. Qualsevol canvi té un efecte immediat en la pàgina de qualificacions i en les qualificacions que es mostrin a l\'estudiantat en les diverses llistes. Si la qualificació s\'estableix a 0, la lliçó no apareixerà en cap de les pàgines de qualificació. </p>';
$string['maxhighscores'] = 'Nombre de puntuacions màximes mostrades';
$string['maximumnumberofanswersbranches'] = 'Nombre màxim de respostes/ramificacions';
$string['maximumnumberofanswersbranches_help'] = 'Aquest paràmetre especifica el nombre màxim de respostes / branques que es poden utilitzar en la lliçó. Si només hi ha preguntes de tipus Vertader / Fals es pot ajustar a 2. La configuració es pot canviar en qualsevol moment, ja que només afecta a allò que veu el professorat, no les dades.';
$string['maximumnumberofattempts'] = 'Nombre màxim d\'intents';
$string['maximumnumberofattempts_help'] = 'Aquest paràmetre especifica el nombre màxim d\'intents permesos per a cada pregunta. Si es respon incorrectament en diverses ocasions i s\'assoleix el valor màxim, es mostrarà la pàgina  següent de la lliçó .';
$string['maximumnumberofattemptsreached'] = 'Heu arribat al nombre màxim d\'intents. Ara passareu a la pàgina següent.';
$string['maxtime'] = 'Límit de temps (minuts)';
$string['maxtimewarning'] = 'Us queden {$a} minuts per acabar la lliçó.';
$string['mediaclose'] = 'Mostra el botó de tancar:';
$string['mediafile'] = 'Finestra emergent de fitxer o pàgina web';
$string['mediafile_help'] = 'Per incloure una finestra emergent al començament d\'una lliçó, seleccioneu el fitxer apropiat per mostrar. Cada pàgina de la lliçó inclourà un enllaç per tornar a obrir la finestra emergent en cas necessari.';
$string['mediafilepopup'] = 'Feu clic aquí per visualitzar';
$string['mediaheight'] = 'Alçada de la finestra emergent';
$string['mediawidth'] = 'Amplada de la finestra emergent';
$string['messageprovider:graded_essay'] = 'Notificació de la qualificació de la prova';
$string['minimumnumberofquestions'] = 'Nombre mínim de preguntes';
$string['minimumnumberofquestions_help'] = 'Aquest paràmetre especifica el nombre mínim de preguntes que s\'utilitzaran per calcular la qualificació de l\'activitat. Si la lliçó conté una o més taules de ramificació, el nombre mínim de preguntes ha de ser posat a zero.

Si, per exemple, es posa  a 20 pot ser interessant afegir a la pàgina d\'inici de la lliçó un text semblant  a aquest:
"En aquesta lliçó heu de respondre com a mínim a 20 preguntes, tot i que en podeu respondre més si ho desitgeu. No obstant això, si responeu menys de 20 preguntes, la vostra qualificació serà calculada com si n\'haguéssiu respost 20."';
$string['missingname'] = 'Introduïu un àlies';
$string['modattempts'] = 'Permet a l\'estudiant la revisió';
$string['modattempts_help'] = 'Si s\'activa, els estudiants poden navegar per la lliçó de nou i des del principi.';
$string['modattemptsnoteacher'] = 'No podeu fer la revisió dels estudiants.';
$string['modulename'] = 'Lliçó';
$string['modulename_help'] = 'El mòdul de lliçó permet al professorat crear una experiència d\'aprenentatge adaptatiu que consisteix en una sèrie de pàgines que contenen diferents formats de preguntes.';
$string['modulenameplural'] = 'Lliçons';
$string['move'] = 'Mou la pàgina';
$string['movedpage'] = 'S\'ha mogut la pàgina';
$string['movepagehere'] = 'Mou la pàgina aquí';
$string['moving'] = 'S\'està movent la pàgina: {$a}';
$string['multianswer'] = 'Resposta múltiple';
$string['multianswer_help'] = 'Marqueu la casella de verificació si hi ha més d\'una resposta correcta.';
$string['multichoice'] = 'Opcions múltiples';
$string['multipleanswer'] = 'Múltiples respostes';
$string['nameapproved'] = 'Nom autoritzat';
$string['namereject'] = 'El nom que heu escrit ha estat rebutjat.<br>Trieu-ne un altre.';
$string['new'] = 'Nou';
$string['nextpage'] = 'Pàgina següent';
$string['noanswer'] = 'No s\'ha donat cap resposta';
$string['noattemptrecordsfound'] = 'No s\'ha trobat cap registre d\'intents: no hi ha qualificació.';
$string['nobranchtablefound'] = 'No s\'ha trobat la taula de ramificacions';
$string['nocommentyet'] = 'No comentat encara.';
$string['nocoursemods'] = 'No s\'han trobat activitats';
$string['nocredit'] = 'No hi ha crèdit';
$string['nodeadline'] = 'Sense data límit';
$string['noessayquestionsfound'] = 'No s\'han trobat preguntes de resposta oberta en aquesta lliçó';
$string['nohighscores'] = 'Sense puntuacions màximes';
$string['nolessonattempts'] = 'Encara no s\'ha registrat cap intent en aquesta lliçó';
$string['nooneansweredcorrectly'] = 'Ningú ha contestat correctament.';
$string['nooneansweredthisquestion'] = 'Ningú ha contestat aquesta pregunta.';
$string['noonecheckedthis'] = 'Ningú ha contestat això.';
$string['nooneenteredthis'] = 'Ningú ha escrit això.';
$string['noonehasanswered'] = 'Ningú no ha contestat encara una pregunta de resposta oberta.';
$string['noretake'] = 'No podeu tornar a fer aquesta lliçó.';
$string['normal'] = 'Normal: segueix el camí de la lliçó';
$string['notcompleted'] = 'Incomplet';
$string['notdefined'] = 'No està definit';
$string['nothighscore'] = 'No heu aconseguit la {$a} posició a la llista de puntuacions màximes.';
$string['notitle'] = 'Sense títol';
$string['numberofcorrectanswers'] = 'Nombre de respostes correctes: {$a}';
$string['numberofcorrectmatches'] = 'Nombre d\'aparellaments correctes';
$string['numberofpagestoshow'] = 'Nombre de pàgines per mostrar';
$string['numberofpagestoshow_help'] = 'Aquest paràmetre especifica el nombre de pàgines que es mostren en una lliçó. Només és aplicable per a les lliçons on les pàgines es mostren en ordre aleatori (quan "Acció després de la resposta correcta" té seleccionada l\'opció  "Mostra una pàgina no vista" o "Mostra una pàgina no contestada"). Si es posa a zero, llavors es mostren totes les pàgines.';
$string['numberofpagesviewed'] = 'Nombre de preguntes contestades: {$a}';
$string['numberofpagesviewednotice'] = 'Nombre de preguntes contestades: {$a->nquestions}; (n\'hauríeu de contestar com a mínim: {$a->minquestions})';
$string['numerical'] = 'Numèrica';
$string['ongoing'] = 'Mostra la puntuació acumulada';
$string['ongoingcustom'] = 'Aquesta lliçó us pot donar {$a->score} punts. Fins ara n\'heu aconseguit {$a->score} de {$a->currenthigh}.';
$string['ongoing_help'] = 'Si està activat, cada pàgina mostrarà els punts que l\'estudiant ha obtingut del total possible fins ara.';
$string['ongoingnormal'] = 'Heu contestat correctament {$a->correct} preguntes d\'un total de {$a->viewed} intents.';
$string['onpostperpage'] = 'Només un enviament per qualificació';
$string['options'] = 'Opcions';
$string['or'] = 'O';
$string['ordered'] = 'Ordenat';
$string['other'] = 'Altre';
$string['outof'] = 'de {$a}';
$string['overview'] = 'Revisió';
$string['overview_help'] = 'Una lliçó es composa d\'un cert nombre de pàgines i, opcionalment, de taules de ramificació. Una pàgina inclou alguns continguts i en general acaba amb una pregunta. Hi ha un salt associat a cada resposta a la pregunta. El salt pot ser relatiu, com a aquesta pàgina o a la pàgina següent, o absolut, especificant una de les pàgines de la lliçó. Una taula de ramificació és una pàgina que conté un conjunt d\'enllaços a altres pàgines de la lliçó, per exemple, una Taula de contingut.';
$string['page'] = 'Pàgina: {$a}';
$string['pagecontents'] = 'Continguts de la pàgina';
$string['page-mod-lesson-edit'] = 'Edita la pàgina de la lliçó';
$string['page-mod-lesson-view'] = 'Mostra o previsualitza la pàgina de la lliçó';
$string['page-mod-lesson-x'] = 'Qualsevol pàgina de la lliçó';
$string['pages'] = 'Pàgines';
$string['pagetitle'] = 'Títol de la pàgina';
$string['password'] = 'Contrasenya';
$string['passwordprotectedlesson'] = '{$a} és una lliçó protegida per contrasenya.';
$string['pleasecheckoneanswer'] = 'Si us plau, marqueu una resposta';
$string['pleasecheckoneormoreanswers'] = 'Si us plau, marqueu una o més respostes';
$string['pleaseenteryouranswerinthebox'] = 'Introduïu la vostra resposta al quadre.';
$string['pleasematchtheabovepairs'] = 'Si us plau, relacioneu les parelles de dalt';
$string['pluginadministration'] = 'Administració de la lliçó';
$string['pluginname'] = 'Lliçó';
$string['pointsearned'] = 'Punts aconseguits';
$string['postprocesserror'] = 'S\'ha produït un error durant el postprocessament';
$string['postsuccess'] = 'Missatge enviat correctament';
$string['practice'] = 'Lliçó de pràctica';
$string['practice_help'] = 'Una lliçó de pràctica no té reflex en el llibre de qualificacions';
$string['preprocesserror'] = 'S\'ha produït un error durant el preprocessament';
$string['prerequisitelesson'] = 'Prerequisits de la lliçó';
$string['preview'] = 'Previsualització';
$string['previewlesson'] = 'Previsualitza {$a}';
$string['previouspage'] = 'Pàgina anterior';
$string['processerror'] = 'S\'ha produït un error durant el processament';
$string['progressbar'] = 'Barra de progrés.';
$string['progressbar_help'] = 'Si està activada, es mostra una barra a la part inferior de les pàgines de la lliçó que indica el percentatge aproximat de la seva compleció.';
$string['progressbarteacherwarning'] = 'La barra de progrés no es visualitza per a {$a}';
$string['progressbarteacherwarning2'] = 'No veureu la barra de progrés, ja que teniu permís per modificar aquesta lliçó';
$string['progresscompleted'] = 'Heu completat el {$a}%  de la lliçó.';
$string['qtype'] = 'Tipus de pàgina';
$string['question'] = 'Pregunta';
$string['questionoption'] = 'Opció de pregunta';
$string['questiontype'] = 'Tipus de pregunta';
$string['randombranch'] = 'Pàgina de ramificació aleatòria';
$string['randompageinbranch'] = 'Pregunta aleatòria en una ramificació';
$string['rank'] = 'Rang';
$string['rawgrade'] = 'Qualificació bruta';
$string['receivedcredit'] = 'Crèdit aconseguit';
$string['redisplaypage'] = 'Torna a mostrar la pàgina';
$string['report'] = 'Informe';
$string['reports'] = 'Informes';
$string['response'] = 'Reacció';
$string['retakesallowed'] = 'Es permet repetir';
$string['retakesallowed_help'] = 'Si s\'activa, els estudiants poden seguir la lliçó més d\'una vegada.';
$string['returnto'] = 'Torna a {$a}';
$string['returntocourse'] = 'Torna al curs';
$string['review'] = 'Revisa';
$string['reviewlesson'] = 'Revisa la lliçó';
$string['reviewquestionback'] = 'Sí, vull tornar-ho a provar';
$string['reviewquestioncontinue'] = 'No, vull anar a la pregunta següent';
$string['sanitycheckfailed'] = 'La comprovació ha fallat: S\'ha suprimit aquest intent.';
$string['savechanges'] = 'Desa els canvis';
$string['savechangesandeol'] = 'Desa tots els canvis i ves al final de la lliçó.';
$string['savepage'] = 'Desa la pàgina';
$string['score'] = 'Puntuació';
$string['score_help'] = 'La puntuació sols s\'usa quan s\'ha habilitat la puntuació personalitzada. Cada pregunta pot tenir un valor numèric (positiu o negatiu).';
$string['scores'] = 'Puntuacions';
$string['secondpluswrong'] = 'Incorrecte de nou. Voleu tornar-ho a provar?';
$string['selectaqtype'] = 'Seleccioneu un tipus de pregunta';
$string['shortanswer'] = 'Resposta breu';
$string['showanunansweredpage'] = 'Mostra una pàgina no contestada';
$string['showanunseenpage'] = 'Mostra una pàgina no vista';
$string['singleanswer'] = 'Només una resposta';
$string['skip'] = 'Omet la navegació';
$string['slideshow'] = 'Diapositives.';
$string['slideshowbgcolor'] = 'Color de fons de les diapositives.';
$string['slideshowheight'] = 'Alçada de la diapositiva.';
$string['slideshow_help'] = 'Si està activat, la lliçó es veurà com una presentació de diapositives, amb una amplada i alçada fixes.';
$string['slideshowwidth'] = 'Amplada de la diapositiva.';
$string['startlesson'] = 'Comença la lliçó';
$string['studentattemptlesson'] = 'Intent número {$a->attempt} de {$a->firstname} {$a->lastname},';
$string['studentname'] = 'Nom {$a}';
$string['studentoneminwarning'] = 'Avís: us queda un minut o menys per acabar la lliçó.';
$string['studentresponse'] = 'Resposta de {$a}';
$string['submit'] = 'Envia';
$string['submitname'] = 'Envia el nom';
$string['teacherjumpwarning'] = 'En aquesta lliçó s\'utilitza un salt {$a->cluster} o un salt {$a->unseen}. Al seu lloc es farà servir un salt a la pàgina següent Entreu com estudiant per comprovar aquests salts.';
$string['teacherongoingwarning'] = 'La puntuació acumulada només es mostra a l\'estudiant. Entreu com estudiant per comprovar la puntuació acumulada.';
$string['teachertimerwarning'] = 'El cronòmetre només es mostra als estudiants. Entreu com estudiant per comprovar-ne el funcionament';
$string['thatsthecorrectanswer'] = 'Aquesta és la resposta correcta';
$string['thatsthewronganswer'] = 'Aquesta resposta és errònia';
$string['thefollowingpagesjumptothispage'] = 'Les pàgines següents salten a aquesta pàgina';
$string['thispage'] = 'Aquesta pàgina';
$string['timeisup'] = 'S\'ha acabat el temps';
$string['timeremaining'] = 'Temps restant';
$string['timespenterror'] = 'Heu de dedicar almenys {$a} minuts en la lliçó';
$string['timespentminutes'] = 'Temps dedicat (minuts).';
$string['timetaken'] = 'Temps dedicat';
$string['topscorestitle'] = 'Les {$a} puntuacions màximes de la lliçó.';
$string['truefalse'] = 'Vertader/Fals';
$string['unabledtosavefile'] = 'No es pot desar el fitxer que heu carregat.';
$string['unknownqtypesnotimported'] = 'No s\'han importat {$ a} preguntes amb tipus de pregunta no suportat.';
$string['unseenpageinbranch'] = 'Pregunta no vista en una ramificació';
$string['unsupportedqtype'] = 'Tipus de pregunta no implementat ({$a})';
$string['updatedpage'] = 'S\'ha actualitzat la pàgina';
$string['updatefailed'] = 'No s\'ha pogut actualitzar';
$string['usemaximum'] = 'Utilitza la màxima';
$string['usemean'] = 'Utilitza la mitjana';
$string['usepassword'] = 'Lliçó protegida per contrasenya';
$string['usepassword_help'] = 'Si s\'activa, es necessitarà una contrasenya per accedir a la lliçó.';
$string['viewgrades'] = 'Mostra les qualificacions';
$string['viewhighscores'] = 'Mostra la llista de puntuacions més altes.';
$string['viewreports'] = 'Visualitza {$a->attempts} intents completats';
$string['viewreports2'] = 'Mostra {$a} intents completats';
$string['welldone'] = 'Molt bé';
$string['whatdofirst'] = 'Què voleu fer primer?';
$string['wronganswerjump'] = 'Salt de resposta errònia';
$string['wronganswerscore'] = 'Puntuació de resposta errònia';
$string['wrongresponse'] = 'Resposta errònia';
$string['xattempts'] = '{$a} intents';
$string['youhaveseen'] = 'Ja heu vist més d\'una pàgina d\'aquesta lliçó.<br /> Voleu començar a la darrera pàgina que vau veure?';
$string['youmadehighscore'] = 'Heu aconseguit la posició {$a} en la llista de puntuacions màximes.';
$string['youranswer'] = 'La vostra resposta';
$string['yourcurrentgradeis'] = 'La vostra qualificació actual és {$a}';
$string['yourcurrentgradeisoutof'] = 'La vostra qualificació actual és {$a->grade} sobre {$a->total}';
$string['youshouldview'] = 'N\'hauríeu de contestar com a mínim: {$a}';
