<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'ca', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Ja esteu registrat com {$a}, heu de tancar la sessió abans d\'identificar-vos com a un altre usuari.';
$string['authnotexisting'] = 'No existeix el connector d\'autorització.';
$string['backupcontainexternal'] = 'Aquest fitxer de còpia de seguretat conté hostes en xarxa de Moodle externs que no han estat configurats localment.';
$string['backuptablefail'] = 'No s\'han pogut configurar correctament les taules de la còpia de seguretat.';
$string['blockcannotconfig'] = 'Aquest bloc no dóna suport a la configuració global.';
$string['blockcannotinistantiate'] = 'Hi ha un problema en la instància de l\'objecte bloc';
$string['blockcannotread'] = 'No s\'han pogut llegir les dades del blockid= {$a}';
$string['blockdoesnotexist'] = 'Aquest bloc no existeix';
$string['blockdoesnotexistonpage'] = 'Aquest bloc (id={$a->instanceid}) no existeix en aquesta pàgina ({$a->url}).';
$string['blocknameconflict'] = 'S\'ha produit un conflicte de noms: el bloc {$a->name} té el mateix títol que el bloc existent: {$a->conflict}!';
$string['callbackrejectcomment'] = 'El sistema (Comment callback) ha rebutjat aquest comentari.';
$string['cannotaddcoursemodule'] = 'No s\'ha pogut afegir un nou mòdul de curs';
$string['cannotaddcoursemoduletosection'] = 'No s\'ha pogut afegir el nou mòdul de curs a aquesta secció';
$string['cannotaddmodule'] = 'El mòdul {$a} no s\'ha pogut afegir a la llista de mòduls.';
$string['cannotaddnewmodule'] = 'No s\'ha pogut afegir un nou mòdul de {$a}';
$string['cannotaddrss'] = 'No teniu permís per a afegir canals RSS';
$string['cannotaddthisblocktype'] = 'No podeu afegir un bloc {$a} a aquesta pàgina.';
$string['cannotassignrole'] = 'No s\'ha pogut assignar un sol en el curs';
$string['cannotassignrolehere'] = 'No esteu autoritzat per assignar aquest rol (id = {$a->roleid})en aquest context ({$a->context})';
$string['cannotassignselfasparent'] = 'No es pot assignar a si mateix com a pare.';
$string['cannotcallscript'] = 'No podeu cridar aquest script d\'aquesta manera.';
$string['cannotcallusgetselecteduser'] = 'No podeu cridar user_selector::get_selected_user si multi select és cert.';
$string['cannotcreatebackupdir'] = 'No s\'ha pogut crear el directori de còpies de seguretat. Cal que l\'administrador del lloc assigni els permisos.';
$string['cannotcreatecategory'] = 'No s\'ha inserit la categoria';
$string['cannotcreatedboninstall'] = '<p>No és pot crear la base de dades.</p> <p>La base de dades especificada no existeix i l\'usuari que heu proporcionat no té permís per a crear-la.</p>
<p>L\'administrador del lloc hauria de verificar la configuració de la base de dades.</p>';
$string['cannotcreategroup'] = 'S\'ha produït un error en crear la categoria';
$string['cannotcreatelangbase'] = 'S\'ha produït un error. No s\'ha creat el directori base d\'idiomes.';
$string['cannotcreatelangdir'] = 'No s\'ha pogut crear el directori d\'idiomes.';
$string['cannotcreateorfindstructs'] = 'S\'ha produït un error en crear l\'estructura de seccions d\'aquest curs';
$string['cannotcreatepopupwin'] = 'Element no definit. No s\'ha pogut crear la finestra emergent.';
$string['cannotcreatesitedir'] = 'No es pot crear el directori del lloc. Cal que l\'administrador del lloc assigni els permisos.';
$string['cannotcreatetempdir'] = 'No s\'ha pogut crear el directori temporal';
$string['cannotcreateuploaddir'] = 'No s\'ha pogut crear el directori de pujades. Cal que l\'administrador del lloc assigni els permisos.';
$string['cannotcustomisefiltersblockuser'] = 'No podeu personalitzar les opcions dels filtres en els contexts usuari o bloc.';
$string['cannotdeletebackupids'] = 'No s\'han pogut eliminar els IDs de les còpies de seguretat anteriors';
$string['cannotdeletecategorycourse'] = 'No s\'ha pogut esborrar el curs \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'No s\'han pogut esborrar les preguntes de la categoria {$a}';
$string['cannotdeletecourse'] = 'No teniu permisos per esborrar aquest curs';
$string['cannotdeletecustomfield'] = 'S\'ha produït un error en eliminar les dades del camp personalitzat';
$string['cannotdeletedir'] = 'No s\'ha pogut eliminar ({$a})';
$string['cannotdeletefile'] = 'No s\'ha pogut eliminar aquest fitxer';
$string['cannotdeleterole'] = 'No s\'ha pogut eliminar perquè {$a}';
$string['cannotdeleterolewithid'] = 'No s\'ha pogut eliminar el rol amb ID {$a}';
$string['cannotdeletethisrole'] = 'No podeu eliminar aquest rol perquè està sent utilitzat pel sistema o perquè és el darrer rol amb capacitats d\'administrador.';
$string['cannotdisableformat'] = 'No podeu inhabilitar el format per defecte';
$string['cannotdownloadcomponents'] = 'No s\'han pogut baixar components';
$string['cannotdownloadlanguageupdatelist'] = 'No es pot baixar de download.moodle.org la llista d\'actualitzacions d\'idiomes.';
$string['cannotdownloadzipfile'] = 'No s\'ha pogut baixar el fitxer zip';
$string['cannoteditcomment'] = 'No podeu editar aquest5 comentari perquè no és vostre.';
$string['cannoteditcommentexpired'] = 'No ho podeu editar. S\'ha acabat el temps.';
$string['cannoteditpostorblog'] = 'No podeu enviar o editar entrades de bloc.';
$string['cannoteditsiteform'] = 'No podeu editar el curs del lloc amb aquest formulari.';
$string['cannotedityourprofile'] = 'No podeu editar el vostre propi perfil';
$string['cannotexecduringupgrade'] = 'No es pot executar mentre s\'està actualitzant.';
$string['cannotfindcategory'] = 'No s\'ha pogut trobar a la base de dades el registre de la categoria amb ID - {$a}';
$string['cannotfindcomponent'] = 'No s\'ha pogut trobar el component';
$string['cannotfindcontext'] = 'No s\'ha pogut trobar el context';
$string['cannotfindcourse'] = 'No s\'ha pogut trobar el curs';
$string['cannotfinddocs'] = 'No s\'han pogut trobar els fitxers de la documentació de l\'idioma "{$a}"';
$string['cannotfindgradeitem'] = 'No s\'ha pogut trobar grade_item';
$string['cannotfindgroup'] = 'No s\'ha pogut trobar el grup';
$string['cannotfindhelp'] = 'No s\'han pogut trobar els fitxers d\'ajuda de l\'idioma "{$a}"';
$string['cannotfindinfo'] = 'No s\'ha pogut trobar informació per "{$a}"';
$string['cannotfindlang'] = 'No s\'ha pogut trobar el paquet d\'idioma "{$a}"';
$string['cannotfindteacher'] = 'No s\'ha pogut trobar el/la professor/a';
$string['cannotfinduser'] = 'No s\'ha pogut trobar l\'usuari anomenat "{$a}"';
$string['cannotgeoplugin'] = 'No s\'ha pogut connectar al servidor geoPlugin a http://www.geoplugin.com, comproveu els paràmetres del servidor intermediari o instal·leu millor els fitxers de dades MaxMind GeoLite City';
$string['cannotgetblock'] = 'No s\'han pogut recuperar els blocs de la base de dades.';
$string['cannotgetcats'] = 'No s\'ha pogut recuperar el registre de la categoria';
$string['cannotgetdata'] = 'No s\'ha pogut recuperar la dada';
$string['cannotgradeuser'] = 'No s\'ha pogut qualificar aquest usuari';
$string['cannothaveparentcate'] = 'La categoria del curs no pot tenir pare.';
$string['cannotimport'] = 'S\'ha produït un error en importar';
$string['cannotimportformat'] = 'La importació d\'aquest format encara no està implementada.';
$string['cannotimportgrade'] = 'S\'ha produït un error en importar qualificacions';
$string['cannotinsertgrade'] = 'No es pot inserir una qualificació sense l\'ID del curs.';
$string['cannotinsertrate'] = 'No es pot inserir una nova qualificació ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'No s\'ha pogut inserir el nou registre ID {$a}';
$string['cannotmailconfirm'] = 'S\'ha produït un error en enviar el correu de confirmació del canvi de contrasenya.';
$string['cannotmanualctrack'] = 'L\'activitat no ofereix el seguiment de la compleció manual.';
$string['cannotmapfield'] = 'S\'ha detectat una col·lisió: dos mapes de camps al mateix element de qualificació {$a}';
$string['cannotmarktopic'] = 'No s\'ha pogut aquest tema per aquest curs';
$string['cannotmigratedatacomments'] = 'No s\'han pogut migrar els comentaris del mòdul de dades.';
$string['cannotmodulename'] = 'No s\'ha pogut recuperar el nom del mòdul al construir la navegació.';
$string['cannotmoduletype'] = 'No s\'ha pogut recuperar el tipus de mòdul al construir la navegació.';
$string['cannotmovecategory'] = 'No es pot moure la categoria.';
$string['cannotmovecourses'] = 'No es poden moure els cursos de la categoria en què són a una altra.';
$string['cannotmoverolewithid'] = 'No s\'ha pogut moure el rol amb ID {$a}';
$string['cannotopencsv'] = 'No s\'ha pogut obrir el fitxer CSV';
$string['cannotopenfile'] = 'No s\'ha pogut obrir el fitxer ({$a})';
$string['cannotopenforwrit'] = 'No s\'ha pogut obrir ({$a}) per a escriure-hi';
$string['cannotopentemplate'] = 'No s\'ha pogut obrir el fitxer de plantilla ({$a})';
$string['cannotopenzip'] = 'No s\'ha pogut obrir el fitxer comprimit, probablement per un problema amb l\'extensió zip en el S.O. en 64 bits';
$string['cannotoverridebaserole'] = 'No s\'han pogut anul·lar les capacitats del rol base';
$string['cannotoverriderolehere'] = 'No esteu autoritzat a anul·lar aquest rol (id = {$a->roleid}) en aquest context ({$a->context})';
$string['cannotreadfile'] = 'No s\'ha pogut llegir el fitxer ({$a})';
$string['cannotreadtmpfile'] = 'S\'ha produït un error en llegir el fitxer temporal';
$string['cannotreaduploadfile'] = 'No s\'ha pogut llegir el fitxer carregat';
$string['cannotremovefrommeta'] = 'No s\'ha pogut eliminar el curs seleccionat d\'aquest metacurs';
$string['cannotresetguestpwd'] = 'No podeu reiniciar la contrasenya del visitant';
$string['cannotresetmail'] = 'S\'ha produït un error en reiniciar la contrasenya i enviar el correu';
$string['cannotresetthisrole'] = 'No es pot reiniciar aquest rol';
$string['cannotrestore'] = 'S\'ha produït un error i no es pot completar la restauració.';
$string['cannotrestoreadminorcreator'] = 'Heu de tenir el rol de Creador o Administrador per poder restaurar en un curs nou.';
$string['cannotrestoreadminoredit'] = 'Heu de tenir el rol de Professor editor o Administrador per poder restaurar en el curs seleccionat.';
$string['cannotsaveagreement'] = 'No s\'ha pogut desar el vostre acord';
$string['cannotsaveblock'] = 'S\'ha produït un error en desar la configuració del bloc';
$string['cannotsavecomment'] = 'No s\'ha pogut desar el comentari.';
$string['cannotsavedata'] = 'No s\'han pogut desar les dades.';
$string['cannotsavefile'] = 'No s\'ha pogut desar el fitxer "{$a}"';
$string['cannotsavemd5file'] = 'No s\'ha pogut desar el fitxer md5';
$string['cannotsavezipfile'] = 'No s\'ha pogut desar el fitxer zip';
$string['cannotservefile'] = 'No s\'ha pogut servir el fitxer a causa d\'un problema de configuració del servidor.';
$string['cannotsetparentforcatoritem'] = 'No s\'ha pogut configurar el pare de la categoria o de l\'element del curs';
$string['cannotsetpassword'] = 'No s\'ha pogut configurar la contrasenya de l\'ususari';
$string['cannotsetprefgrade'] = 'No s\'han pogut configurar les preferències de la vista d\'agregació de {$a} per aquesta categoria de qualificació';
$string['cannotsettheme'] = 'No s\'ha pogut configurar el tema.';
$string['cannotsetupblock'] = 'No s\'han pogut configurar correctament les taules dels blocs.';
$string['cannotsetupcapformod'] = 'No s\'han pogut configurar les capacitats de {$a}';
$string['cannotsetupcapforplugin'] = 'No s\'han pogut configurar les capacitats de {$a}';
$string['cannotshowhidecoursesincategory'] = 'No s\'han pogut Mostrar/Amagar les cursos de la categoria {$a}';
$string['cannotunassigncap'] = 'No s\'ha pogut cancel·lar l\'assignació de la capacitat obsoleta {$ a->cap} del rol {$ a->rol}';
$string['cannotunassignrolefrom'] = 'No s\'ha pogut cancel·lar l\'assignació del rol id: {$a} a aquest usuari';
$string['cannotunzipfile'] = 'No s\'ha pogut descomprimir el fitxer';
$string['cannotupdatemod'] = 'No s\'ha pogut actualitzar {$a}';
$string['cannotupdatepasswordonextauth'] = 'S\'ha produït un error en actualitzar la contrasenya amb external auth: {$a}. Vegeu els registres del servidor per tenir-ne més detalls.';
$string['cannotupdateprofile'] = 'S\'ha produït un error en actualitzar el registre de l\'usuari';
$string['cannotupdaterecord'] = 'No s\'ha pogut actualitzar el registre ID {$a}';
$string['cannotupdaterss'] = 'No es pot actualitzar el RSS';
$string['cannotupdatesubcourse'] = 'No s\'ha pogut actualitzar el curs fill';
$string['cannotupdateusermsgpref'] = 'No s\'han pogut actualitzar les preferències sobre els missatges de l\'usuari';
$string['cannotupdateuseronexauth'] = 'S\'ha produït un error en actualitzar les dades de l\'usuari amb external auth: {$a}. Vegeu els registres del servidor per tenir-ne més detalls.';
$string['cannotuploadfile'] = 'S\'ha produït un error en carregar el fitxer';
$string['cannotuseadmin'] = 'Cal que sigueu administrador per utilitzar aquesta pàgina';
$string['cannotuseadminadminorteacher'] = 'Cal que sigueu administrador o professor per utilitzar aquesta pàgina';
$string['cannotusepage'] = 'Només el professorat o l\'administrador poden utilitzar aquesta pàgina';
$string['cannotusepage2'] = 'No podeu utilitzar aquesta pàgina';
$string['cannotviewprofile'] = 'No podeu veure el perfil d\'aquest usuari.';
$string['cannotviewreport'] = 'No podeu veure aquest informe';
$string['cannotwritefile'] = 'No s\'ha pogut escriure en el fitxer ({$a})';
$string['categoryerror'] = 'Error en la categoria';
$string['categoryidnumbertaken'] = 'El número ID s\'està utilitzant per a una altra categoria.';
$string['categorynamerequired'] = 'El nom de la categoria és obligatori.';
$string['categorytoolong'] = 'Nom de categoria massa llarg';
$string['commentmisconf'] = 'L\'ID del comentari està mal configurat';
$string['componentisuptodate'] = 'El component està al dia';
$string['confirmsesskeybad'] = 'No s\'ha pogut confirmar la vostra clau de sessió per portar a terme aquesta acció. Aquesta característica de seguretat impedeix que s\'executin funcions importants en el vostre nom de manera accidental o fraudulenta. Si us plau confirmeu que volíeu realment executar aquesta funció.';
$string['couldnotassignrole'] = 'S\'ha produït un error greu sense especificar mentre se us intentava assignar un rol';
$string['couldnotupdatenoexistinguser'] = 'No s\'ha pogut actualitzar l\'usuari perquè no existeix.';
$string['countriesphpempty'] = 'Error: falta o està buit el fitxer de països countries.php del paquet d\'idioma {$a}';
$string['coursedoesnotbelongtocategory'] = 'El curs no pertany a aquesta categoria';
$string['courseformatnotfound'] = 'El format de curs ({$a}) o no existeix o no és reconegut';
$string['coursegroupunknown'] = 'No s\'ha especificat el curs corresponent al grup {$a}';
$string['courseidnotfound'] = 'L\'id del curs no existeix';
$string['courseidnumbertaken'] = 'El número ID està essent utilitzat per a un altre curs ({$a})';
$string['coursemisconf'] = 'El curs està mal configurat';
$string['courserequestdisabled'] = 'L\'administrador ha desactivat la sol·licitud de cursos';
$string['csvcolumnduplicates'] = 'S\'han detectat columnes duplicades';
$string['csvemptyfile'] = 'El fitxer CSV està buit';
$string['csvfewcolumns'] = 'No hi ha prou columnes, reviseu el paràmetre delimitador';
$string['csvinvalidcols'] = '<b>Fitxer CSV no vàlid:</b> La primera línia ha d\'incloure els "Camps d\'encapçalament" i el fitxer ha de ser del tipus <br />"Camps expandits/Separat per comes"<br />o<br />"Camps expandits amb codi resultant CAVV/Separat per comes"';
$string['csvinvalidcolsnum'] = 'Fitxer CSV no vàlid. Cada línia ha d\'incloure 49 o 70 camps';
$string['csvloaderror'] = 'S\'ha produït un error durant la càrrega del fitxer CSV: {$a}';
$string['csvweirdcolumns'] = 'El format del fitxer CSV no és vàlid. El nombre de columnes no és constant.';
$string['dbconnectionfailed'] = '<p>Error: ha fallat la connexió amb la Base de dades</p> <p>És possible que la Base de dades estigui sobrecarregada o que no funcioni correctament.</p> <p>
L\'administrador del lloc també hauria de comprovar que els detalls de la Base de dades estan correctament especificats a config.php</p>';
$string['dbdriverproblem'] = '<p>Error: s\'ha detectat un problema en el motor de la Base de dades</p> <p>L\'administrador del lloc hauria de verificar la configuració del servidor</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'S\'ha detectat un problema seriós en la sessió de la Base de dades.<br /><br />Notifiqueu-ho a l\'administrador del servidor.';
$string['dbsessionhandlerproblem'] = 'S\'ha produït un error en configurar la sessió de la Base de dades.<br /><br />Notifiqueu-ho a l\'administrador del servidor.';
$string['dbsessionmysqlpacketsize'] = 'S\'ha detectat un problema seriós en la sessió.<br /><br />Notifiqueu-ho a l\'administrador. Aquest problema molt probablement està causat per un valor massa petit en la configuració de MySQL max_allowed_packet.';
$string['dbupdatefailed'] = 'Ha fallat l\'actualització de la base de dades';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" no es pot modificar. S\'ha trobat una dependència amb {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'S\'ha produït un error d\'execució DDL sql';
$string['ddlfieldalreadyexists'] = 'El camp "{$a}" ja existeix';
$string['ddlfieldnotexist'] = 'El camp "{$a->fieldname}" no existeix a la taula "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'La taula "{$a}" ja existeix';
$string['ddltablenotexist'] = 'La taula "{$a}" no existeix';
$string['ddlunknownerror'] = 'S\'ha produït un error a causa de la biblioteca desconeguda DDL';
$string['ddlxmlfileerror'] = 'S\'han trobat errors en el fitxer XML de la base de dades';
$string['ddsequenceerror'] = 'La definició de la taula "{$a}" és incorrecta. Només hi pot haver una columna auto i s\'ha de definir com a clau.';
$string['destinationcmnotexit'] = 'El mòdul de destinació del curs no existeix.';
$string['detectedbrokenplugin'] = 'No es pot continuar perquè el connector "{$a}" és defectuós o està antiquat.';
$string['dmlexceptiononinstall'] = '<p>S\'ha produït un error de la base de dades [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlreadexception'] = 'S\'ha produït un error en llegir a la base de dades';
$string['dmltransactionexception'] = 'S\'ha produït un error en fer una transacció a la base de dades';
$string['dmlwriteexception'] = 'S\'ha produït un error en escriure a la base de dades.';
$string['downgradedcore'] = 'S\'ha produït un error perquè el codi que esteu utilitzant és més antic que la versió amb què es va construir aquesta base de dades.';
$string['downloadedfilecheckfailed'] = 'Ha fallat la comprovació del fitxer baixat';
$string['duplicatefieldname'] = 'S\'ha detectat un duplicat del nom de camp "{$a}"';
$string['duplicatenosupport'] = 'L\'activitat \'{$a->modname}\' no és pot duplicar perquè el mòdul  {$a->modtype} no és compatible amb la funció de còpies de seguretat i restauracions.';
$string['duplicateparaminsql'] = 'S\'ha produït un error perquè hi ha un nom de paràmetre duplicat a la consulta';
$string['duplicaterolename'] = 'Ja existeix un rol amb aquest nom.';
$string['duplicateroleshortname'] = 'Ja existeix un rol amb aquest nom curt.';
$string['duplicateusername'] = 'Nom d\'usuari duplicat. S\'ha omès aquest registre.';
$string['emailfail'] = 'S\'ha produït un error en enviar el correu.';
$string['error'] = 'S\'ha produït un error';
$string['errorcleaningdirectory'] = 'S\'ha produït un error en netejar el directori "{$a}"';
$string['errorcopyingfiles'] = 'S\'ha produït un error en copiar els fitxers';
$string['errorcreatingdirectory'] = 'S\'ha produït un error en crear el directori "{$a}"';
$string['errorcreatingfile'] = 'S\'ha produït un error en crear el fitxer "{$a}"';
$string['errorcreatingrole'] = 'S\'ha produït un error en crear el rol.';
$string['errorfetchingrssfeed'] = 'S\'ha produït un error en recollir el RSS.';
$string['erroronline'] = 'S\'ha produït un error a la línia {$a}';
$string['errorparsingxml'] = 'S\'ha produït un error en analitzar l\'XML: {$a->errorstring} a la línia {$a->errorline}, caràcter {$a->errorchar}';
$string['errorprocessingarchive'] = 'Error mentre es processava el fitxer de l\'arxiu';
$string['errorreadingfile'] = 'S\'ha produït un error en llegir el fitxer "{$a}"';
$string['errorsavingrequest'] = 'S\'ha produït un error quan s\'intentava desar la vostra sol·licitud.';
$string['errorsettinguserpref'] = 'S\'ha produït un error en establir les preferències de l\'usuari';
$string['errorunzippingfiles'] = 'S\'ha produït un error en descomprimir els fitxers';
$string['expiredkey'] = 'La clau ha expirat';
$string['externalauthpassworderror'] = 'La contrasenya no ha d\'estar buida per a l\'autenticació externa';
$string['externalfilenolocation'] = 'El fitxer extern no té el camí d\'ubicació.';
$string['failtoloadblocks'] = 'A la base de dades hi ha un o més blocs registrats però n\'ha fallat la càrrega.';
$string['fieldrequired'] = '"{$a}" és un camp necessari';
$string['fileexists'] = 'El fitxer ja existeix';
$string['filemismatch'] = 'No coincideix el nom del fitxer no essencial. El fitxer "{$a->current}" hauria de ser {$a->file}';
$string['filenotfound'] = 'El fitxer sol·licitat no es pot trobar';
$string['filenotreadable'] = 'No es pot llegir el fitxer';
$string['filterdoesnothavelocalconfig'] = 'El filtre {$a} no permet la configuració local.';
$string['filternotactive'] = 'El filtre {$a} està inactiu.';
$string['filternotenabled'] = 'El filtre no està activat';
$string['filternotinstalled'] = 'El filtre {$a} no està instal·lat';
$string['forumblockingtoomanyposts'] = 'Heu sobrepassat el llindar de missatges definit per a aquest fòrum';
$string['generalexceptionmessage'] = 'Excepció - {$a}';
$string['gradecantregrade'] = 'S\'ha produït un error durant el càlcul de la qualificació: {$a}';
$string['gradepubdisable'] = 'La publicació de qualificacions està desactivada';
$string['groupalready'] = 'L\'usuari ja pertany al grup {$a}';
$string['groupexistforcourse'] = 'El grup "{$a}" ja existeix en aquest curs';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: El grup "{$a->name}" amb un idnumber de "{$a->idnumber}" ja existeix en aquest curs';
$string['grouphasidnumber'] = 'El grup \'{$a}\' té un idnumber i pot haver estat creat automàticament per un sistema extern. No teniu permís per suprimir aquest grup.';
$string['groupinghasidnumber'] = 'L\'agrupament \'{$a}\' té un idnumber i pot haver estat creat automàticament per un sistema extern. No teniu permís per suprimir aquest agrupament.';
$string['groupingnotaddederror'] = 'No s\'ha afegit l\'agrupació "{$a}"';
$string['groupnotaddederror'] = 'No s\'ha afegit el grup "{$a}"';
$string['groupnotaddedtogroupingerror'] = 'No s\'ha afegit el grup "{$a->groupname}" a l\'agrupació "{$a->groupingname}"';
$string['groupunknown'] = 'El grup {$a} no està associat al curs especificat';
$string['groupusernotmember'] = 'L\'usuari no és membre d\'aquest grup.';
$string['guestnocomment'] = 'Els visitants no tenen permís per enviar comentaris.';
$string['guestnoeditprofile'] = 'Els usuaris visitants no poden editar el seu perfil';
$string['guestnoeditprofileother'] = 'El perfil de l\'usuari o usuària visitant no es pot editar';
$string['guestnorate'] = 'Els visitants no tenen permís per qualificar entrades.';
$string['guestsarenotallowed'] = 'L\'usuari visitant no té permís per a fer això';
$string['hackdetected'] = 'S\'ha detectat un atac pirata.';
$string['hashpoolproblem'] = 'El contingut del fitxer {$a} és incorrecte';
$string['headersent'] = 'Ja s\'han enviat els encapçalaments';
$string['idnumbertaken'] = 'Aquest número d\'ID ja és
utilitzat per un altre curs.';
$string['idnumbertoolong'] = 'El número d\'ID és massa llarg';
$string['importformatnotimplement'] = 'Encara no està implementada la importació d\'aquest format.';
$string['incorrectext'] = 'El fitxer té una extensió incorrecta';
$string['installproblem'] = 'Generalment no és possible recuperar-se dels errors que es van produir durant la instal·lació, pot ser haureu de crear una nova base de dades o utilitzar un prefix diferent de base de dades  si voleu reintentar la instal·lació.';
$string['internalauthpassworderror'] = 'Per a l\'autenticació interna falta la contrasenya o bé no és vàlida la política de contrasenyes.';
$string['invalidaccess'] = 'No s\'ha pogut accedir correctament a la pàgina';
$string['invalidaccessparameter'] = 'Paràmetre d\'accés no vàlid.';
$string['invalidaction'] = 'Paràmetre d\'acció no vàlid.';
$string['invalidactivityid'] = 'ID d\'activitat no vàlid.';
$string['invalidadminsettingname'] = 'Paràmetre d\'administració incorrecte ({$a})';
$string['invalidargorconf'] = 'No s\'han donat els arguments vàlids o bé la configuració del servidor no és la correcta.';
$string['invalidarguments'] = 'No s\'han donat els arguments vàlids';
$string['invalidblockinstance'] = 'Instància de bloc no vàlida per  {$a}';
$string['invalidbulkenrolop'] = 'La sol·licitud d\'inscripció en bloc no és vàlida.';
$string['invalidcategory'] = 'La Categoria és incorrecta.';
$string['invalidcategoryid'] = 'L\'id de la categoria és incorrecte.';
$string['invalidcomment'] = 'El comentari és incorrecte';
$string['invalidcommentarea'] = 'L\'àrea de comentaris no és vàlida';
$string['invalidcommentid'] = 'L\'ID del comentari no és vàlid';
$string['invalidcommentitemid'] = 'L\'itemid del comentari no és vàlid';
$string['invalidcommentparam'] = 'Els paràmetres del comentari no sóin vàlids';
$string['invalidcomponent'] = 'El nom del component no és vàlid';
$string['invalidconfirmdata'] = 'Les dades de confirmació no són vàlides';
$string['invalidcontext'] = 'El context no és vàlid';
$string['invalidcourse'] = 'El curs no és vàlid';
$string['invalidcourseid'] = 'Esteu intentant utilitzar un ID de curs incorrecte';
$string['invalidcourselevel'] = 'El nivell del context és incorrecte';
$string['invalidcoursemodule'] = 'L\'ID del mòdul de curs no és vàlid';
$string['invalidcoursenameshort'] = 'El nom curt del curs no és vàlid.';
$string['invaliddata'] = 'Les dades enviades són incorrectes.';
$string['invaliddatarootpermissions'] = 'S\'han detectat permisos no vàlids al directori $CFG->dataroot Cal que l\'administrador solucioni el problema dels permisos.';
$string['invaliddevicetype'] = 'El tipus de dispositiu no és vàlid.';
$string['invalidelementid'] = 'L\'id de l\'ement no és vàlid.';
$string['invalidentry'] = 'Aquesta entrada no és vàlida.';
$string['invalidevent'] = 'L\'esdeveniment no és vàlid';
$string['invalidfieldname'] = '"{$a}" no és un nom vàlid per a un camp';
$string['invalidfiletype'] = '"{$a}" no és un tipus de fitxer vàlid';
$string['invalidformatpara'] = 'El paràmetre escollit té un format incorrecte';
$string['invalidformdata'] = 'El formulari de dades és incorrecte';
$string['invalidfunction'] = 'La funció és incorrecta';
$string['invalidgradeitemid'] = 'L\'ID de l\'element de qualificació no és correcte';
$string['invalidgroupid'] = 'L\'ID del grup especificat no és correcte';
$string['invalidipformat'] = 'El format de l\'adreça IP no és vàlid.';
$string['invaliditemid'] = 'L\'ID de l\'element no és correcte';
$string['invalidkey'] = 'La clau és incorrecta';
$string['invalidlegacy'] = 'La definició del rol heretat del tipus {$a} és incorrecta';
$string['invalidmd5'] = 'L\'md5 no és vàlid. Torneu-ho a provar';
$string['invalidmode'] = 'El mode ({$a}) no és vàlid';
$string['invalidmodule'] = 'El mòdul no és vàlid';
$string['invalidmoduleid'] = 'El mòdul amb ID: {$a} no és vàlid';
$string['invalidmodulename'] = 'El mòdul de nom: {$a} no és vàlid';
$string['invalidnum'] = 'El valor numèric no és vàlid.';
$string['invalidnumkey'] = 'La matriu $conditions  no pot contenir claus numèriques, cal que canvieu el codi.';
$string['invalidoutcome'] = 'L\'ID de la competència no és correcte';
$string['invalidpagesize'] = 'La mida de la pàgina no és vàlida';
$string['invalidpasswordpolicy'] = 'La política de contrasenyes no és vàlida';
$string['invalidpaymentmethod'] = 'El mètode d epagament {$a} no és vàlid';
$string['invalidqueryparam'] = 'S\'ha produït un error a causa del nombre incorrecte de paràmetres de la consulta. S\'esperava {$a->expected}, però s\'ha obtingut {$a->actual}.';
$string['invalidratingarea'] = 'L\'àrea de qualificació no és vàlida';
$string['invalidrecord'] = 'No s\'ha pogut trobar el registre de dades a la taula {$a} de la base de dades.';
$string['invalidrecordunknown'] = 'No s\'ha pogut trobar el registre de dades a la base de dades.';
$string['invalidrequest'] = 'La sol·licitud no és vàlida';
$string['invalidrole'] = 'El rol no és vàlid';
$string['invalidroleid'] = 'L\'ID del rol no és vàlid.';
$string['invalidscaleid'] = 'L\'ID de l\'escala no és correcte';
$string['invalidsection'] = 'El registre de mòduls del curs conté una secció no vàlida.';
$string['invalidsesskey'] = 'La clau de sessió tramesa és incorrecta. No s\'ha acceptat el formulari.';
$string['invalidshortname'] = 'El nom curt del curs no és vàlid.';
$string['invalidsourcefield'] = 'El camp d\'origen del fitxer esborrany no és vàlid.';
$string['invalidstatedetected'] = 'S\'ha produït un error: {$a} que normalment ho hagués hagut de passar mai.';
$string['invalidurl'] = 'L\'URL no és vàlid';
$string['invaliduser'] = 'L\'usuari no és vàlid';
$string['invaliduserfield'] = 'El camp de l\'usuari {$a} no és vàlid';
$string['invaliduserid'] = 'L\'ID de l\'usuari no és vàlid';
$string['invalidusername'] = 'El nom d\'usuari que heu proporcionat conté caràcters invàlids';
$string['invalidxmlfile'] = '"{$a}" no és un fitxer XML vàlid';
$string['iplookupfailed'] = 'No es pot trobar informació geogràfica sobre aquesta adreça IP {$a}';
$string['iplookupprivate'] = 'No es pot mostrar informació d\'adreces IP privades';
$string['ipmismatch'] = 'El client no coincideix amb aquesta IP';
$string['listcantmovedown'] = 'No es pot moure aquest element més avall: és el darrer dels seus iguals';
$string['listcantmoveleft'] = 'No es pot moure aquest element a l\'esquerra: no és fill de cap altre element';
$string['listcantmoveright'] = 'No es pot moure aquest element a la dreta: no hi ha un element igual del qual fer-lo fill. Mogueu-lo sota un altre element igual i tot seguit podreu moure\'l a la dreta.';
$string['listcantmoveup'] = 'No es pot moure aquest element més amunt: és el primer dels seus iguals';
$string['listnochildren'] = 'No s\'han trobat fills d\'aquest element';
$string['listnoitem'] = 'No s\'ha trobat l\'element';
$string['listnopeers'] = 'No s\'han trobat elements iguals';
$string['listupdatefail'] = 'L\'operació de la base de dades ha fallat quan s\'estava editant la jerarquia de la llista';
$string['logfilenotavailable'] = 'No es pot accedir als registres';
$string['loginasnoenrol'] = 'No us podeu inscriure en un curs, o cancel·lar la inscripció, si heu "entrat com"';
$string['loginasonecourse'] = 'No podeu entrar en aquest curs.<br />Heu d\'acabar la sessió «Entra com a» abans d\'entrar a cap altre curs';
$string['maxareabytes'] = 'No hi ha prou espai disponible per emmagatzemar aquest fitxer';
$string['maxbytes'] = 'Aquest fitxer excedeix la mida màxima';
$string['messagingdisable'] = 'La missatgeria d\'aquest lloc està desactivada.';
$string['mimetexisnotexist'] = 'El vostre sistema no està configurat per fer funcionar mimeTeX. Cal que descarregueu l\'executable corresponent a la vostra plataforma PHP_OS de <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, o obtenir les fonts de C de <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, compilar-les i posar l\'executable al vostre directori moodle/filter/tex/';
$string['mimetexnotexecutable'] = 'El mimeTeX instal·lat no és executable';
$string['missingfield'] = 'Falta el camp "{$a}"';
$string['missingkeyinsql'] = 'S\'ha produït un error a causa del paràmetre perdut "{$a}" a la consulta.';
$string['missing_moodle_backup_xml_file'] = 'Falta el fitxer XML {$a} de la còpia de seguretat.';
$string['missingparam'] = 'Falta el paràmetre obligatori ({$a})';
$string['missingparameter'] = 'Falta un paràmetre';
$string['missingrequiredfield'] = 'Falta algun camp necessari';
$string['missinguseranditemid'] = 'Falta l\'userid i l\'itemid';
$string['missingvarname'] = 'Falta el nom de la variable exigida';
$string['mixedtypesqlparam'] = 'S\'ha produït un error perquè s\'han barrejat diferents tipus de paràmetres de la consulta sql';
$string['mnetdisable'] = 'MNET està desactivat';
$string['mnetlocal'] = 'Els usuaris de MNET remot no es poden registrar localment';
$string['moduledisable'] = 'Per aquest curs en particular s\'ha desactivat el mòdul ({$a})';
$string['moduledoesnotexist'] = 'Aquest mòdul no existeix';
$string['moduleinstancedoesnotexist'] = 'La instància d\'aquest mòdul no existeix.';
$string['modulemissingcode'] = 'El mòdul {$a} no inclou el codi necessari per a la realització d\'aquesta funció';
$string['movecatcontentstoroot'] = 'No es permet moure el contingut de la categoria a l\'arrel. Heu de moure els continguts a una categoria existent!';
$string['movecategorynotpossible'] = 'No podeu moure la categoria \'{$a}\' dins de la categoria seleccionada.';
$string['movecategoryownparent'] = 'No podeu fer la categoria \'{$a}\' pare d\'ella mateixa.';
$string['movecategoryparentconflict'] = 'No podeu convertir la categoria \'{$a}\' en una subcategoria d\'una de les seves subcategories pròpies.';
$string['multiplerecordsfound'] = 'S\'han trobat diferents registres, però se n\'esperava un de sol.';
$string['multiplerestorenotallow'] = 'No està permesa l\'execució de diferents restauracions.';
$string['mustbeloggedin'] = 'Heu d\'estar registrat per poder fer això';
$string['mustbeteacher'] = 'Cal ser professor/a per veure aquesta pàgina';
$string['myisamproblem'] = 'Les taules de la base de dades estan utilitzant el motor MyISAM. Es recomana utilitzar un motor de compilació ACID amb suport total a les transaccions, com ara InnoDB.';
$string['needcopy'] = 'Cal que primer copieu alguna cosa.';
$string['needcoursecategroyid'] = 'S\'ha d\'especificar o l\'ID del curs o la categoria';
$string['needphpext'] = 'Heu d\'afegir a la vostra instal·lació PHP suport {$a}';
$string['noadmins'] = 'No hi ha cap administrador';
$string['noblocks'] = 'No s\'ha trobat cap bloc';
$string['nocapabilitytousethisservice'] = 'L\'usuari no té la capacitat necessària per utilitzar aquest servei.';
$string['nocategorydelete'] = 'La categoria \'{$a}\' no es pot suprimir';
$string['nocontext'] = 'Aquest curs no és un context vàlid';
$string['nodata'] = 'No hi ha cap dada.';
$string['noexistingcategory'] = 'Aquesta categoria no existeix';
$string['nofile'] = 'No s\'ha especificat cap fitxer';
$string['nofiltersenabled'] = 'No hi ha cap filtre activat';
$string['nofolder'] = 'El directori sol·licitat no existeix';
$string['noformdesc'] = 'No s\'ha trobat cap fitxer de descripció formslib d\'aquesta activitat';
$string['noguest'] = 'Aquí no hi ha cap visitant';
$string['noinstances'] = 'No hi ha instància de {$a} en aquest curs.';
$string['nologinas'] = 'No esteu autoritzat a entrar com a aquest usuari';
$string['nonmeaningfulcontent'] = 'Contingut no significatiu';
$string['noparticipants'] = 'No s\'ha trobat cap participant en aquest curs';
$string['noparticipatorycms'] = 'No teniu mòduls participatius dels quals es pugui informar';
$string['nopermissions'] = 'Actualment no teniu permisos per a fer això ({$a})';
$string['nopermissiontocomment'] = 'No podeu afegir comentaris';
$string['nopermissiontodelentry'] = 'No podeu esborrar entrades d\'altres persones';
$string['nopermissiontoeditcomment'] = 'No podeu editar els comentaris d\'altres persones';
$string['nopermissiontohide'] = 'No teniu permís per ocultar';
$string['nopermissiontoimportact'] = 'No teniu els permisos necessaris per importar activitats a aquest curs.';
$string['nopermissiontolock'] = 'No teniu permís per bloquejar';
$string['nopermissiontomanagegroup'] = 'No teniu els permisos necessaris per gestionar grups';
$string['nopermissiontorate'] = 'No està permesa la qualificació d\'elements';
$string['nopermissiontoshow'] = 'No teniu els permisos per veure això';
$string['nopermissiontounlock'] = 'No teniu permís per desbloquejar';
$string['nopermissiontoupdatecalendar'] = 'No teniu permís per actualitzar els esdeveniments del calendari';
$string['nopermissiontoviewgrades'] = 'No podeu veure les qualificacions';
$string['nopermissiontoviewletergrade'] = 'Cal tenir el permís per veure les qualificacions en lletra.';
$string['nopermissiontoviewpage'] = 'No teniu permís per veure aquesta pàgina';
$string['nosite'] = 'No s\'ha pogut trobar un curs de nivell màxim';
$string['nositeid'] = 'No hi ha cap ID pel lloc';
$string['nostatstodisplay'] = 'No hi ha dades disponibles per a mostrar';
$string['notallowedtoupdateprefremotely'] = 'No teniu permís per actualitzar remotament les preferències de l\'usuari';
$string['notavailable'] = 'Això no està disponible actualment';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'No sou membre d\'aquest grup del curs';
$string['notownerofkey'] = 'No sou el propietari d\'aquesta clau';
$string['nousers'] = 'No existeix aquest usuari';
$string['onlyadmins'] = 'Això només poden fer-ho els administradors';
$string['onlyeditingteachers'] = 'Això només pot fer-ho el professorat que tingui permisos d\'edició';
$string['onlyeditown'] = 'Només podeu editar la vostra pròpia informació';
$string['orderidnotfound'] = 'No s\'ha trobat l\'ID d\'ordre {$a}';
$string['pagenotexist'] = 'S\'ha esdevingut un error poc comú (heu intentat anar a una pàgina que no existeix).';
$string['pathdoesnotstartslash'] = 'Heu donat uns argument no vàlids, el camí no pot començar amb una barra (/)';
$string['pleasereport'] = 'Si teniu temps, us agrairem que ens informeu de què estàveu fent quan s\'ha esdevingut aquest error:';
$string['pluginrequirementsnotmet'] = 'El connector "{$a->pluginname}" ({$a->pluginversion}) no s\'ha pogut instal·lar. Necessita una versió més nova de Moodle (esteu utilitzant la {$a->currentmoodle} i necessiteu la {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>S\'ha produït un error: el prefix de les taules de la base de dades no pot ser buit({$a})</p> <p>L\'administrador del lloc ha de solucionar aquest problema.</p>';
$string['prefixtoolong'] = '<p>S\'ha produït un error: el prefix de les taules de la base de dades és massa llarg ({$a->dbfamily})</p> <p>L\'administrador del lloc ha de solucionar aquest problema. La longitud màxima dels prefixos de les taules a {$a->dbfamily} és de {$a->maxlength} caràcters.</p>';
$string['processingstops'] = 'El processament acaba aquí. Els registres que resten s\'ignoraran.';
$string['protected_cc_not_supported'] = 'No hi ha suport per als cartutxos protegits.';
$string['querystringcannotbeempty'] = 'La cadena de consulta no pot estar buida.';
$string['redirecterrordetected'] = 'Ha finalitzat l\'execució de l\'script perquè s\'ha detectat un redireccionament sense suport.';
$string['refoundto'] = 'Poden reemborsar-se a {$a}';
$string['refoundtoorigi'] = 'S\'ha retornat a la quantitat original: {$a}';
$string['remotedownloaderror'] = 'No s\'ha pogut baixar el component al vostre servidor. Verifiqueu els paràmetres de servidor intermediari. Es recomana l\'extensió cURL.<br /><br />Haureu de baixar manualment el fitxer <a href="{$a->url}">{$a->url}</a>, copiar-lo a la ubicació "{$a->dest}" del vostre servidor i descomprimir-lo allí.';
$string['remotedownloadnotallowed'] = 'El vostre servidor no permet baixar components ((allow_url_fopen inhabilitat).<br /><br />Baixeu manualment el fitxer <a href="{$a->url}">{$a->url}</a>, copieu en la ubicació "{$a->dest}" del vostre servidor i descomprimiu-lo allí.';
$string['reportnotavailable'] = 'Aquest tipus d\'informe només es pot trobar al curs del lloc.';
$string['requirecorrectaccess'] = 'L\'URL o el port no són vàlids.';
$string['requireloginerror'] = 'No es pot accedir al curs o l\'activitat.';
$string['restorechecksumfailed'] = 'S\'ha produït un problema amb la informació de la restauració desada en la vostra sessió. Comproveu els límits de la mida de la memòria PHP/Base de dades. S\'ha aturat la restauració.';
$string['restore_path_element_missingmethod'] = 'No existeix el mètode de restauració {$a}. Cal que un desenvolupador el defineixi.';
$string['restore_path_element_noobject'] = 'L\'objecte de restauració {$a} no és un objecte.';
$string['restrictedcontextexception'] = 'L\'execució de funcions externes viola les restriccions del context';
$string['restricteduser'] = 'Al vostre compte "{$a}" no li és permès de fer això';
$string['reverseproxyabused'] = 'S\'habilitat el proxy invers,  no es pot accedir al servidor directament.<br />Contacteu amb l\'administrador del servidor.';
$string['rpcerror'] = 'S\'ha produït un error de comunicació MNET. Aquí teniu el missatge d\'error que podeu fer arribar al vostre administrador: {$a}';
$string['scheduledbackupsdisabled'] = 'Els administradors d\'aquest servidor han inhabilitat les còpies de seguretat programades.';
$string['secretalreadyused'] = 'Ja s\'ha utilitzat l\'enllaç de confirmació del canvi de contrasenya, per tant no s\'ha canviat la contrasenya.';
$string['sectionnotexist'] = 'Aquesta secció no existeix';
$string['sendmessage'] = 'Envia missatge';
$string['serverconnection'] = 'S\'ha produït un error de connexió amb el servidor';
$string['servicedonotexist'] = 'El servei no existeix';
$string['sessioncookiesdisable'] = 'L\'ús de require_key_login() és incorrecte - S\'han de desactivar les galetes de sessió.';
$string['sessiondiskfull'] = 'La partició de la sessió és plena. No és possible que us pugueu registrar ara mateix.<br /><br />Notifiqueu-ho a l\'administrador del servidor.';
$string['sessionerroruser'] = 'Heu excedit el termini de la vostra sessió o s\'ha produït un error. Si us plau torneu a entrar-hi.';
$string['sessionerroruser2'] = 'S\'ha detectat un error del servidor que afecta la vostra sessió. Heu d\'entrar de nou o reiniciar el vostre navegador.';
$string['sessionhandlerproblem'] = 'El gestor de sessions està mal configurat';
$string['sessionipnomatch'] = 'Sembla que el vostre número IP ha canviat des que heu entrat. Aquesta característica de seguretat impedeix que un <i>cracker</i> suplanti la vostra identitat després que heu entrat en Moodle. Els usuaris normals no haurien de veure aquest missatge: demaneu ajuda a l\'administrador del lloc.';
$string['sessionipnomatch2'] = 'Sembla que la vostra adreça IP  ha canviat des del moment en què us heu registrat per primer cop. Aquesta funció de seguretat impedeix el robatori de la vostra identitat mentre esteu connectats a aquest lloc. Podeu veure aquest error si utilitzeu xarxes sense fils o si esteu en <em>roaming</em> entre xarxes diferents. Pregunteu a l\'administrador del lloc per obtenir més ajuda. <br /> <br /> Si voleu continuar premeu la tecla F5 per refrescar aquesta pàgina.';
$string['sessionwaiterr'] = 'S\'ha excedit el temps mentre s\'esperava a tancar la sessió.<br />Espereu que acabi la sol·licitud en curs i torneu-ho a provar més tard.';
$string['shortnametaken'] = 'El nom curt ja està essent utilitzat per a un altre curs  ({$a})';
$string['socksnotsupported'] = 'L\'intermediari SOCKS5 no funciona en PHP4';
$string['spellcheckernotconf'] = 'No s\'ha habilitat la correcció ortogràfica';
$string['sslonlyaccess'] = 'Per raons de seguretat només estan permeses les connexions htpps';
$string['statscatchupmode'] = 'S\'estan recollint les estadístiques. Fins ara s\'han processat {$a->daysdone} dies i estan pendents {$a->dayspending}. Torneu a provar-ho d\'aquí a una estona.';
$string['statsdisable'] = 'No s\'han activat les estadístiques';
$string['statsnodata'] = 'No hi ha disponible cap dada sobre la combinació de curs i període de temps';
$string['storedfilecannotcreatefile'] = 'No es pot crear el conjunt de fitxers associats al fitxer local. Verifiqueu els permisos de dataroot i l\'espai disponible al disc.';
$string['storedfilecannotcreatefiledirs'] = 'No s\'han pogut crear els directoris locals del repositori de fitxers. Verifiqueu els permisos de datarrot.';
$string['storedfilecannotread'] = 'No es pot llegir el fitxer bé perquè no existeix, bé perquè hi ha problemes amb els permisos.';
$string['storedfilenotcreated'] = 'No s\'ha pogut crear el fitxer "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = 'Hi ha una excepció desconeguda en relació amb els fitxers locals ({$ a})';
$string['tagdisabled'] = 'S\'han desactivat les etiquetes';
$string['tagnotfound'] = 'L\'etiqueta especificada no s\'ha pogut trobar a la base de dades';
$string['targetdatabasenotempty'] = 'La base de dades de destí no està buida. S\'ha aturat la transferència per raons de seguretat.';
$string['textconditionsnotallowed'] = 'No estan permeses les comparacions de les condicions de la columna de text. Utilitzeu sql_compare_text() a la vostra consulta.';
$string['themenotinstall'] = 'Aquest tema no està instal·lat';
$string['TODO'] = 'Per fer';
$string['tokengenerationfailed'] = 'No s\'ha pogut generar un testimoni nou.';
$string['transactionvoid'] = 'La transacció no pot ser anul·lada pel fet que ja havia estat anul·lada.';
$string['unenrolerror'] = 'S\'ha produït un error mentre s\'estava donant de baixa aquesta persona.';
$string['unicodeupgradeerror'] = 'La vostra base de dades encara no és en Unicode i aquesta versió de Moodle no pot efectuar la migració a Unicode. Actualitzeu primer a Moodle 1.7 i feu la migració de la base de dades a Unicode mitjançant la pàgina d\'Administració. Després d\'això ja podreu actualitzar a Moodle {$a}.';
$string['unknowaction'] = 'Acció desconeguda';
$string['unknowcategory'] = 'Categoria desconeguda';
$string['unknowcontext'] = 'Aquest és un context desconegut ({$a}) a get_child_contexts';
$string['unknowformat'] = 'Format desconegut ({$a})';
$string['unknownbackupexporterror'] = 'S\'ha produït un error desconegut mentre es preparava la informació per la importació.';
$string['unknownblockregion'] = 'No es reconeix el bloc \'{$a}\' en aquesta pàgina.';
$string['unknowncontext'] = 'Aquest és un context desconegut.';
$string['unknowncourse'] = 'El curs "{$a}" és desconegut';
$string['unknowncourseidnumber'] = 'ID de curs "{$a}" desconegut';
$string['unknowncourserequest'] = 'Sol·licitud de curs desconeguda';
$string['unknowncoursesection'] = 'Secció de curs desconeguda en el curs "{$a}"';
$string['unknownevent'] = 'Esdeveniment desconegut';
$string['unknownfiletype'] = 'S\'ha produït un error desconegut en relació al tipus de filtre.';
$string['unknowngroup'] = 'Grup "{$a}" desconegut';
$string['unknownhelp'] = 'Tema d\'ajuda {$a} desconegut';
$string['unknownjsinrequirejs'] = 'No s\'ha pogut trobar la biblioteca JS: {$a}';
$string['unknownmodulename'] = 'Nom del mòdul desconegut pel formulari';
$string['unknownrole'] = 'Rol "{$a}" desconegut';
$string['unknownsortcolumn'] = 'Columna d\'ordenació {$a} desconeguda';
$string['unknownuseraction'] = 'Aquesta acció d\'usuari no és intel·ligible';
$string['unknownuserselector'] = 'Selector d\'usuari desconegut';
$string['unknoworder'] = 'Ordenació desconeguda';
$string['unknowparamtype'] = 'Tipus de paràmetre desconegut: {$a}';
$string['unknowquestiontype'] = 'Tipus de pregunta sense suport {$a}';
$string['unknowuploadaction'] = 'S\'ha produït un error: acció de càrrega ({$a}) desconeguda';
$string['unspecifycourseid'] = 'Heu d\'especificar un ID de curs, un nom curt o un idnumber';
$string['unsupportedevent'] = 'Tipus d\'esdeveniment sense suport.';
$string['unsupportedstate'] = 'Estat de compleció sense suport';
$string['unsupportedwebserver'] = 'El programari del servidor web ({$a}) no està suportat.';
$string['upgraderequires19'] = 'S\'ha produït un error:  al servidor hi ha instal·lada la nova versió de Moodle. Malauradament l\'actualització de la versió anterior no és compatible. <br />Cal que primer actualitzeu la versió des de la 1.9.x. També podeu tornar a la versió anterior reinstal·lant els fitxers originals.';
$string['upgraderunning'] = 'El lloc s\'està actualitzant. Proveu-ho més tard.';
$string['urlnotdefinerss'] = 'No s\'ha definit l\'URL d\'aquest RSS';
$string['useradmineditadmin'] = 'Només els administradors tenen permisos per modificar els comptes dels altres administradors.';
$string['useradminodelete'] = 'Els comptes dels administradors no es poden eliminar.';
$string['userautherror'] = 'Connector d\'autenticació desconegut';
$string['userauthunsupported'] = 'El connector d\'autenticació no funciona aquí';
$string['useremailduplicate'] = 'Adreça duplicada';
$string['usermustbemnet'] = 'Els usuaris de la llista de control d\'accés MNET han de ser usuaris remots';
$string['usernotaddederror'] = 'No s\'ha afegit l\'usuari. Error desconegut';
$string['usernotaddedregistered'] = 'No s\'ha afegit l\'usuari. Ja està registrat';
$string['usernotavailable'] = 'Els detalls d\'aquest usuari no estan disponibles per a vós.';
$string['usernotdeletedadmin'] = 'No s\'ha eliminat l\'usuari: no es poden eliminar els comptes dels administradors';
$string['usernotdeletederror'] = 'L\'usuari no s\'ha suprimit. S\'ha produït un error.';
$string['usernotdeletedmissing'] = 'L\'usuari no s\'ha suprimit. No s\'ha pogut trobat aquest nom d\'usuari.';
$string['usernotdeletedoff'] = 'L\'usuari no s\'ha suprimit. No es permet suprimir.';
$string['usernotincourse'] = 'Aquest usuari no és en aquest curs.';
$string['usernotrenamedadmin'] = 'No es pot canviar el nom dels comptes d\'administració.';
$string['usernotrenamedexists'] = 'No s\'ha canviat el nom de l\'usuari. El nom nou ja és utilitzat per un altre usuari.';
$string['usernotrenamedmissing'] = 'No s\'ha canviat el nom de l\'usuari. No s\'ha pogut trobar el nom vell.';
$string['usernotrenamedoff'] = 'No s\'ha canviat el nom d\'usuari. No es permet canviar els noms.';
$string['usernotupdatedadmin'] = 'No es pot actualitzar els comptes d\'administració.';
$string['usernotupdatederror'] = 'L\'usuari no s\'ha actualitzat. S\'ha produït un error.';
$string['usernotupdatednotexists'] = 'L\'usuari no s\'ha actualitzat perquè no existeix.';
$string['userquotalimit'] = 'Heu arribat al límit de la vostra quota de fitxers.';
$string['userselectortoomany'] = 'user-selector té més d\'un usuari seleccionat, tot i que multiselect és fals.';
$string['wrongcall'] = 'S\'ha cridat erròniament a aquest script';
$string['wrongcontextid'] = 'l\'ID del context no és correcte (no s\'ha trobat)';
$string['wrongdestpath'] = 'El camí de destinació és erroni';
$string['wrongroleid'] = 'L\'ID del rol no és correcte';
$string['wrongsourcebase'] = 'L\'adreça (URL) base de la font és errònia';
$string['wrongusernamepassword'] = 'Usuari o contrasenya erronis';
$string['wrongzipfilename'] = 'El nom del fitxer ZIP és erroni';
$string['wscouldnotcreateecoursenopermission'] = 'No s\'ha pogut crear el curs per manca de permisos.';
$string['wwwrootmismatch'] = 'S\'ha detectat un accés incorrecte. Només es pot accedir a aquest servidor a través de l\'adreça "{$a}"<br />Notifiqueu-ho a l\'administrador del servidor.';
$string['wwwrootslash'] = 'S\'ha detectat una incorrecció a  $CFG->wwwroot de config.php, no ha de contenir cap barra final. <br />Notifiqueu-ho a l\'administrador del servidor.';
$string['xmldberror'] = 'S\'ha produït un error XMLDB';
$string['youcannotdeletecategory'] = 'No podeu suprimir la categoria \'{$a}\' perquè no se\'n poden suprimir els continguts o moure\'ls a una altra ubicació.';
