<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Du kan forhåndsvise denne quizen, men hvis det er gjort reelle forsøk vil du blokkeres, fordi:';
$string['action'] = 'Handling';
$string['activityoverview'] = 'Du har quizer som kan tas nå';
$string['adaptive'] = 'Tilpasningsmodus';
$string['adaptive_help'] = 'Dersom aktivert vil det tillates flere svar på et spørsmål i samme quiz-forsøket. Hvis f.eks. et svar er merket som feil kan studenten prøve igjen med en gang. Likevel - avhengig av straffepoenginnstillingene - vil hvert nye forsøk resultere i poengtrekk.';
$string['addaquestion'] = 'Legg til et spørsmål...';
$string['addarandomquestion'] = 'Legg til et tilfeldig spørsmål...';
$string['addarandomquestion_help'] = 'Når det legges til et tilfeldig spørsmål betyr det at det trekkes et tilfeldig spørsmål fra angitt kategori. Det medfører at forskjellige studenter får forskjellige quizer og gjentatte forsøk gir også ny quiz hver gang.';
$string['adddescriptionlabel'] = 'Legg til beskrivelse';
$string['addingquestion'] = 'Legger til et spørsmål';
$string['addingquestions'] = '<p>Dette er siden der du håndterer databasen med spørsmål. Spørsmålene lagres i kategorier for å hjelpe deg å holde orden på dem, og de kan brukes i alle quizeri kurset og evt. også i andre kurs hvis du velger å \'publisere\' dem. </p>
<p>Etter at du har valgt eller laget en spørsmålskategori vil du få muligheten til å lage eller redigere spørsmål. Du kan velge disse spørsmålene og legge dem til quizen din på den andre siden av skjermbildet.</p>';
$string['addmoreoverallfeedbacks'] = 'Legg til {no} ekstra tilbakemeldingsfelt';
$string['addnewgroupoverride'] = 'Legg til gruppebasert overstyring';
$string['addnewpagesafterselected'] = 'Legg til nye sider etter valgte spørsmål';
$string['addnewquestionsqbank'] = 'Legg til spørsmål til kategorien {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Legg til brukerbasert overstyring';
$string['addpagehere'] = 'Legg til side her';
$string['addquestion'] = 'Legg til spørsmål';
$string['addquestions'] = 'Legg inn spørsmål';
$string['addquestionstoquiz'] = 'Legg spørsmål til gjeldende quiz';
$string['addrandom'] = 'Legg til {$a} tilfeldige spørsmål';
$string['addrandom1'] = '<<Legg til';
$string['addrandom2'] = 'Tilfeldige spørsmål';
$string['addrandomfromcategory'] = 'Legg til tilfeldig spørsmål fra kategori:';
$string['addrandomquestion'] = 'Legg til tilfeldig spørsmål';
$string['addrandomquestiontoquiz'] = 'Legg til tilfeldig spørsmål til quizen {$a}';
$string['addselectedtoquiz'] = 'Legg valgte til quizen';
$string['addtoquiz'] = 'Legg til';
$string['affectedstudents'] = 'Berørte {$a}';
$string['aftereachquestion'] = 'Etter å ha lagt til hvert spørsmål';
$string['afternquestions'] = 'Etter å ha lagt til {$a} spørsmål';
$string['age'] = 'alder';
$string['allattempts'] = 'Alle forsøk';
$string['allinone'] = 'Ubegrenset';
$string['allowreview'] = 'Tillat sammendrag';
$string['alreadysubmitted'] = 'Du har sannsynligvis svart allerede';
$string['alternativeunits'] = 'Alternative enheter';
$string['alwaysavailable'] = 'Alltid tilgjengelig';
$string['analysisoptions'] = 'Analysemuligheter';
$string['analysistitle'] = 'Tabell for elementanalyse';
$string['answer'] = 'Svar';
$string['answered'] = 'Besvart';
$string['answerhowmany'] = 'Ett eller flere svar?';
$string['answers'] = 'Vis fasit';
$string['answersingleno'] = 'Flere svar tillatt';
$string['answersingleyes'] = 'Kun ett svar';
$string['answertoolong'] = 'Svaret er for langt etter linje {$a} (Maks 255 tegn)';
$string['aon'] = 'AOM-format';
$string['areyousureremoveselected'] = 'Er du sikker på at du vil fjerne alle valgte spørsmål?';
$string['asshownoneditscreen'] = 'Som vist på redigeringsskjermbildet';
$string['attempt'] = 'Forsøk {$a}';
$string['attemptalreadyclosed'] = 'Dette forsøket er allerede avsluttet';
$string['attemptclosed'] = 'Forsøket er ikke avsluttet ennå';
$string['attemptduration'] = 'Brukt tid';
$string['attemptedon'] = 'Forsøkt den';
$string['attempterror'] = 'Du har ikke lov til å forsøke på denne quizen nå fordi: {$a}';
$string['attemptfirst'] = 'Første forsøk';
$string['attemptincomplete'] = 'Forsøket (av {$a}) er ennå ikke fullført.';
$string['attemptlast'] = 'Siste forsøk';
$string['attemptnumber'] = 'Forsøk';
$string['attemptquiznow'] = 'Ta quizen nå';
$string['attempts'] = 'Forsøk';
$string['attemptsallowed'] = 'Forsøk tillatt';
$string['attemptsdeleted'] = 'Testforsøk slettet';
$string['attemptselection'] = 'Velg hvilke brukerforsøk du vil analysere';
$string['attemptsexist'] = 'Noen har allerede tatt denne quizen <br/> Du kan ikke lenger legge til eller fjerne spørsmål.';
$string['attemptsnum'] = 'Forsøk: {$a}';
$string['attemptsnumthisgroup'] = 'Forsøk:{$a->total} ({$a->group} fra denne gruppen)';
$string['attemptsnumyourgroups'] = 'Forsøk: {$a->total} ({$a->group} fra denne gruppen)';
$string['attemptsonly'] = 'Vis bare studenter som har prøvd';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Forsøket pågår fremdeles';
$string['attemptsunlimited'] = 'Ubegrensede forsøk';
$string['autosaveperiod'] = 'Periode for auto-save';
$string['autosaveperiod_desc'] = 'Studenters svar kan lagres automatisk med minutters intervaller under quizforsøk. Dette innbærer en avveining: Å lagre svarene medfører at serverbelastningen øker, men reduserer sjansen for at studentene mister arbeidet sitt.';
$string['back'] = 'Tilbake til forhåndsvisning av spørsmålet';
$string['backtocourse'] = 'Tilbake til kurset';
$string['backtoquestionlist'] = 'Tilbake til spørsmålslista';
$string['backtoquiz'] = 'Tilbake til quiz-redigereing';
$string['basicideasofquiz'] = 'Den grunnleggende ideen bak å lage Quiz';
$string['bestgrade'] = 'Beste karakter/poeng';
$string['bothattempts'] = 'Vis studenter med og uten forsøk';
$string['browsersecurity'] = 'Nettlesersikkerhet';
$string['browsersecurity_help'] = 'Dersom du har valgt "Fulll skjerm popup-vindu med noe javascript-sikkerhet";

* Quizen vil kun tas av studenter med aktivert Javascript i nettleseren.
* Quizen vil kun åpnes i et fullskjerms popup-vindu som ligger over alle andre vinduer og har ingen navigsjonselementer.
* Studenter blir forhindret, så langt det går, å bruke funksjoner som klipp og lim.';
$string['calculated'] = 'Beregnet';
$string['calculatedquestion'] = 'Beregnet spørsmål er ikke støttet på linje {$a}. Spørsmålet vil bli ignorert';
$string['cannotcreatepath'] = 'Stien kan ikke opprettes ({$a})';
$string['cannoteditafterattempts'] = 'Du kan ikke legge til eller fjerne spørsmål når noen har lagrede forsøk på testen. ({$a})';
$string['cannotfindprevattempt'] = 'Kan ikke finne tidligere forsøk å bygge på.';
$string['cannotfindquestionregard'] = 'Mislykkes i å hente spørsmål for revurdering!';
$string['cannotinsert'] = 'Kan ikke sette inn spørsmål';
$string['cannotinsertrandomquestion'] = 'Kunne ikke sette inn et tilfeldig spørsmål!';
$string['cannotloadquestion'] = 'Kunne ikke laste spørsmålsinnstillingene';
$string['cannotloadtypeinfo'] = 'Kunne ikke laste spørsmålstype-spesifikk spørsmålsinformasjon';
$string['cannotopen'] = 'Kan ikke åpne eksportert fil ({$a})';
$string['cannotrestore'] = 'Kunne ikke gjenopprette spørsmålssesjoner';
$string['cannotreviewopen'] = 'Du kan ikke se på dette forsøket - det er fortsatt åpent!';
$string['cannotsavelayout'] = 'Kunne ikke lagre layout';
$string['cannotsavenumberofquestion'] = 'Kunne ikke lagre antall spørsmål pr. side';
$string['cannotsavequestion'] = 'Kunne ikke lagre spørsmålslisten';
$string['cannotsetgrade'] = 'Kunne ikke angi ny maksimumskarakter for quizen';
$string['cannotsetsumgrades'] = 'Mislykkes i å angi sum karakter';
$string['cannotstartgradesmismatch'] = 'Kan ikke starte noe forsøk på denne quizen. Quizen er satt til å vurderes basert på  {$a->grade}, men ingen av spørsmålene i quizen har noen poengsum angitt. Dette kan fikses på "Endre quiz"-siden.';
$string['cannotstartmissingquestion'] = 'Kan ikke starte noe forsøk på denne quizen. Quiz-oppsettet har med et spørsmål som ikke lenger eksisterer.';
$string['cannotstartnoquestions'] = 'Kan ikke starte noe forsøk på denne quizen. Quizen er ikke ferdig satt opp ennå. Det er ikke lagt til noen spørsmål.';
$string['cannotwrite'] = 'Kan ikke skrive til eksportert fil ({$a})';
$string['caseno'] = 'Nei, store/små bokstaver må ikke stemme';
$string['casesensitive'] = 'Store/små bokstaver må stemme';
$string['caseyes'] = 'Ja, bokstaver/tegn må stemme';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categoryadded'] = 'Kategorien {$a} ble lagt til';
$string['categorydeleted'] = 'Kategorien {$a} ble slettet';
$string['categorynoedit'] = 'Du har ikke rettigheter til å redigere spørsmål i kategorien \'{$a}\'';
$string['categoryupdated'] = 'Oppdateringen av denne kaegorien var vellykket';
$string['close'] = 'Lukk forhåndsvsining';
$string['closebeforeopen'] = 'Kunne ikke fullføre oppdateringen. Du har valgt en frist for fullføring som er FØR åpningsdatoen.';
$string['closed'] = 'Stengt';
$string['closepreview'] = 'Lukk forhåndsvisning';
$string['closereview'] = 'Lukk sammendrag';
$string['comment'] = 'Kommentar';
$string['commentorgrade'] = 'Skriv en kommentar eller overstyr karakteren';
$string['comments'] = 'Kommentarer';
$string['completedon'] = 'Fullført den';
$string['configadaptive'] = 'Dersom du velger JA her vil studenten kunne svare flere ganger på et spørsmål innen samme forsøk på quizen.';
$string['configattemptsallowed'] = 'Begrensninger på antall forsøk på quizen.';
$string['configdecimaldigits'] = 'Antall desimaler som skal vises i karakteren.';
$string['configdecimalplaces'] = 'Antall desimaler som skal vises i sluttkarakteren for quizen.';
$string['configdecimalplacesquestion'] = 'Antall desimaler som skal vises i karakteren for hvert spørsmål.';
$string['configdelay1'] = 'Dersom du  angir en tidsutsettelse, må studenten vente den tiden før de kan prøve igjen etter det første forsøket.';
$string['configdelay1st2nd'] = 'Dersom du  angir en tidsutsettelse, må studenten vente den tiden før de kan prøve igjen etter det første forsøket.';
$string['configdelay2'] = 'Dersom du  angir en tidsutsettelse, må studenten vente den tiden før de kan prøve igjen - etter det andre forsøket.';
$string['configdelaylater'] = 'Dersom du  angir en tidsutsettelse, må studenten vente den tiden før de kan prøve igjen etter andre forsøket.';
$string['configeachattemptbuildsonthelast'] = 'Dersom mange forsøk er tillatt vil vært nye forsøk være basert på det foregående forsøket.';
$string['configgrademethod'] = 'Dersom mange forsøk er tillatt, hvilken metode skal brukes for å beregne studentens endelige karakter for quizen.';
$string['configintro'] = 'Verdiene du setter her bestemmer standardverdiene som brukes når du lager en ny quiz. Du kan også bestemme hvilke quiz-innstillinger som skal regnes som avanserte.';
$string['configmaximumgrade'] = 'Standard karakter som quizen skal skaleres ut i fra.';
$string['confignavmethod'] = 'I fri navigasjonsmodus kan spørsmålene besvares i frivillig rekkefølge ved å bruke spørsmålsnavigasjonen. I sekvensiell modus må spørsmålene besvares i den rekkefølgen som er angitt.';
$string['confignewpageevery'] = 'Når du legger til spørsmål vil sideskiftene automatisk justeres etter de innstillingene du angir her.';
$string['configoutcomesadvanced'] = 'Dersom dette valget er aktivert, vil Læringsutbytte vises som en avansert innstilling i Quiz.';
$string['configpenaltyscheme'] = 'Straffepoeng som trekkes fra hvert gale svar (i tilpasningsmodus)';
$string['configpopup'] = 'Tvinger forsøket til å åpnes i et eget vindu og bruker Javascript for å forhindre klipp og lim osv. når quizen tas.';
$string['configrequirepassword'] = 'Studenten må skrive inn et passord før de kan åpne quizen.';
$string['configrequiresubnet'] = 'Studenter kan bare ta quizen fra disse pc-ene.';
$string['configreviewoptions'] = 'Disse valgene styrer hvilken informasjon brukere kan se når de ser over quizforsøket eller kikker på quizrapporter.';
$string['configshowblocks'] = 'Vis blokker samtidig med quizen.';
$string['configshowuserpicture'] = 'Vis brukerens profilbilde på skjermen under forsøket.';
$string['configshufflequestions'] = 'Dersom du aktiverer dette valget, vil spørsmålsrekkefølgen endres tilfeldig hver gang studenten tar quizen.';
$string['configshufflewithin'] = 'Dersom du aktiverer dette valget vil svaralternativene vises tilfeldig hver gang quizen tas.';
$string['configtimelimit'] = 'Standard tidsbegrensning for quizer (i minutter). 0 betyr ingen tidsbegrensning';
$string['configtimelimitsec'] = 'Standard tidsbegrensning for quizer (i sekunder). = betyr ingen tidsbegrensning.';
$string['configurerandomquestion'] = 'Endre spørsmål';
$string['confirmclose'] = 'Etter at du har sendt inn besvarelsen kan du ikke lenger forandre svarene dine for dette forsøket.';
$string['confirmserverdelete'] = 'Er du sikker på at du vil fjerne tjeneren <b>{$a}</b> fra listen?';
$string['confirmstartattemptlimit'] = 'Denne quizen er begrenset til {$a} forsøk. Du holder på å starte ett nytt forsøk. Ønsker du å fortsette?';
$string['confirmstartattempttimelimit'] = 'Denne quizen har en tidsbegrensning og er begrenset til {$a} forsøk. Du holder på å starte et nytt forsøk. Ønsker du å fortsette?';
$string['confirmstarttimelimit'] = 'Denne quizen har en tidsbegrensning. Er du sikker på at du vil starte?';
$string['connectionerror'] = 'Nettverksforbindelsen er brutt. (Autolagring mislykkes).
Ta et notat på kommentarene du la inn på denne siden de siste minuttene og prøv igjen.

Straks forbindelsen er gjenopprettet, bør kommentarene dine bli lagret og da forsvinner denne meldingen.';
$string['connectionok'] = 'Nettverksforbindelsen er gjenopprettet. Du kan nå fortsette.';
$string['containercategorycreated'] = 'Denne kategorien ble laget for å ta vare på de kategoriene som har blitt flyttet til øverste nivå(nettsted)på grunn av følgende årsaker:';
$string['continueattemptquiz'] = 'Fortsett med forrige forsøk';
$string['continuepreview'] = 'Fortsett siste forhåndsvisning';
$string['copyingfrom'] = 'Lager en kopi av spørsmål \'{$a}\'';
$string['copyingquestion'] = 'Kopierer et spørsmål';
$string['correct'] = 'Riktig';
$string['correctanswer'] = 'Riktig svar';
$string['correctanswerformula'] = 'Korrekt svarformel';
$string['correctansweris'] = 'Korrekt svar: {$a}';
$string['correctanswerlength'] = 'Viktige tall';
$string['correctanswers'] = 'Riktige svar';
$string['correctanswershows'] = 'Riktig svar viser';
$string['corrresp'] = 'Korrekt respons';
$string['countdown'] = 'Nedtelling';
$string['countdownfinished'] = 'Quizen avsluttes, du bør sende svarene dine straks.';
$string['countdowntenminutes'] = 'Denne quizen avsluttes om ti minutter.';
$string['coursetestmanager'] = 'Format for administrering av kurstester';
$string['createcategoryandaddrandomquestion'] = 'Opprett kategori og legg til tilfeldig spørsmål';
$string['createfirst'] = 'Du må lage noen kort-svar-spørsmål først.';
$string['createmultiple'] = 'Lag mange spørsmål';
$string['createnewquestion'] = 'Lag nytt spørsmål';
$string['createquestionandadd'] = 'Opprett et nytt spørsmål og legg det til i quizen.';
$string['custom'] = 'Eget format';
$string['dataitemneed'] = 'Må må legge til minst ett sett dataelement for å få et gyldig spørsmål';
$string['datasetdefinitions'] = 'Gjenbrukbare definisjoner for datasett for kategori {$a}';
$string['datasetnumber'] = 'Nummer';
$string['daysavailable'] = 'Dager tilgjengelig';
$string['decimaldigits'] = 'Desimaltall i karakterer';
$string['decimalplaces'] = 'Antall desimaler i karakterer';
$string['decimalplaces_help'] = 'Denne innstillingen bestemmer antall desimaler som skal være med i visningen av karakterer. Den har kun betydning for visningen av karakterer, og ikke for karakterene som lagres i databasen eller interne beregninger, som er nøyaktig utført.';
$string['decimalplacesquestion'] = 'Antall desimaler i spørsmålskarakteren';
$string['decimalplacesquestion_help'] = 'Denne innstillingen angir antall desimaler som skal vises i karakteren på hvert individuelle spørsmål.';
$string['decimalpoints'] = 'Desimaltegn';
$string['default'] = 'Standard';
$string['defaultgrade'] = 'Standard karaktersetting';
$string['defaultinfo'] = 'Standard kategori med spørsmål.';
$string['delay1'] = 'Pause mellom første og andre forsøk';
$string['delay1st2nd'] = 'Tving ventetid mellom første og andre forsøk';
$string['delay1st2nd_help'] = '<p>Hvis du angir en tidsforsinkelse, må studenten vente i angitt tid før de kan prøve en gang til på quizen.</p>';
$string['delay2'] = 'Pause mellom senere forsøk';
$string['delaylater'] = 'Tving ventetid mellom hvert senere forsøk';
$string['delaylater_help'] = '<p>Dersom du angir en tidsforsinkelse her, vil studenten måtte vente angitt tid mellom hvert senere forsøk (etter det andre forsøket).</p>';
$string['deleteattemptcheck'] = 'Er du helt sikker på at du vil slette disse forsøkene fullstendig?';
$string['deleteselected'] = 'Slett valgte';
$string['deletingquestionattempts'] = 'Sletter forsøk';
$string['description'] = 'Informasjonsfelt';
$string['disabled'] = 'Deaktivert';
$string['displayoptions'] = 'Vis valgmuligheter';
$string['donotuseautosave'] = 'Ikke bruk auto-lagring';
$string['download'] = 'Klikk for å laste ned den eksporterte kategorifila';
$string['downloadextra'] = '(Filen blir også lagret i kursfiler i mappen /backupdata/quiz)';
$string['duplicateresponse'] = 'Denne innleveringa blir ignorert. Du har gitt et lignende svar tidligere.';
$string['eachattemptbuildsonthelast'] = 'Hvert forsøk bygger på det forrige';
$string['eachattemptbuildsonthelast_help'] = '<p>Hvis det tillates flere forsøk og dette valget settes til \'Ja\' vil hvert
forsøk inneholde resultatene fra det tidligere forsøket. Dette gjør det mulig å
fullføre quizen med et visst antall forsøk. </p>
<p>For å vise en ny (blank) quiz for hvert forsøk velger du \'Nei\' her. </p>';
$string['editcategories'] = 'Rediger kategorier';
$string['editcategory'] = 'Rediger kategori';
$string['editcatquestions'] = 'Rediger kategorispørsmål';
$string['editingquestion'] = 'Redigerer et spørsmål';
$string['editingquiz'] = 'Rediger quiz';
$string['editingquiz_help'] = 'Når en quiz opprettes er hovedkonseptet:

* Quizen, som inneholder spørsmål over en eller flere sider.
* Testbanken, som har kopier av alle spørsmål organisert i kategorier.
* Tilfeldige spørsmål - en student får da forskjellige spørsmål hver gang de tar quizen og forskjellige studenter får ulike spørsmål.';
$string['editingquizx'] = 'Endrer quiz: {$a}';
$string['editoverride'] = 'Overstyr endring';
$string['editqcats'] = 'Rediger spørsmålskategorier';
$string['editquestions'] = 'Rediger spørsmål';
$string['editquiz'] = 'Endre quiz';
$string['editquizquestions'] = 'Endre quizspørsmål';
$string['emailconfirmbody'] = 'Hei {$a->username},

Takk for at du sendte inn svarene på \'{$a->quizname}\'
i kurset \'{$a->coursename}\' {$a->submissiontime}.

Denne e-posten bekrefter at vi har mottatt svarene dine.

Du kan åpne denne quizen på {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Takk for at du sendte inn dine svar på  \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Bekreftelse på innsending av quiz:  {$a->quizname}';
$string['emailnotifybody'] = 'Hei {$a->username},

{$a->studentname} har fullført quizen
\'{$a->quizname}\' ({$a->quizurl})
i kurset \'{$a->coursename}\'

Du kan se på forsøket her: {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} har fullført {$a->quizname}. Se {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} har fullført {$a->quizname}';
$string['emailoverduebody'] = 'Hei {$a->studentname},

Du påbegynte et forsøk på \'{$a->quizname}\' i kurset \'{$a->coursename}\', men du sendte ikke inn besvarelsen. Det skulle ha vært sendt inn innen {$a->attemptduedate}.

Hvis du fortsatt vil sende inn denne besvarelsen, vennligst gå til {$a->attemptsummaryurl} og klikk på sendknappen. Du må gjøre dette før {$a->attemptgraceend}, ellers vil ikke besvarelsen din telle.';
$string['emailoverduesmall'] = 'Du har ikke sendt inn besvarelsen din til {$a->quizname}. Vennligst gå til {$a->attemptsummaryurl} før {$a->attemptgraceend} hvis du fortsatt vil sende inn besvarelsen.';
$string['emailoverduesubject'] = 'Tiden er utløpt for: {$a->quizname}';
$string['empty'] = 'Tom';
$string['enabled'] = 'Aktivert';
$string['endtest'] = 'Avslutter forsøket...';
$string['erroraccessingreport'] = 'Du har ikke tilgang til denne rappoorten';
$string['errorinquestion'] = 'Feil i spørsmålet';
$string['errormissingquestion'] = 'Feil: Systemet mangler spørsmålet med id {$a}';
$string['errornotnumbers'] = 'Feil - svarene må bestå av tall';
$string['errorunexpectedevent'] = 'Uventet eventcode {$a->event} funnet for spørsmålet {$a->questionid} i forsøket {$a->attemptid}.';
$string['essay'] = 'Essay';
$string['essayquestions'] = 'Spørsmål';
$string['eventquizattemptabandoned'] = 'Quizforsøk avbrutt';
$string['eventquizattemptstarted'] = 'Quizforsøk startet';
$string['eventquizattemptsubmitted'] = 'Quizforsøk sendt';
$string['eventquizattempttimelimitexceeded'] = 'Tidsgrensen for quizen er overskredet';
$string['everynquestions'] = 'Hvert {$a}. spørsmål';
$string['everyquestion'] = 'Hvert spørsmål';
$string['everythingon'] = 'Alt på';
$string['export'] = 'Eksport';
$string['exportcategory'] = 'eksportkategori';
$string['exporterror'] = 'En feil oppsto under eksportprosessen';
$string['exportingquestions'] = 'Spørsmål eksporteres til fil';
$string['exportname'] = 'Filnavn';
$string['exportquestions'] = 'Eksporter spørsmål til fil';
$string['extraattemptrestrictions'] = 'Ekstra restriksjoner på forsøkene';
$string['false'] = 'Feil';
$string['feedback'] = 'Tilbakesvar';
$string['feedbackerrorboundaryformat'] = 'Tilbakemeldingsgrenser må settes til enten prosent eller et tall. Grenseverdien {$a}, som du skrev inn, gjenkjennes ikke som gyldig verdi.';
$string['feedbackerrorboundaryoutofrange'] = 'Tilbakemeldingsgrenser må være mellom 0% og 100%. Grenseverdien {$a}, som du skrev inn, er ikke innenfor gyldig område.';
$string['feedbackerrorjunkinboundary'] = 'Du må fylle ut grenseverdiene uten gap.';
$string['feedbackerrorjunkinfeedback'] = 'Du må fylle ut tilbakemeldingsboksene uten gap.';
$string['feedbackerrororder'] = 'Grenseverdier for tilbakemelding må være ordnet med høyeste verdi først. Grenseverdien {$a}, som du skrev inn, er ikke en del av ordnet rekkefølge.';
$string['file'] = 'Fil';
$string['fileformat'] = 'Filformat';
$string['fillcorrect'] = 'Sett inn riktig ord/frase';
$string['filloutnumericalanswer'] = 'Du må legge inn minst ett mulig svar og en feilmargin. Første gyldige svar vil bli brukt til å bestemme karakter og tilbakemelding. Hvis du legger inn tilbakemelding uten svar, vil dette vises til studenter som svarer noe annet enn dine svaralternativer.';
$string['filloutoneanswer'] = 'Du må skrive minst ett riktig svar. Svarfelter som er blanke vil ikke bli brukt. \'*\' kan brukes som jokertegn for å gi treff på alle bokstaver. Første samsvarende svaralternativ blir brukt til å beregne skåring og tilbakemelding,';
$string['filloutthreequestions'] = 'Du må fylle ut minst 3 spørsmål med samsvarende svaralternativer. Du kan legge til ekstra svaralternativer for feil svar ved å la spørsmålsfeltet stå tomt. Er både spørsmåls- og svarfeltet tomt blir de ikke med i spørsmålet.';
$string['fillouttwochoices'] = 'Du må gi minst to valg. Felter som er blanke vil ikke bli brukt.';
$string['finishattemptdots'] = 'Avslutt forsøket...';
$string['finishreview'] = 'Avslutt gjennomgang';
$string['forceregeneration'] = 'tving regenerering';
$string['formatnotfound'] = 'Import/exportformat {$a} fantes ikke';
$string['formatnotimplemented'] = 'Dette formatet er ikke korrekt implementert, vennligst meld dette som en bug';
$string['formulaerror'] = 'Formelfeil!';
$string['fractionsaddwrong'] = 'Karakterene du har satt går ikke opp 100%
<br />De går opp til {$a}%
<br />Vil du gå tilbake og endre dette?';
$string['fractionsnomax'] = 'Et av svarene burde være 100%, slik at det er
<br />mulig å få høyeste karakter.
<br />Vil du gå tilbake og endre dette?';
$string['fromfile'] = 'fra filen:';
$string['functiondisabledbysecuremode'] = 'Den funksjonen er for tiden deaktivert';
$string['generalfeedback'] = 'Generell tilbakemelding';
$string['generalfeedback_help'] = '<p>Feltet "Generell tilbakemelding" i spørsmål er en tekst som skal vises straks studenten har forsøkt seg på spørsmålet. Til forskjell fra vanlig tilbakemelding, som avhenger av spørsmålstypen og svaralternativet som ble valgt, vil "Generell tilbakemelding" vise samme melding til alle studenter.</p>

<p>Du kan styre hvordan generell tilbakemelding skal vises for studentene ved å merke av boksen for "Studentene kan se over" på spørsmålets redigeringsside.</p>

<p>Du kan bruke generell tilbakemelding til å gi studenene noe bakgrunnsinformasjon om kunnskapsområdet de blir testet på - eller til å gi dem lenker til mer informasjon de kan sette seg inn i dersom de ikke forstår spørsmålene.</p>';
$string['graceperiod'] = 'Utsettelsesperiode for innsending';
$string['graceperiod_desc'] = 'Hvis hva som skal skje når tiden går ut er satt til "Tillat en utsettelsesperiode til å sende inn, men ikke til å endre svar", er dette standard ekstra tid som gis, i sekunder.';
$string['graceperiod_help'] = 'Hvis hva som skal skje når tiden går ut er satt til "Tillat en utsettelsesperiode til å sende inn, men ikke til å endre svar", er dette hvor mye ekstra tid som skal gis.';
$string['graceperiodmin'] = 'Siste utsettelsesperiode for innsending';
$string['graceperiodmin_desc'] = 'Det er et potensielt problem helt på slutten av quizen. På den ene siden er det ønskelig å la studentene jobbe med quizen helt til siste sekund - ved hjelp av tidtakeren som sender inn besvarelsen automatisk når tiden går ut. På den andre siden så kan det hende at serveren da blir overbelastet, og bruker en del tid på å behandle bevarelsene. På grunn av dette vil vi ta imot besvarelser fram til det angitte antallet sekunder etter tiden går ut, så studentene ikke blir straffet for at serveren er treg. Studenten kan imidlertid jukse og bruke disse sekundene på å svare på quizen. Du må derfor foreta en avveining ut ifra om du stoler på at serveren din kan tåle belastningen quizen medfører.';
$string['graceperiodtoosmall'] = 'Utsettelsesperioden må være lenger enn {$a}.';
$string['grade'] = 'Karakter';
$string['gradeall'] = 'Vurder alt';
$string['gradeaverage'] = 'Gjennomsnittlig karakter';
$string['gradeboundary'] = 'Vurderingsgrense';
$string['gradeessays'] = 'Vurder fritekstene';
$string['gradehighest'] = 'Høyeste karakter';
$string['grademethod'] = 'Karaktermetode';
$string['grademethod_help'] = '<p>
Når quizen tillater flere forsøk fins det ulike måter å beregne de endelige
karakterene.
</p>
<p><b>Høyeste karakter</b></p>
<ul>
<li>
Tellende karakter er det beste av samtlige forsøk.
</li>
</ul>

<p><b>Gjennomsnittelig karakter</b><p>
<ul>
<li>
Tellende karakter er gjennomsnittet av alle forsøkene.
</li>
</ul>

<p><b>Første forsøk</b><p>
<ul>
<li>Tellende karakter er lik karakteren studentene/elevene får på det <b>første
</b>forsøket. (De andre regnes ikke med). </li>
</ul>

<p><b>Siste forsøk</b><p>
<ul>
<li>Tellende karakter er lik karakteren studentene/elevene får på det <b>siste</b>
forsøket. (De andre regnes ikke med). </li>
</ul>';
$string['gradesdeleted'] = 'Testresultatene er slettet';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Karakter for denne innleveringa: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Med tidligere straffepoeng blir dette <strong>{$a->cur}/{$a->max}</strong>';
$string['gradingdetailspenalty'] = 'Denne innleveringa hadde {$a} straffepoeng.';
$string['gradingdetailszeropenalty'] = 'Denne innleveringa hadde ingen straffepoeng';
$string['gradingmethod'] = 'Karaktermetode: {$a}';
$string['groupoverrides'] = 'Overstyringer for gruppe';
$string['groupsnone'] = 'Det er ingen grupper i dette kurset';
$string['guestsno'] = 'Beklager, gjester kan ikke se eller ta quizer.';
$string['hidebreaks'] = 'Skjul sideskift';
$string['hidereordertool'] = 'Skjul organiseringsverktøyet';
$string['history'] = 'Responshistorikk:';
$string['howquestionsbehave_desc'] = 'Standard innstilling for hvordan spørsmål oppfører seg i en quiz.';
$string['imagedisplay'] = 'Bilde som skal vises';
$string['import'] = 'Import';
$string['importcategory'] = 'importkategori';
$string['importerror'] = 'Det oppstod en feil under importen';
$string['importfilearea'] = 'Importer fra en fil som allerede er lastet opp...';
$string['importfileupload'] = 'Importer ved å laste opp en fil...';
$string['importfromthisfile'] = 'Importer fra denne filen';
$string['import_help'] = 'Denne funksjonen lar deg importere spørsmål fra en tekstfil.

Dersom filen inneholder tegn utover ASCII-tegnsettet må det støtte UTF-8 kodesettet. Vær spesielt oppmerksom på tekstfiler fra Microsoft Office programmene siden de svært ofte bruker helt egne tegnsett som da ikke importeres korrekt.

Import- og eksportformatene er moduler som kan kobles til. Andre valgfrie formater kan være tilgjengelig på moodle.org sin portal.';
$string['importingquestions'] = 'Importerer {$a} spørsmål fra filen';
$string['importmax10error'] = 'Det er en feil i spørsmålet. Du kan ikke ha mer enn ti svar.';
$string['importmaxerror'] = 'Det er en fei i spørsmålet. Det er for mange svar.';
$string['importquestions'] = 'Importer spørsmål fra fil';
$string['inactiveoverridehelp'] = '* Studenten har ikke korrekt gruppe eller rolletildeling for å ta quizen.';
$string['incorrect'] = 'Feil';
$string['indivresp'] = 'De Individuelle svarene på hvert spørsmål';
$string['info'] = 'Informasjon';
$string['infoshort'] = 'i';
$string['inprogress'] = 'Pågår';
$string['introduction'] = 'Beskrivelse';
$string['invalidattemptid'] = 'Ingen slike forsøks ID-er finnes';
$string['invalidcategory'] = 'KategoriID-en er ugyldig';
$string['invalidnumericanswer'] = 'Et av svarene du skrev inn er ikke et gyldig tall.';
$string['invalidnumerictolerance'] = 'En av toleranseverdiene du skrev inn var ikke et gyldig tall.';
$string['invalidoverrideid'] = 'Ugyldig overstyrings ID';
$string['invalidquestionid'] = 'Ugyldig spørsmåls ID';
$string['invalidquizid'] = 'Ugyldig quiz-ID';
$string['invalidsource'] = 'Kilden er ikke godkjent som gyldig';
$string['invalidsourcetype'] = 'Ugyldig kildetype';
$string['invalidstateid'] = 'Ugyldig tilstands ID';
$string['lastanswer'] = 'Det siste svaret ditt var';
$string['layout'] = 'Utseende';
$string['layoutasshown'] = 'Sideutseende slik det vises';
$string['layoutasshownwithpages'] = 'Sideoppsett som vist. <small>(Automatisk ny side for hvert {$a} spørsmål.)</small>';
$string['layoutshuffledandpaged'] = 'Spørsmålene vises i tilfeldig rekkefølge med {$a} spørsmål på hver side.';
$string['layoutshuffledsinglepage'] = 'Spørsmålene vises i tilfeldig rekkefølge, alle på samme side.';
$string['link'] = 'Lenke';
$string['listitems'] = 'Opplisting av enheter i hver quiz';
$string['literal'] = 'Bokstav';
$string['loadingquestionsfailed'] = 'Lastingen av spørsmålene mislykkes: {$a}';
$string['makecopy'] = 'Lagre som nytt spørsmål';
$string['managetypes'] = 'Administrere spørsmålstyper og servere';
$string['manualgrading'] = 'Karakersetting';
$string['mark'] = 'Sjekk dette svaret';
$string['markall'] = 'Sjekk alt';
$string['marks'] = 'Poeng';
$string['marks_help'] = 'Den numeriske karakteren for hvert spørsmål, og den samlede skåren for besvarelsen.';
$string['match'] = 'Sammenfallende';
$string['matchanswer'] = 'Sammenfallende svar';
$string['matchanswerno'] = 'Samsvarerende {$a}';
$string['max'] = 'Maks';
$string['messageprovider:attempt_overdue'] = 'Advarsel når quizforsøket har gått ut på tid';
$string['messageprovider:confirmation'] = 'Bekreftelse på dine egne quizforsøk';
$string['messageprovider:submission'] = 'Melding om quizforsøk';
$string['min'] = 'Min';
$string['minutes'] = 'Minutter';
$string['missingcorrectanswer'] = 'Riktig svar må spesifiseres';
$string['missingitemtypename'] = 'Mangler navn';
$string['missingquestion'] = 'Dette spørsmålet ser ut til å ha blitt slettet';
$string['modulename'] = 'Quiz';
$string['modulename_help'] = 'Quizmodulen lar læreren designe og opprette quizer som kan bestå av flervalg, samsvarende, kortsvar, numeriske og andre spørsmålstyper.

Læreren kan velge å la studentene ta quizen flere ganger, med omstokket spørsmålsrekkefølge eller spørsmålene vilkårlig valgt fra testbanken. Grense for antall forsøk kan settes.

Hvert forsøk blir automatisk vurdert (med unntak av fritekstspørsmål), og karakteren blir registrert i karakterboken.

Læreren kan velge om og når hint, tilbakemeldinger og korrekte svar skal vises til studentene.

Quizer kan brukes

* som kurseksamener
* som minitester til leseoppgaver eller på slutten av et emne
* som eksamensøving basert på spørsmål fra tidligere eksamensoppgaver
* til å gi umiddelbare tilbakemeldinger om resultater/prestasjoner
* til egenvurdering';
$string['modulenameplural'] = 'Quizer';
$string['moveselectedonpage'] = 'Flytt valgte spørsmål til side: {$a}';
$string['multichoice'] = 'Flere svaralternativer';
$string['multipleanswers'] = 'Velg minst ett svar';
$string['multiplier'] = 'Gangefaktor';
$string['mustbesubmittedby'] = 'Dette forsøket må sendes innen: {$a}.';
$string['name'] = 'Navn';
$string['navmethod'] = 'Navigeringsmetode';
$string['navmethod_free'] = 'Fri';
$string['navmethod_help'] = 'Når sekvensiell navigering er aktivert, må studenten gå igjennom quizen i rekkefølgen quizen er satt opp. Studenten kan m.a.o. ikke gå tilbake til foregående sider eller hoppe fram.';
$string['navmethod_seq'] = 'Sekvensiell';
$string['navnojswarning'] = 'Advarsel: disse lenkene vil ikke lagre dine svar. Bruk Neste-knappen på bunnen av siden.';
$string['neverallononepage'] = 'Aldri, alle spørsmålene på en side';
$string['newattemptfail'] = 'Feil: Kunne ikke starte et nytt forsøk.';
$string['newpage'] = 'Ny side';
$string['newpageevery'] = 'Automatisk starte en ny side';
$string['newpage_help'] = '<p>Dersom prøva er lang kan det være en fordel å dele quizen opp i flere sider begrenset av antall spørsmål pr. side. Når du legger til spørsmål vil sideskiftet endres automatisk avhengig av innstillingen du velger her. Du kan også endre sideskift manuelt senere.</p>';
$string['noanswers'] = 'Ingen svar ble valgt!';
$string['noattempts'] = 'Ingen forsøk gjort på denne quizen.';
$string['noattemptsfound'] = 'Ingen forsøk funnet';
$string['noattemptstoshow'] = 'Ingen forsøk å vise';
$string['nocategory'] = 'Ugyldig eller ingen kategori oppgitt';
$string['noclose'] = 'Ingen stengningsdato';
$string['nocommentsyet'] = 'Ingen kommentarer ennå.';
$string['noconnection'] = 'Det er for øyeblikket ingen forbindelse til en nett-tjeneste som kan behandle dette spørsmålet. Vennligst kontakt din administrator.';
$string['nodataset'] = 'ingentingh - ugyldig wild card';
$string['nodatasubmitted'] = 'Ingen data ble sendt.';
$string['noessayquestionsfound'] = 'Fant ingen manuelt vurderte spørsmål';
$string['nogradewarning'] = 'Denne quizen er ikke vurdert, så du kan ikke legge inn generell tilbakemelding som differensieres på resultatene.';
$string['nomoreattempts'] = 'Ingen flere forsøk tillatt';
$string['none'] = 'Ingen';
$string['noopen'] = 'Ingen åpningsdato';
$string['nooverridedata'] = 'Du må overstyre minst en av quizens innstillinger.';
$string['nopossibledatasets'] = 'Ingen mulige datasett';
$string['noquestionintext'] = 'Spørsmålsteksten inneholder ingen luker.';
$string['noquestions'] = 'Ingen spørsmål er lagt til enda';
$string['noquestionsfound'] = 'Ingen spørsmål funnet';
$string['noquestionsinquiz'] = 'Det er ingen spørsmål i denne quizen.';
$string['noquestionsnotinuse'] = 'Dette tilfeldige spørsmålet er ikke i bruk siden kategorien er tom.';
$string['noquestionsonpage'] = 'Tom side';
$string['noresponse'] = 'Ingen forsøk gjort';
$string['noreview'] = 'Du har ikke tillatelse til å lese disse svarene';
$string['noreviewattempt'] = 'Du har ikke tillatelse til å se gjennom dette forsøket.';
$string['noreviewshort'] = 'Ikke tillatt';
$string['noreviewuntil'] = 'Du får ikke se svarene før {$a}';
$string['noreviewuntilshort'] = 'Tilgjengelig {$a}';
$string['noscript'] = 'Du må skru på JavaScript for å fortsette';
$string['notavailabletostudents'] = 'NB: Denne quizen er for øyeblikket ikke tilgjengelig for studenter.';
$string['notenoughrandomquestions'] = 'Det er ikke mange nok spørsmål i kategorien {$a->category} til at du kan opprette spørsmålet {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Det er ikke definert nok mange delspørsmål!<br />Vil du gå tilbake og endre dette?';
$string['notimedependentitems'] = 'Tidsavhengige elementer støttes foreløpig ikke i testmodulen. Som en midlertidig løsning kan du sette en tidsgrense for hele testen. Ønsker du å velge et annet element (eller uansett bruke gjeldende)?';
$string['notyetgraded'] = 'Karakter foreløpig ikke satt';
$string['notyetviewed'] = 'Ikke vist foreløpig';
$string['notyourattempt'] = 'Dette er ikke ditt forsøk!';
$string['noview'] = 'Innloggede brukere har ikke tilgang til å se denne quizen';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} har gjort {$a->attemptnum} forsøk';
$string['numattemptsmade'] = '{$a} forsøk er gjort på denne testen';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerisk';
$string['numquestionsx'] = 'Spørsmål: {$a}';
$string['oneminute'] = '1 minutt';
$string['onlyteachersexport'] = 'Bare lærere kan eksportere spørsmål';
$string['onlyteachersimport'] = 'bare lærere med redigeringstilgang kan importere spørsmål';
$string['onthispage'] = 'Denne siden';
$string['open'] = 'Ikke besvart';
$string['openclosedatesupdated'] = 'Testens tilgangsdatoer er oppdatert';
$string['optional'] = 'valgfritt';
$string['orderandpaging'] = 'Rekkefølge og sidefordeling';
$string['orderandpaging_help'] = 'Tallene 10,20,30,... overfor hvert spørsmål indikerer sorteringsrekkefølgen. Tallene øker i steg på 10 for å gi plass til spørsmål som måtte bli lagt til senere. For å omorganisere spørsmålsrekkefølgen kan du endre nummeret og deretter klikke på knappen "Omorganiser spørsmålene".

Du legger til sideskift etter et spørsmål ved å merke av avkrysningsboksen ved siden av spørsmålet og deretter  knappen for "Legg til sideskift etter valgte spørsmål"

For å fordele spørsmålene over et antall sider kan du klikke på Omorganiser-knappen og velge ønsket antall spørsmål pr. side.';
$string['orderingquiz'] = 'Rekkefølge og sidefordeling';
$string['orderingquizx'] = 'Rekkefølge og sidetall: {$a}';
$string['outcomesadvanced'] = 'Læringsutbytte hører til under avanserte innstillinger.';
$string['outof'] = '{$a->grade} av maksimalt {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} av maksimum {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Tilbakemelding på testen';
$string['overallfeedback_help'] = '<p>Den generelle tilbakemeldingen er en tekst som vises for studentene straks de har fullført et quizforsøk. Den teksten som vises kan være avhengig av poengsummen de har fått.</p>

<p>F.eks. dersom du skriver inn:</p>

<p>Poenggrense: 100%<br />
Tilbakemelding: Utmerket!<br />
Poenggrense: 40%<br />
Tilbakemelding: Vennligst se over denne ukens lærestoff en gang til.<br />
...<br />
Poenggrense: 0%</p>

<p>Når studenter får en poengsum mellom 100% og 40% vil de få meldingen "Utmerket" og studenter med poengsum mellom 39.99% og 0% vil få den andre meldingen. Det er altså teksten mellom øvre og nedre grense som vises for hvert poengsteg du definerer.</p>

<p>Poenggrensene kan angis enten som prosent eller et tall. Dersom quizen har maks 10 poeng vil en poenggrense på 7 bety  at de må ha 7/10 eller bedre.</p>';
$string['overdue'] = 'For sent';
$string['overduehandling'] = 'Når tiden går ut';
$string['overduehandlingautoabandon'] = 'Besvarelser må leveres inn før tiden går ut, ellers blir de ikke regnet med.';
$string['overduehandlingautosubmit'] = 'Åpne besvarelser blir sendt inn automatisk';
$string['overduehandling_desc'] = 'Hva skal skje som standard hvis en student ikke leverer inn quizen før tiden går ut.';
$string['overduehandlinggraceperiod'] = 'Det er en utsettelsesperiode der åpne forsøk kan leveres inn men ingen flere spørsmål kan besvares.';
$string['overduehandling_help'] = 'Denne innstillingen kontrollerer hva som skjer hvis studenten ikke sender inn sitt quizforsøk før tiden går ut. Hvis studenten jobber aktivt med quizen der og da, vil nedtellingstidtakeren alltid sende inn forsøket automatisk for studenten, men hvis han/hun er logget ut, kontrollerer denne innstillingen hva som skjer.';
$string['overduemustbesubmittedby'] = 'Tiden har nå gått ut for dette forsøket. Besvarelsen skulle allerede ha vært levert inn. Hvis du vil ha karakter på dette forsøket, må du sende det inn innen {$a}. Hvis du ikke sender det inn innen dette tidspunktet, vil ikke noen karakter fra dette forsøket telles med.';
$string['override'] = 'Overstyr';
$string['overridedeletegroupsure'] = 'Er du sikker på at du vil slette overstyringen for gruppen {$a}?';
$string['overridedeleteusersure'] = 'Er du sikker på at du vil slette overstyringen for brukeren {$a}?';
$string['overridegroup'] = 'Overstyr gruppe';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Overstyringer';
$string['overrideuser'] = 'Overstyr bruker';
$string['overrideusereventname'] = '{$a->quiz} - Overstyring';
$string['page-mod-quiz-attempt'] = 'Oversikt over quiz-forsøk';
$string['page-mod-quiz-edit'] = 'Rediger quizsiden';
$string['page-mod-quiz-report'] = 'En quiz rapportside';
$string['page-mod-quiz-review'] = 'Vis quiz-forsøk';
$string['page-mod-quiz-summary'] = 'Oppsummeringsside for quiz-forsøk';
$string['page-mod-quiz-view'] = 'Quiz informasjonsside';
$string['page-mod-quiz-x'] = 'Alle sider i quizmodulen';
$string['pagesize'] = 'Sidestørrelse';
$string['parent'] = 'Overordnet';
$string['parentcategory'] = 'Overordnet kategori';
$string['parsingquestions'] = 'Inspiserer spørsmål fra importfila';
$string['partiallycorrect'] = 'Delvis riktig';
$string['penalty'] = 'Straffepoeng';
$string['penaltyscheme'] = 'Bruk straffepoeng';
$string['penaltyscheme_help'] = '<p>Hvis en quiz kjøres i tilpasningsmodus kan studentene prøve mer enn en gang når de svarer feil. I slike tilfeller ønsker du kanskje å benytte en straffefaktor som trekker noe fra maks poengsum hver gang de svarer feil. Hvor mye som skal trekkes fra bestemmes individuelt for hvert spørsmål når du oppretter eller redigerer spørsmålene.</p>

<p>Denne innstillingen har ingen innvirkning på quizer som ikke kjører i tilpasningsmodus.</p>';
$string['percentcorrect'] = 'Prosent riktig';
$string['pleaseclose'] = 'Forespørselen din har blitt behandlet. Du kan lukke dette vinduet.';
$string['pluginadministration'] = 'Quiz-administrasjon';
$string['pluginname'] = 'Quiz';
$string['popup'] = 'Vis quizen i et "sikkert" vindu';
$string['popupblockerwarning'] = 'Denne testen kjøres i sikkermodus, dette betyr at du må ta testen i et "sikkert" vindu. Vennligst slå av pop-up blokkeringen i nettleseren. Tusen takk.';
$string['popupnotice'] = 'Studentene ser denne quizen i et sikkert vindu';
$string['preprocesserror'] = 'Det oppstod en feil under pre-prosesseringen!';
$string['preview'] = 'Forhåndsvisning';
$string['previewquestion'] = 'Forhåndsvisning av spørsmålet';
$string['previewquiz'] = 'Forhåndsvis {$a}';
$string['previewquiznow'] = 'Ta testen nå';
$string['previous'] = 'Tidligere tilstand';
$string['publish'] = 'Publiser';
$string['publishedit'] = 'For å legge til eller redigere spørsmål i denne kategorien må ha tillatelse fra kurset som har publisert den.';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'navn';
$string['qti'] = 'IMS QTI-format';
$string['qtypename'] = 'type, navn';
$string['question'] = 'Spørsmål';
$string['questionbankcontents'] = 'Testbankens innhold';
$string['questionbankmanagement'] = 'Testbank administrasjon';
$string['questionbehaviour'] = 'Quiz-oppførsel';
$string['questioncats'] = 'Spørsmålskategorier';
$string['questiondeleted'] = 'Dette spørsmålet er slettet. Vennligst kontakt læreren din.';
$string['questioninuse'] = 'Spørsmålet \'{$a}\' er i bruk:';
$string['questionmissing'] = 'Spørsmål for denne sesjonen mangler';
$string['questionname'] = 'Spørsmålsnavn';
$string['questionnonav'] = '<span class="accesshide">Spørsmål </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informasjon </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Spørsmål {$a} har ikke blir lastet fra databasen';
$string['questionorder'] = 'Spørsmålsrekkefølge';
$string['questionposition'] = 'Ny posisjon i rekkefølgen for spørsmål {$a}';
$string['questions'] = 'Spørsmål';
$string['questionsinclhidden'] = 'Spørsmål (inkludert skjulte)';
$string['questionsinthisquiz'] = 'Spørsmål i denne testen';
$string['questionsperpage'] = 'Spørsmål pr.side';
$string['questionsperpageselected'] = 'Spørsmål pr side er angitt så sidefordelingen er reparert. Som resultat er sidekontrollene deaktivert. Du kan endre dette i {$a}';
$string['questionsperpagex'] = 'Spørsmål pr. side: {$a}';
$string['questiontext'] = 'Spørsmålstekst';
$string['questiontextisempty'] = '[Manglende spørsmålstekst]';
$string['questiontype'] = 'Spørsmålstype';
$string['questiontypesetupoptions'] = 'Oppsettsmuligheter for spørsmålstyper:';
$string['quiz:addinstance'] = 'Legg til ny quiz';
$string['quiz:attempt'] = 'Testforsøk';
$string['quizavailable'] = 'Quizen er tilgjengelig til: {$a}';
$string['quizclose'] = 'Avslutt denne quizen';
$string['quizclosed'] = 'Denne quizen avsluttes {$a}';
$string['quizcloses'] = 'Quizen avsluttes';
$string['quizcloseson'] = 'Denne testen vil stenges {$a}';
$string['quiz:deleteattempts'] = 'Slett testforsøk';
$string['quiz:emailconfirmsubmission'] = 'Motta e-postbekreftelse ved innlevering';
$string['quiz:emailnotifysubmission'] = 'Motta e-postvarsel når innleveringer sendes inn';
$string['quiz:emailwarnoverdue'] = 'Få e-postvarsel når et quizforsøk er på overtid og må leveres inn.';
$string['quiz:grade'] = 'Vurder tester manuelt';
$string['quiz:ignoretimelimits'] = 'Ignorer tidsgrenser på tester';
$string['quizisclosed'] = 'Denne quizen er stengt';
$string['quizisclosedwillopen'] = 'Quizen er stengt (åpner {$a})';
$string['quizisopen'] = 'Denne quizen er åpen';
$string['quizisopenwillclose'] = 'Quizen er åpen (stenger {$a})';
$string['quiz:manage'] = 'Administrere tester';
$string['quiz:manageoverrides'] = 'Administrere quiz-overstyringer';
$string['quiznavigation'] = 'Quiz-navigasjon';
$string['quizopen'] = 'Åpne quizen';
$string['quizopenclose'] = 'Datoer for å åpne og stenge';
$string['quizopenclose_help'] = 'Studenter kan bare starte sine forsøk etter åpningstidspunktet, og de må fullføre dem før stengetidspunktet.';
$string['quizopened'] = 'Denne quizen er åpen.';
$string['quizopenedon'] = 'Quizen åpner {$a}';
$string['quizopens'] = 'Quizen åpnes';
$string['quizopenwillclose'] = 'Denne quizen er åpen, og vil stenge {$a}';
$string['quizordernotrandom'] = 'Quiz-rekkefølgen er ikke satt til tilfeldig';
$string['quizorderrandom'] = '* Quiz-rekkefølgen er satt til tilfeldig';
$string['quiz:preview'] = 'Forhåndsvis tester';
$string['quiz:regrade'] = 'Revurder quiz-forsøkene';
$string['quiz:reviewmyattempts'] = 'Vis dine egne forsøk';
$string['quizsettings'] = 'Testinnstillinger';
$string['quiztimer'] = 'Tidtaker for quiz';
$string['quiz:view'] = 'Vis testinformasjon';
$string['quiz:viewreports'] = 'Vis testrapporter';
$string['quizwillopen'] = 'Denne quizen vil åpne {$a}';
$string['random'] = 'Tilfeldig spørsmål';
$string['randomcreate'] = 'Lag tilfeldige spørsmål';
$string['randomfromcategory'] = 'Tilfeldig spørsmål fra kategorien: ';
$string['randomfromexistingcategory'] = 'Tilfeldige spørsmål fra en eksisterende kategori';
$string['randomnosubcat'] = 'Spørsmål fra bare denne kategorien - ikke underkategorier.';
$string['randomquestionusinganewcategory'] = 'Tilfeldige spørsmål fra en ny kategori';
$string['randomwithsubcat'] = 'Spørsmål fra denne kategorien med underkategorier.';
$string['readytosend'] = 'Du prøver å sende svarene dine til vurdering. Er du sikker?';
$string['reattemptquiz'] = 'Ta quizen på nytt';
$string['recentlyaddedquestion'] = 'Nylig tillagte spørsmål';
$string['recurse'] = 'Ta også med spørsmål fra underkategorier';
$string['regrade'] = 'Regn om alle forsøk';
$string['regradecomplete'] = 'Alle forsøk er regnet om';
$string['regradecount'] = '{$a->changed} av {$a->attempt} karakterer ble endret';
$string['regradedisplayexplanation'] = 'Forsøk som endres ved revurdering blir vist som lenker i spørsmålsvinduet';
$string['regradenotallowed'] = 'Du har ikke tillatelse til å endre vurderingene i denne testen';
$string['regradingquestion'] = 'Ny beregning av "{$a}"';
$string['regradingquiz'] = 'Omberegner quizen "{$a}"';
$string['remove'] = 'Fjern';
$string['removeallquizattempts'] = 'Slett alle testforsøk';
$string['removeemptypage'] = 'Fjern tom side';
$string['removeselected'] = 'Fjern valgte';
$string['rename'] = 'Nytt navn';
$string['renderingserverconnectfailed'] = 'Serveren {$a} mislykkes i å behandle en RQP forespørsel. Sjekk at URL-en er korrekt.';
$string['reorderquestions'] = 'Omorganiser spørsmålene';
$string['reordertool'] = 'Vis verktøy for endring av rekkefølge';
$string['repaginate'] = 'Ompaginer med {$a} spørsmål på hver side';
$string['repaginatecommand'] = 'Repaginer';
$string['repaginatenow'] = 'Repaginer nå';
$string['replace'] = 'Bytt ut';
$string['replacementoptions'] = 'Erstatningsvalg';
$string['report'] = 'Rapporter';
$string['reportanalysis'] = 'Analyse';
$string['reportattemptsfrom'] = 'Forsøk fra';
$string['reportattemptsthatare'] = 'Forsøk som er';
$string['reportdisplayoptions'] = 'Visningsvalg';
$string['reportfullstat'] = 'Detaljert statistikk';
$string['reportmulti_percent'] = 'Multi-prosentverdier';
$string['reportmulti_q_x_student'] = 'Multi-student valg';
$string['reportmulti_resp'] = 'Individuelle besvarelser';
$string['reportmustselectstate'] = 'Du må velge minst en tilstand';
$string['reportnotfound'] = 'Rapporten ukjent ({$a})';
$string['reportoverview'] = 'Oversikt';
$string['reportregrade'] = 'Regn om karakterer';
$string['reportresponses'] = 'Detaljerte tilbakemeldinger';
$string['reports'] = 'Rapporter';
$string['reportshowonly'] = 'Vis bare forsøkene';
$string['reportshowonlyfinished'] = 'Vis maksimalt et fullført forsøk for hver bruker ({$a})';
$string['reportsimplestat'] = 'Enkel statistikk';
$string['reportusersall'] = 'alle brukere som har tatt quizen';
$string['reportuserswith'] = 'påmeldte brukere som har tatt quizen';
$string['reportuserswithorwithout'] = 'påmeldte brukere som har, eller ikke har tatt quizen';
$string['reportuserswithout'] = 'påmeldte brukere som ikke har tatt quizen';
$string['reportwhattoinclude'] = 'Hva som skal tas med i rapporten';
$string['requirepassword'] = 'Krev passord';
$string['requirepassword_help'] = '<p>Dette felter er valgfritt.</p>

<p>Dersom du skriver inn et passord her må deltakerne skrive inn samme passord for å få lov til å ta quizen.</p>';
$string['requiresubnet'] = 'Krev nettverksadresse';
$string['requiresubnet_help'] = '<p>Dette felter er valgfritt.</p>

<p>Du kan avgrense tilgangen til en quiz til bestemte subnett på nettverket eller Internett ved å angi en kommaseparert liste av deler eller hele IP-adressenumre.</p>

<p>Dette er spesielt anvendelig ved overvåkede quizer, hvor du ønsker å være sikker på at bare deltakere i et bestemt rom har tilgang til quizen.</p>

<p>For eksempel: <b>192.168. , 231.54.211.0/20, 231.3.56.211, 231.3.56.10-20</b></p>

<p>Du kan bruke fire forskjellige nummertyper (du kan ikke bruke kanoniske navn som example.com):</p>

<ol>
<li>Fulle IP addresser, som <b>192.168.10.1</b> som vil gi tilgang for en enkelt pc/proxy eller ruter.</li>
<li>Delvise addresser, som <b>192.168</b> som vil gi tilgang for alle ip-adresser som starter med disse tallene.</li>
<li>CIDR notasjon, som <b>231.54.211.0/20</b> som lar deg angi mer detaljert hvilket subnett som skal ha tilgang.</li>
<li>Et IP-addresseområde <b>231.3.56.10-20</b> Adresseområdet angis ved de siste sifferelementene og betyr alle IP-adresser fra  231.3.56.10 til 231.3.56.20.</li>
</ol>

<p>Mellomrom blir ignorert.</p>';
$string['response'] = 'Respons';
$string['responses'] = 'Respons';
$string['results'] = 'Resultater';
$string['returnattempt'] = 'Gå tilbake til forsøket';
$string['reuseifpossible'] = 'gjenbruk tidligere fjernede';
$string['reverttodefaults'] = 'Tilbakestill til Quiz-modulens standardverdier';
$string['review'] = 'Sammendrag';
$string['reviewafter'] = 'Tillat sammendrag etter at quizen er avsluttet.';
$string['reviewalways'] = 'Tillat sammendrag';
$string['reviewattempt'] = 'Vis forsøk';
$string['reviewbefore'] = 'Tillat sammendrag mens quizen er åpen';
$string['reviewclosed'] = 'Etter at quizen er avsluttet';
$string['reviewduring'] = 'Under forsøket';
$string['reviewimmediately'] = 'Rett etter et forsøk';
$string['reviewnever'] = 'Ikke tillat sammendrag';
$string['reviewofattempt'] = 'Sammendrag av forsøk {$a}';
$string['reviewofpreview'] = 'Gjennomgang av forhåndsvisning';
$string['reviewopen'] = 'Senere, så lenge quizen fortsatt er åpen';
$string['reviewoptions'] = 'Studenter kan bedømme';
$string['reviewoptionsheading'] = 'Gjennomgå innstillinger';
$string['reviewoptionsheading_help'] = 'Disse valgene styrer hvilken informasjon studentene kan se når de ser gjennom quizforsøk eller ser på rapporter.

**Mens forsøket pågår**-innstillinger er kun relevant for noen atferder, f.eks. \'interaktivt med flere forsøk\', som kan vise tilbakemeldinger mens forsøket pågår.

**Straks etter et forsøk**-innstillinger gjelder for de første to minuttene etter at en har klikket på "Send inn og avslutt".

**Senere, mens quizen fortsatt er åpen**-innstillinger gjelder etter dette og før stengningstidpunktet for quizzen.</p>

**Etter at quizzen er avsluttet**-innstillinger gjelder etter at tidspunktet for stenging av quizen har passert. Dersom quizen ikke har noen stengningsdato inntreffer dette aldri.';
$string['reviewoverallfeedback'] = 'Generelle tilbakemeldinger';
$string['reviewoverallfeedback_help'] = 'Tilbakemeldingen gitt etter endt forsøk, avhengig av studentens samlede karakter';
$string['reviewresponse'] = 'Gjennomgå tilbakemeldinger';
$string['reviewresponsetoq'] = 'Vis responsen (spørsmål {$a})';
$string['reviewthisattempt'] = 'Vis dine responser på dette forsøket';
$string['rqp'] = 'Eksternt spørsmål';
$string['rqps'] = 'Eksterne spørsmål';
$string['sameasoverall'] = 'Samme som for sammenlagt karakterer';
$string['save'] = 'Lagre';
$string['saveandedit'] = 'Lagre endringer og rediger spørsmål';
$string['saveattemptfailed'] = 'Lagringen av gjeldende quiz-forsøk var mislykket.';
$string['savedfromdeletedcourse'] = 'Lagret fra slettet kurs "{$a}"';
$string['savegrades'] = 'Lagre karakterer';
$string['savemyanswers'] = 'Lagre mine svar';
$string['savenosubmit'] = 'Lagre uten å sende inn';
$string['saveoverrideandstay'] = 'Lagre og åpne en annen overstyring';
$string['savequiz'] = 'Lagre hele quizen';
$string['saving'] = 'Lagrer';
$string['savingnewgradeforquestion'] = 'Lagrer ny karakter for spørsmåls-ID {$a}.';
$string['savingnewmaximumgrade'] = 'Lagrer ny makskarakter.';
$string['score'] = 'Poeng';
$string['scores'] = 'Poeng';
$string['select'] = 'Velg';
$string['selectall'] = 'Velg alle';
$string['selectcategory'] = 'Velg kategori';
$string['selectedattempts'] = 'Valgte forsøk';
$string['selectnone'] = 'Omgjør alle valgte';
$string['selectquestiontype'] = '- Velg spørsmålstype - ';
$string['serveradded'] = 'La til tjener';
$string['serveridentifier'] = 'Identfiser';
$string['serverinfo'] = 'Tjenerinformasjon';
$string['servers'] = 'Tjenere';
$string['serverurl'] = 'Tjeners URL';
$string['settingsoverrides'] = 'Overstyring av innstillinger';
$string['shortanswer'] = 'Kort svar';
$string['show'] = 'Vis';
$string['showall'] = 'Vis alle spørsmålene på samme side';
$string['showblocks'] = 'Vis sideblokker når quizen tas';
$string['showblocks_help'] = 'Dersom Ja vil sideblokker vises når quizen tas';
$string['showbreaks'] = 'Vis sideskift';
$string['showcategorycontents'] = 'Vis kategoriinnhold {$a->arrow}';
$string['showcorrectanswer'] = 'Vis de riktige svarene i tilbakesvar?';
$string['showdetailedmarks'] = 'Vis kommentardetaljer';
$string['showeachpage'] = 'Vis en side om gangen';
$string['showfeedback'] = 'Vis tilbakemelding etter svar?';
$string['showinsecurepopup'] = 'Bruk et "sikkert" popup-vindu for quizforsøk';
$string['showlargeimage'] = 'Stort bilde';
$string['shownoattempts'] = 'Vis studenter uten forsøk';
$string['shownoattemptsonly'] = 'Vis kun studenter uten forsøk';
$string['shownoimage'] = 'Uten bilde';
$string['showreport'] = 'Vis rapport';
$string['showsmallimage'] = 'Lite bilde';
$string['showteacherattempts'] = 'Vis lærernes forsøk';
$string['showuserpicture'] = 'Vis brukerens profilbilde';
$string['showuserpicture_help'] = 'Dersom aktivert vil studentens navn og bilde vises på skjermen når quizen tas og når en ser over quizresultatene. Dette gjør det lettere å sikre at studenten er logget inn som seg selv når det skal være en overvåket eksamen.';
$string['shuffle'] = 'Stokk om';
$string['shuffleanswers'] = 'Stokk svarene';
$string['shuffledrandomly'] = 'Tilfeldig rekkefølge';
$string['shufflequestions'] = 'Stokk spørsmålene';
$string['shufflequestionsselected'] = 'TIlfeldig rekkefølge er valgt, så noen handlinger relatert til sidefordeling er ikke tilgjengelige. Endre i så fall til manuell organisering, {$a}';
$string['shufflewithin'] = 'Stokk innen spørsmål';
$string['shufflewithin_help'] = '<p>Hvis du slår på denne innstillingen vil rekkefølgen på svaralternativene i
hvert spørsmål være tilfeldig for hver gang en student tar quizen. </p>

<p>Meningen er helt enkelt å gjøre det litt vanskeligere for studenter å kopiere
fra hverandre. </p>';
$string['singleanswer'] = 'Velg et svar';
$string['sortage'] = 'Sorter etter alder';
$string['sortalpha'] = 'Sorter etter navn';
$string['sortquestionsbyx'] = 'Sorter spørsmålene etter: {$a}';
$string['sortsubmit'] = 'Sorter spørsmål';
$string['sorttypealpha'] = 'Sorter etter type, navn';
$string['specificapathnotonquestion'] = 'Den angitte filstien er ikke på det spesifiserte spørsmålet';
$string['specificquestionnotonquiz'] = 'Spesifisert spørsmål er ikke i den angitte quizen';
$string['startagain'] = 'Begynn på nytt';
$string['startattempt'] = 'Start forsøk';
$string['startedon'] = 'Begynt den';
$string['startnewpreview'] = 'Begynn på nytt';
$string['stateabandoned'] = 'Aldri sendt inn';
$string['statefinished'] = 'Ferdig';
$string['statefinisheddetails'] = 'Levert {$a}';
$string['stateinprogress'] = 'Pågår';
$string['statenotloaded'] = 'Status for spørsmål {$a} er ikke lastet fra databasen';
$string['stateoverdue'] = 'På overtid';
$string['stateoverduedetails'] = 'Må sendes inn innen {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stopp ved feil';
$string['submitallandfinish'] = 'Send svarene og avslutt';
$string['subneterror'] = 'Beklager, denne quizen er låst, slik at den bare er tilgjengelig fra visse nettverk. Datamaskinen din befinner seg dessverre ikke på et slikt nettverk.';
$string['subnetnotice'] = 'Denne quizen har blitt låst slik at den kun er tilgjengelig fra visse steder. Din datamaskin er ikke på et tillatt subnett. Som lærer har du lov til å kikke på den uansett.';
$string['subplugintype_quiz'] = 'Rapport';
$string['subplugintype_quizaccess'] = 'Tilgangsregel';
$string['subplugintype_quizaccess_plural'] = 'Tilgangsregler';
$string['subplugintype_quiz_plural'] = 'Rapporter';
$string['substitutedby'] = 'vil bli byttet ut med';
$string['summaryofattempt'] = 'Oppsummering av forsøk';
$string['summaryofattempts'] = 'Oppsummering av dine tidligere forsøk';
$string['temporaryblocked'] = 'Du har midlertidig ikke lov å forsøke quizen på nytt.<br />Du vil kunne forsøke igjen den:';
$string['theattempt'] = 'Forsøket';
$string['theattempt_help'] = 'Hvorvidt studenten kan se igjennom forsøket i det hele tatt';
$string['time'] = 'Tid';
$string['timecompleted'] = 'Fullført';
$string['timedelay'] = 'Du kan ikke ta denne testen siden det er gått for kort tid siden forrige forsøk.';
$string['timeleft'] = 'Gjenstående tid';
$string['timelimit'] = 'Tidsgrense';
$string['timelimitexeeded'] = 'Beklager! Quizens tidsgrense er overskredet.';
$string['timelimit_help'] = 'Hvis denne funksjonen er aktivert, blir tidsbegrensningen oppgitt på den første siden av quizen og en nedtellingstidtakeren vist i quiznavigeringsblokken.';
$string['timelimitmin'] = 'Tidsgrense (minutter)';
$string['timelimitsec'] = 'Tidsbegrensning (sekunder)';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Tida er over!';
$string['timetaken'] = 'Totalt brukt tid';
$string['timing'] = 'Tidtaging';
$string['tofile'] = 'til fil';
$string['tolerance'] = 'Toleranse';
$string['toomanyrandom'] = 'Antallet tilfeldige spørsmål er større enn denne kategorien inneholder! ({$a})';
$string['top'] = 'Topp';
$string['totalmarksx'] = 'Totalvurdering: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total for {$a} spørsmål i kategorien.';
$string['true'] = 'Riktig';
$string['truefalse'] = 'Sant/usant';
$string['type'] = 'Type';
$string['unfinished'] = 'åpen';
$string['ungraded'] = 'Ikke vurdert';
$string['unit'] = 'Enhet';
$string['unknowntype'] = 'Spørsmålstypen blir ikke støttet ved linje {$a}. Spørsmålet vill bli ignorert.';
$string['unusedcategorydeleted'] = 'Denne kategorien er slettet fordi, etter sletting av kurset, dets spørsmål ikke lenger er i bruk.';
$string['updatesettings'] = 'Oppdater testinnstillinger';
$string['updatingatttemptgrades'] = 'Oppdaterer karakteren på forsøket';
$string['updatingfinalgrades'] = 'Oppdaterer endelig karakter';
$string['updatingthegradebook'] = 'Oppdaterer karakterboken';
$string['upgradesure'] = '<div>Spesielt testmodulen vil gjennomgå store endringer i testtabeller og denne oppgraderingen er ikke ennå tilstrekkelig testet. Vi anbefaler sterkt at du tar en backup av databasen FØR du fortsetter.</div>';
$string['upgradingquizattempts'] = 'Oppgraderer quizforsøkene: quiz {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Oppgraderer veldig gamle quizforsøk: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Denne kategorien tihørte et kurs som har blitt slettet. Siden den inneholder spørsmål som er i bruk av andre kurs, har den blitt flyttet til øverste nivå(nettstednivå).';
$string['useroverrides'] = 'Bruker overstyring';
$string['usersnone'] = 'Ingen studenter har tilgang til denne quizen';
$string['validate'] = 'Valider';
$string['viewallanswers'] = 'Vis {$a} fullførte quizer';
$string['viewallreports'] = 'Vis rapporter for {$a} forsøk';
$string['viewed'] = 'Vist';
$string['warningmissingtype'] = '<b>Dette spørsmålet er av en type som ennå ikke er installert i din Moodle.<br />Vennligst varsle Moodle administrator.</b>';
$string['wheregrade'] = 'Hvor er karakteren min?';
$string['wildcard'] = 'Gjett';
$string['windowclosing'] = 'Dette vinduet vil straks lukkes';
$string['withsummary'] = 'med sammendragsstatistikk';
$string['wronguse'] = 'Du kan ikke bruke denne sida slik.';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Du må melde deg på dette kurset før du kan ta testen i den.';
$string['yourfinalgradeis'] = 'Sluttkarakter på denne quizen ble {$a}.';
