<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'plugin', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   plugin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Handlinger';
$string['availability'] = 'Tilgjengelighet';
$string['checkforupdates'] = 'Sjekk etter tilgjengelige oppdateringer';
$string['checkforupdateslast'] = 'Siste sjekk ble gjort {$a}';
$string['dependencyinstall'] = 'Installer';
$string['dependencyupload'] = 'Last opp';
$string['detectedmisplacedplugin'] = 'Modul "{$a->component}" er installert på feil plassering "{$a->current}", forvented plassering er "{$a->expected}"';
$string['displayname'] = 'Navn på modul';
$string['err_response_curl'] = 'Kunne ikke hente tilgjengelige oppdateringsdata - uventet cURL-feil';
$string['err_response_format_version'] = 'Uventet versjon av svarformatet. Vennligst sjekk igjen om det finnes tilgjengelige oppdateringer.';
$string['err_response_http_code'] = 'Kunne ikke hente tilgjengelige oppdateringsdata - uventet HTTP svarkode.';
$string['filterall'] = 'Vis alle';
$string['filtercontribonly'] = 'Vis kun tilleggsmoduler';
$string['filtercontribonlyactive'] = 'Viser kun tilleggsmoduler';
$string['filterupdatesonly'] = 'Vis kun oppdateringer';
$string['filterupdatesonlyactive'] = 'Viser kun oppdateringer';
$string['moodleversion'] = 'Moodle {$a}';
$string['nonehighlighted'] = 'Ingen moduler krever din oppmerksomhet akkurat nå.';
$string['nonehighlightedinfo'] = 'Vis liste over alle installerte moduler likevel';
$string['noneinstalled'] = 'Ingen moduler av denne typen er installert';
$string['notdownloadable'] = 'Kan ikke laste ned pakken';
$string['notdownloadable_help'] = 'ZIP-pakken med oppdateringen kan ikke lastes ned automatisk. Vennligst sjekk dokumentasjonssiden for mer hjelp.';
$string['notes'] = 'Notater';
$string['notwritable'] = 'Modulsidene er ikke skrivbare';
$string['notwritable_help'] = 'Du har aktivert automatisk utrulling av oppdateringer og det er en tilgjengelig oppdatering for denne modulen. Webtjeneren har imidlertid ikke skrivetilgang til modulfilene, så oppdateringen kan ikke installeres for øyeblikket.

Gjør modulmappen og alt innholdet i den skrivbar for å kunne installere den tilgjengelige oppdateringen automatisk.';
$string['numdisabled'] = 'Deaktivert: {$a}';
$string['numextension'] = 'Tilleggsmoduler: {$a}';
$string['numtotal'] = 'Installert: {$a}';
$string['numupdatable'] = 'Oppdateringer ikke tilgjengelig: {$a}';
$string['otherplugin'] = '{$a->component}';
$string['otherpluginversion'] = '{$a->component} ({$a->version})';
$string['pluginchecknotice'] = 'Denne siden viser moduler som det kan hende at du må vie oppmerksomhet under oppgraderingen. Markerte elementer inkluderer nye moduler som er i ferd med å bli innstallert, oppdaterte moduler som er i ferd med å bli oppgradert, pluss eventuelle moduler som mangler. Tilleggsmoduler er også fremhevet. Du bør sjekke om nyere versjoner av tilleggsmoduler er tilgjengelig, og evt. oppdatere kildekoden til disse tilleggsmodulene før du fortsetter med denne Moodle-oppgraderingen.';
$string['plugindisable'] = 'Deaktiver';
$string['plugindisabled'] = 'Deaktivert';
$string['pluginenable'] = 'Aktiver';
$string['pluginenabled'] = 'Aktivert';
$string['requiredby'] = 'Krevd av: {$a}';
$string['requires'] = 'Krever';
$string['rootdir'] = 'Katalog';
$string['settings'] = 'Innstillinger';
$string['showall'] = 'Last på nytt og vis alle moduler';
$string['somehighlighted'] = 'Antall moduler som krever din oppmerksomhet: {$a}';
$string['somehighlightedinfo'] = 'Vis fullstendig liste over installerte moduler';
$string['somehighlightedonly'] = 'Vis kun moduler som krever din oppmerksomhet';
$string['source'] = 'Kilde';
$string['sourceext'] = 'Programtillegg';
$string['sourcestd'] = 'Standard';
$string['status'] = 'Status';
$string['status_delete'] = 'Skal slettes';
$string['status_downgrade'] = 'Nyere versjon er allerede installert!';
$string['status_missing'] = 'Mangler fra disk';
$string['status_new'] = 'Skal installeres';
$string['status_nodb'] = 'Ingen database';
$string['status_upgrade'] = 'Skal oppgraderes';
$string['status_uptodate'] = 'Installert';
$string['systemname'] = 'Identifikator';
$string['type_auth'] = 'Autentiseringsmetode';
$string['type_auth_plural'] = 'Autentiseringsmoduler';
$string['type_block'] = 'Blokk';
$string['type_block_plural'] = 'Blokker';
$string['type_cachelock'] = 'Mellomlagre låsbehandleren';
$string['type_cachelock_plural'] = 'Mellomlagre låsbehandlerene';
$string['type_cachestore'] = 'Mellomlager';
$string['type_cachestore_plural'] = 'Mellomlagre';
$string['type_calendartype'] = 'Kalendertype';
$string['type_calendartype_plural'] = 'Kalendertyper';
$string['type_coursereport'] = 'Kursrapporter';
$string['type_coursereport_plural'] = 'Kursrapporter';
$string['type_editor'] = 'Editor';
$string['type_editor_plural'] = 'Editorer';
$string['type_enrol'] = 'Påmeldingsmetode';
$string['type_enrol_plural'] = 'Påmeldingsmetoder';
$string['type_filter'] = 'Filter';
$string['type_filter_plural'] = 'Tekstfiltre';
$string['type_format'] = 'Kursformater';
$string['type_format_plural'] = 'Kursformat';
$string['type_gradeexport'] = 'Karaktereksportmetode';
$string['type_gradeexport_plural'] = 'Karaktereksportmetoder';
$string['type_gradeimport'] = 'Karakterimportmetode';
$string['type_gradeimport_plural'] = 'Karakterimportmetoder';
$string['type_gradereport'] = 'Karakterbokrapport';
$string['type_gradereport_plural'] = 'Karakterbokrapporter';
$string['type_gradingform'] = 'Avansert karaktersettingsmetode';
$string['type_gradingform_plural'] = 'Avanserte metoder for karaktersetting';
$string['type_local'] = 'Lokal modul';
$string['type_local_plural'] = 'Lokale moduler';
$string['type_message'] = 'Meldingsproduksjon';
$string['type_message_plural'] = 'Meldingsproduksjon';
$string['type_mnetservice'] = 'MNet-tjeneste';
$string['type_mnetservice_plural'] = 'MNet-tjenester';
$string['type_mod'] = 'Aktivitetsmodul';
$string['type_mod_plural'] = 'Aktivitetsmoduler';
$string['type_plagiarism'] = 'Plagiatbeskyttelse';
$string['type_plagiarism_plural'] = 'Moduler for plagiatbeskyttelse';
$string['type_portfolio'] = 'Portefølje';
$string['type_portfolio_plural'] = 'Porteføljer';
$string['type_profilefield'] = 'Type profilfelt';
$string['type_profilefield_plural'] = 'Typer profilfelt';
$string['type_qbehaviour'] = 'Spørsmålsatferd';
$string['type_qbehaviour_plural'] = 'Spørsmålsatferd';
$string['type_qformat'] = 'Import/eksportformat på spørsmål';
$string['type_qformat_plural'] = 'Import/eksportformat på spørsmål';
$string['type_qtype'] = 'Spørsmålstype';
$string['type_qtype_plural'] = 'Spørsmålstyper';
$string['type_report'] = 'Portalrapport';
$string['type_report_plural'] = 'Rapporter';
$string['type_repository'] = 'Filområde';
$string['type_repository_plural'] = 'Filarkiv';
$string['type_theme'] = 'Tema';
$string['type_theme_plural'] = 'Tema';
$string['type_tool'] = 'Adminverktøy';
$string['type_tool_plural'] = 'Adminverktøy';
$string['type_webservice'] = 'Protokoll over webtjenester';
$string['type_webservice_plural'] = 'Protokoller over webtjenester';
$string['uninstall'] = 'Fjern';
$string['uninstallconfirm'] = 'Du er i ferd med å avinstallere <em>{$a->name}</em>. Dette vil slette alt i databasen som er assosiert med modulen, inkludert oppsett, logger, brukerfiler som modulen bruker osv. Det finnes ingen vei tibake og Moodle i seg selv lager ingen tilbakestillingskopi. Er du SIKKER på at du ønsker å fortsette?';
$string['uninstalldelete'] = 'Alle data assosiert med modulen <em>{$a->name}</em> er slettet fra databasen. For å forhindre at modulen reinstallerer seg selv må mappen  <em>{$a->rootdir}</em> nå fjernes manuelt fra serveren. Moodle kan ikke på egen hånd fjerne mappen på grunn av manglende skriverettigheter.';
$string['uninstalldeleteconfirm'] = 'Alle data assosiert med modulen <em>{$a->name}</em> er slettet fra databasen. For å forhindre at modulen reinstallerer seg selv må mappen  <em>{$a->rootdir}</em> nå fjernes fra serveren. Ønsker du å fjerne mappen nå?';
$string['uninstalldeleteconfirmexternal'] = 'Det ser ut som om gjeldelde versjon av modulen er lagt til via kildehåndteringssystemet ({$a}). Hvis du fjerner modulmappen kan det være at du mister viktige lokale modifikasjoner av koden. Vennligst vær sikker på at du virkelig ønsker å fjerne modulmappen FØR du fortsetter.';
$string['uninstallextraconfirmblock'] = 'Denne blokken er brukt {$a->instances} ganger.';
$string['uninstallextraconfirmenrol'] = 'Det er {$A->enrolments} innmeldt brukere.';
$string['uninstallextraconfirmmod'] = 'Denne modulen er brukt {$a->instances} ganger i {$a->courses} kurs.';
$string['uninstalling'] = 'Avinstallerer {$a->name}';
$string['updateavailable'] = 'En ny versjon {$a} er tilgjengelig!';
$string['updateavailable_moreinfo'] = 'Mer informasjon...';
$string['updateavailable_release'] = 'Slipp {$a}';
$string['updatepluginconfirm'] = 'Bekreftelse på moduloppdatering';
$string['updatepluginconfirmexternal'] = 'Det ser ut til at den gjeldende versjonen av modulen har blitt skaffet via kildekodens administrasjonssystems ({$a}) utsjekk. Hvis du installerer denne oppdateringen, vil du ikke lenger kunne skaffe moduloppdateringer fra kildekodens administrasjonssystem. Vennligst forsikre deg om at du vil oppdatere modulen før du fortsetter.';
$string['updatepluginconfirminfo'] = 'Du er i ferd med å installere en ny versjon av modulen <strong>{$a->name}</strong>. En zip-pakke med versjonen {$a->version} av modulen vil bli lastet ned fra <a href="{$a->url}">{$a->url}</a> og pakket ut i din Moodleinstallasjon så den kan oppgraderes.';
$string['updatepluginconfirmwarning'] = 'Vennligst vær oppmerksom på at Moodle ikke automatisk vil lage en sikkerhetskopi av databasen din før oppgraderingen. Vi anbefaler sterkt at du tar en fullstendig sikkerhetskopi nå, for å kunne hanskes med det sjeldne tilfellet at den nye koden har feil som gjør portalen din utilgjengelig eller ødelegger databasen. Fortsett på egen risiko.';
$string['version'] = 'Versjon';
$string['versiondb'] = 'Gjeldende versjon';
$string['versiondisk'] = 'Ny versjon';
