<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Godta';
$string['accept_grades'] = 'Godta karakterer fra verktøyet';
$string['accept_grades_admin'] = 'Godta karakterer fra verktøyet';
$string['accept_grades_admin_help'] = 'Angi hvorvidt verktøytilbyder kan legge til, oppdatere, lese og slette karakterer koblet med instanser av denne verktøytypen.

Noen verktøytilbydere støtter tilbakerapportering av karakterer til Moodle basert på handlinger i verktøyet. Dette gjør det til en mer integrert læringsressurs.';
$string['accept_grades_help'] = 'Angi hvorvidt verktøytilbyder kan legge til, oppdatere, lese og slette karakterer koblet med instanser av denne verktøytypen.

Noen verktøytilbydere støtter tilbakerapportering av karakterer til Moodle basert på handlinger i verktøyet. Dette gjør det til en mer integrert læringsressurs.

Merk at denne innstillngen kan overstyres i innstillingene til verktøyet.';
$string['action'] = 'Handling';
$string['active'] = 'Aktiv';
$string['activity'] = 'Aktivitet';
$string['addnewapp'] = 'Aktiver ekstern applikasjon';
$string['addserver'] = 'Legg til ny klarert server';
$string['addtype'] = 'Legg til eksternt verktøyoppsett';
$string['allow'] = 'Tillat';
$string['allowinstructorcustom'] = 'Tillat lærere å legge til egendefinerte innstillinger';
$string['allowsetting'] = 'Tillat verktøy å lagre 8K av innstillingene i Moodle';
$string['always'] = 'Alltid';
$string['automatic'] = 'Automatisk, basert på start-URL';
$string['baseurl'] = 'Base-URL';
$string['basiclti'] = 'LTI';
$string['basicltiactivities'] = 'LTI-aktiviteter';
$string['basiclti_base_string'] = 'LTI OAuth Base-streng';
$string['basiclti_endpoint'] = 'LTI start sluttpunkt';
$string['basicltifieldset'] = 'Egendefinert eksempel på feltsett';
$string['basiclti_in_new_window'] = 'Din aktivitet har åpnet i et nytt vindu';
$string['basicltiintro'] = 'Beskrivelse av aktiviteten';
$string['basicltiname'] = 'Navnet på aktiviteten';
$string['basiclti_parameters'] = 'LTI startparametere';
$string['basicltisettings'] = 'Standard Læringsverktøy interoperabilitetsinnstillinger';
$string['cannot_delete'] = 'Du bør ikke slette dette verktøyoppsettet';
$string['cannot_edit'] = 'Du bør ikke endre dette verktøyoppsettet';
$string['comment'] = 'Kommentar';
$string['configpassword'] = 'Standard passord for eksternt verktøy';
$string['configpreferheight'] = 'Standardverdi for høyde';
$string['configpreferwidget'] = 'Angi widget som standard start';
$string['configpreferwidth'] = 'Standardverdi for bredde';
$string['configresourceurl'] = 'Standard URL for ressurs';
$string['configtoolurl'] = 'Standard URL for eksternt verktøy';
$string['configtypes'] = 'Aktivér LTI-applikasjoner';
$string['courseid'] = 'Kurs ID-nummer';
$string['coursemisconf'] = 'Kurset er feilkonfigurert';
$string['course_tool_types'] = 'Verktøytyper for kurs';
$string['createdon'] = 'Opprettet';
$string['curllibrarymissing'] = 'PHP Curl-biblioteket må være installert for å bruke LTI';
$string['custom'] = 'Egendefinerte parametere';
$string['custom_config'] = 'Bruker egendefinerte innstillinger for verktøy.';
$string['custom_help'] = 'Egendefinerte parametre er innstillinger som brukes av verktøytilbyderen. F.eks. kan en egendefinert parameter bli brukt til å vise en bestemt ressurs fra tilbyderen.

Det er trygt å la feltet være uendret, så sant ikke verktøytibyderen anbefaler noe annet.';
$string['custominstr'] = 'Egendefinerte parametere';
$string['debuglaunch'] = 'Feilsøking';
$string['debuglaunchoff'] = 'Feilsøkingmodus av';
$string['debuglaunchon'] = 'Feilsøkingmodus på';
$string['default'] = 'Standard';
$string['default_launch_container'] = 'Standard oppstartsbeholder';
$string['default_launch_container_help'] = 'Oppstartsbeholderen har betydning for visningen av verktøyet når det startes fra kurset. Noen oppstartsbeholdere overfører mer av visningskontrollen til verktøyet, mens andre tilbyr en mer integrert visning i pakt med Moodles måte å vise kurs på.

* **Standard** - Bruk oppstartsbeholderen som angis i verktøyoppsettet.
* **Innebygget** - Verktøyet vises på Moodle-siden på samme måte som de fleste andre aktivitetstypene.
* **Innebygget - uten blokker** - Verktøyet vises på Moodle-siden og bare med  standard navigasjon i toppteksten.
* **Nytt vindu** - Verktøyet åpnes i et eget vindu og fyller skjermen.
Avhengig av nettleseren vil vinduet åpnes enten i en ny fane eller et pop-up vindu.
Det er også mulig at nettleseren vil forhindre  at et nytt vindu åpnes, så sjekk det.';
$string['delegate'] = 'Deleger til Lærer';
$string['delete'] = 'Slett';
$string['delete_confirmation'] = 'Er du sikker på at du vil slette dette eksterne verktøyoppsettet?';
$string['deletetype'] = 'Slett eksternt verktøyoppsett';
$string['display_description'] = 'Vis beskrivelsen av aktiviteten når den starter';
$string['display_description_help'] = 'Hvis denne funksjonen er valgt kommer beskrivelsen av aktiviteten (beskrevet over) til å vises over verktøytilbyderens innhold.

Beskrivelsen kan brukes til å skaffe ekstra instruksjoner for programmer som starter verktøyet, men det er ikke påkrevd.

Beskrivelsen blir aldri vist når verktøyets oppstartsbeholder er i et nytt vindu.';
$string['display_name'] = 'Vis navnet på aktiviteten når den starter';
$string['display_name_help'] = 'Hvis denne funksjonen er valgt kommer navnet på aktiviteten (angitt over) til å vises over verktøytilbyderens innhold.

Det er mulig at verktøytilbyderen også vil vise tittelen. Dette alternativet kan forhindre at tittelen på aktiviteten blir vist to ganger.

Tittelen blir aldri vist når verktøyets oppstartsbeholder er i et nytt vindu.';
$string['domain_mismatch'] = 'Oppstart-URLens domene er ikke i samsvar med verktøyoppsettet.';
$string['donot'] = 'Ikke send';
$string['donotaccept'] = 'Ikke ta imot';
$string['donotallow'] = 'Ikke tillat';
$string['edittype'] = 'Rediger eksternt verktøyoppsett';
$string['embed'] = 'Innebygg (embed)';
$string['embed_no_blocks'] = 'Innebygg (embed), uten blokker';
$string['enableemailnotification'] = 'Send epost-varsler';
$string['enableemailnotification_help'] = 'Hvis denne funksjonen er aktivert kommer studentene til å få epost-varsler når deres innleveringer til verktøyet er blitt karaktersatt.';
$string['errormisconfig'] = 'Feilkonfigurert verktøy. Kontakt din Moodle-administrator for å rette opp innstillingene for verktøyet.';
$string['extensions'] = 'Tjenester for LTI-filtypen';
$string['external_tool_type'] = 'Ekstern verktøytype';
$string['external_tool_type_help'] = 'Hovedhensikten med verktøyoppsettet er å sette opp en sikker kommunikasjonskanal mellom Moodle og verktøytilbyderen. Den gir også muligheten for standardinnstillinger og å sette opp ekstra tjenester som verktøyet tilbyr.

* **Automatisk, basert på oppstart-UR URL** - Denne innstillingen bør brukes i så godt som alle tilfeller. Moodle velger den mest passende verktøyoppsett basert på oppstart-URLen. Verktøy som er konfigurert av en administrator eller inne i dette kurset vil bli brukt. Når oppstart-URLen er oppgitt gir Moodle tilbakemelding om Moodle gjenkjenner den eller ikke. Hvis Moodle ikke kjenner igjen oppstart-URLen, kan det hende at du må taste inn verktøyoppsettdetaljene manuelt.
* **En bestemt type verktøy** - Ved å velge en bestemt type verktøy, kan du tvinge Moodle til å bruke det verktøyoppsettet når det kommuniserer med den eksterne verktøytilbyderen. Hvis oppstart-URLen ikke ser ut til å komme fra verktøytilbyderen, vil en advarsel komme opp. I noen tilfeller er det ikke nødvendig å skrive inn noen oppstart-URL når en bestemt type verktøy er angitt (hvis ikke du starter til en bestemt ressurs inne i verktøytilbyderen).
* **Tilpasset oppsett** - For å stille inn på tilpasset verktøyoppsett på bare dette tilfellet, vis Avanserte valg, og skriv inn forbrukerpassordet og den delte hemmelige strengen selv. Hvis du ikke har noen forbrukerpassord og delt hemmelig streng, kan det være at du kan få dem oppgitt av verktøytilbyderen. Ikke alle verktøy krever forbrukerpassord og delt hemmelig streng. I disse tilfellene kan feltene stå blanke.

 ### Redigering av verktøytype

Tre ikoner kan velges etter Nedtrekkslisten med eksterne verktøytyper:

* **Legg til** - Opprett en verktøyoppsett på kursnivå. Alle Eksterne verktøy i dette kurset kan bruke oppsettet.
* **Rediger** - Velg en verktøytype på kursnivå fra nedtrekksmenyen. Klikk så på dette ikonet. Detaljene i verktøyoppsettet kan redigeres.
* **Slett** - Fjern den valgte verktøytypen på kursnivå.';
$string['external_tool_types'] = 'Eksterne verktøytyper';
$string['failedtoconnect'] = 'Moodle kunne ikke kommunisere med "{$a}"systemet.';
$string['filter_basiclti_configlink'] = 'Konfigurer dine foretrukne portaler og tilhørende passord.';
$string['filter_basiclti_password'] = 'Passord er obligatorisk.';
$string['filterconfig'] = 'LTI-administrasjon';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Bruk et eksisterende oppsett for det feilkonfigurerte tilfellet.';
$string['fixnew'] = 'Nytt oppsett';
$string['fixnewconf'] = 'Angi et nytt oppsett for det feilkonfigurerte tilfellet.';
$string['fixold'] = 'Bruk eksisterende';
$string['forced_help'] = 'Denne innstillingen er satt som tvungen i et verktøyoppsett på kurs- eller portalnivå. Du kan ikke endre den fra dette grensesnittet.';
$string['force_ssl'] = 'Tving SSL';
$string['force_ssl_help'] = 'Hvis du velger denne funksjonen, vil alle oppstarter til denne verktøytilbyderen bli tvunget til å bruke SSL.

I tillegg vil alle webtjeneste-forespørsler fra denne verktøytilbyderen bruke SSL.

Hvis du bruker denne funksjonen, vennligst bekreft at denne Moodleportalen og verktøytilbyderen støtter SSL.';
$string['generaltool'] = 'Generelt verktøy';
$string['global_tool_types'] = 'Globale verktøytyper';
$string['grading'] = 'Karaktersøking';
$string['icon_url'] = 'Ikon-URL';
$string['icon_url_help'] = 'Ikon-URLen lar deg endre ikonet som vises i kurslisten for denne aktiviteten. I stedet for å bruke standard LTI-ikonet, kan et ikon som formidler typen aktivitet angis.';
$string['id'] = 'ID';
$string['invalidid'] = 'LTI-IDen var feil';
$string['launch_in_moodle'] = 'Oppstartsverktøyet i moodle';
$string['launchinpopup'] = 'Oppstartsbeholder';
$string['launch_in_popup'] = 'Oppstartsverktøyet i en popup';
$string['launchinpopup_help'] = 'Oppstartsbeholderen påvirker visningen av verktøyet når det blir åpnet fra kurset. Noen oppstartsbeholdere gir mer skjermplass til verktøyet, og andre gir en mer integrert opplevelse med Moodleomgivelsene.


* **Standard** - Bruk oppstartsbeholderen som er angitt i verktøyoppsettet. * **Innebygd** - Verktøyet vises inni Moodle-vinduet, på en måte som er lik de fleste andre aktivitetstyper. * **Innebygd, uten blokker** - Verktøyet vises inni Moodle-vinduet, med bare navigasjonskontrollen på toppen av siden. * **Nytt vindu** - Verktøyet åpnes i et nytt vindu som tar opp all tilgjengelig plass. Det vil åpnes i en ny fane eller et popup-vindu, avhengig av nettleseren. Det er mulig at noen nettlesere kan hindre det nye vinduet fra å åpne.';
$string['launchoptions'] = 'Oppstartsalternativer';
$string['launch_url'] = 'Oppstarts-URL';
$string['launch_url_help'] = 'Oppstarts-URLen viser nettadressen til det eksterne verktøyet, og kan inneholde tilleggsopplysninger, som for eksempel ressursen som skal vises. Hvis du er usikker på hva du skal skrive inn som oppstarts-URL, vennligst sjekk med verktøytilbyderen for mer informasjon.

Hvis du har valgt en bestemt verktøytype, kan det hende at du ikke trenger å skrive inn noen oppstarts-URL. Dette er ofte tilfelle hvis verktøylenken er brukt til å starte inn i verktøytilbyderens system og ikke til å gå til en bestemt ressurs.';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Legg til kursspesifikke verktøykonfigurasjoner';
$string['lti:addinstance'] = 'Legg til ny LTI-aktivitet';
$string['lti_administration'] = 'LTI-administrasjon';
$string['lti_errormsg'] = 'Verktøyet genererte følgende feilmelding: "{$a}"';
$string['lti:grade'] = 'Vis karakterer returnert fra LTI-aktiviteter';
$string['lti_launch_error'] = 'En feil oppstod da det eksterne verktøyet ble startet:';
$string['lti_launch_error_tool_request'] = '<p>
For å sende en forespørsel til en administrator om å fullføre oppsettet av verktøyet, klikk <a href="{$a->admin_request_url}" target="_top">her</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p> Denne feilen kan være et resultat av manglende forbrukernøkkel og delt hemmelig streng til verktøytilbyderen. </p> <p> Hvis du har en brukernøkkel og delt hemmelig streng, kan du skrive det inn når du redigerer tilfellet i det eksterne verktøyet (forsikre deg om at avanserte valg er synlige).<br /> En annen mulighet er å opprette et verktøytilbyderoppsett på kursnivå <a href="{$a->course_tool_editor}">here</a>. </p>';
$string['lti:manage'] = 'Bli instruktør når verktøyet startes';
$string['lti:requesttooladd'] = 'Send et verktøy som skal konfigureres til administrator';
$string['lti_tool_request_added'] = 'Forespørselen om verktøyinnstillinger er sendt. Det kan hende at du må kontakte en administrator for å fullføre verktøyoppsettet.';
$string['lti_tool_request_existing'] = 'En forespørsel om verktøyinnstillinger for verktøydomenet har allerede blitt sendt.';
$string['ltiunknownserviceapicall'] = 'LTI ukjent API-service kall';
$string['lti:view'] = 'Start LTI-aktiviteter';
$string['main_admin'] = 'Generell hjelp';
$string['main_admin_help'] = 'Eksterne verktøy gir Moodlebrukere muligheten til å kommunisere med og bruke læringsressurser som hostes eksternt. Gjennom en spesiell startprotokoll gis det eksterne verktøyet tilgang til generell informasjon om brukeren som starter det. Eksempler på informasjon som deles med verktøyet kan være navn på institusjon, kurs-ID, bruker-ID, og annen informasjon som for eksempel brukernavn eller epostadresse.

Verktøytypene som vises på denne siden kan deles opp i tre kategorier:

* **Aktive** - Disse verktøytilbyderne har blitt godkjent og konfigurert av en administrator. De kan brukes i hvilket som helst kurs på denne Moodleinstallasjonen. Hvis en forbrukernøkkel og delt hemmelig streng blir fastsatt, etablerer dette et tillitsforhold mellom denne Moodleinstallasjonen og det eksterne verktøyet, som igjen gir en sikker kanal for kommunikasjon.
* **På vent** - Disse verktøytilbyderne har blitt importert som en del av en pakke, men har ikke blitt konfigurert av noen administrator. Lærere kan fortsatt bruke verktøy fra disse tilbyderne hvis de har en forbrukernøkkel og delt hemmelig streng, eller hvis forbrukernøkkel/hemmelig streng ikke er påkrevd.
* **Avvist** - Disse verktøytilbyderne er merket som tilbydere som en administrator ikke har til hensikt å gjøre tilgjengelige for hele Moodleinstallasjonen. Lærere kan fortsatt bruke verktøy fra disse tilbyderne hvis de har en forbrukernøkkel og delt hemmelig streng, eller hvis forbrukernøkkel/hemmelig streng ikke er påkrevd.';
$string['miscellaneous'] = 'Diverse';
$string['misconfiguredtools'] = 'Feilkonfigurerte verktøy funnet';
$string['missingparameterserror'] = 'Denne siden er feilkonfigurert: "{$a}"';
$string['module_class_type'] = 'Modultype i Moodle';
$string['modulename'] = 'Eksternt verktøy';
$string['modulename_help'] = 'Aktivitetsmodulen Eksternt verktøy lar studenter være interaktive med læringsressurser og aktiviteter på andre nettsteder. F.eks. kan et eksternt verktøy gi tilgang til en ny aktivitetstype eller læringsmateriell fra en utgiver.

For å opprette en aktivitet knyttet til et eksternt verktøy kreves det en verktøytilbyder som støtter LTI (learning Tools Interoperability). Lærere kan opprette en aktivitet knyttet til et eksternt verktøy eller benytte seg av verktøy som er satt opp av portaladministrator.

Aktiviteter knyttet til eksterne verktøy skiller seg ut fra URL-ressurser på følgende måte:

*Eksterne verktøy har kjennskap til konteksten de blir brukt i. Dvs. at de har tilgang til informasjon om brukeren som startet verktøyet, som f.eks. institusjon, kurs og navn.
* Eksterne verktøy støtter lesing, oppdatering og sletting av karakterer som er knyttet til aktiviteten.
* Oppsett av eksterne verktøy skaper et tillitsforhold mellom din portal og verktøytilbyderen; sikker kommunikasjon mellom partene er mulig.';
$string['modulenameplural'] = 'Ekstern verktøy';
$string['modulenamepluralformatted'] = 'LTI-forekomster';
$string['never'] = 'Aldri';
$string['new_window'] = 'Nytt vindu';
$string['noattempts'] = 'Ingen forsøk har blitt gjort på dette verktøyet.';
$string['no_lti_configured'] = 'Det er ingen aktive konfigurerte Eksterne verktøy';
$string['no_lti_pending'] = 'Det er ingen Eksterne verktøy på vent';
$string['no_lti_rejected'] = 'Det er ingen avviste Eksterne verktøy';
$string['noltis'] = 'Det er ingen LTI-forekomster';
$string['noservers'] = 'Ingen servere funnet';
$string['notypes'] = 'Det er for øyeblikket ingen LTI-verktøyoppsett i Moodle. Klikk på Installer-lenken ovenfor for å legge til noen.';
$string['noviewusers'] = 'Ingen brukere med tillatelse til å bruke dette verkøyet ble funnet.';
$string['optionalsettings'] = 'Valgfrie innstillinger';
$string['organization'] = 'Informasjon om organisasjonen';
$string['organizationdescr'] = 'Beskrivelse av organisasjonen';
$string['organizationid'] = 'Organisasjonens ID';
$string['organizationid_help'] = 'En unik ID for denne Moodleinstallasjonen. Vanligvis brukes DNS-navnet til organisasjonen (domain name system).

Hvis du lar dette feltet stå tomt, vil vertsnavnet på Moodleportalen brukt som standardverdi.';
$string['organizationurl'] = 'Organisasjonens URL';
$string['organizationurl_help'] = 'Basis-URLen til denne Moodleinstallasjonen.

Hvis du lar dette feltet stå tomt, vil en standardverdi basert på portalinnstillingene bli brukt.';
$string['pagesize'] = 'Antall innleveringer som vises på hver side';
$string['password'] = 'Delt hemmelig streng';
$string['password_admin'] = 'Delt hemmelig streng';
$string['password_admin_help'] = 'Den delte hemmelige strengen kan betraktes som et passord som skal brukes til å autentisere tilgang til verktøyet. Det skal oppgis sammen med forbrukernøkkelen fra verktøytilbyderen.

Det kan være at verktøy som ikke er avhengig av sikker kommunikasjon fra Moodle og som ikke gir tilleggstjenester (som for eksempel karakterrapportering) ikke krever en delt hemmelig streng.';
$string['password_help'] = 'For forhåndskonfigurerte verktøy er det ikke nødvendig å skrive inn noen delt hemmelig streng her, siden den delte hemmelige strengen vil bli oppgitt som en del av prosessen med å sette opp verktøyet.

Dette feltet skal fylles ut hvis du skal lage en lenke til en verktøytilbyder som ikke allerede er konfigurert.
Hvis verktøytilbyderen skal brukes mer enn en gang i dette kurset er det en god ide å legge til et verktøyoppsett.

Den delte hemmelige strengen kan betraktes som et passord som brukes til å autentisere tilgang til verktøyet. Det skal oppgis sammen med forbrukernøkkelen fra verktøytilbyderen.

Det kan være at verktøy som ikke trenger sikker kommunikasjon fra Moodle og som ikke tilbyr tilleggstjenester (som for eksempel karakterrapportering) ikke krever noen delt hemmelig streng.';
$string['pending'] = 'På vent';
$string['pluginadministration'] = 'LTI-administrasjon';
$string['pluginname'] = 'LTI';
$string['preferheight'] = 'Standardverdi for høyde';
$string['preferwidget'] = 'Standardverdi for oppstart av Widget';
$string['preferwidth'] = 'Standardverdi for bredde';
$string['press_to_submit'] = 'Trykk for å starte denne aktiviteten';
$string['privacy'] = 'Personvern';
$string['quickgrade'] = 'Tillat hurtig karaktersetting';
$string['quickgrade_help'] = 'Hvis denne funksjonen er aktivert, kan det legges til karakter på flere verktøy på en side. Legg til karakterer og kommentarer og klikk så på knappen "Lagre alle mine tilbakemeldinger" for å lagre alle endringene på siden.';
$string['redirect'] = 'Om noen sekunder vil du bli omdirigert. Hvis ikke dette skjer, må du trykke på knappen.';
$string['reject'] = 'Avvis';
$string['rejected'] = 'Avvist';
$string['resource'] = 'Ressurs';
$string['resourcekey'] = 'Forbrukernøkkel';
$string['resourcekey_admin'] = 'Forbrukernøkkel';
$string['resourcekey_admin_help'] = 'Forbrukernøkkelen kan betraktes som et brukernavn som brukes til å autentisere tilgang til verktøyet. Det kan brukes av verktøytilbyderen for å identifisere Moodleportalen som brukerene starter verktøyet fra.

Forbrukernøkkelen får du oppgitt av verktøytilbyderen.Det varierer fra verktøytilbyder til verktøytilbyder hvordan du får tak i forbrukernøkkelen. Noen ganger kan det være en automatisk prosess, andre ganger er det nødvendig å opprette en dialog med verktøytilbyderen.

Det kan være at verktøy som ikke trenger sikker kommunikasjon fra Moodle og som ikke tilbyr tilleggstjenester (som for eksempel karakterrapportering) ikke krever noen ressursnøkkel.';
$string['resourcekey_help'] = 'For forhåndskonfigurerte verktøy er det ikke nødvendig å skrive inn noen forbrukernøkkel her, siden forbrukernøkkelen vil bli oppgitt som en del av prosessen med å sette opp verktøyet.

Dette feltet skal fylles ut hvis du skal lage en lenke til en verktøytilbyder som ikke allerede er konfigurert.
Hvis verktøytilbyderen skal brukes mer enn en gang i dette kurset er det en god ide å legge til et verktøyoppsett.

Forbrukernøkkelen kan betraktes som et brukernavn som brukes til å autentisere tilgang til verktøyet. Det kan brukes av verktøytilbyderen for å identifisere Moodleportalen som brukerene starter verktøyet fra.

Forbrukernøkkelen får du oppgitt av verktøytilbyderen. Det varierer fra verktøytilbyder til verktøytilbyder hvordan du får tak i forbrukernøkkelen. Noen ganger kan det være en automatisk prosess, andre ganger er det nødvendig å opprette en dialog med verktøytilbyderen.

Det kan være at verktøy som ikke trenger sikker kommunikasjon fra Moodle og som ikke tilbyr tilleggstjenester (som for eksempel karakterrapportering) ikke krever noen ressursnøkkel.';
$string['resourceurl'] = 'Ressursens URL';
$string['return_to_course'] = 'Klikk <a href="{$a->link}" target="_top">her</a> for å gå tilbake til kurset.';
$string['saveallfeedback'] = 'Lagre alle tilbakemeldingene mine';
$string['secure_icon_url'] = 'Sikker ikon-URL';
$string['secure_icon_url_help'] = 'Likner på ikon-URL, men brukes hvis brukeren får/har sikker adgang til Moodle gjennom SSL. Hovedhensikten med dette feltet er å forhindre nettleseren i å advare brukeren hvis den underliggende siden oppfordrer til å vise et usikkert bilde, når siden er gjort tilgjengelig over SSL.';
$string['secure_launch_url'] = 'Sikker oppstart-URL';
$string['secure_launch_url_help'] = 'Veldig lik oppstart-URL, men brukes i stedet for oppstart-URLen hvis det er nødvendig med høy sikkerhet. Moodle bruker den sikre oppstart-URLen i stedet for oppstart-URLen hvis tilgangen til Moodleportalen er gjennom SSL, eller hvis verktøyoppsettet er satt til å alltid starte gjennom SSL.

Oppstart-URLen kan også settes til en https-adresse for å tvinge start gjennom SSL. Dette feltet kan også stå tomt.';
$string['send'] = 'Send';
$string['setupoptions'] = 'Valg for oppsett';
$string['share_email'] = 'Oppgi navnet til brukeren (som starter verktøyet) til verktøyet';
$string['share_email_admin'] = 'Oppgi navnet til brukeren (som starter verktøyet) til verktøyet';
$string['share_email_admin_help'] = 'Angi hvorvidt epostadressen til brukeren som starter verktøyet skal oppgis til verktøytilbyderen.
Det kan være at verktøytilbyderen trenger epostadressene til personene som starter verktøyet for å kunne skille mellom brukere med samme navn, eller sende eposter til brukere, basert på handlinger inne i verktøyet.';
$string['share_email_help'] = 'Angi hvorvidt epostadressen til brukeren som starter verktøyet skal oppgis til verktøytilbyderen.
Det kan være at verktøytilbyderen trenger epostadressene til personene som starter verktøyet for å kunne skille mellom brukere med samme navn, eller sende eposter til brukere, basert på handlinger inne i verktøyet.

Vær oppmerksom på at denne innstillingen kan overstyres i verktøyinnstillingene.';
$string['share_name'] = 'Oppgi navnet til personen som starter verktøyet til verktøyet.';
$string['share_name_admin'] = 'Oppgi navnet til personen som starter verktøyet til verktøyet.';
$string['share_name_admin_help'] = 'Angi hvorvidt det fulle navnet til brukeren som starter verktøyet skal oppgis til verktøytilbyderen.
Det kan være at verktøytilbyderen trenger navnene til personene som starter verktøyet for å kunne vise meningsfull informasjon inne i verktøyet.';
$string['share_name_help'] = 'Angi om det fulle navnet til brukeren som starter verktøyet skal oppgis til verktøytilbyderen.
Det kan være at verktøytilbyderen trenger navnene til personene som starter verktøyet for å kunne vise meningsfull informasjon inne i verktøyet.

Vær oppmerksom på at denne innstillingen kan overstyres i verktøyinnstillingene.';
$string['share_roster'] = 'Gi verktøyet tilgang til dette kursets liste over brukere';
$string['share_roster_admin'] = 'Verktøyet kan ha tilgang til listen over brukere';
$string['share_roster_admin_help'] = 'Angi om verktøyet skal få tilgang til listen over brukere som er påmeldt kurset.';
$string['share_roster_help'] = 'Angi om verktøyet skal få tilgang til listen over brukere som er påmeldt kurset.

Vær oppmerksom på at denne innstillingen kan overstyres i verktøyinnstillingene.';
$string['show_in_course'] = 'Vis verktøytypen når verktøyinstanser blir opprettet.';
$string['show_in_course_help'] = 'Hvis det er valgt kommer dette verktøyoppsettet til å vises i "Ekstern verktøytype"-nedtrekksmenyen når lærere setter opp verktøy inni kurs.

I de fleste tilfelller trenger ikke denne funksjonen å være valgt. Lærere kan bruke dette verktøyoppsettet basert på at start-URLen samsvarer med Verktøyets basis-URL, som er den foretrukne metoden.

Det eneste tilfellet denne funksjonen burde velges er når verktøyoppsettet er kun ment for Single Sign On: For eksempel, hvis oppstarten av verktøytilbyderen kun tar brukeren til en destinasjonsside i stedet for til en bestemt ressurs.';
$string['size'] = 'Størrelseparametere';
$string['submission'] = 'Innlevering';
$string['submissions'] = 'Innsendelser';
$string['submissionsfor'] = 'Innleveringer for {$a}';
$string['subplugintype_ltisource'] = 'LTI-kilde';
$string['subplugintype_ltisource_plural'] = 'LTI-kilder';
$string['toggle_debug_data'] = 'Bytte om på feilsøkingsdata';
$string['tool_config_not_found'] = 'Fant ingen verktøyoppsett for denne URL-en';
$string['tool_settings'] = 'Verktøyinnstillinger';
$string['toolsetup'] = 'Eksternt verktøyoppsett';
$string['toolurl'] = 'Verktøyets basis-URL';
$string['toolurl_help'] = 'Verktøyets basis-URL brukes til å matche verktøyets start-URL med det rette verktøyoppsettet. Å sette http(s) foran URLen er valgfritt. I tillegg brukes basis-URLen som start-URL hvis en start-URL ikke er angitt i den eksterne verktøyinstansen. <table> <thead> <tr> <td> <b>Base URL</b> </td> <td> <b>Matches</b> </td> </tr> </thead> <tbody> <tr> <td> tool.com </td> <td> tool.com, tool.com/quizzes, tool.com/quizzes/quiz.php?id=10, www.tool.com/quizzes </td> </tr> <tr> <td> www.tool.com/quizzes </td> <td> tool.com/quizzes, tool.com/quizzes/take.php?id=10, www.tool.com/quizzes </td> </tr> <tr> <td> quiz.tool.com </td> <td> quiz.tool.com, quiz.tool.com/take.php?id=10 </td> </tr> </tbody> </table> Hvis to forskjellige verktøyoppsett er for samme domene, brukes den som passer best.';
$string['typename'] = 'Navn på verktøyet';
$string['typename_help'] = 'Navnet på verktøyet brukes til å identifisere verktøytilbyderen inne i Moodle. Navnet som skrives inn kommer til å være synlig for lærere når eksterne verktøy blir lagt til inni kurs.';
$string['types'] = 'Typer';
$string['update'] = 'Oppdatering';
$string['using_tool_configuration'] = 'Bruker verktøyoppsett:';
$string['validurl'] = 'Gyldig URL må starte med http(s)://';
$string['viewsubmissions'] = 'Vis innleveringer og karakterskjermbildet';
