<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Tilgangskontroll';
$string['actionaftercorrectanswer'] = 'Handling etter riktig svar';
$string['actionaftercorrectanswer_help'] = 'Etter å ha oppgitt riktig svar på et spørsmål er det 3 valg for neste side:

* Normal - Følg leksjonsstrukturen
* Vis en usett side - Sider vises i tilfeldig rekkefølge uten å vise noen sider mer enn en gang
* Vis en ubesvart side - Sider vises i tilfeldig rekkefølge, og sider som inneholder ubesvarte spørsmål vises igjen';
$string['actions'] = 'Handlinger';
$string['activitylink'] = 'Lenke til neste aktivitet';
$string['activitylink_help'] = '<p>Listeboksmenyen inneholder alle aktivitetene i dette kurset. Dersom en velges vil det opprettes en lenke til denne på siste side i leksjonen.</p>';
$string['activitylinkname'] = 'Gå til {$a}';
$string['activityoverview'] = 'Du har leksjoner som må tas';
$string['addabranchtable'] = 'Legg til en innholdsside';
$string['addanendofbranch'] = 'Legg til avslutning på gren';
$string['addanewpage'] = 'Legg til ny side';
$string['addaquestionpage'] = 'Legg til en spørsmålsside';
$string['addaquestionpagehere'] = 'Legg til en spørsmålsside her';
$string['addbranchtable'] = 'Legg til en innholdsside';
$string['addcluster'] = 'Legg til klynge';
$string['addedabranchtable'] = 'La til en innholdsside';
$string['addedanendofbranch'] = 'La til avslutning på gren';
$string['addedaquestionpage'] = 'La til spørsmålside';
$string['addedcluster'] = 'La til klynge';
$string['addedendofcluster'] = 'La til klyngeavslutning';
$string['addendofcluster'] = 'Legg til klyngeavslutning';
$string['addpage'] = 'Legg til en side';
$string['anchortitle'] = 'Begynnelsen på hovedinnholdet';
$string['and'] = 'OG';
$string['answer'] = 'Svaralternativ';
$string['answeredcorrectly'] = 'riktig besvart.';
$string['answersfornumerical'] = 'Svar på numeriske spørsmål bør være sammenfallende par med minimums- og maksimumsverdier';
$string['arrangebuttonshorizontally'] = 'Skal knapper til innholdssider plasseres horisontalt?';
$string['attempt'] = 'Forsøk: {$a}';
$string['attempts'] = 'Forsøk';
$string['attemptsdeleted'] = 'Slettede forsøk';
$string['attemptsremaining'] = 'Du har {$a} forsøk igjen';
$string['available'] = 'Tilgjengelig fra';
$string['averagescore'] = 'Gjennomsnittspoengsum';
$string['averagetime'] = 'Gjenomsnittstid';
$string['branch'] = 'Forgreining';
$string['branchtable'] = 'Innholdsside';
$string['cancel'] = 'Avbryt';
$string['cannotfindanswer'] = 'Feil; kunne ikke finne svaret';
$string['cannotfindattempt'] = 'Feil; kunne ikke finne forsøket';
$string['cannotfindessay'] = 'Feil: kunne ikke finne essayet';
$string['cannotfindfirstgrade'] = 'Feil: kunne ikke finne noen karakterer';
$string['cannotfindfirstpage'] = 'Kunne ikke finne første side';
$string['cannotfindgrade'] = 'Feil: Kunne ikke finne karakterer';
$string['cannotfindnewestgrade'] = 'Feil: Kunne ikke finne nyeste karakter';
$string['cannotfindnextpage'] = 'Leksjon sikkerhetskopi: Neste side ikke funnet!';
$string['cannotfindpagerecord'] = 'Legg til slutten på grenen: side ikke funnet';
$string['cannotfindpages'] = 'Fant ingen leksjonsider';
$string['cannotfindpagetitle'] = 'Bekreft sletting: Sidetittel ikke funnet';
$string['cannotfindpreattempt'] = 'Forrige forsøk ble ikke funnet';
$string['cannotfindrecords'] = 'Feil: kunne ikke finne leksjondata';
$string['cannotfindtimer'] = 'Feil: kunne ikke finne data om leksjon_timer';
$string['cannotfinduser'] = 'Feil: kunne ikke finne brukere';
$string['canretake'] = '{$a} kan forsøke på nytt';
$string['casesensitive'] = 'Skiller mellom store/små bokstaver';
$string['casesensitive_help'] = 'Merk av her for å bruke regulære uttrykk i analysen av responser.';
$string['checkbranchtable'] = 'Sjekk menytabell';
$string['checkedthisone'] = 'Sjekket denne.';
$string['checknavigation'] = 'Sjekk navigering';
$string['checkquestion'] = 'Sjekk spørsmål';
$string['classstats'] = 'Deltakerstatistikk';
$string['clicktodownload'] = 'Klikk denne lenken for å laste ned filen.';
$string['clicktopost'] = 'Klikk her for å sende karakterene dine til lista over de beste resultatene.';
$string['cluster'] = 'Gruppe';
$string['clusterjump'] = 'Usett spørsmål inne i ei klynge';
$string['clustertitle'] = 'Klynge';
$string['collapsed'] = 'Slått sammen';
$string['comments'] = 'Dine kommentarer';
$string['completed'] = 'Fullført';
$string['completederror'] = 'Fullfør leksjonen';
$string['completethefollowingconditions'] = 'Du må oppfylle disse betingelsene i leksjonen <b>{$a}</b> før du kan fortsette.';
$string['conditionsfordependency'] = 'Betingelser for avhengighet';
$string['configactionaftercorrectanswer'] = 'Standardhandling etter riktig svar';
$string['configmaxanswers'] = 'Standard maksimum antall svar/grener per side';
$string['configmaxhighscores'] = 'Antall rekorder som vises';
$string['configmediaclose'] = 'Viser en lukk-knapp som del av popup-vindu generert for en lenket mediafil';
$string['configmediaheight'] = 'Setter høyde på popupvindu vist for en lenket mediafil';
$string['configmediawidth'] = 'Setter bredde på popupvindu vist for en lenket mediafil';
$string['configslideshowbgcolor'] = 'Bakgrunnsfarge for slideshow hvis det er slått på';
$string['configslideshowheight'] = 'Setter høyde på slideshow hvis det er slått på';
$string['configslideshowwidth'] = 'Setter bredde på slideshow hvis det er slått på';
$string['confirmdelete'] = 'Slett side';
$string['confirmdeletionofthispage'] = 'Bekreft sletting av denne siden';
$string['congratulations'] = 'Gratulerer - du er ferdig med leksjonen';
$string['continue'] = 'Fortsett';
$string['continuetoanswer'] = 'Fortsett å endre svarene.';
$string['continuetonextpage'] = 'Fortsett til neste side.';
$string['correctanswerjump'] = 'Hopp ved riktig svar';
$string['correctanswerscore'] = 'Poeng ved riktig svar';
$string['correctresponse'] = 'Riktig svar';
$string['createaquestionpage'] = 'Lag en spørsmålsside';
$string['credit'] = 'Poeng';
$string['customscoring'] = 'Standard poengtildeling';
$string['customscoring_help'] = '<p>Denne innstillingen lar deg legge inn en numerisk verdi på hvert svar. Svaralternativene kan ha negative eller positive verdier. Importerte spørsmål vil automatisk tildeles verdien "1" for riktig svar og "0" for galt svar. Dette må du evt. endre på etter importen.</p>';
$string['deadline'] = 'Frist (dato og klokkeslett)';
$string['defaultessayresponse'] = 'Læreren din vil sette karakter på innleveringen din.';
$string['deleteallattempts'] = 'Slett alle leksjonforsøk';
$string['deletedefaults'] = 'Slettet {$a} x standardleksjon';
$string['deletedpage'] = 'Slettet side';
$string['deleting'] = 'Sletter';
$string['deletingpage'] = 'Sletter side: {$a}';
$string['dependencyon'] = 'Avhenger av';
$string['dependencyon_help'] = '<p>Denne innstillingen tillater gjeldende leksjon å være avhengig av studentens resultater i en annen leksjon i samme kurs. Dersom kravene ikke tilfredsstilles vil studenten ikke kunne fortsette med denne leksjonen.</p>

<p>Betingelsene for avhengighet omfatter:</p>

    <ul>
        <li><b>Tid brukt:</b> Studenten må ha brukt en minimumstid på påkrevd leksjon.</li>
        <li><b>Fullført:</b> Studenten må har fullført den påkrevde leksjonen.</li>
        <li><b>Karakter bedre enn:</b> Studenten må ha fått en karakter bedre enn grensen som er satt her.</li>
    </ul>
<p>    Enhver kombinasjon av ovenstående kan om ønskelig brukes.</p>';
$string['description'] = 'Beskrivelse';
$string['detailedstats'] = 'Detaljert statistikk';
$string['didnotanswerquestion'] = 'Svarte ikke på dette spørsmålet';
$string['didnotreceivecredit'] = 'Ingen poeng';
$string['displaydefaultfeedback'] = 'Vis standard tilbakemelding';
$string['displaydefaultfeedback_help'] = '<p>Dersom satt til <strong>Ja</strong> vil det, hver gang det ikke finnes egendefinert respons for et spørsmål, vises en standardmelding som; "Det var riktig svar" eller "Det var feil svar".</p>
<p>Dersom satt til <strong>Nei</strong> vil det, hver gang det ikke finnes egendefinert respons for et spørsmål, ikke vises noen tilbakemelding. Brukeren vil i stedet bli ført direkte til neste side i leksjonen.</p>';
$string['displayhighscores'] = 'Vis toppresultatene';
$string['displayinleftmenu'] = 'Vis i venstre meny?';
$string['displayleftif'] = 'og vis kun hvis karakteren bedre enn';
$string['displayleftif_help'] = 'Denne innstillingen avgjør hvorvidt en student må få en karakter før han ser venstre meny. Dette tvinger studenten til å gå gjennom hele leksjonen på første forsøk, så etter å ha fått karakter kan han bruke venstre meny for å se gjennom.';
$string['displayleftmenu'] = 'Vis venstre meny';
$string['displayleftmenu_help'] = 'Hvis aktivert, vises en sideoversikt på venstre side i leksjonen.';
$string['displayofgrade'] = 'Visning av karakter (kun for studenter)';
$string['displayreview'] = 'Tilby muligheten til å prøve et spørsmål en gang til';
$string['displayreview_help'] = '<p>Dette valget vil vise en knapp etter et feilaktiv besvart spørsmål og lar studenten prøve en gang til. Er ikke kompatibel med Fritekstspørsmål, så ikke aktiver denne hvis du bruker spørsmålstypen Fritekst.</p>';
$string['displayscorewithessays'] = '<p>Du fikk {$a->score} av {$a->tempmaxgrade} på de spørsmålene som ble regnet ut automatisk.</p>Teksten(e) du skrev som svar på {$a->essayquestions} vil bli vurdert av en lærer og lagt til den endelige karakteren din senere.</p><p>Karakteren din uten tekstvurdering er nå {$a->score} av {$a->grade} mulige.</p>';
$string['displayscorewithoutessays'] = 'Du har {$a->score} poeng (av {$a->grade}).';
$string['edit'] = 'Rediger';
$string['editingquestionpage'] = 'Redigerer {$a} spørsmålsside';
$string['editlessonsettings'] = 'Rediger innstillinger';
$string['editpage'] = 'Rediger sideinnhold';
$string['editpagecontent'] = 'Rediger sideinnhold';
$string['email'] = 'Send som epost';
$string['emailallgradedessays'] = 'Send alle tekster med karakter som epost.';
$string['emailgradedessays'] = 'Send tekster med karakter som epost';
$string['emailsuccess'] = 'Sending av epost var vellykket';
$string['emptypassword'] = 'Passorfeltet kan ikke være tomt';
$string['endofbranch'] = 'Slutt på gren';
$string['endofcluster'] = 'Slutt på gruppe';
$string['endofclustertitle'] = 'Slutt på klynge';
$string['endoflesson'] = 'Leksjonen er ferdig';
$string['enteredthis'] = 'skrev dette.';
$string['entername'] = 'Skriv inn et pseudonym for toppresultatlista';
$string['enterpassword'] = 'Skriv inn passordet';
$string['eolstudentoutoftime'] = 'OBS: Du brukte for lang tid på denne leksjonen. Det siste svaret ditt ble kanskje ikke tatt med i beregningen hvis du svarte etter at tiden hadde gått ut.';
$string['eolstudentoutoftimenoanswers'] = 'Du svarte ikke på noen spørsmål. Du fikk 0 poeng på denne leksjonen.';
$string['essay'] = 'Tekst';
$string['essayemailmessage'] = '<p>Essay prompt:<blockquote>{$a->question}</blockquote></p><p>Ditt svar:<blockquote><em>{$a->response}</em></blockquote></p><p>{$a->teacher} kommentarer:<blockquote><em>{$a->comment}</em></blockquote></p><p>Du fikk {$a->earned} av {$a->outof} på dette Essay-spørsmålet.</p><p>Karakteren din for leksjonen er blitt endret til {$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p>Essay ledetekst:<blockquote>{$a->question}</blockquote></p><p>Din respons:<blockquote><em>{$a->response}</em></blockquote></p><p>Lærers kommentarer:<blockquote><em>{$a->comment}</em></blockquote></p><p>Du har mottatt {$a->earned} av i alt {$a->outof} på dette essay-spørsmålet</p><p>Din karakter på denne leksjonen er endret til {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Karakteren din for {$a} spørsmål';
$string['essays'] = 'Tekster';
$string['essayscore'] = 'Tekstvurdering';
$string['fileformat'] = 'Filformat';
$string['finish'] = 'Avslutt';
$string['firstanswershould'] = 'Første svar skulle gå til siden "Riktig"';
$string['firstwrong'] = 'Dessverre kan du ikke få poeng på dette spørsmålet, da svaret ditt var feil. Vil du fortsette å gjette, bare for gleden ved å lære (men uten å få noen poeng)?';
$string['flowcontrol'] = 'Flytkontroll';
$string['full'] = 'Utvidet';
$string['general'] = 'Generelt';
$string['gotoendoflesson'] = 'Gå til slutten av leksjonen';
$string['grade'] = 'Karakter';
$string['gradebetterthan'] = 'Karakter bedre enn  (%)';
$string['gradebetterthanerror'] = 'Få en karakter som er bedre enn {$a} prosent';
$string['gradeessay'] = 'Gi karakterer til tekstoppgaver ({$a->notgradedcount} ennå ikke vurdert og {$a->notsentcount} ikke sendt)';
$string['gradeis'] = 'Karakteren er {$a}';
$string['gradeoptions'] = 'Karakteralternativer';
$string['handlingofretakes'] = 'Vurdering av gjentatte forsøk';
$string['handlingofretakes_help'] = '<p>Når studentene får ta leksjonen flere ganger, vil dette valget aktivere at karakteren skal vises i karakterboka; enten som gjennomsnitt av alle forsøk eller beste resultat.</p>

<p>Dette valget kan endres når som helst.</p>';
$string['havenotgradedyet'] = 'Ennå ikke vurdert.';
$string['here'] = 'her';
$string['highscore'] = 'Beste poengsum';
$string['highscores'] = 'Beste poengsummer';
$string['hightime'] = 'Beste tider';
$string['importcount'] = 'Henter inn {$a} spørsmål';
$string['importquestions'] = 'Hent inn spørsmål';
$string['importquestions_help'] = 'Denne funksjonen lar deg importere spørsmål fra eksterne tekstfiler - som du laster opp direkte.';
$string['insertedpage'] = 'Satte inn side';
$string['invalidfile'] = 'Ugyldig fil';
$string['invalidid'] = 'Ingen kursmodul ID eller leksjon-ID ble sendt';
$string['invalidlessonid'] = 'Leksjon er feil';
$string['invalidpageid'] = 'Ugyldig side-ID';
$string['jump'] = 'Hopp';
$string['jumps'] = 'Sprang';
$string['jumps_help'] = 'Hvert svar- eller beskrivelsesalternativ (på en innholdsside) har en Gå til-lenke. Når dette svaret velges vil svaralternativets respons vises for studenten. Etter dette blir de ført til den siden Gå til-lenken peker på. 
';
$string['jumpsto'] = 'Sprang til <em>{$a}</em>';
$string['leftduringtimed'] = 'Du har gått ut under en leksjon med tidtaking.<br/> Klikk på "Fortsett" for å starte på nytt';
$string['leftduringtimednoretake'] = 'Du har gått ut under en leksjon med tidtaking, og du får ikke begynne på nytt eller ta leksjonen om igjen.';
$string['leftduringtimedsession'] = 'Du har gått ut under en leksjon med tidtaking.';
$string['lesson:addinstance'] = 'Legg til en ny leksjon';
$string['lessonattempted'] = 'Leksjonen er forsøkt';
$string['lessonclosed'] = 'Denne leksjonen ble avsluttet den {$a}';
$string['lessoncloses'] = 'Leksjonen avsluttes';
$string['lessoncloseson'] = 'Leksjonen avslutter {$a}';
$string['lesson:edit'] = 'Rediger en aktivitet i leksjonen';
$string['lessonformating'] = 'Leksjonsformatering';
$string['lesson:manage'] = 'Administrer en aktivitet i leksjonen';
$string['lessonmenu'] = 'Leksjonsmeny';
$string['lessonnotready'] = 'Leksjonen er ikke klar for bruk. Ta kontakt med {$a}';
$string['lessonnotready2'] = 'Denne leksjonen er ikke klar til å tas';
$string['lessonopen'] = 'Denne leksjonen blir tilgjengelig den {$a}';
$string['lessonopens'] = 'Leksjonen blir tilgjengelig';
$string['lessonpagelinkingbroken'] = 'Fant ikke første side. Det må være noe galt med lenkene - ta kontakt med en administrator.';
$string['lessonstats'] = 'Leksjonstatistikk';
$string['linkedmedia'] = 'Lenket media';
$string['loginfail'] = 'Innlogging mislykka. Prøv igjen...';
$string['lowscore'] = 'Dårlige resultater';
$string['lowtime'] = 'Svak tid';
$string['manualgrading'] = 'Vurder essayene';
$string['matchesanswer'] = 'Kobling med svar';
$string['matching'] = 'Tilhørende';
$string['matchingpair'] = 'Matchende sett {$a}';
$string['maxgrade'] = 'Maksimum karakter';
$string['maxgrade_help'] = '<p>Denne verdien bestemmer maksimum karakter for denne leksjonen. Skalaen er fra 0-100%. Denne verdien kan endres når som helst, selv om flere har gjennomført leksjonen. Alle endringer vil omgående bli oppdatert i karakterboka og karakteren som vises for studentene på forskjellige oversikter. Dersom karakteren settes til 0 vil ikke leksjonen vises i karakterboka.</p>';
$string['maxhighscores'] = 'Antallet toppresultater som skal vises';
$string['maximumnumberofanswersbranches'] = 'Maksimum antall svar/forgreininger';
$string['maximumnumberofanswersbranches_help'] = 'Denne innstillingen angir maks antall svar som kan brukes i leksjonen. Dersom det bare er sant/usant-spørsmål i leksjonen kan den settes til -2-. Innstillingen kan endres når sopm helst siden den bare har betydning for hva læreren ser - ikke dataene som er lagret.';
$string['maximumnumberofattempts'] = 'Maksimum antall forsøk';
$string['maximumnumberofattempts_help'] = 'Dette valget bestemmer maks antall studentforsøk på et spørsmål i leksjonen. I tilfeller hvor det ikke tilbys noe svar, f.eks. kortsvar og numeriske alternativer vil denne verdien gi studenten en mulighet for å fortsette til neste side når antall forsøk er brukt opp.';
$string['maximumnumberofattemptsreached'] = 'Maks antall forsøk er oppbrukt. Leksjonen fortsetter på neste side.';
$string['maxtime'] = 'Tidsbegrensning';
$string['maxtimewarning'] = 'Du har {$a} minutter til å avslutte leksjonen.';
$string['mediaclose'] = 'Vis lukkeknapp';
$string['mediafile'] = 'Mediefil';
$string['mediafile_help'] = '<p>Dette vil vise et popupvindu i starten av leksjonen med en valgt fil (f.eks. en mp3-fil) eller en webside. I tillegg vil det vises en lenke på hver side i leksjonen slik at dette vinduet kan gjenåpnes hvis studenten ønsker det.</p>

<p>Det vil også bli vist en "Lukk vinduet"-knapp på bunnen av hver popup og du kan også angi høyde og bredde på vinduet.</p>

<p>Støttede filtyper for visning i popup:</p>
    <ul>
        <li>MP3</li>
        <li>Media Player</li>
        <li>Quicktime</li>
        <li>Realmedia</li>
        <li>HTML</li>
        <li>Ren tekst</li>
        <li>GIF</li>
        <li>JPEG</li>
        <li>PNG</li>
    </ul>
<p>Alle andre filtyper vil som standard vises med en lenke for å laste ned filen.</p>';
$string['mediafilepopup'] = 'Klikk her for å vise';
$string['mediaheight'] = 'Vindushøyde:';
$string['mediawidth'] = 'Vindusbredde:';
$string['messageprovider:graded_essay'] = 'Melding om vurdert essay';
$string['minimumnumberofquestions'] = 'Minimum antall spørsmål';
$string['minimumnumberofquestions_help'] = 'Denne innstillingen angir minimum antall spørsmål som skal være en del av karakteren for denne aktiviteten. Dersom leksjonen inneholder to eller flere innholdssider bør minimum antall spørsmål settes til -0-.

Hvis den settes til f.eks. -20- antas det at følgende tekst legges til i åpningen av leksjonen: "I denne leksjonen forventer vi at du har forsøkt deg på minst 20 spørsmål. Du kan svare på så mange du vil, men svarer du på mindre enn 20 spørsmål vil karakteren beregnes som om du besvarte 20 spørsmål."';
$string['missingname'] = 'Vennligst skriv inn et kallenavn';
$string['modattempts'] = 'Studentene kan se over leksjonen.';
$string['modattempts_help'] = '<p>Dette valget vil tillate at studentene går tilbake i leksjonen og endrer på svarene.</p>';
$string['modattemptsnoteacher'] = 'Studenten kan bare lese andre studenters bidrag';
$string['modulename'] = 'Leksjon';
$string['modulename_help'] = 'Leksjonsmodulen gjør det mulig for lærere å presentere kursinnhold eller øvingsaktiviteter på en interessant og fleksibel måte. Lærere kan bruke leksjoner til å lage en rekke innholdssider eller instruksjonsaktiviteter som tilbyr forskjellige veier eller valg for studenten. Lærere kan velge om de vil øke graden av aktivisering og passe på at elevene forstår det som skal læres ved å legge til et utvalg spørsmål, f.eks. flervalg-, samsvars- og kortsvarsspørsmål. Avhengig av studentens svarvalg og hvordan læreren utvikler leksjonen, kan studentene gå videre til neste side, sendes tilbake til en tidligere side eller omdirigeres ned en helt annen vei.

Leksjoner kan gis karakter, og da vil karakterene bli registrert i karakterboken.

Leksjoner kan brukes

* Til selvstyrt læring av et nytt emne
* Til øvelser som omhandler scenarioer eller simulering/beslutningsprosesser
* Til variert lesing til eksamen/repetering, med forskjellige sett med repetisjonsspørsmål avhengig av svar gitt på innledende spørsmål';
$string['modulenameplural'] = 'Leksjoner';
$string['move'] = 'Flytt siden';
$string['movedpage'] = 'Siden er flyttet';
$string['movepagehere'] = 'Flytt siden hit';
$string['moving'] = 'Flytter side: {$a}';
$string['multianswer'] = 'Mer enn ett svar er korrekt';
$string['multianswer_help'] = 'Merk av her dersom mer enn ett alternativ er korrekt.';
$string['multichoice'] = 'Flervalg';
$string['multipleanswer'] = 'Flersvar';
$string['nameapproved'] = 'Navnet er akseptert';
$string['namereject'] = 'Beklager, navnet ditt ble avvist av filteret. <br />Prøv et annet navn.';
$string['new'] = 'ny';
$string['nextpage'] = 'Neste side';
$string['noanswer'] = 'Ingen svar gitt. Vennligst gå tilbake og avgi et svar.';
$string['noattemptrecordsfound'] = 'Ingen oversikt over forsøk: Ingen karakter gitt';
$string['nobranchtablefound'] = 'Ingen meny funnet';
$string['nocommentyet'] = 'Ingen kommentar ennå.';
$string['nocoursemods'] = 'Fant ingen aktiviteter';
$string['nocredit'] = 'Ingen poeng';
$string['nodeadline'] = 'Ingen tidsfrist';
$string['noessayquestionsfound'] = 'Fant ingen Essay-spørsmål i denne leksjonen';
$string['nohighscores'] = 'Ingen toppresultater';
$string['nolessonattempts'] = 'Det finnes ingen forsøk for denne leksjonen';
$string['nooneansweredcorrectly'] = 'Ingen svarte riktig';
$string['nooneansweredthisquestion'] = 'Ingen svarte på denne oppgaven.';
$string['noonecheckedthis'] = 'Ingen krysset av for denne.';
$string['nooneenteredthis'] = 'Ingen skrev dette.';
$string['noonehasanswered'] = 'Ingen har svart på et essay spørsmål ennå.';
$string['noretake'] = 'Du har ikke lov til å ta denne leksjonen på nytt.';
$string['normal'] = 'Normal - følg rekkefølgen i leksjonen.';
$string['notcompleted'] = 'Ikke fullført';
$string['notdefined'] = 'Ikke definert';
$string['nothighscore'] = 'Du gjorde det ikke bra nok til å komme med på listen over toppresultater for {$a}.';
$string['notitle'] = 'Ingen tittel';
$string['numberofcorrectanswers'] = 'Antallet riktige svar: {$a}';
$string['numberofcorrectmatches'] = 'Antallet riktige par: {$a}';
$string['numberofpagestoshow'] = 'Antallet sider å vise';
$string['numberofpagestoshow_help'] = '<p>Denne parameteren brukes bare i Flash lysbildevisninger  av en leksjon. Standard verdi er 0, noe som betyr at alle lysbildene vises. Ved å sette verdien forskjellig fra 0 vil det antallet sider vises. Etter at ønsket antalls lysbilder er vist, føres studenten til sluttsiden og poeng/karakter vises.</p>

<p>Dersom denne parameteren settes til et tall større enn antall tilgjengelige sider vil slutten av leksjonen nås når alle tilgjengelige sider er vist.</p>';
$string['numberofpagesviewed'] = 'Antallet spørsmål besvart: {$a}';
$string['numberofpagesviewednotice'] = 'Antall spørsmål besvart: {$a->nquestions}; (Minstegrense for besvarte spørsmål: {$a->minquestions})';
$string['numerical'] = 'Numerisk';
$string['ongoing'] = 'Vis poeng underveis';
$string['ongoingcustom'] = 'Du har fått {$a->score} poeng av {$a->currenthigh} mulige så langt.';
$string['ongoing_help'] = '<p>Med denne aktivert vil hver side vises studentens poengsum så langt i leksjonen og hvor mange poeng det er mulig å få. F.eks. vil en student med 6 svar hvorav 5 er korrekt og 20 poeng er maks, få vist på siden at de til nå har 15/20 poeng.</p>';
$string['ongoingnormal'] = 'Du har svart riktig på {$a->correct} av de {$a->viewed} spørsmålene du har sett så langt.';
$string['onpostperpage'] = 'Bare en post per karakter';
$string['options'] = 'Alternativer';
$string['or'] = 'ELLER';
$string['ordered'] = 'Sortert';
$string['other'] = 'Annet';
$string['outof'] = 'Av {$a}';
$string['overview'] = 'Oversikt';
$string['overview_help'] = 'En leksjon bygges opp av et antall spørsmålssider og ett eller flere valgfrie innholdssider. En side er vanligvis et tekstlig og grafisk innhold som avsluttes med et spørsmål til kursdeltakeren. Til hvert svaralternativ er det tilknyttet en "Gå til..."- som tar en til en bestemt side i leksjonen.

En innholdsside er en side som i tillegg til tekst og multimedia inneholder et sett lenker til andre sider i leksjonen. En innholdsside kan derfor fungere som en meny for videre navigering i leksjonen.';
$string['page'] = 'Side: {$a}';
$string['pagecontents'] = 'Sideinnhold';
$string['page-mod-lesson-edit'] = 'Endre leksjonsside';
$string['page-mod-lesson-view'] = 'Vis eller forhåndsvis leksjonsside';
$string['page-mod-lesson-x'] = 'Alle leksjonssider';
$string['pages'] = 'Sider';
$string['pagetitle'] = 'Sidens tittel';
$string['password'] = 'Passord';
$string['passwordprotectedlesson'] = '{$a} er en passordbeskyttet leksjon';
$string['pleasecheckoneanswer'] = 'Vennligst velg et svar';
$string['pleasecheckoneormoreanswers'] = 'Vennligst velg ett eller flere svar';
$string['pleaseenteryouranswerinthebox'] = 'Vennligst skriv inn svaret ditt i boksen';
$string['pleasematchtheabovepairs'] = 'Vennligst finn parene som passer ovenfor';
$string['pluginadministration'] = 'Leksjonsadministrasjon';
$string['pluginname'] = 'Leksjon';
$string['pointsearned'] = 'Poeng';
$string['postprocesserror'] = 'Feil i etterbehandling';
$string['postsuccess'] = 'Sending vellykket';
$string['practice'] = 'Øvelsesleksjon';
$string['practice_help'] = '<p>En øvelsesleksjon vil ikke vises i Karakterboka.</p>';
$string['preprocesserror'] = 'Feil i førbehandling';
$string['prerequisitelesson'] = 'Leksjon som må tas først';
$string['preview'] = 'Forhåndsvisning';
$string['previewlesson'] = 'Forhåndvis {$a}';
$string['previouspage'] = 'Forrige side';
$string['processerror'] = 'Feil i behandling';
$string['progressbar'] = 'Fremdriftsindikator';
$string['progressbar_help'] = 'Viser en framdriftsindikator på bunnen av siden. Foreløpig er framdriftsindikatoren mest anvendelig ved lineære leksjoner uten forgreninger. Når framdriftsindikatoren skal beregne hvor langt en er kommet, regnes innholds- og korrekt besvarte spørsmålssider med. Når totalt antall sider skal beregnes, teller et cluster som EN side og "Slutt på cluster" og "Slutt på forgrening" blir utelatt. Alle andre sider teller som EN side hver.
';
$string['progressbarteacherwarning'] = 'Progresjonsraden vises ikke for {$a}';
$string['progressbarteacherwarning2'] = 'Fremdriftsindikatoren vises ikke for deg siden du har rettighet til å redigere denne leksjonen. (Vises bare for studenter)';
$string['progresscompleted'] = 'Du har fullført {$a}% av leksjonen';
$string['qtype'] = 'Sidetype';
$string['question'] = 'Legg til en spørsmålsside';
$string['questionoption'] = 'Innstillinger for spørsmål';
$string['questiontype'] = 'Type spørsmål';
$string['randombranch'] = 'Vilkårlig forgreningsside';
$string['randompageinbranch'] = 'Vilkårlig spørsmål innen en gren';
$string['rank'] = 'Rangering';
$string['rawgrade'] = 'Ubearbeidet karakter';
$string['receivedcredit'] = 'Mottatt anerkjennelse';
$string['redisplaypage'] = 'Vis siden på nytt';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporter';
$string['response'] = 'Tilbakemelding';
$string['retakesallowed'] = 'Nytt forsøk tillatt';
$string['retakesallowed_help'] = 'Dersom aktivert kan studenter forsøke seg på leksjonen flere ganger.';
$string['returnto'] = 'Gå tilbake til {$a}';
$string['returntocourse'] = 'Gå tilbake til kurset';
$string['review'] = 'Bedømmelse';
$string['reviewlesson'] = 'Se leksjonen på nytt';
$string['reviewquestionback'] = 'Ja, jeg vil gjerne prøve igjen';
$string['reviewquestioncontinue'] = 'Nei, jeg vil bare gå videre til neste spørsmål';
$string['sanitycheckfailed'] = 'Helsesjekken viser feil: Dette forsøket er slettet';
$string['savechanges'] = 'Lagre endringer';
$string['savechangesandeol'] = 'Lagre alle endringer og gå til slutten av leksjonen';
$string['savepage'] = 'Lagre side';
$string['score'] = 'Poeng';
$string['score_help'] = 'Poeng er bare brukt når egendefinert scoring er aktivert. Hvert svar kan da bli gitt en numerisk verdi (positiv eller negativ).';
$string['scores'] = 'Poeng';
$string['secondpluswrong'] = 'Ikke helt. Kunne du tenke deg å prøve igjen?';
$string['selectaqtype'] = 'Velg en spørsmålstype';
$string['shortanswer'] = 'Kortsvar';
$string['showanunansweredpage'] = 'Vis en ubesvart spørsmålsside';
$string['showanunseenpage'] = 'Vis en ulest side';
$string['singleanswer'] = 'Enkelt svar';
$string['skip'] = 'Hopp over navigering';
$string['slideshow'] = 'Lysbildevisning';
$string['slideshowbgcolor'] = 'Bakgrunnsfarge for lysbildevisning';
$string['slideshowheight'] = 'Høyde på lysbildevisning';
$string['slideshow_help'] = 'Dette aktiverer visning av leksjonen som en lysbildevisning, med en bestemt bredde, høyde og tilpasset bakgrunnsfarge. ';
$string['slideshowwidth'] = 'Bredde på lysbildevisning';
$string['startlesson'] = 'Start leksjonen';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} sitt forsøk nummer {$a->attempt}';
$string['studentname'] = '{$a} navn';
$string['studentoneminwarning'] = 'OBS: Du har 1 minutt eller mindre til å avlsutte leksjonen.';
$string['studentresponse'] = '{$a}s tilbakemelding';
$string['submit'] = 'Send';
$string['submitname'] = 'Send navn';
$string['teacherjumpwarning'] = 'Et sprang av typen {$a->cluster} eller {$a->unseen} sprang blir brukt i denne leksjonen. En lenke til neste side vil bli brukt i steden. Logg på som en student for å teste disse sprangene.';
$string['teacherongoingwarning'] = 'Poeng underveis vises bare for studenter. Logg på som en student for å se denne typen visning.';
$string['teachertimerwarning'] = 'Tidtaking virker bare for studenter. Test stoppeklokka ved å logge på som en student.';
$string['thatsthecorrectanswer'] = 'Det er det riktige svaret';
$string['thatsthewronganswer'] = 'Det er feil svar';
$string['thefollowingpagesjumptothispage'] = 'Følgende sider hopper til denne sida';
$string['thispage'] = 'Denne sida';
$string['timeisup'] = 'Tiden er ute';
$string['timeremaining'] = 'Tid som gjenstår';
$string['timespenterror'] = 'Bruk minst {$a} minutter på denne leksjonen';
$string['timespentminutes'] = 'Brukt tid (i minutter)';
$string['timetaken'] = 'Brukt tid';
$string['topscorestitle'] = 'De {$a} beste resultatene';
$string['truefalse'] = 'Sant/Usant';
$string['unabledtosavefile'] = 'Filen du lastet opp kunne ikke lagres';
$string['unknownqtypesnotimported'] = '{$a} spørsmål, med spørsmålstyper som ikke støttes, ble ikke importert';
$string['unseenpageinbranch'] = 'Usette spørsmål i en gren';
$string['unsupportedqtype'] = 'Spørsmålstypen ({$a}) støttes ikke!';
$string['updatedpage'] = 'Oppdatert side';
$string['updatefailed'] = 'Oppdatering mislyktes';
$string['usemaximum'] = 'Bruk beste';
$string['usemean'] = 'Bruk gjennomsnitt';
$string['usepassword'] = 'Passordbeskyttet leksjon';
$string['usepassword_help'] = '<p>Når leksjonen er passordbeskyttet må studenten ha passordet for å kunne ta leksjonen.</p>';
$string['viewgrades'] = 'Se karakterer';
$string['viewhighscores'] = 'Se listen med toppresultater';
$string['viewreports'] = 'Vis {$a->attempts} fullførte {$a->student} forsøk';
$string['viewreports2'] = 'Vis de {$a} fullførte forsøkene';
$string['welldone'] = 'Bra!';
$string['whatdofirst'] = 'Hva vil du gjøre først?';
$string['wronganswerjump'] = 'Sprang ved feil svar';
$string['wronganswerscore'] = 'Poeng ved feil svar';
$string['wrongresponse'] = 'Feil svar';
$string['xattempts'] = '{$a} forsøk';
$string['youhaveseen'] = 'Du har sett mer enn en side i denne leksjonen allerede.<br />Vil du starte på den siste siden du var inne på?';
$string['youmadehighscore'] = 'Du kom på lista over de {$a} beste resultatene';
$string['youranswer'] = 'Ditt svar';
$string['yourcurrentgradeis'] = 'Karakteren din er nå {$a}';
$string['yourcurrentgradeisoutof'] = 'Gjeldende karakter er {$a->grade} av {$a->total}';
$string['youshouldview'] = 'Du bør besvare minst: {$a}';
