<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_memcached', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   cachestore_memcached
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bufferwrites'] = 'Buffer writes';
$string['bufferwrites_help'] = 'Aktiverer eller deaktiverer bufret I / O. Aktivering av bufret I / O fører lagring kommandoer til "buffer" i stedet for å bli sendt. Enhver handling som henter data medfører at bufferen som sendes til den eksterne tilkoblingen. Avslutning av tilkoblingen eller stengning av forbindelsen vil også føre til at bufrede data  blir sendt  til den eksterne tilkoblingen.';
$string['hash'] = 'Hash-metode';
$string['hash_crc'] = 'CRC';
$string['hash_default'] = 'Standard (en om gangen)';
$string['hash_fnv1_32'] = 'FNV1_32';
$string['hash_fnv1_64'] = 'FNV1_64';
$string['hash_fnv1a_32'] = 'FNV1A_32';
$string['hash_fnv1a_64'] = 'FNV1A_64';
$string['hash_help'] = 'Angir hash-algoritmen for elementnøkler. Hver hash-algoritme har sine fordeler og ulemper. Bruk standardvalget om du ikke vet hvordan de virker.';
$string['hash_hsieh'] = 'Hsieh';
$string['hash_md5'] = 'MD5';
$string['hash_murmur'] = 'Murmur';
$string['pluginname'] = 'Memcached';
$string['prefix'] = 'Prefix key';
$string['prefix_help'] = 'Dette kan brukes til å lage en "domene" for dine elementnøkler, og dette lar deg opprette multiple memcache lagringer på en enkelt memcache installasjon. Den kan ikke være lenger enn 16 tegn for å sikre at du ikke får problemer med nøkkellengden.';
$string['prefixinvalid'] = 'Ugyldig prefiks. Du kan bare bruke  a-z A-Z 0-9-_.';
$string['serialiser_igbinary'] = 'Igbinary serialisatortillegg';
$string['serialiser_json'] = 'JSON serialisatortillegg';
$string['serialiser_php'] = 'Standard PHP serialisatortillegg';
$string['servers'] = 'Servere';
$string['servers_help'] = 'Dette angir de serverne som skal tilpasses med dette memcached adapteret.
Serverne må angis linje for linje og bestå av serveradresse og du kan også angi port og vekting.
Hvis du ikke oppgir portnummer brukes standardporten (11211).

F.eks:
<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>';
$string['sessionhandlerconflict'] = 'Advarsel: En memcache ({$a}) er konfigurert til å bruke samme memcached server til sesjonshåndtering. Hvis du tømmer mellomlageret vil derfor alle brukersesjonene blir slettet og brukerne må logge inn på nytt.';
$string['testservers'] = 'Testservere';
$string['testservers_desc'] = 'Testserverne brukes til enhetstester og ytelsestester. Det er helt frivillig å sette opp testservere. Servere må defineres linje for linje og bestå av serveradresse og du kan også angi port og vekting.
Hvis du ikke oppgir portnummer brukes standardporten (11211).';
$string['usecompression'] = 'Bruk kompresjon';
$string['usecompression_help'] = 'Aktiverer eller deaktiverer nyttelast-komprimering. Når aktivert, vil elementverdier lenger enn en viss terskel (for tiden 100 bytes) transparent komprimeres under lagring og dekomprimert under henting.';
$string['useserialiser'] = 'Bruk serialiser';
$string['useserialiser_help'] = 'Angir serialisatortillegg å bruke for serieomkoding av ikke-skalerbare verdier.
De gyldige serializers er memcached :: SERIALIZER_PHP eller memcached :: SERIALIZER_IGBINARY.
Sistnevnte støttes kun når memcached er konfigurert med - enable-memcached-igbinary-alternativet og igbinary-utvidelsen er lastet.';
