<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   badges
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Handlinger';
$string['activate'] = 'Aktiver tilgang';
$string['activatesuccess'] = 'Tilgang til utmerkelser er aktivert.';
$string['addbadgecriteria'] = 'Angi et Merke-krav';
$string['addcourse'] = 'Legg til kurs';
$string['addcourse_help'] = 'Velg de kursene som skal legges til dette merke-kravet. Hold CTRL-tasten nede for å velge mer enn ett kurs.';
$string['addcriteria'] = 'Legg til krav';
$string['addcriteriatext'] = 'Start med å velge en av opsjonene fra listemenyen når du skal legge til et merkekrav.';
$string['addtobackpack'] = 'Legg til i ryggsekk';
$string['adminonly'] = 'Denne siden er kun for portaladministratorer.';
$string['after'] = 'etter tildelingsdatoen';
$string['aggregationmethod'] = 'Tildelingsmetode';
$string['all'] = 'Alle';
$string['allmethod'] = 'Alle valgte krav er oppfylt';
$string['allmethodactivity'] = 'Alle valgte aktiviteter er fullført';
$string['allmethodcourseset'] = 'Alle valgte kurs er fullført';
$string['allmethodmanual'] = 'Alle valgte roller kan tildele merket';
$string['allmethodprofile'] = 'Alle valgte profilfelter er fullført';
$string['allowcoursebadges'] = 'Aktiver kursutmerkelser';
$string['allowcoursebadges_desc'] = 'Tillat at utmerkelser opprettes og tildeles i  kurs.';
$string['allowexternalbackpack'] = 'Aktiver kobling til eksterne ryggsekker';
$string['allowexternalbackpack_desc'] = 'Tillat brukere å sette opp koblinger og vise utmerkelser fra eksterne godkjenningstjenester.

MERK: Det anbefales å la dette valget være deaktivert hvis webportalen ikke er tilgjengeilg via internett. (F.eks. pga en brannmur)';
$string['any'] = 'Et av';
$string['anymethod'] = 'Et av de valgte betingelsen er oppfylt';
$string['anymethodactivity'] = 'Et av de valgte aktivitetene er fullført';
$string['anymethodcourseset'] = 'Et av de valgte kursene er fullført';
$string['anymethodmanual'] = 'En av de valgte rollene tildeler merket';
$string['anymethodprofile'] = 'En av de valgte profilfeltene er fullført';
$string['attachment'] = 'Legg til merket i meldingen';
$string['attachment_help'] = 'Dersom avmerket, vil den tildelte utmerkelsen bli lagt ved e-posten til mottakeren. Aktivering av e-postvedlegg må være gjort i portalinnstillingene for at dette valget skal kunne brukes.';
$string['award'] = 'Tildel merke';
$string['awardedtoyou'] = 'Tildelt meg';
$string['awardoncron'] = 'Tilgang til merket er aktivert. Det er for mange brukere som kan få dette merket samtidig, så det kan ta noe tid før tildelingen er ferdig prosessert.';
$string['awards'] = 'Mottakere';
$string['backpackavailability'] = 'Verifisering av eksternt merke';
$string['backpackavailability_help'] = 'Du må aktivisere koblingen til en ekstern godkjenningstjeneste slik at de som mottar utmerkelser kan få bekreftet at de er ekte. Det ser ikke ut til at portalen din er tilgjengelig for slik kontroll, noe som betyr at de utmerkelsene du allerede har tildelt eller vil tildele i fremtiden ikke kan bekreftes.

## Hvorfor vises denne meldingen til meg?

Det kan være at brannmuren forhindrer tilgang fra brukere utenfor det lokale nettverket, at portalen er passordbeskyttet eller at du kjører portalen på en server som ikke er tilgjengelig på det åpne internett. (F.eks. en lokal utviklingsserver)

## Er dette egentlig noe problem?

Du bør fikse dette på alle produksjonsportaler hvor du planlegger å tildele utmerkelser, ellers vil ikke mottakerne kunne bevise ektheten. Dersom portalen din ikke er offentlig ennå kan du opprette testutmerkelser - men bare hvis serveren er tilkoblet internett.

## Hva hvis jeg ikke kan gjøre portalen tilgjengelig på internett?

Den eneste URL-en som kreves for verifisering er [din-web-adresse]/badges/assertion.php, så hvis du kan lage en unntaksregel i brannmuren til denne filen vil verifiseringen av utmerkelser fortsatt fungere.';
$string['backpackbadges'] = 'Du har {$a->totalbadges} utmerkelser fra  {$a->totalcollections} samlinger. <a href="mybackpack.php">Endre eksterne samlinger</a>.';
$string['backpackconnection'] = 'Ryggsekk-kobling';
$string['backpackconnection_help'] = 'Denne siden lar deg sette opp koblinger til eksterne samlinger. Ved å koble til en ekstern samling kan du vise de eksterne utmerkelsene på denne portalen og overføre utmerkelser du har fått her til samlingen din.

For tiden støttes kun <a href="http://backpack.openbadges.org">Mozilla OpenBadges Backpack</a>. Du må registrere deg hos en slik ekstern samlingstilbyder før du prøver å lage en kobling på denne siden.';
$string['backpackdetails'] = 'Ryggsekkinnstillinger';
$string['backpackemail'] = 'E-postadresse';
$string['backpackemail_help'] = 'E-postadressen som er koblet mot dine eksterne samling av utmerkelser .

Dersom koblingen er etablert vil denne e-postadressen brukes i stedet for din interne e-postadresse for å overføre merker til dine eksterne samling av utmerkelser.';
$string['backpackimport'] = 'Importinnstillinger for utmerkelser';
$string['backpackimport_help'] = 'Etter at godkjenningstjenesten for utmerkelser er tilkoblet og fungerer, vil dine tildelte utmerkelser vises på din "Mine utmerkelser" side og på profilsiden din.

På dette området kan du velge hvilke utmerkelser du ønsker skal vises i profilen din.';
$string['badgedetails'] = 'Merkedetaljer';
$string['badgeimage'] = 'Bilde';
$string['badgeimage_help'] = 'Dette er det bildet som brukes når et merke blir tildelt.

For å legge til et nytt bilde, klikk på Last opp fil og velg et bilde i JPG eller PNG format, og klikk deretter på "Lagre endringer". Bildet vil da bli beskjært til et kvadrat og tilpasset i størrelse til hvordan merkene skal vises.';
$string['badgeprivacysetting'] = 'Hvem som skal få se merkene dine';
$string['badgeprivacysetting_help'] = 'Utmerkelser du er tildelt kan vises i brukerprofilen din. Denne innstillingen lar deg angi hvordan nylig tildelte utmerkelser skal vises.

Du kan fortsatt bestemme om hver enkelt utmerkelse skal vises for andre på siden "Mine utmerkelser".';
$string['badgeprivacysetting_str'] = 'Vis automatisk på profilsiden min alle utmerkelser jeg blir tildelt.';
$string['badgesalt'] = 'Krypteringsfrase for mottakeres e-postadresse';
$string['badgesalt_desc'] = 'Bruk av krypteringsstrenger tillater at tjenester for godkjenning av utmerkelser bekrefter utmerker uten å vise mottakerens e-postadresse. Denne innstillingen bør bare bruke tall og bokstaver.

Merk: Du bør ikke endre disse innstillingene etter at tildeling av utmerkelser har startet. Det vil skape problemer for verifiseringen av utmerkelsene.';
$string['badgesdisabled'] = 'Utmerkelser er ikke aktivert på denne portalen.';
$string['badgesearned'] = 'Antall tildelte utmerkelser: {$a}';
$string['badgesettings'] = 'Utmerkelse innstillinger';
$string['badgestatus_0'] = 'Ikke tilgjengelig for brukere';
$string['badgestatus_1'] = 'Tilgjengelig for brukere';
$string['badgestatus_2'] = 'Ikke tilgjengelig for brukere';
$string['badgestatus_3'] = 'Tilgjengelig for brukere';
$string['badgestatus_4'] = 'Arkivert';
$string['badgestoearn'] = 'Antall tilgjengelige utmerkelser: {$a}';
$string['badgesview'] = 'Kursutmerkelser';
$string['badgeurl'] = 'Lenke til tildelt merke';
$string['bawards'] = 'Mottakere ({$a})';
$string['bcriteria'] = 'Kriterium';
$string['bdetails'] = 'Endre detaljer';
$string['bmessage'] = 'Melding';
$string['boverview'] = 'Oversikt';
$string['bydate'] = 'fullført av';
$string['clearsettings'] = 'Slett innstillinger';
$string['completioninfo'] = 'Dette merket er tildelt for å ha fullført:';
$string['completionnotenabled'] = 'Kursfullføring er ikke aktivert for dette kurset, så det kan dessverre ikke tas med som noe kriterium for merket. Du kan aktivere kursfullføring under kursets innstillinger.';
$string['configenablebadges'] = 'Når aktivert, vil denne funksjonen la deg opprette utmerkelser og tildele dem til brukere på denne portalen.';
$string['configuremessage'] = 'Melding som skal gis ved merketildeling';
$string['connect'] = 'Koble til';
$string['connected'] = 'Tilkoblet';
$string['connecting'] = 'Kobler til...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'En e-postadresse til den som tildeler merket.';
$string['copyof'] = 'Kopi av {$a}';
$string['coursebadges'] = 'Utmerkelser';
$string['coursebadgesdisabled'] = 'Kursutmerkelser er ikke aktivert på denne portalen.';
$string['coursecompletion'] = 'Brukerne må fullføre dette kurset.';
$string['create'] = 'Nytt merke';
$string['createbutton'] = 'Opprett merke';
$string['creatorbody'] = '<p>{$a->user} har bestått alle merkekravene og kan tildeles merket. Du kan se merket her:  {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' er belønnet!';
$string['criteria_0'] = 'Dette merket tildeles når....';
$string['criteria_1'] = 'Aktivitetsfullføring';
$string['criteria_1_help'] = 'Tillat at en utmerkelse tildeles brukere når de fullfører et sett av aktiviteter i kurset.';
$string['criteria_2'] = 'Tildel manuelt via rolle';
$string['criteria_2_help'] = 'Tillat at en utmerkelse tildeles manuelt av brukere som har en bestemt rolle på portalen eller i kurset.';
$string['criteria_3'] = 'Sosial deltakelse';
$string['criteria_3_help'] = 'Sosial';
$string['criteria_4'] = 'Kursfullføring';
$string['criteria_4_help'] = 'Tillater at en utmerkelse tildeles brukere som har fullført kurset. Dette kriteriet har en tilleggsparameter, slik som minstekrav til karakter og dato for kursfullføring.';
$string['criteria_5'] = 'Fullfører et sett av kurs';
$string['criteria_5_help'] = 'Tillater at en utmerkelse blir tildelt brukere som har fullført et sett av kurs. Hvert kurs kan tilleggsparametre som minstekrav til karakter og dato for kursfullføringen.';
$string['criteria_6'] = 'Fullføring av egen profil';
$string['criteria_6_help'] = 'Tillater at en utmerkelse tildeles brukere for fullføring av bestemte felt i egen profil. Du kan velge fra standard og egendefinerte felt som er tilgjengelige for brukerne.';
$string['criteriacreated'] = 'Et utmerkelseskriterie har blitt opprettet';
$string['criteriadeleted'] = 'Et utmerkelseskriterie har blitt slettet';
$string['criteria_descr'] = 'Studenter blir tildelt denne utmerkelsen når de fullfører følgende betingelser:';
$string['criteria_descr_0'] = 'Studenter blir tildelt denne utmerkelsen når de fullfører <strong>{$a}</strong> av opplistede betingelser.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> av følgende aktivitetskrav er fullført:';
$string['criteria_descr_2'] = 'Denne utmerkelsen tildeles av brukere med <strong>{$a}</strong> av følgende roller:';
$string['criteria_descr_4'] = 'Studenter må fullføre kurset';
$string['criteria_descr_5'] = '<strong>{$a}</strong> av følgende kurs må fullføres:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> av følgende brukerprofilfelt må fullføres:';
$string['criteria_descr_bydate'] = 'av <em>{$a}</em>';
$string['criteria_descr_grade'] = 'med minimum karakter <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_short1'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_short2'] = 'Tildelt av <strong>{$a}</strong> til:';
$string['criteria_descr_short4'] = 'Fullfør kurset';
$string['criteria_descr_short5'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_short6'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_single_1'] = 'Følgende aktiviteter må fullføres:';
$string['criteria_descr_single_2'] = 'Denne utmerkelsen må tildeles av en bruker med følgende rolle:';
$string['criteria_descr_single_4'] = 'Studenter må fullføre kurset';
$string['criteria_descr_single_5'] = 'Følgende kurs må fullføres';
$string['criteria_descr_single_6'] = 'Følgende brukerprofilfelt må fullføres:';
$string['criteria_descr_single_short1'] = 'Fullfør:';
$string['criteria_descr_single_short2'] = 'Tildelt av:';
$string['criteria_descr_single_short4'] = 'Fullfør kurset';
$string['criteria_descr_single_short5'] = 'Fullfør:';
$string['criteria_descr_single_short6'] = 'Fullfør:';
$string['criteriasummary'] = 'Kriteriesammendrag';
$string['criteriaupdated'] = 'Et utmerkelseskriterie har blitt oppdatert';
$string['criterror'] = 'Gjeldende parameterfeil';
$string['criterror_help'] = 'Dette feltsettet viser alle parametre som fra starten av ble lagt til denne utmerkelsen og som ikke lenger er tilgjengelige. Det anbefales av du fjerner slike parametre for å sikre at studentene kan få tildelt denne utmerkelsen i fremtiden.';
$string['currentimage'] = 'Gjeldende bilde:';
$string['currentstatus'] = 'Gjeldende status:';
$string['dateawarded'] = 'Dato tildelt';
$string['dateearned'] = 'Dato: {$a}';
$string['day'] = 'Dager';
$string['deactivate'] = 'Deaktiver tilgang';
$string['deactivatesuccess'] = 'Tilgangen til utmerkelsen er nå deaktivert.';
$string['defaultissuercontact'] = 'Standard kontaktinfo for tildeler av utmerkelsen.';
$string['defaultissuercontact_desc'] = 'En e-postadresse tilhørende tildeleren av utmerkelsen.';
$string['defaultissuername'] = 'Standard navn på tildeler av utmerkelsen';
$string['defaultissuername_desc'] = 'Navn på tildeler/utgiver av utmerkelsen';
$string['delbadge'] = 'Slett utmerkelsen';
$string['delconfirm'] = 'Er du sikker på at du vil slette utmerkelsen \'{$a}\'?';
$string['delcritconfirm'] = 'Er du sikker på at du vil slette dette kriteriet?';
$string['delparamconfirm'] = 'Er du sikker på at du vil slette dette parameteret?';
$string['description'] = 'Beskrivelse';
$string['disconnect'] = 'Frakoble';
$string['donotaward'] = 'Denne utmerkelsen er ikke aktiv nå, så den kan ikke deles ut til brukere. Hvis du ønsker å dele ut utmerkelsen til noen må du sette status til aktiv.';
$string['editsettings'] = 'Rediger innstillinger';
$string['enablebadges'] = 'Aktiver utmerkelser';
$string['error:backpackdatainvalid'] = 'Dataene som ble returnert fra den eksterne porteføljen var ugyldig.';
$string['error:backpackemailnotfound'] = 'Den oppgitte epostadressen \'{$a}\' er ikke tilknyttet noen ekstern portefølje. Du må <a href="http://backpack.openbadges.org"> opprette en portefølje </a> for den epostadressen, eller logge inn med en annen epostadresse.';
$string['error:backpackloginfailed'] = 'Du kunne ikke kobles til en ekstern portefølje av følgende årsak:{$a}';
$string['error:backpacknotavailable'] = 'Kursportalen din er ikke tilgjengelig fra Internett, så de utmerkelsene du tildeler fra denne kursportalen vil derfor ikke kunne verifiseres fra en ekstern portefølje av utmerkelser.';
$string['error:backpackproblem'] = 'Det oppstod et problem ved tilkobling til din personlige samling av utmerkelser. Vennligst prøv igjen senere.';
$string['error:badjson'] = 'Tilkoblingen sendte ugyldige data.';
$string['error:cannotact'] = 'Kan ikke aktivere utmerkelsen';
$string['error:cannotawardbadge'] = 'Kan ikke dele ut utmerkelsen til bruker.';
$string['error:clone'] = 'Kan ikke klone utmerkelsen';
$string['error:connectionunknownreason'] = 'Tilkoblingen var mislykket og det ble ikke oppgitt noen årsak.';
$string['error:duplicatename'] = 'Det eksisterer allerede en utmerkelse med samme navn på dette systemet.';
$string['error:externalbadgedoesntexist'] = 'Finner ikke utmerkelse';
$string['error:guestuseraccess'] = 'Du er logget inn som gjest. Du må logge inn med brukerkontoen din for å se utmerkelser.';
$string['error:invalidbadgeurl'] = 'Ugyldig URL-format til tildeler av utmerkelsen.';
$string['error:invalidcriteriatype'] = 'Ugyldig kriterietype';
$string['error:invalidexpiredate'] = 'Utløpsdato må være frem i tid.';
$string['error:invalidexpireperiod'] = 'Utløpsdato kan ikke være negativ eller -0-.';
$string['error:noactivities'] = 'Det finnes ingen aktiviteter med aktivitetsfullføring påslått i dette kurset.';
$string['error:noassertion'] = 'Ingen påstand ble returnert av Persona. Du har kanskje lukket dialogboksen før du fullførte innloggingsprosessen.';
$string['error:nocourses'] = 'Kursfullføring er ikke aktivert for noen av kursene på denne portalen, så det er ingenting å vise. Du kan aktiverer kursfullføring i kursets innstillinger.';
$string['error:nogroups'] = '<p>Det finnes ingen offentlig tilgjengelige utvalg av utmerkelser i din portefølje.</p>
<p>Bare offentlige utvalg vises, <a href="http://backpack.openbadges.org">besøk din portefølje av utmerkelser</a> for å opprette noen offentlige utvalg.</p>';
$string['error:nopermissiontoview'] = 'Du har ikke tillatelser til å se mottakere av utmerkelsen';
$string['error:nosuchbadge'] = 'Utmerkelsen med id {$a} eksisterer ikke.';
$string['error:nosuchcourse'] = 'Advarsel: Dette kurset er ikke lenger tilgjengelig.';
$string['error:nosuchfield'] = 'Advarsel: Dette brukerprofilfeltet er ikke lenger tilgjengelig.';
$string['error:nosuchmod'] = 'Advarsel: Denne aktiviteten er ikke lenger tilgjengelig.';
$string['error:nosuchrole'] = 'Advarsel: Denne rollen er ikke lenger tilgjengelig.';
$string['error:nosuchuser'] = 'Bruker med denne e-postadressen har ikke noen konto hos gjeldende tilbyder av utmerkelsesportefølje.';
$string['error:notifycoursedate'] = 'Advarsel: Utmerkelser som krever fullført kurs og aktivitet vil ikke bli utstedt før kurset starter.';
$string['error:parameter'] = 'Advarsel: Det må minst velges en parameter for å sikret at tildelingen av utmerkelsen går som tenkt.';
$string['error:personaneedsjs'] = 'Det trengs Javascript for å koble til den eksterne porteføljen. Dersom det er mulig kan du tillate Javascript og prøve på nytt.';
$string['error:requesterror'] = 'Tilkoblingen mislyktes (feilkode {$a}).';
$string['error:requesttimeout'] = 'Tilkoblingen ble avbrutt fordi den brukte for lang tid';
$string['error:save'] = 'Kan ikke lagre utmerkelsen.';
$string['error:userdeleted'] = '{$a->user} (Denne brukeren eksisterer ikke lenger på {$a->site})';
$string['evidence'] = 'Bevis';
$string['existingrecipients'] = 'Eksisterende mottakere av utmerkelsen';
$string['expired'] = 'Utløpt';
$string['expiredate'] = 'Utmerkelsen utløper {$a}.';
$string['expireddate'] = 'Utmerkelsen utløper {$a}.';
$string['expireperiod'] = 'Utmerkelsen uløper {$a} dager etter å ha blitt utstedt.';
$string['expireperiodh'] = 'Utmerkelsen utløper {$a} timer etter å ha blitt utstedt.';
$string['expireperiodm'] = 'Utmerkelsen utløper {$a} minutter etter å ha blitt utstedt.';
$string['expireperiods'] = 'Utmerkelsen utløper {$a} sekunder etter å ha blitt utstedt.';
$string['expirydate'] = 'Utløpsdato';
$string['expirydate_help'] = 'Som opsjon kan utmerkelser ha en utløpsdato eller datoen kan beregnes automatisk ut fra når den ble tildelt brukeren.';
$string['externalbadges'] = 'Utmerkelser jeg har fra andre nettsteder';
$string['externalbadges_help'] = 'Dette området viser utmerkelser fra din eksterne samling av utmerkelser.';
$string['externalbadgesp'] = 'Utmerkelser fra andre nettsteder:';
$string['externalconnectto'] = 'Du må koble deg til <a href="{$a}">din eksterne samling av utmerkelser</a> for å kunne vise dem.';
$string['fixed'] = 'Fast dato';
$string['hidden'] = 'Skjult';
$string['hiddenbadge'] = 'Utgiveren av denne utmerkelsen har dessverre ikke lagt ved noen informasjon.';
$string['issuancedetails'] = 'Utløpsdato på utmerkelse';
$string['issuedbadge'] = 'Utstederinformasjon på utmerkelsen';
$string['issuerdetails'] = 'Utstederdetaljer';
$string['issuername'] = 'Navn på utsteder';
$string['issuername_help'] = 'Navn på tildeler/utgiver av utmerkelsen.';
$string['issuerurl'] = 'Utsteders URL';
$string['localbadges'] = 'Mine utmerkelser fra {$a} nettside';
$string['localbadgesh'] = 'Mine utmerkelser fra denne nettsiden';
$string['localbadgesh_help'] = 'Alle utmerkelser du har fått for å fullføre kurs, kursaktiviteter eller andre krav på denne nettsiden.

Du kan administrere utmerkelsene dine her ved å gjøre dem offentlig eller privat på din profilside.

Du kan laste ned alle utmerkelsene dine eller hver utmerkelse separat og lagre dem på datamaskinen din. Nedlastede utmerkelser kan legges til den eksterne porteføljetjenesten.';
$string['localbadgesp'] = 'Utmerkelser fra {$a}:';
$string['localconnectto'] = 'Du må koble deg til <a href="{$a}">din eksterne samling av utmerkelser</a> for å kunne vise dem utenfor denne portalen.';
$string['makeprivate'] = 'Gjør privat';
$string['makepublic'] = 'Gjør offentlig';
$string['managebadges'] = 'Administrer utmerkelser';
$string['message'] = 'Meldingsteksten';
$string['messagebody'] = '<p>Du er blitt tildelt utmerkelsen "%badgename%"!</p>
<p>Du finner mer informasjon om denne utmerkelsen på  %badgelink%.</p>
<p>Hvis det ikke er lagt ved noen utmerkelse i denne e-posten kan du laste den ned fra {$a}.</p>';
$string['messagesubject'] = 'Gratulerer! Du har fått en utmerkelse!';
$string['method'] = 'Dette kriteriet er fullført når...';
$string['mingrade'] = 'Minimumskarakter påkrevd';
$string['month'] = 'Måned(er)';
$string['mybackpack'] = 'Innstillinger for min personlige samling av utmerkelser';
$string['mybadges'] = 'Mine utmerkelser';
$string['never'] = 'Aldri';
$string['newbadge'] = 'Legg til en ny utmerkelse';
$string['newimage'] = 'Nytt bilde';
$string['noawards'] = 'Du har ikke fått denne utmerkelsen enda.';
$string['nobackpack'] = 'Det er ikke tilkoblet noen personlig samling av utmerkelser til denne kontoen. <br/>';
$string['nobackpackbadges'] = 'Det er ingen utmerkelser i utvalget ditt.  <a href="mybackpack.php">Legg til flere samlinger</a>.';
$string['nobackpackcollections'] = 'Ingen personlige samlinger er valgt. <a href="mybackpack.php">Legg til samlinger</a>.';
$string['nobadges'] = 'Det er ingen tilgjengelige utmerkelser.';
$string['nocriteria'] = 'Det er ikke satt opp noe kriterier for denne utmerkelsen enda.';
$string['noexpiry'] = 'Denne utmerkelsen har ingen utløpsdato.';
$string['noparamstoadd'] = 'Det er ingen ekstra parametre tilgjengelig for dette utmerkelseskravet.';
$string['notacceptedrole'] = 'Du er ikke tildelt en rolle med rett til å manuelt tildele denne utmerkelsen.<br />
Hvis du ønsker å se alle brukere som allerede er tildelt denne utmerkelsen, kan du gå til siden {$a}.';
$string['notconnected'] = 'Ikke tilkoblet';
$string['nothingtoadd'] = 'Det er ingen ledige kriterier å legge til.';
$string['notification'] = 'Varsle den som har opprettet  utmerkelsen';
$string['notification_help'] = 'Denne innstillingen administrerer meldinger som sendes utstederen av utmerkelsen, slik at de får vite når utmerkelsen blir tildelt.

Følgende opsjoner er tilgjengelige:

* **ALDRI** – Ikke send meldinger.

* **HVER GANG** – Send en melding hver gang utmerkelsen blir tildelt noen.

* **DAGLIG** – Send en samlemelding hver dag.

* **UKENTLIG** – Send en samlemelding en gang i uka.

* **MÅNEDLIG** – Send en samlemelding en gang i måneden.';
$string['notifydaily'] = 'Daglig';
$string['notifyevery'] = 'Hver gang';
$string['notifymonthly'] = 'Månedlig';
$string['notifyweekly'] = 'Ukentlig';
$string['numawards'] = 'Denne utmerkelsen er tildelt <a href="{$a->link}">{$a->count}</a> brukere.';
$string['numawardstat'] = 'Denne utmerkelsen er tildelt {$a} brukere.';
$string['overallcrit'] = 'av valgte kriterier er fullført.';
$string['personaconnection'] = 'Logg inn med din epostadresse';
$string['personaconnection_help'] = 'Persona er et system for å identifisere deg selv på Internett ved hjelp av en e-postadresse som du eier. The Open Badge Backpack bruker Persona som loginsystem, så for å være i stand til å koble til et eksternt lager av utmerkelser trenger du en Persona-konto.';
$string['potentialrecipients'] = 'Potensielle mottakere av utmerkelsen';
$string['recipientdetails'] = 'Mottakerdetaljer';
$string['recipientidentificationproblem'] = 'Kan ikke finne en mottager av denne utmerkelsen blant eksisterende brukere.';
$string['recipients'] = 'Mottakere av utmerkelsen';
$string['recipientvalidationproblem'] = 'Nåværende bruker kan ikke bli verifisert som mottager av denne utmerkelsen';
$string['relative'] = 'Relativ dato';
$string['requiredcourse'] = 'Minst ett kurs må legges til som kurssett-kriterium.';
$string['reviewbadge'] = 'Se gjennom kriteriene for utmerkelsen';
$string['reviewconfirm'] = '<p>Denne handlingen vil gjøre utmerkelsen din synlig og tillate andre å få den tildelt.</p>
<p>Det er mulig at noen brukere allerede oppfyller kravene til utmerkelsen og disse blir tildelt utmerkelsen med en gang du gjør den aktiv.</p>
<p>Straks en utmerkelse er tildelt vil dette <strong>låse</strong> bestemte innstillinger, inkludert tildelingskriteriene og utløpsinnstillingene kan ikke lenger endres.</p>
<p>Er du sikker på at du vil aktivere tilgang til utmerkelsen \'{$a}\'?</p>';
$string['save'] = 'Lagre';
$string['searchname'] = 'Søk på navn';
$string['selectaward'] = 'Vennligst velg den rollen du ønsker skal kunne tildele denne utmerkelsen:';
$string['selectgroup_end'] = 'Bare offentlige samlinger vises, <a href="http://backpack.openbadges.org">gå til din privalte samling</a>for å opprette flere offentlige samlinger av utmerkelser.';
$string['selectgroup_start'] = 'Velg samlinger fra din private samling av utmerkelser slik at disse kan vises på denne portalen:';
$string['selecting'] = 'Med valgte utmerkelser...';
$string['setup'] = 'Sett opp tilkobling';
$string['signinwithyouremail'] = 'Logg inn med din epostadresse';
$string['sitebadges'] = 'Portalutmerkelser';
$string['sitebadges_help'] = 'Portalutmerkelser kan bare tildeles til brukere for portalbaserte aktiviteter. Dette inkluderer å fullføre et utvalg av kurs eller deler av brukerprofilen. Portalutmerkelser kan også tildeles manuelt.

Utmerkelser for kursrelaterte aktiviteter må opprettes på kursnivået. Kursutmerkelser finner du under Kursadministrasjon > Utmerkelser.';
$string['status'] = 'Status for utmerkelse';
$string['status_help'] = 'Statusen for en utmerkelse bestemmer hvordan den oppfører seg på portalen:

* **TILGJENGELIG** – Betyr at denne utmerkelsen kan tildeles brukere. Når en utmerkelse er gjort tilgjengelig for brukerne kan en ikke lenger endre tildelingskriteriene.

* **IKKE TILGJENGELIG** – Betyr at denne utmerkelsen ikke kan tildeles noen brukere - heller ikke manuelt. Dersom en ikke har tildelt denne utmerkelsen til noen kan kriteriene for tildeling fortsatt endres.

Straks en utmerkelse er tildelt til minst EN bruker vil den låses. En låst utmerkelse kan fortsatt tildeles brukere, men kriteriene kan ikke lenger endres. Dersom du har behov for å endre på tildelingskriteriene kan du i stedet duplisere utmerkelsen og gjøre de nødvendige endringene på denne i stedet.

*Hvorfor låser vi utmerkelsene?*

Vi ønsker å forsikre oss om at alle brukere oppfyller de samme kravene for å få tildelt utmerkelsen. Foreløpig er det ikke mulig å tilbakekalle utmerkelser. Hvis vi tillot at kravene kunne  endres hele tiden, ville vi mest sannsynlig ende opp med brukere som har samme utmerkelse selv om kravene har vært helt forskjellige.';
$string['statusmessage_0'] = 'Denne utmerkelsen er ikke tilgjengelig for brukere. Aktiver tilgang hvis du vil at brukerne skal få denne utmerkelsen.';
$string['statusmessage_1'] = 'Denne utmerkelsen er tilgjengelig for brukere. Deaktiver tilgang for å gjøre endringer.';
$string['statusmessage_2'] = 'Denne utmerkelsen er for tiden ikke tilgjengelig for brukere, og tildelingskriteriene er låst. Aktiver tilgang dersom du ønsker at brukere skal kunne bli tildelt denne utmerkelsen.';
$string['statusmessage_3'] = 'Denne utmerkelsen er for tiden tilgjengelig for brukerne og tildelingskriteriene er låst.';
$string['statusmessage_4'] = 'Denne utmerkelsen er nå arkivert.';
$string['subject'] = 'Meldingsemne';
$string['variablesubstitution'] = 'Variabel substitusjon i meldinger';
$string['variablesubstitution_help'] = 'I en melding om utmerkelse kan det settes inn variabler i Emnefeltet eller i meldingens brødtekst. Variablene erstattes da med virkelige verdier når meldingen sendes. Variablene må benyttes akkurat som de vises under.
Følgende variabler kan benyttes:

%badgename%
:  Dette blir byttet ut med utmerkelsens fulle navn.

%username%
:   Dette blir byttet ut med mottakerens fulle navn.

%badgelink%
:   Dette blir byttet ut med en offentlig URL med informasjon om den tildelte utmerkelsen.';
$string['viewbadge'] = 'Se gjennom utstedte utmerkelser';
$string['visible'] = 'Synlig';
$string['warnexpired'] = '(Denne utmerkelsen har gått ut på dato!)';
$string['year'] = 'År';
