<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har innlevering som krever din oppmerksomhet.';
$string['addsubmission'] = 'Legg til innlevering';
$string['allowdeleting'] = 'Tillat sletting';
$string['allowdeleting_help'] = '<p>Dersom aktiv, kan deltakere slette opplastede filer når som helst FØR de klikker på knappen "Send inn for vurdering".</p>';
$string['allowmaxfiles'] = 'Maksimalt antall opplastede filer';
$string['allowmaxfiles_help'] = '<p>Maks antall filer en deltaker kan laste opp. Dette tallet vises ikke for deltakerne, så vennligst skriv informasjon om hvor mange filer som tillates i innleveringen når du lager beskrivelsesteksten.
</p>';
$string['allownotes'] = 'Tillatt kommentarer';
$string['allownotes_help'] = 'Hvis aktivert, vil studentene kunne legge inn notater i et tekstfelt, slik som i en webbasert tekstinnlevering.';
$string['allowresubmit'] = 'Tillat ny innlevering';
$string['allowresubmit_help'] = '<p>Standardvalget er at studenter/elever ikke kan levere inn oppgaver på nytt
når læreren har gitt vurdering/satt karakter.
</p>

<p>
Dersom du aktiverer denne valgmuligheten kan deltakerne levere inn sine (reviderte) oppgaver igjen etter at de har fått
vurdering/karakter (slik at du kan bedømme dem igjen.) Det kan være praktisk om læreren vil oppmuntre studentene/elevene til å forbedre sin innsats i en interaktiv prosess.
</p>

<p>
Naturligvis gjelder ikke denne valgmuligheten i en Frakoblet aktivitet.
</p>';
$string['alreadygraded'] = 'Oppgaven din har allerede fått karakter og ny innlevering er ikke tillatt.';
$string['assignment:addinstance'] = 'Legg til en ny innlevering';
$string['assignmentdetails'] = 'Oppgavedetaljer';
$string['assignment:exportownsubmission'] = 'Eksporter din innlevering';
$string['assignment:exportsubmission'] = 'Eksperter innlevering';
$string['assignment:grade'] = 'Oppgave med karakterer';
$string['assignmentmail'] = '{$a->teacher} har sendt en tilbakemelding på din
innlevering \'{$a->assignment}\'. Du kan lese tilbakemeldingen her: {$a->url}

Du kan se tilbakemeldingen her:

{$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->teacher} har sendt en tilbakemelding på din
innlevering \'<i>{$a->assignment}</i>\'</p><p>
Du kan se tilbakemeldingen <a href="{$a->url}">her:</a>.</p>';
$string['assignmentmailsmall'] = '{$a->teacher} har lagt til en tilbakemelding på din innlevering for \'{$a->assignment}\'. Den er lagt til innleveringen din.';
$string['assignmentname'] = 'Oppgavenavn';
$string['assignmentsubmission'] = 'Oppgaveinnleveringer';
$string['assignment:submit'] = 'Send inn oppgavesvaret';
$string['assignmenttype'] = 'Oppgavetype';
$string['assignment:view'] = 'Se på oppgave';
$string['availabledate'] = 'Tilgjengelig fra';
$string['cannotdeletefiles'] = 'En feil oppstod og filen kunne ikke slettes.';
$string['cannotviewassignment'] = 'Du kan ikke se denne innleveringen';
$string['changegradewarning'] = 'Denne innleveringen inneholder besvarelser som allerede er karaktersatt. Hvis du endrer karakteren, vil ikke eksisterende karakterer regnes om automatisk. Du må gjøre om karakterene på samtlige eksisterende besvarelser hvis du ønsker å endre karakteren.';
$string['closedassignment'] = 'Innleveringsfristen for denne innleveringen er passert.';
$string['comment'] = 'Kommentar';
$string['commentinline'] = 'Kommenter i tekst';
$string['commentinline_help'] = '<p>Hvis denne opsjonen er valgt vil den originale innleveringsteksten automatisk bli kopiert inn i tilbakemeldingsfeltet når læreren vurderer teksten. Læreren kan f.eks. bruke annen farge på kommentarteksten eller redigere rett i orginalteksten.
</p>';
$string['configitemstocount'] = 'Egenskaper ved elementer som skal telles med ved studentinnleveringer via nett.';
$string['configmaxbytes'] = 'Standard maksimum oppgavestørrelse for alle oppgavene på sidene (overordnet klassenes grenser og andre lokale innstillinger)';
$string['configshowrecentsubmissions'] = 'Alle kan se merknader til innleveringer i de siste aktivitetsrapporter.';
$string['confirmdeletefile'] = 'Er du HELT SIKKER på at du vil slette denne filen?<br /><strong>{$a}</strong>';
$string['coursemisconf'] = 'Kurset er feilkonfigurert';
$string['currentgrade'] = 'Nåværende karakter i karakterboka';
$string['deleteallsubmissions'] = 'Slette alle innleveringer';
$string['deletefilefailed'] = 'Sletting av filen mislykkes';
$string['description'] = 'Beskrivelse';
$string['downloadall'] = 'Last ned alle innleveringer som ei zipfil';
$string['draft'] = 'Kladd';
$string['due'] = 'Innleveringsfrist';
$string['duedate'] = 'Innleveringsfrist';
$string['duedateno'] = 'Ingen innleveringsfrist';
$string['early'] = '{$a} før fristen';
$string['editmysubmission'] = 'Rediger innleveringen min';
$string['editthesefiles'] = 'Rediger disse filene';
$string['editthisfile'] = 'Last opp denne filen';
$string['emailstudents'] = 'Epostvarsel til studentene';
$string['emailteachermail'] = '{$a->username} har oppdatert sin oppgaveinnlevering for \'{$a->assignment}\'  {$a->timeupdated}

Den er tilgjengelig her:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} har oppdatert sin innlevering av oppgave
for <i>\'{$a->assignment}\'  {$a->timeupdated}</i></p><p>
Den er <a href="{$a->url}">tilgjengelig på nettstedet</a>.</p>';
$string['emailteachers'] = 'Epostvarsel til lærere';
$string['emailteachers_help'] = '<p>Hvis påslått vil lærere bli varslet med en kort e-post hver gang deltakerne legger til eller oppdaterer innleveringen sin.
</p>

<p>Det er bare lærere med vurderingsrettigheter som blir varslet. Hvis du har satt opp kurset med separate grupper og lærere bare ser "sine" deltakere, vil de ikke motta e-postvarsler for deltakere fra andre grupper.
</p>

<p>I frakoblede aktiviteter vil det selvsagt ikke sendes noen e-postvarsel siden deltakerne ikke leverer noe.
</p>';
$string['emptysubmission'] = 'Du har ikke levert noe ennå';
$string['enablenotification'] = 'Send varsel i epost';
$string['enablenotification_help'] = '<p>Dersom du slår denne på vil deltakerne bli varslet via e-post om vurdering og tilbakemelding.</p>
<p>Moodle lagrer innstillingen din som en personlig preferanse og vil automatisk slå den på i alle innleveringer du vurderer.</p>';
$string['errornosubmissions'] = 'Det er ingen innleveringer å laste ned';
$string['existingfiledeleted'] = 'Eksisterende fil er slettet: {$a}';
$string['failedupdatefeedback'] = 'Kunne ikke oppdatere tilbakemelding for levering til {$a}';
$string['feedback'] = 'Tilbakemelding';
$string['feedbackfromteacher'] = 'Tilbakemelding fra {$a}';
$string['feedbackupdated'] = 'Tilbakemelding oppdatert for {$a} personer';
$string['finalize'] = 'Hindre oppdatering av innleveringen';
$string['finalizeerror'] = 'En feil oppstod slik at innsendingen ikke ble fullført';
$string['futureaassignment'] = 'Denne innleveringen er ennå ikke tilgjengelig';
$string['graded'] = 'Karaktersatt';
$string['guestnosubmit'] = 'Beklager, gjester har ikke lov til å levere inn oppgaver. Du må logge inn/registere deg før du kan levere inn besvarelsen din.';
$string['guestnoupload'] = 'Beklager, gjester har ikke lov til å levere inn';
$string['helpoffline'] = '<p>Dette er nyttig når oppgaven utføres utenfor Moodle. Det kan være et annet sted på nettet eller ansikt-til-ansikt.</p><p>Studenter kan se en beskrivelse av oppgaven, men de kan ikke levere inn filer eller annet. Karaktersetting fungerer vanligvis, og studenter vil få melding om sine karakterer.</p>';
$string['helponline'] = '<p>Denne oppgavetypen spør brukerne om å editere en tekst, ved bruk av vanlige redigeringsverktøy. Lærerne kan karaktersette dem på nett, og til og med skrive noen kommentarlinjer eller endringer i teksten.</p><p>(Hvis du er vant til en eldre versjon av Moodle, gjør denne oppgavetypen det samme som den gamle Journal-modulen pleide å gjøre.)</p>';
$string['helpupload'] = '<p>Denne oppgavetypen tillater hver deltaker å laste opp en eller flere filer av hvilken som helst type.</p>
<p>Det kan være et Word-dokument, bilder, et komprimert nettsted,eller hva som helst du ber dem om å levere inn.</p>
<p>Denne typen tillater deg å laste opp flere responsfiler av hvilken som helst type, også FØR studentinnleveringen slik at hver enkelt kan få sine filer å jobbe med.</p>
<p>Innleveringer av denne typen må manuelt merkes som endelig av studenten. Du kan når som helst se status på innleveringen og foreløpige innleveringer merkes som "kladd". Du kan også tilbakestille (ikke vurderte) innleveringer til kladd-status. </p>';
$string['helpuploadsingle'] = '<p>Denne innleveringstypen lar hver deltaker laste opp en enkelt fil av hvilken som helst type.</p><p>Dette kan være et Word-dokument, et bilde, et komprimert nettsted, eller hva som helst du ellers måtte be dem om å levere inn.</p>';
$string['hideintro'] = 'Skjul beskrivelsen før tilgjengeligdato';
$string['hideintro_help'] = '<p>Dersom aktiv vil innleveringsbeskrivelsen være skjult helt fram til innleveringen er åpen for innleveringer.
</p>';
$string['invalidassignment'] = 'Ugyldig innlevering';
$string['invalidfileandsubmissionid'] = 'Manglende fil- eller innsendings-ID';
$string['invalidid'] = 'InnleveringsID-en var feil';
$string['invalidsubmissionid'] = 'Ugyldig innsendings-ID';
$string['invalidtype'] = 'Feil innleveringstype';
$string['invaliduserid'] = 'Ugyldig brukerid';
$string['itemstocount'] = 'Tell';
$string['lastgrade'] = 'Siste karakter';
$string['late'] = '{$a} for sent';
$string['maximumgrade'] = 'Maks karakter/poeng';
$string['maximumsize'] = 'Maks filstørrelse';
$string['maxpublishstate'] = 'Maks synlighet for blogginnlegg før utløpsdato';
$string['messageprovider:assignment_updates'] = 'Innleveringsmeldinger (2.2)';
$string['modulename'] = 'Innlevering (2.2)';
$string['modulename_help'] = '<ul>
<p>
Oppgave lar læreren formulere en oppgavetekst som
innebærer at studentene/elevene skal levere et digitalt innhold (i valgfritt format)
til serveren. Essay, prosjekt, rapporter
osv. er eksempler p&aring; typiske oppgaver. Denne modulen tillater
vurdering/karakterer. Læreren kan også gi en oppgave som ikke skal leveres over
Internett. Likevel kan tilbakemeldingen gis i systemet.
</p>
</ul>';
$string['modulenameplural'] = 'Innleveringer (2.2)';
$string['newsubmissions'] = 'Leverte oppgaver';
$string['noassignments'] = 'Det foreligger ingen oppgaver ennå';
$string['noattempts'] = 'Det har ikke vært gjort noen forsøk på denne oppgaven ennå.';
$string['noblogs'] = 'Du har ingen blogginnlegg å levere!';
$string['nofiles'] = 'Ingen filer ble sendt';
$string['nofilesyet'] = 'Ingen filer er lastet opp til siden ennå';
$string['nomoresubmissions'] = 'Ingen flere innleveringer er tillatt';
$string['norequiregrading'] = 'Det er ingen innleveringer som skal ha karakter';
$string['nosubmisson'] = 'Ingen besvarelser er levert';
$string['notavailableyet'] = 'Beklager, denne innleveringen er ikke tilgjengelig ennå.<br/>Instrukser for innleveringen vil vises på datoen som er oppgitt under.';
$string['notes'] = 'Notater';
$string['notesempty'] = 'Ingen notater';
$string['notesupdateerror'] = 'Feil ved oppdatering av notatet';
$string['notgradedyet'] = 'Ikke satt karakter enda';
$string['notsubmittedyet'] = 'Ikke levert enda';
$string['onceassignmentsent'] = 'Straks innleveringsfristen er ute, kan du ikke lenger slette eller legge til filer. Ønsker du å fortsette?';
$string['operation'] = 'Handling';
$string['optionalsettings'] = 'Valgfrie innstillinger';
$string['overwritewarning'] = 'Advarsel: Laster du opp på nytt vil du OVERSKRIVE din leverte oppgave';
$string['page-mod-assignment-submissions'] = 'Innsendingsside for innlevering';
$string['page-mod-assignment-view'] = 'Hovedside for innlevering';
$string['page-mod-assignment-x'] = 'Alle typer innleveringssider';
$string['pagesize'] = 'Innleveringer vist pr side';
$string['pluginadministration'] = 'Innleveringsadministrasjon';
$string['pluginname'] = 'Innlevering (2.2)';
$string['popupinnewwindow'] = 'Åpne i et popup-vindu';
$string['preventlate'] = 'Forhindre sene innleveringer';
$string['quickgrade'] = 'Tillat rask karaktersetting';
$string['quickgrade_help'] = '<p>Med hurtigvurdering kan du raskt vurdere mange innleveringer i samme skjermbilde.
</p>

<p>Det er bare å endre karakter og kommentarer og bruke "Lagre"-knappen på bunnen av siden. Da lagres alle vurderingene i en enkelt operasjon.
</p>

<p>De vanlige vurderingsknappene til høyre i skjermbildet virker fortsatt i tilfelle du trenger mer plass. Moodle lagrer innstillingen som en personlig preferanse og vil bruke denne i alle innleveringer i alle kurs.
</p>';
$string['requiregrading'] = 'Trenger karaktersetting';
$string['responsefiles'] = 'Responsfil';
$string['reviewed'] = 'Gjennomlest';
$string['saveallfeedback'] = 'Lagre og send tilbakemelding(ene)';
$string['selectblog'] = 'Velg hvilket blogginnlegg du vil sende inn';
$string['sendformarking'] = 'Send for karaktersetting';
$string['showrecentsubmissions'] = 'Vis nylige innleveringer';
$string['submission'] = 'Innlevering';
$string['submissiondraft'] = 'Innleveringskladd';
$string['submissionfeedback'] = 'Tilbakemelding';
$string['submissions'] = 'Leveringer';
$string['submissionsaved'] = 'Dine endringer er lagret';
$string['submissionsnotgraded'] = '{$a} innleveringer ikke karaktersatt';
$string['submitassignment'] = 'Lever din oppgave med nettskjemaet nedenfor';
$string['submitedformarking'] = 'Innleveringen er allerede under behandling av lærer og kan ikke oppdateres';
$string['submitformarking'] = 'Endelig innlevering for vurdering';
$string['submitted'] = 'Levert';
$string['submittedfiles'] = 'Leverte filer';
$string['subplugintype_assignment'] = 'Oppgavetype';
$string['subplugintype_assignment_plural'] = 'Innleveringstyper';
$string['trackdrafts'] = 'Slå på knappen "Send til karaktersetting"';
$string['trackdrafts_help'] = '<p>"Send inn til vurdering"-knappen lar deltakeren fortelle læreren at de har avsluttet arbeidet med innleveringen. Lærere kan tilbakestille innleveringen til "Kladd" dersom innleveringen bør jobbes mer med f.eks.
</p>';
$string['typeblog'] = 'Bloggpost';
$string['typeoffline'] = 'Frakoplet aktivitet';
$string['typeonline'] = 'Online tekst';
$string['typeupload'] = 'Last opp flere filer';
$string['typeuploadsingle'] = 'Last opp fil';
$string['unfinalize'] = 'Tilbakestilt som kladd';
$string['unfinalizeerror'] = 'En feil oppsto slik at innleveringen ikke kunne gjøres om til kladd igjen';
$string['unfinalize_help'] = 'Endring til Kladd lar studentene gjøre nye oppdateringer av innleveringene.';
$string['unsupportedsubplugin'] = 'Innleveringstypen \'{$a}\' støttes ikke i gjeldende versjon. Du kan vente til innleveringstypen blir tilgjengelig i oppdatert versjon eller slette den.';
$string['upgradenotification'] = 'Denne aktiviteten er basert på en eldre innleveringsmodul';
$string['uploadafile'] = 'Last opp en fil';
$string['uploadbadname'] = 'Filnavnet inneholdt ugyldige tegn og filen kunne derfor ikke lastes opp';
$string['uploadedfiles'] = 'Opplastede filer';
$string['uploaderror'] = 'En feil oppstod ved lagring av filen på serveren';
$string['uploadfailnoupdate'] = 'Filen ble lastet opp uten problemer, men vi kunne ikke oppdatere din levering!';
$string['uploadfiles'] = 'Last opp filer';
$string['uploadfiletoobig'] = 'Beklager, filen er for stor (grensen er {$a} byte)';
$string['uploadnofilefound'] = 'Ingen fil ble levert - er du sikker på at du valgte en å laste opp, eller er filen for stor?';
$string['uploadnotregistered'] = '\'{$a}\' ble lastet opp riktig men leveringen kunne ikke registreres!';
$string['uploadsuccess'] = 'Lastet opp \'{$a}\' uten problemer';
$string['usermisconf'] = 'Brukeren er feilkonfigurert';
$string['usernosubmit'] = 'Beklager, men du har ikke tillatelse til å foreta innlevering';
$string['viewassignmentupgradetool'] = 'Vis oppgraderingsverktøyet for innlevering';
$string['viewfeedback'] = 'Vis karakterer og tilbakemeldinger';
$string['viewmysubmission'] = 'Se min innlevering';
$string['viewsubmissions'] = 'Vis {$a} leverte oppgaver';
$string['yoursubmission'] = 'Din levering';
