<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'no', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har innleveringer som behøver din oppmerksomhet.';
$string['addattempt'] = 'Tillat et nytt forsøk';
$string['addnewattempt'] = 'Legg til et nytt forsøk';
$string['addnewattemptfromprevious'] = 'Legg til et nytt forsøk basert på forrige innlevering';
$string['addnewattemptfromprevious_help'] = 'Dette kopierer innholdet fra din forrige innlevering til en ny innlevering som du kan jobbe videre med.';
$string['addnewattempt_help'] = 'Dette oppretter en ny tom innlevering som du kan jobbe med.';
$string['addsubmission'] = 'Legg til innlevering';
$string['allocatedmarker'] = '';
$string['allocatedmarker_help'] = 'Karaktersetter for denne innleveringen.';
$string['allowsubmissions'] = 'Tillat brukeren å fortsette og levere inn besvarelser til denne innleveringen.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Informasjon om innleveringen og innsendingsskjemaet finner du her: <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Tillat innsending fra';
$string['allowsubmissionsfromdate_help'] = 'Hvis denne funksjonen er aktivert, kan ikke studentene levere før denne datoen. Hvis den er deaktivert, kan studentene levere inn med en gang.';
$string['allowsubmissionsfromdatesummary'] = 'Denne innleveringsoppgaven godtar innleveringer som er sendt inn fra <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Tillat endring av innsending';
$string['alwaysshowdescription'] = 'Vis alltid beskrivelse';
$string['alwaysshowdescription_help'] = 'Hvis denne funksjonen er deaktivert, blir innleveringsbeskrivelsen ovenfor synlig for studentene på "Tillat innleveringer fra"-datoen.';
$string['applytoteam'] = 'Gjør karakterer og tilbakemeldinger gjeldende for helle gruppen';
$string['assign:addinstance'] = 'Legg til ny innlevering';
$string['assign:exportownsubmission'] = 'Eksporter din innlevering';
$string['assignfeedback'] = 'Tilbakemeldingsmodul';
$string['assignfeedbackpluginname'] = 'Tilbakemeldingsmodul';
$string['assign:grade'] = 'Oppgave med karakterer';
$string['assign:grantextension'] = 'Gi utsettelse';
$string['assign:manageallocations'] = 'Administrer karaktersettere for denne innleveringen.';
$string['assign:managegrades'] = 'Forhåndsvis og publiser karakterer';
$string['assignmentisdue'] = 'Frist for innlevering';
$string['assignmentmail'] = '{$a->grader} har lagt ut en tilbakemelding på din innlevering for \'{$a->assignment}\'.

Du kan se tilbakemeldingen her: {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} har lagt ut en tilbakemelding på din innlevering til \'<i>{$a->assignment}</i>\'</p> <p>Du kan se tilbakemeldingen <a href="{$a->url}">her</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} har lagt ut en tilbakemelding på din innlevering for \'{$a->assignment}\'.

Den er lagt til innleveringen din.';
$string['assignmentname'] = 'Oppgavenavn';
$string['assignmentplugins'] = 'Oppgavemoduler';
$string['assignmentsperpage'] = 'Oppgaver pr. side';
$string['assign:releasegrades'] = 'Publiser karakterer';
$string['assign:revealidentities'] = 'Vis studentenes identitet';
$string['assign:reviewgrades'] = 'Forhåndsvis karakterer';
$string['assignsubmission'] = 'Innsendingsmodul';
$string['assignsubmissionpluginname'] = 'Innsendingsmodul';
$string['assign:submit'] = 'Send inn oppgavesvaret';
$string['assign:view'] = 'Se på oppgave';
$string['attemptheading'] = 'Forsøk {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Tidligere forsøk';
$string['attemptnumber'] = 'Forsøk nummer';
$string['attemptreopenmethod'] = 'Forsøk gjenåpnet';
$string['attemptreopenmethod_help'] = 'Bestemmer hvordan studentinnleveringer skal gjenåpnes. De tilgjengelige alternativene er: <ul><li>Aldri - Studentens innlevering kan ikke gjenåpnes.</li><li>Manuelt - Studentens innlevering kan gjenåpnes av en lærer.</li><li>Automatisk til bestått - Studentens innlevering blir gjenåpnet automatisk fram til studenten oppnår ståkarakteren som er oppgitt i karakterboken (delen for kategorier og elementer) for denne oppgaven.</li></ul>';
$string['attemptreopenmethod_manual'] = 'Manuelt';
$string['attemptreopenmethod_none'] = 'Aldri';
$string['attemptreopenmethod_untilpass'] = 'Automatisk til bestått';
$string['attemptsettings'] = 'Forsøksinnstillinger';
$string['availability'] = 'Tilgjengelighet';
$string['backtoassignment'] = 'Tilbake til innleveringen';
$string['batchoperationconfirmaddattempt'] = 'Tillat et forsøk til for valgte innleveringer?';
$string['batchoperationconfirmgrantextension'] = 'Gi utsettelse til alle valgte innleveringer?';
$string['batchoperationconfirmlock'] = 'Skal alle valgte innsendinger låses?';
$string['batchoperationconfirmreverttodraft'] = 'Gjøre om de valgte innleveringene til utkast?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Angi tildeling av oppgaver for alle valgte innleveringer?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Angi status for arbeidsflyt for vurdering for alle valgte  innleveringer?';
$string['batchoperationconfirmunlock'] = 'Låse opp alle de valgte innleveringene?';
$string['batchoperationlock'] = 'lås innsendinger';
$string['batchoperationreverttodraft'] = 'Tilbakestill innsendinger til kladd';
$string['batchoperationsdescription'] = 'Med valgte...';
$string['batchoperationunlock'] = 'lås opp innsendinger';
$string['batchsetallocatedmarker'] = 'Angi tildeling for vurdering for {$a} valgte brukere.';
$string['batchsetmarkingworkflowstateforusers'] = 'Angi status for vurderingsarbeidsflyt for {$a} valgte brukere.';
$string['blindmarking'] = 'Anonym karaktersetting';
$string['blindmarking_help'] = 'Anonym karaktersetting skjuler studentenes identitet for den som setter karakter. Innstillingene for anonym karaktersetting låses når en innlevering eller karakter er utført i forbindelse med denne oppgaven.';
$string['changegradewarning'] = 'Denne innleveringen inneholder besvarelser som allerede er karaktersatt. Hvis du endrer karakteren, vil ikke eksisterende karakterer regnes om automatisk. Du må gjøre om karakterene på samtlige eksisterende besvarelser hvis du ønsker å endre karakteren.';
$string['choosegradingaction'] = 'Handling for karaktersetting';
$string['choosemarker'] = 'Velg...';
$string['chooseoperation'] = 'Velg handling';
$string['comment'] = 'Kommentar';
$string['completionsubmit'] = 'Studenten må levere inn noe til denne aktiviteten for å fullføre den.';
$string['configshowrecentsubmissions'] = 'Alle kan se merknader til innleveringer i de siste aktivitetsrapporter.';
$string['confirmbatchgradingoperation'] = 'Er du sikker på at du vil {$a->operation} for {$a->count} studenter?';
$string['confirmsubmission'] = 'Er du sikker på at du vil levere inn arbeidet ditt til vurdering? Da kan du ikke gjøre flere endringer.';
$string['conversionexception'] = 'Kunne ikke konvertere innleveringen. Unntaket var: {$a}.';
$string['couldnotconvertgrade'] = 'Kunne ikke konvertere innleveringskarakteren til bruker {$a}.';
$string['couldnotconvertsubmission'] = 'Kunne ikke konvertere innleveringen til bruker {$a}.';
$string['couldnotcreatecoursemodule'] = 'Kunne ikke opprette kursmodulen.';
$string['couldnotcreatenewassignmentinstance'] = 'Kunne ikke opprette ny innleveringsinstans.';
$string['couldnotfindassignmenttoupgrade'] = 'Kunne ikke finne noen gammel innleveringsinstanse å oppgradere.';
$string['currentattempt'] = 'Dette er forsøk {$a}.';
$string['currentattemptof'] = 'Dette er forsøk {$a->attemptnumber} ( {$a->maxattempts} forsøk tillatt ).';
$string['currentgrade'] = 'Nåværende karakter i karakterboka';
$string['cutoffdate'] = 'Siste dato for innlevering';
$string['cutoffdatefromdatevalidation'] = 'Siste dato for innlevering må være etter åpningsdatoen for innleveringer.';
$string['cutoffdate_help'] = 'Hvis denne funksjonen brukes, vil ikke innleveringen godta innsendinger etter denne datoen uten forlengelse.';
$string['cutoffdatevalidation'] = 'Siste dato for innlevering må være etter fristen.';
$string['defaultsettings'] = 'Standardinnstillinger for innleveringsmodulen';
$string['defaultsettings_help'] = 'Disse innstillingene bestemmer standardinnstillingene for alle nye innleveringer.';
$string['defaultteam'] = 'Standardgruppe';
$string['deleteallsubmissions'] = 'Slett alle innleveringer';
$string['description'] = 'Beskrivelse';
$string['downloadall'] = 'Last ned alle innsendinger';
$string['duedate'] = 'Innleveringsfrist';
$string['duedate_help'] = 'Dette er fristen for innleveringen. Hvis for sene innleveringer tillates, vil alle besvarelser som er levert inn etter denne datoen merkes som sen.';
$string['duedateno'] = 'Ingen innleveringsfrist';
$string['duedatereached'] = 'Fristen for denne innleveringen har passert.';
$string['duedatevalidation'] = 'Innleveringsfristen må være etter innleveringens åpningsdato.';
$string['editaction'] = 'Handlinger...';
$string['editattemptfeedback'] = 'Rediger karakteren og tilbakemeldingen for forsøk nummer {$a}';
$string['editingpreviousfeedbackwarning'] = 'Du redigerer tilbakemeldingen til et tidligere forsøk. Dette er forsøk {$a->attemptnumber} av {$a->totalattempts}.';
$string['editingstatus'] = 'Redigerer status';
$string['editsubmission'] = 'Rediger innleveringen';
$string['editsubmission_help'] = 'Gjør endringer på din innlevering';
$string['enabled'] = 'Aktivert';
$string['errornosubmissions'] = 'Det er ingen innleveringer å laste ned';
$string['errorquickgradingvsadvancedgrading'] = 'Karakterene ble ikke lagret fordi denne innleveringen bruker avansert karaktersetting.';
$string['errorrecordmodified'] = 'Karakterene ble ikke lagret fordi noen har endret en eller flere oppføringer siden du lastet siden.';
$string['event_all_submissions_downloaded'] = 'Alle innleveringene bli lastet ned.';
$string['event_assessable_submitted'] = 'En innlevering har blitt levert inn.';
$string['event_extension_granted'] = 'Det har blitt gitt en utsettelse.';
$string['event_identities_revealed'] = 'Alle identitene har blitt avslørt.';
$string['event_marker_updated'] = 'Oppgavetildelingen er oppdatert.';
$string['event_statement_accepted'] = 'Brukeren har akseptert innleveringserklæringen';
$string['event_submission_duplicated'] = 'Brukeren duplikerte innleveringen sin';
$string['event_submission_graded'] = 'Det har blitt satt en karakter på innleveringen.';
$string['event_submission_locked'] = 'Innleveringen har blitt låst for en bruker';
$string['event_submission_status_updated'] = 'Innleveringsstatusen har blitt oppdatert';
$string['event_submission_unlocked'] = 'Innleveringen har blitt låst opp for en bruker.';
$string['event_submission_updated'] = 'Brukeren har lagret en innlevering';
$string['event_workflow_state_updated'] = 'Status for vurderingsarbeidsflyt er oppdatert.';
$string['extensionduedate'] = 'Frist for forlengelse';
$string['extensionnotafterduedate'] = 'Frist for forlengelse må være etter ordinær frist.';
$string['extensionnotafterfromdate'] = 'Frist for forlengelse må være etter åpningsdatoen for innleveringer.';
$string['feedback'] = 'Tilbakemelding';
$string['feedbackavailablehtml'] = '{$a->username} har postet tilbakemeldinger på innleveringen din for \'<i>{$a->assignment}</i>\'<br /><br /> Du kan se tilbakemeldingen <a href="{$a->url}">her</a>.';
$string['feedbackavailablesmall'] = '{$a->username} har gitt tilbakemelding på innleveringen {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} har postet en tilbakemelding på innleveringen for \'{$a->assignment}\'

Du kan se tilbakemeldingen her: {$a->url}';
$string['feedbackplugin'] = 'Tilbakemeldingsmodul';
$string['feedbackpluginforgradebook'] = 'Modul for tilbakemeldinger som vil presse kommentarer til karakterboken.';
$string['feedbackpluginforgradebook_help'] = 'Bare en modul for tilbakemeldinger kan flytte tilbakemeldinger inn i karakterboken.';
$string['feedbackplugins'] = 'Tilbakemeldingsmoduler';
$string['feedbacksettings'] = 'Innstillinger for tilbakemelding';
$string['feedbacktypes'] = 'Tilbakemeldingstyper';
$string['filesubmissions'] = 'Filinnsendiger';
$string['filter'] = 'Filter';
$string['filternone'] = 'Ingen filter';
$string['filterrequiregrading'] = 'Krever karakter';
$string['filtersubmitted'] = 'Levert';
$string['gradeabovemaximum'] = 'Karakteren må være mindre enn eller lik {$a}.';
$string['gradebelowzero'] = 'Karakteren må være høyere enn eller lik null.';
$string['gradecanbechanged'] = 'Karakter kan endres';
$string['graded'] = 'Karaktersatt';
$string['gradedby'] = 'Vurdert av';
$string['gradedon'] = 'Vurdert den';
$string['gradelocked'] = 'Denne karakteren er låst eller overstyrt i karakterboken.';
$string['gradeoutof'] = 'Karakter av {$a} mulige.';
$string['gradeoutofhelp'] = 'Karakter';
$string['gradeoutofhelp_help'] = 'Skriv karakteren på studentens innlevering her. Du kan bruke desimaler hvis du ønsker det.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} har oppdatert sin innlevering av oppgave
for <i>\'{$a->assignment}\'  {$a->timeupdated}</i><br /><br />
Den er <a href="{$a->url}">tilgjengelig på nettstedet</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} har oppdatert besvarelsen sin for innleveringen {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} har oppdatert sin oppgaveinnlevering for \'{$a->assignment}\'  {$a->timeupdated}

Den er tilgjengelig her:

{$a->url}';
$string['gradestudent'] = 'Gi karakter til student: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Karakter {$a}';
$string['grading'] = 'Karaktersetting';
$string['gradingchangessaved'] = 'Karakterendringene ble lagret';
$string['gradingmethodpreview'] = 'Kriterier for karaktersetting';
$string['gradingoptions'] = 'Innstillinger';
$string['gradingstatus'] = 'Karaktersettingsstatus';
$string['gradingstudent'] = 'Gir karakter til student';
$string['gradingsummary'] = 'Oversikt over karakterer';
$string['grantextension'] = 'Gi forlengelse';
$string['grantextensionforusers'] = 'Gi forlengelse til {$a} studenter';
$string['groupsubmissionsettings'] = 'Innstillinger for gruppeinnleveringer';
$string['hiddenuser'] = 'Deltaker';
$string['hideshow'] = 'Skjul/Vis';
$string['instructionfiles'] = 'Instruksjonsfiler';
$string['invalidfloatforgrade'] = 'Den oppgitte karakteren ble ikke forstått: {$a}';
$string['invalidgradeforscale'] = 'Den oppgitte karakteren var ikke gyldig for den gjeldende skalaen.';
$string['lastmodifiedgrade'] = 'Sist endret (karakter)';
$string['lastmodifiedsubmission'] = 'Sist endret (innsending)';
$string['latesubmissions'] = 'Sene innleveringer';
$string['latesubmissionsaccepted'] = 'Kun studenter som har fått forlengelse innvilget kan fortsatt sende inn innleveringen.';
$string['locksubmissionforstudent'] = 'Forhindre flere innleveringer fra student: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Lås innsendinger';
$string['manageassignfeedbackplugins'] = 'Administrere moduler for tilbakemeldinger på innleveringer';
$string['manageassignsubmissionplugins'] = 'Administrere moduler for innsending av innleveringer';
$string['marker'] = 'Karaktersetter';
$string['markerfilter'] = 'Rettefilter';
$string['markingallocation'] = 'Bruk tildeling av oppgaver for vurdering';
$string['markingallocation_help'] = 'Når aktivert vil denne innstillingen gjøre det mulig å tildele studenter individuelt til karaktersetterne. Dette krever at arbeidsflyt for vurdering er aktivert.';
$string['markingworkflow'] = 'Bruk arbeidsflyt for karaktersetting';
$string['markingworkflow_help'] = 'Hvis aktivert, vil vurderingen foregå som en del av en arbeidsflyt før den publiseres til studentene. Dette åpner for flere runder med vurdering av oppgavene og at endelig vurdering publiseres til studentene til samme tid.';
$string['markingworkflowstate'] = 'Status for arbeidsflyt';
$string['markingworkflowstate_help'] = 'Mulige arbeidsflytstadier kan inkludere (avhengig av dine rettigheter):

* Ikke vurdert - vurderingen har ennå ikke startet.
* Under vurdering - vurderingen pågår, men er ikke avsluttet.
* Til gjennomgang - vurderingen er nå til gjennomgang av en ansvarlig lærer for kvalitetssjekk.
* Klar for publisering - ansvarlig lærer er fornøyd med vurderingen, men vil vente med å publisere resultatene for studentene.
* Publisert - studenten gis tilgang til vurdering og tilbakemelding.';
$string['markingworkflowstateinmarking'] = 'Under retting';
$string['markingworkflowstateinreview'] = 'Blir vurdert';
$string['markingworkflowstatenotmarked'] = 'Ikke vurdert';
$string['markingworkflowstatereadyforrelease'] = 'Klar for publisering';
$string['markingworkflowstatereadyforreview'] = 'Karaktersetting fullført';
$string['markingworkflowstatereleased'] = 'Publisert';
$string['maxattempts'] = 'Maks antall forsøk';
$string['maxattempts_help'] = 'Maks antall innleveringsforsøk som kan gjøres av en student. Etter dette antallet har blitt levert kan ikke studenten gjenåpne innleveringen.';
$string['maxgrade'] = 'Høyeste karakter';
$string['messageprovider:assign_notification'] = 'Innleveringsvarsler';
$string['modulename'] = 'Innlevering';
$string['modulename_help'] = 'Aktivitetsmodulen "Innlevering" gjør det mulig for læreren å annonsere oppgaver, samle inn studentenes arbeid, og gi karakterer og tilbakemeldinger.

Studentene kan levere inn alt slags digitalt innhold (filer), for eksempel tekstbehandlingsdokumenter, regneark, bilder, eller lyd- og videoklipp. Som et alternativ, eller i tillegg, kan innleveringen kreve at studentene skal skrive inn tekst direkte i teksteditoren. Innleveringer kan også brukes til å minne studentene på praktiske oppgaver som de må fullføre utenfor internett som ikke krever noe digitalt innhold, for eksempel en oppgave innen kunst og håndverk. Studentene kan levere inn arbeider individuelt eller som medlem av en gruppe.

Når innleveringene gjennomgås, kan lærerne legge til tilbakemeldinger og kommentarer og laste opp filer, f.eks. ferdig vurderte innleveringer, dokumenter med kommentarer, eller innspilte lydfiler med tilbakemeldinger. Vurdering av innleveringer kan skje ved bruk av numerisk eller egendefinert karaktersettingsmetode, f.eks. en rubrikk. Endelige karakterer registreres i karakterboken.';
$string['modulenameplural'] = 'Innlevering';
$string['moreusers'] = '{$a} mer...';
$string['mysubmission'] = 'Min innlevering:';
$string['newsubmissions'] = 'Leverte oppgaver';
$string['noattempt'] = 'Ingen forsøk';
$string['nofiles'] = 'Ingen filer.';
$string['nograde'] = 'Ingen karakter.';
$string['nolatesubmissions'] = 'Ingen sene innleveringer godtas.';
$string['nomoresubmissionsaccepted'] = 'Ingen flere innleveringer godtas.';
$string['noonlinesubmissions'] = 'Denne innleveringen krever ikke at du skal levere inn noe på nett.';
$string['nosavebutnext'] = 'Neste';
$string['nosubmission'] = 'Ingenting har blitt levert inn til denne innleveringen.';
$string['nosubmissionsacceptedafter'] = 'Ingen innleveringer godtas etter';
$string['notgraded'] = 'Ikke vurdert';
$string['notgradedyet'] = 'Ikke satt karakter enda';
$string['notifications'] = 'Meldinger';
$string['notsubmittedyet'] = 'Ikke levert enda';
$string['nousersselected'] = 'Ingen brukere valgt';
$string['numberofdraftsubmissions'] = 'Utkast';
$string['numberofparticipants'] = 'Deltakere';
$string['numberofsubmissionsneedgrading'] = 'Må vurderes';
$string['numberofsubmittedassignments'] = 'Levert';
$string['numberofteams'] = 'Grupper';
$string['offline'] = 'Ingen innleveringer på nett påkrevd';
$string['open'] = 'Åpen';
$string['outlinegrade'] = 'Karakter: {$a}';
$string['outof'] = '{$a->current} av {$a->total}';
$string['overdue'] = '<font color="red">Innleveringen er forsinket med: {$a}</font>';
$string['page-mod-assign-view'] = 'Hovedsiden og innleveringssiden i innleveringsmodulen';
$string['page-mod-assign-x'] = 'Alle sider i oppgavemodulen';
$string['participant'] = 'Deltaker';
$string['pluginadministration'] = 'Administrering av innlevering';
$string['pluginname'] = 'Innlevering';
$string['preventsubmissions'] = 'Forhindre brukeren fra å levere inn flere besvarelser til denne innleveringen.';
$string['preventsubmissionsshort'] = 'Forhindre endringer i innleveringer';
$string['previous'] = 'Forrige';
$string['quickgrading'] = 'Hurtig karaktersetting';
$string['quickgradingchangessaved'] = 'Endringene i karakterene ble lagret';
$string['quickgrading_help'] = 'Hurtig karaktersetting lar deg tildele karakterer (og resultater) direkte i innleveringstabellen. Hurtig karaktersetting er ikke forenelig med avansert karaktersetting, og er ikke anbefalt når det er flere lærere involvert i karaktersettingen.';
$string['quickgradingresult'] = 'Hurtig karaktersetting';
$string['recordid'] = 'Identifikator';
$string['requireallteammemberssubmit'] = 'Krev at alle gruppemedlemmer leverer';
$string['requireallteammemberssubmit_help'] = 'Hvis denne funksjonen er aktivert, må alle medlemmene i studentgruppen klikke på send-knappen i denne innleveringen for at gruppeinnleveringen skal telle som levert. Hvis den er deaktivert, blir gruppeinnleveringen registrert som levert så fort et medlem av studentgruppen klikker på send-knappen.';
$string['requiresubmissionstatement'] = 'Krev at studentene skal godta innleveringserklæringen';
$string['requiresubmissionstatement_help'] = 'Krev at studentene skal godta innleveringserklæringen for alle innleveringene på denne oppgaven.';
$string['revealidentities'] = 'Vis studentidentiteter';
$string['revealidentitiesconfirm'] = 'Er du sikker på at du vil vise studentidentitetene i denne innleveringen? Denne handlingen kan ikke omgjøres. Så fort studentidentitetene har blitt vist, blir karakterene frigitt til karakterboken.';
$string['reverttodraft'] = 'Tilbakestill innleveringen til utkast-status';
$string['reverttodraftforstudent'] = 'Tilbakestill innleveringen til utkast for student:  (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Tilbakestill innleveringen til utkast';
$string['reviewed'] = 'Gjennomlest';
$string['saveallquickgradingchanges'] = 'Lagre alle endringene i hurtig karaktersetting';
$string['savechanges'] = 'Lagre endringer';
$string['savegradingresult'] = 'Karakter';
$string['savenext'] = 'Lagre og vis neste';
$string['scale'] = 'Skala';
$string['selectedusers'] = 'Valgte brukere';
$string['selectlink'] = 'Velg...';
$string['selectuser'] = 'Velg {$a}';
$string['sendlatenotifications'] = 'Varsle karaktergivere om sene innleveringer';
$string['sendlatenotifications_help'] = 'Hvis denne funksjonen er aktivert, vil karaktergivere (vanligvis lærere) motta en melding når studenter leverer en besvarelse sent. Meldingsmetoder kan konfigureres.';
$string['sendnotifications'] = 'Varsle karaktergivere om innleveringer';
$string['sendnotifications_help'] = 'Hvis denne funksjonen er aktivert, vil karaktergivere (vanligvis lærere) motta en melding når studenter leverer en besvarelse tidlig, til rett tid og sent. Meldingmetoder kan konfigureres.';
$string['sendstudentnotifications'] = 'Varsle studenter';
$string['sendstudentnotifications_help'] = 'Hvis aktivert vil studentene få en melding om oppdatert karakter eller tilbakemelding';
$string['sendsubmissionreceipts'] = 'Send innleveringskvittering til studentene';
$string['sendsubmissionreceipts_help'] = 'Denne bryteren vil aktivere innleveringskvitteringer for studenter. Studentene vil motta en melding hver gang de leverer inn en besvarelse.';
$string['setmarkerallocationforlog'] = 'Angi vurderingstildelig : (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Angi hvem som skal vurdere';
$string['setmarkingworkflowstate'] = 'Angi fase i vurderingsarbeidsflyt';
$string['setmarkingworkflowstateforlog'] = 'Angi fase i arbeidsflyt: (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Innleveringsinnstillinger';
$string['showrecentsubmissions'] = 'Vis nylige innleveringer';
$string['status'] = 'Status';
$string['submission'] = 'Innlevering';
$string['submissioncopiedhtml'] = '<p>Du har laget en kopi av din tidligere oppgavebesvarelse for \'<i>{$a->assignment}</i>\'</p> <p>Du kan se statusen på din <a href="{$a->url}">innlevering</a>.</p>';
$string['submissioncopiedsmall'] = 'Du har laget en kopi av din tidligere oppgavebesvarelse for {$a->assignment}';
$string['submissioncopiedtext'] = 'Du har laget en kopi av din tidligere oppgavebesvarelse for \'{$a->assignment}\'

Du kan se statusen på din innlevering:

 {$a->url}';
$string['submissiondrafts'] = 'Krev at studentene klikker på lever-knappen';
$string['submissiondrafts_help'] = 'Hvis denne funksjonen er aktivert, vil studentene måtte klikke på Lever-knappen for å erklære at innleveringen deres er endelig. Dette gjør det mulig for studentene å beholde et utkast av innleveringen i systemet. Hvis denne innstillingen endres fra "Nei" til "Ja" etter studentene allerede har levert, vil de innleveringene bli regnet som endelige.';
$string['submissioneditable'] = 'Studenter kan redigere denne innleveringen';
$string['submissionempty'] = 'Ingenting ble sendt inn';
$string['submissionnotcopiedinvalidstatus'] = 'Innleveringen ble ikke kopiert fordi den har blitt redigert siden den ble gjenåpnet.';
$string['submissionnoteditable'] = 'Studenter kan ikke redigere denne innleveringen';
$string['submissionnotready'] = 'Denne oppgavebesvarelsen er ikke klar til innlevering:';
$string['submissionplugins'] = 'Innleveringsmoduler';
$string['submissionreceipthtml'] = '<p>Du har levert en oppgavebesvarelse for \'<i>{$a->assignment}</i>\'</p><p> Du kan se status på din<a href="{$a->url}">innlevering</a>.</p>';
$string['submissionreceipts'] = 'Send innleveringskvitteringer';
$string['submissionreceiptsmall'] = 'Du har levert din oppgavebesvarelse for {$a->assignment}';
$string['submissionreceipttext'] = 'Du har levert en oppgavebesvarelse for {$a->assignment}

Du kan se status på din innlevering:  {$a->url}';
$string['submissions'] = 'Leveringer';
$string['submissionsclosed'] = 'Innleveringene er stengt';
$string['submissionsettings'] = 'Innstillinger for innlevering';
$string['submissionslocked'] = 'Denne innleveringen tar ikke imot innleveringer';
$string['submissionslockedshort'] = 'Endringer i innleveringer ikke tillatt';
$string['submissionsnotgraded'] = 'Innleveringer ikke karaktersatt: {$a}';
$string['submissionstatement'] = 'Innleveringserklæring';
$string['submissionstatementacceptedlog'] = 'Innleveringserklæring godtatt av bruker {$a}';
$string['submissionstatementdefault'] = 'Denne innleveringen er mitt eget arbeid, unntatt der hvor jeg har erkjent at jeg har brukt andres ideer og arbeid.';
$string['submissionstatement_help'] = 'Bekreftelsesmelding for innleveringserklæring';
$string['submissionstatus'] = 'Status på innlevering';
$string['submissionstatus_'] = 'Ingen innlevering';
$string['submissionstatus_draft'] = 'Utkast (ikke levert)';
$string['submissionstatusheading'] = 'Status på innlevering';
$string['submissionstatus_marked'] = 'Karaktersatt';
$string['submissionstatus_new'] = 'Ny innlevering';
$string['submissionstatus_reopened'] = 'Gjenåpnet';
$string['submissionstatus_submitted'] = 'Levert til vurdering';
$string['submissionsummary'] = '{$a->status}. Sist endret {$a->timemodified}';
$string['submissionteam'] = 'Gruppe';
$string['submissiontypes'] = 'Innleveringstyper';
$string['submitaction'] = 'Levér';
$string['submitassignment'] = 'Send inn oppgavesvaret';
$string['submitassignment_help'] = 'Når du har levert denne oppgavebesvarelsen, vil du ikke kunne gjøre flere endringer.';
$string['submitted'] = 'Levert';
$string['submittedearly'] = 'Oppgavebesvarelsen ble levert {$a} for tidlig.';
$string['submittedlate'] = 'Oppgavebesvarelsen ble levert {$a} for sent.';
$string['submittedlateshort'] = '{$a} for sent';
$string['subplugintype_assignfeedback'] = 'Feedbackmodul';
$string['subplugintype_assignfeedback_plural'] = 'Feedbackmoduler';
$string['subplugintype_assignsubmission'] = 'Innleveringsmodul';
$string['subplugintype_assignsubmission_plural'] = 'Innleveringsmoduler';
$string['teamsubmission'] = 'Studenter leverer i grupper';
$string['teamsubmissiongroupingid'] = 'Tilgangsgruppe for studentgrupper';
$string['teamsubmissiongroupingid_help'] = 'Dette er tilgangsgruppen som innleveringen vil bruke for å finne grupper til studentgrupper. Hvis ingenting er angitt, blir standard gruppesett brukt.';
$string['teamsubmission_help'] = 'Hvis denne funksjonen er aktivert, blir studentene delt inn i grupper basert på standard gruppesett eller egendefinert tilgangsgruppe. En gruppeinnlevering vil bli delt mellom gruppemedlemmene, og alle gruppens medlemmer vil se hverandres endringer på innleveringen.';
$string['teamsubmissionstatus'] = 'Status på gruppeinnlevering';
$string['textinstructions'] = 'Innleveringsanvisninger';
$string['timemodified'] = 'Sist endret';
$string['timeremaining'] = 'Tid som gjenstår';
$string['unlimitedattempts'] = 'Ubegrenset';
$string['unlimitedattemptsallowed'] = 'Ubegrenset antall forsøk tillatt.';
$string['unlocksubmissionforstudent'] = 'Tillat innleveringer for student: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Lås opp innleveringer';
$string['updategrade'] = 'Oppdater karakter';
$string['updatetable'] = 'Lagre og oppdater tabell';
$string['upgradenotimplemented'] = 'Oppgradering ikke implementert i modul ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Forlengelse innvilget til: {$a}';
$string['usergrade'] = 'Brukers karakter';
$string['userswhoneedtosubmit'] = 'Brukere som må levere: {$a}';
$string['validmarkingworkflowstates'] = 'Gyldig fase i vurderingsarbeidsflyt';
$string['viewbatchmarkingallocation'] = 'Vis massehåndteringssiden for tildeling av oppgaver.';
$string['viewbatchsetmarkingworkflowstate'] = 'Vis massehåndteringsside for vurderingsarbeidsflyt.';
$string['viewfeedback'] = 'Vis tilbakemelding';
$string['viewfeedbackforuser'] = 'Vis tilbakemelding for bruker: {$a}';
$string['viewfull'] = 'Vis hele';
$string['viewfullgradingpage'] = 'Åpne karaktersettingssiden fullt ut for å gi tilbakemelding';
$string['viewgradebook'] = 'Vis karakterboken';
$string['viewgrading'] = 'Vis/sett karakter på alle innleveringer';
$string['viewgradingformforstudent'] = 'Vis karaktersiden for student: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Vis egen innleveringsside for oppgavebesvarelse.';
$string['viewownsubmissionstatus'] = 'Vis statussiden for egen innlevering';
$string['viewrevealidentitiesconfirm'] = 'Se side for visning av bekreftelse på studentidentitet';
$string['viewsubmission'] = 'Vis innlevering';
$string['viewsubmissionforuser'] = 'Vis innlevering for bruker: {$a}';
$string['viewsubmissiongradingtable'] = 'Vis karaktersettingstabell for innlevering';
$string['viewsummary'] = 'Vis oppsummering';
$string['workflowfilter'] = 'Filter for arbeidsflyt';
