<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'cy', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Rydych chi eisoes wedi mewngofnodi fel {$a}, mae angen i chi allgofnodi cyn mewngofnodi fel defnyddiwr gwahanol.';
$string['authnotexisting'] = 'Dydy\'r ategyn awdurdodi ddim yn bodoli';
$string['backupcontainexternal'] = 'Mae\'r ffeil copi wrth gefn hon yn cynnwys Gwesteiwyr Rhwydwaith Moodle nad ydynt wedi\'u ffurfweddu\'n lleol';
$string['backuptablefail'] = 'HEB lwyddo i sefydlu tablau wrth gefn!';
$string['blockcannotconfig'] = 'Dydy\'r bloc hwn ddim yn cefnogi ffurfweddu eang';
$string['blockcannotinistantiate'] = 'Roedd problem wrth enghreifftio\'r gwrthrych bloc';
$string['blockcannotread'] = 'Doedd dim modd darllen y data ar gyfer idbloc= {$a}';
$string['blockdoesnotexist'] = 'Dydy\'r bloc hwn ddim yn bodoli';
$string['blockdoesnotexistonpage'] = 'Dydy\'r bloc hwn (id={$a->instanceid}) ddim yn bodoli ar y dudalen hon ({$a->url}).';
$string['blocknameconflict'] = 'Enwau\'n gwrthdaro: mae gan floc {$a->name} yr un teitl â bloc sy\'n bodoli eisoes: {$a->gwrthdaro}! ';
$string['callbackrejectcomment'] = 'Mae\'r swyddogaeth gawl sylwadau\'n ôl wedi gwrthod y sylw hwn. ';
$string['cannotaddcoursemodule'] = 'Doedd dim modd ychwanegu modiwl cwrs newydd';
$string['cannotaddcoursemoduletosection'] = 'Doedd dim modd ychwanegu\'r modiwl cwrs newydd at yr adran honno';
$string['cannotaddmodule'] = 'Doedd dim modd ychwanegu\'r modiwl {$a} at y rhestr modiwlau!';
$string['cannotaddnewmodule'] = 'Doedd dim modd ychwanegu modiwl newydd o {$a}';
$string['cannotaddrss'] = 'Does gennych chi ddim caniatâd i ychwanegu crynodebau rss';
$string['cannotaddthisblocktype'] = 'Allwch chi ddim ychwanegu bloc {$a} at y dudalen hon.';
$string['cannotassignrole'] = 'Does dim modd neilltuo\'r swyddogaeth mewn cwrs';
$string['cannotassignrolehere'] = 'Dydych chi ddim yn cael neilltuo\'r swyddogaeth hon (id = {$a->roleid}) yn y cyd-destun hwn ({$a->context})';
$string['cannotassignselfasparent'] = 'Does dim modd i chi neilltuo eich hun yn rhiant!';
$string['cannotcallscript'] = 'Chewch chi ddim galw\'r sgript hon yn y ffordd honno';
$string['cannotcallusgetselecteduser'] = 'Does dim modd galw user_selector::get_selected_user os yw\'r amlddewis wedi\'i osod fel gwir.';
$string['cannotcreatebackupdir'] = 'Doedd dim modd creu ffolder copi wrth gefn. Mae angen i weinyddwr y safle gywiro\'r hawliau ffeiliau.';
$string['cannotcreatecategory'] = 'Doedd y categori ddim wedi\'i osod';
$string['cannotcreatedboninstall'] = '<p>Methu creu y gronfa ddata.</p> <p>Dydy’r gronfa ddata benodedig ddim yn bodoli a does gan y defnyddiwr dan sylw ddim hawl i greu cronfa ddata.</p> <p>Dylai gweinyddwr y safle wirio ffurfweddu cronfeydd data.</p>';
$string['cannotcreategroup'] = 'Gwall wrth greu grŵp';
$string['cannotcreatelangbase'] = 'Gwall: Doedd dim modd creu cyfeiriadur iaith sylfaenol';
$string['cannotcreatelangdir'] = 'Does dim modd creu cyfeiriadur iaith';
$string['cannotcreateorfindstructs'] = 'Roedd gwall wrth ganfod neu greu strwythurau adran ar gyfer y cwrs hwn';
$string['cannotcreatepopupwin'] = 'Elfen heb ei diffinio - does dim modd creu ffenestr naid';
$string['cannotcreatesitedir'] = 'Does dim modd creu ffolder safle. Mae angen i weinyddwr y safle gywiro\'r hawliau ffeiliau.';
$string['cannotcreatetempdir'] = 'Does dim modd creu cyfeiriadur dros dro';
$string['cannotcreateuploaddir'] = 'Does dim modd creu ffolder llwytho i fyny. Mae angen i weinyddwr y safle gywiro\'r hawliau ffeiliau.';
$string['cannotcustomisefiltersblockuser'] = 'Does dim modd i chi addasu\'r gosodiadau hidlo mewn cyd-destun defnyddiwr nac mewn cyd-destun bloc.';
$string['cannotdeletebackupids'] = 'Doedd dim modd dileu\'r ids copi wrth gefn blaenorol';
$string['cannotdeletecategorycourse'] = 'Wedi methu dileu cwrs \'{$a}\'.';
$string['cannotdeletecategoryquestions'] = 'Doedd dim modd dileu\'r cwestiynau o\'r categori \'{$a}\'';
$string['cannotdeletecourse'] = 'Does gennych chi mo\'r caniatâd i ddileu\'r cwrs hwn';
$string['cannotdeletecustomfield'] = 'Roedd gwall wrth ddileu\'r data maes personol';
$string['cannotdeletedir'] = 'Does dim modd dileu ({$a})';
$string['cannotdeletefile'] = 'Does dim modd dileu\'r ffeil hon';
$string['cannotdeleterole'] = 'Does dim modd dileu, oherwydd {$a}';
$string['cannotdeleterolewithid'] = 'Doedd dim modd dileu\'r swyddogaeth hon ag ID {$s}';
$string['cannotdeletethisrole'] = 'Does dim modd dileu\'r swyddogaeth hon gan ei bod yn cael ei defnyddio gan y system, neu gan mai hon yw\'r swyddogaeth olaf gyda galluoedd gweinyddwr.';
$string['cannotdisableformat'] = 'Does dim modd i chi analluogi\'r fformat diofyn';
$string['cannotdownloadcomponents'] = 'Does dim modd llwytho cydrannau i lawr';
$string['cannotdownloadlanguageupdatelist'] = 'Does dim modd llwytho rhestr o ddiweddariadau iaith o download.moodle.org';
$string['cannotdownloadzipfile'] = 'Does dim modd llwytho ffeil ZIP i lawr';
$string['cannoteditcomment'] = 'Nid eich sylw chi yw hwn i\'w olygu!';
$string['cannoteditcommentexpired'] = 'Does dim modd i chi olygu hyn. Mae\'r amser wedi dod i ben!';
$string['cannoteditpostorblog'] = 'Does dim modd i chi bostio na golygu blogiau';
$string['cannoteditsiteform'] = 'Does dim modd golygu cwrs y safle drwy ddefnyddio\'r ffurflen hon';
$string['cannotedityourprofile'] = 'Mae\'n ddrwg gen i, does dim modd i chi olygu eich proffil eich hun';
$string['cannotexecduringupgrade'] = 'Methu ei roi ar waith yn ystod diweddariad';
$string['cannotfindcategory'] = 'Does dim modd canfod cofnod categori o\'r gronfa ddata yn ôl ID - {$a}';
$string['cannotfindcomponent'] = 'Does dim modd canfod cydran';
$string['cannotfindcontext'] = 'Doedd dim modd canfod cyd-destun';
$string['cannotfindcourse'] = 'Does dim modd canfod cwrs';
$string['cannotfinddocs'] = 'Does dim modd canfod ffeiliau dogfennau iaith "{$a}" ';
$string['cannotfindgradeitem'] = 'Does dim modd canfod grade_item';
$string['cannotfindgroup'] = 'Ddim yn gallu canfod grŵp';
$string['cannotfindhelp'] = 'Does dim modd canfod ffeiliau help iaith "{$a}"';
$string['cannotfindinfo'] = 'Does dim modd canfod gwybodaeth ar gyfer: "{$a}"';
$string['cannotfindlang'] = 'Does dim modd canfod pecyn iaith "{$a}"!';
$string['cannotfindteacher'] = 'Does dim modd canfod athro';
$string['cannotfinduser'] = 'Does dim modd canfod y defnyddiwr o\'r enw "{$a}" ';
$string['cannotgeoplugin'] = 'Methu cysylltu â’r gweinydd geoPlugin yn http://www.geoplugin.com, gwiriwch osodiadau’r dirprwy, neu’n well, gosodwch ffeil ddata MaxMind GeoLite';
$string['cannotgetblock'] = 'Doedd dim modd adfer blociau o\'r gronfa ddata';
$string['cannotgetcats'] = 'Does dim modd cael cofnod categori';
$string['cannotgetdata'] = 'Does dim modd cael data';
$string['cannotgradeuser'] = 'Does dim modd rhoi gradd i\'r defnyddiwr hwn';
$string['cannothaveparentcate'] = 'Does dim modd i gategori cwrs gael rhiant!';
$string['cannotimport'] = 'Gwall mewngludo';
$string['cannotimportformat'] = 'Mae\'n ddrwg gen i, dydy dull mewngludo\'r fformat hwn ddim wedi\'i roi ar waith eto!';
$string['cannotimportgrade'] = 'Gwall wrth fewngludo graddau';
$string['cannotinsertgrade'] = 'Does dim modd mewnosod eitem gradd heb id cwrs!';
$string['cannotinsertrate'] = 'Doedd dim modd mewnosod sgôr newydd ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Doedd dim modd mewnosod ID cofnod newydd {$a}';
$string['cannotmailconfirm'] = 'Roedd gwall wrth anfon e-bost yn cadarnhau newid cyfrinair';
$string['cannotmanualctrack'] = 'Dydy\'r gweithgaredd ddim yn darparu proses ar gyfer olrhain cwblhad eich hun';
$string['cannotmapfield'] = 'Wedi canfod gwrthdrawiad mapio - dau fap maes i\'r un eitem gradd {$a}';
$string['cannotmarktopic'] = 'Doedd dim modd marcio\'r pwnc hwnnw ar gyfer y cwrs hwn';
$string['cannotmigratedatacomments'] = 'Does dim modd mudo sylwadau\'r modiwl data';
$string['cannotmodulename'] = 'Does dim modd cael enw\'r modiwl yn y swyddogaeth adeiladu bar llywio';
$string['cannotmoduletype'] = 'Does dim modd cael y math o fodiwl yn y swyddogaeth adeiladu bar llywio';
$string['cannotmovecategory'] = 'Does dim modd symud y categori';
$string['cannotmoverolewithid'] = 'Does dim modd symud swyddogaeth gydag ID {$a}';
$string['cannotopencsv'] = 'Does dim modd agor ffeil CSV';
$string['cannotopenfile'] = 'Does dim modd agor ffeil ({$a})';
$string['cannotopenforwrit'] = 'Does dim modd agor ar gyfer ysgrifennu: {$a}';
$string['cannotopentemplate'] = 'Does dim modd agor ffeil dempled ({$a})';
$string['cannotopenzip'] = 'Does dim modd agor y ffeil zip, mae chwilen estyniad zip ar y system gweithredu 64bit fwy na thebyg';
$string['cannotoverridebaserole'] = 'Does dim modd diystyru galluoedd y swyddogaethau sylfaenol';
$string['cannotoverriderolehere'] = 'Chewch chi ddim diystyru\'r swyddogaeth hon (id = {$a->roleid}) yn y cyd-destun hwn ({$a->context})';
$string['cannotreadfile'] = 'Does dim modd darllen ffeil ({$a})';
$string['cannotreadtmpfile'] = 'Gwall wrth ddarllen ffeil dros dro';
$string['cannotreaduploadfile'] = 'Doedd dim modd darllen y ffeil a lwythwyd i fyny';
$string['cannotremovefrommeta'] = 'Doedd dim modd tynnu\'r cwrs a ddewiswyd o\'r cwrs meta hwn!';
$string['cannotresetguestpwd'] = 'Does dim modd i chi ailosod y cyfrinair gwestai';
$string['cannotresetmail'] = 'Gwall wrth ailosod cyfrinair ac anfon neges atoch ';
$string['cannotresetthisrole'] = 'Does dim modd ailosod y swyddogaeth hon';
$string['cannotrestore'] = 'Mae gwall wedi digwydd a doedd dim modd cwblhau\'r broses adfer!';
$string['cannotrestoreadminorcreator'] = 'Mae angen i chi fod yn grëwr neu\'n weinyddwr er mwyn adfer i gwrs newydd!';
$string['cannotrestoreadminoredit'] = 'Mae angen i chi fod yn athro sy\'n golygu neu\'n weinyddwr er mwyn adfer i gwrs a ddewiswyd!';
$string['cannotsaveagreement'] = 'Doedd dim modd cadw eich cytundeb';
$string['cannotsaveblock'] = 'Gwall wrth gadw\'r ffurfweddiad bloc';
$string['cannotsavecomment'] = 'Does dim modd cadw\'r sylw';
$string['cannotsavedata'] = 'Does dim modd cadw\'r data';
$string['cannotsavefile'] = 'Does dim modd cadw\'r ffeil "{$a}"!';
$string['cannotsavemd5file'] = 'Does dim modd cadw ffeil md5';
$string['cannotsavezipfile'] = 'Does dim modd cadw ffeil ZIP';
$string['cannotservefile'] = 'Does dim modd cyflwyno\'r ffeil - problem ffurfweddu gweinydd.';
$string['cannotsetparentforcatoritem'] = 'Does dim modd gosod rhiant ar gyfer eitem cwrs neu gategori!';
$string['cannotsetpassword'] = 'Doedd dim modd gosod cyfrinair defnyddiwr!';
$string['cannotsetprefgrade'] = 'Doedd dim modd gosod hoff ddewis o ran golwg cyfanrediad ar gyfer {$a} yng nghyswllt y categori gradd hwn';
$string['cannotsettheme'] = 'Doedd dim modd gosod y thema!';
$string['cannotsetupblock'] = 'HEB lwyddo i osod y tablau bloc!';
$string['cannotsetupcapformod'] = 'Doedd dim modd gosod y galluoedd ar gyfer {$a}';
$string['cannotsetupcapforplugin'] = 'Doedd dim modd gosod y galluoedd ar gyfer {$a}';
$string['cannotshowhidecoursesincategory'] = 'Does dim modd dangos/cuddio\'r cyrsiau yn y categori {$a}.';
$string['cannotunassigncap'] = 'Doedd dim modd dad-neilltuo\'r gallu anghymeradwyo {$a->cap} o\'r swyddogaeth {$a->role}';
$string['cannotunassignrolefrom'] = 'Does dim modd dad-neilltuo\'r defnyddiwr hwn o\'r id swyddogaeth: {$a}';
$string['cannotunzipfile'] = 'Does dim modd dadzipio\'r ffeil';
$string['cannotupdatemod'] = 'Doedd dim modd diweddaru {$a}';
$string['cannotupdatepasswordonextauth'] = 'Wedi methu diweddaru\'r cyfrinair ar y dilysiad allanol: {$a}. Edrychwch ar logiau\'r gweinydd am ragor o fanylion.';
$string['cannotupdateprofile'] = 'Gwall wrth ddiweddaru cofnod y defnyddiwr';
$string['cannotupdaterecord'] = 'Doedd dim modd diweddaru ID cofnod {$a}';
$string['cannotupdaterss'] = 'Does dim modd diweddaru RSS';
$string['cannotupdatesubcourse'] = 'Doedd dim modd diweddaru cwrs plentyn!';
$string['cannotupdateusermsgpref'] = 'Does dim modd diweddaru eich dewisiadau o ran negeseuon defnyddiwr';
$string['cannotupdateuseronexauth'] = 'Wedi methu diweddaru\'r data defnyddiwr ar y dilysiad allanol: {$a}. Edrychwch ar logiau\'r gweinydd am ragor o fanylion.';
$string['cannotuploadfile'] = 'Gwall wrth brosesu\'r ffeil i\'w llwytho i fyny';
$string['cannotuseadmin'] = 'Mae angen i chi fod yn weinyddwr er mwyn defnyddio\'r dudalen hon';
$string['cannotuseadminadminorteacher'] = 'Mae angen i chi fod yn athro neu\'n weinyddwr er mwyn defnyddio\'r dudalen hon';
$string['cannotusepage'] = 'Dim ond athrawon a gweinyddwyr all ddefnyddio\'r dudalen hon';
$string['cannotusepage2'] = 'Mae\'n ddrwg gen i, chewch chi ddim defnyddio\'r dudalen hon';
$string['cannotviewprofile'] = 'Chewch chi ddim gweld proffil y defnyddiwr hwn';
$string['cannotviewreport'] = 'Chewch chi ddim gweld yr adroddiad hwn';
$string['cannotwritefile'] = 'Does dim modd ysgrifennu i\'r ffeil ({$a})';
$string['categoryerror'] = 'Gwall categori';
$string['categoryidnumbertaken'] = 'Mae\'r rhif ID yn cael ei ddefnyddio ar gyfer categori arall yn barod';
$string['categorynamerequired'] = 'Rhaid rhoi enw categori';
$string['categorytoolong'] = 'Enw categori yn rhy hir';
$string['commentmisconf'] = 'Mae\'r ID Sylwadau wedi\'i gam-ffurfweddu';
$string['componentisuptodate'] = 'Mae\'r gydran wedi\'i diweddaru';
$string['confirmsesskeybad'] = 'Mae\'n flin gennyf, doedd dim modd cadarnhau eich allwedd sesiwn er mwyn cyflawni\'r weithred hon. Mae\'r nodwedd ddiogelwch hon yn eich atal rhag cyflawni gweithredoedd pwysig yn ddamweiniol neu\'n faleisus yn eich enw. Sicrhewch eich bod eisiau cyflawni\'r swyddogaeth hon.';
$string['couldnotassignrole'] = 'Mae gwall difrifol ond amhenodol wedi digwydd wrth geisio neilltuo swyddogaeth i chi';
$string['couldnotupdatenoexistinguser'] = 'Does dim modd diweddaru\'r defnyddiwr - dydy\'r defnyddiwr ddim yn bodoli';
$string['countriesphpempty'] = 'Gwall: Mae\'r ffeil gwledydd.php yn y pecyn iaith {$a} yn wag neu ar goll.';
$string['coursedoesnotbelongtocategory'] = 'Nid yw\'r cwrs yn perthyn i\'r categori hwn';
$string['courseformatnotfound'] = 'Dydy\'r fformat cwrs \'{$a}\' ddim yn bod neu ddim yn cael ei adnabod';
$string['coursegroupunknown'] = 'Heb bennu cwrs sy\'n cyd-fynd â grŵp {$a}';
$string['courseidnotfound'] = 'Nid yw\'r id cwrs yn bodoli';
$string['coursemisconf'] = 'Mae\'r cwrs wedi\'i gam-ffurfweddu';
$string['courserequestdisabled'] = 'Mae\'n ddrwg gen i, ond mae\'r broses gwneud cais am gyrsiau wedi\'i hanalluogi gan y gweinyddwr.';
$string['csvcolumnduplicates'] = 'Wedi canfod colofnau dyblyg';
$string['csvemptyfile'] = 'Mae\'r ffeil CSV yn wag';
$string['csvfewcolumns'] = 'Dim digon o golofnau, gwiriwch y gosodiad amddiffyn';
$string['csvinvalidcols'] = '<b>Ffeil CSV annilys:</b> Mae\'n rhaid i\'r llinell gyntaf gynnwys "Meysydd Pennyn" ac mae\'n rhaid i\'r ffeil fod yn fath o <br />"Feysydd Estynedig/Wedi\'u Gwahanu gan Gomas"<br />neu\'n<br /> "Feysydd Estynedig gyda Chod Canlyniad CAVV/Wedi\'u Gwahanu gan Gomas"';
$string['csvinvalidcolsnum'] = 'Ffeil CSV annilys - mae\'n rhaid i bob llinell gynnwys 49 neu 70 o feysydd';
$string['csvloaderror'] = 'Roedd gwall wrth lwytho\'r ffeil CSV!';
$string['csvweirdcolumns'] = 'Fformat ffeil CSV annilys - nid yw nifer y colofnau yn gyson!';
$string['dbconnectionfailed'] = '<p>Gwall: Heb lwyddo i gysylltu â\'r gronfa ddata</p> <p>Mae\'n bosibl bod y gronfa ddata wedi\'i gorlwytho neu fel arall ddim yn rhedeg yn iawn.</p> <p>Dylai gweinyddwr y safle hefyd wneud yn siŵr bod manylion y gronfa ddata wedi\'u nodi\'n gywir yn config.php</p>';
$string['dbdriverproblem'] = '<p>Gwall: wedi canfod problem gyda gyrrwr y gronfa ddata</p> <p>Dylai gweinyddwr y safle ddilysu ffurfweddiad y gweinydd</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Wedi canfod problem ddifrifol gyda sesiwn cronfa ddata.<br /><br />Rhowch wybod i weinyddwr y gweinydd.';
$string['dbsessionhandlerproblem'] = 'Heb lwyddo i roi sesiwn cronfa ddata ar waith.<br /><br />Rhowch wybod i weinyddwr y gweinydd.';
$string['dbsessionmysqlpacketsize'] = 'Wedi canfod gwall sesiwn difrifol.<br /><br />Rhowch wybod i\'r gweinyddwr, mae\'r broblem hon yn cael ei hachosi fwy na thebyg gan werth bach yn y gosodiad MySQL max_allowed_packet.';
$string['dbupdatefailed'] = 'Heb lwyddo i ddiweddaru\'r gronfa ddata';
$string['ddldependencyerror'] = 'Does dim modd addasu {$a->targettype} "{$a->targetname}". Wedi canfod dibyniaeth â {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Gwall gweithredu sql DDL';
$string['ddlfieldalreadyexists'] = 'Mae maes "{$a}" yn bodoli eisoes';
$string['ddlfieldnotexist'] = 'Nid yw maes "{$a->fieldname}" yn bodoli yn y tabl "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Mae tabl "{$a}" yn bodoli eisoes';
$string['ddltablenotexist'] = 'Nid yw tabl "{$a}" yn bodoli';
$string['ddlunknownerror'] = 'Gwall llyfrgell DDL dieithr';
$string['ddlxmlfileerror'] = 'Wedi canfod gwallau ffeil cronfa ddata XML';
$string['ddsequenceerror'] = 'Diffiniad tabl "{$a}" anghywir; dim ond un golofn awtomatig y gellir ei chael ac mae\'n rhaid ei diffinio fel allwedd.';
$string['destinationcmnotexit'] = 'Nid yw\'r modiwl cwrs sy\'n derbyn yn bodoli';
$string['detectedbrokenplugin'] = 'Mae\'r ategyn "{$a}" yn ddiffygiol neu\'n hen, does dim modd bwrw ymlaen yn anffodus.';
$string['dmlexceptiononinstall'] = '<p>Roed gwall cronfa ddata [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlreadexception'] = 'Gwall wrth ddarllen o\'r gronfa ddata';
$string['dmltransactionexception'] = 'Gwall gyda thrafodyn cronfa ddata';
$string['dmlwriteexception'] = 'Gwall wrth ysgrifennu ar y gronfa ddata';
$string['downgradedcore'] = 'GWALL!!! Mae\'r cod rydych chi\'n ei ddefnyddio yn HŶN na\'r fersiwn a greodd y cronfeydd data hyn!';
$string['downloadedfilecheckfailed'] = 'Heb lwyddo i wirio\'r ffeil a lwythwyd i lawr';
$string['duplicatefieldname'] = 'Wedi canfod enw maes "{$a}" dyblyg';
$string['duplicatenosupport'] = 'Doedd dim modd dyblygu gweithgaredd ‘{$a->modname}\' am nad ydy’r modiwl {$a->modtype} yn cefnogi’r gwaith o adfer a gwneud copi wrth gefn.';
$string['duplicateparaminsql'] = 'GWALL: enw paramedr dyblyg yn yr ymholiad  ';
$string['duplicaterolename'] = 'Mae swyddogaeth gyda\'r enw hwn yn bodoli eisoes!';
$string['duplicateroleshortname'] = 'Mae swyddogaeth gyda\'r enw byr hwn yn bodoli eisoes!';
$string['duplicateusername'] = 'Enw defnyddiwr dyblyg - anwybyddu cofnod';
$string['emailfail'] = 'Wedi methu anfon negeseuon e-bost';
$string['error'] = 'Gwall';
$string['errorcleaningdirectory'] = 'Gwall wrth lanhau\'r cyfeiriadur "{$a}"';
$string['errorcopyingfiles'] = 'Gwall wrth gopïo ffeiliau';
$string['errorcreatingdirectory'] = 'Gwall wrth greu\'r cyfeiriadur "{$a}"';
$string['errorcreatingfile'] = 'Gwall wrth greu\'r ffeil "{$a}"';
$string['errorcreatingrole'] = 'Gwall wrth greu swyddogaeth';
$string['errorfetchingrssfeed'] = 'Gwall wrth nôl crynodeb RSS.';
$string['erroronline'] = 'Gwall ar linell {$a}';
$string['errorparsingxml'] = 'Gwall dosrannu XML: {$a->errorstring} yn llinell {$a->errorline}, nod {$a->errorchar}';
$string['errorreadingfile'] = 'Gwall wrth ddarllen y ffeil "{$a}"';
$string['errorsavingrequest'] = 'Gwall wrth geisio cadw eich cais.';
$string['errorsettinguserpref'] = 'Gwall wrth osod dewisiadau defnyddiwr';
$string['errorunzippingfiles'] = 'Gwall wrth ddadzipio ffeiliau';
$string['expiredkey'] = 'Allwedd wedi dod i ben';
$string['externalauthpassworderror'] = 'Cyfrinair heb fod yn wag ar gyfer dilysiad allanol';
$string['externalfilenolocation'] = 'Does gan y ffeil allanol ddim llwybr lleoliad';
$string['failtoloadblocks'] = 'Mae un neu ragor o flociau wedi\'u cofrestru ar y gronfa ddata, ond mae pob un wedi methu llwytho!';
$string['fieldrequired'] = 'Mae "{$a}" yn faes gofynnol';
$string['fileexists'] = 'Ffeil yn bodoli';
$string['filemismatch'] = 'Anghysondeb yn yr enw ffeil di-graidd. {$a->file} ddylai\'r ffeil "{$a->current}" fod';
$string['filenotfound'] = 'Mae\'n flin gennyf, doedd dim modd canfod y ffeil dan sylw';
$string['filenotreadable'] = 'Does dim modd darllen y ffeil';
$string['filterdoesnothavelocalconfig'] = 'Nid yw\'r hidlydd {$a} yn caniatáu ffurfweddu lleol.';
$string['filternotactive'] = 'Nid yw\'r hidlydd {$a} ar waith ar hyn o bryd';
$string['filternotenabled'] = 'Hidlydd heb ei alluogi!';
$string['filternotinstalled'] = 'Dydy\'r hidlydd {$a} ddim wedi\'i osod ar hyn o bryd';
$string['forumblockingtoomanyposts'] = 'Rydych chi wedi mynd dros y trothwy postio ar gyfer y fforwm hwn';
$string['generalexceptionmessage'] = 'Eithriad - {$a}';
$string['gradecantregrade'] = 'Roedd gwall yn ystod cyfrifo gradd: {$a}';
$string['gradepubdisable'] = 'Wedi analluogi cyhoeddi graddau';
$string['groupalready'] = 'Mae\'r defnyddiwr eisoes yn perthyn i\'r grŵp {$a}';
$string['groupexistforcourse'] = 'Mae\'r grŵp "{$a}" eisoes yn bodoli ar gyfer y cwrs hwn';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Mae grŵp "{$a->name}" gyda rhif id "{$a->idnumber}" yn bodoli eisoes ar gyfer y cwrs hwn';
$string['grouphasidnumber'] = 'Mae gan grŵp "{$a}" rif id a gall fod wedi’i greu yn awtomatig gan system allanol. Does gennych chi ddim hawl i gael gwared o’r grŵp hwn.';
$string['groupinghasidnumber'] = 'Mae gan dosbarthiad "{$a}" rif id a gall fod wedi’i greu yn awtomatig gan system allanol. Does gennych chi ddim hawl i gael gwared o’r dosbarthiad hwn.';
$string['groupingnotaddederror'] = 'Dosbarthiad "{$a}" heb ei ychwanegu';
$string['groupnotaddederror'] = 'Grŵp "{$a}" heb ei ychwanegu';
$string['groupnotaddedtogroupingerror'] = 'Grŵp "{$a->groupname}" heb ei ychwanegu at ddosbarthiad "{$a->groupingname}"';
$string['groupunknown'] = 'Grŵp {$a} heb ei gysylltu â chwrs penodol';
$string['groupusernotmember'] = 'Nid yw\'r defnyddiwr yn aelod o\'r grŵp hwn.';
$string['guestnocomment'] = 'Nid yw gwesteion yn cael postio sylwadau!';
$string['guestnoeditprofile'] = 'Ni all y gwestai olygu ei broffil';
$string['guestnoeditprofileother'] = 'Ni ellir golygu\'r proffil gwestai';
$string['guestnorate'] = 'Nid yw gwesteion yn cael graddio cofnodion';
$string['guestsarenotallowed'] = 'Nid yw\'r defnyddiwr gwadd yn cael gwneud hyn';
$string['hackdetected'] = 'Wedi dod o hyd i ymosodiad hacio!';
$string['hashpoolproblem'] = 'Cynnwys ffeil gronfa anghywir {$a}.';
$string['headersent'] = 'Mae\'r penynnau eisoes wedi\'u hanfon';
$string['idnumbertaken'] = 'Mae\'r rhif ID eisoes yn cael ei ddefnyddio ar gyfer cwrs arall
';
$string['idnumbertoolong'] = 'Rhif ID yn rhy hir';
$string['importformatnotimplement'] = 'Yn anffodus, does dim modd mewngludo\'r fformat hwn eto!';
$string['incorrectext'] = 'Mae estyniad y ffeil yn anghywir';
$string['installproblem'] = 'Fel arfer, nid yw\'n bosibl adfer o wallau sy\'n digwydd yn ystod y broses osod, efallai y bydd angen i chi greu cronfa ddata newydd neu ddefnyddio rhagddodiad cronfa ddata gwahanol os ydych chi am roi cynnig arall ar osod.';
$string['internalauthpassworderror'] = 'Cyfrinair coll neu bolisi cyfrinair annilys ar gyfer dilysu mewnol';
$string['invalidaccess'] = 'Ni chafodd y dudalen hon ei chyrchu\'n gywir';
$string['invalidaccessparameter'] = 'Paramedr mynediad annilys';
$string['invalidaction'] = 'Paramedr gweithredu annilys';
$string['invalidactivityid'] = 'ID gweithgaredd annilys';
$string['invalidadminsettingname'] = 'Gosodiad gweinyddol annilys ({$a})';
$string['invalidargorconf'] = 'Dim dadl ddilys wedi\'i darparu neu ffurfweddiad y gweinydd yn anghywir';
$string['invalidarguments'] = 'Dim dadl ddilys wedi\'i darparu';
$string['invalidblockinstance'] = 'Achos bloc annilys ar gyfer: {$a}';
$string['invalidbulkenrolop'] = 'Cais annilys wedi\'i wneud am weithred cofrestru torfol.';
$string['invalidcategory'] = 'Categori anghywir!';
$string['invalidcategoryid'] = 'ID categori anghywir!';
$string['invalidcomment'] = 'Mae\'r sylw yn anghywir';
$string['invalidcommentarea'] = 'Ardal sylwadau annilys';
$string['invalidcommentid'] = 'ID sylw annilys';
$string['invalidcommentitemid'] = 'ID eitem sylw annilys';
$string['invalidcommentparam'] = 'Paramedrau sylw annilys';
$string['invalidcomponent'] = 'Enw cydran annilys';
$string['invalidconfirmdata'] = 'Data cadarnhau annilys';
$string['invalidcontext'] = 'Cyd-destun annilys';
$string['invalidcourse'] = 'Cwrs annilys';
$string['invalidcourseid'] = 'Rydych chi\'n ceisio defnyddio ID cwrs annilys';
$string['invalidcourselevel'] = 'Lefel cyd-destun anghywir';
$string['invalidcoursemodule'] = 'ID modiwl cwrs annilys';
$string['invalidcoursenameshort'] = 'Enw cwrs byr annilys';
$string['invaliddata'] = 'Mae\'r data a gyflwynwyd yn annilys';
$string['invaliddatarootpermissions'] = 'Wedi canfod hawliau annilys yn $CFG->cyfeiriadur data craidd, mae\'n rhaid i\'r gweinyddwr gywiro hawliau.';
$string['invaliddevicetype'] = 'Math o ddyfais annilys';
$string['invalidelementid'] = 'ID elfen anghywir!';
$string['invalidentry'] = 'Nid yw hwn yn gofnod dilys!';
$string['invalidevent'] = 'Digwyddiad annilys';
$string['invalidfieldname'] = 'Nid yw "{$a}" yn enw maes dilys';
$string['invalidfiletype'] = 'Nid yw "{$a}" yn fath dilys o ffeil';
$string['invalidformatpara'] = 'Fformat anghywir ar gyfer dewis paramedr';
$string['invalidformdata'] = 'Data ffurflen anghywir';
$string['invalidfunction'] = 'Gweithred anghywir';
$string['invalidgradeitemid'] = 'ID eitem gradd anghywir';
$string['invalidgroupid'] = 'ID grŵp anghywir wedi\'i nodi';
$string['invalidipformat'] = 'Fformat cyfeiriad IP annilys';
$string['invaliditemid'] = 'ID eitem anghywir';
$string['invalidkey'] = 'Allwedd anghywir';
$string['invalidlegacy'] = 'Diffiniad hen swyddogaeth anghywir ar gyfer math: {$a}';
$string['invalidmd5'] = 'Roedd y newidyn gwirio yn anghywir - rhowch gynnig arall arni';
$string['invalidmode'] = 'Modd annilys ({$a})';
$string['invalidmodule'] = 'Modiwl annilys';
$string['invalidmoduleid'] = 'ID modiwl annilys: {$a}';
$string['invalidmodulename'] = 'Enw modiwl annilys: {$a}';
$string['invalidnum'] = 'Gwerth rhifol annilys';
$string['invalidnumkey'] = 'Dydy\'r arae $conditions ddim yn cael cynnwys bysellau rhifol, cywirwch y cod hwn!';
$string['invalidoutcome'] = 'ID deilliant anghywir';
$string['invalidpagesize'] = 'Maint tudalen annilys';
$string['invalidpasswordpolicy'] = 'Polisi cyfrinair annilys';
$string['invalidpaymentmethod'] = 'Dull talu annilys: {$a}';
$string['invalidqueryparam'] = 'GWALL: Nifer y paramedrau ymholiadau yn anghywir. Disgwyliwyd {$a->expected}, cafwyd {$a->actual}.';
$string['invalidratingarea'] = 'Man sgorio annilys';
$string['invalidrecord'] = 'Does dim modd dod o hyd i\'r cofnod o\'r data yn y tabl cronfa ddata {$a}.';
$string['invalidrecordunknown'] = 'Does dim modd dod o hyd i\'r cofnod o\'r data yn y gronfa ddata.';
$string['invalidrequest'] = 'Cais annilys';
$string['invalidrole'] = 'Swyddogaeth annilys';
$string['invalidroleid'] = 'ID swyddogaeth annilys';
$string['invalidscaleid'] = 'ID graddfa anghywir';
$string['invalidsection'] = 'Mae cofnod modiwl y cwrs yn cynnwys adran annilys';
$string['invalidsesskey'] = 'Mae\'r allwedd sesiwn a gyflwynwyd yn anghywir, heb dderbyn y ffurflen!';
$string['invalidshortname'] = 'Mae hwnnw\'n enw cwrs byr annilys';
$string['invalidsourcefield'] = 'Mae maes tarddu y ffeil ddrafft yn annilys';
$string['invalidstatedetected'] = 'Mae rhywbeth wedi mynd o\'i le: {$a}. Ddylai hyn byth ddigwydd fel arfer.';
$string['invalidurl'] = 'URL annilys';
$string['invaliduser'] = 'Defnyddiwr annilys';
$string['invaliduserfield'] = 'Maes defnyddiwr annilys: {$a}';
$string['invaliduserid'] = 'ID defnyddiwr annilys';
$string['invalidusername'] = 'Mae\'r enw defnyddiwr a roddwyd yn cynnwys nodau annliys';
$string['invalidxmlfile'] = 'Nid yw "{$a}" yn ffeil XML ddilys';
$string['iplookupfailed'] = 'Does dim modd canfod gwybodaeth ddaearyddol am y cyfeiriad IP hwn {$a}';
$string['iplookupprivate'] = 'Does dim modd dangos y chwiliad o gyfeiriadau IP preifat';
$string['ipmismatch'] = 'Dydy cyfeiriad IP y cleient ddim yn cyfateb';
$string['listcantmovedown'] = 'Wedi methu symud yr eitem i lawr, gan mai dyma\'r eitem olaf ar yr un lefel';
$string['listcantmoveleft'] = 'Wedi methu symud yr eitem i\'r chwith, gan nad oes uwch eitem';
$string['listcantmoveright'] = 'Wedi methu symud yr eitem i\'r dde gan nad oes eitem ar yr un lefel i wneud is eitem. Symudwch ef o dan eitem arall ar yr un lefel ac yna gallwch ei symud i\'r dde.';
$string['listcantmoveup'] = 'Wedi methu symud yr eitem i fyny, gan mai dyma\'r eitem gyntaf o\'r eitemau sydd ar yr un lefel';
$string['listnochildren'] = 'Heb ganfod is eitem';
$string['listnoitem'] = 'Heb ganfod eitem';
$string['listnopeers'] = 'Heb ganfod eitemau ar yr un lefel';
$string['listupdatefail'] = 'Mae\'r gweithrediad DB wedi methu wrth olygu hierarchaeth y rhestr';
$string['logfilenotavailable'] = 'Logiau ddim ar gael';
$string['loginasnoenrol'] = 'Ni allwch gofrestru na dadgofrestru pan fyddwch yn sesiwn "Mewngofnodi fel" y cwrs.';
$string['loginasonecourse'] = 'Ni allwch gael mynediad i\'r cwrs hwn.<br /> Rhaid i chi derfynu\'r sesiwn "Mewngofnodi fel" cyn gallu cael mynediad i unrhyw gwrs arall.';
$string['maxareabytes'] = 'Mae\'r ffeil yn fwy\'n na\'r lle sydd ar ol yn yr ardal hon.';
$string['maxbytes'] = 'Mae\'r ffeil hon yn fwy na\'r swm mwyaf a ganiateir';
$string['messagingdisable'] = 'Mae negeseua wedi\'i analluogi ar y safle hwn';
$string['mimetexisnotexist'] = 'Nid yw eich system wedi\'i ffurfweddu i redeg mimeTeX. Mae angen i chi lwytho\'r ffeil weithredu briodol ar gyfer eich llwyfan PHP_OS o <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, neu gael y ffynhonnell C o <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, ei chrynhoi a rhoi\'r ffeil weithredu yn eich cyfeiriadur moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Does dim modd gweithredu\'r mimetex personol!';
$string['missingfield'] = 'Mae\'r maes "{$a}" ar goll';
$string['missingkeyinsql'] = 'GWALL: paramedr "{$a}" ar goll yn yr ymholiad';
$string['missing_moodle_backup_xml_file'] = 'Mae ffeil XML ar goll yn y copi wrth gefn: {$a}';
$string['missingparam'] = 'Roedd paramedr gofynnol ({$a}) ar goll';
$string['missingparameter'] = 'Paramedr ar goll';
$string['missingrequiredfield'] = 'Mae maes gofynnol ar goll';
$string['missinguseranditemid'] = 'ID defnyddiwr ac ID eitem ar goll';
$string['missingvarname'] = 'Mae enw\'r newidyn sy\'n ofynnol ar goll!';
$string['mixedtypesqlparam'] = 'GWALL: Gwahanol fathau o baramedrau ymholiadau sql!!';
$string['mnetdisable'] = 'MNET wedi\'i analluogi';
$string['mnetlocal'] = 'Does dim modd i\'r rhai sy\'n defnyddio MNET o bell fewngofnodi\'n lleol';
$string['moduledisable'] = 'Mae\'r modiwl hwn ({$a}) wedi cael ei analluogi ar gyfer y cwrs penodol hwn';
$string['moduledoesnotexist'] = 'Nid yw\'r modiwl hwn yn bodoli';
$string['moduleinstancedoesnotexist'] = 'Nid yw enghraifft y modiwl hwn yn bodoli';
$string['modulemissingcode'] = 'Mae\'r cod sydd ei angen i gyflawni\'r swyddogaeth hon ar goll o\'r modiwl {$a}';
$string['movecatcontentstoroot'] = 'Dydy symud cynnwys y categori i’r gwreiddyn ddim yn cael ei ganiatáu. Mae’n rhaid i chi symud y cynnwys i gategori sy’n bodoli eisoes!';
$string['multiplerecordsfound'] = 'Wedi canfod mwy nag un cofnod, dim ond un cofnod a ddisgwyliwyd.';
$string['multiplerestorenotallow'] = 'Chewch chi ddim adfer mwy nag un!';
$string['mustbeloggedin'] = 'Mae\'n rhaid mewngofnodi i wneud hyn';
$string['mustbeteacher'] = 'Rhaid i chi fod yn athro i edrych ar y dudalen hon';
$string['myisamproblem'] = 'Mae tablau cronfa ddata yn defnyddio\'r peiriant chwilio cronfeydd data MyISAM. Argymhellir i chi ddefnyddio peiriant sy\'n gydnaws ag ACID gyda chymorth trafodion llawn megis InnoDB.';
$string['needcopy'] = 'Mae angen i chi gopïo rhywbeth yn gyntaf!';
$string['needcoursecategroyid'] = 'Mae\'n rhaid nodi ID y cwrs neu\'r categori';
$string['needphpext'] = 'Mae angen i chi ychwanegu {$a} cymorth at eich gosodiad PHP';
$string['noadmins'] = 'Dim gweinyddwyr!';
$string['noblocks'] = 'Heb ganfod blociau!';
$string['nocapabilitytousethisservice'] = 'Does gan y defnyddiwr mo\'r gallu sy\'n ofynnol i ddefnyddio\'r gwasanaeth hwn';
$string['nocategorydelete'] = 'Does dim modd dileu categori \'{$a}\'!';
$string['nocontext'] = 'Mae\'n flin gennyf, nid yw\'r cwrs hwnnw\'n gyd-destun dilys';
$string['nodata'] = 'Dim data';
$string['noexistingcategory'] = 'Dim categori presennol';
$string['nofile'] = 'Ffeil heb ei nodi';
$string['nofiltersenabled'] = 'Dim hidlyddion wedi\'u galluogi.';
$string['nofolder'] = 'Nid yw\'r cyfeiriadur yn bodoli';
$string['noformdesc'] = 'Heb ganfod ffeil disgrifio ffurflen formslib ar gyfer y gweithgaredd hwn.';
$string['noguest'] = 'Dim gwesteion yma!';
$string['noinstances'] = 'Does dim enghreifftiau o {$a} yn y cwrs hwn!';
$string['nologinas'] = 'Ni chewch fewngofnodi fel y defnyddiwr hwnnw';
$string['nonmeaningfulcontent'] = 'Cynnwys diystyr';
$string['noparticipants'] = 'Heb ddod o hyd i gyfranogwyr ar gyfer y cwrs hwn';
$string['noparticipatorycms'] = 'Mae\'n flin gennyf, nid oes gennych unrhyw fodiwlau cwrs cyfranogol i adrodd arnynt.';
$string['nopermissions'] = 'Mae\'n flin gennyf, nid oes gennych hawl i wneud hynny ({$a}) ar hyn o bryd';
$string['nopermissiontocomment'] = 'Allwch chi ddim ychwanegu sylwadau';
$string['nopermissiontodelentry'] = 'Allwch chi ddim dileu cofnodion pobl eraill!';
$string['nopermissiontoeditcomment'] = 'Allwch chi ddim golygu sylwadau pobl eraill!';
$string['nopermissiontohide'] = 'Dim caniatâd i guddio!';
$string['nopermissiontoimportact'] = 'Does gennych chi mo\'r hawliau sy\'n ofynnol i fewngludo gweithgareddau ar y cwrs hwn';
$string['nopermissiontolock'] = 'Dim caniatâd i gloi!';
$string['nopermissiontomanagegroup'] = 'Does gennych chi mo\'r hawliau sy\'n ofynnol i reoli grwpiau';
$string['nopermissiontorate'] = 'Chewch chi ddim sgorio eitemau!';
$string['nopermissiontoshow'] = 'Dim caniatâd i weld hwn!';
$string['nopermissiontounlock'] = 'Dim caniatâd i ddad-gloi!';
$string['nopermissiontoupdatecalendar'] = 'Yn anffodus, ar hyn o bryd does gennych chi mo\'r hawliau i ddiweddaru\'r digwyddiad ar y calendr';
$string['nopermissiontoviewgrades'] = 'Does dim modd gweld graddau.';
$string['nopermissiontoviewletergrade'] = 'Does dim caniatâd i weld graddau llythyren';
$string['nopermissiontoviewpage'] = 'Chewch chi ddim edrych ar y dudalen hon';
$string['nosite'] = 'Wedi methu canfod cwrs lefel uchel!';
$string['nositeid'] = 'Dim ID safle';
$string['nostatstodisplay'] = 'Yn anffodus, does dim data i\'w ddangos';
$string['notallowedtoupdateprefremotely'] = 'Chewch chi ddim diweddaru\'r dewis defnyddiwr hwn o bell';
$string['notavailable'] = 'Nid yw hwnnw ar gael ar hyn o bryd';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Dydych chi ddim yn aelod o\'r grŵp cwrs hwn';
$string['notownerofkey'] = 'Nid chi yw perchennog yr allwedd hon';
$string['nousers'] = 'Dim defnyddiwr o\'r fath!';
$string['onlyadmins'] = 'Dim ond gweinyddwyr all wneud hynny';
$string['onlyeditingteachers'] = 'Dim ond athrawon â hawl i olygu all wneud hynny';
$string['onlyeditown'] = 'Dim ond eich gwybodaeth eich hun y cewch ei golygu';
$string['orderidnotfound'] = 'Heb ganfod ID trefn {$a}';
$string['pagenotexist'] = 'Gwall anghyffredin (wedi ceisio cyrraedd tudalen nad yw\'n bodoli)';
$string['pathdoesnotstartslash'] = 'Heb ddarparu dadleuon dilys, nid yw\'r llwybr yn cychwyn gyda slaes!';
$string['pleasereport'] = 'Os oes gennych amser, rhowch wybod i ni beth yr oeddech yn ceisio\'i wneud pan ddigwyddodd y gwall:';
$string['pluginrequirementsnotmet'] = 'Heb lwyddo i osod yr ategyn "{$a->pluginname}" ({$a->pluginversion}).  Mae arno angen fersiwn mwy diweddar o Moodle (rydych yn defnyddio {$a->currentmoodle}, mae arnoch angen {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Gwall: nid yw rhagddodiad tabl cronfa ddata yn gallu bod yn wag ({$a})</p> <p>Mae\'n rhaid i weinyddwr y safle gywiro\'r broblem hon.</p>';
$string['prefixtoolong'] = '<p>Gwall: mae rhagddodiad y tabl cronfa ddata yn rhy hir ({$a->dbfamily})</p> <p>Mae\'n rhaid i weinyddwr y safle gywiro\'r broblem hon. Ni chaiff rhagddodiadau tablau yn {$a->dbfamily} fod yn fwy na {$a->maxlength} nod.</p>';
$string['processingstops'] = 'Prosesu wedi dod i ben yma. Wedi anwybyddu gweddill y cofnodion.';
$string['protected_cc_not_supported'] = 'Dydy cetris sydd wedi\'u diogelu ddim yn cael eu cefnogi.';
$string['querystringcannotbeempty'] = 'Dydy\'r testun ymholiad ddim yn cael bod yn wag.';
$string['redirecterrordetected'] = 'Wedi canfod proses ailgyfeirio heb ei chefnogi, wedi dod â\'r sgript i ben';
$string['refoundto'] = 'Gellir ei ad-dalu i {$a}';
$string['refoundtoorigi'] = 'Wedi\'i ad-dalu i\'r swm gwreiddiol: {$a}';
$string['remotedownloaderror'] = 'Wedi methu llwytho cydran ar eich gweinydd, gwiriwch osodiadau\'r dirprwy, argymhellir yr estyniad PHP cURL yn gryf.<br /><br />Mae\'n rhaid i chi lwytho\'r ffeil <a href="{$a->url}">{$a->url}</a> eich hun, ei chopïo i "{$a->dest}" ar eich gweinydd, a\'i dad-zipio yno.';
$string['remotedownloadnotallowed'] = 'Ni chaniateir llwytho cydrannau i lawr i\'ch gweinydd (mae allow_url_fopen wedi\'i analluogi).<br /><br />Rhaid i chi lwytho\'r ffeil <a href="{$a->url}">{$a->url}</a> i lawr eich hun, ei chopïo i "{$a->dest}" yn eich gweinydd, a\'i dadzipio yno.';
$string['reportnotavailable'] = 'Dim ond ar gyfer y cwrs safle mae\'r math hwn o adroddiad ar gael';
$string['requirecorrectaccess'] = 'Url neu borth annilys.';
$string['requireloginerror'] = 'Does dim modd mynd i\'r cwrs neu\'r gweithgaredd.';
$string['restorechecksumfailed'] = 'Roedd problem gyda\'r wybodaeth adfer a oedd wedi\'i storio yn eich sesiwn. Edrychwch ar gyfyngiadau maint eich pecyn DB/cof PHP. Mae\'r broses adfer wedi\'i hatal.';
$string['restore_path_element_missingmethod'] = 'Mae\'r dull adfer {$a} ar goll. Mae\'n rhaid iddi gael ei diffinio gan ddatblygwr.';
$string['restore_path_element_noobject'] = 'Nid yw\'r gwrthrych adfer {$a} yn wrthrych.';
$string['restrictedcontextexception'] = 'Mae\'n flin gennyf, mae rhoi\'r weithred allanol hon ar waith yn mynd yn groes i gyfyngiadau\'r cyd-destun.';
$string['restricteduser'] = 'Mae\'n flin gennyf, mae eich cyfrif cyfredol "{$a}" wedi\'i wahardd rhag gwneud hynny';
$string['reverseproxyabused'] = 'Mae\'r dirprwy weinydd gwrthdro wedi\'i alluogi, does dim modd cael mynediad at y gweinydd yn uniongyrchol yn anffodus.<br />Cysylltwch â gweinyddwr y gweinydd.';
$string['rpcerror'] = 'Wps! Mae eich cysylltiad MNET wedi methu! Dyma\'r neges gwall i\'w rhoi i\'ch gweinyddwr: {Sa}';
$string['scheduledbackupsdisabled'] = 'Mae gweinyddwr y gweinydd wedi analluogi copïau wrth gefn wedi\'u trefnu';
$string['secretalreadyused'] = 'Roedd y ddolen cadarnhau newid cyfrinair wedi\'i defnyddio\'n barod, ni chafodd y cyfrinair ei newid';
$string['sectionnotexist'] = 'Nid yw\'r adran hon yn bodoli';
$string['sendmessage'] = 'Anfon neges';
$string['serverconnection'] = 'Gwall wrth geisio cysylltu â\'r gweinydd';
$string['servicedonotexist'] = 'Nid yw\'r gwasanaeth yn bodoli';
$string['sessioncookiesdisable'] = 'Defnydd anghywir o require_key_login() - mae\'n rhaid analluogi\'r cwcis sesiwn!';
$string['sessiondiskfull'] = 'Mae rhaniad y sesiwn yn llawn. Nid yw\'n bosib mewngofnodi ar hyn o bryd.<br /><br />Rhowch wybod i weinyddwr y gweinydd.';
$string['sessionerroruser'] = 'Mae amser eich sesiwn wedi dod i ben. Mewngofnodwch eto os gwelwch yn dda.';
$string['sessionerroruser2'] = 'Wedi canfod gwall gweinydd sy\'n effeithio ar eich sesiwn mewngofnodi. Mewngofnodwch eto neu ailgychwyn eich porwr.';
$string['sessionipnomatch'] = 'Mae\'n flin gennyf, mae\'n ymddangos bod eich rhif IP wedi newid ers i chi fewngofnodi\'r tro cyntaf. Mae\'r nodwedd ddiogelwch hon yn atal drwgweithredwyr rhag dwyn eich manylion personol pan fyddwch ar y safle hwn. Ni ddylai defnyddwyr normal weld y neges hon - gofynnwch i weinyddwr y safle am help.';
$string['sessionipnomatch2'] = 'Mae\'n flin gennyf, mae\'n ymddangos bod eich rhif IP wedi newid ers i chi fewngofnodi\'r tro cyntaf. Mae\'r nodwedd ddiogelwch hon yn atal drwgweithredwyr rhag dwyn eich manylion personol pan fyddwch ar y safle hwn. Efallai y gwelwch y gwall hwn os ydych chi\'n defnyddio rhwydweithiau di-wifr neu os ydych chi\'n defnyddio mwy nag un rhwydwaith ac yn crwydro o un i\'r llall. Gofynnwch i weinyddwr y safle am ragor o help.<br /><br />Os ydych chi am fwrw ymlaen, gwasgwch F5 i adnewyddu\'r dudalen hon.';
$string['sessionwaiterr'] = 'Wedi dod i ben wrth ddisgwyl i\'r sesiwn gloi.<br />Disgwyliwch i\'ch cais presennol orffen a rhowch gynnig arall arni nes ymlaen.';
$string['shortnametaken'] = 'Mae\'r enw byr eisoes yn cael ei ddefnyddio ar gyfer cwrs arall';
$string['socksnotsupported'] = 'Nid oes modd delio â SOCKS5 yn PHP4';
$string['spellcheckernotconf'] = 'Nid yw\'r gwirydd sillafu wedi\'i ffurfweddu';
$string['sslonlyaccess'] = 'Am resymau diogelwch, dim ond cysylltiadau https a ganiateir, mae\'n flin gennyf.';
$string['statscatchupmode'] = 'Ar hyn o bryd, mae\'r ystadegau wrthi\'n dal i fyny. Hyd yn hyn, mae {$a->daysdone} diwrnod wedi\'u prosesu ac mae {$a->dayspending} eto i\'w prosesu. Dewch yn ôl yn fuan!';
$string['statsdisable'] = 'Nid yw\'r ystadegau wedi\'u galluogi';
$string['statsnodata'] = 'Nid oes data ar gael ar gyfer y cyfuniad hwnnw o gwrs a chyfnod amser';
$string['storedfilecannotcreatefile'] = 'Does dim modd creu ffeil cronfa o ffeiliau lleol, gwiriwch yr hawliau yn dataroot a\'r lle gwag sydd ar gael ar y ddisg.';
$string['storedfilecannotcreatefiledirs'] = 'Does dim modd creu cyfeiriaduron cronfa o ffeiliau lleol, gwiriwch yr hawliau yn dataroot.';
$string['storedfilecannotread'] = 'Does dim modd darllen y ffeil, nid yw\'r ffeil yn bodoli neu mae problemau hawliau';
$string['storedfilenotcreated'] = 'Does dim modd creu ffeil "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}/{$a->filepath}/{$a->filename}"';
$string['storedfileproblem'] = 'Eithriad anhysbys yng nghyswllt ffeiliau lleol ({$a})';
$string['tagdisabled'] = 'Mae\'r tagiau wedi\'u hanalluogi!';
$string['tagnotfound'] = 'Heb lwyddo i ddod o hyd i\'r tag yn y gronfa ddata';
$string['targetdatabasenotempty'] = 'Nid yw\'r gronfa ddata darged yn wag. Mae\'r broses drosglwyddo wedi\'i therfynu am resymau diogelwch.';
$string['textconditionsnotallowed'] = 'Ni chaniateir cymharu amodau colofnau testun. Defnyddiwch sql_compare_text() yn eich ymholiad.';
$string['themenotinstall'] = 'Nid yw\'r thema hon wedi\'i gosod!';
$string['TODO'] = 'TODO';
$string['tokengenerationfailed'] = 'Heb lwyddo i greu tocyn newydd';
$string['transactionvoid'] = 'Does dim modd dirymu\'r trafodyn gan ei fod eisoes wedi\'i ddirymu';
$string['unenrolerror'] = 'Roedd gwall wrth geisio dad-gofrestru\'r person hwnnw';
$string['unicodeupgradeerror'] = 'Mae\'n flin gennyf, nid yw eich cronfa ddata eisoes yn Unicode, ac ni all y fersiwn hwn o Moodle fudo eich cronfa ddata i Unicode. Diweddarwch i Moodle 1.7.x yn gyntaf, yna perfformio\'r mudo Unicode o\'r dudalen Gweinyddu. Ar ôl gwneud hynny, dylech allu mudo i Moodle {$a}';
$string['unknowaction'] = 'Gweithred ddieithr!';
$string['unknowcategory'] = 'Categori dieithr!';
$string['unknowcontext'] = 'Mae hwn yn gyd-destun dieithr ({$a}) yn get_child_contexts!';
$string['unknowformat'] = 'Fformat dieithr ({$a})';
$string['unknownbackupexporterror'] = 'Gwall dieithr wrth baratoi gwybodaeth i\'w mewngludo';
$string['unknownblockregion'] = 'Does dim modd adnabod ardal y bloc \'{$a}\' ar y dudalen hon.';
$string['unknowncontext'] = 'Mae hwn yn gyd-destun dieithr.';
$string['unknowncourse'] = 'Cwrs anhysbys o\'r enw "{$a}"';
$string['unknowncourseidnumber'] = 'ID cwrs anhysbys "{$a}"';
$string['unknowncourserequest'] = 'Cais am gwrs dieithr';
$string['unknowncoursesection'] = 'Adran cwrs anhysbys yng nghwrs "{$a}"';
$string['unknownevent'] = 'Digwyddiad anhysbys';
$string['unknownfiletype'] = 'Gwall math o hidlydd dieithr';
$string['unknowngroup'] = 'Grŵp dieithr "{$a}"';
$string['unknownhelp'] = 'Pwnc help dieithr {$a}';
$string['unknownjsinrequirejs'] = 'Does dim modd dod o hyd i\'r llyfrgell JS: {$a}';
$string['unknownmodulename'] = 'Enw modiwl dieithr ar gyfer y ffurflen';
$string['unknownrole'] = 'Swyddogaeth ddieithr "{$a}"';
$string['unknownsortcolumn'] = 'Colofn drefnu ddieithr {$a}';
$string['unknownuseraction'] = 'Mae\'n flin gennyf, nid wyf yn deall y weithred defnyddiwr hon';
$string['unknownuserselector'] = 'Dewisydd defnyddiwr dieithr';
$string['unknoworder'] = 'Trefnu dieithr';
$string['unknowparamtype'] = 'Math o baramedr dieithr: {$a}';
$string['unknowquestiontype'] = 'Does dim modd delio â math o gwestiwn {$a}';
$string['unknowuploadaction'] = 'Gwall: Gweithred llwytho i fyny ddieithr ({$a})';
$string['unspecifycourseid'] = 'Rhaid nodi\'r ID cwrs, enw byr neu rif ID';
$string['unsupportedevent'] = 'Does dim modd delio â\'r math o ddigwyddiad';
$string['unsupportedstate'] = 'Does dim modd delio â\'r cyflwr cwblhau';
$string['unsupportedwebserver'] = 'Mae\'n flin gennyf, does dim modd delio â meddalwedd y gweinydd gwe ({$a}).';
$string['upgraderequires19'] = 'Gwall: Mae fersiwn newydd o Moodle wedi\'i osod ar y gweinydd, ond yn anffodus does dim modd delio â\'r uwchraddiad o\'r fersiwn flaenorol.<br />Uwchraddiwch yn gyntaf i\'r fersiwn 1.9.x ddiweddaraf. Gallwch hefyd fynd yn ôl i\'r fersiwn flaenorol drwy ailosod y ffeiliau gwreiddiol.';
$string['upgraderunning'] = 'Mae\'r safle\'n cael ei uwchraddio, rhowch gynnig arall arni nes ymlaen.';
$string['urlnotdefinerss'] = 'URL heb ei ddiffinio ar gyfer crynodeb RSS';
$string['useradmineditadmin'] = 'Dim ond gweinyddwyr sy\'n cael addasu cyfrifon gweinyddwyr eraill';
$string['useradminodelete'] = 'Does dim modd dileu cyfrifon gweinyddwyr';
$string['userautherror'] = 'Ategyn dilysu dieithr';
$string['userauthunsupported'] = 'Does dim modd delio â\'r ategyn dilysu yma';
$string['useremailduplicate'] = 'Dyblygu cyfeiriad';
$string['usermustbemnet'] = 'Mae\'n rhaid i ddefnyddwyr ar y rhestr rheoli mynediad MNET fod yn ddefnyddwyr MNET o bell';
$string['usernotaddederror'] = 'Heb ychwanegu defnyddiwr - gwall';
$string['usernotaddedregistered'] = 'Heb ychwanegu defnyddiwr - mae wedi\'i gofrestru\'n barod';
$string['usernotavailable'] = 'Nid yw manylion y defnyddiwr hwn ar gael i chi';
$string['usernotdeletedadmin'] = 'Heb ddileu\'r defnyddiwr - does dim modd dileu cyfrifon gweinyddwyr';
$string['usernotdeletederror'] = 'Heb ddileu\'r defnyddiwr - gwall';
$string['usernotdeletedmissing'] = 'Heb ddileu\'r defnyddiwr - doedd dim modd canfod yr enw defnyddiwr';
$string['usernotdeletedoff'] = 'Heb ddileu\'r defnyddiwr - dim hawl i ddileu';
$string['usernotincourse'] = 'Nid yw\'r defnyddiwr ar y cwrs hwn!';
$string['usernotrenamedadmin'] = 'Does dim modd ailenwi cyfrifon gweinyddwyr';
$string['usernotrenamedexists'] = 'Heb ailenwi\'r defnyddiwr -- mae\'r enw defnyddiwr newydd eisoes yn cael ei ddefnyddio';
$string['usernotrenamedmissing'] = 'Heb ailenwi\'r defnyddiwr -- wedi methu â chanfod yr hen enw defnyddiwr';
$string['usernotrenamedoff'] = 'Heb ailenwi\'r defnyddiwr - dim hawl i ailenwi';
$string['usernotupdatedadmin'] = 'Does dim modd diweddaru cyfrifon gweinyddwyr';
$string['usernotupdatederror'] = 'Heb ddiweddaru\'r defnyddiwr - gwall';
$string['usernotupdatednotexists'] = 'Heb ddiweddaru defnyddiwr - nid yw\'n bodoli';
$string['userquotalimit'] = 'Rydych chi wedi cyrraedd terfyn eich cwota ffeiliau.';
$string['userselectortoomany'] = 'Daeth user_selector ar draws mwy nag un defnyddiwr, er bod dewis mwy nag un wedi\'i analluogi.';
$string['wrongcall'] = 'Mae\'r sgript hon wedi\'i galw\'n anghywir';
$string['wrongcontextid'] = 'Roedd yr ID Cyd-destun yn anghywir (heb lwyddo i ddod o hyd iddo)';
$string['wrongdestpath'] = 'Llwybr cyrchfan anghywir';
$string['wrongroleid'] = 'ID swyddogaeth anghywir!';
$string['wrongsourcebase'] = 'Bôn URL ffynhonnell anghywir';
$string['wrongusernamepassword'] = 'Defnyddiwr/cyfrinair anghywir';
$string['wrongzipfilename'] = 'Enw ffeil ZIP anghywir';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Doedd dim modd creu cwrs - Dim caniatâd';
$string['wwwrootmismatch'] = 'Wedi canfod mynediad anghywir, dim ond drwy\'r cyfeiriad "{$a}" y gellir cael mynediad at y gweinydd hwn yn anffodus. Rhowch wybod i weinyddwr y gweinydd.';
$string['wwwrootslash'] = 'Wedi canfod $CFG->wwwroot anghywir yn config.php, ni ddylai gynnwys slaes ar y diwedd.<br />Rhowch wybod i weinyddwr y gweinydd.';
$string['xmldberror'] = 'Gwall XMLDB!';
$string['youcannotdeletecategory'] = 'Chewch chi ddim dileu\'r categori \'{$a}\' gan na allwch chi ddileu\'r cynnwys na\'i symud i rywle arall.';
