<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'eu', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Dagoeneko {$a} gisa identifikatuta zaude, beste erabiltzaile bat bezala identifikatzeko lehenik irten egin behar duzu.';
$string['authnotexisting'] = 'Autorizazio-plugina ez da existitzen';
$string['backuptablefail'] = 'Segurtasun-kopiaren taulak EZ dira ondo sortu!';
$string['blockcannotconfig'] = 'Bloke honek ez ditu ezarpen orokorrak onartzen ';
$string['blockcannotinistantiate'] = 'Arazoa bloke-objektuaren instantzia egitean';
$string['blockcannotread'] = 'Ondorengo bloke id-tik ezin da daturik irakurri= {$a}';
$string['blockdoesnotexist'] = 'Bloke hau ez da existitzen';
$string['blockdoesnotexistonpage'] = 'Bloke hau (id={$a->instanceid}) ez da existitzen orri honetan: ({$a->url}).';
$string['blocknameconflict'] = 'Izenen arteko gatazka: {$a->name} blokeak dagoeneko baden beste bloke honen izenburu bera du: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Moduluak ez du iruzkin hau onartzen.';
$string['cannotaddcoursemodule'] = 'Ezin da ikastaro-modulu berria gehitu';
$string['cannotaddcoursemoduletosection'] = 'Ezin da ikastaro-modulu berria gehitu atal honetan';
$string['cannotaddmodule'] = '{$a} modulua ezin da gehitu modulu-zerrendara!';
$string['cannotaddnewmodule'] = 'Ezin da modulu berria gehitu {$a} -rako';
$string['cannotaddrss'] = 'Ez duzu baimenik RSS jarioak gehitzeko';
$string['cannotaddthisblocktype'] = 'Ezin duzu {$a} blokea gehitu orri honetan.';
$string['cannotassignrole'] = 'Ezin da ikastaroan rola ezarri';
$string['cannotassignrolehere'] = 'Ez duzu baimenik rol hau (id = {$a->roleid}) esleitzeko testuinguru honetan ({$a->context})';
$string['cannotassignselfasparent'] = 'Ezin da berau ezarri goragoko gisa!';
$string['cannotcallscript'] = 'Ezin duzu script hau horrela deitu';
$string['cannotcreatebackupdir'] = 'Ezin da backupdata karpeta sortu. Guneko kudeatzaileak fitxategien baimenak ezarri behar ditu';
$string['cannotcreatecategory'] = 'Kategoria ez da txertatu';
$string['cannotcreategroup'] = 'Errorea taldea sortzean';
$string['cannotcreatelangbase'] = 'Errorea: ezin izan da oinarrizko hizkuntza-direktorioa sortu';
$string['cannotcreatelangdir'] = 'Ezin da hizkuntza-direktorioa sortu';
$string['cannotcreateorfindstructs'] = 'Errorea ikastaro honetarako atal-egitura bilatzean edo sortzean';
$string['cannotcreatepopupwin'] = 'Definitu gabeko elementua - ezin da sortu pop-up leihorik';
$string['cannotcreatesitedir'] = 'Ezin da guneko karpetarik sortu. Guneko kudetzaileak ezarri behar ditu fitxategirako baimenak';
$string['cannotcreatetempdir'] = 'Ezin da temp direktorioa sortu';
$string['cannotcreateuploaddir'] = 'Ezin da jaitsitakoetarako karpetarik sortu. Guneko kudetzaileak ezarri behar ditu fitxategirako baimenak';
$string['cannotcustomisefiltersblockuser'] = 'Ezin duzu ezarpen-iragazkirik pertsonalizatu erabiltzaileen edo blokeen testuinguruetan.';
$string['cannotdeletebackupids'] = 'Ezin izan dira aurreko segurtasun-kopien IDak ezabatu';
$string['cannotdeletecategorycourse'] = '\'{$a}\' ikastaroaren ezabaketak kale egin du.';
$string['cannotdeletecategoryquestions'] = 'Ezin dira galderak ezabatu \'{$a}\' kategoriatik';
$string['cannotdeletecourse'] = 'Ez duzu ikastaro hau ezabatzeko baimenik';
$string['cannotdeletecustomfield'] = 'Errorea pertsonalizatutako eremuen datuak ezabatzean';
$string['cannotdeletedir'] = 'Ezin da ezabatu ({$a})';
$string['cannotdeletefile'] = 'Ezin da ezabatu fitxategi hau';
$string['cannotdeleterole'] = 'Ezin da ezabatu, zeren {$a}';
$string['cannotdeleterolewithid'] = 'Ezin da {$a} ID-a duen rola ezabatu';
$string['cannotdeletethisrole'] = 'Ezin duzu rola hau ezabatu sistemak erabiltzen duelako edo kudeatzailearen gaitasunak dituen azkena delako.';
$string['cannotdisableformat'] = 'Ezin duzu desgaitu berezko formatua';
$string['cannotdownloadcomponents'] = 'Ezin dira osagaiak jaitsi';
$string['cannotdownloadlanguageupdatelist'] = 'Ezin da download.moodle.org-tik eguneratzeko hizkuntza-zerrenda jaitsi';
$string['cannotdownloadzipfile'] = 'Ezin da ZIP fitxategia jaitsi';
$string['cannoteditcomment'] = 'Iruzkin hau ez da zuk editatzekoa!';
$string['cannoteditcommentexpired'] = 'Ezin duzu hau editatu. Denbora amaitu egin da!';
$string['cannoteditpostorblog'] = 'Ezin duzu mezurik bidali edo bloga editatu';
$string['cannoteditsiteform'] = 'Ezin duzu guneko ikastaroa formulario hau erabilita';
$string['cannotedityourprofile'] = 'Barkatu, ezin duzu zeure profila editatu';
$string['cannotexecduringupgrade'] = 'Ezin izango da egikaitu eguneraketa izan bitartean';
$string['cannotfindcomponent'] = 'Ezin da osagaia aurkitu';
$string['cannotfindcontext'] = 'Ezin da testuingurua aurkitu';
$string['cannotfindcourse'] = 'Ezin da ikastaroa aurkitu';
$string['cannotfinddocs'] = 'Ezin dira "{$a}" hizkuntzaren docs fitxategiak aurkitu';
$string['cannotfindgradeitem'] = 'Ezin da grade_item aurkitu';
$string['cannotfindgroup'] = 'Ezin da taldea aurkitu';
$string['cannotfindhelp'] = 'Ezin dira "{$a}" hizkuntzaren laguntza-fitxategiak aurkitu';
$string['cannotfindinfo'] = 'Ezin da ondokoarentzako informaziorik aurkitu: "{$a}"';
$string['cannotfindlang'] = 'Ezin da "{$a}" hizkuntza-paketea aurkitu!';
$string['cannotfindteacher'] = 'Ezin da irakaslea aurkitu';
$string['cannotfinduser'] = 'Ezin da "{$a}" erabiltzaile-izena aurkitu';
$string['cannotgetblock'] = 'Ezin da blokerik berreskuratu datu-basetik';
$string['cannotgetcats'] = 'Ezin da lortu kategoria-erregistrorik';
$string['cannotgetdata'] = 'Ezin da daturik lortu';
$string['cannotgradeuser'] = 'Ezin da erabiltzaile honen kalifikaziorik aurkitu';
$string['cannothaveparentcate'] = 'Ikastaro-kategoriak ezin du goragokorik izan!';
$string['cannotimport'] = 'Errorea inportatzean';
$string['cannotimportformat'] = 'Barkatu, formatu hau inportatzea ez dago oraindik indarrean!';
$string['cannotimportgrade'] = 'Errorea kalifikazioak inportatzean';
$string['cannotinsertgrade'] = 'Ezin da kalifikazio-elementurik txertatu ikastaroaren ID-rik gabe!';
$string['cannotinsertrate'] = 'Ezin da beste kalifikazio bat txertatu ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Ezin da {$a} ID-a duen erregistro berria txertatu';
$string['cannotmailconfirm'] = 'Errorea pasahitza aldatzeko konfirmazio e-posta bidaltzean';
$string['cannotmanualctrack'] = 'Jarduerak ez du eskuz osatutzat emateko jarraipenik';
$string['cannotmarktopic'] = 'Ezin da gai hau markatu ikastaro honetan';
$string['cannotmigratedatacomments'] = 'Ezin dira iruzkinak migratu datuen modulutik';
$string['cannotmovecategory'] = 'Ezin da kategoria mugitu';
$string['cannotmoverolewithid'] = 'Ezin da {$a} ID-a duen rola mugitu';
$string['cannotopencsv'] = 'Ezin da CSV fitxategia zabaldu';
$string['cannotopenfile'] = 'Ezin da fitxategia zabaldu ({$a})';
$string['cannotopenforwrit'] = 'Ezin da zabaldu idazteko: {$a}';
$string['cannotopentemplate'] = 'Ezin da txantiloi-fitxategia zabaldu ({$a})';
$string['cannotopenzip'] = 'Ezin da zip fitxategia zabaldu, ziur aski errorea dago 64 bit-eko sistema eragileko zip luzapenean';
$string['cannotoverridebaserole'] = 'Ezin dira oinarrizko rolaren baimenak baliogabetu';
$string['cannotoverriderolehere'] = 'Ez duzu (id = {$a->roleid}) rola  ({$a->context}) testuinguruan kentzeko baimenik';
$string['cannotreadfile'] = 'Ezin da fitxategia irakurri ({$a})';
$string['cannotreadtmpfile'] = 'Errorea aldi baterako fitxategia irakurtzean';
$string['cannotreaduploadfile'] = 'Ezin da jaitsitako fitxategia irakurri';
$string['cannotremovefrommeta'] = 'Ezin da aukeratutako ikastaroa meta-ikastaro honetatik kendu!';
$string['cannotresetguestpwd'] = 'Ezin duzu bisitarien pasahitza berezko ezarpenetara ekarri';
$string['cannotresetmail'] = 'Errorea pasahitza berrezartzean eta zuri bidaltzean';
$string['cannotresetthisrole'] = 'Ezin da rol hau berezko baloreetara ekarri';
$string['cannotrestore'] = 'Errorea gertatu da eta ezin izan guztiz berreskuratu!';
$string['cannotrestoreadminorcreator'] = 'Ikastaro-sortzailea edo kudeatzailea izan behar duzu ikastaro bat berreskuratu ahal izateko!';
$string['cannotrestoreadminoredit'] = 'Edizio baimena duen irakaslea edo kudeatzailea izan behar duzu aukeratutako ikastaroa berrabiarazteko!';
$string['cannotsaveagreement'] = 'Ezin da zure akordioa gorde';
$string['cannotsaveblock'] = 'Errorea blokearen ezarpenak gordetzean';
$string['cannotsavecomment'] = 'Ezin da iruzkina gorde';
$string['cannotsavedata'] = 'Ezin da datu-basea gorde';
$string['cannotsavefile'] = 'Ezin da "{$a}" fitxategia gorde!';
$string['cannotsavemd5file'] = 'Ezin da Md5 fitxategia gorde';
$string['cannotsavezipfile'] = 'Ezin da ZIP fitxategia gorde';
$string['cannotservefile'] = 'Ezin da fitxategia erakutsi: zerbitzariaren konfigurazio-arazoa.';
$string['cannotsetparentforcatoritem'] = 'Ezin da ezarri goragokorik kategoria edo ikastaro-elementurako!';
$string['cannotsetpassword'] = 'Ezin da ezarri erabiltzaile-pasahitzik!';
$string['cannotsettheme'] = 'Ezin da itxura ezarri!';
$string['cannotsetupblock'] = 'Blokeen taulak EZ dira ondo sortu!';
$string['cannotsetupcapformod'] = 'Ezin dira gaitasunak esleitu honentzat: {$a}';
$string['cannotsetupcapforplugin'] = 'Ezin dira gaitasunak esleitu honentzat: {$a}';
$string['cannotshowhidecoursesincategory'] = 'Ezin dira ikastaroak erakutsi/ezkutatu {$a} kategorian.';
$string['cannotunassignrolefrom'] = 'Ezin zaio erabiltzaie honi {$a} ID-a duen rola kendu';
$string['cannotunzipfile'] = 'Ezin da fitxategia deskonprimatu';
$string['cannotupdatemod'] = 'Ezin da {$a} eguneratu';
$string['cannotupdateprofile'] = 'Errorea erabiltzailearen erregistroa eguneratzean';
$string['cannotupdaterecord'] = 'Ezin da eguneratu {$a} ID-a duen erregistroa';
$string['cannotupdaterss'] = 'Ezin da RSS jarioa eguneratu';
$string['cannotupdatesubcourse'] = 'Ezin da beheragoko ikastaroa eguneratu!';
$string['cannotupdateusermsgpref'] = 'Ezin dira erabiltzailearen mezularitza-hobespenak eguneratu';
$string['cannotuploadfile'] = 'Errorea eguneratutako fitxategia prozesatzean';
$string['cannotuseadmin'] = 'Kudeatzailea izan behar duzu orri hau erabili ahal izateko';
$string['cannotuseadminadminorteacher'] = 'Kudeatzailea edo irakaslea izan behar duzu orri hau erabili ahal izateko';
$string['cannotusepage'] = 'Irakasleek edo kudeatzaileek baino ezin dute orri hau erabili';
$string['cannotusepage2'] = 'Barkatu, ezin duzu orri hau erabili';
$string['cannotviewprofile'] = 'Ezin duzu erabiltzaile honen profila ikusi';
$string['cannotviewreport'] = 'Ezin duzu txosten hau ikusi';
$string['cannotwritefile'] = 'Ezin da fitxategian idatzi ({$a})';
$string['categoryerror'] = 'Kategoria-errorea';
$string['categoryidnumbertaken'] = 'ID zenbakia dagoeneko erabilita dago beste kategoria batean';
$string['categorynamerequired'] = 'Kategoria-izena derrigorrezkoa da';
$string['categorytoolong'] = 'Kategoriaren izena luzeegia';
$string['commentmisconf'] = 'Iruzkinaren IDa gaizki konfiguratuta dago';
$string['componentisuptodate'] = 'Osagaia eguneratu da';
$string['confirmsesskeybad'] = 'Sentitzen dugu, baina ekintza hau egiteko zure saio-pasahitza ezin izan da baieztatu. Segurtasun-ezaugarri honek zure izenean, ustekabean edo fede txarrez, eginkizun garrantzitsuen egikaritzea saihesten du. Eginkizun hori egikaritu nahi duzula ziur izan, mesedez.';
$string['couldnotassignrole'] = 'Zuri rol bat ezartzean zehaztu gabeko arazo larria gertatu da.';
$string['couldnotupdatenoexistinguser'] = 'Ezin da eguneratu erabitlzailea - erabitlzailea ez dago';
$string['countriesphpempty'] = 'Errorea: {$a} hizkuntza-paketeko countries.php fitxategia hutsik edo galduta dago';
$string['coursedoesnotbelongtocategory'] = 'Ikastaroa ez da kategoria honetakoa';
$string['courseformatnotfound'] = '\'{$a}\' ikastaro-formatua ez da existitzen, edo ez da formatu ezaguna';
$string['coursegroupunknown'] = '{$a} taldeari dagokion ikastaroa ez da zehaztu';
$string['courseidnotfound'] = 'Ikastaroa ID-a ez dago';
$string['courseidnumbertaken'] = 'ID zenbakia dagoeneko erabilita dago beste ikastaro batean  ({$a})';
$string['coursemisconf'] = 'Ikastaroa gaizki konfiguratuta dago';
$string['courserequestdisabled'] = 'Barkatu, baina ikastaro-eskariak egiteko modua kudeatzaileak desgaitu du.';
$string['csvcolumnduplicates'] = 'Bikoiztutako zutabeak atzeman dira';
$string['csvemptyfile'] = 'CSV fitxategia hutsik dago.';
$string['csvfewcolumns'] = 'Ez dago zutabe nahikorik, mesedez egiazta ezazu mugatzailearen ezarpena';
$string['csvinvalidcols'] = '<b>CSV fitxategia ez da egokia:</b> lehen lerroak "Header Fields" izan behar du eta fitxategiak <br />"Expanded Fields/Comma Separated"<br /> erakoa izan behar du edo<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'CSV fitxategi ezegokia - lerro bakoitzak 49 edo 70 eremu izan behar ditu';
$string['csvloaderror'] = 'Errorea gertatu da CVS fitxategia igotzean: {$a}';
$string['csvweirdcolumns'] = 'CSV fitxategi-formatuak ez du balio - zutabe-kopurua ez da beti bat!';
$string['dbsessionbroken'] = 'Datu-basean arazo larria gertatu da.<br /><br />Mesedez, jakinarazi zerbitzariaren kudeatzaileari.';
$string['dbsessionmysqlpacketsize'] = 'Saioan errore larria atzeman da. Mesedez, jakinarazi guneko kudeatzaileari; errore hau max_allowed_packet  MySQL ezarpenean balore handiegia ezarri delako gertatuko zen ziurrenik.';
$string['dbupdatefailed'] = 'Datu-basearen eguneraketak kale egin du';
$string['ddlexecuteerror'] = 'Errorea DDL sql egikaritzean';
$string['ddlfieldalreadyexists'] = '"{$a}" eremua badago dagoeneko';
$string['ddlfieldnotexist'] = '"{$a->fieldname}" eremua ez da "{$a->tablename}" taulan existitzen';
$string['ddltablealreadyexists'] = 'Bada dagoeneko "{$a}" taula';
$string['ddltablenotexist'] = '"{$a}" taula ez da existitzen';
$string['ddlunknownerror'] = 'DDL liburutegiaren errore ezezaguna';
$string['ddlxmlfileerror'] = 'XML datu-base fitxategiak erroreak ditu';
$string['destinationcmnotexit'] = 'Helburu-ikastaroaren modulua ez da existitzen';
$string['detectedbrokenplugin'] = '"{$a}" plugina ez dago ondo, ezin da aurrera jarraitu. Barkatu.';
$string['dmlexceptiononinstall'] = '<p>Datu-basearen errorea gertatu da [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlreadexception'] = 'Errorea datu-basetik irakurtzean';
$string['dmltransactionexception'] = 'Errorea datu-basearekiko transakzioan';
$string['dmlwriteexception'] = 'Errorea datu-basean idaztean';
$string['downloadedfilecheckfailed'] = 'Jaitsitako fitxategiaren konprobazioak kale egin du.';
$string['duplicatefieldname'] = '"{$a}" eremuaren izen bikoiztua atzeman da';
$string['duplicateparaminsql'] = 'ERROREA: parametro bikoiztua kontsultan';
$string['duplicaterolename'] = 'Dagoeneko bada izen hori duen rola!';
$string['duplicateroleshortname'] = 'Dagoeneko bada izen labur hori duen rola!';
$string['duplicateusername'] = 'Bikoiztutako erabiltzaile-izena - erregistroa alde batera utzi da';
$string['emailfail'] = 'E-posta ez da egoki bidali';
$string['error'] = 'Errorea gertatu da';
$string['errorcleaningdirectory'] = 'Errorea gertatu da "{$a}" karpeta garbitzean';
$string['errorcopyingfiles'] = 'Errorea fitxategiak kopiatzean';
$string['errorcreatingdirectory'] = 'Errorea "{$a}" direktorioa sortzean';
$string['errorcreatingfile'] = 'Errorea "{$a}" fitxategia sortzean';
$string['errorcreatingrole'] = 'Errorea rola sortzean';
$string['errorfetchingrssfeed'] = 'Errorea RSS jarioa lortzean.';
$string['erroronline'] = 'Errorea {$a} lerroan';
$string['errorparsingxml'] = 'Errorea XMLa analizatzean: {$a->errorstring} {$a->errorline} lerroan,  {$a->errorchar} karakterea';
$string['errorreadingfile'] = 'Errorea "{$a}" fitxategia irakurtzean';
$string['errorsavingrequest'] = 'Errorea gertatu da zure eskaria gordetzean.';
$string['errorsettinguserpref'] = 'Errorea erabiltzailearen hobespenak ezartzean';
$string['errorunzippingfiles'] = 'Errorea fitxategiak deskonprimatzean';
$string['expiredkey'] = 'Iraungitako giltza';
$string['fieldrequired'] = '"{$a}" derrigorrezko eremua da';
$string['fileexists'] = 'Fitxategia dagoeneko badago';
$string['filenotfound'] = 'Barkatu, baina eskatutako fitxategia ezin izan dugu aurkitu';
$string['filenotreadable'] = 'Fitxategia ez da irakurtzeko modukoa';
$string['filternotactive'] = '{$a} iragazkia ez dago une honetan indarrean';
$string['filternotenabled'] = 'Iragazkia ez dago gaituta!';
$string['filternotinstalled'] = '{$a} iragazkia ez dago une honetan instalatuta';
$string['forumblockingtoomanyposts'] = 'Foro honetara mezuak bidaltzeko denbora-epea gainditu duzu.';
$string['generalexceptionmessage'] = 'Salbuespena - {$a}';
$string['gradecantregrade'] = 'Errorea gertatu da kalifikazioa kalkulatu bitartean: {$a}';
$string['gradepubdisable'] = 'Kalifikazioak argitaratzea desgaituta dago';
$string['groupalready'] = 'Erabiltzailea oraindik da {$a} taldeko partaidea';
$string['groupexistforcourse'] = 'Ikastaro honetan dagoeneko bada "{$a}" taldea';
$string['groupingnotaddederror'] = '"{$a}" taldekatzea ez da gehitu';
$string['groupnotaddederror'] = '"{$a}" taldea ez da gehitu';
$string['groupnotaddedtogroupingerror'] = '"{$a->groupname}" taldea ez da  "{$a->groupingname}" taldekatzera gehitu';
$string['groupunknown'] = '{$a} taldea ez da inongo ikastarokoa';
$string['groupusernotmember'] = 'Erabiltzailea ez da talde honetako kidea';
$string['guestcantaccessprofiles'] = 'Bisitariek ez dute erabiltzaile-profiletarako sarbiderik. Hasi saioa zure kontuarekin aurrera egiteko.';
$string['guestnocomment'] = 'Bisitariek ez dute mezuen iruzkinak egiteko baimenik';
$string['guestnoeditprofile'] = 'Erabiltzaile bisitariek ezin dute beren profila editatu.';
$string['guestnoeditprofileother'] = 'Ezinezkoa da bisitarien profila editatzea.';
$string['guestnorate'] = 'Bisitariek ez dute sarrerak kalifikatzeko baimenik';
$string['guestsarenotallowed'] = 'Bisitari-rola ez dago honetarako baimenduta';
$string['hackdetected'] = 'Hack-en erasoa atzeman da!';
$string['headersent'] = 'Goiburuak dagoeneko bidali dira';
$string['idnumbertaken'] = 'ID zenbakia dagoeneko erabiltzen ari da';
$string['idnumbertoolong'] = 'ID zenbakia luzeegia da';
$string['importformatnotimplement'] = 'Barkatu, formatu hau inportatzea ez dago oraindik';
$string['incorrectext'] = 'Fitxategiaren luzapena ez da zuzena';
$string['internalauthpassworderror'] = 'Pasahitza falta da edo pasahitz-politika ez da baliagaria barne-autentifikaziorako';
$string['invalidaccess'] = 'Orri honetarako sarbidea ez da zuzena izan';
$string['invalidaccessparameter'] = 'Sarbiderako parametro baliogabea';
$string['invalidaction'] = 'Ekintzarako parametro baliogabea';
$string['invalidactivityid'] = 'Jardueraren ID baliogabea';
$string['invalidadminsettingname'] = 'Kudeatzaile ezarpen baliogabea ({$a})';
$string['invalidarguments'] = 'Ez dago emandako argumentu baliagarririk';
$string['invalidcategory'] = 'Kategoria ez da zuzena!';
$string['invalidcategoryid'] = 'Kategoriaren IDa ez da zuzena!';
$string['invalidcomment'] = 'Iruzkina ez da zuzena!';
$string['invalidcommentarea'] = 'Iruzkinen eremua ez da baliagarria';
$string['invalidcommentid'] = 'Iruzkinaren ID baliogabea';
$string['invalidcommentitemid'] = 'Iruzkinaren itemid baliogabea';
$string['invalidcommentparam'] = 'Iruzkinaren parametro baliogabeak';
$string['invalidcomponent'] = 'Osagaiaren izen baliogabea';
$string['invalidconfirmdata'] = 'Datuen egiaztapen baliogabea';
$string['invalidcontext'] = 'Testuinguru baliogabea';
$string['invalidcourse'] = 'Ikastaro baliogabea';
$string['invalidcourseid'] = 'Ikastaroaren ID baliogabea ari zara erabiltzen';
$string['invalidcourselevel'] = 'Testuinguru-maila ez da zuzena!';
$string['invalidcoursemodule'] = 'Ikastaro-moduluaren ID-a baliogabea da';
$string['invalidcoursenameshort'] = 'Ikastaroaren izen laburra baliogabea da';
$string['invaliddata'] = 'Bidalitako data ez da egokia';
$string['invaliddevicetype'] = 'Gailu-mota baliogabea';
$string['invalidelementid'] = 'Elementuaren IDa ez da zuzena!';
$string['invalidentry'] = 'Hau ez da sarrera baliagarria!';
$string['invalidevent'] = 'Ekitaldi baliogabea';
$string['invalidfieldname'] = '"{$a}"  ez da izen baliagarria eremu honetarako';
$string['invalidfiletype'] = '"{$a}" ez da fitxategi mota baliagarria';
$string['invalidformatpara'] = 'Formatua ez da zuzena parametroa aukeratzeko';
$string['invalidformdata'] = 'Datu-formularioa ez da zuzena';
$string['invalidfunction'] = 'Funtzioa ez da zuzena';
$string['invalidgradeitemid'] = 'Kalifikaizo-elementuaren IDa ez da zuzena';
$string['invalidgroupid'] = 'Taldearen IDa ez da zuzen zehaztu';
$string['invalidipformat'] = 'IP helbide-formatu honek ez du balio';
$string['invaliditemid'] = 'Elementuaren IDa ez da zuzena';
$string['invalidkey'] = 'Giltza ez da zuzena';
$string['invalidmd5'] = 'md5 ez da baliagarria';
$string['invalidmode'] = 'Modu baliogabea ({$a})';
$string['invalidmodule'] = 'Modulu baliogabea';
$string['invalidmoduleid'] = 'Moduluaren ID baliogabea: {$a}';
$string['invalidmodulename'] = 'Moduluaren izen baliogabea: {$a}';
$string['invalidnum'] = 'Zenbakizko balore baliogabea';
$string['invalidoutcome'] = 'Helburuaren IDa ez da zuzena';
$string['invalidpagesize'] = 'Orriaren tamaina baliogabea';
$string['invalidpasswordpolicy'] = 'Pasahitzen politika baliogabea';
$string['invalidpaymentmethod'] = 'Ordainketa-metodo baliogabea: {$a}';
$string['invalidratingarea'] = 'Kalifikazioen eremua ez da baliagarria';
$string['invalidrecord'] = 'Ezin da datuen erregistroa aurkitu datu-basearen  {$a} taulan.';
$string['invalidrecordunknown'] = 'Ezin da datuen erregistroa aurkitu datu-basean.';
$string['invalidrequest'] = 'Eskari baliogabea';
$string['invalidrole'] = 'Rol baliogabea';
$string['invalidroleid'] = 'Rolaren ID baliogabea';
$string['invalidscaleid'] = 'Eskalaren IDa ez da zuzena';
$string['invalidshortname'] = 'Ikastaroaren izen laburra ez da egokia';
$string['invalidurl'] = 'URL baliogabea';
$string['invaliduser'] = 'Erabiltzaile baliogabea';
$string['invaliduserfield'] = 'Erabiltzailearen eremu baliogabea: {$a}';
$string['invaliduserid'] = 'Erabiltzailearen ID baliogabea';
$string['invalidxmlfile'] = '"{$a}" ez da XML fitxategi baliagarria.';
$string['iplookupfailed'] = 'Ezin da {$a} IP helbideari buruzko informaziorik aurkitu';
$string['iplookupprivate'] = 'Ezin da IP helbide pribatuaren bilaketarik erakutsi';
$string['ipmismatch'] = 'Bezeroaren IP helbidea ez dator bat';
$string['listcantmovedown'] = 'Kale egin du elementua behera mugitzeak, zeren berdinen arteko azkena baita';
$string['listcantmoveleft'] = 'Kale egin du ezkerreko elementua mugitzeak, zeren ez baitago goragokoa';
$string['listcantmoveright'] = 'Errorea elementua eskuinera eramatean, ez baitago beste bat horren beheragokoa izan dadin. Mugi ezazu hau beste baten azpira eta horrela eskuinera eraman ahal izango duzu.';
$string['listcantmoveup'] = 'Errorea elementua gora eramatean, hau baita bere mailakoen arteko lehena.';
$string['listnochildren'] = 'Ez dago aurkitutako elementuaren beheragokorik';
$string['listnoitem'] = 'Ez da elementua aurkitu';
$string['listnopeers'] = 'Ez dago aurkitutako elementuaren maila berekorik';
$string['listupdatefail'] = 'Errorea DB eragiketan zerrendaren ierarkia editatzean';
$string['logfilenotavailable'] = 'Agerraldiak ez daude eskuragarri';
$string['loginasnoenrol'] = 'Ezin duzu matrikulatu edo desmatrikulatu "Aukeratu beste rol bat" erabiltzen ari zarenean.';
$string['loginasonecourse'] = 'Ezin zara ikastaro honetan sartu.<br />"Aukeratu beste rol bat" saioa bukatu behar duzu beste edozein ikastarotan sartzeko.';
$string['maxbytes'] = 'Fitxategiaren tamaina gehienez onartutakoa baino handiago da';
$string['messagingdisable'] = 'Mezularitza desgaituta dago gune honetan';
$string['missingfield'] = '"{$a}" eremua falta da';
$string['missingkeyinsql'] = 'ERROREA: kontsultan "{$a}" parametroa falta da';
$string['missing_moodle_backup_xml_file'] = 'Segurtasun-kopian XML fitxategia falta da: {$a}';
$string['missingparam'] = 'Behar den ({$a}) parametroa falta da';
$string['missingparameter'] = 'Parametroa falta da';
$string['missingrequiredfield'] = 'Beharrezko eremuren bat falta da.';
$string['mnetdisable'] = 'MNET desgaituta dago';
$string['mnetlocal'] = 'Urrutiko MNET erabiltzaileek ezin dute saioa lokalean hasi';
$string['moduledisable'] = 'Modulu hau ({$a}) desgaituta dago ikastaro jakin honetarako';
$string['moduledoesnotexist'] = 'Modulu hau ez da existitzen';
$string['moduleinstancedoesnotexist'] = 'Modulu honen erregistroa ez da existitzen';
$string['modulemissingcode'] = '{$a} moduluak ez dauka funtzio hau aurrera eramateko beharrezko kodea.';
$string['movecategorynotpossible'] = 'Ezin duzu \'{$a}\' kategoria mugitu aukeratutako kategoriara.';
$string['mustbeloggedin'] = 'Saioa hasi behar duzu hori egiteko';
$string['mustbeteacher'] = 'Irakaslea izan behar duzu orri hau ikusteko';
$string['needcopy'] = 'Lehenengo zerbait kopiatu behar duzu!';
$string['needcoursecategroyid'] = 'Ikastaro guztien IDa edo kategoria zehaztu behar da';
$string['noadmins'] = 'Ez dago kudeatzailerik!';
$string['noblocks'] = 'Ez da blokerik aurkitu!';
$string['nocapabilitytousethisservice'] = 'Erabiltzaileak ez du baimenik zerbitzu hau erabiltzeko';
$string['nocategorydelete'] = '\'{$a}\' kategoria ezin da ezabatu!';
$string['nocontext'] = 'Barkatu, ikastaro hau ez da testuinguru baliagarria';
$string['nodata'] = 'Daturik ez';
$string['noexistingcategory'] = 'Ez dago kategoriarik';
$string['nofile'] = 'Ez da fitxategia zehaztu';
$string['nofiltersenabled'] = 'Iragazkiak ez daude gaituta.';
$string['nofolder'] = 'Eskatutako direktorioa ez da existitzen';
$string['noguest'] = 'Hemen bisitaririk ez!';
$string['noinstances'] = 'Ikastaro honetan ez da {$a} azaltzen.';
$string['nologinas'] = 'Ez duzu rol hori aukeratzeko baimenik "Aukeratu beste rol bat"-en';
$string['nonmeaningfulcontent'] = 'Eduki esaguratsurik ez';
$string['noparticipants'] = 'Ez da partaiderik aurkitu ikastaro honetarako';
$string['noparticipatorycms'] = 'Sentitzen dugu, baina ez duzu ikastaroez informatzeko partaidetza-modulurik.';
$string['nopermissions'] = 'Sentitzen dugu, baina oraingoz ez duzu hori egiteko baimenik ({$a})';
$string['nopermissiontocomment'] = 'Ezin duzu iruzkinik gehitu';
$string['nopermissiontodelentry'] = 'Ezin dituzu beste pertsonen sarrerak ezabatu!';
$string['nopermissiontoeditcomment'] = 'Ezin dituzu beste pertsonen iruzkinak editatu!';
$string['nopermissiontohide'] = 'Ez duzu ezkutatzeko baimenik!';
$string['nopermissiontoimportact'] = 'Ez dituzu jarduerak ikastaro honetara inportatzeko behar diren baimenak';
$string['nopermissiontolock'] = 'Ez duzu blokeatzeko baimenik!';
$string['nopermissiontomanagegroup'] = 'Ez dituzu taldeak kudeatzeko behar diren baimenak';
$string['nopermissiontorate'] = 'Elementuak kalifikatzea ez dago baimenduta!';
$string['nopermissiontoshow'] = 'Ez duzu hau erakusteko baimenik!';
$string['nopermissiontounlock'] = 'Ez duzu desblokeatzeko baimenik!';
$string['nopermissiontoupdatecalendar'] = 'Barkatu, baina ez duzu egutegiko ekitaldiak eguneratzeko baimenik';
$string['nopermissiontoviewgrades'] = 'Ezin da kalifikaziorik ikusi.';
$string['nopermissiontoviewletergrade'] = 'Letra-kalifikazioak ikusteko baimena galduta.';
$string['nopermissiontoviewpage'] = 'Ez duzu orri hau begiratzeko baimenik.';
$string['nosite'] = 'Ezin da maila altuagoko ikastarorik aurkitu';
$string['nositeid'] = 'Guneko ID-rik ez';
$string['nostatstodisplay'] = 'Barkatu, baina ez dago erakusteko daturik';
$string['notavailable'] = 'Ez dago eskura';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Ez zara ikastaro-talde honetako kide';
$string['notownerofkey'] = 'Ez zara giltza honen jabe';
$string['nousers'] = 'Ez dago erabiltzaile hau!';
$string['onlyadmins'] = 'Kudeatzaileek baino ezin dute hori egin.';
$string['onlyeditingteachers'] = 'Edizio-baimena duten irakasleek baino ezin dute hori egin.';
$string['onlyeditown'] = 'Zeure informazioa baino ezin duzu editatu';
$string['pagenotexist'] = 'Ohiz kanpoko errorea gertatu da (ez dagoen orri batera sartzeko saiakera egin da).';
$string['pleasereport'] = 'Denbora baduzu, errorea gertatu zenean zertan saiatzen ari zinen jakinaraz iezaguzu, mesedez:';
$string['pluginrequirementsnotmet'] = '"{$a->pluginname}" ({$a->pluginversion}) plugina ezin izan da instalatu. Moodle-ren bertsio berriagoa behar duzu (zure bertsioa {$a->currentmoodle} da, eta plugin-ak behar duena {$a->requiremoodle} da)';
$string['prefixcannotbeempty'] = '<p>Errorea: datu-basearen taularen aurrizkia ezin da hutsik egon ({$a})</p> <p>Guneko kudeatzaileak arazo hau konpondu behar du.</p>';
$string['processingstops'] = 'Prozesamendua hemen bukatu da. Gainontzeko erregistroak ez dira kontuan hartu.';
$string['redirecterrordetected'] = 'Onartzen ez den berbideraketa atzeman da, script-aren egikaritzea amaitu da';
$string['remotedownloaderror'] = 'Errorea osagaia zure zerbitzarian jaistean, mesedez egiaztatu proxy-ezarpenak, PHP cURL luzapea erabat gomendatzen da.<br/><br /> <a href="*{$a->url}*">*{$a->url}*</a> fitxategia eskuz jaitsi beharko zenuke, zure zerbitzariko "*{$a->dest}*" -ra kopiatu eta bertan deskonprimatu.';
$string['remotedownloadnotallowed'] = 'Osagaiak ezin dira zure zerbitzarira jaitsi (allow_url_fopen ez dago aktibatuta).<br /><br /><a href="{$a->url}">{$a->url}</a> fitxategia eskuz jaitsi eta "{$a->dest}" kokapenean kopiatu behar duzu.';
$string['requirecorrectaccess'] = 'URLa edo ataka ez dira baliagarriak.';
$string['requireloginerror'] = 'Ez dago ikastaro edo jarduerarako sarbiderik';
$string['restricteduser'] = 'Sentitzen dugu, baina zure kontuak, "{$a}", ezin du holakorik egin.';
$string['scheduledbackupsdisabled'] = 'Guneko kudeatzaileak programatutako segurtasun-kopiak desgaitu ditu';
$string['sectionnotexist'] = 'Atal hau ez da existitzen';
$string['sendmessage'] = 'Mezua bidali';
$string['serverconnection'] = 'Errorea zerbitzariarekin konektatzean';
$string['servicedonotexist'] = 'Zerbitzua ez da existitzen';
$string['sessionerroruser'] = 'Saioa amaitu da. Sar zaitez berriro, mesedez.';
$string['sessionerroruser2'] = 'Zure saioari eragiten dion zerbitzari-errorea antzeman da. Berriz sartu edo nabigatzailea berriro abiatu, mesedez.';
$string['sessionipnomatch'] = 'Sentitzen dugu, baina lehenengo sarreratik zure IPa aldatu dela dirudi. Ziurtasun neurri honen arrazoia crackerrek gune honetan zauden bitartean zure nortasuna ez lapurtzean datza. Erabiltzaile arruntek ez lukete mezu hau ikusi beharko. Beraz, gunearen kudeatzaileari laguntza eskatu.';
$string['shortnametaken'] = 'Izan laburra dagoeneko beste ikastaro batean erabili da ({$a})';
$string['socksnotsupported'] = 'SOCKS5 proxya ez da onartzen PHP4-n';
$string['spellcheckernotconf'] = 'Zuzentzaile ortografikoa ez dago konfiguratuta';
$string['sslonlyaccess'] = 'Segurtasun-arrazoiak direla-eta, https konexioak bakarrik dude baimenduta, barkatu.';
$string['statscatchupmode'] = 'Estatistika une honetan \'catchup\' moduan dago. Orain arte {$a->daysdone} egun prozesatu dira eta {$a->dayspending} prozesatzeko daude. Mesedez, beranduago aztertu berriz.';
$string['statsdisable'] = 'Estatistikak ez daude gaituta.';
$string['statsnodata'] = 'Ez dago daturik ikastaro eta denbora-tarte konbinazio horretarako';
$string['storedfilecannotread'] = 'Ezin da fitxategia irakurri, edo ez dago fitxategia edo baimen arazoak daude.';
$string['storedfilenotcreated'] = 'Ezin da fitxategia sortu: "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['tagdisabled'] = 'Etiketak desgaituta daude!';
$string['tagnotfound'] = 'Ez da aurkitu zehaztutako etiketa datu-basean';
$string['themenotinstall'] = 'Itxura hau ez dago instalatuta!';
$string['TODO'] = 'EGITEKOAK';
$string['tokengenerationfailed'] = 'Ezin da token berria sortu.';
$string['unenrolerror'] = 'Errorea gertatu da pertsona hau desmatrikulatzean';
$string['unicodeupgradeerror'] = 'Barkatu baina zure datu-basea oraindik ez dago Unicoden eta Moodle-ren bertsio honek ezin du zure datu-basea Unicodera migratu. Mesedez, eguneratu Moodle 1.7.x-era eta egin Unicoderako migrazioa Kudeaketa orritik. Hori eginda, Moodle {$a}-rako migrazioa egin ahal izango duzu.';
$string['unknowaction'] = 'Ekintza ezezaguna!';
$string['unknowcategory'] = 'Kategoria ezezaguna!';
$string['unknowformat'] = 'Formatu ezezaguna ({$a})';
$string['unknownbackupexporterror'] = 'Errore ezezaguna inportatzeko informazioa prestatzean';
$string['unknownblockregion'] = '\'{$a}\' bloke-eremua ez da onartzen orri honetan.';
$string['unknowncontext'] = 'Hau testuinguru ezezaguna da.';
$string['unknowncourse'] = 'Ez dago "{$a}" izeneko ikastarorik';
$string['unknowncourseidnumber'] = '"{$a}" ikastaroaren ID ezezaguna';
$string['unknowncourserequest'] = 'Ikastaro-eskari ezezaguna';
$string['unknownevent'] = 'Ekitaldi ezezaguna';
$string['unknowngroup'] = '"{$a}" talde ezezaguna';
$string['unknownhelp'] = '{$a} laguntza-gaia ezezaguna';
$string['unknownjsinrequirejs'] = 'Ezin da JS liburutegia aurkitu: {$a}';
$string['unknownmodulename'] = 'Moduluaren izena ezezaguna da formulariorako';
$string['unknownrole'] = '"{$a}" rol ezezaguna';
$string['unknownuseraction'] = 'Barkatu, baina erabiltzailearen ekintza hau ez dugu ulertzen.';
$string['unknownuserselector'] = 'Erabiltzaile-hautatzaile ezezaguna';
$string['unknoworder'] = 'Ordena ezezaguna';
$string['unknowparamtype'] = 'Parametro-mota ezezaguna: {$a}';
$string['unknowquestiontype'] = '{$a} galdera-mota onartezina';
$string['unspecifycourseid'] = 'Ikastaroaren ID-a, izen laburra edo ID zenbakia zehaztu behar da.';
$string['unsupportedevent'] = 'Ekitaldi-mota onartezina';
$string['unsupportedwebserver'] = 'Web zerbitzariaren softwarea ({$a}) ez da onartzen, barkatu.';
$string['upgraderequires19'] = 'Errorea: Moodle-ren bertsio berria instalatu da zerbitzarian eta tamalez ez da onartzen aurreko bertsiotiko eguneraketa.<br />Mesedez, eguneratu lehenik askatutako 1.9.x azken bertsiora. Aurreko bertsiora ere itzul zaitezke jatorrizko fitxategiak instalatuta.';
$string['upgraderunning'] = 'Gunea eguneratzen ari da; mesedez, saitu beranduago.';
$string['urlnotdefinerss'] = 'RSS jariorako URLa ez dago definituta';
$string['useradmineditadmin'] = 'Kudeatzaileek bakarrik alda ditzakete beste kudeatzaileen kontuak';
$string['useradminodelete'] = 'Kudeatzaileen kontuak ezin dira ezabatu';
$string['userautherror'] = 'Autentifikazio-plugin ezezaguna';
$string['userauthunsupported'] = 'Auth plugina ez da hemen onartzen';
$string['useremailduplicate'] = 'Bikoiztutako helbidea';
$string['usernotaddederror'] = 'Erabiltzailea ez da gehitu - errorea';
$string['usernotaddedregistered'] = 'Erabiltzailea ez da gehitu - dagoeneko izena emanda dago';
$string['usernotavailable'] = 'Erabiltzaile honen xehetasunak ezin dituzu ikusi';
$string['usernotdeletedadmin'] = 'Erabiltzailea ez da ezabatu - ezin da kudeatzaileen konturik ezabatu';
$string['usernotdeletederror'] = 'Ez da erabiltzailea ezabatu - errorea.';
$string['usernotdeletedmissing'] = 'Ez da erabiltzailea ezabatu - ez da erabiltzaile-izena aurkitu.';
$string['usernotdeletedoff'] = 'Ez da erabiltzailea ezabatu - ezabatzea ez dago baimenduta';
$string['usernotincourse'] = 'Erabiltzaile hau ez dago ikastaro honetan!';
$string['usernotrenamedadmin'] = 'Ezin dira kudeatzailearen kontuak berrizendatu';
$string['usernotrenamedexists'] = 'Erabiltzailea ez da berrizendatu - erabiltzaile-izen berria indarrean dago.';
$string['usernotrenamedmissing'] = 'Erabiltzailea ez da berrizendatu - erabiltzailearen aurreko izena ez da aurkitu.';
$string['usernotrenamedoff'] = 'Erabiltzailea ez da berrizendatu - berrizendatzea ez dago baimenduta';
$string['usernotupdatedadmin'] = 'Ezin dira kudeatzailearen kontuak eguneratu';
$string['usernotupdatederror'] = 'Ez da erabiltzailea eguneratu - errorea.';
$string['usernotupdatednotexists'] = 'Ez da erabiltzailea eguneratu - ez da existitzen.';
$string['userquotalimit'] = 'Fitxategietarako gehienezko kuotara irsitsi zara.';
$string['wrongcontextid'] = 'Testuinguru ID-a ez da zuzena (ezin da aurkitu)';
$string['wrongdestpath'] = 'Bide desegokia';
$string['wrongroleid'] = 'Rolaren IDa ez da zuzena';
$string['wrongsourcebase'] = 'URL iturriaren oinarri akastuna';
$string['wrongusernamepassword'] = 'Erabiltzaile/pasahitz ezezaguna';
$string['wrongzipfilename'] = 'ZIP fitxategiaren izen desegokia';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Ezin da sortu ikastaroa - Ez duzu baimenik';
$string['xmldberror'] = 'XMLDB errorea!';
$string['youcannotdeletecategory'] = 'Ezin da \'{$a}\' kategoria ezabatu zeren edukia ezin baita ezabatu, ezta beste toki batera mugitu ere.';
