<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Контрола приступа';
$string['actionaftercorrectanswer'] = 'Акција након тачног одговора';
$string['actionaftercorrectanswer_help'] = '<p>Након тачног одговора на питање постоје 3 могућности за прелазак на наредни страницу:<p><br />

<ul>
<li>Нормалан - следи ток лекције</li>
<li>Прикажи неприказану страницу - странице се приказују насумично с тим да се свака страница приказује само једанпут</li>
<li>Прикажи неодговорену страницу - странице су приказују насумично с тим да се странице са питањем на које није одговорено понављају</li>
</ul>';
$string['actions'] = 'Акције';
$string['activitylink'] = 'Линк до следеће активности';
$string['activitylink_help'] = 'Уколико желите да на крају лекције прикажете линк ка другој активности на курсу, изаберите активност из падајуће листе.';
$string['activitylinkname'] = 'Иди на {$a}';
$string['activityoverview'] = 'Приближава се рок за завршетак лекција';
$string['addabranchtable'] = 'Додај страницу са садржајем/гранањем';
$string['addanendofbranch'] = 'Додај крај гране';
$string['addanewpage'] = 'Додај нову страницу';
$string['addaquestionpage'] = 'Додај страницу са питањем';
$string['addaquestionpagehere'] = 'Додај овде страницу са питањем';
$string['addbranchtable'] = 'Додај страницу са садржајем и гранањем';
$string['addcluster'] = 'Додај групу питања';
$string['addedabranchtable'] = 'Додата је страница са садржајем и гранањем';
$string['addedanendofbranch'] = 'Додат је крај гране';
$string['addedaquestionpage'] = 'Додата је страница са питањем';
$string['addedcluster'] = 'Додата је група питања';
$string['addedendofcluster'] = 'Додат је крај групе питања';
$string['addendofcluster'] = 'Додај крај групе питања';
$string['addpage'] = 'Додај страницу';
$string['anchortitle'] = 'Почетак главног садржаја';
$string['and'] = 'и';
$string['answer'] = 'Одговор';
$string['answeredcorrectly'] = 'је тачно одговорило';
$string['answersfornumerical'] = 'Одговори за нумеричка питања треба да буду уклопљени парови минималних и максималних вредности';
$string['arrangebuttonshorizontally'] = 'Да ли да дугмад у табели гранања буду постављена хоризонтално?';
$string['attempt'] = 'Покушај: {$a}';
$string['attempts'] = 'Покушаји';
$string['attemptsdeleted'] = 'Обрисани покушаји';
$string['attemptsremaining'] = 'Остало Вам је још {$a} покушаја';
$string['available'] = 'Датум од ког ће бити доступно:';
$string['averagescore'] = 'Просечан број бодова';
$string['averagetime'] = 'Просечно време';
$string['branch'] = 'Садржај са гранањем';
$string['branchtable'] = 'Садржај са гранањем';
$string['cancel'] = 'Одустани';
$string['cannotfindanswer'] = 'Грешка: није пронађен одговор';
$string['cannotfindattempt'] = 'Грешка: није пронађен покушај';
$string['cannotfindessay'] = 'Грешка: није пронађен есеј';
$string['cannotfindfirstgrade'] = 'Грешка: није могуће пронаћи оцене';
$string['cannotfindfirstpage'] = 'Није могуће наћи прву страну';
$string['cannotfindgrade'] = 'Није могуће наћи досје са оценама';
$string['cannotfindnewestgrade'] = 'Грешка: није могуће наћи најновију оцену';
$string['cannotfindnextpage'] = 'Резервна копија лекције: Следећа страна није пронађена!';
$string['cannotfindpagerecord'] = 'Додај крај гране: запис о страни није пронађен';
$string['cannotfindpages'] = 'Није могуће наћи странице лекције';
$string['cannotfindpagetitle'] = 'Потврда брисања: није пронађен наслов стране';
$string['cannotfindpreattempt'] = 'Запис о претходном покушају није пронађен!';
$string['cannotfindrecords'] = 'Грешка: нису пронађени слогови у табели lesson';
$string['cannotfindtimer'] = 'Грешка: није могуће пронаћи записе из табеле lesson_timer';
$string['cannotfinduser'] = 'Грешка: нису пронађени слогови у табели lesson_timer';
$string['canretake'] = '{$a} може поново да погледа лекцију';
$string['casesensitive'] = 'Користи регуларне изразе';
$string['casesensitive_help'] = 'Означите поље за потврду ако желите да користите регуларне изразе за анализу одговора';
$string['checkbranchtable'] = 'Провера странице са садржајем и гранањем';
$string['checkedthisone'] = 'је изабрало овај одговор.';
$string['checknavigation'] = 'Провери навигацију';
$string['checkquestion'] = 'Провери питање';
$string['classstats'] = 'Статистички преглед резултата свих учесника курса';
$string['clicktodownload'] = 'Кликните на следећи линк да бисте преузели датотеку.';
$string['clicktopost'] = 'Кликните овде да пошаљете своју оцену на листу најбољих резултата.';
$string['cluster'] = 'Група питања';
$string['clusterjump'] = 'Још неприказано питање из групе питања';
$string['clustertitle'] = 'Група питања';
$string['collapsed'] = 'Скупљено';
$string['comments'] = 'Ваши коментари';
$string['completed'] = 'Завршено';
$string['completederror'] = 'Завршите лекцију';
$string['completethefollowingconditions'] = 'Морате да испуните следеће услове у лекцији <b>{$a}</b> да бисте могли да наставите.';
$string['conditionsfordependency'] = 'Услови зависности';
$string['configactionaftercorrectanswer'] = 'Подразумевана акција која ће се извршити након тачног одговора';
$string['configmaxanswers'] = 'Подразумевани максималан број одговора по страни';
$string['configmaxhighscores'] = 'Број приказаних најбољих резултата';
$string['configmediaclose'] = 'Прикажи дугме за затварање на искачућем прозору који садржи линк ка мултимедијалној датотеци';
$string['configmediaheight'] = 'Одређује висину искачућег прозора који приказује линк ка мултимедијалној датотеци';
$string['configmediawidth'] = 'Одређује ширину искачућег прозора који приказује линк ка мултимедијалној датотеци';
$string['configslideshowbgcolor'] = 'Боја позадине за слајд-шоу уколико је омогућен';
$string['configslideshowheight'] = 'Одређује висину за слајд-шоу уколико је омогућен';
$string['configslideshowwidth'] = 'Одређује ширину за слајд-шоу уколико је омогућен';
$string['confirmdelete'] = 'Обриши страницу';
$string['confirmdeletionofthispage'] = 'Потврди брисање ове странице';
$string['congratulations'] = 'Честитамо - стигли сте до краја лекције';
$string['continue'] = 'Настави';
$string['continuetoanswer'] = 'Наставите да бисте променили одговоре.';
$string['continuetonextpage'] = 'Идите на следећу страницу';
$string['correctanswerjump'] = 'Тачан одговор води до';
$string['correctanswerscore'] = 'Број бодова који се добија за тачан одговор';
$string['correctresponse'] = 'Повратне информације за тачан одговор';
$string['createaquestionpage'] = 'Креирај страницу са питањем';
$string['credit'] = 'Бодови';
$string['customscoring'] = 'Прилагођено бодовање';
$string['customscoring_help'] = 'Ако је ова опција омогућена. онда се сваком одговору може доделити нумеричка вредност (позитивна или негативна)';
$string['deadline'] = 'Крајњи рок';
$string['defaultessayresponse'] = 'Предавач ће оценити ваш есеј.';
$string['deleteallattempts'] = 'Обриши све покушаје проласка кроз лекцију';
$string['deletedefaults'] = 'Обрисано {$a} x подразумевано за лекцију';
$string['deletedpage'] = 'Страница је обрисана';
$string['deleting'] = 'Брисање';
$string['deletingpage'] = 'Брисање странице: {$a}';
$string['dependencyon'] = 'Зависно од';
$string['dependencyon_help'] = 'Ово подешавање допушта да приступ овој лекцији зависи од резултата полазника у другој лекцији истог курса. Може се користити било која комбинација следећих услова: утрошеног времена (време које је полазник потрошио да би урадио лекцију), завршености (да ли је полазник завршио наведену лекцију) и добијене оцене (да ли је полазник добио оцену већу од наведене).';
$string['description'] = 'Опис';
$string['detailedstats'] = 'Детаљна статистика';
$string['didnotanswerquestion'] = 'Нисте одговорили на ово питање.';
$string['didnotreceivecredit'] = 'Нисте добили бодове';
$string['displaydefaultfeedback'] = 'Користи подразумеване повратне информације';
$string['displaydefaultfeedback_help'] = 'Ако је ова опција омогућена, онда ће, у ситуацији када за неко питање не постоји повратна информација, бити приказана подразумевана повратна информација: "Тачан одговор" односно "Погрешан одговор"';
$string['displayhighscores'] = 'Приказ најбољих резултата';
$string['displayinleftmenu'] = 'Приказ у менију са леве стране?';
$string['displayleftif'] = 'Минимална оцена за приказ менија';
$string['displayleftif_help'] = 'Ово подешавање одређује да ли полазник мора да добије одређену оцену како би видео мени са леве стране. Ово подешавање тера полазника да прође кроз целу лекцију приликом првог покушаја. Тек након што полазник добије потребну оцену може да користи мени са леве стране за преглед лекције.';
$string['displayleftmenu'] = 'Приказ менија са леве стране';
$string['displayleftmenu_help'] = 'Ако је ова опција омогућена, биће приказан списак страница лекције.';
$string['displayofgrade'] = 'Приказ оцена (само за полазнике)';
$string['displayreview'] = 'Обезбедите могућност за поновни покушај';
$string['displayreview_help'] = 'Ако је ова опција омогућена, у ситуацији када полазник погрешно одговори на питање, биће му понуђено да покуша поново да одговори (без могућности да добије поен) или да настави са лекцијом.';
$string['displayscorewithessays'] = '<p>Освојили сте {$a->score} од максималних {$a->tempmaxgrade} бодова за питања која се аутоматски оцењују.</p>
<p>Ваш {$a->essayquestions} одговор на питања  у форми есеја биће ускоро прегледан и оцењен, а оцена ће касније бити додата<br />у ваш финални резултат.</p>
<p>Ваша тренутна оцена без есеја је {$a->score} од {$a->grade}</p>';
$string['displayscorewithoutessays'] = 'Ваш резултат је {$a->score} (од могућих {$a->grade}).';
$string['edit'] = 'Уреди';
$string['editingquestionpage'] = 'Уређивање {$a} странице питања';
$string['editlessonsettings'] = 'Уреди подешавања лекције';
$string['editpage'] = 'Уреди садржај странице';
$string['editpagecontent'] = 'Уреди садржај странице';
$string['email'] = 'Е-пошта';
$string['emailallgradedessays'] = 'Пошаљи СВЕ оцењене есеје';
$string['emailgradedessays'] = 'Пошаљи оцењене есеје е-поштом';
$string['emailsuccess'] = 'Е-пошта је успешно послата';
$string['emptypassword'] = 'Поље за лозинку не може бити празно';
$string['endofbranch'] = 'Крај гране';
$string['endofcluster'] = 'Крај групе питања';
$string['endofclustertitle'] = 'Крај групе питања';
$string['endoflesson'] = 'Крај лекције';
$string['enteredthis'] = 'је одабрало/унело овај одговор';
$string['entername'] = 'Унесите надимак који ће бити приказан на листи најбољих резултата';
$string['enterpassword'] = 'Молимо унесите лозинку:';
$string['eolstudentoutoftime'] = 'Упозорење! Истекло вам је време за ову лекцију. Ваш последњи одговор можда није урачунат ако је дат након што је време истекло.';
$string['eolstudentoutoftimenoanswers'] = 'Нисте одговорили ни на једно питање. Ваша оцена за ову лекцију је 0.';
$string['essay'] = 'Есеј';
$string['essayemailmessage'] = '<p>Есеј:<blockquote>{$a->question}</blockquote></p><p>Ваш одговор:<blockquote><em>{$a->response}</em></blockquote></p><p>Коментар предавача ({$a->teacher}\'s):<blockquote><em>{$a->comment}</em></blockquote></p><p>Добили сте оцену {$a->earned} од максимално {$a->outof} за  овај есеј.</p><p>Ваша оцена за ову лекцију је промењена на {$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p>Есеј:<blockquote>{$a->question}</blockquote></p><p>Ваш одговор:<blockquote><em>{$a->response}</em></blockquote></p><p>Коментрар оцењивача:<blockquote><em>{$a->comment}</em></blockquote></p><p>Добили сте {$a->earned} од максималних {$a->outof} за овај есеј.</p><p>Ваша оцена за ову лекцију је промењена на {$a->newgrade}&#37;.</p>';
$string['essayemailsubject'] = 'Ваша оцена за питање {$a}';
$string['essays'] = 'Есеји';
$string['essayscore'] = 'Резултат есеја';
$string['fileformat'] = 'Формат датотеке';
$string['finish'] = 'Заврши';
$string['firstanswershould'] = 'Први одговор би требало до води на страницу "Тачно"';
$string['firstwrong'] = 'Нажалост, не можете да освојите овај бод, зато што је Ваш одговор нетачан. Желите ли да покушате поново како бисте учили (али без могућности да освојите неке бодове)';
$string['flowcontrol'] = 'Контрола тока лекције';
$string['full'] = 'Проширено';
$string['general'] = 'Општа подешавања';
$string['gotoendoflesson'] = 'Иди на крај лекције';
$string['grade'] = 'Оцена';
$string['gradebetterthan'] = 'Оцена виша од (%)';
$string['gradebetterthanerror'] = 'Освојите оцену већу од {$a} процената';
$string['gradeessay'] = 'Оцени одговоре на есејски тип питања({$a->notgradedcount} још није оцењено, а {$a->notsentcount} није послато)';
$string['gradeis'] = 'Оцена је {$a}';
$string['gradeoptions'] = 'Опције за оцењивање';
$string['handlingofretakes'] = 'Третман поновних покушаја';
$string['handlingofretakes_help'] = 'Ако су поновни покушаји дозвољени, ово подешавање одређује да ли је оцена за лекцију једнака просечној оцени свих покушаја или највећој оцени.';
$string['havenotgradedyet'] = 'Још није оцењено.';
$string['here'] = 'овде';
$string['highscore'] = 'Најбољи резултат';
$string['highscores'] = 'Листа најбољих резултата';
$string['hightime'] = 'Најбоље време';
$string['importcount'] = 'Увози се {$a} питања';
$string['importquestions'] = 'Увоз питања';
$string['importquestions_help'] = 'Ово својство омогућава да питања у различитим форматима, буду увезена путем текстуалне датотеке.';
$string['insertedpage'] = 'Страница је уметнута';
$string['invalidfile'] = 'Неисправна датотека';
$string['invalidid'] = 'Није прослеђен ID модула или лекције';
$string['invalidlessonid'] = 'ID лекције није био тачан';
$string['invalidpageid'] = 'Неисправан ID странице';
$string['jump'] = 'Прелаз';
$string['jumps'] = 'Прелази';
$string['jumps_help'] = 'Сваки одговор (за страницу са питањем) или опис (за страницу са садржајем) има одговарајући прелаз. Прелаз може бити релативан, као на пример "текућа страница" или "следећа страница", или апсолутан тј. прелаз на било коју страницу у лекцији.';
$string['jumpsto'] = 'Прелази на <em>{$a}</em>';
$string['leftduringtimed'] = 'Напустили сте лекцију која је временски ограничена.<br />Притисните тастер за наставак да бисте погледали лекцију од почетка.';
$string['leftduringtimednoretake'] = 'Напустили сте лекцију која је временски ограничена и није Вам <br /> дозвољено да наставите или почнете лекцију из почетка.';
$string['leftduringtimedsession'] = 'Изашли сте током лекције која има временско ограничење.';
$string['lesson:addinstance'] = 'Додај нову лекцију';
$string['lessonattempted'] = 'Лекцији је приступано';
$string['lessonclosed'] = 'Ова лекција је затворена дана {$a}.';
$string['lessoncloses'] = 'Лекција се затвара';
$string['lessoncloseson'] = 'Време затварања лекције: {$a}';
$string['lesson:edit'] = 'Уреди лекцију';
$string['lessonformating'] = 'Форматирање лекције';
$string['lesson:manage'] = 'Управљај лекцијом';
$string['lessonmenu'] = 'Мени лекције';
$string['lessonnotready'] = 'Ова лекција још није спремна за коришћење. Молимо контактирајте свог {$a}.';
$string['lessonnotready2'] = 'Ова лекција још није спремна за коришћење';
$string['lessonopen'] = 'Ова лекција ће бити доступна од {$a}.';
$string['lessonopens'] = 'Лекција се отвара';
$string['lessonpagelinkingbroken'] = 'Није пронађена прва страница. Мора да је дошло до прекида линкова између страница лекције. Молимо контактирајте администратора.';
$string['lessonstats'] = 'Статистика лекције';
$string['linkedmedia'] = 'Повезани медији';
$string['loginfail'] = 'Погрешна пријава, молимо покушајте поново...';
$string['lowscore'] = 'Наслабији резултат';
$string['lowtime'] = 'Најслабије време';
$string['manualgrading'] = 'Оцени есеје';
$string['matchesanswer'] = 'Поклапа се са одговором';
$string['matching'] = 'Упаривање';
$string['matchingpair'] = 'Упаривање пара {$a}';
$string['maxgrade'] = 'Максимална оцена';
$string['maxgrade_help'] = 'Ово подешавање одређује највећу оцену за лекцију. Уколико је вредност подешена на 0 лекција се неће појавити на страници са оценама.';
$string['maxhighscores'] = 'Број најбољих резултата који треба приказати';
$string['maximumnumberofanswersbranches'] = 'Максималан број одговора';
$string['maximumnumberofanswersbranches_help'] = 'Ова вредност одређује максимални број одговора који се могу користити у лекцији. Ако се користе само ТАЧНО/НЕТАЧНО питања тада је разумно поставити ову вредност на 2. Подешавање се може променити било када, пошто утиче само на начин приказа података наставнику, не и на саме податке.';
$string['maximumnumberofattempts'] = 'Максималан број покушаја';
$string['maximumnumberofattempts_help'] = 'Ово подешавање одређује максималан број дозвољених покушаја за свако питање. Уколико се нетачни одговори понављају, када се достигне максималан број покушаја биће приказана следећа страница лекције.';
$string['maximumnumberofattemptsreached'] = 'Достигнут је максималан број покушаја - прелази се на следећу страницу';
$string['maxtime'] = 'Временско ограничење (у минутима)';
$string['maxtimewarning'] = 'Имате још {$a} минут(а) да завршите лекцију.';
$string['mediaclose'] = 'Приказ дугмета за затварање';
$string['mediafile'] = 'Искачући прозор за приказ датотеке';
$string['mediafile_help'] = 'Да бисте на почетку лекције укључили искачући прозор одаберите одговарајућу датотеку за приказ. Свака страница лекције ће садржати линк за поновно отварање искачућег прозора, уколико је то потребно.';
$string['mediafilepopup'] = 'Кликните овде за приказ';
$string['mediaheight'] = 'Висина искачућег прозора:';
$string['mediawidth'] = 'Ширина искачућег прозора:';
$string['messageprovider:graded_essay'] = 'Обавештење о оцењеном есеју';
$string['minimumnumberofquestions'] = 'Минималан број питања';
$string['minimumnumberofquestions_help'] = 'Ова подешавање одређује најмањи број питања који ће се користити за израчунавање оцене за активност. Уколико лекција садржи једну или више страница садржаја (табеле гранања) минималну вредност би требало поставити на 0.

Уколико поставите вредност на, рецимо, 20 на уводној страници лекције ће се појавити следећи текст: "У овој лекцији се очекује да одговорите на најмање 20 питања. Уколико желите можете одговорити и на више. Међутим, уколико одговорите на мање од 20 питања, Ваша оцена ће се рачунати као да сте одговорили на свих 20 питања."';
$string['missingname'] = 'Молимо унесите надимак';
$string['modattempts'] = 'Дозволите полазницима преглед';
$string['modattempts_help'] = 'Ако је ова опција омогућена, полезници ће моћи поново да погледају лекцију од почетка.';
$string['modattemptsnoteacher'] = 'Полазнички преглед функционише само за полазнике.';
$string['modulename'] = 'Лекција';
$string['modulename_help'] = 'Модул \'Лекција\' омогућава предавачу да  презентује садржај и/или практичне активности на интересантан и флексибилан начин. Предавач може да користи лекцију како би креирао линеарни низ страница са садржајем или инструкције које нуде различите путање или опције за корисника. У оба случај предавачи могу да повећају ангажман полазника и да обезбедe разумевање градива, тако што ће на крају странице додати различите типове питања, укључујући вишеструки избор, спаривање, кратак одговор и др. Зависно од изабраног одговора, као и од тога како је предавач организовао лекцију, полазници могу да напредују на следећу страницу, буду враћени на претходну или преусмерени на неку другу страницу лекције.

Лекције могу да се оцењују, а оцене уписују у књигу оцена.

Лекција може да се користи:

* за самостално учење нових садржаја
* за сценарија или симулације/вежбе доношење одлука
* за исправку наученог градива, са различитим сетовима питања у зависности од одговора датих на почетна питања';
$string['modulenameplural'] = 'Лекције';
$string['move'] = 'Премести страницу';
$string['movedpage'] = 'Страница је премештена';
$string['movepagehere'] = 'Овде премести страницу';
$string['moving'] = 'Премештање странице: {$a}';
$string['multianswer'] = 'Вишеструки одговор';
$string['multianswer_help'] = 'Означите уколико постоји више тачних одговора.';
$string['multichoice'] = 'Вишеструки избор';
$string['multipleanswer'] = 'Вишеструки одговор';
$string['nameapproved'] = 'Назив је одобрен';
$string['namereject'] = 'Нажалост, Ваше име је одбијено.<br />Молимо покушајте са другим именом.';
$string['new'] = 'ново';
$string['nextpage'] = 'Следећа страница';
$string['noanswer'] = 'На једно или више питања није дат одговор. Молимо вратите се назад и дајте свој одговор.';
$string['noattemptrecordsfound'] = 'Нема забележених покушаја: није дата ниједна оцена';
$string['nobranchtablefound'] = 'Није пронађена ниједна страница садржаја (табела гранања)';
$string['nocommentyet'] = 'Још нема коментара.';
$string['nocoursemods'] = 'Није пронађена ниједна активност';
$string['nocredit'] = 'Без бодова';
$string['nodeadline'] = 'Без рока';
$string['noessayquestionsfound'] = 'У овој лекцији нису пронађена питања која захтевају одговор у форми есеја.';
$string['nohighscores'] = 'Нема најбољих резултата';
$string['nolessonattempts'] = 'Нико још није покушао да прође кроз ову лекцију.';
$string['nooneansweredcorrectly'] = 'Нико није тачно одговорио.';
$string['nooneansweredthisquestion'] = 'Нико није одговорио на ово питање.';
$string['noonecheckedthis'] = 'Нико није изабрао овај одговор.';
$string['nooneenteredthis'] = 'Нико није ово покушао.';
$string['noonehasanswered'] = 'Нико још није одговорио на есејско питање.';
$string['noretake'] = 'Није Вам дозвољено да поново покушате ову лекцију.';
$string['normal'] = 'Нормално - пратите путању лекције';
$string['notcompleted'] = 'Није завршено';
$string['notdefined'] = 'Није дефинисано';
$string['nothighscore'] = 'Ваш резултат није међу првих {$a} на листи најбољих резултата.';
$string['notitle'] = 'Нема наслова';
$string['numberofcorrectanswers'] = 'Број тачних одговора: {$a}';
$string['numberofcorrectmatches'] = 'Број тачних подударања: {$a}';
$string['numberofpagestoshow'] = 'Број страница које треба приказати';
$string['numberofpagestoshow_help'] = '<p>Овај параметар се користи само у типу лекција са Флеш Картицама. Подразумевана вредност је нула, што значи да су све странице/картице приказане у лекцији. Постављање овог параметра на не-нула вредност приказује тај број страница. Након што је досегнут тај број страница/картица, долази се до завршетка лекције и полазнику се приказује његова оцена.</p>

<p>Уколико се овај параметар подеси на број већи од броја страница у лекцији онда се крај лекције достиже када се све странице прикажу.</p>';
$string['numberofpagesviewed'] = 'Број прегледаних страница: {$a}';
$string['numberofpagesviewednotice'] = 'Број питања на које је дат одговор: {$a->nquestions}; (Требало би их бити бар: {$a->minquestions})';
$string['numerical'] = 'Бројчани';
$string['ongoing'] = 'Приказ тренутног резултата';
$string['ongoingcustom'] = 'До сада сте освојили {$a->score} од максимално {$a->currenthigh} бодова.';
$string['ongoing_help'] = 'Ако је ова опција омогућена, на свакој страница ће бити приказан тренутни број бодова од укупног броја које је полазник до тада могао да постигне.';
$string['ongoingnormal'] = 'Тачно сте одговорили на {$a->correct} од {$a->viewed} питања која сте видели.';
$string['onpostperpage'] = 'Само једна порука по оцени';
$string['options'] = 'Опције';
$string['or'] = 'ИЛИ';
$string['ordered'] = 'Поређано';
$string['other'] = 'Остало';
$string['outof'] = 'Од {$a}';
$string['overview'] = 'Преглед';
$string['overview_help'] = 'Лекција се састоји од одређеног броја страница и, опционо, страница са садржајем (табелом гранања). Страница садржи  произвољну количину текста и одговарајућих илустрација, и обично се завршава питањем. Уз сваки одговор на питање везан је тзв. прелаз. Прелази могу бити релативни, као на пример “текућа страница” или “следећа страница”, или апсолутни када се тачно наводи нека од страница унутар лекцији. Страница са садржајем (табела гранања) је страница која садржи низ линкова ка другим страницама лекције, као на пример "Табела садржаја".';
$string['page'] = 'Страница: {$a}';
$string['pagecontents'] = 'Садржај странице';
$string['page-mod-lesson-edit'] = 'Страница за уређивање лекције';
$string['page-mod-lesson-view'] = 'Прикажи или прегледај страницу лекције';
$string['page-mod-lesson-x'] = 'Било која страница лекције';
$string['pages'] = 'Странице';
$string['pagetitle'] = 'Наслов странице';
$string['password'] = 'Лозинка';
$string['passwordprotectedlesson'] = '{$a} је лекција заштићена лозинком.';
$string['pleasecheckoneanswer'] = 'Изаберите један одговор';
$string['pleasecheckoneormoreanswers'] = 'Изаберите један или више одговора';
$string['pleaseenteryouranswerinthebox'] = 'Унесите свој одговор у поље за унос';
$string['pleasematchtheabovepairs'] = 'Спојите парове';
$string['pluginadministration'] = 'Администрација лекције';
$string['pluginname'] = 'Лекција';
$string['pointsearned'] = 'Освојени бодови';
$string['postprocesserror'] = 'Дошло је до грешке током постпроцесирања!';
$string['postsuccess'] = 'Успешно послато';
$string['practice'] = 'Лекција за вежбање';
$string['practice_help'] = 'Лекција за вежбу се не приказује у дневнику оцена.';
$string['preprocesserror'] = 'Дошло је до грешке током претпроцесирања!';
$string['prerequisitelesson'] = 'Лекција предуслов';
$string['preview'] = 'Преглед';
$string['previewlesson'] = 'Преглед {$a}';
$string['previouspage'] = 'Претходна страница';
$string['processerror'] = 'Дошло је до грешке током процесирања!';
$string['progressbar'] = 'Трака напредовања кроз лекцију';
$string['progressbar_help'] = 'Ако је ова опција омогућена, на дну странице биће приказана трака која приказује приближан проценат завршености лекције (напредовање полазника кроз лекцију).';
$string['progressbarteacherwarning'] = 'Трака напредовања кроз лекцију се не приказује за {$a}';
$string['progressbarteacherwarning2'] = 'Нећете видети траку напредовања зато што можете да уређујете ову лекцију';
$string['progresscompleted'] = 'Завршили сте {$a}% лекције';
$string['qtype'] = 'Врста странице';
$string['question'] = 'Питање';
$string['questionoption'] = 'Питање';
$string['questiontype'] = 'Врста питања';
$string['randombranch'] = 'Насумично одабрана страна са садржајем и гранањем';
$string['randompageinbranch'] = 'Насумично одабрано питање унутар странице садржаја (гране)';
$string['rank'] = 'Ранг';
$string['rawgrade'] = 'Необрађена оцена';
$string['receivedcredit'] = 'Добијени бодови';
$string['redisplaypage'] = 'Освежавање приказа странице';
$string['report'] = 'Извештај';
$string['reports'] = 'Извештаји';
$string['response'] = 'Повратне информације';
$string['retakesallowed'] = 'Поновни преглед лекције је дозвољен';
$string['retakesallowed_help'] = 'Ако је ова опција омогућена, полазник може више пута да погледа лекцију.';
$string['returnto'] = 'Врати се на {$a}';
$string['returntocourse'] = 'Врати се на курс';
$string['review'] = 'Преглед';
$string['reviewlesson'] = 'Преглед лекције';
$string['reviewquestionback'] = 'Да, волео/ла бих да поново покушам';
$string['reviewquestioncontinue'] = 'Не, желим да пређем на следеће питање';
$string['sanitycheckfailed'] = 'Провера није успела. Покушај је избрисан.';
$string['savechanges'] = 'Сачувај промене';
$string['savechangesandeol'] = 'Сачувај све промене и иди на крај лекције.';
$string['savepage'] = 'Сачувај страницу';
$string['score'] = 'Резултат';
$string['score_help'] = 'Резултат се користи само када је прилагођено бодовање омогућено. Сваком одговору затим може бити дата нумеричка вредност (позитивна или негативна).';
$string['scores'] = 'Резултати';
$string['secondpluswrong'] = 'Није баш. Да ли желите да покушате поново?';
$string['selectaqtype'] = 'Одаберите тип питања';
$string['shortanswer'] = 'Кратак одговор';
$string['showanunansweredpage'] = 'Прикажи страницу са неодговореним питањем';
$string['showanunseenpage'] = 'Прикажи непрегледану страницу';
$string['singleanswer'] = 'Један одговор';
$string['skip'] = 'Прескочи навигацију';
$string['slideshow'] = 'Приказ слајд по слајд';
$string['slideshowbgcolor'] = 'Позадинска боја при приказу слајдова';
$string['slideshowheight'] = 'Висина дела за приказ слајдова';
$string['slideshow_help'] = 'Уколико је подешавање омогућено, лекција се приказује слајд по слајд, са фиксном ширином и висином.';
$string['slideshowwidth'] = 'Ширина дела за приказ слајдова';
$string['startlesson'] = 'Почните лекцију';
$string['studentattemptlesson'] = '{$a->attempt} покушај корисника {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} Име';
$string['studentoneminwarning'] = 'Упозорење: имате мање од једног минута да завршите лекцију.';
$string['studentresponse'] = 'Одговор полазника {$a}';
$string['submit'] = 'Пошаљи';
$string['submitname'] = 'Пошаљи име';
$string['teacherjumpwarning'] = 'У овој лекцији се користе {$a->cluster} или {$a->unseen} прелаз између страница. Прелаз "Следећа страница" ће се користити уместо њих током овог приказа. За тестирање ових прелаза пријавите се на систем у улози полазника.';
$string['teacherongoingwarning'] = 'Тренутни резултат током прегледа лекције се приказује само полазницима. Пријавите се на систем у улози полазника да бисте тестирали ову могућност.';
$string['teachertimerwarning'] = 'Мерач времена могу да виде само полазници. Како бисте тестирали мерач времена пријавите се на систем у улози полазника.';
$string['thatsthecorrectanswer'] = 'Тачан одговор';
$string['thatsthewronganswer'] = 'Погрешан одговор';
$string['thefollowingpagesjumptothispage'] = 'Следеће странице воде до ове странице';
$string['thispage'] = 'Ова страница';
$string['timeisup'] = 'Vreme je isteklo';
$string['timeremaining'] = 'Преостало време';
$string['timespenterror'] = 'Проведите бар {$a} минута прегледајући садржај лекције';
$string['timespentminutes'] = 'Потрошено време (у минутима)';
$string['timetaken'] = 'Потрошено време';
$string['topscorestitle'] = '{$a} најбољих резултата';
$string['truefalse'] = 'Тачно/нетачно';
$string['unabledtosavefile'] = 'Није могуће сачувати датотеку коју сте послали.';
$string['unknownqtypesnotimported'] = 'Број питања, са неподржаним типом питања, која нису увезена: {$a}';
$string['unseenpageinbranch'] = 'Још неприказано питање унутар стране са садржајем и гранањем';
$string['unsupportedqtype'] = 'Тип питања који није подржан {$a}!';
$string['updatedpage'] = 'Страница је ажурирана';
$string['updatefailed'] = 'Ажурирање није успело';
$string['usemaximum'] = 'Користи максималну вредност';
$string['usemean'] = 'Користи просечну вредност';
$string['usepassword'] = 'Лекција заштићена лозинком';
$string['usepassword_help'] = 'Уколико је укључено, за приступ лекцији неопходна је лозинка.';
$string['viewgrades'] = 'Приказ оцена';
$string['viewhighscores'] = 'Приказ листе најбољих резултата';
$string['viewreports'] = 'Приказ {$a->attempts} комплетних покушаја полазника {$a->student}';
$string['viewreports2'] = 'Погледај {$a} завршених покушаја';
$string['welldone'] = 'Браво!';
$string['whatdofirst'] = 'Шта желите прво да урадите?';
$string['wronganswerjump'] = 'Страница која ће се приказати након погрешног одговора';
$string['wronganswerscore'] = 'Број бодова који носи погрешан одговор';
$string['wrongresponse'] = 'Повратне информације за погрешан одговор';
$string['xattempts'] = '{$a} покушај(а)';
$string['youhaveseen'] = 'Већ сте видели више од једне странице ове лекције.<br /> Желите ли почети од последње странице коју сте видели?';
$string['youmadehighscore'] = 'Доспели сте на листу {$a} најбољих резултата.';
$string['youranswer'] = 'Ваш одговор';
$string['yourcurrentgradeis'] = 'Ваша тренутна оцена је {$a}';
$string['yourcurrentgradeisoutof'] = 'Ваша тренутна оцена је {$a->grade} од могућих {$a->total}';
$string['youshouldview'] = 'Требало би да одговорите на барем: {$a}';
