<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Специфицирани администраторски директоријум је нетачан';
$string['admindirname'] = 'Администраторски директоријум';
$string['admindirsetting'] = 'Врло мали број веб сервера користи /admin као специјални URL за приступ разним подешавањима (контролни панел и сл.). Нажалост, то доводи до конфликта са стандардном локацијом за администраторске странице у Moodleu. Овај проблем можете решити тако што ћете променити име администраторског директоријума у вашој инсталацији, и овде уписати то ново име. На пример: <br /> <br /><b>moodleadmin</b><br /> <br />
Ово подешавање ће преправити администраторске линкове у Moodle систему.';
$string['admindirsettinghead'] = 'Подешавање администраторског директоријума';
$string['admindirsettingsub'] = 'Врло мали број веб сервера користи /admin као специјални URL за приступ разним подешавањима (контролни панел и сл.). Нажалост, то доводи до конфликта са стандардном локацијом за администраторске странице у Moodleu. Овај проблем можете решити тако што ћете променити име администраторског директоријума у вашој инсталацији, и овде уписати то ново име. На пример: <br /> <br /><b>moodleadmin</b><br /> <br />
Ово подешавање ће преправити администраторске линкове у Moodle систему.';
$string['availablelangs'] = 'Доступни језички пакети';
$string['caution'] = 'Опрез';
$string['chooselanguage'] = 'Изабери језик';
$string['chooselanguagehead'] = 'Изаберите језик';
$string['chooselanguagesub'] = 'Молимо изаберите језик који ће се користити током инсталације. Овај језик ће, такође, бити коришћен на нивоу сајта као подразумевани, мада то накнадно може бити промењено.';
$string['cliadminpassword'] = 'Нова лозинка за администратора';
$string['cliadminusername'] = 'Корисничко име администратора';
$string['clialreadyconfigured'] = 'Датотека config.php већ постоји. Молимо, употребите команду admin/cli/install_database.php ако желите да инсталирате Moodle на овај сајт.';
$string['clialreadyinstalled'] = 'Датотека config.php већ постоји. Моликмо употребите admin/cli/upgrade.php ако желите да надоградите свај сајт.';
$string['cliinstallfinished'] = 'Инсталација је успешно завршена';
$string['cliinstallheader'] = 'Moodle {$a} програм за инсталацију из командне линије';
$string['climustagreelicense'] = 'У неинтерактивном моду морате прихватити лиценцу наводећи опцију --agree-license';
$string['clitablesexist'] = 'База подтака већ постоји. Није могуће наставити инсталацију из командне линије.';
$string['compatibilitysettings'] = 'Провера Ваших PHP подешавања...';
$string['compatibilitysettingshead'] = 'Провера Ваших PHP подешавања...';
$string['compatibilitysettingssub'] = 'Ваш сервер би требао проћи све ове тестове да би Moodle на њему успешно функционисао';
$string['configfilenotwritten'] = 'Инсталациони скрипт није био у могућности да аутоматски креира датотеку config.php која би садржавала Ваша одабрана подешавања, веројатно због тога што нема права на писање (мењање садржаја) у Вашем Moodle директоријуму. Ако то желите, можете ручно копирати код у датотеку config.php у основном директоријуму Ваше Moodle инсталације.';
$string['configfilewritten'] = 'config.php је успешно креиран';
$string['configurationcomplete'] = 'Конфигурација је завршена';
$string['configurationcompletehead'] = 'Конфигурација је завршена';
$string['configurationcompletesub'] = 'Moodle је покушао да сачува Вашу конфигурацију у датотеци смештеној у коренском директоријуму Moodle инсталације.';
$string['database'] = 'База података';
$string['databasehead'] = 'Подешавања базе података';
$string['databasehost'] = 'Сервер базе података';
$string['databasename'] = 'Име базе података';
$string['databasepass'] = 'Лозинка за приступ бази података';
$string['databaseport'] = 'Пребацивање базе';
$string['databasesocket'] = 'Unix сокет';
$string['databasetypehead'] = 'Изаберите драјвер базе података';
$string['databasetypesub'] = 'Moodle подржава неколико типова база података. Уколико не знате који тип да користите контактирајте администратора сервера.';
$string['databaseuser'] = 'Корисничко име за приступ бази података';
$string['dataroot'] = 'Директоријум података';
$string['datarooterror'] = '\'Директоријум података\' који сте навели не може бити пронађен или креиран. Унесите тачну путању или креирајте тај директоријум ручно.';
$string['datarootpermission'] = 'Овлашћења над директоријумом података';
$string['datarootpublicerror'] = '\'Директоријума података\' који сте подесили је директно доступан преко веба, морате користити други директоријум.';
$string['dbconnectionerror'] = 'Немогуће је успоставити везу са базом података коју сте навели. Молимо проверите подешавања базе података.';
$string['dbcreationerror'] = 'Грешка при креирању базе података. Није било могуће креирати базу наведеног имена уз задата подешавања';
$string['dbhost'] = 'Сервер';
$string['dbpass'] = 'Лозинка';
$string['dbport'] = 'Порт';
$string['dbprefix'] = 'Префикс табеле';
$string['dbtype'] = 'Тип';
$string['directorysettings'] = '<p>Молимо потврдите локације ове Moodle инсталације</p>

<p><b>Веб адреса:</b>
Наведите пуну веб адресу путем које ће се приступати Moodleu.
Ако се вашем веб сајту може приступити преко више URL адреса, изаберите ону коју ће ваши полазници највероватније користити. Немојте у адреси наводити крајњу косу црту.</p>

<p><b>Moodle директоријум:</b>
Наведите пуну путању до ове инсталације.
Водите рачуна о великим и малим словима.</p>

<p><b>Директоријум података:</b>
Морате одредити место на ком ће Moodle моћи да сачува постављене датотеке. Корисник веб сервера (обично \'nobody\' или \'apache\') треба да има могућност да чита податке из тог директоријума, као и да УПИСУЈЕ податке у њега, али директоријум података не сме бити доступан директно преко веба. Програм за инсталацију ће покушати да креира овај директоријум уколико он не постоји.</p>';
$string['directorysettingshead'] = 'Молимо потврдите локације ове Moodle инсталације';
$string['directorysettingssub'] = '<b>Веб адреса:</b>
Наведите пуну веб адресу путем које ће се приступати Moodleu.
Ако се вашем веб сајту може приступити преко више URL адреса, изаберите ону коју ће ваши полазници највероватније користити. Немојте у адреси наводити крајњу косу црту.
<br />
<br />
<b>Moodle директоријум:</b>
Наведите пуну путању до ове инсталације.
Водите рачуна о великим и малим словима.
<br />
<br />
<b>Директоријум података:</b>
Морате одредити место на ком ће Moodle моћи да сачува постављене датотеке. Корисник веб сервера (обично \'nobody\' или \'apache\') треба да има могућност да чита податке из тог директоријума, као и да УПИСУЈЕ податке у њега, али директоријум података не сме бити доступан директно преко веба. Програм за инсталацију ће покушати да креира овај директоријум уколико он не постоји.';
$string['dirroot'] = 'Moodle директоријум';
$string['dirrooterror'] = 'Изгледа да је подешавање \'Moodle директоријума погрешно - на наведеној адреси није могуће пронаћи Moodle инсталацију. Доња вредност је ресетована.';
$string['download'] = 'Преузети';
$string['downloadlanguagebutton'] = 'Преузми "{$a}" језички пакет';
$string['downloadlanguagehead'] = 'Преузми језички пакет';
$string['downloadlanguagenotneeded'] = 'Можете наставити процес инсталације коришћењем подразумеваног језичког пакета, "{$a}".';
$string['downloadlanguagesub'] = 'Сада имате могућност преузимања жељеног језичког пакета и наставка инсталационог процеса на том језику.<br /><br />Ако нисте у могућности да преузмете језички пакет, инсталациони процес ће се наставити на енглеском језику. (Када се инсталација заврши, имаћете могућност да преузмете и инсталирате додатне језичке пакете.)';
$string['doyouagree'] = 'Да ли се слажете? (да/не)';
$string['environmenthead'] = 'Проверавање Вашег окружења...';
$string['environmentsub'] = 'Проверава се да ли разне компоненте Вашег система задовољавају системске захтеве';
$string['environmentsub2'] = 'Свако издање Moodlea има минимум захтева по питању одговарајуће PHP верзије и неколико обавезних PHP екстензија.
Комплетна провера окружења се врши пре сваке инсталације и надоградње постојеће верзије. Уколико не знате како да инсталирате нову верзију или омогућите PHP екстензије контактирајте свог администратора сервера.';
$string['errorsinenvironment'] = 'Провера окружења није прошла!';
$string['fail'] = 'Није прошло';
$string['fileuploads'] = 'Постављање датотека';
$string['fileuploadserror'] = 'Ова опција би требала бити укључена';
$string['fileuploadshelp'] = '<p>Изгледа да је постављање датотека на вашем серверу онемогућено.</p>

<p>Moodle још увек може бити инсталиран, али без ове могућности, нећете моћи да поставите датотеке курса или нове слике за корисничке профиле.</p>

<p>Да бисте омогућили постављање датотека ви, или ваш систем администратор, ћете морати да уредите датотеку php.ini на свом систему и да промените подешавање за <b>file_uploads</b> на \'1\'.</p>';
$string['inputdatadirectory'] = 'Директоријум податка:';
$string['inputwebadress'] = 'Веб адреса :';
$string['inputwebdirectory'] = 'Moodle директоријум:';
$string['installation'] = 'Инсталација';
$string['langdownloaderror'] = 'Нажалост, језик "{$a}" се не може преузети. Процес инсталације биће настављен на енглеском језику.';
$string['langdownloadok'] = 'Језик "{$a}" је успешно инсталиран. Инсталациони процес ће бити настављен на овом језику.';
$string['magicquotesruntime'] = 'Magic Quotes време извршавања';
$string['magicquotesruntimeerror'] = 'Ова опција би требала бити искључена';
$string['magicquotesruntimehelp'] = '<p>Magic quotes време извршавања треба да буде искључено како би Moodle исправно функционисао.</p>

<p>Нормално, ово је искључено према подразумеваној вредности... погледајте подешавање <b>magic_quotes_runtime</b> у својој php.ini датотеци.</p>

<p>Ако немате приступ својој php.ini датотеци, можда ћете моћи да ставите следећи ред у датотеку под називом .htaccess, унутар вашег Moodle директоријума: <blocquote>php_value magic_quotes_runtime Off</blockquote>
</p>';
$string['memorylimit'] = 'Ограничење меморије';
$string['memorylimiterror'] = 'PHP ограничење меморије је подешено на прилично низак ниво... касније може доћи до проблема.';
$string['memorylimithelp'] = '<p>PHP ограничење меморије за ваш сервер је тренутно подешено на {$a}.</p>

<p>Ово подешавање може касније да проузрокује да Moodle има проблема са меморијом, посебно ако имате много активираних модула и/или много корисника.</p>

<p>Препоручујемо да конфигуришете PHP са вишим ограничењем ако је могуће, рецимо 40М. Постоји неколико начина на које то може да се то уради:</p><ol>
<li>Ако можете, рекомпајлирајте PHP са <i>--enable-memory-limit</i>. Ово ће омогућити Moodle систему да сам постави меморијско ограничење.</li>
<li>Ако имате приступ својој php.ini датотеци, можете променити вредност за <b>memory_limit</b> на, рецимо, 40М. Ако немате приступ тој датотеци можете питати свог администратора да то уради уместо вас.</li>
<li>На неким PHP серверима можете да креирате .htaccess датотеку у Moodle директоријуму која садржи ред:
<blockquote><div>php_value memory_limit 40M</div></blockquote>
<p>Међутим, на неким серверима то ће спречити приказивање <b>свих</b> PHP страница (видећете поруку о грешци када будете гледали странице), па ћете са тих сервера морати да уклоните .htaccess датотеку.</p></li>
</ol>';
$string['mssqlextensionisnotpresentinphp'] = 'PHP није био прописно конфигурисан са MSSQL екстензијом тако да може комуницирати са SQL* Сервером. Молимо Вас да проверите своју php.ini датотеку или опет компајлирате PHP.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP није правилно подешен за рад са MySQLi екстензијом да би могао да комуницира са MySQL. Молимо, проверите своју php.ini датотеку или поново компајлирајте PHP.';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>Сада је неопходно да конфигуришете базу податка где ће највећи део података из Moodlea бити смештен.</p>
<p>Назив базе, корисничко име и лозинка су обавезна поља. Префикс табела је опциони.</p>
<p>Ако база тренутно не постоји, али дати корисник има потребна овлашћења биће покушано креирање нове базе са одговарајућим правима и подешавањима.</p>
<p>Управљачки програм није компатибилан са старим MyISAM механизмом.</p>';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Сада је неопходно да конфигуришете базу података у коју ће Moodle похрањивати већину података..
Ова база података, као и корисничко име и лозинка за приступ бази, морају бити претходно већ креирани. Префикс табеле је обавезан.';
$string['nativemysqli'] = 'Унапређен MySQL(native/mysqli)';
$string['nativemysqlihelp'] = '<p>Сада је неопходно да конфигуришете базу податка где ће највећи део података из Moodlea бити смештен.</p>
<p>Назив базе, корисничко име и лозинка су обавезна поља. Префикс табела је опциони.</p>
<p>Ако база тренутно не постоји, али дати корисник има потребна овлашћења биће покушано креирање нове базе са одговарајућим правима и подешавањима.</p>';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Сада је неопходно да конфигуришете базу података у коју ће Moodle похрањивати већину података.
Ова база података, као и корисничко име и лозинка за приступ бази, морају бити претходно већ креирани. Префикс табеле је обавезан.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>Сада је неопходно да конфигуришете базу податка где ће највећи део података из Moodlea бити смештен.</p>
<p>Назив базе, корисничко име, лозинка и префикс табеле су обавезна поља.</p>
<p>База мора већ постојати и корисник мора имати овлашћења за читање из ње и писање у њу.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Сада је неопходно да конфигуришете базу података у коју ће Moodle похрањивати већину података.
Ова база података, као и корисничко име и лозинка за приступ бази, морају бити претходно већ креирани.
Префикс табеле је обавезан.';
$string['nativesqlsrvnodriver'] = 'Microsoft драјвери за SQL сервер за PHP нису инсталирани или нису правилно конфигурисани.';
$string['nativesqlsrvnonwindows'] = 'Microsoft драјвери за SQL сервер за PHP доступни су само за Windows OS..';
$string['ociextensionisnotpresentinphp'] = 'PHP није био прописно конфигурисан са OCI8 екстензијом тако да може комуницирати са Oracle-ом. Молимо Вас да проверите своју php.ini датотеку или опет компајлирате PHP.';
$string['pass'] = 'Прошло';
$string['paths'] = 'Путање';
$string['pathserrcreatedataroot'] = 'Инсталациона процедура не може да креира директоријум базе података ({$a->dataroot}).';
$string['pathshead'] = 'Потврди путање';
$string['pathsrodataroot'] = 'У директоријум за податке није могућ упис';
$string['pathsroparentdataroot'] = 'Није могућ упис у надређени директоријум ({$a->parent}).  Инсталациони програм не може да креира директоријум за податке ({$a->dataroot}).';
$string['pathssubadmindir'] = 'Врло мали број веб сервера користи /admin као специјални URL за приступ разним подешавањима (контролни панел и сл.). Нажалост, то доводи до конфликта са стандардном локацијом за администраторске странице у Moodleu. Овај проблем можете решити тако што ћете променити име администраторског директоријума у вашој инсталацији, и овде уписати то ново име. На пример <em>moodleadmin</em>. Ово подешавање ће преправити администраторске линкове у Moodle систему.';
$string['pathssubdataroot'] = '<p>Потребан вам је простор где ће Moodle чувати постављене датотеке.</p><p>Овај директоријум треба да буде подешен тако да се може читати и у њега уписивати од стране корисника веб сервера (обично \'www-data\', \'nobody\' или \'apache\').</p><p>Истовремено не сме бити доступан директно преко веба.</p><p>Уколико овај директоријум не постоји Moodle ће покушати да га креира током инсталације.</p>';
$string['pathssubdirroot'] = '<p>Пуна путања до директоријума који садржи код Moodlea.</p>';
$string['pathssubwwwroot'] = '<p>Пуна адреса путем које ће се приступати платформи.</p>
<p>Није могуће приступати јој користећи више адреса. Ако ваш сајт има више јавних адреса одаберите најједноставнију и на осталим подесите перманентне редирекције на њу.</p>
<p>Ако је ваш сајт доступан са Интернета али и из интранет окружења овде употребите јавну адресу.</p>
<p>Ако је адреса нетачна промените URL у свом веб читачу да бисте поново покренули инсталацију са другачијом вредношћу.</p>';
$string['pathsunsecuredataroot'] = 'Dataroot локација није безбедна';
$string['pathswrongadmindir'] = 'Админ директоријум не постоји';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP није био прописно конфигурисан са  PGSQL екстензијом тако да може комуницирати са PostgreSQLом. Молимо Вас да проверите своју php.ini датотеку или опет компајлирате PHP.';
$string['phpextension'] = '{$a} PHP екстензија';
$string['phpversion'] = 'PHP верзија';
$string['phpversionhelp'] = '<p>Moodle захтева најмање PHP верзију 4.3.0 или 5.1.0 (5.0.x има  бројне уочене проблеме).</p>
<p>Тренутно користите верзију {$a}</p>
<p>Морате надоградити PHP или преместити Moodle на веб сервер са новијом верзијом PHP-a!</br>
(У случају верзије 5.0.x можете, такође, да се вратите на 4.4.x верзију)</p>';
$string['releasenoteslink'] = 'За више информацији о овој верзији Moodlea, погледајте напомене уз издање на {$a}';
$string['safemode'] = 'Безбедни режим';
$string['safemodeerror'] = 'Moodle може имати проблема са укљученим безбедним модом рада';
$string['safemodehelp'] = '<p>Moodle може имати различите проблеме ако је укључен безбедни режим рада. Један од битнијих је тај што му вероватно неће бити дозвољено да креира нове датотеке.</p>

<p>Безбедни режим рада је обично омогућен једино на параноидним јавним веб серверима, тако да ћете можда морати да за свој Moodle сајт нађете нови веб сервер код неке друге компаније.</p>

<p>Можете покушати да наставите са инсталацијом, ако желите, али очекујте неколико проблема касније.</p>';
$string['sessionautostart'] = 'Аутоматски почетак сесије';
$string['sessionautostarterror'] = 'Ова опција би требала бити искључена';
$string['sessionautostarthelp'] = '<p>Moodle захтева подршку за сесије и неће фунционисати без ње.</p>

<p>Рад са сесијама се може омогућити у php.ini датотеци... потражите session.auto_start параметар.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP није правилно подешен са екстензијом SQLite. Молимо проверите Вашу датотеку php.ini или поново компајлирајте PHP.';
$string['upgradingqtypeplugin'] = 'Надоградња додатка за питања/типове';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Ову страницу видите зато што сте успешно инсталирали и покренули <strong>{$a->packname} {$a->packversion}</strong> пакет на свом серверу. Честитамо!';
$string['welcomep30'] = 'Ово издање <strong>{$a->installername}</strong> укључује апликације за креирање окружења у којем ће <strong>Moodle</strong> успешно функционисати, конкретно:';
$string['welcomep40'] = 'Овај пакет обухвата и <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Коришћење свих апликација овог пакета је уређено њиховим лиценцама. Комплетан<strong>{$a->installername}</strong> пакет је <a href="http://www.opensource.org/docs/definition_plain.html">отвореног кода</a> и дистрибуира се под <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a> лиценцом.';
$string['welcomep60'] = 'Наредне странице ће вас провести кроз неколико једноставних корака током којих ћете конфигурисати и подесити <strong>Moodle</strong> на свом рачунару. Можете прихватити подразумевана подешавања или их, опционо, прилагодити сопственим потребама.';
$string['welcomep70'] = 'Кликните на дугме за наставак да бисте даље подешавали <strong>Moodle</strong>.';
$string['wwwroot'] = 'Веб адреса';
$string['wwwrooterror'] = 'Наведена \'веб адреса\' се чини невалидном - ова Moodle инсталација изгледа није на њој. Вредност наведена испод је ресетована.';
