<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'Додаj коментар';
$string['addentry'] = 'Додај нови појам';
$string['addingcomment'] = 'Додаj коментара';
$string['alias'] = 'Кључна реч';
$string['aliases'] = 'Кључне речи';
$string['aliases_help'] = 'Сваки појам у речнику може имати придружени списак кључних речи (или алијаса). Ако користите филтер за аутоматско повезивање појмова, онда ће и све кључне речи, придружене појму, бити аутоматски повезане.

Сваку кључну реч унесите у нови ред (немојте их раздвајати зарезима).';
$string['allcategories'] = 'Све категорије';
$string['allentries'] = 'СВЕ';
$string['allowcomments'] = 'Дозволитe коментарисање појмова';
$string['allowcomments_help'] = '<p>Студентима може бити дозвољено да уносе коментаре за појмове у речнику.</p>

<p>Можете одабрати желите ли да ова опција буде укључена или искључена.</p>

<p>Предавачи увек могу да додају коментаре за појмове у  речнику.</p>';
$string['allowduplicatedentries'] = 'Дозвољени су дупликати појмова';
$string['allowduplicatedentries_help'] = '<p>Ако укључите ову опцију, биће дозвољено да вишеструки појмови имају исто концептуално име.</p>';
$string['allowprintview'] = 'Дозволити приказ верзије за штампу';
$string['allowprintview_help'] = 'Ако је ова опција омогућена, полазницима ће бити доступан линк ка верзији речника која је прилагођена за штампање. Овај линк је увек доступан предавачима.';
$string['andmorenewentries'] = 'и још {$a} нових појмова.';
$string['answer'] = 'Одговор';
$string['approvaldisplayformat'] = 'Формат приказа приликом одобравања';
$string['approvaldisplayformat_help'] = 'Приликом одобравања нових ставки у речнику можда ћете хтети да користите другачији формат приказа';
$string['approve'] = 'Одобри';
$string['areaattachment'] = 'Прилози';
$string['areaentry'] = 'Дефиниције';
$string['areyousuredelete'] = 'Јесте ли сигурни да желите да обришете овај појам?';
$string['areyousuredeletecomment'] = 'Јесте ли сигурни да желите да обришете овај коментар?';
$string['areyousureexport'] = 'Јесте ли сигурни да желите да извезете овај појам у';
$string['ascending'] = '(растући)';
$string['attachment'] = 'Прилог';
$string['attachment_help'] = '<p>Можете опционо закачити ЈЕДАН фајл са свог компјутера било којем појму у речнику. Тај фајл се upload-ује на сервер и чува се са поменутим појмом.</p>

<p>Ово је корисно када желите да делите слику, рецимо, или Word документ.</p>

<p>Овај фајл може бити било ког типа, али је строго препоручљиво да је име фајла са стандардним за интернет суфиксима од три слова, као што су .doc за Word документе, .jpg или .png за слике, итд. Ово ће олакшати другима да скину са мреже и виде Ваше прилоге на својим browser-има.</p>

<p>Ако поново измените појам и закачите нови фајл, раније закачен прилог биће замењен.</p>

<p>Ако поново измените појам и прилог и оставите ово место празно, оригинални прилог ће бити враћен.</p>';
$string['author'] = 'аутор';
$string['authorview'] = 'Преглед по ауторима';
$string['back'] = 'Назад';
$string['cantinsertcat'] = 'Не може се уметнути категорија';
$string['cantinsertrec'] = 'Не може се уметнути појам';
$string['cantinsertrel'] = 'Не може се уметнути релација категорија - појам';
$string['casesensitive'] = 'Уз разликовање малих и великих слова';
$string['casesensitive_help'] = '<p>Ова опција одређује да ли је неопходно тачно подударање у великим и малим словима приликом аутоматског линковања појмова.</p>

<p>На пример, ако је ова опција укључена, тада се реч "html" у поруци на форуму НЕЋЕ линковати на појам "HTML" у речнику.</p>';
$string['cat'] = 'категорија';
$string['categories'] = 'Категорије';
$string['category'] = 'Категорија';
$string['categorydeleted'] = 'Категорија је обрисана';
$string['categoryview'] = 'Преглед по категоријама';
$string['changeto'] = 'промена у <b>{$a}</b>';
$string['cnfallowcomments'] = 'Дефинише да ли се подразумева да ће речник прихватати коментаре појмова';
$string['cnfallowdupentries'] = 'Дефинише да ли се подразумева да ће речник прихватати дупликате појмова';
$string['cnfapprovalstatus'] = 'Дефинише подразумевани статус за одобравање уноса нових појмова послатих од стране полазника';
$string['cnfcasesensitive'] = 'Дефинише да ли да нови појам, кад је линкован, по подразумеваној вредности разликује мала и велика слова';
$string['cnfdefaulthook'] = 'Изаберите начин за приказ речника виђеног по први пут';
$string['cnfdefaultmode'] = 'Изаберите подразумевани оквир за приказ речника виђеног по први пут.';
$string['cnffullmatch'] = 'Дефинише да се појам, ако је линкован, апсолутно поклапа са циљаним текстом';
$string['cnflinkentry'] = 'Дефинише да ли нови појам треба да буде аутоматски линкован';
$string['cnflinkglossaries'] = 'Дефинише да ли речник треба да буде аутоматски линкован';
$string['cnfrelatedview'] = 'Изаберите формат приказа који ће бити коришћен за аутоматско линковање и приказ појомова.';
$string['cnfshowgroup'] = 'Одлучите да ли групна пауза треба да буде приказана или не.';
$string['cnfsortkey'] = 'Изаберите подразумевани кључ за сортирање.';
$string['cnfsortorder'] = 'Одаберите подразумевани редослед сортирања.';
$string['cnfstudentcanpost'] = 'Дефинише да ли полазници по подразумеваним опцијама могу или не могу да уносе појмове у речник';
$string['comment'] = 'Коментар';
$string['commentdeleted'] = 'Коментар је обрисан.';
$string['comments'] = 'Коментари';
$string['commentson'] = 'Коментари су укључени';
$string['commentupdated'] = 'Коментар је ажуриран.';
$string['completionentries'] = 'Број појмова које полазник мора да унесе:';
$string['completionentriesgroup'] = 'Захтевај унос појмова';
$string['concept'] = 'Појам';
$string['concepts'] = 'Појмови';
$string['configenablerssfeeds'] = 'Овај прекидач ће омогућити коришћења RSS сервиса за све речнике. Ипак, мораћете ручно да укључите RSS подршку у подешавањима за сваки речник посебно.';
$string['current'] = 'Тренутно сортирано <b>{$a}</b>';
$string['currentglossary'] = 'Тренутни речник';
$string['date'] = 'датум';
$string['dateview'] = 'Преглед по датуму';
$string['defaultapproval'] = 'Подразумевани статус за одобрења';
$string['defaultapproval_help'] = '<p>Ова опција омогућава предавачу да дефинише шта ће бити са новим појмовима које су додали полазници. Они могу бити аутоматски доступни свима, или, са друге стране, предавач мора сваки од њих да одобри.</p>';
$string['defaulthook'] = 'Подразумевани начин';
$string['defaultmode'] = 'подразумевани приказ';
$string['defaultsortkey'] = 'подразумевани кључ за сортирање';
$string['defaultsortorder'] = 'подразумевани редослед сортирања';
$string['definition'] = 'Дефиниција';
$string['definitions'] = 'Дефиниције';
$string['deleteentry'] = 'Обриши појам';
$string['deletenotenrolled'] = 'Обриши појмове учесника који нису уписани на курс';
$string['deletingcomment'] = 'Брисање коментара';
$string['deletingnoneemptycategory'] = 'Брисањем ове категорије, нећете обрисати појмове које садржи - они ће бити означени као некатегоризовани.';
$string['descending'] = '(опадајући)';
$string['destination'] = 'Одредиште увезених појмова';
$string['destination_help'] = '<p>Можете навести где желите да увезете појмове:</p>

</p><ul><li><strong>Текући речник:</strong> Појмове које увозите биће додати у тренутно отворен речник.
</li>
<li><strong>Нови речник:</strong> Креираће нови речник базиран на информацијама пронађеним у одабраном фајлу који се увози и додаће нове појмове у њега.</li>
</ul>';
$string['disapprove'] = 'Поништи одобрење';
$string['displayformat'] = 'Формат приказа';
$string['displayformatcontinuous'] = 'Продужен без аутора';
$string['displayformatdefault'] = 'Стандардно, исто као и формат приказа';
$string['displayformatdictionary'] = 'Једноставан, у стилу речника';
$string['displayformatencyclopedia'] = 'Енциклопедија';
$string['displayformatentrylist'] = 'Листа појмова';
$string['displayformatfaq'] = 'Често постављана питања';
$string['displayformatfullwithauthor'] = 'Пуни формат са аутором';
$string['displayformatfullwithoutauthor'] = 'Пуни формат без навођења аутора';
$string['displayformat_help'] = 'Постоји 7 различитих формата за приказ појмова:

* Једноставан, у стилу речника - изгледа као конвенционалан речник са одвојеним појмовима. Аутори нису приказани, а прилози се приказају као линкови
* Континуирани без имена аутора - приказује појмове један за другим, који су раздвојени само иконицама за уређивање
* Пуни формат са именом аутора - овај формат је сличан изгледу форума и приказује податке о аутору, док су прилози приказани као линкови
* Пуни формат без именa аутора - овај формат је, такође, сличан изгледу форума, али не приказује податке о аутору, док су прилози приказани као линкови
* Eнциклопедија - овај формат је исти као "Пуни формат са именом аутора" осим што се приложене слике приказују унутар текста (дефиниције појма)
* Листа појмова - појмови су наведени као линкови
* FAQ (<i>Frequently Asked Questions</i> - често постављана питања) - у овом формату као појам се приказује ПИТАЊЕ, а дефиниција као ОДГОВОР.';
$string['displayformats'] = 'Формати приказа';
$string['displayformatssetup'] = 'Приказ подешавања формата';
$string['duplicatecategory'] = 'Дупликат категорије';
$string['duplicateentry'] = 'Дупликат појма';
$string['editalways'] = 'Увек дозволи уређивање';
$string['editalways_help'] = '<p>Ова опција Вам даје могућност да одлучите да ли ће полазници моћи да уређују своје појмове у било ком моменту.</p>

<p>Можете изабрати:</p>

<ul>
<li><b>Да:</b> Појмови се увек могу уређивати.</li>

<li><b>Не:</b> Појмови се могу уређивати док не истекне време предвиђено за то.</li>
</ul>';
$string['editcategories'] = 'Уреди категорије';
$string['editentry'] = 'Уреди појам';
$string['editingcomment'] = 'Уређивање коментара';
$string['entbypage'] = 'Број појмова по страници';
$string['entries'] = 'Појмови';
$string['entrieswithoutcategory'] = 'Појмови ван категорија';
$string['entry'] = 'Појам';
$string['entryalreadyexist'] = 'Појам већ постоји';
$string['entryapproved'] = 'Овај појам је одобрен';
$string['entrydeleted'] = 'Појам је обрисан';
$string['entryexported'] = 'Појам је успешно извезен';
$string['entryishidden'] = '(овај појам је тренутно сакривен)';
$string['entryleveldefaultsettings'] = 'Подразумевана подешавања на нивоу појма';
$string['entrysaved'] = 'Појам је сачуван';
$string['entryupdated'] = 'Појам је ажуриран';
$string['entryusedynalink'] = 'Овај појам треба да буде аутоматски линкован';
$string['entryusedynalink_help'] = '<p align="center"><b>Омогући аутоматско линковвање у појму</b></p>
<p></p>
<p>Укључивање ове опције ће омогућити појму да буде аутоматски линкован кад год се тај попјам или израз појави негде у оквиру истог курса. То подразумева поруке на форумима, унутрашње ресурсе, недељне прегледе итд.</p>

<p>Ако не желите да одређени текст буде линкован (у порукама на форумима, рецимо), онда треба да додате &lt;nolink&gt; испред и &lt;/nolink&gt; иза тог текста.</p>

<p>Да би ова опција могла да се укључи мора бити омогућено ауто линковање на нивоу речника.</p>';
$string['errcannoteditothers'] = 'Не можете уређивати појмове других корисника.';
$string['errconceptalreadyexists'] = 'Овај појам већ постоји. Дупликати нису дозвољени у овом речнику.';
$string['errdeltimeexpired'] = 'Не можете ово обрисати. Време је истекло!';
$string['erredittimeexpired'] = 'Истекло је време за уређивање овог појма.';
$string['errorparsingxml'] = 'Појавиле су се грешке при парсирању датотеке. Проверите валидност XML синтаксе.';
$string['explainaddentry'] = 'Додај нови појам тренутном речнику.<br />Појам и дефиниција су обавезна поља.';
$string['explainall'] = 'Приказивање СВИХ појмова на једној страници';
$string['explainalphabet'] = 'Преглед речника коришћењем овог индекса';
$string['explainexport'] = 'Датотека је направљена.<br />Преузмите је и сачувајте. Можете је увек кад то желите увести у овај или други курс.<p>Имајте на уму да прилози (нпр. слике) и аутори нису извезени.</p>';
$string['explainimport'] = 'Морате да одредите датотеку за увоз и да дефинишете критеријуме за тај процес.<br />Приложите захтев и прегледајте резултате.';
$string['explainspecial'] = 'Прикажи појмове који не почињу словом';
$string['exportedentry'] = 'Извезен појам';
$string['exportentries'] = 'Извези појмове';
$string['exportentriestoxml'] = 'Извези појмове у XML датотеку';
$string['exportfile'] = 'Извези појмове у датотеку';
$string['exportglossary'] = 'Извези речник';
$string['exporttomainglossary'] = 'Извези у главни речник';
$string['filetoimport'] = 'Датотека за увоз';
$string['filetoimport_help'] = '<p>Одаберите на свом компјутеру XML датотеку која садржи појмове за увоз.</p>';
$string['fillfields'] = 'Појам и дефиниција су обавезна поља.';
$string['filtername'] = 'Аутоматско линковање речника';
$string['fullmatch'] = 'Ако се подударају искључиво целе речи';
$string['fullmatch_help'] = '<p>Ако је омогућено аутоматско линковање, онда ће укључивање ове опције форсирати само целе речи за линковање.</p>

<p>На пример, појам "construct" у речнику неће направити линк унутар речи "constructivism".</p>';
$string['glossary:addinstance'] = 'Додај нови речник';
$string['glossary:approve'] = 'Одобри неодобрене појмове, или поништи одобрење одобрених';
$string['glossary:comment'] = 'Напиши коментар';
$string['glossary:export'] = 'Извоз појмова';
$string['glossary:exportentry'] = 'Извоз једног појма';
$string['glossary:exportownentry'] = 'Извоз једног сопственог појма';
$string['glossary:import'] = 'Увоз појмова';
$string['glossaryleveldefaultsettings'] = 'Подразумевана подешавања на нивоу речника';
$string['glossary:managecategories'] = 'Управљање категоријама';
$string['glossary:managecomments'] = 'Управљање коментарима';
$string['glossary:manageentries'] = 'Управљање појмовима';
$string['glossary:rate'] = 'Оцени појмова';
$string['glossarytype'] = 'Врста речника';
$string['glossarytype_help'] = '<p>Систем речника дозвољава извоз појмова из било којег споредног речника у главни речник курса.</p>

<p>Да бисте то урадили, потребно је да дефинишете који је главни речник курса.</p>

<p>Примедба: Можете имати само један главни речник у оквиру курса и једино је предавачима дозвољено да га надограђују.</p>';
$string['glossary:view'] = 'Погледај речник';
$string['glossary:viewallratings'] = 'Погледајте све необрађене оцене дате од стране појединаца';
$string['glossary:viewanyrating'] = 'Погледајте укупне оцене које је било ко добио';
$string['glossary:viewrating'] = 'Погледајте укупну оцену коју сте добили';
$string['glossary:write'] = 'Креирање нових појмова';
$string['guestnoedit'] = 'Гостима није дозвољено да уређују речнике';
$string['importcategories'] = 'Увези категорије';
$string['importedcategories'] = 'Увезене категорије';
$string['importedentries'] = 'Увезени појмови';
$string['importentries'] = 'Увези појмове';
$string['importentriesfromxml'] = 'Увези појмове из XML датотеке';
$string['includegroupbreaks'] = 'Укључи прелазе група';
$string['isglobal'] = 'Да ли је ово општи речник?';
$string['isglobal_help'] = '<p>Администратори могу да одреде речник који ће бити основни.</p>

<p>Ови речници могу бити део било којег курса (but particulary front page).</p>

<p>Разлика између нормалног локалног речника и основног речника је да се у основном речнику појмови користе за креирање аутоматских линкова на нивоу целог сајта (а не само на нивоу курса коме речник припада).</p>';
$string['letter'] = 'слово';
$string['linkcategory'] = 'Аутоматски линкуј ову категорију';
$string['linkcategory_help'] = '<p>Можете подесити желите ли да категорије буду аутоматски линковане, или не.</p>

<p>Примедба: Категорије се линкују базирано на подударању целих речи са разликовањем великих и малих слова.</p>';
$string['linking'] = 'Аутоматско линковање';
$string['mainglossary'] = 'Главни речник';
$string['maxtimehaspassed'] = 'Нажалост, максимално допуштено време за уређивање/измену овог коментара ({$a}) је истекло!';
$string['modulename'] = 'Речник';
$string['modulename_help'] = 'Модул \'Речник\' омогућава учесницима да креирају и одржавају листе појмова и њихових дефиниција, или да сакупљају и орагнизују ресурсе и информације.

Предавач може да дозволи да се уз појмове у речнику додају датотеке као прилог. Приложене слике се приказују унутар дефиниције појма. Појмови у речнику могу да се претражују или прегледају по азбучном (абецедном) редоследу или по категоријама, датуму или аутору. Унети појмови могу бити аутоматски одобрени за објављивање, или их предавач мора одобрити пре него што постану свима видљиви.

Ако је филтер за аутоматско линковање речника омогућен, појмови ће аутоматски бити повезани где год да се унутар курса појављују речи и/или фразе из појма (или кључних речи којима се појам додатно дефинише).

Предавач може да дозволи коментарисање појмове, као и њихово оцењивање како од стране предавача, тако и од стране полазника (вршњачка евалуација). Оцене могу да се сабирају како би се формирала финална оцена која се бележи у књигу оцена.

Речници могу да се користе на различит начине, као на пример:

* колаборативно креирана банка кључних термина
* простор за упознавање где нови полазници додају своја имена и личне податке
* \'корисни савети\' - каталог примера најбоље праксе о практичним темама
* простор за дељење корисних видео клипова, слика или аудио датотека
* каталог чињеница које треба запамтити';
$string['modulenameplural'] = 'Речници';
$string['newentries'] = 'Нови појмови у речнику';
$string['newglossary'] = 'Нови речник';
$string['newglossarycreated'] = 'Нови речник је креиран.';
$string['newglossaryentries'] = 'Нови појмови у речнику:';
$string['nocomment'] = 'Нису пронађени коментари';
$string['nocomments'] = '(Нема коментара овог појма)';
$string['noconceptfound'] = 'Нису пронађени концепти или дефиниције.';
$string['noentries'] = 'Нису пронађени појмови у овом одељку';
$string['noentry'] = 'Није пронађен ниједан појам.';
$string['nopermissiontodelcomment'] = 'Не можете обрисати коментаре других корисника!';
$string['nopermissiontodelinglossary'] = 'Не можете брисати коментаре у овом речнику!';
$string['nopermissiontoviewresult'] = 'Можете прегледати резултате само за сопствене уносе';
$string['notapproved'] = 'Појам још увек није одобрен';
$string['notcategorised'] = 'Није категорисано';
$string['numberofentries'] = 'Број појмова';
$string['onebyline'] = '(један по линији)';
$string['page-mod-glossary-edit'] = 'Улазна страница речника за додавање/уређивање појмова';
$string['page-mod-glossary-view'] = 'Страница за преглед речника';
$string['page-mod-glossary-x'] = 'Било која страница модула \'Речник\'';
$string['pluginadministration'] = 'Администрација речника';
$string['pluginname'] = 'Речник';
$string['popupformat'] = 'Формат за popup прозор';
$string['print'] = 'Штампај';
$string['printerfriendly'] = 'Верзија за штампу';
$string['printviewnotallowed'] = 'Приказ верзије за штампу није дозвољен';
$string['question'] = 'Питање';
$string['rejectedentries'] = 'Одбачени појмови';
$string['rejectionrpt'] = 'Извештај о одбаченим појмовима';
$string['resetglossaries'] = 'Обриши појмове из';
$string['resetglossariesall'] = 'Обриши појмове из свих речника';
$string['rssarticles'] = 'Број скорашњих RSS чланака (појмова)';
$string['rssarticles_help'] = '<p>Ова опција вам даје могућност да одаберете број чланова који желите да укључите у RSS извор вести.</p>

<p>Број између 5 и 20 је за већину речника нормалан. Ако речник често надограђујете, повећајте овај број.</p>';
$string['rsssubscriberss'] = 'Приказати RSS подршку за \'{$a}\' концепте';
$string['rsstype'] = 'RSS извор за ову активност';
$string['rsstype_help'] = '<p>Ова опција Вам допушта да омогућите RSS извор вести за текући речник.</p>

<p>Можете бирати између две врсте подршки:</p>

</p><ul><li><b>Са аутором:</b> Генерисани извори вести ће укључити име аутора у сваком члану.
</li><li><b>Без аутора:</b>Генерисани извори вести неће укључити име аутора у сваки члан.</li>
</ul>';
$string['searchindefinition'] = 'Претражи комплетан текст';
$string['secondaryglossary'] = 'Секундарни речник';
$string['showall'] = 'Прикажи линк \'СВЕ\'';
$string['showall_help'] = '<p>Можете прилагодити на који начин желите да омогућите да корисник прегледа речник. Прегледање и претраживање су увек доступни, а можете да одредите и још три опције:</p>

<p><b>ПРИКАЖИ СПЕЦИЈАЛНЕ</b> Омогући или онемогући приказивање по специјалним карактерима као што су @, #, итд. </p>

<p><b>ПРИКАЖИ АБЕЦЕДУ</b> Омогући или онемогући абецедно приказивање.</p>

<p><b>ПРИКАЖИ СВЕ</b> Омогући или онемогући приказивање свих појмова одједном.</p>';
$string['showalphabet'] = 'Прикажи линкове азбуке/абецеде';
$string['showalphabet_help'] = '<p>Можете прилагодити на који начин желите да омогућите да корисник прегледа речник. Прегледање и претраживање су увек доступни, а можете да одредите и још три опције:</p>

<p><b>ПРИКАЖИ СПЕЦИЈАЛНЕ</b> Омогући или онемогући приказивање по специјалним карактерима као што су @, #, итд. </p>

<p><b>ПРИКАЖИ АБЕЦЕДУ</b> Омогући или онемогући абецедно приказивање.</p>

<p><b>ПРИКАЖИ СВЕ</b> Омогући или онемогући приказивање свих појмова одједном.</p>';
$string['showspecial'] = 'Прикажи линк \'Специјално\'';
$string['showspecial_help'] = '<p>Можете прилагодити на који начин желите да омогућите да корисник прегледа речник. Прегледање и претраживање су увек доступни, а можете да одредите и још три опције:</p>

<p><b>ПРИКАЖИ СПЕЦИЈАЛНЕ</b> Омогући или онемогући приказивање по специјалним карактерима као што су @, #, итд. </p>

<p><b>ПРИКАЖИ АБЕЦЕДУ</b> Омогући или онемогући абецедно приказивање.</p>

<p><b>ПРИКАЖИ СВЕ</b> Омогући или онемогући приказивање свих појмова одједном.</p>';
$string['sortby'] = 'Сортирај';
$string['sortbycreation'] = 'По датуму креирања';
$string['sortbylastupdate'] = 'По датуму последње измене';
$string['sortchronogically'] = 'Хронолошки';
$string['special'] = 'Специјално';
$string['standardview'] = 'Преглед по абецеди';
$string['studentcanpost'] = 'Полазници могу додавати појмове';
$string['totalentries'] = 'Укупно појмова';
$string['usedynalink'] = 'Аутоматски линкуј појмове из речника';
$string['usedynalink_help'] = '<p>Укључивање ове опције омогућује појединачним појмовима у текућем речнику да буду аутоматски линковани кад год се тај појам или израз појави негде у оквиру тог курса. То подразумева поруке на форумима, унутрашње ресурсе, недељне прегледе итд.</p>

<p>Обратите пажњу на то да омогућавање линковања за речник не укључује аутоматски и линковање за сваки појам - линковање мора бити подешено за сваки појам посебно.</p>

<p>Ако не желите да одређени текст буде линкован (у порукама на форуму, рецимо) онда треба да додате &lt;nolink&gt; испред и &lt;/nolink&gt; иза текста. </p>

<p>Запамтите да се и имена категорија такође линкују.</p>';
$string['waitingapproval'] = 'Чека на одобрење';
$string['warningstudentcapost'] = '(Важи само ако речник није главни)';
$string['withauthor'] = 'Појмови уз навођење аутора';
$string['withoutauthor'] = 'Појмови без навођења аутора';
$string['writtenby'] = 'од';
$string['youarenottheauthor'] = 'Ви нисте аутор овог коментара, па Вам није дозвољено да га мењате.';
