<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Има нових порука на форуму';
$string['addanewdiscussion'] = 'Додај нову тему за дискусију';
$string['addanewquestion'] = 'Додај ново питање';
$string['addanewtopic'] = 'Додај нову тему';
$string['advancedsearch'] = 'Напредно претраживање';
$string['allforums'] = 'Сви форуми';
$string['allowdiscussions'] = 'Да ли {$a} може слати поруке на овај форум?';
$string['allowsallsubscribe'] = 'Овај форум дозвољава свима да одаберу да ли ће се претплатити или не.';
$string['allowsdiscussions'] = 'Овај форум дозвољава свакој особи да започне једну дискусију';
$string['allsubscribe'] = 'Пријавите се на све форуме';
$string['allunsubscribe'] = 'Одјавите се са свих форума';
$string['alreadyfirstpost'] = 'Ово је већ прва порука у дискусији';
$string['anyfile'] = 'Било која датотека';
$string['areaattachment'] = 'Прилози';
$string['areapost'] = 'Поруке';
$string['attachment'] = 'Прилог';
$string['attachment_help'] = 'Поруци можете да приложите једну или више датотека. Ако приложите слику, она ће бити приказана на крају поруке.';
$string['attachmentnopost'] = 'Не можете да извезете прилоге без идентификатора поруке';
$string['attachments'] = 'Прилози';
$string['attachmentswordcount'] = 'Прилози и број речи';
$string['blockafter'] = 'Гранична вредност броја порука која доводи до блокирања';
$string['blockafter_help'] = 'Ово подешавање одређује највећи број порука које корисник може да постује на форуму и датом временском периоду. Ово ограничење не важи за кориснике који имају овлашћења mod/forum:postwithoutthrottling.';
$string['blockperiod'] = 'Временски период након ког се врши блокирање';
$string['blockperioddisabled'] = 'Не блокирати';
$string['blockperiod_help'] = 'Могуће је ограничити број порука које полазници могу послати унутар датог временског периода. Ово ограничење не важи за кориснике који имају овлашћења mod/forum:postwithoutthrottling.';
$string['blogforum'] = 'Стандардни форум у облику блога';
$string['bynameondate'] = 'написао/ла {$a->name} - {$a->date}';
$string['cannotadd'] = 'Није могуће додати дискусију на овом форуму';
$string['cannotadddiscussion'] = 'Додавање дискусије у оквиру овог форума захтева групно чланство.';
$string['cannotadddiscussionall'] = 'Немате дозволу да додајете нову тему за дискусију за све учеснике.';
$string['cannotaddsubscriber'] = 'Није било могуће додати претплатника са идентификатором {$a} на овај форум!';
$string['cannotaddteacherforumto'] = 'Није било могуће додати инстанцу измењеног форума предавача у секцију 0 овога курса';
$string['cannotcreatediscussion'] = 'Није било могуће отворити нову дискусију';
$string['cannotcreateinstanceforteacher'] = 'Није било могуће крерати нову инстанцу модула за предавачки форум';
$string['cannotdeletepost'] = 'Не можете да обришете ову поруку!';
$string['cannoteditposts'] = 'Не можете да уређујете поруке других корисника!';
$string['cannotfinddiscussion'] = 'Није било могуће наћи дискусију на овом форуму';
$string['cannotfindfirstpost'] = 'Није било могуће наћи прву поруку на овом форуму';
$string['cannotfindorcreateforum'] = 'Није било могуће наћи или креирати главни форум за новости на овом сајту';
$string['cannotfindparentpost'] = 'Није било могуће наћи надређену поруку за поруку {$a}';
$string['cannotmovefromsingleforum'] = 'Није могуће преместити дискусију из форума типа \'једна обична дискусија\'';
$string['cannotmovenotvisible'] = 'Форум није видљив';
$string['cannotmovetonotexist'] = 'Не можете да преместите у тај форум јер он не постоји!';
$string['cannotmovetonotfound'] = 'Циљни форум није пронађен на овом курсу.';
$string['cannotmovetosingleforum'] = 'Није могуће преместити дискусију у форум типа једна обична дискусија';
$string['cannotpurgecachedrss'] = 'Није било могуће очистити RSS доводе из кеша за изворни и/или одредишни(е) форум(е) - проверите Вашу датотеку за дозволе форума';
$string['cannotremovesubscriber'] = 'Није било могуће уклонити претплатника са идентификатором {$a} са овог форума!';
$string['cannotreply'] = 'Не можете да одговорите на ову поруку';
$string['cannotsplit'] = 'Дискусије са овог форума не могу бити раздвојене';
$string['cannotsubscribe'] = 'Опростите али морате бити члан групе да бисте се пријавили';
$string['cannottrack'] = 'Није могуће престати с праћењем овог форума';
$string['cannotunsubscribe'] = 'Није могуће одјавити се са овог форума';
$string['cannotupdatepost'] = 'Не можете да ажурирате ову поруку';
$string['cannotviewpostyet'] = 'Још увек не можете да читате питања других полазника у овој дискусији јер нисте послали ниједну поруку';
$string['cannotviewusersposts'] = 'Не постоје поруке овог корисника које можете да видите';
$string['cleanreadtime'] = 'Време када се старе поруке обележавају као прочитане';
$string['completiondiscussions'] = 'Корисник мора да креира дискусију:';
$string['completiondiscussionsgroup'] = 'Захтевај дискусију';
$string['completiondiscussionshelp'] = 'неопходно је креирање дискусије за завршетак активности';
$string['completionposts'] = 'Полазник мора да пошаље поруку или одговор:';
$string['completionpostsgroup'] = 'Обавезно слање поруке';
$string['completionpostshelp'] = 'неопходно је слање поруке или одговора за завршетак активности';
$string['completionreplies'] = 'Полазник мора да пошаље одговор:';
$string['completionrepliesgroup'] = 'Неопходан је одговор на поруку';
$string['completionreplieshelp'] = 'неопходан је одговор на поруку за завршетак активности';
$string['configcleanreadtime'] = 'Време у току дана када се бришу старе поруке из табеле "прочитано".';
$string['configdigestmailtime'] = 'Корисници који изаберу да им се поруке са форума шаљу електронском поштом у скраћеном облику, добијаће једну поруку дневно. Ово подешавање задаје време у току дана када ће наведена порука бити послата (први следећи крон који се покрене након задатог времена ће их послати).';
$string['configdisplaymode'] = 'Подразумевани начин приказивања странице са дискусијама уколико исти није подешен.';
$string['configenablerssfeeds'] = 'Овај прекидач ће омогућити коришћења RSS сервиса за све форуме. Ипак, мораћете ручно да укључите RSS подршку у подешавањима за сваки форум посебно.';
$string['configenabletimedposts'] = 'Изаберите "да" ако желите да дозволите подешавање периода приказивања поруке приликом отварања нове дискусије на форуму (експериментално, пошто још увек није потпуно тестирано).';
$string['configlongpost'] = 'Било која порука дужа од ове вредности (изражене у карактерима, не рачунајући HTML ознаке) сматра се предугом. Поруке приказане на почетној страници сајта, странице курсева у друштвеном формату, или кориснички профили се скраћују природно на дужину која се креће између вредности за forum_shortpost и forum_longpost.';
$string['configmanydiscussions'] = 'Максималан број дискусија приказаних на форуму по страници';
$string['configmaxattachments'] = 'Подразумевани максимални број прилога дозвољен по једној поруци.';
$string['configmaxbytes'] = 'Подразумевана максимална величина прилога за све форуме на сајту (зависно од ограничења курсева и осталих локалних подешавања)';
$string['configoldpostdays'] = 'Број дана након којег се све старе поруке сматрају прочитаним.';
$string['configreplytouser'] = 'Када се порука са форума шаље електронском поштом, хоће ли она садржати електронску адресу аутора поруке, тако да прималац поруке може на њу да одговори лично а не преко форума? Чак и када је ова опција подешена на "Да", корисници могу да, у оквиру свог корисничког профила, одаберу да њихова електронска адреса буде сакривена од осталих корисника.';
$string['configshortpost'] = 'Свака порука краћа од ове дужине (не укључујући HTML ознаке) се сматра кратком (види испод).';
$string['configtrackingtype'] = 'Подразумевано подешавање за праћење прочитаних/непрочитаних порука?';
$string['configtrackreadposts'] = 'Подесите на "Да" ако желите да пратите прочитане/непрочитане поруке за сваког корисника.';
$string['configusermarksread'] = 'Ако је изабрана опција "да" корисник мора ручно да обележи поруку као прочитану, у супротном (опција "не") оног тренутка када је корисник видео поруку она ће бити обележена као прочитана.';
$string['confirmsubscribe'] = 'Да ли заиста желите да се пријавите на форум \'{$a}\'?';
$string['confirmunsubscribe'] = 'Да ли заиста желите да се одјавите са форума \'{$a}\'?';
$string['couldnotadd'] = 'Нажалост, није могуће додати Вашу поруку због непознате грешке';
$string['couldnotdeletereplies'] = 'Жао нам је, ова порука се не може обрисати пошто су други корисници одговорили на њу';
$string['couldnotupdate'] = 'Ваша порука не може бити ажурирана због непознате грешке';
$string['delete'] = 'Обриши';
$string['deleteddiscussion'] = 'Ова тема је обрисана';
$string['deletedpost'] = 'Порука је обрисана';
$string['deletedposts'] = 'Те поруке су обрисане';
$string['deletesure'] = 'Јесте ли сигурни да желите да обришете ову поруку?';
$string['deletesureplural'] = 'Јесте ли сигурни да желите да обришете ову поруку и СВЕ одговоре на њу? ({$a} порука)';
$string['digestmailheader'] = 'Ово је Ваш дневни скраћени приказ нових порука са {$a->sitename} форума. Да би сте променили начин на који ће Вам бити слате поруке са форума идите на {$a->userprefs}.';
$string['digestmailpost'] = 'Промените Ваше преференције везане за резиме порука са форума';
$string['digestmailprefs'] = 'Ваш кориснички профил';
$string['digestmailsubject'] = '{$a}: скраћен приказ порука са форума';
$string['digestmailtime'] = 'Време за слање е-поште са скраћеним извештајима';
$string['digestsentusers'] = 'Скраћен приказ порука са форума успешно је послат на електронске адресе {$a} корисника';
$string['disallowsubscribe'] = 'Учлањивање није дозвољено';
$string['disallowsubscribeteacher'] = 'Учлањивање није дозвољено (осим предавачима)';
$string['discussion'] = 'Дискусија';
$string['discussionmoved'] = 'Ова дискусија је премештена на \'{$a}\'.';
$string['discussionmovedpost'] = 'Ова дискусија је премештена <a href="{$a->discusshref}">овде</a> у форуму <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Назив дискусије';
$string['discussions'] = 'Дискусије';
$string['discussionsstartedby'] = 'Дискусију започео/ла {$a}';
$string['discussionsstartedbyrecent'] = 'Дискусије које је корисник {$a} започео у скорије време';
$string['discussionsstartedbyuserincourse'] = 'Дискусија коју је започео/ла {$a->fullname} на курсу {$a->coursename}';
$string['discussthistopic'] = 'Дискусија о овој теми';
$string['displayend'] = 'Крај приказивања';
$string['displayend_help'] = 'Ово подешавање одређује да ли ће порука на форуму бити сакривене након одређеног датума. Напомена: администратори увек могу да виде поруке на форуму.';
$string['displaymode'] = 'Начин приказивања';
$string['displayperiod'] = 'Период приказивања';
$string['displaystart'] = 'Почетак приказивања';
$string['displaystart_help'] = 'Ово подешавање одређује да ли ће порука на форуму бити приказана од одређеног датума. Напомена: администратори увек могу да виде поруке на форуму.';
$string['displaywordcount'] = 'Прикажи број речи';
$string['displaywordcount_help'] = 'Ово подешавање одређује да ли треба приказати број речи сваке поруке.';
$string['eachuserforum'] = 'Свака особа може започети једну дискусију';
$string['edit'] = 'Уреди';
$string['editedby'] = 'Уредио/ла  {$a->name} - изворно објављено {$a->date}';
$string['editedpostupdated'] = 'Порука коју је постовао/ла {$a} је ажурирана';
$string['editing'] = 'Уређивање';
$string['emaildigest_0'] = 'Добијаћете једну електронску поруку по објави.';
$string['emaildigest_1'] = 'Добијаћете по једну електронску поруку на дан која ће садржати комплетан садржај објава на форуму.';
$string['emaildigest_2'] = 'Добијаћете по једну електронску поруку на дан која ће садржати само наслове свих објава на форуму.';
$string['emaildigestcompleteshort'] = 'Комплетне поруке';
$string['emaildigestdefault'] = 'Подразумевано ({$a})';
$string['emaildigestoffshort'] = 'Без резимеа';
$string['emaildigestsubjectsshort'] = 'Само наслови';
$string['emaildigesttype'] = 'Опције везане за резиме који се шаље електронском поштом';
$string['emaildigesttype_help'] = 'Тип обавештења који ћете добијати са сваког форума.

* Подразумевани - пратиће се преференције постављене у Вашем корисничком профилу. Ако ажурирате свој профил промене ће се одразити и на ово подешавање;
* Без резимеа - добијаћете једну електронску поруку по објави на форуму;
* Резиме - комплетне објаве - добијаћете једну електронску поруку на дан која ће садржати комплетан садржај свих објава на форуму;
* Резиме - само теме - добијаћете једну електронску поруку на дан која ће садржати само теме свих објава на форуму.';
$string['emaildigestupdated'] = 'Опција везана за резиме који се шаље електронском поштом је измењена на \'{$a->maildigesttitle}\' за форум \'{$a->forum}\'. {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'Ваше подразумевано подешавање у профилу за \'{$a->maildigesttitle}\' је коришћено за форум \'{$a->forum}\'. {$a->maildigestdescription}.';
$string['emptymessage'] = 'Нешто није у реду са вашом поруком. Можда сте оставили празна поља, или је прилог био превелик. Ваше промене НИСУ сачуване.';
$string['erroremptymessage'] = 'Тело поруке не може бити празно';
$string['erroremptysubject'] = 'Тема (наслов) поруке не може бити празна';
$string['errorenrolmentrequired'] = 'Да бисте приступили овом садржају морате бити уписани на овај курс';
$string['errorwhiledelete'] = 'Дошло је до грешке у току брисања записа';
$string['event_assessable_uploaded'] = 'Објављен је неки садржај.';
$string['everyonecanchoose'] = 'Сви могу одабрати желе ли бити учлањени на овај форум';
$string['everyonecannowchoose'] = 'Свако може сада да изабере да ли ће бити претплаћен на овај форум ';
$string['everyoneisnowsubscribed'] = 'Сви су сада претплаћени на овај форум';
$string['everyoneissubscribed'] = 'Сви су претплаћени на овај форум';
$string['existingsubscribers'] = 'Тренутни чланови';
$string['exportdiscussion'] = 'Извези целу дискусију';
$string['forcedreadtracking'] = 'Дозволи обавезно праћење прочитаних/непрочитаних порука?';
$string['forcedreadtracking_desc'] = 'Ова опција дозвољава да форуми буду подешени тако да се обавезно прате прочитане/непрочитане поруке. Ово ће довести до смањења перформанси система за неке кориснике, нарочито на курсевима са великим бројем форума и порука. Када се искључи, сви форуми, претходно подешени на "обавезно", биће пребачени на опционо праћење прочитаних/непрочитаних порука.';
$string['forcessubscribe'] = 'Учлањивање на овај форум је обавезно за све.';
$string['forum'] = 'Форум';
$string['forum:addinstance'] = 'Додај нови форум';
$string['forum:addnews'] = 'Додај вест';
$string['forum:addquestion'] = 'Додај питање';
$string['forum:allowforcesubscribe'] = 'Омогући принудну пријаву на форум';
$string['forumauthorhidden'] = 'Аутор (скривено)';
$string['forumblockingalmosttoomanyposts'] = 'Приближавате се максималном могућем броју порука на овом форуму. Објавили сте {$a->numposts} порука у последњих {$a->blockperiod} а лимит је {$a->blockafter} порука.';
$string['forumbodyhidden'] = 'Ову поруку не можете да видите, вероватно зато што: још нисте учествовали у дискусији, још није истекло максимално дозвољено време за уређивање поруке, дискусија још није започета или зато што је дискусија истекла.';
$string['forum:createattachment'] = 'Креирај прилоге';
$string['forum:deleteanypost'] = 'Обриши све поруке (у било које време)';
$string['forum:deleteownpost'] = 'Обриши своје поруке (у задатом року)';
$string['forum:editanypost'] = 'Уреди било коју поруку';
$string['forum:exportdiscussion'] = 'Извези комплетну дискусију';
$string['forum:exportownpost'] = 'Извези своју поруку';
$string['forum:exportpost'] = 'Извези поруку';
$string['forumintro'] = 'Опис';
$string['forum:managesubscriptions'] = 'Управљање чланствима';
$string['forum:movediscussions'] = 'Премести дискусије';
$string['forumname'] = 'Назив форума';
$string['forumposts'] = 'Поруке на форуму';
$string['forum:postwithoutthrottling'] = 'Изузет од ограничења броја порука';
$string['forum:rate'] = 'Оцени поруке';
$string['forum:replynews'] = 'Одговори на вести';
$string['forum:replypost'] = 'Одговори на поруке';
$string['forums'] = 'Форуми';
$string['forum:splitdiscussions'] = 'Подели дискусије';
$string['forum:startdiscussion'] = 'Започни нове дискусије';
$string['forumsubjecthidden'] = 'Тема (скривено)';
$string['forumtracked'] = 'Непрочитане поруке се прате';
$string['forumtrackednot'] = 'Непрочитане поруке се не прате';
$string['forumtype'] = 'Тип форума';
$string['forumtype_help'] = 'Постоји 5 типова форума:

* Једна обична дискусија - форум у облику само једне теме о којој сви могу дискутовати и слати своје одговоре (не може се користити са одвојеним групама)
* Сваки учесник покреће једну дискусију - сваки полазник може покренути само једну нову тему за дискусију, на коју сви могу да одговарају
* Форум питања и одговора - полазници морају прво да пошаљу свој одговор пре него што виде одговоре других
* Стандарни форум у облику блога - отворени форум у којем свако у било ком тренутку може започети нову дискусију, и у ком су теме за дискусију приказане на једној страници са линком "Дискутуј о овој теми"
* Стандардни форум за општу употребу - отворени форум у којем свако може започети нову дискусију у било ком тренутку';
$string['forum:viewallratings'] = 'Погледај све необрађене оцене које су дали појединци';
$string['forum:viewanyrating'] = 'Погледај све оцене које је добио било ко';
$string['forum:viewdiscussion'] = 'Преглед дискусија';
$string['forum:viewhiddentimedposts'] = 'Погледај скривене, временски ограничене поруке';
$string['forum:viewqandawithoutposting'] = 'Увек види поруке на форуму "Питања и одговори"';
$string['forum:viewrating'] = 'Погледајте све оцене које сте добили';
$string['forum:viewsubscribers'] = 'Преглед чланова';
$string['generalforum'] = 'Стандардни форум за општу употребу';
$string['generalforums'] = 'Општи форуми';
$string['hiddenforumpost'] = 'Скривена порука на форуму';
$string['inforum'] = 'у {$a}';
$string['introblog'] = 'Поруке у овом форуму су аутоматски овде копиране из блога корисника на овом курсу зато што ти чланци блога нису више доступни';
$string['intronews'] = 'Опште новости и најаве';
$string['introsocial'] = 'Отворени форум за разговор о било којој теми';
$string['introteacher'] = 'Форум резервисан за белешке и дускусије предавача';
$string['invalidaccess'] = 'Овој страни није исправно приступљено';
$string['invaliddigestsetting'] = 'Подешавање резимеа објава које се шаљу електронском поштом које је дато није валидно';
$string['invaliddiscussionid'] = 'Идентификатор дискусије није био исправан или више не постоји';
$string['invalidforcesubscribe'] = 'Неисправан начин обавезне претплате';
$string['invalidforumid'] = 'ID форума није био тачан';
$string['invalidparentpostid'] = 'Идентификатор надређене поруке је неисправан';
$string['invalidpostid'] = 'Неисправан ID поруке - {$a}';
$string['lastpost'] = 'Последња порука';
$string['learningforums'] = 'Форуми за учење';
$string['longpost'] = 'Дугачкa порука';
$string['mailnow'] = 'Пошаљи одмах е-поштом';
$string['manydiscussions'] = 'Број дискусија по страници';
$string['markalldread'] = 'Означи све поруке ове дискусије као прочитане.';
$string['markallread'] = 'Означи све поруке на овом форуму као прочитане.';
$string['markread'] = 'Означи као прочитано';
$string['markreadbutton'] = 'Означи као<br /> прочитано';
$string['markunread'] = 'Означи као непрочитано';
$string['markunreadbutton'] = 'Означи као<br /> непрочитано';
$string['maxattachments'] = 'Максималан број прилога';
$string['maxattachments_help'] = 'Ово подешавање одређује максималан број датотека које могу бити приложене уз поруку.';
$string['maxattachmentsize'] = 'Максимална величина прилога';
$string['maxattachmentsize_help'] = 'Ово подешавање одређује максималну величину датотеке која може бити приложена уз поруку.';
$string['maxtimehaspassed'] = 'Нажалост, максимално време за уређивање ове поруке ({$a}) је истекло!';
$string['message'] = 'Порука';
$string['messageprovider:digests'] = 'Изводи порука са форума на које сте претплаћени';
$string['messageprovider:posts'] = 'Поруке са форума на које сте претплаћени';
$string['missingsearchterms'] = 'Следећи тражени термини се јављају искључиво унутар HTML ознака ове поруке:';
$string['modeflatnewestfirst'] = 'Приказ одговора, почевши прво с најновијим';
$string['modeflatoldestfirst'] = 'Приказ одговора, почевши прво с најстаријим';
$string['modenested'] = 'Приказ одговора у угнежђеној форми';
$string['modethreaded'] = 'Приказ одговора у низу';
$string['modulename'] = 'Форум';
$string['modulename_help'] = 'Модул активности \'Форум\' омогућава учесницима да воде асинхроне дискусије тј, да дискутују на различите теме у дужем временском периоду.

Постоји неколико типова форуму који се могу изабрати, као што су стандардни форуму где свако може да започне нову дискусију у било ком тренутку; форум где сваки полазник може да покрене само једну дискусију, или форум \'Питање и одговор\' где полазници морају прво да поставе свој одговор пре него што буде у могућности да виде одговоре других полазника. Предавач може да дозволи полазницима да уз своје поруке достављају датотеке у прилогу. Приложене слике се приказују унутар саме поруке.

Учесници могу да се пријаве (претплате) на форуму како би редовно примали обавештења о новим порукама. Предавач може да подеси режим пријаве на опциони, обавезни или аутоматски, или да потпуно спречи могућност пријаве на форум. Ако је потребно, могуће је, такође, спречити да полазници шаљу више од одређеног броја порука, у датом временском периоду; на овај начин може се спречити да појединци доминирају дискусијама.

Поруке на форумима могу бити  оцењиване како од стране предавача, тако и од стране полазника (вршњачка евалуација). Оцене могу да се сабирају како би се формирала финална оцена која се бележи у књигу оцена.

Форуми могу да се користе на врло различите начине, као нпр:

* друштвени простор за међусобно упознавање и дружење полазника
* за објављивање важних обавештења на курсу (користећи форум \'Вести\' на који су, стандардно, сви полазници пријављени)
* за дискутовање о садржају односно темама које курс покрива
* за  наставак дискусије у онлајн окружењу, о темама које се претходно започете у учионици
* за дискусије намењене само предавачима (користећи опцију за сакривање форума од полазника)
- као центар за помоћ, где полазници могу да добију помоћ и савет од стране предавача и искуснијих полазника
* за додатне активности, на пример \'мозгалице\' за полазнике o којима они треба да размисле и понуде решењa';
$string['modulenameplural'] = 'Форуми';
$string['more'] = 'још';
$string['movedmarker'] = '(Премештено)';
$string['movethisdiscussionto'] = 'Премести ову дискусију у ...';
$string['mustprovidediscussionorpost'] = 'Морате навести идентификатор дискусије или поруке да бисте их извезли';
$string['namenews'] = 'Форум вести';
$string['namenews_help'] = '<p>Форум вести је специјални форум за најаве и најновије информације који се аутоматски креира када се отвара нови курс. Курс можете имати само један овакав форум.</p>

<p>Блок "Најновије вести" ће приказивати најновије дискусије са овог форума (чак и ако му промените име).</p>';
$string['namesocial'] = 'Друштвени форум';
$string['nameteacher'] = 'Форум предавача';
$string['newforumposts'] = 'Нове поруке на форуму';
$string['noattachments'] = 'Ова порука нема прилога';
$string['nodiscussions'] = 'Још нема тема за дискусију на овом форуму';
$string['nodiscussionsstartedby'] = '{$a} није започео/ла ниједну дискусију';
$string['nodiscussionsstartedbyyou'] = 'Још нисте започели ниједну диксусију';
$string['noguestpost'] = 'Нажалост, гостима није дозвољено слање порука.';
$string['noguesttracking'] = 'Нажалост, гостима није дозвољено да подешавају опције за праћење порука.';
$string['nomorepostscontaining'] = 'Нема више порука које садрже \'{$a}\'';
$string['nonews'] = 'Тренутно нема новости';
$string['noonecansubscribenow'] = 'Пријаве тренутно нису могуће';
$string['nopermissiontosubscribe'] = 'Немате дозволу да видите ко се пријавио на форум';
$string['nopermissiontoview'] = 'Немате дозволу да видите ову поруку';
$string['nopostforum'] = 'Опростите, али није вам дозвољено слање порука на овај форум';
$string['noposts'] = 'Нема порука';
$string['nopostsmadebyuser'] = '{$a} није послао/ла ниједну поруку';
$string['nopostsmadebyyou'] = 'Нисте написали ниједну поруку';
$string['noquestions'] = 'Још нема питања на овом форуму';
$string['nosubscribers'] = 'Тренутно нема пријављених корисника на овом форуму';
$string['notexists'] = 'Дискусија више не постоји';
$string['nothingnew'] = 'Ништа ново за {$a}';
$string['notingroup'] = 'Нажалост, морате бити део групе да бисте видели овај форум.';
$string['notinstalled'] = 'Модул Форум није инсталиран';
$string['notpartofdiscussion'] = 'Ова порука није део дискусије';
$string['notrackforum'] = 'Не прати непрочитане поруке';
$string['noviewdiscussionspermission'] = 'Немате дозволу да видите дискусије на овом форуму';
$string['nowallsubscribed'] = 'Пријављени сте на све форуме у {$a}.';
$string['nowallunsubscribed'] = 'Одјављени сте са свих форума у {$a}.';
$string['nownotsubscribed'] = '{$a->name} НЕЋЕ примати е-поруке са копијама порука с форума \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} више не прати поруке на форуму \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} ће примати е-поруке са копијама порука с форума \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} прати поруке на форуму \'{$a->forum}\'.';
$string['numposts'] = 'Број порука: {$a}';
$string['olderdiscussions'] = 'Старије дискусије';
$string['oldertopics'] = 'Старије теме';
$string['oldpostdays'] = 'Број дана након којих се старе поруке сматрају прочитаним';
$string['openmode0'] = 'Нема дискусија, нема одговора';
$string['openmode1'] = 'Нема дискусија, али одговори су дозвољени';
$string['openmode2'] = 'Дискусије и одговори су дозвољени';
$string['overviewnumpostssince'] = '{$a} порукa/е од последње пријаве на систем';
$string['overviewnumunread'] = 'укупно непрочитаних: {$a}';
$string['page-mod-forum-discuss'] = 'Страница са дискусијом модула \'Форум\'';
$string['page-mod-forum-view'] = 'Главна страница форума';
$string['page-mod-forum-x'] = 'Било која страница форума';
$string['parent'] = 'Прикажи надређену поруку';
$string['parentofthispost'] = 'Порука надређена овој поруци';
$string['pluginadministration'] = 'Администрација форума';
$string['pluginname'] = 'Форум';
$string['postadded'] = '<p>Ваша порука је успешно додата.</p> <p>Имате {$a} за промену садржаја исте, уколико то желите.</p>';
$string['postaddedsuccess'] = 'Ваша порука је успешно додата.';
$string['postaddedtimeleft'] = 'Имате {$a} минута да уредите поруку ако желите да направите било какве измене.';
$string['postbyuser'] = '{$a->post} написао/ла {$a->user}';
$string['postincontext'] = 'Погледај поруку у контексту';
$string['postmailinfo'] = 'Ово је копија поруке са форума на веб сајту {$a}.

Да бисте одговорили на поруку кликните на овај линк:';
$string['postmailnow'] = '<p>Ова порука ће бити одмах послата свима који су пријављени на овај форум.</p>';
$string['postrating1'] = 'Углавном одвојено знање';
$string['postrating2'] = 'Одвојено и повезано';
$string['postrating3'] = 'Углавном повезано знање';
$string['posts'] = 'Поруке';
$string['postsmadebyuser'] = 'Порука коју је послао/ла {$a}';
$string['postsmadebyuserincourse'] = 'Порука коју је послао/ла {$a->fullname} на курсу {$a->coursename}';
$string['posttoforum'] = 'Пошаљи поруку на форум';
$string['postupdated'] = 'Ваша порука је ажурирана';
$string['potentialsubscribers'] = 'Потенцијални чланови';
$string['processingdigest'] = 'Слање извода путем е-поште кориснику {$a}';
$string['processingpost'] = 'Обрађује се порука {$a}';
$string['prune'] = 'Раздвој';
$string['prunedpost'] = 'Од ове поруке креирана је нова дискусија';
$string['pruneheading'] = 'Раздвој дискусију и премести ову поруку у нову дискусију';
$string['qandaforum'] = 'Форум питања и одговора';
$string['qandanotify'] = 'Ово је форум питања и одговора. Да бисте видели одговоре других на ова питања, морате прво послати свој одговор';
$string['re'] = 'Одговор:';
$string['readtherest'] = 'Прочитајте остатак ове теме';
$string['replies'] = 'Одговори';
$string['repliesmany'] = '{$a} одговора до сада';
$string['repliesone'] = '{$a} одговор до сада';
$string['reply'] = 'Одговори';
$string['replyforum'] = 'Одговори на форуму';
$string['replytouser'] = 'Користи адресу е-поште у одговору';
$string['resetdigests'] = 'Обриши све преференције везане за слање резимеа електронском поштом које су постављене на нивоу корисника';
$string['resetforums'] = 'Обриши поруке са';
$string['resetforumsall'] = 'Обриши све поруке';
$string['resetsubscriptions'] = 'Обриши све пријаве на форум';
$string['resettrackprefs'] = 'Обриши сва подешавања за праћење форума';
$string['rssarticles'] = 'Број скорашњих RSS чланака';
$string['rssarticles_help'] = 'Ово подешавање одређује број чланака (дискусија или порука) који ће бити укључени у RSS извор вести. За већину форума је прихватљиво да то буде између 5 и 20 чланака.';
$string['rsssubscriberssdiscussions'] = 'RSS извор дискусија';
$string['rsssubscriberssposts'] = 'RSS извор порука';
$string['rsstype'] = 'RSS извор за ову активност';
$string['rsstype_help'] = 'Да бисте укључили RSS извор вести за ову активност одаберите дискусије или поруке које ће бити укључен у овај извор.';
$string['search'] = 'Претраживање';
$string['searchdatefrom'] = 'Поруке морају бити свежије од';
$string['searchdateto'] = 'Поруке морају бити старије од';
$string['searchforumintro'] = 'Молимо да унесете термине претраживања у једно или више од следећих поља:';
$string['searchforums'] = 'Претражи форуме';
$string['searchfullwords'] = 'Ове речи треба да се појаве као целе речи';
$string['searchnotwords'] = 'Ове речи НЕ треба да буду укључене';
$string['searcholderposts'] = 'Претражи старије поруке...';
$string['searchphrase'] = 'Ова конкретна фраза се мора наћи у поруци';
$string['searchresults'] = 'Резултати претраживања';
$string['searchsubject'] = 'Ове речи треба да буду у теми поруке';
$string['searchuser'] = 'Ово име треба да одговара имену аутора поруке';
$string['searchuserid'] = 'Moodle идентификатор аутора поруке';
$string['searchwhichforums'] = 'Изаберите које форуме треба претражити';
$string['searchwords'] = 'Ове речи се могу појавити било где у поруци';
$string['seeallposts'] = 'Погледај све поруке овог корисника';
$string['shortpost'] = 'Кратка порука';
$string['showsubscribers'] = 'Прикажи/промени списак тренутних чланова';
$string['singleforum'] = 'Једна обична дискусија';
$string['smallmessage'] = '{$a->user} је послао/ла поруку на {$a->forumname}';
$string['startedby'] = 'Започео/ла';
$string['subject'] = 'Тема';
$string['subscribe'] = 'Учланите се у овај форум';
$string['subscribeall'] = 'Пријави све кориснике на овај форум';
$string['subscribed'] = 'Учлањени';
$string['subscribeenrolledonly'] = 'Опростите, само корисници уписани на неки од курсева имају дозволу да се пријаве да примају поруке са форума е-поштом.';
$string['subscribenone'] = 'Одјави све кориснике са овог форума';
$string['subscribers'] = 'Чланови';
$string['subscribersto'] = 'Чланови на \'{$a}\'';
$string['subscribestart'] = 'Пошаљите ми обавештења о новим порукама на овом форуму';
$string['subscribestop'] = 'Не желим да добијам обавештења о новим порукама на овом форуму';
$string['subscription'] = 'Пријава';
$string['subscriptionandtracking'] = 'Пријава и праћење';
$string['subscriptionauto'] = 'Аутоматска пријава';
$string['subscriptiondisabled'] = 'Пријава је онемогућена';
$string['subscriptionforced'] = 'Обавезна пријава';
$string['subscription_help'] = 'Када сте пријављени на неки форум то значи да ћете примати обавештења о новим порукама на форуму. Најчешће можете да изаберете да ли желите да се пријавите на форум. Међутим, понекад предавач може подесити да пријава буде обавезна. У том случају сви корисници ће примати обавештења.';
$string['subscriptionmode'] = 'Начин пријаве';
$string['subscriptionmode_help'] = 'Када је корисник пријављен на форум, то значи да ће добијати обавештења о порукама на форуму.
Постоје 4 могућа начина за претплату:

* Опциона пријава - корисници могу да изаберу да ли желе да буду претплаћени на форум или не
* Обавезна претплата - сви корисници су претплаћени и не могу се одјавити
* Аутоматска претплата - сви корисници су иницијално претплаћени али, уколико желе, могу да изаберу да се одјаве у било ком тренутку
* Претплата онемогућена - претплата на форум није дозвољена

Напомена: Било која промена начина претплате ће имати дејство само на нове кориснике коју ће се после ње уписати на курс, не и на постојеће кориснике.';
$string['subscriptionoptional'] = 'Опциона пријава';
$string['subscriptions'] = 'Пријаве';
$string['thisforumisthrottled'] = 'Овај форум има ограничење у броју порука које можете послати у датом временском периоду - тренутно је ово ограничење подешено на {$a->blockafter} порука унутар {$a->blockperiod}';
$string['timedposts'] = 'Временски одређени постови';
$string['timestartenderror'] = 'Крај приказа не може бити подешен на датум ранији од почетка приказа';
$string['trackforum'] = 'Прати непрочитане поруке';
$string['tracking'] = 'Прати';
$string['trackingoff'] = 'Искључено';
$string['trackingon'] = 'Обавезно';
$string['trackingoptional'] = 'Опционо';
$string['trackingtype'] = 'Праћење прочитаних/непрочитаних порукана';
$string['trackingtype_help'] = 'Ако је ово подешавање омогућено, учесници могу да прате прочитане и непрочитане поруке на форуму и унутар дискусија. Постоје три могућности:

* Опционо - учесници могу да изаберу да ли ће укључити или искључити праћење прочитаних и непрочитаних порука путем линка у блоку за администрацију
* Обавезно - праћење је увек укључено, без обзира на подешавања корисника. Опција је доступна зависно од подешавања администратора.
* Искључено -  прочитане и непрочитане поруке се не прате';
$string['unread'] = 'Непрочитано';
$string['unreadposts'] = 'Непрочитане поруке';
$string['unreadpostsnumber'] = 'Број непрочитаних порука: {$a}';
$string['unreadpostsone'] = '1 непрочитана порука';
$string['unsubscribe'] = 'Одјавите се са овог форума';
$string['unsubscribeall'] = 'Одјавите се са свих форума';
$string['unsubscribeallconfirm'] = 'Тренутно сте пријављени на {$a} форум(а). Да ли заиста желите да се одјавите са свих форума и да искључите аутоматску пријаву на форуме?';
$string['unsubscribealldone'] = 'Све опционе пријаве на форуме су поништене. Још увек ћете примати обавештења са форума на којима је пријава обавезна. Да бисте детаљније подесили опције везане за поруке које ћете примати одаберите опцију Поруке међу онима које се нуде при подешавању корисничког профила.';
$string['unsubscribeallempty'] = 'Нисте пријављени ни на један форум. Ако не желите више да добијате е-поруке са овог сервера одаберите опцију Поруке међу онима које се нуде при подешавању корисничког профила.';
$string['unsubscribed'] = 'Одјављени сте са овог форума';
$string['unsubscribeshort'] = 'Одјави се';
$string['usermarksread'] = 'Ручно обележавање прочитаних порука';
$string['viewalldiscussions'] = 'Погледај све дискусије';
$string['warnafter'] = 'Гранична вредност броја порука за слање упозорења';
$string['warnafter_help'] = '<p>Полазници могу бити упозорени када се приближе максималном броју порука дозвоњених у датом временском периоду. Ово подешавање одређује након колико порука ће бити упозорени.</p>

<p>Корисници са овлашћењем mod/forum:postwithoutthrottling су изузети од овог ограничења.</p>';
$string['warnformorepost'] = 'Упозорење! Постоји више од једне дискусије на овом форуму - користите најновију';
$string['yournewquestion'] = 'Ваше ново питање';
$string['yournewtopic'] = 'Ваша нова тема за дискусију';
$string['yourreply'] = 'Ваш одговор';
