<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   auth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Доступни додаци за проверу идентитета';
$string['alternatelogin'] = 'Ако овде унесете URL, биће коришћен као страница за пријаву на овај сајт. Страница би требала садржати форму са акцијском опцијом подешеном на <strong>\'{$a}\'</strong> и враћањем поља <strong>username</strong> i <strong>password</strong>.<br />Будите опрезни да не бисте случајно унели погрешан URL и тиме сами себи онемогућили приступ сајту.<br />Оставите ово подешавање празно да бисте користили подразумевану страницу за приступ систему.';
$string['alternateloginurl'] = 'Алтернативна URL адреса за пријаву на систем';
$string['auth_changepasswordhelp'] = 'Промена помоћи за лозинку';
$string['auth_changepasswordhelp_expl'] = 'Приказ помоћи за случај изгубљене лозинке корисницима који су изгубили своју {$a} лозинку. То ће бити приказано или исто као или уместо <strong>URL-a за промену лозинке</strong> или интерне промене Moodle лозинке.';
$string['auth_changepasswordurl'] = 'URL за промену лозинке';
$string['auth_changepasswordurl_expl'] = 'Специфицирајте URL који ће се слати корисницима који изгубе своје {$a} лозинке. Подесите<strong>Користити стандардну страницу за промену лозинке</strong> на <strong>Не</strong>.';
$string['auth_changingemailaddress'] = 'Затражили сте да стару адресе е-поште  {$a->oldemail} промените у нову {$a->newemail}. Из  разлога безбедности, шаљемо вам е-поруку на нову адресу како би потврдили да она заиста припада вама. Ваша адреса е-поште биће ажурирана чим отворите URL која вам је послат у тој поруци.';
$string['auth_common_settings'] = 'Општа подешавања';
$string['auth_data_mapping'] = 'Мапирање података';
$string['authenticationoptions'] = 'Опције за проверу идентитета';
$string['auth_fieldlock'] = 'Закључавање вредности';
$string['auth_fieldlock_expl'] = '<p><b>Закључавање вредности:</b> Ако је омогућено, спречиће Moodle кориснике и администраторе да директно уређују поље. Користите ову опцију ако одржавате ове податке у екстерном аутентикационом систему. </p>';
$string['auth_fieldlocks'] = 'Закључавање корисничких поља';
$string['auth_fieldlocks_help'] = '<p>Можете закључати поља са корисничким подацима. То је корисно за сајтове на којима корисничке податке ручно одржавају администратори уређивањем корисничких записа у бази података или постављањем података коришћењем опције  \'Постављање корисника\'. Ако закључавате поља која су неопходна за рад Moodle система, проверите да ли сте, приликом креирања корисничких налога, попунили та поља одговарајућим подацима, јер се у супротном налози неће моћи користити.</p><p>Подесите вредност за закључавање на \'Откључано ако је празно\' да бисте избегли наведени проблем.</p>';
$string['authinstructions'] = 'Оставите ово поље празно ако желите да се корисницима приказују подразумеване инструкције за пријаву на систем на насловној страни. Ако желите да им понудите неке посебне инструкције унесите их овде.';
$string['auth_invalidnewemailkey'] = 'Грешка: ако покушавате да потврдите промену адресе е-поште, можда сте направили грешку при копирању URL адресе коју смо вам послали путем е-поште. Молимо, копирајте адресу и покушајте поново.';
$string['auth_multiplehosts'] = 'Одређивање више домаћина или адреса (нпр. host1.com;host2.com;host3.com) или (npr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_outofnewemailupdateattempts'] = 'Потрошили сте дозвољени број покушаја за промену адресе е-поште. Ваш захтев за промену је одбијен.';
$string['auth_passwordisexpired'] = 'Ваша лозинка је истекла. Да ли желите да је промените сада?';
$string['auth_passwordwillexpire'] = 'Ваша лозинка истиче за {$a} дан/а.  Да ли желите да је промените сада?';
$string['auth_remove_delete'] = 'Потпуно брисање интерних података';
$string['auth_remove_keep'] = 'Задржавање интерних података';
$string['auth_remove_suspend'] = 'Обустављање интерних података';
$string['auth_remove_user'] = 'Одредите шта радити са унутрашњим корисничким налогом за време масовне синхронизације када је корисник уклоњен од стране спољног извора. Само обустављени корисници се аутоматски обнављају ако се поново појављују у спољном извору.';
$string['auth_remove_user_key'] = 'Уклоњен спољни корисник';
$string['auth_sync_script'] = 'Скрипта синхронизације крона';
$string['auth_updatelocal'] = 'Ажурирање локалних података';
$string['auth_updatelocal_expl'] = '<p><b>Ажурирање локалних података:</b> Ако је омогућено, поље ће бити ажурирано (користи се екстерни auth) сваки пут када корисник приступи систему или дође до корисничке синхронизације. Поља за која је подешено локално ажурирање би требала бити закључана.</p>';
$string['auth_updateremote'] = 'Ажурирање екстерних података';
$string['auth_updateremote_expl'] = '<p><b>Ажурирање екстерних података:</b> Ако је омогућено, екстерни auth ће бити ажуриран при ажурирању записа о корисницима. Поља би требала бити откључана да би се дозволиле промене.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Напомене:</b> Ажурирање екстерних LDAP података захтева да подесите повезивање binddn и bindpw за bind-корисника са привилегијама кориговања свих корисничких записа. Ово тренутно не чува вишевредносне атрибуте и уклониће додатне вредности надоградње.</p>';
$string['auth_user_create'] = 'Омогућити креирање корисника';
$string['auth_user_creation'] = 'Нови (анонимни) корисници могу направити корисничке налоге на спољашњем извору за проверу идентитета и извршити потврду путем е-поште. Ако омогућите ову опцију, конфигуришите и специфичне опције модула које служе за креирање корисника.';
$string['auth_usernameexists'] = 'Одабрано корисничко име већ постоји. Молимо изаберите друго корисничко име.';
$string['auto_add_remote_users'] = 'Аутоматско додавање удаљених корисника';
$string['changepassword'] = 'URL за промену лозинке';
$string['changepasswordhelp'] = 'Овде можете навести локацију на којој ваши корисници могу обновити или променити своје корисничко име/лозинку, у случају да су их заборавили.
Ова опција се може понудити корисницима у виду дугмета на страници за приступ систему, као и на њиховој корисничкој страници. Ако оставите празно поље, дугме неће бити приказано.';
$string['chooseauthmethod'] = 'Изаберите начин провере идентитета';
$string['chooseauthmethod_help'] = 'Ово подешавање одређује начин провере идентитета који се користи када се корисник пријављује на систем. Треба да одаберете само додатке за проверу идентитет који су укључени, у супротном корисници неће више моћи да се пријаве. Да бисте блокирали будуће пријаве неког корисника, одаберите \'Нема пријаве\'.';
$string['createpassword'] = 'Генериши лозинку и обавести корисника';
$string['createpasswordifneeded'] = 'Креирање лозинке ако је то потребно';
$string['emailchangecancel'] = 'Поништи промену електронске адресе';
$string['emailchangepending'] = 'Промена на чекању. Отворите линк који Вам је послата на {$a->preference_newemail}.';
$string['emailnowexists'] = 'Адреса е-поште коју сте покушали да доделите Вашем профилу је већ додељенљ другом кориснику. Зато је Ваш захтев за промену електорнске адресе поништен, али можете покушати са другом адресом.';
$string['emailupdate'] = 'Ажурирање електронске адресе';
$string['emailupdatemessage'] = 'Драги/а {$a->fullname},

Тражили сте промену своје е-адресе за Ваш кориснички налог на {$a->site}. Молимо Вас да отворите следећи URL у свом веб читачу како бисте потврдили ову промену.

{$a->url}';
$string['emailupdatesuccess'] = 'Е-адреса корисника <em>{$a->fullname}</em> је успешно промењена у <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Потврда ажурирања е-адресе на {$a->site}';
$string['enterthenumbersyouhear'] = 'Унесите број који чујете';
$string['enterthewordsabove'] = 'Унесите реч изнад';
$string['errormaxconsecutiveidentchars'] = 'Максималан број истоветних карактера за редом које мора садржати лозинка је: {$a}';
$string['errorminpassworddigits'] = 'Минималан број цифара који лозинка мора садржати је: {$a}.';
$string['errorminpasswordlength'] = 'Минималан број карактера који лозинка мора садржати је: {$a}.';
$string['errorminpasswordlower'] = 'Минималан број малих слова који лозинка мора садржати је: {$a}.';
$string['errorminpasswordnonalphanum'] = 'Минималан број карактера који нису алфанумерички који лозинка мора садржати је: {$a}.';
$string['errorminpasswordupper'] = 'Минималан број великих слова који лозинка мора садржати је: {$a}.';
$string['errorpasswordupdate'] = 'Грешка у ажурирању лозинке, лозинка није промењена.';
$string['event_user_loggedin'] = 'Корисник се пријавио';
$string['eventuserloggedinas'] = 'Корисник пријављен као други корисник';
$string['forcechangepassword'] = 'Обавезна промена лозинке';
$string['forcechangepasswordfirst_help'] = 'Обавезна промена лозинке за све кориснике при њиховом првом приступу Moodle систему';
$string['forcechangepassword_help'] = 'Обавезна промена лозинке за све кориснике при њиховом следећем приступу Moodle систему';
$string['forgottenpassword'] = 'Уколико овде унесете URL адресу, она ће бити коришћена за страницу за обнављање заборављене лозинке, на овом сајту. Ово је намењено сајтовима на којима се лозинкама, у потпуности, управља изван Moodlea. Оставите ово поље празно да бисте користили уобичајени начин за обнављање лозинке.';
$string['forgottenpasswordurl'] = 'URL адреса за обнављање заборављене лозинке';
$string['getanaudiocaptcha'] = 'Преузмите звучни CAPTCHA';
$string['getanimagecaptcha'] = 'Преузмите CAPTCHA слику';
$string['getanothercaptcha'] = 'Преузмите други CAPTCHА';
$string['guestloginbutton'] = 'Дугме за пријаву гостију';
$string['incorrectpleasetryagain'] = 'Неисправно. Молимо покушајте поново';
$string['infilefield'] = 'Поље захтевано у датотеци';
$string['informminpassworddigits'] = 'минималан број цифара: {$a}';
$string['informminpasswordlength'] = 'минималан број знакова: {$a}';
$string['informminpasswordlower'] = 'минималан број малих слова: {$a}';
$string['informminpasswordnonalphanum'] = 'минималан број неалфанумеричких знакова: {$a}';
$string['informminpasswordupper'] = 'минималан број великих слова: {$a}';
$string['informpasswordpolicy'] = 'Лозинка мора имати {$a}';
$string['instructions'] = 'Упутства';
$string['internal'] = 'Интерно';
$string['locked'] = 'Закључано';
$string['md5'] = 'MD5 хеш';
$string['nopasswordchange'] = 'Није могуће променити лозинку';
$string['nopasswordchangeforced'] = 'Нисте у могућности да наставите даље без промене корисничког имена, међутим не постоји расположива страница за промену. Молимо контактирајте Moodle администратора.';
$string['noprofileedit'] = 'Није могуће уређивати профил';
$string['ntlmsso_attempting'] = 'Покушава се SSO (Single Sign On) преко NTLM...';
$string['ntlmsso_failed'] = 'Аутоматско пријављивање није успело, покушајте са обичном страницом за пријаву...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO (јединствена пријава) није укључена.';
$string['passwordhandling'] = 'Управљење пољем лозинке';
$string['plaintext'] = 'Обичан текст';
$string['pluginnotenabled'] = 'Додатак за проверу идентитета \'{$a}\' није оспособљен.';
$string['pluginnotinstalled'] = 'Додатак за проверу идентитета \'{$a}\' није инсталиран.';
$string['potentialidps'] = 'Пријавите се користећи свој налог на:';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA служи за спречавање злоупотребу од стране аутоматизованих програма. Само унесите у оквир речи које видите, редом којим су написане и одвојите их размаком.

Ако нисте сигурни које су то речи, можете да затражите нови CAPTCHA или да послушате звучни CAPTCHA.';
$string['selfregistration'] = 'Саморегистрација';
$string['selfregistration_help'] = 'Ако је одабран додатак за проверу идентитета, као што је самостална регистрација помоћу е-поште, онда ће ово омогућити потенцијалним корисницима да се сами региструју и креирају корисничке налоге. Ово за последицу има могућност да спамери креирају корисничке налоге како би користили форуме, блог чланке и слично за слање нежељених порука. Како бисте избегли овај ризик, самостална регистрација треба да буде онемогућена или ограничена помоћу подешавања <em>Дозвољени домени е-поште</em>.';
$string['sha1'] = 'SHA-1 хеш';
$string['showguestlogin'] = 'Можете сакрити или приказати дугме за пријаву гостију на пријавној страници.';
$string['stdchangepassword'] = 'Користи стандардну страницу за промену лозинке';
$string['stdchangepassword_expl'] = 'Ако спољашњи систем за проверу идентитета дозвољава промену лозинке из Moodle система, укључите га. Ово подешавање заобилази \'URL за промену лозинке\'.';
$string['stdchangepassword_explldap'] = 'Напомена: Препоручује се да користите LDAP пре него SSL шифровање тунела (ldaps://) ако је LDAP сервер удаљен.';
$string['suspended'] = 'Суспендовани налог';
$string['suspended_help'] = 'Корисници којима је суспендован налог не могу да се пријаве на систем или да користе веб сервисе, нити им се шаљу поруке са система.';
$string['testsettings'] = 'Подешавања теста';
$string['testsettingsheading'] = 'Подешавања  теста за проверу  идентитета  - {$a}';
$string['unlocked'] = 'Откључано';
$string['unlockedifempty'] = 'Откључано ако је празно';
$string['update_never'] = 'Никад';
$string['update_oncreate'] = 'При креирању';
$string['update_onlogin'] = 'При сваком приступу систему';
$string['update_onupdate'] = 'При ажурирању';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() не подржава изабрани тип корисника: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_activate() не подржава изабрани тип корисника (...још)';
