<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Имате задатке на које треба обратити пажњу';
$string['addattempt'] = 'Дозволите други покушај';
$string['addnewattempt'] = 'Додај нови покушај';
$string['addnewattemptfromprevious'] = 'Додај нови покушај на основу претходно предатог рада';
$string['addnewattemptfromprevious_help'] = 'Ово ће копирати садржај вашег претходног рада у нови како бисте могли да радите на њему.';
$string['addnewattempt_help'] = 'Ово ће креирати нови празан рад како бисте могли да радите на њему';
$string['addsubmission'] = 'Додај рад';
$string['allocatedmarker'] = 'Додељени оцењивач';
$string['allocatedmarker_help'] = 'Оцењивач који је додељен за овај рад';
$string['allowsubmissions'] = 'Дозволи кориснику да настави  предају радова на овај задатак';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Детаљније информације о задатку и образац за предају радова биће доступни од <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Дозволи предају од';
$string['allowsubmissionsfromdate_help'] = 'Ако је ова опција омогућена полазницинеће моћи да предају рад пре овог датума. Ако је онемогућена, полазници ће одмах моћи да предају рад.';
$string['allowsubmissionsfromdatesummary'] = 'Овај задатак ће прихватити предају рада од <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Дозволи промене предатог рада';
$string['alwaysshowdescription'] = 'Увек прикажи опис';
$string['alwaysshowdescription_help'] = 'Ако је ова опција омогућена, \'Опис задатка\' ће постати видљив полазницима тек од датума наведеног за подешавање "Дозволи предају од"';
$string['applytoteam'] = 'Примените оцене и повратне информације на целу групу';
$string['assign:addinstance'] = 'Додај нови задатак';
$string['assign:exportownsubmission'] = 'Извоз сопственог рада';
$string['assignfeedback'] = 'Додатак за повратне информације';
$string['assignfeedbackpluginname'] = 'Додатак за повратне информације';
$string['assign:grade'] = 'Оцењивање задатка';
$string['assign:grantextension'] = 'Одобри продужетак';
$string['assign:manageallocations'] = 'Управљање оцењивачима додељеним предатим радовима';
$string['assign:managegrades'] = 'Прегледај и објави оцене';
$string['assignmentisdue'] = 'Крајњи рок за предају је истекао';
$string['assignmentmail'] = '{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\'

Повратне информације су придружене вашем раду и можете их погледати  на:

{$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'<i>{$a->assignment}</i>\'.</p>
<p>Повратне информације можете погледати придружене вашем <a href="{$a->url}">раду</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\' . Повратне информације можете погледати придружене вашем раду.';
$string['assignmentname'] = 'Назив задатка';
$string['assignmentplugins'] = 'Додаци за задатак';
$string['assignmentsperpage'] = 'Задаци по страници';
$string['assign:releasegrades'] = 'Објави оцене';
$string['assign:revealidentities'] = 'Откриј идентитет студената';
$string['assign:reviewgrades'] = 'Прегледај оцене';
$string['assignsubmission'] = 'Додатак за предају рада';
$string['assignsubmissionpluginname'] = 'Додатак за предају рада';
$string['assign:submit'] = 'Predaj rad';
$string['assign:view'] = 'Прегледај задатак';
$string['attemptheading'] = 'Покушај {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Претходни покушаји';
$string['attemptnumber'] = 'Број покушаја';
$string['attemptreopenmethod'] = 'Поновно отварање рада';
$string['attemptreopenmethod_help'] = 'Ово подешавање одређује како се студентски радови поново отварају. Доступне су следеће опције:
 <ul>
<li>Никад - рад студента не може да се отвара поново.</li>
<li>Ручно - предавач може поново да отвори рад студента./li>
<li>Аутоматски док не добије прелазну оцену - рад се аутоматски поново отвара све док студент, за овај задатак,  не постигне прелазну оцену која је подешена у књизи оцена (секција категорија и ставки).</li>
</ul>';
$string['attemptreopenmethod_manual'] = 'Ручно';
$string['attemptreopenmethod_none'] = 'Никад';
$string['attemptreopenmethod_untilpass'] = 'Аутоматски док не добије прелазну оцену';
$string['attemptsettings'] = 'Подешавања покушаја';
$string['availability'] = 'Доступност';
$string['backtoassignment'] = 'Назад на задатак';
$string['batchoperationconfirmaddattempt'] = 'Дозволите још један покушај за изабране радове?';
$string['batchoperationconfirmgrantextension'] = 'Одобрити продужење рока свим изабраним радовима?';
$string['batchoperationconfirmlock'] = 'Закључајте све изабране предате радове?';
$string['batchoperationconfirmreverttodraft'] = 'Вратите изабране радове у статус нацрта?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Доделите оцењивача за све изабране предате радове?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Подесити стање тока оцењивања за све изабране радове?';
$string['batchoperationconfirmunlock'] = 'Одкључајте све изабране предате радове?';
$string['batchoperationlock'] = 'закључај предате радове';
$string['batchoperationreverttodraft'] = 'вратите предате радове у статус нацрта';
$string['batchoperationsdescription'] = 'Са изабранима...';
$string['batchoperationunlock'] = 'откључај предате радове';
$string['batchsetallocatedmarker'] = 'Додели оцењивача за следећи број одабраних корисника: {$a} .';
$string['batchsetmarkingworkflowstateforusers'] = 'Подеси стање тока оцењивања за следећи број изабраних корисника: {$a}.';
$string['blindmarking'] = 'Слепо оцењивање';
$string['blindmarking_help'] = 'Слепо оцењивање скрива од оцењивача идентитета студената. Подешавања за слепо оцењивање биће закључана оног тренутка када рад буде предат или када буде оцењен.';
$string['changegradewarning'] = 'Овај задатак садржи оцењене предате радове па промена оцене неће аутоматски поново израчунати постојеће оцене радова. Морате поново оценити све постојеће радове ако желите да промените оцену.';
$string['choosegradingaction'] = 'Акција оцењивања';
$string['choosemarker'] = 'Изабери...';
$string['chooseoperation'] = 'Изаберите операцију';
$string['comment'] = 'Коментар';
$string['completionsubmit'] = 'Студент мора да преда ову активност како би је завршио';
$string['configshowrecentsubmissions'] = 'Сви могу да виде обавештење о предатим радовима у извештају о скорашњим активностима.';
$string['confirmbatchgradingoperation'] = 'Да ли сте сигурни да желите да {$a->operation}  за {$a->count} полазника?';
$string['confirmsubmission'] = 'Да ли сте сигурни да желите да  предате свој рад на оцењивање? Више нећете моћи да га мењате.';
$string['conversionexception'] = 'Није могуће конвертовати рад. Изузетак је гласио: {$a}.';
$string['couldnotconvertgrade'] = 'Није могуће конвертовати оцену задатка за корисника {$a}.';
$string['couldnotconvertsubmission'] = 'Није могуће конвертовати предати рад за корисника {$a}.';
$string['couldnotcreatecoursemodule'] = 'Није могуће креирати модул курса';
$string['couldnotcreatenewassignmentinstance'] = 'Није могуће креирати нову инстанцу задатка';
$string['couldnotfindassignmenttoupgrade'] = 'Није могуће наћи стару инстанцу задатка за надоградњу';
$string['currentattempt'] = 'Ово је покушај {$a}.';
$string['currentattemptof'] = 'Ово је покушај {$a->attemptnumber} ( {$a->maxattempts} дозвољена/их покушаја ).';
$string['currentgrade'] = 'Тренутна оцена у књизи оцена';
$string['cutoffdate'] = 'Дефинитивни рок';
$string['cutoffdatefromdatevalidation'] = 'Дефинитивни рок за предају мора бити након датума од ког је дозвољена предаја рада.';
$string['cutoffdate_help'] = 'Ако је подешен овај датум, након њега неће бити могуће предати рад без продужетка рока за предају.';
$string['cutoffdatevalidation'] = 'Дефинитивни рок не може бити пре крајњег рока за предају рада.';
$string['defaultsettings'] = 'Подразумевана подешавања задатка';
$string['defaultsettings_help'] = 'Ова подешавања дефинишу подразмеване вредности за све нове задатке';
$string['defaultteam'] = 'Подразумевана група';
$string['deleteallsubmissions'] = 'Обриши све предате радове';
$string['description'] = 'Опис';
$string['downloadall'] = 'Преузми све предате радове';
$string['duedate'] = 'Крајњи рок';
$string['duedate_help'] = 'Овај датум представља крајњи рок за предају задатка. Предаја након овог датума ће и даље бити дозвољена, али ће сви радови предати након овог датума бити обележени као закаснели. Да бисте спречили предају радова након одређеног датума - подесите дефинитивни рок за предају рада.';
$string['duedateno'] = 'Нема крајњег рока';
$string['duedatereached'] = 'Крајњи рок за овај задатак је сада истекао';
$string['duedatevalidation'] = 'Крајњи рок мора бити након датума од којег је дозвољена предаја';
$string['editaction'] = 'Акције...';
$string['editattemptfeedback'] = 'Уреди оцену и повратне информације за покушај број {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Уређујете повратне информације за претходни покушај. Ово је покушај {$a->attemptnumber} од укупно {$a->totalattempts}.';
$string['editingstatus'] = 'Статус уређивања';
$string['editsubmission'] = 'Уреди рад';
$string['editsubmission_help'] = 'Направите промене у свом раду';
$string['enabled'] = 'Омогућено';
$string['errornosubmissions'] = 'Нема предатих радова за преузимање';
$string['errorquickgradingvsadvancedgrading'] = 'Оцене нису сачуване зато што овај задатак тренутно користи напредно оцењивање';
$string['errorrecordmodified'] = 'Оцене нису сачуване зато што је неко изменио један или више записа након што сте учитали страницу';
$string['event_all_submissions_downloaded'] = 'Сви предати радови се преузимају.';
$string['event_assessable_submitted'] = 'Рад је предат.';
$string['event_extension_granted'] = 'Продужење је одобрено.';
$string['event_identities_revealed'] = 'Идентитети су откривени.';
$string['event_marker_updated'] = 'Додељени оцењивач је ажуриран.';
$string['event_statement_accepted'] = 'Корисник је прихватио изјаву о предаjи рада.';
$string['event_submission_duplicated'] = 'Корисник је предао дупликат свог рада.';
$string['event_submission_graded'] = 'Предати рад је оцењен.';
$string['event_submission_locked'] = 'Предати радови су закључани за корисника.';
$string['event_submission_status_updated'] = 'Статус предатог рада је ажуриран.';
$string['event_submission_unlocked'] = 'Предати радови су откључани за корисника.';
$string['event_submission_updated'] = 'Корисник је сачувао предати рад.';
$string['event_workflow_state_updated'] = 'Стање тока оцењивања је ажурирано.';
$string['extensionduedate'] = 'Продужени рок';
$string['extensionnotafterduedate'] = 'Продужени рок мора бити након крајњег рок за предају рада.';
$string['extensionnotafterfromdate'] = 'Продужени рок мора бити након датумa од ког је дозвољена предаја решења.';
$string['feedback'] = 'Повратне информације';
$string['feedbackavailablehtml'] = '{$a->username} је послао/ла повратне информације на рад који сте предали за задатак  \'<i>{$a->assignment}</i>\'<br /><br /> Повратне информације можете погледати придружене вашем <a href="{$a->url}">предатом раду</a>.';
$string['feedbackavailablesmall'] = '{$a->username} је дао/ла повратне информације за задатак {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\'

Повратне информације су придружене вашем раду и можете их погледати  на:

{$a->url}';
$string['feedbackplugin'] = 'Додатак за повратне информације';
$string['feedbackpluginforgradebook'] = 'Додатак за повратне информације који ће пребацивати коментаре у књигу оцена';
$string['feedbackpluginforgradebook_help'] = 'Само један додатак за повратне информације задатка може да пребаци повратне информације у књигу оцена.';
$string['feedbackplugins'] = 'Додаци за повратне информације';
$string['feedbacksettings'] = 'Подешавања повратних информација';
$string['feedbacktypes'] = 'Врсте повратних информација';
$string['filesubmissions'] = 'Предаја датотека';
$string['filter'] = 'Филтер';
$string['filternone'] = 'Нема филтера';
$string['filterrequiregrading'] = 'Захтева оцењивање';
$string['filtersubmitted'] = 'Предато';
$string['gradeabovemaximum'] = 'Оцена мора да буде мања од или једнака {$a}';
$string['gradebelowzero'] = 'Оцена мора бити већа од или једнака нули';
$string['gradecanbechanged'] = 'Оцена може бити промењена';
$string['graded'] = 'Оцењено';
$string['gradedby'] = 'Оценио/ла';
$string['gradedon'] = 'Оцењено';
$string['gradelocked'] = 'Ова оцена је закључана или преписана у књизи оцена.';
$string['gradeoutof'] = 'Оцена од {$a}';
$string['gradeoutofhelp'] = 'Оцена';
$string['gradeoutofhelp_help'] = 'Овде унесите оцену за рад полазника. Можете укључити децимале.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} је ажурирао/ла своје решење задатка <i>\'{$a->assignment}\' у  {$a->timeupdated}</i><br /><br />
Решење је <a href="{$a->url}">доступно на веб сајту</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} је ажурирао/ла свој рад за задатак за задатак {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} је ажурирао/ла свој рад за задатак \'{$a->assignment}\' у  {$a->timeupdated}

Рад је доступно на следећој адреси:

{$a->url}';
$string['gradestudent'] = 'Оцени полазника: (id={$a->id}, име и презим={$a->fullname}).';
$string['gradeuser'] = 'Оцена {$a}';
$string['grading'] = 'Оцењивање';
$string['gradingchangessaved'] = 'Промене оцена су сачуване';
$string['gradingmethodpreview'] = 'Критеријуми оцењивања';
$string['gradingoptions'] = 'Опције';
$string['gradingstatus'] = 'Статус оцењивања';
$string['gradingstudent'] = 'Оцењивање студента';
$string['gradingsummary'] = 'Резиме оцењивања';
$string['grantextension'] = 'Одобри продужетак';
$string['grantextensionforusers'] = 'Одобри продужетак за {$a} студен(а)та';
$string['groupsubmissionsettings'] = 'Подешавања за групну предају рада';
$string['hiddenuser'] = 'Учесник';
$string['hideshow'] = 'Сакриј/Прикажи';
$string['instructionfiles'] = 'Датотеке са инструкцијама';
$string['invalidfloatforgrade'] = 'Није могуће разумети оцену која је дата: {$a}';
$string['invalidgradeforscale'] = 'Оцена која је дата није исправна за текућу скалу';
$string['lastmodifiedgrade'] = 'Последње измене (оцена)';
$string['lastmodifiedsubmission'] = 'Последње измене (предати рад)';
$string['latesubmissions'] = 'Касно предати радови';
$string['latesubmissionsaccepted'] = 'Само студент/и којима је дат додатни рок могу да предају рад';
$string['locksubmissionforstudent'] = 'Спречи даљу предају радова за полазника: (id={$a->id}, fиме и презиме={$a->fullname}).';
$string['locksubmissions'] = 'Закључај предате радове';
$string['manageassignfeedbackplugins'] = 'Управљање додацима за повратне информације';
$string['manageassignsubmissionplugins'] = 'Управљање додацима за предају радова';
$string['marker'] = 'Оцењивач';
$string['markerfilter'] = 'Филтер оцењивача';
$string['markingallocation'] = 'Користи расподелу оцењивања';
$string['markingallocation_help'] = 'Ако је ово подешавање омогућено, заједно са током оцењивања, оцењивачима могу бити додељени  поједини студенти.';
$string['markingworkflow'] = 'Користи ток цењивања';
$string['markingworkflow_help'] = 'Ако је ово подешавање омогућено, оцене ће проћи кроз низ фаза у процесу оцењивања пре него што буду објављене студентима. Ово омогућава више кругова оцењивања, као и да оцене буду објављене студентима истовремено.';
$string['markingworkflowstate'] = 'Стање тока оцењивања';
$string['markingworkflowstate_help'] = 'Могућа стања  тока оцењивања могу да обухвате (зависно од ваших овлашћења):

* Неоцењено - оцењивач још није започео оцењивање
* Оцењује се - оцењивач је започео оцењивање али га још није завршио
* Оцењивање завршено . оцењивач је завршио оцењивање,  али је можда потребно да се врати због провере/исправки
* На прегледу - оцењивање је сада код надлежног наставника одговорног за проверу квалитета
* Спремно за објављивање - надлежни наставник је задовољан са оцењивањем али чека пре него што студентима дозволи приступ оценама
* Објављено - студенти могу да приступе оценама/повратним информацијама';
$string['markingworkflowstateinmarking'] = 'Оцењује се';
$string['markingworkflowstateinreview'] = 'На прегледу';
$string['markingworkflowstatenotmarked'] = 'Није оцењено';
$string['markingworkflowstatereadyforrelease'] = 'Спремно за објаву';
$string['markingworkflowstatereadyforreview'] = 'Оцењивање завршено';
$string['markingworkflowstatereleased'] = 'Објављено';
$string['maxattempts'] = 'Максималан број покушаја';
$string['maxattempts_help'] = 'Максималан број дозвољених покушаја предаје рада од стране студента. Након овог броја покушаја студентов рад више неће моћи да се поново отвори.';
$string['maxgrade'] = 'Максимална оцена';
$string['messageprovider:assign_notification'] = 'Обавештење о задатку';
$string['modulename'] = 'Задатак';
$string['modulename_help'] = 'Модул активности "Задатак"  пружа могућност наставнику да полазницима  задаје задатке, прикупља њихове радове, оцењује их, као и да им  шаље повратне информације.

Полазници, као свој рад, могу да предају различите дигиталне садржаје (датотеке), као што су текстуални документи, прорачунске табеле, слике, презентације или аудио и видео клипови. Алтернативно, или као додатак претходном, задатак може да тражи од полазника да текст унесу директно у текст едитор. Задатак, такође, може да се користи као подсетник полазницима за „стварни“ задатак који морају да ураде „офлајн“, ван сајта, попут  рецимо неког уметничког рада, цртежа итд, а да се при томе од њих не захтева слање било каквог дигиталног садржаја. Полазници могу да предају рад индивидуално или као чланови групе.

Приликом прегледања задатака, наставници могу да остављају коментаре, повратне информације и постављају датотеке, као што су прегледани и  обележени радови полазника са коментарима, засебни докуменати са коментарима или повратне информације у говорном тј. аудио формату. Задаци се оцењује бројчаном,  или наменски прилагођеном, скалом за оцењивање, или, коришћењем напредних метода оцењивања као што су рубрике. Завршне оцене се записују у књигу оцена.';
$string['modulenameplural'] = 'Задаци';
$string['moreusers'] = 'још {$a}...';
$string['mysubmission'] = 'Моји предати радови';
$string['newsubmissions'] = 'Задаци су предати';
$string['noattempt'] = 'Нема покушаја';
$string['nofiles'] = 'Нема датотека';
$string['nograde'] = 'Нема оцене';
$string['nolatesubmissions'] = 'Не прихвата се закаснела преда радова.';
$string['nomoresubmissionsaccepted'] = 'Закаснела предаја радова се више не прихвата';
$string['noonlinesubmissions'] = 'Овај задатак не тражи од вас да било штa предате  онлајн';
$string['nosavebutnext'] = 'Следећи';
$string['nosubmission'] = 'За овај задатак још ништа није предато';
$string['nosubmissionsacceptedafter'] = 'Решења се не прихватају после';
$string['notgraded'] = 'Није оцењено';
$string['notgradedyet'] = 'Још није оцењено';
$string['notifications'] = 'Обавештења';
$string['notsubmittedyet'] = 'Још није предато';
$string['nousersselected'] = 'Није изабран ниједан полазник';
$string['numberofdraftsubmissions'] = 'Нацрти';
$string['numberofparticipants'] = 'Учесници';
$string['numberofsubmissionsneedgrading'] = 'Тражи оцењивање';
$string['numberofsubmittedassignments'] = 'Предато';
$string['numberofteams'] = 'Групе';
$string['offline'] = 'Не тражи се онлајн предаја рада';
$string['open'] = 'Отворено';
$string['outlinegrade'] = 'Оцена: {$a}';
$string['outof'] = '{$a->current} од {$a->total}';
$string['overdue'] = '<font color="red">Крајњи рок за предају рада је истекао пре: {$a}</font>';
$string['page-mod-assign-view'] = 'Главна страница модула \'Задатак\'';
$string['page-mod-assign-x'] = 'Било која страница модула \'Задатак\'';
$string['participant'] = 'Учесник';
$string['pluginadministration'] = 'Администрација задатака';
$string['pluginname'] = 'Задатак';
$string['preventsubmissions'] = 'Спречи корисника да више не предаје своје радове за овај задатак.';
$string['preventsubmissionsshort'] = 'Спречи измене предатих радова';
$string['previous'] = 'Претходни';
$string['quickgrading'] = 'Брзо оцењивања';
$string['quickgradingchangessaved'] = 'Промене оцена су сачуване';
$string['quickgrading_help'] = 'Брзо оцењивање вам дозвољава да доделите оцене (и исходе) директно у табели предатих задатака. Брзо оцењивање није компатибилно са напредним оцењивањем и не препоручује се када постоји више оцењивача.';
$string['quickgradingresult'] = 'Брзо оцењивање';
$string['recordid'] = 'Индетификатор';
$string['requireallteammemberssubmit'] = 'Неопходна је предаја рада од стране свих чланова групе';
$string['requireallteammemberssubmit_help'] = 'Ако је ова опција омогућена сви чланови студентске групе ће морати да кликну на дугме \'Предај\' за овај задатак, пре него што групни рад буде могао да се сматра предатим. Ако је опција онемогућена, групни рад ће се сматрати предатим оног момента када било ко од чланова групе кликне на дугме \'Предај\'.';
$string['requiresubmissionstatement'] = 'Захтевај да студенти прихвате изјаву о предаји рада';
$string['requiresubmissionstatement_help'] = 'Захтевај да студенти прихвате изјаву о предаји рада за све предате радове за овај задатак.';
$string['revealidentities'] = 'Откриј идентитет студената';
$string['revealidentitiesconfirm'] = 'Да ли сте сигурни да желите да откријете идентитет студената за овај задатак? Ова операција не може бити поништена, Једном када се идентитет студената открије оцене ће бити објављене у књизи оцена.';
$string['reverttodraft'] = 'Врати предати рад у статус нацрта';
$string['reverttodraftforstudent'] = 'Врати рад у статус нацрта за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['reverttodraftshort'] = 'Врати предати рад у статус нацрта';
$string['reviewed'] = 'Прегледано';
$string['saveallquickgradingchanges'] = 'Сачувај све промене брзог оцењивања';
$string['savechanges'] = 'Сачувај промене';
$string['savegradingresult'] = 'Оцена';
$string['savenext'] = 'Сачувај и прикажи следећи';
$string['scale'] = 'Скала';
$string['selectedusers'] = 'Одабрани корисници';
$string['selectlink'] = 'Изабери...';
$string['selectuser'] = 'Изабери {$a}';
$string['sendlatenotifications'] = 'Обавести оцењиваче о радовима који су предати са закашњењем';
$string['sendlatenotifications_help'] = 'Ако је ова опција омогућена, оцењивачи (обично предавачи) ће добити поруку кад год полазник рад преда са закашњењем. Начин слања поруке се може подесити.';
$string['sendnotifications'] = 'Обавести оцењиваче о предатим радовима';
$string['sendnotifications_help'] = 'Ако је ова опција омогућена, оцењивачи (обично предавачи) ће добити поруку кад год полазник рад преда раније, на време и са закашњењем. Начин слања поруке се може подесити.';
$string['sendstudentnotifications'] = 'Обавести студенте';
$string['sendstudentnotifications_help'] = 'Ако је ова опција омогућена студенти ће примати поруку о ажурираној оцене или повратним информацијама.';
$string['sendsubmissionreceipts'] = 'Пошаљи полазницима потврду о предатом раду';
$string['sendsubmissionreceipts_help'] = 'Ово омогућава слање потврду о предатом раду. Полазници ће примити обавештење сваки пут када успешно предају рад.';
$string['setmarkerallocationforlog'] = 'Подеси доделу оцењивања : (id={$a->id}, има и презиме={$a->fullname}, оцењивач={$a->marker}).';
$string['setmarkingallocation'] = 'Подеси додељеног оцењивача';
$string['setmarkingworkflowstate'] = 'Подеси стање тока оцењивања';
$string['setmarkingworkflowstateforlog'] = 'Подеси стање тока оцењивања : (id={$a->id}, име и презиме={$a->fullname}, стање={$a->state}).';
$string['settings'] = 'Подешавања задатка';
$string['showrecentsubmissions'] = 'Прикажи скоро предате радове';
$string['status'] = 'Статус';
$string['submission'] = 'Предати рад';
$string['submissioncopiedhtml'] = '<p>Направили сте копију свог претходног рада за задатак \'<i>{$a->assignment}</i>\'.</p>
<p>Можете видети статус свог <a href="{$a->url}">предатог рада</a>.</p>';
$string['submissioncopiedsmall'] = 'Копирали сте свој претходни рад за задатак {$a->assignment}';
$string['submissioncopiedtext'] = 'Направили сте копију свог претходног рада за задатак \'{$a->assignment}\'

Можете видети статус свог предатог рада:

    {$a->url}';
$string['submissiondrafts'] = 'Захтевај да полазници кликну на дугме "Предај\'';
$string['submissiondrafts_help'] = 'Ако је ова опција омогућена полазници ће морати да кликну на дугме \'Предај\' како би свој рад прогласили коначним. Ово омогућава полазницима да унутар система чувају верзију нацрта свог рада. Ако се ово подешавање са "Не" промени на "Да" након што су полазници предали своје радове те верзије њихових радове ће бити сматране коначним.';
$string['submissioneditable'] = 'Студенти могу да уређују овај задатак';
$string['submissionempty'] = 'Ништа није предато';
$string['submissionnotcopiedinvalidstatus'] = 'Рад није копиран зато што је промењен од момента када је поново отворен.';
$string['submissionnoteditable'] = 'Студенти не могу да уређују овај задатак';
$string['submissionnotready'] = 'Овај задатак није спреман за предају радова:';
$string['submissionplugins'] = 'Додаци за предају радова';
$string['submissionreceipthtml'] = '<p>Предали сте свој рад за задатак \'<i>{$a->assignment}</i>\' </p>
<p>Можете видети статус свог <a href="{$a->url}">предатог рада</a>.</p>';
$string['submissionreceipts'] = 'Пошаљи потврду о предатом раду';
$string['submissionreceiptsmall'] = 'Предали сте свој рад за задатак {$a->assignment}';
$string['submissionreceipttext'] = 'Предали сте свој рад за задатак \'{$a->assignment}</i>\'

Можете видети статус свог рада на следећој адреси:

   {$a->url}';
$string['submissions'] = 'Предати радови';
$string['submissionsclosed'] = 'Предаја радова је затворена';
$string['submissionsettings'] = 'Подешавања за предају рада';
$string['submissionslocked'] = 'Овај задатак не прихвата предају радова';
$string['submissionslockedshort'] = 'Промене предатих радова нису дозвољено';
$string['submissionsnotgraded'] = 'Неоцењени радови: {$a}';
$string['submissionstatement'] = 'Изјава о предаји рада';
$string['submissionstatementacceptedlog'] = 'Корисник {$a} је прихватио/ла изјаву о предаји рада';
$string['submissionstatementdefault'] = 'Овај рад је искључиво мој, осим сегмената у којима је експлицитно наглашено да су коришћени резултати других људи.';
$string['submissionstatement_help'] = 'Потврдна изјава о предаји рада';
$string['submissionstatus'] = 'Статус предатог рада';
$string['submissionstatus_'] = 'Нема предатих радова';
$string['submissionstatus_draft'] = 'Нацрт рада (није предато)';
$string['submissionstatusheading'] = 'Статус предатог рада';
$string['submissionstatus_marked'] = 'Оцењено';
$string['submissionstatus_new'] = 'Нови предати рад';
$string['submissionstatus_reopened'] = 'Поново отворено';
$string['submissionstatus_submitted'] = 'Предато за оцењивање';
$string['submissionsummary'] = '{$a->status}. Последњи пут промењено {$a->timemodified}';
$string['submissionteam'] = 'Група';
$string['submissiontypes'] = 'Врста предатог рада';
$string['submitaction'] = 'Предај';
$string['submitassignment'] = 'Предај рад';
$string['submitassignment_help'] = 'Оног тренутка када предате овај рад више нећете моћи да га мењате.';
$string['submitted'] = 'Предато';
$string['submittedearly'] = 'Задатак је предат {$a} раније';
$string['submittedlate'] = 'Задатак је предат {$a} касније';
$string['submittedlateshort'] = '{$a} касније';
$string['subplugintype_assignfeedback'] = 'Додатак за повратне информације';
$string['subplugintype_assignfeedback_plural'] = 'Додаци за повратне информација';
$string['subplugintype_assignsubmission'] = 'Додатак за предају рада';
$string['subplugintype_assignsubmission_plural'] = 'Додаци за предају рада';
$string['teamsubmission'] = 'Студенти предају радове у групама';
$string['teamsubmissiongroupingid'] = 'Груписање за студентске групе';
$string['teamsubmissiongroupingid_help'] = 'Ово је груписање које ће Задатак користити како би пронашао групе за студентске групе. Уколико није подешено користиће се подразумевани скуп група.';
$string['teamsubmission_help'] = 'Ако је ова опција омогућена студенти ће бити подељени у групе на основу подразумеваног скупа група или наменски прилагођеног груписања. Групни рад ће бити дељен између чланова групе и сви чланови групе ће видети промене у раду које буду унели други чланови групе.';
$string['teamsubmissionstatus'] = 'Статус групних радова';
$string['textinstructions'] = 'Упутства за задатак';
$string['timemodified'] = 'Последње измене';
$string['timeremaining'] = 'Преостало време';
$string['unlimitedattempts'] = 'Неограничено';
$string['unlimitedattemptsallowed'] = 'Неограничен број покушаја';
$string['unlocksubmissionforstudent'] = 'Дозволи предају радова за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['unlocksubmissions'] = 'Откључај предате радове';
$string['updategrade'] = 'Ажурирај оцену';
$string['updatetable'] = 'Сачувај и ажурирај табелу';
$string['upgradenotimplemented'] = 'Надоградња није имплементирана у додатку ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Продужетак је одобрен до: {$a}';
$string['usergrade'] = 'Водич за кориснике';
$string['userswhoneedtosubmit'] = 'Корисници који треба да предају решење: {$a}';
$string['validmarkingworkflowstates'] = 'Исправна стања тока оцењивања';
$string['viewbatchmarkingallocation'] = 'Погледај страницу за групну доделу оцењивача.';
$string['viewbatchsetmarkingworkflowstate'] = 'Погледај страницу за групно подешавање тока оцењивања.';
$string['viewfeedback'] = 'Погледајте повратне информације';
$string['viewfeedbackforuser'] = 'Погледајте повратне информације за корисника {$a}';
$string['viewfull'] = 'Прикажи све';
$string['viewfullgradingpage'] = 'Отворите страницу за оцењивање у пуном формату како бисте дали повратне информације';
$string['viewgradebook'] = 'Погледај књигу оцена';
$string['viewgrading'] = 'Погледај/оцени све предате радове';
$string['viewgradingformforstudent'] = 'Погледајте страницу за оцењивање за  полазника: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Погледајте страницу за предају сопственог рада';
$string['viewownsubmissionstatus'] = 'Погледајте страницу статуса сопственог рада';
$string['viewrevealidentitiesconfirm'] = 'Погледај страницу са потврдом за откривање идентитета студената';
$string['viewsubmission'] = 'Погледај предати рад';
$string['viewsubmissionforuser'] = 'Погледај предати рад за корисника: {$a}';
$string['viewsubmissiongradingtable'] = 'Погледај табелу за оцењивање предатих радова';
$string['viewsummary'] = 'Прикажи сажетак';
$string['workflowfilter'] = 'Филтер тока оцењивања';
