<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Приступ је одбијен';
$string['accounts'] = 'Налози';
$string['addcategory'] = 'Додај категорију';
$string['additionalhtml'] = 'Додатни HTML';
$string['additionalhtml_desc'] = 'Ово подешавање вам дозвољава да наведете HTML кôд који желите да буде додат на сваку страницу. Можете поставити HTML кôд који ће бити додат унутар ознаке HEAD за сваку страницу, одмах након отварања или непосредно пре затварања ознаке BODY.<br /> На овај начин можете имати прилагођено заглавље или подножје за сваку страницу или можете додати подршку за сервисе, попут Google Analytics, на једноставан начин, независно од теме коју сте изабрали.';
$string['additionalhtmlfooter'] = 'Пре него што се затвори BODY ознака';
$string['additionalhtmlfooter_desc'] = 'Садржај који овде упишете биће додат на сваку страницу непосредно пре него што се затвори body ознака (</body>).';
$string['additionalhtmlhead'] = 'Унутар HEAD ознаке';
$string['additionalhtmlhead_desc'] = 'Садржај који овде упишете биће додат на крау HEAD ознаке на свакој страници.';
$string['additionalhtml_heading'] = 'Додатни HTML који се бити придружен свакој страници.';
$string['additionalhtmltopofbody'] = 'Када се отвори BODY ознака';
$string['additionalhtmltopofbody_desc'] = 'Садржај који овде упишете биће додат на сваку страницу одмах након што се отвори body ознака (<body>).';
$string['admincategory'] = 'Категорија: {$a}';
$string['adminseesall'] = 'Администратори виде све';
$string['adminseesallevents'] = 'Администратори виде све догађаје';
$string['adminseesownevents'] = 'Администратори су као остали корисници';
$string['advancedfeatures'] = 'Напредна својства';
$string['allcountrycodes'] = 'Све ознаке земаља';
$string['allowbeforeblock'] = 'Прво ће се обрађивати списак допуштених адреса';
$string['allowbeforeblockdesc'] = 'Подразумевано је да се списак блокираних адреса прво обрађује, ако је ова опција омогућена, списак допуштених IP адреса биће обрађен пре списка блокираних адреса.';
$string['allowblockstodock'] = 'Дозволити фиксирање блокова';
$string['allowcategorythemes'] = 'Дозволи избор графичке теме на нивоу категорија';
$string['allowcoursethemes'] = 'Дозволи избор графичке теме на нивоу курсева';
$string['allowediplist'] = 'Списак допуштених адреса';
$string['allowemailaddresses'] = 'Дозвољени домени електронске поште';
$string['allowframembedding'] = 'Дозволи уметање оквира';
$string['allowframembedding_help'] = 'Дозволи уметање овог сајта у оквире спољних сајтова. Омогућавање ове функције се не препоручује из безбедносних разлога.';
$string['allowguestmymoodle'] = 'Дозволите гостима приступ страници \'Моја почетна страница\'';
$string['allowobjectembed'] = 'Дозволи EMBED и OBJECT ознаке';
$string['allowthemechangeonurl'] = 'Дозволи промену графичке теме у URL адреси';
$string['allowuserblockhiding'] = 'Дозволи корисницима да сакрију блокове';
$string['allowuserswitchrolestheycantassign'] = 'Дозволи корисницима који немају могућност додељивања улога да мењају своје улоге';
$string['allowuserthemes'] = 'Дозволи корисницима избор графичке теме';
$string['antivirus'] = 'Антивирус';
$string['appearance'] = 'Изглед';
$string['aspellpath'] = 'Путања до алата aspell';
$string['authentication'] = 'Провера идентитета';
$string['authpreventaccountcreation'] = 'Спречи креирање налога приликом провере идентитета';
$string['authpreventaccountcreation_help'] = 'Приликом провере идентитета корисника, на сајту се аутоматски креира налог, уколико он већ не постоји. Ако се пак, за проверу идентитета, користи нека спољашња база података, попут LDAP-а, а при томе желите да дозволите приступ сајту  само корисницима са постојећим налогом, онда треба укључити ову опцију. У том случају, нови налози се креирају ручно или путем опције за постављање корисника. Имајте у виду да се ово подешавање не примењује на MNet проверу идентитета.';
$string['authsettings'] = 'Управљање провером идентитета';
$string['autolang'] = 'Аутоматско детектовање језика';
$string['autologinguests'] = 'Аутоматско пријављивање гостију';
$string['availablelicenses'] = 'Расположиве лиценце';
$string['availableto'] = 'Доступно';
$string['backgroundcolour'] = 'Транспарентна боја';
$string['backups'] = 'Резервне копије';
$string['backup_shortname'] = 'Користите назив курса у називу датотеке резервне копије';
$string['backup_shortnamehelp'] = 'Користите назив курса као део назива датотеке резервне копије.';
$string['badwordsconfig'] = 'Унесите своју листу ружних речи одвојених зарезима.';
$string['badwordsdefault'] = 'Уколико је Ваша листа ружних речи празна, биће коришћена подразумевана листа језичког пакета.';
$string['badwordslist'] = 'Листа дефинисаних ружних речи';
$string['blockediplist'] = 'Списак блокираних IP адреса';
$string['blockeditingmenu'] = 'Менији за уређивање блокова';
$string['blockeditingmenu_desc'] = 'Ако је ова опција омогућена многе од икона за уређивање блокова приказаних кад је уређивање укључено биће приказане у оквиру падајућег менија. Ово редукује садржај на екрану сакривајући иконе док не постану потребне.';
$string['blockinstances'] = 'Инстанце';
$string['blockmultiple'] = 'Вишеструки';
$string['blockprotect'] = 'Заштити инстанце';
$string['blockprotect_help'] = 'Ако закључате одређени тип блока, онда нико неће моћи да додаје или брише инстанце тог блокова. (Блок можете, наравно,  поново да откључавате, уколико желите да уредите његове инстанце)

Сврха ове опције је да се заштите блокови као што су \'Навигација\' и \'Подешавања \', које је тешко повратити ако се грешком обришу.';
$string['blocksettings'] = 'Управљање блоковима';
$string['blockunprotect'] = 'Уклони заштиту';
$string['bloglevel'] = 'Видљивост блога';
$string['bookmarkadded'] = 'Обележивач је додат.';
$string['bookmarkalreadyexists'] = 'Већ сте обележили ову страницу.';
$string['bookmarkdeleted'] = 'Обележивач је обрисан.';
$string['bookmarkthispage'] = 'Обележи ову страницу';
$string['cacheapplication'] = 'Кеш апликације';
$string['cacheapplicationhelp'] = 'Кеширане ставке се деле између свих корисника и истичу након одређеног периода (ttl).';
$string['cachejs'] = 'Кеширај Javascript';
$string['cachejs_help'] = 'Кеширање Javascripta и компресија у великој мери побољшава учитавање странице. Веома се препоручује за продукционе сајтове. Програмери ће вероватно желети да онемогуће ову функцију.';
$string['cacherequest'] = 'Кеш захтева';
$string['cacherequesthelp'] = 'Посебан кориснички кеш који истиче након што је захтев испуњен. Намена му је да замени области где смо користили статичко чување података.';
$string['cachesession'] = 'Кеш сесије';
$string['cachesessionhelp'] = 'Посебан кориснички кеш који истиче након што корисник заврши сесију. Намена му је да смањи увећање/оптерећење сесије.';
$string['cachesettings'] = 'Подешавања кеша';
$string['cachetext'] = 'Време трајања кеширања текста';
$string['caching'] = 'Кеширање';
$string['calendarexportsalt'] = 'Насумични стринг (salt) за извоз календара';
$string['calendarsettings'] = 'Календар';
$string['calendartype'] = 'Тип календара';
$string['calendartype_desc'] = 'Изабарите подразумевани тип календара за читав сајт. Ово подешавање може бити промењено у подешавањима курса или од стране корисника на њиховим страницама профила.';
$string['calendar_weekend'] = 'Дани викенда';
$string['cannotdeletemodfilter'] = 'Не можете да деинсталирате  филтер \'{$a->filter}\' зато шро је он део модула \'{$a->module}\'';
$string['cannotuninstall'] = '{$a} није могуће деинсталирати';
$string['cfgwwwrootslashwarning'] = 'Погрешно сте дефинисали $CFG->wwwroot у вашој config.php датотеци. Укључили сте карактер \'/\' на крају. Уклоните га, иначе ће те добијати чудне поруке о грешци попут следеће <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Погрешно сте дефинисали $CFG->wwwroot у вашој config.php датотеци. Адреса не одговара URL адреси коју користите да бисте приступили овој страници. Исправите адресу, иначе ће те добијати чудне поруке о грешци попут следеће <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'промени';
$string['checkboxno'] = 'Не';
$string['checkboxyes'] = 'Да';
$string['choosefiletoedit'] = 'Одабери датотеку за уређивање';
$string['clamfailureonupload'] = 'Након неуспешног извршавања clam антивирусног алата';
$string['cleanup'] = 'Чишћење';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Грешка, неисправна вредност "{$a->value}" за "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Неисправна вреднос, молим покушајте поново';
$string['clistatusdisabled'] = 'Статус онемогућен';
$string['clistatusenabled'] = 'Статус омогућен';
$string['clistatusenabledlater'] = 'статус: CLI режим одржавања биће омогућен {$a}';
$string['clitypevalue'] = 'откуцај вредност';
$string['clitypevaluedefault'] = 'откуцај вредност, притисни Ентер да бисте употребили подразумевану вредност ({$a})';
$string['cliunknowoption'] = 'Непрепознате опције:
{$a}
Молимо искористите опцију за помоћ.';
$string['cliupgradefinished'] = 'Ажурирање путем команде линије је успешно завршено.';
$string['cliupgradenoneed'] = 'Није потребна надоградња за инсталирану верзију {$}. У сваком случају хвала што сте дошли !';
$string['cliyesnoprompt'] = 'откуцај y (значи да) или n (значи не)';
$string['commentsperpage'] = 'Број коментара приказаних по страници';
$string['commonfiltersettings'] = 'Заједничка подешавања филтера';
$string['commonsettings'] = 'Општа подешавања';
$string['componentinstalled'] = 'Компонента је инсталирана';
$string['computedfromlogs'] = 'Израчунато из записа о активностима од {$a}.';
$string['condifmodeditdefaults'] = 'Подразумеване вредности се користе у формама за подешавање приликом креирања нове активности или ресурса.';
$string['confeditorhidebuttons'] = 'Одаберите дугмад која би требала бити скивена у HTML едитору.';
$string['configallcountrycodes'] = 'Ово је списак земаља које могу бити одабране на разним местима, рецимо у корисничком профилу. Ако је списак празан (што је подразумевана вредност), користиће се списак из countries.php који је део стандардног енглеског језичког пакета. Тај списак је преузет из ISO 3166-1. У супротноме потребно је да да наведете и двословне ознаке земаља одвојене зарезима, нпр. \'RS,GB,ES\'. Ако додате нове, нестандардне ознаке, мораћете да их додате и у countries.php датотеку, како енглеског, тако и Вашег језичког пакета.';
$string['configallowassign'] = 'Можете дозволити људима које имају улоге наведене у првој колони са леве стране да другим људима додељују неке од улога у осталим колонама.';
$string['configallowblockstodock'] = 'Ако је овo подешавање омогућено, а то изабрана тема подржава, корисници могу да одаберу да премештају блокове у посебан док (са десне стране).';
$string['configallowcategorythemes'] = 'Уколико омогућите ову опцију графичке теме се могу подешевати на нивоу категорија. То ће утицати на све подређене категорије и курсеве које већ немају подешену сопствену графичку тему. УПОЗОРЕЊЕ: Омогућавање избора графичке теме на нивоу категорија може утицати на перформансе система.';
$string['configallowcoursethemes'] = 'Уколико омогућите ову опцију, курсевима ће бити дозвољено да подесе сопственe графичке теме. Графичке теме на нивоу курсева имају првенство у односу на све остале изборе тема (сајта, корисника или сесије).';
$string['configallowemailaddresses'] = 'Уколико желите да ограничите нове електронске адресе на одређене домене, наведите их овде раздвојене размацима. Сви остали домени биће одбијени. Да бисте дозволили коришћење одређених поддомена додајте одговарајући домен са тачком испред. На пример: <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'Ако је ова опција омогућена гости ће моћи да приступе страници \'Моjа почетна страница\', у супротном биће преусмерени на насловну страницу сајта.';
$string['configallowobjectembed'] = 'Као подразумевана безбедносна мера, крајњим корисницима није дозвољено уметање мултимедијалних садржаја (попут Flash анимација) унутар текста експлицитно коришћењем ознака EMBED и OBJECT унутар HTML кода (иако је то и даље могуће извести на сигурнији начин путем mediaplugins филтера). Желите ли ипак дозволити употребу ових ознака, укључите ову опцију.';
$string['configallowoverride'] = 'Можете дозволити људима које имају улоге наведене у првој колони са леве стране да мењају овлашћења улога
наведених у преосталим колонама.';
$string['configallowoverride2'] = 'Изаберите које улоге се којим улогама из леве колоне могу променити.<br /> Запазите да ова подешавања важе само за оне кориснике који имају допуштене могућности moodle/role:override или moodle/role:safeoverride.';
$string['configallowswitch'] = 'Изаберите у које улоге корисник може прећи, на основу оних улога које већ поседује. Поред уноса у овој табели, корисник такође мора поседовати овлашћење moodle/role:switchroles да би могао да промени улогу.<br />Запазите да је једино могуће изменити улоге које имају овлашћење moodle/course:view, а немају овлашћење moodle/site:doanything, па су неке колоне ове табеле онемогућене.';
$string['configallowthemechangeonurl'] = 'Ако је овo подешавање омогућено, графичка тема може да се промени додавањем <br />?theme=themename било којој Moodle URL адреси (нпр: mymoodlesite.com/?theme=afterburner ) или <br />&theme=themename било којој интерној Moodle URL адреси (нпр: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Да ли желите да корисницима омогућите да сами  скривају/приказују бочне блокове на овом сајту? Ово својство користи Java скрипт и "колачиће" како би се запамтило тренутно стање блокова, и утиче једино на изглед сајта појединачног корисника.';
$string['configallowuserswitchrolestheycantassign'] = 'Као подразумевано подешавање, захтева се да корисник има овлашћење moodle/role:assign да би могао да мења улоге. Омогућавањем овог подешавања овде, уклања се овај захтев и за последицу има да се појављује падајући списак "Промени улогу у", који је одређен само подешавањима у табели "Дозволи додељивање улога".
Препоручује се да подешавања у табели "Дозволи додељивање улога" не дозвољавају корисницима да промене улогу у ону са већим овлашћењима од постојеће.';
$string['configallowuserthemes'] = 'Уколико омогућите ову опцију, корисницима ће бити дозвољено да сами подесе графичку тему по својој жељи. Теме које изаберу корисници имају предност у односу на графичку тему подешену на нивоу сајта (али не и у односу на графичку тему подешену на нивоу курса).';
$string['configallusersaresitestudents'] = 'За активности на почетној страници сајта, да ли се СВИ корисници сматрају полазницима? Уколико је одговор "Да", онда ће сваком кориснику са отвореним налогом бити дозвољено да као полазник учествује у тим активностима. Уколико је одговор "Не", онда ће само они корисници који су уписани на најмање један курс моћи да учествују у активностима на почетној страни. Само администратори и посебно одређени предавачи могу да буду предавачи за те активности.';
$string['configauthenticationplugins'] = 'Молимо одаберите додатке за проверу идентитета које желите да користите и поређајте их у редоследу смењивања у случају неуспеха. Саморегистрацијом ће управљати додатак одабран у колони \'Регистрација\' (обично \'е-пошта\')';
$string['configautolang'] = 'Уколико подразумевани језик на нивоу сајт није укључен, детектуј подразумевани језик веб читача.';
$string['configautologinguests'] = 'Да ли би посетиоци сајта требало да буду аутоматски пријављени на систем као гости када улазе на неки од курсева који дозвољавају приступ гостима?';
$string['configbloglevel'] = 'Ово подешавање вам дозвољава да ограничите ниво до ког ће бити видљиви блогови корисника на овом сајту. Имајте у виду да ово одређује најшири контекст ЧИТАОЦА, а не аутора или тип блог чланка. Блогови могу бити и потпуно онемогућени ако уопште не желите да их користите.';
$string['configcachetext'] = 'За обимније сајтове, односно сајтове које користе текстуалне филтере ово подешавање може да убрза рад. Копије текстова биће задржане у свом обрађеном облику у временском интервалу који овде одредите. Задавање премале вредности би могло донекле успорити рад, а задавање превелике вредности би могло резултирати тиме да текстовима треба превише времена за освежавање (нпр. с новим линковима).';
$string['configcalendarcustomexport'] = 'Омогући прилагођени временски оквир извоза календара';
$string['configcalendarexportsalt'] = 'Овај насумични текст се користи за унапређење безбедности токена за проверу аутентичности који се користи за извоз календара. Имајте у виду  да су сви текући токени поништени уколико промените овај насумични текст ("hash salt")';
$string['configclamactlikevirus'] = 'Третирај датотеке као вирусе';
$string['configclamdonothing'] = 'Третирај датотеке нормално';
$string['configclamfailureonupload'] = 'Како да се понаша Clam AV, конфигурисан да скенира постављене датотеке, када због лоше конфигурације или из неког непознатог разлога не успе да се покрене? Ако изаберете опцију "Третирај датотеке као вирусе" датотеке ће бити премештене у "карантин" или обрисане. Уколико изаберете опцију "Третирај датотеке нормално" датотеке ће бити премештене у одредишни директоријум на уобичајен начин. У оба случаја администратор ће бити обавештен да је Clam пријавио грешку приликом стартовања. Уколико изаберете опцију "Третирај датотеке као вирусе", у случају да из било ког разлога Clam не буде покренут (обично због погрешно подешене путање до њега), СВЕ постављене датотеке биће премештене у "карантин" или обрисане. Будите обазриви са овим подешавањем.';
$string['configconvertformat'] = 'Ако су <i>latex</i>, <i>dvips</i> и <i>convert</i> доступни, слике се креирају коришћењем наведеног формата. Ако нису, биће коришћен mimeTeX и он ће креирати GIF слике.';
$string['configcookiehttponly'] = 'Омогућава нову карактеристику PHP 5.2.0 - веб читачима се задаје да шаљу колачиће само са правим http захтевима, колачићи не би требало да буду доступни скрипт језицима. Ово не подржавају сви веб читачи и можда неће бити компатибилно са садашњим кодом. Помаже да се спрече неки типови XSS напада.';
$string['configcookiesecure'] = 'Ако сервер прихвата само https конекције, препоручљиво је омогућити слање безбедних колачића. Ако је подешавање омогућено, молимо, проверите да веб сервер не прихвата http:// или подесите стално преусмеравање на https:// адресу. Када <em>wwwroot</em> адреса не почиње са https:// ово подешавање се аутоматски искључује.';
$string['configcountry'] = 'Уколико овде подесите име државе, оно ће бити изабрано као подразумевано у новоотвореним корисничким налозима. Оставите ово поље празно како би сте приморали кориснике да сами изаберу државу из које су.';
$string['configcourseoverviewfilesext'] = 'Списак дозвољених, зарезима раздвојених, екстензија датотека резимеа курсева.';
$string['configcourseoverviewfileslimit'] = 'Максималан број датотека који се може приложити уз реѕиме курса.';
$string['configcourserequestnotify'] = 'Упишите корисничко име корисника који ће бити обавештени када се појави захтев за покретање новог курса.';
$string['configcourserequestnotify2'] = 'Корисници који ће бити обавештени када се појави захтев за покретање новог курса. Овде су наведени само корисници који могу одобрити захтев за покретање курса.';
$string['configcoursesperpage'] = 'Унесите број курсева који се на списку курсева приказује по једној страници.';
$string['configcourseswithsummarieslimit'] = 'Максималан број курсева за приказивање на списку курсева, укључујући њихов резимеа, пре повратка на једноставнији списак курсева (без резимеа).';
$string['configcronclionly'] = 'Уколико је ово укључено, онда се крон скрипта може покренути само из командне линије уместо преко веба. Ово подешавање има предност у односу на лозинку за крон.';
$string['configcronremotepassword'] = 'Ово значи да се cron.php скрипта не може покренути из веб читача ако се не обезбеди лозинка, тако што ће се употребити следећи облик URL адресе:<pre> http://site.example.com/admin/cron.php?password=opensesame</pre. Уколико се ово остави празно, лозинка није потребна.';
$string['configcurlcache'] = 'Време трајања cURL кеша, у секундама';
$string['configcustommenuitems'] = 'Овде можете да конфигуришете сопствени мени који ће бити приказан у оквиру графичке теме. Сваки ред се састоји од текста ставке у менију, одговарајуће URL адресе линка (опционо), кратког описа ставке (опционо), као и ознаке језика или листе ознака језика, одвојених зарезима, (опционо, за приказ тог реда искључиво корисницима наведеног језика) који су међусобно одвојени вертикалном цртом |. Можете да одредите и структуру менија користећи цртицe. На пример:
<pre>
Moodle заједница|https|//moodle.org
-Moodle бесплатна подршка|https://moodle.org/support
-Moodle развој|https://moodle.org/development
--Moodle документи|https://docs.moodle.org
Moodle.com|http://moodle.com/
</pre>';
$string['configdbsessions'] = 'Ако је омогућено, ово подешавање ће користити базу података за похрањивање информације о текућим сесијама. Имајте у виду да:ће промена овог подешавања прекинути сесије свих тренутно активних корисника (укључујући и вас). Уколико користите MySQL проверите да ли је вредност за \'max_allowed_packet\' у my.cnf (или my.ini) датотеци  барем 4M. Други драјвери сесија могу се директно конфигурисати у config.php датотеци; за више информација погледајте датотеку config-dist.php. Ова опција нестаје ако наведете драјвер сесије у датотеци  config.php.';
$string['configdebug'] = 'Уколико укључите ову опцију онда ће бити повећан број извешатаја о грешкама PHP-a (error_reporting). Ова опција је корисна једино онима који развијају Moodle.';
$string['configdebugdisplay'] = 'Ако је ова опција укључена, обавештавање о грешкама ће бити прослеђенo на HTML страницу. Ово је практично, али генерално није компатибилно са XHTML, JS, колачићима и HTTP заглављем. Ако је искључено, излазне информације биће прослеђене у записе вашег сервера, омогућавајући тако боље уклањање грешака. PHP подешавање error_log контролише у који запис иду ове информације.';
$string['configdebugpageinfo'] = 'Укључите уколико желите да се информације о страници приказују у њеном подножју.';
$string['configdebugsmtp'] = 'Укључите детаљне информације за отклањање грешака током слања порука е-поште SMTP серверу.';
$string['configdebugvalidators'] = 'Укључите ако у подножју странице желите имати линкове на спољне сервере за проверу исправности. Можда ће бити потребно да креирате новог корисника са корисничким именом <em>w3cvalidator</em>, и омогућити му гостујући приступ. Ове измене могу дозволити неовлашћени приступ серверу, не укључујте на званично активним веб локацијама!';
$string['configdefaulthomepage'] = 'Ово подешавање одређује почетну страницу за улоговане кориснике';
$string['configdefaultrequestcategory'] = 'Курсеви које захтевају корисници биће аутоматски смештени у ову категорију.';
$string['configdefaultrequestedcategory'] = 'Подразумевана категорија за смештање захтеваних курсева, уколико су исти одобрени.';
$string['configdefaultuserroleid'] = 'Свим корисницима, пријављеним  на систем, биће дате могућности улоге коју овде наведете, на нивоу сајта, као ДОДАТАК на евентуалне друге улоге које можда већ имају. Подразумевана је улога ауторизованог корисника. Имајте у виду да ово неће бити у супротности са другим улогама које корисници имају, осим ако не забраните могућности.
Ово само осигурава да сви корисници имају способности које није могуће доделити на нивоу курса (нпр. писање блог чланака, уређивање сопственог календара итд.)';
$string['configdeleteincompleteusers'] = 'По истеку овог периода, бришу се стари, непотпуни налози.';
$string['configdeleteunconfirmed'] = 'Уколико користите проверу идентитета путем електронске поште, ово је временски рок унутар ког ће бити прихваћена потврда од стране корисника. Након тог периода сви непотврђени налози биће обрисани.';
$string['configdenyemailaddresses'] = 'Да бисте онемогућили електронске адресе са одређених домена наведите их овде на исти начин. Сви други домени биће прихваћени. На пример <strong>hotmail.com yahoo.co.uk neželjeni.domen.com</strong>';
$string['configdisableuserimages'] = 'Искључите могућност да корисници мењају слике у корисничким профилима';
$string['configdisplayloginfailures'] = 'Ово ће изабраним корисницима приказати информације о претходним неуспешним покушајима пријаве на систем.';
$string['configdndallowtextandlinks'] = 'Омогућите или онемогућите постављање текста и линкова, заједно са датотекама, помоћу опције \'превуци и спусти\'. Имајте на уму да је превлачење текста у Фајерфоксу или између различитих веб читача непоуздано и да као последицу може имати да подаци или текст не буду постављени.';
$string['configdocroot'] = 'Definiše putanju do Moodle dokumentacije za pružanje kontekstualne podrške putem linkova "Moodle dokumentacija za ovu stranicu" u podnožju svake strane. Ako se ovo polje ostavi prazno ti linkovi se neće prikazivati.';
$string['configdoctonewwindow'] = 'Ако ово омогућите, линкови до Moodle документације ће бити приказани у новом прозору.';
$string['configeditordictionary'] = 'Ова вредност се користи ако aspell нема речник за језик корисника.';
$string['configeditorfontlist'] = 'Изаберите фонтове који ће се појавити у листи расположивих фонтова при коришћењу едитора.';
$string['configemailchangeconfirmation'] = 'Затражити корак потврде путем е-поште када корисници измене своју адресу е-поште у свом профилу.';
$string['configenableajax'] = 'Ово подешавање контролише коришћења AJAX-а на сајту. AJAX је неопходан за неке функционалности као што је превлачење садржаја.';
$string['configenableblogs'] = 'Овај прекидач омогућава свим корисницима сајта да користе свој блог';
$string['configenablecalendarexport'] = 'Омогући извоз или пријаву на календаре';
$string['configenablecomments'] = 'Омогући коментаре';
$string['configenablecourserequests'] = 'Ово ће дозволити сваком кориснику да захтева креирање курса.';
$string['configenabledevicedetection'] = 'Омогућава детекцију мобилних и паметних телефона, таблета или стандардних уређаја (стони или преносиви рачунари, итд.) због примене графичких тема и других функција.';
$string['configenablegroupmembersonly'] = 'Ако је ово подешавање омогућено, приступ активностима може бити ограничен само на чланове групе. Ово може да резултира повећаним оптерећењем сервера. Додатно, категорије у књизи оцена морају бити подешене на одговарајући начин како би се осигурало да те активности буду сакривене од оних који нису чланови групе.';
$string['configenablemobilewebservice'] = 'Омогућите примену мобилних сервиса за званичну Moodle апликацију или друге апликације који то захтевају. За више информација прочитајте {$a}';
$string['configenablerssfeeds'] = 'Ова је опција омогућена, RSS извори ће бити генерисани на читавом сајту од стране различити модула активности као што су блогови, форуми. базе података и речници. Имајте у виду да RSS сервис, такође, треба да буде омогућен на нивоу подешавања појединачног модула активности.';
$string['configenablerssfeedsdisabled'] = 'RSS сервис није доступан, зато што његово коришћење није омогућено на нивоу целог сајта. Да би сте омогућили коришћење RSS-a, идите на страницу за подешавања променљивих у оквиру администраторске конфигурације.';
$string['configenablerssfeedsdisabled2'] = 'Подршка за RSS извор вести је искључена на нивоу сервера. Потребно је да је прво укључите на Администрација сајта/Сервер/RSS';
$string['configenablesafebrowserintegration'] = 'Ово додаје опцију "Захтева Safe Exam Browser" у пољу "Сигурност веб читача" на обрасцу за подешавање теста. За више информација погледајте http://www.safeexambrowser.org/';
$string['configenablestats'] = 'Ако овде изаберете опцију "Да", cronjob вашег Moodleа ће обрадити записе и прикупити неке статистичке информације. У зависности од количине саобраћаја на вашем сајту то може потраје неко време. Ако ову опцију омогућите, моћи ћете да видите неке занимљиве графиконе и статистичке извештаје о сваком од ваших курсева, или на нивоу целог сајта.';
$string['configenabletrusttext'] = 'Према подразумеваним подешавањима Moodle ће увек темељно пречистити текст који долази од корисника, како би уклонио евентуалне злонамерне скриптове, мултимедијалне и друге садржаје који би могли представљати безбедносни ризик. Систем Поузданог садржаја (Trusted Content system) представља начин да појединим корисницима, којима верујете, дозволите да додају и такве напредне садржаје без додатне провере. Да бисте омогућили овај систем прво морате да укључите ово подешавање, а потом да одобрите дозволу за Поуздани садржај одговарајућој Moodle улози. Tекстови које креирају или постављају такви корисници биће означени као поуздани и неће бити подвргнути пречишћавању пре приказа.';
$string['configenablewebservices'] = 'Веб сервиси дају могућбост другим системима да се пријаве на овај Moodle и изводе различите операције. Због додатне безбедности ово својство би требало да буде искључено, осим ако не желите да га стварно користите.';
$string['configenablewsdocumentation'] = 'Укључите аутоматско генерисање документације о веб сервисима. Корисник може приступити сопственој документацији на својој страници безбедносних кључева {$a}. Страница приказује документацију само за дозвољене протоколе. ';
$string['configerrorlevel'] = 'Одаберите ниво PHP упозорења која ће Вам се приказивати на екрану. Поставка Нормал је обично најбољи одабир.';
$string['configexportlookahead'] = 'Дана унапред за праћење у току извоза';
$string['configexportlookback'] = 'Дана уназад за праћење током извоза';
$string['configextendedusernamechars'] = 'Укључите ово подешавање како бисте дозволили полазницима да употребљавају све знакове у својим корисничиким именима (напомена: ово не утиче на њихова права имена). Подразумевана вредност је "нетачно" што ограничава полазнике да користе само мала слова, бројеве, доњу црту (_), цртицу (-), тачку (.) или симбол "ет" (@).';
$string['configextramemorylimit'] = 'Поједини скриптови као што је претрага, прављење резервних копија или крон захтевају више меморије. За велике сајтове поставите више вредности.';
$string['configfilterall'] = 'Филтрирање свих стрингова, укључујући наслове, називе, навигацијске елементе и слично. Ово је једино корисно код коришћења вишејезичког филтера, у супротном превише оптерећује сервер уз малу или никакву корист.';
$string['configfiltermatchoneperpage'] = 'Филтери за аутоматско линковање ће генерисати само један линк ка првој одговарајућој појави текста пронађеној на комплетној страници. Све остале појаве се игноришу.';
$string['configfiltermatchonepertext'] = 'Филтери за аутоматско линковање ће генерисати само један линк ка првој одговарајућој појави текста пронађеној у свакој од ставки текста (нпр. ресурсу, блоку) на страници. Све остале појаве се игноришу. Ово подешавање се не узима у обзир ако је подешавање за једну појаву по страници постављено на <i>да</i>.';
$string['configfilteruploadedfiles'] = 'Процесирање свих постављених HTML и текстуалних датотека филтерима пре њиховог приказивања, процесирање само постављених HTML датотека или без процесирања.';
$string['configforcelogin'] = 'Под нормалним околностима, људи ће моћи да виде насловну страну сајта и списак курсева (али не и саме курсеве) без претходног пријављивања. Уколико желите да приморате људе да се пријаве пре него што виде БИЛО ШТА на сајту, онда би требало да омогућите ово подешавање.';
$string['configforceloginforprofiles'] = 'Ово подешавање приморава људе да се на систем пријаве са правим налозима (не као гости) пре него што буду у прилици да виде странице са корисничким профилима. Ако сте онемогућили ово подешавање може се десити да неки корисници у своје профиле постављају рекламе или други неприкладан садржај, који ће онда бити видљив свима на Интернету.';
$string['configfrontpage'] = 'Горе изабране ставке биће приказане на насловној страници сајта.';
$string['configfrontpagecourselimit'] = 'Максималан број курсева';
$string['configfrontpagecourselimithelp'] = 'Максималан број курсева који се приказује на насловној страници сајта у оквиру списка курсева.';
$string['configfrontpageloggedin'] = 'Горе изабране ставке биће приказане на насловној страници сајта када је корисник пријављен на систем.';
$string['configfullnamedisplay'] = 'Ово дефинише начин на који ће бити приказано име и презиме. Подразумевана вредност, "language", оставља да вредност стринга "fullnamedisplay" у текућем језичком пакету одреди начин приказа. Поједини језици имају различите конвенције за приказ имена.

За већину монојезичних сајтова најефикасније подешавање је  "Име + Презиме", али можете да изаберете да потпуно сакријете презимена. Ознаке које могу да се користе су: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, и alternatename.';
$string['configgeoipfile'] = 'Локација GeoIP City бинарне датотеке. Ова датотека није део Moodle дистрибуције и мора бити засебно преузета са <a href="http://www.maxmind.com/">MaxMind</a>. Можете, или да купите комерцијалну или да користите бесплатну верзију. Једноставно преузмите датотеку <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> и распакујте је у директоријум "{$a}" на свом серверу.';
$string['configgetremoteaddrconf'] = 'Ако је Ваш сервер иза повратног (reverse) проксија, можете користити ово подешавање да подесите за која HTTP заглавља се може веровати да садрже удаљену адресу. Заглавља се читају по реду, користи се прво доступно.';
$string['configgradebookroles'] = 'Ова опција Вам омогућава да контролишете ко се појављује у евиденцији оцена. Корисници треба да имају најмање једну од ових улога у курсу да би били приказани у евиденцији оцена тог курса.';
$string['configgradeexport'] = 'Одаберите који формати за извоз књиге оцена су Ваши примарни методи за извоз оцена. Изабрани додаци ће онда поставити и користити поље "last exported" за сваку оцену. На пример, ово може као резултат дати извезене оцене означене као "нове" или "ажуриране". Ако нисте сигурни шта желите да постигнете овим подешавањима, слободно оставите све опције непотврђене.';
$string['confighiddenuserfields'] = 'Изаберите која поља са корисничким информацијама желите да сакријете од других корисника који нису предавачи на курсу или администратори. Ово ће повећати приватност корисника. Држите CTRL тастер да бисте изабрали више поља.';
$string['configidnumber'] = 'Ова поставка одређује (а) хоће ли корисници уопште бити питани за ID број, (б) хоће ли корисници бити питани за ID број, али ће наведено поље моћи оставити празно или (ц) хоће ли корисницима унос у поље ID број бити обавезан. Ако је ID број унет, исти се приказује у њиховом профилу.';
$string['configintro'] = 'На овој страници можете да наведете бројне конфигурационе променљиве које ће помоћи да Moodle правилно функционише на вашем серверу. Не брините превише о томе - подразумеване вредности обично су потпуно адекватне. Касније се можете вратити на ову страницу и променити подешавања према потреби.';
$string['configintroadmin'] = 'На овој страни би требало да конфигуришите Ваш главни администраторски налог који ће имати потпуну контролу над читавим сајтом. Уверите се да сте налогу доделили безбедно корисничко име и лозинку, као и исправну електронску адресу. Касније можете креирати додатне администраторске налоге.';
$string['configintrosite'] = 'Ова страница вам омогућава да конфигуришете изглед насловне странице и назив сајта. Увек се можете накнадно вратити на ову страницу како бисте променили ова подешавања, користећи мени за администрацију.';
$string['configiplookup'] = 'Кад кликнете на IP адресу (као што је 34.12.222.93), на пример у извештајима о активностима, приказује Вам се мапа са најбољом могућом проценом стварне локације тог IP-а. Има више додатака које можете одабрати за ову функцију (сваки нуди неке предности, али и долази с одрђеним мањкавостима, па се кориснику препушта коначни избор).';
$string['configkeeptagnamecase'] = 'Чекирајте ово ако желите да имена ознака (тагова) задрже оригинална велика и мала слова како су их унели креатори';
$string['configlang'] = 'Изаберите подразумевани језик за цео сајт. Корисници могу да промене ово подешавање користећи језички мени или подешавање у оквиру свог личног профила.';
$string['configlanglist'] = 'Оставите ову опцију празном ако желите дати Вашим корисницима право на одабир БИЛО КОГ језичког пакета инсталираног на нивоу Moodle система. Међутим, можете скратити падајући језички мени уношењем жељених језичких кодова одвојених зарезима. Пример: en,sr,de,fr,it';
$string['configlangmenu'] = 'Одаберите желите ли приказати падајући мени за одабир језика интерфејса на почетној страници, страници за пријављивање на систем, итд. Ово подешавање не онемогућава кориснике у одабиру жељеног језика у њиховом личном профилу.';
$string['configlangstringcache'] = 'Кешира све изразе језика у компајлиране датотеке у директоријуму за податке. Ако преводите Moodle или вршите измене израза у изворном коду Moodlea, онда ћете можда желети да ово искључите. Иначе оставите га укључено да видите напредак у раду.';
$string['configlatinexcelexport'] = 'Одаберите кодирање за извоз Excel докумената.';
$string['configlocale'] = 'Одаберите локална подешавања на нивоу целог сајта, што ће утицати на облик приказа и језик на којем се исписују датуми. Неопходно је да у оквиру Вашег оперативног система имате инсталирану подршку за  одговарајући језик (нпр. eng_US или sr). Ако не знате шта бисте одабрали, оставите ово поље празним.';
$string['configloginhttps'] = 'Уколико укључите ову опцију Moodle ће користити безбедну https конекцију само за страницу за приступ сајту, а након тога ће се вратити на нормални http URL, повећавајући тиме брзину рада. ОПРЕЗ: ово подешавање ЗАХТЕВА да https буде експлицитно омогућен на веб серверу - ако није МОЖЕТЕ ДОЋИ У СИТУАЦИЈУ ДА САМИ СЕБИ ОНЕМОГУЋИТЕ ПРИСТУП САЈТУ.';
$string['configloglifetime'] = 'Ово подешавање одређује колико дуго желите да чувате записе о активностима корисника. Записи који су старији биће аутоматски обрисани. Најбоље је да записе о активностима чувате што је могуће дуже, у случају да вам затребају, али уколико имате јако оптерећен сервер и уколико имате проблеме са његовим перформансама, можете скратити временски период њиховог чувања. Вредности мање од 30 дана се не препоручују зато што статистика можда неће исправно радити.';
$string['configlookahead'] = 'Дана унапред за праћење';
$string['configmaxbytes'] = 'Ово подешавање одређује максималну величину постављених датотека на нивоу целог сајта. Вредности овог подешавања су ограничене PHP подешавањима post_max_size и upload_max_filesize, као и Apache подешавањем LimitRequestBody. Заузврат, maxbytes ограничава опсег величина које се могу бирати на нивоу курса или модула. Ако изаберете опцију \'Ограничење сервера\' биће коришћена максимaлна вредност коју дозвољава сервер.';
$string['configmaxconsecutiveidentchars'] = 'Лозинке не смеју имати више од овог броја истоветних карактера за редом. Употребите 0 како бисте искључили ову опцију.';
$string['configmaxeditingtime'] = 'Одређује време које корисници имају на располагању за накнадно уређивање порука на форумима, коментара у речницима итд. Обично је 30 минута сасвим довољно.';
$string['configmaxevents'] = 'Број догађаја за праћење унапред';
$string['configmaxusersperpage'] = 'Максималан број корисника који се приказује унутар бирача корисника за курс, групу, кохорту, веб сервис итд.';
$string['configmessaging'] = 'Да ли омогућити корисницима сајта коришћење система за инстант поруке?';
$string['configmessagingallowemailoverride'] = 'Дозволи да се корисницима обавештења шаљу на адресу е-поште различиту од оне која је наведена у њиховом профилу';
$string['configmessagingdeletereadnotificationsdelay'] = 'Обавештења о читању могу се обрисати да се сачува простор. Након колико времена после читања могу бити обрисана?';
$string['configmessaginghidereadnotifications'] = 'Сакрити обавештења о читању у вези са догађајима као што су поруке на форумима када се прегледа историја порука';
$string['configminpassworddigits'] = 'Лозинке морају имати најмање оволико бројева.';
$string['configminpasswordlength'] = 'Лозинке морају да садрже најмање оволико карактера.';
$string['configminpasswordlower'] = 'Лозинке морају да садрже најмање оволико малих слова.';
$string['configminpasswordnonalphanum'] = 'Лозинке морају да садрже најмање оволико не-алфанумеричких карактера.';
$string['configminpasswordupper'] = 'Лозинке морају да садрже најмање оволико великих слова.';
$string['configmobilecssurl'] = 'CSS датотека за прилагођавање интерфејса ваше мобилне апликације';
$string['configmodchooserdefault'] = 'Да ли бирач активности треба да буде приказан кориснику';
$string['configmycoursesperpage'] = 'Максималан број курсева за приказ на било којој корисниковој листи курсева';
$string['configmymoodleredirect'] = 'Ово подешавање чини обавезним преусмеравање на /my при приступу систему свих корисника осим администратора и мења поставку основног нивоа сајта на /my';
$string['configmypagelocked'] = 'Ово подешавање спречава да корисници који нису администратори уређују подразумеване странице, попут насловне странице сајта.';
$string['confignavcourselimit'] = 'Ограничите број курсева који ће бити приказани корисницима у ситуацији када или нису нису пријављени на систем или нису уписани ни на један курс.';
$string['confignavshowallcourses'] = 'Ово подешавање одређује да ли корисници, уписани на курсеве, могу у блоку за навигацију, поред ставке \'Моји курсеви\' (списак курсева на које су уписани). да виде и ставку \'Курсеви\' (списак свих курсева).';
$string['confignavshowcategories'] = 'Прикажи категорије курсева у навигационој траци и у блоковима за навигацију Ово се не односи на курсеве у које је корисник тренутно уписан, јер ће курсеви, без категорија, бити наведени у менију под Моји курсеви (mycourses).';
$string['confignotifyloginfailures'] = 'Уколико систем региструје неуспешне приступе, обавештења о томе биће послата електронском поштом. Ко би требало да види та обавештења?';
$string['confignotifyloginthreshold'] = 'Уколико је опција за регистровање неуспешних приступа активна, колики је минимум погрешних приступа по једном кориснику односно једној IP адреси неопходан да би обавештење о томе било послато?';
$string['confignotloggedinroleid'] = 'Корисници који нису пријављени на систем биће третирани као да им је ова улога додељена у контексту сајта. Скоро увек је улога госта оно што бисте пожелели за такве случајеве, али на овај начин имате могућност да користите улоге креиране као мање или више рестриктивне. Ипак, акције као што је слање порука на форуме и томе слично захтевају да корисник прописно приступи систему.';
$string['configopentogoogle'] = 'Уколико укључите ово подешавање, онда ће Google-у бити омогућено да улази на Ваш сајт као гост. Осим тога људи који на Ваш сајт буду долазили посредством Google претрага аутоматски ће бити пријављени као гости. Напомена: ово омогућава приступ само оним курсевима који и иначе дозвољавају приступ са налогом за госта.';
$string['configoverride'] = 'Дефинисано у config.php датотеци';
$string['configpasswordpolicy'] = 'Укључивање ове опције ће омогућити да Мoodle проверава корисничке лозинке у складу са важећим правилима за креирање лозинки. Користите подешавања испод да бисте специфицирали своја правила (она ће бити игнорисана ако ову опцију поставите на \'Не\').';
$string['configpasswordresettime'] = 'Ово одређује време које корисници имају на располагању како би потврдили захтев за ресетовање лозинке, пре него што оно истекне. Обично је 30 минута сасвим одговарајуће време.';
$string['configpathtoclam'] = 'Путања до Clam AV алата. Вероватно нешто попут /usr/bin/clamscan или /usr/bin/clamdscan. Ову вредност је потребно унети да би се користио Clam AV.';
$string['configpathtodu'] = 'Путања до du. Вероватно нешто попут /usr/bin/du. Aко ово унесете, странице које приказују садржај директоријума ће радити много брже за директоријуме са много датотека.';
$string['configperfdebug'] = 'Ако ово укључите, информације о перформансама биће приказане у подножју стандардне графичке теме';
$string['configprofileroles'] = 'Списак улога које су видљиве на корисничким профилима и страници са списком учесника.';
$string['configprofilesforenrolledusersonly'] = 'Да би се спречила злоупотреба од стране спамера, поље за опис на страници са профилом корисника, који се још нису уписали ни на један курс, је сакривено. Нови корисници морају да се упишу барем на један курс како би могли да додају опис.';
$string['configprotectusernames'] = 'По подразумеваним подешавањима forget_password.php не приказује никакву помоћ за погађање корисничких имена или адреса електронске поште.';
$string['configproxybypass'] = 'Списак са ставкама одвојеним зарезом (делова) имена сервера домаћина или IP адреса које би требало да премосте посреднички сервер (Proxy)(e.g., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Уколико <b>сервер</b> мора да користи прокси рачунар (нпр. "заштитни зид") за приступ Интернету, унесите овде његову адресу и порт. У супротном оставите ово поље празно.';
$string['configproxypassword'] = 'Лозинка потребна за приступ интернету путем прокси сервера, уколико је то неопходно. Оставите празно уколико прокси сервер није потребан (неопходна је PHP cURL екстензија)';
$string['configproxyport'] = 'Ако овај сервер мора да користи proxy рачунар, наведите овде proxy порт.';
$string['configproxytype'] = 'Тип веб Proxy сервера(PHP5 и cURL екстентија су неопходни за подршку за SOCKS5)';
$string['configproxyuser'] = 'Корисничко име потребно за приступ Интернету путем Proxy сервера уколико је то неопоходно. Оставити празно уколико Proxy није потребан (неопходна је PHP cURL екстензија)';
$string['configquarantinedir'] = 'Уколико желите да Clam AV премести инфициране датотеке у карантин, упишите путању до директоријума предвиђеног за карантин. Веб серверу мора бити дозвољен упис у овај директоријум. Ако оставите ово поље празно или унесете директоријум који не постоји или ако се у њега не може уписивати, инфициране датотеке биће обрисане. Немојте ставити косу црту на крају путање.';
$string['configrecaptchaprivatekey'] = 'Низ знакова који се користи за комуникацију између вашег Moodle сервера и recaptcha.net сервера. Набавите низ за овај веб сајт на http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Низ знакова који се користи за приказ reCAPTCHA елемента на обрасцу за пријаву. Низ генерише http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Дозволи избор категорије приликом подношења захтева за курс.';
$string['configrequestedstudentname'] = 'Реч за полазника која се користи у захтеваним курсевима';
$string['configrequestedstudentsname'] = 'Реч за полазнике која се користи у захтеваним курсевима';
$string['configrequestedteachername'] = 'Реч за предавача која се користи у захтеваним курсевима';
$string['configrequestedteachersname'] = 'Реч за предаваче која се користи у захтеваним курсевима';
$string['configrequiremodintro'] = 'Искључите ову опцију уколико не желите да приморавате кориснике да уносе опис сваке активности.';
$string['configrunclamavonupload'] = 'Ако је ова опција омогућена, clam AV ће бити коришћен за проверу свих постављених датотека.';
$string['configrunclamonupload'] = 'Користити Clam AV при постављању датотека? Да би ово  подешавање успешно радило, морате навести тачну путању до директоријума у којем се налази Clam AV. (Clam AV је БЕСПЛАТНИ антивирусни софтвер који можете преузети са http://www.clamav.net/)';
$string['configsectioninterface'] = 'Интерфејс';
$string['configsectionmail'] = 'Пошта';
$string['configsectionmaintenance'] = 'Одржавање';
$string['configsectionmisc'] = 'Разно';
$string['configsectionoperatingsystem'] = 'Оперативни систем';
$string['configsectionpermissions'] = 'Дозволе';
$string['configsectionrequestedcourse'] = 'Захтев за курсом';
$string['configsectionsecurity'] = 'Безбедност';
$string['configsectionstats'] = 'Статистика';
$string['configsectionuser'] = 'Корисник';
$string['configsecureforms'] = 'Moodle може да користи додатни ниво безбедности када прима податке из веб форми. Уколико је то омогућено, онда се HTTP_REFERER променљива веб читача упоређује са текућом адресом форме. У веома малом броју случајева то може проузрокавати проблеме ако корисник употребљава "заштитни зид" (нпр. Zonealarm) конфигурисан тако да уклања HTTP_REFERER променљиву из веб саобраћаја. Последица тога је тзв. "заглављивање у форми". Уколико Ваши корисници имају проблема, на пример, са страницом за пријаву, можда ћете желети да онемогућите ово подешавање, иако ће то Ваш сајт учинити далеко осетљивијим на хакерске нападе разбијања лозинки грубом силом. Уколико сте у дилеми, омогућите ову опцију.';
$string['configsessioncookie'] = 'Ово подешавање прилагођава име "колачића" за Moodle сесије. Подешавање је опционо и корисно је само да би се избегла мешање "колачића", у ситуацији када је у оквиру истог веб сајта покренуто више од једне копије Moodlea.';
$string['configsessioncookiedomain'] = 'Ово Вам дозвољава да мењате домен са ког су Moodle колачићи доступни. То је корисно за разна прилагођавања Moodlea (нпр. додаци за проверу идентитета или упис) који морају да деле информације о Moodle сесији са веб апликацијом на другом поддомену. <strong>УПОЗОРЕЊЕ: топло препоручујемо да ово подешавање оставите празно (подразумевана вредност) - неисправна вредност ће спречити било какву пријаву на сајт.</strong>';
$string['configsessioncookiepath'] = 'Ако је потребно да промените где веб читачи шаљу Moodle "колачиће", можете променити ово подешавање тако што ћете одредите поддиректоријум свог веб сајта. Иначе, стандардна вредност \'/\' требало би да је сасвим прихватљива.';
$string['configsessiontimeout'] = 'Уколико су корисници који су пријављени на сајт, неактивни дужи временски период (не учитавају странице), биће аутоматски одјављени (њихове сесије биће завршене). Ова променљива одређује колики би требао бити тај временски период.';
$string['configshowcommentscount'] = 'Прикажи број коментара. Биће потребно извршити само један упит више приликом приказа линка коментара.';
$string['configshowicalsource'] = 'Прикажи изворне информације за ical догађаје';
$string['configshowsiteparticipantslist'] = 'Сви ови полазници и предавачи на нивоу сајта биће приказани на списку учесника. Коме ће бити дозвољено да види овај списак учесника?';
$string['configsitedefaultlicense'] = 'Подразумевана лиценца сајта';
$string['configsitedefaultlicensehelp'] = 'Подразумевана лиценца за објављивање садржаја на овом сајту';
$string['configsitemaxcategorydepth'] = 'Максималан број поткатегорија';
$string['configsitemaxcategorydepthhelp'] = 'Ово одређује максималан број поткатегорија који ће се појавити када се приказују категорије или комбинована листа. Нижи ниво категорија ће појавити као линкови које ће корисник моћи да прошири помоћу AJAX захтева.';
$string['configslasharguments'] = 'Датотеке (слике, постављене датотеке и сл.) су доступне помоћу скрипте која користи тзв. slash аргумент. Овај метод омогућава да датотеке буду лакше кеширане у веб читачу, прокси серверима итд. Нажалост, неки PHP сервери не дозвољавају коришћење овог метода, тако да уколико имате проблема да видите постављене датотеке или слике (нпр. слике корисника), онда онемогућите ово подешавање.';
$string['configsmartpix'] = 'Ако се ова опција укључи иконице ће учитавати PHP скрипт који претражује текућу графичку тему сајта, потом све надређене теме, и коначно Moodle /pix директоријум. Ово смањује потребу за чувањем дупликата слика унутар тема, али помало утиче на перформансе система.';
$string['configstartwday'] = 'Дан којим почиње радна недеља';
$string['configstatsfirstrun'] = 'Ово одређује колики временски интервал се узима у обзир при процесирању извештаја о активностима <b>први пут</b> када cronjob жели да процесира статистичке податке. Ако имате доста саобраћаја и на дељеном сте серверу, вероватно није добра идеја да идете превише уназад, јер би могло бити потребно превише времена за извршавање процеса и та активност би била прилично захтевна за сервер. (Приметите да је за ово подешавање 1 месец = 28 дана. На графиконима и извештајима који се генеришу 1 месец одговара једном календарском месецу.)';
$string['configstatsmaxruntime'] = 'Процесирање статистичких података може бити прилично интензивно, па користите комбинацију овог и следећег поља да специфицирате када ће се оно извршавати и колико дуго ће трајати.';
$string['configstatsmaxruntime2'] = 'Статистичка обрада може бити прилично интезивна. Одредите максимално време које се допушта за прикупљање статистичких података за један дан. Максимални број дана који се обрађује у једном извршењу crona је 31.';
$string['configstatsmaxruntime3'] = 'Ово одређује максимално дозвољено време за израчунавање статистике за један дан. Имајте у виду да процесирање статистичких података може у великој мери оптеретити сервер. Максимална број дана обрађених у једном крону може бити доле одређен.';
$string['configstatsruntimedays'] = 'Ово одређује максималан број дана који се обрађује приликом сваког процесуирања статистике. Када је статистика ажурна, само ће се један дан обрађивати - зато подесите ову вредност зависно од оптерећења вашег сервера, смањујући је ако су потребна краћа покретања crona.';
$string['configstatsruntimestart'] = 'У које време треба да започне са извршавањем cronjob који процесира статистичке податке? Уколико на серверу има више Moodle сајтова, препоручљиво је навести различита времена.';
$string['configstatsuserthreshold'] = 'Ово подешавање одређује минималан број уписаних корисника, потребан да би курс био укључен у статистичко израчунавање.';
$string['configstrictformsrequired'] = 'Ако је ово подешавање омогућено, корисницима неће бити дозвољено да уносе размак или прелаз у нови ред, али само унутар обавезних поља у обрасцима.';
$string['configstripalltitletags'] = 'Искључите ово подешавање да бисте омогућили HTML ознаке у именима активности и ресурса.';
$string['configsupportemail'] = 'Ова адреса електронске поште ће се приказивати корисницима сајта као она на коју треба писати кад им је потребна нека општа помоћ (на пример кад нови корисници креирају своје налоге). Ако се не попуни ово поље, онда таква корисна адреса неће бити доступна.';
$string['configsupportname'] = 'Ово је име особе/организације задужене за пружање опште помоћи корисницима путем електронске поште или веб сајта.';
$string['configsupportpage'] = 'Ова веб адреса ће се приказивати корисницима сајта као она коју треба посетити у случају да им затреба нека општа помоћ (на пример кад нови корисници креирају своје налоге). Ако се не попуни ово поље, такав линк неће бити доступан.';
$string['configthemedesignermode'] = 'Уобичајено је да се све слике графичке теме као и CSS датотеке на дужи временски период кеширају у веб читачу и на серверу, због брзине извршавања. Ако дизајнирате теме или развијате изворни кôд, вероватно ћете желите да укључити овај режим рада како би сте избегли да добијате верзије из кеша. Упозорење: ово ће успорити ваш сајт за све кориснике! Алтернативно, можете да ресетујете кеш ручно на страници за избор теме.';
$string['configthemelist'] = 'Оставите ово поље празно да бисте дозволили употребу било које графичке теме. Уколико желите да скратите листу тема, овде можете да наведите списак њихових назива, раздвојених зарезима (немојте користити размаке!).
На пример: standard,orangewhite.';
$string['configtimezone'] = 'Ово је подразумевана временска зона за приказивање датума - сваки корисник може да промени ово подешавање у свом профилу. "Временска зона сервера" овде подешена услови ће да Moodle као подразумевану вредност користи PHP подешавање сервера. Уколико корисник у свом профилу изабере опцију "Временска зона сервера" за њега ће подразумевана временска зона бити она коју овде подесите. Препоручује се да ажурирате временске зоне, а затим изаберите временску зону која одговара вашем региону.';
$string['configuseblogassociations'] = 'Да ли је потребно да корисници могу да организују своје блогове повезивањем чланака са курсевима и модулима курса?';
$string['configuseexternalyui'] = 'Уместо локалних датотека, користите онлајн датотеке доступне на Yahoo серверима. УПОЗОРЕЊЕ: Ово захтева интернет конекцију, или AJAX уопште неће радити на вашем сајту.';
$string['configuserquota'] = 'Максималан број бајтова које корисник може да сачува у свом простору за приватне датотеке. {$a->bytes} бајтова == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Ако је ово подешавање омогућено, онда ће се у навигацији за странице сајта, уместо фразе \'Странице сајта\', користити скраћени назив сајта.';
$string['configusetags'] = 'Да ли треба омогућити ознаке (тагове) на читавом сајту?';
$string['configvariables'] = 'Променљиве';
$string['configverifychangedemail'] = 'Омогући потврду промењених е-адреса који користећи подешавање за дозвољене и забрањене домене е-адреса. Уколико је ово подешавање искључено ограничење домена ће бити коришћено само приликом креирања нових корисничких налога.';
$string['configvisiblecourses'] = 'Нормално приказује курсеве који су у скривеним категоријама.';
$string['configwarning'] = 'Будите опрезни при мењању ових подешавања - чудне вредности могу изазвати проблеме у раду.';
$string['configyuicomboloading'] = 'Ова опција омогућава оптимизацију учитавања комбинованих датотека YUI библиотека. Ово подешавање треба да буде укључено на продукционим сајтовима због бољих перформанси.';
$string['confirmation'] = 'Потврда';
$string['confirmdeletecomments'] = 'Обрисаћете коментаре. Да ли сте сигурни?';
$string['confirmed'] = 'Потврђено';
$string['convertformat'] = '<i>конвертуј</i> излазни формат';
$string['cookiehttponly'] = 'Само http колачићи';
$string['cookiesecure'] = 'Само безбедни колачићи';
$string['country'] = 'Подразумевана држава';
$string['coursecontact'] = 'Курс - контакт особе';
$string['coursecontact_desc'] = 'Ово подешавање вам омогућава да одредите ко се појављује на страници са описом курса. Корисници морају да имају барем једну од ових улога на курсу како би њихова имена била приказани поред описа тог курса.';
$string['courselistshortnames'] = 'Прикажи пуне називе курсева';
$string['courselistshortnames_desc'] = 'Ако је ова опција омогућена, на списку курсева ће, поред пуних назива, бити приказани и скраћени називи курсева. Ако је неопходно, проширени називи курсева се могу прилагодити уређивањем језичког стринга \'courseextendednamedisplay\', користећи могућност за прилагођавање језика.';
$string['coursemgmt'] = 'Управљање курсевима и категоријама';
$string['courseoverview'] = 'Преглед курсева';
$string['courserequestnotify'] = 'Обавештење о захтеву за покретање новог курса';
$string['courserequestnotifyemail'] = 'Корисник {$a->user} је затражио/ла нови курс на {$a->link}';
$string['courserequests'] = 'Захтеви за покретање новог курса';
$string['courserequestspending'] = 'Захтеви за покретање курс на чекању';
$string['courses'] = 'Курсеви';
$string['coursesperpage'] = 'Курсева по страници';
$string['courseswithsummarieslimit'] = 'Број курсева са резимеом';
$string['creatornewroleid'] = 'Улога креатора у новим курсевима';
$string['creatornewroleid_help'] = 'Уколико корисник већ нема овлашћења да управља новим курсом, онда је аутоматски уписан користећи ову улогу';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Покретање Cronа искључиво преко командне линије';
$string['cronerrorclionly'] = 'Жалим, интернет приступ овој страници је онемогућен од стране администратора.';
$string['cronerrorpassword'] = 'Жао нам је, нисте унели исправну лозинку да бисте приступили овој страници';
$string['cron_help'] = 'Cron.php помаже неким од Moodle модула у обављању задатака у правилним временским  интервалима, као што је слање копија нових порука са форума путем е-поште. Потребно је редовно покретање cron скрипте, нпр. на сваких 5 минута.';
$string['cronremotepassword'] = 'Cron лозинка за удаљени приступ';
$string['cronwarning'] = '<a href="cron.php">cron.php скрипт за одржавање</a> није покретан најмање последњa 24 сата.';
$string['ctyperecommended'] = 'Инсталирање опционе PHP екстензије ctype се строго препоручује да би се унапредило функционисање сајта, поготово ако Ваш сајт подржава не-латиничне језике.';
$string['ctyperequired'] = 'PHP екстензије ctype је сада обавезна за Moodle, да би се унапредило функционисање сајта и да би се нудила вишејезична компатибилност.';
$string['curlcache'] = 'cURL кеш TTL';
$string['curlrecommended'] = 'Инсталирање опционе cURL библиотеке је врло препоручљиво, да би се омогућило коришћење функција за умрежавање (Moodle Networking).';
$string['curlrequired'] = 'PHP екстензија cURL сада је обавезна за Moodle због комуникације са Moodle репозиторијумима.';
$string['curltimeoutkbitrate'] = 'Брзина протока у битовима која се користи приликом израчунвања cURL тајмаута (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ово подешавање се користи за израчунавање одговарајућег тајм-аута код великих cURL захтева. Као део овог прорачуна креира се HTTP HEAD захтев како би се одредила величина садржаја. Постављањем овог параметра на 0 онемогућава се креирање овог захтева.';
$string['currenttheme'] = 'Тренутна графичка тема';
$string['customcheck'] = 'Друге провере';
$string['custommenu'] = 'Прилагођени мени';
$string['custommenuitems'] = 'Ставке прилагођеног менија';
$string['datarootsecurityerror'] = '<p><strong>БЕЗБЕДНОСНО УПОЗОРЕЊЕ!</strong></p><p>Ваш директоријум са подацима је на погрешном месту и могуће му је приступити са веба. То значи да су све ваше приватне датотеке доступне свакоме ко има приступ интернету, па неке од њих могу искористити злонамерни корисници како би добили неауторизован администраторски приступ вашем сајту!</p>
<p><em>Морате</em> да преместите директоријум са подацима ({$a}) на нову локацију која није у оквиру вашег јавног веб директоријума, а потом да ажурирате <code>$CFG->dataroot</code> подешавање у датотеци config.php у складу са начињеним променама.</p>';
$string['datarootsecuritywarning'] = 'Конфигурација вашег сајта можда није безбедна. Молимо проверите да ли ваш директоријум података ({$a}) није директно доступан преко веба.';
$string['dbmigrate'] = 'Миграција Moodle базе података';
$string['dbmigrateconnecerror'] = 'Није могуће успоставити везу са специфицираном базом података.';
$string['dbmigrateencodingerror'] = 'Специфицирана база података има кодирање {$a}, а не неопходно UNICODE/UTF8.<br />Молимо наведите другу базу.';
$string['dbmigratepostgres'] = 'Чини се да користите PostgreSQL као сервер базе података. Да бисте наставили са миграционим процесом морате ручно креирати нову базу са кодирањем "UNICODE"(PostgreSQL 7) или "UTF8" (PostgreSQL 8) за чување мигрираних података. Молимо унесите подешавања за повезивање са Вашом новом базом података испод да бисте наставили:';
$string['dbmigratewarning'] = 'Пре него што започнете ову процедуру, молимо проверите да ли сте направили резервну копију своје Moodle базе података. Ако нисте сигурни како да то урадите, контактирајте свог систем администратора. Ваш Moodle сајт ће бити стављен у режим одржавања након што започнете процес миграције';
$string['dbmigratewarning2'] = '<b>Упозорење: Управо ћете започети процес миграције базе података. Молимо проверите да ли је направљена резервна копија Ваше комплетне Moodle базе података.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Ова база података мигрирана је на нову UTF8 базу, те се сматра застарелом. Молимо подесите Вашу config.php датотеку и користите нову базу података за ову Moodle верзију.</font>';
$string['dbmigrationdupfailed'] = 'Дуплирање базе података није успело. Могућа грешка  до које је дошло је:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Коришћење базе података за информације о сесијама';
$string['debug'] = 'Поруке за отклањање грешака';
$string['debugall'] = 'СВЕ: Прикажи све разумљиве PHP поруке о грешкама';
$string['debugdeveloper'] = 'РАЗВОЈНЕ: Прикажи додатне Moodle поруке о грешкама, намењене само програмери';
$string['debugdisplay'] = 'Прикажи поруке за отклањање грешака';
$string['debugging'] = 'Отклањање грешака';
$string['debugminimal'] = 'МИНИМАЛНО: Прикажи само фаталне грешке';
$string['debugnone'] = 'БЕЗ ПОРУКЕ: Не приказуј грешке или упозорења';
$string['debugnormal'] = 'НОРМАЛНО: Прикажи грешке, упозорења и обавештења';
$string['debugpageinfo'] = 'Прикажи информације о страници';
$string['debugsmtp'] = 'Отклањање грешака током слања е-поште';
$string['debugstringids'] = 'Прикажи порекло језичких израза';
$string['debugstringids_desc'] = 'Ова опција је осмишљена како би  помогла преводиоцима. Када је ова опција омогућена, ако URL адреси додате параметар strings=1, то ће приказати језичку датотеку и id стрингa поред сваког стринга (израза).';
$string['debugvalidators'] = 'Прикажи линк ка сервисима за проверу валидности';
$string['defaultcity'] = 'Подразумевани град';
$string['defaultcity_help'] = 'Град који овде унесете биће подразумевани град за све новоотворене корисничке налоге.';
$string['defaultformatnotset'] = 'Грешка приликом одређивања подразумеваног формата курса. Проверите подешавања сајта.';
$string['defaulthomepage'] = 'Подразумавана почетна страница за кориснике';
$string['defaultrequestcategory'] = 'Подразумевана категорија за захтеване курсеве';
$string['defaultsettinginfo'] = 'Подразумевана вредност: {$a}';
$string['defaultuserroleid'] = 'Подразумевана улога за све кориснике';
$string['deleteincompleteusers'] = 'Oбриши непотпуне корисничке налоге након';
$string['deleteunconfirmed'] = 'Обриши непотврђене кориснике након';
$string['deleteuser'] = 'Обриши корисника';
$string['density'] = 'Густина';
$string['denyemailaddresses'] = 'Недозвољени домени е-поште';
$string['development'] = 'Развој';
$string['devicedetectregex'] = 'Регуларни изрази за детекцију уређаја';
$string['devicedetectregex_desc'] = '<p>Стандардно, Moodle може да детектује подразумевани тип уређаја (стони и преносиви рачунари итд.), мобилни уређај (паметни телефони, ручни рачунари) таблет (iPad, Android таблети) као и старије типове веб читача (Internet Explorer 6 корисници). Помоћу селектора графичке теме могуће је за сваки од ових типова уређаја подесити засебну тема. Ово подешавање дозвољава коришћење регуларних израза који омогућавају детекцију додатних типова уређаја (ови имају предност у односу на подразумеване типове).</p>
<p>На пример, можете да унесете регуларни израз \'/(MIDP-1.0|Maemo|Windows CE)/\'  за детекцију неких најчешће коришћених телефона додајте повратну вредност \'featurephone\'. Ово додаје \'featurephone\' у селектор графичке темe што ће вам омогућити да додате тему која ће се користити на овим уређајима. Остали телефони ће и даље користити тему која је изабрана за мобилне уређаје.</p>';
$string['devicedetectregexexpression'] = 'Регуларни изрази';
$string['devicedetectregexvalue'] = 'Повратна вредност';
$string['devicetype'] = 'Тип уређаја';
$string['disableuserimages'] = 'Искључи слике у корисничком профилу';
$string['displayerrorswarning'] = 'Омогућавање подешавања у PHP-у <em>display_errors</em> није препоручљиво на продукционим сајтовима, јер неке поруке о грешкама могу открити осетљиве информације о вашем серверу.';
$string['displayloginfailures'] = 'Прикажи неуспешне пријаве';
$string['dndallowtextandlinks'] = 'Постављање текста/линкова помоћу опције \'превуци и спусти\'';
$string['docroot'] = 'Коренски директоријум Moodle документације';
$string['doctonewwindow'] = 'Отворити у новом прозору';
$string['download'] = 'Преузми';
$string['edithelpdocs'] = 'Уређивање докумената помоћи';
$string['editingnoncorelangfile'] = 'Покушавате да уредите превод додатка (додатног модула). Можете сачувати превод независних (3rd party) модула само у свом локалном ( _local) директоријуму. Можда ћете желети да преместити датотеку са преводом у језички директоријум модула и/или да га пошаљете особи која одржава додатни модул.';
$string['editlang'] = '<b>Уређивање</b>';
$string['editorbackgroundcolor'] = 'Боја позадине';
$string['editordictionary'] = 'Едитор речника';
$string['editorfontfamily'] = 'Фамилија фонтова';
$string['editorfontlist'] = 'Списак фонтова';
$string['editorfontsize'] = 'Величина фонта';
$string['editorhidebuttons'] = 'Скривена дугмад';
$string['editorkillword'] = 'Филтер Word формата';
$string['editorspelling'] = 'Едитор правописа';
$string['editorspellinghelp'] = 'Укључи/искључи проверу правописа. Када је укључено, <strong>aspell</strong> мора бити инсталиран на серверу.';
$string['editstrings'] = 'Уређивање речи или израза';
$string['emailchangeconfirmation'] = 'Потврда измене адресе е-поште';
$string['emoticonalt'] = 'Алтернативни текст';
$string['emoticoncomponent'] = 'Графичка компонента емотикона';
$string['emoticonimagename'] = 'Назив слике';
$string['emoticons'] = 'Емотикони';
$string['emoticons_desc'] = 'На овој страници можете подесити емотиконе који се користе на вашем сајту. Како бисте уклонили ред из табеле (односно неки емотикон) обришите садржај било ког од захтеваних поља и сачувајте образац. За додавање новог емотикона, попуните поља у последњем празном реду. За ресетовање свих поља на подразумеване, почетне вредности кликните на горњи линк.

* Текст (обавезно) - овај текст ће бити замењен са сликом емотикона. Мора садржати бар 2 карактера.
* Назив слике (обавезно) - назив датотека са сликом емотикона (без екстензије), релативно у односу на pix директоријум компоненте.
* Графичка компонента (обавезно) - компонента која обезбеђује иконицу.
* Алтернативни текст (опционо) - идентификатор стринга и компонента алтернативног текста емотикона.';
$string['emoticonsreset'] = 'Ресетуј подешавања емотикона на подразумеване вредности';
$string['emoticontext'] = 'Текст';
$string['emptysettingvalue'] = 'Празно';
$string['enableajax'] = 'Укључи AJAX';
$string['enableblogs'] = 'Омогући блог';
$string['enablecalendarexport'] = 'Омогући извоз календара';
$string['enablecomments'] = 'Омогући коментаре';
$string['enablecourserequests'] = 'Омогући слање захтева за покретање нових курсева';
$string['enablecssoptimiser'] = 'Омогући оптимизацију CSS-а';
$string['enablecssoptimiser_desc'] = 'Када је ова опција омогућена CSS ће пре кеширања бити покренут кроз процес оптимизације. Овај процес обрађује CSS тако што уклања дупликате правила и стилова, као и размаке који се могу уклонити, и тако што га реформатира. Молимо вас, имајте у виду да укључивање ове опције у исто време када је укључен и режим за дизајнирање тема, има озбиљне последице на перформансе система, али помаже дизајнерима тема да креирају оптимизовани CSS.';
$string['enabled'] = 'Омогућено';
$string['enabledevicedetection'] = 'Омогућите детекцију уређаја';
$string['enablegravatar'] = 'Омогући Граватар';
$string['enablegravatar_help'] = 'Када је ова опција омогућена Moodle ће покушати да преузме слику за профил са Граватара, ако корисник није поставио своју слику.';
$string['enablegroupmembersonly'] = 'Омогући само члановима групе';
$string['enablemobilewebservice'] = 'Омогућите веб сервисе за мобилне уређаје';
$string['enablerecordcache'] = 'Укључи кеш за запис података';
$string['enablerssfeeds'] = 'Омогући RSS изворе вести';
$string['enablesafebrowserintegration'] = 'Омогући Safe Exam Browser интеграцију';
$string['enablestats'] = 'Омогући статистику';
$string['enabletgzbackups'] = 'Омогући нови формат резервне копије';
$string['enabletgzbackups_desc'] = 'Ако је ова опција омогућена, будуће резервне копије биће креиране у новом компримованом формату за .mbz датотеке (интерно ускладиштене као .tar.gz датотека). Ово уклања ограничење величине датотеке резервне копије од 4GB и може да унапреди перформансе система. Процес рестаурације резервне копије подржава оба формата, а разлика између њих треба да буде транспарентна за кориснике.';
$string['enabletgzbackups_nozlib'] = 'PHP екстензија ‘zlib’ није доступна. Нови формат резервне копије почива на овој екстензији и биће онемогућен све док  zlib не буде инсталиран и омогућен.';
$string['enabletrusttext'] = 'Омогући поуздани садржај';
$string['enablewebservices'] = 'Омогући веб сервисе';
$string['enablewsdocumentation'] = 'Документација веб сервиса';
$string['enrolinstancedefaults'] = 'Подразумеване вредности инстанце уписа';
$string['enrolinstancedefaults_desc'] = 'Подразумевана подешавања уписа у новим курсевима';
$string['enrolmultipleusers'] = 'Уписати кориснике';
$string['environment'] = 'Окружење';
$string['environmenterrortodo'] = 'Морате решити све проблеме окружења (грешке) наведене изнад пре наставка инсталације ове Moodle верзије!';
$string['environmenterrorupgrade'] = 'УПОЗОРЕЊЕ: Требате решити све пронађене проблеме окружења (грешке) пре него што наставите надоградњу Мудлеа. Прелаз на нову верзију без исправљања пронађених грешака могу довести до губитка података. Да ли сте сигурни да желите да наставите надоградњу?';
$string['environmentmustfixsetting'] = 'PHP подешавање мора бити промењено.';
$string['environmentok'] = 'Ваше серверско окружење задовољава све минималне захтеве.';
$string['environmentrecommendcustomcheck'] = 'уколико овај тест не прође, постоји могућност појављивања потенцијалног проблема.';
$string['environmentrecommendinstall'] = 'је препоручљиво инсталирати/омогућити да би се добили најбољи резултати';
$string['environmentrecommendversion'] = 'препоручена верзија је {$a->needed} а Ви тренутно користите верзију {$a->current}';
$string['environmentrequirecustomcheck'] = 'Овај тест мора проћи';
$string['environmentrequireinstall'] = 'мора бити инсталиран и омогућен';
$string['environmentrequireversion'] = 'неопходна верзија је {$a->needed} а Ви тренутно користите верзију {$a->current}';
$string['environmentsettingok'] = 'детектовано је препоручено подешавање';
$string['environmentshouldfixsetting'] = 'PHP подешавање би требало бити промењено.';
$string['environmentxmlerror'] = 'Грешка у читању података окружења ({$a->error_code})';
$string['errordeletingconfig'] = 'У току брисања конфигурационог записа за додатак \'{$a}\' појавила се грешка.';
$string['errorsetting'] = 'Није могуће сачувати подешавање';
$string['errorwithsettings'] = 'Нека подешавања нису промењена због грешке.';
$string['everyonewhocan'] = 'Свако ко може \'{$a}\'';
$string['exceptions'] = 'изузеци';
$string['execpathnotallowed'] = 'Подешавање извршних путања у датотеци config.php је онемогућено';
$string['experimental'] = 'Експериментално';
$string['experimentalsettings'] = 'Експериментална подешавања';
$string['extendedusernamechars'] = 'Дозволити проширени избор карактера у корисничким именима';
$string['extramemorylimit'] = 'Додатно PHP меморијско ограничење.';
$string['fatalmagicquotesruntime'] = '<p>Уочена је озбиљна конфигурациона грешка. Молимо вас, обавестите администратореа.</p><p> Како би функционисао правилно Moodle захтева да администратор промени PHP подешавања.</p><p><code>magic_quotes_runtime</code> мора бити подешен на <code>off</code>.</p><p>Ово подешавање се може променти едитовањем <code>php.ini</code>датоотеке, конфигутацојом Apache/IIS севера<br />или <code>.htaccess</code> датотеке на серверу.</p>';
$string['fatalsessionautostart'] = '<p>Откривена је озбиљна конфигурациона грешка. Молимо Вас да обавестите администратора.</p><p> Како би функционисао правилно Moodle захтева да администратор промени PHP подешавања.</p>
<p><code>session.auto_start</code> мора бити подешен на <code>off</code>.</p>
<p>Ово подешавање се може променти едитовањем <code>php.ini</code>датотеке, конфигурацијом Apache/IIS севера<br />или <code>.htaccess</code> датотеке на серверу.</p>';
$string['filecreated'] = 'Креирана је нова датотека';
$string['filestoredin'] = 'Сними датотеку у директоријум:';
$string['filestoredinhelp'] = 'Где ће датотека бити смештена';
$string['filterall'] = 'Филтрирај све стрингове';
$string['filtermatchoneperpage'] = 'Поклапање филтера једном по страници';
$string['filtermatchonepertext'] = 'Поклапање филтера једном по тексту';
$string['filters'] = 'Филтери';
$string['filtersettings'] = 'Управљање филтерима';
$string['filtersettingsgeneral'] = 'Општа подешавања филтера';
$string['filteruploadedfiles'] = 'Филтрирај постављене датотеке';
$string['forcelogin'] = 'Приморај кориснике да се пријаве на систем';
$string['forceloginforprofileimage'] = 'Приморај кориснике да се пријаве на систем да би могли да виде слике корисника';
$string['forceloginforprofileimage_help'] = 'Ако је ово подешавање омогућено, корисници морају да буду пријављени на систем како би могли да виде слике других корисника. У супротном видеће подразумевану слику за корисника у свим електронским порукама.';
$string['forceloginforprofiles'] = 'Приморај кориснике да се пријаве на систем за профиле';
$string['forcetimezone'] = 'Обавезна временска зона';
$string['formatuninstallwithcourses'] = 'Постоји/е {$a->count} курс/а/ева који користе  {$a->format}. Формат ових курсева биће промењен у  {$a->defaultformat} (подразумевани формат за овај сајт). Неки подаци који су специфични за поједине формате могу се изгубити. Да ли сте сигурни да желите да наставите?';
$string['frontpage'] = 'Насловна страница';
$string['frontpagebackup'] = 'Резервна копија насловне странице';
$string['frontpagedefaultrole'] = 'Подразумевана улога за насловну страницу';
$string['frontpagefilters'] = 'Филтери насловне странице';
$string['frontpageloggedin'] = 'Ставке на насловној страници када је корисник пријављен на систем';
$string['frontpageoverrides'] = 'Промене овлашћења на насловној страници';
$string['frontpagequestions'] = 'Питања насловне странице';
$string['frontpagerestore'] = 'Рестаурација насловне странице';
$string['frontpageroles'] = 'Улоге на насловној страници';
$string['frontpagesettings'] = 'Подешавања насловне странице';
$string['fullnamedisplay'] = 'Формат пуног имена';
$string['fullnamedisplayprivate'] = 'Формат пуног имена - приватно';
$string['gdrecommended'] = 'GD екстензија се користи за конверзију слика; неке опције, као што су слике корисника на страници са профилом неће бити доступне уколико ова екстензија недостаје.';
$string['gdrequired'] = 'Moodle сада захтева GD екстензију за конверзију слика';
$string['generalsettings'] = 'Општа подешавања';
$string['geoipfile'] = 'GeoIP city датотека';
$string['getremoteaddrconf'] = 'Извор забележене IP адресе';
$string['globalswarning'] = '<p><strong>БЕЗБЕДНОСНО УПОЗЕРЕЊЕ!</strong></p><p> Како би могао да функционише исправно, Moodle захтева <br />да направите неке измене у вашим тренутним PHP подешавањима.<p/><p><em>Морате</em> да поставите <code>register_globals=off</code>.</p><p>Ово подешавање можете изменити тако што ћете уредити вашу <code>php.ini</code> датотеку, конфигурацију Apache/IIS веб сервера<br /> или <code>.htaccess</code> датотеку.</p>';
$string['googlemapkey3'] = 'Google Maps API V3 кључ';
$string['googlemapkey3_help'] = 'Да бисте користили Google Maps за лоцирање IP адресе потребно је да унесете специјални кључ. Кључ можете добити бесплатно на <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Иди на први израз који недостаје';
$string['gradebook'] = 'Евиденција оцена';
$string['gradebookroles'] = 'Оцене улога';
$string['gradeexport'] = 'Примарни методи за извоз оцена';
$string['gravatardefaulturl'] = 'URL адреса подразумеване Gravatar слике';
$string['gravatardefaulturl_help'] = 'Gravatar тражи подразумевану слику за приказивање, уколико није у могућности да пронађе слику датог корисника. Унесите пуну URL адресу слике. Ако подешавање оставите празно, Moodle ће покушати да употреби подразумевану слику која је најприкладнија за страницу коју посматрате. Имајте на уму да Граватар има низ кодова који могу да се користе за <a href="https://en.gravatar.com/site/implement/images/#default-image"> генерисање подразумеваних слика </a>.';
$string['groupenrolmentkeypolicy'] = 'Правила за лозинку за упис у групу';
$string['groupenrolmentkeypolicy_desc'] = 'Укључивањем ове опције Moodle ће проверавти лозинке за упис у групу према важећим правилима о лозинкама';
$string['guestroleid'] = 'Улога за госта';
$string['guestroleid_help'] = 'Ова улога се аутоматски додјељује госту. Она се додељује привремено и неуписаним корисницима који приступају курсу преко додатка за упис гостију.';
$string['helpadminseesall'] = 'Да ли администратори виде све догађаје из календара или само оне које се односе на њих?';
$string['helpcalendarcustomexport'] = 'Омогући опцију за прилагођени временски оквир у извозима календара. Претходно морају бити омогућени извози календара, како би ова опција била могућа.';
$string['helpexportlookahead'] = 'Колико дана унапред ће календар тражити дешавања приликом извоза, за опцију прилагођеног извоза?';
$string['helpexportlookback'] = 'Колико дана уназад ће календар тражити дешавања приликом извоза, за опцију прилагођеног извоза?';
$string['helpforcetimezone'] = 'Можете дозволити корисницима да сами изаберу временску зону, или их приморати да користе ону коју сте Ви изабрали.';
$string['helpshowicalsource'] = 'Ако је ова опција омогућена, назив претплате и линк биће приказани за iCal-увезене догађаје.';
$string['helpsitemaintenance'] = 'За надоградње и остале послове одржавања система';
$string['helpstartofweek'] = 'Којим даном започиње седмица у календару?';
$string['helpupcominglookahead'] = 'Колико дана унапред ће календар тражити предстојећа дешавања?';
$string['helpupcomingmaxevents'] = 'Колико се (максимално) наредних догађаја приказује корисницима?';
$string['helpweekenddays'] = 'Који дани у седмици се сматрају викендом и приказују у другој боји?';
$string['hiddenuserfields'] = 'Сакривање корисничких поља';
$string['hidefromall'] = 'Сакриј од свих корисника';
$string['hidefromnone'] = 'Не сакривати';
$string['hidefromstudents'] = 'Сакриј од полазника';
$string['htmleditor'] = 'HTML едитор';
$string['htmleditorsettings'] = 'Подешавања HTML едитора';
$string['htmlsettings'] = 'HTML подешавања';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP безбедност';
$string['hubs'] = 'Чворишни сервери';
$string['iconvrecommended'] = 'Инсталирање опционе ICONV библиотеке је врло препоручљиво у циљу унапређивања перформанси сајта, поготово ако ваш сајт подржава језике који не користе латинично писмо.';
$string['iconvrequired'] = 'Потребно је инсталирати ICONV екстензију.';
$string['ignore'] = 'Игнориши';
$string['includemoduleuserdata'] = 'Укључујући податке корисника модула';
$string['incompatibleblocks'] = 'Некомпатибилни блокови';
$string['installhijacked'] = 'Инсталација мора бити завршена са оригиналне IP адресе.';
$string['installsessionerror'] = 'Није могуће започети PHP сесију. Молимо Вас да проверите да ли Ваш веб читач прихвата колачиће.';
$string['intlrecommended'] = 'Intl екстензија се користи за унапређење интернационалне подршке, као што је сортирање према правилима локалног језика.';
$string['invalidsection'] = 'Неисправна секција';
$string['invaliduserchangeme'] = 'Корисничко име "changeme" је резервисано -- не можете креирати налог са тим именом.';
$string['ipblocked'] = 'Овај сајт тренутно није доступан.';
$string['ipblocker'] = 'Блокер IP адреса';
$string['ipblockersyntax'] = 'Један запис по једном реду. Исправни записи су или пуне IP адресе (нпр. <б>192.168.10.1</б>), које које одговарају једном серверу; или делимичне адресе (нпр. <b>192.168.</b>), које одговарају сви рачунарима чија IP адреса почиње тим бројевима; или CIDR нотације (нпр. <b>231.54.211.0/20</b>); или ранг IP адреса (нпр. <b>231.3.56.10-20</b>) где ранг одговара последњем делу адресе. Словима написани домени (нпр. \'example.com\') нису подржани. Празне линије биће занемарене.';
$string['iplookup'] = 'Тражење IP адресе';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">geoPlugin</a> сервис се тренутно користи за проналажење географских информација. За прецизније резултата предлажемо вам да инсталирате локалну копију MaxMind GeoLite базе података.';
$string['iplookupinfo'] = 'Како би лоцирао IP адресу Moodle стандардно користи бесплатан онлајн NetGeo (The Internet Geographic Database) сервер. Нажалост, ова база података се више не одржава па се може десити да добијете <em>крајње погрешне</em> податке.
Препоручује се да инсталирате локалну копију бесплатне GeoLite City базе података компаније MaxMind.<br />
Позиција IP адресе се приказује на једноставној мапи или коришћењем  Google Maps. Напомена: да бисте омогућили интерактивне мапе неопходно је да имате Google налог као и да се пријавите за бесплатан Google Maps API кључ.';
$string['iplookupmaxmindnote'] = 'Овај производ укључује GeoLite податке креиране од стране MaxMind, који је доступан на <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Задржати велика и мала слова ознака (тагова)';
$string['lang'] = 'Подразумевани језик';
$string['langcache'] = 'Кеширање језичког менија';
$string['langcache_desc'] = 'Кеширај језички мени. Ако је ово подешавање омогућено, списак доступних превода се кешира. Кеш меморија се аутоматски освежава када инсталирате или обришете језички пакете помоћу уграђеног алата за управљање језичким пакетима. Ако ручно инсталирате нови пакет, морате да употребите наредбу "Обриши цео кеш" како бисте освежили кеширану листу језичких пакета.';
$string['langlist'] = 'Језици на језичком менију';
$string['langmenu'] = 'Приказ језичког менија';
$string['langpackwillbeupdated'] = 'Напомена: У току надоградње Moodle ће покушати да ажурира ваше језичке пакете.';
$string['langstringcache'] = 'Кеширај све језичке стрингове';
$string['languagesettings'] = 'Језичка подешавања';
$string['latexpreamble'] = 'LaTeX преамбула';
$string['latexsettings'] = 'Подешавања LaTeX рендеровања';
$string['latinexcelexport'] = 'Excel кодирање';
$string['legacyfilesaddallowed'] = 'Дозволи додавање наслеђеним датотекама';
$string['legacyfilesaddallowed_help'] = 'Ако курс има старе наслеђене датотеке, дозволите да им буду додате нове датотеке и директоријуми.';
$string['legacyfilesinnewcourses'] = 'Наслеђене датотеке курса у новом курсу';
$string['legacyfilesinnewcourses_help'] = 'Стандардно, простори за наслеђене датотеке курсева су доступни само у надограђеним курсевима. Имајте у виду да поједина својства, попут креирања и рестаурирања резервне копије нису компатибилне са овим подешавањем.';
$string['licensesettings'] = 'Подешавања лиценце';
$string['linkadmincategories'] = 'Прикажи администраторске категорије као линкове';
$string['linkadmincategories_help'] = 'Ако је ово подешавање омогућено, категорије, унутар администраторског блока за подешавања, бићe приказане као линкови и повезане са страницама  одговарајућих администраторских категорија.';
$string['loading'] = 'Учитавање';
$string['localetext'] = 'Локални текст на нивоу сајта';
$string['localstringcustomization'] = 'Прилагођавање стрингова локала';
$string['location'] = 'Локација';
$string['locationsettings'] = 'Подешавања локације';
$string['locked'] = 'Закључано';
$string['lockoutduration'] = 'Период у ком је налог закључан';
$string['lockoutduration_desc'] = 'Закључани налог се аутоматски откључава.након што истекне овај временски период';
$string['lockoutemailbody'] = 'Ваш налог са корисничким именом {$a->username} на сајту \'{$a->sitename}\'
је закључан након вишеструких неисправних покушаја пријаве на систем.

Да бисте откључали налог одмах идите на следећу адресу

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}';
$string['lockoutemailsubject'] = 'Ваш налог на сајту {$a} је закључан';
$string['lockouterrorunlock'] = 'Добављена је неисправна информација за откључавање налога.';
$string['lockoutthreshold'] = 'Праг закључавања налога';
$string['lockoutthreshold_desc'] = 'Изаберите број неуспешних покушаја пријаве на систем који ће довести до закључавања налога. Ова функција може бити злоупотребљена у нападима ускраћивањем услуга (DoS - denial of service).';
$string['lockoutwindow'] = 'Време праћења за закључавање налога';
$string['lockoutwindow_desc'] = 'Време праћења за праг закључавања – уколико нема неуспешних покушаја пријаве на систем бројач прага закључавања се ресетује након овог временског периода.';
$string['log'] = 'Записи о активностима';
$string['logguests'] = 'Бележи приступе гостију';
$string['logguests_help'] = 'Ово подешавање омогућава бележење активности од стране гостију, као и корисника који нису пријављени на систем. Ако ваш сајт има велики број корисника можда ћете желети да искључите ово подешавање због бољих перформанси. Препоручљиво је да ово подешавање држите укључено на продукционим сајтовима.';
$string['loginhttps'] = 'Користити HTTPS за приступе систему';
$string['loginpageautofocus'] = 'Образац са аутофокусирајућим пољима на страници за пријављивање';
$string['loginpageautofocus_help'] = 'Укључивањем ове опције повећава се употребљивост странице за пријављивање, али аутоматски фокусирајућа поља могу представљати проблем приступачности свим корисницима, нарочито онима са посебним потребама.';
$string['loginpasswordautocomplete'] = 'Спречи аутоматско попуњавање лозинке на обрасцу за пријаву на систем.';
$string['loginpasswordautocomplete_help'] = 'Уколико је ово подешавање укључено корисници неће моћи да сачувају лозинку у свом веб читачу.';
$string['loglifetime'] = 'Чувај записе о активностима за последњих';
$string['longtimewarning'] = '<b>Молимо вас да узмете у обзир да овај процес може потрајати</b>';
$string['maintenancemode'] = 'У режиму одржавања';
$string['maintenancemodeisscheduled'] = 'Сајт се пребацује у режиму одржавања за {$a} минут/а';
$string['maintfileopenerror'] = 'Грешка при отварању датотека за одржавање!';
$string['maintinprogress'] = 'Одржавање је у току...';
$string['manageformats'] = 'Управљање форматима курса';
$string['manageformatsgotosettings'] = 'Подразумевани формат може бити промењен у {$a}';
$string['managelang'] = '<b>Управљање</b>';
$string['managelicenses'] = 'Управљање лиценцама';
$string['manageqbehaviours'] = 'Управљање понашањима питања';
$string['manageqtypes'] = 'Управљање типовима питања';
$string['maturity100'] = 'Бета верзија';
$string['maturity150'] = 'RC (Release candidate) верзија';
$string['maturity200'] = 'Стабилна верзија';
$string['maturity50'] = 'Алфа верзија';
$string['maturityallowunstable'] = 'Савет: Можда ћете желети да покренете ову скрипту са опцијом --allow-unstable option';
$string['maturitycoreinfo'] = 'Ваш сајт тренутно покреће нестабилни "{$a}" развојни код';
$string['maturitycorewarning'] = 'Верзија коју ћете управо инсталирати или надоградити садржи нестабилан "{$a}" код који је у још у развоју те се не сматра погодним за коришћење на већини продукционих сајтова.  Ако то није оно што сте желели употребите стабилну верзију кода за надоградњу. Погледајте документацију за више детаља.';
$string['maxbytes'] = 'Максимална величина постављене датотеке';
$string['maxconsecutiveidentchars'] = 'Редоследни идентични карактери';
$string['maxeditingtime'] = 'Максимално време за уређивање порука';
$string['maxusersperpage'] = 'Максималан број корисника по страници';
$string['mbstringrecommended'] = 'Инсталирање опционе MBSTRING библиотеке је врло препоручљиво због унапређивања перформанси сајта, поготово ако ваш сајт подржава језике који не користе латинично писмо.';
$string['mediapluginavi'] = 'Омогући .avi филтер';
$string['mediapluginflv'] = 'Омогући .flv филтер';
$string['mediapluginimg'] = 'Омогући аутоматско уметање линкованих слика';
$string['mediapluginmov'] = 'Омогући .mov филтер';
$string['mediapluginmp3'] = 'Омогући .mp3 филтер';
$string['mediapluginmpg'] = 'Омогући .mpg филтер';
$string['mediapluginogg'] = 'Омогући .ogg филтер';
$string['mediapluginogv'] = 'Омогући .ogv филтер';
$string['mediapluginram'] = 'Омогући .ram филтер';
$string['mediapluginrm'] = 'Омогући .rm филтер';
$string['mediapluginrpm'] = 'Омогући .rpm филтер';
$string['mediapluginswf'] = 'Омогући .swf филтер';
$string['mediapluginswfnote'] = 'Као подразумевану меру безбедности, обичним корисницима не треба дозволити да умећу swf flash датотеке.';
$string['mediapluginwmv'] = 'Омогућити .wmv филтер';
$string['mediapluginyoutube'] = 'Омогући филте за YouTube линкове';
$string['messaging'] = 'Омогући систем за размену порука';
$string['messagingallowemailoverride'] = 'Измена е-адресе за слање обавештења';
$string['messagingdeletereadnotificationsdelay'] = 'Обриши обавештење о прочитаним порукама';
$string['messaginghidereadnotifications'] = 'Сакриј обавештење о прочитаним порукама';
$string['minpassworddigits'] = 'Бројеви';
$string['minpasswordlength'] = 'Дужина лозинке';
$string['minpasswordlower'] = 'Мала слова';
$string['minpasswordnonalphanum'] = 'Не-алфанумерички карактери';
$string['minpasswordupper'] = 'Велика слова';
$string['misc'] = 'Разно';
$string['mnetrestore_extusers'] = '<strong>Напомена:</strong> Ова резервна копија садржи удаљене корисничке налоге из одговарајуће Moodle мреже. Ти налози ће током овог процеса такође бити рестаурирани.';
$string['mnetrestore_extusers_admin'] = '<strong>Напомена:</strong> Изгледа да је ова дадотека резервне копије креирана на некој другој Moodle инсталацији и да садржи корисничке налоге удаљене Moodle Мреже. Процес рестаурације ће покушати да усклади хостове Moodle Мреже за све кориснике. Оне корисници, за које то не успе, аутоматски ће нбити пребачени на интерну проверу идентитета (уместо mnet). Запис о рестаурацији ће Вас инфорисати о томе.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Напомена:</strong> Ова резервна копија очигледно потиче са неке друге Moodle инсталације и садржи корисничке налоге удаљене Moodle Мреже који се можда неће истравно рестаурирати. Ова операција није подржана. Ако сте сигурни да је архива креирана на овој Moodle инсталацији, или можете да потврдите да су сви потребни хостови у Вашој Moodle мрежи  конфигурисани, можда ћете ипак желети да покушате рестаурацију.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Напомена:</strong> Изгледа да је ова дадотека резервне копије креирана на некој другој Moodle инсталацији и да садржи корисничке налоге удаљене Moodle Мреже. Није Вам дозвољено да извршавате овај тип рестаурирања. Контактирајте администратора овог сајта или, алтернативно, рестаурирајте овај курс без било какве информације о кориснивима (модули, датотеке...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Удаљени корисник Moodle Мреже {$a->username} (који долази са {$a->mnethosturl}) пребачен је на локалног {$a->auth} ауторизованог корисника.';
$string['mobile'] = 'Мобилни';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Подразумевани статус бирача активности';
$string['modeditdefaults'] = 'Подразумеване вредности за подешавања активности';
$string['modeditingmenu'] = 'Менији за уређивање активности';
$string['modeditingmenu_desc'] = 'Ако је ова опција омогућена многе од икона за уређивање активности приказаних кад се прегледа курс са укљученим уређивањем биће приказане у оквиру падајућег менија. Ово редукује садржај на екрану при уређивању курса сакривајући иконе док не постану потребне.';
$string['modsettings'] = 'Управљање активностима';
$string['modulesecurity'] = 'Безбедност модула';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Инсистирати на старој вишејезичкој синтакси: &lt;span&gt; без class="multilang" и &lt;lang&gt;';
$string['mustenablestats'] = 'Статистика још није омогућена на овом сајту.';
$string['mycoursesperpage'] = 'Број курсева';
$string['mydashboard'] = 'Подразумевана контролна табла система';
$string['mymoodle'] = 'Моја почетна страница';
$string['mymoodleredirect'] = 'Обавезно коришћење опције Мој Moodle за све кориснике';
$string['mypage'] = 'Подразумевана Моја почетна страница';
$string['mypagelocked'] = 'Закључај подразумевану страницу';
$string['myprofile'] = 'Подразумевана страница профила';
$string['mysql416bypassed'] = 'Међутим, ако Ваш сајт користи iso-8859-1 (latin) језике, можете да наставите с коришћењем Ваше тренутно инсталиране MySQL верзије 4.1.12 (или више).';
$string['mysql416required'] = 'MySQL 4.1.16 је минимална верзија потребна за Moodle 1.6 да би се гарантовало даље конвертовање свих података у UTF-8.';
$string['navadduserpostslinks'] = 'Додај линкове за приказ корисничких порука';
$string['navadduserpostslinks_help'] = 'Ако је ово подешавање омогућено, сваком кориснику ће у блоку за навигацију бити додата два линка, један за приказ дискусија које је корисник започео и други за приказ порука које је поставио на форумима широм сајта или на одређеним курсевима.';
$string['navcourselimit'] = 'Број курсева';
$string['navigationupgrade'] = 'Ова надоградња уводи два нова блока за навигацију који ће заменити следеће блокове: Администрација, Курсеви, Активности и Учесници. Ако сте претходно доделили нека посебна овлашћења у овим блоковима, требало би да проверите да ли се све догађа онако како желите.';
$string['navshowallcourses'] = 'Прикажи све курсеве';
$string['navshowcategories'] = 'Прикажи категорије курсева';
$string['navshowfrontpagemods'] = 'Прикажи активности на насловној страници сајта';
$string['navshowfrontpagemods_help'] = 'Ако је ово подешавање омогућено, активности на насловној страници сајта биће приказане у блоку за навигације под ставком \'Странице сајта\'.';
$string['navshowfullcoursenames'] = 'Прикажи пуне називе курсева';
$string['navshowfullcoursenames_help'] = 'Ако је укључено у навигацији ће се користити пуни називи курсева уместо скраћених.';
$string['navshowmycoursecategories'] = 'Прикажи категорије мојих курсева';
$string['navshowmycoursecategories_help'] = 'Ако је ово подешавање омогућено, курсеви ће бити приказани корисницима у блоку за навигацију под ставком \'Моји курсеви\', као гране одговарајућих категорија.';
$string['navsortmycoursessort'] = 'Сортирај моје курсеве';
$string['navsortmycoursessort_help'] = 'Ово одређује да ли су курсеви унутар ставке \'Моји курсеви\', у блоку за навигацију, поређани према редоследу сортирања (тј. редоследу који је подешен у Администрација сајта > Курсеви > Управљање курсевима и категоријама) или алфабетски према подешавању курса.';
$string['neverdeleteruns'] = 'Никада не бриши покретања';
$string['nobookmarksforuser'] = 'Немате постављених обележивача.';
$string['nodatabase'] = 'Нема базе података';
$string['nohttpsformobilewarning'] = 'Препоручује се да омогућите HTTPS протокол са важећим сертификатом. Moodle апликација ће увек прво покушати да користи безбедну конекцију.';
$string['nomissingstrings'] = 'Нема недостајућих израза';
$string['nonewsettings'] = 'Није додато ниједно ново подешавање током овог ажурирања.';
$string['nonexistentbookmark'] = 'Тражени обележивач не постоји.';
$string['noresults'] = 'Нема резултата';
$string['noroles'] = 'Нема улога';
$string['notifications'] = 'Обавештења';
$string['notifyloginfailures'] = 'Послати извештај о неуспешним приступима систему кориснику';
$string['notifyloginthreshold'] = 'Гранична вредност за обавештења е-поштом';
$string['notloggedinroleid'] = 'Улога за посетиоце';
$string['numberofmissingstrings'] = 'Број недостајућих израза: {$a}';
$string['numberofstrings'] = 'Укупан број израза: {$a->strings}<br />Недостаје: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'Кеширање PHP кода операције побољшава перформансе и снижава меморијске захтеве, OPcache додатак је препоручен и у потпуности подржан.';
$string['opensslrecommended'] = 'Инсталирање опционе OpenSSL библиотеке је врло препоручљиво -- она омогућава коришћење функција за умрежавање.';
$string['opentogoogle'] = 'Отворен за Google';
$string['optionalmaintenancemessage'] = 'Опциона порука у току одржавања система';
$string['order1'] = 'Први';
$string['order2'] = 'Други';
$string['order3'] = 'Трећи';
$string['order4'] = 'Четврти';
$string['passwordpolicy'] = 'Правилник за креирање лозинке';
$string['passwordresettime'] = 'Максимално време за потврду захтева за ресетовање лозинке.';
$string['pathconvert'] = 'Путања <i>convert</i> бинарне датотеке';
$string['pathdvips'] = 'Путања <i>dvips</i> бинарне датотеке';
$string['pathlatex'] = 'Путања <i>latex</i> бинарне датотеке';
$string['pathtoclam'] = 'clam AV путања';
$string['pathtodot'] = 'Путања до dot';
$string['pathtodot_help'] = 'Путања до dot. Вероватно, нешто попут /usr/bin/dot. Да бисте могли да генеришете графике из DOT датотека, морате имати инсталиран dot извршну датотеку и подешену исправну путању до ње. Имајте на уму да се ово користи само за тзв. "профајлинг" (Development->Profiling) нову функцију уграђену у Moodle, која је у развојној фази.';
$string['pathtodu'] = 'Путања до du алата';
$string['pathtopgdump'] = 'Путања до pg_dump';
$string['pathtopgdumpdesc'] = 'Ово је неопходно унети само ако имате више од једног pg_dumpa на свом систему (на пример ако сте инсталирали више од једне верзије postgresqla)';
$string['pathtopgdumpinvalid'] = 'Путања до pg_dump-a није валидна - или је путања погрешна или није извршива';
$string['pathtopsql'] = 'Путања до psql';
$string['pathtopsqldesc'] = 'Ово је неопходно унети само ако имате више од једног psqla на свом систему (на пример ако сте инсталирали више од једне верзије postgresqla)';
$string['pathtopsqlinvalid'] = 'Путања до psql-a није валидна - или је путања погрешна или није извршива';
$string['pcreunicodewarning'] = 'Строго се препоручује да користите PCRE PHP екстензију који је компатибилна са Unicode сетом карактера.';
$string['perfdebug'] = 'Информације о извршавању';
$string['performance'] = 'Перформансе';
$string['pgcluster'] = 'PostgreSQL кластер';
$string['pgclusterdescription'] = 'Параметар PostgreSQL верзије/кластера за операције командне линије. Ако имате само један postgresql на свом систему или нисте сигурни шта ово подешавање представља, оставите поље празно.';
$string['php50restricted'] = 'PHP 5.0.x има више познатих проблема, молимо унапредите PHP на верзије 5.1.x или инсталирајте верзију 4.3.x односно 4.4.x';
$string['php533warning'] = 'Препоручује се коришћење PHP 5.3.3 или новије верзије';
$string['phpfloatproblem'] = 'Уочене је неочекивани проблем у обради PHP бројева са покретним зарезом - {$a}';
$string['pleaserefreshregistration'] = 'Ваш сајт је регистрован на moodle.org. Размотрите могућност ажурирања регистрације, уколико је дошло до значајних промена од Вашег последњег ажурирања, на {$a}';
$string['pleaseregister'] = 'Молимо региструјте Ваш сајт како бисте уклонили ову поруку';
$string['plugin'] = 'Додатак';
$string['plugins'] = 'Додаци';
$string['pluginscheck'] = 'Провера зависности додатака';
$string['pluginscheckfailed'] = 'Провера зависности није успела за {$a->pluginslist}';
$string['pluginschecktodo'] = 'Морате решити све захтеве додатака пре него што наставите са инсталацијом ове верзије Мoodlea!';
$string['pluginsoverview'] = 'Преглед додатака';
$string['pluginsoverviewsee'] = 'За више информација погледајте страницу <a href="{$a->url}">Преглед додатака</a>.';
$string['profilecategory'] = 'Категорија';
$string['profilecategoryname'] = 'Назив категорије (мора бити јединствен)';
$string['profilecategorynamenotunique'] = 'Овај назив категорије већ је у употреби';
$string['profilecommonsettings'] = 'Заједничка подешавања';
$string['profileconfirmcategorydeletion'] = 'Постоје {$a}. поља у овој категорији која могу бити померена у категорију изнад (или испод).<br />Да ли желите да обришете ову категорију?';
$string['profileconfirmfielddeletion'] = 'Постоји {$a} корисничких уноса за ово поље који требају бити обрисани.<br />Да ли и даље желите обрисати ово поље?';
$string['profilecreatecategory'] = 'Креирај нову категорију профила';
$string['profilecreatefield'] = 'Креирај ново поље за профил:';
$string['profilecreatenewcategory'] = 'Креирај нову категорију';
$string['profilecreatenewfield'] = 'Креирање новог поља профила: &quot;{$a}&quot;';
$string['profiledefaultcategory'] = 'Остала поља';
$string['profiledefaultchecked'] = 'Укључено подразумевано';
$string['profiledefaultdata'] = 'Подразумевана вредност';
$string['profiledeletecategory'] = 'Брисање категорије';
$string['profiledeletefield'] = 'Брисање поља \'{$a}\'';
$string['profiledescription'] = 'Опис поља';
$string['profiledscript'] = 'Оваj скрипт је профилисан';
$string['profiledscriptview'] = 'Види информације о профилисању за овaj скрипт';
$string['profileeditcategory'] = 'Уређивање категорије: {$a}';
$string['profileeditfield'] = 'Уређивање поља  профила: {$a}';
$string['profilefield'] = 'Поље профила';
$string['profilefieldcolumns'] = 'Колоне';
$string['profilefieldispassword'] = 'Да ли је ово поље за лозинку?';
$string['profilefieldlink'] = 'Линк';
$string['profilefieldlink_help'] = 'За претварање текста у линк, унесите URL који садржи $$, где ће $$ бити замењен текстом. На пример, за претварање Twitter ID-ја у линк, упишите http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Адреса до које води линк';
$string['profilefieldmaxlength'] = 'Максимална дужина';
$string['profilefieldrows'] = 'Редова';
$string['profilefields'] = 'Поља профила корисника';
$string['profilefieldsize'] = 'Величина поља';
$string['profileforceunique'] = 'Да ли подаци треба да буду јединствени?';
$string['profileinvaliddata'] = 'Неодговарајућа вредност';
$string['profilelocked'] = 'Да ли је ово поље закључано?';
$string['profilemenudefaultnotinoptions'] = 'Подразумевана вредност није у листи опција.';
$string['profilemenunooptions'] = 'Без опција са менијима';
$string['profilemenuoptions'] = 'Мени опције (по једна у линији)';
$string['profilemenutoofewoptions'] = 'Морате понудити бар 2 могућности';
$string['profilename'] = 'Назив';
$string['profilenofieldsdefined'] = 'Није дефинисано ниједно поље';
$string['profilerequired'] = 'Да ли је ово поље обавезно?';
$string['profileroles'] = 'Улоге видљиве у профилу';
$string['profilesforenrolledusersonly'] = 'Профили само за кориснике уписане на курс.';
$string['profileshortname'] = 'Скраћен назив (мора бити јединствен)';
$string['profileshortnamenotunique'] = 'Овај скраћен назив се већ користи';
$string['profilesignup'] = 'Приказати на страници за пријаву?';
$string['profilespecificsettings'] = 'Специфична подешавања';
$string['profilevisible'] = 'Коме је ово поље видљиво?';
$string['profilevisibleall'] = 'Видљиво свима';
$string['profilevisible_help'] = '* Није видљиво - за личне податке видљиве само администраторима
* Видљиво кориснику - за личне податке видљиве само администраторима и кориснику чију су подаци
* Видљиво свима';
$string['profilevisiblenone'] = 'Није видљиво';
$string['profilevisibleprivate'] = 'Видљиво кориснику';
$string['profiling'] = 'Профилисање';
$string['profilingallowall'] = 'Континуирано профилисање';
$string['profilingallowall_help'] = 'Ако омогућите ово подешавање, онда, у било ком тренутку можете да користите параметар PROFILEALL било где (PGC) како бисте омогућили профилисање за све извршене скрипте током трајања Moodle сесије. Аналогно томе, можете да користите параметар PROFILEALLSTOP како бисте то зауставили.';
$string['profilingallowme'] = 'Селективно профилисање';
$string['profilingallowme_help'] = 'Ако омогућите ово подешавање, онда, селективно, можете да користите параметар PROFILEME било где (PGC) и тај скрипт ће бити профилисан. Аналогно томе, можете да користите параметар DONTPROFILEME како би спречили профилисање.';
$string['profilingautofrec'] = 'Аутоматско профилисање';
$string['profilingautofrec_help'] = 'Конфигурисањем овог подешавања, неки захтеви (насумично одабрани, засновано на учесталости одређеној као 1 од N) биће одабрани и аутоматски профилисани, смештајући резултате за даљу анализу. Имајте на уму да овај начин профилисања посматра include/exclude подешавања. Поставите вредност на 0 како бисте онемогућили аутоматско профилисање.';
$string['profilingenabled'] = 'Омогући профилисање';
$string['profilingenabled_help'] = 'Ако омогућите ову подешавање, онда ће профилисање бити доступно на овом сајту и моћи ћете да одредити његово понашање тако што ћете подесити следеће опције.';
$string['profilingexcluded'] = 'Искључи профилисање';
$string['profilingexcluded_help'] = 'Списак URL адреса (одвојених зарезима, апсолутних, прескачући wwwroot, које могу бити позване) које ће бити изузетe од профилисања дефинисаног у подешавању \'Профилиши ове\'.';
$string['profilingimportprefix'] = 'Prefiks za uvoz profilisanja';
$string['profilingimportprefix_desc'] = 'Ради лакшег утврђивања, сва увезена покретања профилисања ће добити префиксе са вредношћу специфицираном овде.';
$string['profilingincluded'] = 'Профилиши ове';
$string['profilingincluded_help'] = 'Списак URL адреса (одвојених зарезима, апсолутних, прескачући wwwroot, које могу бити позване) које ће бити аутоматски профилисанe. Пример:/index.php, /course/view.php. Такође је прихватљива употреба * џокер ознака на било којој позицији. Птимер: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Настави са профилисањем';
$string['profilinglifetime_help'] = 'Одредите колико дуго желите да чувате информације о претходним покретањима профилисања. Старија ће периодично бити одстрањивана. Имајте у виду да ово искључује било које покретање профилисања означенo као "референтно покретање".';
$string['protectusernames'] = 'Заштитити корисничка имена';
$string['proxybypass'] = 'Хостови за премошћење Proxy сервера';
$string['proxyhost'] = 'Proxy домаћин';
$string['proxypassword'] = 'Лозинка за прокси сервер';
$string['proxyport'] = 'Proxy порт';
$string['proxytype'] = 'Тип Proxy сервера';
$string['proxyuser'] = 'Корисничко име за Proxy';
$string['purgecaches'] = 'Обриши све записе из кеш меморије';
$string['purgecachesconfirm'] = 'Moodle може да чува у кеш меморији теме, Javascript, језичке стрингове, филтрирани текст, RSS изворе вести и многе друге обрађене података. Брисање кеш меморије ће обрисати те привремено сачуване податке са сервера и тиме приморати веб читач да поново преузмe податке, тако да можете бити сигурни да гледате најновије вредности које је произвео тренутни кôд. Нема никакве опасности у брисању кеш меморије, али Ваш сајт може, на тренутак, бити спорији, све док сервер и клијентски програм не генеришу нове информације и поново их сместе у кеш.';
$string['purgecachesfinished'] = 'Сви записи из кеш меморије су обрисани';
$string['qtyperqpwillberemoved'] = 'Током надоградње, RQP типови питања биће уклоњени. Нећете користити овај тип питања, тако да не очекујте проблеме у вези с тим.';
$string['qtyperqpwillberemovedanyway'] = 'Током надоградње биће уклоњен RQP тип питања. Како имате нека RQP питања у својој бази, препоручује се да поново инсталирате додатак са http://moodle.org/mod/data/view.php?d=13&amp;rid=797 пре наставка надоградње да би она могла и даље несметано да се користе.';
$string['quarantinedir'] = 'Карантински директоријум';
$string['question'] = 'Питање';
$string['questionbehaviours'] = 'Понашања питања';
$string['questioncwqpfscheck'] = 'Једно или више \'насумично изабраних\' питања у тесту подешено је да врши одабир питања и из категорија дељених и из категорија недељених питања. Детаљнији извештај погледајте <a href="{$a->reporturl}">овде</a>, или потражите додатне информације у оквиру страница Moodle <a href="{$a->docsurl}">документације</a>.';
$string['questioncwqpfsok'] = 'У реду. Нема \'насумично изабраних\' питања у Вашим тестовима која су подешена тако да врше одабир питања и из категорија дељених и из категорија недељених питања.';
$string['questiontype'] = 'Тип питања';
$string['questiontypes'] = 'Типови питања';
$string['quizattemptsupgradedmessage'] = 'У верзији Moodle 2.1 извршен је велика надоградња оног  дела који се односи на питања. Било је могуће да се део надоградње базе података одложи и покрене касније. Пре преласка на верзију Moodle 2.7 ова надоградња мора да буде завршена.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA приватни кључ';
$string['recaptchapublickey'] = 'ReCAPTCHA јавни кључ';
$string['register'] = 'Региструјте свој сајт';
$string['registermoodleorg'] = 'Када региструјете свој сајт на {$a}';
$string['registermoodleorgli1'] = 'Бићете додати на листу е-поште за слање важних обавештења као што су безбедносна упозорења и информације о новим издањима Moodlea.';
$string['registermoodleorgli2'] = 'Статистички подаци о вашем сајту биће додати статистици светске Moodle заједнице - {$a}.';
$string['registermoodleorgli3'] = 'Ваш сајт ће, такође, бити регистрован на Moodle.net ({$a}), што корисницима са издавачким овлашћењем (стандардно, то су само менаџери) омогућава да објављују курсеве на Moodle.net.';
$string['registerwithmoodleorg'] = 'Регистрација на сајту Moodle.org';
$string['registration'] = 'Регистрација';
$string['registration_help'] = 'Регистрација вашег сајта на Moodle.org се препоручује из више разлога - због добијања безбедносних упозорења е-поштом, због прецизније статистике на<a href="http://moodle.org/stats">Статистички подаци о коришћењу Moodlea</a> , као и због могућности дељења курсева на <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Ваш сајт још није регистрован';
$string['releasenoteslink'] = 'За информације о овој верзији Moodlea, молимо погледајте онлајн <a target="_new" href="{$a}">Белешке о издању</a>';
$string['rememberusername'] = 'Запамти корисничко име';
$string['rememberusername_desc'] = 'Омогућите ову опцију ако желите да сачувате перманентне колачиће са корисничким именима приликом пријављивања корисника на систем. Перманентни колачићи могу да представљају проблем приватности ако се користе без сагласности.';
$string['reportsmanage'] = 'Управљање извештајима';
$string['requestcategoryselection'] = 'Омогући избор категорија';
$string['requiredentrieschanged'] = '<strong>ВАЖНО - МОЛИМО ПРОЧИТАЈТЕ<br/>(Ова порука упозорења биће приказана само у току ове надоградње система)</strong><br/>Због исправљања багова понашање активности базе података које користе подешавања \'Захтевани уноси\' и \'Захтевани уноси пре прегледања подешавања\' биће промењена. Детаљније објашњење промена можете прочитати на <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">форуму о модулу База података</a>. О очекиваним променама понашања ових подешавања, такође, можете прочитати у оквиру <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle документације</a>.
<br/><br/>Ова промена утиче на следеће базе података у вашем систему: (Молимо вас да сада сачувате овај списак и, након завршене надоградње система, проверите да ли ове активности и даље раде онако како су то предавачи планирали.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Захтевај опис активности';
$string['requires'] = 'Неопходно';
$string['restorernewroleid'] = 'Улога рестауратора на курсевима';
$string['restorernewroleid_help'] = 'Ако корисник већ нема дозволу да управља недавно рестаурисаним курсом, аутоматски ће му бити додељена ова улога и биће уписан на курс ако је то потребно. Изаберите "Ништа", ако не желите да они који рестаурирају курсеве буду  у могућности да управљају сваким рестаурисаним курсом.';
$string['reverseproxy'] = 'Реверзни прокси';
$string['riskconfig'] = 'Корисници би могли променити конфигурацију и понашање сајта';
$string['riskconfigshort'] = 'Конфигурациони ризик';
$string['riskdataloss'] = 'Корисници могу да униште велику количину садржаја или информација';
$string['riskdatalossshort'] = 'Ризик од губиткка података';
$string['riskmanagetrust'] = 'Корисници би могли променити сигурносна подашавања других корисника';
$string['riskmanagetrustshort'] = 'Управљање дозволама за приступ';
$string['riskpersonal'] = 'Корисници би могли стећи приступ приватним информацијама других корисника';
$string['riskpersonalshort'] = 'Ризик по приватност';
$string['riskspam'] = 'Корисници би могли слати нежељену пошту корисницима сајта или другим лицима';
$string['riskspamshort'] = 'Ризик од нежељене е-поште';
$string['riskxss'] = 'Корисници би могли додати датотеке и текстове који дозвољавају скриптовање у оквиру читавог сајта (XSS)';
$string['riskxssshort'] = 'XSS ризик';
$string['roleswithexceptions'] = '{$a->roles}, са {$a->exceptions}';
$string['rssglobaldisabled'] = 'Искључи на нивоу сервера';
$string['runclamavonupload'] = 'Користити clam AV за све постављене датотеке';
$string['save'] = 'Сачувај';
$string['savechanges'] = 'Сачувај промене';
$string['search'] = 'Претрага';
$string['searchinsettings'] = 'Тражи у подешавањима';
$string['searchresults'] = 'Резултати претраге';
$string['sectionerror'] = 'Грешка секције!';
$string['secureforms'] = 'Користити додатне мере безбедности формулара';
$string['security'] = 'Безбедност';
$string['selectdevice'] = 'Изабери уређај';
$string['selecttheme'] = 'Изабери графичку тему за уређај {$a}';
$string['server'] = 'Сервер';
$string['serverchecks'] = 'Провере сервера';
$string['serverlimit'] = '.Ограничење сервера';
$string['sessionautostartwarning'] = '<p>Откривена је озбиљна грешка при конфигурацији, молимо обавестите администратора сервера</p><p> За исправан рад, администратор треба да променит PHP подешавања.</p> <p><code>session.auto_start</code> мора бити подешено на <code>off</code>.</p><p> Ово подешавање може се променити уређивањем <code>php.ini</code> датотеке, конфигурације Apache/IIS веб сервера<br />или <code>.htaccess</code> датотеке на серверу.</p>';
$string['sessioncookie'] = 'Префикс колачића';
$string['sessioncookiedomain'] = 'Домен колачића';
$string['sessioncookiepath'] = 'Путања колачића';
$string['sessionhandling'] = 'Управљање сесијама';
$string['sessiontimeout'] = 'Време истека сесије';
$string['settingfileuploads'] = 'За мормално функционисње неопходно је  ппостаљање дадотека. Молим Вас, дозволите ово у PHP конфигурационој датотеци.';
$string['settingmemorylimit'] = 'Уочена је недостатак меморије. Молимо Вас да поставите већи лимит за меморију у PHP подешаваљима.';
$string['settingsafemode'] = 'Moodle није у потпуности компатибилан са безбедним режимом. Замолите администратора сервер да га искључи. Покретањ Moodlea у безбедном режиму није подржано, тако да ако то урадите можете очекивати различите проблеме.';
$string['showcommentscount'] = 'Прикажи број коментара';
$string['showdetails'] = 'Прикажи детаље';
$string['showuseridentity'] = 'Прикажи идентитет корисника';
$string['showuseridentity_desc'] = 'Приликом избора или претраге корисника, када се приказује списак корисника, ова поља се могу приказати поред њихових имена и презимена. Поља ће се приказати само оним корисницима који имају могућност moodle/site:viewuseridentity capability,  стандардно, предавачима и менаџерима. (Ова опција највише има смисла ако изаберете једно или два поља која су у вашој институцији обавезна).';
$string['simplexmlrequired'] = 'Moodle сада захтева SimpleXML PHP екстензију.';
$string['sitemaintenance'] = 'Сајт је у фази одржавања и тренутно није доступан';
$string['sitemaintenancemode'] = 'Режим одржавања система';
$string['sitemaintenanceoff'] = 'Одржавање система је завршено и сајт је поново у нормалном режиму рада';
$string['sitemaintenanceon'] = 'Ваш сајт је тренутно у режиму одржавања (само администратори могу да приступе сајту)';
$string['sitemaintenanceoncli'] = 'Ваш сајт је тренутно у CLI режиму одржавања. Интернет приступ није дозвољен.';
$string['sitemaintenancewarning'] = 'Ваш сајт је тренутно у режиму одржавања (само администратори могу да приступе сајту). Да би сте вратили сајт у нормалан режим рада, <a href="maintenance.php"> искључите режим одржавања</a>.';
$string['sitemaintenancewarning2'] = 'Ваш сајт је тренутно у режиму одржавања (само администратори могу да се пријаве на систем). Да бисте вратили овај сајт у нормалан режним рада, <a href="{$a}">искључите режим одржавања</a>.';
$string['sitepolicies'] = 'Правила о коришћењу сајта';
$string['sitepolicy'] = 'URL правила сајта';
$string['sitepolicyguest'] = 'URL адреса правилника о понашању на сајту за госте';
$string['sitepolicyguest_help'] = 'Ако имате правилник о понашању на сајту који сви гости морају да прочитају и прихвате, овде можете навести URL адресу истог. У супротном оставите ово поље празно. Ово подешавање може садржати било коју јавно доступну URL адресу. Напомена: приступ непријављеним корисницима може бити онемогућен коришћењем подешавања forcelogin.';
$string['sitepolicy_help'] = 'Уколико имате посебна правила и упутства за коришћење сајта која корисници морају да прочитају  и да их прихвате онда наведите URL стране на којој се налазе правила. У супротном оставите ово поље празно. URL стране може бити било који - погодно место може бити и датотека на самом сајту тј. http://yoursite/file.php/1/policy.html';
$string['sitesectionhelp'] = 'Уколико је ово подешавање укључено, тематска секција ће бити приказана на насловној страници сајта.';
$string['slasharguments'] = 'Користити slash аргументе';
$string['smartpix'] = '"Паметна" претрага слика';
$string['soaprecommended'] = 'Инсталирање опционе soap екстензије је корисно за веб сервисе и неке нестандардне додатке за Moodle.';
$string['sort_fullname'] = 'Пун назив курса';
$string['sort_idnumber'] = 'ID број курса';
$string['sort_shortname'] = 'Скраћени назив курса';
$string['sort_sortorder'] = 'Редослед сортирања';
$string['spellengine'] = 'Систем за проверу правописа';
$string['spelllanguagelist'] = 'Списак језика за проверу правописа';
$string['splrequired'] = 'Moodle захтева SPL PHP екстензију';
$string['stats'] = 'Статистика';
$string['statsfirstrun'] = 'Максимални интервал процесирања';
$string['statsmaxruntime'] = 'Максимално време извршавања';
$string['statsmoodleorg'] = 'статистика';
$string['statsruntimedays'] = 'Дана за обраду';
$string['statsruntimestart'] = 'Извршавање у';
$string['statsuserthreshold'] = 'Гранична вредност корисника';
$string['stickyblocks'] = 'Фиксирани блокови';
$string['stickyblockscourseview'] = 'Страница курса';
$string['stickyblocksduplicatenotice'] = 'Ако је било који блок који овде додате већ присутан на некој конкретној страници, биће приказан и његов дупликат.<br />Једино што се фиксирани блок неће моћи мењати, а дупликат још увек хоће.';
$string['stickyblocksmymoodle'] = 'Мој Moodle';
$string['stickyblockspagetype'] = 'Врста странице за конфигурисање';
$string['strictformsrequired'] = 'Стриктна провера обавезних поља';
$string['stripalltitletags'] = 'Уклони HTML ознаке са свих имена активности';
$string['supportcontact'] = 'Контакт за подршку';
$string['supportemail'] = 'Адреса е-поште за подршку';
$string['supportname'] = 'Име за подршку';
$string['supportpage'] = 'Веб страница за подршку';
$string['suspenduser'] = 'Суспендуј кориснички налог';
$string['switchlang'] = 'Промени lang директоријум';
$string['systempaths'] = 'Системске путање';
$string['tablenosave'] = 'Промене у горњој табели се аутоматски чувају.';
$string['tablesnosave'] = 'Промене у горњим табелама се аутоматски чувају.';
$string['tabselectedtofront'] = 'У табелама са табовима, да ли би ред са тренутно одабраним табом требало да буде стављен у први план';
$string['tabselectedtofronttext'] = 'Померити изабрани ред на почетак';
$string['testsiteupgradewarning'] = 'Тренутно користите тест сајт {$a}; да бисте га исправно надоградили , употребите интерфејс са командом линијом';
$string['themedesignermode'] = 'Режим за дизајнирање теме';
$string['themelist'] = 'Списак графичких тема';
$string['themenoselected'] = 'Ниједна графичка тема није изабрана';
$string['themeresetcaches'] = 'Обриши теме из кеш меморије';
$string['themeselect'] = 'Промени графичку тему';
$string['themeselector'] = 'Селектор графичке теме';
$string['themesettings'] = 'Подешавања графичких тема';
$string['therewereerrors'] = 'Било је грешака у вашим подацима';
$string['thirdpartylibrary'] = 'Библиотека';
$string['thirdpartylibrarylocation'] = 'Локација';
$string['thirdpartylibs'] = 'Независне библиотеке';
$string['timezone'] = 'Подразумевана временска зона';
$string['timezoneforced'] = 'Ово је администратор сајта прогласио обавезним';
$string['timezoneisforcedto'] = 'Обавезна употреба за све кориснике';
$string['timezonenotforced'] = 'Корисници могу одабрати сопствену временску зону';
$string['tokenizerrecommended'] = 'Препоручује се инсталација опционог PHP Tokenizer додатка ради побољшавања функционалности за умрежавање.';
$string['tools'] = 'Администраторски алати';
$string['toolsmanage'] = 'Управљање администраторским алатима';
$string['unattendedoperation'] = 'Аутоматска инсталација';
$string['unbookmarkthispage'] = 'Уклони обележивач са ове странице';
$string['unicoderecommended'] = 'Препоручљиво је смештање ваших података у Уникод (UTF-8) стандард. Нове инсталације биће извршене над базама који као подразумеван карактер-сет имају подешен Уникод. Уколико вршите надоградњу, потребно је покренути UTF-8 процес миграције (погледати Админ страну).';
$string['unicoderequired'] = 'Потребно је да све ваше податке смештате у Уникод формату (UTF-8).Нове инсталације морају бити примењене у базама података које имају основни карактерни сет намештен на Уникод. Уколико вршите надоградњу, потребно је покренути UTF-8 процес миграције (погледати Админ страну).';
$string['uninstallplugin'] = 'Деинсталирај';
$string['unlockaccount'] = 'Откључај налог';
$string['unsettheme'] = 'Уклони графичку тему';
$string['unsupported'] = 'Неподржано';
$string['unsuspenduser'] = 'Активирајте кориснички налог';
$string['updateaccounts'] = 'Ажурирање постојећих налога';
$string['updateautocheck'] = 'Аутоматски провери доступност нових верзија';
$string['updateautocheck_desc'] = 'Ако је ово подешавање омогућено,  ваш сајт ће аутоматски проверавати да ли су доступне нове верзије како основног Moodle пакета, тако и свих додатака. Ако постоје доступне нове верзије, биће послато обавештење е-поштом администраторима сајта.';
$string['updateautodeploy'] = 'Омогући примену ажурирања';
$string['updateautodeploy_desc'] = 'Ако је ова опција омогућена, моћи ћете да ажурирате тј. инсталирате нове верзије додатака, директно са странице за администрацију Moodlea. Имајте у виду, да би ово могло да функционише ваш веб сервер мора да има овлашћење за уписивање унутар директоријума у којем се налази Moodle инсталација. Ово се може сматрати потенцијалним ризиком по безбедност система.';
$string['updateavailable'] = 'Доступна је новија верзија Moodlea!';
$string['updateavailabledetailslink'] = 'За више информација погледајте {$a->url}';
$string['updateavailableforplugin'] = 'Доступне су новије верзије за неке од ваших додатака!';
$string['updateavailableinstall'] = 'Инсталирај нову верзију';
$string['updateavailable_moreinfo'] = 'Више информација...';
$string['updateavailablenot'] = 'Користите последњу верзију Moodlea';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Верзија{$a}';
$string['updatecomponent'] = 'Ажурирај компоненту';
$string['updateminmaturity'] = 'Потребна зрелост кôдa';
$string['updateminmaturity_desc'] = 'Пошаљи обавештење о новим верзијама само ако доступни кôд има, најмање, изабрани ниво зрелости. Нове верзије додатака које не објављују зрелост свог кôда увек се пријављују, без обзира на ово подешавање.';
$string['updatenotificationfooter'] = 'Ваш Moodle сајт {$a->siteurl} је конфигурисан да аутоматски проверава да ли су доступне нове верзије програма. Ову поруку сте добили као администратор сајта. Аутоматску проверу нових верзија можете да онемогућите у секцији \'Администрација сајта\' унутар блока \'Администрација\'. Начин слања ове поруке можете да прилагодите помоћу свог личног подешавања за \'Слање порука\' у секцији \'Подешавања мог профила\'.';
$string['updatenotifications'] = 'Обавештења о новим верзијама';
$string['updatenotificationsubject'] = 'Доступне су нове верзије Moodlea ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Обавести о новим подверзијама';
$string['updatenotifybuilds_desc'] = 'Ако је ово подешавање омогућено,  онда ће обавештење о новoj верзији Moodle пакета бити послато и у ситуацијама када је доступна нова подверзија за текућу верзију програма. Подверзије (builds) представљају континуирана побољшања дате верзије Moodlea. Генерално, ова обавештења се објављују сваке недеље. Ако је овo подешавање онемогућено, обавештење о новој верзији ће бити послато само када се појави нова, унапређена верзија. Ово подешавање не утиче на проверу нових верзија додатака.';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 садржи неколико безбедносних поправки за корисничке лозинке и резервне копије података како би се заштитили кориснички подаци на вашем сајту. Због тога нека од ваших подешавања и овлашћења везана за резервне копије података могу бити промењена.<br /> Погледајте <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes</a> за више детаља.</p>';
$string['upgrade197noticesubject'] = 'Сигурносно обавештење о надоградњи Moodle 1.9.7 верзије';
$string['upgrade197salt'] = 'Да бисте смањили ризик од крађе лозинки, строго се препоручује да подесите тзв. <i>password salt</i>.(врло дугачак насумични низ карактера)<br />Погледајте <a href="{$a}" target="_blank">password salting documentation</a> за детаљније информације.';
$string['upgradeerror'] = 'Непозната грешка у току надоградње {$a->plugin} на верзију {$a->version}. Није могуће наставити.';
$string['upgradeforumread'] = 'Moodle верзији 1.5 је додата нова опција за праћење прочитаних/непрочитаних порука у форумима. <br />Да бисте могли да користите ову опцију морате да <a href={$a}>ажурирате своје табеле</a>.';
$string['upgradeforumreadinfo'] = 'Moodle верзији 1.5 је додата нова опција за праћење прочитаних/непрочитаних порука у форумима. Да бисте могли да користите ову опцију морате да ажурирате своје табеле заједно са свим информацијама за постојеће поруке на форумима. У зависности од величине Вашег сајта таква акција може потрајати (и до неколико сати) и може оптеретити базу података, тако да је најбоље да то обавите када је сервер мање оптерећен. Ипак, Ваш сајт ће у току освежавања бити у функцији и корисници неће бити тиме погођени. Када једном започнете овај процес пустите да се заврши (оставите отворен прозор свог веб читача). Уколико, ипак, затворите прозор: не брините, моћи ћете поново да стартујте процес.<br /><br />Да ли желите да започнете процес ажурирања?';
$string['upgradelogs'] = 'Због потпуне фукционалности, ваши стари записи о активностима треба да буду надограђени. <a href="{$a}">Више информацијa</a>';
$string['upgradelogsinfo'] = 'Недавно су направљене одређене промене у начину чувања записа о активностима. Да бисте могли да видите све своје старе записе, редом по активностима, потребно је да их надоградите. У зависности од вашег сајта, то може да потраје (и до неколико сати) и да оптерети базу података за велике сајтове. Једном када започнете овај процес, потребно је да га пустите да се заврши (тако што ћете прозор веб читача оставити отворен). Не брините - док се записи о активностима надограђују. ваш сајт ће и даље радити без проблема за остале кориснике,.<br /><br />Да ли желите сада да надоградите записе о активностима?';
$string['upgradepluginsfirst'] = 'Препоручује се да се прво инсталира све доступне нове верзије';
$string['upgradepluginsinfo'] = 'Надоградња додатака';
$string['upgradepluginsinfo_help'] = 'Постоје доступне нове верзије за неке од ваших додатака. Требало би да их све инсталирате пре надоградње Moodle базе података. Ако ваш сајт не подржава аутоматско ажурирање, морате да преузмете и ручно, на серверу, инсталирате нове верзије додатака.';
$string['upgradesettings'] = 'Нова подешавања';
$string['upgradesettingsintro'] = 'Доле наведена подешавања су додата током последње надоградње Moodlea. Направите све потребне промене подразумеваних вредности и кликните на дугме "Сачувај промене" на дну ове странице.';
$string['upgradestalefiles'] = 'Откривене су измешане верзије Moodle па надоградња не може да се настави';
$string['upgradestalefilesinfo'] = 'Процес надоградње Moodlea је заустављен зато што су у Moodle директоријуму откривене PHP скрипте из најмање две различите верзије Moodlea

Ово касније може да направи велике проблеме. Како бисте наставили процес надоградње, морате прво да обезбедите да у Moodle директоријуму буду датотеке само једне верзије Moodlea

Да бисте очистили Moodle директоријум и решили овај проблем урадите следеће:

* промените назив текућег Moodle директоријума у "moodle_old"
* креирајте нови Moodle директоријум који садржи само датотеке из стандардног Moodle пакета, или из GIT репозиторијума.
* пребаците оригиналну config.php датотеку и све нестандардне додатке из старог, ”moodle_old”, у нови Moodle директоријум.

Када завршите описану процедуру, освежите ову страницу како бисте наставили процес надоградњу Moodlea.

Ово упозорење је често последица распакивања стандардног Moodle пакета у постојећи директоријум, у којем се налази претходна верзија Moodlea. Иако овај поступак не ствара проблеме приликом мањих надоградњи, никако се не саветује када се раде велике надоградње Moodlea.

Упозорење, такође, може да буде последица непотпуне провере или надоградње из GIT репозиторијума, у ком случају ћете морати само да сачекате да се операција заврши, евентуално покренете одговарајућу команду за чишћење и поново покушате операцију.

Више информација можете наћи у документацији о надоградњи на <a href=”{$a}">{$a}</a>';
$string['upgradestart'] = 'Надогради Moodle базу података сада';
$string['upgradesure'] = '<p>Ваше Moodle датотеке су измењене, и намеравате да аутоматски надоградите свој сервер на ову верзију:</p>
<p><strong>{$a}</strong></p>
<p>Једном када ово урадите не можете се вратити назад. Молимо узмите у обзир и то да овај процес може да потраје.</p>
<p>Да ли сте сигурни да желите да надоградите сервер на ову верзију?</p>';
$string['upgradetimedout'] = 'Истекло је време за ажурирање, молимо започните процес ажурирања изнова.';
$string['upgradingdata'] = 'Ажурирање података је у току';
$string['upgradinglogs'] = 'Надоградња записа о активностима је у току';
$string['upgradingversion'] = 'Ажурирај на нову верзију';
$string['upwards'] = 'нагоре';
$string['useblogassociations'] = 'Омогући повезивање';
$string['useexternalyui'] = 'Користи YUI библиотеке на мрежи';
$string['user'] = 'Корисник';
$string['userbulk'] = 'Масовне акције над корисницима';
$string['userlist'] = 'Преглед списка корисника';
$string['userpolicies'] = 'Правила за кориснике';
$string['userpreference'] = 'Корисничка подешавања';
$string['userquota'] = 'Корисничка квота';
$string['users'] = 'Корисници';
$string['usesitenameforsitepages'] = 'Користи назив сајта за странице сајта';
$string['usetags'] = 'Омогући ознаке (тагове)';
$string['validateerror'] = 'Ова вредност није ваљана:';
$string['verifychangedemail'] = 'Ограничи домене приликом промене е-адресе';
$string['warningcurrentsetting'] = 'Неисправна тренутна вредност: {$a}';
$string['warningiconvbuggy'] = 'Ваша верзија iconv библиотеке не подржава //IGNORE модификатор. Требало би да инсталирате екстензију mbstring која може, уместо iconv библиотеке, да се користи за чишћење стрингова који садрже неисправне UTF-8 карактере.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Попуни следеће опције уколико Moodle сервер не може да приступи Интернету директно. Приступ Интернету је неопходан за преузимање података о окружењу, језичких пакета, RSS извора вести, временских зона итд.<br /><em>PHP cURL екстензија се препоручује!!!.</em>';
$string['xmlrpcrecommended'] = 'xmlrpc екстензија је потребна за комуникацију с чвориштем, а корисна је и за веб сервисе, као и за MNet.';
$string['yuicomboloading'] = 'YUI combo се учитава';
$string['ziprequired'] = 'PHP екстензија Zip сада је обавезна за Moodle, бинарне info-ZIP датотеке и библиотека PclZip више се не користе.';
$string['zlibenabled'] = 'zlib омогућен';
