<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'group', language 'he', branch 'MOODLE_26_STABLE'
 *
 * @package   group
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addedby'] = 'נוסף על ידי {$a}';
$string['addgroup'] = 'הוסף משתמש לקבוצה';
$string['addgroupstogrouping'] = 'הוסף קבוצות לאוסף הקבוצות';
$string['addgroupstogroupings'] = 'הוספת/הסרת קבוצות';
$string['adduserstogroup'] = 'הוספת/הסרת משתתפים מקבוצה';
$string['allocateby'] = 'הקצאת חברי קבוצה';
$string['anygrouping'] = '[כל אוסף קבוצות]';
$string['autocreategroups'] = 'יצירת קבוצות אוטומטית';
$string['backtogroupings'] = 'בחזרה לאוסף הקבוצות';
$string['backtogroups'] = 'חזרה לקבוצות';
$string['badnamingscheme'] = 'חייב להכיל לפחות סימן אחד של \'@\' או \'#\'';
$string['byfirstname'] = 'על פי סדר האלף-בית של שם פרטי, שם משפחה';
$string['byidnumber'] = 'על פי סדר האלף-בית של מספר זהות';
$string['bylastname'] = 'על פי סדר האלף-בית של שם משפחה, שם פרטי';
$string['createautomaticgrouping'] = 'יצירת חלוקה אוטומטית לקבוצות';
$string['creategroup'] = 'יצירת קבוצה';
$string['creategrouping'] = 'יצירת אוסף־קבוצות';
$string['creategroupinselectedgrouping'] = 'יצירת קבוצה באוסף־הקבוצות הנבחר';
$string['createingrouping'] = 'אוסף קבוצות מתוך יצירה אוטומטית של קבוצות';
$string['createorphangroup'] = 'יצירת קבוצה יתומה';
$string['databaseupgradegroups'] = 'כעת גירסת הקבוצה היא {$a}';
$string['defaultgrouping'] = 'אוסף־קבוצות<br/>(ברירת מחדל)';
$string['defaultgroupingname'] = 'אוסף קבוצות';
$string['defaultgroupname'] = 'קבוצה';
$string['deleteallgroupings'] = 'מחק את כל אוסף הקבוצות';
$string['deleteallgroups'] = 'מחק את כל הקבוצות';
$string['deletegroupconfirm'] = 'האם אתה בטוח שברצונך למחוק את הקבוצה {$a}?';
$string['deletegrouping'] = 'מחק את אוסף הקבוצות';
$string['deletegroupingconfirm'] = 'האם אתה בטוח שברצונך למחוק את אוסף הקבוצות {$a}? (הקבוצות שנמצאות בתוך אוסף הקבוצות לא נמחקות)';
$string['deletegroupsconfirm'] = 'האם אתה בטוח כי ברצונך למחוק את הקבוצות הבאות?';
$string['deleteselectedgroup'] = 'מחק את הקבוצה שנבחרה';
$string['editgroupingsettings'] = 'עריכת הגדרות אוסף הקבוצות';
$string['editgroupsettings'] = 'עריכת הגדרות הקבוצה';
$string['enrolmentkey'] = 'מפתח הרשמה';
$string['enrolmentkeyalreadyinuse'] = 'מפתח הרשמה זה כבר קיים לקבוצה אחרת';
$string['enrolmentkey_help'] = 'מפתח הרשמה מאפשר גישה לקורס, הגבלת גישה רק לאלו היודעים את המפתח. אם מצויין מפתח הרשמה, הפעולה תרשום את המשתמש לקורס וגם כחבר לקבוצה באופן אוטומטי.';
$string['erroraddremoveuser'] = 'חלה שגיאה במהלך ניסיון ההוספהמחיקה של המשתמש {$a} למהקבוצה';
$string['erroreditgroup'] = 'חלה שגיאה במהלך היצירההעדכון של הקבוצה {$a}';
$string['erroreditgrouping'] = 'חלה שגיאה במהלך היצירההעדכון של אוסף הקבוצות {$a}';
$string['errorinvalidgroup'] = 'שגיאה, {$a} קבוצה לא תקפה';
$string['errorremovenotpermitted'] = 'אין לך הרשאה להסיר חבר קבוצה שנוסף אוטומטית {$a}';
$string['errorselectone'] = 'אנא בחר קבוצה אחת לפני בחירת אפשרות זו';
$string['errorselectsome'] = 'אנא בחר קבוצה אחת או כמה לפני בחירת אפשרות זו';
$string['evenallocation'] = 'הערה: בכדי לקיים הקצאת קבוצה שווה, המספר הממשי של חברים לכל קבוצה שונה מהמספר שציינת.';
$string['event_group_created'] = 'הקבוצה נוצרה';
$string['event_group_deleted'] = 'הקבוצה נמחקה';
$string['event_grouping_created'] = 'אוסף קבוצות נוצר';
$string['event_grouping_deleted'] = 'אוסף קבוצות נמחק';
$string['event_grouping_updated'] = 'אוסף קבוצות עודכן';
$string['event_group_member_added'] = 'נוסף חבר לקבוצה';
$string['event_group_member_removed'] = 'הוסר חבר מהקבוצה';
$string['event_group_updated'] = 'הקבוצה עודכנה';
$string['existingmembers'] = 'חברים קיימים: {$a}';
$string['filtergroups'] = 'סנן קבוצות על-ידי:';
$string['group'] = 'קבוצה';
$string['groupaddedsuccesfully'] = 'קבוצה {$a} נוספה בהצלחה';
$string['groupaddedtogroupingsuccesfully'] = 'הקבוצה {$a->groupname} נוספה בהצלחה לאוסף הקבוצות {$a->groupingname}';
$string['groupby'] = 'יצירה אוטומטית מבוססת לפי חלוקה של';
$string['groupdescription'] = 'תיאור הקבוצה';
$string['groupinfo'] = 'מידע על הקבוצה שנבחרה';
$string['groupinfomembers'] = 'מידע על חברי הקבוצה שנבחרו';
$string['groupinfopeople'] = 'מידע על האנשים שנבחרו';
$string['grouping'] = 'אוסף קבוצות';
$string['groupingaddedsuccesfully'] = 'אוסף הקבוצות {$a} נוסף בהצלחה';
$string['groupingdescription'] = 'תיאור אוסף הקבוצות';
$string['grouping_help'] = '<p>"אוסף קבוצות" הינו אוסף הקבוצות בקורס.</p>

<p> במידה ואוסף קבוצות נבחר, משתמשים אשר רשומים לקבוצה שנכללת באוסף הקבוצות יוכלו לעבוד יחד על מה שנבחר.</p>

<p>חובה לסמן את מצב הקבוצות ל"קבוצות נפרדות " או "קבוצות נראות" תחת ניהול הקורס.</p>';
$string['groupingname'] = 'שם אוסף הקבוצות';
$string['groupingnameexists'] = 'שם אוסף הקבוצות \'{$a}\' כבר קיים בקורס. אנא בחר שם אחר.';
$string['groupings'] = 'אוספי קבוצות';
$string['groupingsection'] = 'נגיש לאוסף-הקבוצות';
$string['groupingsection_help'] = '"אוסף קבוצות" זהו לקט של קבוצות בקורס. אם נבחר אוסף קבוצה כאן, רק הסטודנטים שרשומים לקבוצה שנמצאת באוסף הקבוצה הזה יוכלו לגשת ליחידת הוראה.';
$string['groupingsonly'] = 'אוספי קבוצות בלבד';
$string['groupmember'] = 'חבר בקבוצה';
$string['groupmemberdesc'] = 'תפקיד סטנדרתי לחבר בקבוצה';
$string['groupmembers'] = 'חברי הקבוצה';
$string['groupmembersonly'] = 'זמין רק לחברי אוסף הקבוצה';
$string['groupmembersonlyerror'] = 'אנו מצטערים, אולם אליך להיות חבר בלפחות קבוצה אחת שמשתשמים בה בפעילות זאת.';
$string['groupmembersonly_help'] = '<p>אם תיבת "זמין רק עבור חברי הקבוצה" מסומנת, הפעילות (או המשאב) תיהיה זמינה למשתמשים אשר רשומים לקבוצות שבתוך אוסף הקבוצות או לכל הקבוצות אם לא נבחר אף אוסף קבוצה.</p>';
$string['groupmemberssee'] = 'ראה את חברי הקבוצה';
$string['groupmembersselected'] = 'חברי הקבוצה שנבחרה';
$string['groupmode'] = 'מצב קבוצה';
$string['groupmodeforce'] = 'מצב קבוצה מאולץ<br/>
(בכל רכיבי הקורס)';
$string['groupmodeforce_help'] = 'כאשר מצב הקבוצה מאולץ, מצב הקבוצה בקורס תקף לכל פעילות בקורס. אין התחשבות  בהגדרות מצב הקבוצה בכל פעילות.';
$string['groupmode_help'] = '<p align="center"><b>מצב קבוצה</b></p>

<p>מצב הקבוצה יכול להיות כל אחד משלוש הרמות הבאות:
   <ul>
      <li>אין קבוצות - כל המשתמשים רואים אחד את השני ויכולים לבצע פעילות אחד עם השני, בהתאם לרכיב בו הם נמצאים.</li>
      <li>קבוצות נפרדות - כל קבוצת משתמשים יכולה לראות רק את חברי הקבוצה עצמה, משתמשים אחרים בקורס אינם נראים, במסגרת הפעילות המסויימת.</li>
      <li>קבוצות נראות - כל קבוצת משתמשים פועלת במסגרת הקבוצה עצמה, אך בנוסף, יכולה לראות גם פעילות משתמשים מקבוצות אחרות.</li>
   </ul>
</p>

<p>את מצב הקבוצה ניתן להגדיר בשתי רמות:</p>

<dl>
   <dt><b>1. רמת הקורס</b></dt>
   <dd>מצב הקבוצה שמוגדר ברמת הקורס, הינו מצב ברירת המחדל לכל הפעילויות שמוגדרות בתוך אותו קורס.<br /><br /></dd>
   <dt><b>2. רמת הפעילות</b></dt>
   <dd>ניתן להגדיר מצב קבוצה פרטנית לכל פעילות שתומכת בקבוצות. אם הקורס נקבע ל"<a href="help.php?module=moodle&file=groupmodeforce.html">כפה מצב קבוצה</a>"
אז לא מתייחסים להגדרות הפרטניות של כל פעילות.</dd>
</dl>';
$string['groupmy'] = 'הקבוצה שלי';
$string['groupname'] = 'שם הקבוצה';
$string['groupnameexists'] = 'שם הקבוצה \'{$a}\' כבר קיים בקורס זה, אנא בחר בשם אחר.';
$string['groupnotamember'] = 'סליחה, אינך חבר בקבוצה זו';
$string['groups'] = 'קבוצות';
$string['groupscount'] = 'קבוצות ({$a})';
$string['groupsettingsheader'] = 'קבוצות';
$string['groupsgroupings'] = 'קבוצות &amp; אוספי קבוצות';
$string['groupsinselectedgrouping'] = 'קבוצות באוסף הקבוצות הנבחר';
$string['groupsnone'] = 'אין קבוצות';
$string['groupsonly'] = 'קבוצות בלבד';
$string['groupspreview'] = 'תצוגה מקדימה של הקבוצות';
$string['groupsseparate'] = 'קבוצות נפרדות';
$string['groupsvisible'] = 'קבוצות נראות';
$string['grouptemplate'] = 'קבוצה @';
$string['hidepicture'] = 'הסתר את התמונה';
$string['importgroups'] = 'יבוא קבוצות';
$string['importgroups_help'] = 'ניתן לייבא קבוצות דרך קובץ טקסט. תסדיר הקובץ צריך להיות כך:
* כל שורה בקובץ תכיל רשומה אחת
*  כל רשומה היא סדרה של נתונים המופרדים בפסיק
* השורה הראשונה מכילה את שמות השדות המגדירות את תסדיר של שאר הנתונים
* שם השדה שנדרש הוא  groupname
*  שדות רשות: description, enrolmentkey, picture, hidepicture';
$string['javascriptrequired'] = 'עמוד זה דורש הפעלה של Javascript.';
$string['members'] = 'חברים לכל קבוצה';
$string['membersofselectedgroup'] = 'חברי הקבוצה שנבחרה';
$string['namingscheme'] = 'תבנית שמות הקבוצות';
$string['namingscheme_help'] = 'סימון הכרוכית (@) משומש ליצירת קבוצות עם שמות המכילות אותיות. למשל קבוצה@ תייצר קבוצות כך: קבוצה א, קבוצה ב, קבוצה ג ...
סימון הסולמית (#) משומש ליצירת קבוצות עם שמות המכילות מספרים. למשל קבוצה#  תייצר קבוצות כך: קבוצה 1 , קבוצה 2, קבוצה 3, ....
';
$string['newgrouping'] = 'אוסף קבוצות חדש';
$string['newpicture'] = 'תמונה חדשה';
$string['newpicture_help'] = '<p align="center"><b>העלאת תמונה</b></p>

<p>אתם יכולים להעלות תמונה מהמחשב שלכם לשרת זה, תמונה זו תופיע בכל מני מקומות ותסמל אתכם.
</p>
<p>מסיבה זו, התמונות שהכי כדאי להשתמש בהן הן תמונות \'קלוז-אפ\' של הפנים שלכם, אבל אתם יכולים להשתמש בכל תמונה שרק תרצו.
</p>
<p>על התמונה להיות בתסדיר JPG או PNG (כלומר, לרוב סיומת שמות הקבצים תהיה .jpg או .png).</p>
<p>אתם יכולים להשיג קובץ תמונה באמצעות אחת מתוך ארבע השיטות הבאות:
</p>

<ol>
<li>אם תשתמשו במצלמה דיגיטלית, רוב הסיכויים שהתמונות שלכם כבר יהיו על המחשב שלכם בתסדיר המתאים. </li>
<li>אתם יכולים להשתמש בסורק כדי לסרוק תמונה מודפסת. וודאו שאתם שומרים אותה כתסדיר  JPG או PNG.</li>
<li>אם יש לכם כישורים אומנותיים, אולי תירצו לצייר תמונה באמצעות תוכנת ציור.
</li>
<li>לבסוף, תוכלו \'לגנוב\' תמונות מהרשת. <a target="google" href="http://images.google.com/">http://images.google.com</a> הוא מקום נפלא לחפש אחר תמונות. מרגע שתמצאו תמונה, אתם יכולים ללחוץ עליה באמצעות הכפתור הימני של העכבר ולבחור ב-"שמור את התמונה..." מהתפריט שיופיע (במחשבים שונים יכולים להיות שינויים מעטים).</li>
</ol>

<p>כדי להעלות את התמונה, לחצו על כפתור ה"עיין" בעמוד העריכה וביחרו בתמונה מהדיסק הקשיח שלכם.
</p>
<p>שימו לב: וודאו שהקובץ לא עולה בגודלו על הגודל המירבי הרשום אחרת הוא לא יעלה.
</p>
<p>לאחר מכן לחצו על "עדכן את הפרופיל שלי" בתחתית - קובץ התמונה יקוצץ לריבוע וגודלו ישונה ל 100 X 100 פיקסלים.
</p>
<p>כשאתם חוזרים לעמוד הפרופיל שלכם יכול להיות שהתמונה לא תיראה שונה. אם זהו המקרה, פשוט השתמשו בכפתור ה"טען מחדש" בשרת שלכם.';
$string['noallocation'] = 'ללא הקצאה';
$string['nogrouping'] = 'אין אוסף קבוצות';
$string['nogroups'] = 'לא קיים עדיין מבנה קבוצות בקורס זה';
$string['nogroupsassigned'] = 'לא מוקצות קבוצות';
$string['nopermissionforcreation'] = 'לא ניתן ליצור את קבוצה "{$a}" מפני שאין לך את ההרשאות המתאימות לכך';
$string['nosmallgroups'] = 'מנע קבוצה קטנה אחרונה';
$string['notingrouping'] = '[לא נמצא באוסף קבוצות]';
$string['nousersinrole'] = 'לא קיימים משתמשים מתאימים בתפקיד הנבחר';
$string['number'] = 'כמות חברים או כמות קבוצות';
$string['numgroups'] = 'כמות הקבוצות';
$string['nummembers'] = 'חברים בכל קבוצה';
$string['overview'] = 'סקירה כללית';
$string['potentialmembers'] = 'חברים אפשריים: {$a}';
$string['potentialmembs'] = 'משתמשים זמינים';
$string['printerfriendly'] = 'תצוגת קבוצות ידידותית להדפסה';
$string['random'] = 'אקראי';
$string['removefromgroup'] = 'הסרת משתמש מקבוצה {$a}';
$string['removefromgroupconfirm'] = 'האם הינך בטוח כי ברצונך להסיר את המשתמש "{$a->user}" מהקבוצה
"{$a->group}"?';
$string['removegroupfromselectedgrouping'] = 'הוצא את הקבוצה מאוסף הקבוצות שנבחר.';
$string['removegroupingsmembers'] = 'הסרת כל הקבוצות מאוספי הקבוצות';
$string['removegroupsmembers'] = 'הסרת כל חברי הקבוצה';
$string['removeselectedusers'] = 'הוצא את המשתמשים שנבחרו.';
$string['selectfromrole'] = 'בחירת חברי קבוצה עם תפקיד';
$string['showgroupsingrouping'] = 'הראה את הקבוצות באוסף הקבוצות';
$string['showmembersforgroup'] = 'הראה את החברים עבור הקבוצה';
$string['toomanygroups'] = 'אין מספיק משתמשים או שמספרם לקוי בכדי ליישב את מספר קבוצות זה - קיימים רק {$a} משתמשים בתפקיד הנבחר.';
$string['usercount'] = 'ספירת משתמש';
$string['usercounttotal'] = 'ספירת משתמש ({$a})';
$string['usergroupmembership'] = 'המשתמש שייך לקבוצות:';
