<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_splash', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_splash
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Splash</h2>
<img src="splash/pix/screenshot.jpg" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3><p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentation:</h3>
<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>
<h3>Fehler melden:</h3><p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Splash</h2>
<p>Splash ist ein Drei-Spalten-Design mit variabler Breite für Moodle 2.0.
<h2>Hinweise</h2>
<p>Dieses Design basiert auf den beiden in Moodle enthaltenen Grunddesigns Base und Canvas. Wenn Sie Änderungen vornehmen wollen, empfehlen wir unbedingt, vorher immer eine Kopie zu erstellen und diese umzubenennen. So wird verhindert, dass Ihre Änderungen bei einem Update von Moodle verloren gehen; Sollte Ihnen ein Fehler in den Änderungen unterlaufen, haben Sie so ebenfalls noch eine funktionierende Sicherheitskopie. Weitere Informationen zum Bearbeiten von Designs finden Sie in der <a href="http://docs.moodle.org/de/Designs">Designdokumentation</a>.</p>
<h2>Autor</h2>
<p>Dieses Design stammt von Caroline Kennedy (Synergy Learning). Kontaktaufnahme ist per E-Mail: caroline.kennedy@synergy-learningw.com</p>
<h2>Lizenz</h2>
<p>Alle in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
</div>
</div>';
$string['configtitle'] = 'Splash-Einstellungen';
$string['customcss'] = 'CSS-Anpassungen';
$string['customcssdesc'] = 'Die CSS-Anpassungen werden auf jeder Seite benutzt. Das Design kann so einfach geändert werden.';
$string['defaulttagline'] = 'Virtuelles Lernbüro';
$string['footnote'] = 'Fußnote';
$string['footnotedesc'] = 'Der Inhalt dieses Textfeldes wird in der Fußzeile auf jeder Seite angezeigt.';
$string['hide_tagline'] = 'Untertitel verbergen';
$string['hide_taglinedesc'] = 'Wenn diese Option aktiviert ist, wird der Untertitel unter dem Logo nicht angezeigt.';
$string['loginhere'] = 'Hier einloggen!';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Um ein eigenes Logo zu verwenden, geben Sie die URL zu einem Logo an (z.B. http://www.server.de/logo.png). Das Logo sollte maximal 230px breit sein.';
$string['pluginname'] = 'Splash';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['tagline'] = 'Untertitel';
$string['taglinedesc'] = 'Der Inhalt dieses Textfeldes wird auf der Startseite unter dem Website-Logo angezeigt.';
$string['usergreeting'] = 'Hi {$a}!';
$string['welcome'] = 'Hi, {$a}';
