<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Mitteilung 1';
$string['alert2'] = 'Mitteilung 2';
$string['alert3'] = 'Mitteilung 3';
$string['alert_general'] = 'Ankündigung';
$string['alert_info'] = 'Information';
$string['alertsdesc'] = 'Sie können auf der Startseite eine (oder auch mehrere) Mitteilungen einblenden, u.z. in drei unterschiedlichen Varianten. Denken Sie daran, die Mitteilungen zu deaktivieren, wenn diese nicht mehr benötigt werden.';
$string['alertsheading'] = 'Nutzermitteilungen';
$string['alertsheadingsub'] = 'Wichtige Mitteilungen auf der Startseite';
$string['alerttext'] = 'Mitteilungstext';
$string['alerttextdesc'] = 'Welchen Text möchten Sie als Mitteilung anzeigen?';
$string['alerttitle'] = 'Überschrift';
$string['alerttitledesc'] = 'Überschrift der Mitteilung';
$string['alerttype'] = 'Mitteilungstyp';
$string['alerttypedesc'] = 'Wählen Sie den Typ bzw. die Wichtigkeit der Mitteilung.';
$string['alert_warning'] = 'Hinweis';
$string['allclasses'] = 'Alle Klassen';
$string['allcourses'] = 'Alle Kurse';
$string['allmodules'] = 'Alle Lernmodule';
$string['allunits'] = 'Alle Lerneinheiten';
$string['alternativecolors'] = 'Alternative Farbe {$a}';
$string['alternativethemecolor'] = 'Alternative Designfarbe {$a}';
$string['alternativethemecolordesc'] = 'Welche Farbe soll Ihr Design im alternativen Farbset {$a} haben?';
$string['alternativethemecolorname'] = 'Name für alternatives Farbschema {$a}';
$string['alternativethemecolornamedesc'] = 'Legen Sie einen aussagekräftigen Namen für das alternative Farbschema fest.';
$string['alternativethemecolors'] = 'Alternative Designfarben';
$string['alternativethemecolorsdesc'] = 'Diese Option legt Farbalternativen für das Design fest, die Nutzer/innen auswählen dürfen.';
$string['alternativethemehovercolor'] = 'Alternative Hoverfarbe {$a}';
$string['alternativethemehovercolordesc'] = 'Welche Farbe sollen Links im alternativen Farbschema {$a} haben, wenn sie mit der Maus berührt werden?';
$string['alternativethemename'] = 'Name für Farbschema';
$string['alternativethemenamedesc'] = 'Legen Sie einen Namen für das alternative Farbeschema fest.';
$string['alternativethemetextcolor'] = 'Alternative Textfarbe {$a}';
$string['alternativethemetextcolordesc'] = 'Wählen Sie die alternative Textfarbe {$a} aus.';
$string['alternativethemeurlcolor'] = 'Alternative Linkfarbe {$a}';
$string['alternativethemeurlcolordesc'] = 'Wählen Sie die alternative Linkfarbe {$a} aus.';
$string['alwaysdisplay'] = 'Immer anzeigen';
$string['analytics'] = 'Analytics';
$string['analyticscleanurl'] = 'Saubere URLs';
$string['analyticscleanurldesc'] = 'Für ein erweitertes Tracking sollen saubere URLs angelegt werden.';
$string['analyticsdesc'] = 'Wählen Sie den Typ von Analytics, den Sie verwenden möchten. Speichern Sie, um weitere Optionen zu aktivieren.';
$string['analyticsenabled'] = 'Aktiviert';
$string['analyticsenableddesc'] = 'Analytics für Moodle aktivieren';
$string['analyticsguniversal'] = 'Google Universal Analytics';
$string['analyticsheadingsub'] = 'Google Analytics ist ein leistungsfähiges Werkzeug zur Auswertung von Webzugriffen.';
$string['analyticsimagetrack'] = 'Bild-Tracking';
$string['analyticsimagetrackdesc'] = 'Bild-Tracking für Browser aktivieren, bei denen JavaScript nicht läuft.';
$string['analyticspiwik'] = 'Piwik';
$string['analyticssiteid'] = 'Website ID';
$string['analyticssiteiddesc'] = 'Geben Sie die Website ID an.';
$string['analyticssiteurl'] = 'Analytics URL';
$string['analyticssiteurldesc'] = 'Geben Sie Ihre \'Piwik Analytics\' URL an, u.z. ohne http(s):// und ohne Schrägstrich am Ende, z.B. \'meineseite.de/Analytics\'.';
$string['analyticstrackadmin'] = 'Admins tracken';
$string['analyticstrackadmindesc'] = 'Tracking für Administrator/innen aktivieren (nicht empfohlen)';
$string['analyticstrackingid'] = 'Tracking-ID';
$string['analyticstrackingiddesc'] = 'Geben Sie die Tracking-ID ein.';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Geben Sie die URL zu Ihrer Mobile App im Google Play Store an. Wenn Sie keine eigene App haben, können Sie stattdessen die offizielle Moodle Mobile App verlinken.
<br />https://play.google.com/store/apps/details?id=com.moodle.moodlemobile';
$string['backgroundstylefixed'] = 'Fest';
$string['backgroundstylestretch'] = 'Gedehnt';
$string['backgroundstyletiled'] = 'Gekachelt';
$string['backtotop'] = 'Zum Seitenanfang';
$string['badgepreferences'] = 'Auszeichnungseinstellungen';
$string['blogpreferences'] = 'Blogeinstellungen';
$string['bootstrapcdn'] = 'FontAwesome von CDN';
$string['bootstrapcdndesc'] = 'Diese Option legt fest, ob der Zeichensatz FontAwesome aus der Onlinequelle von Bootstrap CDN nachgeladen wird. Aktivieren Sie die Option, wenn die FontAwesome Icons auf Ihrer Website nicht richtig angezeigt werden.';
$string['breadcrumbsimple'] = 'Einfach';
$string['breadcrumbstyle'] = 'Navigationsleiste';
$string['breadcrumbstyled'] = 'Fancy';
$string['breadcrumbstyledesc'] = 'Diese Option legt das Aussehen der Navigationsleiste fest.';
$string['breadcrumbstylednocollapse'] = 'Fancy ohne Verkürzung';
$string['breadcrumbthin'] = 'Dünn';
$string['cachesused'] = 'Cached benutzt';
$string['categoryiconcategory'] = 'Icon für den Kursbereich {$a->category}';
$string['categoryicondesc'] = 'Diese Option erlaubt, Icons für jeden Kursbereich festzulegen.';
$string['categoryiconheading'] = 'Icons für Kursbereiche';
$string['categoryiconheadingsub'] = 'Die Kursbereiche können über Icons symbolisiert werden.';
$string['categoryiconinfo'] = 'Eigene Icons für Kursbereiche festlegen';
$string['categoryiconinfodesc'] = 'Geben Sie das Icon an, das Sie verwenden möchten. Alle verfügbaren Icons finden Sie <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">in dieser Liste</a>. Tragen Sie den Text nach \'fa-\' ein.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class=img-polaroid src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Über Essential</h3>
<p>Essential ist ein angepasstes Design basierend auf Bootstrap. StyleSheets, Rendering und Einstellungen werden von Bootstrap vererbt und können in Essential angepasst werden.</p>
<h3>Entwicklung von Essential</h3>
<p>Ab 2013 Julian Ridden
<br />Ab Juli 2014 Gareth J. Barnard, David Bezemer
<br />Ab Oktober 2014 Gareth J. Barnard
</p>
<h3>Donations</h3>
<p>Dieses Design wird Ihnen kostenlos zur Verfügung gestellt. Falls Sie sich gerne bedanken und uns unterstützen möchten, spenden Sie bitte einen Betrag. Bitte kontaktieren Sie mich über mein <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle-Profil\'</a>.
<br>Spenden helfen, weitere und verbesserte Funktionen zu entwickeln. Ohne Unterstützung kann ich das Design nicht weiter bearbeiten.</p></div></div>';
$string['colordesc'] = 'Für dieses Design können zahlreiche Farbeinstellungen vorgenommen werden.';
$string['colorheading'] = 'Farbe';
$string['colorheadingsub'] = 'Wählen Sie die Farben für das Design aus.';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Kontakt';
$string['contactinfodesc'] = 'Geben Sie Ihre Kontaktdaten ein.';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'Fügen Sie hier mögliche Hinweise zum Copyright und zur Organisation ein.';
$string['coursegrades'] = 'Kursbewertung';
$string['customcss'] = 'CSS-Anpassungen';
$string['customcssdesc'] = 'Die CSS-Anpassungen werden auf jeder Seite benutzt. Das Design kann so einfach angepasst werden.';
$string['dbqueries'] = 'DB Read/Write';
$string['defaultcategoryicon'] = 'Standardmäßige Icons für Kursbereiche';
$string['defaultcategoryicondesc'] = 'Legen Sie ein standardmäßiges Icon für Kursbereiche fest.';
$string['defaultcolors'] = 'Standard';
$string['displayafterlogin'] = 'Nur mit Anmeldung anzeigen';
$string['displaybeforelogin'] = 'Nur ohne Anmeldung anzeigen';
$string['displaymycourses'] = 'Eingeschriebene Kurse anzeigen';
$string['displaymycoursesdesc'] = 'Eingeschriebene Kurse der Nutzer/innen im Benutzermenü anzeigen';
$string['donate_desc'] = 'Unterstützen Sie die Entwicklung von Essential';
$string['donate_desc2'] = '.';
$string['donate_title'] = 'Spenden für Essential';
$string['dontdisplay'] = 'Nie anzeigen';
$string['enablealert'] = 'Mitteilung aktivieren';
$string['enablealertdesc'] = 'Legen Sie fest, ob diese Mitteilung angezeigt werden soll.';
$string['enablealternativethemecolors'] = 'Alternatives Farbschema {$a} aktivieren';
$string['enablealternativethemecolorsdesc'] = 'Diese Option erlaubt es, dass Nutzer/innen das alternative Farbschema {$a} auswählen.';
$string['enablecategoryicon'] = 'Icons für Kursbereiche';
$string['enablecategoryicondesc'] = 'Wenn Sie diese Option aktivieren, müssen Sie zuerst die \'Änderungen speichern\' und können anschließend die Kategorie-Icons auswählen.';
$string['enablecustomcategoryicon'] = 'Eigene Icons für Kursbereiche';
$string['enablecustomcategoryicondesc'] = 'Wenn Sie diese Option aktivieren, finden Sie für jede Kategorie eine Option. Bitte speichern Sie die Änderungen jeweils sofort nach dem Aktivieren und Deaktivieren dieser Option.';
$string['extperfinfoheading'] = 'Erweiterte Performance-Informationen';
$string['facebook'] = 'Facebook URL';
$string['facebookdesc'] = 'Geben Sie die URL zu Ihrer Facebook Seite an, z.B. https://www.facebook.com/mycollege';
$string['few'] = 'Einige';
$string['fitvids'] = 'FitVids benutzen';
$string['fitvidsdesc'] = 'Aktivieren Sie FitVids (fitvidsjs.com), um eingebettete Videos responsive zu machen. Wenn FitVids aktiviert ist und ein Video nicht angepasst werden soll, dann fügen Sie \'class ="fitvidsignore"\' zum <iframe>-Tag im HTML-Modus hinzu, z.B. <iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe>\'.';
$string['fixedwidthnarrow'] = 'Feste Breite - Schmal';
$string['fixedwidthnormal'] = 'Feste Breite - Normal';
$string['fixedwidthwide'] = 'Feste Breite - Breit';
$string['flattr_click'] = 'Spenden über Flattr';
$string['flattr_desc'] = '{$a->url}';
$string['flickr'] = 'Flickr URL';
$string['flickrdesc'] = 'Geben Sie die URL zu Ihrer Flickr Seite an, z.B. http://www.flickr.com/photos/mycollege';
$string['fontcharacterset'] = 'Zusätzliche Google-Zeichensätze';
$string['fontcharactersetcyrillic'] = 'Cyrillic';
$string['fontcharactersetcyrillicext'] = 'Cyrillic Extended';
$string['fontcharactersetdesc'] = 'Wenn ein Google-Zeichensatz gewählt wird, können Sie weitere sprachbezogene Zeichensätze hinzufügen. Um Ihre Webseite nicht zu verlangsamen, sollten Sie nur die Zeichensätze auswählen, die Sie tatsächlich verwenden.';
$string['fontcharactersetgreek'] = 'Greek';
$string['fontcharactersetgreekext'] = 'Greek Extended';
$string['fontcharactersetlatinext'] = 'Latin Extended';
$string['fontcharactersetvietnamese'] = 'Vietnamese';
$string['fontfileeotbody'] = 'Zeichensatz EOT';
$string['fontfileeotheading'] = 'Zeichensatz Überschrift EOT';
$string['fontfileotfbody'] = 'Zeichensatz OTF';
$string['fontfileotfheading'] = 'Zeichensatz Überschrift OTF';
$string['fontfiles'] = 'Zeichensatzdateien';
$string['fontfilesdesc'] = 'Zeichensatzdatei hochladen';
$string['fontfilesvgbody'] = 'Zeichensatz SVG';
$string['fontfilesvgheading'] = 'Zeichensatz Überschrift SVG';
$string['fontfilettfbody'] = 'Zeichensatz TTF';
$string['fontfilettfheading'] = 'Zeichensatz Überschrift TTF';
$string['fontfilewoffbody'] = 'Zeichensatz WOFF';
$string['fontfilewoffheading'] = 'Zeichensatz Überschrift WOFF';
$string['fontfilewofftwobody'] = 'Zeichensatz WOFF2';
$string['fontfilewofftwoheading'] = 'Zeichensatz Überschrift WOFF2';
$string['fontheadingdesc'] = 'Wählen Sie die Zeichensätze, die Sie in Moodle verwenden möchten.';
$string['fontheadingsub'] = 'Zeichensatzeinstellungen';
$string['fontnamebody'] = 'Zeichensatz für Text';
$string['fontnamebodydesc'] = 'Tragen Sie den Namen des Zeichensatzes für die Textabschnitte ein.';
$string['fontnameheading'] = 'Zeichensatz für Überschrift';
$string['fontnameheadingdesc'] = 'Tragen Sie den Namen des Zeichensatzes für die Überschriften ein.';
$string['fontselect'] = 'Zeichensatz';
$string['fontselectdesc'] = 'Wählen Sie einen Zeichensatz aus der Liste aus. Speichern Sie, um weitere Optionen anzuzeigen.';
$string['fontsettings'] = 'Zeichensatz';
$string['fonttypecustom'] = 'Eigener Zeichensatz';
$string['fonttypegoogle'] = 'Google Web Fonts';
$string['fonttypestandard'] = 'Standardzeichensätze';
$string['footercolor'] = 'Hintergrundfarbe im Fußbereich';
$string['footercolordesc'] = 'Mit welcher Farbe soll der Hintergrund im Fußbereich gefüllt werden?';
$string['footercolors'] = 'Farben im Fußbereich';
$string['footercolorsdesc'] = 'Wählen Sie die Farbeinstellungen für den Fußbereich.';
$string['footerheading'] = 'Fußzeile';
$string['footerheadingcolor'] = 'Überschriftfarbe im Fußbereich';
$string['footerheadingcolordesc'] = 'In welcher Farbe sollen Blocküberschriften im Fußbereich angezeigt werden?';
$string['footerhovercolor'] = 'Hoverfarbe im Fußbereich';
$string['footerhovercolordesc'] = 'In welcher Farbe sollen Links im Fußbereich angezeigt werden, wenn sie berührt werden?';
$string['footersepcolor'] = 'Trennlinienfarbe im Fußbereich';
$string['footersepcolordesc'] = 'In welcher Farbe sollen Trennlinien im Fußbereich angezeigt werden?';
$string['footertextcolor'] = 'Textfarbe im Fußbereich';
$string['footertextcolordesc'] = 'In welcher Farbe sollen Texte im Fußbereich angezeigt werden?';
$string['footerurlcolor'] = 'Linkfarbe im Fußbereich';
$string['footerurlcolordesc'] = 'In welcher Farbe sollen Links im Fußbereich angezeigt werden?';
$string['footnote'] = 'Fußnote';
$string['footnotedesc'] = 'Der Text aus diesem Textfeld wird in einer Fußzeile auf jeder Seite angezeigt.';
$string['frontcontent'] = 'Textbereich auf der Startseite aktivieren';
$string['frontcontentarea'] = 'Inhalt des Textbereichs auf der Startseite';
$string['frontcontentareadesc'] = 'Der in diesem Feld eingegebene Inhalt wird über die gesamte Breite der Seite zwischen Diashow und Marketing Spots angezeigt.';
$string['frontcontentdesc'] = 'Diese Option legt fest, ob zwischen Diashow und Marketing Spots ein zusätzlicher Textbereich für weitere Inhalte angezeigt wird.';
$string['frontcontentheading'] = 'Textbereich auf der Startseite';
$string['frontpageblocks'] = 'Blockanordnung auf der Startseite';
$string['frontpageblocksdesc'] = 'Wählen Sie aus, ob die Blöcke auf der Startseite links oder rechts angeordnet sein sollen.';
$string['frontpageblocksheading'] = 'Blöcke auf der Startseite';
$string['frontpageheading'] = 'Startseite';
$string['frontpageheadingdesc'] = 'Konfigurieren Sie die zusätzlichen Elemente, die Sie auf der Startseite angezeigt werden sollen.';
$string['frontpagemiddleblocks'] = 'Zusätzliche Mittelblöcke auf der Startseite';
$string['frontpagemiddleblocksdesc'] = 'Diese Option aktiviert drei zusätzliche Blöcke direkt unter den Marketing Spots.';
$string['fullname'] = 'Vollständiger Name';
$string['fullnamesummary'] = 'Name und Beschreibung';
$string['generalheadingdesc'] = 'Konfigurieren Sie hier die globalen Einstellungen für das Design.';
$string['generalheadingsub'] = 'Allgemeine Einstellungen';
$string['genericsettings'] = 'Allgemein';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Geben Sie die URL für Ihr Google+ Profil an, z.B. https://plus.google.com/+mycollege';
$string['headerheading'] = 'Kopfbereich';
$string['headertitle'] = 'Kopfbereich Überschrift';
$string['headertitledesc'] = 'Konfigurieren Sie hier die Überschrift für den Kopfbereich. Beachten Sie, dass die Überschrift im Kopfbereich nur angezeigt wird, wenn kein Logo vorhanden ist.';
$string['helplink'] = 'Hilfe-Link';
$string['helplinkdesc'] = 'Wenn Sie die Option URL gewählt haben, tragen Sie eine vollständige URL zur Hilfeseite ein, u.z. mit http(s)://. Wenn Sie die Option E-Mail gewählt haben, tragen Sie die E-Mail-Adresse für Ihren Support ein.';
$string['helplinktype'] = 'Hilfe-Link im Menü aktivieren';
$string['helplinktypedesc'] = 'Wählen Sie, ob Sie eine Hilfe-Option im Benutzermenü aktivieren möchten. Sie können eine URL zu einer Hilfeseite oder eine E-Mail-Adresse für Ihren Support angeben.';
$string['hideonphone'] = 'Keine Folienshow auf Smartphones';
$string['hideonphonedesc'] = 'Wenn diese Option aktiviert ist, wird die Folienshow auf Smartphones nicht angezeigt.';
$string['hideontablet'] = 'Keine Folienshow auf Tablets';
$string['hideontabletdesc'] = 'Wenn diese Option aktiviert ist, wird die Folienshow auf Tablets nicht angezeigt.';
$string['included'] = 'Dateien eingeschlossen';
$string['instagram'] = 'Instagram-URL';
$string['instagramdesc'] = 'Geben Sie die URL für Ihre Instagram-Seite an, z.B. http://instagram.com/mycollege';
$string['ios'] = 'iOS (AppStore)';
$string['iosdesc'] = 'Geben Sie die URL zu Ihrer Mobile App im AppStore an. Wenn Sie keine eigene App haben, können Sie stattdessen die offizielle Moodle Mobile App verlinken. <br />https://itunes.apple.com/en/app/moodle-mobile/id633359593';
$string['iosicon'] = 'Homescreen Icons';
$string['iosicondesc'] = 'Das Design zeigt ein standardmäßiges Icon für iOS und Android Homescreens an. Wenn Sie möchten, können Sie auch eigene Icons verwenden.';
$string['ipadicon'] = 'iPad Icon (Nicht Retina)';
$string['ipadicondesc'] = 'Das Bild sollte das Format png haben. (72 x 72 Pixel)';
$string['ipadretinaicon'] = 'iPad Icon (Retina)';
$string['ipadretinaicondesc'] = 'Das Bild sollte das Format png haben. (144 x 144 Pixel)';
$string['iphoneicon'] = 'iPhone Icon (Nicht Retina)';
$string['iphoneicondesc'] = 'Das Bild sollte das Format png haben. (57 x 57 Pixel)';
$string['iphoneretinaicon'] = 'iPhone Icon (Retina)';
$string['iphoneretinaicondesc'] = 'Das Bild sollte das Format png haben. (114 x 114 Pixel)';
$string['layout'] = 'Standardmäßiges Kurslayout benutzen';
$string['layoutdesc'] = 'Bei diesem Design werden beide Blockspalten auf einer Seite zusammengefasst. Wenn Sie das standardmäßige dreispaltige Kurslayout von Moodle bevorzugen, aktivieren Sie diese Option.';
$string['left'] = 'Links';
$string['linkedin'] = 'LinkedIn-URL';
$string['linkedindesc'] = 'Geben Sie die URL für Ihr LinkedIn-Profil an, z. B. https://www.linkedin.com/company/mycollege';
$string['loadtime'] = 'Ladezeit';
$string['loggedinas'] = 'Eingeloggt als';
$string['loggedinfrom'] = 'Eingeloggt von';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Laden Sie ein eigenes Logo hoch, um es in der Kopfleiste anzuzeigen. Das Logo sollte 65 Pixel hoch sein und darf eine beliebige passende Breite haben. Wenn Sie ein Logo verwenden, ersetzt es das standardmäßige Icon und die angezeigte Überschrift..';
$string['marketing1'] = 'Marketing Spot 1';
$string['marketing2'] = 'Marketing Spot 2';
$string['marketing3'] = 'Marketing Spot 3';
$string['marketingbuttontext'] = 'Linktext';
$string['marketingbuttontextdesc'] = 'Dieser Text wird auf der Schaltfläche angezeigt.';
$string['marketingbuttonurl'] = 'Link URL';
$string['marketingbuttonurldesc'] = 'URL, auf welche die Taste verweist.';
$string['marketingcontent'] = 'Text';
$string['marketingcontentdesc'] = 'Geben Sie einen kurzen Text für den Marketing Spot ein.';
$string['marketingdesc'] = 'Dieses Design erlaubt drei \'Marketing Spots\' bzw. Werbeblöcke direkt unterhalb der Folienshow an. Hier können Sie wichtige Kernaussagen und direkte Verlinkungen einfügen.';
$string['marketingheading'] = 'Marketing Spots';
$string['marketingheadingsub'] = 'Bereiche für Informationen und Links auf der Startseite';
$string['marketingheight'] = 'Höhe der Bilder';
$string['marketingheightdesc'] = 'Falls Sie Bilder in die Marketing Spots einfügen möchten, geben Sie hier deren Höhe an.';
$string['marketingicon'] = 'Icon';
$string['marketingicondesc'] = 'Geben Sie den Namen des Symbols an, das Sie verwenden möchten. Die verfügbaren Symbole finden Sie in dieser <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">Liste</a>. Tragen Sie hier den Namen ohne \'fa-\' ein.';
$string['marketingimage'] = 'Bild';
$string['marketingimagedesc'] = 'Wenn Sie hier ein Bild hochladen, wird es oberhalb des Textes im Marketing Spot angezeigt.';
$string['marketinginfodesc'] = 'Legen Sie die Einstellungen für diesen Marketing Spot fest.';
$string['marketingtitle'] = 'Überschrift';
$string['marketingtitledesc'] = 'Überschrift für den Marketing Spot';
$string['marketingurltarget'] = 'Linkziel';
$string['marketingurltargetdesc'] = 'Wählen Sie, wie der Link geöffnet werden soll.';
$string['marketingurltargetnew'] = 'Neue Seite';
$string['marketingurltargetparent'] = 'Übergeordneter Frame';
$string['marketingurltargetself'] = 'Aktuelle Seite';
$string['memused'] = 'Speicher benutzt';
$string['messagepreferences'] = 'Mitteilungseinstellungen';
$string['mobileappsdesc'] = 'Haben Sie eine App im AppStore oder bei Google Play? Geben Sie die Links an, um diese Apps verfügbar zu machen.';
$string['mobileappsheading'] = 'Mobile Apps';
$string['mobileappsheadingsub'] = 'Apps für mobile Endgeräte';
$string['myclasses'] = 'Meine Klassen';
$string['mycourses'] = 'Meine Kurse';
$string['mycoursesinfo'] = 'Eingeschriebene Kurse';
$string['mycoursesinfodesc'] = 'Dynamische Liste von Kursen anzeigen, in die eine Person eingeschrieben ist.';
$string['mycoursetitle'] = 'Bezeichnung';
$string['mycoursetitledesc'] = 'Ändern Sie die Bezeichnung für den Link \'Meine Kurse\' mit dem Dropdown-Menü.';
$string['mygrades'] = 'Meine Bewertungen';
$string['mymodules'] = 'Meine Lernmodule';
$string['myunits'] = 'Meine Lerneinheiten';
$string['navbartitle'] = 'Titel für Navigation';
$string['navbartitledesc'] = 'Geben Sie an, welcher Titel in der Navigation angezeigt werden soll.';
$string['nextsection'] = 'Nächster Abschnitt';
$string['nobreadcrumb'] = 'Verbergen';
$string['noenrolments'] = 'Keine Einschreibungen';
$string['nomessagesfound'] = 'Keine Nachrichten gefunden';
$string['noslidetitle'] = 'Keine Überschrift für Folie {$a->slide}';
$string['notitle'] = 'Ohne Titel';
$string['numberofslides'] = 'Anzahl der Folien';
$string['numberofslides_desc'] = 'Diese Option legt die Anzahl der Folien in der Folienshow fest.';
$string['oldnavbar'] = 'Alte Position für Navigation';
$string['oldnavbardesc'] = 'Diese Option legt fest, dass die alte Position für die Navigation verwendet wird';
$string['pagebackground'] = 'Hintergrundbild der Seite';
$string['pagebackgrounddesc'] = 'Laden Sie ein eigenes Hintergrundbild hoch. Wählen Sie anschließend den Bildmodus.';
$string['pagebackgroundstyle'] = 'Hintergrund der Seite';
$string['pagebackgroundstyledesc'] = 'Geben Sie den Modus für das Bild an.';
$string['pagewidth'] = 'Seitenbreite';
$string['pagewidthdesc'] = 'Wählen Sie eine vorgegebene Seitenbreite.';
$string['paypal_click'] = 'Moodle-Profil';
$string['paypal_desc'] = '.';
$string['peakmem'] = 'Speicher (Peak)';
$string['perfinfo'] = 'Performance-Info';
$string['perfinfodesc'] = 'Nur wenige Seiten brauchen eine vollständige detaillierte Performance-Info, vorallem nicht für alle Nutzer/innen. Wenn diese Option aktiviert ist, wird nur eine minimale Form angezeigt.';
$string['perfinfoheading'] = 'Performance-Informationen';
$string['perf_max'] = 'Ausführlich';
$string['perf_min'] = 'Kurz';
$string['pinterest'] = 'Pinterest URL';
$string['pinterestdesc'] = 'Geben Sie die URL zu Ihrer Pinterest Seite an, z.B. http://www.pinterest.com/mycollege/mypinboard';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Vorheriger Abschnitt';
$string['profilebarcustomtitle'] = 'Titel des eigenen Profilblocks';
$string['profilebarcustomtitledesc'] = 'Titel des eigenen Profilblocks';
$string['readme_click'] = 'README.txt lesen';
$string['readme_desc'] = 'Bitte {$a->url}, um weitere Infos zu Essential zu erhalten.';
$string['readme_title'] = 'Anleitung für das Design Essential';
$string['readmore'] = 'weiter lesen';
$string['region-footer-left'] = 'Fußbereich (links)';
$string['region-footer-middle'] = 'Fußbereich (Mitte)';
$string['region-footer-right'] = 'Fußbereich (rechts)';
$string['region-hidden-dock'] = 'Für Nutzer/innen verborgen';
$string['region-home-left'] = 'Startseite (links)';
$string['region-home-middle'] = 'Startseite (mittig)';
$string['region-home-right'] = 'Startseite (rechts)';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['right'] = 'Rechts';
$string['serverload'] = 'Server Load';
$string['sessionsize'] = 'Session Größe';
$string['shortname'] = 'Kurzname der Website';
$string['shortnamesummary'] = 'Kurzname und Beschreibung';
$string['siteicon'] = 'Website Icon';
$string['siteicondesc'] = 'Haben Sie kein eigenes Logo? Wählen Sie ein Logo aus der <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">Liste</a> und tragen Sie hier den Namen ohne \'fa-\' ein.';
$string['skype'] = 'Skype Konto';
$string['skypedesc'] = 'Geben Sie das Skype-Konto für Ihre Organisation an, z.B. my.college';
$string['slidebuttoncolor'] = 'Tastenfarbe auf den Folien';
$string['slidebuttoncolordesc'] = 'Diese Option legt die Farbe der Navigationstaste auf den Folien fest.';
$string['slidebuttonhovercolor'] = 'Hoverfarbe auf den Folien';
$string['slidebuttonhovercolordesc'] = 'Diese Option legt die Berührungsfarbe der Navigationstaste auf den Folien fest.';
$string['slidecaption'] = 'Folienbeschriftung';
$string['slidecaptionbelow'] = 'Folienbeschriftung unter dem Bild';
$string['slidecaptionbelowdesc'] = 'Diese Option legt fest, ob die Folienbeschriftung unter dem Bild gezeigt werden soll.';
$string['slidecaptioncentred'] = 'Zentrierte Folienbeschriftung';
$string['slidecaptioncentreddesc'] = 'Diese Option legt fest, dass die Folienbeschriftung zentriert sein soll.';
$string['slidecaptiondesc'] = 'Geben Sie eine Folienbeschriftung ein, die für diese Folie benutzt wird.';
$string['slidecolor'] = 'Textfarbe der Folien';
$string['slidecolordesc'] = 'Diese Option legt die Farbe für die Folienbeschriftung fest.';
$string['slideimage'] = 'Folienbild';
$string['slideimagedesc'] = 'Als Folienbild verwenden Sie am besten ein transparentes Bild im Format png.';
$string['slideinterval'] = 'Foliendauer';
$string['slideintervaldesc'] = 'Die Anzeigedauer jeder Folie wird in Millisekunden angegeben.';
$string['slideno'] = 'Folie {$a->slide}';
$string['slidenodesc'] = 'Tragen Sie die Einstellungen für Folie {$a->slide} ein.';
$string['slideshowdesc'] = 'Diese Option erzeugt eine dynamische Folienshow mit bis zu 16 Folien, mit denen Sie wichtige Elemente Ihrer Website hervorheben können.
Die Bildgröße ist abhängig von der jeweiligen Bildschirmgröße. Die empfohlene Bildhöhe ist 300px. Die Bildbreite wird immer auf 100% skaliert, und die tatsächliche Bildhöhe wird entsprechend angepasst. Bei kleineren Bildschirmgrößen wird die Höhe dynamisch reduziert, ohne separate Bilder bereitstellen zu müssen. Die folgenden Angaben dienen als Referenz:
 - Bildschirmbreite kleiner als 767px > Bildhöhe 165px
 - Bildschirmbreite von 768px bis 979px > Bildhöhe 225px
 - Bildschirmbreite größer als 980px > Bildhöhe 300px.
Wenn kein Bild für eine Folie hochgeladen wurde, wird das  Bild default_slide verwendet.';
$string['slideshowheading'] = 'Folienshow';
$string['slideshowheadingsub'] = 'Dynamische Folienshow auf der Startseite';
$string['slidetitle'] = 'Folienüberschrift';
$string['slidetitledesc'] = 'Geben Sie eine beschreibende Überschrift für die Folie an.';
$string['slideurl'] = 'Folienlink';
$string['slideurldesc'] = 'Geben Sie das Ziel an, auf das die Folie verlinkt werden soll.';
$string['slideurltarget'] = 'Linkziel';
$string['slideurltargetdesc'] = 'Wählen Sie, wie der Link geöffnet werden soll.';
$string['slideurltargetnew'] = 'Neue Seite';
$string['slideurltargetparent'] = 'Übergeordneter Frame';
$string['slideurltargetself'] = 'Aktuelle Seite';
$string['socialdesc'] = 'Geben Sie die direkten Links zu den sozialen Netzwerken an, in denen Ihre Organisation vertreten ist. Die sozialen Netzwerke werden im Kopfbereich auf jeder Seite angezeigt.';
$string['socialheading'] = 'Soziale Netzwerke';
$string['socialheadingsub'] = 'Soziale Netzwerke';
$string['socialnetworks'] = 'Soziale Netzwerke';
$string['themecolor'] = 'Hauptfarbe';
$string['themecolordesc'] = 'Wählen Sie die Hauptfarbe für das Design. Diese Farbe wird für viel wichtige Elemente auf der gesamten Website benutzt.';
$string['themecolors'] = 'Farben';
$string['themehovercolor'] = 'Hoverfarbe für Links';
$string['themehovercolordesc'] = 'Wählen Sie eine Hoverfarbe. Diese Farbe wird beim Berühren von Links und Menüs benutzt.';
$string['themeiconcolor'] = 'Icon Farbe';
$string['themeiconcolordesc'] = 'Wählen Sie die Farbe für alle Icons.';
$string['themenavcolor'] = 'Navigationsfarbe';
$string['themenavcolordesc'] = 'Wählen Sie die Farbe für die Navigation. Diese Farbe legt die Navigationsleiste und den Breadcrumb-Stil fest.';
$string['themetextcolor'] = 'Textfarbe';
$string['themetextcolordesc'] = 'Wählen Sie die Farbe für Texte auf der Website.';
$string['themeurlcolor'] = 'Linkfarbe';
$string['themeurlcolordesc'] = 'Wählen Sie die Farbe für verlinkte Textstellen.';
$string['togglemarketing'] = 'Marketing Spots anzeigen';
$string['togglemarketingdesc'] = 'Wählen Sie aus, wie die Marketing Spots auf der Startseite gezeigt werden sollen.';
$string['toggleslideshow'] = 'Folienshow anzeigen';
$string['toggleslideshowdesc'] = 'Wählen Sie aus, wie die Folienshow auf der Startseite gezeigt werden soll.';
$string['twitter'] = 'Twitter URL';
$string['twitterdesc'] = 'Geben Sie die URL für Ihr Twitter Feed an, z.B. https://www.twitter.com/mycollege';
$string['unreadnewnotification'] = 'Neue Meldung';
$string['usecategoryicon'] = 'Icons für Kursbereiche';
$string['usecategoryicondesc'] = 'Icons für die Kursbereiche verwenden';
$string['variablewidth'] = 'Variable Breite';
$string['visibleadminonly'] = 'Die Blöcke in diesem Bereich sind ausschließlich für Administratoren sichtbar.';
$string['vk'] = 'VKontakte URL';
$string['vkdesc'] = 'Geben Sie die URL für Ihre VKontakte an, z.B. http://www.vk.com/mycollege';
$string['website'] = 'Website URL';
$string['websitedesc'] = 'Geben Sie die URL zu Ihrer Website an, z.B. http://www.mycollege.com';
$string['windows'] = 'Windows Desktop';
$string['windowsdesc'] = 'Geben Sie die URL zu Ihrer Mobile App im Windows Store an. Wenn Sie keine eigene App haben, können Sie stattdessen die offizielle Moodle Mobile App verlinken. <br />http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Geben Sie die URL zu Ihrer Mobile App im Windows Store an. Wenn Sie keine eigene App haben, können Sie stattdessen die offizielle Moodle Mobile App verlinken. <br />http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc';
$string['youtube'] = 'YouTube URL';
$string['youtubedesc'] = 'Geben Sie die URL für Ihren YouTube Kanal an, z.B. https://www.youtube.com/mycollege';
