<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'de', branch 'MOODLE_26_STABLE'
 *
 * @package   scheduler
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['addappointment'] = 'Teilnehmer/in hinzufügen';
$string['addondays'] = 'Termine hinzufügen am';
$string['addscheduled'] = 'Wahrnehmende/n Teilnehmer/in hinzufügen';
$string['addscheduled_help'] = '<h3>Adding an appointment on slot setup</h3>
<p>Using this link, you will add a user to the appointment list defined by this slot information. It may be a simple and fast way to setup a collective appointment. </p>';
$string['addsingleslot'] = 'Einzelnes Zeitfenster hinzufügen';
$string['addslot'] = 'Sie können jederzeit zusätzliche Zeitfenster hinzufügen.';
$string['addstudenttogroup'] = 'Diese/n Teilnehmer/in zur Gruppe hinzufügen';
$string['allowgroup'] = 'Einzel-Zeitfenster (mit Klick änderbar)';
$string['allslotsincloseddays'] = 'Alle Zeitfenster waren in geschlossenen Tagen';
$string['allteachersgrading'] = 'Trainer/innen können alle Termine bewerten';
$string['alreadyappointed'] = 'Konnte den Termin nicht festlegen. Das Terminfenster ist schon voll ausgebucht.';
$string['appointagroup'] = 'Gruppen-Termin';
$string['appointagroup_help'] = 'Wählen Sie, ob Sie den Termin nur für sich selbst, oder für eine ganze Gruppe festlegen.';
$string['appointfor'] = 'Festlegen für';
$string['appointformygroup'] = 'Für meine ganze Gruppe festlegen';
$string['appointingstudent'] = 'Termin für Zeitfenster';
$string['appointingstudentinnew'] = 'Termin für neues Zeitfenster';
$string['appointmentmode'] = 'Modus wählen';
$string['appointmentno'] = 'Termin {$a}';
$string['appointmentnotes'] = 'Notizen für den Termin';
$string['appointments'] = 'Termine';
$string['appointsolo'] = 'nur mich';
$string['appointsomeone'] = 'Neuen Termin hinzufügen';
$string['attendable'] = 'Wahrzunehmen';
$string['attendablelbl'] = 'Anzahl Kandidaten für die Terminplanung';
$string['attended'] = 'Wahrgenommen';
$string['attendedlbl'] = 'Anzahl Teilnehmer/innen, die wahrgenommen haben';
$string['attendedslots'] = 'Wahrgenommene Zeitfenster';
$string['availableslots'] = 'Verfügbare Zeitfenster';
$string['availableslotsall'] = 'Alle Zeitfenster';
$string['availableslotsnotowned'] = 'Ohne Besitzer';
$string['availableslotsowned'] = 'Mit Besitzer';
$string['bookwithteacher'] = 'Trainer/in';
$string['bookwithteacher_help'] = 'Wählen Sie eine/n Trainer/in für den Termin.';
$string['break'] = 'Pause zwischen Zeitfenstern';
$string['breaknotnegative'] = 'Die Dauer der Pause darf nicht negativ sein';
$string['cancelledbystudent'] = '{$a}: Termin von einer/m Teilnehmer/in abgesagt oder verschoben';
$string['cancelledbyteacher'] = '{$a}: Termin von der/vom Trainer/in abgesagt';
$string['choice'] = 'Auswahl';
$string['chooseexisting'] = 'Bestehendes wählen';
$string['choosingslotstart'] = 'Anfangszeit wählen';
$string['comments'] = 'Kommentare';
$string['complete'] = 'Gebucht';
$string['composeemail'] = 'E-Mail zusammenstellen:';
$string['confirmdelete'] = 'Das Löschen ist endgültig. Fortsetzen?';
$string['conflictingslots'] = 'Konflikte';
$string['course'] = 'Kurs';
$string['csvencoding'] = 'Encoding der Textdatei';
$string['csvfieldseparator'] = 'Trennzeichen der Felder der CSV-Datei';
$string['csvparms'] = 'CSV Fformatparameter';
$string['csvrecordseparator'] = 'Trenzeichen für Datensätze der CSV Datei';
$string['date'] = 'Datum';
$string['datelist'] = 'Übersicht';
$string['defaultslotduration'] = 'Standard Dauer Zeitfenster';
$string['defaultslotduration_help'] = 'Die voreingestellte Dauer (in Minuten) der Zeitfenster, die Sie einrichten';
$string['deleteallslots'] = 'Alle Zeitfenster löschen';
$string['deleteallunusedslots'] = 'Unbenutzte Zeitfenster löschen';
$string['deletemyslots'] = 'Alle meine Zeitfenster löschen';
$string['deleteselection'] = 'Ausgewählte Zeitfenster löschen';
$string['deletetheseslots'] = 'Diese Zeitfenster löschen';
$string['deleteunusedslots'] = 'Meine unbenutzten Zeitfenster löschen';
$string['department'] = 'Von wo?';
$string['disengage'] = 'Meine Termine absagen';
$string['displayfrom'] = 'Termin Teilnehmer/innen anzeigen ab';
$string['distributetoslot'] = 'Der ganzen Gruppe verteilen';
$string['divide'] = 'In Zeitfenster aufteilen?';
$string['dontforgetsaveadvice'] = 'Sie haben die Liste der Personen für den Termin geändert. Vergessen Sie nicht, dieses Formular zu abzusenden, um die Änderungen endgültig zu speichern.';
$string['downloadexcel'] = 'Exportieren nach Excel';
$string['downloads'] = 'Exporte';
$string['duration'] = 'Dauer';
$string['durationrange'] = 'Die Dauer der Zeitfensters muss zwischen {$a->min} und {$a->max} Minuten sein.';
$string['email_applied_plain'] = 'Ein Termin wurde beantragt am {$a->date} um {$a->time},<br/> von der/m Teilnehmer/in {$a->attendee_url} für den Kurs:

{$a->course_short}: {$a->course}

über den Scheduler mit dem Titel "{$a->module}" auf der Website: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Neuer Termin';
$string['email_cancelled_plain'] = 'Ihr Termin am {$ a->date} um {$ a->time} mit der/m Teilnehmer/in {$a->attendee} für den Kurs:

{$a->course_short}: {$a->course}

im Scheduler mit dem Titel "{$a->module}" auf der Website: {$a->site}

wurde abgesagt oder verschoben.';
$string['email_cancelled_subject'] = '{$a->course_short}: Termin von der/vom Teilnehmer/in abgesagt oder verschoben';
$string['emailreminder'] = 'Per E-Mail eine Erinnerung schicken';
$string['emailreminderondate'] = 'Per E-Mail eine Erinnerung schicken am';
$string['email_reminder_plain'] = 'Sie haben einen bevorstehenden Termin am {$a->date} von {$a->time} bis {$a->endtime} mit {$a->attendant}.

Ort: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Terminerinnerung';
$string['email_teachercancelled_plain'] = 'Ihr Termin am {$ a->date} um {$ a->time} mit dem {$a->staffrole} {$a->attendant} für den Kurs:

{$a->course_short}: {$a->course}

im Scheduler mit dem Titel "{$a->module}" auf der Website: {$a->site}

wurde abgesagt. Bitte wählen Sie ein neues Zeitfenster.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Termin von der/vom Trainer/in abgesagt';
$string['end'] = 'Ende';
$string['endtime'] = 'Endzeit';
$string['exclusive'] = 'Exklusiv';
$string['exclusivity'] = 'Exklusivität';
$string['exclusivity_help'] = '<p>Sie können eine Höchstanzahl Teilnehmer/innen, die sich für ein bestimmtes Zeitfenster einschreiben können einstellen.</p>
<p>Eine Höchstanzahl von 1 (Standard) wird das Zeitfenster in den exklusiven Modus wechseln.</p>
<p>Wenn für das Zeitfenster eine unbegrenzte Höchstanzahl (0) eingestellt wird, wird dieses Zeitfenster nicht in Einschränkungen berücksichtigt werden, auch wenn andere Zeitfenster in der gleichen Zeitspane exklusiv oder begrenzt eingestellt sind.</p>';
$string['exclusivitylockedto'] = 'You cannot change the slot mode when scheduling. The current limit of the destination slot will apply. If the slot is new, a default limit of 1 will apply.';
$string['exclusivityoverload'] = 'Das Zeitfenster hat {$a} gebuchte Teilnehmer/innen, mals durch diese Einstellung erlaubt.';
$string['explaingeneralconfig'] = 'These options can only be setup at site level and will apply to all schedulers of this Moodle installation.';
$string['exportinstructions'] = 'You should better save the generated export file on your hard drive before using it.';
$string['finalgrade'] = 'Schlussbewertung';
$string['for'] = 'für';
$string['forbidgroup'] = 'Gruppen-Zeitfenster (mit Klick änderbar)';
$string['forcewhenoverlap'] = 'Bei Überlappung erzwingen';
$string['forcewhenoverlap_help'] = '<h3>Erstellung eines Zeitfenster falls Zeitfenster überlappen</h3>
<p>Diese Einstellung legt fest, wie mit neuen Zeitfenstern umgegangen werden soll, falls sie sich mit anderen, bestehenden Zeitfenstern überlappen.</p>
<p>Wenn aktiviert, wird das bestehenden überlappende Zeitfenster gelöscht und ein neues Zeitfenster wird erstellt.</p>
<p>Wenn deaktiviert, wird das bestehende überlappende Zeitfenster beibehalten und ein neues Zeitfenster wird <em>nicht</em> erstellt.</p>';
$string['forcourses'] = 'Teilnehmer/innen in Kursen auswählen';
$string['friday'] = 'Freitag';
$string['generalconfig'] = 'Allgemeine Konfiguration';
$string['grade'] = 'Bewertung';
$string['gradingstrategy'] = 'Bewertungsstrategie';
$string['gradingstrategy_help'] = 'In einem Scheduler, in welchem Teilnehmer/innen mehrere Treffen haben können, wählen Sie, wie die Bewertung aggregiert wird.
    Die Bewertungen können entweder <ul><li>die durchschnittliche Bewertung oder</li><li>die beste Bewertung</li></ul> welche die/der Teilnehmer/in erreicht hat, anzeigen.';
$string['group'] = 'Gruppe';
$string['groupbreakdown'] = 'Nach Gruppengrösse';
$string['groupscheduling'] = 'Gruppeneinschreibung aktivieren';
$string['groupscheduling_desc'] = 'Allow entire groups to be scheduled at once.
(Apart from the global option, the activity group mode must be set to "Visible groups" or "Separate groups" in order to enable this feature.)';
$string['groupsession'] = 'Gruppen-Termin';
$string['groupsize'] = 'Gruppengrösse';
$string['guestscantdoanything'] = 'Gäste können hier nichts tun.';
$string['howtoaddstudents'] = 'For adding students to a global scoped scheduler, use the role setting for the module.<br/>You may also use module role definitions to define the attenders of your students.';
$string['ignoreconflicts'] = 'Terminkollisionen ignorieren';
$string['ignoreconflicts_help'] = 'Wenn dieses Feld angekreuzt ist, wird das Zeifenster zum gewählten Zeitpunkt verschoben, selbst falls andere Zeitfenster zur gleichen Zeit existieren. Dies kann zu überlappenden Terminen für einige Trainer/innen oder Teilnehmer/innen führen und sollte daher mit Vorsicht verwendet werden.';
$string['incourse'] = 'in Kurs';
$string['introduction'] = 'Einführung';
$string['invitation'] = 'Einladung';
$string['invitationtext'] = 'Bitte wählen Sie ein Zeitfenster für einen Termin unter';
$string['isnonexclusive'] = 'Nicht-exklusive';
$string['lengthbreakdown'] = 'Nach Dauer des Zeitfensters';
$string['limited'] = 'Beschränkt (noch {$a})';
$string['location'] = 'Ort';
$string['location_help'] = 'Legen Sie den vorgesehenen Ort des Treffens fest.';
$string['markasseennow'] = 'Mark as seen now';
$string['markseen'] = 'Nachdem Sie einen Termin mit einer/m Teilnehmer/in hatten, markieren Sie sie bitte durch das Anklicken der entsprechenden Checkbox in der obigen Tabelle als "gesehen".';
$string['maxgrade'] = 'Beste Bewertung verwenden';
$string['maxstudentlistsize'] = 'Maximum length of student list';
$string['maxstudentlistsize_desc'] = 'The maximum length of the list of students who need to make an appointment, as shown in the teacher view of the scheduler. If there are more students than this, no list will be displayed.';
$string['maxstudentsperslot'] = 'Maximale Anzahl Teilnehmer/innen pro Zeitfenster';
$string['maxstudentsperslot_desc'] = 'Group slots / non-exclusive slots can have at most this number of students. Note that in addition, the setting "unlimited" can always be chosen for a slot.';
$string['meangrade'] = 'Durchschnittliche Bewertung verwenden';
$string['meetingwith'] = 'Treffen mit ihrer/m';
$string['meetingwithplural'] = 'Treffen mit ihrer/m';
$string['mins'] = 'Minuten';
$string['minutes'] = 'Minuten';
$string['minutesperslot'] = 'Minuten pro Zeitfenster';
$string['missingstudents'] = '{$a} Teilnehmer/innen müssen noch einen Termin festlegen';
$string['missingstudentsmany'] = '{$a} Teilnehmer/innen müssen noch einen Termin festlegen. Aufgrund der Grösse wird keine Liste angezeigt.';
$string['mode'] = 'Modus';
$string['modulename'] = 'Scheduler';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Scheduler';
$string['monday'] = 'Montag';
$string['move'] = 'Verschieben';
$string['moveslot'] = 'Zeitfenster verschieben';
$string['multiplestudents'] = 'Mehrere Teilnehmer/innen pro Zeitfenster zulassen?';
$string['myappointments'] = 'Meine Termine';
$string['name'] = 'Name des Schedulers';
$string['needteachers'] = 'Slots cannot be added as this course has no teachers';
$string['negativerange'] = 'Range is negative. This can\'t be.';
$string['never'] = 'Nie';
$string['newappointment'] = '{$a}: Neuer Termin';
$string['noappointments'] = 'Keine Termine';
$string['noexistingstudents'] = 'Keine Teilnehmer/innen vorhanden';
$string['nogroups'] = 'No group available for scheduling.';
$string['noresults'] = 'Keine Ergebnisse.';
$string['noschedulers'] = 'There are no schedulers';
$string['noslots'] = 'There are no appointment slots available.';
$string['noslotsopennow'] = 'No slots are open right now.';
$string['nostudents'] = 'Keine Teilnehmer/innen mit Terminen';
$string['nostudenttobook'] = 'Kein/e Teilnehmer/in buchbar';
$string['note'] = 'Bewertung';
$string['noteacherforslot'] = 'Kein/e Trainer/in für das Zeitfenster';
$string['noteachershere'] = 'Kein/e Trainer/in verfügbar';
$string['notifications'] = 'Benachrichtigungen';
$string['notifications_help'] = 'Wenn diese Option aktiviert ist, werden Trainer/innen und Teilnehmer/innen Benachrichtigungen erhalten, wenn Termine beantragt oder abgesagt werden.';
$string['notselected'] = 'You have not yet made a choice';
$string['now'] = 'Jetzt';
$string['occurrences'] = 'Fundstellen';
$string['on'] = 'on';
$string['onedaybefore'] = '1 Tag vor Zeitfenster';
$string['oneslotadded'] = '1 Zeitfenster hinzugefügt';
$string['oneweekbefore'] = '1 Woche vor Zeitfenster';
$string['onthemorningofappointment'] = 'Am Morgen des Termins';
$string['overall'] = 'Überall';
$string['overlappings'] = 'Some other slots are overlapping';
$string['pluginadministration'] = 'Scheduler-Administration';
$string['pluginname'] = 'Scheduler';
$string['registeredlbl'] = 'Teilnehmer/innen mit Terminen';
$string['reminder'] = 'Erinnerung';
$string['remindertext'] = 'This is just a reminder that you have not yet set up your appointment. Please choose a time-slot as soon as possible at';
$string['remindtitle'] = '{$a}: Terminerinnerung';
$string['remindwithwhom'] = 'Scheduled appointment with';
$string['resetappointments'] = 'Termine und Bewertungen löschen';
$string['resetslots'] = 'Scheduler-Zeitfenster löschen';
$string['return'] = 'Zurück zum Kurs';
$string['revoke'] = 'Den Termin absagen';
$string['saturday'] = 'Samstag';
$string['save'] = 'Sichern';
$string['savechoice'] = 'Auswahl speichern';
$string['savecomment'] = 'Kommentar speichern';
$string['saveseen'] = 'Als gesehen speichern';
$string['schedule'] = 'Festlegen';
$string['scheduleappointment'] = 'Termin festlegen für {$a}';
$string['schedulecancelled'] = '{$a}: Ihr Termin wurde abgesagt oder verschoben';
$string['schedulegroups'] = 'Für Gruppen festlegen';
$string['scheduleinnew'] = 'In neuem Zeitfenster festlegen';
$string['scheduler'] = 'Scheduler';
$string['scheduler:addinstance'] = 'Scheduler hinzufügen';
$string['scheduler:appoint'] = 'Festlegen';
$string['scheduler:attend'] = 'Teilnehmer/innen betreuen';
$string['scheduler:canscheduletootherteachers'] = 'Termine für andere Mitarbeiter festlegen';
$string['scheduler:canseeotherteachersbooking'] = 'Buchungen anderer Trainer/innen sehen und browsen';
$string['scheduler:disengage'] = 'Alle Termine absagen (Teilnehmer/innen)';
$string['scheduler:manage'] = 'Zeitfenster und Termine verwalten';
$string['scheduler:manageallappointments'] = 'Alle Scheduler-Einträge managen';
$string['scheduler:seeotherstudentsbooking'] = 'Die Buchung anderer Teilnehmer/innen im Zeitfenster sehen';
$string['scheduler:seeotherstudentsresults'] = 'Die Bewertung anderer Teilnehmer/innen im Zeitfenster sehen';
$string['schedulestudents'] = 'Schedule nach Teilnehmer/in';
$string['seen'] = 'Gesehen';
$string['showemailplain'] = 'Show e-mail addresses in plain text';
$string['showemailplain_desc'] = 'In the teacher\'s view of the scheduler, show the e-mail addresses of students needing an appointment in plain text, in addition to mailto: links.';
$string['slots'] = 'Zeitfenster';
$string['slotsadded'] = '{$a} Zeitfenster wurden hinzugefügt';
$string['slottype'] = 'Zeitfenstertyp';
$string['slotupdated'] = '1 Zeitfenster aktualisiert';
$string['staffbreakdown'] = 'Nach {$a}';
$string['staffmember'] = 'Member of Staff';
$string['staffrolename'] = 'Rollenname der/s Trainers/in';
$string['staffrolename_help'] = 'Name der Rolle, welche die Teilnehmer/innen betreut. Das ist nicht unbedingt ein/e "Trainer/in".';
$string['start'] = 'Start';
$string['starttime'] = 'Anfangszeit';
$string['statistics'] = 'Statistik';
$string['strdownloadcsvgrades'] = 'CSV-Export der Bewertungen';
$string['strdownloadcsvslots'] = 'CSV-Export der Zeitfenster';
$string['strdownloadexcelsingle'] = 'Excel-Export als ein Blatt';
$string['strdownloadexcelteachers'] = 'Excel-Exporte nach {$a}';
$string['strdownloadodssingle'] = 'OpenDoc-Export als ein Blatt';
$string['strdownloadodsteachers'] = 'OpenDoc-Exporte nach {$a}';
$string['student'] = 'Teilnehmer/in';
$string['studentbreakdown'] = 'Nach Teilnehmer/in';
$string['studentcomments'] = 'Bemerkungen der/s Teilnehmer/in';
$string['studentdetails'] = 'Teilnehmer/in Details';
$string['studentmultiselect'] = 'Jede/r Teilnehmer/in kann nur einmal in diesem Zeitfenster ausgewählt werden.';
$string['studentnotes'] = 'Ihre Kommentare zum Treffen';
$string['students'] = 'Teilnehmer/innen';
$string['sunday'] = 'Sonntag';
$string['teacher'] = 'Trainer/in';
$string['thursday'] = 'Donnerstag';
$string['tuesday'] = 'Dienstag';
$string['unattended'] = 'Nicht wahrgenommen';
$string['unlimited'] = 'Unbegrenzt';
$string['unregisteredlbl'] = 'Teilnehmer/innen ohne Termine';
$string['updategrades'] = 'Bewertungen aktualisieren';
$string['updatesingleslot'] = '';
$string['updatingappointment'] = 'Einen Termin aktualisieren';
$string['wednesday'] = 'Mittwoch';
$string['welcomenewstudent'] = 'Die folgende Tabelle zeigt alle verfügbaren Zeitfenster für einen Termin. Treffen Sie Ihre Wahl indem Sie ein Auswahlfeld wählen und vergessen Sie nicht danach "Auswahl speichern" zu klicken. Wenn Sie später eine Änderung vornehmen müssen, können Sie diese Seite erneut besuchen.';
$string['welcomenewteacher'] = 'Bitte klicken Sie auf den Button unten, um Zeitfenster für Termine hinzuzufügen, um alle Ihre Teilnehmer/innen zu sehen.';
$string['what'] = 'Was?';
$string['whathappened'] = 'Was geschah?';
$string['whatresulted'] = 'Was resultierte?';
$string['when'] = 'Wann?';
$string['where'] = 'Wo?';
$string['who'] = 'Mit wem?';
$string['whosthere'] = 'Wer ist dort?';
$string['xdaysbefore'] = '{$a} Tage vor Zeitfenster';
$string['xweeksbefore'] = '{$a} Wochen vor Zeitfenster';
$string['yourappointmentnote'] = 'Kommentar für Sie persönlich';
$string['yourslotnotes'] = 'Kommentare zum Zeitfenster';
