<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'pripravený k inštalácii';
$string['action'] = 'Akcia';
$string['actionchoice'] = 'Co chcete robiť so súborom \'{$a}\'?';
$string['actions'] = 'Akcie';
$string['active'] = 'Aktívny';
$string['activeusers'] = 'Aktívni používatelia';
$string['activities'] = 'Aktivity';
$string['activities_help'] = 'Aktivity ako napríklad diskusné fóra, testy, alebo wiki umožňujú pridať do kurzu interaktívny obsah';
$string['activity'] = 'Aktivita';
$string['activityclipboard'] = 'Presúvanie tejto aktivity: {$a}';
$string['activityiscurrentlyhidden'] = 'Ľutujem, táto aktivita je momentálne skrytá';
$string['activitymodule'] = 'Modul aktivít';
$string['activitymodules'] = 'Moduly aktivít';
$string['activityreport'] = 'Správa o aktivitách';
$string['activityreports'] = 'Správy o aktivitách';
$string['activityselect'] = 'Vybrať túto aktivitu na presunutie';
$string['activitysince'] = 'Aktivita od {$a}';
$string['activityweighted'] = 'Aktivita vzhľadom na používateľa';
$string['add'] = 'Pridať';
$string['addactivity'] = 'Pridať aktivitu';
$string['addactivitytosection'] = 'Pridať aktivitu do sekcie \'{$a}\'';
$string['addadmin'] = 'Pridať administrátora';
$string['addblock'] = 'Pridať blok';
$string['addcomment'] = 'Pridať poznámku';
$string['addcountertousername'] = 'Vytvoriť používateľa vložením čísla k loginu';
$string['addcreator'] = 'Pridať tvorcu kurzov';
$string['adddots'] = 'Pridať...';
$string['added'] = 'Pridané {$a}';
$string['addedrecip'] = 'Pridaný {$a} nový príjemca';
$string['addedrecips'] = 'Pridaní {$a} noví príjemcovia';
$string['addedtogroup'] = 'Pridaný do skupiny {$a}';
$string['addedtogroupnot'] = 'Nepridaný do skupiny {$a}';
$string['addedtogroupnotenrolled'] = 'Nepridaný do skupiny {$a}, pretože nie je zapísaný do kurzu';
$string['addfilehere'] = 'Pridať súbor (súbory) sem';
$string['addinganew'] = 'Pridávanie novej aktivity {$a}';
$string['addinganewto'] = 'Pridávanie novej aktivity {$a->what} do {$a->to}';
$string['addingdatatoexisting'] = 'Pridať údaje do existujúcej';
$string['additionalnames'] = 'Ďalšie mená';
$string['addlinkhere'] = 'Pridať odkaz';
$string['addnewcategory'] = 'Pridať novú kategóriu';
$string['addnewcourse'] = 'Pridať nový kurz';
$string['addnewuser'] = 'Pridať nového používateľa';
$string['addnousersrecip'] = 'Pridať používateľov, ktorí nenavštívili {$a}, do zoznamu príjemcov';
$string['addpagehere'] = 'Pridať stránku';
$string['addresource'] = 'Pridať zdroj...';
$string['addresourceoractivity'] = 'Pridať aktivitu alebo zdroj';
$string['addresourcetosection'] = 'Pridať zdroj do sekcie \'{$a}\'';
$string['address'] = 'Adresa';
$string['addstudent'] = 'Pridať študenta';
$string['addsubcategory'] = 'Pridať podkategóriu';
$string['addteacher'] = 'Pridať učiteľa';
$string['admin'] = 'Administrátor';
$string['adminhelpaddnewuser'] = 'Manuálne vytvoriť nové používateľské konto';
$string['adminhelpassignadmins'] = 'Administrátori môžu robiť všetko a všade v rámci prostredia Moodle';
$string['adminhelpassigncreators'] = 'Tvorcovia kurzov môžu vytvárať nové kurzy';
$string['adminhelpassignsiteroles'] = 'Aplikovať roly v rámci celého portálu vybraným používateľom';
$string['adminhelpassignstudents'] = 'Ísť do kurzu a pridať študentov cez administrátorské menu';
$string['adminhelpauthentication'] = 'Môžete použiť interné používateľské kontá alebo externé databázy';
$string['adminhelpbackup'] = 'Konfigurovať automatické zálohy a ich zoznamy';
$string['adminhelpconfiguration'] = 'Konfigurovať ako bude stránka vyzerať a pracovať';
$string['adminhelpconfigvariables'] = 'Nastaviť premenné, ktoré ovplyvnia základné operácie na stránke';
$string['adminhelpcourses'] = 'Definovať kurzy, kategórie a prideľovanie ľudí do nich';
$string['adminhelpeditorsettings'] = 'Definovať základné nastavenia pre HTML editor';
$string['adminhelpedituser'] = 'Prehľadávať zoznam používateľských kont a ich úpravu';
$string['adminhelpenvironment'] = 'Skontrolovať, či tento server vyhovuje požiadavkám na súčasnú a budúce inštalácie';
$string['adminhelpfailurelogs'] = 'Prehľadávať záznamy neúspešných prihlásení';
$string['adminhelplanguage'] = 'Pre kontrolu a úpravu aktuálnej jazykovej verzie';
$string['adminhelplogs'] = 'Prezrieť záznamy všetkých aktivít na stránkach';
$string['adminhelpmanageblocks'] = 'Spravovať inštalované bloky a ich nastavenia';
$string['adminhelpmanagedatabase'] = 'Priamy prístup do databázy (veľmi opatrne!)';
$string['adminhelpmanagefilters'] = 'Vybrať textové filtre a s nimi súvisiace nastavenia';
$string['adminhelpmanagemodules'] = 'Usporiadať nainštalované moduly a ich nastavenia';
$string['adminhelpmanageroles'] = 'Vytvoriť a definovať roly, ktoré môžu byť aplikované používateľom';
$string['adminhelpmymoodle'] = 'Konfigurovať bloky Môj moodle pre používateľov';
$string['adminhelpreports'] = 'Záznamy o portáli';
$string['adminhelpsitefiles'] = 'Pre publikovanie hlavných súborov a načítanie vytvorených externých záloh';
$string['adminhelpsitesettings'] = 'Definovať ako bude vyzerať úvodná stránka';
$string['adminhelpstickyblocks'] = 'Konfigurovať bloky, ktoré budú na každej stránke';
$string['adminhelpthemes'] = 'Vybrať ako bude stránka vyzerať (farby, písma, atď.)';
$string['adminhelpuploadusers'] = 'Importovať kontá nových používateľov z textového súboru';
$string['adminhelpusers'] = 'Definovať používateľov a nastavenie spôsobu ich overovania';
$string['adminhelpxmldbeditor'] = 'Rozhranie na úpravu XMLDB súborov. Iba pre vývojárov';
$string['administration'] = 'Administratíva';
$string['administrationsite'] = 'Administratíva portálu';
$string['administrator'] = 'Administrátor';
$string['administratordescription'] = 'Administrátori obvykle môžu robiť všetko na portáli a v kurzoch.';
$string['administrators'] = 'Administrátori';
$string['administratorsall'] = 'Všetci administrátori';
$string['administratorsandteachers'] = 'Administrátori a učitelia';
$string['advanced'] = 'Rozšírené';
$string['advancedfilter'] = 'Rozšírené vyhľadávanie';
$string['advancedsettings'] = 'Rozšírené nastavenia';
$string['afterresource'] = 'Za zdrojom "{$a}"';
$string['aftersection'] = 'Po sekcii "{$a}"';
$string['again'] = 'opäť';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX a Javascript';
$string['all'] = 'Všetko';
$string['allactions'] = 'Všetko';
$string['allactivities'] = 'Všetky aktivity';
$string['allcategories'] = 'Všetky kategórie';
$string['allchanges'] = 'Všetky zmeny';
$string['alldays'] = 'Všetky dni';
$string['allfieldsrequired'] = 'Všetky políčka musíte vyplniť';
$string['allfiles'] = 'Všetky súbory';
$string['allgroups'] = 'Všetky skupiny';
$string['alllogs'] = 'Všetky prihlásenia';
$string['allmods'] = 'Všetky {$a}';
$string['allow'] = 'Povoliť';
$string['allowinternal'] = 'Povoliť taktiež interné metódy';
$string['allownone'] = 'Nepovoliť nikoho';
$string['allownot'] = 'Nepovoliť';
$string['allparticipants'] = 'Všetci účastníci';
$string['allteachers'] = 'Všetci učitelia';
$string['alphanumerical'] = 'Môže obsahovať iba písmená abecedy, čísla, pomlčku (-) alebo bodku (.)';
$string['alreadyconfirmed'] = 'Registrácia už bola potvrdená';
$string['alternatename'] = 'Alternatívne meno';
$string['always'] = 'Vždy';
$string['and'] = '{$a->one} a {$a->two}';
$string['answer'] = 'Odpoveď';
$string['any'] = 'Ľubovoľný';
$string['appearance'] = 'Vzhľad';
$string['approve'] = 'Schváliť';
$string['areyousure'] = 'Ste si istý?';
$string['areyousuretorestorethis'] = 'Chcete pokračovať ďalej?';
$string['areyousuretorestorethisinfo'] = 'Neskôr v tomto procese bude možnosť pridávať zálohy do existujúceho kurzu alebo vytvoriť si kompletne nový kurz.';
$string['asc'] = 'Vzostupne';
$string['assessment'] = 'Ohodnotenie';
$string['assignadmins'] = 'Prideliť administrátorov';
$string['assigncreators'] = 'Prideliť tvorcov kurzov';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Prideliť role v rámci celého portálu';
$string['authenticateduser'] = 'Overený používateľ';
$string['authenticateduserdescription'] = 'Všetci prihlásení používatelia';
$string['authentication'] = 'Overovanie';
$string['authenticationplugins'] = 'Overovacie zásuvné moduly';
$string['autosubscribe'] = 'Auto-prihlasovanie do fóra';
$string['autosubscribeno'] = 'Nie: Neprihlasovať ma automaticky do fór';
$string['autosubscribeyes'] = 'Áno: Prihlásiť ma do fóra, keď pošlem prvý príspevok';
$string['availability'] = 'Dostupnosť';
$string['availablecourses'] = 'Dostupné kurzy';
$string['back'] = 'Späť';
$string['backto'] = 'Späť na {$a}';
$string['backtocourselisting'] = 'Naspäť do zoznamu kurzov';
$string['backtopageyouwereon'] = 'Naspäť na stránku, kde ste boli';
$string['backtoparticipants'] = 'Naspäť do zoznamu účastníkov';
$string['backup'] = 'Zálohovanie';
$string['backupactivehelp'] = 'Vyberte si, či chcete robiť automatizované zálohy';
$string['backupcancelled'] = 'Zálohovanie zrušené';
$string['backupcoursefileshelp'] = 'Ak povolené, tak potom súbory kurzov budú zahrnuté do automatických záloh.';
$string['backupdate'] = 'Dátum zálohovania';
$string['backupdatenew'] = '&nbsp; {$a->TAG} je teraz {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} bol {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detaily zálohovania';
$string['backupexecuteathelp'] = 'Zvoľte si čas spustenia automatizovaných zálohovaní';
$string['backupfailed'] = 'Niektoré z Vašich kurzov neboli uložené!';
$string['backupfilename'] = 'záloha';
$string['backupfinished'] = 'Záloha prebehla úspešne';
$string['backupfromthissite'] = 'Bola záloha vytvorená v tomto portáli?';
$string['backupgradebookhistoryhelp'] = 'Ak je povolené, bude zaznamenávaná história úprav výkazu známok v automatizovaných zálohách. Poznámka: pre správnu funkcionalitu nesmie byť na serveri zakázaná história známok (disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Vyberte, či chcete zahrnúť moduly kurzov, s alebo bez údajov používateľa, v automatických zálohách';
$string['backupincludemoduleuserdatahelp'] = 'Vyberte si, či chcete zahrnúť údaje používateľov v automatizovaných zálohovaniach';
$string['backupkeephelp'] = 'Koľko posledných záloh z každého kurzu si chcete ponechať? (staršie budú automaticky vymazané)';
$string['backuplogdetailed'] = 'Detailný záznam o vykonávaní';
$string['backuploglaststatus'] = 'Posledný záznam o vykonávaní';
$string['backupmissinguserinfoperms'] = 'Poznámka: táto záloha neobsahuje údaje používateľov. Aktivity cvičenie a tvorivá dielňa nebudú v tejto zálohe zahrnuté, pretože nie sú kompatibilné s týmto typom zálohy.';
$string['backupnext'] = 'Ďalšia záloha';
$string['backupnonisowarning'] = 'Pozor: táto záloha nie je v Unicode z verzie Moodle nižšej ako 1.6. Ak táto záloha obsahuje ľubovoľné texty v inom kódovaní ako iso-8859-1, je možné že jej obnova bude POŠKODENÁ. Viď <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> ohľadom informácií o správnom obnovení takejto zálohy.';
$string['backupnotyetrun'] = 'Čakanie na automatické zálohovanie';
$string['backuporiginalname'] = 'Názov zálohy';
$string['backuproleassignments'] = 'Priradenia rol pre tieto roly pri zálohovaní';
$string['backupsavetohelp'] = 'Celá cesta k adresáru, kde si chcete uložiť zálohované súbory<br />
(nechajte voľné, aby ste doňho mohli uložiť štandardný adresár kurzov)';
$string['backupsitefileshelp'] = 'Súbory portálu využívané v kurzoch budú zahrnuté v automatických zálohách.';
$string['backuptakealook'] = 'Prosím prezrite si Vaše záznamy o zálohovaniach: {$a}';
$string['backupuserfileshelp'] = 'Vyberte, či súbory používateľov (napr: obrázok v profile), majú byť zahrnuté do automatických záloh';
$string['backupversion'] = 'Verzia zálohy';
$string['badges'] = 'Odznaky';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurácia bloku: {$a}';
$string['blockconfigbad'] = 'Tento blok nebol správne vložený a tak nemôže poskytnúť konfiguračné rozhranie';
$string['blocks'] = 'Bloky';
$string['blocksaddedit'] = 'Pridať/Upraviť bloky';
$string['blockseditoff'] = 'Vypnúť úpravu blokov';
$string['blocksediton'] = 'Zapnúť úpravu blokov';
$string['blocksetup'] = 'Navrhnúť tabuľky blokov';
$string['blocksuccess'] = '{$a} tabuľky boli navrhnuté správne';
$string['brief'] = 'Stručný';
$string['bulkactions'] = 'Hromadné operácie';
$string['bulkactionselect'] = '{$a} výber hromadnej operácie';
$string['bulkmovecoursessuccess'] = 'Do kategórie {$a->category} bolo úspešne presunutých {$a->courses}  kurzov';
$string['bycourseorder'] = 'Podľa poradia kurzov';
$string['byname'] = 'podľa {$a}';
$string['bypassed'] = 'Obídené';
$string['cachecontrols'] = 'Ovládanie cache';
$string['cancel'] = 'Zrušiť';
$string['cancelled'] = 'Zrušené';
$string['categories'] = 'Kategórie kurzov';
$string['categoriesandcoures'] = 'Kategórie kurzov a kurzy';
$string['category'] = 'Kategória';
$string['categoryadded'] = 'Kategória \'{$a}\' bola pridaná';
$string['categorybulkaction'] = 'Hromadné operácie pre vybrané kategórie';
$string['categorycontents'] = 'Podkategórie a kurzy';
$string['categorycurrentcontents'] = 'Obsah {$a}';
$string['categorydeleted'] = 'Kategória \'{$a}\' bola odstránená';
$string['categoryduplicate'] = 'Kategória nazvaná \'{$a}\' už existuje!';
$string['categorymodifiedcancel'] = 'Kategória bola zmenená! Zrušte operáciu a opakujte.';
$string['categoryname'] = 'Názov kategórie';
$string['categorysubcategoryof'] = '{$a->category} - podkategórie v {$a->parentcategory}';
$string['categoryupdated'] = 'Kategória \'{$a}\' bola aktualizovaná';
$string['changedpassword'] = 'Zmenené heslo';
$string['changepassword'] = 'Zmeniť heslo';
$string['changesmadereallygoaway'] = 'Urobili ste zmeny. Naozaj chcete odísť preč a stratiť všetky zmeny?';
$string['changessaved'] = 'Zmeny uložené';
$string['check'] = 'Kontrolovať';
$string['checkall'] = 'Kontrolovať všetko';
$string['checkingbackup'] = 'Kontrola zálohy';
$string['checkingcourse'] = 'Kontrola kurzu';
$string['checkingforbbexport'] = 'Kontrola BlackBoard exportu';
$string['checkinginstances'] = 'Kontrola častí';
$string['checkingsections'] = 'Kontrola sekcií';
$string['checklanguage'] = 'Skontrolovať jazyk';
$string['checknone'] = 'Nekontrolovať nič';
$string['childcoursenotfound'] = 'Nebol nájdený odvodený kurz!';
$string['childcourses'] = 'Odvodené kurzy';
$string['choose'] = 'Vybrať si';
$string['choosecourse'] = 'Vybrať kurz';
$string['choosedots'] = 'Vybrať ...';
$string['chooselivelogs'] = 'Alebo sledovať súčasnú činnosť';
$string['chooselogs'] = 'Vyberte si, ktoré pripojenia chcete vidieť';
$string['choosereportfilter'] = 'Vybrať si filter na správu';
$string['choosetheme'] = 'Vybrať tému';
$string['chooseuser'] = 'Vybrať používateľa';
$string['city'] = 'Mesto';
$string['clambroken'] = 'Váš administrátor povolil kontrolovanie vírusov načítavaných súborov, ale niečo zle nastavil v konfigurácii.<br />
Z tohto dôvodu nebolo načítanie Vášho súboru úspešné. Váš administrátor už bol na túto skutočnosť emailom upozornený, takže by chyba mala byť v dohľadnej dobe odstránená.<br />
Skúste načítať súbor neskôr.';
$string['clamdeletedfile'] = 'Súbor bol vymazaný';
$string['clamdeletedfilefailed'] = 'Súbor nemohol byť vymazaný';
$string['clamemailsubject'] = '{$a} :: oznámenie o Clam AV';
$string['clamfailed'] = 'Spustenie Clam AV bolo neúspešné. Správa o hlásení chyby bola {$a}. Tu je výstup z Clam-u:';
$string['clamlost'] = 'Moodle je nastavený tak, aby spustil clam pri načítavaní súboru, ale cesta, ktorá bola vložená do Clam AV,{$a}, je neplatná.';
$string['clamlostandactinglikevirus'] = 'Naviac, Moodle je nastavený tak, že ak je spustenie clam neúspešné, so súbormi sa nakladá podobne ako s vírusmi. Toto znamená, že žiaden študent nemôže úspešne načítať súbor, pokým toto neopravíte.';
$string['clammovedfile'] = 'Súbor bol presunutý do Vášho karanténneho adresára, jeho nové umiestnenie je: {$a}';
$string['clammovedfilebasic'] = 'Súbor bol presunutý do Vášho osobného adresára';
$string['clamquarantinedirfailed'] = 'Nie je možné presunúť súbor do Vášho karanténneho adresára, {$a}. Túto chybu by ste mali čo najskôr odstrániť, pretože súbory, ktoré považuje systém za napadnuté vírusom, sa automaticky vymazávajú.';
$string['clamunknownerror'] = 'Pri spracovaní súboru antivírom clam sa objavila neznáma chyba.';
$string['cleaningtempdata'] = 'Vyčistiť dočasné údaje';
$string['clear'] = 'Vyčistiť';
$string['clickhelpiconformoreinfo'] = '... pokračovanie ... Kliknite na ikonu nápovedy pre prečítanie celého článku';
$string['clickhere'] = 'Kliknite sem ...';
$string['clicktochangeinbrackets'] = '{$a} (Kliknite pre zmenu)';
$string['clicktohideshow'] = 'Kliknite na rozbalenie alebo zbalenie';
$string['closebuttontitle'] = 'Zavrieť';
$string['closewindow'] = 'Zavrieť toto okno';
$string['collapse'] = 'Zbaliť';
$string['collapseall'] = 'Zbaliť všetko';
$string['collapsecategory'] = 'Zbaliť {$a}';
$string['commentincontext'] = 'Zobraziť túto poznámku v kontexte';
$string['comments'] = 'Poznámky';
$string['commentsnotenabled'] = 'Komentáre nie sú povolené';
$string['commentsrequirelogin'] = 'Pre prehliadanie komentárov sa potrebujete prihlásiť';
$string['comparelanguage'] = 'Porovnať a upraviť súčasný jazyk';
$string['complete'] = 'Podrobný';
$string['completereport'] = 'Podrobná správa';
$string['configuration'] = 'Konfigurácia';
$string['confirm'] = 'Potvrdiť';
$string['confirmcheckfull'] = 'Naozaj chcete potvrdiť {$a}?';
$string['confirmcoursemove'] = 'Naozaj chcete presunúť kurz ({$a->course}) do kategórie ({$a->category})?';
$string['confirmed'] = 'Vaša registrácia bola potvrdená';
$string['confirmednot'] = 'Vaša registrácia ešte nebola potvrdená!';
$string['content'] = 'Obsah';
$string['continue'] = 'Pokračovať';
$string['continuetocourse'] = 'Kliknite sem pre vstup do testu';
$string['convertingwikitomarkdown'] = 'Konverzia Wiki do Markdown';
$string['cookiesenabled'] = 'Cookies musia byť zapnuté na Vašom prehliadači';
$string['cookiesenabled_help'] = '<p>Tieto stránky používajú dva súbory cookie.</p>

<p>Hlavným používaným súborom cookie je súbor session, ktorý sa obvykle nazýva
<b>MoodleSession</b>. Tento súbor cookie je treba povoliť v prehliadači,
zaisťuje kontinuitu vašej práce na portáli a udržuje informácie o vašom
prihlásení. Pri odhlásení alebo ukončení prehliadača je tento súbor cookie
odstránený jednak z prehliadača, ako aj zo serveru.</p>

<p>Druhý súbor cookie iba uľahčuje používateľovi prácu. Obvykle sa nazýva
<b>MOODLEID</b>. Slúži k zapamätaniu vášho používateľského mena v prehliadači.
To znamená, že pri návrate na tento portál bude pole s používateľským menom na
stránke prihlásenia už vyplnené. Tento súbor cookie je možné zakázať. Pri
každom prihlásení však budete musieť zadať svoje používateľské meno.</p>';
$string['cookiesnotenabled'] = 'Bohužiaľ, cookies nie sú zapnuté na Vašom prehliadači.';
$string['copy'] = 'kopírovať';
$string['copyasnoun'] = 'kopírovanie';
$string['copyingcoursefiles'] = 'Kopírujú sa súbory kurzu';
$string['copyingsitefiles'] = 'Kopírujú sa súbory portálu použité v kurze';
$string['copyinguserfiles'] = 'Kopírujú sa súbory používateľov';
$string['copyingzipfile'] = 'Kopírujú sa súbory zip';
$string['copyrightnotice'] = 'Upozornenie o autorských právach';
$string['coresystem'] = 'Systémové jadro';
$string['cost'] = 'Náklady';
$string['costdefault'] = 'Východiskové náklady';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Krajina';
$string['course'] = 'Kurz';
$string['courseadministration'] = 'Administratíva kurzu';
$string['courseapprovedemail'] = 'Kurz {$a->name}, ktorý ste žiadali, bol schválený a vy ste boli nastavený ako {$a->teacher}. Kurz nájdete na adrese: {$a->url}';
$string['courseapprovedemail2'] = 'Kurz {$a->name}, o vytvorenie ktorého ste požiadali, bol vytvorený.  Ak sa chcete doň dostať, choďte sem {$a->url}';
$string['courseapprovedfailed'] = 'Nepodarilo sa uložiť kurz ako schválený';
$string['courseapprovedsubject'] = 'Váš kurz bol schválený';
$string['courseavailable'] = 'Tento kurz je prístupný pre študentov';
$string['courseavailablenot'] = 'Tento kurz nie je prístupný pre študentov';
$string['coursebackup'] = 'Záloha kurzu';
$string['coursebulkaction'] = 'Hromadné operácie pre vybrané kurzy';
$string['coursecategories'] = 'Kategórie kurzu';
$string['coursecategory'] = 'Kategória kurzu';
$string['coursecategorydeleted'] = 'Vymazaná kategória kurzov {$a}';
$string['coursecategory_help'] = '<p>Váš Moodle administrátor môže zriadiť niekoľko kategórií kurzov.</p>

<p>Napríklad, "Veda", "Humanitné predmety", "Zdravie obyvateľstva" atď.</p>

<p>Vyberte si najvhodnejšiu pre váš kurz. Táto voľba ovplyvní, kde
bude váš kurz zobrazený. Toto môže napomôcť študentom pri nájdení
vášho kurzu.</p>';
$string['coursecatmanagement'] = 'Správa kurzov a kategórií';
$string['coursecompletion'] = 'Ukončenie kurzu';
$string['coursecompletions'] = 'Ukončenie kurzov';
$string['coursecreators'] = 'Tvorca kurzu';
$string['coursecreatorsdescription'] = 'Tvorcovia kurzov môžu vytvárať nové kurzy.';
$string['coursedeleted'] = 'Vymazaný kurz {$a}';
$string['coursedisplay'] = 'Vzhľad kurzu';
$string['coursedisplay_help'] = 'Toto nastavenie určuje, či sa má celý kurz zobraziť na jednej stránke alebo či sa majú jednotlivé sekcie zobrazovať na samostatných stránkach.';
$string['coursedisplay_multi'] = 'Zobraziť jednu sekciu na stránke';
$string['coursedisplay_single'] = 'Zobraziť všetky sekcie na stránke';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Súbory kurzu (zastaralé)';
$string['coursefilesedit'] = 'Upraviť  súbory kurzu';
$string['coursefileswarning'] = 'Súbory kurzu sú zastaralé';
$string['coursefileswarning_help'] = 'Súbory kurzu sú zastaralé od Moodle 2.0. Použite namiesto nich v čo najväčšej miere externé úložiská.';
$string['courseformatdata'] = 'Formát dát kurzu';
$string['courseformatoptions'] = 'Formátovacie voľby pre {$a}';
$string['courseformats'] = 'Formáty kurzu';
$string['courseformatudpate'] = 'Aktualizácia formátu';
$string['coursegrades'] = 'Známky v kurze';
$string['coursehelpcategory'] = 'Umiestnenie kurzu v zozname kurzov pre jeho ľahšie nájdenie študentmi';
$string['coursehelpforce'] = 'Vnútiť režim skupín nastavený kurzom pre každú aktivitu.';
$string['coursehelpformat'] = 'Hlavná stránka kurzu bude zobrazená v tomto formáte';
$string['coursehelphiddensections'] = 'Spôsob zobrazenia skrytých sekcií kurzu študentom';
$string['coursehelpmaximumupload'] = 'Určenie najväčšej veľkosti súboru, ktorý môžu študenti nahrať na server. Je to obmedzené nastavením na portáli.';
$string['coursehelpnewsitemsnumber'] = 'Počet najnovších položiek zobrazených na domovskej stránke kurzu v novinkách (0 znamená, že blok noviniek nebude zobrazený).';
$string['coursehelpnumberweeks'] = 'Počet sekcií v kurze (platí iba pre niektoré formáty kurzu).';
$string['coursehelpshowgrades'] = 'Povoliť zobrazenie známok. Nemá to ale vplyv na zobrazenie hodnotení v jednotlivých aktivitách.';
$string['coursehidden'] = 'Tento kurz je v súčasnosti pre študentov neprístupný';
$string['courseinfo'] = 'Informácie o kurze';
$string['courselegacyfiles'] = 'Súbory kurzu (zastaralé)';
$string['courselegacyfiles_help'] = 'Súbory kurzu poskytujú spätnú kompatibilitu s Moodle verziou 1.9 a staršou. Všetky súbory v tomto priestore sú vždy dostupné všetkým účastníkom (nezáleží na tom, či sa na ne odkazuje alebo nie). Tiež nie je žiaden spôsob zistiť, kde a ktoré súbory sú v Moodle použité.

Ak používate toto miesto na uloženie súborov kurzu, môžete mať problémy so súkromím a bezpečnosťou. Taktiež môžu chýbať v zálohách kurzov, importoch a nie je možné ich viacnásobne využívať. Je preto doporučené, aby ste tento priestor nepoužívali, ak presne neviete, čo robíte.

Odkaz nižšie poskytuje viac informácií o tejto problematike a vysvetlí vám viacero lepších spôsobov práce so súbormi v Moodle 2.';
$string['courselegacyfilesofcourse'] = 'Súbory kurzu: {$a}';
$string['coursemessage'] = 'Správa používateľom kurzu';
$string['coursenotaccessible'] = 'Tento kurz nepovoľuje verejný prístup';
$string['courseoverview'] = 'Prehľad kurzu';
$string['courseoverviewfiles'] = 'Súbory v súhrne kurzu';
$string['courseoverviewfilesext'] = 'Prípony súborov v súhrne kurzu';
$string['courseoverviewfiles_help'] = 'Súbory súhrnu, napríklad obrázky, sú zobrazené v zozname kurzov spoločne so súhrnom kurzu.';
$string['courseoverviewfileslimit'] = 'Limit počtu súborov v súhrne kurzu';
$string['courseoverviewgraph'] = 'Graf prehľadu kurzu';
$string['courseprofiles'] = 'Profily kurzu';
$string['coursereasonforrejecting'] = 'Vaše dôvody pre neakceptovanie tejto žiadosti';
$string['coursereasonforrejectingemail'] = 'Toto bude mailované žiadateľovi';
$string['coursereject'] = 'Zamietnuť žiadosť o kurz';
$string['courserejected'] = 'Kurz bol zamietnutý a žiadateľ bol o tom informovaný.';
$string['courserejectemail'] = 'Žiaľ, Vaša žiadosť o kurz bola zamietnutá z nasledovného dôvodu

{$a}';
$string['courserejectreason'] = 'Vysvetlite svoje dôvody na zamietnutie žiadosti o kurz<br />(toto bude mailované žiadateľovi)';
$string['courserejectsubject'] = 'Váš kurz bol zamietnutý';
$string['coursereport'] = 'Výkaz kurzu';
$string['coursereports'] = 'Výkazy kurzu';
$string['courserequest'] = 'Žiadosť o vytvorenie nového kurzu';
$string['courserequestdetails'] = 'Podrobnosti o kurze, ktorý žiadate vytvoriť';
$string['courserequestfailed'] = 'Z nejakého dôvodu nemohla byť vaša žiadosť o vytvorenie kurzu uložená.';
$string['courserequestintro'] = 'Použite tento formulár na žiadosť o vytvorenie kurzu <br />Pokúste sa uviesť maximum informácií,<br />aby administrátor pochopil vašu žiadosť.';
$string['courserequestreason'] = 'Dôvody pre žiadosť o vytvorenie kurzu';
$string['courserequestsuccess'] = 'Vaša žiadosť o kurz bola úspešne uložená. O pár dní očakávajte mail s rozhodnutím.';
$string['courserequestsupport'] = 'Dodatočné informácie, ktoré by mohli pomôcť administrátorovi pri vyhodnotení Vašej požiadavky';
$string['courserestore'] = 'Obnoviť kurz zo zálohy';
$string['courses'] = 'Kurzy';
$string['coursesectionsummaries'] = 'Súhrn sekcie kurzu';
$string['coursesettings'] = 'Východzie nastavenia kurzu';
$string['coursesmovedout'] = 'Kurzy boli presunuté z {$a}';
$string['coursespending'] = 'Kurzy, ktoré čakajú na schválenie';
$string['coursestart'] = 'Štart kurzu';
$string['coursesummary'] = 'Sumár kurzu';
$string['coursesummary_help'] = 'Obsah kurzu sa nachádza v zozname kurzov. Vyhľadávanie kurzov taktiež prezerá aj v obsahu kurzov.';
$string['courseupdates'] = 'Aktualizácia kurzov';
$string['create'] = 'Vytvoriť';
$string['createaccount'] = 'Vytvoriť moje nové konto';
$string['createcategory'] = 'Vytvoriť kategóriu';
$string['createfolder'] = 'Vytvoriť priečinok v {$a}';
$string['createnew'] = 'Vytvoriť novú';
$string['createnewcategory'] = 'Vytvoriť novú kategóriu';
$string['createnewcourse'] = 'Vytvoriť nový kurz';
$string['createnewsubcategory'] = 'Vytvoriť novú podkategóriu';
$string['createsubcategoryof'] = 'Vytvoriť podkategóriu v {$a}';
$string['createuser'] = 'Vytvoriť používateľa';
$string['createuserandpass'] = 'Zvolte svoje používateľské meno a heslo na prihlasovanie';
$string['createziparchive'] = 'Vytvoriť zip archív';
$string['creatingblocks'] = 'Vytvárajú sa bloky';
$string['creatingblocksroles'] = 'Vytvárajú sa blokové priradenia a prepisovanie rol';
$string['creatingblogsinfo'] = 'Vytváranie informácií k blogom';
$string['creatingcategoriesandquestions'] = 'Vytvárajú sa kategórie a otázky';
$string['creatingcoursemodules'] = 'Vytvárajú sa moduly kurzu';
$string['creatingcourseroles'] = 'Vytvárajú sa priradenia a prepisovanie rol kurzu';
$string['creatingevents'] = 'Vytvárajú sa udalosti';
$string['creatinggradebook'] = 'Vytvárajú sa knihy bodov';
$string['creatinggroupings'] = 'Vytvárajú sa zoskupenia';
$string['creatinggroupingsgroups'] = 'Pridávanie skupín do zoskupení';
$string['creatinggroups'] = 'Vytvárajú sa skupiny';
$string['creatinglogentries'] = 'Vytvárajú sa prihlasovacie zoznamy';
$string['creatingmessagesinfo'] = 'Vytvárajú sa informácie o správach';
$string['creatingmodroles'] = 'Vytvárajú sa priradenia a prepisovanie rol na úrovni modulu';
$string['creatingnewcourse'] = 'Vytvára sa nový kurz';
$string['creatingrolesdefinitions'] = 'Vytvárajú sa definície rol';
$string['creatingscales'] = 'Vytvárajú sa stupnice';
$string['creatingsections'] = 'Vytvárajú sa sekcie';
$string['creatingtemporarystructures'] = 'Vytvárajú sa dočasné štruktúry';
$string['creatinguserroles'] = 'Vytvárajú sa priradenia a prepisovanie rol na úrovni používateľov';
$string['creatingusers'] = 'Vytvárajú sa používatelia';
$string['creatingxmlfile'] = 'Vytvára sa XML súbor';
$string['currency'] = 'Mena';
$string['currentcourse'] = 'Aktuálny kurz';
$string['currentcourseadding'] = 'Aktuálny kurz, pridávajú sa do neho údaje';
$string['currentcoursedeleting'] = 'Aktuálny kurz, vymazáva sa ako prvý';
$string['currentlanguage'] = 'Aktuálny jazyk';
$string['currentlocaltime'] = 'Váš aktuálny miestny čas';
$string['currentlyselectedusers'] = 'Vyznačení používatelia';
$string['currentpicture'] = 'Aktuálny obrázok';
$string['currentrelease'] = 'Informácia o aktuálnej verzii';
$string['currentversion'] = 'Aktuálna verzia';
$string['databasechecking'] = 'Aktualizujem Moodle databázu z verzie {$a->oldversion} na {$a->newversion}';
$string['databaseperformance'] = 'Činnosť databázy';
$string['databasesetup'] = 'Nastavovanie databázy';
$string['databasesuccess'] = 'Databáza bola úspešne aktualizovaná';
$string['databaseupgradebackups'] = 'Zálohovaná verzia je momentálne {$a}';
$string['databaseupgradeblocks'] = 'Verzia blokov je momentálne {$a}';
$string['databaseupgradegroups'] = 'Verzia skupín je teraz {$a}';
$string['databaseupgradelocal'] = 'Verzia úprav lokálnej databázy je teraz {$a}';
$string['databaseupgrades'] = 'Aktualizácia databázy';
$string['date'] = 'Dátum';
$string['datechanged'] = 'Dátum zmenený';
$string['datemostrecentfirst'] = 'Dátum - aktuálny ako prvý';
$string['datemostrecentlast'] = 'Dátum - aktuálny ako posledný';
$string['day'] = 'deň';
$string['days'] = 'dni';
$string['decodinginternallinks'] = 'Dekódovanie interných linkov';
$string['default'] = 'Predvolené';
$string['defaultcoursestudent'] = 'Študent';
$string['defaultcoursestudentdescription'] = 'Študenti majú vo všeobecnosti v kurze menej práv.';
$string['defaultcoursestudents'] = 'Študenti';
$string['defaultcoursesummary'] = 'Tu napíšte výstižný a zaujímavý odsek, ktorý vysvetľuje, o čom je tento kurz';
$string['defaultcourseteacher'] = 'Učiteľ';
$string['defaultcourseteacherdescription'] = 'Učitelia majú všetky právomoci v kurze vrátane zmien aktivít a hodnotenia študentov.';
$string['defaultcourseteachers'] = 'Učitelia';
$string['defaulteditor'] = 'Východzí editor';
$string['delete'] = 'Odstrániť';
$string['deleteablock'] = 'Odstrániť blok';
$string['deleteall'] = 'Odstrániť všetko';
$string['deleteallcannotundo'] = 'Vymazať všetko - bez možnosti vrátiť sa späť';
$string['deleteallcomments'] = 'Vymazať všetky poznámky';
$string['deleteallratings'] = 'Vymazať všetky hodnotenia';
$string['deletecategory'] = 'Vymazať kategóriu: {$a}';
$string['deletecategorycheck'] = 'Naozaj chcete úplne odstrániť túto kategóriu<b>\'{$a}\'</b>?<br />
Týmto presuniete všetky kurzy do rodičovskej (nadradenej) kategórie, ak taká existuje, alebo do kategórie Rôzne.';
$string['deletecategorycheck2'] = 'Ak vymažete túto kategóriu, rozhodnite, čo urobíte z kurzmi a kategóriami kurzov, ktoré obsahuje.';
$string['deletecategoryempty'] = 'Táto kategória je prázdna';
$string['deletecheck'] = 'Odstrániť {$a} ?';
$string['deletecheckfiles'] = 'Naozaj chcete vymazať tieto súbory?';
$string['deletecheckfull'] = 'Naozaj chcete odstrániť {$a} ?';
$string['deletechecktype'] = 'Naozaj chcete vymazať {$a->type}?';
$string['deletechecktypename'] = 'Naozaj chcete vymazať {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Chystáte sa odstrániť tieto súbory';
$string['deletecomment'] = 'Odstrániť tento komentár';
$string['deletecompletely'] = 'Všetko odstrániť';
$string['deletecourse'] = 'Odstrániť kurz';
$string['deletecoursecheck'] = 'Naozaj chcete úplne odstrániť tento kurz a všetky údaje, ktoré obsahuje?';
$string['deleted'] = 'Odstránené';
$string['deletedactivity'] = 'Odstránená aktivita {$a}';
$string['deletedcourse'] = '{$a} bolo úplne odstránené';
$string['deletednot'] = 'Nemôže odstrániť {$a} !';
$string['deletelogs'] = 'Vymazať logy';
$string['deleteselected'] = 'Odstrániť vybraté';
$string['deleteselectedkey'] = 'Vymazať vybraný kľúč';
$string['deletingcourse'] = 'Odstraňovanie {$a}';
$string['deletingexistingcoursedata'] = 'Odstraňujú sa  údaje existujúceho kurzu';
$string['deletingolddata'] = 'Odstraňujú sa staré údaje';
$string['department'] = 'Oddelenie';
$string['desc'] = 'Zostupné';
$string['description'] = 'Opis';
$string['deselectall'] = 'Odznačiť všetko';
$string['detailedless'] = 'Menej detailný';
$string['detailedmore'] = 'Detailnejší';
$string['directory'] = 'Adresár';
$string['disable'] = 'Deaktivovať';
$string['disabledcomments'] = 'Komentáre sú zakázané';
$string['displayingfirst'] = 'Len prvých {$a->count} {$a->things} je zobrazených.';
$string['displayingrecords'] = 'Zobrazuje sa {$a} záznamov';
$string['displayingusers'] = 'Zobrazuje používateľov {$a->start} do {$a->end}';
$string['displayonpage'] = 'Zobraziť na stránke';
$string['dndcourse'] = 'Kurz môžete potiahnuť a zmeniť jeho poradie alebo presunúť do inej kategórie.';
$string['dndenabled_inbox'] = 'Pre nahranie súborov z vášho počítača ich potiahnite sem';
$string['dndnotsupported'] = 'Nahrávanie súborov ťahaním  myšou nie je podporované';
$string['dndnotsupported_help'] = 'Váš prehliadač nepodporuje ťahanie súborov myšou. <br />. Táto funkcia je dostupná vo všetkých najnovších verziách prehliadačov Chrome, Firefox, Safari a tiež aj Internet Explorer verzie 10 a vyššej.';
$string['dndnotsupported_insentence'] = 'Ťahanie súborov myšou nie je podporované';
$string['dnduploadwithoutcontent'] = 'Toto nahrávanie nemá žiadny obsah';
$string['dndworkingfile'] = 'Pre nahranie súborov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingfilelink'] = 'Pre nahranie súborov alebo odkazov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingfiletext'] = 'Pre nahranie súborov alebo textov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingfiletextlink'] = 'Pre nahranie súborov, odkazov, alebo textov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkinglink'] = 'Pre nahranie odkazov textov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingtext'] = 'Pre nahranie textov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingtextlink'] = 'Pre nahranie textov alebo odkazov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['documentation'] = 'Moodle dokumentácia';
$string['dontsortcategories'] = 'Neradiť kategórie';
$string['dontsortcourses'] = 'Neradiť kurzy';
$string['down'] = 'Dolu';
$string['download'] = 'Stiahnuť';
$string['downloadall'] = 'Stiahnuť všetko';
$string['downloadexcel'] = 'Stiahnuť vo formáte Excel';
$string['downloadfile'] = 'Stiahnuť súbor';
$string['downloadods'] = 'Stiahnuť vo formáte ODS';
$string['downloadtext'] = 'Stiahnuť v textovom formáte';
$string['doyouagree'] = 'Prečítali ste si podmienky a porozumeli ste im?';
$string['droptoupload'] = 'Pre nahranie súborov ich potiahnite sem';
$string['duplicate'] = 'Duplikát';
$string['duplicateconfirm'] = 'Naozaj chcete vytvoriť kópiu:  {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Vrátiť sa do kurzu';
$string['duplicatecontedit'] = 'Upraviť novú kópiu';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' : kópia úspešne vytvorená';
$string['duplicatinga'] = 'Vytvára sa duplikát: {$a}';
$string['edhelpaspellpath'] = 'Pre použitie kontroly pravopisu v editore MUSÍTE mať nainštalovaný na vašom serveri <strong>aspell 0.50</strong>, alebo novší a musíte určiť správnu cestu ku binárnemu súboru aspell. Na Unix-Linux systémoch je táto cesta obyčajne <strong>/usr/bin/aspell</strong>, ale je možné že to bude inak.';
$string['edhelpbgcolor'] = 'Definovať farbu pozadia editora.<br />Platné hodnoty sú napríklad:#ffffff alebo biela';
$string['edhelpcleanword'] = 'Toto nastavenie aktivuje alebo deaktivuje špecifický formát filtrovania Wordu.';
$string['edhelpenablespelling'] = 'Aktivovať alebo deaktivovať kontrolu pravopisu. Ak je voľba aktivovaná,<strong>aspell</strong> musí byť nainštalovaný na serveri. Druhá hodnota je <strong>default dictionary</strong>. Táto hodnota bude použitá vtedy, ak aspell nemá slovník pre vlastný zvolený jazyk používateľa.';
$string['edhelpfontfamily'] = 'Vlastnosti príbuzných fontov je zoznam názvov príbuzných fontov a/alebo druhových mien. Príbuzné názvy musia byť oddelené čiarkou.';
$string['edhelpfontlist'] = 'Definovať fonty použité v roletovom editovacom menu.';
$string['edhelpfontsize'] = 'Východiskové nastavenie veľkosti fontu nastavuje veľkosť fontu.<br />Platné hodnoty sú napríklad: stredná, veľká, menšia, väčšia, 10pt, 11px.';
$string['edit'] = 'Upraviť';
$string['edita'] = 'Upraviť {$a}';
$string['editcategorysettings'] = 'Upraviť nastavenia kategórie';
$string['editcategorythis'] = 'Upraviť túto kategóriu';
$string['editcoursesettings'] = 'Upraviť nastavenia kurzu';
$string['editfiles'] = 'Upraviť súbory';
$string['editgroupprofile'] = 'Upraviť profil skupiny';
$string['editinga'] = 'Upraviť {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Túto hodnotu nemôžete upravovať!';
$string['editmyprofile'] = 'Upraviť profil';
$string['editorbgcolor'] = 'Farba pozadia';
$string['editorcleanonpaste'] = 'Prilepiť v čistom Word HTML formáte';
$string['editorcommonsettings'] = 'Bežné nastavenia';
$string['editordefaultfont'] = 'Východiskový font';
$string['editorenablespelling'] = 'Aktivovať kontrolu pravopisu';
$string['editorfontlist'] = 'Zoznam fontov';
$string['editorfontsize'] = 'Východisková veľkosť fontu';
$string['editorresettodefaults'] = 'Obnoviť východiskové hodnoty';
$string['editorsettings'] = 'Nastavenia editora';
$string['editorshortcutkeys'] = 'Klávesové skratky editora';
$string['editsettings'] = 'Upraviť nastavenia';
$string['editsummary'] = 'Upraviť zhrnutie';
$string['editthisactivity'] = 'Upraviť túto aktivitu';
$string['editthiscategory'] = 'Upraviť túto kategóriu';
$string['edittitle'] = 'Upraviť názov';
$string['edittitleinstructions'] = 'Pre zrušenie stlačte Escape, pre dokončenie Enter';
$string['edituser'] = 'Upraviť používateľské kontá';
$string['email'] = 'Emailová adresa';
$string['emailactive'] = 'Aktivovaný email';
$string['emailagain'] = 'Email (znovu)';
$string['emailalreadysent'] = 'E-mail s obnovením hesla bol odoslaný. Skontrolujte prosím Váš e-mail.';
$string['emailcharset'] = 'Znaková sada mailu';
$string['emailconfirm'] = 'Potvrďte Vaše konto';
$string['emailconfirmation'] = 'Dobrý deň {$a->firstname},
Požiadali ste o vytvorenie nového konta u \'{$a->sitename}\' používajúce Vašu emailovú adresu.

Na potvrdenie Vášho nového konta choďte prosím na nasledujúcu webovú adresu:  {$a->link}

Vo väčšine emailových programov, by sa mala objaviť ako modrá linka, na ktorú stačí kliknúť. Ak to nefunguje, skopírujte adresu do riadku pre adresu vo vrchnej časti okna Vášho web prehliadača.

Ak potrebujete akúkoľvek pomoc, prosím kontaktujte administrátora stránky, {$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: potvrdenie konta';
$string['emailconfirmsent'] = '<p>Na Vašu emailovú adresu by mal byť odoslaný email<b>{$a}</b></p>

<p>Obsahuje jednoduchý návod na ukončenie Vašej registrácie.</p>

<p>Ak problémy pretrvávajú, kontaktujte administrátora stránky.</p>';
$string['emaildigest'] = 'Štruktúrovaný typ emailu';
$string['emaildigestcomplete'] = 'Kompletný (denne so všetkými príspevkami)';
$string['emaildigestoff'] = 'Neštruktúrovaný (jednoduchý email s príspevkami z fór)';
$string['emaildigestsubjects'] = 'Predmety (denne len s predmetmi)';
$string['emaildisable'] = 'Táto emailová adresa je neaktívna';
$string['emaildisableclick'] = 'Kliknite sem pre deaktiváciu všetkých emailov, ktoré dostávate na Vašu adresu';
$string['emaildisplay'] = 'Zobrazenie emailov';
$string['emaildisplaycourse'] = 'Povoliť zobrazenie mojej emailovej adresy len členom kurzu';
$string['emaildisplayhidden'] = 'Skrytý email';
$string['emaildisplayno'] = 'Ukryť moju skutočnú emailovú adresu pre všetkých';
$string['emaildisplayyes'] = 'Povoliť zobrazenie mojej emailovej adresy pre každého';
$string['emailenable'] = 'Táto emailová adresa je aktivovaná';
$string['emailenableclick'] = 'Kliknite sem pre opätovnú aktiváciu zasielania všetkých mailov na túto adresu.';
$string['emailexists'] = 'Táto emailová adresa je už zaregistrovaná.';
$string['emailformat'] = 'Emailový formát';
$string['emailmustbereal'] = 'Pozor: Vaša emailová adresa musí byť skutočná';
$string['emailnotallowed'] = 'Emailové adresy v týchto doménach nie sú povolené ({$a})';
$string['emailnotfound'] = 'Tento email nebol nájdený v databáze';
$string['emailonlyallowed'] = 'Tento email nie je jedným z tých, ktoré sú povolené ({$a})';
$string['emailpasswordchangeinfo'] = 'Dobrý deň {$a->firstname},

Niekto (pravdepodobne vy) požaduje zmenu hesla k Vášmu účtu na stránkach  \'{$a->sitename}\'.
Vaše heslo zmeníte na stránke:

{$a->link}

Vo väčšine emailových programov, by sa mala objaviť ako modrá linka, na ktorú stačí kliknúť. Ak to nefunguje, skopírujte adresu do riadku pre adresu vo vrchnej časti okna Vášho web prehliadača.

Ak narazíte na problémy, obráťte sa na správcu týchto stránok:
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Dobrý deň {$a->firstname},

Niekto (pravdepodobne vy) požaduje zmenu hesla k Vášmu účtu na stránkach  \'{$a->sitename}\'.

Vaše konto je však zablokované a nemôže byť resetované. Obráťte sa na správcu týchto stránok:
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Dobrý deň {$a->firstname},

Niekto (pravdepodobne vy) požaduje zmenu hesla k Vášmu účtu na stránkach  \'{$a->sitename}\'.

Na týchto stránkach bohužiaľ nie je možné zmeniť heslo, spojte sa so správcom:
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = 'Zmeniť informáciu hesla';
$string['emailpasswordconfirmation'] = 'Dobrý deň {$a->firstname},

Niekto (pravdepodobne Vy) si vyžiadal nové heslo pre Vaše konto na \'{$a->sitename}\'.

Aby ste to potvrdili a dostali nové heslo e-mailom, navštívte nasledovnú www stránku:

{$a->link}

Vo väčšine emailových programov, by sa mala objaviť ako modrá linka, na ktorú stačí kliknúť. Ak to nefunguje, skopírujte adresu do riadku pre adresu vo vrchnej časti okna Vášho web prehliadača.

Ak potrebujete akúkoľvek pomoc, kontaktujte prosím  administrátora siete,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: potvrdenie zmeny hesla';
$string['emailpasswordconfirmmaybesent'] = '<p>Ak ste zadali správne meno alebo adresu, mali by ste dostať e-mail.</p>
<p>Obsahuje jednoduché pokyny na potvrdenie a ukončenie zmeny hesla.
Ak budú vaše problémy pokračovať, kontaktujte administrátora portálu.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> Zadaný používateľský účet nemá zadanú e-mailovú adresu. </p><p> Kontaktujte správcu portálu. </p>';
$string['emailpasswordconfirmsent'] = 'Na Vašu emailovú adresu by mal byť odoslaný email<b>{$a}</b><br />
Obsahuje jednoduchý návod na potvrdenie a kompletizáciu procesu zmeny hesla.
Ak problémy pretrvávajú, kontaktujte administrátora stránky.';
$string['emailpasswordsent'] = 'Ďakujeme, že ste potvrdili zmenu hesla.

Na Vašu emailovú adresu by mal byť odoslaný email potvrdzujúci Vaše nové heslo<br />
<b>{$a->email}</b>.<br />
Nové heslo bolo automaticky generované - možno si ho budete chcieť <a href="{$a->link}">zmeniť</a> na ľahšie zapamätateľné.';
$string['emailresetconfirmationsubject'] = '{$a}: žiadosť o zmenuu hesla';
$string['emptydragdropregion'] = 'prázdna oblasť';
$string['enable'] = 'Aktivovať';
$string['encryptedcode'] = 'Šifrovací kód';
$string['english'] = 'Angličtina';
$string['enrolmentmethods'] = 'Metódy zápisu';
$string['entercourse'] = 'Kliknite pre vstup do tohto kurzu';
$string['enteremail'] = 'Vložte Vašu emailovú adresu';
$string['enteremailaddress'] = 'Vložte Vašu emailovú adresu na obnovu Vášho hesla. Nové heslo Vám bude zaslané emailom.';
$string['enterusername'] = 'Vložte Vaše používateľské meno';
$string['entries'] = 'Záznamy';
$string['error'] = 'Chyba';
$string['errorcreatingactivity'] = 'Nie je možné vytvoriť inštanciu aktivity \'{$a}\'';
$string['errorfiletoobig'] = 'Súbor bol väčší ako povolené maximum {$a} bytov';
$string['errornouploadrepo'] = 'Pre tento portál nie je povolený žiadne úložisko';
$string['errorwhenconfirming'] = 'Vaše údaje ešte nie sú potvrdené, pretože sa vyskytla chyba. Ak ste klikli na odkaz v emaili, aby ste sa tam dostali, ubezpečte sa, že riadok nebol porušený. Na zopakovanie voľby použite funkcie \'vystrihnúť\' a \'prilepiť\', aby ste dosiahli správne fungovanie odkazu.';
$string['eventcontentviewed'] = 'Zobrazený obsah';
$string['eventcoursecategorydeleted'] = 'Kategória bola vymazaná';
$string['eventcoursecontentdeleted'] = 'Obsah kurzu bol vymazaný';
$string['eventcoursecreated'] = 'Kurz bol vytvorený';
$string['eventcoursedeleted'] = 'Kurz bol odstránený';
$string['eventcoursemodulecreated'] = 'Modul kurzu bol vytvorený';
$string['eventcoursemoduledeleted'] = 'Modul kurzu bol odstránený';
$string['eventcoursemoduleupdated'] = 'Modul kurzu bol aktualizovaný';
$string['eventcourseresetended'] = 'Resetovanie kurzu bolo ukončené';
$string['eventcourseresetstarted'] = 'Resetovanie kurzu bolo začaté';
$string['eventcourserestored'] = 'Kurz bol obnovený';
$string['eventcoursesectionupdated'] = 'Sekcia kurzu bola aktualizovaná';
$string['eventcourseupdated'] = 'Kurz bol aktualizovaný';
$string['eventusercreated'] = 'Používateľ bol vytvorený';
$string['eventuserdeleted'] = 'Používateľ bol odstránený';
$string['eventuserlistviewed'] = 'Zobrazený zoznam používateľov';
$string['eventuserloggedout'] = 'Používateľ sa odhlásil';
$string['eventuserprofileviewed'] = 'Zobrazený používateľský profil';
$string['eventuserupdated'] = 'Používateľ bol aktualizovaný';
$string['everybody'] = 'Každý';
$string['executeat'] = 'Vykonať';
$string['existing'] = 'Existujúci';
$string['existingadmins'] = 'Existujúci administrátori';
$string['existingcourse'] = 'Existujúci kurz';
$string['existingcourseadding'] = 'Existujúci kurz, pripojiť k nemu údaje';
$string['existingcoursedeleting'] = 'Existujúci kurz, najprv ho vymazať';
$string['existingcreators'] = 'Existujúci tvorcovia kurzov';
$string['existingstudents'] = 'Zapísaní študenti';
$string['existingteachers'] = 'Existujúci učitelia';
$string['expand'] = 'Rozbaliť';
$string['expandall'] = 'Rozbaliť všetko';
$string['expandcategory'] = 'Rozbaliť {$a}';
$string['explanation'] = 'Vysvetlenie';
$string['extendenrol'] = 'Predĺžiť zapisovanie (individuálne)';
$string['extendperiod'] = 'Čas predĺženia';
$string['failedloginattempts'] = '{$a->attempts} neúspešných pokusov o prihlásenie do systému od Vášho posledného prihlásenia';
$string['failedloginattemptsall'] = '{$a->attempts} neúspešných pokusov o prihlásenie do systému pre {$a->accounts} používateľské účty';
$string['feedback'] = 'Spätná väzba';
$string['file'] = 'Súbor';
$string['fileexists'] = 'Súbor s názvom {$a} už existuje';
$string['filemissing'] = '{$a} chýba';
$string['files'] = 'Súbory';
$string['filesanduploads'] = 'Súbory a nahrávanie';
$string['filesfolders'] = 'Súbory/priečinky';
$string['filetoolarge'] = 'súbor je príliš veľký';
$string['fileuploadwithcontent'] = 'Neočakávaný parameter "content" pri nahrávaní súboru';
$string['filloutallfields'] = 'Vyplňte prosím všetky políčka tohto formulára';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Vyhľadaj ďalšie kurzy';
$string['first'] = 'Prvý';
$string['firstaccess'] = 'Prvý prístup';
$string['firstname'] = 'Krstné meno';
$string['firstnamephonetic'] = 'Krstné meno - foneticky';
$string['firsttime'] = 'Ste tu prvý raz?';
$string['folder'] = 'Priečinok';
$string['folderclosed'] = 'Zavretý priečinok';
$string['folderopened'] = 'Otvorený priečinok';
$string['followingoptional'] = 'Nasledujúce položky sú nepovinné';
$string['followingrequired'] = 'Nasledujúce položky sú povinné';
$string['for'] = 'Pre';
$string['force'] = 'Vyžadovať';
$string['forcelanguage'] = 'Preferovať určitý jazyk';
$string['forceno'] = 'Nenastaviť';
$string['forcepasswordchange'] = 'Vyžadovať zmenu hesla';
$string['forcepasswordchangecheckfull'] = 'Naozaj chcete vynútiť zmenu hesla pre {$a}?';
$string['forcepasswordchange_help'] = 'Vyzvať používateľa na zmenu hesla pri ďalšom prihlásení.';
$string['forcepasswordchangenot'] = 'Nepodarilo sa vynútiť zmenu hesla pre {$a}';
$string['forcepasswordchangenotice'] = 'Pre pokračovanie je nutné zmeniť heslo';
$string['forcetheme'] = 'Vnútiť tému';
$string['forgotaccount'] = 'Zabudli ste heslo?';
$string['forgotten'] = 'Zabudli ste používateľské meno a heslo?';
$string['forgottenduplicate'] = 'Táto emailová adresa je zdieľaná viacerými účtami, prosím použite používateľské meno';
$string['forgotteninvalidurl'] = 'Neplatné heslo - reset URL';
$string['format'] = 'Formát';
$string['format_help'] = '<h2>LAMS formát</h2>
<p class="indent">
Interface k systému Learning Activity Management System (LAMS) v rámci celého kurzu. LAMS vyžaduje nastavenie administrátorom, aby ho bolo možné používať.</p>

<h2>SCORM formát</h2>
<p class="indent">
Tento formát zobrazuje v prvej sekcii kurzu SCORM balík. (Modul SCORM/AICC poskytuje alternatívnu metódu zobrazovania SCORM balíka v kurze.)</p>

<h2>Formát tém</h2>
<p class="indent">
Veľmi podobné ako týždenný formát, s rozdielom, že každý týždeň je nazvaný "témou".
Téma nie je obmedzená nijakým časovým limitom. Nemusíte špecifikovať žiadne termíny.
</p>

<h2>Sociálny formát</h2>
<p class="indent">
Tento formát je orientovaný na hlavné fórum - sociálne fórum, ktoré sa objaví na hlavnej stránke.
Je to užitočné, nakoľko sa prostredie stáva voľnejšie. Dokonca to nemusí byť kurz. Napríklad,
môže byť použitý ako diskusná skupina daného pracoviska.
</p>

<h2>Týždený formát</h2>
<p class="indent">
Kurz je organizovaný týždeň po týždni s jasným počiatočným a konečným dátumom.
Každý týždeň pozostáva z aktivít. Niektoré z nich môžu mať "otvorené okná",
napríklad dva týždne, po ktorých sa môžu stať nedostupné.
</p>

<h2>Weekly format - CSS (bez tabuliek)</h2>
<p class="indent">
Kurz je organizovaný po týždňoch bez použitia tabuliek v HTML kóde.</p>';
$string['formathtml'] = 'HTML formát';
$string['formatmarkdown'] = 'Markdown formát';
$string['formatplain'] = 'Textový formát';
$string['formattext'] = 'Moodle auto-formát';
$string['formattexttype'] = 'Formátovanie';
$string['framesetinfo'] = 'Dokument v rámcoch obsahuje:';
$string['from'] = 'Od';
$string['frontpagecategorycombo'] = 'Combo zoznam';
$string['frontpagecategorynames'] = 'Zobraziť zoznam kategórii';
$string['frontpagecourselist'] = 'Zobraziť zoznam kurzov';
$string['frontpagecoursesearch'] = 'Pole pre vyhľadávanie kurzu';
$string['frontpagedescription'] = 'Opis titulnej stránky';
$string['frontpagedescriptionhelp'] = 'Tento text bude zobrazený na hlavnej stránke.';
$string['frontpageenrolledcourselist'] = 'Zapísané kurzy';
$string['frontpageformat'] = 'Formát hlavnej stránky';
$string['frontpageformatloggedin'] = 'Formát hlavnej stránky pri prihlásení';
$string['frontpagenews'] = 'Zobraziť položky noviniek';
$string['frontpagesettings'] = 'Nastavenia hlavnej stránky';
$string['fulllistofcourses'] = 'Všetky kurzy';
$string['fullname'] = 'Celý názov';
$string['fullnamecourse'] = 'Celý názov kurzu';
$string['fullnamecourse_help'] = 'Celý názov kurzu je zobrazený v hornej časti každej stránky kurzu a tiež v zozname kurzov.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Celé meno';
$string['fullprofile'] = 'Celý profil';
$string['fullsitename'] = 'Celý názov stránky';
$string['functiondisabled'] = 'Táto funkcia je momentálne neaktívna';
$string['general'] = 'Všeobecné';
$string['geolocation'] = 'zemepisná šírka - dĺžka';
$string['gettheselogs'] = 'Získať tieto logy';
$string['go'] = 'Ísť';
$string['gpl'] = 'Autorské práva (C) 1999 Martin Dougiamas  (http://moodle.com)

Tento program je voľne šíriteľný softvér. Môžete ho šíriť a modifikovať podľa ustanovení Všeobecnej verejnej licencie GNU, vydávanej nadáciou Free Software Foundation a to buď verzie 2 tejto licencie, alebo (podľa vášho uváženia) ktorejkoľvek neskoršej verzie.

Tento program je rozširovaný v nádeji, že bude užitočný, avšak BEZ AKEJKOĽVEK ZÁRUKY. Neposkytujú sa ani odvodené záruky PREDAJNOSTI alebo VHODNOSTI PRE URČITÝ ÚČEL.

Úplné informácie o licencii nájdete na adrese:
http://docs.moodle.org/en/License';
$string['gpl3'] = 'Autorské práva (C) 1999 Martin Dougiamas (http://moodle.com).

Tento program je voľne šíriteľný softvér. Môžete ho šíriť a modifikovať podľa ustanovení Všeobecnej verejnej licencie GNU, vydávanej nadáciou Free Software Foundation a to buď verzie 3 tejto licencie, alebo (podľa vášho uváženia) ktorejkoľvek neskoršej verzie.

Tento program je rozširovaný v nádeji, že bude užitočný, avšak BEZ AKEJKOĽVEK ZÁRUKY. Neposkytujú sa ani odvodené záruky PREDAJNOSTI alebo VHODNOSTI PRE URČITÝ ÚČEL.

Úplné informácie o licencii nájdete na adrese:
http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL licencia';
$string['grade'] = 'Známka';
$string['grades'] = 'Známky';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> je pre túto stránku povolený. V prípade, že nevložíte Vašu profilovú fotografiu, Moodle sa namiesto nej pokúsi nahrať Gravatar obrázok.';
$string['group'] = 'Skupina';
$string['groupadd'] = 'Pridať novú skupinu';
$string['groupaddusers'] = 'Pridať zvolených používateľov do skupiny';
$string['groupextendenrol'] = 'Predĺžiť zápis pre všetkých';
$string['groupfor'] = 'pre skupinu';
$string['groupinfo'] = 'Informácie o zvolenej skupine';
$string['groupinfoedit'] = 'Upraviť nastavenia skupín';
$string['groupinfomembers'] = 'Informácie o zvolených členoch skupiny';
$string['groupinfopeople'] = 'Informácie o zvolených ľuďoch';
$string['groupmembers'] = 'Členovia skupiny';
$string['groupmemberssee'] = 'Prezrieť si členov skupiny';
$string['groupmembersselected'] = 'Členovia zvolenej skupiny';
$string['groupmode'] = 'Režim skupiny';
$string['groupmodeforce'] = 'Vyžadovať režim skupiny';
$string['groupmy'] = 'Moja skupina';
$string['groupnonmembers'] = 'Ľudia nezaradení do skupiny';
$string['groupnotamember'] = 'Prepáčte, ale nie ste členom tejto skupiny';
$string['grouprandomassign'] = 'Náhodne prideliť všetkých do skupín';
$string['groupremove'] = 'Odstrániť zvolenú skupinu';
$string['groupremovemembers'] = 'Odstrániť zvolených členov skupiny';
$string['groups'] = 'Skupiny';
$string['groupsnone'] = 'Žiadne skupiny';
$string['groupsseparate'] = 'Oddelené skupiny';
$string['groupsvisible'] = 'Viditeľné skupiny';
$string['guest'] = 'Hosť';
$string['guestdescription'] = 'Hostia majú minimálne privilégiá a nemôžu vkladať text.';
$string['guestskey'] = 'Povoliť vstup hostí, ktorí majú kľúč';
$string['guestsno'] = 'Nepovoliť vstup hostí';
$string['guestsnotallowed'] = 'Prepáčte, \'{$a}\' nepovoľuje vstup hostí.';
$string['guestsyes'] = 'Povoliť vstup hostí bez kľúča';
$string['guestuser'] = 'Hosťovský používateľ';
$string['guestuserinfo'] = 'Tento používateľ je zvláštnym používateľom, ktorý má prístup len na čítanie do niektorých kurzov.';
$string['help'] = 'Pomoc';
$string['helpprefix2'] = 'Pomoc s {$a}';
$string['helpwiththis'] = 'Pomoc s týmto';
$string['hiddenassign'] = 'Skryté pridelenie rol';
$string['hiddenfromstudents'] = 'Skryté pred študentmi';
$string['hiddensections'] = 'Skryté sekcie';
$string['hiddensectionscollapsed'] = 'Skryté sekcie sa nebudú zobrazovať v plnej forme';
$string['hiddensections_help'] = '<p>Táto voľba umožňuje nastaviť, ako sa budú študentom zobrazovať
skryté sekcie kurzu.</p>

<p>Vo východzom nastavení sa študentom zobrazí malá (obvykle šedá)
plocha, ktorá označuje umiestnenie skrytej sekcie, neobsahuje však ani
odkazy na činnosti ani texty zapísané priamo v tele sekcie. Tento
spôsob je výhodný predovšetkým pri týždennom usporiadaní kurzu,
pretože umožňuje zreteľne označiť týždne, v ktorých sa vyučovanie
nekoná.</p>

<p>Druhou možnosťou je skryť sekcie úplne, takže študenti nebudú o ich
umiestnení v kurze vôbec vedieť.</p>';
$string['hiddensectionsinvisible'] = 'Skryté sekcie budú pre ostatných úplne neviditeľné';
$string['hide'] = 'Skryť';
$string['hideadvancedsettings'] = 'Skryť rozšírené nastavenia';
$string['hidepicture'] = 'Skryť obrázky';
$string['hidesection'] = 'Skryť sekciu {$a}';
$string['hidesettings'] = 'Skryť nastavenia';
$string['hideshowblocks'] = 'Skryť alebo zobraziť bloky';
$string['hits'] = 'Obľúbené';
$string['hitsoncourse'] = 'Obľúbené v {$a->coursename} pre {$a->username}';
$string['hitsoncoursetoday'] = 'Dnešná obľúbenosť v {$a->coursename} pre {$a->username}';
$string['home'] = 'Domov';
$string['hour'] = 'hodina';
$string['hours'] = 'hodín';
$string['howtomakethemes'] = 'Ako urobiť nové témy';
$string['htmleditor'] = 'Použite HTML editor';
$string['htmleditoravailable'] = 'Editor HTML je dostupný';
$string['htmleditordisabled'] = 'Vo Vašom používateľskom profile ste deaktivovali editor HTML';
$string['htmleditordisabledadmin'] = 'Administrátor deaktivoval editor HTML na tejto stránke';
$string['htmleditordisabledbrowser'] = 'Editor HTML nie je dostupný, pretože nepoužívate kompatibilný prehliadač (IE 5.5 a vyšší, Mozilla/Firefox)';
$string['htmlfilesonly'] = 'Iba HTML súbory';
$string['htmlformat'] = 'Pekný HTML formát';
$string['icon'] = 'Ikona';
$string['icqnumber'] = 'Číslo ICQ';
$string['idnumber'] = 'Číslo ID';
$string['idnumbercourse'] = 'ID číslo kurzu';
$string['idnumbercoursecategory'] = 'Identifikátor (ID) kategórie';
$string['idnumbercoursecategory_help'] = 'Identifikátor kategórie kurzu sa používa pri synchronizácii s externými systémami. Tento identifikátor sa nikde nezobrazuje. Pokiaľ neviete identifikátor kategórie, nechajte toto pole prázdne.';
$string['idnumbercourse_help'] = '<p>Identifikačné číslo kurzu (ID) sa používa iba v prípade prepojenia
kurzu s externým informačným systémom. V Moodle sa ID nikde
nezobrazuje. Ak má váš kurz pridelené oficiálne ID, napíšte ho sem. V
opačnom prípade nechajte pole nevyplnené.</p>';
$string['idnumbergroup'] = 'ID číslo skupiny';
$string['idnumbergrouping'] = 'ID číslo zoskupenia';
$string['idnumbermod'] = 'Identifikátor';
$string['idnumbermod_help'] = 'Nastavenie názvu identifikátora poskytuje možnosť identifikácie aktivity v známkach pri ich výpočtoch.
Ak aktivita nie je použitá vo výpočtoch, identifikátor nemusí byť vyplnený.

Identifikátor môže byť nastavený aj v známkovom výkaze, ale upravovaný môže iba na stránke aktualizácie aktivity.';
$string['idnumbertaken'] = 'Tento identifikátor už existuje';
$string['imagealt'] = 'Opis obrázku';
$string['import'] = 'Import';
$string['importdata'] = 'Importovať údaje kurzu';
$string['importdataexported'] = 'Export údajov z \'odkiaľ\' kurzu prebehol úspešne.<br />
Pokračujte v importovaní údajov do \'to\' kurzu.';
$string['importdatafinished'] = 'Import údajov bol ukončený! Teraz vstúpte do vášho kurzu';
$string['importdatafrom'] = 'Vyhľadajte kurz, z ktorého sa majú importovať údaje:';
$string['inactive'] = 'Neaktívny';
$string['include'] = 'Zahrnúť';
$string['includeallusers'] = 'Zahrnúť všetkých používateľov';
$string['includecoursefiles'] = 'Zahrnúť súbory kurzu';
$string['includecourseusers'] = 'Zahrnúť používateľov kurzu';
$string['included'] = 'Zahrnuté';
$string['includelogentries'] = 'Zahrnúť záznamy o prihlasovaní do kurzov';
$string['includemodules'] = 'Zahrnúť moduly';
$string['includemoduleuserdata'] = 'Zahrnúť používateľské údaje modulu';
$string['includeneededusers'] = 'Zahrnúť potrebných používateľov';
$string['includenoneusers'] = 'Nezahrnúť žiadnych používateľov';
$string['includeroleassignments'] = 'Zahrnúť priradenia rol';
$string['includesitefiles'] = 'Zahrnúť súbory portálu použité v tomto kurze';
$string['includeuserfiles'] = 'Zahrnúť súbory používateľov';
$string['increasesections'] = 'Zvýšiť počet sekcií';
$string['info'] = 'Informácie';
$string['institution'] = 'Inštitúcia';
$string['instudentview'] = 'V študentskom pohľade';
$string['interests'] = 'Záujmy';
$string['interestslist'] = 'Zoznam záujmov';
$string['interestslist_help'] = 'Zadajte svoje záujmy oddelené čiarkami';
$string['invalidemail'] = 'Neplatná emailová adresa';
$string['invalidlogin'] = 'Neplatný pokus o prihlásenie, skúste ešte raz';
$string['invalidusername'] = 'Používateľské meno môže obsahovať iba malá alfanumerické znaky, podtržník (_), pomlčku (-), bodku (.) alebo symbol @ ';
$string['invalidusernameupload'] = 'Neplatné používateľské meno';
$string['ip_address'] = 'IP adresa';
$string['jump'] = 'Ísť';
$string['jumpto'] = 'Ísť na...';
$string['keep'] = 'Zachovať';
$string['keepsearching'] = 'Pokračovať v hľadaní';
$string['langltr'] = 'Smer jazyka zľava doprava';
$string['langrtl'] = 'Smer jazyka sprava doľava';
$string['language'] = 'Jazyk';
$string['languagegood'] = 'Tento balíček jazykových nastavení je aktuálny! :-)';
$string['last'] = 'Posledný';
$string['lastaccess'] = 'Posledný prístup';
$string['lastedited'] = 'Posledná úprava';
$string['lastlogin'] = 'Posledné prihlásenie';
$string['lastmodified'] = 'Posledná zmena';
$string['lastname'] = 'Priezvisko';
$string['lastnamephonetic'] = 'Priezvisko - foneticky';
$string['lastyear'] = 'Posledný rok';
$string['latestlanguagepack'] = 'Overte si aktuálny balíček jazykových nastavení na moodle.org';
$string['layouttable'] = 'Usporiadanie tabuľky';
$string['leavetokeep'] = 'Túto položku nevypĺňajte, ak si chcete zachovať pôvodné heslo';
$string['legacythemeinuse'] = 'Tento portál je zobrazený v režime kompatibility, pretože Váš prehliadač je príliš starý.';
$string['license'] = 'Licencia';
$string['licenses'] = 'Licencie';
$string['liketologin'] = 'Chcete sa teraz prihlásiť pod plným používateľským účtom?';
$string['list'] = 'Zoznam';
$string['listfiles'] = 'Zoznam súborov v {$a}';
$string['listofallpeople'] = 'Zoznam všetkých ľudí';
$string['listofcourses'] = 'Zoznam kurzov';
$string['loadinghelp'] = 'Nahrávam ...';
$string['local'] = 'Lokálny';
$string['localplugins'] = 'Lokálne zásuvné moduly';
$string['localpluginsmanage'] = 'Spravovať lokálne zásuvné moduly';
$string['location'] = 'Poloha';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Ste prihlásený ako {$a}';
$string['loggedinasguest'] = 'Práve používate hosťovský prístup';
$string['loggedinnot'] = 'Nie ste prihlásený.';
$string['login'] = 'Prihlásenie';
$string['loginalready'] = 'Už ste prihlásený(á)';
$string['loginas'] = 'Prihlásiť sa ako';
$string['loginaspasswordexplain'] = '<p>Musíte zadať špeciálne "loginas password", aby ste mohli použiť túto vlastnosť.<br />Ak ho neviete, kontaktujte administrátora servera.</p>';
$string['login_failure_logs'] = 'Záznamy o neúspešných pokusoch o prihlásenie';
$string['loginguest'] = 'Prihlásiť sa ako hosť';
$string['loginsite'] = 'Prihlásiť sa na portál';
$string['loginsteps'] = 'Dobrý deň! Na úplný prístup do kurzov potrebujete chvíľu času, aby ste si vytvorili nový účet na tomto web portáli.

Každý z jednotlivých kurzov môže mať aj jednorazový "kľúč na zápis do kurzu", ktorý zatiaľ nebudete potrebovať.

Tu sú kroky:

<ol>
<li>Vyplňte formulár <a href="{$a}">Nové konto</a> s Vašimi údajmi.</li>
<li>Na vašu emailovú adresu bude okamžite odoslaný email.</li>
<li>Prečítajte si váš email a kliknite na webový odkaz, ktorý obsahuje.</li>
<li>Vaše konto bude potvrdené a Vy budete prihlásený.</li>
<li>Teraz si vyberte kurz, ktorého sa chcete zúčastniť.</li>
<li>Ak Vás systém požiada o  "prihlasovací kľúč pre zápis do kurzu" - použite ten, ktorý vám dal váš učiteľ. To vás "zapíše" do kurzu.</li>
<li>Teraz máte prístup do celého kurzu. Odteraz budete musieť už len uviesť Vaše osobné používateľské meno a heslo (vo formulári na tejto strane) na prihlásenie a vstup do každého kurzu, na ktorý ste sa prihlásili.</li>
</ol>';
$string['loginstepsnone'] = '<p>Dobrý deň!</p>
<p>Aby ste mohli úplne vstúpiť do kurzov, musíte si vytvoriť svoje konto.</p>
<p>Potrebujete si stanoviť používateľské meno a heslo a použiť ho vo formulári na tejto strane!</p>
<p>Ak si už niekto pred Vami vybral také isté používateľské meno, budete to musieť skúsiť ešte raz a použiť iné používateľské meno.</p>';
$string['loginto'] = 'Prihlásenie na {$a}';
$string['logout'] = 'Odhlásiť';
$string['logoutconfirm'] = 'Naozaj sa chcete odhlásiť?';
$string['logs'] = 'Záznamy o prihláseniach';
$string['logtoomanycourses'] = '<a href="{$a->url}">more</a>';
$string['logtoomanyusers'] = '<a href="{$a->url}">more</a>';
$string['lookback'] = 'Ísť späť';
$string['mailadmins'] = 'Informovať administrátorov';
$string['mailstudents'] = 'Informovať študentov';
$string['mailteachers'] = 'Informovať učiteľov';
$string['maincoursepage'] = 'Hlavná stránka kurzu';
$string['makeafolder'] = 'Vytvoriť priečinok';
$string['makeeditable'] = 'Ak zapisujete \'{$a}\' prostredníctvom web serverového procesu (napr. Apache), potom môžete zapisovať tento súbor priamo z tejto stránky';
$string['makethismyhome'] = 'Nastaviť toto ako moju východziu domovskú stránku';
$string['manageblocks'] = 'Bloky';
$string['managecategorythis'] = 'Spravovať túto kategóriu';
$string['managecourses'] = 'Spravovať kurzy';
$string['managedatabase'] = 'Spravovať databázu';
$string['manageeditorfiles'] = 'Správa súborov ktoré používa editor';
$string['managefilters'] = 'Filtre';
$string['managemodules'] = 'Administrácia modulov';
$string['manageroles'] = 'Roly a oprávnenia';
$string['markedthistopic'] = 'Táto téma vysvietená ako aktuálna';
$string['markthistopic'] = 'Označiť túto tému, ako aktuálnu tému';
$string['matchingsearchandrole'] = 'Zhoda \'{$a->search}\' a {$a->role}';
$string['maxbytesforfile'] = 'Veľkosť súboru {$a} prevyšuje nastavený limit.';
$string['maxfilesize'] = 'Maximálna veľkosť pre nové súbory: {$a}';
$string['maxfilesreached'] = 'K tejto položke môžete pripojiť maximálne {$a} súborov';
$string['maximumchars'] = 'Maximum {$a} znakov';
$string['maximumgrade'] = 'Maximálna známka';
$string['maximumgradex'] = 'Maximálna známka: {$a}';
$string['maximumshort'] = 'Maximum';
$string['maximumupload'] = 'Maximálna veľkosť sťahovania';
$string['maximumupload_help'] = '<p>Toto nastavenie určuje definovať maximálnu veľkosť súboru, ktorý môžu do kurzu
študenti vložiť. Učiteľ je pri jej určení obmedzený hodnotou maximálnej
veľkosti súboru pre celý portál nastavenou administrátorom.</p>

<p>Veľkosť súboru možno ďalej znížiť nastavením u jednotlivých modulov
aktivít.</p>';
$string['maxnumberweeks'] = 'Maximálny počet sekcií kurzu';
$string['maxnumberweeks_desc'] = 'Týmto nastavíte maximálny počet sekcií, ktorá sa zobrazí v nastaveniach počtu sekcií kurzu (platí iba pre niektoré formáty kurzu).';
$string['maxnumcoursesincombo'] = 'Zobraziť <a href="{$a->link}">zoznam {$a->numberofcourses} kurzov</a>';
$string['maxsize'] = 'Maximálna veľkosť: {$a}';
$string['maxsizeandareasize'] = 'Maximálna veľkosť pre nové súbory: {$a->size}, celkový limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maximálna veľkosť pre nové súbory: {$a->size}, maximálny počet príloh: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maximálna veľkosť pre nové súbory: {$a->size}, maximálny počet príloh: {$a->attachments}, celkový limit: {$a->areasize}';
$string['memberincourse'] = 'Ľudia v kurze';
$string['messagebody'] = 'Telo správy';
$string['messagedselectedusers'] = 'Vybraným používateľom bola poslaná správa a zoznam príjemcov bol resetovaný.';
$string['messagedselectedusersfailed'] = 'Niektorí príjemcovia možno nedostali mail.';
$string['messageprovider:availableupdate'] = 'Sú dostupné oznámenia o aktualizáciách';
$string['messageprovider:backup'] = 'Oznámenia o zálohovaní';
$string['messageprovider:badgecreatornotice'] = 'Oznámenia tvorcu Odznaku';
$string['messageprovider:badgerecipientnotice'] = 'Oznámenia príjemcu Odznaku';
$string['messageprovider:courserequestapproved'] = 'Schválenie žiadosti o vytvorenie kurzu';
$string['messageprovider:courserequested'] = 'Nová žiadosť o vytvorenie kurzu';
$string['messageprovider:courserequestrejected'] = 'Zamietnutie žiadosti o vytvorenie kurzu';
$string['messageprovider:errors'] = 'Dôležité chyby na stránke';
$string['messageprovider:errors_help'] = 'Toto sú dôležité chyby o ktorých by mal administrátor vedieť.';
$string['messageprovider:instantmessage'] = 'Súkromné správy medzi používateľmi';
$string['messageprovider:instantmessage_help'] = 'Tento oddiel nastavuje, čo sa stane so so správami, ktoré sú Vám zaslané od ostatných používateľov tohto portálu.';
$string['messageprovider:notices'] = 'Upozornenie o menej závažných problémoch';
$string['messageprovider:notices_help'] = 'Toto sú menej závažné chyby o ktorých by mal administrátor vedieť.';
$string['messageselect'] = 'Označiť tohto používateľa ako príjemcu pošty';
$string['messageselectadd'] = 'Poslať správu';
$string['middlename'] = 'Stredné meno';
$string['migratinggrades'] = 'Migrácia známok';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minúta';
$string['minutes'] = 'Minúty';
$string['miscellaneous'] = 'Rôzne';
$string['missingcategory'] = 'Musíte si vybrať kategóriu';
$string['missingcity'] = 'Chýba mesto';
$string['missingcountry'] = 'Chýba krajina';
$string['missingdescription'] = 'Chýba opis';
$string['missingemail'] = 'Chýba emailová adresa';
$string['missingfirstname'] = 'Chýba krstné meno';
$string['missingfromdisk'] = 'Chýba na disku';
$string['missingfullname'] = 'Chýba celé meno';
$string['missinglastname'] = 'Chýba priezvisko';
$string['missingname'] = 'Chýba meno';
$string['missingnewpassword'] = 'Chýba nové heslo';
$string['missingpassword'] = 'Chýba heslo';
$string['missingrecaptchachallengefield'] = 'Chýbajúce pole výzvy reCHAPTCHA';
$string['missingreqreason'] = 'Chýba dôvod';
$string['missingshortname'] = 'Chýba skrátené meno';
$string['missingshortsitename'] = 'Chýba skrátený názov stránky';
$string['missingsitedescription'] = 'Chýba opis portálu';
$string['missingsitename'] = 'Chýba názov stránky';
$string['missingstrings'] = 'Nájsť nepreložené texty';
$string['missingstudent'] = 'Musíte si niečo vybrať';
$string['missingsummary'] = 'Chýbajúce zhrnutie';
$string['missingteacher'] = 'Musíte si niečo vybrať';
$string['missingurl'] = 'Chýba URL adresa';
$string['missingusername'] = 'Chýbajúce používateľské meno';
$string['modchooserdisable'] = 'Vypnúť sprievodcu pridaním obsahu';
$string['modchooserenable'] = 'Zapnúť sprievodcu pridaním obsahu';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} nepodporuje nahrávanie súboru typu {$a->type}';
$string['modified'] = 'Modifikované';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Nastavovanie modulových tabuliek';
$string['modulesuccess'] = '{$a} tabuľky boli nastavené správne';
$string['modulesused'] = 'Použité moduly';
$string['month'] = 'Mesiac';
$string['months'] = 'Mesiace';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Moodle Docs pre túto stránku';
$string['moodlerelease'] = 'Moodle verzia';
$string['moodleversion'] = 'Verzia Moodle';
$string['more'] = 'viac';
$string['morehelp'] = 'Viac nápovedy';
$string['moreinformation'] = 'Viac informácií o tejto chybe';
$string['moreprofileinfoneeded'] = 'Povedzte o sebe viac';
$string['mostrecently'] = 'aktuálny';
$string['move'] = 'Presunúť';
$string['movecategoriessuccess'] = 'Úspešne bolo presunutých {$a->count} kategórií do kategórie "{$a->to}"';
$string['movecategoriestotopsuccess'] = 'Úspešne bolo presunutých {$a->count} kategórií do najvyššej úrovne';
$string['movecategorycontentto'] = 'Presunúť do';
$string['movecategorysuccess'] = 'Kategória \'{$a->moved}\' bola úspešne presunutá do kategórie \'{$a->to}\'';
$string['movecategoryto'] = 'Presunúť kategóriu do:';
$string['movecategorytotopsuccess'] = 'Kategórae \'{$a->moved}\' bola úspešne presunutá do najvyššej úrovne';
$string['movecontent'] = 'Presunúť {$a}';
$string['movecontentstoanothercategory'] = 'Presunúť obsah do inej kategórie';
$string['movecoursemodule'] = 'Presunúť zdroj';
$string['movecoursesection'] = 'Presunúť sekciu';
$string['movecourseto'] = 'Presunúť kurz do:';
$string['movedown'] = 'Presunúť nadol';
$string['movefilestohere'] = 'Presunúť súbory sem';
$string['movefull'] = 'Presunúť {$a} na toto miesto';
$string['movehere'] = 'Presunúť sem';
$string['moveleft'] = 'Presunúť doľava';
$string['moveright'] = 'Presunúť doprava';
$string['movesection'] = 'Presunúť sekciu {$a}';
$string['moveselectedcategoriesto'] = 'Presunúť vybrané kategórie do';
$string['moveselectedcoursesto'] = 'Presunúť označené kurzy do ..';
$string['movetoanotherfolder'] = 'Presunúť do iného priečinka';
$string['moveup'] = 'Presunúť nahor';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Nové heslo musí byť rozdielne ako to súčasné';
$string['mustconfirm'] = 'Musíte potvrdiť Vaše prihlásenie';
$string['mycourses'] = 'Moje kurzy';
$string['myfiles'] = 'Moje súkromné súbory';
$string['myfilesmanage'] = 'Spravovať moje súkromné súbory';
$string['myhome'] = 'Moja domovská stránka';
$string['mymoodledashboard'] = 'Môj ovládací panel Moodle';
$string['myprofile'] = 'Môj profil';
$string['name'] = 'Meno';
$string['nameforlink'] = 'Ako chcete nazvať tento odkaz?';
$string['nameforpage'] = 'Ako chcete nazvať túto stránku?';
$string['navigation'] = 'Navigácia';
$string['needed'] = 'Potrebné';
$string['never'] = 'Nikdy';
$string['neverdeletelogs'] = 'Nikdy nevymazávať záznamy o prihláseniach';
$string['new'] = 'Nový';
$string['newaccount'] = 'Nové konto';
$string['newcourse'] = 'Nový kurz';
$string['newpassword'] = 'Nové heslo';
$string['newpasswordfromlost'] = '<strong>POZOR:</strong> Vaše <strong>súčasné heslo</strong> Vám bude poslané v <strong>druhom</strong> maili (z dvoch). Uistite sa, že ste dostali náhradné heslo predtým, ako budete pokračovať na tejto obrazovke.';
$string['newpassword_help'] = 'Nechajte prázdne pre zachovanie súčasného hesla.';
$string['newpasswordtext'] = 'Dobrý deň {$a->firstname},

Vaše heslo účtu na \'{$a->sitename}\' bolo zmenené a bolo vám generované nové aktuálne heslo.

Vaše aktuálne prihlasovacie informácie sú:

   používateľské meno: {$a->username}
   heslo: {$a->newpassword}

Ak chcete zmeniť Vaše heslo, navštívte prosím túto stránku:

   {$a->link}

Vo väčšine programov pre čítanie elektronickej pošty by sa mal tento odkaz objaviť ako modrá linka, na ktorú stačí kliknúť. Ak to nefunguje, skopírujte adresu do riadku pre adresu vo vrchnej časti okna vášho web prehliadača.

S pozdravom \'{$a->sitename}\' administrátor,

{$a->signoff}';
$string['newpicture'] = 'Nový obrázok';
$string['newpicture_help'] = '<p>Môžete načítať obrázok z vášho PC na tento server a tento bude
následne použitý na viacerých miestach.</p>

<p>Z tohoto dôvodu sú najlepšie detailne zábery vašej tváre, ale
môžete použiť ľubovoľné obrázky. </p>

<p>Obrázky musia byť v JPG alebo PNG formáte (znamená to, že obyčajne
majú príponu .jpg alebo .png).</p>

<p>Obrázok môžete získať štyrmi spôsobmi: </p>

<ol>
<li>Použitím digitálneho fotoaparátu. Vaše obrázky s najväčšou pravdepodobnosťou budú v PC v správnom formáte.</li>

<li>Môžete použiť skener a naskenovať obrázky
resp. fotografie. Uistite sa, že tieto sú uložené vo formáte JPG alebo
PNG.</li>

<li>Ak máte umelecké sklony, môžete nakresliť obrázok v kresliacom programe. </li>

<li>Nakoniec, môžete "ukradnúť" obrázky z
internetu.  <a target="google"
href="http://images.google.com/">http://images.google.com</a> je super
miesto na nájdenie obrázku. Ak ste našli správny obrázok, pravým
tlačidlom myši vyberte v menu možnosť "Uložiť obrázok ako...". (Táto
voľba sa v závislosti od PC môže mierne líšiť.) </li>

</ol>

<p>Na načítanie obrázku kliknite na tlačidlo "Prezerať" na tejto
editovacej stránke a vyberte si obrázok z disku vášho počítača.</p>

<p>POZOR: Uistite sa, že obrázok nie je väčší ako je maximálne určená
veľkosť, lebo v takom prípade tento nebude načítaný. </p>

<p>Potom kliknite na "Aktualizácia môjho profilu" a obrázok bude
prispôsobený a zmenšený na 100 * 100 pixelov.</p>

<p>Po návrate na vašu profilovú stránku sa môže zdať, že obrázok
nebol zmenený. V takomto prípade použite tlačítko "Obnoviť" vo vašom
prehliadači. </p>';
$string['newsitem'] = 'nová novinka';
$string['newsitems'] = 'nové novinky';
$string['newsitemsnumber'] = 'Nové správy na zobrazenie';
$string['newsitemsnumber_help'] = '<p>V "týždennom" formáte a vo formáte "tém" sa objaví špeciálne fórum
nazvané "Novinky". Toto je dobrým miestom na poslanie správ a odkazov pre všetkých študentov.
(Prednastavené je také nastavenie, že všetci študenti sú prihlásení na toto fórum a dostanú
vaše správy - odkazy cez e-mail.)  </p>

<p>Toto nastavenie určuje, koľko nedávno vytvorených alebo zmenených
  položiek sa objaví na úvodnej stránke vášho kurzu v bloku vpravo. </p>

<p>Pri nastavení "0 nových položiek" sa okno nových položiek sa neotvorí vôbec.</p>';
$string['newuser'] = 'Nový používateľ';
$string['newusernewpasswordsubj'] = 'Nové používateľské konto';
$string['newusernewpasswordtext'] = 'Dobrý deň {$a->firstname},

Na portáli \'{$a->sitename}\' Vám bolo vytvorené nové konto a dostali ste dočasné heslo.

Váš súčasný login je:
meno: {$a->username}
heslo: {$a->newpassword}
(toto heslo budete musieť zmeniť po Vašom prvom prihlásení)

Na začatie používania portálu \'{$a->sitename}\' sa prihláste na odkaze
{$a->link}.

V najčastejších v mailových programoch je tento odkaz modrý a môžete naň kliknúť. Ak sa to nedá, skopírujte si adresu do zadávacieho riadku Vašeho web prehliadača.

S pozdravom od administrátora portálu \'{$a->sitename}\',

{$a->signoff}';
$string['newusers'] = 'Noví používatelia';
$string['newwindow'] = 'nové okno';
$string['next'] = 'Ďalší';
$string['nextsection'] = 'Ďalšia sekcia';
$string['no'] = 'Nie';
$string['noblockstoaddhere'] = 'K tejto stránke nemôžete pridať žiadne bloky.';
$string['nobody'] = 'Nikto';
$string['nochange'] = 'Žiadna zmena';
$string['nocomments'] = 'Bez komentárov';
$string['nocourses'] = 'Žiadne kurzy';
$string['nocoursesfound'] = 'Žiaden kurz neobsahuje slová \'{$a}\'';
$string['nocoursesyet'] = 'Žiadne kurzy v tejto kategórii';
$string['nodstpresets'] = 'Administrátor nezapol podporu pre letný a zimný čas.';
$string['nofilesselected'] = 'Neoznačili ste žiadne súbory na obnovenie zo zálohy';
$string['nofilesyet'] = 'Do Vášho kurzu ešte neboli vložené žiadne súbory';
$string['nograde'] = 'Žiadna známka';
$string['nohelpforactivityorresource'] = 'Pre tento zdroj alebo aktivitu nie je k dispozícii žiadna nápoveda';
$string['noimagesyet'] = 'Do Vášho kurzu ešte neboli vložené žiadne obrázky';
$string['nologsfound'] = 'Neboli nájdené žiadne záznamy';
$string['nomatchingusers'] = 'Žiadny používatelia sa nezhodujú s \'{$a}\'';
$string['nomorecourses'] = 'Nenašiel sa žiaden ďalší kurz, ktorý by vyhovoval podmienkam';
$string['nomoreidnumber'] = 'Nepoužívate ID číslo  aby ste predišli možným kolíziám';
$string['none'] = 'Žiadne';
$string['noneditingteacher'] = 'Učiteľ bez práv úprav';
$string['noneditingteacherdescription'] = 'Učitelia bez práv úprav môžu učiť v kurzoch a hodnotiť študentov, ale nemôžu meniť aktivity';
$string['nonstandard'] = 'Neštandardný';
$string['nopendingcourses'] = 'Nie sú žiadne kurzy čakajúce na schválenie';
$string['nopotentialadmins'] = 'Nie sú potenciálni administrátori';
$string['nopotentialcreators'] = 'Nie sú potenciálni tvorcovia kurzov';
$string['nopotentialstudents'] = 'Nie sú potenciálni študenti';
$string['nopotentialteachers'] = 'Nie sú potenciálni učitelia';
$string['norecentactivity'] = 'Žiadna súčasná aktivita';
$string['noreplybouncemessage'] = 'Odpovedali ste na emailovú adresu, na ktorú sa zvyčajne neodpovedá. Ak ste sa pokúšali odpovedať na príspevok z fóra, použite namiesto toho prosím tieto {$a} fóra.

Tu sa nachádza obsah Vášho emailu:';
$string['noreplybouncesubject'] = '{$a} - vrátený mail';
$string['noreplyname'] = 'Neodpovedajte na tento mail';
$string['noresults'] = 'Žiadne výsledky';
$string['normal'] = 'Normálny';
$string['normalfilter'] = 'Normálne vyhľadávanie';
$string['nosite'] = 'Nie je možné nájsť kurzy na úrovni portálu';
$string['nostudentsfound'] = 'Nenájdené žiadne {$a}';
$string['nostudentsingroup'] = 'V tejto skupine zatiaľ nie sú žiadni študenti';
$string['nostudentsyet'] = 'Zatiaľ žiadni študenti nie sú prihlásení do tohto kurzu';
$string['nosuchemail'] = 'Nie je taká  emailová adresa';
$string['notavailable'] = 'Nie je k dispozícii';
$string['noteachersyet'] = 'Zatiaľ žiadni učitelia v tomto kurze';
$string['notenrolled'] = '{$a} nie je prihlásený do tohto kurzu.';
$string['notenrolledprofile'] = 'Tento profil nie je dostupný, pretože používateľ nie je zapísaný do tohto kurzu.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Poznámka:</strong> Schopnosť zmeniť dátumy v kurze pri obnovovaní bola zakázaná, pretože Vám na ňu chýbajú oprávnenia.';
$string['noteuserschangednonetocourse'] = '<strong>Poznámka:</strong> Používatelia kurzu musia byť obnovení, ak sa obnovujú používateľské údaje. Toto nastavenie bolo zmenené pre Vás.';
$string['nothingnew'] = 'Od Vášho posledného prihlásenia sa nič nezmenilo';
$string['nothingtodisplay'] = 'Nič na zobrazenie';
$string['notice'] = 'Oznámenie';
$string['noticenewerbackup'] = 'Táto záloha súboru bola vytvorená s Moodle {$a->backuprelease} ({$a->backupversion}) a je vyššia, ako aktuálna verzia Moodle {$a->serverrelease} ({$a->serverversion}). Toto môže spôsobiť niektoré problémy, pretože spätná kompatibilita zálohovaných súborov nemôže byť garantovaná.';
$string['notifications'] = 'Oznámenia';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Používateľ: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Tieto záznamy si môžete prezrieť na {$a}/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Tu je zoznam neúspešných pokusov o prihlásenie na {$a}, odkedy ste boli o tom naposledy upozornený';
$string['notifyloginfailuressubject'] = '{$a} :: Oznámenie o neúspešných pokusoch o prihlásenie';
$string['notincluded'] = 'Nezahrnuté';
$string['notingroup'] = 'Prepáčte, ale musíte byť členom skupiny, aby ste si mohli prezerať tieto aktivity.';
$string['notpublic'] = 'Neverejné!';
$string['nousersfound'] = 'Neboli nájdení používatelia';
$string['nousersmatching'] = 'Neboli nájdení žiadni používatelia, vyhovujúci \'{$a}\'';
$string['nousersyet'] = 'Zatiaľ nie sú používatelia';
$string['novalidcourses'] = 'Žiadne kurzy k zobrazeniu';
$string['now'] = 'teraz';
$string['numattempts'] = '{$a} neúspešných pokusov o prihlásenie';
$string['numberofcourses'] = 'Počet kurzov';
$string['numberweeks'] = 'Počet sekcií';
$string['numdays'] = '{$a} dní';
$string['numhours'] = '{$a} hodín';
$string['numletters'] = '{$a} písmen';
$string['numminutes'] = '{$a} minút';
$string['nummonths'] = '{$a} mesiacov';
$string['numseconds'] = '{$a} sekúnd';
$string['numviews'] = '{$a} názorov';
$string['numweeks'] = '{$a} týždňov';
$string['numwords'] = '{$a} slov';
$string['numyears'] = '{$a} rokov';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Súčasné heslo';
$string['olduserdirectory'] = 'Toto je STARÝ používateľský adresár, ktorý sa už nepoužíva. Môžete ho vymazať, pretože súbory, ktoré obsahoval, boli kopírované do NOVÉHO používateľského adresára.';
$string['opentoguests'] = 'Hosťovský prístup';
$string['optional'] = 'nepovinné';
$string['options'] = 'možnosti';
$string['order'] = 'Poradie';
$string['originalpath'] = 'Pôvodné umiestnenie';
$string['orphanedactivitiesinsectionno'] = 'Osirotené aktivity (sekcia {$a})';
$string['other'] = 'Iné';
$string['outline'] = 'Prehľad';
$string['outlinereport'] = 'Prehľadná správa';
$string['page'] = 'Stránka';
$string['pagea'] = 'Strana {$a}';
$string['pageheaderconfigablock'] = 'Konfiguruje sa blok v {$a->fullname}';
$string['pagepath'] = 'Adresa stránky';
$string['pageshouldredirect'] = 'Táto stránka by sa mala automaticky presmerovať. Ak sa nič neudeje, prosím použite priložený odkaz.';
$string['parentcategory'] = 'Nadradená kategória';
$string['parentcoursenotfound'] = 'Nebol nájdený rodičovský (nadradený) kurz!';
$string['parentfolder'] = 'Rodičovský priečinok';
$string['participants'] = 'Účastníci';
$string['participantslist'] = 'Zoznam účastníkov';
$string['participationratio'] = 'Pomer účastníkov';
$string['participationreport'] = 'Záznamy o účastníkoch';
$string['password'] = 'Heslo';
$string['passwordchanged'] = 'Heslo bolo zmenené';
$string['passwordconfirmchange'] = 'Potvrdiť zmenu hesla';
$string['passwordextlink'] = 'Nasledujúci odkaz je poskytnutý na získanie Vašeho zabudnutého hesla. Odkazuje sa mimo Moodle.';
$string['passwordforgotten'] = 'Zabudnuté heslo';
$string['passwordforgotteninstructions'] = 'Potrebujeme nájsť informácie o Vás v databáze. Zadajte prosím <strong>alebo</strong> Váš login v Moodle alebo mailovú adresu, s ktorou ste sa registrovali. Nemusíte zadať obe.';
$string['passwordforgotteninstructions2'] = 'Ak chcete obnoviť heslo, vyplňte vaše prihlasovacie meno alebo emailovú adresu. Ak vás systém nájde v databáze, bude vám zaslaný email na adresu, ktorú máte vo vašom profile. Mail bude obsahovať  inštrukce, ako sa úspešne prihlásiť.';
$string['passwordnohelp'] = 'Nepodarilo sa nájsť Vaše zabudnuté heslo. Prosím kontaktujte administrátora Moodle.';
$string['passwordrecovery'] = 'Áno, pomôžte mi prihlásiť sa';
$string['passwordsdiffer'] = 'Tieto heslá nie sú správne';
$string['passwordsent'] = 'Heslo bolo poslané';
$string['passwordsenttext'] = '<p>Na vašu adresu {$a->email} bol poslaný email.</p>
<p><b>Skontroluje si prosím poštu, kvôli novému heslu</b></p>
<p>Nové heslo bolo automaticky vytvorené, takže ho môžete <a href="{$a->link}">zmeniť na niečo ľahšie zapamätateľné</a>.</p>';
$string['passwordset'] = 'Vaše heslo bolo nastavené.';
$string['path'] = 'Adresa';
$string['pathnotexists'] = 'Na Vašom serveri neexistuje cesta!';
$string['pathslasherror'] = 'Cesta sa nemôže končiť lomítkom!';
$string['paymentinstant'] = 'Použite tlačidlo v spodnej časti stránky na zaplatenie a budete zapísaný do kurzu v priebehu niekoľkých minút.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> čakajúci</small>)';
$string['paymentrequired'] = 'Tento kurz vyžaduje zaplatenie poplatku pre vstup';
$string['payments'] = 'Platby';
$string['paymentsorry'] = 'Ďakujeme za Vašu platbu! Bohužiaľ, Vaša platba ešte nebola úplne spracovaná a Vy ešte nie ste registrovaný pre vstup do kurzu "{$a->fullname}". Prosím, skúste sa prihlásiť do kurzu o niekoľko sekúnd. Ak problém pretrváva, oznámte to prosím {$a->teacher} alebo administrátorovi stránky.';
$string['paymentthanks'] = 'Ďakujeme za Vašu platbu! Teraz ste zapísaný do kurzu:<br />"{$a}"';
$string['pendingrequests'] = 'Nespracované žiadosti';
$string['periodending'] = 'Obdobie končí ({$a})';
$string['perpage'] = 'Na stranu';
$string['perpagea'] = 'Na stranu: {$a}';
$string['personal'] = 'Osobný';
$string['personalprofile'] = 'Osobný profil';
$string['phone'] = 'Telefón';
$string['phone2'] = 'Mobil';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = 'Obrázok: {$a}';
$string['pictureofuser'] = 'Obrázok používateľa';
$string['pleaseclose'] = 'Prosím zavrite toto okno.';
$string['pleasesearchmore'] = 'Prosím pokračujte vo vyhľadávaní';
$string['pleaseusesearch'] = 'Prosím použite vyhľadávanie';
$string['plugin'] = 'Zásuvný modul';
$string['plugincheck'] = 'Kontrola zásuvných modulov';
$string['plugindeletefiles'] = 'Všetky údaje prepojené s pluginom \'{$a->name}\' boli vymazané z databázy.  Aby ste predišli opätovnej samoinštalácii pluginu, mali by ste zo serveru vymazať nasledujúci adresár: {$a->directory}.  ';
$string['pluginsetup'] = 'Nastavenie tabuliek zásuvných modulov';
$string['policyaccept'] = 'Rozumiem a súhlasím';
$string['policyagree'] = 'Najprv musíte súhlasiť s podmienkami používania tejto stránky. Súhlasíte s nimi?';
$string['policyagreement'] = 'Súhlas s podmienkami portálu';
$string['policyagreementclick'] = 'Odkaz na podmienky a politiku portálu';
$string['popup'] = 'vyskakovacie (popup) okno';
$string['popupwindow'] = 'Otvoriť súbor v novom okne';
$string['popupwindowname'] = 'Vyskakovacie (popup) okno';
$string['post'] = 'Diskusný príspevok';
$string['posts'] = 'Diskusné príspevky';
$string['potentialadmins'] = 'Potenciálni administrátori';
$string['potentialcreators'] = 'Potenciálni tvorcovia kurzov';
$string['potentialstudents'] = 'Potenciálni študenti';
$string['potentialteachers'] = 'Potenciálni učitelia';
$string['preferences'] = 'Preferencie';
$string['preferredlanguage'] = 'Preferovaný jazyk';
$string['preferredtheme'] = 'Preferovaná téma';
$string['preprocessingbackupfile'] = 'Pripravujem súbor so zálohou';
$string['prev'] = 'Predchádzajúci';
$string['preview'] = 'Náhľad';
$string['previewhtml'] = 'Náhľad HTML formátu';
$string['previeworchoose'] = 'Prehliadať, alebo vybrať tému';
$string['previous'] = 'Predchádzajúci';
$string['previouslyselectedusers'] = 'Predošle vybraný používatelia sa nezhodujú s \'{$a}\'';
$string['previoussection'] = 'Predchádzajúca sekcia';
$string['primaryadminsetup'] = 'Nastavenie účtu administrátora';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Tento profil nebude zobrazený dovtedy, kým nebude tento používateľ zapísaný minimálne do jedného kurzu.';
$string['publicprofile'] = 'Verejný profil';
$string['publicsitefileswarning'] = 'Upozornenie: súbory tu umiestnené budú prístupné pre každého';
$string['publicsitefileswarning2'] = 'Poznámka: súbory tu uložené sú dostupné každému, kto pozná, alebo uhádne URL. Z dôvodov bezpečnosti je doporučované, aby boli súbory záloh okamžite vymazané potom, čo boli obnovené.';
$string['publicsitefileswarning3'] = 'Poznámka: Tu uložené súbory sú dostupné pre každého, kto vie (alebo uhádne) URL. <br />Z dôvodov bezpečnosti by mali byť súbory so zálohami uložené iba v bezpečnom adresári backupdata.';
$string['publish'] = 'Zverejniť';
$string['question'] = 'Otázka';
$string['questionsinthequestionbank'] = 'Otázky v banke otázok';
$string['readinginfofrombackup'] = 'Načítať informácie zo zálohy';
$string['readme'] = 'Čítaj ma';
$string['recentactivity'] = 'Aktuálna činnosť';
$string['recentactivityreport'] = 'Kompletná správa o Vašej aktuálnej činnosti';
$string['recipientslist'] = 'Zoznam príjemcov';
$string['recreatedcategory'] = 'Znovuvytvorená kategória {$a}';
$string['redirect'] = 'Presmerovať';
$string['reducesections'] = 'Znížiť počet sekcií';
$string['refresh'] = 'Obnoviť';
$string['refreshingevents'] = 'Obnovujú sa udalosti';
$string['registration'] = 'Registrácia Moodle';
$string['registrationcontact'] = 'Kontakt pre verejnosť';
$string['registrationcontactno'] = 'Nie, nechcem kontaktný formulár vo výpise web stránok';
$string['registrationcontactyes'] = 'Áno, poskytnem formulár pre budúcich používateľov Moodle, aby ma mohli kontaktovať';
$string['registrationemail'] = 'Oznámenia cez e-mail';
$string['registrationinfo'] = '<p>Táto stránka dovoľuje registrovať Vašu Moodle
www stránku na domovskej stránke Moodle (moodle.org). Registrácia je bezplatná. Hlavnou výhodou registrácie je, že budete pridaní do slabo frekventovanej mail-konferencie, kde budú oznamované dôležité informácie (napr.problémy s bezpečnosťou alebo oznamy o nových verziách Moodle).</p>
<p>Vaše informácie budú len pre potrebu vývoja Moodle a nebudú šírené tretím osobám. Využijeme ich len na účely grantovej podpory a zisťovania štatistických údajov o Moodle komunite ako celku.</p>
<p>Ak chcete, môžete povoliť pridanie Vašej URL adresy, mena www stránky a krajiny do verejného zoznamu Moodle stránok.</p>
<p>Všetky nové registrácie sú overované manuálne predtým, než sú zaradené do zoznamu. Ak ste už zaradení, môžete kedykoľvek aktualizovať Vaše registračné odoslaním vyplneného formulára.</p>';
$string['registrationinfotitle'] = 'Informácie o registrácii';
$string['registrationno'] = 'Nie, nechcem dostávať e-maily';
$string['registrationsend'] = 'Poslať registračné informácie na domovskú stránku Moodle (moodle.org)';
$string['registrationyes'] = 'Áno, informujte ma o dôležitých Moodle udalostiach';
$string['reject'] = 'Odmietnuť';
$string['rejectdots'] = 'Zamietnuť...';
$string['reload'] = 'Reload';
$string['remoteappuser'] = 'Vzdialený používateľ {$a}';
$string['remove'] = 'Odstrániť';
$string['removeadmin'] = 'Odstrániť administrátora';
$string['removecreator'] = 'Odstrániť tvorcu kurzov';
$string['removestudent'] = 'Odstrániť študenta';
$string['removeteacher'] = 'Odstrániť učiteľa';
$string['rename'] = 'Premenovať';
$string['renamefileto'] = 'Premenovať <b>{$a}</b> na';
$string['report'] = 'Záznamy';
$string['reports'] = 'Záznamy';
$string['repositories'] = 'Úložiská';
$string['requestcourse'] = 'Požiadať o vytvorenie nového kurzu';
$string['requestedby'] = 'Žiadané kým';
$string['requestedcourses'] = 'Žiadané kurzy';
$string['requestreason'] = 'Dôvod žiadosti';
$string['required'] = 'Požadované';
$string['requirespayment'] = 'Tento kurz vyžaduje zaplatenie poplatku pre vstup';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Vyčistenie kurzu';
$string['resetinfo'] = 'Táto stránka dovoľuje vymazať užívateľské údaje z kurzu pri uchovaní aktivít a ostatných nastavení. Prosím všimnite si výber položiek nižšie. Ktoré z nich vyznačíte, tie budú navždy odstránené.';
$string['resetnotimplemented'] = 'Reset nie je implementovaný';
$string['resetstartdate'] = 'Vyčistiť začiatočný dátum';
$string['resetstatus'] = 'Stav';
$string['resettask'] = 'Úloha';
$string['resettodefaults'] = 'Prestaviť na predvolené hodnoty';
$string['resortbyfullname'] = 'Podľa celého názvu';
$string['resortbyidnumber'] = 'Podľa identifikátora';
$string['resortbyshortname'] = 'Podľa krátkeho názvu';
$string['resortcourses'] = 'Zoradiť kurzy';
$string['resortsubcategoriesbyidnumber'] = 'Usporiadať podkategórie podľa identifikátora';
$string['resortsubcategoriesbyname'] = 'Usporiadať podkategórie podľa názvu';
$string['resource'] = 'Zdroj';
$string['resourcedisplayauto'] = 'Automaticky';
$string['resourcedisplaydownload'] = 'Vynútiť stiahnutie';
$string['resourcedisplayembed'] = 'Vložiť';
$string['resourcedisplayframe'] = 'V rámci';
$string['resourcedisplaynew'] = 'Nové okno';
$string['resourcedisplayopen'] = 'Otvoriť';
$string['resourcedisplaypopup'] = 'V novom okne';
$string['resources'] = 'Zdroje';
$string['resources_help'] = 'Rozličné zdroje umožňujú vloženie skoro ľubovoľného web obsahu do kurzu.';
$string['restore'] = 'Obnoviť zo zálohy';
$string['restorecancelled'] = 'Obnova zrušená';
$string['restorecannotassignroles'] = 'Pri obnove je potrebné priradiť roly a nemáte na to oprávnenie.';
$string['restorecannotcreateorassignroles'] = 'Pri obnove je potrebné vytvoriť alebo priradiť roly a nemáte na to oprávnenie.';
$string['restorecannotcreateuser'] = 'Obnova kurzu zo zálohovacieho súboru potrebuje vytvoriť používateľa \'{$a}\' a vy na to nemáte oprávnenie.';
$string['restorecannotoverrideperms'] = 'Pri obnove je potrebné prepísať oprávnenia a nemáte na to oprávnenie.';
$string['restorecoursenow'] = 'Obnoviť tento kurz teraz!';
$string['restoredaccount'] = 'Obnovené konto';
$string['restoredaccountinfo'] = 'Toto heslo bolo importované z iného servera, pričom sa nezachovalo heslo. Pre nastavenie nového hesla pomocou mailu kliknite na "Pokračovať".';
$string['restorefinished'] = 'Obnova prebehla úspešne';
$string['restoreto'] = 'Obnoviť do';
$string['restoretositeadding'] = 'Upozornenie: Chystáte sa obnoviť titulnú stránku portálu a pridať k údaje k existujúcej!';
$string['restoretositedeleting'] = 'Upozornenie: Chystáte sa obnoviť titulnú stránku portálu a predtým vymazať údaje existujúcej!';
$string['restoreuserconflict'] = 'Pokus o obnovenie používateľa \'{$a}\' zo zálohovacieho súboru spôsobí konflikt.';
$string['restoreuserinfofailed'] = 'Proces obnovy kurzu bol zastavený, pretože nemáte oprávnenie obnoviť údaje používateľov.';
$string['restoreusersprecheck'] = 'Kontrolovanie používateľských údajov';
$string['restoreusersprecheckerror'] = 'Pri kontrole používateľských údajov boli zistené problémy';
$string['restricted'] = 'Obmedzený';
$string['returningtosite'] = 'Vrátiť sa na túto webovú stránku?';
$string['returntooriginaluser'] = 'Návrat na {$a}';
$string['revert'] = 'Vrátiť';
$string['role'] = 'Rola';
$string['roleassignments'] = 'Priradenie rol';
$string['rolemappings'] = 'Mapovania rol';
$string['rolerenaming'] = 'Premenovanie rol';
$string['rolerenaming_help'] = 'Táto voľba umožňuje zmeniť zobrazované názvy rol použité v kurze. Zmení sa iba zobrazované meno, samotný systém rol a oprávnení sa tým nemení.
Tieto nové názvy rol sú zobrazené na stránke účastníkov kurzu a inde v kurze. Ak premenovaná rola je tá, ktorú administrátor určí ako správcu kurzu, názov sa tiež zjaví v zozname kurzov.';
$string['roles'] = 'Roly';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Počet aktuálnych RSS článkov';
$string['rsserror'] = 'Chyba pri čítaní RSS údajov';
$string['rsserrorauth'] = 'Váš RSS odkaz neobsahuje platný autentifikačný token';
$string['rsserrorguest'] = 'K tomuto zdroju správ pristupujete ako anonymní hostia. Tí ale nemajú právo čítať správy. Navštívte originálnu adresu zdroja týchto správ (URL) ako oprávnený užívateľ a získajte nový odkaz pre tento zdroj.';
$string['rsskeyshelp'] = 'Pre zaistenie ochrany a súkromia, odkazy RSS správ obsahujú špeciálny token, ktorý identifikuje užívateľa, pre ktorého sú určené. Toto zabráni ostatným užívateľom pred vstupom do oblastí Moodle, kde by tento prístup cez RSS nemali.</p><p>Tento token je automaticky vytvorený pri prvom vstupe do oblasti Moodle, ktorá produkuje RSS správy. V prípade, že Váš RSS token bol nejakým spôsobom ohrozený, môžete si vyžiadať nový, kliknutím na Resetovať odkaz. Po vygenerovaní nového tokenu budú všetky existujúce odkazy neplatné.';
$string['rsstype'] = 'RSS kanály pre túto aktivitu';
$string['saveandnext'] = 'Uložiť a ísť ďalej';
$string['savechanges'] = 'Uložiť zmeny';
$string['savechangesanddisplay'] = 'Uložiť a zobraziť';
$string['savechangesandreturntocourse'] = 'Uložiť a návrat do kurzu';
$string['savecomment'] = 'Uložiť komentár';
$string['savedat'] = 'Uložené:';
$string['savepreferences'] = 'Uložiť preferencie';
$string['saveto'] = 'Uložiť do';
$string['scale'] = 'Stupnica';
$string['scale_help'] = '<p>Učitelia môžu vytvárať pre hodnotenie jednotlivých činností v kurze vlastné
stupnice.</p>

<p>Názvom stupnice by malo byť slovné spojenie, ktoré ju jasne opisuje; názov sa
zobrazuje v zoznamoch pre výber stupnice a tiež na tlačidlách kontextovej
nápovedy.</p>

<p>Stupnica sama o sebe je definovaná vzostupným rozsahom hodnotenia, v ktorom sú
po jednom položky oddelené čiarkami. Príklad:</p>

<p class="indent">
  <i>Neuspokojivý, Dostatočný, Priemerný, Dobrý, Veľmi dobrý, Vynikajúci</i>
</p>

<p>Stupnice by mali tiež obsahovať opis jednotlivých stupňov hodnotenia a ich
použitia v praxi. Tento popis sa bude zobrazovať na stránkach nápovedy.</p>

<p>Vaše stránky môžu tiež mať jednu alebo viac "štandardných" stupníc, ktoré pre
celý systém definuje administrátor. Tieto stupnice budú k dispozícii vo všetkých
kurzoch.</p>';
$string['scales'] = 'Stupnice';
$string['scalescustom'] = 'Vlastná stupnica';
$string['scalescustomcreate'] = 'Pridať novú stupnicu';
$string['scalescustomno'] = 'Zatiaľ nebola vytvorená žiadna vlastná stupnica';
$string['scalesstandard'] = 'Štandardná stupnica';
$string['scalestandard'] = 'Štandardná stupnica';
$string['scalestandard_help'] = '<p>Štandardná stupnica je tá, ktorá je dostupná a použiteľná pre všetky kurzy.</p>';
$string['scalestip'] = 'Na vytvorenie vlastnej stupnice, použite odkaz \'Stupnice...\' vo Vašom administrátorskom menu kurzu.';
$string['scalestip2'] = 'Ak chcete vytvoriť vlastné stupnice, kliknite na odkaz Známky v bloku Administratíva a zvoľte si v menu príkaz Upraviť, Stupnice.';
$string['schedule'] = 'Zoznam';
$string['screenshot'] = 'Snímok obrazovky';
$string['search'] = 'Hľadať';
$string['searchagain'] = 'Hľadať opäť';
$string['searchbyemail'] = 'Vyhľadávať podľa emailovej adresy';
$string['searchbyusername'] = 'Vyhľadávať podľa používateľského mena';
$string['searchcourses'] = 'Vyhľadať kurzy';
$string['searchhelp'] = 'Môžete vyhľadávať viaceré slovné spojenia naraz.<br />
slovo: vyhľadá toto slovo vo vnútri textu.<br />
+slovo: vyhľadá iba presný výraz.<br />
-slovo: nezobrazí výsledky obsahujúce toto slovo.';
$string['search_help'] = 'Pre jednoduché vyhľadávanie jedného alebo viacerých slov hocikde v texte ich zadajte oddelené medzerami. Budú použité všetky, ktoré majú viac ako dva znaky.';
$string['searchoptions'] = 'Možnosti vyhľadávania';
$string['searchresults'] = 'Výsledky hľadania';
$string['sec'] = 'sekunda';
$string['seconds'] = 'sekundy';
$string['secondstotime172800'] = '2 dni';
$string['secondstotime259200'] = '3 dni';
$string['secondstotime345600'] = '4 dni';
$string['secondstotime432000'] = '5 dní';
$string['secondstotime518400'] = '6 dní';
$string['secondstotime604800'] = '1 týždeň';
$string['secondstotime86400'] = '1 deň';
$string['secretalreadyused'] = 'Odkaz na potvrdenie zmeny hesla už bol použitý. Heslo nebolo zmenené.';
$string['secs'] = 'sekundy/sekúnd';
$string['section'] = 'Sekcia';
$string['sectionname'] = 'Názov sekcie';
$string['sections'] = 'Sekcie';
$string['sectionusedefaultname'] = 'Použiť východzí názov sekcie';
$string['seealsostats'] = 'Viď tiež: štatistiky';
$string['selctauser'] = 'Vyberte používateľa';
$string['select'] = 'Vybrať';
$string['selectacategory'] = 'Vyberte kategóriu';
$string['selectacountry'] = 'Vybrať krajinu';
$string['selectacourse'] = 'Vyberte kurz';
$string['selectacoursesite'] = 'Vyberte kurz alebo portál';
$string['selectagroup'] = 'Vyberte skupinu';
$string['selectall'] = 'Vybrať všetko';
$string['selectamodule'] = 'Prosím vyberte modul aktivity';
$string['selectanaction'] = 'Vyberte akciu';
$string['selectanoptions'] = 'Vyberte možnosť';
$string['selectaregion'] = 'Vybrať oblasť';
$string['selectcategorysort'] = 'Ktoré kategórie si prajete triediť?';
$string['selectcategorysortby'] = 'Vyberte, ako chcete triediť kategórie';
$string['selectcoursesortby'] = 'Vyberte, ako chcete triediť kurzy';
$string['selectdefault'] = 'Vyberte predvolený';
$string['selectedcategories'] = 'Vybrané kategórie';
$string['selectedfile'] = 'Vybraný súbor';
$string['selectednowmove'] = '{$a} súbory označené pre presun. Teraz prejdite na cieľové miesto a stlačte \'Presunúť súbory sem\'';
$string['selectfiles'] = 'Vybrať súbory';
$string['selectmoduletoviewhelp'] = 'Vyberte modul z ponuky pre zobrazenie jeho opisu a nápovedy';
$string['selectnos'] = 'Vybrať všetky \'nie\'';
$string['selectperiod'] = 'Vybrať obdobie';
$string['senddetails'] = 'Posielať moje údaje prostredníctvom emailu';
$string['separate'] = 'Individuálne';
$string['separateandconnected'] = 'Individuálne a vzťahové spôsoby poznávania';
$string['separateandconnectedinfo'] = 'Stupnica založená na teórii individuálneho a vzťahového poznávania. Táto teória opisuje dva nezávislé spôsoby, ako môžeme hodnotiť a učiť sa o veciach, ktoré vidíme alebo počujeme.
<ul>
<li><strong>Individuálne poznávanie</strong> ostáva čo najobjektívnejšie bez zahnutia pocitov a emócií. V diskusiách s inými ľuďmi takíto účastníci zvyčajne obhajujú svoje idey a využívajú diery v protivníkovej argumentácii.</li>
<li><strong>Vzťahové poznávanie</strong> charakterizuje ľudí citlivejších k ostatným. Sú zruční v empatii a väčšinou zvyknú počúvať a spytovať sa, až kým nechápu podstatu a "nerozumejú veci z ich smeru pohľadu". Učia sa snahou zdieľať skúsenosti, ktoré ich priviedli k vedomostiam naučeným od iných ľudí. </li>
</ul>';
$string['servererror'] = 'V komunikácii so serverom sa vyskytla chyba';
$string['serverlocaltime'] = 'Miestny čas serveru';
$string['setcategorytheme'] = 'Vybrať tému kategórie';
$string['setpassword'] = 'Nastaviť heslo';
$string['settings'] = 'Nastavenia';
$string['shortname'] = 'Skrátené meno';
$string['shortnamecollisionwarning'] = '[*] = Táto skratka je už použitá v inom kurze a musí byť zmenená.';
$string['shortnamecourse'] = 'Skrátené meno kurzu';
$string['shortnamecourse_help'] = '<p>Mnohé organizácie používajú skratky pre označenie kurzu napr. BP102
alebo COMMS.  Ak ešte nemáte takúto skratku pre váš kurz, vytvorte si
ju. Táto bude použitá v kurze na viacerých miestach a to tam, kde nie
je možné použiť dlhý názov kurzu. (napríklad v predmete e-mailu).</p>';
$string['shortnametaken'] = 'Krátke meno je už použité pre iný kurz ({$a})';
$string['shortnameuser'] = 'Krátke používateľské meno';
$string['shortsitename'] = 'Skrátený názov stránky  (napr. jedno slovo)';
$string['show'] = 'Zobraziť';
$string['showactions'] = 'Ukázať možnosti';
$string['showadvancedsettings'] = 'Zobraziť rozšírené nastavenia';
$string['showall'] = 'Zobraziť všetky {$a}';
$string['showallcourses'] = 'Zobraziť všetky kurzy';
$string['showallusers'] = 'Zobraziť všetkých používateľov';
$string['showblockcourse'] = 'Zobraziť zoznam kurzov s blokmi';
$string['showcategory'] = 'Zobraziť {$a}';
$string['showcomments'] = 'Ukázať/skryť komentáre';
$string['showcommentsnonjs'] = 'Ukázať komentáre';
$string['showdescription'] = 'Zobraziť opis na titulnej stránke kurzu';
$string['showdescription_help'] = 'Či sa má vyššie vložený úvodný opis zobraziť na stránke kurzu pod odkazom na príslušnú aktivitu alebo študijného materiálu.';
$string['showgrades'] = 'Zobraziť študentom výkaz známok';
$string['showgrades_help'] = '<p>Väčšinu činností v kurze možno známkovať.</p>

<p>Vo východzom nastavení možno všetky známky v kurze nájsť na stránke
&quot;Známky&quot;, dostupné z hlavnej stránky kurzu.</p>

<p>Ak učiteľ nechce študentov v kurze známkovať, alebo nechce, aby
študenti videli známkový výkaz, môže voľbu &quot;Zobraziť študentom výkaz známok&quot; v
nastavení kurzu vypnúť. Toto nastavenie nebráni učiteľovi, aby
činnosti známkoval, iba neumožňuje študentom, aby si známky mohli
prezerať.</p>';
$string['showingacourses'] = 'Ukázať všetky {$a} kurzy';
$string['showingxofycourses'] = 'Ukázať kurzy od {$a->start} do {$a->end} z {$a->total} kurzov';
$string['showlistofcourses'] = 'Zobraziť zoznam kurzov';
$string['showmodulecourse'] = 'Zobraziť zoznam kurzov s aktivitami';
$string['showonly'] = 'Zobraziť iba';
$string['showperpage'] = 'Zobraziť {$a} na jednej stránke';
$string['showrecent'] = 'Zobraziť aktuálnu činnosť';
$string['showreports'] = 'Zobraziť správu o aktivitách';
$string['showreports_help'] = '<p>Pre každého účastníka kurzu sú vedené "Správy o aktivitách", ktoré zachycujú
jeho činnosti v kurze. Okrem prehľadu jeho príspevkov do kurzu obsahuje tento
protokol aj podrobné záznamy o jeho prihláseniach a prístupoch k jednotlivým
častiam kurzu.</p>

<p>Prístup k týmto údajom je umožnený učiteľovi cez tlačidlo umiestnené na stránke
osobného profilu každého študenta.</p>

<p>O prístupe študenta k jeho záznamom rozhoduje učiteľ v nastavení kurzu. V
nektorých kurzoch môže byť protokol o činnosti pre študenta prínosný, pretože mu
umožní sledovať jeho zapojenie do činnosti v kurzu; u iných kurzov nie je jeho
sprístupnenie nutné.</p>

<p>Ďalším možným dôvodom pre vypnutie tejto funkcie je zvýšené zaťaženie systému
pri vytváraní správ. Ak je v kurze veľký počet študentov alebo ak prebieha
kurz dlho, je lepšie túto funkciu vypnúť.</p>';
$string['showsettings'] = 'Zobraziť nastavenia';
$string['showtheselogs'] = 'Zobraziť tieto prihlásenia';
$string['showthishelpinlanguage'] = 'Ukázať túto nápovedu v jazyku: {$a}';
$string['since'] = 'Od';
$string['sincelast'] = 'od posledného prihlásenia';
$string['site'] = 'Portál';
$string['sitedefault'] = 'Východzia stránka portálu';
$string['siteerrors'] = 'Chyby na stránke';
$string['sitefiles'] = 'Súbory stránky';
$string['sitefilesused'] = 'Súbory portálu použité v tomto kurze';
$string['sitehome'] = 'Domovská stránka';
$string['sitelegacyfiles'] = 'Zdedené (legacy) súbory portálu';
$string['sitelogs'] = 'Záznamy o prihláseniach na stránku';
$string['sitenews'] = 'Miestne správy stránky pre všetkých používateľov';
$string['sitepages'] = 'Stránky portálu';
$string['sitepartlist'] = 'Nemáte požadované oprávnenie prezerať zoznam účastníkov';
$string['sitepartlist0'] = 'Musíte byť učiteľom stránky, aby ste si mohli prezerať zoznam účastníkov stránky';
$string['sitepartlist1'] = 'Musíte byť učiteľom, aby ste si mohli prezerať zoznam účastníkov stránky';
$string['sites'] = 'Stránky';
$string['sitesection'] = 'Zahrnúť tématickú sekciu';
$string['sitesettings'] = 'Miestne nastavenia';
$string['siteteachers'] = 'Učitelia stránky';
$string['size'] = 'Veľkosť';
$string['sizeb'] = 'bajty';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Preskočené';
$string['skiptocategorylisting'] = 'Prejsť na zoznam kategórií';
$string['skiptocoursedetails'] = 'Prejsť na podrobné informácie o kurze';
$string['skiptocourselisting'] = 'Prejsť na zoznam kurzov';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Sociálne fórum - posledné témy';
$string['someallowguest'] = 'Niektoré kurzy môžu povoliť vstup hostí';
$string['someerrorswerefound'] = 'Niektoré informácie chýbali, alebo neboli správne. Pozrite nižšie pre podrobnosti.';
$string['sort'] = 'Roztriediť';
$string['sortby'] = 'Roztriediť podľa';
$string['sortbyx'] = 'Roztriediť podľa {$a} vzostupne';
$string['sortbyxreverse'] = 'Roztriediť podľa {$a} zostupne';
$string['sortcategoriesbyidnumber'] = 'Triedenie kategórií podľa ich identifikátora';
$string['sortcategoriesbyname'] = 'Triedenie kategórií podľa ich názvu';
$string['sortcoursesbyfullname'] = 'Triedenie kurzu podľa celého názvu';
$string['sortcoursesbyidnumber'] = 'Triedenie kurzu podľa identifikátora';
$string['sortcoursesbyshortname'] = 'Triedenie kategórií podľa krátkeho názvu';
$string['sorting'] = 'Triedenie';
$string['sourcerole'] = 'Zdrojová rola';
$string['specifyname'] = 'Musíte uviesť meno.';
$string['standard'] = 'Štandardný';
$string['starpending'] = '([*] = kurz čaká na akceptáciu)';
$string['startdate'] = 'Dátum začiatku kurzu';
$string['startdate_help'] = 'Toto nastavenie určuje začiatok prvého týždňa v kurze, ktorý je v týždňovom formáte. Tiež určuje najskorší dátum, od ktorého sú dostupné záznamy kurzu. ';
$string['startingfrom'] = 'Začínajúci z';
$string['startsignup'] = 'Začnite teraz vytvorením nového účtu!';
$string['state'] = 'Štát/VÚC';
$string['statistics'] = 'Štatistika';
$string['statisticsgraph'] = 'Graf štatistík';
$string['stats'] = 'Štatistika';
$string['statslogins'] = 'Prihlásenia';
$string['statsmodedetailed'] = 'Detailný (používateľský) pohľad';
$string['statsmodegeneral'] = 'Všeobecný pohľad';
$string['statsnodata'] = 'Pre túto kombináciu kurzu a časového intervalu nie sú v databáze žiadne údaje.';
$string['statsnodatauser'] = 'Pre túto kombináciu kurzu, používateľa a časového intervalu nie sú v databáze žiadne údaje.';
$string['statsoff'] = 'Štatistiky nie sú v súčasnosti povolené';
$string['statsreads'] = 'Pohľady';
$string['statsreport1'] = 'Prihlásenia';
$string['statsreport10'] = 'Aktivita používateľov';
$string['statsreport11'] = 'Najaktívnejšie kurzy';
$string['statsreport12'] = 'Najaktívnejšie kurzy (vážené)';
$string['statsreport13'] = 'Najviac používateľov (v kurze)';
$string['statsreport14'] = 'Najviac používateľov (pohľady/diskusie)';
$string['statsreport2'] = 'Náhľady (učitelia a študenti)';
$string['statsreport3'] = 'Diskusie (učitelia a študenti)';
$string['statsreport4'] = 'Všetky aktivity (učitelia a študenti)';
$string['statsreport5'] = 'Všetky študentské aktivity (pohľady a diskusie)';
$string['statsreport7'] = 'Používateľské aktivity (pohľady a diskusie)';
$string['statsreport8'] = 'Všetky aktivity používateľa';
$string['statsreport9'] = 'Prihlásenia (na portáli)';
$string['statsreportactivity'] = 'Všetky aktivity (učitelia a študenti)';
$string['statsreportactivitybyrole'] = 'Všetky aktivity (pohľady a diskusie)';
$string['statsreportforuser'] = 'pre';
$string['statsreportlogins'] = 'Prihlásenia';
$string['statsreportreads'] = 'Všetky aktivity (učitelia a študenti)';
$string['statsreporttype'] = 'Typ záznamov';
$string['statsreportwrites'] = 'Diskusie (učitelia a študenti)';
$string['statsstudentactivity'] = 'Študentské aktivity';
$string['statsstudentreads'] = 'Študentské náhľady';
$string['statsstudentwrites'] = 'Študentské diskusie';
$string['statsteacheractivity'] = 'Učiteľské aktivity';
$string['statsteacherreads'] = 'Učiteľské náhľady';
$string['statsteacherwrites'] = 'Učiteľské diskusie';
$string['statstimeperiod'] = 'Obdobie - posledné:';
$string['statsuniquelogins'] = 'Jedinečné prihlásenia';
$string['statsuseractivity'] = 'Všetky aktivity';
$string['statsuserlogins'] = 'Prihlásenia';
$string['statsuserreads'] = 'Náhľady';
$string['statsuserwrites'] = 'Diskusie';
$string['statswrites'] = 'Príspevky';
$string['status'] = 'Status';
$string['stringsnotset'] = 'Nasledovné spojenia nie sú definované v {$a}';
$string['studentnotallowed'] = 'Prepáčte, nemôžete vstúpiť do tohto kurzu ako \'{$a}\'';
$string['students'] = 'Študenti';
$string['studentsandteachers'] = 'Študenti a učitelia';
$string['subcategories'] = 'Podkategórie';
$string['subcategory'] = 'Podkategória';
$string['subcategoryof'] = 'Podkategória {$a}';
$string['submit'] = 'Odovzdať';
$string['success'] = 'Úspech';
$string['summary'] = 'Zhrnutie';
$string['summary_help'] = '<p>Súhrn je krátky text, ktorý by mal pripraviť študentov na činnosť v rámci
danej témy/týždňa.</p>

<p>Súhrn by mal byť čo najkratší, aby sa hlavná stránka kurzu neúmerne
nepredlžovala.</p>

<p>Ak sa domnievate, že daná téma vyžaduje podrobnejší opis, môže byť
vhodnejšie uložiť ho ako samostatný materiál a do témy vložiť iba
odkaz.</p>';
$string['summaryof'] = 'Zhrnutie z  {$a}';
$string['supplyinfo'] = 'Viac informácií';
$string['suspended'] = 'Pozastavený';
$string['suspendedusers'] = 'Pozastavení používatelia';
$string['switchdevicedefault'] = 'Prepnúť na štandardnú tému';
$string['switchdevicerecommended'] = 'Prepnúť na odporúčanú tému pre Vaše zaradenie';
$string['switchrolereturn'] = 'Návrat do mojej pôvodnej roly';
$string['switchroleto'] = 'Prepnúť rolu na ...';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Toto kľúčové slovo už existuje';
$string['tagmanagement'] = 'Pridať/vymazať tagy';
$string['tags'] = 'Tagy';
$string['targetrole'] = 'Cieľová rola';
$string['teacheronly'] = 'iba pre {$a}';
$string['teacherroles'] = '{$a} úlohy';
$string['teachers'] = 'Učitelia';
$string['textediting'] = 'Textový editor';
$string['texteditor'] = 'Používajte štandardné webové formáty';
$string['textformat'] = 'Čisto textový formát';
$string['thanks'] = 'Vďaka';
$string['theme'] = 'Téma';
$string['themes'] = 'Témy';
$string['themesaved'] = 'Nová téma uložená';
$string['therearecourses'] = 'Existuje {$a} kurzov';
$string['thereareno'] = 'V tomto kurze nie sú žiadne {$a}';
$string['thiscategory'] = 'Táto kategória';
$string['thiscategorycontains'] = 'Táto kategórie obsahuje';
$string['time'] = 'Čas';
$string['timezone'] = 'Časové pásmo';
$string['to'] = 'Do';
$string['tocontent'] = 'Na položku "{$a}"';
$string['tocreatenewaccount'] = 'Preskočiť na vytvorenie nového konta ';
$string['today'] = 'Dnes';
$string['todaylogs'] = 'Dnešné záznamy o prihláseniach';
$string['toeveryone'] = 'pre všetkých';
$string['toomanybounces'] = 'Táto emailová adresa má veľa chýb. <b>Musíte</b>ju opraviť, aby ste mohli ďalej pokračovať.';
$string['toomanytoshow'] = 'Je priveľa používateľov, aby mohli byť zobrazení';
$string['toomanyusersmatchsearch'] = 'Príliš veľa používateľov ({$a->count}) vyhovuje \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Príliš veľa používateľov ({$a}) na zobrazenie';
$string['toonly'] = 'iba pre {$a}';
$string['top'] = 'Vrch';
$string['topic'] = 'Téma';
$string['topichide'] = 'Ukryť túto položku od  {$a}';
$string['topicoutline'] = 'Prehľad témy';
$string['topicshow'] = 'Ukázať túto položku {$a}';
$string['toplevelcategory'] = 'Kategória najvyššej úrovne';
$string['total'] = 'Spolu';
$string['totopofsection'] = 'Na začiatok sekcie "{$a}"';
$string['trackforums'] = 'Sledovanie fór';
$string['trackforumsno'] = 'Nie: nezachovaj sledovanie príspevkov ktoré som už videl';
$string['trackforumsyes'] = 'Áno: zvýrazni pre mňa nové príspevky';
$string['trysearching'] = 'Skúste vyhľadávanie namiesto toho';
$string['turneditingoff'] = 'Vypnúť upravovanie';
$string['turneditingon'] = 'Zapnúť upravovanie';
$string['undecided'] = 'Nerozhodnutý';
$string['unfinished'] = 'Neukončený';
$string['unknowncategory'] = 'Neznáma kategória';
$string['unknownerror'] = 'Neznáma chyba';
$string['unlimited'] = 'Neohraničený';
$string['unpacking'] = 'Rozbaľujem  {$a}';
$string['unsafepassword'] = 'Heslo nie je bezpečné - skúste niečo iné';
$string['untilcomplete'] = 'Kým neukončí';
$string['unusedaccounts'] = 'Kontá nepoužívané viac než {$a} dní sú automaticky odhlásené';
$string['unzip'] = 'Rozbaliť';
$string['unzippingbackup'] = 'Rozzipovať zálohu';
$string['up'] = 'Hore';
$string['update'] = 'Aktualizovať';
$string['updated'] = 'Aktualizované {$a}';
$string['updatemymoodleoff'] = 'Koniec úprav stránky';
$string['updatemymoodleon'] = 'Začiatok úprav stránky';
$string['updatemyprofile'] = 'Aktualizovať profil';
$string['updatesevery'] = 'Aktualizuje každých {$a} sekúnd';
$string['updatethis'] = 'Aktualizovať {$a}';
$string['updatethiscourse'] = 'Aktualizovať tento kurz';
$string['updatinga'] = 'Aktualizácia: {$a}';
$string['updatingain'] = 'Aktualizácia: {$a->what} v {$a->in}';
$string['upload'] = 'Preniesť';
$string['uploadafile'] = 'Preniesť súbor';
$string['uploadcantwrite'] = 'Nepodarilo sa zapísať súbor na disk';
$string['uploadedfile'] = 'Súbor bol úspešne prenesený';
$string['uploadedfileto'] = 'Preniesť {$a->file} do {$a->directory}';
$string['uploadedfiletoobig'] = 'Prepáčte, ale tento súbor je veľmi veľký (limit je {$a} bytov)';
$string['uploadextension'] = 'Nahranie súboru bolo zrušené nejakým PHP rozšírením';
$string['uploadfailednotrecovering'] = 'Váš prenos súboru nebol úspešný, pretože sa tu vyskytol problém s jedným z týchto súborov, {$a->name}.<br />
Tu je záznam tohto problému:<br />
{$a->problem}<br />
Proces sa už nebude opakovať';
$string['uploadfilelog'] = 'Preniesť záznam pre súbor {$a}';
$string['uploadformlimit'] = 'Prenášaný súbor {$a} prekročil povolenú nastavenú maximálnu veľkosť';
$string['uploadlabel'] = 'Nadpis:';
$string['uploadlimitwithsize'] = 'Rovnaké obmedzenie veľkosti ako pre: {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Nahrať nový súbor';
$string['uploadnofilefound'] = 'Nebol nájdený súbor - ste si istý, že ste nejaký vybrali na prenos?';
$string['uploadnotallowed'] = 'Prenosy nie sú povolené';
$string['uploadnotempdir'] = 'Chýbajúci dočasný adresár';
$string['uploadoldfilesdeleted'] = 'Starý súbor (súbory) boli vymazané';
$string['uploadpartialfile'] = 'Súbor bol prenesený len čiastočne';
$string['uploadproblem'] = 'Pri prenose súboru \'{$a}\' sa vyskytol neznámy problém (možno bol súbor príliš veľký)';
$string['uploadrenamedchars'] = 'Súbor bol premenovaný z {$a->oldname} na {$a->newname} kvôli neplatným znakom.';
$string['uploadrenamedcollision'] = 'Súbor bol premenovaný z {$a->oldname} na {$a->newname}, pretože sa tu vyskytol problém v mene súboru.';
$string['uploadserverlimit'] = 'Prenášaný súbor prekročil povolenú maximálnu veľkosť nastavenú serverom';
$string['uploadthisfile'] = 'Preniesť tento súbor';
$string['url'] = 'URL';
$string['used'] = 'Použitý';
$string['usedinnplaces'] = 'Použité v {$a} miestach';
$string['usemessageform'] = 'alebo použite formulár nižšie na zaslanie správy vyznačeným študentom';
$string['user'] = 'Používateľ';
$string['userconfirmed'] = 'Potvrdené {$a}';
$string['usercurrentsettings'] = 'Nastavenia môjho profilu';
$string['userdata'] = 'Údaje používateľa';
$string['userdeleted'] = 'Toto používateľské konto bolo odstránené';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'Toto pole umožňuje vložiť text, ktorý sa potom zobrazí vo vašom profile všetkých používateľom. ';
$string['userdetails'] = 'Podrobnosti používateľa';
$string['userfiles'] = 'Súbory používateľa';
$string['userlist'] = 'Zoznam používateľov';
$string['username'] = 'Používateľské meno';
$string['usernameemailmatch'] = 'Toto meno a mailová adresa nie sú pre jedného používateľa.';
$string['usernameexists'] = 'Toto používateľské meno už existuje, vyberte si nové';
$string['usernamelowercase'] = 'Sú povolené iba písmená malej abecedy';
$string['usernamenotfound'] = 'Meno používateľa nebolo nájdené v databáze';
$string['usernameoremail'] = 'Zadajte alebo login alebo email';
$string['usernotconfirmed'] = 'Nemožno potvrdiť {$a}';
$string['userpic'] = 'Obrázok používateľa';
$string['users'] = 'Používatelia';
$string['userselectorautoselectunique'] = 'Ak sa iba jeden používateľ zhoduje s vyhľadávaním,  ostatných zvoľte automaticky. ';
$string['userselectorpreserveselected'] = 'Uchovať zvolených používateľov, aj keď sa nezhodujú s vyhľadávaním';
$string['userselectorsearchanywhere'] = 'Hľadať text kdekoľvek v zobrazených poliach';
$string['usersnew'] = 'Noví používatelia';
$string['usersnoaccesssince'] = 'Zobraziť používateľov, ktorí neboli aktívni viac ako';
$string['userswithfiles'] = 'Používatelia so súbormi';
$string['useruploadtype'] = 'Typ nahrania používateľa: {$a}';
$string['userviewingsettings'] = 'Nastavenia profilu pre {$a}';
$string['userzones'] = 'Používateľské zóny';
$string['usetheme'] = 'Použiť tému';
$string['usingexistingcourse'] = 'Použiť existujúci kurz';
$string['valuealreadyused'] = 'Táto hodnota už bola použitá.';
$string['version'] = 'Verzia';
$string['view'] = 'Náhľad';
$string['viewallcourses'] = 'Zobraziť všetky kurzy';
$string['viewallcoursescategories'] = 'Zobraziť všetky kurzy a kategórie';
$string['viewallsubcategories'] = 'Zobraziť všetky podkategórie';
$string['viewfileinpopup'] = 'Zobraziť súbor v novom okne';
$string['viewing'] = 'Prehľad:';
$string['viewmore'] = 'Zobraziť viac';
$string['viewprofile'] = 'Zobraziť profil';
$string['views'] = 'Náhľady';
$string['viewsolution'] = 'prezrieť si riešenie';
$string['virusfound'] = 'Administrátor pozor! Clam AV našiel vírus v súbore prenášanom používateľom {$a->user} kurzu {$a->course}. Tu je výstup z clamscan:';
$string['virusfoundlater'] = 'Súbor, ktorý ste prenášali dňa {$a->date} s názvom {$a->filename} kurzu {$a->course} obsahoval vírus. Tu je správa z toho, čo sa stalo s Vaším súborom:

{$a->action}

Ak toto bolo Vaše vypracované zadanie úlohy, môžete ho poslať znovu, aby Vám ho mohol učiteľ skontrolovať.';
$string['virusfoundlateradmin'] = 'Administrátor pozor! Súbor, ktorý bol prenášaný dňa {$a->date} s názvom {$a->filename} kurzu {$a->course} obsahoval vírus. Tu je správa z toho, čo sa stalo s týmto súborom:

{$a->action}

Používateľ už bol o tom upozornený.';
$string['virusfoundlateradminnolog'] = 'Administrátor pozor! Bol prenášaný súbor s názvom {$a->filename}, ktorý obsahoval vírus. Moodle nebol schopný vrátiť ho späť k používateľovi, ktorý ho pôvodne prenášal.Tu je zoznam toho, čo sa stalo s týmto súborom:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Bol nájdený vírus!';
$string['virusfounduser'] = 'Súbor, ktorý ste prenášali, {$a->filename}, bol skenovaný antivírom a našiel v ňom vírus. Z tohto dôvodu NEBOL prenos Vášho súboru úspešný.';
$string['virusplaceholder'] = 'Súbor, ktorý bol prenášaný, obsahoval vírus a bol presunutý alebo odstránený. Používateľ bol už o tom upozornený.';
$string['visible'] = 'Viditeľné';
$string['visible_help'] = 'Táto voľba vám umožňuje kurz skryť, aby sa nezobrazoval v zozname kurzov. Vstúpiť doň potom môžu iba učitelia a administrátori.';
$string['visibletostudents'] = 'Viditeľné pre {$a}';
$string['warning'] = 'Upozornenie';
$string['warningdeleteresource'] = 'Upozornenie: Na {$a} sa odkazuje v inom zdroji. Prajete si ho aktualizovať?';
$string['webpage'] = 'Webová stránka';
$string['week'] = 'Týždeň';
$string['weekhide'] = 'Ukryť tento týždeň pred {$a}';
$string['weeklyoutline'] = 'Týždenný prehľad';
$string['weeks'] = 'týždňov';
$string['weekshow'] = 'Ukázať tento týždeň {$a}';
$string['welcometocourse'] = 'Vitajte v kurze {$a}';
$string['welcometocoursetext'] = 'Vitajte v kurze {$a->coursename}!

Jednou z prvých vecí, ktoré by ste mali urobiť, je úprava Vašej profilovej stránku v rámci kurzu, aby sme sa mohli o Vás niečo viac dozvedieť:

  {$a->profileurl}';
$string['whatforlink'] = 'Co chcete urobiť s týmto odkazom?';
$string['whatforpage'] = 'Co chcete urobiť s týmto textom?';
$string['whattocallzip'] = 'Ako chcete pomenovať zip súbor?';
$string['whattodo'] = 'Čo robiť';
$string['windowclosing'] = 'Toto okno by sa malo automaticky zatvoriť. Ak sa tak nestane, prosím zatvorte ho.';
$string['withchosenfiles'] = 'So zvolenými súbormi';
$string['withdisablednote'] = '{$a} (vypnuté)';
$string['withoutuserdata'] = 'bez údajov používateľa';
$string['withselectedusers'] = 'S označenými používateľmi...';
$string['withselectedusers_help'] = '* Poslať správu - Pre posielanie správ jednému alebo viacerým účastníkom
* Pridať novú poznámku - Pre pridanie poznámky vybranému účastníkovi
* Pridať spoločnú poznámku - Pre pridanie rovnakej poznámky viac ako jednému účastníkovi';
$string['withuserdata'] = 's údajmi používateľa';
$string['wordforstudent'] = 'Vaše označenie pre študenta';
$string['wordforstudenteg'] = 'Napr. študent, účastník atď.';
$string['wordforstudents'] = 'Vaše označenie pre študentov';
$string['wordforstudentseg'] = 'Napr. študenti, účastníci atď.';
$string['wordforteacher'] = 'Vaše označenie pre učiteľa';
$string['wordforteachereg'] = 'Napr. učiteľ, tútor, facilitátor atď.';
$string['wordforteachers'] = 'Vaše označenie pre učiteľov';
$string['wordforteacherseg'] = 'Napr. učitelia, tútori, facilitátori atď.';
$string['writingblogsinfo'] = 'Zapisujú sa informácie o blogoch';
$string['writingcategoriesandquestions'] = 'Zapisujú sa  kategórie a otázky';
$string['writingcoursedata'] = 'Zapisujú sa  údaje kurzu';
$string['writingeventsinfo'] = 'Zapisujú sa informácie o udalostiach';
$string['writinggeneralinfo'] = 'Zapisujú sa  základné informácie';
$string['writinggradebookinfo'] = 'Zapisujú sa informácie do knihy bodov';
$string['writinggroupingsgroupsinfo'] = 'Zapisujú sa informácie o skupinách a zoskupeniach';
$string['writinggroupingsinfo'] = 'Zapisujú sa informácie o zoskupeniach';
$string['writinggroupsinfo'] = 'Zapisujú sa informácie o skupinách';
$string['writingheader'] = 'Zapisujú sa  hlavičky';
$string['writingloginfo'] = 'Zapisujú sa  informácie o prístupoch';
$string['writingmessagesinfo'] = 'Zapisujú sa informácie pre správy';
$string['writingmoduleinfo'] = 'Zapisujú sa  informácie o moduloch';
$string['writingscalesinfo'] = 'Zapisujú sa informácie o stupniciach';
$string['writinguserinfo'] = 'Zapisujú sa  informácie o používateľoch';
$string['wrongpassword'] = 'Nesprávne heslo pre tohto používateľa';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'rok';
$string['years'] = 'roky';
$string['yes'] = 'Áno';
$string['youareabouttocreatezip'] = 'Práve sa chystáte vytvoriť zip súbor obsahujúci';
$string['youaregoingtorestorefrom'] = 'Práve sa chystáte obnovovať z:';
$string['youneedtoenrol'] = 'Na splnenie Vami požadovanej akcie je potrebné sa prihlásiť do toho kurzu.';
$string['yourlastlogin'] = 'Vaše posledné prihlásenie bolo';
$string['yourself'] = 'seba';
$string['yourteacher'] = 'Váš {$a}';
$string['yourwordforx'] = 'Vaše označenie pre \'{$a}';
$string['zippingbackup'] = 'Záloha sa práve zozipováva';
