<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_brick', language 'zh_cn', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_brick
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">

<div class="theme_screenshot">

	<h2 style="padding-top:0.5em;">砖块</h2>
	<img src="brick/pix/screenshot.png" />

	<h3>主题讨论区：</h3>
	<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

	<h3>主题文档：</h3>
	<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

	<h3>主题致谢</h3>
	<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

	<h3>报告bug：</h3>
	<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>

</div>
<div class="theme_description">

	<h2>关于</h2>
	<p>砖块是一个双列、可变宽的Moodle 2.0主题。您可以在主题设置页面修改它的配色。</p>

	<h2>调整</h2>
	<p>本主题基于Moodle核心的基本主题和画布主题构建。如果除了设置里提供的定制功能以外，您还想做其它修改，我们建议您创建一个新主题，并将本主题、基础和画布做为父主题。这样这三个核心主题中任意一个的更新都能反映到您的主题上。</p>

	<h2>致谢</h2>
	<p>本主题由NewSchool Learning的John Stabinger编写和维护。可以通过contact@newschoollearning.com联系他。</p>

	<h2>授权</h2>
	<p>Moodle核心提供的所有主题，包括此主题的授权协议都是<a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>。</p>

</div>
</div>';
$string['configtitle'] = '砖块设置';
$string['headingcolor'] = '标题颜色';
$string['headingcolordesc'] = '大标题（网站新闻、我的课程）和其它标题的颜色。';
$string['linkcolor'] = '链接';
$string['linkcolordesc'] = '设置本主题中链接的颜色，使用html 16进制代码。';
$string['linkhover'] = '链接悬停';
$string['linkhoverdesc'] = '设置本主题中链接（悬停时）的颜色，使用html 16进制代码。';
$string['logo'] = '徽标';
$string['logodesc'] = '输入URL（比如，http://www.somesite/animage.png），改变本主题的徽标。缺省的徽标是265px宽，60px高。透明的PNG文件效果最好。';
$string['maincolor'] = '主色';
$string['maincolordesc'] = '设置头部、停靠栏和其它区域颜色的16进制代码。深色或饱和色的效果最好。';
$string['maincolorlink'] = '主色链接';
$string['maincolorlinkdesc'] = '菜单栏和版块标题链接的颜色。';
$string['pluginname'] = '砖块';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
