<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'zh_cn', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = '访问控制';
$string['actionaftercorrectanswer'] = '回答正确之后的动作';
$string['actionaftercorrectanswer_help'] = '正确回答问题之后，有三个选项决定下一页跳转到哪里：

* 正常 - 跟随教程路径继续
* 显示一个没看过的页面 - 按随机顺序显示页面。每个页面只会显示一次
* 显示一个未回答的页面 - 按随机顺序显示页面。有未回答的问题的页面会被重新显示';
$string['actions'] = '行为';
$string['activitylink'] = '活动链接';
$string['activitylink_help'] = '想在教程结束时显示一个到课程中其它活动的链接，请在下拉列表中选择该活动。';
$string['activitylinkname'] = '转到{$a}';
$string['addabranchtable'] = '新建内容页';
$string['addanendofbranch'] = '新建分支结束页';
$string['addanewpage'] = '新建一个页面';
$string['addaquestionpage'] = '新建题目页';
$string['addaquestionpagehere'] = '在此新建题目页';
$string['addbranchtable'] = '添加内容页面';
$string['addcluster'] = '新建簇';
$string['addedabranchtable'] = '新建了一个内容页';
$string['addedanendofbranch'] = '新建了一个分支结束页';
$string['addedaquestionpage'] = '新建了一个题目页';
$string['addedcluster'] = '新建了一个簇';
$string['addedendofcluster'] = '新建了一个簇结束页';
$string['addendofcluster'] = '新建簇结束页';
$string['addpage'] = '新建页面';
$string['anchortitle'] = '主内容头';
$string['and'] = '与';
$string['answer'] = '答案';
$string['answeredcorrectly'] = '回答正确。';
$string['answersfornumerical'] = '计算题的答案应该是若干对匹配的最小值和最大值';
$string['arrangebuttonshorizontally'] = '水平排列内容按钮？';
$string['attempt'] = '尝试：{$a}';
$string['attempts'] = '尝试';
$string['attemptsdeleted'] = '已删除尝试';
$string['attemptsremaining'] = '您还有{$a}次机会';
$string['available'] = '开放时间';
$string['averagescore'] = '平均分';
$string['averagetime'] = '平均耗时';
$string['branch'] = '内容';
$string['branchtable'] = '内容';
$string['cancel'] = '取消';
$string['cannotfindanswer'] = '错误：找不到选项';
$string['cannotfindattempt'] = '错误：找不到试答';
$string['cannotfindessay'] = '错误：找不到问答题';
$string['cannotfindfirstgrade'] = '错误：找不到成绩';
$string['cannotfindfirstpage'] = '找不到首页';
$string['cannotfindgrade'] = '错误：找不到成绩';
$string['cannotfindnewestgrade'] = '错误：找不到最新成绩';
$string['cannotfindnextpage'] = '教程备份：找不到下一页！';
$string['cannotfindpagerecord'] = '添加分支结尾：找不到页面记录';
$string['cannotfindpages'] = '找不到教程页面';
$string['cannotfindpagetitle'] = '确认删除：找不到页面标题';
$string['cannotfindpreattempt'] = '找不到之前的尝试记录！';
$string['cannotfindrecords'] = '错误：找不到教程记录';
$string['cannotfindtimer'] = '错误：找不到lesson_timer记录';
$string['cannotfinduser'] = '错误：找不到用户';
$string['canretake'] = '{$a}允许重学';
$string['casesensitive'] = '使用正则表达式';
$string['casesensitive_help'] = '勾选此选择框表示使用正则表达式分析学生的答案。';
$string['checkbranchtable'] = '检查内容页面';
$string['checkedthisone'] = '选择了此项。';
$string['checknavigation'] = '检查该课导航';
$string['checkquestion'] = '检查题目';
$string['classstats'] = '班级统计';
$string['clicktodownload'] = '点击下面链接下载文件';
$string['clicktopost'] = '点击此处可以把您的成绩发送到最高分列表上。';
$string['cluster'] = '簇';
$string['clusterjump'] = '在簇中的题目不可见';
$string['clustertitle'] = '簇';
$string['collapsed'] = '折叠的';
$string['comments'] = '您的评价';
$string['completed'] = '完成';
$string['completederror'] = '完成此教程';
$string['completethefollowingconditions'] = '在您继续前您必须完成下面的课程<b>{$a}</b>';
$string['conditionsfordependency'] = '依赖的前提';
$string['configactionaftercorrectanswer'] = '回答正确后的缺省动作';
$string['configmaxanswers'] = '缺省每页最多选项数';
$string['configmaxhighscores'] = '显示高分的个数';
$string['configmediaclose'] = '在打开媒体文件的弹出窗口中显示关闭按钮';
$string['configmediaheight'] = '设置开媒体文件的弹出窗口的高度';
$string['configmediawidth'] = '设置开媒体文件的弹出窗口的宽度';
$string['configslideshowbgcolor'] = '幻灯片模式的背景色，如果激活了该模式的话';
$string['configslideshowheight'] = '幻灯片模式的高度，如果激活了该模式的话';
$string['configslideshowwidth'] = '幻灯片模式的宽度，如果激活了该模式的话';
$string['confirmdelete'] = '删除页面';
$string['confirmdeletionofthispage'] = '确认删除该页';
$string['congratulations'] = '恭喜 － 已到达教程终点';
$string['continue'] = '继续';
$string['continuetoanswer'] = '继续修改答案。';
$string['continuetonextpage'] = '继续到下一页。';
$string['correctanswerjump'] = '回答正确跳转到';
$string['correctanswerscore'] = '回答正确得分';
$string['correctresponse'] = '给正确答案的响应';
$string['credit'] = '学分';
$string['customscoring'] = '是否自定义分数';
$string['customscoring_help'] = '如启用，可以给每个答案一个分数值（可以是正数或负数）。';
$string['deadline'] = '截止时间';
$string['defaultessayresponse'] = '教师将随后对您的问答题评分。';
$string['deleteallattempts'] = '删除所有对教程的尝试';
$string['deletedefaults'] = '删除{$a}默认课程';
$string['deletedpage'] = '删除此页';
$string['deleting'] = '删除中';
$string['deletingpage'] = '删除页面：{$a}';
$string['dependencyon'] = '依赖关系';
$string['dependencyon_help'] = '此设置基于学生在同一课程中其它教程的表现，限制他们对此教程的访问权。可以使用花费时间、是否完成或“成绩高于”的各种组合。';
$string['description'] = '描述';
$string['detailedstats'] = '详细统计';
$string['didnotanswerquestion'] = '未回答此题。';
$string['didnotreceivecredit'] = '没有获得学分';
$string['displaydefaultfeedback'] = '是否显示默认反馈信息';
$string['displaydefaultfeedback_help'] = '如果启用，当某个特定的问题没有设定反馈内容时，将显示默认反馈：“此答案正确”和“此答案错误”。 ';
$string['displayhighscores'] = '显示最高分';
$string['displayinleftmenu'] = '在左侧菜单中显示？';
$string['displayleftif'] = '显示左侧菜单，仅当成绩高于';
$string['displayleftif_help'] = '此设置决定在看到左侧菜单之前是否必须先获得一定的分数。这将强制学生在第一次访问时必须浏览完整个教程。在达到分数线后，他们就可以使用左侧菜单进行复习了。';
$string['displayleftmenu'] = '显示左侧菜单';
$string['displayleftmenu_help'] = '开启此选项后，会显示页面列表。';
$string['displayofgrade'] = '向学生显示成绩';
$string['displayreview'] = '提供重试一道题目的选项';
$string['displayreview_help'] = '如果启用，当学生未能正确回答问题时，可以选择再答一次但不计分，或者继续教程。';
$string['displayscorewithessays'] = '您在自动评分的题目中得了{$a->score}（满分：{$a->tempmaxgrade}）。<br />您的{$a->essayquestions}个问答题将晚些评分，并添加到您的最终成绩中。<br /><br />您当前不包含问答题的成绩是：{$a->score} （满分：{$a->grade}）';
$string['displayscorewithoutessays'] = '您的分数是{$a->score}(满分{$a->grade})。';
$string['edit'] = '编辑';
$string['editingquestionpage'] = '编辑{$a}题目页面';
$string['editlessonsettings'] = '修改程序教学的设置';
$string['editpage'] = '编辑页面内容';
$string['editpagecontent'] = '编辑页面内容';
$string['email'] = 'Email';
$string['emailallgradedessays'] = 'Email所有的已评分的问答题';
$string['emailgradedessays'] = 'Email已评分的问答题';
$string['emailsuccess'] = 'Email发送成功';
$string['emptypassword'] = '密码不能为空';
$string['endofbranch'] = '分支结束';
$string['endofcluster'] = '簇结束';
$string['endofclustertitle'] = '簇结束';
$string['endoflesson'] = '教程结束';
$string['enteredthis'] = '输入这个';
$string['entername'] = '请输入昵称以显示在最高分列表中';
$string['enterpassword'] = '请输入密码';
$string['eolstudentoutoftime'] = '注意：您已经超过了本教程规定的时间。您最后回答的题目如果是在时限之后作答，那么可能不会被算分。';
$string['eolstudentoutoftimenoanswers'] = '您没有回答任何题目。您在本教程中得到了 0 分。';
$string['essay'] = '问答题';
$string['essayemailmessage'] = '<p>问答题题面：<blockquote>{$a->question}</blockquote></p><p>您的回答：<blockquote><em>{$a->response}</em></blockquote></p><p>{$a->teacher}的评论：<blockquote><em>{$a->comment}</em></blockquote></p><p>此问答题您已经得到{$a->outof}分中的{$a->earned}分。</p><p>您此教程的得分已经变为{$a->newgrade}%。</p>';
$string['essayemailmessage2'] = '<p>问答题：<blockquote>{$a->question}</blockquote></p><p>您的回答：<blockquote><em>{$a->response}</em></blockquote></p><p>评分人评论：<blockquote><em>{$a->comment}</em></blockquote></p><p>此问答题您得到了{$a->earned}分（满分{$a->outof}）。</p><p>您此教程的成绩已经变为{$a->newgrade}%。</p>';
$string['essayemailsubject'] = '题目{$a}的成绩';
$string['essays'] = '问答题';
$string['essayscore'] = '问答题成绩';
$string['fileformat'] = '文件格式';
$string['finish'] = '结束';
$string['firstanswershould'] = '第一个选项应当跳转到"正确"页';
$string['firstwrong'] = '很遗憾，因为回答不正确，您没能够获得分数。还想继续猜测吗？这纯粹是为了学习的快乐（不能获得成绩）。';
$string['flowcontrol'] = '流程控制';
$string['full'] = '展开的';
$string['general'] = '一般';
$string['gotoendoflesson'] = '到教程末尾';
$string['grade'] = '成绩';
$string['gradebetterthan'] = '比(%)成绩好';
$string['gradebetterthanerror'] = '得到一个高于{$a}%的成绩';
$string['gradeessay'] = '为问答题打分';
$string['gradeis'] = '成绩是{$a}';
$string['gradeoptions'] = '分数选项';
$string['handlingofretakes'] = '如何处理多个成绩';
$string['handlingofretakes_help'] = '如果允许学生重新学习，此设置决定此教程的得分是所有尝试的平均分还是最高分。';
$string['havenotgradedyet'] = '尚未打分';
$string['here'] = '这里';
$string['highscore'] = '最高分';
$string['highscores'] = '高分';
$string['hightime'] = '最长耗时';
$string['importcount'] = '导入{$a}道题目';
$string['importquestions'] = '导入题目';
$string['importquestions_help'] = '通过文本文件导入各种格式的题目。';
$string['insertedpage'] = '已经插入页面';
$string['invalidfile'] = '无效文件';
$string['invalidid'] = '没有课程模块ID或教程ID传入';
$string['invalidlessonid'] = '教程ID不正确';
$string['invalidpageid'] = '无效页面ID';
$string['jump'] = '跳转';
$string['jumps'] = '跳转';
$string['jumps_help'] = '每个题目页的答案或内容页的描述都有一个对应的跳转。跳转可以是相对的，比如当前页或下一页，也可以绝对指向教程中的任意一页。';
$string['jumpsto'] = '跳转到<em>{$a}</em>';
$string['leftduringtimed'] = '您在计时教程的中间离开了。<br/>请点击“继续”来重新开始。';
$string['leftduringtimednoretake'] = '您在计时教程的中间离开了。<br/>此教程不允许重学或继续。';
$string['lesson:addinstance'] = '添加一个新课程';
$string['lessonattempted'] = '已尝试过的教程';
$string['lessonclosed'] = '此教程在 {$a} 关闭。';
$string['lessoncloses'] = '关闭教程';
$string['lessoncloseson'] = '教程在{$a}关闭';
$string['lesson:edit'] = '编辑教程活动';
$string['lessonformating'] = '程序教学显示格式';
$string['lesson:manage'] = '管理教程活动';
$string['lessonmenu'] = '教程目录';
$string['lessonnotready'] = '这个程序教学还没有准备好。请与{$a}联系。';
$string['lessonnotready2'] = '此教程还没准备。';
$string['lessonopen'] = '本教程将在 {$a} 开放。';
$string['lessonopens'] = '开放教程';
$string['lessonpagelinkingbroken'] = '找不到第一个页面。教程的页面链接一定损坏了。请与管理员联系。';
$string['lessonstats'] = '教程统计';
$string['linkedmedia'] = '链接的媒体';
$string['loginfail'] = '登录错误，请重试……';
$string['lowscore'] = '最低分';
$string['lowtime'] = '最短耗时';
$string['manualgrading'] = '问答题评分';
$string['matchesanswer'] = '答案匹配';
$string['matching'] = '匹配题';
$string['matchingpair'] = '匹配对{$a}';
$string['maxgrade'] = '最高分';
$string['maxgrade_help'] = '此设置决定此教程的最高分。如果设为0，此教程将不会出现在成绩页面上。';
$string['maxhighscores'] = '显示的最高分数目';
$string['maximumnumberofanswersbranches'] = '最大选项数';
$string['maximumnumberofanswersbranches_help'] = '此设置决定在此教程中可以使用的选项的最大个数。如果只使用判断题，那么可以设为0。此设置随时可以改变，因为它只影响教师界面，不影响数据。';
$string['maximumnumberofattempts'] = '允许试答次数';
$string['maximumnumberofattempts_help'] = '此设置决定每个问题最多可以回答的次数。如果持续回答错误，当达到此最大值时，会显示教程的下一页。';
$string['maximumnumberofattemptsreached'] = '您已达到最大数量的尝试-请进入下一个页面';
$string['maxtime'] = '时间限制(分钟)';
$string['maxtimewarning'] = '您还有 {$a} 分钟来完成任务。';
$string['mediaclose'] = '显示关闭按钮';
$string['mediafile'] = '弹出文件或网页';
$string['mediafile_help'] = '如果想在教程开始时弹出一个窗口，请选择在窗口里显示的文件。每个教程页面都会有一个重新打开此弹出窗口的链接，可以在需要的时候使用。';
$string['mediafilepopup'] = '点击这里查看';
$string['mediaheight'] = '弹出窗口高度：';
$string['mediawidth'] = '弹出窗口宽度：';
$string['messageprovider:graded_essay'] = '文章评分通知';
$string['minimumnumberofquestions'] = '至少回答题目数';
$string['minimumnumberofquestions_help'] = '此设置决定用来计算此活动成绩的最少题目数量。如果此教程包含一个或多个内容页面，那么最小题目数应设为0。

假如它被设为20，那么在教程的起始页会显示下面文字：“在此教程中，希望您回答至少20个问题。 如果愿意，您可以回答更多问题。但是，如果您回答少于20个问题，您的成绩将按照回答了20个问题的方式计算。”';
$string['missingname'] = '请输入昵称';
$string['modattempts'] = '允许学生检查';
$string['modattempts_help'] = '如果启用，学生可以再次从头浏览此教程。';
$string['modattemptsnoteacher'] = '学生复审只能在学生端使用。';
$string['modulename'] = '教程';
$string['modulename_help'] = '教程模块使教师可以为学生创造自适应性的学习体验。它由一系列的页面组成，每个页面都可以包含题目。';
$string['modulenameplural'] = '教程';
$string['move'] = '移动页面';
$string['movedpage'] = '已移动的页面';
$string['movepagehere'] = '移动页面到此';
$string['moving'] = '移动页面：{$a}';
$string['multianswer'] = '多项选择';
$string['multianswer_help'] = '如果有多个正确答案，就勾选此框。';
$string['multichoice'] = '选择题';
$string['multipleanswer'] = '多个答案';
$string['nameapproved'] = '名称核准';
$string['namereject'] = '很抱歉，您的名称被过滤器拒绝。<br/>请尝试其他的名字';
$string['new'] = '新的';
$string['nextpage'] = '下一页';
$string['noanswer'] = '未回答问题。请回退并提交一个答案。';
$string['noattemptrecordsfound'] = '没有发现尝试记录:没有给定成绩';
$string['nobranchtablefound'] = '没找到内容页面';
$string['nocommentyet'] = '还没有意见';
$string['nocoursemods'] = '没找到活动的';
$string['nocredit'] = '没有学分';
$string['nodeadline'] = '没有最后期限';
$string['noessayquestionsfound'] = '此教程中没有问答题。';
$string['nohighscores'] = '没有最高成绩';
$string['nolessonattempts'] = '还没有人尝试此教程。';
$string['nooneansweredcorrectly'] = '没有人回答正确。';
$string['nooneansweredthisquestion'] = '没有人回答此题。';
$string['noonecheckedthis'] = '无人选择此项。';
$string['nooneenteredthis'] = '没有人输入这个。';
$string['noonehasanswered'] = '还没有人回答问答题。';
$string['noretake'] = '您不可以重新学习此教程。';
$string['normal'] = '常规-按照自定义流程';
$string['notcompleted'] = '没有完成';
$string['notdefined'] = '没有定义';
$string['nothighscore'] = '您没有制作 {$a} 最高成绩列表。';
$string['notitle'] = '没有标题';
$string['numberofcorrectanswers'] = '正确答案数：{$a}';
$string['numberofcorrectmatches'] = '正确匹配数：{$a}';
$string['numberofpagestoshow'] = '显示多少页';
$string['numberofpagestoshow_help'] = '此设置决定一个教程中可以显示多少个页面。它只对按随机顺序（当“回答正确后的动作”设为“显示一个未浏览的页面”或“显示一个未回答的页面”时）显示页面的教程有用。如果设为0，那么所有页面都会被显示。';
$string['numberofpagesviewed'] = '页面浏览数：{$a}';
$string['numberofpagesviewednotice'] = '已回答题数:{$a->nquestions};(您至少要回答{$a->minquestions})';
$string['numerical'] = '计算题';
$string['ongoing'] = '显示即时分数';
$string['ongoingcustom'] = '您迄今已获得 {$a->score} 分 （满分 {$a->currenthigh}）。';
$string['ongoing_help'] = '如果启用，每个页面都会显示学生已经获得的分数和目前的总分。';
$string['ongoingnormal'] = '您在已浏览的 {$a->viewed} 道题目中已正确回答了{$a->correct}道。';
$string['onpostperpage'] = '每个成绩只能发布一次';
$string['options'] = '选项';
$string['or'] = '或';
$string['ordered'] = '已排序的';
$string['other'] = '其它';
$string['outof'] = '超出 {$a}';
$string['overview'] = '概览';
$string['overview_help'] = '一个教程由一系列的页面和可选的内容页构成。一个页面包含一些内容，且通常以一个问题结束。问题的每个答案都有一个对应的跳转。这个跳转可以是相对的，比如本页或下一页，也可以是绝对的，指向本教程中的任意一页。内容页面包含到教程中其它页面的链接，就像一个目录一样。';
$string['page'] = '页面：{$a}';
$string['pagecontents'] = '页面内容';
$string['page-mod-lesson-edit'] = '教程编辑页面';
$string['page-mod-lesson-view'] = '查看或预览教程页面';
$string['page-mod-lesson-x'] = '任意教程页面';
$string['pages'] = '页面';
$string['pagetitle'] = '页面标题';
$string['password'] = '设置密码';
$string['passwordprotectedlesson'] = '教程{$a}受密码保护。';
$string['pleasecheckoneanswer'] = '请选择一个答案';
$string['pleasecheckoneormoreanswers'] = '请选择一个或多个选项';
$string['pleaseenteryouranswerinthebox'] = '请在框内填上答案';
$string['pleasematchtheabovepairs'] = '请匹配以上内容';
$string['pluginadministration'] = '教程管理';
$string['pluginname'] = '教程';
$string['pointsearned'] = '获得分数';
$string['postprocesserror'] = '后处理时发生错误！';
$string['postsuccess'] = '发表成功';
$string['practice'] = '实践教程';
$string['practice_help'] = '实践教程不会出现在成绩单中。';
$string['preprocesserror'] = '预处理时发生错误！';
$string['preview'] = '预览';
$string['previewlesson'] = '预览{$a}';
$string['previouspage'] = '上一页';
$string['processerror'] = '处理是发生错误！';
$string['progressbar'] = '进度条';
$string['progressbar_help'] = '如果启用，在教程页面底部会显示一个进度条，以说明完成的百分比。';
$string['progressbarteacherwarning'] = '{$a}不显示进度条';
$string['progressbarteacherwarning2'] = '因为您可以编辑此教程，所以您看不到进度条';
$string['progresscompleted'] = '您已完成此教程的 {$a}%';
$string['qtype'] = '页面类型';
$string['question'] = '题目';
$string['questionoption'] = '题目';
$string['questiontype'] = '题目类型';
$string['randombranch'] = '随机内容页';
$string['randompageinbranch'] = '内容页面中的随机题';
$string['rank'] = '等级';
$string['rawgrade'] = '原始分数';
$string['receivedcredit'] = '获得的学分';
$string['redisplaypage'] = '重新显示此页';
$string['report'] = '报表';
$string['reports'] = '报表';
$string['response'] = '回应';
$string['retakesallowed'] = '允许重试';
$string['retakesallowed_help'] = '如果启用，学生可以多次尝试此教程。';
$string['returnto'] = '返回到{$a}';
$string['returntocourse'] = '返回到课程';
$string['review'] = '复习';
$string['reviewlesson'] = '复习教程';
$string['reviewquestionback'] = '再试一次';
$string['reviewquestioncontinue'] = '不，我只想继续看下一题';
$string['sanitycheckfailed'] = '检查失败: 这次尝试将被删除';
$string['savechanges'] = '保存更改';
$string['savechangesandeol'] = '保存所有修改并跳转到教程的最后。';
$string['savepage'] = '保存页面';
$string['score'] = '分数';
$string['scores'] = '分数';
$string['secondpluswrong'] = '不完全正确，您想再试一次吗？';
$string['selectaqtype'] = '选择一个题目类型';
$string['shortanswer'] = '填空题';
$string['showanunansweredpage'] = '显示一个未回答的页面';
$string['showanunseenpage'] = '显示一个未浏览的页面';
$string['singleanswer'] = '一个答案';
$string['skip'] = '跳跃导航';
$string['slideshow'] = '幻灯片';
$string['slideshowbgcolor'] = '幻灯片背景';
$string['slideshowheight'] = '幻灯片高度';
$string['slideshow_help'] = '如果启用，此教程将以固定宽和高的幻灯片的形式显示。';
$string['slideshowwidth'] = '幻灯片宽度';
$string['startlesson'] = '开始专题讨论';
$string['studentattemptlesson'] = '{$a->firstname {$a->lastname}}的尝试次数{$a->attempt}';
$string['studentname'] = '{$a} 名称';
$string['studentoneminwarning'] = '警告：您还有不到1分钟来完成此活动';
$string['studentresponse'] = '{$a} 的回应';
$string['submit'] = '提交';
$string['submitname'] = '提交名称';
$string['teacherjumpwarning'] = '此教程使用了一个{$a->cluster}跳转或一个{$a->unseen}跳转。将使用“下一页”跳转模式替代。以学生身份登录来测试这些跳转。';
$string['teacherongoingwarning'] = '即时分数只显示给学生。以学生身份登录来测试即时分数';
$string['teachertimerwarning'] = '只有学生可以使用计时器。要测试计时器，请以学生身份登录。';
$string['thatsthecorrectanswer'] = '此答案正确';
$string['thatsthewronganswer'] = '此答案错误';
$string['thefollowingpagesjumptothispage'] = '从下页面跳转到此页面';
$string['thispage'] = '本页';
$string['timeremaining'] = '剩余时间';
$string['timespenterror'] = '在本教程中至少花费了{$a}分钟';
$string['timespentminutes'] = '消耗时间（分钟）';
$string['timetaken'] = '开始时间';
$string['topscorestitle'] = '{$a}个最高分';
$string['truefalse'] = '判断题';
$string['unabledtosavefile'] = '无法保存您上传的文件';
$string['unknownqtypesnotimported'] = '{$a}个题目没有导入，因为不支持的它们的题目类型';
$string['unseenpageinbranch'] = '内容页面内未查看的题目';
$string['unsupportedqtype'] = '无效的提问形式({$a})!';
$string['updatedpage'] = '更新页面';
$string['updatefailed'] = '更新失败';
$string['usemaximum'] = '最高分';
$string['usemean'] = '平均分';
$string['usepassword'] = '是否有密码';
$string['usepassword_help'] = '如果启用，不知道密码就不能访问此教程。';
$string['viewgrades'] = '查看成绩';
$string['viewhighscores'] = '查看最高分列表';
$string['viewreports'] = '查看{$a->attempts}完成{$a->student}尝试';
$string['viewreports2'] = '查看{$a}个已完成的试答';
$string['welldone'] = '非常好!';
$string['whatdofirst'] = '您希望先做什么?';
$string['wronganswerjump'] = '回答错误跳转到';
$string['wronganswerscore'] = '回答错误得分';
$string['wrongresponse'] = '给错误答案的回应';
$string['xattempts'] = '{$a}尝试';
$string['youhaveseen'] = '您已经浏览了本教程的多个页面。<br />想从上次结束的页面开始吗？';
$string['youmadehighscore'] = '您在高分表的第{$a}位。';
$string['youranswer'] = '您的答案';
$string['yourcurrentgradeis'] = '您当前的分数是{$a}';
$string['yourcurrentgradeisoutof'] = '您目前的分数是{$a->grade}（总分{$a->total}）';
$string['youshouldview'] = '您最少应该浏览：{$a}';
