<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'će biti instalirano';
$string['action'] = 'Operacija';
$string['actionchoice'] = 'Što želite napraviti s datotekom \'{$a}\'?';
$string['actions'] = 'Operacije';
$string['active'] = 'Aktivno';
$string['activeusers'] = 'Aktivni korisnici';
$string['activities'] = 'Aktivnosti';
$string['activities_help'] = 'Aktivnosti, kao što su forumi, testovi i wikiji, omogućuju dodavanje interaktivnog sadržaja.';
$string['activity'] = 'Aktivnost';
$string['activityclipboard'] = 'Premjesti ovu aktivnost: {$a}';
$string['activityiscurrentlyhidden'] = 'Nažalost, ova aktivnost je trenutno skrivena';
$string['activitymodule'] = 'Aktivnosti';
$string['activitymodules'] = 'Aktivnosti';
$string['activityreport'] = 'Izvještaj o aktivnosti';
$string['activityreports'] = 'Izvještaji o aktivnosti';
$string['activityselect'] = 'Odaberite ovu aktivnost radi premještanja na drugu lokaciju';
$string['activitysince'] = 'Aktivnost od {$a}';
$string['activityweighted'] = 'Aktivnost po korisniku';
$string['add'] = 'Dodajte';
$string['addactivity'] = 'Dodajte aktivnost';
$string['addactivitytosection'] = 'Dodajte aktivnost u sekciju \'{$a}\'';
$string['addadmin'] = 'Dodaj administratora';
$string['addblock'] = 'Dodaj blok';
$string['addcomment'] = 'Dodaj komentar...';
$string['addcountertousername'] = 'Stvori korisnika dodavanjem broja korisničkom imenu';
$string['addcreator'] = 'Dodaj kreatora kolegija';
$string['adddots'] = 'Dodaj..';
$string['added'] = '{$a} dodan';
$string['addedrecip'] = 'Dodan je novi primatelj: {$a}';
$string['addedrecips'] = 'Broj novih primatelja: {$a}';
$string['addedtogroup'] = 'Dodan(a) u grupu {$a}';
$string['addedtogroupnot'] = 'Nije dodan(a) u grupu {$a}';
$string['addedtogroupnotenrolled'] = 'Nije dodan(a) u grupu {$a}, jer nije upisan(a) u kolegij';
$string['addfilehere'] = 'Dodajte datoteku/e ovdje';
$string['addinganew'] = 'Novi/a {$a}';
$string['addinganewto'] = 'Novi/a {$a->what} u {$a->to}';
$string['addingdatatoexisting'] = 'Dodavanje podataka postojećim';
$string['additionalnames'] = 'Dodatna imena';
$string['addlinkhere'] = 'Dodajte poveznicu ovdje';
$string['addnewcategory'] = 'Dodajte novu kategoriju';
$string['addnewcourse'] = 'Dodajte novi kolegij';
$string['addnewuser'] = 'Dodajte novog korisnika';
$string['addnousersrecip'] = 'Dodavanje korisnika koji nije pristupio {$a} na popis primatelja';
$string['addpagehere'] = 'Dodajte stranicu ovdje';
$string['addresource'] = 'Dodajte resurs...';
$string['addresourceoractivity'] = 'Dodajte aktivnost ili resurs';
$string['addresourcetosection'] = 'Dodajte resurs u sekciju \'{$a}\'';
$string['address'] = 'Adresa';
$string['addstudent'] = 'Dodajte studenta';
$string['addsubcategory'] = 'Dodaj potkategoriju';
$string['addteacher'] = 'Dodajte nastavnika';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Ručno dodavanje novog korisničkog računa';
$string['adminhelpassignadmins'] = 'Administratori mogu činiti _SVE_';
$string['adminhelpassigncreators'] = 'Kreatori mogu kreairati nove kolegije i predavati unutar istih';
$string['adminhelpassignsiteroles'] = 'Primijeni definirane uloge na određene korisnike';
$string['adminhelpassignstudents'] = 'Uđite u kolegij i dodajte studente (polaznike) iz admin izbornika';
$string['adminhelpauthentication'] = 'Možete koristiti interne korisničke račune ili vanjske baze podataka';
$string['adminhelpbackup'] = 'Konfigurirajte automatski backup i vremenski raspored izvršavanja';
$string['adminhelpconfiguration'] = 'Konfigurirajte kako site izgleda i funkcionira';
$string['adminhelpconfigvariables'] = 'Konfigurirajte varijable koje utječu na opću funkcionalnost site-a';
$string['adminhelpcourses'] = 'Odredite kolegije i kategorije i upišite polaznike u njih';
$string['adminhelpeditorsettings'] = 'Odredite osnovne postavke HTML editora';
$string['adminhelpedituser'] = 'Pregledajte popis korisnika i uredite postavke i podatke za bilo kojeg od njih';
$string['adminhelpenvironment'] = 'Provjerite zadovoljava li vaš poslužitelj trenutne i buduće preduvjete za uspješnu instalaciju';
$string['adminhelpfailurelogs'] = 'Pregled zapisa neuspješnih prijava sustavu';
$string['adminhelplanguage'] = 'Provjera i uređivanje trenutnog jezičnog paketa';
$string['adminhelplogs'] = 'Pregledajte zapise svih aktivnosti na site-u';
$string['adminhelpmanageblocks'] = 'Uredite postavke ugrađenih blokova';
$string['adminhelpmanagedatabase'] = 'Direktno pristupite bazi podataka (OPREZ!)';
$string['adminhelpmanagefilters'] = 'Odaberite tekstualne filtere i srodne postavke';
$string['adminhelpmanagemodules'] = 'Uredite postavke ugrađenih modula';
$string['adminhelpmanageroles'] = 'Stvori i definiraj uloge koje se mogu primijeniti na korisnike';
$string['adminhelpmymoodle'] = 'Podesi My Moodle blokove za korisnike';
$string['adminhelpreports'] = 'Izvještaji na razini sustava';
$string['adminhelpsitefiles'] = 'Služi za objavljivanje datoteka općenitog sadržaja ili upload backup datoteka';
$string['adminhelpsitesettings'] = 'Definirajte kako će izgledati naslovnica';
$string['adminhelpstickyblocks'] = 'Podesite fiksne blokove na cijelom poslužitelju';
$string['adminhelpthemes'] = 'Odredite kako će izgledati site (boje, fontovi i sl.)';
$string['adminhelpuploadusers'] = 'Uvezite nove korisničke račune iz tekstualne datoteke';
$string['adminhelpusers'] = 'Odredite korisnike i podesite autentikaciju';
$string['adminhelpxmldbeditor'] = 'Sučelje za uređivanje XMLDB datoteka. Samo za programere.';
$string['administration'] = 'Administracija';
$string['administrationsite'] = 'Administracija poslužitelja';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratori mogu raditi _SVE_.';
$string['administrators'] = 'Administratori';
$string['administratorsall'] = 'Svi administratori';
$string['administratorsandteachers'] = 'Administratori i nastavnici';
$string['advanced'] = 'Napredno';
$string['advancedfilter'] = 'Napredno pretraživanje';
$string['advancedsettings'] = 'Napredne postavke';
$string['afterresource'] = 'Nakon resursa "{$a}"';
$string['aftersection'] = 'Nakon sekcije/teme "{$a}"';
$string['again'] = 'ponovno';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX i Javascript';
$string['all'] = 'Sve';
$string['allactions'] = 'Sve operacije';
$string['allactivities'] = 'Sve aktivnosti';
$string['allcategories'] = 'Sve kategorije';
$string['allchanges'] = 'Sve izmjene';
$string['alldays'] = 'Svi dani';
$string['allfieldsrequired'] = 'Sva polja su obvezna';
$string['allfiles'] = 'Sve datoteke';
$string['allgroups'] = 'Sve grupe';
$string['alllogs'] = 'Svi zapisi';
$string['allmods'] = 'Svi {$a}';
$string['allow'] = 'Dopusti';
$string['allowinternal'] = 'Dopusti i interni način autorizacije';
$string['allownone'] = 'Ne dopusti nijedan';
$string['allownot'] = 'Nemoj dopustiti';
$string['allparticipants'] = 'Svi sudionici';
$string['allteachers'] = 'Svi nastavnici';
$string['alphanumerical'] = 'Može sadržavati SAMO slova i/ili brojeve, crticu (-) ili točku (.)';
$string['alreadyconfirmed'] = 'Registracija je već potvrđena';
$string['alternatename'] = 'Alternativno ime';
$string['always'] = 'Uvijek';
$string['and'] = '{$a->one} i {$a->two}';
$string['answer'] = 'Odgovor';
$string['any'] = 'Bilo koji';
$string['appearance'] = 'Izgled';
$string['approve'] = 'Dopusti';
$string['areyousure'] = 'Jeste li sigurni?';
$string['areyousuretorestorethis'] = 'Želite li nastaviti?';
$string['areyousuretorestorethisinfo'] = 'Tijekom ovog postupka moći ćete odabrati želite li dodati ovaj backup postojećem kolegiju ili stvoriti potpuno novi kolegij.';
$string['asc'] = 'Uzlazno';
$string['assessment'] = 'Zadatak';
$string['assignadmins'] = 'Zaduži administratore';
$string['assigncreators'] = 'Zaduži kreatore';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Dodijeli uloge na razini cijelog sustava';
$string['authenticateduser'] = 'Prijavljeni korisnik';
$string['authenticateduserdescription'] = 'Svi prijavljeni korisnici.';
$string['authentication'] = 'Autentikacija';
$string['authenticationplugins'] = 'Autentikacijski dodaci (plugin)';
$string['autosubscribe'] = 'Automatska pretplata na forum';
$string['autosubscribeno'] = 'NE: ne želim automatsku pretplatu na forume';
$string['autosubscribeyes'] = 'DA: kada pošaljem poruku, pretplati me na taj forum';
$string['availability'] = 'Dostupnost';
$string['availablecourses'] = 'Dostupni kolegiji';
$string['back'] = 'Natrag';
$string['backto'] = 'Natrag na {$a}';
$string['backtocourselisting'] = 'Natrag na popis kolegija';
$string['backtopageyouwereon'] = 'Natrag na stranicu na kojoj ste bili';
$string['backtoparticipants'] = 'Natrag na popis sudionika';
$string['backup'] = 'Backup';
$string['backupactivehelp'] = 'Odlučite želite li uključiti automatsku backup proceduru';
$string['backupcancelled'] = 'Backup procedura prekinuta';
$string['backupcoursefileshelp'] = 'Ako je omogućeno, datoteke unutar kolegija bit će obuhvaćene automatskom backup procedurom.';
$string['backupdate'] = 'Datum backupa';
$string['backupdatenew'] = '&nbsp; {$a->TAG} sada je {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} bio je {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Backup detalji';
$string['backupexecuteathelp'] = 'Odaberite vrijeme kada bi se automatizirana backup procedura trebala pokrenuti.';
$string['backupfailed'] = 'Neki od vaših kolegija NISU pohranjeni!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Backup izvršen uspješno';
$string['backupfromthissite'] = 'Backup je načinjen na ovom sustavu?';
$string['backupgradebookhistoryhelp'] = 'Ako je omogućeno, onda će povijest popisa ocjena biti obuhvaćena pri automatskom backupu. Vodite računa da povijest ocjenjivanja ne smije biti onemogućena u postavkama sustava (disablegradehistory) kako bi ovo radilo.';
$string['backupincludemoduleshelp'] = 'Odaberite želite li u u automatsku backup proceduru uključiti i module kolegija, sa ili bez korisničkih podataka';
$string['backupincludemoduleuserdatahelp'] = 'Odlučite želite li obuhvatiti korisničke podatke nastale u modulima u automatiziranom backup-u.';
$string['backupkeephelp'] = 'Koliki broj kopija backup datoteka kolegija želite čuvati (koliko dana unatrag bi sustav trebao čuvati backup datoteke)? (kopije starije od ove vrijednosti bit će izbrisani automatski po isteku roka)';
$string['backuplogdetailed'] = 'Detaljni log izvršavanja';
$string['backuploglaststatus'] = 'Zapis zadnjeg izvršenja';
$string['backupmissinguserinfoperms'] = 'NAPOMENA: Ova backup datoteka ne sadržava korisničke podatke. Aktivnosti Vježba i Radionica neće biti obuhvaćeni backupom budućiu da ti moduli nisu kompatibilni s ovom vrstom backupa.';
$string['backupnext'] = 'Sljedeći backup';
$string['backupnonisowarning'] = 'Upozorenje: ovaj backup je stvoren u inačici Moodle sustava koja ne podržava Unicode (prije inačice 1.6). Ako ovaj backup sadrži tekstove koji nisu ISO-8859-1 kompatibilni, oni će biti OŠTEĆENI pri uvozu u ovu Unicode inačicu Moodle sustava. Pogledajte <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> za više informacija o tome kako ispravno provesti vraćanje ovog backupa.';
$string['backupnotyetrun'] = 'Automatski backup je zakazan';
$string['backuporiginalname'] = 'Ime backup datoteke';
$string['backuproleassignments'] = 'Backupiraj dodijeljene uloge za ove uloge';
$string['backupsavetohelp'] = 'Puna putanja (path) do mape (direktorija) u kojem želite pohraniti backup datoteke<br /> (ostavite ovo polje praznim kako bi podatke spremili u default mapu kolegija)';
$string['backupsitefileshelp'] = 'Ako je omogućeno, datoteke kolegija koje se koriste unutar kolegija bit će obuhvaćene automatskom backup procedurom.';
$string['backuptakealook'] = 'Molimo pregledajte vaše zapise o backupu: {$a}';
$string['backupuserfileshelp'] = 'Odaberite trebaju li korisničke datoteke (npr. slike za osobne profile - avatare) biti obuhvaćene automatskom backup procedurom.';
$string['backupversion'] = 'Backup inačica';
$string['badges'] = 'Značke';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfiguriranje bloka {$a}';
$string['blockconfigbad'] = 'Ovaj blok nije pravilno implementiran i zato ne možete koristiti konfiguracijsko sučelje';
$string['blocks'] = 'Blokovi';
$string['blocksaddedit'] = 'Dodaj / uredi blokove';
$string['blockseditoff'] = 'Isključi uređivanje blokova';
$string['blocksediton'] = 'Uključi uređivanje blokova';
$string['blocksetup'] = 'Podešavanje tablica s blokovima';
$string['blocksuccess'] = '{$a} tablice su ispravno podešene';
$string['brief'] = 'Ukratko';
$string['bulkactions'] = 'Masovne operacije';
$string['bulkmovecoursessuccess'] = 'Uspješno je prebačen(o) {$a->courses} kolegij(a) u {$a->category}';
$string['bycourseorder'] = 'Poredak po kolegijima';
$string['byname'] = 'od {$a}';
$string['bypassed'] = 'Preskočeno';
$string['cachecontrols'] = 'Cache kontrola';
$string['cancel'] = 'Odustanite';
$string['cancelled'] = 'Otkazano';
$string['categories'] = 'Popis kolegija';
$string['categoriesandcoures'] = 'Kategorije kolegija i kolegiji';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Dodana kategorija \'{$a}\'';
$string['categorycontents'] = 'Podkategorije i kolegiji';
$string['categorycurrentcontents'] = 'Sadržaj {$a}';
$string['categorydeleted'] = 'Izbrisana kategorija \'{$a}\'';
$string['categoryduplicate'] = 'Kategorija pod nazivom \'{$a}\' već postoji';
$string['categorymodifiedcancel'] = 'Kategorija je izmijenjena! Molimo vas da izađete i pokušate ponovno.';
$string['categoryname'] = 'Naziv kategorije';
$string['categoryupdated'] = 'Kategorija \'{$a}\' je osvježena';
$string['changedpassword'] = 'Lozinka promijenjena';
$string['changepassword'] = 'Promijeni lozinku';
$string['changesmadereallygoaway'] = 'Napravili ste izmjene i niste ih pohranili. Želite li uistinu otići odavde i izgubiti svoje izmjene?';
$string['changessaved'] = 'Promjene pohranjene';
$string['check'] = 'Označi';
$string['checkall'] = 'Označi sve';
$string['checkingbackup'] = 'Provjeravanje backupa';
$string['checkingcourse'] = 'Provjeravanje kolegija';
$string['checkingforbbexport'] = 'Provjeravanje BlackBoard izvoza podataka';
$string['checkinginstances'] = 'Provjeravanje instanci';
$string['checkingsections'] = 'Provjeravanje sekcija';
$string['checklanguage'] = 'Provjeravanje jezika';
$string['checknone'] = 'Bez provjere';
$string['childcoursenotfound'] = 'Podređeni kolegij nije pronađen!';
$string['childcourses'] = 'Podređeni kolegiji';
$string['choose'] = 'Odaberite';
$string['choosecourse'] = 'Odaberite kolegij';
$string['choosedots'] = 'Odaberi...';
$string['chooselivelogs'] = 'Ili provjerite trenutnu aktivnost';
$string['chooselogs'] = 'Odaberite zapise koje želite vidjeti';
$string['choosereportfilter'] = 'Odaberite filter po kojem želite filtrirati izvještaj';
$string['choosetheme'] = 'Odaberite temu';
$string['chooseuser'] = 'Odaberite korisnika';
$string['city'] = 'Grad';
$string['clambroken'] = 'Vaš administrator je uključio antivirusnu provjeru pri prijenosu datoteka, ali je nažalost nešto pogrešno  konfigurirano.<br /> Prijenos vaše datoteke NIJE bio uspješan. Administratoru je upućena automatska email poruka od strane sustava. <br /> Molimo pokušajte malo kasnije. Hvala!';
$string['clamdeletedfile'] = 'Datoteka je izbrisana';
$string['clamdeletedfilefailed'] = 'Brisanje datoteke neuspješno';
$string['clamemailsubject'] = '{$a} :: ClamAV obavijest';
$string['clamfailed'] = 'ClamAV se nije mogao pokrenuti. Obavijest o pogrešci je sljedeća: {$a}. Slijedi ClamAV output:';
$string['clamlost'] = 'Moodle je konfiguriran tako da provjerava prijenos datoteka s ClamAV alatom, ali je zadana putanja {$a} do ClamAV alata neispravna.';
$string['clamlostandactinglikevirus'] = 'Dodatno, Moodle je podešentako da ako se ClamAV ne uspije izvršiti, postavljene datoteke se smatraju virusima. Ovo u praksi znači da NIJEDAN student ne može postaviti datoteku na poslužitelj dok god vi ne sredite navedeni problem.';
$string['clammovedfile'] = 'Datoteka je premještena u karantenu, na lokaciji {$a}';
$string['clammovedfilebasic'] = 'Datoteka je premještena u karantenu.';
$string['clamquarantinedirfailed'] = 'Nije bilo moguće premjestiti datoteku u karantenu, {$a}. Trebali biste ovo podesiti (popraviti) budući da se u suprotnom zaražene datoteke automatski brišu.';
$string['clamunknownerror'] = 'Clam je prijavio nepoznatu pogrešku.';
$string['cleaningtempdata'] = 'Čišćenje privremenih podataka';
$string['clear'] = 'Izbriši';
$string['clickhelpiconformoreinfo'] = '...se nastavlja... Kliknite na ikonu pomoći kako bi pročitali cijeli članak';
$string['clickhere'] = 'Kliknite ovdje ...';
$string['clicktochangeinbrackets'] = '{$a} (Klik za promjenu)';
$string['clicktohideshow'] = 'Kliknite za otvaranje ili zatvaranje';
$string['closewindow'] = 'Zatvorite ovaj prozor';
$string['collapse'] = 'Sažmi';
$string['collapseall'] = 'Sažmi sve';
$string['collapsecategory'] = 'Sažmi {$a}';
$string['commentincontext'] = 'Pronađi ovaj komentar u kontekstu';
$string['comments'] = 'Komentari';
$string['commentsnotenabled'] = 'Komentiranje nije omogućeno.';
$string['commentsrequirelogin'] = 'Morate se prijaviti kako bi vidjeli komentare';
$string['comparelanguage'] = 'Usporedite i uredite trenutno odabrani jezik';
$string['complete'] = 'Potpuno';
$string['completereport'] = 'Potpuni izvještaj';
$string['configuration'] = 'Konfiguracija';
$string['confirm'] = 'Potvrdi';
$string['confirmcheckfull'] = 'Želite li uistinu potvrditi {$a}?';
$string['confirmed'] = 'Vaša registracija je potvrđena';
$string['confirmednot'] = 'Vaša registracija još nije potvrđena!';
$string['content'] = 'Sadržaj';
$string['continue'] = 'Nastavi';
$string['continuetocourse'] = 'Kliknite ovdje za ulazak u kolegij';
$string['convertingwikitomarkdown'] = 'Pretvaranje Wiki oblika u Markdown oblik';
$string['cookiesenabled'] = 'Vaš browser (internet preglednik) _MORA_ imati omogućene "cookies"';
$string['cookiesenabled_help'] = 'Na ovom su sjedištu u uporabi dva kolačića (<i>cookies</i>):

Osnovni je kolačić sjednice, obično naziva MoodleSession. U pregledniku morate omogućiti stavljanje ovog kolačića, kako biste osigurali da budete prijavljeni na sustav pri prelasku s jedne stranice na drugu. Kada se odjavite ili zatvorite preglednik, kolačić se uništava (i u pregledniku i na poslužitelju).

Drugi kolačić je tu radi pogodnosti, obično naziva MOODLEID. On pamti samo vaše korisničko ime unutar preglednika. Kada se vratite na ovo sjedište, polje za unos korisničkog imena na stranici za prijavu će već biti ispunjeno. Možete i odbiti prihvatiti ovaj kolačić - tada ćete svaki put morati ponovno utipkati svoje korisničko ime prilikom prijave.';
$string['cookiesnotenabled'] = 'Nažalost, "cookies" nisu omogućeni u vašem internet pregledniku (browser)';
$string['copy'] = 'kopiraj';
$string['copyasnoun'] = 'kopiranje';
$string['copyingcoursefiles'] = 'Kopiranje dokumenata kolegija';
$string['copyingsitefiles'] = 'Kopiranje globalnih datoteka koje su korištene na kolegiju';
$string['copyinguserfiles'] = 'Kopiranje korisničkih dokumenata';
$string['copyingzipfile'] = 'Kopiranje zip datoteke';
$string['copyrightnotice'] = 'Poruka o copyrightu';
$string['coresystem'] = 'Sustav';
$string['cost'] = 'Cijena';
$string['costdefault'] = 'Standardna cijena';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Država';
$string['course'] = 'Kolegij';
$string['courseadministration'] = 'Administracija kolegija';
$string['courseapprovedemail'] = 'Kolegij {$a->name}, cije ste otvaranje zatrazili, je otvoren i vi ste postavljeni u ulogu {$a->teacher}. Kako bi pristupili vasem kolegiju, posjetite {$a->url}';
$string['courseapprovedemail2'] = 'Kolegij {$a->name}, cije ste otvaranje zatrazili, je otvoren. Kako bi pristupili vasem kolegiju, posjetite {$a->url}';
$string['courseapprovedfailed'] = 'Odobreni kolegij nije uspješno pohranjen!';
$string['courseapprovedsubject'] = 'Prijedlog vaseg kolegija je prihvacen i odobren!';
$string['courseavailable'] = 'Ovaj kolegij je vidljiv studentima';
$string['courseavailablenot'] = 'Ovaj kolegij NIJE vidljiv studentima';
$string['coursebackup'] = 'Backup kolegija';
$string['coursebulkaction'] = 'Masovne operacije nad odabranim kolegijima';
$string['coursecategories'] = 'Kategorije kolegija';
$string['coursecategory'] = 'Kategorija kolegija';
$string['coursecategorydeleted'] = 'Kategorija {$a} je izbrisana';
$string['coursecategory_help'] = 'Ova postavka određuje kategoriju u kojoj će se kolegij pojaviti.';
$string['coursecatmanagement'] = 'Upravljanje kolegijima i kategorijama';
$string['coursecompletion'] = 'Dovršenost kolegija';
$string['coursecompletions'] = 'Dovršenost kolegija';
$string['coursecreators'] = 'Tvorac kolegija';
$string['coursecreatorsdescription'] = 'Tvorci kolegija mogu stvarati nove kolegije.';
$string['coursedeleted'] = 'Kolegij {$a} je izbrisana';
$string['coursedisplay'] = 'Izgled kolegija';
$string['coursedisplay_help'] = 'Ovom postavkom određujete je li cijeli kolegij prikazan na jednoj stranici, ili je podijeljen na više stranica.';
$string['coursedisplay_multi'] = 'Prikaz samo jedne sekcije po stranici';
$string['coursedisplay_single'] = 'Prikaz svih sekcija na jednoj stranici';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Datoteke kolegija';
$string['coursefilesedit'] = 'Uredi datoteke kolegija';
$string['coursefileswarning'] = 'Datoteke kolegija u zastarjele';
$string['coursefileswarning_help'] = 'Datoteke kolegija su zastarjele od inačice Moodle 2.0, molimo koristite vanjske repozitorije ako je to moguće.';
$string['courseformatdata'] = 'Podaci o obliku kolegija';
$string['courseformatoptions'] = 'Opcije oblikovanja za {$a}';
$string['courseformats'] = 'Oblik kolegija';
$string['courseformatudpate'] = 'Nadogradnja oblika kolegija';
$string['coursegrades'] = 'Ocjene na kolegiju';
$string['coursehelpcategory'] = 'Postavite kolegij na popis kolegija i omogućite studentima da ga lakše pronađu.';
$string['coursehelpforce'] = 'Obvezni rad u grupama za sve aktivnosti na kolegiju';
$string['coursehelpformat'] = 'Glavna stranica kolegija će biti prikazana u ovom obliku.';
$string['coursehelphiddensections'] = 'Kako će skriveni dijelovi kolegija biti prikazani studentima';
$string['coursehelpmaximumupload'] = 'Odredite maksimalnu veličinu datoteke koju netko može prenijeti na ovaj kolegij (u skladu s ograničenjem na razini cijelog poslužitelja).';
$string['coursehelpnewsitemsnumber'] = 'Broj najnovijih obavijesti koje će se pojaviti na naslovnici kolegija, u bloku Najsvježije vijesti<br/>(0 znači da se blok s najnovijim vijestima neće pojaviti).';
$string['coursehelpnumberweeks'] = 'Broj tjedana/tema prikazan na naslovnici kolegija. (Primjenjuje se samo za neke oblike kolegija.)';
$string['coursehelpshowgrades'] = 'Omogući prikaz popisa ocjena. Ovo ne spriječava prikaz ocjena unutar pojedinih aktivnosti.';
$string['coursehidden'] = 'Ovaj kolegij trenutno NIJE dostupan studentima';
$string['courseinfo'] = 'Informacije o kolegiju';
$string['courselegacyfiles'] = 'Datoteke kolegija';
$string['courselegacyfiles_help'] = 'Područje je datoteke kolegija pruža kompatibilnost s inačicama Moodle 1.9 i starijima. Sve datoteke u ovom području dostupne su svim sudionicima u kolegiju (neovisno o tome povežete li ih u kolegij ili ne) i nema načina saznati gdje se ove datoteke koriste u Moodle-u.

Ako ovdje spremate datoteke kolegija, izlažete se velikom broju problema s privatnošću i sigurnošću, kao i gubitkom datoteka pri backupima, unosu kolegija i svaki put kada sadržaj dijelite ili ponovno koristite. Stoga preporučamo da ovo područje ne koristite, osim ako doista ne znate što radite.

Poveznica ispod pruža dodatne informacije o ovoj temi, i pokazuje vam bolje načine za rad s datotekama u Moodle-u 2.';
$string['coursemessage'] = 'Pošalji poruku polaznicima kolegija';
$string['coursenotaccessible'] = 'Ovaj kolegij ne dopušta javni pristup';
$string['courseoverview'] = 'Pregled kolegija';
$string['courseoverviewfiles'] = 'Datoteke sažetka kolegija';
$string['courseoverviewfilesext'] = 'Dopuštene ekstenzije datoteka sažetka kolegija';
$string['courseoverviewfileslimit'] = 'Ograničenje datoteka sažetka kolegija';
$string['courseoverviewgraph'] = 'Pregled grafova kolegija';
$string['courseprofiles'] = 'Profili kolegija';
$string['coursereasonforrejecting'] = 'Vaš razlog za odbijanje zahtjeva za otvaranje novog kolegija';
$string['coursereasonforrejectingemail'] = 'Ova informacija će biti poslana osobi koja je tražila otvaranje novog kolegija';
$string['coursereject'] = 'Odbij zahtjev za otvaranje novog kolegija';
$string['courserejected'] = 'Zahtjev za otvaranje novog kolegija je odbijen i osoba koja je tražila otvaranje novog kolegija je obaviještena o tome.';
$string['courserejectemail'] = 'Nazalost, vas zahtjev za otvaranje novog kolegija je odbijen. Slijedi obrazlozenje:

{$a}';
$string['courserejectreason'] = 'Navedite razloge za odbijanje zahtjeva za otvaranje novog kolegija <br/>(ovo će biti poslano e-poštom osobi koja je postavila zahtjev)';
$string['courserejectsubject'] = 'Vas zahtjev za otvaranje novog kolegija je odbijen';
$string['coursereport'] = 'Izvještaj na razini kolegija';
$string['coursereports'] = 'Izvještaji na razini kolegija';
$string['courserequest'] = 'Zahtjev za otvaranjem novog kolegija';
$string['courserequestdetails'] = 'Detalji novog kolegija kojeg želite otvoriti';
$string['courserequestfailed'] = 'Iz nekog razloga nije moguće pohraniti vaš zahtjev';
$string['courserequestintro'] = 'Putem ovog obrasca možete zatražiti otvaranje novog kolegija za svoje potrebe.<br/>Unesite što više informacija kako bi<br/> administratoru olakšali otvaranje vašeg novog kolegija.';
$string['courserequestreason'] = 'Razlog za otvaranje novog kolegija';
$string['courserequestsuccess'] = 'Vaš zahtjev za otvaranje novog kolegija je uspješno pohranjen. U sljedećih para dana dobit ćete obavijest o rješenju vašeg zahtjeva putem e-pošte.';
$string['courserequestsupport'] = 'Dodatne informacije koje će pomoći administratoru u procjeni vašeg zahtjeva';
$string['courserestore'] = 'Vraćanje kolegija';
$string['courses'] = 'Kolegiji';
$string['coursesectionsummaries'] = 'Sažeci dijelova kolegija';
$string['coursesettings'] = 'Zadane postavke kolegija';
$string['coursesmovedout'] = 'Kolegij premješten iz {$a}';
$string['coursespending'] = 'Zahtjevi za otvaranje kolegija na čekanju';
$string['coursestart'] = 'Kolegij počinje';
$string['coursesummary'] = 'Sažetak kolegija';
$string['coursesummary_help'] = 'Sažetak kolegija prikazuje se u popisu kolegija. Pretraga kolegija, osim naziva kolegija, pretražuje i sažetke kolegija.';
$string['courseupdates'] = 'Osvježenje kolegija';
$string['create'] = 'Stvori';
$string['createaccount'] = 'Stvori moj novi korisnički račun';
$string['createcategory'] = 'Stvori kategoriju';
$string['createfolder'] = 'Stvori mapu u {$a}';
$string['createnew'] = 'Stvori novi';
$string['createnewcategory'] = 'Stvori novu kategoriju';
$string['createnewcourse'] = 'Stvori novi kolegij';
$string['createnewsubcategory'] = 'Stvori novu potkategoriju';
$string['createsubcategoryof'] = 'Stvori novu potkategoriju {$a}';
$string['createuser'] = 'Stvori korisnika';
$string['createuserandpass'] = 'Stvori novo korisničko ime i lozinku s kojom se mogu prijaviti sustavu';
$string['createziparchive'] = 'Stvori zip arhivu';
$string['creatingblocks'] = 'Stvaranje blokova';
$string['creatingblocksroles'] = 'Stvaranje uloga i izmijenjenih ovlasti dodijeljenih na razini bloka';
$string['creatingblogsinfo'] = 'Stvaranje informacija o blogovima';
$string['creatingcategoriesandquestions'] = 'Stvaranje kategorije i pitanja';
$string['creatingcoursemodules'] = 'Stvaranje modula unutar kolegija';
$string['creatingcourseroles'] = 'Stvaranje uloga i izmijenjenih ovlasti dodijeljenih na razini kolegija ';
$string['creatingevents'] = 'Stvaranje događaja';
$string['creatinggradebook'] = 'Stvaranje zapisa o ocjenama';
$string['creatinggroupings'] = 'Stvaranje grupiranja';
$string['creatinggroupingsgroups'] = 'Dodavanje grupa u grupiranja';
$string['creatinggroups'] = 'Stvaranje grupe';
$string['creatinglogentries'] = 'Stvaranje log zapisa';
$string['creatingmessagesinfo'] = 'Stvaranje informacija o porukama';
$string['creatingmodroles'] = 'Stvaranje uloga i izmijenjenih ovlasti dodijeljenih na razini modula';
$string['creatingnewcourse'] = 'Stvaranje novog kolegija';
$string['creatingrolesdefinitions'] = 'Stvaranje definicija uloga';
$string['creatingscales'] = 'Stvaranje skala';
$string['creatingsections'] = 'Stvaranje odjeljaka';
$string['creatingtemporarystructures'] = 'Stvaranje privremenih struktura';
$string['creatinguserroles'] = 'Stvaranje uloga i izmijenjenih ovlasti dodijeljenih na razini korisnika';
$string['creatingusers'] = 'Stvaranje korisnika';
$string['creatingxmlfile'] = 'Stvaranje XML datoteke';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Trenutni kolegij';
$string['currentcourseadding'] = 'Trenutni kolegij, dodavanje podataka postojećima';
$string['currentcoursedeleting'] = 'Trenutni kolegij, uz prethodno brisanje postojećih podataka';
$string['currentlanguage'] = 'Trenutno važeći jezik';
$string['currentlocaltime'] = 'vaše lokalno vrijeme';
$string['currentlyselectedusers'] = 'Trenutno odabrani korisnici';
$string['currentpicture'] = 'Trenutna slika';
$string['currentrelease'] = 'Informacija o trenutnoj inačici';
$string['currentversion'] = 'Trenutna inačica';
$string['databasechecking'] = 'Nadograđujem Moodle bazu podataka {$a->oldversion} na {$a->newversion}...';
$string['databaseperformance'] = 'Učinkovitost baze podataka (performanse)';
$string['databasesetup'] = 'Podešavanje baze podataka';
$string['databasesuccess'] = 'Baza podataka je uspješno nadograđena';
$string['databaseupgradebackups'] = 'Važeća backup inačica je {$a}';
$string['databaseupgradeblocks'] = 'Važeća inačica bloka je {$a}';
$string['databaseupgradegroups'] = 'Inačica grupe je {$a}';
$string['databaseupgradelocal'] = 'Trenutna inačica lokalnih prilagodbi baze podataka je {$a}';
$string['databaseupgrades'] = 'Nadogradnja baze podataka';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum izmjene';
$string['datemostrecentfirst'] = 'Datum - prvo najnoviji';
$string['datemostrecentlast'] = 'Datum - prvo najstariji';
$string['day'] = 'dan';
$string['days'] = 'dana';
$string['decodinginternallinks'] = 'Dekodiranje internih poveznica';
$string['default'] = 'Zadano';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenti općenito imaju manje ovlasti unutar kolegija.';
$string['defaultcoursestudents'] = 'Studenti';
$string['defaultcoursesummary'] = 'Napišite kratak i zanimljiv sažetak koji objašnjava koje teme pokriva vaš kolegij.';
$string['defaultcourseteacher'] = 'Nastavnik';
$string['defaultcourseteacherdescription'] = 'Nastavnici mogu obavljati sve operacije unutar kolegija, uključujući mijenjanje aktivnosti i ocjenjivanje studenata.';
$string['defaultcourseteachers'] = 'Nastavnici';
$string['delete'] = 'Izbriši';
$string['deleteablock'] = 'Izbriši blok';
$string['deleteall'] = 'Izbriši sve';
$string['deleteallcannotundo'] = 'Izbriši sve - nije moguće vratiti podatke';
$string['deleteallcomments'] = 'Izbriši sve komentare';
$string['deleteallratings'] = 'Izbriši sve ratinge';
$string['deletecategory'] = 'Izbriši kategoriju: {$a}';
$string['deletecategorycheck'] = 'Jeste li apsolutno sigurni da želite obrisati kategoriju pod nazivom <b>\'{$a}\'</b>?<br /> Navedena operacija će premjestiti sve kolegije koji se nalaze u toj kategoriji u nadređenu kategoriju (ako ista postoji), ili u kategoriju Razno.';
$string['deletecategorycheck2'] = 'Ako obrišete ovu kategoriju, morate odlučiti što ćete uraditi s kolegijima i potkategorijama koje ona sadržava.';
$string['deletecategoryempty'] = 'Ova kategorija je prazna.';
$string['deletecheck'] = 'Izbriši {$a} ?';
$string['deletecheckfiles'] = 'Jeste li u potpunosti sigurni da želite obrisati navedene datoteke?';
$string['deletecheckfull'] = 'Želite li uistinu u potpunosti izbrisati {$a} ?';
$string['deletechecktype'] = 'Želite li izbrisati {$a->type}?';
$string['deletechecktypename'] = 'Želite li izbrisati {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Obrisat ćete navedene datoteke';
$string['deletecomment'] = 'Izbriši ovaj komentar';
$string['deletecompletely'] = 'Obriši u potpunosti';
$string['deletecourse'] = 'Izbriši kolegij';
$string['deletecoursecheck'] = 'Želite li uistinu u potpunosti izbrisati ovaj kolegij i SVE podatke sadržane u njemu?';
$string['deleted'] = 'Izbrisano';
$string['deletedactivity'] = '{$a} izbrisan';
$string['deletedcourse'] = '{$a} u potpunosti izbrisan';
$string['deletednot'] = '{$a} se ne može izbrisati!';
$string['deletelogs'] = 'Izbriši zapise';
$string['deleteselected'] = 'Izbriši označeno';
$string['deleteselectedkey'] = 'Izbriši označeni ključ';
$string['deletingcourse'] = 'Brisanje {$a}';
$string['deletingexistingcoursedata'] = 'Brisanje postojeće podatke unutar kolegija';
$string['deletingolddata'] = 'Brisanje starih podataka';
$string['department'] = 'Odsjek';
$string['desc'] = 'Silazno';
$string['description'] = 'Opis';
$string['deselectall'] = 'Odznači sve';
$string['detailedless'] = 'Manje detalja';
$string['detailedmore'] = 'Više detalja';
$string['directory'] = 'Mapa';
$string['disable'] = 'Onemogući';
$string['disabledcomments'] = 'Komentari su onemogućeni';
$string['displayingfirst'] = 'Prikazano je samo prvih(a) {$a->count} {$a->things}';
$string['displayingrecords'] = 'Prikaz {$a} zapisa';
$string['displayingusers'] = 'Prikaz korisnika od {$a->start} do {$a->end}';
$string['displayonpage'] = 'Prikaži na stranici';
$string['dndenabled_inbox'] = 'Ovdje prenesite mišem datoteke koje želite dodati.';
$string['dndworkingfile'] = 'Datoteke možete prenijeti na poslužitelj tako da ih "prenesete mišem" (drag&drop) na željenu sekciju';
$string['dndworkingfilelink'] = 'Datoteke ili poveznice možete prenijeti na poslužitelj tako da ih "prenesete mišem" (drag&drop) na željenu sekciju';
$string['dndworkingfiletext'] = 'Datoteke ili tekst možete prenijeti na poslužitelj tako da ih "prenesete mišem" (drag&drop) na željenu sekciju';
$string['dndworkingfiletextlink'] = 'Datoteke, tekst ili poveznice možete prenijeti na poslužitelj tako da ih "prenesete mišem" (drag&drop) na željenu sekciju';
$string['dndworkinglink'] = 'Poveznice možete prenijeti na poslužitelj tako da ih "prenesete mišem" (drag&drop) na željenu sekciju';
$string['dndworkingtext'] = 'Tekst možete prenijeti na poslužitelj tako da ih "prenesete mišem" (drag&drop) na željenu sekciju';
$string['dndworkingtextlink'] = 'Tekst ili poveznice možete prenijeti na poslužitelj tako da ih "prenesete mišem" (drag&drop) na željenu sekciju';
$string['documentation'] = 'Moodle dokumentacija';
$string['dontsortcategories'] = 'Ne sortiraj kategorije';
$string['dontsortcourses'] = 'Ne sortiraj kolegije';
$string['down'] = 'Dolje';
$string['download'] = 'Preuzimanje';
$string['downloadall'] = 'Preuzmite sve';
$string['downloadexcel'] = 'Preuzimanje u MS Excel obliku';
$string['downloadfile'] = 'Preuzmi datoteku';
$string['downloadods'] = 'Preuzimanje u ODS obliku';
$string['downloadtext'] = 'Preuzimanje u tekstualnom obliku';
$string['doyouagree'] = 'Jeste li pročitali navedene uvjete i razumjeli ih u potpunosti?';
$string['droptoupload'] = 'Ovdje "ispustite" datoteke kako bi ih prenijeli na poslužitelj';
$string['duplicate'] = 'Izradi kopiju';
$string['duplicateconfirm'] = 'Želite li kopirati {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Povratak na kolegij';
$string['duplicatecontedit'] = 'Uredite novu kopiju';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' je uspješno kopiran/a';
$string['duplicatinga'] = 'Kopiranje: {$a}';
$string['edhelpaspellpath'] = 'Kako biste mogli koristiti provjeru pravopisa u uređivaču teksta, na vašem poslužitelju MORATE imati instaliran <strong>aspell 0.50</strong> ili noviji, i morate zadati točnu putanju (PATH) do aspell binarne datoteke. Na Unix/Linux zasnovanim sustavima ta putanja je obično <strong>/usr/bin/aspell</strong>, ali može biti i nešto drugo (PROVJERITE!).';
$string['edhelpbgcolor'] = 'Odredite pozadinsku boju polja za uređivanje.<br />Primjer vrijednosti koje se mogu zadati su: #ffffff ili white';
$string['edhelpcleanword'] = 'Ova postavka uključuje ili isključuje filtriranje MS Word obikovanja.';
$string['edhelpenablespelling'] = 'Uključite ili isključite provjeru pravopisa (spell-checking). Ako je provjera uključena, <strong>aspell</strong> mora biti instaliran na poslužitelju.';
$string['edhelpfontfamily'] = '';
$string['edhelpfontlist'] = 'Odredite fontove koji će se koristiti u padajućem izborniku.';
$string['edhelpfontsize'] = 'Određuje standardnu veličinu fonta (pisma). <br />Primjer vrijednosti koje se mogu zadati su: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Uredi';
$string['edita'] = 'Promijeni {$a}';
$string['editcategorysettings'] = 'Uredi postavke kategorije';
$string['editcategorythis'] = 'Uredi postavke kategorije';
$string['editcoursesettings'] = 'Promijeni postavke kolegija';
$string['editfiles'] = 'Uredi datoteke';
$string['editgroupprofile'] = 'Promijeni podatke o grupi';
$string['editinga'] = 'Uređivanje: {$a}';
$string['editingteachershort'] = 'Urednik';
$string['editlock'] = 'Ova vrijednost se ne može promijeniti!';
$string['editmyprofile'] = 'Promijeni osobne podatke';
$string['editorbgcolor'] = 'Boja pozadine';
$string['editorcleanonpaste'] = 'Pročisti Word HTML nakon operacije PASTE';
$string['editorcommonsettings'] = 'Zajedničke postavke';
$string['editordefaultfont'] = 'Standardni font (oblik slova)';
$string['editorenablespelling'] = 'Omogući provjeru pravopisa';
$string['editorfontlist'] = 'Popis fontova';
$string['editorfontsize'] = 'Zadana veličina slova';
$string['editorresettodefaults'] = 'Vrati na standardne postavke';
$string['editorsettings'] = 'Postavke uređivača';
$string['editorshortcutkeys'] = 'TIpkovničke kratice uređivača';
$string['editsettings'] = 'Uredi postavke';
$string['editsummary'] = 'Promijeni sažetak';
$string['editthisactivity'] = 'Promijeni ovu aktivnost';
$string['editthiscategory'] = 'Promijeni ovu kategoriju';
$string['edittitle'] = 'Uredite naslov';
$string['edittitleinstructions'] = 'Pritisnite tipku Esc za otkazivanje akcije ili Enter za potvrdu';
$string['edituser'] = 'Promijeni korisničke račune';
$string['email'] = 'Adresa e-pošte';
$string['emailactive'] = 'E-pošta aktivirana';
$string['emailagain'] = 'E-pošta (ponovno)';
$string['emailcharset'] = 'Kodna stranica poruke e-pošte';
$string['emailconfirm'] = 'Potvrdite svoj korisnicki racun';
$string['emailconfirmation'] = 'Postovana/i {$a->firstname},

Netko je zatrazio otvaranje korisnickog racuna unutar sustava \'{$a->sitename}\'
koristeci ovu adresu e-poste.

Kako bi korisnicki racun proradio, neophodna je potvrda registracije. Kako biste potvrdili registraciju posjetite sljedecu web adresu:

{$a->link}

U vecini programa za citanje e-poste, u redu iznad ovog biste trebali vidjeti plavo obojenu poveznicu na koju mozete kliknuti. U slucaju da to ne radi,
oznacite i kopirajte adresu u adresnu liniju vaseg internet preglednika (Firefox, Internet Explorer, Opera).

U slucaju da trebate tehnicku pomoc, molimo kontaktirajte administratora sustava,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: potvrda registracije korisnickog racuna';
$string['emailconfirmsent'] = '<p>Uskoro biste trebali primiti poruku e-poste na vasu adresu <b>{$a}</b></p>
   <p>Poruka sadrzava jednostavne upute o daljnjem postupku registracije.</p>
   <p>Ako imate tehnickih problema s registracijom ili pitanja u vezi iste, posaljite poruku e-postom administratoru sustava.</p>';
$string['emaildigest'] = 'Oblik obavijesti putem e-pošte';
$string['emaildigestcomplete'] = 'Potpuno (jedna dnevna poruka e-pošte sa punim forum porukama)';
$string['emaildigestoff'] = 'Pune (po jedna poruka e-pošte za svaki forum post)';
$string['emaildigestsubjects'] = 'Naslovi (jedna dnevna poruka e-pošte samo sa naslovima)';
$string['emaildisable'] = 'Ova adresa e-pošte je onemogućena';
$string['emaildisableclick'] = 'Kliknite ovdje za onemogućavanje slanja bilo kakve poruke e-pošte na ovu adresu.';
$string['emaildisplay'] = 'Prikaz adrese e-pošte';
$string['emaildisplaycourse'] = 'Dopusti jedino polaznicima kolegija (studentima i nastavniku) da vide moju adresu e-pošte.';
$string['emaildisplayhidden'] = 'Adresa e-pošte skrivena';
$string['emaildisplayno'] = 'Skrij moju adresu e-pošte od svih';
$string['emaildisplayyes'] = 'Dopusti svima da vide moju adresu e-pošte';
$string['emailenable'] = 'Ova adresa e-pošte je omogućena';
$string['emailenableclick'] = 'Kliknite ovdje za omogućavanje slanja poruka e-pošte na ovu adresu';
$string['emailexists'] = 'Ova adresa e-pošte je već registrirana otprije.';
$string['emailformat'] = 'Oblik poruke e-pošte';
$string['emailmustbereal'] = 'Napomena: vaša adresa e-pošte mora biti važeća.';
$string['emailnotallowed'] = 'Adrese e-pošte s navedene domene nisu dopuštene ({$a})';
$string['emailnotfound'] = 'Adresa e-pošte nije pronađena u bazi podataka';
$string['emailonlyallowed'] = 'Korištenje ove adrese e-pošte nije dopuštene ({$a})';
$string['emailpasswordchangeinfo'] = 'Postovana/i {$a->firstname},

netko (vjerojatno vi) je zatražio novu lozinku za svoj korisnički račun na \'{$a->sitename}\'.

Da biste promijenili svoju lozinku, molimo posjetite sljedeću web-adresu:

{$a->link}

U vecini programa za citanje e-poste, u redu iznad ovog biste trebali vidjeti plavo obojenu poveznicu na koju mozete kliknuti. U slucaju da to ne radi,
oznacite i kopirajte adresu u adresnu liniju vaseg internet preglednika (Firefox, Internet Explorer, Opera).

Ako vam je potrebna pomoć, molimo kontaktirajte administratora: {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Pozdrav, {$a->firstname},

Netko (vjerojatno vi) je zatrazio novu lozinku za vas korisnicki racun na sjedistu \'{$a->sitename}\'.

Nazalost, vas je racun na ovom sjedistu onemogucen i ne moze biti resetiran. Molimo, javite se administratoru sjedista, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Pozdrav, {$a->firstname},

Netko (vjerojatno vi) je zatrazio novu lozinku za vas korisnicki racun na sjedistu \'{$a->sitename}\'.

Nazalost, na ovom sjedistu lozinke se ne mogu resetirati. Molimo, javite se administratoru sjedista, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informacija o promjeni lozinke';
$string['emailpasswordconfirmation'] = 'Postovana/i {$a->firstname},

Netko (najvjerojatnije VI) je zatrazio novu lozinku (sifru, password) za vas korisnicki racun u sustavu \'{$a->sitename}\'.

Kako biste potvrdili potrebu za novom lozinkom i dobili novu lozinku putem elektronicke poste, posjetite ovu web adresu:

{$a->link}

U vecini programa za citanje e-poste, u redu iznad ovog biste trebali vidjeti plavo obojenu poveznicu na koju mozete kliknuti. U slucaju da to ne radi,
oznacite i kopirajte adresu u adresnu liniju vaseg internet preglednika (Firefox, Internet Explorer, Opera).
U slucaju da trebate tehnicku pomoc, molimo kontaktirajte administratora sustava,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: potvrda promjene lozinke';
$string['emailpasswordconfirmmaybesent'] = '<p>Ako ste upisali ispravno korisničko ime ili adresu e-pošte, poruka bi vam trebala biti poslana e-poštom.</p>
<p>E-pošta sadrži jednostavne upute za potvrdu promjene lozinke. Ako budete imali problema, molimo javite se administratoru sjedišta.</p>';
$string['emailpasswordconfirmsent'] = 'Trebali ste primiti poruku e-poste poslanu na adresu <b>{$a}</b>.
<p>Poruka sadrzi jednostavne upute kako potvrditi zatrazenu promjenu lozinke.
U slucaju da trebate tehnicku pomoc, molimo kontaktirajte administratora sustava';
$string['emailpasswordsent'] = 'Zahvaljujemo na potvrdjenju zahtjeva za promjenu lozinke.
<p>Poruka e-poste koja sadrzava vasu novu lozinku je poslana na vasu adresu <b>{$a->email}</b>.</p>
<p>Nova lozinka je automatski generirana - preporucujemo da istu <a href="{$a->link}"<promijenite </a> CIM ju dobijete u lozinku koju cete lakse zapamtiti.</p>';
$string['enable'] = 'Omogući';
$string['encryptedcode'] = 'Enkriptirani kod';
$string['english'] = 'Engleski';
$string['enrolmentmethods'] = 'Načini upisa';
$string['entercourse'] = 'Kliknite za pristup kolegiju';
$string['enteremail'] = 'Unesite svoju adresu e-pošte';
$string['enteremailaddress'] = 'Unesite svoju adresu e-pošte kako bi sustav resetirao vašu lozinku (načinio novu lozinku automatski) i istu vam poslao na navedenu adresu.';
$string['enterusername'] = 'Unesite vaše korisničko ime';
$string['entries'] = 'Unosi';
$string['error'] = 'Greška';
$string['errorcreatingactivity'] = 'Nije bilo moguće stvoriti instancu aktivnosti  \'{$a}\'';
$string['errorfiletoobig'] = 'Datoteka je veća od ograničenja: {$a} byte';
$string['errornouploadrepo'] = 'Ne postoji repozitorij za prijenos za ovo sjedište';
$string['errorwhenconfirming'] = 'Vaš korisnički račun nije još potvrđen zbog pogreške koja se dogodila. Ako ste kliknuli na poveznicu koju ste dobili u poruci e-pošte, molimo provjerite je li linija u kojoj se nalazi navedena poveznica ispravna (odnosno, je li ju vaš klijent za čitanje e-pošte možda oblikovao u dva reda, čime je dio poveznice završio u drugom redu). Postoji mogućnost da ćete morati ručnim kopiranjem i unosom rekonstruirati izvornu poveznicu.';
$string['eventcourseupdated'] = 'Kolegij osvježen';
$string['eventuserlistviewed'] = 'Pregledan popis korisnika';
$string['eventuserprofileviewed'] = 'Pregledan korisnički profil';
$string['everybody'] = 'Svi';
$string['executeat'] = 'Izvrši u';
$string['existing'] = 'Postojeći';
$string['existingadmins'] = 'Postojeći administratori';
$string['existingcourse'] = 'Postojeći kolegij';
$string['existingcourseadding'] = 'Postojeći kolegij, dodavanje podataka u isti';
$string['existingcoursedeleting'] = 'Postojeći kolegij, brisanje istog';
$string['existingcreators'] = 'Postojeći kreatori kolegija';
$string['existingstudents'] = 'Postojeći studenti';
$string['existingteachers'] = 'Postojeći nastavnici';
$string['expand'] = 'Proširi';
$string['expandall'] = 'Proširi sve';
$string['expandcategory'] = 'Proširi {$a}';
$string['explanation'] = 'Objašnjenje';
$string['extendenrol'] = 'Produlji upis (individualno)';
$string['extendperiod'] = 'Trajanje produljenja';
$string['failedloginattempts'] = '{$a->attempts} neuspješnih prijava sustavu od vaše zadnje prijave';
$string['failedloginattemptsall'] = '{$a->attempts} neuspješnih prijava sustavu putem {$a->accounts} korisničkog računa';
$string['feedback'] = 'Povratna informacija (Feedback)';
$string['file'] = 'Datoteka';
$string['fileexists'] = 'Već postoji datoteka nazvana  {$a}';
$string['filemissing'] = '{$a} nedostaje';
$string['files'] = 'Datoteke';
$string['filesanduploads'] = 'Datoteke i prijenos datoteka';
$string['filesfolders'] = 'Datoteke/mape';
$string['filetoolarge'] = 'je prevelika za prijenos na poslužitelj';
$string['fileuploadwithcontent'] = 'Prenešene datoteke ne bi trebale obuhvaćati parametar sadržaja';
$string['filloutallfields'] = 'Molimo ispunite sva polja na ovom obrascu';
$string['filter'] = 'Filtar';
$string['findmorecourses'] = 'Pronađite druge kolegije...';
$string['first'] = 'Prvi';
$string['firstaccess'] = 'Prvi pristup';
$string['firstname'] = 'Ime';
$string['firstnamephonetic'] = 'Ime - fonetski';
$string['firsttime'] = 'Ovdje ste prvi put?';
$string['folder'] = 'Mapa';
$string['folderclosed'] = 'Zatvorena mapa';
$string['folderopened'] = 'Otvorena mapa';
$string['followingoptional'] = 'Sljedeći podaci su opcionalni';
$string['followingrequired'] = 'Sljedeći podaci su obvezni';
$string['force'] = 'Obvezno';
$string['forcelanguage'] = 'Obvezna uporaba jezika (ili kodne stranice)';
$string['forceno'] = 'Ne obvezuj';
$string['forcepasswordchange'] = 'Obveži na promjenu lozinke';
$string['forcepasswordchangecheckfull'] = 'Želite li uistinu obvezati {$a} na promjenu lozinke?';
$string['forcepasswordchange_help'] = 'Ako je ovo označeno, korisnik će morati promijeniti lozinku prilikom sljedeće prijave';
$string['forcepasswordchangenot'] = 'Nije bilo moguće obvezati {$a} na promjenu lozinke';
$string['forcepasswordchangenotice'] = 'Morate promijeniti svoju lozinku kako biste mogli nastaviti s radom.';
$string['forcetheme'] = 'Obvezna uporaba teme';
$string['forgotaccount'] = 'Zaboravili ste lozinku?';
$string['forgotten'] = 'Zaboravili ste svoje korisničko ime ili lozinku?';
$string['forgottenduplicate'] = 'Ovu adresu e-pošte dijeli više korisničkih računa, molim unesite korisničko ime';
$string['forgotteninvalidurl'] = 'Nevažeći URL za promjenu lozinke';
$string['format'] = 'Oblik';
$string['format_help'] = 'Oblik kolegija određuje izgled naslovnice kolegija.

* SCORM - Za prikaz SCORM paketa u prvoj sekciji stranice kolegija (kao alternativa korištenju SCORM/AICC modula)
* Društveni oblik - Forum na naslovnici kolegija
* Tematski oblik - Naslovnica kolegija je organizirana u tematske sekcije
* Tjedni oblik - Naslovnica kolegija je organizirana u tjedne sekcije, pri čemu je početni tjedan jednak datumu početka kolegija';
$string['formathtml'] = 'HTML oblik';
$string['formatmarkdown'] = 'Markdown oblik';
$string['formatplain'] = 'Tekstualni oblik';
$string['formattext'] = 'Moodle auto-oblik';
$string['formattexttype'] = 'Oblikovanje';
$string['framesetinfo'] = 'Ovaj frameset dokument sadrži:';
$string['from'] = 'Od';
$string['frontpagecategorycombo'] = 'Kombinirani popis';
$string['frontpagecategorynames'] = 'Prikaži popis kategorija';
$string['frontpagecourselist'] = 'Prikaži popis kolegija';
$string['frontpagecoursesearch'] = 'Polje za pretraživanje kolegija';
$string['frontpagedescription'] = 'Opis na naslovnici';
$string['frontpagedescriptionhelp'] = 'Ovaj opis sustava možete prikazati na naslovnici.';
$string['frontpageenrolledcourselist'] = 'Upisani kolegiji';
$string['frontpageformat'] = 'Oblik naslovnice';
$string['frontpageformatloggedin'] = 'Oblik naslovnice kada je korisnik prijavljen';
$string['frontpagenews'] = 'Najprije prikaži vijesti';
$string['frontpagesettings'] = 'Postavke naslovnice';
$string['fulllistofcourses'] = 'Svi kolegiji';
$string['fullname'] = 'Puno ime';
$string['fullnamecourse'] = 'Naziv kolegija';
$string['fullnamecourse_help'] = 'Naziv kolegija se prikazuje na vrhu svake stranice kolegija i na popisu kolegija.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Puno ime';
$string['fullprofile'] = 'Puni profil';
$string['fullsitename'] = 'Puno ime web-sitea';
$string['functiondisabled'] = 'Navedena funkcionalnost je trenutno iskljlučena';
$string['general'] = 'Opće';
$string['geolocation'] = 'širina - dužina';
$string['gettheselogs'] = 'Dohvati ove zapise';
$string['go'] = 'Kreni';
$string['gpl'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details: http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details: http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL licenca';
$string['grade'] = 'Ocjena';
$string['grades'] = 'Ocjene';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> je omogućen za ovo sjedište. Ako sami ne zadate svoju profilnu sliku, Moodle će pokušati učitati istu s Gravatara.';
$string['group'] = 'Grupa';
$string['groupadd'] = 'Dodaj novu grupu';
$string['groupaddusers'] = 'Dodaj odabrane polaznike u grupu';
$string['groupextendenrol'] = 'Produljeni upis (zajednički)';
$string['groupfor'] = 'za grupu';
$string['groupinfo'] = 'Informacije o odabranoj grupi';
$string['groupinfoedit'] = 'Promijeni grupne postavke';
$string['groupinfomembers'] = 'Informacije o odabranim članovima';
$string['groupinfopeople'] = 'Informacije o odabranim korisnicima';
$string['groupmembers'] = 'Članovi grupe';
$string['groupmemberssee'] = 'Prikaži članove grupe';
$string['groupmembersselected'] = 'Članovi odabrane grupe';
$string['groupmode'] = 'Grupni oblik';
$string['groupmodeforce'] = 'Obveži na grupni oblik nastave';
$string['groupmy'] = 'Moja grupa';
$string['groupnonmembers'] = 'Polaznici koji nisu u grupi';
$string['groupnotamember'] = 'Nažalost, niste član te grupe';
$string['grouprandomassign'] = 'Slučajnim odabirom rasporedi sve polaznike u grupe';
$string['groupremove'] = 'Ukloni odabranu grupu';
$string['groupremovemembers'] = 'Ukloni odabrane članove';
$string['groups'] = 'Grupe';
$string['groupsnone'] = 'Bez grupa';
$string['groupsseparate'] = 'Odvojene grupe';
$string['groupsvisible'] = 'Vidljive grupe';
$string['guest'] = 'Gost';
$string['guestdescription'] = 'Gosti imaju minimalne ovlasti i obično ne mogu nigdje unositi tekst.';
$string['guestskey'] = 'Dopusti pristup gostima koji imaju lozinku kolegija';
$string['guestsno'] = 'Zabrani pristup gostima';
$string['guestsnotallowed'] = 'Nažalost, kolegij \'{$a}\' ne dopušta pristup gostima (anonimnim korisnicima).';
$string['guestsyes'] = 'Dopusti pristup gostima bez lozinke kolegija';
$string['guestuser'] = 'Gost (anonimni korisnik)';
$string['guestuserinfo'] = 'Gost (anonimni korisnik) može pristupiti kolegiju, ali ne može sudjelovati u dodavanju BILO KAKVOG sadržaja ili ispunjavanju testova (tzv. read-only pristup).';
$string['help'] = 'Pomoć';
$string['helpprefix2'] = 'Pomoć za {$a}';
$string['helpwiththis'] = 'Pomoć za ovo';
$string['hiddenassign'] = 'Skrivena zadaća';
$string['hiddenfromstudents'] = 'Skriveno od studenata';
$string['hiddensections'] = 'Skriveni dijelovi';
$string['hiddensectionscollapsed'] = 'Skriveni dijelovi su prikazani u minimalnom obliku';
$string['hiddensections_help'] = 'Ova opcija određuje hoće li se skriveni dijelovi kolegija studentima prikazivati u sažetom obliku (npr. za kolegij u tjednom obliku, za prikaz praznika) ili su takvi dijelovi u potpunosti skriveni.';
$string['hiddensectionsinvisible'] = 'Skriveni dijelovi su u potpunosti nevidljivi polaznicima';
$string['hide'] = 'Skrij';
$string['hideadvancedsettings'] = 'Skrij napredne postavke';
$string['hidepicture'] = 'Skrij sliku';
$string['hidesection'] = 'Skrij sekciju {$a}';
$string['hidesettings'] = 'Skrij postavke';
$string['hideshowblocks'] = 'Skrij ili prikaži blokove';
$string['hits'] = 'Posjeti';
$string['hitsoncourse'] = '{$a->username} je kolegij {$a->coursename} posjetio/la';
$string['hitsoncoursetoday'] = 'Današnji posjeti korisnika {$a->username} kolegiju {$a->coursename}';
$string['home'] = 'Naslovnica';
$string['hour'] = 'sat';
$string['hours'] = 'sat(a)';
$string['howtomakethemes'] = 'Kako napraviti vlastite teme';
$string['htmleditor'] = 'Koristi HTML uređivač';
$string['htmleditoravailable'] = 'HTML editor je raspoloživ';
$string['htmleditordisabled'] = 'Isključili ste uporabu HTML editora za vaš korisnički profil';
$string['htmleditordisabledadmin'] = 'Administrator sustava je isključio uporabu HTML editora na razini cijelog sustava';
$string['htmleditordisabledbrowser'] = 'Uporaba HTML editora nije moguća jer vaš web browser nije kompatibilan s istim';
$string['htmlfilesonly'] = 'Isključivo HTML datoteke';
$string['htmlformat'] = 'Uljepšani HTML oblik';
$string['icon'] = 'Ikona';
$string['icqnumber'] = 'ICQ broj';
$string['idnumber'] = 'ID broj';
$string['idnumbercourse'] = 'ID broj kolegija';
$string['idnumbercoursecategory'] = 'ID broj kategorije';
$string['idnumbercoursecategory_help'] = 'ID broj kategorije kolegija se koristi samo za usporedbu dotične kategorije s vanjskim sustavima i ne prikazuje se nigdje na sjedištu. Ako kategorija ima službeni naziv, možete ga ovdje unijeti, u suprotnome, ostavite polje praznim.';
$string['idnumbercourse_help'] = 'ID kolegija se koristi samo prilikom usporedbe s vanjskim sustavima te nije prikazan nigdje na sjedištu. Ako kolegij ima neku službenu šifru, dobro je unijeti ju, ili polje možete ostaviti prazno.';
$string['idnumbergroup'] = 'ID broj grupe';
$string['idnumbergroup_help'] = 'ID broj grupe se koristi samo za usporedbu dotične grupe s vanjskim sustavima i ne prikazuje se nigdje na sjedištu. Ako grupa ima službeni naziv, možete ga ovdje unijeti, u suprotnome, ostavite polje praznim.';
$string['idnumbergrouping'] = 'ID broj grupacije';
$string['idnumbergrouping_help'] = 'ID broj grupacije se koristi samo za usporedbu dotične grupacije s vanjskim sustavima i ne prikazuje se nigdje na sjedištu. Ako grupacija ima službeni naziv, možete ga ovdje unijeti, u suprotnome, ostavite polje praznim.';
$string['idnumbermod'] = 'ID broj';
$string['idnumbermod_help'] = 'Postavljanje ID-a omogućuje identifikaciju aktivnosti u svrhu računanja ocjena. Ako aktivnost nije obuhvaćena nekim od ocjenjivanja, polje koje sadržava ID broj se može ostaviti praznim.

ID se također može postaviti u alatu za ocjenjivanje, no može se uređivati jedino na stranici s postavkama aktivnosti.';
$string['idnumbertaken'] = 'ID broj je zauzet (postoji od prije)';
$string['imagealt'] = 'Opis slike';
$string['import'] = 'Uvoz';
$string['importdata'] = 'Uvezi podatke kolegija';
$string['importdataexported'] = 'Izvoz podataka iz izvornog kolegija prošao je uspješno. <br /> Slijedi uvoz podataka u odredišni kolegij';
$string['importdatafinished'] = 'Uvoz podataka je uspješno završio! Nastavite prema vašem kolegiju';
$string['importdatafrom'] = 'Pronađite kolegij iz kojeg želite uvesti podatke:';
$string['inactive'] = 'Neaktivan';
$string['include'] = 'Obuhvati';
$string['includeallusers'] = 'Obuhvati sve korisnike';
$string['includecoursefiles'] = 'Obuhvati datoteke kolegija';
$string['includecourseusers'] = 'Obuhvati polaznike kolegija';
$string['included'] = 'Obuhvaćeni';
$string['includelogentries'] = 'Obuhvati zapise u logu';
$string['includemodules'] = 'Obuhvati module';
$string['includemoduleuserdata'] = 'Obuhvati korisničke podatke nastale unutar modula';
$string['includeneededusers'] = 'Obuhvati neophodne korisnike';
$string['includenoneusers'] = 'Ne obuhvaćaj korisnike';
$string['includeroleassignments'] = 'Obuhvati dodijeljene uloge';
$string['includesitefiles'] = 'Obuhvati datoteke na razini poslužitelja korištene u ovom kolegiju';
$string['includeuserfiles'] = 'Obuhvati korisničke datoteke';
$string['increasesections'] = 'Povećaj broj tema';
$string['info'] = 'Informacija';
$string['institution'] = 'Institucija';
$string['instudentview'] = 'u studentskom pogledu';
$string['interests'] = 'Interesi';
$string['interestslist'] = 'Popis interesa';
$string['interestslist_help'] = 'Unesite vaše interese odvojene zarezima. Vaši interesi će biti prikazani na vašem profilu kao oznake (tagovi).';
$string['invalidemail'] = 'Nevažeća adresa e-pošte';
$string['invalidlogin'] = 'Problem s korisničkim imenom, pokušajte ponovno';
$string['invalidusername'] = 'Može sadržavati SAMO mala slova i/ili brojeve, podcrtu(_), crticu (-), točku (.) ili AT simbol (@)';
$string['invalidusernameupload'] = 'Netočno korisničko ime';
$string['ip_address'] = 'IP adresa';
$string['jump'] = 'Prikaži';
$string['jumpto'] = 'Prikaži...';
$string['keep'] = 'Zadrži';
$string['keepsearching'] = 'Nastavi pretraživanje';
$string['langltr'] = 'Smjer pisanja lijevo na desno';
$string['langrtl'] = 'Smjer pisanja desno na lijevo';
$string['language'] = 'Jezik';
$string['languagegood'] = 'Ovaj jezični paket je ažuran! :-)';
$string['last'] = 'Zadnji';
$string['lastaccess'] = 'Zadnji pristup';
$string['lastedited'] = 'Zadnji puta promijenjeno';
$string['lastlogin'] = 'Zadnja prijava na sustav';
$string['lastmodified'] = 'Zadnji puta izmijenjeno';
$string['lastname'] = 'Prezime';
$string['lastnamephonetic'] = 'Prezime - fonetski';
$string['lastyear'] = 'Prošle godine';
$string['latestlanguagepack'] = 'Provjeri jezični paket na moodle.org (postoji li novija inačica)';
$string['layouttable'] = 'Tablica rasporeda';
$string['leavetokeep'] = 'Ostavite ovo polje prazno kako bi zadržali postojeću lozinku';
$string['legacythemeinuse'] = 'Ove stranice vam se prikazuju u tzv. načinu kompatibilnosti jer je vaš internet preglednik zastario.';
$string['license'] = 'Licenca';
$string['licenses'] = 'Licence';
$string['liketologin'] = 'Želite li se prijaviti sustavu s pravim korisničim računom?';
$string['list'] = 'Popis';
$string['listfiles'] = 'Popis dokumenata u {$a}';
$string['listofallpeople'] = 'Popis svih korisnika';
$string['listofcourses'] = 'Popis svih kolegija';
$string['loadinghelp'] = 'Učitavanje...';
$string['local'] = 'Lokalno';
$string['localplugins'] = 'Lokalni dodaci';
$string['localpluginsmanage'] = 'Uredi lokalne dodatke';
$string['location'] = 'Lokacija';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Prijavljeni ste kao {$a}';
$string['loggedinasguest'] = 'Trenutno koristite anonimni pristup sustavu';
$string['loggedinnot'] = 'Niste prijavljeni na sustav.';
$string['login'] = 'Prijava';
$string['loginalready'] = 'Već ste se prijavili';
$string['loginas'] = 'Prijavi se kao';
$string['loginaspasswordexplain'] = '<p>Morate uneti posebnu "pristupi sustavu kao" lozinku da biste koristili ovu mogućnost.<br />Ako ne znate tu lozinku, pitajte administratora svog poslužitelja.</p>';
$string['login_failure_logs'] = 'Log pogrešaka pri prijavi sustavu';
$string['loginguest'] = 'Prijava kao gost';
$string['loginsite'] = 'Prijava na sustav';
$string['loginsteps'] = 'Kako biste imali puni pristup kolegijima na ovom sustavu, morate stvoriti novi korisnički račun.
Svaki od pojedinih kolegija može također imati i od vas tražiti "lozinku kolegija", koju trebate dobiti od svog nastavnika i koja se unosi samo prilikom prvog prijavljivanja na kolegij. Slijedite ove upute:
   <ol size="2">
   <li>Ispunite online obrazac <a href="{$a}">Novi korisnički račun</a> unosom osobnih podataka.</li>
   <li>Po predaji online obrasca trebala bi vam doći poruka e-pošte na adresu koju ste naveli.</li>
   <li>Pažljivo pročitajte poruku e-pošte i kliknite na poveznicu koja se nalazi u njoj.</li>
   <li>Vaš korisnički račun će time biti potvrđen i vi ćete se moći prijaviti sustavu.</li>
   <li>Potom biste trebali odabrati kolegij u radu kojeg želite ili trebate sudjelovati.</li>
   <li>Ako vas sustav zatraži "lozinku kolegija" - upotrijebite onu koju vam je dao vaš nastavnik na navedenom kolegiju.</li>
   <li>Nakon unosa ispravne "lozinke kolegija" možete pristupiti kolegiju (odnosno, od tog trenutka ste upisani na isti). Ubuduće vam za pristup kolegiju treba samo vaše korisničko ime i lozinka.</li>
   </ol>';
$string['loginstepsnone'] = '<p>Poštovani budući korisniče!</p>
<p>Za potpuni pristup kolegijima morate stvoriti korisnički račun.</p>
<p>Sve što trebate učiniti je smisliti korisničko ime i lozinku i unijeti iste u za to određena polja u obrascu na ovoj stranici!</p>
<p>Ako je netko prije vas već odabrao identično korisničko ime, morate odabrati neko drugo i pokušati ponovno.</p>';
$string['loginto'] = 'Prijavi se na {$a}';
$string['logout'] = 'Odjava';
$string['logoutconfirm'] = 'Želite li se uistinu odjaviti?';
$string['logs'] = 'Zapisi';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">više</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">više</a> ]';
$string['lookback'] = 'Pogled unazad';
$string['mailadmins'] = 'Obavijesti administratore';
$string['mailstudents'] = 'Obavijesti studente';
$string['mailteachers'] = 'Obavijesti nastavnike';
$string['maincoursepage'] = 'Naslovnica kolegija';
$string['makeafolder'] = 'Stvorite mapu';
$string['makeeditable'] = 'Ako servisu web poslužitelja (npr. apache) omogućite pisanje po \'{$a}\', tada ćete moći uređivati ovu datoteku direktno s ove stranice';
$string['makethismyhome'] = 'Učini ovo mojom naslovnicom';
$string['manageblocks'] = 'Blokovi';
$string['managecategorythis'] = 'Upravljanje kolegijima i kategorijama';
$string['managecourses'] = 'Uredi kolegije';
$string['managedatabase'] = 'Baza podataka';
$string['manageeditorfiles'] = 'Uredi datoteke koje koristi uređivač';
$string['managefilters'] = 'Filtri';
$string['managemodules'] = 'Moduli';
$string['manageroles'] = 'Uloge i ovlasti';
$string['markedthistopic'] = 'Ova tema je istaknuta kao trenutna tema';
$string['markthistopic'] = 'Istakni ovu temu kao trenutnu temu';
$string['matchingsearchandrole'] = 'Uparivanje \'{$a->search}\' i {$a->role}';
$string['maxbytesforfile'] = 'Datoteka {$a} je veća od najveće dopuštene veličine.';
$string['maxfilesize'] = 'Najveća veličina novih datoteka: {$a}';
$string['maxfilesreached'] = 'Najveći broj datoteka koje možete dodati je: {$a}';
$string['maximumchars'] = 'Najveći dopušteni broj znakova:  {$a}';
$string['maximumgrade'] = 'Najviša ocjena';
$string['maximumgradex'] = 'Najviša ocjena: {$a}';
$string['maximumshort'] = 'Maks.';
$string['maximumupload'] = 'Najveća dopuštena veličina prenešene datoteke';
$string['maximumupload_help'] = 'Ova opcija određuje najveću moguću veličinu datoteke koja se može prenijeti na kolegij, a ograničena postavkom za cijelo sjedište koju određuje administrator. Moduli aktivnosti također sadrže postavku najveće moguće veličine datoteke koja može dodatno ograničiti veličinu datoteke.';
$string['maxnumberweeks'] = 'Najveći dopušteni broj tjedana/tema';
$string['maxnumberweeks_desc'] = 'Određuje najveći dopušteni broj tjedana/tema koji se pojavljuje u postavkama kolegija pod "Broj tjedana/tema". (Primjenjuje se samo na neke oblike kolegija.)';
$string['maxnumcoursesincombo'] = 'Pregledajte <a href="{$a->link}">kolegije: {$a->numberofcourses}</a>';
$string['maxsize'] = 'Najveća veličina: {$a}';
$string['maxsizeandareasize'] = 'Najveća dopuštena veličina za nove datoteke: {$a->size}, općenito ograničenje: {$a->areasize}';
$string['maxsizeandattachments'] = 'Najveća dopuštena veličina za nove datoteke: {$a->size}, najveći broj priloga: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Najveća dopuštena veličina za nove datoteke: {$a->size}, najveći broj priloga: {$a->attachments}, općenito ograničenje: {$a->areasize}';
$string['memberincourse'] = 'Polaznici na kolegiju';
$string['messagebody'] = 'Tijelo poruke';
$string['messagedselectedusers'] = 'Odabranim studentima je poslana poruka i popis primatelja je izbrisan.';
$string['messagedselectedusersfailed'] = 'Nešto nije bilo u redu pri slanju poruke odabranim korisnicima. Neki njih su ipak možda primili poslanu poruku.';
$string['messageprovider:availableupdate'] = 'Obavijesti o dostupnim nadogradnjama';
$string['messageprovider:backup'] = 'Obavijesti o backup proceduri';
$string['messageprovider:courserequestapproved'] = 'Obavijesti o stvaranju zahtijevanih kolegija';
$string['messageprovider:courserequested'] = 'Obavijest o zahtjevu za otvaranje kolegija';
$string['messageprovider:courserequestrejected'] = 'Obavijest o odbijanju zahtjeva za otvaranje kolegija';
$string['messageprovider:errors'] = 'Važne pogreške na razini poslužitelja';
$string['messageprovider:errors_help'] = 'Ovo su važne obavijesti koje bi administrator morao pročitati.';
$string['messageprovider:instantmessage'] = 'Osobne poruke između korisnika';
$string['messageprovider:instantmessage_help'] = 'U ovoj se sekciji podešava što bi se trebalo desiti porukama koje su vam poslane od strane drugih korisnika na poslužitelju.';
$string['messageprovider:notices'] = 'Obavijesti o manjim problemima';
$string['messageprovider:notices_help'] = 'Ove bi obavijesti administrator trebao vidjeti.';
$string['messageselect'] = 'Odaberite ovogo korisnika kao primatelja poruke';
$string['messageselectadd'] = 'Pošalji poruku';
$string['middlename'] = 'Srednje ime';
$string['migratinggrades'] = 'Premještanje ocjena';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minuta';
$string['minutes'] = 'minute';
$string['miscellaneous'] = 'Razno';
$string['missingcategory'] = 'Morate odabrati kategoriju';
$string['missingcity'] = 'Nedostaje grad';
$string['missingcountry'] = 'Nedostaje država';
$string['missingdescription'] = 'Nedostaje opis';
$string['missingemail'] = 'Nedostaje adresa e-pošte';
$string['missingfirstname'] = 'Nedostaje ime';
$string['missingfromdisk'] = 'Nedostaje na disku';
$string['missingfullname'] = 'Nedostaje puno ime i prezime';
$string['missinglastname'] = 'Nedostaje prezime';
$string['missingname'] = 'Nedostaje ime';
$string['missingnewpassword'] = 'Nedostaje nova lozinka';
$string['missingpassword'] = 'Nedostaje lozinka';
$string['missingrecaptchachallengefield'] = 'Nedostaje polje za reCAPTCHA';
$string['missingreqreason'] = 'Nedostaje razlog';
$string['missingshortname'] = 'Nedostaje kratica';
$string['missingshortsitename'] = 'Nedostaje kratko ime sitea';
$string['missingsitedescription'] = 'Nedostaje opis sitea';
$string['missingsitename'] = 'Nedostaje naziv sitea';
$string['missingstrings'] = 'Provjera nizova koji nedostaju (missing strings)';
$string['missingstudent'] = 'Morate odabrati NEŠTO';
$string['missingsummary'] = 'Nedostaje sažetak';
$string['missingteacher'] = 'Morate odabrati NEŠTO';
$string['missingurl'] = 'Nedostaje URL';
$string['missingusername'] = 'Nedostaje korisničko ime';
$string['modchooserdisable'] = 'Odvojeni izbornici omogućeni';
$string['modchooserenable'] = 'Odvojeni izbornici onemogućeni';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} ne podržava prenešene datoteke vrste {$a->type}';
$string['modified'] = 'Izmijenjeno';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Podešavam tablice modula';
$string['modulesuccess'] = '{$a} tablice su uspješno podešene ';
$string['modulesused'] = 'Korišteni moduli';
$string['month'] = 'Mjesec';
$string['months'] = 'Mjeseci';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Moodle Docs za ovu stranicu';
$string['moodlerelease'] = 'Moodle inačica';
$string['moodleversion'] = 'Moodle inačica';
$string['more'] = 'više';
$string['morehelp'] = 'Opširniji tekst pomoći';
$string['moreinformation'] = 'Više informacija o ovoj pogrešci';
$string['moreprofileinfoneeded'] = 'Molimo recite nam nešto više o sebi';
$string['mostrecently'] = 'most recently';
$string['move'] = 'Premjesti';
$string['movecategorycontentto'] = 'Premjesti u:';
$string['movecategorysuccess'] = 'Kategorija \'{$a->moved}\' je uspješno premještena u kategoriju \'{$a->to}\'';
$string['movecategoryto'] = 'Premjesti kategoriju u:';
$string['movecontent'] = 'Premjesti {$a}';
$string['movecontentstoanothercategory'] = 'Premjesti sadržaj u drugu kategoriju';
$string['movecoursemodule'] = 'Premjesti resurs';
$string['movecoursesection'] = 'Premjesti sekciju/temu';
$string['movecourseto'] = 'Premjesti kolegij u:';
$string['movedown'] = 'Premjesti dolje';
$string['movefilestohere'] = 'Premjesti datoteke ovamo';
$string['movefull'] = 'Premjesti {$a} na ovo mjesto';
$string['movehere'] = 'Premjesti ovamo';
$string['moveleft'] = 'Pomakni ulijevo';
$string['moveright'] = 'Pomakni udesno';
$string['movesection'] = 'Premjesti sekciju {$a}';
$string['moveselectedcategoriesto'] = 'Premjesti odabrane kategorije u';
$string['moveselectedcoursesto'] = 'Premjesti odabrane kolegije u...';
$string['movetoanotherfolder'] = 'Premjesti u drugu mapu';
$string['moveup'] = 'Premjesti gore';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Nova lozinka mora biti RAZLIČITA od prethodne!!';
$string['mustconfirm'] = 'Morate potvrditi vašu prijavu sustavu (login)';
$string['mycourses'] = 'Moji kolegiji';
$string['myfiles'] = 'Osobne datoteke';
$string['myfilesmanage'] = 'Uredi osobne datoteke';
$string['myhome'] = 'Moja naslovnica';
$string['mymoodledashboard'] = 'My Moodle upravljačka ploča';
$string['myprofile'] = 'Moj profil';
$string['name'] = 'Ime';
$string['nameforlink'] = 'Kako želite nazvati ovu poveznicu?';
$string['nameforpage'] = 'Naziv stranice';
$string['navigation'] = 'Navigacija';
$string['needed'] = 'Potrebno';
$string['never'] = 'Nikad';
$string['neverdeletelogs'] = 'Nikad ne briši zapise';
$string['new'] = 'Novo';
$string['newaccount'] = 'Novi korisnički račun';
$string['newcourse'] = 'Novi kolegij';
$string['newpassword'] = 'Nova lozinka';
$string['newpasswordfromlost'] = '<strong>NAPOMENA:</strong> Vaša <strong>trenutna lozinka</strong> će vam biti poslana u <strong>drugoj</strong> poruci e-pošte u sklopu procesa izdavanja nove lozinke. Provjerite jeste li primili zamjensku lozinku prije nego nastavite s operacijama na ovom ekranu.';
$string['newpassword_help'] = 'Unesite novu lozinku ili ostavite ovo polje praznim ako želite zadržati trenutnu lozinku.';
$string['newpasswordtext'] = '{$a->firstname},

Vasa lozinka za koristenje sustavom \'{$a->sitename}\'  je resetirana i dodijeljena vam je nova privremena lozinka.

Vasi trenutni podaci za prijavu sustavu su:
   korisnicko ime (username): {$a->username}
   lozinka (password): {$a->newpassword}

Molimo posjetite ovu stranicu kako biste promijenili svoju lozinku:
   {$a->link}

U vecini programa za citanje e-poste, u redu iznad ovog biste trebali vidjeti plavo obojenu poveznicu na koju mozete kliknuti. U slucaju da to ne radi,
oznacite i kopirajte adresu u adresnu liniju vaseg internet preglednika (Firefox, Internet Explorer, Opera).

U slucaju da trebate tehnicku pomoc, molimo kontaktirajte administratora sustava,
{$a->signoff}

Pozdrav,
\'{$a->sitename}\' administrator,
{$a->signoff}';
$string['newpicture'] = 'Nova slika';
$string['newpicture_help'] = 'Kako bi dodali novu sliku, pronađite i odaberite istu (u JPG ili PNG obliku), potom kliknite na "Promijeni osobne podatke". Slika će biti isječena (crop) na kvadratni oblik veličine 100x100 piksela.';
$string['newsitem'] = 'vijest';
$string['newsitems'] = 'vijesti';
$string['newsitemsnumber'] = 'Broj vijesti koje treba prikazati';
$string['newsitemsnumber_help'] = 'Ova opcija određuje koliko će se stavki pojaviti u bloku Nedavna aktivnost, na stranici kolegija. Ako je postavljena na "0 stavki", blok s nedavnim aktivnostima se neće prikazivati.';
$string['newuser'] = 'Novi korisnik';
$string['newusernewpasswordsubj'] = 'Novi korisnicki racun';
$string['newusernewpasswordtext'] = 'Pozdrav, {$a->firstname},

Otvoren vam je novi korisnicki racun na sjedistu \'{$a->sitename}\' i dodijeljena vam je nova privremena lozinka.

Vasi trenutni korisnicki podaci su:
   korisnicko ime: {$a->username}
   lozinka: {$a->newpassword}
       (morat cete promijeniti lozinku kada se prvi put prijavite na sustav)

Za pocetak rada na sjedistu \'{$a->sitename}\', prijavite se na: {$a->link}

U vecini klijenata e-poste, ovo bi se trebalo pojaviti kao plava poveznica na koju mozete kliknuti. Ako to ne radi, iskopirajte adresu u adresnu traku na vrhu svog web preglednika.

Administrator sjedista \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'Novi korisnik';
$string['newwindow'] = 'Novi prozor';
$string['next'] = 'Nastavi';
$string['nextsection'] = 'Sljedeća sekcija';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Nema blokova koje možete dodati na ovu stranicu.';
$string['nobody'] = 'Nitko';
$string['nochange'] = 'Nema izmjena';
$string['nocomments'] = 'Nema komentara';
$string['nocourses'] = 'Nema kolegija';
$string['nocoursesfound'] = 'Nijedan kolegij ne sadržava pojam \'{$a}\'';
$string['nocoursesyet'] = 'U ovoj kategoriji nema kolegija';
$string['nodstpresets'] = 'Administrator sustava nije omogućio Daylight Savings Time.';
$string['nofilesselected'] = 'Nijedna datoteka nije odabrana za vraćanje';
$string['nofilesyet'] = 'Unutar ovog kolegija nije prenešena nijedna datoteka (za sada)';
$string['nograde'] = 'Nema ocjene';
$string['nohelpforactivityorresource'] = 'Trenutno ne postoji tekst pomoći za ovaj resurs ili ovu aktivnost';
$string['noimagesyet'] = 'Unutar ovog kolegija nije uploadana nijedna slika (za sada)';
$string['nologsfound'] = 'Nema zapisa';
$string['nomatchingusers'] = 'Nijedan korisnik se ne podudara s \'{$a}\'';
$string['nomorecourses'] = 'Nema više kolegija koji se podudaraju';
$string['nomoreidnumber'] = 'Ne koristi se idnumber kako bi se izbjegle moguće kolizije';
$string['none'] = 'Nijedan';
$string['noneditingteacher'] = 'Nastavnik bez ovlasti za uređivanje';
$string['noneditingteacherdescription'] = 'Asistenti bez prava uređivanja mogu sudjelovati u poučavanju u kolegijima te ocjenjivati studente, ali ne mogu mijenjati aktivnosti.';
$string['nonstandard'] = 'Ne-standardno';
$string['nopendingcourses'] = 'Nema zahtjeva za novim kolegijem na čekanju';
$string['nopotentialadmins'] = 'Nema potencijalnih administratora';
$string['nopotentialcreators'] = 'Nema potencijalnih kreatora kolegija';
$string['nopotentialstudents'] = 'Nema potencijalnih studenata';
$string['nopotentialteachers'] = 'Nema potencijalnih nastavnika';
$string['norecentactivity'] = 'Nema nedavne aktivnosti';
$string['noreplybouncemessage'] = 'Odgovorili ste na adresu e-pošte s koje se poruke samo šalju (no-reply). Ako ste pokušavali odgovoriti na poruku s foruma, molimo da to učinite direktno koristeći forum.

Slijedi sadržaj vaše poruke:';
$string['noreplybouncesubject'] = '{$a} - vraćena poruka e-pošte.';
$string['noreplyname'] = 'Nemojte odgovarati na ovu poruku e-pošte';
$string['noresults'] = 'Nema rezultata';
$string['normal'] = 'Normalno';
$string['normalfilter'] = 'Normalno pretraživanje';
$string['nosite'] = 'Nije pronađen kolegij na razini sustava';
$string['nostudentsfound'] = '{$a} nije pornađen';
$string['nostudentsingroup'] = 'Nema studenata u ovoj grupi (za sada)';
$string['nostudentsyet'] = 'Nijedan student nije upisan u ovaj kolegij (za sada)';
$string['nosuchemail'] = 'Ne postoji takva adresa e-pošte';
$string['notavailable'] = 'Nedostupno';
$string['noteachersyet'] = 'Za sada u ovom kolegiju nema nastavnika';
$string['notenrolled'] = '{$a} nije upisan/a u ovaj kolegij.';
$string['notenrolledprofile'] = 'Ovaj profil je nedostupan jer korisnik nije prijavljen na ovaj kolegij.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Napomena:</strong> Mogućnost mijenjanja datuma pri vraćanju ovog backupa je onemogućena jer nemate potrebne ovlasti.';
$string['noteuserschangednonetocourse'] = '<strong>Napomena:</strong> Kada vraćate korisničke podatke (aktivnosti, datoteke ili poruke) morate vratiti i pripadajuće korisnike. Ova postavka je promijenjena za vas.';
$string['nothingnew'] = 'Nema novosti od vaše zadnje prijave na sustav';
$string['nothingtodisplay'] = 'Ništa za prikazati';
$string['notice'] = 'Obavijest';
$string['noticenewerbackup'] = 'Ova backup datoteka je napravljena sa Moodle {$a->backuprelease} ({$a->backupversion}) i novija je od vašeg trenutno instaliranog sustava Moodle {$a->serverrelease} ({$a->serverversion}). Ovo bi moglo uzrokovati određene probleme (i inkonzistentnosti) zbog toga što backward compatibility nije osiguran.';
$string['notifications'] = 'Obavijesti';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Korisnik: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Ove zapise mozete vidjeti na adresi  {$a}/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Ovo je popis pogrešaka pri prijavi sustavu na {$a} od zadnje obavijesti koju ste primili';
$string['notifyloginfailuressubject'] = '{$a} :: obavijest o pogreskama pri prijavi sustavu';
$string['notincluded'] = 'Nije uključeno';
$string['notingroup'] = 'Nažalost, morate biti član grupe kako biste vidjeli ovaj modul aktivnosti.';
$string['notpublic'] = 'Nije javno!';
$string['nousersfound'] = 'Nema korisnika';
$string['nousersmatching'] = 'Nije pronađen korisnik pod nazivom \'{$a}\'';
$string['nousersyet'] = 'Za sada nema korisnika';
$string['novalidcourses'] = 'Nema valjanih kolegija za prikaz';
$string['now'] = 'sada';
$string['numattempts'] = '{$a} pogrešaka pri prijavi sustavu';
$string['numberofcourses'] = 'Broj kolegija';
$string['numberweeks'] = 'Broj tjedana/tema';
$string['numdays'] = '{$a} dana';
$string['numhours'] = '{$a} sati';
$string['numletters'] = '{$a} slova';
$string['numminutes'] = '{$a} min';
$string['nummonths'] = '{$a} mjeseci';
$string['numseconds'] = '{$a} s';
$string['numviews'] = '{$a} pregledavanja';
$string['numweeks'] = '{$a} tjedana';
$string['numwords'] = '{$a} riječi';
$string['numyears'] = '{$a} godina';
$string['ok'] = 'U redu';
$string['oldpassword'] = 'Trenutna lozinka';
$string['olduserdirectory'] = 'Ovo je STARA korisnička mapa koja više nije u uporabi. Možete ju slobodno obrisai. Sadržaj ove mape je kopiran u NOVU mapu.';
$string['opentoguests'] = 'Pristup gostima (anonimnim korisnicima)';
$string['optional'] = 'opcionalno';
$string['options'] = 'opcije';
$string['order'] = 'Redoslijed';
$string['originalpath'] = 'Originalna putanja';
$string['other'] = 'Drugi';
$string['outline'] = 'Outline';
$string['outlinereport'] = 'Skraćeni izvještaj';
$string['page'] = 'Stranica';
$string['pagea'] = 'Stranica {$a}';
$string['pageheaderconfigablock'] = 'Podešavanje bloka u {$a->fullname}';
$string['pagepath'] = 'Putanja do stranice';
$string['pageshouldredirect'] = 'Ova stranica bi vas trebala automatski preusmjeriti na drugu stranicu. Ako se ništa ne dogodi, molimo koristite poveznicu u nastavku.';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parentcoursenotfound'] = 'Nadređeni kolegij nije pronađen!';
$string['parentfolder'] = 'Nadređena mapa';
$string['participants'] = 'Sudionici';
$string['participantslist'] = 'Popis sudionika';
$string['participationratio'] = 'Udio sudjelovanja';
$string['participationreport'] = 'Izvještaj o aktivnosti / sudjelovanju';
$string['password'] = 'Lozinka';
$string['passwordchanged'] = 'Lozinka je promijenjena';
$string['passwordconfirmchange'] = 'Potvrdite promjenu lozinke';
$string['passwordextlink'] = 'Ova poveznica vam omogucava povrat vase zaboravljene/izgubljene lozinke. Ista ce vas odvesti izvan Moodle posluzitelja';
$string['passwordforgotten'] = 'Zaboravljena lozinka';
$string['passwordforgotteninstructions'] = 'Vaši podaci prvo moraju biti pronađeni u bazi podataka. Molim unesite <strong>bilo</strong> svoje korisničko ime ili vašu prijavljenu adresu e-pošte u pripadajuće polje. Nema potrebe za unošenjem oba podatka.';
$string['passwordforgotteninstructions2'] = 'Za resetiranje vaše lozinke, upišite svoje korisničko ime ili adresu e-pošte. Ako ti podaci postoje u bazi podataka, primit ćete poruku na pripadajuću adresu e-pošte, s uputama kako ponovno dobiti pristup sustavu.';
$string['passwordnohelp'] = 'Nema pomoći na raspolaganju za vašu izgubljenu lozinku. Kontaktirajte Moodle administratora.';
$string['passwordrecovery'] = 'Da, trebam pomoć pri prijavljivanju sustavu';
$string['passwordsdiffer'] = 'Lozinke se ne poklapaju';
$string['passwordsent'] = 'Lozinka je poslana';
$string['passwordsenttext'] = '<p>Poruka e-pošte je poslana na vašu adresu  {$a->email}.</p>
   <p><b>Molimo provjerite vašu e-pošte kako bi primili novu lozinku</b></p>
   <p>Nova lozinka je stvorena automatski, tako da bi ju trebali <a href="{$a->link}">promijeniti u nešto lakše pamtljivo</A>.</p>';
$string['passwordset'] = 'Vaša lozinka je zadana.';
$string['path'] = 'Putanja (PATH)';
$string['pathnotexists'] = 'Putanja ne postoji na vašem poslužitelju!';
$string['pathslasherror'] = 'Putanja ne može završiti sa znakom SLASH!!';
$string['paymentinstant'] = 'Upotrijebite donju poveznicu kako bi platili i bili u mogućnosti pristupiti kolegiju za manje od par minuta!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> očekuje se</small>)';
$string['paymentrequired'] = 'Ovaj kolegij zahtjeva plaćanje za pristup.';
$string['payments'] = 'Uplate';
$string['paymentsorry'] = 'Hvala za vašu uplatu!

Nažalost, uplata još nije do kraja procesirana, pa još niste prijavljeni na kolegij "{$a->fullname}".
Pokušajte se prijaviti kroz nekoliko sekundi, no ako se i dalje ne budete mogli prijaviti, javite se nastavniku ({$a->teacher}) ili administratoru sjedišta';
$string['paymentthanks'] = 'Hvala vam na vašoj uplati! Time ste upisani u kolegije:<br />"{$a}"';
$string['pendingrequests'] = 'Zahtjevi na čekanju';
$string['periodending'] = 'Kraj trajanja ({$a})';
$string['perpage'] = 'Po stranici';
$string['perpagea'] = 'Po stranici: {$a}';
$string['personal'] = 'Osobno';
$string['personalprofile'] = 'Osobni podaci';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobitel';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = 'Slika {$a}';
$string['pictureofuser'] = 'Slika korisnika';
$string['pleaseclose'] = 'Molimo zatvorite ovaj prozor.';
$string['pleasesearchmore'] = 'Molimo tražite dalje';
$string['pleaseusesearch'] = 'Koristite pretraživanje';
$string['plugin'] = 'Dodatak (plugin)';
$string['plugincheck'] = 'Provjera dodataka';
$string['plugindeletefiles'] = 'Svi podaci povezani s dodatkom: \'{$a->module}\' su izbrisani iz baze podataka. Za dovršetak brisanja (i sprječavanje automatske reinstalacije dodatka), trebali biste ODMAH izbrisati ovu mapu s poslužitelja: {$a->directory}';
$string['pluginsetup'] = 'Podešavanje tablice dodataka';
$string['policyaccept'] = 'Razumijem i prihvaćam';
$string['policyagree'] = 'Prije korištenja ovog sustava morate prihvatiti pravilnik ponašanja na sustavu. Prihvaćate li?';
$string['policyagreement'] = 'Pravilnik o korištenju sustava';
$string['policyagreementclick'] = 'Poveznica na pravilnik o korištenju sustava';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Otvori datoteku u novom prozoru';
$string['popupwindowname'] = 'Popup prozor';
$string['post'] = 'Poruka';
$string['posts'] = 'Poruke';
$string['potentialadmins'] = 'Potencijalni administratori';
$string['potentialcreators'] = 'Potencijalni tvorci kolegija';
$string['potentialstudents'] = 'Potencijalni studenti';
$string['potentialteachers'] = 'Potencijalni nastavnici';
$string['preferences'] = 'Postavke';
$string['preferredlanguage'] = 'Poželjni jezik';
$string['preferredtheme'] = 'Poželjna tema';
$string['preprocessingbackupfile'] = 'Predprocesiranje backup datoteke';
$string['prev'] = 'Prethodni';
$string['preview'] = 'Pregled';
$string['previewhtml'] = 'Pregled u HTML obliku';
$string['previeworchoose'] = 'Pregled ili odabir teme';
$string['previous'] = 'Prethodni';
$string['previouslyselectedusers'] = 'Prethodno odabrani korisnik se ne podudara s \'{$a}\'';
$string['previoussection'] = 'Prethodna sekcija';
$string['primaryadminsetup'] = 'Podesite administratorski račun';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Opis na profilu neće biti dostupan do se ova osoba ne upiše u barem jedan kolegij.';
$string['publicprofile'] = 'Javni profil';
$string['publicsitefileswarning'] = 'Napomena: datotekama postavljenim ovdje mogu pristupiti svi';
$string['publicsitefileswarning2'] = 'Napomena: Datotekama postavljenim ovdje može pristupiti bilo tko tko zna (ili može pogoditi) URL.<br />Zbog sigurnosnih razloga, preporučljivo je obrisati backup datoteke nakon vraćanja podataka iz istih.';
$string['publicsitefileswarning3'] = 'Napomena: Datotekama postavljenim ovdje može pristupiti bilo tko tko zna (ili može pogoditi) URL.<br /> Iz sigurnosnih razloga, backup datoteke bi trebale biti spremljene samo u sigurnu mapu backupdata.';
$string['publish'] = 'Objavi';
$string['question'] = 'Pitanje';
$string['questionsinthequestionbank'] = 'Pitanja u bazi pitanja';
$string['readinginfofrombackup'] = 'Reading info from backup';
$string['readme'] = 'Upute';
$string['recentactivity'] = 'Nedavna aktivnost';
$string['recentactivityreport'] = 'Potpuni izvještaj o nedavnoj aktivnosti...';
$string['recipientslist'] = 'Popis primatelja';
$string['recreatedcategory'] = 'Ponovno stvorena kategorija {$a}';
$string['redirect'] = 'Preusmjeri';
$string['reducesections'] = 'Smanji broj tema';
$string['refresh'] = 'Osvježavanje';
$string['refreshingevents'] = 'Osvježavanje događaja';
$string['registration'] = 'Moodle registracija';
$string['registrationcontact'] = 'Javni kontakt';
$string['registrationcontactno'] = 'Ne, ne želim kontaktni obrazac na popisu siteova';
$string['registrationcontactyes'] = 'Da, prikažite obrazac kako bi me potencijalni Moodleri mogli kontaktirati';
$string['registrationemail'] = 'Obavijesti putem e-pošte';
$string['registrationinfo'] = '<p>Ova vam stranica omogućuje registraciju ovog Moodle sjedišta sa sjedištem moodle.org. Registracija je besplatna.
Glavna korist registracije je dodavanje na mailing listu (niske učestalosti poruka) s važnim obavijestima poput sigurnosnih upozorenja i novih inačica Moodle-a.</p>
<p>Vaše će informacije biti skrivene od javnosti i nikada neće biti prodane ili proslijeđene bilo kome drugome. Jedini razlog za sakupljanje informacija je za potrebe podrške, te kao pomoć u izgradnji statistike zajednice Moodle korisnika u cjelini.</p>
<p>Ako želite, možete dopustiti da se naziv sjedišta, zemlja i URL doda na javni popis Moodle sjedišta.</p>
<p>Sve nove registracije će se ručno provjeriti prije dodavanja na popis, no nakon dodavanja možete mijenjati svoje podatke (i prisutnost na na javnom popisu) u bilo kojem trenutku, ponovnim slanjem ovog obrasca.</p>';
$string['registrationinfotitle'] = 'Informacija o registraciji';
$string['registrationno'] = 'Ne, ne želim primati obavijesti putem e-pošte';
$string['registrationsend'] = 'Registriraj sustav na moodle.org';
$string['registrationyes'] = 'Da, obavijestite me o važnim pitanjima';
$string['reject'] = 'Odbaci';
$string['rejectdots'] = 'Odbaci...';
$string['reload'] = 'Učitaj ponovno';
$string['remoteappuser'] = 'Udaljeni korisnik ({$a})';
$string['remove'] = 'Ukloni';
$string['removeadmin'] = 'Ukloni administratora';
$string['removecreator'] = 'Ukloni tvorca kolegija';
$string['removestudent'] = 'Ukloni studenta';
$string['removeteacher'] = 'Ukloni nastavnika';
$string['rename'] = 'Preimenuj';
$string['renamefileto'] = 'Preimenuj <b>{$a}</b> u';
$string['report'] = 'Izvještaj';
$string['reports'] = 'Izvještaji';
$string['repositories'] = 'Repozitoriji';
$string['requestcourse'] = 'Zatraži novi kolegij';
$string['requestedby'] = 'Zatražio/la';
$string['requestedcourses'] = 'Zahtjevi za otvaranjem novog kolegija';
$string['requestreason'] = 'Razlog za otvaranje novog kolegija';
$string['required'] = 'Obvezno';
$string['requirespayment'] = 'Ovaj kolegij zahtjeva plaćanje za pristup';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Komponenta';
$string['resetcourse'] = 'Reset kolegija';
$string['resetinfo'] = 'Ova stranica omogućuje brisanje korisničkih podataka iz kolegija, uz zadržavanje postojećih aktivnosti i drugih postavki. Pazite, odabirom stavki i slanjem obrasca, zauvijek ćete izbrisati te korisničke podatke iz kolegija!';
$string['resetnotimplemented'] = 'Reset nije omogućen';
$string['resetstartdate'] = 'Postavi novi datum početka';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Zadatak';
$string['resettodefaults'] = 'Vrati na zadano';
$string['resortbyfullname'] = 'Po nazivu';
$string['resortbyidnumber'] = 'Po id broju';
$string['resortbyshortname'] = 'Po kratici';
$string['resortcourses'] = 'Sortiraj kolegije';
$string['resortsubcategoriesbyidnumber'] = '';
$string['resortsubcategoriesbyname'] = '';
$string['resource'] = 'Resurs';
$string['resourcedisplayauto'] = 'Automatski';
$string['resourcedisplaydownload'] = 'Obvezno preuzimanje (force download)';
$string['resourcedisplayembed'] = 'Ugradi (Embed)';
$string['resourcedisplayframe'] = 'U okviru (frame)';
$string['resourcedisplaynew'] = 'Novi prozor';
$string['resourcedisplayopen'] = 'Otvori';
$string['resourcedisplaypopup'] = 'U popup prozoru';
$string['resources'] = 'Resursi';
$string['resources_help'] = 'Resursi omogućavaju umetanje bilo koje vrste web sadržaja na vaš kolegij.';
$string['restore'] = 'Vraćanje iz kopije';
$string['restorecancelled'] = 'Vraćanje kolegija otkazano';
$string['restorecannotassignroles'] = 'Procedura vraćanja podataka mora dodijeliti uloge, a vi nemate ovlasti za to';
$string['restorecannotcreateorassignroles'] = 'Procedura vraćanja podataka mora stvoriti i dodijeliti uloge, a vi nemate ovlasti za to';
$string['restorecannotcreateuser'] = 'Procedura vraćanja podataka mora stvoriti korisnika \'{$a}\' iz backup datoteke, a vi nemate ovlasti za to';
$string['restorecannotoverrideperms'] = 'Procedura vraćanja podataka mora izmijeniti ovlasti, a vi nemate ovlasti za to';
$string['restorecoursenow'] = 'Restore this course now!';
$string['restoredaccount'] = 'Vraćeni korisnički račun';
$string['restoredaccountinfo'] = 'Ovaj korisnički račun je uvežen s drugog poslužitelja i lozinka je izgubljena. Kako bi zadali novu lozinku korištenjem e-pošte, kliknite na "Nastavi".';
$string['restorefinished'] = 'Vraćanje kolegija uspješno završeno';
$string['restoreto'] = 'Vrati u';
$string['restoretositeadding'] = 'Upozorenje: Vratit ćete podatke na naslovnicu sustava, dodajući podatke na istu!';
$string['restoretositedeleting'] = 'Upozorenje: Vratit ćete podatke na naslovnicu sustava, brišući podatke s iste!';
$string['restoreuserconflict'] = 'Pokušaj vraćanja korisnika \'{$a}\' iz backup datoteke će prouzročiti konflikt';
$string['restoreuserinfofailed'] = 'Proces vraćanja podataka je zaustavljen jer vi nemate ovlasti za vraćanje korisničkih podataka.';
$string['restoreusersprecheck'] = 'Provjera korisničkih podataka';
$string['restoreusersprecheckerror'] = 'Određeni problemi su pronađeni pri provjeri korisničkih podataka';
$string['restricted'] = 'Ograničenje';
$string['returningtosite'] = 'Već posjedujete korisnički račun?';
$string['returntooriginaluser'] = 'Vrati se na {$a}';
$string['revert'] = 'Vrati';
$string['role'] = 'Uloga';
$string['roleassignments'] = 'Dodjela uloga';
$string['rolemappings'] = 'Mapiranja uloga';
$string['rolerenaming'] = 'Preimenovanje uloga';
$string['rolerenaming_help'] = 'Ova postavka omogućuje promjenu prikazanih naziva za uloga koje se koriste u kolegiju. Samo prikazani naziv se mijenja - ovlasti uloga ostaju iste. Novi nazivi uloga pojavit će se na stranici sa sudionicima kolegija, i bit će korišteni u cijelom kolegiju. Ako je uloga koja je promijenjena jedna od kolegija odabranih kao "menadžer kolegija", naziv nove uloge će se također prikazati i u popsu kolegija.';
$string['roles'] = 'Uloge';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Broj novih RSS članaka';
$string['rsserror'] = 'Pogreška u čitanju RSS podataka';
$string['rsserrorauth'] = 'RSS poveznica ne sadrži valjani autentikacijski token.';
$string['rsserrorguest'] = 'Ovaj kanal koristi anonimni pristup (gost) za pristup podacima, no gosti ovdje nemaju ovlasti pristupa podacima. Posjetite izvornu lokaciju s koje ovaj kanal dolazi (URL) kao prijavljeni korisnik, te tamo pronađite novu poveznicu za RSS kanal.';
$string['rsstype'] = 'RSS kanal za ovu aktivnost';
$string['saveandnext'] = 'Pohrani i prikaži sljedeći';
$string['savechanges'] = 'Pohrani promjene';
$string['savechangesanddisplay'] = 'Pohrani i prikaži';
$string['savechangesandreturntocourse'] = 'Pohrani i vrati se na stranicu kolegija';
$string['savecomment'] = 'Pohrani komentar';
$string['savedat'] = 'Pohranjeno:';
$string['savepreferences'] = 'Pohrani postavke';
$string['saveto'] = 'Pohrani u';
$string['scale'] = 'Skala';
$string['scale_help'] = 'Skala pruža način evaluacije ili ocjenjivanja uspjeha u aktivnosti. Definirana je kao popis vrijednosti, od negativnih do pozitivnih, odvojenih zarezom. Na primjer: "Razočaravajuće, Nedovoljno dobro, Prosječno, Dobro, Vrlo dobro, Izvrsno!"';
$string['scales'] = 'Skale';
$string['scalescustom'] = 'Vlastite skale';
$string['scalescustomcreate'] = 'Dodajte novu skalu';
$string['scalescustomno'] = 'No custom scales have been created yet';
$string['scalesstandard'] = 'Standardne skale';
$string['scalestandard'] = 'Standardna skala';
$string['scalestandard_help'] = 'Standardna skala je dostupna na razini cijelog sustava, za sve kolegije.';
$string['scalestip'] = 'Kako bi stvorili vlastite skale ocjenjivanja, upotrijebite poveznicu "Skale..." iz izbornika "Administracija".';
$string['scalestip2'] = 'Za izradu vlastitih skala, odaberite poveznicu Skale iz izbornika za upravljanje kolegijem, te odaberite Uredi, Skale.';
$string['schedule'] = 'Raspored';
$string['screenshot'] = 'Screenshot';
$string['search'] = 'Pretraži';
$string['searchagain'] = 'Pretraži ponovo';
$string['searchbyemail'] = 'Pretraživanje po adresi e-pošte';
$string['searchbyusername'] = 'Pretraživanje po korisničkom imenu';
$string['searchcourses'] = 'Pretraži kolegije';
$string['searchhelp'] = 'Možete pretraživati koristeći više riječi odjednom.<p>riječ : traženje bilo kojeg pojavljivanja ove riječi u tekstu (pa i u sklopu drugih riječi).<br />+riječ : traženje isključivo onog oblika riječi koji je unešen.<br />-riječ : prikazuju se samo oni rezultati u kojima NEMA navedene riječi.';
$string['search_help'] = 'Za jednostavnu pretragu jedne ili više riječi bilo gdje u tekstu, samo ih upišite odvojene razmacima. Pretraživati se mogu sve riječi dulje od 2 znaka.

Za pristup obrascu za naprednu pretragu, kliknite gumb za pretragu bez upisivanja pojmova u polje za pretragu.';
$string['searchoptions'] = 'Postavke pretraživanja';
$string['searchresults'] = 'Rezultati pretraživanja';
$string['sec'] = 'sek';
$string['seconds'] = 'sekunde';
$string['secondstotime172800'] = '2 dana';
$string['secondstotime259200'] = '3 dana';
$string['secondstotime345600'] = '4 dana';
$string['secondstotime432000'] = '5 dana';
$string['secondstotime518400'] = '6 dana';
$string['secondstotime604800'] = '1 tjedan';
$string['secondstotime86400'] = '1 dan';
$string['secretalreadyused'] = 'Poveznica za potvrdu izmjene lozinke je već upotrijebljena, lozinka nije promijenjena.';
$string['secs'] = 's';
$string['section'] = 'Sekcija';
$string['sectionname'] = 'Naziv sekcije';
$string['sections'] = 'Sekcije';
$string['sectionusedefaultname'] = 'Koristi zadano ime sekcije';
$string['seealsostats'] = 'Pogledajte i statistiku';
$string['selctauser'] = 'Odaberite korisnika';
$string['select'] = 'Odaberi';
$string['selectacategory'] = 'Odaberite kategoriju';
$string['selectacountry'] = 'Odaberite državu';
$string['selectacourse'] = 'Odaberite državu';
$string['selectacoursesite'] = 'Odaberite kolegij ili sjedište';
$string['selectagroup'] = 'Odaberite grupu';
$string['selectall'] = 'Odaberite sve';
$string['selectamodule'] = 'Molim odaberite modul aktivnosti';
$string['selectanaction'] = 'Odaberite operaciju';
$string['selectanoptions'] = 'Odaberite opciju';
$string['selectaregion'] = 'Odaberi regiju';
$string['selectcategorysort'] = 'Koje kategorije želite sortirati?';
$string['selectdefault'] = 'Odaberi zadanu vrijednost';
$string['selectedcategories'] = 'Odabrane kategorije';
$string['selectedfile'] = 'Odabrana datoteka';
$string['selectednowmove'] = 'Datoteke koje su označene za premještanje: {$a}. Sada idite na mjesto (u mapu) gdje želite premjestiti datoteke i kliknite \'Premjesti datoteke ovdje\'';
$string['selectfiles'] = 'Odabrane datoteke';
$string['selectmoduletoviewhelp'] = 'Odaberite modul kako bi vidjeli tekst pomoći.';
$string['selectnos'] = 'Odaberi sve odgovore "Ne"';
$string['selectperiod'] = 'Odaberite vremenski period';
$string['senddetails'] = 'Pošalji moje osobne podatke porukom e-pošte';
$string['separate'] = 'Odvojeno';
$string['separateandconnected'] = 'Odvojeni i povezani načini znanja';
$string['separateandconnectedinfo'] = 'Ova je skala temeljena na teoriji odvojenog i povezanog znanja. Ova teorija opisuje dva različita načina na koje možemo učiti o stvarima koje vidimo i čujemo. <ul>
<li><strong>Odvojeni način učenja</strong> - učenici ostaju objektivni što je više moguće bez uključivanja osjećaja- U diskusiji s drugim osobama, vole braniti svoje stavove, uporabom logike za pronalazak nedostataka u idejama sugovornika.</li>
<li><strong>Povezani način učenja</strong> - učenici su više osjetljivi na druge osobe. Dobri su u suosjećanju i slušanju, te postavljaju pitanja dok ne osjete da se mogu spojiti i "razmjeti stvari iz njihovog kuta gledanja". Oni uče pokušavajući dijeliti iskustva koja vode znanju koje pronalaze u drugim osobama.</li></ul>';
$string['servererror'] = 'Dogodila se pogreška u komunikaciji s poslužiteljem';
$string['serverlocaltime'] = 'Lokalno vrijeme poslužitelja';
$string['setcategorytheme'] = 'Odredite temu na razini kategorije';
$string['setpassword'] = 'Zadajte lozinku';
$string['settings'] = 'Postavke';
$string['shortname'] = 'Kratica';
$string['shortnamecollisionwarning'] = '[*] = Ova kratica kolegija je već u uporabi od strane drugog kolegija i morat će biti promijenjena pri odobravanju/otvaranju ovog kolegija.';
$string['shortnamecourse'] = 'Kratica kolegija';
$string['shortnamecourse_help'] = 'Kratica kolegija se prikazuje u navigaciji i kao dio naslova (subject) poruka e-pošte koja dolazi od strane aktivnosti na kolegiju.';
$string['shortnametaken'] = 'Navedena kratica je već u uporabi za drugi kolegij ({$a})';
$string['shortnameuser'] = 'Kratica korisnika';
$string['shortsitename'] = 'Kratki naziv sustava (tj. jedna riječ)';
$string['show'] = 'Prikaži';
$string['showactions'] = 'Prikaži operacije';
$string['showadvancedsettings'] = 'Prikaži napredne postavke';
$string['showall'] = 'Prikaži sve {$a}';
$string['showallcourses'] = 'Prikaži sve kolegije';
$string['showallusers'] = 'Prikaži sve korisnike';
$string['showblockcourse'] = 'Prikaži popis kolegija koji sadrže ovaj blok';
$string['showcategory'] = 'Prikaži {$a}';
$string['showcomments'] = 'Prikaži / skrij komentare';
$string['showcommentsnonjs'] = 'Prikaži komentare';
$string['showdescription'] = 'Prikaži opis/upute na naslovnici';
$string['showdescription_help'] = 'Ako je omogućeno, upute ili opis će biti prikazani na naslovnici kolegija ispod poveznice na aktivnost / resurs.';
$string['showgrades'] = 'Prikaži ocjene studentima';
$string['showgrades_help'] = 'Mnoge aktivnosti u kolegiju se mogu ocjenjivati. Ova postavka određuje može li student vidjeti popis svih svojih ocjena u kolegiju kroz poveznicu Ocjene u bloku za upravljanje kolegijem.';
$string['showlistofcourses'] = 'Prikaži popis kolegija';
$string['showmodulecourse'] = 'Prikaži popis kolegija koji sadrže ovu aktivnost';
$string['showonly'] = 'Prikaži samo';
$string['showperpage'] = 'Prikaži {$a} po stranici';
$string['showrecent'] = 'Prikaži nedavne aktivnosti';
$string['showreports'] = 'Prikaži izvještaje o aktivnosti';
$string['showreports_help'] = 'Izvještaji o aktivnosti, prikazuju aktivnost svakog sudionika u kolegiju. Osim popisa njihovih doprinosa, poput poruka na forumu ili predaje zadaća, ovi izvještaji također uključuju zapise o pristupima. Ova postavka određuje može li student vidjeti zapise o svojoj aktivnosti preko vlastite stranice profila.';
$string['showsettings'] = 'Prikaži postavke';
$string['showtheselogs'] = 'Prikaži ove zapise';
$string['showthishelpinlanguage'] = 'Prikaži ovu pomoć na jeziku: {$a}';
$string['since'] = 'Od';
$string['sincelast'] = 'od zadnje prijave sustavu';
$string['site'] = 'Site';
$string['sitedefault'] = 'Zadano na razini sustava';
$string['siteerrors'] = 'Site errors';
$string['sitefiles'] = 'Site files';
$string['sitefilesused'] = 'Globalne datoteke koje se koriste u ovom kolegiju';
$string['sitehome'] = 'Naslovnica sustava';
$string['sitelegacyfiles'] = 'Datoteke sa starog sjedišta';
$string['sitelogs'] = 'Zapisi na razini sustava';
$string['sitemessage'] = 'Pošalji poruku korisnicima';
$string['sitenews'] = 'Obavijesti na razini sjedišta';
$string['sitepages'] = 'Stranice na razini sustava';
$string['sitepartlist'] = 'Nemate potrebne ovlasti za pregled liste polaznika';
$string['sitepartlist0'] = 'Morate biti nastavnik kako bi mogli vidjeti popis polaznika';
$string['sitepartlist1'] = 'Morate biti nastavnik kako bi mogli vidjeti popis polaznika';
$string['sites'] = 'Sustavi';
$string['sitesection'] = 'Obuhvati tematsku sekciju';
$string['sitesettings'] = 'Postavke sustava';
$string['siteteachers'] = 'Nastavnici';
$string['size'] = 'Veličina';
$string['sizeb'] = 'bajtovi';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Preskočeno';
$string['skiptocourselisting'] = 'Preskoči na popis kolegija';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Socijalni forum - najsvježije teme';
$string['someallowguest'] = 'Neki od kolegija mogu dopustiti pristup gostima (anonimnim korisnicima)';
$string['someerrorswerefound'] = 'Neke od informacija su nedostajale ili su bile netočne. Pregledajte ponovno vaš unos.';
$string['sort'] = 'Sortiranje';
$string['sortby'] = 'Sortiraj prema';
$string['sortbyx'] = 'Sortiraj prema {$a} uzlazno';
$string['sortbyxreverse'] = 'Sortiraj prema {$a} silazno';
$string['sortcategoriesbyidnumber'] = 'Sortiranje kategorija po ID broju';
$string['sortcategoriesbyname'] = 'Sortiranje kategorija po nazivu';
$string['sortcoursesbyfullname'] = 'Sortiranje kolegija po punom imenu';
$string['sortcoursesbyidnumber'] = 'Sortiranje kolegija po ID broju';
$string['sortcoursesbyshortname'] = 'Sortiranje kolegija po kratici';
$string['sorting'] = 'Sortiranje';
$string['sourcerole'] = 'Izvorna uloga';
$string['specifyname'] = 'Morate navesti ime.';
$string['standard'] = 'Standardno';
$string['starpending'] = '([*] = kolegij čeka na otvaranje)';
$string['startdate'] = 'Kolegij počinje';
$string['startdate_help'] = 'Ova postavka određuje početak prvog tjedna za kolegij u tjednom obliku. Također određuje najraniji datum za koji će zapisi o aktivnostima u kolegiju biti dostupni.';
$string['startingfrom'] = 'Počinje';
$string['startsignup'] = 'Stvori novi korisnički račun!';
$string['state'] = 'Pokrajina/Županija';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Statistički graf';
$string['stats'] = 'Statistika';
$string['statslogins'] = 'Prijave';
$string['statsmodedetailed'] = 'Detaljni (korisnički) prikaz';
$string['statsmodegeneral'] = 'Općeniti prikaz';
$string['statsnodata'] = 'Nema dostupnih podataka za tu kombinaciju kolegija i vremenskog perioda.';
$string['statsnodatauser'] = 'Nema dostupnih podataka za tu kombinaciju kolegija, korisnika i vremenskog perioda.';
$string['statsoff'] = 'Statistika nije trenutno omogućena';
$string['statsreads'] = 'Pregledavanja';
$string['statsreport1'] = 'Prijave';
$string['statsreport10'] = 'Korisnička aktivnost';
$string['statsreport11'] = 'Kolegiji s najviše aktivnosti';
$string['statsreport12'] = 'Najaktivniji kolegiji (ponderirano)';
$string['statsreport13'] = 'Kolegiji s najvećom količinom sudjelovanja (upisa)';
$string['statsreport14'] = 'Kolegiji s najvećom količinom sudjelovanja (pregledi/poruke)';
$string['statsreport2'] = 'Pregledavanja (za sve uloge)';
$string['statsreport3'] = 'Poruke (nastavnika i studenata)';
$string['statsreport4'] = 'Ukupna aktivnost (nastavnika i studenata)';
$string['statsreport5'] = 'Ukupna studentska aktivnost (pregledi i poruke)';
$string['statsreport7'] = 'Aktivnost korisnika (pregledi i poruke)';
$string['statsreport8'] = 'Ukupna studentska aktivnost';
$string['statsreport9'] = 'Prijave (naslovnica sustava)';
$string['statsreportactivity'] = 'Ukupna aktivnost (nastavnika i studenata)';
$string['statsreportactivitybyrole'] = 'Ukupna aktivnost (pregledi i poruke)';
$string['statsreportforuser'] = 'za';
$string['statsreportlogins'] = 'Prijave';
$string['statsreportreads'] = 'Pregledi (nastavnici i studenti)';
$string['statsreporttype'] = 'Vrsta izvještaja';
$string['statsreportwrites'] = 'Poruke (sve uloge)';
$string['statsstudentactivity'] = 'Studentska aktivnost';
$string['statsstudentreads'] = 'Studentski pregledi';
$string['statsstudentwrites'] = 'Studentske poruke';
$string['statsteacheractivity'] = 'Aktivnost nastavnika';
$string['statsteacherreads'] = 'Nastavnički pregledi';
$string['statsteacherwrites'] = 'Poruke nastavnika';
$string['statstimeperiod'] = 'Vremenski period - trajanje:';
$string['statsuniquelogins'] = 'Jedinstvene prijave (unique logins)';
$string['statsuseractivity'] = 'Sva aktivnost';
$string['statsuserlogins'] = 'Prijave';
$string['statsuserreads'] = 'Pregledi';
$string['statsuserwrites'] = 'Poruke';
$string['statswrites'] = 'Poruke';
$string['status'] = 'Status';
$string['stringsnotset'] = 'Sljedeći nizovi nisu definirani u {$a}';
$string['studentnotallowed'] = 'Nažalost, ne možete ući u ovaj kolegij kao \'{$a}\'';
$string['students'] = 'Studenti';
$string['studentsandteachers'] = 'Studenti i nastavnici';
$string['subcategories'] = 'Potkategorije';
$string['subcategory'] = 'Potkategorija';
$string['subcategoryof'] = 'Potkategorija {$a}';
$string['submit'] = 'Predaj';
$string['success'] = 'Uspješno';
$string['summary'] = 'Sažetak';
$string['summary_help'] = 'Sažetak je kratki tekst koji priprema studente za aktivnosti unutar određene teme / tjedna. Tekst se prikazuje na stranici kolegija u dijelu naziva sekcije.';
$string['summaryof'] = 'Sažeti opis {$a}';
$string['supplyinfo'] = 'Molimo unesite osobne informacije';
$string['switchdevicedefault'] = 'Prebacivanje na standardnu temu';
$string['switchdevicerecommended'] = 'Prebacivanje na emu preporučenu za vašu vrstu uređaja';
$string['switchrolereturn'] = 'Vrati me u moju uobičajenu ulogu';
$string['switchroleto'] = 'Promijeni ulogu u..';
$string['tag'] = 'Oznaka (tag)';
$string['tagalready'] = 'Ova oznaka već postoji';
$string['tagmanagement'] = 'Dodaj/obriši oznake...';
$string['tags'] = 'Oznake';
$string['targetrole'] = 'Odredišna uloga';
$string['teacheronly'] = 'for the {$a} only';
$string['teacherroles'] = '{$a} uloge';
$string['teachers'] = 'Nastavnici';
$string['textediting'] = 'Uređivač teksta';
$string['texteditor'] = 'Koristi standardne web obrasce';
$string['textformat'] = 'Običan tekstualni oblik';
$string['thanks'] = 'Hvala';
$string['theme'] = 'Tema';
$string['themes'] = 'Teme';
$string['themesaved'] = 'Nova tema pohranjena';
$string['therearecourses'] = 'Broj kolegija: {$a}';
$string['thereareno'] = 'U ovom kolegiju ne postoji {$a}';
$string['thiscategory'] = 'Ova kategorija';
$string['thiscategorycontains'] = 'Ova kategorija sadržava';
$string['time'] = 'Vrijeme';
$string['timezone'] = 'Vremenska zona';
$string['to'] = 'Do';
$string['tocreatenewaccount'] = 'Preskoči za stvaranje novog korisničkog računa';
$string['today'] = 'Danas';
$string['todaylogs'] = 'Današnji zapisi';
$string['toeveryone'] = 'svima';
$string['toomanybounces'] = 'Navedena adresa e-pošte ima previše poruka o pogrešci. <b>MORATE</b> ju promijeniti kako biste nastavili.';
$string['toomanytoshow'] = 'Previše korisnika za prikaz';
$string['toomanyusersmatchsearch'] = 'Previše korisnika ({$a->count}) se podudara s \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Previše korisnika ({$a}) za prikaz';
$string['toonly'] = 'samo za {$a}';
$string['top'] = 'Vrh';
$string['topic'] = 'Tema';
$string['topichide'] = 'Skrij ovu temu od {$a}';
$string['topicoutline'] = 'Uvod';
$string['topicshow'] = 'Prikaži ovu temu {$a}';
$string['total'] = 'Ukupno';
$string['trackforums'] = 'Praćenje foruma';
$string['trackforumsno'] = 'NE: ne bilježi informaciju o tome koje sam poruke prethodno pročitao';
$string['trackforumsyes'] = 'DA: istakni nove poruke';
$string['trysearching'] = 'Pokušajte sa pretraživanjem.';
$string['turneditingoff'] = 'Onemogući izmjene';
$string['turneditingon'] = 'Omogući izmjene';
$string['undecided'] = 'Neodlučni';
$string['unfinished'] = 'Nedovršeno';
$string['unknowncategory'] = 'Nepoznata kategorija';
$string['unknownerror'] = 'Nepoznata pogreška';
$string['unlimited'] = 'Neograničeno';
$string['unpacking'] = 'Otpakiravanje {$a}';
$string['unsafepassword'] = 'Nesigurna lozinka - probajte nešto kompleksnije';
$string['untilcomplete'] = 'Dok se ne završi';
$string['unusedaccounts'] = 'Korisnički računi koji se ne koriste {$a} dana se automatski ispisuju';
$string['unzip'] = 'Unzip';
$string['unzippingbackup'] = 'Otpakiravanje backup datoteke';
$string['up'] = 'Gore';
$string['update'] = 'Nadogradi';
$string['updated'] = 'Osvježeno: {$a}';
$string['updatemymoodleoff'] = 'Prestanite s prilagođavanjem ove stranice';
$string['updatemymoodleon'] = 'Prilagodite ovu stranicu';
$string['updatemyprofile'] = 'Promijeni osobne podatke';
$string['updatesevery'] = 'Osvježava se svakih {$a} sekundi';
$string['updatethis'] = 'Osvježi {$a}';
$string['updatethiscourse'] = 'Nadogradi ovaj kolegij';
$string['updatinga'] = 'Nadograđivanje: {$a}';
$string['updatingain'] = 'Nadograđivanje {$a->what} u {$a->in}';
$string['upload'] = 'Prijenos';
$string['uploadafile'] = 'Prijenos datoteke';
$string['uploadcantwrite'] = 'Datoteku nije bilo moguće zapisati na disk';
$string['uploadedfile'] = 'Datoteka je uspješno prenešena';
$string['uploadedfileto'] = 'Upload datoteke {$a->file} u mapu {$a->directory} izvršen';
$string['uploadedfiletoobig'] = 'Nažalost, navedena datoteka je prevelika (ograničenje iznosi {$a} bajtova)';
$string['uploadextension'] = 'Prijenos datoteke na poslužitelj zaustavljen zbog ekstenzije PHP';
$string['uploadfailednotrecovering'] = 'Prijenos datoteka na poslužitelj nije uspio jer je došlo do problema s jednom od datoteka, {$a->name}.<br /> Evo zapisa o problemu: <br />{$a->problem}<br />Nije moguće oporaviti se od ove pogreške.';
$string['uploadfilelog'] = 'Zapis o prijenosu datoteke {$a}';
$string['uploadformlimit'] = 'Datoteka {$a} koju ste pokušali prenijeti na poslužitelj je veća od maksimalne veličine dozovoljene ograničenjem ovog obrasca';
$string['uploadlabel'] = 'Naslov:';
$string['uploadlimitwithsize'] = '{$a->contextname} ograničenje veličine za prijenos ({$a->displaysize})';
$string['uploadnewfile'] = 'Prenesite novu datoteku';
$string['uploadnofilefound'] = 'Datoteka nije pronađena - jeste li sigurni da ste odabrali datoteku za prijenos?';
$string['uploadnotallowed'] = 'Prijenos datoteka nije dopušten';
$string['uploadnotempdir'] = 'Nedostaje privremena mapa (temp)';
$string['uploadoldfilesdeleted'] = 'Stare datoteke u vašem prostoru za prijenos datoteka su izbrisane';
$string['uploadpartialfile'] = 'Prijenos datoteka nije izvršen u cijelosti';
$string['uploadproblem'] = 'Prilikom prijenosa datoteke \'{$a}\' dogodila se neidentificirana pogreška (možda je ista bila prevelika?)';
$string['uploadrenamedchars'] = 'Datoteka {$a->oldname} je preimenovana u {$a->newname} zbog nedopuštenih znakova u nazivu.';
$string['uploadrenamedcollision'] = 'Datoteka {$a->oldname} je preimenovana u {$a->newname} zbog konflikta s postojećom istoimenom datotekom.';
$string['uploadserverlimit'] = 'Datoteka koja je prenešena je veća od maksimalne veličine dopuštene ograničenjem ovog poslužitelja';
$string['uploadthisfile'] = 'Prenesi ovu datoteku';
$string['url'] = 'URL';
$string['used'] = 'Korišteno';
$string['usedinnplaces'] = 'Koristi se na {$a} mjesta';
$string['usemessageform'] = 'ili upotrijebite obrazac prikazan dolje za slanje poruke odabranim studentima';
$string['user'] = 'Korisnik';
$string['userconfirmed'] = '{$a} potvrđen';
$string['usercurrentsettings'] = 'Postavke profila';
$string['userdata'] = 'Podaci o korisniku';
$string['userdeleted'] = 'Ovaj korisnički račun je izbrisan';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'Ovdje možete unijeti neke podatke o sebi koji će biti prikazani na stranici vašeg profila.';
$string['userdetails'] = 'Detalji o korisniku';
$string['userfiles'] = 'Korisničke datoteke';
$string['userlist'] = 'Popis korisnika';
$string['username'] = 'Korisničko ime';
$string['usernameemailmatch'] = 'Korisničko ime i adresa e-pošte se ne odnose na istog korisnika';
$string['usernameexists'] = 'Navedeno korisničko ime već postoji, izaberite neko drugo';
$string['usernamelowercase'] = 'Dopuštena su samo mala slova';
$string['usernamenotfound'] = 'Korisničko ime nije pronađeno u bazi podataka';
$string['usernameoremail'] = 'Unesite korisničko ime ILI adresu e-pošte';
$string['usernotconfirmed'] = 'Ne mogu potvrditi {$a}';
$string['userpic'] = 'Slika korisnika';
$string['users'] = 'Korisnici';
$string['userselectorautoselectunique'] = 'Ako se podudara samo jedan korisnik, automatski ga odaberi.';
$string['userselectorpreserveselected'] = 'Zadrži korisnike označenima, iako više ne odgovaraju pretraživanju';
$string['userselectorsearchanywhere'] = 'Pronađi traženi tekst bilo gdje u prikazanim poljima';
$string['usersnew'] = 'Novi korisnici';
$string['usersnoaccesssince'] = 'Neaktivan više od';
$string['userswithfiles'] = 'Korisnici s datotekama';
$string['useruploadtype'] = 'Vrsta prijenosa korisnika: {$a}';
$string['userviewingsettings'] = 'Postavke profila: {$a}';
$string['userzones'] = 'Korisničke zone';
$string['usetheme'] = 'Koristi temu';
$string['usingexistingcourse'] = 'Koristeći postojeći kolegij';
$string['valuealreadyused'] = 'Ova vrijednost je već korištena.';
$string['version'] = 'Inačica';
$string['view'] = 'Prikaz';
$string['viewallcourses'] = 'Prikaži sve kolegije';
$string['viewallcoursescategories'] = 'Prikaži sve kolegije i kategorije';
$string['viewallsubcategories'] = 'Prikaz svih potkategorija';
$string['viewfileinpopup'] = 'Prikaži datoteku u popup prozoru';
$string['viewmore'] = 'Opširnije';
$string['viewprofile'] = 'Prikaži profil';
$string['views'] = 'Prikazi';
$string['viewsolution'] = 'vidi rješenje';
$string['virusfound'] = 'Upozorenje administratoru! ClamAV je pronašao virus u datoteci koju je korisnik {$a->user} prenio na kolegij {$a->course}. Rezultat ClamAV provjere:';
$string['virusfoundlater'] = 'Datoteka koju ste pokušali prenijeti: {$a->date}, naziva:  {$a->filename} za kolegij {$a->course} je zaražena virusom. Evo sažetka opisa operacije na datoteci:

{$a->action}

Ako je ovo bio predani rad, možda ju trebate ponovno predati kako bi ju vaš nastavnik mogao vidjeti.';
$string['virusfoundlateradmin'] = 'Pažnja! Datoteka koju je korisnik {$a->user} prenio {$a->date}, naziva:  {$a->filename} za kolegij {$a->course} je zaražena virusom. Evo sažetka opisa operacije na datoteci:

{$a->action}

Korisnik je također obaviješten.';
$string['virusfoundlateradminnolog'] = 'Pažnja! Datoteka naziva {$a->filename}, koja je prenešena na poslužitelj, zaražena je virusom. Moodle nije mogao odrediti koji ju je korisnik prenio na poslužitelj.

Evo sažetka opisa operacije na datoteci:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Pronadjen virus!';
$string['virusfounduser'] = 'Datoteka koju ste prenijeli, {$a->filename}, je provjerena antivirusnim programom i pronađeno je da je zaražena! Prijenos vaše datoteke NIJE uspio.';
$string['virusplaceholder'] = 'Datoteka koja je prenešena na sustav sadržavala je virus, pa je ili premještena ili izbrisana, a korisnik je obaviješten.';
$string['visible'] = 'Vidljivo';
$string['visible_help'] = 'Ova postavka određuje hoće li se kolegij pojaviti na popisu kolegija. Osim nastavnika i administratora, korisnici ne mogu uči u tečaj.';
$string['visibletostudents'] = 'Vidljivo studentima: {$a}';
$string['warning'] = 'Upozorenje';
$string['warningdeleteresource'] = 'Upozorenje: {$a} se koristi kao resurs. Želite li osvježiti resurs?';
$string['webpage'] = 'Web stranica';
$string['week'] = 'Tjedan';
$string['weekhide'] = 'Skrij ovaj tjedan od {$a}';
$string['weeklyoutline'] = 'Tjedni pregled';
$string['weeks'] = 'tjedni';
$string['weekshow'] = 'Prikaži ovaj tjedan {$a}';
$string['welcometocourse'] = 'Dobrodosli na kolegij {$a}';
$string['welcometocoursetext'] = 'Dobrodosli na online-kolegij {$a->coursename}!

Ako to vec niste ucinili do sada, trebali biste azurirati podatke o sebi (vidljivi u izborniku lijevo kada ste unutar kolegija), kako bi sto
lakse medjusobno komunicirali.

  {$a->profileurl}';
$string['whatforlink'] = 'Što želite napraviti s poveznicom?';
$string['whatforpage'] = 'Što želite napraviti s tekstom?';
$string['whattocallzip'] = 'Ime zip datoteke?';
$string['whattodo'] = 'Što napraviti';
$string['windowclosing'] = 'Ovaj prozor bi se trebao automatski zatvoriti. Ako se to ne dogodi, možete ga samostalno zatvoriti.';
$string['withchosenfiles'] = 'S odabranim datotekama';
$string['withdisablednote'] = '{$a} (onemogućeno)';
$string['withoutuserdata'] = 'bez korisničkih podataka';
$string['withselectedusers'] = 'S odabranim korisnicima...';
$string['withselectedusers_help'] = '* Pošalji poruku - za slanje poruke jednom ili više sudionika
* Dodaj novu bilješku - za dodavanje bilješke o odabranom sudioniku
* Dodaj zajedničku bilješku - za dodavanje iste bilješke o više sudionika';
$string['withuserdata'] = 's korisničkim podacima';
$string['wordforstudent'] = 'Vaša riječ za studenta';
$string['wordforstudenteg'] = 'npr. student, sudionik, sl.';
$string['wordforstudents'] = 'Vaša riječ za studente (množinu)';
$string['wordforstudentseg'] = 'npr. studenti, sudionici, sl.';
$string['wordforteacher'] = 'Vaša riječ za nastavnika';
$string['wordforteachereg'] = 'npr. predavač, profesor, voditelj kolegija, sl.';
$string['wordforteachers'] = 'Vaša riječ za nastavnike (množinu)';
$string['wordforteacherseg'] = 'npr. predavači, profesori, voditelji kolegija, sl.';
$string['writingblogsinfo'] = 'Zapisivanje podatke o blogovima';
$string['writingcategoriesandquestions'] = 'Zapisivanje kategorija i pitanja';
$string['writingcoursedata'] = 'Zapisivanje podataka kolegija';
$string['writingeventsinfo'] = 'Zapisivanje informacija o događajima';
$string['writinggeneralinfo'] = 'Zapisivanje općih informacija';
$string['writinggradebookinfo'] = 'Zapisivanje podataka o ocjenama';
$string['writinggroupingsgroupsinfo'] = 'Zapisivanje podataka o grupacijama-grupama';
$string['writinggroupingsinfo'] = 'Zapisivanje informacija o grupacijama';
$string['writinggroupsinfo'] = 'Zapisivanje informacija o grupama';
$string['writingheader'] = 'Zapisivanje zaglavlja';
$string['writingloginfo'] = 'Zapisivanje informacija o logovima';
$string['writingmessagesinfo'] = 'Zapisivanje informacija o porukama';
$string['writingmoduleinfo'] = 'Zapisivanje informacija o modulima';
$string['writingscalesinfo'] = 'Zapisivanje informacija o skalama ocjenjivanja';
$string['writinguserinfo'] = 'Zapisivanje informacija o korisnicima';
$string['wrongpassword'] = 'Netočna lozinka';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'godina';
$string['years'] = 'godine';
$string['yes'] = 'Da';
$string['youareabouttocreatezip'] = 'Započet će stvaranje zip arhive koja sadrži';
$string['youaregoingtorestorefrom'] = 'Započet će proces vraćanja podataka za';
$string['youneedtoenrol'] = 'Kako biste to napravili, morate se upisati na ovaj kolegij';
$string['yourlastlogin'] = 'Vaša zadnja prijava sustavu';
$string['yourself'] = 'vi';
$string['yourteacher'] = 'vaš {$a}';
$string['yourwordforx'] = 'Vaš naziv za \'{$a}\'';
$string['zippingbackup'] = 'Sažimanje backup datoteke (zip)';
