<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'bn', branch 'MOODLE_24_STABLE'
 *
 * @package   local_amos
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>AMOS দ্বারা বুঝায় স্ট্রিং এর স্বয়ংক্রিয় পরিবর্তন। AMOS হল মুডলের স্ট্রিং এবং ইতিহাসের কেন্দ্রীয় রিপোজিটরি। এটা মুডল কোডে ইংরেজি স্ট্রিং যোগ পরীক্ষা, অনুবাদ একত্রীকরণ, সাধারন অনুবাদের কাজ ব্যবস্থাপনা এবং মুডল সার্ভারে প্রয়োগযোগ্য ভাষা প্যাকেজ তৈরি করে।</p>
<p>দেখুন <a href="http://docs.moodle.org/en/AMOS">AMOS ডকুমেন্টেশন</a> আরও তথ্যের জন্য।</p>';
$string['amos'] = 'AMOS - মডুল অনুবাদক টুল';
$string['amos:commit'] = 'স্টেজ স্ট্রিং প্রধান রিপোজিটরিতে জমা';
$string['amos:importfile'] = 'আপলোডকৃত ফাইল থেকে স্ট্রিং ইম্পোর্ট';
$string['amos:manage'] = 'AMOS পোর্টাল ব্যবস্থাপনা';
$string['amos:stage'] = 'AMOS অনুবাদক টুল ব্যবহার করে স্ট্রিং স্টেজ';
$string['amos:stash'] = 'নিয়মিত স্ট্যাশে বর্তমান স্টেজ জমা রাখুন';
$string['commitstage'] = 'স্টেজ স্ট্রিং জমা';
$string['commitstage_help'] = 'AMOS রিপোজিটরিতে স্থায়ীভাবে সব স্টেজ অনুবাদ জমা। স্টেজ স্বয়ংক্রিয়ভাবে কাটছাট করে এবং পুনরায় তৈরি করে জমা দেয়া হয়। শুধু জমা দেয়ার মত স্ট্রিং ই সংরক্ষণ করা হয়। তারমানে হচ্ছে নিচে সবুজ রং এ চিহ্নিত অনুবাদগুলোই জমা দেয়া হবে। জমা দেয়ার পর স্টেজ খালি করা হবে।';
$string['committableall'] = 'সব ভাষা';
$string['committablenone'] = 'কোনো ভাষা অনুমোদিত নয় - অনুগ্রহ করে AMOS ব্যবস্থাপকের সাথে যোগাযোগ';
$string['confirmaction'] = 'এটা পূর্বাবস্থায় ফিরিয়ে আনা যায় না। আপনি কি নিশ্চিত?';
$string['contribaccept'] = 'গ্রহণ';
$string['contribactions'] = 'অবদানকৃত অনুবাদ অ্যাকশন';
$string['contribactions_help'] = 'আমাদের অধিকার এবং কাজের ধারার উপর নির্ভর করে, আমরা নিম্নোক্ত কাজ পেতে পারি:

* প্রয়োগ - যে অনুবাদ করা হয়েছে তা আপনার স্টেজে অনুলিপি করুন। অবদানের রেকর্ড পরিবর্তন করা যাবে না
* আমাকে দেয়া হবে - অবদানে নিয়োগকারী হিসাবে আপনার নিজেকে নির্ধারণ করতে হবে, যে অবদান রিভিউ এবং ইন্টিগ্রেশনের জন্য দায়ী থাকবে
* বরখাস্ত - অবদান নিয়োগকারী হিসাবে কাউকে নির্ধারন করা হয়নি
* রিভিউ শুরু - নতুন অবদানে নিজেকে নিয়োগ করুন, \'রিভিউ\' এ এর স্ট্যাটাস নির্ধারণ করুন এবং আপনার স্টেজে জমাকৃত অনুবাদ অনুলিপি করুন
* গ্রহণ - গৃহিত হিসাবে আপনার অনুবাদ চিহ্নিত করুন
* প্রত্যাখান - প্রত্যাখিত হিসাবে আপনার অনুবাদ চিহ্নিত করুন, অনুগ্রহ করে মন্তব্যে এর কারণ বর্ণনা করুন';
$string['contribapply'] = 'প্রয়োগ';
$string['contribassignee'] = 'নিয়োগকারী';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'আমাকে দিন';
$string['contribauthor'] = 'লেখক';
$string['contribclosedno'] = 'সমাধানকৃত অবদান আড়াল';
$string['contribclosedyes'] = 'সমাধানকৃত অবদান প্রদর্শন';
$string['contribcomponents'] = 'কম্পোনেন্ট';
$string['contribid'] = 'আইডি';
$string['contribincomingnone'] = 'আসন্ন কোনো অবদানকারী নেই';
$string['contribincomingsome'] = 'আসন্ন অবদানকারী ({$a}';
$string['contriblanguage'] = 'ভাষা';
$string['contribreject'] = 'প্রত্যাখান';
$string['contribresign'] = 'বরখাস্ত';
$string['contribstartreview'] = 'রিভিউ শুরু';
$string['contribstatus'] = 'অবস্থা';
$string['contribstatus0'] = 'নতুন';
$string['contribstatus10'] = 'রিভিউতে';
$string['contribstatus20'] = 'প্রত্যাখ্যান';
$string['contribstatus30'] = 'গৃহীত';
$string['contribstatus_help'] = 'অবদানকৃত অনুবাদের কাজে নিম্নোক্ত ধাপগুলো থাকে:

* নতুন - অবদান জমা দেয়া হয়েছে কিন্তু এখন পর্যন্ত রিভিউ করা হয়নি
* রিভিউতে - ভাষা প্যাক ব্যবস্থাপকের কাছে এ অবদান দেয়া হয়েছে এবং রিভিউ এর জন্য স্টেজ করা হয়েছে
*প্রত্যাখিত - ভাষা প্যাক ব্যবস্থাপক অবদান প্রত্যাখান করেছে এবং মন্তব্যে একটি ব্যাখ্যা দেয়া হয়
* গৃহিত - ভাষা প্যাক ব্যবস্থাপক অবদান গ্রহন করেছে';
$string['contribstrings'] = 'স্ট্রিং';
$string['contribstringseq'] = '{$a->orig} নতুন';
$string['contribstringsnone'] = '{$a->orig} (ভাষা প্যাকে সব কিছু ইতোমধ্যে অনুবাদ করা আছে)';
$string['contribstringssome'] = '{$a->orig} ({$a->same} এর মত সবগুলোর ইতোমধ্যে আরও সাম্প্রতিক অনুবাদ আছে)';
$string['contribsubject'] = 'বিষয়';
$string['contribsubmittednone'] = 'কোনো অবদান জমা দেয়া হয়নি';
$string['contribsubmittedsome'] = 'আপনার অবদান ({$a})';
$string['contribtimemodified'] = 'পরিবর্তিত';
$string['contributions'] = 'অবদান';
$string['emailacceptbody'] = 'ভাষা প্যাক ব্যবস্থাপক {$a->assignee} আপনার অবদানকৃত অনুবাদ #{$a->id} {$a->subject} অনুমোদন করেছে।

আরও বিস্তারিত তথ্য জানতে {$a->url} দেখুন।';
$string['emailacceptsubject'] = '[AMOS contribution] অনুমোদিত';
$string['emailcontributionbody'] = 'ব্যবহারকারী {$a->author} নতুন অনুবাদ #{$a->id} {$a->subject} জমা দিয়েছে।

বিস্তারিত তথ্যের জন্য {$a->url} দেখুন।';
$string['emailcontributionsubject'] = '[AMOS contribution] নতুন অনুবাদ জমা দেয়া হয়েছে';
$string['emailrejectbody'] = 'ভাষা প্যাক ব্যবস্থাপক {$a->assignee} আপনার অবদান #{$a->id} {$a->subject} প্রত্যাখ্যান করেছে।

আরও বিস্তারিত তথ্যের জন্য {$a->url} দেখুন।';
$string['emailrejectsubject'] = '[AMOS contribution] প্রত্যাখ্যান';
$string['emailreviewbody'] = 'ভাষা প্যাক ব্যবস্থাপক {$a->assignee} আপনার অবদানকৃত অনুবাদ #{$a->id} {$a->subject} রিভিউ করছে।

আরও বিস্তারিত তথ্যের জন্য {$a->url} দেখুন।';
$string['emailreviewsubject'] = '[AMOS contribution] রিভিউ শুরু';
$string['err_exception'] = 'ত্রুটি: {$a}';
$string['err_invalidlangcode'] = 'অকার্যকর ভাষা কোড';
$string['err_parser'] = 'পার্সিং ত্রুটি: {$a}';
$string['filtercmp'] = 'কম্পোনেন্ট';
$string['filtercmp_desc'] = 'এ কম্পোনেন্ট এর স্ট্রিং প্রদর্শন';
$string['filterlng'] = 'ভাষা';
$string['filterlng_desc'] = 'এ ভাষায় অনুবাদ প্রদর্শন';
$string['filtermis'] = 'বিবিধ';
$string['filtermis_desc'] = 'স্ট্রিং এ অতিরিক্ত শর্ত প্রদর্শন';
$string['filtermisfglo'] = 'কেবল ধুসর তালিকাভুক্ত স্ট্রিং';
$string['filtermisfhlp'] = 'কেবল সহায়তা স্ট্রিং';
$string['filtermisfmis'] = 'কেবল অনুপস্থিত এবং মেয়াদ শেষ হয়ে যাওয়া স্ট্রিং';
$string['filtermisfstg'] = 'কেবল বিভাগীয় স্ট্রিং';
$string['filtermisfwog'] = 'ধুসর তালিকাভুক্ত স্ট্রিং ছাড়া';
$string['filtersid'] = 'স্ট্রিং আইডেন্টিফায়ার';
$string['filtersid_desc'] = 'স্ট্রিং অ্যারে এ কী';
$string['filtertxt'] = 'সাবস্ট্রিং';
$string['filtertxtcasesensitive'] = 'অক্ষর-ছাঁদ সংবেদনশীল';
$string['filtertxt_desc'] = 'যে টেক্সট দেয়া আছে তা স্ট্রিং এ থাকতে হবে';
$string['filtertxtregex'] = 'রিজেক্স';
$string['filterver'] = 'সংস্করণ';
$string['filterver_desc'] = 'এ মডুল সংস্করণ থেকে স্ট্রিং প্রদর্শন';
$string['found'] = 'খুঁজুন: {$a->found} &nbsp;&nbsp;&nbsp;অনুপস্থিত : {$a->missing} ({$a->missingonpage})';
$string['foundinfo'] = 'যে সংখ্যক স্ট্রিং পাওয়া গেছে';
$string['foundinfo_help'] = 'অনুবাদক টেবিলে সর্বমোট সংখ্যক সারি, অনুপস্থিত অনুবাদের সংখ্যা এবং বর্তমান পৃষ্ঠায় অনুপস্থিত অনুবাদের সংখ্যা প্রদর্শন করে।';
$string['gotofirst'] = 'প্রথম পৃষ্ঠায় যান';
$string['gotoprevious'] = 'পূর্ববর্তী  পৃষ্ঠায় যান';
$string['greylisted'] = 'ধুসর তালিকাভুক্ত স্ট্রিং';
$string['greylisted_help'] = 'বৈধতাজনিত কারণে, মুডল ভাষা প্যাকে এমন কিছু স্ট্রিং আছে যা আর ব্যবহৃত হয় না কিন্তু এখনও মুছে ফেলা হয়নি। স্ট্রিং \'ধুসর তালিকাভুক্ত\'। একাবার যদি এটা নিশ্চিত হওয়া যায় যে ধুসর তালিকাভুক্ত স্ট্রিং ব্যবহৃত হয় না, তখন তা ভাষা প্যাক থেকে অপসারণ করা হয়।

মুডলে আপনার যদি এমন কোনো ধুসর তালিকাভুক্ত স্ট্রিং চোখে পড়ে, অনুগ্রহ করে এ সাইটে মুডল অনুবাদ কোর্সে ফোরাম পোস্টের সাহায্যে আমাদের তা জানান। অন্যথায়, মুডলে অহরহ ব্যবহৃত স্ট্রিং অনুবাদ করে এবং ধুসর তালিকাভুক্ত স্ট্রিং উপেক্ষা করে আপনি আপনার মূল্যবান সময় বাঁচাতে পারেন।';
$string['greylistedwarning'] = 'স্ট্রিং ধুসর তালিকাভুক্ত';
$string['importfile'] = 'ফাইল থেকে অনুবাদকৃত স্ট্রিং ইম্পোর্ট';
$string['importfile_help'] = 'যদি অফলাইনে অনুবাদকৃত স্ট্রিং থাকে, আপনি ফর্ম এর সাহায্যে তাদের স্টেজ করে নিতে পারেন।

* ফাইলটি অবশ্যই কার্যকর মুডল PHP স্ট্রিং ডেফিনেশন ফাইল। উদাহরণস্বরূপ, মুডল ইনস্টলেশনের `/lang/en/` ডিরেক্টরিতে দেখুন।
* ফাইলের নাম সরবরাহকৃত কম্পোনেন্টের ইংরেজি স্ট্রিল ডেফিনেশনের সাথে মিলতে হবে (যেমন `moodle.php`, `assignment.php` অথবা `enrol_manual.php`)।

 ফাইলে পাওয়া সব স্ট্রিং নির্বাচিত সংস্করণ এবং ভাষায় ভাগ করা হবে।';
$string['importfile_link'] = 'local/amos/importfile';
$string['language'] = 'ভাষা';
$string['languages'] = 'ভাষা';
$string['log'] = 'লগ';
$string['logfilterbranch'] = 'সংস্করণ';
$string['logfiltercommithash'] = 'git hash';
$string['logfiltercommitmsg'] = 'বার্তার বিষয়বস্তু জমা';
$string['logfiltercommits'] = 'ফিল্টার জমা';
$string['logfiltercommittedafter'] = 'যার পর জমা দেয়া হবে';
$string['logfiltercommittedbefore'] = 'যার আগে জমা দেয়া হবে';
$string['logfiltercomponent'] = 'কম্পোনেন্ট';
$string['logfilterlang'] = 'ভাষা';
$string['logfiltershow'] = 'ফিল্টার করা জমা এবং স্ট্রিং প্রদর্শন';
$string['logfiltersource'] = 'উৎস';
$string['logfiltersourceamos'] = 'amos (ওয়েব ভিত্তিক অনুবাদক)';
$string['logfiltersourcecommitscript'] = 'commitscript (বার্তা জমায় AMOScript)';
$string['logfiltersourcegit'] = 'git (মুডল সোর্স কোড এবং 1.x packs এর git mirror)';
$string['logfiltersourcerevclean'] = 'revclean (পাল্টা ক্লিনআপ প্রসেস)';
$string['logfilterstringid'] = 'স্ট্রিং আইডেন্টিফায়ার';
$string['logfilterstrings'] = 'স্ট্রিং ফিল্টার';
$string['logfilterusergrp'] = 'জমাকারী';
$string['logfilterusergrpor'] = 'অথবা';
$string['maintainers'] = 'ব্যবস্থাপক';
$string['markuptodate'] = 'অনুবাদ হালনাগাদকৃত করা';
$string['markuptodate_help'] = 'AMOS সনাক্ত করেছে যে স্ট্রিং পুরনো হতে পারে কারণ অনুবাদ করার পর ইংরেজি  সংস্করণ পরিবর্তিত হয়েছে। অনুবাদ রিভিউ। আপনি যদি এটা হালনাগাদকৃত হিসাবে পান, তবে চেকবক্সে ক্লিক। অন্যভাবে সম্পাদনা করুন।';
$string['markuptodate_link'] = 'local/amos/outdatedstrings';
$string['merge'] = 'একত্রীকরণ';
$string['mergestrings'] = 'অন্য শাখা থেকে স্ট্রিং একত্রীকরণ';
$string['mergestrings_help'] = 'এটা সব স্ট্রিং সোর্স শাখা থেকে নিয়ে টার্গেট শাখায় যা এখন পর্যন্ত অনুবাদ করা হয়নি সেগুলো স্টেজ করা হবে। এ টুল ব্যবহার করে প্যাকের অন্য যে কোনো সংস্করণে অনুবাদকৃত স্ট্রিং অনুলিপি করতে পারেন। কেবল ভাষা প্যাক ব্যবস্থাপক এ টুল ব্যবহার করতে পারে।';
$string['mergestrings_link'] = 'local/amos/merge';
$string['newlanguage'] = 'নতুন ভাষা';
$string['nofiletoimport'] = 'অনুগ্রহ করে ইম্পোর্ট করার জন্য একটি ফাইল দিন।';
$string['nologsfound'] = 'কোনো স্ট্রিং পাওয়া যায়নি, অনুগ্রহ করে ফিল্টার পরিবর্তন করুন';
$string['nostringsfound'] = 'কোনো স্ট্রিং পাওয়া যায়নি';
$string['nostringsfoundonpage'] = 'পৃষ্ঠা {$a} কোনো স্ট্রিং পাওয়া যায়নি';
$string['nostringtoimport'] = 'কোনো কার্যকর স্ট্রিং পাওয়া যায়নি। নিশ্চিত হন যে ফাইলের নাম সঠিক এবং ফাইলটি ঠিকভাবে ফরম্যাট করা হয়েছে।';
$string['nothingtomerge'] = 'সোর্স শাখায় কোনো নতুন স্ট্রিং নেই যা টার্গেট শাখায় অনুপস্থিত থাকবে। একত্রীকরণ করার মত কিছু নেই।';
$string['numofcommitsabovelimit'] = 'কমিট ফিল্টারের সাথে মেলে এমন কমিট খুঁজুন {$a->found}, সবচেয়ে সাম্প্রতিক {$a->limit} ব্যবহার করে';
$string['numofcommitsunderlimit'] = 'কমিট ফিল্টারের সাথে মেলে এমন কমিট খুঁজুন {$a->found}';
$string['numofmatchingstrings'] = 'এটা ছাড়া, স্ট্রিং ফিল্টারে {$a->commits} কমিটে {$a->strings} পরিবর্তন মিলে যায়';
$string['outdatednotcommitted'] = 'বাতিলকৃত স্ট্রিং';
$string['outdatednotcommitted_help'] = 'AMOS একে বতিলকৃত হিসাবে সনাক্ত করতে পারে কারণ এর ইংরেজি সংস্করণ অনুবাদ করার পর আবার পরিবর্তিত হয়েছে। অনুগ্রহ করে অনুবাদ রিভিউ করুন।';
$string['outdatednotcommittedwarning'] = 'বাতিল';
$string['ownstashactions'] = 'স্ট্যাশ অ্যাকশন';
$string['ownstashactions_help'] = '* প্রয়োগ - অনুবাদ করা স্ট্রিং স্ট্যাশ থেকে নিয়ে স্টেজে অনুলিপি এবং স্ট্যাশকে অপরিবর্তিত রাখা হয়। যদি স্ট্রিং ইতোমধ্যে বিভাগ করা হয় তবে তা স্ট্যাশের শীর্ষে একে রাখতে হবে।
* পপ - অনুবাদ করা স্ট্রিং স্ট্যাশ থেকে নিয়ে স্টেজে আনা হয় এবং স্ট্যাশ ড্রপ করতে হবে (প্রয়োগ করে ড্রপ)।
* - স্ট্যাশ স্ট্রিং দূরে রাখতে হবে।
* জমা - অফিসিয়াল ভাষা ব্যবস্থাপক এর নিকট স্ট্যাশ জমা দেয়ার ফর্ম খুলবে যাতে করে তারা অফিসিয়াল ভাষা প্যাকে তাদের অবদান যুক্ত করতে পারে।';
$string['ownstashes'] = 'আপনার স্ট্যাশ';
$string['ownstashes_help'] = 'এটা আপনার সব স্ট্যাশের তালিকা।';
$string['ownstashesnone'] = 'নিজের কোনো স্ট্যাশ পাওয়া যায়নি';
$string['permalink'] = 'পার্মালিংক';
$string['placeholder'] = 'প্লেসহোল্ডার';
$string['placeholder_help'] = 'প্লেসহোল্ডার `{$a}` বা `{$a->something}` এর মত কিছু বিশেষ স্টেটমেন্ট যা স্ট্রিং এ ব্যবহৃত হয়। যখন স্ট্রিং প্রকৃত অর্থে মূদ্রণ করা হয় তখন একটি মান দ্বারা তা প্রতিস্থাপিত হয়।

মূল স্ট্রিং য়েঙন আছে ঠিক সেভাবে এগুলো অনুলিপি করা জরুরী। এগুলো অনুবাদ করা বা বাম-ডান সজ্জা পরিবর্তন করার প্রয়োজন নেই।';
$string['placeholderwarning'] = 'স্ট্রিং এ প্লেসহোল্ডার আছে';
$string['pluginclasscore'] = 'কোর সাবসিস্টেম';
$string['pluginclassnonstandard'] = 'নন-স্ট্যান্ডার্ড প্লাগইন';
$string['pluginclassstandard'] = 'স্ট্যান্ডার্ড প্লাগইন';
$string['pluginname'] = 'AMOS';
$string['presetcommitmessage'] = '{$a->author} কর্তৃক করা অনুবাদ #{$a->id}';
$string['privileges'] = 'আপনার বিশেষ অধিকার';
$string['privilegesnone'] = 'আপনি কেবল পাবলিক তথ্য পড়তে পারবেন।';
$string['requestactions'] = 'অ্যাকশন';
$string['requestactions_help'] = '* প্রয়োগ - পুল রিকোয়েস্ট থেকে নিজের বিভাগে অনুলিপি। যদি এ স্ট্রিং ইতোমধ্যে এ বিভাগে থাকে তবে, এটা স্ট্যাশের সাথে ওভাররাইট করা হবে।
* আড়াল - পুল রিকোয়েস্ট ব্লক করা হয় যাতে তা আপনি আর দেখতে না পান।';
$string['sourceversion'] = 'সোর্স সংস্করণ';
$string['stage'] = 'বিভাগ';
$string['stageactions'] = 'স্টেজ অ্যাকশন';
$string['stageactions_help'] = '* স্টেজ করা স্ট্রিং সম্পাদনা - অনুবাদকের ফিল্টার সেটিং পরিবর্তন করে যাতে করে কেবল স্টেজ করা অনুবাদ প্রদর্শিত হবে।
* জমা দেয়া যাবে না এমন স্ট্রিং সরিয়ে ফেলা হবে - যে স্ট্রিং জমা দেয়ার জন্য অনুমোদিত নন তা সব এ বিভাগ থেকে সরিয়ে ফেলা হবে। স্টেজ জমা দেয়ার আগেই স্বয়ংক্রিয়ভাবে সরিয়ে ফেলা হবে।
* রিবেজ - সব অনুবাদ ভাগ করা হবে না এমনকি বর্তমান অনুবাদ বা রিপোজিটরিতে বর্তমান অনুবাদের চেয়ে পুরাতন যে অনুবাদ রয়েছে তা পরিবর্তন করা হবে না। বিভাগ জমা দেয়ার আগে স্বয়ংক্রিয়ভাবে রিবেজ করা হবে।
* সব আনস্টেজ - সব স্টেজ মুছে ফেলা হবে, সব স্টেজ করা অনুবাদ হারিয়ে গেছে।';
$string['stageedit'] = 'স্টেজ স্ট্রিং সম্পাদনা';
$string['stagelang'] = 'ভাষা';
$string['stageoriginal'] = 'মূল';
$string['stageprune'] = 'জমা দেয়া যায় না এমন কিছু সরিয়ে ফেলা';
$string['stagerebase'] = 'রিবেজ';
$string['stagestring'] = 'স্ট্রিং';
$string['stagestringsnocommit'] = '{$a->staged} স্টেজ করা স্ট্রিং রয়েছে';
$string['stagestringsnone'] = 'কোনো স্টেজ করা স্ট্রিং নেই';
$string['stagestringssome'] = '{$a->staged} স্টেজ স্ট্রিং রয়েছে, তার মধ্যে {$a->committable} জমা দেয়া যাবে';
$string['stagesubmit'] = 'ব্যবস্থাপকের কাছে জমা';
$string['stagetranslation'] = 'অনুবাদ';
$string['stagetranslation_help'] = 'স্টেজ করা যে অনুবাদ আছে জমা দেয়ার মত তা প্রদর্শন। সেল এর পটভূমির রঙ বলতে বুঝায়:

* সবুজ - কোনো স্ট্রিং পরিবর্তিত হয়েছে বা অনুপস্থিত অনুবাদ যোগ করা হয়েছে এবং আপনি অনুবাদ জমা দিতে অনুমেদিত।
* নীল - কোনো স্ট্রিং পরিবর্তিত হয়েছে বা অনুপস্থিত অনুবাদ যোগ করা হয়েছে কিন্তু আপনি অনুবাদ জমা দিতে অনুমেদিত নন।
* রংহীন - স্টেজ অনুবাদ বর্তমানটার মতই এবং তাই আর জমা দেয়া হবে না।';
$string['stageunstageall'] = 'সব আনস্টেজ';
$string['stashactions'] = 'স্ট্যাশিং অ্যাকশন';
$string['stashactions_help'] = 'স্ট্যাশ বর্তমান স্টেজের স্ন্যাপশট। অফিসিয়াল ভাষা প্যাক ব্যবস্থাপকের কাছে ভাষা প্যাকে যোগ করার জন্য স্ট্যাশ জমা দেয়া যেতে পারে।';
$string['stashapply'] = 'প্রয়োগ';
$string['stashautosave'] = 'স্বয়ংক্রিয়ভাবে সংরক্ষিত ব্যাকআপ স্ট্যাশ';
$string['stashautosave_help'] = 'স্ট্যাশে স্টেজের সবচেয়ে সাম্প্রতিক কিছু স্ন্যাপশট থাকে। যেমন, সব স্ট্রিং যখন দুর্ঘটনাবশত আনস্টেজ হয় তখনএটা আপনি ব্যাকআপ হিসাবে কিছু কিছু ক্ষেত্রে ব্যবহার করতে পারেন। স্ট্যাজে সব  স্ট্যাশ করা স্ট্রিং অনুলিপি করার জন্য \'প্রয়োগ\' অ্যাকশন ব্যবহার (যদি ইতোমধ্যে স্টেজ করা থাকে তবে স্ট্রিং ওভাররাইট করা হবে)।';
$string['stashcomponents'] = '<span>কম্পোনেন্ট:</span> {$a}';
$string['stashdrop'] = 'ড্রপ';
$string['stashes'] = 'স্ট্যাশ';
$string['stashlanguages'] = '<span>ভাষা:</span> {$a}';
$string['stashpop'] = 'পপ';
$string['stashpush'] = 'সব স্টেজ করা স্ট্রিং নতুন স্ট্যাশে নিয়ে আসা হয়';
$string['stashstrings'] = '<span>স্ট্রিং সংখ্যা:</span> {$a}';
$string['stashsubmit'] = 'ব্যবস্থাপকের কাছে জমা';
$string['stashsubmitdetails'] = 'বিস্তারিত তথ্য জমা';
$string['stashsubmitmessage'] = 'বার্তা';
$string['stashsubmitsubject'] = 'বিষয়';
$string['stashtitle'] = 'স্ট্যাশ শিরোনাম';
$string['stashtitledefault'] = 'WIP - {$a->time}';
$string['stringhistory'] = 'ইতিহাস';
$string['strings'] = 'স্ট্রিং';
$string['submitting'] = 'অবদান জমা';
$string['submitting_help'] = 'অফিসিয়াল ভাষা ব্যবস্থাপক এর কাছে অনুবাদ করা স্ট্রিং পাঠানো হবে। তাদের স্টেজে আপনার কাজটি প্রয়োগ করতে পারবে, এবং রিভিউ করে জমা দিতে পারবে। অনুগ্রহ করে আপনার কাজের বর্ণনা দিয়ে এবং এবং কেন আপনি আপনার অবদান সেখানে সংযুক্ত করতে চান তা নিয়ে একটি বার্তা পাঠান।';
$string['targetversion'] = 'টার্গেট সংস্করণ';
$string['translatorlang'] = 'ভাষা';
$string['translatorlang_help'] = 'যে ভাষা কোডে অনুবাদ করা হবে তা প্রদর্শন। <strong>+-</strong> লিঙ্ক ক্লিক করে স্ট্রিং এর টাইমলাইন ইতিহাস প্রদর্শন।';
$string['translatororiginal'] = 'মূল';
$string['translatororiginal_help'] = 'স্ট্রিং এর মূল ইংরেজি প্রদর্শন। এর নিচে, গুগল অনুবাদকের মাধ্যমে স্ট্রিং স্বয়ংক্রিয়ভাবে অনুবাদ করার জন্য এ লিঙ্ক দেখতে পারেন (যদি ভাষা সমর্থন করে এবং আপনার ব্রাউজারে জাভাস্ক্রিপ্ট সক্রিয় করা থাকে)। এছাড়াও আপনি কিছু অতিরিক্ত তথ্য পেতে পারেন, যেমন যদি স্ট্রিং এ কোনো প্লেসহোল্ডার থাকে।';
$string['translatorstring'] = 'স্ট্রিং';
$string['translatorstring_help'] = 'মুডল শাখা (সংস্করণ) প্রদর্শন, এ স্ট্রিং এর স্ট্রিং আইডেন্টিফায়ার এবং কম্পোনেন্ট যেখানে আছে।';
$string['translatortool'] = 'অনুবাদক';
$string['translatortranslation'] = 'অনুবাদ';
$string['translatortranslation_help'] = 'ইনপুট সম্পাদকে এটা চালু করার জন্য ক্লিক। অনুবাদ দিয়ে তারপর সেলের বাইরে ক্লিক করে তা স্টেজ করা হয়। সেলের পটভূমির রঙ বলতে বুঝায়:

* সবুজ - স্ট্রিং ইতিমধ্যে অনুবাদকৃত এবং অনুবাদ পরিবর্তন করপ জমা দেয়ার জন্য আপনি অনুমোদিত।
* হলুদ - স্ট্রিং জমা দেয়া যায় কিন্তু তা বাতিলকৃত। স্ট্রিং অনুবাদ করার পর ইংরেজি সংস্করণ পরিবর্তন করা যায়।
* লাল - স্ট্রিং অনুবাদ করা হয়নি এবং আপনি এটা অনুবাদ করে জমা দিতে পারেন।
* নীল - আপনি অনুবাদ পরিবর্তন করেছেন এবং এখন এটা স্ট্যাজ করা হয়েছে। আপনি লগআউট করার আগে অনুবাদ স্টেজ করতে ভুলবেন না!
* রংহীন - যদিও আপনি অনুবাদ স্টেজ করতে পারেন তবে আপনি এ ভাষায় তা জমা দিতে পারবেন না। আপনি কেবল ফাইলে এ স্টেজ এক্সপোর্ট করতে পারেন।';
$string['typecontrib'] = 'নন-স্ট্যান্ডার্ড প্লাগইন';
$string['typecore'] = 'কোর সাবসিস্টেম';
$string['typestandard'] = 'স্ট্যান্ডার্ড প্লাগইন';
$string['version'] = 'সংস্করণ';
