<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addanewdiscussion'] = 'আলোচনার নতুন বিষয় সংযুক্ত';
$string['addanewquestion'] = 'নতুন প্রশ্ন সংযুক্ত';
$string['addanewtopic'] = 'নতুন বিষয় সংযুক্ত';
$string['advancedsearch'] = 'উচ্চ পর্যায়ের অনুসন্ধান';
$string['allforums'] = 'সব ফোরাম';
$string['allowdiscussions'] = 'এই ফোরামে {$a} পোস্ট করা যাবে?';
$string['allowsallsubscribe'] = 'এই ফোরামটি প্রত্যেককে সাবস্ক্রাইব হওয়া অথবা না হওয়া নির্বাচনের অনুমোদন দেয়';
$string['allowsdiscussions'] = 'এই ফোরামটি প্রত্যেক ব্যক্তিকে আলোচনার বিষয় আরম্ভ করার অনুমতি দেয়।';
$string['allsubscribe'] = 'সব ফোরামে সাবস্ক্রাইব হওয়া';
$string['allunsubscribe'] = 'সব ফোরামে আনসাবস্ক্রাইব না হওয়া';
$string['alreadyfirstpost'] = 'ইতোমধ্যে এটি আলোচনার প্রথম পোস্ট';
$string['anyfile'] = 'যে কোন ফাইল';
$string['attachment'] = 'সংযুক্তি';
$string['attachment_help'] = 'ফোরাম পোস্টে আপনি এক অথবা একাধিক ফাইল ঐচ্ছিকভাবে সংযুক্ত করতে পারবেন। যদি আপনি ছবি সংযুক্ত করেন, এটি এই বার্তার পরে প্রদর্শিত হবে।';
$string['attachmentnopost'] = 'পোস্ট আইডি ছাড়া আপনি সংযুক্তি এক্সপোর্ট করতে পারবেননা';
$string['attachments'] = 'সংযুক্তি';
$string['blockafter'] = 'ব্লক করার জন্য পোস্ট থ্রেশহোল্ড';
$string['blockafter_help'] = 'ব্যবহারকারী প্রদত্ত সময়কালের মধ্যে পোস্ট করতে পারবে যা কিনা সেটিং পোস্টের সর্বোচ্চ নাম্বার উল্লেখ করে। মড/ফোরাম সক্ষমতা সহ ব্যবহারকারী:পোস্ট সীমা হতে postwithoutthrottling অব্যাহতি নেয়।';
$string['blockperiod'] = 'ব্লক করার জন্য সময়কাল';
$string['blockperioddisabled'] = 'ব্লক নয়';
$string['blockperiod_help'] = 'প্রদত্ত সময়কালের মধ্যে প্রদত্ত সংখ্যার বেশি পোস্ট করতে শিক্ষার্থীদের বাধা দেওয়া যাবে। মড/ফোরাম সক্ষমতা সহ ব্যবহারকারী:পোস্ট সীমা হতে postwithoutthrottling অব্যাহতি নেয়।';
$string['blogforum'] = 'ব্লগ-লাইক বিন্যাসে আদর্শ ফোরাম প্রদর্শিত';
$string['bynameondate'] = '{$a->নাম} - {$a->তারিখ} দ্বারা';
$string['cannotadd'] = 'এই ফোরামের জন্য আলোচনাটি সংযুক্ত করা যাচ্ছেনা';
$string['cannotadddiscussion'] = 'এই ফোরামে আলোচনা সংযুক্ত করতে গ্রুপ সদস্যপদের প্রয়োজন।';
$string['cannotadddiscussionall'] = 'সব অংশগ্রহনকারীর জন্য নতুন আলোচনার বিষয় সংযুক্ত করতে আপনার অনুমতি নেই।';
$string['cannotaddsubscriber'] = 'এই ফোরামে আইডি {$a} সহ সাবস্ক্রাইবার সংযুক্ত করা যাচ্ছেনা!';
$string['cannotaddteacherforumto'] = 'এই কোর্সে ০ বিভাগে রূপান্তর কৃত শিক্ষক ফোরাম সংযুক্ত করা যাচ্ছেনা';
$string['cannotcreatediscussion'] = 'নতুন আলোচনা তৈরি করা যাচ্ছেনা';
$string['cannotcreateinstanceforteacher'] = 'শিক্ষক ফোরামের জন্য নতুন কোর্স মডিউল তৈরি করা যাচ্ছেনা';
$string['cannotdeletepost'] = 'পোস্টটি অপসারণ করতে পারবেননা!';
$string['cannoteditposts'] = 'অন্যান্য মানুষের পোস্ট সম্পাদন করতে পারবেননা!';
$string['cannotfinddiscussion'] = 'এই ফোরামে আলোচনা পাওয়া যায়নি';
$string['cannotfindfirstpost'] = 'এই ফোরামে প্রথম পোস্টটি পাওয়া যায়নি';
$string['cannotfindorcreateforum'] = 'এই সাইটের জন্য প্রধান সংবাদ ফোরাম পাওয়া যাচ্ছেনা অথবা তৈরি করা যাচ্ছেনা';
$string['cannotfindparentpost'] = 'পোস্ট {$a} তে শীর্ষ প্যারেন্ট পাওয়া যাচ্ছেনা';
$string['cannotmovefromsingleforum'] = 'সহজ একটি আলোচনা ফোরাম থেকে আলোচনা সরানো যাচ্ছেনা';
$string['cannotmovenotvisible'] = 'ফোরাম দৃশ্যমান নয়';
$string['cannotmovetonotexist'] = 'এই ফোরামে সরানো যাবেনা - এটি বিদ্যমান নয়!';
$string['cannotmovetonotfound'] = 'এই কোর্সে লক্ষ্য ফোরাম পাওয়া যাচ্ছেনা।';
$string['cannotpurgecachedrss'] = 'উৎস এবং/অথবা গন্তব্য ফোরামের ক্যাশকৃত RSS ফীড বিশোধন করা যাচ্ছেনা - আপনার ফাইল অনুমোদন ফোরাম পরীক্ষা করুন';
$string['cannotremovesubscriber'] = 'এই ফোরাম থেকে {$a} আইডিযুক্ত সাবস্ক্রাইবার অপসারণ করা যাচ্ছেনা!';
$string['cannotreply'] = 'এই পোস্টে উত্তর দিতে পারবেন না';
$string['cannotsplit'] = 'এই ফোরাম থেকে আলোচনা বিভক্ত করা যাবেনা';
$string['cannotsubscribe'] = 'দুঃখিত, সাবস্ক্রাইব হতে হলে অবশ্যই গ্রুপের সদস্য হতে হবে।';
$string['cannottrack'] = 'এই ফোরাম ট্র্যাক করা বন্ধ করা যাচ্ছেনা';
$string['cannotunsubscribe'] = 'এই ফোরাম থেকে আপনাকে আনসাবস্ক্রাইব করা যাচ্ছেনা';
$string['cannotupdatepost'] = 'এই পোস্ট হালনাগাদ করতে পারবেন না';
$string['cannotviewpostyet'] = 'আপনি এখনো পোস্ট করেন নি তাই এই আলোচনায় অন্যান্য শিক্ষার্থীদের প্রশ্ন পড়তে পারবেননা';
$string['cleanreadtime'] = 'পড়ার ঘন্টা হিসেবে পুরাতন পোস্ট  চিহ্নিত';
$string['completiondiscussions'] = 'শিক্ষার্থীকে অবশ্যই আলোচনা তৈরি করতে হবে:';
$string['completiondiscussionsgroup'] = 'আলোচনার প্রয়োজন';
$string['completiondiscussionshelp'] = 'সম্পন্ন করতে আলোচনার প্রয়োজন';
$string['completionposts'] = 'শিক্ষার্থীকে অবশ্যই আলোচনা পোস্ট অথবা উত্তর দিতে হবে:';
$string['completionpostsgroup'] = 'পোস্ট প্রয়োজন';
$string['completionpostshelp'] = 'সম্পন্ন করতে আলোচনা অথবা উত্তর প্রয়োজন';
$string['completionreplies'] = 'শিক্ষার্থীকে অবশ্যই পোস্টের উত্তর দিতে হবে:';
$string['completionrepliesgroup'] = 'উত্তর প্রয়োজন';
$string['completionreplieshelp'] = 'সম্পন্ন করতে উত্তরের প্রয়োজন';
$string['configcleanreadtime'] = '\'পড়া\' টেবিল থেকে পুরাতন পোস্ট অপসারণ করতে দিনের ঘন্টা।';
$string['configdigestmailtime'] = 'People who choose to have emails sent to them in digest form will be emailed the digest daily. This setting controls which time of day the daily mail will be sent (the next cron that runs after this hour will send it).';
$string['configdisplaymode'] = 'আলোচনার যে কোন একটি পূর্বনির্ধারিত প্রদর্শন মোড নির্ধারিত হয়নি।';
$string['configenablerssfeeds'] = 'সব ফোরামের জন্য সুইচটি RSS ফীডের সম্ভাব্যতা সক্রিয় করবে। প্রত্যেক ফোরামের জন্য এখনো আপনাকে সেটিং এ নিজ হাতে ফীড চালু করতে হবে।';
$string['configenabletimedposts'] = 'নতুন একটি আলোচনা পোস্ট করার সময় যদি আপনি সময়কাল প্রদর্শন করতে চান তাহলে সেটিং এ \'হ্যাঁ\' নির্ধারণ করুন (পরীক্ষামূলক এখনো পর্যন্ত সম্পূর্ণ পরীক্ষা করে দেখা হয়নি)';
$string['configlongpost'] = 'এই দৈর্ঘ্যের (শুধু অক্ষর HTML নয়) বেশি যেকোন পোস্ট দীর্ঘ হিসেবে বিবেচনা করা হবে। সাইটের সামনের পৃষ্ঠায়, সামাজিক রীতি কোর্সের পৃষ্ঠায়, অথবা ব্যবহারকারী বৃত্তান্তে পোস্ট প্রদর্শিত হবে এবং এগুলো forum_shortpost এবং forum_longpost মানের মধ্যে যে কোন যায়গায় স্বাভাবিক বিরতি দিয়ে ছোট করা হয়েছে।';
$string['configmanydiscussions'] = 'ফোরামের প্রত্যেক পৃষ্ঠায় প্রদর্শিত আলোচনার সর্বোচ্চ সংখ্যা';
$string['configmaxattachments'] = 'প্রত্যেক পোস্টে পূর্বনির্ধারিতভাবে অনুমোদিত সংযুক্তির সর্বোচ্চ সংখ্যা।';
$string['configmaxbytes'] = 'সাইটটির সব ফোরামের পূর্বনির্ধারিত সংযুক্তির সর্বোচ্চ আকার (কোর্সের সীমা এবং অন্যান্য স্থানীয় সেটিং এর জন্য)';
$string['configoldpostdays'] = 'এত দিনের পুরানো পোস্ট পড়া হয়েছে হিসেবে বিবেচনা করা হবে।';
$string['configreplytouser'] = 'যখন একটি ফোরামে পোস্ট মেইল করা হয়, এটি কি ব্যবহারকারী ইমেইল ঠিকানা ধারণ করবে তাহলে গ্রাহক ব্যক্তিগতভাবে উত্তর না দিয়ে ফোরামের মাধ্যমে দিতে পারবে? যদিও এটি \'হ্যাঁ\' নির্ধারণ করা থাকে ব্যবহারকারীরা বৃত্তান্তে তাদের ইমেইল ঠিকানা গোপনীয় রাখা নির্বাচন করতে পারেন।';
$string['configshortpost'] = 'এই দৈর্ঘ্যের (শুধু অক্ষর HTML নয়) কমে যে কোন পোস্ট ছোট হিসেবে বিবেচনা করা হবে (নিম্নে প্রদর্শন)।';
$string['configtrackreadposts'] = 'যদি আপনি প্রত্যেক ব্যবহারকারীর পড়া হয়েছে/পড়া হয়নি ট্র্যাক করতে চান তাহলে \'হ্যাঁ\' নির্ধারণ করুন।';
$string['configusermarksread'] = 'যদি \'হ্যাঁ\' হয়, ব্যবহারকারী অবশ্যই নিজ হাতে পোস্ট পড়া হয়েছে তা চিহ্নিত করতে পারবে। যদি \'না\' হয়, যখন পোস্ট প্রদর্শিত হবে তখন তা পড়া হয়েছে হিসেবে চিহ্নিত হবে।';
$string['couldnotadd'] = 'অজানা একটি ত্রুটির জন্য আপনার পোস্ট সংযুক্ত করা যাচ্ছেনা';
$string['couldnotdeletereplies'] = 'দুঃখিত, মানুষ ইতোমধ্যে এটিতে উত্তর দিয়েছে তাই এটি অপসারণ করা যাবেনা';
$string['couldnotupdate'] = 'অজানা একটি ত্রুটির জন্য আপনার পোস্ট হালনাগাদ করা যাচ্ছেনা';
$string['delete'] = 'অপসারণ';
$string['deleteddiscussion'] = 'আলোচনার বিষয়টি অপসারিত';
$string['deletedpost'] = 'পোস্টটি অপসারিত';
$string['deletedposts'] = 'পোস্টসমূহ অপসারিত';
$string['deletesure'] = 'পোস্টটি অপসারণ করতে আপনি কি নিশ্চিত?';
$string['deletesureplural'] = 'পোস্ট এবং সব উত্তর অপসারণ করতে আপনি কি নিশ্চিত? ({$a} পোস্ট)';
$string['digestmailheader'] = 'এটি {$a->sitename} ফোরাম থেকে আপনার নতুন পোস্টের প্রত্যেক দিনের ডাইজেস্ট। আপনার ফোরাম ইমেইল পছন্দ পরিবর্তন করতে, {$a->userprefs} এ যান।';
$string['digestmailprefs'] = 'আপনার ব্যবহারকারী বৃত্তান্ত';
$string['digestmailsubject'] = '{$a}: ফোরাম ডাইজেস্ট';
$string['digestmailtime'] = 'ডাইজেস্ট ইমেল পাঠানোর সময়';
$string['digestsentusers'] = 'ইমেইল ডাইজেস্ট সফলতার সাথে {$a} তে পাঠানো হয়েছে।';
$string['disallowsubscribe'] = 'সাবস্ক্রিপশন এর অনুমতি নেই';
$string['disallowsubscribeteacher'] = 'সাবস্ক্রিপশন এর অনুমতি নেই (শিক্ষকদের ব্যতীত)';
$string['discussion'] = 'আলোচনা';
$string['discussionmoved'] = 'আলোচনা \'{$a}\' তে অপসারন করা হয়েছে।';
$string['discussionmovedpost'] = 'আলোচনা অপসারন করা হয়েছে <a href="{$a->discusshref}">এখানে</a> ফোরামে <a href="{$a->forumhref}">{$a->forumname}</a';
$string['discussionname'] = 'আলোচনার নাম';
$string['discussions'] = 'আলোচনা';
$string['discussionsstartedby'] = 'আলোচনা আরম্ভ হবে {$a} দ্বারা';
$string['discussionsstartedbyrecent'] = 'আলোচনা আরম্ভ হবে {$a} দ্বারা সাম্প্রতিক কালে';
$string['discussthistopic'] = 'বিষয়টি আলোচনা';
$string['displayend'] = 'প্রদর্শনের সমাপ্তি';
$string['displayend_help'] = 'একটি নির্দিষ্ট তারিখের পরে একটি ফোরাম পোস্ট লুকানো হবে কি হবেনা তা এই সেটিংটি উল্লেখ করে। মনে রাখবেন প্রসাশক সবসময় ফোরাম পোস্ট প্রদর্শন করতে পারবে।';
$string['displaymode'] = 'প্রদর্শন মোড';
$string['displayperiod'] = 'সময়কাল প্রদর্শন';
$string['displaystart'] = 'আরম্ভ করা প্রদর্শন';
$string['displaystart_help'] = 'একটি নির্দিষ্ট তারিখের পরে একটি ফোরাম পোস্ট প্রদর্শিত হবে কি হবেনা তা এই সেটিংটি উল্লেখ করে। মনে রাখবেন প্রসাশক সবসময় ফোরাম পোস্ট প্রদর্শন করতে পারবে।';
$string['eachuserforum'] = 'প্রত্যেক ব্যক্তি একটি করে আলোচনা পোস্ট করতে পারবে';
$string['edit'] = 'সম্পাদন';
$string['editedby'] = '{$a->নাম} দ্বারা সম্পাদিত - {$a->তারিখ} মূল জমা';
$string['editing'] = 'সম্পাদিত';
$string['emptymessage'] = 'আপনার পোস্টে কিছু ভুল হয়েছে। আপনি হয়তো এটি খালি রেখে দিয়েছেন, অথবা সংযুক্তিটি খুবই বড়। আপনার পরিবর্তনটি সংরক্ষিত হয়নি।';
$string['erroremptymessage'] = 'পোস্টকৃত বার্তা খালি করা যাবেনা';
$string['erroremptysubject'] = 'পোস্টকৃত বিষয় খালি করা যাবেনা';
$string['errorwhiledelete'] = 'রেকর্ড অপসারণের সময় একটি ত্রুটি হয়েছে।';
$string['everyonecanchoose'] = 'সাবস্ক্রাইবার হতে হলে সবাইকে তা নির্বাচন করতে হবে';
$string['everyonecannowchoose'] = 'সাবস্ক্রাইবার হতে হলে সবাই এখন নির্বাচন করতে পারবে';
$string['everyoneisnowsubscribed'] = 'প্রত্যেকে এখন এই ফোরাম সাবস্ক্রাইব করেছে';
$string['everyoneissubscribed'] = 'প্রত্যেকে এই ফোরামে সাবস্ক্রাইব করেছে';
$string['existingsubscribers'] = 'বিদ্যমান সাবস্ক্রাইবার';
$string['forcessubscribe'] = 'ফোরামটি সবাইকেই সাবস্ক্রাইব করে';
$string['forum'] = 'ফোরাম';
$string['forum:addnews'] = 'সংবাদ সংযুক্ত';
$string['forumauthorhidden'] = 'লেখক (লুকানো)';
$string['forumblockingalmosttoomanyposts'] = 'আপনি থ্রেশহোল্ডের পোস্টে ঢুকছেন। আপনি সর্বশেষ{$a->blockperiod} তে {$a->numposts} বার পোস্ট করেছেন এবং {$a->blockafter} পোস্টের সীমা।';
$string['forum:createattachment'] = 'সংযুক্তি তৈরি';
$string['forum:deleteanypost'] = 'যেকোন পোস্ট অপসারণ (যে কোন সময়)';
$string['forum:deleteownpost'] = 'নিজের পোস্ট অপসারণ (ডেডলাইনের মধ্যে)';
$string['forum:editanypost'] = 'যে কোন পোস্ট সম্পাদন';
$string['forum:exportdiscussion'] = 'সম্পূর্ণ আলোচনা এক্সপোর্ট';
$string['forum:exportownpost'] = 'নিজের পোস্ট এক্সপোর্ট';
$string['forum:exportpost'] = 'পোস্ট এক্সপোর্ট';
$string['forum:managesubscriptions'] = 'সাবস্ক্রিপশন পরিচালনা';
$string['forum:movediscussions'] = 'আলোচনা সরানো';
$string['forumname'] = 'ফোরামের নাম';
$string['forumposts'] = 'ফোরাম পোস্ট';
$string['forum:postwithoutthrottling'] = 'পোস্ট থ্রেশহোল্ড থেকে অব্যাহতি';
$string['forum:rate'] = 'পোস্টকে হার করা';
$string['forum:replynews'] = 'সংবাদের উত্তর';
$string['forum:replypost'] = 'পোস্টের উত্তর';
$string['forums'] = 'ফোরাম';
$string['forum:splitdiscussions'] = 'আলোচনা বিভক্ত';
$string['forum:startdiscussion'] = 'নতুন আলোচনা আরম্ভ করা';
$string['forumsubjecthidden'] = 'বিষয় (লুকানো)';
$string['forumtracked'] = 'যে পোস্ট পড়া হয়নি তা ট্র্যাক করা হচ্ছে';
$string['forumtrackednot'] = 'যে পোস্ট পড়া হয়নি তা ট্র্যাক করা হচ্ছে না';
$string['forumtype'] = 'ফোরামের ধরণ';
$string['forum:viewallratings'] = 'প্রত্যেকের দ্বারা আলাদা আলাদা অশোধিত রেটিং প্রদর্শন';
$string['forum:viewanyrating'] = 'যে কেউ গ্রহণ করতে পারে এরূপ সর্বমোট রেটিং প্রদর্শন';
$string['forum:viewdiscussion'] = 'আলোচনা প্রদর্শন';
$string['forum:viewhiddentimedposts'] = 'লুকানো সময়ভিত্তিক পোস্ট প্রদর্শন';
$string['forum:viewqandawithoutposting'] = 'সবসময় প্র এবং উ পোস্ট দেখা';
$string['forum:viewrating'] = 'আপনি গ্রহণ করতে পারেন এরূপ সর্বমোট রেটিং প্রদর্শন';
$string['forum:viewsubscribers'] = 'সাবস্ক্রাইবার প্রদর্শন';
$string['generalforum'] = 'সাধারণ ব্যবহারের জন্য আদর্শ ফোরাম';
$string['generalforums'] = 'সাধারণ ফোরাম';
$string['inforum'] = '{$a} তে';
$string['introblog'] = 'এই কোর্সে ব্যবহারকারীর ব্লগ থেকে এই ফোরামের পোস্টটি স্বয়ংক্রিভাবে অনুলিপি করা হয় কারন ব্লগ এন্ট্রি আর বিদ্যমান নেই';
$string['intronews'] = 'সাধারণ সংবাদ এবং ঘোষণা';
$string['introsocial'] = 'আপনার যে কোন সম্পর্কিত কথোপকথনের জন্য একটি খোলা ফোরাম';
$string['introteacher'] = 'শুধু শিক্ষক নোট এবং আলোচনার জন্য ফোরাম';
$string['invalidaccess'] = 'পৃষ্ঠাটি সঠিকভাবে দেওয়া হয়নি';
$string['invaliddiscussionid'] = 'আলোচনার আইডিটি ভুল অথবা আর বিদ্যমান নেই';
$string['invalidforcesubscribe'] = 'অকার্যকর ফোর্স সাবস্ক্রিপশন মোড';
$string['invalidforumid'] = 'ফোরাম আইডি ভুল';
$string['invalidparentpostid'] = 'প্যারেন্ট পোস্ট আইডি ভুল';
$string['invalidpostid'] = 'অকার্যকর পোস্ট আইডি - {$a}';
$string['lastpost'] = 'শেষ পোস্ট';
$string['learningforums'] = 'শিক্ষা গ্রহণের ফোরাম';
$string['longpost'] = 'দীর্ঘ পোস্ট';
$string['mailnow'] = 'এখনই মেইল করুন';
$string['manydiscussions'] = 'প্রত্যেক পৃষ্ঠায় আলোচনা';
$string['markalldread'] = 'যে আলোচনা পড়া হয়েছে তা সব পোস্ট চিহ্নিত করে রাখুন।';
$string['markallread'] = 'যে ফোরাম পড়া হয়েছে তা সব পোস্ট চিহ্নিত করে রাখুন।';
$string['markread'] = 'পড়া চিহ্নিত';
$string['markreadbutton'] = 'চিহ্নিত<br />পড়া';
$string['markunread'] = 'পড়া হয়নি তা চিহ্নিত';
$string['markunreadbutton'] = 'চিহ্নিত<br />পড়া হয়নি';
$string['maxattachments'] = 'সংযুক্তির সর্বোচ্চ সংখ্যা';
$string['maxattachments_help'] = 'ফোরাম পোস্টে সর্বোচ্চ কত সংখ্যক ফাইল সংযুক্ত করা যাবে সেটিংটি তা উল্লেখ করে।';
$string['maxattachmentsize'] = 'সংযুক্তির সর্বোচ্চ আকার';
$string['maxattachmentsize_help'] = 'ফোরাম পোস্টে কত বৃহত্তম আকার ফাইল সংযুক্ত করা যাবে সেটিংটি তা উল্লেখ করে।';
$string['maxtimehaspassed'] = 'দুঃখিত, এই পোস্ট ({$a}) সম্পাদনার জন্য সর্বোচ্চ সময় অতিবাহিত!';
$string['message'] = 'বার্তা';
$string['messageprovider:digests'] = 'ফোরাম সার-সংক্ষেপ সাবস্ক্রাইব করা';
$string['messageprovider:posts'] = 'ফোরাম পোস্ট সাবস্ক্রাইব করা';
$string['missingsearchterms'] = 'বর্ণিত অনুসন্ধান শর্তাবলী হবে শুধুমাত্র এই বার্তার HTML মার্কআপ:';
$string['modeflatnewestfirst'] = 'সমতল উত্তর প্রদর্শন, প্রথমে নতুনসহ';
$string['modeflatoldestfirst'] = 'সমতল উত্তর প্রদর্শন, প্রথমে পুরাতনসহ';
$string['modenested'] = 'নেস্টেড ফর্মে উত্তর প্রদর্শন';
$string['modethreaded'] = 'সূত্রতা ফর্মে উত্তর প্রদর্শন';
$string['modulename'] = 'ফোরাম';
$string['modulenameplural'] = 'ফোরাম';
$string['more'] = 'আরও';
$string['movedmarker'] = '(সরানো)';
$string['movethisdiscussionto'] = 'আলোচনাটি সরানো...';
$string['mustprovidediscussionorpost'] = 'এক্সপোর্ট করতে আপনাকে হয় আলোচনার আইডি অথবা পোস্ট আইডি দিতে হবে';
$string['namenews'] = 'সংবাদের ফোরাম';
$string['namenews_help'] = 'সংবাদ ফোরাম একটি বিশেষ ফোরাম যেখানে যখন একটি কোর্স তৈরি হলে স্বয়ংক্রিভাবে ঘোষণা তৈরি হয়। একটি কোর্সের শুধুমাত্র একটি সংবাদ ফোরাম থাকতে পারে। সংবাদ ফোরামে শুধুমাত্র শিক্ষক এবং প্রশাসক পোস্ট করতে পারে। সংবাদ ফোরাম থেকে "সর্বশেষ সংবাদ" ব্লকের মাধ্যমে সাম্প্রতিক আলোচনা প্রদর্শিত হবে।';
$string['namesocial'] = 'সামাজিক ফোরাম';
$string['nameteacher'] = 'শিক্ষকের ফোরাম';
$string['newforumposts'] = 'নতুন ফোরাম পোস্ট';
$string['noattachments'] = 'এই পোস্টে কোন সংযুক্তি নেই';
$string['nodiscussions'] = 'এখনও পর্যন্ত এই ফোরামে কোন আলোচনার বিষয় নেই';
$string['nodiscussionsstartedby'] = 'এই ব্যবহারকারী দ্বারা এখনো কোন আলোচনা শুরু হয়নি';
$string['noguestpost'] = 'দুঃখিত, অতিথিরা পোস্ট করতে পারবেনা।';
$string['noguesttracking'] = 'দুঃখিত, অতিথিদের ট্র্যাকিং অপশন নির্ধারণ করার অনুমোদন নেই।';
$string['nomorepostscontaining'] = '\'{$a}\' ধারণ করে এরূপ আর কোন পোস্ট পাওয়া যায়নি';
$string['nonews'] = 'এখনও পর্যন্ত কোন সংবাদ পোস্ট করা হয়নি';
$string['noonecansubscribenow'] = 'সাবস্ক্রিপশনের অনুমোদন নেই';
$string['nopermissiontosubscribe'] = 'ফোরাম সাবস্ক্রাইবার প্রদর্শনে আপনার অনুমতি নেই';
$string['nopermissiontoview'] = 'পোস্টটি প্রদর্শনে আপনার অনুমতি নেই';
$string['nopostforum'] = 'দুঃখিত, এই ফোরামে আপনার পোস্ট করার অনুমোদন নেই';
$string['noposts'] = 'কোন পোস্ট নেই';
$string['noquestions'] = 'এখনো পর্যন্ত এই ফোরামে কোন প্রশ্ন নেই';
$string['nosubscribers'] = 'এখনো পর্যন্ত এই ফোরামে কোন সাবস্ক্রাইবার নেই';
$string['notexists'] = 'আলোচনা আর বিদ্যমান নেই';
$string['nothingnew'] = '{$a} এর জন্য কোন কিছুই নতুন না';
$string['notingroup'] = 'দুঃখিত, এই ফোরাম দেখার জন্য আপানকে গ্রুপের সদস্য হতে হবে।';
$string['notinstalled'] = 'ফোরাম মডিউল ইনস্টল হয়নি';
$string['notpartofdiscussion'] = 'পোস্টটি আলোচনার অংশ নয়!';
$string['notrackforum'] = 'যে পোস্টটি পড়া হয়নি তা ট্র্যাক করা হবেনা';
$string['noviewdiscussionspermission'] = 'এই ফোরামে আলোচনা প্রদর্শনের আপনার অনুমতি নেই';
$string['nowallsubscribed'] = '{$a} তে সব ফোরাম সাবস্ক্রাইব করা হয়েছে।';
$string['nowallunsubscribed'] = '{$a} তে সব ফোরাম সাবস্ক্রাইব করা হয়নি।';
$string['nownotsubscribed'] = 'ইমেইল দ্বারা \'{$a->ফোরাম}\' এর অনুলিপি {$a->নাম} পাবেনা।';
$string['nownottracking'] = '{$a->নাম} আর \'{$a->ফোরাম}\' ট্র্যাক করছেনা।';
$string['nowsubscribed'] = 'ইমেইল দ্বারা \'{$a->ফোরাম}\' এর অনুলিপি {$a->নাম} পাবে।';
$string['nowtracking'] = '{$a->নাম} এখন \'{$a->ফোরাম}\' কে ট্র্যাক করছে।';
$string['numposts'] = '{$a} পোস্ট';
$string['olderdiscussions'] = 'পুরাতন আলোচনা';
$string['oldertopics'] = 'পুরাতন বিষয়';
$string['oldpostdays'] = 'দিন পরে পড়া';
$string['openmode0'] = 'কোন আলোচনা, কোন উত্তর নেই';
$string['openmode1'] = 'কোনো আলোচনা নয়, কিন্তু উত্তরের অনুমোদন নেই';
$string['openmode2'] = 'আলোচনা এবং উত্তরের অনুমোদন আছে';
$string['overviewnumpostssince'] = 'শেষ লগইন হতে পোস্ট';
$string['overviewnumunread'] = 'সর্বমোট পড়া হয়নি এরূপ';
$string['parent'] = 'উৎস প্রদর্শন';
$string['parentofthispost'] = 'এই পোস্টের প্যারেন্ট';
$string['pluginadministration'] = 'ফোরাম প্রশাসন';
$string['pluginname'] = 'ফোরাম';
$string['postadded'] = '<p>আপনার পোস্টটি সফলতার সাথে সংযুক্ত হয়েছে। </p> <p>যদি আপনি কোন পরিবর্তন করতে চান তাহলে {$a} তে সম্পাদন করুন।</p>';
$string['postaddedsuccess'] = 'আপনার পোস্ট সফলতার সাথে সংযুক্ত করা হয়েছে।';
$string['postaddedtimeleft'] = 'যদি আপনি কোন পরিবর্তন করতে চান তাহলে {$a} তে সম্পাদন করুন।';
$string['postincontext'] = 'বিষয়বস্তুতে এই পোস্ট দেখা';
$string['postmailinfo'] = 'এটি একটি বার্তার অনুলিপি যা {$a} ওয়েবসাইটে পোস্ট করা হয়েছে।

উত্তর দিতে এই লিঙ্কে ক্লিক করুন:';
$string['postmailnow'] = '<p>পোস্টটি তৎক্ষণাত ভাবে সব ফোরাম সাবস্ক্রাইবারের কাছে মেইল করা হবে।</p>';
$string['postrating1'] = 'অধিকাংশ জানা বিচ্ছিন্ন';
$string['postrating2'] = 'পৃথক এবং সংযুক্ত';
$string['postrating3'] = 'অধিকাংশ জানা সংযুক্ত';
$string['posts'] = 'পোস্ট';
$string['posttoforum'] = 'ফোরামে পোস্ট';
$string['postupdated'] = 'পোস্ট হালনাগাদ করা হয়েছে';
$string['potentialsubscribers'] = 'সম্ভাব্য সাবস্ক্রাইবার';
$string['processingdigest'] = '{$a} ব্যবহারকারীর প্রক্রিয়াধীন ই-মেইল সারসঙ্কলন';
$string['processingpost'] = 'প্রক্রিয়াধীন পোস্ট {$a}';
$string['prune'] = 'বিভক্ত';
$string['prunedpost'] = 'এই পোস্ট থেকে নতুন আলোচনা তৈরি করা হয়েছে';
$string['pruneheading'] = 'আলোচনাটি বিভক্ত করুন এবং এই পোস্টটিকে নতুন আলোচনায় সরান';
$string['qandaforum'] = 'প্র এবং উ ফোরাম';
$string['qandanotify'] = 'এটি একটি প্রশ্ন এবং উত্তর ফোরাম। এই প্রশ্নের অন্যান্যদের উত্তর দেখতে হলে, প্রথমে আপনাকে উত্তর পোস্ট করতে হবে';
$string['re'] = 'Re:';
$string['readtherest'] = 'এই বিষয়ের বাকী অংশ পড়া';
$string['replies'] = 'উত্তর';
$string['repliesmany'] = 'এখনো পর্যন্ত {$a} উত্তর';
$string['repliesone'] = 'এখনো পর্যন্ত {$a} উত্তর';
$string['reply'] = 'উত্তর';
$string['replyforum'] = 'ফোরামে উত্তর';
$string['replytouser'] = 'উত্তরে ইমেইল ঠিকানা ব্যবহার';
$string['resetforums'] = 'পোস্ট অপসারণ';
$string['resetforumsall'] = 'সব পোস্ট অপসারণ';
$string['resetsubscriptions'] = 'সব ফোরাম সাবস্ক্রিপশন অপসারণ';
$string['resettrackprefs'] = 'সব ফোরাম ট্র্যাকিং পছন্দ অপসারণ';
$string['rssarticles'] = 'সাম্প্রতিক RSS অনুচ্ছেদের সংখ্যা';
$string['rssarticles_help'] = 'RSS ফীডে কত সংখ্যক অনুচ্ছেদ (হয় আলোচনা অথবা পোস্ট) সংযুক্ত হবে সেটিংটি তা উল্লেখ করে। সাধরানত ৫ এবং ২০ এর মধ্যে গ্রহণযোগ্য।';
$string['rsssubscriberssdiscussions'] = 'আলোচনার RSS ফীড';
$string['rsssubscriberssposts'] = 'পোস্টের RSS ফীড';
$string['rsstype'] = 'এই প্রক্রিয়ার জন্য RSS ফীড';
$string['rsstype_help'] = 'এই প্রক্রিয়ার জন্য RSS ফীড সক্রিয় করতে, ফীডে আলোচনা অথবা পোস্ট অন্তরভুক্ত নির্বাচন করুন।';
$string['search'] = 'অনুসন্ধান';
$string['searchdatefrom'] = 'পোস্ট অবশ্যই এর থেকে নতুন হতে হবে';
$string['searchdateto'] = 'পোস্ট অবশ্যই এর থেকে পুরাতন হতে হবে';
$string['searchforumintro'] = 'বর্নিত এক বা একাধিক ক্ষেত্রে অনুগ্রহ করে অনুসন্ধানের শর্তাবলী দিন';
$string['searchforums'] = 'ফোরাম অনুসন্ধান';
$string['searchfullwords'] = 'এই শব্দগুলো অবশ্যই সম্পূর্ণ শব্দ হিসেবে দৃশ্যমান হতে হবে';
$string['searchnotwords'] = 'এই শব্দগুলো অন্তর্ভুক্ত করা যাবেনা';
$string['searcholderposts'] = 'পুরাতন পোস্ট অনুসন্ধান...';
$string['searchphrase'] = 'যথার্থ শব্দসমষ্টি অবশ্যই পোস্টে দৃশ্যমান হতে হবে';
$string['searchresults'] = 'অনুসন্ধানের ফলাফল';
$string['searchsubject'] = 'এই শব্দগুলো অবশ্যই বিষয়টিতে থাকতে হবে';
$string['searchuser'] = 'নামটি অবশ্যই লেখকের সাথে মিলতে হবে';
$string['searchuserid'] = 'লেখকের মুডল আইডি';
$string['searchwhichforums'] = 'কোন ফোরামে অনুসন্ধান করা হবে তা নির্বাচন';
$string['searchwords'] = 'পোস্টে যেকোন জায়গায় এই শব্দগুলো দৃশ্যমান হতে পারে';
$string['seeallposts'] = 'এই ব্যবহারকারী দ্বারা তৈরি সব পোস্ট দেখা';
$string['shortpost'] = 'ছোট পোস্ট';
$string['showsubscribers'] = 'প্রদর্শন/সম্পাদন বর্তমান সাবস্ক্রাইবার';
$string['singleforum'] = 'একটি সহজ আলোচনা';
$string['smallmessage'] = '{$a->forumname} এ পোস্টকৃত {$a->ব্যবহারকারী}';
$string['startedby'] = 'শুরু হবে';
$string['subject'] = 'বিষয়';
$string['subscribe'] = 'এই ফোরামে সাবস্ক্রাইব';
$string['subscribeall'] = 'এই ফোরামে প্রত্যেককে সাবস্ক্রাইব';
$string['subscribed'] = 'সাবস্ক্রাইবকৃত';
$string['subscribenone'] = 'এই ফোরাম থেকে প্রত্যেককে আনসাবস্ক্রাইব';
$string['subscribers'] = 'সাবস্ক্রাইবার';
$string['subscribersto'] = '\'{$a}\' তে সাবস্ক্রাইবার';
$string['subscribestart'] = 'এই ফোরামের পোস্টের ইমেইল অনুলিপি আমাকে পাঠান';
$string['subscribestop'] = 'এই ফোরামের পোস্টের ইমেইল অনুলিপি আমি চাইনা';
$string['subscription'] = 'সাবস্ক্রিপশন';
$string['subscriptionauto'] = 'স্বয়ংক্রিয় সাবস্ক্রিপশন';
$string['subscriptiondisabled'] = 'সাবস্ক্রিপশন নিষ্ক্রিয়';
$string['subscriptionforced'] = 'জোরপূর্বক সাবস্ক্রিপশন';
$string['subscription_help'] = 'যদি আপনি একটি ফোরাম সাবস্ক্রাইব করতে চান তাহলে এতে ফোরাম পোস্টের ইমেইলের অনুলিপি পাবেন। আপনি সাবস্ক্রাইব করতে চাচ্ছেন কিনা তা সাধারনত আপনি নির্বাচন করতে পারেন, যদিও মাঝেমধ্যে সাবস্ক্রিপশন জোরপূর্বক করে তাতে করে সবাই ফোরাম পোস্টের ইমেইলের অনুলিপি পাবে।';
$string['subscriptionmode'] = 'সাবস্ক্রিপশন মোড';
$string['subscriptionoptional'] = 'ঐচ্ছিক সাবস্ক্রিপশন';
$string['subscriptions'] = 'সাবস্ক্রিপশন';
$string['thisforumisthrottled'] = 'ফোরাম পোস্টটির প্রদত্ত সময়কালের মধ্যে আপনি কত সংখ্যক ফোরাম পোস্ট তৈরি করতে পারবেন তার সীমা আছে - বর্তমানে নির্ধারণ করা আছে {$a->blockafter} পোস্টিং {$a->blockperiod} তে';
$string['timedposts'] = 'সময় পোস্ট';
$string['timestartenderror'] = 'শুরুর তারিখ থেকে প্রদর্শন শেষের তারিখ কোন ভাবেই আগে হতে পারবেনা';
$string['trackforum'] = 'পড়া হয়নি এরূপ পোস্ট ট্র্যাক';
$string['tracking'] = 'ট্র্যাক';
$string['trackingoff'] = 'বন্ধ';
$string['trackingon'] = 'চালু';
$string['trackingoptional'] = 'ঐচ্ছিক';
$string['trackingtype'] = 'এই ফোরামের জন্য ট্র্যাকিং পড়তে চান?';
$string['trackingtype_help'] = 'যদি সক্রিয় থাকে, অংশগ্রহণকারীরা ফোরাম ও আলোচনায় পড়া এবং পড়া হয়নি এরূপ বার্তা ট্র্যাক করতে পারে।

এখানে তিনটি অপশন আছে:

* ঐচ্ছিক - অংশগ্রহণকারীরা ট্র্যাকিং চালু অথবা বন্ধ নির্বাচন করতে পারবে
* চালু - ট্র্যাকিং সর্বদাই চালু
* বন্ধ -  ট্র্যাকিং সর্বদাই বন্ধ';
$string['unread'] = 'পড়া হয়নি';
$string['unreadposts'] = 'পোস্ট পড়া হয়নি';
$string['unreadpostsnumber'] = '{$a} পোস্ট পড়া হয়নি';
$string['unreadpostsone'] = '১ টি পোস্ট পড়া হয়নি';
$string['unsubscribe'] = 'এই ফোরাম থেকে আনসাবস্ক্রাইব';
$string['unsubscribeall'] = 'সব ফোরাম থেকে আনসাবস্ক্রাইব';
$string['unsubscribeallconfirm'] = 'আপনি এখন {$a} ফোরাম সাবস্ক্রাইব করেছেন। আপনি কি সব ফোরাম আনসাবস্ক্রাইব এবং ফোরাম স্বয়ংক্রিয়-সাবস্ক্রাইব নিষ্ক্রিয় করতে চান?';
$string['unsubscribealldone'] = 'আপনার সব ফোরাম সাবস্ক্রিপশন অপসারিত হয়েছে, ফোরাম থেকে জোরপূর্বক সাবস্ক্রিপশনসহ ঘোষনা পেতে পারেন। যদি এই সার্ভার থেকে কোন ইমেইল না পেতে চান তাহলে অনুগ্রহ করে আপনার বৃত্তান্তে যান এবং সেখানে ইমেইল ঠিকানা নিষ্ক্রিয় করুন।';
$string['unsubscribeallempty'] = 'দুঃখিত, আপনি কোন ফোরাম সাবস্ক্রাইব করেন নি। যদি সার্ভার থেকে কোন ইমেইল পেতে না চান তাহলে অনুগ্রহ করে আপনার বৃত্তান্তে যান এবং সেখানে ইমেইল ঠিকানা নিষ্ক্রিয় করুন।';
$string['unsubscribed'] = 'আনসাবস্ক্রাইব করা হয়েছে';
$string['unsubscribeshort'] = 'আনসাবস্ক্রাইব';
$string['usermarksread'] = 'স্বনির্ধারিত বার্তা পড়া চিহ্নিত';
$string['viewalldiscussions'] = 'সব আলোচনা প্রদর্শন';
$string['warnafter'] = 'সতর্কীকরণের জন্য থ্রেশহোল্ড পোস্ট';
$string['warnafter_help'] = 'প্রদত্ত সময়কালের মধ্যে পোস্টের অনুমোদিত সর্বোচ্চ সংখ্যায় প্রবেশ করলে শিক্ষার্থীরা সতর্কীকরণ পাবে। সেটিংটি উল্লেখ করে কতগুলো পোস্টের পর তারা সতর্কীকরণ পাবে। ব্যবহারকারীরা সক্ষমতা মড/ফোরাম সহ:postwithoutthrottling পোস্ট সীমা থেকে অব্যাহতি দেওয়া হয়েছে।';
$string['yournewquestion'] = 'আপনার নতুন প্রশ্ন';
$string['yournewtopic'] = 'আপনার আলোচনার নতুন বিষয়';
$string['yourreply'] = 'আপনার উত্তর';
