<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'আপনি ইতোমধ্যে {$a} হিসাবে লগ করেছেন, ভিন্ন ব্যবহারকারী হিসাবে লগইন করার আগে এখান থেকে লগআউট করতে হবে।';
$string['authnotexisting'] = 'প্রমানীকরণ প্লাগইন বিদ্যমান নেই';
$string['backupcontainexternal'] = 'এ ব্যাকআপ ফাইলে বাহ্যিক নেটওয়ার্ক হোস্ট আছে যা স্থানীয়ভাবে কনফিগার করা নাই';
$string['backuptablefail'] = 'ব্যাকআপ টেবিল সফলভাবে নির্ধারণ করা যায়নি!';
$string['blockcannotconfig'] = 'এ ব্লক গ্লোবাল কনফিগারেশন সমর্থন করে না';
$string['blockcannotinistantiate'] = 'ব্লক অবজেক্ট তাৎক্ষনিককরণ করতে সমস্যা';
$string['blockcannotread'] = 'ব্লকআইডি= {$a} এর জন্য ডাটা পড়া যায়নি';
$string['blockdoesnotexist'] = 'এ ব্লক বিদ্যমান নেই';
$string['blockdoesnotexistonpage'] = 'এ ব্লক (আইডি={$a->instanceid}) এ পৃষ্ঠায় ({$a->url}) বিদ্যমান নেই।';
$string['blocknameconflict'] = 'নামকরণে দ্বন্দ্ব:ব্লক {$a->name} এবং বিদ্যমান ব্লক: {$a->conflict} এর শিরোনাম একই!';
$string['callbackrejectcomment'] = 'এ মন্তব্য যোগ করতে মডিউল প্রত্যাখান করে';
$string['cannotaddcoursemodule'] = 'নতুন কোর্স মডিউল যোগ করা যাচ্ছে না';
$string['cannotaddcoursemoduletosection'] = 'ঐ বিভাগে নতুন কোর্স মডিউল যোগ করা যাচ্ছে না';
$string['cannotaddmodule'] = '{$a} মডিউল, মডিউলের তালিকায় যোগ করা যাচ্ছে না!';
$string['cannotaddnewmodule'] = 'নতুন মডিউল {$a} যোগ করা যাচ্ছে না';
$string['cannotaddrss'] = 'rss ফিড যোগ করার অনুমতি নেই';
$string['cannotaddthisblocktype'] = 'এ পৃষ্ঠায় {$a} ব্লক যোগ করতে পারেনা।';
$string['cannotassignrole'] = 'কোর্সে রোল এসাইন করতে পারে না';
$string['cannotassignrolehere'] = 'এ কনটেক্সট ({$a->context}) এ রোল (id = {$a->roleid}) এসাইন করার জন্য অনুমোদিত নয়';
$string['cannotassignselfasparent'] = 'প্যারেন্ট হিসাবে নিজেেকে এসাইন করা যায়না!';
$string['cannotcallscript'] = 'আপনি এভাবে স্ক্রিপ্ট কল করতে পারেন না';
$string['cannotcallusgetselecteduser'] = 'যদি একাধিক নির্বাচন সত্য হয় তবে আপনি user_selector::get_selected_user কল করতে পারেন না।';
$string['cannotcreatebackupdir'] = 'ব্যাকআপ ডাটা ফোল্ডার তৈরি করা যায়নি। সাইটের প্রসাশনকে ফাইলের অনুমোদন ঠিক করতে হবে';
$string['cannotcreatecategory'] = 'বিভাগ সন্নিবেশ করা হয়নি';
$string['cannotcreategroup'] = 'গ্রুপ তৈরি করার সময় ত্রুটি';
$string['cannotcreatelangbase'] = 'ত্রুটি: বেস lang ডিরেক্টরি তৈরি করতে পারেনা';
$string['cannotcreatelangdir'] = 'lang ডিরেক্টরি তৈরি করতে পারে না';
$string['cannotcreateorfindstructs'] = 'এ কোর্সের জন্য বিভাগের কাঠামো খোঁজ করা বা তৈরি করার সময় ত্রুটি';
$string['cannotcreatepopupwin'] = 'অনির্ধারিত এলিমেন্ট - পপআপ উইন্ডো তৈরি করতে পারেনা';
$string['cannotcreatesitedir'] = 'সাইট ফোল্ডার তৈরি করতে পারেনা। এ সাইটের প্রসাশকের উচিত ফাইলের অনুমোদন ঠিক করা।';
$string['cannotcreatetempdir'] = 'টেম্প ডিরেক্টরি তৈরি করতে পারে না';
$string['cannotcreateuploaddir'] = 'আপলোড ফোল্ডার তৈরি করতে পারে না। এ সাইটের প্রসাশকের উচিত ফাইলের অনুমোদন ঠিক করা।';
$string['cannotcustomisefiltersblockuser'] = 'ব্যবহারকারী বা ব্লক কনটেক্সট এর ক্ষেত্রে আপনি ফিল্টার স্বনির্ধারন করতে পারেন না।';
$string['cannotdeletebackupids'] = 'পূর্ববর্তী ব্যাকআপ আইডি মুছে ফেলা যাচ্ছে না';
$string['cannotdeletecategorycourse'] = 'কোর্স  \'{$a}\' মুছে ফেলতে ব্যর্থ।';
$string['cannotdeletecategoryquestions'] = '\'{$a}\' বিভাগ থেকে প্রশ্ন মুছে ফেলা যায়না';
$string['cannotdeletecourse'] = 'কোর্স মুছে ফেলার অনুমতি আপনার নেই';
$string['cannotdeletecustomfield'] = 'স্বনির্ধারিত ক্ষেত্রের ডাটা মুছে ফেলার সময় ত্রুটি';
$string['cannotdeletedir'] = '({$a}) মুছে ফেলা যায়না';
$string['cannotdeletefile'] = 'এ ফাইল মুছে ফেলা যায়না';
$string['cannotdeleterole'] = 'এটা অপসারন করা যায়না, কারণ {$a}';
$string['cannotdeleterolewithid'] = 'আইডি {$a} এর রোল মুছে ফেলা যায়না';
$string['cannotdeletethisrole'] = 'আপনি এ রোল মুছে ফেলতে পারেন না কারণ এটা সিস্টেমে ব্যবহার করা হয়, অথবা এটা প্রশাসকের ক্ষমতার শেষ রোল।';
$string['cannotdownloadcomponents'] = 'কম্পোনেন্ট ডাউনলোড করা যায় না';
$string['cannotdownloadlanguageupdatelist'] = 'download.moodle.org থেকে ভাষার হালনাগাদের তালিকা ডাউনলোড করা যায় না';
$string['cannotdownloadzipfile'] = 'ZIP ফাইল ডাউনলোড করা যায়না';
$string['cannoteditcomment'] = 'আপনি এ মন্তব্য সম্পাদনা করতে পারেন না!';
$string['cannoteditcommentexpired'] = 'আপনি এটা সম্পাদনা করতে পারেন না। এর সময় শেষ!';
$string['cannoteditpostorblog'] = 'আপনি ব্লগ পোস্ট বা সম্পাদনা করতে পারেন না';
$string['cannoteditsiteform'] = 'এ ফর্ম ব্যবহার করে আপনি সাইট কোর্স সম্পাদনা করতে পারেন না';
$string['cannotedityourprofile'] = 'দুঃখিত, আপনি আপনার প্রোফাইল সম্পাদনা করতে পারেন না';
$string['cannotfindcategory'] = 'আইডি - {$a} ডাটাবেস থেকে বিভাগের রেকর্ড খুঁজে পায়না';
$string['cannotfindcomponent'] = 'কম্পোনেন্ট খুঁজে পাওয়া যায় না';
$string['cannotfindcontext'] = 'কনটেক্সট খুঁজে পায়নি';
$string['cannotfindcourse'] = 'কোর্স খুঁজে পায়নি';
$string['cannotfinddocs'] = '"{$a}" ভাষা ডক ফাইল খুঁজে পায়নি';
$string['cannotfindgradeitem'] = 'grade_item খুঁজে পায়নি';
$string['cannotfindgroup'] = 'গ্রুপ খুঁজে পেতে ব্যর্থ';
$string['cannotfindhelp'] = '"{$a}" ভাষা সহায়তা ফাইল খুঁজে পায়নি';
$string['cannotfindinfo'] = 'যার জন্য তথ্য খুঁজে পায়নি: "{$a}"';
$string['cannotfindlang'] = '"{$a}" ল্যাঙ্গুয়েজ প্যাক খুঁজে পায়নি!';
$string['cannotfindteacher'] = 'শিক্ষক খুঁজে পায়নি';
$string['cannotfinduser'] = '"{$a}" নামক ব্যবহারকারী খুঁজে পায়নি';
$string['cannotgetblock'] = 'ডাটাবেস থেকে ব্লক উদ্ধার করা যায়নি';
$string['cannotgetcats'] = 'বিভাগের রেকর্ড পায়নি';
$string['cannotgetdata'] = 'ডাটা পায়নি';
$string['cannotgradeuser'] = 'ব্যবহারকারীকে গ্রেড দিতে পারেনি';
$string['cannothaveparentcate'] = 'কোর্স বিভাগের প্যারেন্ট নেই!';
$string['cannotimport'] = 'ত্রুটি  ইম্পোর্ট';
$string['cannotimportformat'] = 'দুঃখিত, এ বিন্যাস এখনও বাস্তবায়ন করা হয়নি!';
$string['cannotimportgrade'] = 'গ্রেড ইম্পোর্ট ত্রুটি';
$string['cannotinsertgrade'] = 'কোর্স আইডি ছাড়া গ্রেড সন্নিবেশ করা যায়না!';
$string['cannotinsertrate'] = 'নতুন রেটিং ({$a->id} = {$a->rating}) সন্নিবেশ করা যায়নি';
$string['cannotinsertrecord'] = 'নতুন রেকর্ড আইডি {$a} সন্নিবেশ করা যায়নি';
$string['cannotmailconfirm'] = 'পাসওয়ার্ড পরিবর্তন নিশ্চিতকারী ইমেইল প্রেরণ করতে ত্রুটি';
$string['cannotmanualctrack'] = 'এ কার্যকলাপ ম্যানুয়েল সম্পন্ন করার ট্র্যাকিং সরবরাহ করতে পারেনা';
$string['cannotmapfield'] = 'ম্যাপিং সংঘাত সনাক্তকরণ - দুটি ক্ষেত্র একই গ্রেড আইটেমে {$a} ম্যাপ করে';
$string['cannotmarktopic'] = 'এ কোর্সের জন্য ঐ বিষয় চিহ্নিত করা যায়নি';
$string['cannotmigratedatacomments'] = 'ডাটা মডিউল মন্তব্য স্থানান্তর করা যায়নি';
$string['cannotmodulename'] = 'বিল্ড ন্যাভিগেশনে মডিউলের নাম পাওয়া যায়নি';
$string['cannotmoduletype'] = 'বিল্ড ন্যাভিগেশনে মডিউলের ধরণ পাওয়া যায়নি';
$string['cannotmoverolewithid'] = 'আইডি {$a} এর রোল স্থানান্তর করা যায়নি';
$string['cannotopencsv'] = 'CSV ফাইল খোলা যায়না';
$string['cannotopenfile'] = 'ফাইল ({$a}) খোলা যায়না';
$string['cannotopenforwrit'] = 'যা লেখার জন্য খোলা যায়না: {$a}';
$string['cannotopentemplate'] = 'টেম্পলেট ফাইল ({$a}) খোলা যায়নি';
$string['cannotopenzip'] = 'জিপ ফাইল খোলা যায়নি, খুব সম্ভবত জিপ এক্সটেনশন 64bit os এ বাগ';
$string['cannotoverridebaserole'] = 'বেস রোল ক্ষমতা উপেক্ষা করা যায়না';
$string['cannotoverriderolehere'] = 'কনটেক্সট ({$a->context}) এ রোল (id = {$a->roleid}) উপেক্ষা করার অনুমোদন আপনার নেই';
$string['cannotreadfile'] = 'ফাইল ({$a}) পড়তে পারে না';
$string['cannotreadtmpfile'] = 'অস্থায়ী ফাইল পড়ার সময় ত্রুটি';
$string['cannotreaduploadfile'] = 'আপলোডকৃত ফাইল পড়তে পারেনি';
$string['cannotremovefrommeta'] = 'এ মেটা কোর্স থেকে নির্বাচিত কোর্স অপসারণ করতে পারেনি!';
$string['cannotresetguestpwd'] = 'অতিথি পাসওয়ার্ড পুনরায় নির্ধারন করা যায়নি';
$string['cannotresetmail'] = 'পাসওয়ার্ড এবং আপনাকে মেইল করা পুনরায় নির্ধারন করতে ত্রুটি';
$string['cannotresetthisrole'] = 'এ রোল পুনঃনির্ধারণ করা যায়নি';
$string['cannotrestore'] = 'ত্রুটি ঘটেছে এবং পুনরুদ্ধার সম্পন্ন করা যায়নি!';
$string['cannotrestoreadminorcreator'] = 'নতুন কোর্সে পুনরুদ্ধার করতে আপনাকে নির্মাতা বা প্রসাশনিক ব্যবহাকরী হতে হবে!';
$string['cannotrestoreadminoredit'] = 'নির্বাচিত কোর্সে পুনরুদ্ধার করতে  শিক্ষক বা ব্যবহাকারী সম্পাদনা করতে হবে!';
$string['cannotsaveagreement'] = 'আপনার চুক্তি সংরক্ষণ করা যায়নি';
$string['cannotsaveblock'] = 'ব্লক কনফিগারেশন সংরক্ষন করার সময় ত্রুটি';
$string['cannotsavecomment'] = 'মন্তব্য সংরক্ষণ করতে পারেনা';
$string['cannotsavedata'] = 'ডাটা সংরক্ষণ করতে পারেনা';
$string['cannotsavefile'] = '"{$a}" ফাইল সংরক্ষণ করতে পারেনা!';
$string['cannotsavemd5file'] = 'md5 ফাইল সংরক্ষণ করতে পারেনা';
$string['cannotsavezipfile'] = 'ZIP ফাইল সংরক্ষণ করতে পারেনা';
$string['cannotsetparentforcatoritem'] = 'বিভাগ বা কোর্স আইটেমের জন্য প্যারেন্ট নির্ধারণ করতে পারে না!';
$string['cannotsetpassword'] = 'ব্যবহারকারীর পাসওয়ার্ড নির্ধারণ করতে পারে না!';
$string['cannotsetprefgrade'] = 'এ গ্রেড বিভাগের জন্য এগ্রিগেশনভিউ পছন্দ {$a} নির্ধারণ করা যায়নি';
$string['cannotsettheme'] = 'থীম নির্ধারন করতে পারেনি!';
$string['cannotsetupblock'] = 'ব্লক টেবিল সফলভাবে নির্ধারণ করা যায়নি!';
$string['cannotsetupcapformod'] = '{$a} এর জন্য ক্ষমতা নির্ধারণ করা যায়নি';
$string['cannotsetupcapforplugin'] = '{$a} এর জন্য ক্ষমতা নির্ধারণ করা যায়নি';
$string['cannotshowhidecoursesincategory'] = 'বিভাগ {$a} এ কোর্স প্রদর্শন/আড়াল করা যায়নি।';
$string['cannotunassigncap'] = '{$a->role} রোল থেকে অবলোপকৃত  ক্ষমতা {$a->cap} আনএসাইন করা যায়নি';
$string['cannotunassignrolefrom'] = 'যে রোল আইডি থেকে ব্যবহারকারী আনএসাইন করা যায়না: {$a}';
$string['cannotunzipfile'] = 'ফাইল আনজিপ করতে পারে না';
$string['cannotupdatemod'] = '{$a} হালনাগাদ করতে পারে না';
$string['cannotupdatepasswordonextauth'] = 'যে বাহ্যিক অথে পাসওয়ার্ড হালনাগাদ করতে ব্যর্থ: {$a}। আরও বিস্তারিত তথ্যের জন্য সার্ভার লগ দেখুন।';
$string['cannotupdateprofile'] = 'ব্যবহারকারীর রেকর্ড হালনাগাদ করার সময় ত্রুটি';
$string['cannotupdaterecord'] = 'রেকর্ড আইডি {$a} হালনাগাদ করতে পারেনা';
$string['cannotupdaterss'] = 'RSS হালনাগাদ করতে পারেনা';
$string['cannotupdatesubcourse'] = 'চাইল্ড কোর্স হালনাগাদ করতে পারেনা!';
$string['cannotupdateusermsgpref'] = 'ব্যবহারকারীর বার্তা পছন্দসমূহ হালনাগাদ করতে পারে না';
$string['cannotupdateuseronexauth'] = 'যে বাহ্যিক অথে ব্যবহারকারী ডাটা হালনাগাদ করতে পারেনা: {$a}। আরও বিস্তারিত তথ্যের জন্য সার্ভার লগ দেখুন।';
$string['cannotuploadfile'] = 'ফাইল আপলোড প্রক্রিয়াধীন করতে ত্রুটি';
$string['cannotuseadmin'] = 'এ পৃষ্ঠা ব্যবহার করতে আপনাকে প্রসাশনিক ব্যবহারকারী হতে হবে';
$string['cannotuseadminadminorteacher'] = 'এ পৃষ্ঠা ব্যবহার করতে আপনাকে প্রসাশনিক ব্যবহারকারী হতে হবে';
$string['cannotusepage'] = 'কেবল শিক্ষক এবং প্রসাশক এ পৃষ্ঠা ব্যবহার করতে পারে';
$string['cannotusepage2'] = 'দুঃখিত, আপনি এ পৃষ্ঠা ব্যবহার নাও করতে পারেন';
$string['cannotviewprofile'] = 'আপনি এ ব্যবহারকারীর প্রোফাইল দেখতে পারেন না';
$string['cannotviewreport'] = 'আপনি এ রিপোর্ট দেখতে পারেন না';
$string['cannotwritefile'] = 'ফাইল ({$a}) এ লেখা যায় না';
$string['commentmisconf'] = 'মন্তব্য আইডি কনফিগার করা নেই';
$string['componentisuptodate'] = 'কম্পোনেন্ট হালনাগাদ করা নেই';
$string['confirmsesskeybad'] = 'দুঃখিত, আপনার সেশন কী দিয়ে এ কাজ করা যাবে না। এ নিরাপত্তাজনিত বৈশিষ্ট্য আপনার নামের গুরুত্বপূর্ণ ফাংশনের দুর্ঘটনামূলক বা বাজেভাবে কার্যকর করা থেকে প্রতিরোধ করে। অনুগ্রহ করে নিশ্চিত হোন যে, আপনি এ ফাংশনটি কার্যকর করতে চান।';
$string['couldnotassignrole'] = 'আপনাকে রোল এসাইন করতে চেষ্টা করার সময় একটি মারাত্মক কিন্তু অনির্ধারিত ত্রুটি ঘটে';
$string['couldnotupdatenoexistinguser'] = 'ব্যবহারকারী হালনাগাদ করা যায়না - ব্যবহারকারী নেই';
$string['countriesphpempty'] = 'ত্রুটি: ল্যাঙ্গুয়েজ প্যাকে {$a} ফাইল countries.php ফাঁকা বা অনুপস্থিত।';
$string['coursedoesnotbelongtocategory'] = 'কোর্স এ বিভাগে বিদ্যমান নেই';
$string['coursegroupunknown'] = 'এ গ্রুপ {$a} এর কোর্স নির্দিষ্ট করা নেই';
$string['courseidnotfound'] = 'কোর্স আইডি নেই';
$string['coursemisconf'] = 'কোর্স ঠিকভাবে কনফিগার করা নেই';
$string['courserequestdisabled'] = 'দুঃখিত, প্রশাসক অনুরোধকৃত কোর্স নিস্ক্রিয় করে দিয়েছে';
$string['csvcolumnduplicates'] = 'নকল কলাম সনাক্ত';
$string['csvemptyfile'] = 'CSV ফাইল খালি';
$string['csvfewcolumns'] = 'পর্যাপ্ত কলাম নেই, অনুগ্রহ করে অনুগ্রহ করে ডিলিমিটার সেটিং পরীক্ষা';
$string['csvinvalidcols'] = '<b>অকার্যকর CSV ফাইল:</b>';
$string['csvinvalidcolsnum'] = 'অকার্যকর CSV ফাইল - প্রত্যেক লাইনে অবশ্যই ৪৯ বা ৭০ ক্ষেত্র থাকতে হবে';
$string['csvloaderror'] = 'CSV ফাইল লোড করার সময় ত্রুটি!';
$string['csvweirdcolumns'] = 'অকার্যকর CSV ফাইল বিন্যাস - কলামের সংখ্যা ধ্রুব নয়!';
$string['dbconnectionfailed'] = '<p>ত্রুটি: ডাটাবেস সংযোগ ব্যর্থ</p>
<p>এটাও সম্ভব হতে পারে যে ডাটাবেস ওভারলোডেড বা ঠিকমত কাজ করছে না।</p>
<p>সাইট প্রসাশকের উচিত config.php এ ডাটাবেসের বিস্তারিত তথ্য সঠিকভাবে পরীক্ষা করা</p>';
$string['dbdriverproblem'] = '<p>ত্রুটি: ডাটাবেস ড্রাইভারে সমস্যা সনাক্ত</p>
<p>সাইট প্রশাসকের উচিত সার্ভার কনফিগারেশন পরীক্ষা করা</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'ডাটাবেস সেশনে মারাত্মক সমস্যা সনাক্ত।<br /><br />অনুগ্রহ করে সার্ভার প্রশাসকে জানান।';
$string['dbsessionhandlerproblem'] = 'ডাটাবেস সেশন নির্ধারণ ব্যর্থ।<br /><br />অনুগ্রহ করে সার্ভার প্রশাসকে জানান।';
$string['dbsessionmysqlpacketsize'] = 'মারাত্মক সেশন ত্রুটি সনাক্ত।<br /><br />অনুগ্রহ করে সার্ভার প্রশাসকে জানান, খুব সম্ভবত max_allowed_packet MySQL সেটিং এ ছোট মানের জন্য সমস্যাটি হয়েছে।';
$string['dbupdatefailed'] = 'ডাটাবেস হালনাগাদ ব্যর্থ';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" পরিবর্তন করা যায় না। {$a->offendingtype} "{$a->offendingname}" এ ডিপেন্ডসি পাওয়া গেছে';
$string['ddlexecuteerror'] = 'DDL sql কার্যকর ত্রুটি';
$string['ddlfieldalreadyexists'] = 'ক্ষেত্র "{$a}" ইতোমধ্যে বিদ্যমান';
$string['ddlfieldnotexist'] = 'টেবিল "{$a->tablename}" এ ক্ষেত্র "{$a->fieldname}" বিদ্যমান নেই';
$string['ddltablealreadyexists'] = 'টেবিল "{$a}" ইতোমধ্যে বিদ্যমান';
$string['ddltablenotexist'] = 'টেবিল "{$a}" ইতোমধ্যে বিদ্যমান নেই';
$string['ddlunknownerror'] = 'অজানা DDL লাইব্রেরি ত্রুটি';
$string['ddlxmlfileerror'] = 'XML ডাটাবেস ফাইল ত্রুটি বিদ্যমান';
$string['ddsequenceerror'] = 'ভুল টেবিল "{$a}" বর্ণনা; একটিমাত্র স্বয়ংক্রিয় কলাম রয়েছে এবং যা কী হিসাবে নির্ধারণ করা উচিত।';
$string['destinationcmnotexit'] = 'ডেস্টিনেশন কোর্স মডিউল বিদ্যমান নেই';
$string['detectedbrokenplugin'] = 'প্লাগইন "{$a}" ত্রুটিযুক্ত বা পুরাতন, তাই চালানে যায়না, দুঃখিত।';
$string['dmlreadexception'] = 'ডাটাবেস থেকে পড়তে ত্রুটি';
$string['dmltransactionexception'] = 'ডাটাবেস ট্র্যানজ্যাকশন ত্রুটি';
$string['dmlwriteexception'] = 'ডাটাবেসে লিখতে ত্রুটি';
$string['downgradedcore'] = 'ত্রুটি!!!  আপনি যে কোড ব্যবহার করছেন না তা এ ডাটাবেস যে সংস্করণে তৈরি সেটা থেকে পুরাতন!';
$string['downloadedfilecheckfailed'] = 'ফাইল ডাউনলোড পরীক্ষা ব্যর্থ';
$string['duplicateparaminsql'] = 'ত্রুটি: কোয়েরিতে নকল প্যারামিটার নাম';
$string['duplicaterolename'] = 'ইতোমধ্যে এ নামের রোল আছে!';
$string['duplicateroleshortname'] = 'এই ডাক নামের ইতোমধ্যে একটি রোল আছে!';
$string['duplicateusername'] = 'নকল ব্যবহারকারী - রেকর্ড বাদ দেয়া হচ্ছে';
$string['emailfail'] = 'ইমেইল করতে ব্যর্থ';
$string['error'] = 'ত্রুটি ঘটেছে';
$string['errorcleaningdirectory'] = 'ডিরেক্টরি "{$a}" পরিস্কার করতে ত্রুটি';
$string['errorcopyingfiles'] = 'ফাইল অনুলিপি করতে ত্রুটি';
$string['errorcreatingdirectory'] = '"{$a}" ডিরেক্টরি তৈরি করতে ত্রুটি';
$string['errorcreatingfile'] = 'ফাইল "{$a}" তৈরি করতে ত্রুটি';
$string['errorcreatingrole'] = 'রোল তৈরি করতে ত্রুটি';
$string['errorfetchingrssfeed'] = 'RSS ফিড আনতে ত্রুটি।';
$string['erroronline'] = 'লাইন {$a} এ ত্রুটি';
$string['errorparsingxml'] = 'XML পার্সিং এ ত্রুটি: লাইন {$a->errorline} এ {$a->errorstring}, char {$a->errorchar}';
$string['errorreadingfile'] = 'ফাইল "{$a}" পড়তে ত্রুটি';
$string['errorsavingrequest'] = 'আপনার অনুরোধ সংরক্ষণ করার চেষ্টা করার সময় ত্রুটি।';
$string['errorsettinguserpref'] = 'ব্যবহারকারীর পছন্দ নির্ধারন করতে ত্রুটি';
$string['errorunzippingfiles'] = 'ফাইল আনজিপ করতে ত্রুটি';
$string['expiredkey'] = 'কী এর মেয়াদ শেষ';
$string['externalauthpassworderror'] = 'বাহ্যিক প্রমাণীকরণের জন্য ফাঁকা নয় এমন পাসওয়ার্ড';
$string['failtoloadblocks'] = 'ডাটাবেসে এক বা একাধিক ব্লক নিবন্ধন, কিন্তু সব লোড করতে ব্যর্থ!';
$string['fieldrequired'] = '"{$a}" একটি আবশ্যক ক্ষেত্র';
$string['fileexists'] = 'ফাইল বিদ্যমান';
$string['filemismatch'] = 'নন-কোর ফাইল নাম মিলেনা। ফাইল "{$a->current}" {$a->file} হওয়া উচিত';
$string['filenotfound'] = 'দুঃখিত, অনুরোধকৃত ফাইল পাওয়া যায়নি';
$string['filenotreadable'] = 'ফাইল পড়া যায় না';
$string['filterdoesnothavelocalconfig'] = 'ফিল্টার {$a} স্থানীয় কনফিগারেশন অনুমোদন করে না।';
$string['filternotactive'] = 'ফিল্টার {$a} বর্তমানে সক্রিয় নয়';
$string['filternotenabled'] = 'ফিল্টার সক্রিয় নেই!';
$string['filternotinstalled'] = 'ফিল্টার {$a} বর্তমানে ইনস্টল করা নেই';
$string['forumblockingtoomanyposts'] = 'এ ফোরামের জন্য থ্রেশহোল্ড সেট পোস্ট করা অতিক্রম';
$string['generalexceptionmessage'] = 'এক্সেপশন - {$a}';
$string['gradepubdisable'] = 'গ্রেড প্রকাশ নিস্ক্রিয়';
$string['groupalready'] = 'ব্যবহারকারী ইতোমধ্যে গ্রুপ {$a} এ আছে';
$string['groupexistforcourse'] = 'এ কোর্সের জন্য গ্রুপ "{$a}" বিদ্যমান নেই';
$string['groupnotaddederror'] = 'গ্রুপ "{$a}" যোগ করা হয়নি';
$string['groupunknown'] = 'নির্দিষ্ট কোর্সে গ্রুপ {$a} সম্পৃক্ত নয়';
$string['groupusernotmember'] = 'ব্যবহারকারী এ গ্রুপের সদস্য নয়।';
$string['guestnocomment'] = 'অতিথি কোনো মন্তব্য পোস্ট করতে পারেনা!';
$string['guestnoeditprofile'] = 'অতিথি তাদের প্রোফাইল সম্পাদনা করতে পারে না';
$string['guestnoeditprofileother'] = 'অতিথি ব্যবহারকারীর প্রোফাইল সম্পাদনা করা যায়না';
$string['guestnorate'] = 'অতিথি কোনো এন্ট্রি রেট করার জন্য অনুমোদিত নয়';
$string['guestsarenotallowed'] = 'অতিথি ব্যবহারকারী এটা করার জন্য অনুমোদিত নয়';
$string['hackdetected'] = 'হ্যাক আক্রমণ সনাক্ত!';
$string['hashpoolproblem'] = 'ভুল পুল ফাইল কন্টেন্ট {$a}।';
$string['headersent'] = 'শিরোনাম ইতোমধ্যে প্রেরণ';
$string['idnumbertaken'] = 'আইডি নাম্বার ইতোমধ্যে অন্য কোর্সে ব্যবহৃত';
$string['importformatnotimplement'] = 'দুঃখিত, এ বিন্যাস ইম্পোর্ট করা এখনও কার্যকর হয়নি!';
$string['incorrectext'] = 'ফাইলে একটি ভুল একস্টেনশন আছে';
$string['internalauthpassworderror'] = 'পাসওয়ার্ড অনুপস্থিত বা অভ্যন্তরীণ প্রমাণীকরণের জন্য অকার্যকর পাসওয়ার্ড নীতিমালা';
$string['invalidaccess'] = 'পৃষ্ঠায় সঠিকভাবে প্রবেশ করা হয়নি';
$string['invalidaccessparameter'] = 'প্রবেশাধিকারের অকার্যকর প্যারামিটার';
$string['invalidaction'] = 'কাজের প্যারামিটারঅকার্যকর';
$string['invalidactivityid'] = 'কার্যকরণের অকার্যকর আইডি';
$string['invalidadminsettingname'] = 'অকার্যকর প্রসাশনিক সেটিং ({$a})';
$string['invalidargorconf'] = 'কোনো কার্যকর মতামত দেয়া নেই অথবা ভুল সার্ভার কনফিগারেশন';
$string['invalidarguments'] = 'কোনো কার্যকর মতামত দেয়া নেই';
$string['invalidblockinstance'] = 'যার জন্য অকার্যকর ব্লক নমুনা: {$a}';
$string['invalidcategory'] = 'ভুল বিভাগ!';
$string['invalidcategoryid'] = 'ভুল বিভাগ আইডি!';
$string['invalidcomment'] = 'মন্তব্য ভুল';
$string['invalidconfirmdata'] = 'অকার্যকর নিশ্চিতকরণ ডাটা';
$string['invalidcontext'] = 'অকার্যকর কনটেক্সট';
$string['invalidcourse'] = 'অকার্যকর কোর্স';
$string['invalidcourselevel'] = 'ভুল কনটেক্সট ধাপ';
$string['invalidcoursemodule'] = 'অকার্যকর কোর্স মডিউল আইডি';
$string['invalidcoursenameshort'] = 'অকার্যকর স্বল্প মেয়াদী কোর্সের নাম';
$string['invaliddata'] = 'ডাটা জমা দেয়া অকার্যকর';
$string['invaliddatarootpermissions'] = '$CFG->dataroot ডিরেক্টরিতে অকার্যকর অনুমোদন, প্রশাসককে এর অনুমোদন ঠিক করতে হবে।';
$string['invalidelementid'] = 'ভুল এলিমেন্ট আইডি!';
$string['invalidentry'] = 'এটা কার্যকর এন্ট্রি নয়!';
$string['invalidevent'] = 'অকার্যকর ইভেন্ট';
$string['invalidfieldname'] = '"{$a}" কোনো কার্যকর ক্ষেত্রের নাম নয়';
$string['invalidfiletype'] = '"{$a}" ফাইলের কোনো কার্যকরী ধরণ নয়';
$string['invalidformatpara'] = 'প্যারামিটার নির্বাচন করার ভুল বিন্যাস';
$string['invalidformdata'] = 'ভুল ফর্ম ডাটা';
$string['invalidfunction'] = 'ভুল ফাংশন';
$string['invalidgradeitemid'] = 'ভুল গ্রেড আইটেম আইডি';
$string['invalidgroupid'] = 'ভুল গ্রুপ আইডি নির্ধারিত';
$string['invalidipformat'] = 'IP অ্যাড্রেসএর অকার্যকর বিন্যাস';
$string['invaliditemid'] = 'ভুল আইটেম আইডি';
$string['invalidkey'] = 'ভুল কী';
$string['invalidlegacy'] = 'যে টাইপের জন্য প্রাপ্ত রোলের অর্থ ভুল: {$a}';
$string['invalidmd5'] = 'পরীক্ষন ভেরিয়েবল ভুল ছিল - পুনরায় চেষ্টা';
$string['invalidmode'] = 'অকার্যকর মোড ({$a})';
$string['invalidmodule'] = 'অকার্যকর মডিউল';
$string['invalidmoduleid'] = 'অকার্যকর মডিউল আইডি: {$a}';
$string['invalidmodulename'] = 'অকার্যকর মডিউল নাম: {$a}';
$string['invalidnum'] = 'অকার্যকর সংখ্যাসূচক মান';
$string['invalidnumkey'] = '$conditions অ্যারে এ সংখ্যাসূচক কী নাও থাকতে পারে, অনুগ্রহ করে কোড নির্ধারণ!';
$string['invalidoutcome'] = 'ভুল ফলাফল আইডি';
$string['invalidpagesize'] = 'অকার্যকর পৃষ্ঠার আকার';
$string['invalidpasswordpolicy'] = 'অকার্যকর পাসওয়ার্ড নীতি';
$string['invalidpaymentmethod'] = 'টাকা পরিশোধের অকার্যকর পদ্ধতি: {$a}';
$string['invalidqueryparam'] = 'ত্রুটি: কোয়েরি প্যারামিটারের ভুল নাম্বার। প্রত্যাশিত {$a->expected}, পাওয়া গেছে {$a->actual}।';
$string['invalidrecord'] = 'ডাটাবেস টেবিল {$a} এ ডাটা রেকর্ড পাওয়া যায়নি।';
$string['invalidrecordunknown'] = 'ডাটাবেসে ডাটা রেকর্ড পাওয়া যায়নি';
$string['invalidrequest'] = 'অকার্যকর অনুরোধ';
$string['invalidrole'] = 'অকার্যকর রোল';
$string['invalidroleid'] = 'অকার্যকর রোল আইডি';
$string['invalidscaleid'] = 'ভুল স্কেল আইডি';
$string['invalidsection'] = 'কোর্স মডিউল রেকর্ডে অকার্যকর বিভাগ';
$string['invalidsesskey'] = 'ভুল sesskey জমা, ফর্ম গৃহীত নয়!';
$string['invalidshortname'] = 'সেটা একটা অকার্যকর স্বল্প মেয়াদী কোর্সের নাম';
$string['invalidstatedetected'] = 'কোনো কিছু ভুল হয়েছে: {$a}। এটা সাধারনত কখনই হওয়ার কথা নয়।';
$string['invalidurl'] = 'অকার্যকর URL';
$string['invaliduser'] = 'অকার্যকর ব্যবহারকারী';
$string['invaliduserid'] = 'অকার্যকর ব্যবহারকারীর আইডি';
$string['invalidxmlfile'] = '"{$a}" কোনো কার্যকর XML ফাইল না';
$string['iplookupfailed'] = 'IP অ্যাড্রেস {$a} এর কোনো ভৌগলিক তথ্য খুঁজে পাওয়া যায়নি';
$string['iplookupprivate'] = 'ব্যক্তিগত IP অ্যাড্রেস এর লুকআপ প্রদর্শন করা যায়না';
$string['ipmismatch'] = 'ক্লায়েন্ট IP অ্যাড্রেসে অমিল';
$string['listcantmovedown'] = 'আইটোম নিচে সরাতে ব্যর্থ, যাতে এটা এ ধাপের শেষটা হয়';
$string['listcantmoveleft'] = 'আইটেম বামে সরাতে ব্যর্থ, যেহেতু এর কোনো প্যারেন্ট নেই';
$string['listcantmoveright'] = 'ডানে আইটেম স্থানান্তর করতে ব্যর্থ, যদি কোনো ধাপ তৈরি করা না যায় তবে এটা চাইল্ড।  একে অন্য কোনো ধাপের নিচে স্থানান্তর করে আপনি এটাকে ডানে সরাতে পারবেন।';
$string['listcantmoveup'] = 'আইটেম উপরে সরাতে ব্যর্থ, যেহেতু এটা ধাপের প্রথমেই আছে';
$string['listnochildren'] = 'আইটেমের কোনো চিল্ড্রেন পাওয়া যায়নি';
$string['listnoitem'] = 'আইটেম পাওয়া যায়নি';
$string['listnopeers'] = 'আইটেমের কোনো ধাপ পাওয়া যায়নি';
$string['listupdatefail'] = 'তালিকার স্তরায়ন সম্পাদনা করার সময় DB অপারেশন ব্যর্থ';
$string['logfilenotavailable'] = 'লগ নেই';
$string['loginasnoenrol'] = 'কোর্সের "লগইন" সেশনে তালিকাভুক্ত বা তালিকামুক্ত করতে পারেন না';
$string['loginasonecourse'] = 'আপনি এ কোর্স ব্যবহার করতে পারেন না।<br /> এ কোর্সে প্রবেশ করার আগে আপনাকে "লগইন" সেশন বন্ধ করতে হবে।';
$string['messagingdisable'] = 'এ সাইটে বার্তা প্রেরণ নিস্ক্রিয়';
$string['mimetexisnotexist'] = 'mimeTeX চালানোর জন্য সিস্টেম কনফিগার করা নেই। আপনার প্রয়োজন আপনার জন্য যথাযথ কার্যকরী PHP_OS প্ল্যাটফর্ম <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a> থেকে ডাউনলোড করা, অথবা';
$string['mimetexnotexecutable'] = 'স্বনির্ধারিত মাইমটেক্সট কার্যকরী নয়!';
$string['missingfield'] = 'ক্ষেত্র "{$a}" অনুপস্থিত';
$string['missingkeyinsql'] = 'ত্রুটি: কোয়েরিতে প্যারাম "{$a}" অনুপস্থিত';
$string['missing_moodle_backup_xml_file'] = 'ব্যাকআপ অনুপস্থিত XML ফাইল: {$a}';
$string['missingparam'] = 'আবশ্যক প্যারামিটার ({$a}) অনুপস্থিত';
$string['missingparameter'] = 'প্যারামিটার অনুপস্থিত';
$string['missingrequiredfield'] = 'কিছু আবশ্যক ক্ষেত্র অনুপস্থিত';
$string['missinguseranditemid'] = 'অনুপস্থিত ব্যবহারকারীর আইডি এবং আইটেম আইডি';
$string['missingvarname'] = 'আবশ্যক ভ্যারিয়েবল অনুপস্থিত!';
$string['mixedtypesqlparam'] = 'ত্রুটি: SQL কোয়েরির মিশ্র ধরণের প্যারামিটার!!';
$string['mnetdisable'] = 'MNET নিস্ক্রিয়';
$string['mnetlocal'] = 'রিমোট MNET ব্যবহারকারী স্থানীয়ভাবে লগইন করতে পারেনা';
$string['moduledisable'] = 'এ নির্দিষ্ট কোর্সের জন্য এ মডিউল ({$a}) নিস্ক্রিয় করা হয়েছে';
$string['moduledoesnotexist'] = 'এ মডিউল বিদ্যমান নেই';
$string['moduleinstancedoesnotexist'] = 'মডিউলের এ নমুনা বিদ্যমান নেই';
$string['modulemissingcode'] = 'ফাংশনটি চালানোর মত প্রয়োজনীয় কোড মডিউল {$a} এ নেই';
$string['multiplerecordsfound'] = 'একাধিক রেকর্ড পাওয়া গেছে, কেবল একটি রেকর্ড আশা করা হয়েছিল।';
$string['multiplerestorenotallow'] = 'একাধিক পুনরুদ্ধার কার্যকর করা অনুমোদিত নয়!';
$string['mustbeloggedin'] = 'এটা করতে আপনাকে লগইন করতে হবে';
$string['mustbeteacher'] = 'কেবল শিক্ষক এ পৃষ্ঠা দেখতে পাবে';
$string['myisamproblem'] = 'ডাটাবেস টেবিল MyISAM ডাটাবেস ইঞ্জিন ব্যবহার করছে, InnoDB এর মত সম্পূর্ণ ট্র্যানজ্যাকশন সমর্থনসহ ACID সম্মত ইঞ্জিন ব্যবহারের জন্য সুপারিশ করা হয়।';
$string['needcopy'] = 'আপনাকে আগে কিছু অনুলিপি করতে হবে!';
$string['needcoursecategroyid'] = 'কোর্স আইডি অথবা বিভাগ নির্দিষ্ট করা উচিত';
$string['needphpext'] = 'PHP ইনস্টলেশনে {$a} সমর্থন যোগ করা উচিত';
$string['noadmins'] = 'কোনো প্রসাশন নেই!';
$string['noblocks'] = 'কোনো ব্লক নেই!';
$string['nocapabilitytousethisservice'] = 'এ সার্ভিস ব্যবহার করার আবশ্যক ক্ষমতা ব্যবহারকারীর নেই';
$string['nocategorydelete'] = 'বিভাগ \'{$a}\' মুছে ফেলা যায়না!';
$string['nocontext'] = 'দুঃখিত, কোর্সটি কোনো কার্যকর কনটেক্সট না';
$string['nodata'] = 'কোনো ডাটা না';
$string['noexistingcategory'] = 'বিদ্যমান কোনো বিভাগ নয়';
$string['nofile'] = 'ফাইল নির্দিষ্ট নয়';
$string['nofiltersenabled'] = 'কোনো ফিল্টার সক্রিয় নেই।';
$string['nofolder'] = 'অনুরোধকৃত ডিরেক্টরি নেই';
$string['noformdesc'] = 'এ ডিরেক্টরির জন্য বর্ণনা ফাইল থেকে কোনো ফর্মস্লিব পাওয়া যায়নি।';
$string['noguest'] = 'কোনো অতিথি নেই!';
$string['noinstances'] = 'এ কোর্সে {$a} এর কোনো নমুনা নেই!';
$string['nologinas'] = 'ঐ ব্যবহারকারী হিসাবে আপনার লগইন করা অনুমোদিত নয়';
$string['nonmeaningfulcontent'] = 'কোনো অর্থবোধক কনটেন্ট নেই';
$string['noparticipants'] = 'এ কোর্সের কোনো অংশগ্রহনকারী নেই';
$string['noparticipatorycms'] = 'দুঃখিত, কিন্তু রিপোর্ট করার মত কোনো অংশগ্রহনকৃত কোর্স নেই';
$string['nopermissions'] = 'দুঃখিত, কিন্তু বর্তমানে এটা ({$a}) করার অনুমোদন আপনার নেই';
$string['nopermissiontocomment'] = 'আপনি মন্তব্য করতে পারেন না';
$string['nopermissiontodelentry'] = 'আপনি অন্য ব্যবহারকারীর এন্ট্রি মুছে ফেলতে পারেনা না!';
$string['nopermissiontoeditcomment'] = 'আপনি অন্য ব্যবহারকারীর মন্তব্য সম্পাদনা করতে পারেনা না!';
$string['nopermissiontohide'] = 'আড়াল করার মত কোনো অনুমতি নেই!';
$string['nopermissiontoimportact'] = 'এ কোর্সে কোনো কার্যকরণ যোগ করার আবশ্যক অনুমতি আপনার নেই';
$string['nopermissiontolock'] = 'লক করার অনুমতি নেই!';
$string['nopermissiontomanagegroup'] = 'গ্রুপ ব্যবস্থাপনা করার মত আবশ্যক অনুমতি আপনার নেই';
$string['nopermissiontorate'] = 'আইটেমে রেট করা অনুমোদিত নয়!';
$string['nopermissiontoshow'] = 'এটা দেখা অনুমোদিত নয়!';
$string['nopermissiontounlock'] = 'আনলক করা অনুমোদিত নয়!';
$string['nopermissiontoviewgrades'] = 'গ্রেড দেখতে পারে না।';
$string['nopermissiontoviewletergrade'] = 'অক্ষর গ্রেড দেখার অনুমতি নেই';
$string['nopermissiontoviewpage'] = 'এ পৃষ্ঠা দেখার জন্য আপনি অনুমোদিত নন';
$string['nosite'] = 'শীর্ষ-ধাপের কোনো কোর্স পাওয়া যায়নি!';
$string['nositeid'] = 'কোনো সাইট আইডি নেই';
$string['nostatstodisplay'] = 'দুঃখিত, প্রদর্শন করার মত কোনো ডাটা নেই';
$string['notallowedtoupdateprefremotely'] = 'দূর থেকে ব্যবহারকারীর পছন্দ হালনাগাদ করার অনুমতি নেই';
$string['notavailable'] = 'এটা বর্তমানে নেই';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'আপনি এ কোর্স গ্রুপের সদস্য নয়';
$string['notownerofkey'] = 'এই কী টা আপনার নয়';
$string['nousers'] = 'এমন কোনো ব্যবহারকারী নেই!';
$string['onlyadmins'] = 'কেবল প্রসাশক এটা ব্যবহার করতে পারে';
$string['onlyeditingteachers'] = 'কেবল সম্পাদকীয় শিক্ষক এটা করতে পারে';
$string['onlyeditown'] = 'আপনি কেবল নিজের তথ্য সম্পাদনা করতে পারেন';
$string['orderidnotfound'] = 'ক্রম ID {$a} পাওয়া যায়না';
$string['pagenotexist'] = 'একটি অস্বাভাবিক ত্রুটি ঘটে (পৃষ্ঠায় যাওয়ার চেষ্টা করেন যা এখানে নেই)';
$string['pathdoesnotstartslash'] = 'যদি কার্যকর আর্গুমেন্ট পাওয়া না যায় তবে, পাথ স্ল্যাশ দিয়ে শুরু হয়না!';
$string['pleasereport'] = 'আপনার যদি সময় থাকে, অনুগ্রহ করে আমাদের জানান যে কোনো ত্রুটি ঘটলে আপনি কি করার চেষ্টা করছেন:';
$string['pluginrequirementsnotmet'] = 'প্লাগইন "{$a->pluginname}" ({$a->pluginversion}) ইনস্টল করা যায়নি। এর জন্য মডিউলের নতুন সংস্করণ আবশ্যক (বর্তমানে ব্যবহার করছেন {$a->currentmoodle}, আপনার দরকার {$a->requiremoodle})।';
$string['prefixcannotbeempty'] = '<p>ত্রুটি:ডাটাবেস টেবিল প্রিফিক্স ফাঁকা হতে পারেনা ({$a})</p>
<p>সাইট প্রসাশকের উচিত এটা ঠিক করা।</p>';
$string['prefixtoolong'] = '<p>ত্রুটি: ডাটাবেস টেবিল প্রিফিক্স খুুব বড় ({$a->dbfamily})</p>
<p>. Maximum length for table prefixes in {$a->dbfamily} is {$a->maxlength} characters.</p>';
$string['processingstops'] = 'প্রক্রিয়াকরণ এখানে শেষ। অবশিষ্ট রেকর্ড অবহেলিত।';
$string['redirecterrordetected'] = 'অসমর্থিত রিডিরেক্ট সনাক্ত, স্ক্রিপ্ট কার্যকর বন্ধ';
$string['refoundto'] = '{$a} এ ফেরত দেয়া যায়';
$string['refoundtoorigi'] = 'মূল পরিমানে ফেরত: {$a}';
$string['remotedownloaderror'] = 'আপনার সার্ভারে কম্পোনেন্ট ডাউনলোড ব্যর্থ, অনুগ্রহ করে প্রক্সি সেটিং পরীক্ষা, PHP cURL এক্সটেনশন খুব ভালোভাবে সুপারিশ করা হয়েছে।<br /><br />আপনার উচিত ফাইলটি নিজহাতে <a href="{$a->url}">{$a->url}</a> থেকে ডাউনলোড করে, আপনার সার্ভারে "{$a->dest}" এ এটা অনুলিপি এবং এটা এখানে আনজিপ করুন।';
$string['remotedownloadnotallowed'] = 'আপনার সার্ভারে কম্পোনেন্ট ডাউনলোড করা অনুমোদিত নয় (allow_url_fopen নিস্ক্রিয়)।<br /><br />নিজহাতে ফাইল <a href="{$a->url}">{$a->url}</a> ডাউনলোড করা উচিত, আপনার সার্ভারে "{$a->dest}" এ এটা অনুলিপি এবং এটা এখানে আনজিপ করুন।';
$string['reportnotavailable'] = 'এ কোর্সের জন্য কেবল এ ধরণের রিপোর্ট বিদ্যমান';
$string['requireloginerror'] = 'কোর্স বা কার্যকরণ প্রবেশযোগ্য নয়।';
$string['restorechecksumfailed'] = 'আপনার সেশনে সংরক্ষন করা তথ্য পুনরুদ্ধার করতে সমস্যা। অনুগ্রহ করে আপনার PHP মেমরি/DB প্যাকেজের আকারের সীমা পরীক্ষা। পুনরুদ্ধার বন্ধ।';
$string['restrictedcontextexception'] = 'দুঃখিত, বাহ্যিক ফাংশন কার্যকর করলে কনটেক্সট এর সীমাবদ্ধতা অমান্য করে।';
$string['restricteduser'] = 'দুঃখিত, আপনার বর্তমান অ্যাকাউন্ট "{$a}" এটা করতে দেয়না';
$string['reverseproxyabused'] = 'বিপরীত প্রক্সি সক্রিয়, সার্ভারে সরাসরি প্রবেশ করা যায়না, দুঃখিত।<br />অনুগ্রহ করে সার্ভার প্রশাসকের সাথে যোগাযোগ করুন।';
$string['rpcerror'] = 'অহো! MNET যোগাযোগ ব্যর্থ! এ ত্রুটি বার্তাটি আপনার প্রসাশককে পাঠান: {$a}';
$string['scheduledbackupsdisabled'] = 'সার্ভার প্রসাশন নিয়মিত ব্যকআপ নিস্ক্রিয় করে দিয়েছে';
$string['secretalreadyused'] = 'পাসওয়ার্ড পরিবর্তন নিশ্চিতকরণ লিঙ্ক ইতোমধ্যে ব্যবহৃত, পাসওয়ার্ড পরিবর্তিত হয়নি';
$string['sectionnotexist'] = 'এ বিভাগ নেই';
$string['sendmessage'] = 'বার্তা প্রেরণ';
$string['servicedonotexist'] = 'সার্ভিস নেই';
$string['sessioncookiesdisable'] = 'require_key_login() এর ভুল ব্যবহার - সেশন কুকি নিস্ক্রিয় করা উচিত!';
$string['sessiondiskfull'] = 'এ সেশন পার্টিশন সম্পূর্ণ। এখন লগইন করা সম্ভব নয়।<br /><br />অনুগ্রহ করে সার্ভার প্রশাসককে জানান।';
$string['sessionerroruser'] = 'আপনার সেশনের সময় শেষ। অনুগ্রহ করে পুনরায় লগইন করুন।';
$string['sessionerroruser2'] = 'আপনার লগইন সেশনে প্রভাব ফেলে এমন সার্ভার ত্রুটি সনাক্ত। অনুগ্রহ করে পুনরায় লগইন অথবা আপনার ব্রাউজার পুনরায় চালু করুন।';
$string['sessionipnomatch'] = 'দুঃখিত, কিন্তু আপনি যখন প্রথমবার লগইন করেছেন তা থেকে এখন আপনার IP নাম্বার পরিবর্তিত হয়েছে। এ বৈশিষ্ট্যের জন্য এ সাইটে লগইন করলে ক্র্যাকার আপনার পরিচয় চুরি করতে পারেনা। সাধারণ ব্যবহারকারী এ বার্তা দেখার কথা নয় - অনুগ্রহ করে সাইট প্রসাশকের কাছ থেকে সাহায্য নিন।';
$string['sessionipnomatch2'] = 'দুঃখিত, কিন্তু আপনি যখন প্রথমবার লগইন করেছেন তা থেকে এখন আপনার IP নাম্বার পরিবর্তিত হয়েছে। এ বৈশিষ্ট্যের জন্য এ সাইটে লগইন করলে ক্র্যাকার আপনার পরিচয় চুরি করতে পারেনা। যদি তারবিহীন নেটওয়ার্ক ব্যবহার বা বিভিন্ন নেটওয়ার্কের মধ্যে রোমিং করেন তবে এ ত্রুটি দেখতে পারেন। অনুগ্রহ করে আরও সহায়তার জন্য সাইট প্রসাশককে অনুরোধ করা যায়।<br /><br />অগ্রসর হতে চাইলে অনুগ্রহ করে F5 কী চেপে পৃষ্ঠা রিফ্রেশ।';
$string['shortnametaken'] = 'ডাকনাম ইতোমধ্যে অন্য কোর্সের জন্য ব্যবহৃত';
$string['socksnotsupported'] = 'SOCKS5 প্রক্সি PHP4 এ সমর্থিত নয়';
$string['spellcheckernotconf'] = 'বানান পরীক্ষক কনফিগার করা নেই';
$string['sslonlyaccess'] = 'নিরাপত্তাজনিত কারণে কেবল https সংযোগ অনুমোদিত, দুঃখিত।';
$string['statscatchupmode'] = 'পরিসংখ্যান বর্তমানে ক্যাচআপ মোডে আছে। এখন পর্যন্ত {$a->daysdone} দিন প্রক্রিয়াধীন হয়েছে এবং {$a->dayspending} অবশিষ্ট। দ্রুত পুনরায় পরীক্ষা!';
$string['statsnodata'] = 'ঐ কোর্স এবং সময় সীমার সাথে মিলে এমন কোনো ডাটা নেই';
$string['storedfilecannotcreatefiledirs'] = 'লোক্যাল ফাইল পুল ডিরেক্টরি তৈরি করতে পারে না, অনুগ্রহ করে ডাটারুটে অনুমতি পরীক্ষা।';
$string['storedfilecannotread'] = 'ফাইল পড়া যায় না, হয়তো ফাইল বিদ্যমান নেই বা অনুমতিজনিত সমস্যা';
$string['storedfilenotcreated'] = 'ফাইল "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}/{$a->filepath}/{$a->filename}" তৈরি করতে পারে না';
$string['storedfileproblem'] = 'লোক্যাল ফাইলে ({$a}) অজানা এক্সেপশন সম্পর্কিত';
$string['tagdisabled'] = 'ট্যাগ নিস্ক্রিয়!';
$string['tagnotfound'] = 'ডাটাবেসে নির্ধারিত ট্যাগ পাওয়া যায়নি';
$string['targetdatabasenotempty'] = 'টার্গেট ডাটাবেস ফাঁকা নয়। নিরাপত্তাজনিত কারণে স্থানান্তর বন্ধ।';
$string['themenotinstall'] = 'এ থীম ইনস্টল করা নেই!';
$string['TODO'] = 'TODO';
$string['tokengenerationfailed'] = 'নতুন টোকেন তৈরি করা যায় না।';
$string['transactionvoid'] = 'ট্র্যানজ্যাকশন বাতিল করা যায় না, কারণ এটা ইতোমধ্যে বাতিল';
$string['unenrolerror'] = 'ঐ ব্যক্তিকে তালিকামুক্ত করার চেষ্টা করার সময় ত্রুটি ঘটে';
$string['unicodeupgradeerror'] = 'দুঃখিত, ডাটাবেস ইতোমধ্যে ইউনিকোডে নেই, এবং মুডলের এ সংস্করণ ডাটাবেসকে ইউনিকোডে স্থানান্তর করতে পারেনা। অনুগ্রহ করে প্রথমে মুডল 1.7.x সংস্করণে আপগ্রেড করে প্রসাশন পৃষ্ঠায় গিয়ে ইউনিকোডে স্থানান্তর। এটা করার পর মুডল {$a} এ স্থানান্তর করতে হবে';
$string['unknowaction'] = 'অজানা কাজ!';
$string['unknowcategory'] = 'বিভাগ পরিচিত নয়!';
$string['unknowcontext'] = 'এটা get_child_contexts এ অজানা কনটেক্সট ({$a})!';
$string['unknowformat'] = 'বিন্যাস পরিচিত নয় ({$a})';
$string['unknownbackupexporterror'] = 'ইম্পোর্ট করার তথ্য প্রস্তুতিতে অজানা ত্রুটি';
$string['unknownblockregion'] = 'ব্লক এলাকা \'{$a}\' এ পৃষ্ঠায় সনাক্ত করা যায়না।';
$string['unknowncontext'] = 'এটি অজানা কনটেক্সট।';
$string['unknowncourse'] = '"{$a}" নামক অজানা কোর্স';
$string['unknowncourseidnumber'] = 'অজানা কোর্স আইডি "{$a}"';
$string['unknowncourserequest'] = 'অজানা কোর্সের অনুরোধ';
$string['unknownfiletype'] = 'অজানা ফিল্টারটাইপ ত্রুটি';
$string['unknowngroup'] = 'অজানা গ্রুপ "{$a}"';
$string['unknownhelp'] = 'অজানা সহায়িকা বিষয় {$a}';
$string['unknownjsinrequirejs'] = 'JS লাইব্রেরি খুঁজে পাওয়া যায়নি: {$a}';
$string['unknownmodulename'] = 'অজানা মডিউল নাম';
$string['unknownrole'] = 'অজানা রোল "{$a}"';
$string['unknownsortcolumn'] = 'ক্রমানুসারে সাজানোর অজানা কলাম {$a}';
$string['unknownuseraction'] = 'দুঃখিত, আমি ব্যবহারকারীর এ কাজ বুঝিনি';
$string['unknownuserselector'] = 'অজানা ব্যবহারকারী নির্বাচক';
$string['unknoworder'] = 'অজানা ক্রমায়ন';
$string['unknowparamtype'] = 'অজানা ধরণের প্যারামিটার: {$a}';
$string['unknowquestiontype'] = 'অসমর্থিত ধরণের প্রশ্ন {$a}';
$string['unknowuploadaction'] = 'ত্রুটি: আপলোড সম্পর্কিত অজানা কাজ ({$a})';
$string['unspecifycourseid'] = 'কোর্স আইডি নির্দিষ্ট করা উচিত, ডাকনাম বা আইডিনাম্বার';
$string['unsupportedevent'] = 'অসমর্থিত ধরণের ইভেন্ট';
$string['unsupportedstate'] = 'অসমর্থিত প্রতিযোগিতার অবস্থান';
$string['unsupportedwebserver'] = 'ওয়েব সার্ভার সফ্টওয়্যার ({$a}) সমর্থিত নয়, দুঃখিত।';
$string['upgraderequires19'] = 'ত্রুটি: সার্ভারে নতুন মুডল সংস্করণ ইনস্টল করা হয়েছে, দূর্ভাগ্যবশত পূর্ববর্তী  সংস্করণ আপগ্রেড করা সমর্থিত নয়।<br />অনুগ্রহ করে প্রথমে সর্বশেষ সংস্করণ 1.9.x এ আপগ্রেড। মূল ফাইল পুনরায় ইনস্টল করে আপনি পূর্ববর্তী  সংস্করণে ফেরত যেতে পারেন।';
$string['upgraderunning'] = 'সাইট আপগ্রেড করা হয়েছে, অনুগ্রহ করে পরে পুনরায় চেষ্টা।';
$string['urlnotdefinerss'] = 'RSS ফিডের জন্য URL অনির্ধারিত';
$string['useradmineditadmin'] = 'কেবল প্রসাশকই অন্যান্য প্রশাসকের অ্যাকাউন্ট পরিবর্তন করার জন্য অনুমোদিত';
$string['useradminodelete'] = 'প্রশাসকের অ্যাকাউন্ট মুছে ফেলা যায়না';
$string['userautherror'] = 'অজানা অথ প্লাগইন';
$string['userauthunsupported'] = 'অথ প্লাগইন এখানে সমর্থন করে না';
$string['useremailduplicate'] = 'নকল ঠিকানা';
$string['usermustbemnet'] = 'MNET প্রবেশাধিকার নিয়ন্ত্রন তালিকায় ব্যবহারকারী রিমোট MNET ব্যবহারকারী হওয়া উচিত';
$string['usernotaddederror'] = 'ব্যবহারকারী যোগ করা হয়নি - ত্রুটি';
$string['usernotaddedregistered'] = 'ব্যবহারকারী যোগ করা হয়নি - ইতোমধ্যে নিবন্ধনকৃত';
$string['usernotavailable'] = 'এ ব্যবহারকারীর বিস্তারিত তথ্য আপনার কাছে নেই';
$string['usernotdeletedadmin'] = 'ব্যবহারকারী মুছে ফেলা হয়নি - প্রশাসকের অ্যাকাউন্ট মুছে ফেলা যায়নি';
$string['usernotdeletederror'] = 'ব্যবহারকারী মুছে ফেলা হয়নি - ত্রুটি';
$string['usernotdeletedmissing'] = 'ব্যবহারকারী মুছে ফেলা হয়নি - ব্যবহাকরীর নাম খুঁজে পাওয়া যায়নি';
$string['usernotdeletedoff'] = 'ব্যবহারকারী মুছে ফেলা হয়নি - মুছে ফেলা অনুমোদিত নয়';
$string['usernotincourse'] = 'ব্যবহারকারী এ কোর্সের নয়!';
$string['usernotrenamedadmin'] = 'প্রসাশনের অ্যাকাউন্টের পুনরায় নামকরণ করা যায়নি';
$string['usernotrenamedexists'] = 'ব্যবহারকারীর পুনরায় নামকরণ হয়নি - নতুন ব্যবহারকারীর নাম ইতোমধ্যে ব্যবহৃত';
$string['usernotrenamedmissing'] = 'ব্যবহারকারীর পুনরায় নামকরণ হয়নি - ব্যবহারকারীর পুরাতন নাম খুঁজে পায়নি';
$string['usernotrenamedoff'] = 'ব্যবহারকারীর পুনরায় নামকরণ হয়নি - পুনরায় নামকরণ অনুমোদিত নয়';
$string['usernotupdatedadmin'] = 'প্রসাশকের অ্যাকাউন্ট হালনাগাদ করা যায়নি';
$string['usernotupdatederror'] = 'ব্যবহারকারী হালনাগাদকৃত নয় - ত্রুটি';
$string['usernotupdatednotexists'] = 'ব্যবহারকারী হালনাগাদকৃত নয় - বিদ্যমান নয়';
$string['userquotalimit'] = 'আপনি আপনার ফাইলের কোটার সীমায় পৌছে গেছেন।';
$string['userselectortoomany'] = 'user_selector এ একাধিক নির্বাচিত ব্যবহারকারী রয়েছে, যদিও একাধিক নির্বাচন ভুল।';
$string['wrongcall'] = 'স্ক্রিপ্ট ভুলভাবে কল করা হয়েছে';
$string['wrongcontextid'] = 'কনটেক্সট আইডি ভুল (এটা পাওয়া যায়না)';
$string['wrongdestpath'] = 'ভুল গন্তব্য পাথ';
$string['wrongroleid'] = 'ভুল রোল আইডি!';
$string['wrongsourcebase'] = 'ভুল সোর্স URL বেস';
$string['wrongusernamepassword'] = 'ভুল ব্যবহারকারী/পাসওয়ার্ড';
$string['wrongzipfilename'] = 'ভুল ZIP ফাইল নাম';
$string['wscouldnotcreateecoursenopermission'] = 'WS - কোর্স তৈরি করতে পারেনা - অনুমতি নেই';
$string['wwwrootmismatch'] = 'ভুল প্রবেশাধিকার সনাক্ত, এ সার্ভারে কেবল "{$a}" ঠিকানা থেকে প্রবেশ করা যেতে পারে, দুঃখিত।<br />অনুগ্রহ করে সার্ভার প্রশাসককে জানান।';
$string['wwwrootslash'] = 'config.php এ ভুল $CFG->wwwroot সনাক্ত, এতে ট্রায়ালিং স্ল্যাশ থাকার কথা না।<br />অনুগ্রহ করে সার্ভার প্রশাসককে জানান।';
$string['xmldberror'] = 'XMLDB ত্রুটি!';
$string['youcannotdeletecategory'] = 'বিভাগ \'{$a}\' মুছে ফেলতে পারেন না কারণ আপনি এ কনটেন্ট মুছেও ফেলতে পারেন না বা অন্যকোথাও স্থানান্তরও করতে পারেন না।';
