<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'simplecertificate', language 'fi', branch 'MOODLE_26_STABLE'
 *
 * @package   simplecertificate
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allusers'] = 'Kaikki käyttäjät';
$string['awardedsubject'] = 'Todistus {$a->certificate} myönnettiin opiskelijalle {$a->student}';
$string['awardedto'] = 'Myönnetty';
$string['bulkaction'] = 'Valitse joukkotoiminto';
$string['bulkbuttonlabel'] = 'Lataa/Lähetä';
$string['bulkview'] = 'Joukkotoiminnot';
$string['cantdeleteissue'] = 'Virhe poistettaessa myönnettyjä todistuksia';
$string['cantissue'] = 'Todistusta ei voi myöntää koska käyttäjä ei ole saavuttanut vaadittuja kriteerejä.';
$string['certificatecopy'] = 'Kopioi';
$string['certificateimage'] = 'Todistuksen taustakuva';
$string['certificateimage_help'] = 'Tätä kuvaa käytetään todistuksen taustakuvana, tekstin takana.';
$string['certificatename'] = 'Todistuksen nimi';
$string['certificatename_help'] = 'Todistuksen nimi';
$string['certificatenot'] = 'Todistus-aktiviteettia ei löydy';
$string['certificatetext'] = 'Todistuksen teksti';
$string['certificatetext_help'] = 'Tämä teksti näytetään todistuksessa.

Osa tiedoista tulee kirjoittaa PHP-ohjelmointikielen muuttujina kuten oppilaan nimi, kurssin nimi, arvosana, suorituspäivämäärä jne.

Esimerkiksi voitaisiin kirjoittaa "{USERNAME} on suorittanut kurssin {COURSENAME} arvosanalla {GRADE} päivämäärä: {DATE}" Tämä tulostaisi todistukseen "Erkki Esimerkki on suorittanut kurssin yhteiskuntaoppi1 arvosanalla 80,00 päivämäärä: 18.3.2015" Se minkä aktiviteetin arvosana ja miten se esitetään riippuu muista todistukseen määrittelemistäsi asetuksista.

Todistus hakee muuttujien tiedot käyttäjän Moodle profiilista ja kurssin suoritustiedoista/arvioinneista. Jos näitä tietoja ei ole saatavilla, niitä ei voida esittää myöskään todistuksessa.

Kaikki käytössä olevat muuttujat ovat: <ul> <li>{USERNAME} -> Tulostaa todistukseen todistuksen vastaanottajan etu- ja sukunimen</li> <li>{COURSENAME} -> Tulostaa todistukseen kurssin nimen (tai todistuksen asetuksissa määritellyn vaihtoehtoisen kurssin nimen)</li> <li>{GRADE} -> Tulostaa todistukseen arvosanan</li> <li>{DATE} -> Tulostaa todistukseen päivämäärän.  Kyseisen päivämäärän esitysmuoto määritellään tarkemmin "Myöntämisasetukset" otsikon alla.</li> <li>{OUTCOME} -> Tulostaa todistukseen lopputuloksen</li> <li>{TEACHERS} -> Tulostaa todistukseen listan kurssin opettajista</li> <li>{IDNUMBER} -> Tulostaa todistukseen käyttäjän Moodle ID-numeron</li> <li>{FIRSTNAME} -> Tulostaa todistukseen käyttäjän etunimen</li> <li>{LASTNAME} -> Tulostaa todistukseen käyttäjän sukunimen</li> <li>{EMAIL} -> Tulostaa todistukseen käyttäjän sähköpostiosoitteen</li> <li>{ICQ} -> Tulostaa todistukseen käyttäjän ICQ-numeron</li> <li>{SKYPE} -> Tulostaa todistukseen käyttäjän Skype-tunnuksen</li> <li>{YAHOO} -> Tulostaa todistukseen käyttäjän Yahoo Messenger tunnuksen</li> <li>{AIM} -> Tulostaa todistukseen käyttäjän AIM-tunnuksen</li> <li>{MSN} -> Tulostaa todistukseen käyttäjän MSN-tunnuksen</li> <li>{PHONE1} -> Tulostaa todistukseen käyttäjän 1. puhelinnumeron</li> <li>{PHONE2} -> Tulostaa todistukseen käyttäjän 2. puhelinnumeron</li> <li>{INSTITUTION} -> Tulostaa todistukseen käyttäjän Laitos-tiedon</li> <li>{DEPARTMENT} -> Tulostaa todistukseen käyttäjän osaston</li> <li>{ADDRESS} -> Tulostaa todistukseen käyttäjän osoitteen</li> <li>{CITY} -> Tulostaa todistukseen käyttäjän kaupungin</li> <li>{COUNTRY} -> Tulostaa todistukseen käyttäjän maan</li> <li>{URL} -> Tulostaa todistukseen käyttäjän kotisivun osoitteen</li> <li>{CERTIFICATECODE} -> Tulostaa todistukseen uniikin todistuskooditekstin</li> <li>{USERROLENAME} -> Tulostaa todistukseen käyttäjän roolin kurssilla</li> <li>{TIMESTART} -> Tulostaa todistukseen käyttäjän sen päivämäärän jolloin henkilö liittyi kurssille. Kyseisen päivämäärän esitysmuoto määritellään tarkemmin "Myöntämisasetukset" otsikon alla.</li> <li>{USERIMAGE} -> Tulostaa todistukseen käyttäjän profiilikuvan</li> <li>{USERRESULTS} -> Tulostaa todistukseen käyttäjän arvosanat kurssin aktiviteeteissa</li> <li>{PROFILE_xxxx} -> Tulostaa todistukseen mahdolllisen Moodleenne luodun räätälöidyn käyttäjäprofiilikentän.</li> </ul> Räätälöityjen käyttäjäprofiilikenttien kanssa tulee käyttää kyseisen kentän nimeä ja PROFILE-etuliitettä. Jos teillä on esim. luotu käyttäjien profiilitietoihin syntymäpäiva-kenttä niin tällöin pitäisi käyttää muuttujaa [PROFILE_syntymapaiva] joka esittää kyseisen kentän tiedon todistuksessa.';
$string['certificatetextx'] = 'Todistustekstin vaakatason sijainti';
$string['certificatetexty'] = 'Todistustekstin pystytason sijainti';
$string['certificateverification'] = 'Todistus-aktiviteetin varmennus';
$string['certlifetime'] = 'Säilytä myönnettyjä todistuksia (kuukausia):';
$string['certlifetime_help'] = 'Määrittelee ajan kuinka kauan myönnettyjä todistuksia säilytetään. Tätä määritystä vanhemmat todistukset poistetaan automaattisesti.';
$string['code'] = 'Koodi';
$string['codex'] = 'Todistuksen QR-koodin vaakasijanti';
$string['codey'] = 'Todistuksen QR-koodin pystysijanti';
$string['completedusers'] = 'Käyttäjät, jotka ovat saavuttaneet aktiviteetin suoritusvaatimukset';
$string['completiondate'] = 'Kurssin suorituspäivämäärä';
$string['coursegrade'] = 'Kurssin arvosana';
$string['coursename'] = 'Vaihtoehtoinen kurssin nimi';
$string['coursename_help'] = 'Voit määritellä tähän kurssille vaihtoehtoisen nimen joka tulostuu todistukseen {COURSENAME}-muuttujalla.
<br>
Jos et määrittele vaihtoehtoista nimeä niin silloin käytetään kurssin oikeaa pitkää nimeä.';
$string['coursenotfound'] = 'Kurssia ei löytynyt';
$string['coursetimereq'] = 'Vaadittu kurssillaoloaika minuuteissa.';
$string['coursetimereq_help'] = 'Syötä tähän kurssillaoloaika minuuteissa jonka jälkeen oppilaat voivat saada todistuksen. Myös muut todistuksen vaatimusehdot huomioidaan.';
$string['datefmt'] = 'Päivämäärän muoto';
$string['datefmt_help'] = 'Määrittele missä muodossa päivämärää esitetään todistuksessa (esim. pp.kk.vvvv) Syötteen tulee olla PHP-ohjelmointikielen mukaisessa muodossa, katso ohjeet <a href="http://www.php.net/manual/en/function.strftime.php"> Täältä.</a><br>
Jos jätät kentän tyhjäksi käytetään automaattisesti todistuksen saajan kielivalinnan mukaista päivämääräformaattia kuten suomen kielessä pp.kk.vvvv';
$string['defaultcertificatetextx'] = 'Vaakasuuntaisen tekstin oletussijainti';
$string['defaultcertificatetexty'] = 'Pystysuuntaisen tekstin oletussijainti';
$string['defaultcodex'] = 'QR koodin oletussijainti vaakasuunnassa';
$string['defaultcodey'] = 'QR koodin oletussijainti pystysuunnassa';
$string['defaultheight'] = 'Oletuskorkeus';
$string['defaultperpage'] = 'Per sivu';
$string['defaultperpage_help'] = 'Kuinka monta todistusta näytetään sivulla (max. 200)';
$string['defaultwidth'] = 'Oletusleveys';
$string['deletissuedcertificates'] = 'Poista myönnetyt todistukset';
$string['delivery'] = 'Todistuksen toimitustapa';
$string['delivery_help'] = 'Valitse tästä kuinka haluat opiskelijoiden saavan todistuksensa.

<ul> <li>Avaus selaimessa: Avaa todistuksen uuteen selainikkunaan.</li> <li>Pakota lataus: Pakottaa selaimen lataamaan todistuksen tietokoneelle PDF-tiedostona</li> <li>Lähetä sähköpostitse: Lähettää todistuksen oppilaalle sähköpostin PDF-liitetiedostona</li> </ul>Sen jälkeen kun käyttäjä on jollain edellä mainituista tavoista saanut todistuksensa ja hän avaa todistus-aktiviteetin kurssilla, hän näkee millä päivämäärällä se on myönnetty ja hän voi myös halutessaan tarkastella sitä.';
$string['designoptions'] = 'Muotoiluasetukset';
$string['download'] = 'Pakota lataus';
$string['emailcertificate'] = 'Sähköpostin liitetiedosto';
$string['emailfrom'] = 'Sähköpostin lähettäjäosoite (from)';
$string['emailfrom_help'] = 'Kirjoita tähän se sähköpostiosoite josta haluat viestin näennäisesti lähtevän (näkyy vastaanottajalle lähettäjä-kentässä). Osoitteen ei tarvitse olla oikea sähköpostiosoite, se voi olla esimerkiksi todistus@organisaatio.fi. <br>Jos et määritä vaihtoehtoista sähköpostiosoitetta käytetään Moodlen järjestelmätason asetuksiin määritettyä noreply-osoitetta joka yleensä on noreply@moodlenverkkoosoite.fi';
$string['emailothers'] = 'Muut vastaanottajat';
$string['emailothers_help'] = 'Syötä tähän pilkulla erotettuina niiden muiden kuin kurssialueen opettajien sähköpostiosoitteet, joiden haluat saavan sähköpostia kun opiskelijalle myönnetään todistus.';
$string['emailsent'] = 'Todistus on nyt lähetetty sähköpostitse sinulle.';
$string['emailstudentsubject'] = 'Sinun todistuksesi kurssilla:  {$a->course}';
$string['emailstudenttext'] = 'Hei,

 {$a->username}, liitteenä on todistuksesi kurssilta {$a->course}. Tämä on automaattinen viesti, älä vastaa tähän viestiin.';
$string['emailteachermail'] = '{$a->student} on saanut todistuksen: \'{$a->certificate}\' kurssilla {$a->course}. Voit tarkastella myönnettyä todistusta täältä: {$a->url}';
$string['emailteachermailhtml'] = '{$a->student} on saanut todistuksen: \'<i>{$a->certificate}</i>\' kurssilla {$a->course}. Voit tarkastella myönnettyä todistusta täällä: <a href="{$a->url}">Certificate Report</a>.';
$string['emailteachers'] = 'Lähetä sähköposti-ilmoitus myönnetyistä todistuksista opettajille.';
$string['emailteachers_help'] = 'Jos tämä asetus otetaan käyttöön saavat kurssin kaikki opettajat sähköposti-ilmoituksen kun opiskelijalle myönnetään todistus.';
$string['enablesecondpage'] = 'Käytetäänkö todistuksessa taustapuolta';
$string['enablesecondpage_help'] = 'Tämä asetus lisää todistukseen toisen sivun, joka kaksipuoleisella tulostuksella toimii todistuksen taustapuolena. Jos asetusta ei laiteta päälle, ainoastaan QR-koodi tulostetaan todistuksen toiselle sivulle (jos QR-koodin tulos on päällä todistuksen asetuksissa)';
$string['filenotfound'] = 'Tiedostoa ei löytynyt';
$string['getcertificate'] = 'Lataa todistus';
$string['grade'] = 'Arvosana';
$string['gradefmt'] = 'Todistuksen arvosanan esitysmalli';
$string['gradefmt_help'] = 'Arvosanoja voidaan esittää todistuksessa kolmella eri tapaa.  <ul> <li>Prosentteina: Merkitsee arvosanan todistukseen prosentteina.</li> <li>Pisteinä: Merkitsee arvosanan todistukseen pisteinä.</li> <li>Kirjaimina: Merkitsee arvosanan todistukseen kirjainasteikolla.</li> </ul>';
$string['gradeletter'] = 'Arvosanat kirjaimina';
$string['gradepercent'] = 'Arvosanat prosentteina';
$string['gradepoints'] = 'Arvosanat pisteinä';
$string['height'] = 'Todistuksen korkeus';
$string['hours'] = 'tuntia';
$string['intro'] = 'Kuvaus';
$string['invalidcode'] = 'Väärä todistuskoodi';
$string['issued'] = 'Myönnetty';
$string['issuedcertificatenotfound'] = 'Myönnettyä todistusta ei löytynyt';
$string['issueddate'] = 'Avaamispäivämäärä';
$string['issueddownload'] = 'Myönnetty todistus [id: {$a}] ladattu';
$string['issuedview'] = 'Myönnetyt todistukset';
$string['issueoptions'] = 'Myöntämisasetukset';
$string['keywords'] = 'todistus, kurssi, pdf, moodle';
$string['modulename'] = 'Todistus';
$string['modulename_help'] = 'Todistus-aktiviteetilla voidaan myöntää opiskelijoille todistuksia. Todistuksen asetuksissa voidaan määritellä myöntämisehdot ja räätälöidä todistuksen ulkoasua.';
$string['modulenameplural'] = 'Todistus-aktiviteetit';
$string['multipdf'] = 'Lataa todistukset ZIP-tiedostona';
$string['neverdeleteoption'] = 'Älä poista koskaan';
$string['nocertificatesissued'] = 'Todistuksia ei ole vielä myönnetty';
$string['nodelivering'] = 'Todistuksia ei toimiteta; opiskelijat saavat todistuksensa toisella tapaa.';
$string['onepdf'] = 'Lataa kaikki todistukset yhtenä PDF-tiedostona';
$string['openbrowser'] = 'Avaa uudessa ikkunassa';
$string['opendownload'] = 'Paina alla olevaa painiketta ladataksesi todistuksen tietokoneellesi';
$string['openemail'] = 'Paina alla olevaa painiketta ja todistus lähetetään sinulle sähköpostin liitetiedostona';
$string['openwindow'] = 'Paina alla olevaa painiketta avataksesi todistuksen uuteen ikkunaan';
$string['pluginadministration'] = 'Todistuksen ylläpito';
$string['pluginname'] = 'Todistus-aktiviteetti';
$string['printdate'] = 'Päivämäärä';
$string['printdate_help'] = 'Tämä asetus tulostaa päivämäärän todistukseen.

<ul><li>Avaamispäivämäärä-asetus tulostaa todistukseen sen päivämäärän jolloin oppilas avaa sen ensimmäistä kertaa.</li>
<br>
<li>Kurssinsuorituspäivämäärä tulostaa todistukseen kurssinsuorituspäivän (jos kurssilla on kurssin suoritusehdot määritettyinä.)</li>
<br>
Jos valitset kurssinsuorituspäivämärään mutta oppilas ei ole vielä suorittanut kurssia hyväksytysti ja hän avaa todistuksen, niin silloin hänen todistukseensa tulostuu todistuksen avauspäivämäärä.
<br>
<li>Kun valitset jonkun kurssin aktiviteeteista Arvosana-alasvetovalikkoon, tulostuu todistukseen se päivämäärä jolloin valitsemasi aktiviteetti on arvioitu.</li>
<br>
Jos oppilas avaa todistuksen ennen kuin aktiviteetti on arvioitu, tämä kyseinen avauspäivämäärä tulostetaan todistukseen.
<br>
</ul>';
$string['printgrade'] = 'Arvosana';
$string['printgrade_help'] = 'Voit valita Arvosana-asetukseen kolme vaihtoehtoa
<br>
<ul>
<li>Ei arvointia. Ei tulosta todistukseen mitään arvosanaa.</li>
<li> Kurssin arvosana. Tulostaa todistukseen kurssin lopullisen arvosanan </li>
<li>Tai voit valita minkä tahansa kurssin aktiviteetin arvosanoista. </li>
</ul>
<br>
Muista valita tämän asetuksen alapuolelta miten arvosana esitetään todistuksessa (prosentit, pisteet vai kirjainarvosana)';
$string['printoutcome'] = 'Lopputulos (outcome)';
$string['printoutcome_help'] = 'Voit valita todistukseen tulostettavaksi mikä tahansa oppilaan saaman lopputuloksen (outcome).';
$string['printqrcode'] = 'Tulosta todistuksen QR-koodi';
$string['printqrcode_help'] = 'Jos valitset tämän asetuksen todistukseen tulostetaan QR-koodi';
$string['qrcodefirstpage'] = 'Tulosta QR-koodi ensimmäiselle sivulle';
$string['qrcodefirstpage_help'] = 'Tulostaa QR-koodin todistuksen etusivulle';
$string['qrcodeposition'] = 'QR-koodin sijainti todistuksessa';
$string['qrcodeposition_help'] = 'Nämä ovat X- ja Y-koordinaatit (millimetreissä) joiden perusteella todistuksen QR-koodi sijoittuu sivulle.';
$string['receiveddate'] = 'Myöntämispäivämäärä';
$string['report'] = 'Raportti';
$string['requiredtimenotmet'] = 'Et voi saada todistusta ennen kuin olet ollut kurssilla {$a->requiredtime} minuuttia.';
$string['secondimage'] = 'Todistuksen taustapuolen kuva';
$string['secondimage_help'] = 'Tätä kuvaa käytetään todistuksen taustapuolen kuvana.';
$string['secondpageoptions'] = 'Todistuksen taustapuoli';
$string['secondpagetext'] = 'Todistuksen taustapuolen teksti';
$string['secondpagex'] = 'Todistuksen taustapuolen tekstin vaakasijainti';
$string['secondpagey'] = 'Todistuksen taustapuolen tekstin pystysijainti';
$string['secondtextposition'] = 'Todistuksen taustapuolen tekstin sijainti';
$string['secondtextposition_help'] = 'Nämä ovat X- ja Y-koordinaatit (millimetreissä) joiden perusteella todistuksen taustapuolen tekstit sijoittuvat sivulle.';
$string['sendtoemail'] = 'Lähetä todistukset kaikille käyttäjille sähköpostitse';
$string['showusers'] = 'Näytä';
$string['simplecertificate:addinstance'] = 'Lisää Todistus-aktiviteetti';
$string['simplecertificate:manage'] = 'Muokkaa Todistus-aktiviteetin asetuksia';
$string['simplecertificate:view'] = 'Näytä Todistus-aktiviteetti';
$string['size'] = 'Todistuksen koko (leveys/korkeus)';
$string['size_help'] = 'Näillä arvoilla määritetään todistuksen korkeus ja leveys (millimetreissä) oletuskokona on vaakatasoinen A4.';
$string['standardview'] = 'Esikatsele todistusta';
$string['summaryofattempts'] = 'Yhteenveto aiemmin vastaanotetuista todistuksista';
$string['textposition'] = 'Todistustekstin sijainti';
$string['textposition_help'] = 'Nämä ovat X- ja Y-koordinaatit (millimetreissä) joiden perusteella todistuksen teksti sijoittuu sivulle.';
$string['timestartdatefmt'] = 'Kurssille liittymisen päivämäärä';
$string['timestartdatefmt_help'] = 'Määrittele missä muodossa kurssille liittymisen päivämärää esitetään todistuksessa (esim. pp.kk.vvvv) Syötteen tulee olla PHP-ohjelmointikielen mukaisessa muodossa, katso ohjeet (<a href="http://www.php.net/manual/en/function.strftime.php"> Täältä</a>).<br>
Jos jätät kentän tyhjäksi käytetään automaattisesti todistuksen saajan kielivalinnan mukaista päivämääräformaattia kuten suomen kielessä pp.kk.vvvv';
$string['upgradeerror'] = 'Virhe päivitettäessä $a';
$string['usercontextnotfound'] = 'Käyttäjäkontekstia ei löytynyt';
$string['userdateformat'] = 'Käyttäjän kielivalinnan mukainen päivämääräformaatti (esim. pp.kk.vvvv)';
$string['usernotfound'] = 'Käyttäjää ei löytynyt';
$string['variablesoptions'] = 'Muut asetukset';
$string['verifycertificate'] = 'Vahvista todistus';
$string['viewcertificateviews'] = 'Näytä {$a} myönnetyt todistukset';
$string['width'] = 'Todistuksen leveys';
