<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'fi', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Kurssialueellasi on ajastettuja tehtäviä; katso lisätiedot tästä!';
$string['addattempt'] = 'Anna toinen suorituskerta';
$string['addnewattempt'] = 'Anna uusi suorituskerta';
$string['addnewattemptfromprevious'] = 'Lisää uusi suorituskerta, joka perustuu aiempaan palautukseen';
$string['addnewattemptfromprevious_help'] = 'Tämä kopioi edellisen palautuksesi sisällön uuden palautuksen pohjaksi, jota voit työstää edelleen.';
$string['addnewattempt_help'] = 'Tämä luo palautukselle uuden tyhjän pohjan, jota voit työstää.';
$string['addsubmission'] = 'Lisää palautus';
$string['allocatedmarker'] = 'Nimetty arvioija';
$string['allocatedmarker_help'] = 'Tälle palautukselle nimetty arvioija';
$string['allowsubmissions'] = 'Anna käyttäjän jatkaa palautusten lähettämistä tähän tehtävään.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Tehtävän yksityiskohdat ja palautuslomake tulevat näkyville <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Palautettavissa alkaen';
$string['allowsubmissionsfromdate_help'] = 'Jos tämä asetus on käytössä, opiskelijat eivät voi palauttaa vastauksiaan ennen asettamaasi päivää. Muuten opiskelijat voivat palauttaa vastauksensa samantien.';
$string['allowsubmissionsfromdatesummary'] = 'Tämän tehtävän voi palauttaa aikaisintaan <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Salli palautuksen muokkaaminen';
$string['alwaysshowdescription'] = 'Näytä aina tehtäväkuvaus';
$string['alwaysshowdescription_help'] = 'Jos tämä asetus on *pois* käytöstä, yllä oleva tehtävän kuvaus näkyy opiskelijoille vasta samalla kun vastausten palautus on mahdollista.';
$string['applytoteam'] = 'Anna sama arvosana ja palaute koko ryhmälle';
$string['assign:addinstance'] = 'Lisää uusi tehtävä';
$string['assign:exportownsubmission'] = 'Vie oma palautus';
$string['assignfeedback'] = 'Palaute-lisäosa';
$string['assignfeedbackpluginname'] = 'Palaute-lisäosa';
$string['assign:grade'] = 'Tehtävän arviointi';
$string['assign:grantextension'] = 'Anna lisäaikaa';
$string['assign:manageallocations'] = 'Muokkaa palautuksille nimettyjä arvioijia';
$string['assign:managegrades'] = 'Esikatsele ja julkaise arvosanat';
$string['assignmentisdue'] = 'Palautusaika on päättynyt';
$string['assignmentmail'] = '{$a->grader} on arvioinut palauttamasi tehtävän
\'{$a->assignment}\'

Näet annetun arvioinnin tehtäväsivulla

    {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} on arvioinut palauttamasi tehtävän  \'<i>{$a->assignment}</i>\'</p>

<p>Näet annetun arvioinnin <a href="{$a->url}">tehtäväsivun</a> alareunassa.</p>';
$string['assignmentmailsmall'] = '{$a->grader} on arvioinut palauttamasi tehtävän  \'{$a->assignment}\'. Näet annetun arvioinnin tehtäväsivun alareunassa.';
$string['assignmentname'] = 'Tehtävän nimi';
$string['assignmentplugins'] = 'Tehtävä-lisäosat';
$string['assignmentsperpage'] = 'Näytettävien tehtävien määrä sivulla';
$string['assign:releasegrades'] = 'Julkaise arvioinnit opiskelijoille';
$string['assign:revealidentities'] = 'Paljasta opiskelijoiden nimet';
$string['assign:reviewgrades'] = 'Esikatsele arvosanoja';
$string['assignsubmission'] = 'Tehtäväpalautus-lisäosa';
$string['assignsubmissionpluginname'] = 'Tehtäväpalautus-lisäosa';
$string['assign:submit'] = 'Tehtävän palautus';
$string['assign:view'] = 'Tehtävän tarkastelu';
$string['attemptheading'] = 'Suorituskerta {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Edelliset suorituskerrat';
$string['attemptnumber'] = 'Suorituskerran numero';
$string['attemptreopenmethod'] = 'Milloin palautukset avataan opiskelijoiden muokattaviksi';
$string['attemptreopenmethod_help'] = 'Määrittelee, milloin ja miten opiskelijoiden palautukset avataan takaisin opiskelijoiden muokattaviksi. Vaihtoehdot ovat
<ul>
<li>Ei koskaan - opiskelijan palautusta ei voi avata muokattavaksi</li>
<li>Opettaja - opettaja voi halutessaan avata opiskelijan palautuksen muokattavaksi</li>
<li>Automaattisesti kunnes läpäisee - opiskelijan palautus avautuu automaattisesti muokattavaksi niin monta kertaa, että opiskelija saa arviointikirjassa määritellyn, hyväksytyn arvosanarajan tälle tehtävälle</li>
</ul>';
$string['attemptreopenmethod_manual'] = 'Opettaja';
$string['attemptreopenmethod_none'] = 'Ei koskaan';
$string['attemptreopenmethod_untilpass'] = 'Automaattisesti kunnes läpäisee';
$string['attemptsettings'] = 'Suorituskertojen asetukset';
$string['availability'] = 'Saatavuus';
$string['backtoassignment'] = 'Takaisin tehtävään';
$string['batchoperationconfirmaddattempt'] = 'Sallitaanko valituille palautuksille lisäsuorituskerta?';
$string['batchoperationconfirmgrantextension'] = 'Annatko lisäaikaa kaikille valituille opiskellijoille?';
$string['batchoperationconfirmlock'] = 'Lukitaanko kaikki valitut palautukset?';
$string['batchoperationconfirmreverttodraft'] = 'Muutetaanko valitut palautukset keskeneräisiksi?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Muutetaanko arvioija kaikille valituille palautuksille?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Muutetaanko arviointiprosessin vaihe kaikille valituille palautuksille?';
$string['batchoperationconfirmunlock'] = 'Avaa lukitus kaikilta valituilta palautuksilta';
$string['batchoperationlock'] = 'lukitse palautukset';
$string['batchoperationreverttodraft'] = 'muuta palautukset keskeneräisiksi';
$string['batchoperationsdescription'] = 'Valituille...';
$string['batchoperationunlock'] = 'avaa palautukset muokattaviksi';
$string['batchsetallocatedmarker'] = 'Muuta arvioija {$a} valitulle opiskelijalle.';
$string['batchsetmarkingworkflowstateforusers'] = 'Muuta arviointiprosessin vaihe {$a} valitulle opiskelijalle.';
$string['blindmarking'] = 'Piilota opiskelijoiden nimet';
$string['blindmarking_help'] = 'Opiskelijoiden nimien piilotus  piilottaa opiskelijatiedot arvioijilta. Huomaa, että piilotus aktivoituu paitsi ko. tehtävässä myös arviointikirjassa. Asetus lukittuu kun tehtävään on tehty palautus tai annettu arvosana.

Huomaa, että nimet on erikseen paljastettava arvioinnin jälkeen, jotta opiskelijoiden arvosanat näkyvät arviointikirjassa.';
$string['changegradewarning'] = 'Tehtävässä on arvioituja palautuksia. Tehtävän arviointiasteikon muuttaminen ei automaattisesti skaalaa annettuja arvosanoja uudelle asteikolle. Arvioi siis kaikki jo arvioidut tehtävät uudelleen, jos haluat vaihtaa tehtävän arviointiasteikkoa.';
$string['choosegradingaction'] = 'Arviointitoimenpide';
$string['choosemarker'] = 'Valitse...';
$string['chooseoperation'] = 'Valitse toimenpide';
$string['comment'] = 'Kommentoi';
$string['completionsubmit'] = 'Opiskelijan on palautettava tehtävä saadakseen suoritusmerkinnän';
$string['configshowrecentsubmissions'] = 'Kaikki näkevät palautustapahtumat viimeisimpien tapahtumien listalla';
$string['confirmbatchgradingoperation'] = 'Oletko varma, että haluat tehdä toiminnon  {$a->operation} {$a->count} opiskelijalle?';
$string['confirmsubmission'] = 'Oletko varma, että haluat palauttaa työsi arvioitavaksi? Sen jälkeen et voi enää tehdä muutoksia.';
$string['conversionexception'] = 'Tehtävää ei pystytty konvertoimaan. Virhe oli: {$a}.';
$string['couldnotconvertgrade'] = 'Tehtäväpalautuksen arvosanaa ei pystytty konvertoimaan käyttäjälle {$a}.';
$string['couldnotconvertsubmission'] = 'Tehtäväpalautusta ei pystytty konvertoimaan käyttäjälle {$a}.';
$string['couldnotcreatecoursemodule'] = 'Kurssimoduulia ei voitu luoda.';
$string['couldnotcreatenewassignmentinstance'] = 'Tehtävän lisääminen ei onnistunut.';
$string['couldnotfindassignmenttoupgrade'] = 'Vanhaa tehtäväinstanssia ei löytynyt päivitystä varten';
$string['currentattempt'] = 'Tämä on suorituskerta {$a}';
$string['currentattemptof'] = 'Tämä on suorituskerta {$a->attemptnumber} (suorituskertoja sallitaan enintään {$a->maxattempts}).';
$string['currentgrade'] = 'Nykyinen arvosana';
$string['cutoffdate'] = 'Ehdoton takaraja palautukselle';
$string['cutoffdatefromdatevalidation'] = 'Palautuksen ehdottoman takarajan on oltava tehtävän palautusajan alkamisen jälkeen.';
$string['cutoffdate_help'] = 'Jos asetus on käytössä, tehtävää ei voi palauttaa tämän päivän jälkeen ilman annettua lisäaikaa.';
$string['cutoffdatevalidation'] = 'Palautuksen ehdoton takaraja ei voi olla ennen tehtävän palautusajan päättymistä.';
$string['defaultsettings'] = 'Tehtävän oletusasetukset';
$string['defaultsettings_help'] = 'Nämä asetukset määrittelevät oletusarvot kaikille uusille tehtäville.';
$string['defaultteam'] = 'Oletusryhmä';
$string['deleteallsubmissions'] = 'Poista kaikki palautetut tehtävät';
$string['description'] = 'Kuvaus';
$string['downloadall'] = 'Lataa kaikki palautukset zip-tiedostona';
$string['duedate'] = 'Palautettava viimeistään';
$string['duedate_help'] = 'Tämä tarkoittaa palautusajan päättymistä. Tämän jälkeenkin saa palauttaa, mutta kaikki tämän ajan jälkeen palautetut vastaukset merkitään myöhästyneiksi. Jos haluat estää palautukset tietyn ajan jälkeen, käytä palautusten ehdotonta takarajaa.';
$string['duedateno'] = 'Ei palautusten päättymisaikaa';
$string['duedatereached'] = 'Tehtävän palautusten päättymisaika on mennyt';
$string['duedatevalidation'] = 'Palautusten päättymisajan on oltava myöhempi kuin palautusten alkamisaika.';
$string['editaction'] = 'Toiminnot...';
$string['editattemptfeedback'] = 'Muokkaa suorituskerran {$a} arvosanaa ja palautetta.';
$string['editingpreviousfeedbackwarning'] = 'Olet muokkaamassa aiemman suorituskerran palautetta. Tämä on suorituskerta {$a->attemptnumber} kaikkiaan {$a->totalattempts} suorituskerrasta.';
$string['editingstatus'] = 'Muokataan tilaa';
$string['editsubmission'] = 'Muokkaa palautusta';
$string['editsubmission_help'] = 'Muokkaa palautustasi';
$string['enabled'] = 'Käytössä';
$string['errornosubmissions'] = 'Ladattavia palautuksia ei ole';
$string['errorquickgradingvsadvancedgrading'] = 'Arvosanat eivät tallentuneet, koska tämä tehtävä käyttää edistynyttä arviointia';
$string['errorrecordmodified'] = 'Arvosanat eivät tallentuneet, koska joku toinen henkilö on muokannut yhtä tai useampaa arviointikenttää sen jälkeen, kun avasit tämän sivun.';
$string['event_all_submissions_downloaded'] = 'Kaikki palautukset ladatataan';
$string['event_assessable_submitted'] = 'Palautus on lähetetty';
$string['event_extension_granted'] = 'Laajennus on vahvistettu.';
$string['event_identities_revealed'] = 'Identiteetit on paljastettu.';
$string['event_marker_updated'] = 'Työlle nimetty arvioija on päivitetty';
$string['event_statement_accepted'] = 'Käyttäjä on hyväksynyt palautukseen liittyvän vakuutuksen oman työn osuudesta.';
$string['event_submission_duplicated'] = 'Käyttäjä monisti palautuksensa.';
$string['event_submission_graded'] = 'Palautus on arvioitu.';
$string['event_submission_locked'] = 'Palautukset on lukittu käyttäjältä';
$string['event_submission_status_updated'] = 'Palautuksen tila on päivitetty';
$string['event_submission_unlocked'] = 'Palautusten lukitus poistettu käyttäjältä';
$string['event_submission_updated'] = 'Käyttäjä on tallentanut palautuksensa';
$string['event_workflow_state_updated'] = 'Prosessin tila on päivitetty';
$string['extensionduedate'] = 'Lisäajan päättymisaika';
$string['extensionnotafterduedate'] = 'Lisäajan päättymisajan on oltava varsinaisen palautusajan jälkeen';
$string['extensionnotafterfromdate'] = 'Lisäajan päättymisajan on oltava palautusajan alkamisen jälkeen';
$string['feedback'] = 'Palaute';
$string['feedbackavailablehtml'] = '{$a->username} on antanut sinulle palautetta tehtävään {$a->assignment}.
<br/><br/>
Voit lukea palautteen täältä:

<a href="{$a->url}">Tehtävän palautus</a>.';
$string['feedbackavailablesmall'] = '{$a->username} on arvioinut tehtävän {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} on antanut sinulle palautetta tehtävään {$a->assignment}.

Voit lukea palautteen täältä:

{$a->url}';
$string['feedbackplugin'] = 'Palaute-lisäosa';
$string['feedbackpluginforgradebook'] = 'Palaute-lisäosa, joka syöttää kommentteja arviointikirjaan';
$string['feedbackpluginforgradebook_help'] = 'Vain yksi tehtävän palaute-lisäosista (kerrallaan) voi syöttää palautteita arviointikirjaan.';
$string['feedbackplugins'] = 'Palaute-lisäosat';
$string['feedbacksettings'] = 'Palauteasetukset';
$string['feedbacktypes'] = 'Palautemuodot';
$string['filesubmissions'] = 'Tiedostopalautukset';
$string['filter'] = 'Näytä';
$string['filternone'] = 'Kaikki';
$string['filterrequiregrading'] = 'Odottaa arviointia';
$string['filtersubmitted'] = 'Palautettu';
$string['gradeabovemaximum'] = 'Arvosanan tulee olla pienempi tai yhtä suuri kuin {$a}.';
$string['gradebelowzero'] = 'Arvosanan tulee olla suurempi tai yhtä suuri kuin nolla.';
$string['gradecanbechanged'] = 'Arviointi on muutettavissa';
$string['graded'] = 'Arvioitu';
$string['gradedby'] = 'Arvioija';
$string['gradedon'] = 'Arviointipäivä';
$string['gradelocked'] = 'Tämä arvosana on lukittu tai ylitetty arviointikirjassa';
$string['gradeoutof'] = 'Arvosana (0 - {$a})';
$string['gradeoutofhelp'] = 'Arvosana';
$string['gradeoutofhelp_help'] = 'Kirjoita opiskelijan vastauksen arvosana tähän. Voit käyttää desimaaleja.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} on palauttanut tehtävän \'{$a->assignment}\'.</i><br /><br />
Pääset tehtävään Moodlesta, <a href="{$a->url}">tästä linkistä</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} on palauttanut tehtävän {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} on palauttanut tehtävän {$a->assignment}.

Pääset tehtävään Moodlesta alla olevan linkin kautta.
{$a->url}';
$string['gradestudent'] = 'Arvioi opiskelija: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Arvioi {$a}';
$string['grading'] = 'Arviointi';
$string['gradingchangessaved'] = 'Arvosanojen muutokset on tallennettu';
$string['gradingmethodpreview'] = 'Arviointikriteeri';
$string['gradingoptions'] = 'Valinnaiset asetukset';
$string['gradingstatus'] = 'Arvioinnin tila';
$string['gradingstudent'] = 'Arvioidaan opiskelijaa';
$string['gradingsummary'] = 'Arvioinnin yhteenveto';
$string['grantextension'] = 'Anna lisäaikaa';
$string['grantextensionforusers'] = 'Anna lisäaikaa {$a} opiskelijalle';
$string['groupsubmissionsettings'] = 'Ryhmäpalautuksen asetukset';
$string['hiddenuser'] = 'Opiskelija';
$string['hideshow'] = 'Piilota/Näytä';
$string['instructionfiles'] = 'Ohjeistustiedostot';
$string['invalidfloatforgrade'] = 'Annettua arvosanaa ei pystytä tulkitsemaan: {$a}';
$string['invalidgradeforscale'] = 'Annettu arvosana on virheellinen nykyiselle asteikolle';
$string['lastmodifiedgrade'] = 'Viimeksi muutettu (Arviointi)';
$string['lastmodifiedsubmission'] = 'Viimeksi muutettu (Palautus)';
$string['latesubmissions'] = 'Myöhässä tulleet palautukset';
$string['latesubmissionsaccepted'] = 'Vain opiskelijat, joille on annettu lisäaikaa, voivat enää palauttaa vastauksensa.';
$string['locksubmissionforstudent'] = 'Estä uudet palautukset opiskelijalta: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Lukitse palautukset';
$string['manageassignfeedbackplugins'] = 'Hallinnoi tehtävän palaute-lisäosia';
$string['manageassignsubmissionplugins'] = 'Hallinnoi tehtävän palautus-lisäosia';
$string['marker'] = 'Arvioija';
$string['markerfilter'] = 'Arvioija-suodatin';
$string['markingallocation'] = 'Nimeä arvioijat';
$string['markingallocation_help'] = 'Kun arvioijien nimeäminen on käytössä yhdessä vaiheistetun arviointiprosessin kanssa, voit nimetä arvioijat kunkin opiskelijan palautuksille.';
$string['markingworkflow'] = 'Vaiheista arviointiprosessi';
$string['markingworkflow_help'] = 'Kun vaiheistettu arviointiprosessi on käytössä, voit hyödyntää arvioinnissa välivaiheita ja lopulta halutessasi julkaista kaikki tai valitsemasi arvioinnit opiskelijoille yhtäaikaa.';
$string['markingworkflowstate'] = 'Arviointiprosessin vaihe';
$string['markingworkflowstate_help'] = 'Arviointiprosessin välivaiheita voivat olla:

* Ei arvioitu - arvioija ei ole aloittanutkaan
* Arvioinnissa - arvioija on aloittanut, mutta ei ole valmis
* Arviointi tehty - arviointi on valmis vastuuopettajan tarkistusta varten
* Tarkastuskierroksella - vastuuopettaja on tekemässä tarkastusta laadunvarmistukseksi
* Valmis julkaistavaksi - vastuuopettaja on kuitannut arvioinnin tarkastuksen, mutta arviointeja ei ole vielä avattu opiskelijoille
* Julkaistu - opiskelija saa nähdä arvoinnin ja palautteen';
$string['markingworkflowstateinmarking'] = 'Arvioinnissa';
$string['markingworkflowstateinreview'] = 'Tarkastuskierroksella';
$string['markingworkflowstatenotmarked'] = 'Ei arvioitu';
$string['markingworkflowstatereadyforrelease'] = 'Valmis julkaistavaksi';
$string['markingworkflowstatereadyforreview'] = 'Arviointi tehty';
$string['markingworkflowstatereleased'] = 'Julkaistu';
$string['maxattempts'] = 'Suorituskertojen enimmäismäärä';
$string['maxattempts_help'] = 'Opiskelijan tekemien palautuskierrosten enimmäismäärä. Tämän toistomäärän jälkeen palautusmahdollisuus ei enää avaudu automaattisesti uudelleen.';
$string['maxgrade'] = 'Korkein arvosana';
$string['messageprovider:assign_notification'] = 'Tehtävien suorittamiseen liittyvät ilmoitukset';
$string['modulename'] = 'Tehtävä';
$string['modulename_help'] = 'Tehtävä-aktiviteetilla opettaja voi antaa tehtäviä, kerätä vastaukset sekä arvioida ne sanallisesti ja arvosana-asteikolla. <strong>Huomaa, että vain kurssialueen opettajat ja työn palauttaneet opiskelijat itse saavat nähdä palautetut vastaukset</strong>.

Opiskelijat voivat palauttaa tiedostokoon rajoissa mitä vain tiedostoja, kuten tekstinkäsittely- tai taulukkolaskentaohjelmalla tuotettuja dokumentteja, kuvia, ääni- ja videotiedostoja. Vaihtoehtoisesti tai lisäksi tehtävän voi palauttaa kirjoittamalla tekstiä Moodlessa tekstieditorilla. Voit hyödyntää tehtävä-aktiviteettia myös pelkkänä tehtävänantona oppimistehtävään, joka toteutetaan Moodlen ulkopuolella. Tällöinkin voit edelleen arvioida opiskelijoiden suoritukset, vaikka he eivät palautakaan Moodleen mitään. Palautetut työt voivat olla yksilö- tai ryhmätöitä.

Arviointi voi muodostua sanallisesta palautteesta, arvosanasta ja yhdestä tai useammasta palautetiedostosta, esimerkiksi opiskelijan työn kommenttien kera tai äänitetyn palautteen. Tehtävän arvosanaan voit käyttää numeerista tai sanallista asteikkoa, jollaisen voit tehdä myös itse. Vaihtoehtoisesti voit antaa arvionnin arviointimatriisin tai arviointiohjeistuksen avulla. Tällöin voit julkaista arviointikriteerit myös opiskelijoille jo tehtävän tekemisen ajaksi.

Tehtävän lopulliset arvosanat näkyvät myös arviointikirjassa.';
$string['modulenameplural'] = 'Tehtävät';
$string['moreusers'] = '{$a} lisää';
$string['mysubmission'] = 'Oma palautukseni:';
$string['newsubmissions'] = 'Palautetut tehtävät';
$string['noattempt'] = 'Ei suorituskertoja';
$string['nofiles'] = 'Ei tiedostoja.';
$string['nograde'] = 'Ei arvosanaa';
$string['nolatesubmissions'] = 'Myöhässä ei voi palauttaa.';
$string['nomoresubmissionsaccepted'] = 'Myöhässä ei voi palauttaa.';
$string['noonlinesubmissions'] = 'Tähän tehtävään ei vastata Moodlessa';
$string['nosavebutnext'] = 'Seuraava';
$string['nosubmission'] = 'Tähän tehtävään ei ole vielä vastattu';
$string['nosubmissionsacceptedafter'] = 'Vastauksia ei voi palauttaa tämän jälkeen';
$string['notgraded'] = 'Ei arvioitu';
$string['notgradedyet'] = 'Ei vielä arvioitu';
$string['notifications'] = 'Ilmoitukset';
$string['notsubmittedyet'] = 'Ei vielä palautettu';
$string['nousersselected'] = 'Yhtään käyttäjää ei ollut valittuna';
$string['numberofdraftsubmissions'] = 'Keskeneräiset';
$string['numberofparticipants'] = 'Opiskelijoita';
$string['numberofsubmissionsneedgrading'] = 'Odottaa arviointia';
$string['numberofsubmittedassignments'] = 'Palautuksia';
$string['numberofteams'] = 'Ryhmät';
$string['offline'] = 'Ei verkon kautta tehtävää palautusta';
$string['open'] = 'Avoinna';
$string['outlinegrade'] = 'Arvosana: {$a}';
$string['outof'] = '{$a->current} enimmäismäärästä {$a->total}';
$string['overdue'] = '<font color="red">Tehtävän viimeinen palautusaika oli {$a} sitten</font>';
$string['page-mod-assign-view'] = 'Tehtävämoduulin pääsivu';
$string['page-mod-assign-x'] = 'Mikä tahansa tehtävämoduulin sivu';
$string['participant'] = 'Opiskelija';
$string['pluginadministration'] = 'Tehtävän hallinnointi';
$string['pluginname'] = 'Tehtävä';
$string['preventsubmissions'] = 'Estä opiskelijaa tekemästä uusia palautuksia tähän tehtävään';
$string['preventsubmissionsshort'] = 'Estä palautusten muokkaaminen';
$string['previous'] = 'Edellinen';
$string['quickgrading'] = 'Nopea arviointi';
$string['quickgradingchangessaved'] = 'Muutokset arvosanoihin tallennettu';
$string['quickgrading_help'] = 'Nopealla arvioinnilla voit antaa palautteet ja arvosanat suoraan opiskelijalistassa sen sijaan, että avaat kunkin opiskelijan henkilökohtaisen palautenäkymän. Nopeaa arviointia ei voi käyttää edistyneen arvionnin eli esimerkiksi arviointimatriisin kanssa, eikä sitä suositella käytettäväksi, jos arvosana muodostuu osista.';
$string['quickgradingresult'] = 'Nopea arviointi';
$string['recordid'] = 'Tunniste';
$string['requireallteammemberssubmit'] = 'Kaikkien ryhmäläisten on palautettava';
$string['requireallteammemberssubmit_help'] = 'Jos asetus on käytössä, kaikkien ryhmän jäsenten on klikattava tehtävän palautuspainiketta, jotta tehtävä katsotaan palautetuksi. HUOMAA, että tämä asetus aktivoituu valittavaksi vasta, kun olet ottanut Lähetä arvioitavaksi -painikkeen käyttöön!

Jos asetus ei ole käytössä, ryhmän palautus katsotaan palautetuksi heti, kun kuka tahansa ryhmän jäsenistä klikkaa tehtävän palautuspainiketta.';
$string['requiresubmissionstatement'] = 'Vaadi, että opiskelijat hyväksyvät vakuutuksen oman työn osuudesta';
$string['requiresubmissionstatement_help'] = 'Vaadi, että opiskelijat hyväksyvät vakuutuksen oman työn osuudesta kaikissa tämän tehtävän palautuksissa.';
$string['revealidentities'] = 'Paljasta opiskelijoiden nimet';
$string['revealidentitiesconfirm'] = 'Oletko varma, että haluat paljastaa opiskelijoiden nimet tässä tehtävässä? Toimenpidettä ei voi peruuttaa.

Kun opiskelijoiden nimet on paljastettu, arvosanat näkyvät arviointikirjassa.';
$string['reverttodraft'] = 'Muuta palautuksen tila keskeneräiseksi.';
$string['reverttodraftforstudent'] = 'Muuta palautukset keskeneräisiksi opiskelijalta:  (id={$a->id}, nimi={$a->fullname}).';
$string['reverttodraftshort'] = 'Muuta palautus keskeneräiseksi';
$string['reviewed'] = 'Arvioinut';
$string['saveallquickgradingchanges'] = 'Tallenna kaikki nopean arvioinnin muutokset';
$string['savechanges'] = 'Tallenna muutokset';
$string['savegradingresult'] = 'Arvosana';
$string['savenext'] = 'Tallenna ja näytä seuraava';
$string['scale'] = 'Asteikko';
$string['selectedusers'] = 'Valitut opiskelijat';
$string['selectlink'] = 'Valitse...';
$string['selectuser'] = 'Valitse {$a}';
$string['sendlatenotifications'] = 'Ilmoita myöhästyneistä palautuksista opettajille';
$string['sendlatenotifications_help'] = 'Jos tämä asetus on käytössä, kaikki kurssialueen opettajat saavat viestin aina kun opiskelija palauttaa vastauksensa myöhässä. Kukin opettaja voi säätää saapuvien viestien kanavan (sähköposti, Moodle-viesti vai ei kumpaakaan) omista profiiliasetuksistaan.';
$string['sendnotifications'] = 'Ilmoita palautuksista opettajille';
$string['sendnotifications_help'] = 'Jos tämä asetus on käytössä, kaikki kurssialueen opettajat saavat viestin aina, kun opiskelija palauttaa vastauksensa ajallaan tai myöhässä. Kukin opettaja voi säätää saapuvien viestien kanavan (sähköposti, Moodle-viesti vai ei kumpaakaan) omista profiiliasetuksistaan.';
$string['sendstudentnotifications'] = 'Ilmoita opiskelijoille';
$string['sendstudentnotifications_help'] = 'Kun käytössä, opiskelijat saavat viestin päivitetystä arvosanasta tai palautteesta.';
$string['sendsubmissionreceipts'] = 'Lähetä opiskelijalle kuittaus tehtäväpalautuksesta';
$string['sendsubmissionreceipts_help'] = 'Tämä asetus lähettää palautuksesta kuittauksen opiskelijalle itselleen. Opiskelija saa siis viestin joka kerta kun hänen palautuksensa on onnistunut.';
$string['setmarkerallocationforlog'] = 'Muuta nimetty arvioija: (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Muuta nimetty arvioija';
$string['setmarkingworkflowstate'] = 'Muuta arviointiprosessin vaihe';
$string['setmarkingworkflowstateforlog'] = 'Muuta arviointiprosessin vaihe: (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Tehtävän asetukset';
$string['showrecentsubmissions'] = 'Näytä viimeisimmät palautukset';
$string['status'] = 'Arviointivaihe';
$string['submission'] = 'Palautus';
$string['submissioncopiedhtml'] = '<p>Olet kopioinut aiemman suorituskertasi palautuksen tehtävään  <i>{$a->assignment}</i></p>

Katso <a href="{$a->url}">palautuksesi tila</a>.';
$string['submissioncopiedsmall'] = 'Olet kopioinut aiemman suorituskerran palautuksesi tehtävään  {$a->assignment}';
$string['submissioncopiedtext'] = 'Olet kopioinut aiemman suorituskertasi palautuksen tehtävään  {$a->assignment}

Näet palautuksesi tilan osoitteesta {$a->url}';
$string['submissiondrafts'] = 'Ota Lähetä arvioitavaksi -toiminto käyttöön';
$string['submissiondrafts_help'] = 'Jos tämä asetus on käytössä, opiskelijoiden on erikseen napsautettava Lähetä arvioitavaksi -painiketta lukitakseen lopullisen vastauksensa. Tämä siis mahdollistaa opiskelijoille palautuksen pitämisen luonnoksena tarpeen mukaan. Jos vaihdat asetuksen vaihtoehdosta "Ei" vaihtoehtoon "Kyllä" opiskelijoiden jo palautettua tehtäviä, jo tehdyt palautukset palautukset katsotaan lopullisiksi ja ne lukittuvat.';
$string['submissioneditable'] = 'Opiskelija saa muokata tätä palautusta';
$string['submissionempty'] = 'Mitään ei palautettu';
$string['submissionnotcopiedinvalidstatus'] = 'Palautusta ei kopioitu, koska sitä on muokattu sen jälkeen, kun se on avattu uudelleen.';
$string['submissionnoteditable'] = 'Opiskelija ei voi muokata tätä palautusta';
$string['submissionnotready'] = 'Tämä tehtävä ei ole vielä valmis palautettavaksi:';
$string['submissionplugins'] = 'Palautukseen liittyvät lisäosat';
$string['submissionreceipthtml'] = '<p>Olet palauttanut vastauksesi tehtävään {$a->assignment}
</p>

<p>Katso halutessasi <a href="{$a->url}">palautuksen tilanne Moodlesta</a>.</p>';
$string['submissionreceipts'] = 'Lähetä opiskelijalle kuittaus palautetusta tehtävästä';
$string['submissionreceiptsmall'] = 'Olet palauttanut vastauksesi tehtävään {$a->assignment}';
$string['submissionreceipttext'] = 'Olet palauttanut vastauksesi tehtävään {$a->assignment}

Pääset näkemään palautuksesi tilanteen Moodlesta, alla olevasta osoitteesta.

{$a->url}';
$string['submissions'] = 'Palautukset';
$string['submissionsclosed'] = 'Palautusaika on päättynyt';
$string['submissionsettings'] = 'Palautuksen asetukset';
$string['submissionslocked'] = 'Tähän tehtävään ei voi vastata';
$string['submissionslockedshort'] = 'Palautusta ei saa muokata';
$string['submissionsnotgraded'] = 'Arvioimattomat palautukset: {$a}';
$string['submissionstatement'] = 'Vakuutus oman työn osuudesta';
$string['submissionstatementacceptedlog'] = 'Opiskelija {$a} on hyväksynyt vakuutuksen oman työn osuudesta';
$string['submissionstatementdefault'] = 'Tämä tehtävä on omaa työtäni, ja olen selkeästi viitannut muiden kirjoittajien töihin niitä hyödyntäessäni. Työni lopussa on lähdeluettelo, jossa kaikki viittaamani lähteet ovat lueteltuina.';
$string['submissionstatement_help'] = 'Vakuutuksella oman työn osuudesta vakuutat opettajallesi, että työsi on asianmukaisesti omasi, ja kohdissa, joissa olet hyödyntänyt lähteitä, on asianmukaiset lähdeviitteet. Lisäksi olet tarkistanut, että kaikki käyttämäsi lähteet löytyvät lähdeluettelosta työsi lopusta.';
$string['submissionstatus'] = 'Palautuksen tila';
$string['submissionstatus_'] = 'Ei palautusta';
$string['submissionstatus_draft'] = 'Keskeneräinen (ei lähetetty arvioitavaksi)';
$string['submissionstatusheading'] = 'Palautuksen tila';
$string['submissionstatus_marked'] = 'Arvioitu';
$string['submissionstatus_new'] = 'Uusi palautus';
$string['submissionstatus_reopened'] = 'Avattu uudelleen';
$string['submissionstatus_submitted'] = 'Lähetetty arvioitavaksi';
$string['submissionsummary'] = '{$a->status}. Viimeksi muokattu {$a->timemodified}';
$string['submissionteam'] = 'Ryhmä';
$string['submissiontypes'] = 'Palautusmuodot';
$string['submitaction'] = 'Lähetä arvioitavaksi';
$string['submitassignment'] = 'Lähetä arvioitavaksi';
$string['submitassignment_help'] = 'Palautettuasi tehtävän et voi enää muokata sitä.';
$string['submitted'] = 'Palautettu';
$string['submittedearly'] = 'Palautus tehtiin {$a} ennen määräaikaa';
$string['submittedlate'] = 'Palautus tehtiin myöhässä {$a} määräajan jälkeen';
$string['submittedlateshort'] = '{$a} myöhässä';
$string['subplugintype_assignfeedback'] = 'Palautelisäosa';
$string['subplugintype_assignfeedback_plural'] = 'Palautelisäosat';
$string['subplugintype_assignsubmission'] = 'Palautuslisäosa';
$string['subplugintype_assignsubmission_plural'] = 'Palautuslisäosat';
$string['teamsubmission'] = 'Opiskelijat palauttavat ryhmätöitä';
$string['teamsubmissiongroupingid'] = 'Ryhmittely';
$string['teamsubmissiongroupingid_help'] = 'Nimeä ryhmittely, jota käytetään ryhmätöiden palauttamisessa. Jos et valitse ryhmittelyä, ryhminä käytetään kaikkia kurssialueen ryhmiä.';
$string['teamsubmission_help'] = 'Jos asetus on käytössä, opiskelijat jaetaan ryhmiin nimeämäsi ryhmittelyn tai kurssialueella olevien ryhmien perusteella.

Ryhmäpalautus näkyy kaikille ryhmän jäsenille ja kaikki ryhmäläiset näkevät myös toistensa muokkaukset.';
$string['teamsubmissionstatus'] = 'Ryhmän palautuksen tila';
$string['textinstructions'] = 'Tehtävän ohjeistus';
$string['timemodified'] = 'Viimeksi muokattu';
$string['timeremaining'] = 'Palautusaikaa jäljellä';
$string['unlimitedattempts'] = 'Rajoittamaton';
$string['unlimitedattemptsallowed'] = 'Suorituskertoja saa olla rajoittamaton määrä.';
$string['unlocksubmissionforstudent'] = 'Salli palautukset opiskelijalle: (id={$a->id}, nimi={$a->fullname}).';
$string['unlocksubmissions'] = 'Avaa palautusten lukitus';
$string['updategrade'] = 'Päivitä arvosanaa';
$string['updatetable'] = 'Tallenna ja päivitä taulukko';
$string['upgradenotimplemented'] = 'Päivitystä ei ole toteutettu lisäosassa ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Olet saanut lisäaikaa {$a} asti';
$string['usergrade'] = 'Arvosana';
$string['userswhoneedtosubmit'] = 'Opiskelijat, joilla on palautettavaa: {$a}';
$string['validmarkingworkflowstates'] = 'Oikeelliset arviointiprosessin vaiheet';
$string['viewfeedback'] = 'Näytä palaute';
$string['viewfeedbackforuser'] = 'Näytä palaute käyttäjälle: {$a}';
$string['viewfull'] = 'Näytä kaikki tiedot';
$string['viewfullgradingpage'] = 'Avaa erillinen arviointisivu antaaksesi palautetta';
$string['viewgradebook'] = 'Näytä arviointikirja';
$string['viewgrading'] = 'Näytä palautukset';
$string['viewgradingformforstudent'] = 'Näytä opiskelijan (id={$a->id}, nimi={$a->fullname}) arviointisivu.';
$string['viewownsubmissionform'] = 'Näytä oma tehtävän palautussivu.';
$string['viewownsubmissionstatus'] = 'Näytä oman palautuksen tilasivu.';
$string['viewrevealidentitiesconfirm'] = 'Näytä sivu, jolla opiskelijoiden nimien paljastaminen vahvistetaan';
$string['viewsubmission'] = 'Näytä palautus';
$string['viewsubmissionforuser'] = 'Näytä opiskelijan {$a} palautukset';
$string['viewsubmissiongradingtable'] = 'Näytä palautusten arviointitaulukko';
$string['viewsummary'] = 'Näytä yhteenveto';
$string['workflowfilter'] = 'Työprosessin suodatin';
