<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcija';
$string['addanotherhint'] = 'Dodaj namig';
$string['addcategory'] = 'Dodaj kategorijo';
$string['addmorechoiceblanks'] = 'Dodaj {no} prazna polja za več izbir';
$string['adminreport'] = 'Poročajte o morebitnih težavah v vaši podatkovni zbirki vprašanj.';
$string['answer'] = 'Odgovor';
$string['answersaved'] = 'Odgovor shranjen';
$string['attemptfinished'] = 'Poskus končan';
$string['attemptfinishedsubmitting'] = 'Oddajam končan poskus:';
$string['attemptoptions'] = 'Nastavitve poskusa';
$string['availableq'] = 'Na voljo?';
$string['badbase'] = 'Neveljavno pred **: {$a}**';
$string['behaviour'] = 'Obnašanje';
$string['behaviourbeingused'] = 'obnašanje, ki je v uporabi: {$a}';
$string['broken'] = 'To je neveljavna povezava, saj kaže na neobstoječo datoteko.';
$string['byandon'] = 'uporabnik/ca <em>{$a->user}</em>, datum <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Ni mogoče kopirati varnostne kopije';
$string['cannotcreatepath'] = 'Ni mogoče ustvariti poti: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Ne morete izbrisati vedenja \'{$a}\'. Uporabljeno je pri poskupih vprašanja.';
$string['cannotdeletecate'] = 'Ne morete izbrisati te kategorije, ker je privzeta kategorija za ta okvir.';
$string['cannotdeleteneededbehaviour'] = 'Ne morete izbrisati vedenja \'{$a}\'. Nameščena so še druga vedenja, ki se nanašajo na to.';
$string['cannotdeleteqtypeinuse'] = 'Tipa vprašanj \'{$a}\' ne morete zbrisati, ker so vprašanja tega tipa v zbirki vprašanj.';
$string['cannotdeleteqtypeneeded'] = 'Tipa vprašanj \'{$a}\' ne morete zbrisati, ker so drugi tipi vprašanj odvisni od tega.';
$string['cannotenable'] = 'Tip vprašanja {$a} ne more biti ustvarjen direktno.';
$string['cannotenablebehaviour'] = 'Vedenje vprašanja {$a} ne more biti neposredno uporabljeno. Namenjeno je samo za notranjo uporabo.';
$string['cannotfindcate'] = 'Ni mogoče najti zapisa kategorije';
$string['cannotfindquestionfile'] = 'Ni mogoče najti datoteke s podatki (vprašanj) v zip datoteki';
$string['cannotgetdsfordependent'] = 'Ni mogoče pridobiti navedenega nabora podatkov za vprašanje, ki je odvisno od nabora (vprašanje: {$a->id}, nabor podatkov: {$a->item})';
$string['cannotgetdsforquestion'] = 'Ni mogoče pridobiti navedenega nabora podatkov za izračunano vprašanje! (Vprašanje: {$a})';
$string['cannothidequestion'] = 'Vprašanj ni bilo možno skriti';
$string['cannotimportformat'] = 'Oprostite, uvoz tega formata še ni implementiran!';
$string['cannotinsertquestioncatecontext'] = 'Ni mogoče vstaviti nove kategorije vprašanj {$a->cat} neveljaven contextid {$a->ctx}';
$string['cannotloadquestion'] = 'Ni mogoče naložiti vprašanja';
$string['cannotmovequestion'] = 'Te skripte ne morete uporabljati za premik vprašanj, ki imajo povezane datoteke iz različnih področij.';
$string['cannotopenforwriting'] = 'Ni mogoče odpreti za pisanje: {$a}';
$string['cannotpreview'] = 'Ne morete si predogledati teh vprašanj!';
$string['cannotread'] = 'Ni možno prebrati uvozne datoteke (oziroma je datoteka prazna)';
$string['cannotretrieveqcat'] = 'Ni mogoče pridobiti kategorije vprašanja';
$string['cannotunhidequestion'] = 'Razkritje vprašanj ni uspelo.';
$string['cannotunzip'] = 'Ni mogoče odzipati datoteke.';
$string['cannotwriteto'] = 'Ni mogoče zapisati izvoženih vprašanj v {$a}';
$string['category'] = 'Kategorija';
$string['categorycurrent'] = 'Trenutna kategorija';
$string['categorycurrentuse'] = 'Uporabi to kategorijo';
$string['categorydoesnotexist'] = 'Ta kategorija ne obstaja';
$string['categoryinfo'] = 'Informacije o kategoriji';
$string['categorymove'] = 'Kategorija \'{$a->name}\' vsebuje {$a->count} vprašanj (nekatera so lahko stara, skrita ali vprašanja, ki so še vedno v uporabi v obstoječih kvizih).<br />Prosimo, izberite drugo kategorijo v katero naj se premaknejo.';
$string['categorymoveto'] = 'Shrani v kategorijo';
$string['categorynamecantbeblank'] = 'Ime kategorije ne sme biti prazno.';
$string['changeoptions'] = 'Spremeni možnosti';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategoriji "{$a->name}"</a> v predmetu "{$a->coursename}" bo spremenjen status objavljenosti iz <strong>{$a->changefrom} v {$a->changeto}</strong>.';
$string['check'] = 'Preveri';
$string['chooseqtypetoadd'] = 'Izberite tip vprašanja za dodajanje';
$string['clearwrongparts'] = 'Počisti nepravilne odgovore';
$string['clickflag'] = 'Označi z zastavico';
$string['clicktoflag'] = 'Kliknite za označbo tega vprašanja';
$string['clicktounflag'] = 'Kliknite za odstranitev označbe tega vprašanja';
$string['clickunflag'] = 'Odstrani zastavico';
$string['closepreview'] = 'Zapri predogled';
$string['combinedfeedback'] = 'Kombinirani odziv';
$string['comment'] = 'Komentar';
$string['commented'] = 'Komentirano: {$a}';
$string['commentormark'] = 'Komentirajte ali povozite oznako';
$string['comments'] = 'Komentarji';
$string['commentx'] = 'Komentar: {$a}';
$string['complete'] = 'Končano';
$string['contexterror'] = 'Ne bi smeli priti sem, če ne premikate kategorijo v drugi kontekst.';
$string['copy'] = 'Kopiraj iz {$a} in spremeni povezave.';
$string['correct'] = 'Pravilno';
$string['correctfeedback'] = 'Za vsak pravilni  odgovor';
$string['correctfeedbackdefault'] = 'Vaš odgovor je pravilen.';
$string['created'] = 'Ustvaril/a';
$string['createdby'] = 'Ustvarjeno od';
$string['createdmodifiedheader'] = 'Ustvarjeno / Zadnjič shranjeno';
$string['createnewquestion'] = 'Ustvari novo vprašanje ...';
$string['cwrqpfs'] = 'Naključna izbira vprašanj iz podkategorij.';
$string['cwrqpfsinfo'] = '<p>Med posodobitvijo v Moodle 1.9 bomo kategorije vprašanj razdelili v različne kontekste. Nekaterim kategorijam vprašanj in vprašanjem na vašem spletnem mestu bo spremenjen njihov status objavljenosti. To je potrebno v izjemnih primerih, ko je eno ali več \'naključnih\' vprašanj v kvizu nastavljenih na izbiro iz mešanice objavljenih in neobjavljenih kategorij (kor je na primer na tem spletnem mestu). To se zgodi, ko je \'naključno\' vprašanje nastavljeno na izbiro iz podkategorij, pri čemer ima ena ali več podkategorij nastavljen drugi status objavljenosti kot nadrejena kategorija, v kateri je bilo naključno vprašanje ustvarjeno.</p>
<p>Pri nadgradnji v Moodle 1.9 bo naslednjim kategorijam vprašanj (v katerih \'naključna\' vprašanja iz nadrejenih kategorij izbirajo vprašanja) spremenjen status objavljenosti v status, ki je enak statusu kategorije z \'naključnim\' vprašanjem. Naslednjim kategorijam bo spremenjen status objavljenosti. Vprašanja, ki se jih sprememba tiče, bodo še naprej delovala v obstoječih kvizih, dokler jih iz teh kvizov ne odstranite.</p<';
$string['cwrqpfsnoprob'] = 'Nobena kategorija vprašanj na vašem spletnem mestu ni bila prizadeta zaradi težave z \'Naključno izbiro vprašanj iz podkategorij.\'';
$string['decimalplacesingrades'] = 'Decimalna mesta v ocenah';
$string['defaultfor'] = 'Privzeto za {$a}';
$string['defaultinfofor'] = 'Privzeta kategorija za vprašanja objavljena v kontekstu \'{$a}\'.';
$string['defaultmark'] = 'Privzeta ocena';
$string['deletecoursecategorywithquestions'] = 'V tej zbirki vprašanj so vprašanja, ki so povezana s to kategorijo predmeta. Če nadaljujete, bodo vprašanja izbrisana. Morda jih boste najprej želeli premakniti s pomočjo vmesnika v zbirki vprašanj.';
$string['deletequestioncheck'] = 'Ste popolnoma prepričani da želite izbrisati \'{$a}\'?';
$string['deletequestionscheck'] = 'Ste popolnoma prepričani da želite izbrisati sledeče vprašanja?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Izbris vedenja vprašanja \'{$a}\'';
$string['deletingqtype'] = 'Brisanje vprašanja tipa \'{$a}\'';
$string['disabled'] = 'Onemogočeno';
$string['displayoptions'] = 'Možnosti prikaza';
$string['disterror'] = 'Distribucija {$a} je povzročila probleme';
$string['donothing'] = 'Ne kopiraj ali premikaj datotek ali spremeni povezave.';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategories_help'] = '<p>Namesto tega, da imate vsa vprašanja v enem dolgem seznamu, jih lahko razvrstite v kategorije.</p>

<p>Kategorije je mogoče po želji ustvariti ali izbrisati, vendar:
<ul><li>V vsakem kontekstu mora biti vsaj ena kategorija, kar pomeni, da ne morete izbrisati zadnje kategorije v kontekstu.</li>
<li>Ko boste poskušali izbrisati kategorijo, ki vsebuje vprašanja, boste pozvani, da določite kategorijo, v katero bodo vprašanja premaknjena.</li></ul></p>

<p>Kategorije lahko uredite tudi v hierarhijo, tako da jih je lažje urejati. Urejanje kategorij se izvaja preko zavihka \'Kategorije\' v zbirki vprašanj.</p>

   <ul><li>Na glavni strani pod zavihkom \'Kategorije\' v zbirki vprašanj :
   <ul><li>Puščici gor in dol zamenjata vrstni red v seznamu kategorij na istem nivoju.</li>
   <li>Kategorijo lahko premaknete v nov kontekst z uporabo puščic gor/dol.</li>
   <li>Puščici v levo in desno se uporabljata za spremembo nadrejene kategorije za določeno kategorijo.</li></ul></li>
   <li>Včasih je hitrejši način za premikanje kategorij ta, da kliknete na ikono za urejene pri želeni kategoriji pod zavihkom \'Kategorije\' v zbirki vprašanja in nato uporabite padajoči meni za izbiro nove nadrejene kategorije.</li></ul></p>

<p>Poglejte si tudi:</p>
<ul>
  <li><a href="help.php?module=question&amp;file=categorycontexts.html">Konteksti kategorij</a></li>
  <li><a href="help.php?module=question&amp;file=permissions.html">Dovoljenja za vprašanja</a></li>
  <li><a href="http://docs.moodle.org/en/Question_categories">Kategorije vprašanj na Moodle Docs (v angleščini)</a></li>
</ul>';
$string['editcategory'] = 'Uredi kategorijo';
$string['editingcategory'] = 'Urejanje kategorije';
$string['editingquestion'] = 'Urejanje vprašanja';
$string['editquestion'] = 'Uredi vprašanje';
$string['editquestions'] = 'Uredi vprašanja';
$string['editthiscategory'] = 'Uredi to kategorijo';
$string['emptyxml'] = 'Neznana napaka - prazen imsmanifest.xml';
$string['enabled'] = 'Omogočeno';
$string['erroraccessingcontext'] = 'Ni mogoče dostopati do konteksta';
$string['errordeletingquestionsfromcategory'] = 'Napaka pri brisanju vprašanj iz kategorije {$a}.';
$string['errorduringregrade'] = 'Ni mogoče ponovno oceniti vprašanja {$a->qid}, prehod v stanje {$a->stateid}.
';
$string['errorfilecannotbecopied'] = 'Napaka: ni mogoče kopirati datoteke {$a}.';
$string['errorfilecannotbemoved'] = 'Napaka: ni mogoče premakniti datoteke {$a}.';
$string['errorfileschanged'] = 'Napaka: datoteke, na katere so povezana vprašanja, so se od prikaza obrazca spremenile.';
$string['errormanualgradeoutofrange'] = 'Ocena {$a->grade} ni med 0 in {$a->maxgrade} pri vprašanju {$a->name}. Ocena in komentar nista bila shranjena.';
$string['errormovingquestions'] = 'Napaka pri premikanju vprašanj z id-ji {$a}.';
$string['errorpostprocess'] = 'Napaka se je pojavila med poopravilom!';
$string['errorpreprocess'] = 'Napaka se je pojavila med preopravilom!';
$string['errorprocess'] = 'Napaka se je pojavila med opravilom!';
$string['errorprocessingresponses'] = 'Med obravnavo vaših odzivov je prišlo do napake.';
$string['errorsavingcomment'] = 'Napaka pri shranjevanju komentarja za vprašanje {$a->name} v podatkovni zbirki.';
$string['errorsavingflags'] = 'Napaka pri shranjevanju statusa zastave.';
$string['errorupdatingattempt'] = 'Napaka pri posodabljanju poskusa {$a->id} v podatkovni zbirki.';
$string['exportcategory'] = 'Izvozi kategorijo';
$string['exportcategory_help'] = '<p align="center"><b>Izvozi kategorijo</b></p>

<p>Padajoči meni <b>Kategorija:</b> se uporabi za izbiro kategorije, iz katere bodo vzeta vprašanja za izvoz.</p>

<p>Nekateri formati za uvoz (formata GIFT in XML) omogočajo možnost vključitve kategorije v zapisano datoteko, kar omogoča (po želji), da se kategorije poustvarijo pri uvozu. Če želite te podatke vključiti, morate odkljukati kvadratek <b>Zapiši kategorijo v datoteko</b>. Če izberete to možnost, lahko v izvoz vključite tudi kontekst kategorije z odkljukanjem kvadratka <b>Zapiši kontekst v datoteko</b>. Če želite zagotoviti kompatibilnost s starejšimi različicami Moodla, ne označite možnosti za kontekst.</p>';
$string['exporterror'] = 'Napaka se je pojavila med izvažanjem!';
$string['exportfilename'] = 'kviz';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportquestions'] = 'Izvozi vprašanja v datoteko';
$string['exportquestions_help'] = '<p>Ta funkcija vam omogoča izvoz celotne kategorije vprašanj (in vseh njenih podkategorij) v datoteko z besedilom. </p>

<p>Vedite, da se v mnogih formatih datotek ob izvozu vprašanj nekatere informacije izgubijo. To se zgodi zato, ker mnogi formati ne vsebujejo vseh možnosti, ki obstajajo v Moodle vprašanjih. Ne smete pričakovati, da bodo vprašanja identična, če jih izvozite in uvozite. Nekaterih vrst vprašanj se sploh ne da izvoziti. Priporočeno je, da izvožene podatke preverite, preden jih uporabite v delovnem okolju.</p>

<p>Trenutno podprti formati so:</p>

<h2>GIFT format</h2>

<p>GIFT je najbolj vsestranska oblika zapisa za izvoz in uvoz za izvoz vprašanj Moodle kvizov v datoteko z besedilom.  Zasnovan je bil kot enostaven način, s katerim lahko izvajalci pišejo vprašanja kot datoteko z besedilom. Podpira večkratno izbiro, drži - ne drži, kratek odgovor, ujemanje in številčna vprašanja, kakor tudi obliko za vstavljanje ____ za &quot;manjkajoče besede&quot;.  Vedite, da trenutno vprašanja izpolnjevanja niso podprta. Različne vrste vprašanj so lahko mešane v eni datoteki besedila , prav tako pa oblika podpira tudi medvrstične komentarje, imena vprašanj, povratno informacijo in odstotke oz. utežene ocene. Spodaj je nekaj primerov:</p>
<pre>
Kdo je pokopan v Grantovi grobnici?{~Grant ~Jefferson =nihče}

Grant je {~pokopan =položen ~živ} v Grantovi grobnici.

Grant je pokopan v Grantovi grobnici.{FALSE}

Kdo je pokopan v Grantovi grobnici?{=nihče =nobeden}

Kdaj je bil Ulysses S. Grant rojen?{#1822}
</pre>

<p align="right"><a href="help.php?file=formatgift.html&module=quiz">Več informacij o formatu &quot;GIFT&quot;</a></p>

<h2>Moodle XML format</h2>

<p>Oblika zapisa značilna za Moodle izvozi vprašanja kviza v preprost XML zapis. Uvoziti jih je možno v drugo kategorijo kviza ali uporabiti v kakem drugem procesu kot npr. pri XSLT transformacijah. Zapis XML bo izvozil slike priložene vprapanjem (kodirane z načinom base64).</p>

<h2>IMS QTI 2.0 format</h2>

<p>Izvozi standardni zapis IMS QTI (različica 2.0). Vedite, da to ustvari skupino datotek v eni \'zip\' datoteki.</p>
<p align="right"><a href="http://www.imsglobal.org/question/" target="_qti">Več informacij na spletni strani IMS QTI</a> (zunanja spletna stran v novem oknu)</p>

<h2>XHTML format</h2>

<p>Izvozi kategorijo kot eno stran v \'doslednem\' XHTML. Vsako vprašanje je jasno postavljeno v lastno oznako &lt;div&gt;. Če želite uporabiti to stran tako kot je, boste morali urediti vsaj oznako &lt;form&gt; na začetku odseka &lt;body&gt;, da boste ponudili ustrezno dejanje (npr. \'mailto\').</p>

<p>Več formatov bo še sledilo, vključno z WebCT in karkoli drugega bodo lahko prispevali Moodle uporabniki! </p>';
$string['feedback'] = 'Odziv';
$string['filecantmovefrom'] = 'Datotek z vprašanji ni mogoče premakniti, ker nimate dovoljenja za odstranitev datotek iz prostora od koder skušate premakniti vprašanja.';
$string['filecantmoveto'] = 'Datotek z vprašanji ni mogoče premakniti oz. kopirati, ker nimate dovoljenja za dodajanje datotek v prostor, kamor skušate vprašanja premakniti.';
$string['fileformat'] = 'Format datoteke';
$string['filesareacourse'] = 'področje za datoteke predmeta';
$string['filesareasite'] = 'področje za datoteke strani';
$string['filestomove'] = 'Premakni / kopiraj datoteke v {$a}?';
$string['fillincorrect'] = 'Vnesi pravilne odgovore';
$string['flagged'] = 'Označeno';
$string['flagthisquestion'] = 'Označi to vprašanje';
$string['formquestionnotinids'] = 'Obrazec vsebuje vprašanje, ki ni v vprašanjih';
$string['fractionsnomax'] = 'Eden izmed odgovorov bi moral imeti vrednost 100 %, tako da je pri tem vprašanju možno doseči vse točke.';
$string['generalfeedback'] = 'Generalni odziv';
$string['generalfeedback_help'] = 'Generalni odziv je prikazan udeležencu po poskusu vprašanja. Za razliko od odziva, ki je odvisen od vrste vprašanja in kakšen odziv poda udeleženec, isti tekst generalnega odziva je prikazan vsem udeležencem.

Uporablite lahko generalni odziv, da podate udeležencem ozadje katero področje je vprašanje testiralo ali pa jim date povezavo za več informacij, ki jih lahko uporabijo če niso razumeli vprašanja.';
$string['getcategoryfromfile'] = 'Pridobi kategorijo iz datoteke';
$string['getcontextfromfile'] = 'Pridobi kontekst iz datoteke';
$string['hidden'] = 'Skrito';
$string['hintn'] = 'Namig {ne}';
$string['hintnoptions'] = 'Namig {no} možnosti';
$string['hinttext'] = 'Besedilo namiga';
$string['howquestionsbehave'] = 'Kako se vprašanja vedejo';
$string['howquestionsbehave_help'] = 'Udeleženci lahko izvajajo interakcije z vprašanji v kvizu na različne načine. Na primer, nastavite lahko, da udeleženci vnesejo odgovor na vsako vprašanje posebej in nato oddajo celoten kviz, preden dobijo oceno ali odziv. To bi bil \'Odložen odzivni\' način.
Lahko pa tudi nastavite, da udeleženci oddajo odgovor na vsako vprašanje in dobijo takojšnji odziv in če odgovor ni pravilen, lahko poskusijo ponovno za manj točk. To bi bil \'Interaktivni način z več poskusi\'.';
$string['ignorebroken'] = 'Prezri neveljavne povezave';
$string['importcategory'] = 'Uvozi kategorijo';
$string['importcategory_help'] = '<p>Padajoči meni <b>Kategorija:</b> se uporabi za izbiro kategorije, v katero bodo dodana uvožena vprašanja.</p>

<p>Nekateri formati za uvoz (formata GIFT in XML) omogočajo možnost določitve kategorije v datoteko za uvoz. Če želite te podatke vključiti, morate odkljukati kvadratek <b>Pridobi kategorijo iz datoteke</b>. Če tega ne storite, bodo vprašanja dodana v izbrano kategorijo ne glede na morebitna navodila v datoteki za uvoz. Formati, ki so bili izvoženi iz Moodla, lahko vsebujejo tudi podatke o kontekstu kategorije. Če želite, da se uporabi privzeti kontekst, kvadratek <b>Pridobi kontekst iz datoteke</b> ne sme biti označen.</p>

<p>V primeru, da so v datoteki za uvoz določene kategorije, ki še ne obstajajo, bodo pri uvozu ustvarjene.</p>';
$string['importerror'] = 'Prišlo je do napake med procesom uvažanja';
$string['importerrorquestion'] = 'Napaka pri uvozu vprašanj';
$string['importfromcoursefiles'] = '... ali izberite predmetno datoteko za uvoz.';
$string['importfromupload'] = 'Izberite datoteko za nalaganje ...';
$string['importingquestions'] = 'Uvažanje {$a} vprašanj iz datoteke';
$string['importparseerror'] = 'Napaka(e) najdene pri razčlenjevanju uvožene datoteke. Uvoženih ni bilo nobenih vprašanj. Za uvoz katerihkoli dobrih vprašanj poskusite znova nastaviti \'Ustavi se na napaki\' na \'Ne\'';
$string['importquestions'] = 'Uvozi vprašanja iz datoteke';
$string['importquestions_help'] = 'Ta funkcija omogoča uvoz vprašanj v različnih formatih preko tekstovne datoteke. Pomnite, da mora datoteka uporabljati UTF-8 kodiranje.';
$string['importwrongfiletype'] = 'Tip datoteke, ki ste ga označili ({$a->actualtype}) se ne ujema s pričakovanim tipom tega uvoznega formata    ({$a->expectedtype}).';
$string['impossiblechar'] = 'Nemogoč znak {$a} je bil odkrit kot znak oklepaja';
$string['includesubcategories'] = 'Prikaži tudi vprašanja iz pod-kategorij';
$string['incorrect'] = 'NEpravilno';
$string['incorrectfeedback'] = 'Za vsak nepravilni odgovor';
$string['incorrectfeedbackdefault'] = 'Vaš odgovor je napačen.';
$string['information'] = 'Informacije';
$string['invalidanswer'] = 'Nepopoln odgovor';
$string['invalidarg'] = 'Brez veljavnih dobavljenih argumentov oz. neveljavna konfiguracija strežnika';
$string['invalidcategoryidforparent'] = 'Neveljavna id kategorija za starša!';
$string['invalidcategoryidtomove'] = 'Neveljavna id kategorija za premik!';
$string['invalidconfirm'] = 'Potrditveni niz je bil neveljaven';
$string['invalidcontextinhasanyquestions'] = 'Neveljaven kontekst posredovan v question_context_has_any_questions.';
$string['invalidgrade'] = 'Ocene se ne ujemajo z možnostmi ocem - preskočeno vprašanje';
$string['invalidpenalty'] = 'Nepravilna kazen';
$string['invalidwizardpage'] = 'Neveljavna oz. ni določene strani s čarovnikom!';
$string['lastmodifiedby'] = 'Zadnjič spremenjeno od';
$string['linkedfiledoesntexist'] = 'Povezana datoteka {$a} ne obstaja';
$string['makechildof'] = 'Naredi podrejeno za \'{$a}\'';
$string['makecopy'] = 'Naredi kopijo';
$string['maketoplevelitem'] = 'Premakni v zgornji nivo';
$string['manualgradeoutofrange'] = 'Ta ocena je izven veljavnega območja.';
$string['manuallygraded'] = 'Ročno ocenjeno {$a->mark} z komentarjem: {$a->comment}';
$string['mark'] = 'Ocena';
$string['markedoutof'] = 'Ocenjen s/z';
$string['markedoutofmax'] = 'Ocenjen s/z {$a}';
$string['markoutofmax'] = 'Ocena {$a->mark} od {$a->max}';
$string['marks'] = 'Ocene';
$string['matchgrades'] = 'Poišči ujemanje ocen';
$string['matchgradeserror'] = 'Napaka, če ocena ni navedena';
$string['matchgrades_help'] = '<p>Uvožene ocene se <b>morajo</b> ujemati z enim izmed določenih seznamom veljavnih ocen, kot sledijo...</p>

<ul>
  <li>100%</li>
  <li>90%</li>
  <li>80%</li>
  <li>75%</li>
  <li>70%</li>
  <li>66.666%</li>
  <li>60%</li>
  <li>50%</li>
  <li>40%</li>
  <li>33.333</li>
  <li>30%</li>
  <li>25%</li>
  <li>20%</li>
  <li>16.666%</li>
  <li>14.2857</li>
  <li>12.5%</li>
  <li>11.111%</li>
  <li>10%</li>
  <li>5%</li>
  <li>0%</li>
</ul>

<p>dovoljene so tudi negativne vrednosti z gornjega seznama.</p>

<p>Za to stikalo sta dve nastavitvi. Vplivata na to, kako uvozni postopek obravnava vrednosti, ki se ne ujemajo <strong>natančno</strong> z eno izmed zgoraj naštetih vrednosti</p>

<ul>
  <li><strong>Napaka, če ocene ni na seznamu</strong><br /> Če vprašanje vsebuje ocene, ki jih ni na seznamu, se prikaže napaka in to vprašanje ne bo uvoženo.</li>
  <li><strong>Najbližja ocena, če je ni na seznamu</strong><br /> Če je najdena ocena, katere vrednost se ne ujema z nobeno vrednostjo na seznamu, se ocena spremeni na najbližjo ujemajočo vrednost iz seznama.</li>
</ul>

<p><i>Opomba: nekateri uvozni zapisi po meri pišejo neposredno v podatkovno zbirko in morda zaobidejo to preverjanje</i></p>';
$string['matchgradesnearest'] = 'Najbližja ocena, če ni navedena';
$string['missingcourseorcmid'] = 'Potrebno je zagotoviti id predmeta ali cmid za print_question.';
$string['missingcourseorcmidtolink'] = 'Potrebno je zagotoviti id predmeta ali cmid za get_question_edit_link.';
$string['missingimportantcode'] = 'Tej vrsti vprašanja manjka pomembna koda: {$a}.';
$string['modified'] = 'Na zadnje shranil/a';
$string['move'] = 'Premakni iz {$a} in spremeni povezave.';
$string['movecategory'] = 'Premakni kategorijo';
$string['movedquestionsandcategories'] = 'Vprašanja in kategorije vprašanj so bile premaknjene iz {$a->oldplace} v {$a->newplace}.';
$string['movelinksonly'] = 'Samo spremeni cilj povezav, ne premikaj ali kopiraj datotek.';
$string['moveq'] = 'Premakni vprašanje/a';
$string['moveqtoanothercontext'] = 'Premakni vprašanje v drug kontekst.';
$string['moveto'] = 'Pramakni na >>';
$string['movingcategory'] = 'Premikanje kategorije';
$string['movingcategoryandfiles'] = 'Ali ste prepričani, da želite premakniti kategorijo {$a->name} in vse podrejene kategorije v kontekst za "{$a->contextto}"?<br /> Zaznali smo {$a->urlcount} povezanih datotek iz vprašanj v {$a->fromareaname}; ali bi si želeli skopirati ali premakniti te datoteke v {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Ali ste prepričani, da želite premakniti kategorijo "{$a->name}" in vse podrejene kategorije v kontekst za "{$a->contextto}"?';
$string['movingquestions'] = 'Premikanje vprašanj in vseh datotek';
$string['movingquestionsandfiles'] = 'Ali ste prepričani, da želite premakniti vprašanje/a {$a->questions} v kontekst za <strong>"{$a->tocontext}"</strong>?<br /> Zaznali smo <strong>{$a->urlcount} povezanih datotek</strong> iz teh vprašanj v {$a->fromareaname}; ali bi si želeli skopirati ali premakniti te datoteke v {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Ali ste prepričani, da želite premakniti vprašanje/a {$a->questions} v kontekst za <strong>"{$a->tocontext}"</strong>?<br /> <strong>Ni datotek</strong>, ki bi bile povezane iz teh vprašanj v {$a->fromareaname}.';
$string['needtochoosecat'] = 'Izbrati morate kategorijo, v katero želite premakniti to vprašanje, ali klikniti \'Prekliči\'.';
$string['nocate'] = 'Ni take kategorije {$a}!';
$string['nopermissionadd'] = 'Tu nimate dovoljenja za dodajanje vprašanj.';
$string['nopermissionmove'] = 'Nimate dovoljenja za premikanje datotek iz tega mesta. Vprašanje morate shraniti v teh kategoriji ali ga shraniti kot novo vprašanje.';
$string['noprobs'] = 'V podatkovni zbirki vprašanj ni bilo najdenih težav.';
$string['noquestions'] = 'Ni bilo mogoče najti nobenega vprašanja za izvoz. Izbrati morate tako kategorijo za izvoz, ki vsebuje vprašanja.';
$string['noquestionsinfile'] = 'V datoteki za uvoz ni vprašanj';
$string['noresponse'] = '[Ni odziva]';
$string['notanswered'] = 'Ni odgovorjeno';
$string['notenoughanswers'] = 'Za vrsta vprašanja potrebuje vsaj {$a} odgovorov';
$string['notenoughdatatoeditaquestion'] = 'Določeni niso bili ne id vprašanja ne id kategorije in vrsta vprašanja.';
$string['notenoughdatatomovequestions'] = 'Podati morate id-je vprašanj, ki jih želite premakniti.';
$string['notflagged'] = 'Neoznačeno';
$string['notgraded'] = 'Neocenjeno';
$string['notshown'] = 'Ni prikazano';
$string['notyetanswered'] = 'Ni še odgovorjeno';
$string['notyourpreview'] = 'Ta predogled ne pripada vam';
$string['numqas'] = 'Št. poskusov vprašanja';
$string['numquestions'] = 'Št. vprašanj';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} skrito)';
$string['options'] = 'Možnosti';
$string['page-question-category'] = 'Stran kategorije vprašanja';
$string['page-question-edit'] = 'Stran urejanja vprašanja';
$string['page-question-export'] = 'Stran izvoza vprašanja';
$string['page-question-import'] = 'Stran uvoza vprašanja';
$string['page-question-x'] = 'Katerakoli stran vprašanja';
$string['parent'] = 'Starš';
$string['parentcategory'] = 'Starševska kategorija';
$string['parentcategory_help'] = '<h2>Nadrejena kategorij</h2>

<p>Kategorija, v katero bo uvrščen element, ki ga urejate. \'Vrh\' pomeni, da kategorija ni del nobene druge kategorije.</p>

<p>Praviloma boste videli več \'kontekstov\' kategorij, ki so izpisani s krepko pisavo. Pomnite, da vsak kontekst vsebuje svojo hierarhijo kategorij. Poglejte spodaj za več informacij o kontekstih. Če ne vidite več kontekstov, to lahko pomeni, da nimate dovoljenja za dostop do drugih kontekstov.</p>

<p>Če je v kontekstu samo ena kategorija, kategorije ne boste mogli premakniti, saj mora biti v vsakem kontekstu vsaj ena kategorija.</p>

<p>Poglejte si tudi:</p>
<ul>
  <li><a href="help.php?module=question&amp;file=categories.html">Kategorije vprašanj</a></li>
  <li><a href="help.php?module=question&amp;file=categorycontexts.html">Konteksti vprašanj</a></li>
  <li><a href="help.php?module=question&amp;file=permissions.html">Dovoljenja za vprašanja</a></li>
</ul>';
$string['parenthesisinproperclose'] = 'Oklepaj pred ** je nepravilno zaključen v {$a}**';
$string['parenthesisinproperstart'] = 'Oklepaj pred ** je nepravilno začet v {$a}**';
$string['parsingquestions'] = 'Razčlenjevanje vprašanj iz uvožene datoteke.';
$string['partiallycorrect'] = 'Delno pravilno';
$string['partiallycorrectfeedback'] = 'Za vsak delno pravilni odgovor';
$string['partiallycorrectfeedbackdefault'] = 'Vaš odgovor je delno pravilen.';
$string['penaltyfactor'] = 'Količnik odbitka';
$string['penaltyfactor_help'] = '<p>Določite lahko kolikšen delež doseženega rezultata naj bo odštet za vsak napačen odgovor. To je pomembno samo v primeru, če kviz teče v prilagodljivem načinu, tako da udeleženec sme ponovno odgovarjati na vprašanja. Količnik odbitka mora biti število med 0 in 1. Količnik odbitka 1 pomeni, da mora udeleženec pravilno odgovoriti na vprašanje v prvem poskusu, če želi prejeti kaj točk zanj. Količnik odbitka 0 pomeni, da lahko udeleženec poskuša poljubno mnogokrat in bo še vedno prejel vse točke.</p>';
$string['penaltyforeachincorrecttry'] = 'Kazen za vsak nepravilni poskus';
$string['penaltyforeachincorrecttry_help'] = 'Ko zaganjate vaša vprašanja z uporabo \'Interaktivnevnega z več poskusi\' ali \'Prilagoditvenega načina\' vedenja, tako bo imel uporabnik na voljo več poskusov da pravilno odgovori na vprašanje. Potem ta možnost kontrolira koliko so kaznovani za vsak nepravilni poskus.

Kazen je delež celotne ocene vprašanja, tako da če je vprašanje vredno tri točke in je kazen 0.333333, dobi udeleženec oceno 3, če odgovori na vprašanje pravilno v prvem poskusu. Če pravilno odgovori na vprašanje v drugem poskusu dobi 2 in 1, če pravilno odgovori v tretjem poskusu.';
$string['permissionedit'] = 'Uredi to vprašanje';
$string['permissionmove'] = 'Premakni to vprašanje';
$string['permissionsaveasnew'] = 'Shrani to kot novo vprašanje';
$string['permissionto'] = 'Dovoljenje imate za :';
$string['previewquestion'] = 'Predogled vprašanja: {$a}';
$string['published'] = 'objavljeno';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Vprašanje "{$a->name}" ({$a->qtype})</a> je v tej kategoriji vprašanj, vendar je prav tako v uporabi v <a href="{$a->qurl}">kvizu "{$a->quizname}"</a> v predmetu "{$a->coursename}".';
$string['questionbank'] = 'Zbirka vprašanj';
$string['questionbehaviouradminsetting'] = 'Nastavitve vedenja vprašanja';
$string['questionbehavioursdisabled'] = 'Vedenja vprašanja za onemogočiti';
$string['questionbehavioursdisabledexplained'] = 'Vnesite z vejico ločen seznam vedenj, ki jih ne želite prikazati v padajočem meniju';
$string['questionbehavioursorder'] = 'Vedenja vprašanj po vrsti';
$string['questionbehavioursorderexplained'] = 'Vnesite z vejico ločen seznam vedenj po vrstnem redu, kot jih želite prikazati v padajočem meniju';
$string['questioncategory'] = 'Kategorija vprašanj';
$string['questioncatsfor'] = 'Kategorije vprašanj za \'{$a}\'';
$string['questiondoesnotexist'] = 'To vprašanje ne obstaja';
$string['questionidmismatch'] = 'ID-ji vprašanj se ne ujemajo';
$string['questionname'] = 'Ime vprašanja';
$string['questionno'] = 'Vprašanje {$a}';
$string['questionpreviewdefaults'] = 'Privzete nastavitve za predogled vprašanj';
$string['questionpreviewdefaults_desc'] = 'Te nastavitve se uprabljajo, ko si udeleženec prvič ogleda vprašanje iz zaloge vprašanj. Nastavitve se nato shranijo kot prednostne nastavitve uporabnika.';
$string['questions'] = 'Vprašanja';
$string['questionsinuse'] = '(* Vprašanja označena z zvezdico so že v uporabi v nekaterih kvizih. Ta vprašanja ne bodo izbrisana iz teh kvizov smpak samo iz seznama kategorij. )';
$string['questionsmovedto'] = 'Vprašanja, ki so še v uporabi, so bila premaknjena v "{$a}" v nadrejeni kategoriji predmeta.';
$string['questionsrescuedfrom'] = 'Vprašanja so bila shranjena iz konteksta {$a}.';
$string['questionsrescuedfrominfo'] = 'Ta vprašanja (nekatera so lahko skrita) so bila shranjena, ko je bil kontekst {$a} izbrisan, ker so še vedno v uporabi v nekaterih kvizih ali drugih dejavnostih.';
$string['questiontext'] = 'Tekst vprašanja';
$string['questiontype'] = 'Tip vprašanja';
$string['questionuse'] = 'Uporabi vprašanje v tej dejavnosti';
$string['questionvariant'] = 'Varianta vprašanja';
$string['questionx'] = 'Vprašanje {$a}';
$string['requiresgrading'] = 'Potrebuje ocenjevanje';
$string['responsehistory'] = 'Zgodovina odzivov';
$string['restart'] = 'Ponovno začni';
$string['restartwiththeseoptions'] = 'Ponovno začnite s temi možnostmi';
$string['reviewresponse'] = 'Preglej odgovor';
$string['rightanswer'] = 'Pravilni odgovor';
$string['rightanswer_help'] = 'Samodejen povzetek pravilnega odgovora. Lahko ga omejite, tako da pojasnite pravilno rešitev v Splošnem odzivu, to možnost pa izklopite.';
$string['saved'] = 'Shranjeno: {$a}';
$string['saveflags'] = 'Shrani stanje oznak';
$string['selectacategory'] = 'Izberi kategorijo:';
$string['selectaqtypefordescription'] = 'Izberi tip vprašanja za ogled njegovega opisa.';
$string['selectcategoryabove'] = 'Izberite kategorijo zgoraj';
$string['selectquestionsforbulk'] = 'Izberi vprašanja za masovna dejanja';
$string['settingsformultipletries'] = 'Nastavitve za več poskusov';
$string['shareincontext'] = 'Objavi v kontekstu za {$a}';
$string['showhidden'] = 'Prikaži tudi stara vprašanja';
$string['showmarkandmax'] = 'Prikaži oceno in najvišjo oceno';
$string['showmaxmarkonly'] = 'Prikaži samo najvišjo oceno';
$string['shown'] = 'Prikazano';
$string['shownumpartscorrect'] = 'Prikaži število pravilnih odgovorov';
$string['shownumpartscorrectwhenfinished'] = 'Prikaži število pravilnih odgovorov';
$string['showquestiontext'] = 'Prikaži tekst vprašanja v seznamu vprašanj';
$string['specificfeedback'] = 'Specifičen odziv';
$string['specificfeedback_help'] = 'Odziv, odvisen od odgovora udeleženca.';
$string['started'] = 'Začeto';
$string['state'] = 'Stanje';
$string['step'] = 'Korak';
$string['stoponerror'] = 'Ustavi ob napaki';
$string['stoponerror_help'] = 'Ta nastavitev določa, če se proces uvoza ustavi, ko je najdena napaka, kar rezultira v neuvozu vprašanj ali če ignoriram vprašanja, ki vsebujejo napake in so uvožena veljavna vprašanja.';
$string['submissionoutofsequence'] = 'Dostop izven sekvence. Prosimo, da ne kliknete nazaj gumba ko delate na vprašanjih kviza.';
$string['submissionoutofsequencefriendlymessage'] = 'Vnesli ste podatke izven normalne sekvence. Do tega lahko pride pri uporabi brskalnikovegaNazaj ali Naprej gumba; prosimo, da jih ne uporabljate med testom. Do tega lahko tudi pride, če kliknete na nekaj medtem, ko se stran nalaga. Za nadaljevanje kliknite <strong>Nadaljuj</strong>.';
$string['submit'] = 'Oddaj';
$string['submitandfinish'] = 'Oddaj in končaj';
$string['submitted'] = 'Oddaj: {$a}';
$string['tofilecategory'] = 'Zapiši kategorijo v datoteko';
$string['tofilecontext'] = 'Zapiši kontekst v datoteko';
$string['uninstallbehaviour'] = 'Odstrani vedenje tega vprašanja';
$string['uninstallqtype'] = 'Odstrani to vrsto vprašanja.';
$string['unknown'] = 'Neznano';
$string['unknownbehaviour'] = 'Nepoznano vedenje: {$a}.';
$string['unknownquestion'] = 'Nepoznano vprašanje: {$a}.';
$string['unknownquestioncatregory'] = 'Nepoznana kategorija vprašanja: {%a}.';
$string['unknownquestiontype'] = 'Neznana vrsta vprašanja: {$a}.';
$string['unknowntolerance'] = 'Neznan tip odstopanja {$a}';
$string['unpublished'] = 'neobjavljeno';
$string['updatedisplayoptions'] = 'Posodobi možnosti prikaza';
$string['upgradeproblemcategoryloop'] = 'Pri posodabljanju kategorij vprašanj je bila zaznana težava. V drevesu kategorije obstaja zanka. Id-ji prizadetih kategorij so {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Kategorije vprašanj {$a->name} ({$a->id}) ni bilo možno posodobiti.';
$string['upgradeproblemunknowncategory'] = 'Pri nadgradnji kategorij vprašanj je bila zaznana težava. Kategorija {$a->id} se sklicuje na nadrejeno kategorijo {$a->parent}, ki ne obstaja. Nadrejena kategorija je bila spremenjena za odpravo težave.';
$string['whethercorrect'] = 'Ali je pravilno';
$string['whethercorrect_help'] = 'Vsebuje tako besedilni opis (v obliki: \'Pravilno\', \'Delno pravilno\' ali \'Napačno\') kot barvno označevanje besedila, ki podaja pomensko enako informacijo.';
$string['withselected'] = 'Z izbranimi';
$string['xoutofmax'] = '{$a->mark} od {$a->max}';
$string['yougotnright'] = 'Pravilno ste izbrali {$a->num}.';
$string['youmustselectaqtype'] = 'Izbrati morate tip vprašanja.';
$string['yourfileshoulddownload'] = 'Vaša datoteka za izvoz bi se morala začet prenašati v kratkem. Če ne, prosimo <a href="{$a}">kliknite sem</a>. Nadrejena kategorija je bila spremenjena za odpravo težave.';
