<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotpot', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   hotpot
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'Opuščeno';
$string['abandonhotpot'] = 'Vaši dosedanji rezultati bodo shranjeni, vendar kasneje te dejavnosti ne morete nadaljevati ali začeti znova.';
$string['activitycloses'] = 'Dejavnost se odpre';
$string['activitygrade'] = 'Ocena dejavnosti';
$string['activityopens'] = 'Dejavnost se zapre';
$string['added'] = 'Dodano';
$string['addquizchain'] = 'Dodaj verigo kviza';
$string['addquizchain_help'] = 'Naj bodo dodani vsi kvizi v verigi?

**Ne**
: samo en kviz bo dodan na predmet

**Da**
: Če je izvorna datoteka **datoteka kviza**,  obravnavana kot začetek verige kvizov, bodo vsi kvizi v tej verigi dodani v predmet z identičnimi nastavitvami. Vsak kviz v verigi mora imeti povezavo v naslednjo datoteko v verigi.

Če je izvorna datoteka **mapa**, vsi prepoznavni kvizi v mapi bodo dodani v predmet in formirajo verigo kvizov z identičnimi nastavitvami.

Če je izvorna datoteka **datoteka enote**, kot na primer Hot Poratoes, masher datoteka ali index.html. Kvizi napisani v datoteki enote bodo dodani v predmet kot veriga kvizov z identičnimi nastavitvami.';
$string['allowreview'] = 'Dovoli pregled';
$string['allowreview_help'] = 'Če je omogočeno, udeleženci lahko pregledajo svoje poskuse kviza, ko je kviz zaprt.';
$string['analysisreport'] = 'Analiza predmeta';
$string['attemptlimit'] = 'Limita poskusov';
$string['attemptlimit_help'] = 'Najvišje število poskusov, ki jih lahko ima udeleženec v tej HotPot dejavnosti';
$string['attemptnumber'] = 'Številka poskusa';
$string['attempts'] = 'Poskusi';
$string['attemptscore'] = 'Ocena poskusa';
$string['attemptsunlimited'] = 'Neomejeno poskusov';
$string['average'] = 'Povprečje';
$string['averagescore'] = 'Povprečna ocena';
$string['bodystyles'] = 'Slogi osrednjega besedila';
$string['bodystylesbackground'] = 'Barva in slika ozadja';
$string['bodystylescolor'] = 'Barva besedila';
$string['bodystylesfont'] = 'Velikost in slog pisave';
$string['bodystylesmargin'] = 'Levi in desni rob';
$string['cacherecords'] = 'HotPot cache zapisi';
$string['canrestarthotpot'] = 'Vaši dosedanji rezultati bodo shranjeni, dejavnost "{$a}" pa lahko ponovite kasneje.';
$string['canresumehotpot'] = 'Vaši dosedanji rezultati bodo shranjeni, dejavnost "{$a}" pa lahko nadaljujete kasneje.';
$string['checks'] = 'Preverjanja';
$string['checksomeboxes'] = 'Prosimo obkljukajte nekatere kvadratke.';
$string['clearcache'] = 'Pobriši HotPot cache';
$string['cleardetails'] = 'Izbriši HotPot podrobnosti';
$string['clearedcache'] = 'HotPot cache je bil izpraznjen';
$string['cleareddetails'] = 'HotPot podrobnosti so bie izpraznjene';
$string['clickreporting'] = 'Omogoči poročanje o klikih';
$string['clickreporting_help'] = 'Če je omogočeno, se beleži ločeni zapis za vsak klik na gumb "namig", "indic", "preveri". To omogoča učitelji ogled zelo podrobnega poročila, ki prikazuje stanje kviza za vsak klik. Obdrži se samo eno poročilo na poskus kviza.';
$string['clicktrailreport'] = 'Sledi klika';
$string['closed'] = 'Ta dejavnost je bila zaključena';
$string['clues'] = 'Ključi';
$string['completed'] = 'Zaključeno';
$string['configbodystyles'] = 'Privzeto se slogi HotPot dejavnosti prepišejo s temami Moodla. Tukaj izbrani slogi HotPot pa imajo prednost pred Moodlovimi.';
$string['configenablecache'] = 'Vzdrževanje HotPot kvizov v predpomnilniku, lahko dramatično pospeši dostavo kvizov do udeleženca.';
$string['configenablecron'] = 'Določite ure v vašem časovnem okvirju v katerem se lahko zaganjajo HotPot cron skripte';
$string['configenablemymoodle'] = 'Ta nastavitev kontrolira ali so HotPot napisani na MyMoodle strani ali ne';
$string['configenableobfuscate'] = 'Obfuscating javascript kode za vstavljanje medijskih predvajalnikov otežkoča določanje imena medijskih datotek in ugibanje kaj datoteka vsebuje.';
$string['configenableswf'] = 'Dovoli vdelavo SWF datotek in HotPot dejavnosti. Če je omogočeno, ta nastavitev povozi filter_mediaplugin_enable_swf.';
$string['configfile'] = 'Konfiguracijska datoteka';
$string['configframeheight'] = 'ko je kviz prikazan znotraj okvirja, ta vrednost je višina (v pikslih) na vrhu okvirja ki vsebuje Moodlovo navigacijsko vrstico.';
$string['configlocation'] = 'Lokacija konfiguracijske datoteke';
$string['configlockframe'] = 'Če je ta nastavitev omogočena, potem je navigacijski okvir, če ga uporabimo, zaklenjen, da po njem ne moremo drsati z drsnikom, ni razširljivo ter nima mej';
$string['configmaxeventlength'] = 'Če ima HotPot določen čas odprtja in zaprtja, in je razlika med časoma večja od števila dnevov, ki so tukaj določeni, potem bosta dodana dva ločena koledarska dogodka v koledar predmeta. Za krajše trajanja, ali ko je določen samo en čas, bo dodan samo en koledarski dogodek. Če noben čas ni določen, ne bo dodanega nobenega koledarskega dogodka.';
$string['configstoredetails'] = 'Če je ta nastavitev omogočena, potem bodo surovi HTML detajli poskusov HotPot kvizov shranjeni v hotpot_details tabeli. To omogoča ponovno ocenjevanje poskusov kviza v prihodnosti, kar se zrcali v spremembah v HotPot sistemu ocenjevanja kviza. Če omogočite to možnost na strani z veliko obiska, bo hotpot_details tabela hitro zrasla.';
$string['confirmdeleteattempts'] = 'SI res želite izbrisati te poskuse?';
$string['confirmstop'] = 'Ste prepričani, da želite navigirati proč s te strani?';
$string['correct'] = 'Pravilno';
$string['couldnotinsertsubmissionform'] = 'Ne morem vstaviti obrazca prijave';
$string['delay1'] = 'Zamik 1';
$string['delay1_help'] = 'Minimalni zamik med prvim in drugim poskusom.';
$string['delay1summary'] = 'Časovni zamik med prvim in drugim poskusom';
$string['delay2'] = 'Zamik 2';
$string['delay2_help'] = 'Minimalni zamik med poskusi po drugem poskusu.';
$string['delay2summary'] = 'Časovni zamik med kasnejšimi poskusi';
$string['delay3'] = 'Zamik 3';
$string['delay3afterok'] = 'Počakajte dokler ne udeleženec klikne OK';
$string['delay3disable'] = 'Ne nadaljuj avtomstsko';
$string['delay3_help'] = 'Ta nastavitev določa zamik med končanjem kviza in vračanjem nadzora prikaza nazaj Moodlu **Uporabite določen čas (v sekundah)** : nadzor bo vrnjen Moodlu po določenem številu sekund. **Uporabite nastavitve v izvorni/predložni datoteki** : Nadzor bo vrnjen Moodlu podoločenem številu sekund v izvorni datoteki ali datoteki predloge za ta izhodni format. **Počakaj, dokler udeleženci kliknejo OK** : nadzor bo vrnjen Moodlu, ko udeleženec klikne OK gumb v sporočilu o končanji v kvizu. **Ne nadaljuj avtomatsko** : nadzor ne bo vrnjen Moodlu, ko bo kviz končan. Udeleženec bo lahko prosto odšel iz strani kviza. Pomnite, rezultati kviza so vedno vrnjeni Moodlu takoj, ko je kviz končan ali zapuščen, ne glede na to nastavitev.';
$string['delay3specific'] = 'Uporabi točno določen čas (v sekundah)';
$string['delay3summary'] = 'Časovni zamik na koncu kviza';
$string['delay3template'] = 'Uporabi nastavitve v izvorni/predložni datoteki';
$string['deleteallattempts'] = 'Izbriši vse poskuse';
$string['deleteattempts'] = 'Izbriši poskuse';
$string['detailsrecords'] = 'HotPot podrobni zapisi';
$string['d_index'] = 'Index diskriminacije';
$string['duration'] = 'Trajanje';
$string['enablecache'] = 'Omogoči HotPot predpomnilnik';
$string['enablecron'] = 'Omogoči HotPot cron';
$string['enablemymoodle'] = 'Prikaži HotPot-e na MyMoodle';
$string['enableobfuscate'] = 'Omogoči namerna zavajanja kode medijskega predvajalnika';
$string['enableswf'] = 'Dovoli vdelavo SWF datotek in HotPot aktivnosti';
$string['entry_attempts'] = 'Poskusi';
$string['entrycm'] = 'Prejšnje aktivnosti';
$string['entrycmcourse'] = 'Prejšnje aktivnosti v tem predmetu';
$string['entrycm_help'] = 'Ta nastavitev določa dejavnost in najnižjo oceno, ki mora biti dosežena preden lahko pristopite k dejavnosti HotPot.
Izvajalec lahko določi točno določeno aktivnost ali eno od naslednjih splošnih možnosti:

* Prejšnja dejavnost v tem predmetu
* Prejšnja dejavnost v tem področju
* Prejšnji HotPot v tem predmetu
* Prejšnji HotPot v tem področju';
$string['entrycmsection'] = 'Prejšnja dejavnost v tem področju predmeta';
$string['entrycompletionwarning'] = 'Preden začnete to aktivnost, morate pogledati na {$a}.';
$string['entry_dates'] = 'Datumi';
$string['entrygrade'] = 'Prejšnja ocena aktivnosti';
$string['entrygradewarning'] = 'Te aktivnosti ne morete začeti, dokler ne dobite ocene {$a->entrygrade}% za {$a->entryactivity}. Trenutna ocena za vašo aktivnost je {$a->usergrade}%';
$string['entry_grading'] = 'Ocenjevanje';
$string['entryhotpotcourse'] = 'Prejšnji HotPot v tem predmetu';
$string['entryhotpotsection'] = 'Prejšnji HotPot v tem področju predmeta';
$string['entryoptions'] = 'Začetek strani možnosti';
$string['entryoptions_help'] = 'Te potrditvena polja omogočajo in onemogočajo prikaz predmetov na HotPot vstopni strani.

**Ime enote kot naslov**
: če je obkljukano, bo ime enote prikazano kot naslov vstopne strani.

**Ocenjevanje**
: če je označeno, bodo HotPot informacije o ocenah prikazane na vstopni strani.

**Datumi**
: če je obkljukano, bodo HotPot datumi za zaprtje in odprtje prikazani na vstopni strani.

**Poskusi**
: če je obkljukano bo tabela, ki prikazuje podrobnosti uporabnikov prejšnjih poskusov v tem HotPot-u prikazana na vstopni strani. Poskusi, ki se jih lahko nadaljuje bodo imeli nadaljuj gumb prikazan v desnem stolpcu.';
$string['entrypage'] = 'Prikaži vstopno stran';
$string['entrypagehdr'] = 'Vstopna stran';
$string['entrypage_help'] = 'Ali naj bo udeležencem prikazana vstopna stran, pred začetkom HotPot aktivnosti?

**Da**
: udeležencem bo prikazana vstopna stran, pred začetkom HotPot-a. Vsebina vstopne strani je določena v HotPot nastavitvah vstopne strani.

**Ne**
: udeleženci ne bodo prikazani na vstopni strani, in bodo začeli HotPot takoj.

Vstopna stran je vedno prikazana učitelju, da zagotovi dostop do poročil in urejanje strani kvizov';
$string['entrytext'] = 'Začetek strani besedila';
$string['entry_title'] = 'Ime enote kot naslov';
$string['exit_areyouok'] = 'Zdravo, ste še tu?';
$string['exit_attemptscore'] = 'Vaša ocena za poskus je bila {$a}';
$string['exitcm'] = 'Naslednja sktivnost';
$string['exitcmcourse'] = 'Naslednja aktivnost v tem predmetu';
$string['exitcm_help'] = 'Ta nastavitev določa dejavnost, ki jo je treba opraviti, potem ko bo dejavnost HotPot končana. Ocena je izbirna in predstavlja zahtevano oceno, ki jo je treba doseči, preden lahko nadaljujete z dejavnostmi.

Izvajalec lahko določi točno določeno dejavnost, ali eno od naslednjih splošnih možnosti:

* Naslednja dejavnost v tem predmetu
* Naslednja dejavnost v tem področju
* Naslednja HotPot dejavnost v tem predmetu
* Naslednja HotPot dejavnost v tem področju

Če so možnosti izhoda s strani onemogočene in je udeleženec dosegel zahtevano oceno v tej HotPot dejavnosti, bo udeleženec nadaljeval z  na naslednjo aktivnostjo. V nasprotnem primeru, bo udeležencu prikazana povezava, ki ga bo pripeljala do naslednje aktivnosti, ko bo pripravljen.';
$string['exitcmsection'] = 'Naslednja dejavnost v tem področju predmeta';
$string['exit_course'] = 'Predmet';
$string['exit_course_text'] = 'Vrnite se na glavno stran predmeta';
$string['exit_encouragement'] = 'Opogumljanje';
$string['exit_excellent'] = 'Odlično!';
$string['exit_feedback'] = 'Izhod iz odzivov strani';
$string['exit_feedback_help'] = 'te možnosti omogočijo ali onemogočijo prikaz odzivov predmetov na HotPot izhodni strani.

**Ime enote kot naslov**
: če je označeno, bo ime enote prikazano kot naslov na izhodni strani.

**Opogumljanje**
: če je označeno, bodo nekatera opogumljanja prikazana na izhodni strani. Opogumljanja so odvisna od HotPot ocene:
: **> 90%**:Odlično!
: **> 60%**: Dobro opravljeno
: **> 0%**: Dober poskus
: **= 0%**: Ste v redu?

**Ocena enote poskusa**
: če je označeno bo ocena poskusa, ki je bil ravno končan prikazana na izhodni strani.

**Ocena enote**
: če je označeno bo HotPot ocena prikazana na izhodni strani.

Dodatno, če je ocenjevalna metoda enote najvišja, bo prikazano sporočilo uporabniku, ki mu bo sporočilo, če je bil njegov zadnji poskus enak ali boljši kot prejšni.';
$string['exit_goodtry'] = 'Dober poskus!';
$string['exitgrade'] = 'Ocena naslednje dejavnosti';
$string['exit_grades'] = 'Ocene';
$string['exit_grades_text'] = 'Oglejte si dosedanje ocene za ta predmet';
$string['exithotpotcourse'] = 'Naslednji HotPot v tem predmetu';
$string['exit_hotpotgrade'] = 'Vaša ocena za to aktivnost je {$a}';
$string['exit_hotpotgrade_average'] = 'Vaša povprečna ocena do sedaj za to aktivnost je {$a}';
$string['exit_hotpotgrade_highest'] = 'Vaše najvišja dosedanja ocena za to aktivnost je {$a}';
$string['exit_hotpotgrade_highest_equal'] = 'Izenačili ste prejšnji najboljši rezultat za to aktivnost!';
$string['exit_hotpotgrade_highest_previous'] = 'Vaša prejšnja najvišja ocena za to aktivnost je bila {$a}';
$string['exit_hotpotgrade_highest_zero'] = 'Za to aktivnost niste dobili višje ocene od {$a}';
$string['exithotpotsection'] = 'Naslednji HotPot v tem področju predmeta';
$string['exit_index'] = 'Indeks';
$string['exit_index_text'] = 'Pojdi na indeks aktivnosti';
$string['exit_links'] = 'Izhod iz strani povezav';
$string['exit_links_help'] = 'Te možnosti omogočijo ali onemogočijo prikaz določenih navigacijskih povezav na HotPot izhodnji strani.

**Ponovni poskus**
: če so v HotPot-u dovoljeni večkratni poskusi in ima udeleženec na voljo še nekaj poskusov, mu bo prikazana povezava za ponovni poskus HotPot-a

**Indeks**
: če je označeno, bo prikazana povezava na HotPot indeks stran.

**Predmet**
: če je označeno bo prikazana povezava na Moodle predmetno stran.

**Ocene**
: če je označeno bo prikazana povezava na Moodle redovalnico.';
$string['exit_next'] = 'NAslednji';
$string['exit_next_text'] = 'Poskusite naslednjo aktivnost';
$string['exit_noscore'] = 'Uspešno ste opravili to aktivnost!';
$string['exitoptions'] = 'Izhod iz nastavitev strani';
$string['exitpage'] = 'Ptikaži izhodno stran';
$string['exitpagehdr'] = 'Izodna stran';
$string['exitpage_help'] = 'Naj bo izhodna stran prikazana, ko bo HotPot kviz končan? **Da** : udeleženci bodo prikazani na izhodni strani, ko bo HotPot zaključen. Vsebina izhodne strani je določena z nastavizvami za HotPot izhodno stran odzivov in povezav. **Ne** : udeleženci ne bodo prikazani na izhodni strani. Namesto tega bodo šli takoj na naslednjo aktivnost ali se vrnili na Moodle predmetno stran.';
$string['exit_retry'] = 'Ponovi';
$string['exit_retry_text'] = 'Ponovi to aktivnost';
$string['exittext'] = 'Besedilo izhodne strani';
$string['exit_welldone'] = 'Dobro opravljeno!';
$string['exit_whatnext_0'] = 'Kaj želite storiti?';
$string['exit_whatnext_1'] = 'Izberite svojo destinacijo ...';
$string['exit_whatnext_default'] = 'Prosimo izberite eno od sledečih:';
$string['feedbackdiscuss'] = 'Pogovorite se o tem kvizu na forumu';
$string['feedbackformmail'] = 'Obrazec za odziv';
$string['feedbackmoodleforum'] = 'Moodle forum';
$string['feedbackmoodlemessaging'] = 'Moodle sporočanje';
$string['feedbacknone'] = 'Brez';
$string['feedbacksendmessage'] = 'Pošljite sporočilo svojemu inštruktorju';
$string['feedbackwebpage'] = 'Spletna stran';
$string['firstattempt'] = 'Prvi poskus';
$string['forceplugins'] = 'Vsili medijske vtičnike';
$string['forceplugins_help'] = 'Če je omogočeno, bodo z Moodlom združljivi medijski predvajalniki predvajali vsebine kot avi, mpeg, mpg, mp3, mov in wmv. V nasprotnem primeru Modle ne bo spremenil nastavitev medijskih predvajalnikov v kvizu.';
$string['frameheight'] = 'Višina okvirja';
$string['giveup'] = 'Opusti';
$string['grademethod'] = 'Ocenjevalna metoda';
$string['grademethod_help'] = 'Ta nastavitev definira kako je izračunana HotPot ocena iz ocen poskusov.

**Najvišja ocena**
: ocena bo nastavljena na najvišjo oceno poskusa v tej HotPot aktivnosti.

**Povprečna ocena**
: ocena bo nastavljena na povprečno oceno poskusov v tej HotPot aktivnosti.

**Prva ocena**
: ocena bo nastavljena na oceno prvega poskusoa v tej HotPot aktivnosti.

**Zadnja ocena**
: ocena bo nastavljena na oceno zadnjega poskusa v tej HotPot aktivnosti.';
$string['gradeweighting'] = 'Tehtanje ocene';
$string['gradeweighting_help'] = 'Ocene za to HotPot aktivnost bodo zmanjšane na to številko v Moodle redovalnici.';
$string['highestscore'] = 'Najvišja ocena';
$string['hints'] = 'Namigi';
$string['hotpot:addinstance'] = 'Dodaj novo aktivnost HotPot';
$string['hotpot:attempt'] = 'Poskusi kviz';
$string['hotpot:deleteallattempts'] = 'Izbriši vse uporabniške poskuse HotPot aktivnost';
$string['hotpot:deletemyattempts'] = 'Izbriši svoje lastne poskuse HotPot aktivnosti';
$string['hotpot:ignoretimelimits'] = 'Ignorira časovno omejitev HotPot aktivnosti';
$string['hotpot:manage'] = 'Spremenite nastavitve HotPot aktivnosti';
$string['hotpotname'] = 'Ime HotPot aktivnosti';
$string['hotpot:preview'] = 'Predogled HotPot aktivnosti';
$string['hotpot:reviewallattempts'] = 'Ogled kateregakoli uporabniškega poskusa HotPot aktivnosti';
$string['hotpot:reviewmyattempts'] = 'Ogled lastnih poskusov HotPot aktivnosti';
$string['hotpot:view'] = 'Uporaba kviza';
$string['ignored'] = 'Prezrto';
$string['inprogress'] = 'Se izvaja';
$string['isgreaterthan'] = 'je večje kot';
$string['islessthan'] = 'je manjše kot';
$string['lastaccess'] = 'Zadnji dostop';
$string['lastattempt'] = 'Zadnji poskus';
$string['lockframe'] = 'Zakleni okvir';
$string['maxeventlength'] = 'Najvišje število dni za posamezni koledarski dogodek';
$string['mediafilter_hotpot'] = 'HotPot medijski filter';
$string['mediafilter_moodle'] = 'Moodlovi standardni medijski filtri';
$string['migratingfiles'] = 'Migracija Hot Potatoes kviznih datotek';
$string['missingsourcetype'] = 'V HotPot zapisu manjkajo izvornitipi.';
$string['modulename'] = 'Kviz Hot Potatoes';
$string['modulename_help'] = 'Modul HotPot omogoča izvajalcem, da interaktivna gradiva pošljejo udeležencem po Moodlu in pregledajo njihove odgovor in rezultate.

Posamezna HotPot dejavnost sestoji iz neobvezne vstopne strani, vsaj ene e-naloge in neobvezne izhodne strani. E-naloga je lahko statična spletna stran ali pa interaktivna stran, ki udeležencem ponuja besedilne, slušne in vizualne primere in beleži njihove odgovore. E-nalogo ustvari izvajalec na svojem računalniku z uporabo pooblaščene programske opreme, nato pa jo naloži v Moodle predmet.

HotPot dejavnosti se lahko izdelajo z naslednjo programsko opremo:

* Hot Potatoes (version 6)
* Qedoc
* Xerte
* iSpring
* katerikoli HTML urejevalnik';
$string['modulenameplural'] = 'Kvizi Hot Potatoes';
$string['nameadd'] = 'Ime';
$string['nameadd_help'] = 'Ime je lahko določen tekst, ki ga vnese učitelj, lahko pa je tudi avtomatsko ustvarjen.

**Dobi od izvorne datoteke**
: ime bo izvlečeno iz izvorne datoteke.

**Uporabi ime izvorne datoteke**
: ime izvorne datoteke bo uporabljeno kot ime.

**Uporabi pot izvorne datoteke**
: pot izvorne datoteke bo uporabljena kot ime. Vsaka poševnica v poti datoteke bo zamenjana s presledki.

**Določeno besedilo**
: določeno besedilo vnešeno od učitelja bo uporabljeno kot ime.';
$string['nameedit'] = 'Ime';
$string['nameedit_help'] = 'Določeno besedilo, ki je prikazano udeležencem';
$string['navigation'] = 'Navigacija';
$string['navigation_embed'] = 'Vgnezdena spletna stran';
$string['navigation_frame'] = 'Moodle navigacijski okvir';
$string['navigation_give_up'] = 'Samo en gumb &quot;Opusti&quot;';
$string['navigation_help'] = 'Ta nastavitev določa katera navigacija bo uporabljena v kvizu:

**Moodle navigacijska vrstica**
: Moodle navigacijska vrstica bo prikazana v istem oknu kot kviz na vrhu strani

**Moodle navigacijski okvir**
: Moodle navigacijski okvir bo prikazan v ločenem okvirju na vrhu kviza

**Vgnezdena spletna stran**
: Moodle navigacijska vrstica bo prikazana v Hot Potatoes kvizu vgnezdenem znotraj okna

**Originalni navigacijski pripomočki**
: kviz bo prikazan z navigacijskimi gumbi, če do definirani v kvizu

**Samo en "Obupaj" gumb**
: kviz bo prikazan z enim "Obupaj" gumbom na vrhu strani

**Brez**
: kviz bo prikazan brez navigacijske pomoči. zato ko bodo vsa vprašanja pravilno odgovorjena in odvisno od "Prikaži naslednji kviz" nastavitve, vas bo Moodle vrnil na stran predmeta ali prikazal naslednji kviz';
$string['navigation_moodle'] = 'Standarne Moodle navigacijske vrstice (na vrhu in pri strani)';
$string['navigation_none'] = 'Brez';
$string['navigation_original'] = 'Originalni navigacijski pripomočki';
$string['navigation_topbar'] = 'Samo zgornja Moodle navigacijska vrstica (ne stranskih vrstic)';
$string['noactivity'] = 'Brez dejavnosti';
$string['nohotpots'] = 'Ni najdenih HotPot-ov';
$string['nomoreattempts'] = 'Oprostite, za to aktivnost nimate več poskusov';
$string['noresponses'] = 'Ni najdenih podatkov o posameznih vprašanjih in odgovorih.';
$string['noreview'] = 'Oprostite, ni vam dovoljen ogled podrobnosti tega poskusa kviza.';
$string['noreviewafterclose'] = 'Oprostite, ta kviz je zaprt. Ni vam več dovoljen ogled podrobnosti tega poskusa kviza.';
$string['noreviewbeforeclose'] = 'Oprostite, ni vam dovoljen ogled podrobnosti tega poskusa kviza do {$a}';
$string['nosourcefilesettings'] = 'HotPot zapisu manjkajo informacije o izvorni datoteki';
$string['notavailable'] = 'Oprostite, ta aktivnost vam trenutno ni na voljo.';
$string['outputformat'] = 'Oblika zapisa izhoda';
$string['outputformat_best'] = 'najboljše';
$string['outputformat_help'] = 'Izhodni format določa, kako bi vsebina prikazana udeležencu.

Izhodni formati, ki so na voljo glede na vrsto izvorne datoteke. Nekatere vrste izvornih datotek imajo samo en izhodni format, medtem ko ostale vrste izvornih datotek imajo več izhodnih formatov.

"Najboljša" nastavitev bo prikazala vsebino z uporabo optimalnega izhodnega formata za spletni brskalnik udeleženca.';
$string['outputformat_hp_6_jcloze_html'] = 'JCloze HP6 html: Standard';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'JCloze from HP6 xml: ANCT-Scan';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'JCloze from HP6 xml: Rottmeier DropDown';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'JCloze from HP6 xml: Rottmeier FindIt (a)';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'JCloze from HP6 xml: Rottmeier FindIt (b)';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'JCloze from HP6 xml: Rottmeier JGloss';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'JCloze from HP6 xml: Standard';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'JCloze (v6) iz HP6 xml (Auto-advance)';
$string['outputformat_hp_6_jcross_html'] = 'JCross HP6 html';
$string['outputformat_hp_6_jcross_xml_v6'] = 'JCross iz HP6 xml';
$string['outputformat_hp_6_jmatch_html'] = 'JMatch iz html';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'JMatch iz HP6 xml: Flashcard';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'JMatch iz HP6 xml: Rottmeier JMemori';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'JMatch iz HP6 xml: Standard';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'JMatch iz HP6 xml: Drag and Drop';
$string['outputformat_hp_6_jmix_html'] = 'JMix iz HP6 html';
$string['outputformat_hp_6_jmix_xml_v6'] = 'JMix iz HP6 xml: Standard';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'JMix iz HP6 xml: Drag and Drop';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'JMix (v6+ s predpono, s pripono z distraktorjem) iz xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'JMix iz HP6 xml: Povleci in Spusti s pritisnjenem gumbom';
$string['outputformat_hp_6_jquiz_html'] = 'JQuiz HP6 html';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'JQuiz iz HP6 xml: Standard';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'JQuiz iz HP6 xml: Auto-advance';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'JQuiz iz HP6 xml: Exam';
$string['outputformat_hp_6_rhubarb_html'] = 'WebRhubarb (v6) iz html';
$string['outputformat_hp_6_rhubarb_xml'] = 'WebRhubarb (v6) iz xml';
$string['outputformat_hp_6_sequitur_html'] = 'WebSequitur (v6) iz html';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'WebSequitur (v6) iz html, inkrementalno ocenjevanje';
$string['outputformat_hp_6_sequitur_xml'] = 'WebSequitur (v6) iz xml';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'WebSequitur (v6) from xml, inkrementalno ocenjevanje';
$string['outputformat_html_ispring'] = 'Datoteka iSpring HTML';
$string['outputformat_html_xerte'] = 'Datoteka Xerte HTML';
$string['outputformat_html_xhtml'] = 'Standardna datoteka HTML';
$string['outputformat_qedoc'] = 'Datoteka Qedoc';
$string['overviewreport'] = 'Pregled';
$string['penalties'] = 'Odbitki';
$string['percent'] = 'Procent';
$string['pluginadministration'] = 'HotPot administracija';
$string['pluginname'] = 'Kviz Hot Potatoes';
$string['pressoktocontinue'] = 'Pritisnite OK za nadaljevanje, ali Prekliči, če želite ostati na trenutni strani.';
$string['questionshort'] = 'V-{$a}';
$string['quizname_help'] = 'besedila pomoči za ime Kviza';
$string['quizzes'] = 'Kvizi';
$string['removegradeitem'] = 'Odstrani oceno';
$string['removegradeitem_help'] = 'Odstranim oceno za to aktivnost?

**Ne**
: ocena za to aktivnost ne bo odstranjena iz Moodle redovalnice

**Da**
: Če je najvišja ocena ali pondiranje ocene za ta HotPot nastavljeno na nič, bo ocena za to aktivnost odstranjena iz Moodle redovalnice';
$string['responses'] = 'Odgovori';
$string['responsesreport'] = 'Odzivi';
$string['score'] = 'Rezultat';
$string['scoresreport'] = 'Rezultati';
$string['selectattempts'] = 'Označi poskuse';
$string['showerrormessage'] = 'HotPot napaka: {$a}';
$string['sourcefile'] = 'Ime izvorne datoteke';
$string['sourcefile_help'] = 'Ta nastavitev določa datoteko z vsebino, ki bo prikazana udeležencem.

Ponavadi je izvorna datoteka ustvarjena zunaj Moodla in je nato naložena na področje za datoteke v Moodle predmetu.
Lahko je html datoteka ali druga vrsta datoteke, ki je bila ustvarjena z avtorskim programom kot naprimer Hot Potatoes ali Qedoc.

Izvorna datoteka je lahko določena kot imenik ali pot datoteke v Moodle datotečnem področju predmeta, ali pa je lahko url, ki se začne z http:// ali https://

Za Qedoc material mora biti izvorna datoteka url od Qedoc modula, ki je bil naložen na Qedoc strežnik.

* npr
http://www.qedoc.net/library/ABCDE_123.zip
* Za informacije o nalaganju Qedoc modulov si poglejte:  [Qedoc documentation: Uploading_modules](http://www.qedoc.org/en/index.php?title=Uploading_modules)';
$string['sourcefilenotfound'] = 'Izvorna datoteka ni najdena (ali je prazna): {$a}';
$string['status'] = 'Status';
$string['stopbutton'] = 'Prikaži stop gumb';
$string['stopbutton_help'] = 'Če je ta nastavitev omogočena, bo stop gumb vstavljen na kviz.

Če udeleženec klikne stop gumb bodo dosedanji rezultati vrnjeni Moodlu in status poskusa kviza bo nastavljen na opuščeno.

Besedilo, ki bo prikazano na stop gumbu, je lahko ena od sedanjih fraz iz Moodlovega jezikovnega paketa. Učitelji lahko tudi določijo svoje besedilo za gumb.';
$string['stopbutton_langpack'] = 'Iz jezikovnega paketa';
$string['stopbutton_specific'] = 'Uporabi določeno besedilo';
$string['stoptext'] = 'Besedilo stop gumba';
$string['storedetails'] = 'Shrani surove XML podrobnosti HotPot poskusov kviza';
$string['studentfeedback'] = 'Odziv udeleženca';
$string['studentfeedback_help'] = 'Če je omogočeno, bo prikazana povezava na pojavno okno odzovov, kadar udeleženec klikne na "Preveri" gumb. Okno z odzivi omogoča udeležencem da se pogovarjajo o kvizu z učitelji ali ostalimi udeleženci z enim od naslednjih načinov:

**Spletna stran**
: potrebovan je URL spletne strani, na primer http://myserver.com/feedbackform.html

**Obrazec odzivov**
: potrebovan je URL iz skripte obrazca, na primer http://myserver.com/cgi-bin/formmail.pl

**Moodle forum**
: prikazan bo indeks foruma za ta predmet

**Moodle sporočanje**
: prikazano bo okno za Moodle instantno sporočanje. Če ima predmet več učiteljev, bo lahko udeleženec lahko izbral učitelja, preden se pojavi okno za sporočanje.';
$string['submits'] = 'Oddaje';
$string['subplugintype_hotpotattempt'] = 'Izhodna oblika';
$string['subplugintype_hotpotattempt_plural'] = 'Izhodne oblike';
$string['subplugintype_hotpotreport'] = 'Poročilo';
$string['subplugintype_hotpotreport_plural'] = 'Poročila';
$string['subplugintype_hotpotsource'] = 'Izvorna datoteka';
$string['subplugintype_hotpotsource_plural'] = 'Izvorne datoteke';
$string['textsourcefile'] = 'Pridobi iz izvorne datoteke';
$string['textsourcefilename'] = 'Uporabi ime datoteke';
$string['textsourcefilepath'] = 'Uporabi pot datoteke';
$string['textsourcequiz'] = 'Pridobi iz kviza';
$string['textsourcespecific'] = 'Določeno besedilo';
$string['timeclose'] = 'Na voljo do';
$string['timedout'] = 'Poteklo';
$string['timelimit'] = 'Časovna omejitev';
$string['timelimitexpired'] = 'Časovna omejitev za ta poskus je potekla';
$string['timelimit_help'] = 'Ta nastavitev določa najdaljše trajanje enega poskusa.

**Uporabi nastavitve v izvorni/predložni datoteki**
: časovna omejitev bo pobrana iz izvorne datoteke ali datotek predloge za ta izhodni format

**Uporabi določen čas**
: časovna omejitev določena v nastavitveni strani HotPot kviza bo uporabljena kot časovna omejitev za poskus tega kviza. Ta nastavitev povozi časovne omejitve v izvorni datoteki, konfiguracijski datoteki ali datoteki predloge za ta izhodni format.

**Onemogoči**
: časovna omejitev ne bo nastavljena za poskuse tega kviza.

Pomnite da, če je poskus nadaljevan, se timer nadaljuje od takrat, ko je bil poskus pavziran.';
$string['timelimitspecific'] = 'Uporabi določen čas';
$string['timelimitsummary'] = 'Časovna omejitev za en poskus';
$string['timelimittemplate'] = 'Uporabi nastavitve v izvorni/predložni datoteki';
$string['timeopen'] = 'Na voljo od';
$string['timeopenclose'] = 'Časi odprtja in zaprtja';
$string['timeopenclose_help'] = 'Določite lahko primere, ko bo kviz dosegljiv za poskuse udelenžencev. Pred časom odprtja in po času zaprtja, bo kviz nedostopen.';
$string['title'] = 'Naslov';
$string['title_help'] = 'Ta nastavitev določa naslov, ki bo prikazan na spletni strani.

**HotPot ime aktivnosti**
: ime te HotPot aktivnosti bo prikazano kot naslov spletne strani.

**Pridobi iz izvorne datoteke**
: naslov, če sploh je, definiran v izvorni datoteki, bo uporabljen kot naslov spletne strani.

**Uporabi ime izvorne datoteke**
: ime izvorne datoteke, izvzemši vse imena datotek, bo uporabljen kot ime za spletno stran.

**Uporabi pot izvorne datoteke**
: pot izvorne datoteke, vključuje vse imena datotek, bo uporabljeno kot naslov spletne strani.';
$string['unitname_help'] = 'besedilo pomoči za ime enote';
$string['unrecognizedsourcefile'] = 'HotPot modul ni zaznal oblike izvorne datoteke: {$a}';
$string['updated'] = 'Posodobljeno';
$string['usefilters'] = 'Uporabi filtre';
$string['usefilters_help'] = 'Če je ta možnost omogočena bo šla vsebina skozi Moodle filtre, preden bo poslana v brskalnik.';
$string['useglossary'] = 'Uporabi slovar';
$string['useglossary_help'] = 'Če je ta možnost omogočena bo šla vsebina skozi Moodle slovarjev avtomatsko-povezavni filter, preden bo poslana v brskalnik.

Pomnite da ta nastavitev povozi nastavitve administracije strani da omogočite ali onemogočite slovarjev avtomatsko-povezovalni filter.';
$string['usemediafilter'] = 'Uporabi medijski filter';
$string['usemediafilter_help'] = 'Ta nastavitev določa medijski filter, ki bo uporabljen.

**Brez**
: vsebina ne bo poslana skozi medijske filtre.

**Moddlovi standardni media filtri**
: vsebina bo poslana skozi Moodlove standardne medijske filtre. Ti filtri iščejo povezave do pogostih vrst zvokovnih in filmskih datotek in konvertira te povezave do pravih medijskih predvajalnikov.

**HotPot medijski filter**
: vsebina bo poslana skozi filtre, ki odkrivajo povezave, slike, zvoke in filme, da jih specificira z uporabo oglatih oklepajev.

Zapis z oglatimi oklepaji ima sledečo sintakso:
<code>[url player width height options]</code>

**url**
: relativni ali absolutni url medijskih datotek

**predvajalnik**(opcijsko)
: ime predvajalnika, ki bo vstavljeno. Privzeta vrednost za to nastavitev je "moodle". Standardna verzija HotPot modula ponuja tudi sledeče predvajalnike:
: **dew**: mp3 predvajalnik
: **dyer**: mp3 predvajalnik od Bernard Dyer
: **hbs**: mp3 predvajalnik iz Half-Baked
Software
: **image**: vstavi sliko na spletno stran
: **link**: vstavi povezavo na drugo spletno stran

**širina**(opcijsko)
: potrebna širina predvajalnika

**višina**(opcijsko)
: potrebna višina predvajalnika. Če je izpuščena bo ta vrednost nastavljena na isto kot je nastavitev širine.

**možnosti**(opcijsko)
: z vejico ločen seznam, ki bo posredovan predvajalniku. Vsaka možnost je lahko preprosto vključi/izključi stikalo, ali ime vrednostnega para.
: **name=value
: **name="some value with spaces"';
$string['viewreports'] = 'Ogled poročila za {$a} uporabmika/ke';
$string['views'] = 'Ogledi';
$string['weighting'] = 'Utežitev';
$string['wrong'] = 'Napačno';
$string['zeroduration'] = 'Ni trajanja';
$string['zeroscore'] = 'Nič točk';
