<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Dejavnosti';
$string['addcategory'] = 'Dodaj kategorijo';
$string['addcategoryerror'] = 'Ni možno dodati kategorije.';
$string['addexceptionerror'] = 'Prišlo je do napake ob dodajanju izjeme za userid:gradeitem';
$string['addfeedback'] = 'Dodaj odziv';
$string['addgradeletter'] = 'Dodaj oceno ECTS';
$string['addidnumbers'] = 'Dodaj ID številke';
$string['additem'] = 'Dodaj postavko ocene';
$string['addoutcome'] = 'Dodaj izid';
$string['addoutcomeitem'] = 'Dodaj postavko izida';
$string['addscale'] = 'Dodaj lestvico';
$string['aggregateextracreditmean'] = 'Povprečje ocen (z dodatnimi nalogami)';
$string['aggregatemax'] = 'Najvišja ocena';
$string['aggregatemean'] = 'Povprečje ocen';
$string['aggregatemedian'] = 'Mediana ocen';
$string['aggregatemin'] = 'Najnižja ocena';
$string['aggregatemode'] = 'Modus ocen';
$string['aggregateonlygraded'] = 'Združi samo ocene z vrednostjo';
$string['aggregateonlygraded_help'] = '<p>Ocene, ki nimajo določene vrednosti, se obravnavajo bodisi kot najnižje ocene bodisi niso vključene v združevanje.</p>';
$string['aggregateoutcomes'] = 'V združevanje vključi izide';
$string['aggregateoutcomes_help'] = '<p>Vključevanje izidov v združevanje morda ne vodi k želeni skupni oceni, zato imate možnost, da jih izključite.</p>';
$string['aggregatesonly'] = 'Samo združene ocene';
$string['aggregatesubcats'] = 'Združi z vključevanjem podkategorij';
$string['aggregatesubcats_help'] = '<p>Združevanje se ponavadi izvaja samo z neposredno podrejenimi elementi; možno je tudi združevanje ocen vseh podkategorij brez drugih združenih ocen.</p>';
$string['aggregatesum'] = 'Seštevek ocen';
$string['aggregateweightedmean'] = 'Uteženo povprečje ocen';
$string['aggregateweightedmean2'] = 'Enostavno uteženo povprečje ocen';
$string['aggregation'] = 'Združevanje';
$string['aggregationcoef'] = 'Koeficient združevanja';
$string['aggregationcoefextra'] = 'Dodatni kredit';
$string['aggregationcoefextra_help'] = 'Če je agregacija vsota ocen ali navadno uteženo povprečje in je dodatni kredit označen, potem najvišja ocena elementa ni dodana med najvišje ocene kategorije; izhaja iz možnosti doseganja najvišje ocene (ali ocene čez najvišjo, če jo je omogočil administrator spletnega mesta), v kategoriji brez najvišje ocene v vseh ocenjenih elementih.

Če je združevanje povprečje ocen (z dodatnimi krediti) in je dodatni kredit nastavljen na vrednost, večjo od nič, je dodatni kredit faktor, s katerim se ocena pomnoži, preden se doda v skupno oceno z izračunom povprečja.';
$string['aggregationcoefextrasum'] = 'Dodatna naloga';
$string['aggregationcoefextrasum_help'] = '<p>Ko se uporabi strategija združevanja "Seštevek ocen", lahko določena postavka ocene služi kot dodatna naloga v kategoriji. To pomeni, da najvišja ocena te postavke ocene ne bo dodana k najvišji možni oceni kategorije, ocena postavke pa bo. Sledi primer:</p>

<ul>
    <li>Postavka 1 je ocenjena 0-100</li>
    <li>Postavka 2 je ocenjena 0-75</li>
    <li>Postavka 1 ima označeno potrditveno polje "Dodatna naloga", Postavka 2 nima.</li>
    <li>Obe postavki spadata v Kategorijo 1, ki ima izbran "Seštevek ocen" kot svojo strategijo združevanja</li>
    <li>Skupna vrednost Kategorije 1 bo ocenjena 0-75</li>
    <li>Udeleženec je pri Postavki 1 dobil oceno 20, pri Postavki 2 pa oceno 70</li>
    <li>Skupna ocena za udeleženca v Kategoriji 1 bo 75/75 (20+70 = 90, vendar Postavka 1 služi le kot dodatna naloga, zato skupno oceno dvigne na najvišjo možno vrednost)</li>
</ul>';
$string['aggregationcoefextraweight'] = 'Utež dodatnega kredita';
$string['aggregationcoefextraweight_help'] = '<p>Vrednost večja od 0 ocene pri tej postavki ocene med združevanjem ocen obravnava kot dodatno nalogo. Izbrano število je faktor, s katerim se bo vrednost ocene pomnožila pred seštevanjem vsote vseh ocen, vendar sama postavka ne bo štela pri deljenju. Na primer:</p>

<ul>
    <li>Postavka 1 je ocenjena 0-100 in njena vrednost "Dodatna naloga" določena kot 2</li>
    <li>Postavka 2 je ocenjena 0-100 in njena vrednost "Dodatna naloga" ostane 0.0000</li>
    <li>Postavka 3 je ocenjena 0-100 in njena vrednost "Dodatna naloga" ostane 0.0000</li>
    <li>Vse 3 postavke spadajo pod Kategorijo 1, ki ima izbrano strategijo združevanja "Povprečje ocen (z dodatnimi nalogami)"</li>
    <li>Udeleženec dobi pri Postavki 1 oceno 20, 50 pri Postavki 2 in 70 pri Postavki 3</li>
    <li>Skupna vrednost za udeleženca v Kategoriji 1 bo 95/100, ker je 20*2 + (40 + 70)/2 = 95</li>
</ul>';
$string['aggregationcoefweight'] = 'Utež postavke';
$string['aggregationcoefweight_help'] = '<p>Utež, ki se uporabi na vseh ocenah pri tej postavki ocene med združevanjem z drugimi postavkami ocene.</p>';
$string['aggregation_help'] = '<p>Ta meni vam omogoča izbiro strategije združevanja za izračun skupne ocene v tej kategoriji za vsakega udeleženca. Različne možnosti so razložene spodaj.</p>

<p>Ocene so najprej pretvorjene v odstotne vrednosti (interval od 0 do 1, temu se reče normalizacija), nato pa so združene z uporabo ene izmed spodnjih funkcij in na koncu pretvorjene v razpon postavke kategorije (med <em>Najnižjo oceno</em> in <em>Najvišjo oceno</em>).</p>

<p><strong>Pomembno</strong>: Prazna ocena je manjkajoči vnos v redovalnici in lahko predstavlja različne stvari. Na primer, lahko pomeni, da udeleženec še ni opravil naloge, da oddana naloga še ni bila ocenjena s strani izvajalca ali da je bila ocena ročno izbrisana s strani skrbnika redovalnice. Zaradi tega se priporoča previdnost pri interpretaciji teh "praznih ocen" brez vrednosti.</p>

<dl id="grade-aggregation-help">
    <dt>Povprečje ocen</dt>
    <dd>Vsota vseh ocen deljena s skupnim številom vseh ocen.</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, najvišja ocena kategorije 100:<br />
                     <code>(0.7 + 0.25 + 1.0)/3 = 0.65 --> 65/100</code></dd>

    <dt>Uteženo povprečje</dt>
        <dd>Vsaki oceni lahko določite utež, ki se nato uporabi pri združevanju aritmetičnega povprečja za vplivanje na pomembnost posamezne postavke v končnem povprečju.</dd>
        <dd class="example">A1 70/100 utež 10, A2 20/80 utež 5, A3
                         10/10 utež 3, najvišja ocena kategorije 100:<br /><code>(0.7*10 + 0.25*5 + 1.0*3)/18 = 0.625 --> 62.5/100</code></dd>

    <dt>Enostavno uteženo povprečje</dt>
        <dd>Razlika z <em>Uteženim povprečjem</em> je, da se utež za vsako postavko izračuna kot <em>Najvišja ocena</em> - <em>Najnižja ocena</em>. 100 točkovna naloga ima utež 100, 10 točkovna naloga ima utež 10.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, najvišja ocena kategorije 100:<br />
                         <code>(0.7*100 + 0.25*80 + 1.0*10)/190 = 0.526 --> 52.6/100</code></dd>

    <dt>Povprečje ocen (z dodatnimi nalogami)</dt>
        <dd>Aritmetično povprečje s posebnostjo. To je stara, sedaj nepodprta strategija združevanja, ki je tukaj podana samo za zagotavljanje kompatibilnosti s starimi dejavnostmi.</dd>

    <dt>Mediana ocen</dt>
        <dd>Srednja ocena (ali povprečje dveh srednjih ocen), ko so ocene razporejene po velikosti. Prednost v primerjavi s povprečjem je ta, da nanjo ne vplivajo ekstremne vrednosti (ocene, ki so nenavadno daleč od povprečja).</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, najvišja ocena kategorije 100:<br />
                         <code>mediana(0.7 ; 0.25 ; 1.0) = 0.7 --> 70/100</code></dd>

    <dt>Najnižja ocena</dt>
        <dd>Rezultat je najnižja ocena po normalizaciji. To se ponavadi uporablja v kombinaciji z <em>Združi samo ocene z vrednostjo</em>.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, najvišja ocena kategorije 100:<br />
                         <code>min(0.7 ; 0.25 ; 1.0) = 0.25 --> 25/100</code></dd>

    <dt>Najvišja ocena</dt>
        <dd>Rezultat je najvišja ocena po normalizaciji.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, najvišja ocena kategorije 100:<br />
                         <code>max(0.7 ; 0.25 ; 1.0) = 1.0 --> 100/100</code></dd>

    <dt>Modus ocen</dt>
        <dd>Modus je ocena, ki se najpogosteje pojavlja. Pogosteje se to strategijo uporablja za ne-številčne ocene.
                         Prednost v primerjavi s povprečjem je ta, da nanj ne vplivajo ekstremne vrednosti (ocene, ki so nenavadno daleč od povprečja).
                         Vendar ta strategija izgubi svoj pomen v primeru, da je več kot ena pogosto ponavljajoča se ocena (obdrži se samo ena) ali ko so vse ocene različne.</dd>
        <dd class="example">A1 70/100, A2 35/50, A3 20/80, A4 10/10, A5 7/10 najvišja ocena kategorije 100:<br />
                         <code>modus(0.7 ; 0.7 ; 0.25 ; 1.0 ; 0.7) = 0.7 --> 70/100</code></dd>

    <dt>Seštevek ocen</dt>
        <dd>Seštevek (vsota) vseh vrednosti ocen. Lestvice ocen so pri tem prezrte. To je edina vrsta, ki ocene ne izvede interne normalizacije. <em>Najvišja ocena</em> kategorije je samodejno izračunana kot vsota najvišjih vrednostih vseh združenih ocen.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10:<br />
                         <code>70 + 20 + 10 = 100/190</code></dd>
</dl>';
$string['aggregationposition'] = 'Položaj združevanja';
$string['aggregationposition_help'] = '<p>Določa položaj stolpca z združenim seštevkom glede na ocene, ki se združujejo.</p>';
$string['aggregationsvisible'] = 'Agregacijski tipi na voljo';
$string['aggregationsvisiblehelp'] = 'Izberite vse agregacijske tipe, ki morajo biti na voljo. Držite Ctrl tipko, da izberete več predmetov.';
$string['allgrades'] = 'Vse ocene po kategorijah';
$string['allstudents'] = 'Vsi udeleženci';
$string['allusers'] = 'Vsi uporabniki';
$string['autosort'] = 'Samodejno sortiranje';
$string['availableidnumbers'] = 'id številke na voljo';
$string['average'] = 'Povprečje';
$string['averagesdecimalpoints'] = 'Decimalke v povprečjih stolpcev';
$string['averagesdecimalpoints_help'] = '<p>Določa število decimalnih mest za prikaz pri vsakem povprečju stolpca. Če je izbrana možnost Podeduj, se uporabi vrsta prikaza za vsak stolpec.</p>';
$string['averagesdisplaytype'] = 'Vrsta prikaza povprečij stolpcev';
$string['averagesdisplaytype_help'] = '<p>Določa način prikaza povprečja za vsak stolpec. Če je izbrana možnost Podeduj, se uporabi vrsta prikaza za vsak stolpec.</p>';
$string['backupwithoutgradebook'] = 'Varnostna kopija ne vsebuje konfiguracije redovalnice';
$string['badgrade'] = 'Podana ocena je neveljavna';
$string['badlyformattedscale'] = 'Prosimo, vpišite z vejicami ločen seznam vrednosti (vsaj dve obvezni vrednosti).';
$string['baduser'] = 'Podan uporabnik je neveljaven';
$string['bonuspoints'] = 'Dodatne točke';
$string['bulkcheckboxes'] = 'Množična potrditvena polja';
$string['calculatedgrade'] = 'Izračunana ocena';
$string['calculation'] = 'Izračun';
$string['calculationadd'] = 'Dodaj izračun';
$string['calculationedit'] = 'Uredi izračun';
$string['calculation_help'] = 'Izračun ocene je formula, ki se uporablja za določanje ocene. Formula naj se začne z enačajem (=), vključuje lahko običajne matematične operatorje, kot je max, min in sum. Če želite, lahko druge elemente ocene vključite v izračun z vpisom ID številke v dvojnih oglatih oklepajih.';
$string['calculationsaved'] = 'Izračun je shranjen';
$string['calculationview'] = 'Ogled izračuna';
$string['cannotaccessgroup'] = 'Dostop do ocen izbrane skupine ni mogoč.';
$string['categories'] = 'Kategorije';
$string['categoriesanditems'] = 'Kategorije in postavke';
$string['categoriesedit'] = 'Uredi kategorije in postavke';
$string['category'] = 'Kategorija';
$string['categoryedit'] = 'Uredi kategorijo';
$string['categoryname'] = 'Ime kategorije';
$string['categorytotal'] = 'Seštevek kategorije';
$string['categorytotalfull'] = 'skupaj {$a->category}';
$string['categorytotalname'] = 'Skupno ime kategorije';
$string['changedefaults'] = 'Spremeni privzete vrednosti';
$string['changereportdefaults'] = 'Spremeni privzete vrednosti poročila';
$string['chooseaction'] = 'Izberi dejanje ...';
$string['choosecategory'] = 'Izberi kategorijo';
$string['combo'] = 'Zavihki in spustni meni';
$string['compact'] = 'Kompaktno';
$string['contract'] = 'Skrči kategorijo';
$string['controls'] = 'Kontrole';
$string['courseavg'] = 'Povprečje predmeta';
$string['coursegradecategory'] = 'Kategorija ocen predmeta';
$string['coursegradedisplaytype'] = 'Vrsta prikaza ocen v predmetu';
$string['coursegradedisplayupdated'] = 'Vrsta prikaza ocen v predmetu je bila posodobljena.';
$string['coursegradesettings'] = 'Nastavitve ocene predmeta';
$string['coursename'] = 'Ime predmeta';
$string['coursescales'] = 'Lestvice predmeta';
$string['coursesettings'] = 'Nastavitve predmeta';
$string['coursesettingsexplanation'] = 'Nastavitve predmeta določajo, kako se redovalnica prikaže za vse udeležence v predmetu.';
$string['coursetotal'] = 'Seštevek predmeta';
$string['createcategory'] = 'Ustvari kategorijo';
$string['createcategoryerror'] = 'Nove kategorije ni bilo možno ustvariti';
$string['creatinggradebooksettings'] = 'Ustvarjanje nastavitev redovalnice';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Trenutna starševska agregacija';
$string['curveto'] = 'Krivulja do';
$string['decimalpoints'] = 'Število decimalnih mest';
$string['decimalpoints_help'] = '<p>Določa število decimalnih mest za prikaz pri vsaki oceni. Ta nastavitev nima vpliva na izračune ocen, ki se izvajajo z natančnostjo na 5 decimalnih mest.</p>';
$string['default'] = 'Privzeto';
$string['defaultprev'] = 'Privzeto ({$a})';
$string['deletecategory'] = 'Izbriši kategorijo';
$string['disablegradehistory'] = 'Onemogoči zgodovino ocen';
$string['disablegradehistory_help'] = 'Onemogoči beleženje zgodovine sprememb pri ocenah. To lahko malenkostno pohitri strežnik in prihrani prostor v podatkovni zbirki.';
$string['displaylettergrade'] = 'Prikaži ocene ECTS';
$string['displaypercent'] = 'Prikaži odstotke';
$string['displaypoints'] = 'Prikaži točke';
$string['displayweighted'] = 'Prikaži utežene ocene';
$string['dropdown'] = 'Spustni meni';
$string['droplow'] = 'Izpusti najnižje';
$string['droplow_help'] = '<p>Če določena, bo ta možnost izpustila X najnižjih ocen, pri čemer je X izbrana vrednost za to možnost.</p>';
$string['dropped'] = 'Izpuščeno';
$string['dropxlowest'] = 'Izpusti X najnižjih';
$string['dropxlowestwarning'] = 'Opomba: Če uporabite izpustitev x najnižjih, ocenjevanje predvideva, da imajo vse postavke v kategoriji isto vrednost točk. Če se vrednosti točk razlikujejo, bodo rezultati nepredvidljivi';
$string['duplicatescale'] = 'Podvoji lestvico';
$string['edit'] = 'Uredi';
$string['editcalculation'] = 'Uredi izračun';
$string['editcalculationverbose'] = 'Uredi izračun za
{$a->category}
{$a->itemmodule}
{$a->itemname}';
$string['editfeedback'] = 'Uredi odziv';
$string['editgrade'] = 'Uredi oceno';
$string['editgradeletters'] = 'Uredi ocene s črkami';
$string['editoutcome'] = 'Uredi rezultat';
$string['editoutcomes'] = 'Uredi izide';
$string['editscale'] = 'Uredi lestvico';
$string['edittree'] = 'Kategorije in postavke';
$string['editverbose'] = 'Uredi {$a->category}
{$a->itemmodule}
{$a->itemname}';
$string['enableajax'] = 'Omogoči AJAX';
$string['enableajax_help'] = 'Vklop funkcionalnosti AJAX v poročilu ocenjevalca, kar poenostavi in pohitri navadne operacije. Zahteva vklop Javascript-a v uporabnikovem brskalniku.';
$string['enableoutcomes'] = 'Omogoči izide';
$string['enableoutcomes_help'] = 'Podpora za Izide (znani tudi kot Kompetence, Cilji, Standardi in Kriteriji) pomeni, da lahko ocenjujemo z uporabo ene ali več lestvic, ki so povezane z izidi. Vklop izidov omogoči to posebno vrsto ocenjevanja za celotno stran.';
$string['encoding'] = 'Kodiranje';
$string['errorcalculationnoequal'] = 'Formula se mora začeti z znakom je enako (=1+2)';
$string['errorcalculationunknown'] = 'Neveljavna formula';
$string['errorgradevaluenonnumeric'] = 'Prejeta neštevilčna vrednost za nizko ali visoko oceno za';
$string['errornocalculationallowed'] = 'Izračuni za to postavko niso na voljo';
$string['errornocategorisedid'] = 'Ni moč pridobiti nekategoriziranega id!';
$string['errornocourse'] = 'Ni moč pridobiti informacij o predmetu';
$string['errorreprintheadersnonnumeric'] = 'Prejeta neštevilčna vrednost za ponovni prikaz glave';
$string['errorsavegrade'] = 'Ocene ni bilo mogoče shraniti.';
$string['excluded'] = 'Izključeno';
$string['excluded_help'] = '<p>Če je -Izključeno- omogočeno, bo ta ocena izključena iz kakršnegakoli združevanja s strani nadrejene postavke ocene ali kategorije.</p>';
$string['expand'] = 'Razširi kategorijo';
$string['export'] = 'Izvozi';
$string['exportalloutcomes'] = 'Izvozi vse izide';
$string['exportfeedback'] = 'V izvoz vključi odzive';
$string['exportonlyactive'] = 'Izključi začasno onemogočene uporabnike';
$string['exportonlyactive_help'] = 'Upoštevaj le tiste uporabnike, ki so vpisani in aktivirrani in ne začasno onemogočeni.';
$string['exportplugins'] = 'Vtičniki za izvoz';
$string['exportsettings'] = 'Nastavitve izvoza';
$string['exportto'] = 'Izvozi v';
$string['extracreditwarning'] = 'Opomba: Nastavitev vseh postavk kategorije kot dodatne naloge jih bo učinkovito odstranila iz izračuna ocen. Skupnega števila točk namreč ne bo';
$string['feedback'] = 'Odziv';
$string['feedbackadd'] = 'Dodaj odziv';
$string['feedbackedit'] = 'Uredi odziv';
$string['feedbackforgradeitems'] = 'Odziv za {$a}';
$string['feedback_help'] = '<p>Opombe, ki jih izvajalec doda oceni. Opombe lahko vključujejo obsežne, osebne odzive ali enostavne kode, ki se nanašajo na interen sistem odzivov.</p>';
$string['feedbacks'] = 'Odzivi';
$string['feedbacksaved'] = 'Odziv shranjen';
$string['feedbackview'] = 'Ogled odzivov';
$string['finalgrade'] = 'Končna ocena';
$string['finalgrade_help'] = '<p>Končna ocena (shranjena v predpomnilniku) po vseh izračunih.</p>';
$string['fixedstudents'] = 'Statični stolpec udeležencev';
$string['fixedstudents_help'] = 'Dovoljuje vodoravni pomik ocen, ne da bi pri tem izgubili pogled na stolpec udeležencev, ki je postavljen statično.';
$string['forceoff'] = 'Vsili: Izključeno';
$string['forceon'] = 'Vsili: Vključeno';
$string['forelementtypes'] = 'za izbrane {$a}';
$string['forstudents'] = 'Za udeležence';
$string['full'] = 'Polno';
$string['fullmode'] = 'Poln pogled';
$string['fullview'] = 'Polni pogled';
$string['generalsettings'] = 'Splošne nastavitve';
$string['grade'] = 'Ocena';
$string['gradeadministration'] = 'Skrbništvo ocen';
$string['gradeanalysis'] = 'Analiza ocen';
$string['gradebook'] = 'Redovalnica';
$string['gradebookhiddenerror'] = 'Redovalnica je trenutno nastavljena tako, da vse skrije pred udeleženci.';
$string['gradebookhistories'] = 'Zgodovina ocen';
$string['gradeboundary'] = 'Omejitev črkovne ocene';
$string['gradeboundary_help'] = '<p>Nad to mejo bo odstotkom dodeljena črkovna ocena (če se uporablja vrsta ocen ECTS).</p>';
$string['gradecategories'] = 'Kategorije ocen';
$string['gradecategory'] = 'Kategorija ocen';
$string['gradecategoryonmodform'] = 'Kategorija ocen';
$string['gradecategoryonmodform_help'] = 'Ta nastavitev določa kategorijo, v katero se umestijo ocene te dejavnosti v redovalnici.';
$string['gradecategorysettings'] = 'Nastavitve kategorije ocen';
$string['gradedisplay'] = 'Prikaz ocen';
$string['gradedisplaytype'] = 'Način prikaza ocen';
$string['gradedisplaytype_help'] = '<p>Določa način prikaza ocen v poročilih ocenjevalca in uporabnikov. Ocene se lahko prikažejo kot prave ocene, kot odstotki (v razmerju z najnižjo in najvišjo oceno) ali kot črke.</p>';
$string['gradedon'] = 'Ocenjeno: {$a}';
$string['gradeexport'] = 'Izvoz ocen';
$string['gradeexportcustomprofilefields'] = 'Polja prilagojenega profila za izvoz ocen';
$string['gradeexportcustomprofilefields_desc'] = 'Pri izvozu ocen vključi ta polja prilagojenega profila in jih loči z vejico.';
$string['gradeexportdecimalpoints'] = 'Decimalna mesta ocen pri izvozu';
$string['gradeexportdecimalpoints_desc'] = 'Število decimalnih mest za prikaz med izvozom. To je mogoče povoziti med izvozom.';
$string['gradeexportdisplaytype'] = 'Vrsta prikaza ocen pri izvozu';
$string['gradeexportdisplaytype_desc'] = 'Med izvozom so lahko ocene prikazane kot prave ocene, kot odstotki (v razmerju z najnižjo in najvišjo oceno) ali kot črke (A, B, C itd.). To je mogoče povoziti med izvozom.';
$string['gradeexportuserprofilefields'] = 'Polja uporabniškega profila pri izvozu ocen';
$string['gradeexportuserprofilefields_desc'] = 'Pri izvozu ocen vključi ta polja uporabniškega profila in jih loči z vejico.';
$string['gradehelp'] = 'Pomoč za ocene';
$string['gradehistorylifetime'] = 'Življenjska doba zgodovine ocen';
$string['gradehistorylifetime_help'] = 'To določa kako dolgo želite obdržati zgodovino sprememb pri ocenah. Priporočeno je, da je ta čas kar se da dolg. Če imate težave z zmogljivostjo ali imate omejen prostor v podatkovni zbirki, nastavite nižjo vrednosti.';
$string['gradeimport'] = 'Uvoz ocen';
$string['gradeitem'] = 'Postavka ocene';
$string['gradeitemaddusers'] = 'Izključi iz ocenjevanja';
$string['gradeitemadvanced'] = 'Napredne možnosti za postavko ocene';
$string['gradeitemadvanced_help'] = 'Izberite vse elemente, ki bodo označeni kot napredni pri urejanju postavk ocene.';
$string['gradeitemislocked'] = 'Ta dejavnost je zaklenjena v redovalnici. Spremembe, ki se določijo ocenam v tej dejavnosti, se ne bodo preslikale v redovalnico dokler je dejavnost zaklenjena.';
$string['gradeitemlocked'] = 'Ocenjevanje je zaklenjeno';
$string['gradeitemmembersselected'] = 'Izključeno iz ocenjevanja';
$string['gradeitemnonmembers'] = 'Vključeno v ocenjevanje';
$string['gradeitemremovemembers'] = 'Vključi v ocenjevanje';
$string['gradeitems'] = 'Postavke ocene';
$string['gradeitemsettings'] = 'Nastavitve postavke ocene';
$string['gradeitemsinc'] = 'Postavke ocene za vključitev';
$string['gradeletter'] = 'Ocena ECTS';
$string['gradeletter_help'] = '<p>Črka ali drug simbol za predstavitev razpona ocen.</p>';
$string['gradeletternote'] = 'Za brisanje ocene ECTS samo izpraznite poljubno<br /> izmed treh področij besedila za črko in kliknite oddaj.';
$string['gradeletters'] = 'Črke za ocenjevanje';
$string['gradelocked'] = 'Ocena je zaklenjena';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Najvišja ocena';
$string['grademax_help'] = '<p>Pri uporabi ocene z vrednostjo, se lahko tu določi najvišja ocena. Najvišja ocena za postavko ocene pri dejavnosti se določi pri posodabljanju posamezne dejavnosti.</p>';
$string['grademin'] = 'Najnižja ocena';
$string['grademin_help'] = '<p>Pri uporabi ocene z vrednostjo, se lahko tu določi najnižja ocena.</p>';
$string['gradeoutcomeitem'] = 'Postavka izida ocene';
$string['gradeoutcomes'] = 'Izidi';
$string['gradeoutcomescourses'] = 'Izidi predmeta';
$string['gradepass'] = 'Ocena za uspešno opravljanje';
$string['gradepass_help'] = '<p>Če ima postavka oceno, ki jo morajo udeleženci doseči ali preseči za uspešno opravljanje določene postavke, lahko to oceno določite tukaj.</p>';
$string['gradepreferences'] = 'Nastavitve ocen';
$string['gradepreferenceshelp'] = 'Pomoč pri nastavitvi ocen';
$string['gradepublishing'] = 'Omogoči objavljanje';
$string['gradepublishing_help'] = 'Omogoči objavo izvozov in uvozov: Izvožene ocene so lahko dostopne preko URL-ja brez potrebe po prijavi v Moodle. Ocene se lahko uvozi z dostopom do tovrstnega URL-ja (kar pomeni, da lahko Moodle stran uvozi ocene, ki jih objavi druga stran). Privzeto lahko le skrbniki uporabljajo to funkcijo; pred dodajanjem zahtevanih zmožnosti drugim vlogam poskrbite za ustrezno izobrazbo uporabnikov (nevarnosti deljenja zaznamkov, omejitve intelektualne lastnine ipd.).';
$string['gradereport'] = 'Poročilo z ocenami';
$string['graderreport'] = 'Poročilo ocenjevalca';
$string['grades'] = 'Ocene';
$string['gradesforuser'] = 'Ocene za {a$->user}';
$string['gradesonly'] = 'Samo ocene';
$string['gradessettings'] = 'Nastavitve ocene';
$string['gradetype'] = 'Tip ocene';
$string['gradetype_help'] = '<p>Določa tip ocene: brez (ocenjevanje ni možno), vrednost (omogoča določanje najvišje in najnižje ocene), lestvica (omogoča nastavitev lestvice) ali besedilo (samo odziv). Samo ocene z vrednostjo ali lestvico je možno združevati. Tip ocene za postavko ocene, ki temelji na dejavnosti, se določi pri posodabljanju posamezne dejavnosti.</p>';
$string['gradeview'] = 'Ogled Ocene';
$string['gradeweighthelp'] = 'Pomoč pri uteženih ocenah';
$string['groupavg'] = 'Povprečje skupine';
$string['hidden'] = 'Skrito';
$string['hiddenasdate'] = 'Prikaži datum oddaje za skrite ocene';
$string['hiddenasdate_help'] = 'Če uporabnik ne more videti skritih ocen, pokaži datum oddaje namesto\'-\'.';
$string['hidden_help'] = 'Če je označeno, so ocene skrite pred udeleženci. Lahko izberete skrito do datuma, če želite ocene prikazati po tistem, ko je ocenjevanje končano.';
$string['hiddenuntil'] = 'Skrito do';
$string['hiddenuntildate'] = 'Skrito do: {$a}';
$string['hideadvanced'] = 'Skrij dodatne možnosti';
$string['hideaverages'] = 'Skrij povprečja';
$string['hidecalculations'] = 'Skrij izračune';
$string['hidecategory'] = 'Skrito';
$string['hideeyecons'] = 'Skrij ikono prikaži/skrij';
$string['hidefeedback'] = 'Skrij odzive';
$string['hideforcedsettings'] = 'Skrij vsiljene nastavitve';
$string['hideforcedsettings_help'] = 'Ne prikaži vsiljenih nastavitev v ocenjevalnem uporabniškem vmesniku.';
$string['hidegroups'] = 'Skrij skupine';
$string['hidelocks'] = 'Skrij zaklenjeno';
$string['hidenooutcomes'] = 'Prikaži izide';
$string['hidequickfeedback'] = 'Skrij Hitre odzive';
$string['hideranges'] = 'Skrij razpone';
$string['hidetotalifhiddenitems'] = 'Skrij skupne ocene, če vsebujejo skrite elemente';
$string['hidetotalifhiddenitems_help'] = 'Ta nastavitev določa, ali so končne ocene, ki vsebujejo skrite ocene, prikazane udeležencem ali pa so nadomeščene z vezajem (-). Če so prikazane, je lahko skupni izračun bodisi brez bodisi s skritimi ocenami.

Če so skrite ocene izključene, bo skupna ocena drugačna  od tiste, ki jo učitelj vidi v poročilu ocen, saj učitelj vedno vidi skupne ocene, izračunane na podlagi vseh elementov, skritih ali prikazanih. Če so vključene skrite ocene, obstaja možnost, da lahko udeleženci izračunajo skrite ocene.';
$string['hidetotalshowexhiddenitems'] = 'Prikaži skupne ocene brez skritih ocen';
$string['hidetotalshowinchiddenitems'] = 'Prikaži skupne ocene s skritimi ocenami';
$string['hideverbose'] = 'Skrij {$a->category}
{$a->itemmodule}
{$a->itemname}';
$string['highgradeascending'] = 'Razvrsti po visokih ocenah naraščajoče';
$string['highgradedescending'] = 'Razvrsti po visokih ocenah padajoče';
$string['highgradeletter'] = 'Visoko';
$string['identifier'] = 'Identificiraj uporabnika po';
$string['idnumbers'] = 'ID številke';
$string['import'] = 'Uvozi';
$string['importcsv'] = 'Uvozi CSV';
$string['importcustom'] = 'Uvozi kot izide po meri (samo za ta predmet)';
$string['importerror'] = 'Prišlo je do napake, ta skripta ni bila klicana z ustreznimi parametri.';
$string['importfailed'] = 'Neuspešen uvoz';
$string['importfeedback'] = 'Uvozi odziv';
$string['importfile'] = 'Uvozi datoteko';
$string['importfilemissing'] = 'Ni bilo prejete datoteke; pojdite nazaj na obrazec in uvozite veljavno datoteko.';
$string['importfrom'] = 'Uvozi iz';
$string['importoutcomenofile'] = 'Prenešena datoteka je prazna ali pokvarjena. Prosimo, preverite datoteko. Problem je bil zaznan v vrstici {$a}; vrstica nima toliko stolpcev kot prva vrstica ali pa v datoteki manjka pričakovana glava. Oglejte si izvoženo datoteko za primer datoteke s primerno glavo.';
$string['importoutcomes'] = 'Uvozi izide';
$string['importoutcomes_help'] = 'Izide je mogoče uvoziti prek datoteke csv v obliki, ki je enaka obliki izvoženih izidov.';
$string['importoutcomesuccess'] = 'Uvožen izid "{$a->name}" z ID-jem #{$a->id}';
$string['importplugins'] = 'Vtičniki za uvoz';
$string['importpreview'] = 'Predogled uvoza';
$string['importsettings'] = 'Nastavitve uvoza';
$string['importskippednomanagescale'] = 'Nimate dovoljenja za dodajanje nove lestvice, zato je bil izid "{$a}" preskočen, saj zahteva ustvarjanje nove lestvice.';
$string['importskippedoutcome'] = 'Izid s kratkim imenom "{$a}" že obstaja v tem kontekstu, zato je bila ena izmed uvoženih datotek preskočena.';
$string['importstandard'] = 'Uvozi kot standardne izide';
$string['importsuccess'] = 'Uspešen uvoz ocen';
$string['importxml'] = 'Uvozi XML';
$string['includescalesinaggregation'] = 'V združevanje vključi lestvice';
$string['includescalesinaggregation_help'] = 'Lahko spremenite, ali naj se lestvice vključijo kot številke v vseh združenih ocenah v vseh redovalnicah, v vseh predmetih. OPOZORILO: sprememba te nastavitve bo prisilila vse združene ocene k ponovnem izračunu.';
$string['incorrectcourseid'] = 'ID predmeta je bil napačen';
$string['incorrectcustomscale'] = '(Nepravilna lestvica po meri, prosimo spremenite.)';
$string['incorrectminmax'] = 'Minimum mora biti nižji od maksimuma';
$string['inherit'] = 'Podeduj';
$string['item'] = 'Postavka';
$string['iteminfo'] = 'Informacije o postavki';
$string['iteminfo_help'] = '<p>Prostor za vnos informacije o postavki. Besedilo se ne pojavi nikjer drugje.</p>';
$string['itemname'] = 'Ime postavke';
$string['itemnamehelp'] = 'Ime postavke, ki ga je določil modul.';
$string['items'] = 'Postavke';
$string['itemsedit'] = 'Uredi postavko ocene';
$string['keephigh'] = 'Obdrži najvišje';
$string['keephigh_help'] = 'Če določena, bo ta možnost obdržala le X najvišjih ocen, pri čemer je X izbrana vrednost za to možnost.';
$string['keymanager'] = 'Upravljavec ključa';
$string['lessthanmin'] = 'Vnesena ocena za {$a->itemname} pri uporabniku {$a->username} ne dosega najnižje dovoljene vrednosti';
$string['letter'] = 'Črka';
$string['lettergrade'] = 'Ocena ECTS';
$string['lettergradenonnumber'] = 'Nizka in/ali Visoka ocena sta bili neštevilčni za';
$string['letterpercentage'] = 'Črka (odstotek)';
$string['letterreal'] = 'Črka (prava)';
$string['letters'] = 'Črke';
$string['linkedactivity'] = 'Povezana dejavnost';
$string['linkedactivity_help'] = '<p>Določa neobvezno dejavnost, ki je povezana s to postavko izida. To se uporablja za merjenje uspeha udeležencev na podlagi kriterijev, ki niso ovrednoteni z oceno dejavnosti.</p>';
$string['linktoactivity'] = 'Povezava do {$a->name} dejavnosti';
$string['lock'] = 'Zakleni';
$string['locked'] = 'Zaklenjeno';
$string['locked_help'] = 'Če je označeno, ocene povezanih dejavnosti ne bodo več samodejno posodobljene.';
$string['locktime'] = 'Zakleni po';
$string['locktimedate'] = 'Zaklenjeno po: {$a}';
$string['lockverbose'] = 'Zakleni {$a->category}
{$a->itemmodule}
{$a->itemname}';
$string['lowest'] = 'Najnižja';
$string['lowgradeletter'] = 'Nizka';
$string['manualitem'] = 'Ročna postavka';
$string['mapfrom'] = 'Preslikaj iz';
$string['mappings'] = 'Preslikave postavk ocen';
$string['mapto'] = 'Preslikaj v';
$string['max'] = 'Najvišja';
$string['maxgrade'] = 'Najvišja ocena';
$string['meanall'] = 'Vse ocene';
$string['meangraded'] = 'Ocene z vrednostjo';
$string['meanselection'] = 'Izbrane ocene za povprečja stolpcev';
$string['meanselection_help'] = 'Ali naj se celice brez ocen vključijo v izračun povprečja za vsak stolpec.';
$string['median'] = 'Mediana';
$string['min'] = 'Najnižja';
$string['missingscale'] = 'Izbrana mora biti lestvica';
$string['mode'] = 'Modus';
$string['morethanmax'] = 'Vnesena ocena za {$a->itemname} pri uporabniku {$a->username} presega najvišjo dovoljeno vrednost';
$string['moveselectedto'] = 'Premakni izbrane predmete v';
$string['movingelement'] = 'Premikanje {$a}';
$string['multfactor'] = 'Večkratnik';
$string['multfactor_help'] = '<p>Faktor, s katerim bodo zmnožene vse ocene v tej postavki ocene, z najvišjo vrednostjo enako najvišji oceni.</p>';
$string['mypreferences'] = 'Moje izbire';
$string['myreportpreferences'] = 'Moje nastavitve poročila';
$string['navmethod'] = 'Metoda navigacije';
$string['neverdeletehistory'] = 'Nikoli ne izbriši zgodovine';
$string['newcategory'] = 'Nova kategorija';
$string['newitem'] = 'Nov element ocene';
$string['newoutcomeitem'] = 'Nov element izida';
$string['no'] = 'Ne';
$string['nocategories'] = 'Kategorije ocen ni možno dodati ali najti za ta predmet';
$string['nocategoryname'] = 'Ni bilo podanega imena kategorije.';
$string['nocategoryview'] = 'Ni kategorije za pregled';
$string['nocourses'] = 'Ni še predmetov';
$string['noforce'] = 'Ne vsili';
$string['nogradeletters'] = 'Ni nastavljenih ocen ECTS';
$string['nogradesreturned'] = 'Ni vrnjenih ocen';
$string['noidnumber'] = 'Ni ID številke';
$string['nolettergrade'] = 'Ni ocene ECTS za';
$string['nomode'] = 'BREZ';
$string['nonnumericweight'] = 'Prejeta neštevilčna vrednost za';
$string['nonunlockableverbose'] = 'Te ocene ni moč odkleniti dokler je postavka {$a->itemname} zaklenjena.';
$string['nonweightedpct'] = 'ne utežen %';
$string['nooutcome'] = 'Ni izida';
$string['nooutcomes'] = 'Postavke izida morajo biti povezane z izidom predmeta, vendar v tem predmetu ni izidov. Ali želite dodati izid?';
$string['nopublish'] = 'Ne objavi';
$string['norolesdefined'] = 'Ni določenih vlog v Skrbništvo > Ocene > Splošne nastavitve > Ocenjene vloge';
$string['noscales'] = 'Izidi morajo biti povezani z lestvico predmeta ali globalno lestvico, vendar ni nobenih lestvic. Ali želite dodati lestvico?';
$string['noselectedcategories'] = 'ni izbranih kategorij.';
$string['noselecteditems'] = 'ni izbranih postavk.';
$string['notteachererror'] = 'Za uporabo te možnosti morate biti izvajalec.';
$string['numberofgrades'] = 'Število ocen';
$string['onascaleof'] = 'na lestvico od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operacije';
$string['options'] = 'Možnosti';
$string['outcome'] = 'Izid';
$string['outcomeassigntocourse'] = 'Dodeli drug izid temu predmetu';
$string['outcomecategory'] = 'Ustvari izide v kategoriji';
$string['outcomecategorynew'] = 'Nova kategorija';
$string['outcomeconfirmdelete'] = 'Ali ste prepričani, da želite izbrisati izid "{$a}"?';
$string['outcomecreate'] = 'Dodaj nov izid';
$string['outcomedelete'] = 'Izbriši izid';
$string['outcomefullname'] = 'Polno ime';
$string['outcome_help'] = 'Določa Izid, ki ga bo ta postavka ocene določala v redovalnici. Na voljo so samo izidi, ki so povezani s tem predmetom ali s celotno stranjo.';
$string['outcomeitem'] = 'Postavka izida';
$string['outcomeitemsedit'] = 'Uredi postavko izida';
$string['outcomereport'] = 'Poročilo izida';
$string['outcomes'] = 'Učni izidi';
$string['outcomescourse'] = 'Izidi v predmetu';
$string['outcomescoursecustom'] = 'Po meri v uporabi (ni moč odstraniti)';
$string['outcomescoursenotused'] = 'Standardni niso v uporabi';
$string['outcomescourseused'] = 'Standardni v uporabi (ni moč odstraniti)';
$string['outcomescustom'] = 'Izidi po meri';
$string['outcomeshortname'] = 'Kratko ime';
$string['outcomesstandard'] = 'Standardni izidi';
$string['outcomesstandardavailable'] = 'Standardni izidi na voljo';
$string['outcomestandard'] = 'Standardni izid';
$string['outcomestandard_help'] = '<p>Standardni izid je na voljo za celotno stran, za vse predmete.</p>';
$string['overallaverage'] = 'Celotno povprečje';
$string['overridden'] = 'Povoženo';
$string['overridden_help'] = '<p>Ko je vključena, oznaka povoženo onemogoči vse prihodnje poskuse za samodejno prilagajanje vrednosti ocene. Ta oznaka je pogosto interno določena v redovalnici, vendar jo je moč vključiti ali izključiti z uporabo tega elementa obrazca.</p>';
$string['overriddennotice'] = 'Končna ocena za to dejavnost je bila ročno prilagojena.';
$string['overridesitedefaultgradedisplaytype'] = 'Povozi privzete nastavite strani';
$string['overridesitedefaultgradedisplaytype_help'] = '<p>Označite to potrditveno polje, če želite omogočiti povozitve privzetih vrednosti strani za prikaz ocen v tej redovalnici. To aktivira elemente obrazca, ki vam omogočijo določanje ocen ECTS in omejitev po vaši izbiri.</p>';
$string['parentcategory'] = 'Nadrejena kategorija';
$string['pctoftotalgrade'] = '% od skupne ocene';
$string['percent'] = 'Odstotek';
$string['percentage'] = 'Odstotek';
$string['percentageletter'] = 'Odstotek (črka)';
$string['percentagereal'] = 'Odstotek (pravi)';
$string['percentascending'] = 'Razvrsti po odstotkih naraščajoče';
$string['percentdescending'] = 'Razvrsti po odstotkih padajoče';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Odmik';
$string['plusfactor_help'] = '<p>Število, ki bo prišteto vsaki oceni za to postavko ocen po množenju z večkratnikom.</p>';
$string['points'] = 'točke';
$string['pointsascending'] = 'Razvrsti po točkah naraščajoče';
$string['pointsdescending'] = 'Razvrsti po točkah padajoče';
$string['positionfirst'] = 'Prvi';
$string['positionlast'] = 'Zadnji';
$string['preferences'] = 'Nastavitve';
$string['prefgeneral'] = 'Splošno';
$string['prefletters'] = 'Ocene ECTS in omejitve';
$string['prefrows'] = 'Posebne vrstice';
$string['prefshow'] = 'Prikaži/skrij kontrole';
$string['previewrows'] = 'Predogled vrstic';
$string['profilereport'] = 'Poročilo uporabniškega profila';
$string['profilereport_help'] = 'Poročilo za ocene, ki se uporabi na profilu uporabnika.';
$string['publishing'] = 'Objavljanje';
$string['quickfeedback'] = 'Hiter odziv';
$string['quickgrading'] = 'Hitro ocenjevanje';
$string['quickgrading_help'] = '<p>Hitro ocenjevanje doda vnosni element za besedilo pri vsaki celici ocene v poročilu ocenjevalca, kar vam omogoči, da uredite več ocen hkrati. Nato lahko kliknete na gumb Posodobi za shranjevanje več sprememb hkrati namesto tega, da posodabljate vsako oceno posamično.</p>';
$string['range'] = 'Razpon';
$string['rangedecimals'] = 'Razpon decimalna mesta';
$string['rangedecimals_help'] = 'Število decimalnih mest za prikaz v razponu.';
$string['rangesdecimalpoints'] = 'Decimalke v razponih';
$string['rangesdecimalpoints_help'] = '<p>Določa število decimalnih mest za prikaz za vsak razpon. To nastavitev je možno povoziti pri vsaki postavki ocene.</p>';
$string['rangesdisplaytype'] = 'Vrsta prikaza razpona';
$string['rangesdisplaytype_help'] = '<p>Določa način prikaza razponov. Če je izbrana možnost Podeduj, se uporabi vrsta prikaza za vsak stolpec.</p>';
$string['rank'] = 'Rang';
$string['rawpct'] = 'Čisti %';
$string['real'] = 'Prave';
$string['realletter'] = 'Prave (črka)';
$string['realpercentage'] = 'Prave (odstotek)';
$string['recovergradesdefault'] = 'Ponastavi ocene';
$string['recovergradesdefault_help'] = 'Privzeto obnovi prejšnje ocene udeleženca, ko se ta ponovno vpiše v predmet.';
$string['regradeanyway'] = 'Vseeno ponovno oceni';
$string['removeallcoursegrades'] = 'Izbriši vse ocene';
$string['removeallcourseitems'] = 'Izbriši vse postavke in kategorije';
$string['report'] = 'Poročilo';
$string['reportdefault'] = 'Privzeta vrednost poročila ({$a})';
$string['reportplugins'] = 'Vtičniki za poročilo';
$string['reportsettings'] = 'Nastavitve poročila';
$string['reprintheaders'] = 'Ponovni prikaz glave';
$string['respectingcurrentdata'] = 'puščam nespremenjeno trenutno konfiguracijo';
$string['rowpreviewnum'] = 'Predogled vrstic';
$string['savechanges'] = 'Shrani spremembe';
$string['savepreferences'] = 'Shrani izbire';
$string['scaleconfirmdelete'] = 'Ste prepričani, da želite izbrisati lestvico "{$a}"?';
$string['scaledpct'] = '% v razmerju';
$string['seeallcoursegrades'] = 'Ogled vseh ocen predmeta';
$string['select'] = 'Izberite {$a}';
$string['selectalloroneuser'] = 'Izberi vse ali enega uporabnika';
$string['selectauser'] = 'Izberi uporabnika';
$string['selectdestination'] = 'Izberite cilj za {$a}';
$string['separator'] = 'Ločilo';
$string['sepcolon'] = 'Dvopičje';
$string['sepcomma'] = 'Vejica';
$string['sepsemicolon'] = 'Podpičje';
$string['septab'] = 'Zavihek';
$string['setcategories'] = 'Nastavi kategorije';
$string['setcategorieserror'] = 'Najprej morate nastaviti kategorije za vaš predmet, preden jih lahko utežite.';
$string['setgradeletters'] = 'Nastavi ocene ECTS';
$string['setpreferences'] = 'Nastavi lastnosti';
$string['setting'] = 'Nastavitev';
$string['settings'] = 'Nastavitve';
$string['setweights'] = 'Nastavi uteži';
$string['showactivityicons'] = 'Prikaži ikone dejavnosti';
$string['showactivityicons_help'] = '<p>Ali naj zraven imen dejavnosti prikažejo ikone dejavnosti.</p>';
$string['showallhidden'] = 'Prikaži skrito';
$string['showallstudents'] = 'Prikaži vse udeležence';
$string['showanalysisicon'] = 'Prikaži ikono za analizo ocen';
$string['showanalysisicon_desc'] = 'Ali naj se ikona privzeto prikaže? Če jo aktivnost podpira, se ikona za analizo ocen poveže s stranjo z natančnejšo razlago ocene in kako je bila pridobljena.';
$string['showanalysisicon_help'] = 'Če jo aktivnost podpira, se ikona za analizo ocen poveže s stranjo z natančnejšo razlago ocene in kako je bila pridobljena.';
$string['showaverage'] = 'Prikaži povprečje';
$string['showaverage_help'] = 'Prikažem stolpec povprečja? Udeleženci bodo lahko predvideli ocene drugih udeležencev, če je povprečje izračunano iz majhnega števila ocen. Zaradi zmogljivostnih razlogov je povprečje približno, če je odvisno od skritih ocen.';
$string['showaverages'] = 'Prikaži povprečje stolpcev';
$string['showaverages_help'] = 'Ali naj se prikaže povprečje za vsak stolpec.';
$string['showcalculations'] = 'Prikaži izračune';
$string['showcalculations_help'] = 'Ali naj se pri vsaki postavki in kategoriji ocen prikažejo ikone za izračun, zaslonski namigi pri izračunanih postavkah in vizualni indikator tega, da je stolpec izračunan.';
$string['showeyecons'] = 'Prikaži ikone prikaži/skrij';
$string['showeyecons_help'] = 'Ali naj se prikaže ikona pokaži/skrij pri vsaki oceni (kar nastavlja vidnost ocene za uporabnika).';
$string['showfeedback'] = 'Prikaži odziv';
$string['showfeedback_help'] = 'Prikažem stolpec odzivov?';
$string['showgrade'] = 'Prikaži ocene';
$string['showgrade_help'] = 'Prikažem stolpec ocen?';
$string['showgroups'] = 'Prikaži skupine';
$string['showhiddenitems'] = 'Pokaži skrite postavke';
$string['showhiddenitems_help'] = 'Ali so skrite ocene popolnoma skrite ali so imena skritih ocen vidna udeležencem.

* Prikaži skrite - imena skritih ocen so prikazana, ocene so skrite

* Samo skrite do - Ocene z nastavitvijo "skrij do" so skrite popolnoma do nastavljenega datuma, po tem datumu pa so vse ocene prikazane

* Ne prikaži - Skrite ocene so popolnoma skrite';
$string['showhiddenuntilonly'] = 'Skrit do';
$string['showlettergrade'] = 'Prikaži ocene s črkami';
$string['showlettergrade_help'] = 'Prikažem stolpec z ocenami s črkami?';
$string['showlocks'] = 'Prikaži zaklepanje';
$string['showlocks_help'] = 'Ali naj se prikaže ikona zakleni/odkleni pri vsaki oceni.';
$string['shownohidden'] = 'Ne prikaži';
$string['shownooutcomes'] = 'Skrij izide';
$string['shownumberofgrades'] = 'Prikaži število ocen v povprečjih';
$string['shownumberofgrades_help'] = 'Ali naj se v oklepaju za vsakim povprečjem prikaže število ocen, ki je bilo uporabljeno pri izračunu povprečja, npr. 45 (34).';
$string['showonlyactiveenrol'] = 'Prikaži samo aktivne vpisane uporabnike';
$string['showonlyactiveenrol_help'] = 'Določa ali naj bodo v poročilu redovalnice prikazani samo aktivni vpisani uporabniki. Če je možnost vključena izpisani uporabniki ne bodo vidni v redovalnici.';
$string['showpercentage'] = 'Prikaži odstotek';
$string['showpercentage_help'] = 'Prikažem odstotna vrednost za vsak element ocene?';
$string['showquickfeedback'] = 'Prikaži hiter odziv';
$string['showquickfeedback_help'] = 'Hiter odziv doda vnosni element za besedilo pri vsaki celici ocene v poročilu ocenjevalca, kar vam omogoči, da uredite odzive za več ocen hkrati. Nato lahko kliknete na gumb Posodobi za shranjevanje več sprememb hkrati namesto tega, da posodabljate vsak odziv posamično.';
$string['showrange'] = 'Prikaži območja';
$string['showrange_help'] = 'Prikažem stolpec z območji?';
$string['showranges'] = 'Prikaži razpone';
$string['showranges_help'] = 'Ali naj se v dodatni vrstici prikaže razpon ocen za vsak stolpec.';
$string['showrank'] = 'Prikaži rang';
$string['showrank_help'] = 'Prikažem položaj udeleženca v primerjavi z preostalimi udeleženci za vsak element ocene?';
$string['showuserimage'] = 'Prikaži slike uporabniških profilov';
$string['showuserimage_help'] = 'Ali naj se slika uporabnika prikaže zraven ocena v poročilu ocenjevalca.';
$string['showverbose'] = 'Prikaži {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Prikaži uteževanje';
$string['showweight_help'] = 'Prikažem stolpec uteži ocene?';
$string['simpleview'] = 'Enostaven pogled';
$string['sitewide'] = 'Za celotno stran';
$string['sort'] = 'razvrsti';
$string['sortasc'] = 'Razvrsti naraščajoče';
$string['sortbyfirstname'] = 'Razvrsti po imenu';
$string['sortbylastname'] = 'Razvrsti po priimku';
$string['sortdesc'] = 'Razvrsti padajoče';
$string['standarddeviation'] = 'Standardni odklon';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Udeleženec';
$string['studentsperpage'] = 'Udeležencev na stran';
$string['studentsperpage_help'] = 'Število udeležencev za prikaz na stran v poročilu ocenjevalca.';
$string['subcategory'] = 'Normalna kategorija';
$string['submissions'] = 'Oddaje';
$string['submittedon'] = 'Oddano: {$a}';
$string['tabs'] = 'Zavihki';
$string['topcategory'] = 'Super kategorija';
$string['total'] = 'Skupno';
$string['totalweight100'] = 'Skupna utež je enaka 100';
$string['totalweightnot100'] = 'Skupna utež ni enaka 100';
$string['turnfeedbackoff'] = 'Izključi odzive';
$string['turnfeedbackon'] = 'Vključi odzive';
$string['typenone'] = 'Brez';
$string['typescale'] = 'Lestvica';
$string['typescale_help'] = '<p>Pri uporabi lestvice za oceno, je možno izbrati lestvico. Lestvico za postavko ocene, ki je vezana na dejavnost, se izbere pri posodabljanju posamezne dejavnosti.</p>';
$string['typetext'] = 'Besedilo';
$string['typevalue'] = 'Vrednost';
$string['uncategorised'] = 'Nekategorizirano';
$string['unchangedgrade'] = 'Ocena nespremenjena';
$string['unenrolledusersinimport'] = 'Ta uvoz je vseboval naslednje ocene za uporabnike, ki trenutno niso vključeni v ta predmet: {$a}';
$string['unlimitedgrades'] = 'Neomejene ocene';
$string['unlimitedgrades_help'] = 'Privzeto so ocene omejene z največjo in najmanjšo vrednostjo vsakega elementa ocene. Omogočanje te nastavitve umakne to omejitev in dovoli, da se lahko vpiše ocena nad 100% neposredno v redovalnico. Priporočeno je, da je ta nastavitev omogočena v času manjše obremenitve, da se lahko vse ocene preračunajo, saj to povzroči visoke obremenitve strežnika.';
$string['unlock'] = 'Odkleni';
$string['unlockverbose'] = 'Odkleni {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Neuporabljeno';
$string['updatedgradesonly'] = 'Izvozi samo nove ali posodobljene ocene';
$string['uploadgrades'] = 'Naloži ocene';
$string['useadvanced'] = 'Uporabi napredne možnosti';
$string['usedcourses'] = 'Uporabljeni predmeti';
$string['usedgradeitem'] = 'Uporabljena postavka ocene';
$string['usenooutcome'] = 'Ne uporabi izidov';
$string['usenoscale'] = 'Ne uporabi lestvice';
$string['usepercent'] = 'Uporabi odstotek';
$string['user'] = 'Uporabnik';
$string['userenrolmentsuspended'] = 'Uporabniški vpis je bil suspendiran';
$string['usergrade'] = 'Uporabnik {$a->fullname} ({$a->useridnumber}) na postavki {$a->gradeidnumber}';
$string['userpreferences'] = 'Uporabniške nastavitve';
$string['useweighted'] = 'Uporabi uteženo';
$string['verbosescales'] = 'Podrobne lestvice';
$string['viewbygroup'] = 'Skupina';
$string['viewgrades'] = 'Prikaži ocene';
$string['warningexcludedsum'] = 'Opozorilo: izključitev ocen ni skladno z agregacijo vsote.';
$string['weight'] = 'utež';
$string['weightcourse'] = 'Uporabi utežene ocene pri predmetu';
$string['weightedascending'] = 'Razvrsti po uteženem odstotku naraščajoče';
$string['weighteddescending'] = 'Razvrsti po uteženem odstotku padajoče';
$string['weightedpct'] = 'utežen %';
$string['weightedpctcontribution'] = 'prispevek uteženega %';
$string['weights'] = 'Uteži';
$string['weightuc'] = 'Utež';
$string['writinggradebookinfo'] = 'Pisanje nastavitev redovalnice';
$string['xml'] = 'XML';
$string['yes'] = 'Da';
$string['yourgrade'] = 'Vaša ocena';
