<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'cs', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Máte jeden či více nových příspěvků ve fóru (klikněte zde pro zobrazení).';
$string['addanewdiscussion'] = 'Přidat nové téma diskuse';
$string['addanewquestion'] = 'Přidat novou otázku';
$string['addanewtopic'] = 'Přidat nové téma';
$string['advancedsearch'] = 'Pokročilé vyhledávání';
$string['allforums'] = 'Všechna fóra';
$string['allowdiscussions'] = 'Může {$a} přispívat do tohoto fóra?';
$string['allowsallsubscribe'] = 'V tomto fóru si může každý zvolit, zda bude odebírat příspěvky nebo ne.';
$string['allowsdiscussions'] = 'V tomto fóru může každý zahájit nové téma diskuse.';
$string['allsubscribe'] = 'Odebírat příspěvky ze všech fór';
$string['allunsubscribe'] = 'Zrušit odebírání příspěvků ze všech fór';
$string['alreadyfirstpost'] = 'Toto je první příspěvek ve fóru';
$string['anyfile'] = 'Libovolný soubor';
$string['areaattachment'] = 'Přílohy';
$string['areapost'] = 'Zprávy';
$string['attachment'] = 'Příloha';
$string['attachment_help'] = 'Volitelně můžete k příspěvku přiložit jeden nebo více souborů. Přiložíte-li obrázek, bude automaticky zobrazen.';
$string['attachmentnopost'] = 'Nemůžete exportovat přílohy bez id příspěvku';
$string['attachments'] = 'Přílohy';
$string['attachmentswordcount'] = 'Přílohy a počet slov';
$string['blockafter'] = 'Blokovat po dosažení počtu příspěvků';
$string['blockafter_help'] = 'Uživatelům je zablokována možnost dále přispívat, vloží-li do fóra během daného období nastavený počet příspěvků. Toto omezení se nevztahuje na uživatele s pravomocí "Ignorovat limit počtu příspěvků" (mod/forum:postwithoutthrottling).';
$string['blockperiod'] = 'Blokační období';
$string['blockperioddisabled'] = 'Neblokovat';
$string['blockperiod_help'] = 'Uživatelům je zablokována možnost dále přispívat, vloží-li do fóra během nastaveného období jistý počet příspěvků. Toto omezení se nevztahuje na uživatele s pravomocí "Ignorovat limit počtu příspěvků" (mod/forum:postwithoutthrottling).';
$string['blogforum'] = 'Standardní fórum zobrazované jako blog';
$string['bynameondate'] = 'autor {$a->name} - {$a->date}';
$string['cannotadd'] = 'Do tohoto fóra není možné přidat diskusi';
$string['cannotadddiscussion'] = 'Abyste mohli přidávat diskuse do tohoto fóra, musíte být členy skupiny.';
$string['cannotadddiscussionall'] = 'Nemáte oprávnění vkládat téma diskuse pro všechny účastníky.';
$string['cannotaddsubscriber'] = 'Není možné přidat do tohoto fóra odběratele {$a}!';
$string['cannotaddteacherforumto'] = 'Není možné přidat do sekce 0 (úvodní) převedené učitelské fórum.';
$string['cannotcreatediscussion'] = 'Nelze vytvořit novou diskusi';
$string['cannotcreateinstanceforteacher'] = 'Není možné vytvořit nové učitelské fórum';
$string['cannotdeletepost'] = 'Nemáte oprávnění odstranit tento příspěvek';
$string['cannoteditposts'] = 'Nemůžete upravovat příspěvky jiných lidí!';
$string['cannotfinddiscussion'] = 'V tomto fóru se nepodařilo najít diskusi';
$string['cannotfindfirstpost'] = 'Nelze najít první příspěvek v tomto fóru';
$string['cannotfindorcreateforum'] = 'Nelze najít nebo vytvořít hlavní fórum novinky na tomto webu';
$string['cannotfindparentpost'] = 'Nelze najít počáteční příspěvek v této diskusi {$a}';
$string['cannotmovefromsingleforum'] = 'Nemůžete přesunout diskusi z typu jednoduchého diskusního fóra';
$string['cannotmovenotvisible'] = 'Fórum není viditelné';
$string['cannotmovetonotexist'] = 'Nemůžete přesunout diskusi do neexistujícího fóra!';
$string['cannotmovetonotfound'] = 'Cílové fórum nebylo v tomto kurzu nalezeno.';
$string['cannotmovetosingleforum'] = 'Nelze přesunout diskusi na jednoduché prosté diskusní fórum';
$string['cannotpurgecachedrss'] = 'Nelze vymazat mezipaměť RSS pro daný zdroj a/nebo cílové fórum. Zkontrolujte vaše oprávnění.';
$string['cannotremovesubscriber'] = 'Nelze odstranit odběratele s id {$a} z tohoto fóra!';
$string['cannotreply'] = 'Na tento příspěvek nemůžete odpovídat';
$string['cannotsplit'] = 'Diskuze z tohoto fóra nelze rozdělit';
$string['cannotsubscribe'] = 'Promiňte, ale chcete-li se přihlásit k odběru tohoto fóra, musíte být členem nějaké skupiny.';
$string['cannottrack'] = 'Z tohoto fóra není možné zastavit sledování ';
$string['cannotunsubscribe'] = 'Z tohoto fóra není možné odhlásit odběr';
$string['cannotupdatepost'] = 'Tento příspěvek nemůžete aktualizovat';
$string['cannotviewpostyet'] = 'Nemůžete si prohlédnout otázky jiných studentů, protože jste ještě nevložili svůj příspěvek.';
$string['cannotviewusersposts'] = 'Nemáte přístup k žádným příspěvkům tohoto uživatele.';
$string['cleanreadtime'] = 'Hodina označování přečtených příspěvků';
$string['completiondiscussions'] = 'Počet diskusí, které musí student odstartovat:';
$string['completiondiscussionsgroup'] = 'Požadovat diskuse';
$string['completiondiscussionshelp'] = 'Pro ukončení se vyžadují diskuse';
$string['completionposts'] = 'Počet příspěvků nebo odpovědí, které musí student vytvořit:';
$string['completionpostsgroup'] = 'Vyžadovat příspěvky';
$string['completionpostshelp'] = 'Pro ukončení se vyžadují diskuse nebo odpovědi';
$string['completionreplies'] = 'Počet odpovědí, které musí student odeslat:';
$string['completionrepliesgroup'] = 'Vyžadovat odpovědi';
$string['completionreplieshelp'] = 'Pro ukončení modulu se vyžadují odpovědi';
$string['configcleanreadtime'] = 'V kterou denní hodinu se mají staré příspěvky označit jako přečtené, tj. v kolik hodin se má čistit tabulka \'read\' od starých příspěvků';
$string['configdigestmailtime'] = 'Zadejte hodinu, kdy mají být odesílány denní e-mailové přehledy. (E-maily budou rozeslány při prvním spuštění cronu po nastavené hodině.)';
$string['configdisplaymode'] = 'Výchozí způsob zobrazování diskuse, není-li uživateli nastaveno jinak.';
$string['configenablerssfeeds'] = 'Povolit funkci RSS kanálů pro všechna diskusní fóra. Budete ještě muset zapnout RSS kanály v nastavení jednotlivých fór.';
$string['configenabletimedposts'] = 'Zvolte "Ano", pokud chcete povolit nastavování doby zobrazení při vkládání nové diskuse';
$string['configlongpost'] = 'Příspěvek delší než tato vložená hodnota (HTML kód se nepočítá) je považován za dlouhý. Příspěvky zobrazované na titulní stránce instalace, v kurzech s diskusním uspořádáním a na stránce uživatelského profilu jsou zalomeny v místě přirozeného předělu tak, že počet zobrazených znaků leží někde mezi hodnotami forum_shortpost a forum_longpost.';
$string['configmanydiscussions'] = 'Maximální počet diskusí zobrazovaných na jedné stránce fóra.';
$string['configmaxattachments'] = 'Výchozí maximální počet příloh pro každý příspěvek.';
$string['configmaxbytes'] = 'Výchozí maximální velikost přílohy ve všech fórech na těchto stránkách (může být upravena nastavením kurzu a dalšími lokálními proměnnými).';
$string['configoldpostdays'] = 'Po kolika dnech se bude příspěvek považovat za přečtený';
$string['configreplytouser'] = 'Když je příspěvek odesílán odběratelům, má e-mail v poli \'Od:\' obsahovat adresu autora příspěvku? Příjemce tak může odpovídat přímo autorovi e-mailem, a ne prostřednictvím diskusního fóra. I když je zde zvolena hodnota \'Ano\', uživatelé si mohou ve svých profilech nastavit skrývání své e-mailové adresy.';
$string['configshortpost'] = 'Příspěvek kratší než tato vložená hodnota (HTML kód se nepočítá) je považován za krátký.';
$string['configtrackingtype'] = 'Výchozí nastavení pro sledování příspěvků.';
$string['configtrackreadposts'] = 'Zvolte \'Ano\', chcete-li pro každého uživatele zaznamenávat stav příspěvků přečteno/nepřečteno.';
$string['configusermarksread'] = 'Při \'Ano\' si musí uživatelé sami označit příspěvek jako přečtený. Při \'Ne\' se příspěvek automaticky označí jako přečtený po zobrazení uživateli.';
$string['confirmsubscribe'] = 'Skutečně si přejete odebírat příspěvky z fóra "{$a}"?';
$string['confirmunsubscribe'] = 'Skutečně si přejete zrušit odebírání příspěvků z fóra "{$a}"?';
$string['couldnotadd'] = 'Neznámá chyba! Nemohu přidat váš příspěvek.';
$string['couldnotdeletereplies'] = 'Příspěvek, na který již někdo odpověděl, nemůže být odstraněn.';
$string['couldnotupdate'] = 'Neznámá chyba! Nemohu aktualizovat váš příspěvek.';
$string['delete'] = 'Odstranit';
$string['deleteddiscussion'] = 'Téma diskuse bylo odstraněno.';
$string['deletedpost'] = 'Příspěvek byl odstraněn.';
$string['deletedposts'] = 'Tyto příspěvky byly odstraněny.';
$string['deletesure'] = 'Jste si jistí, že chcete odstranit tento příspěvek?';
$string['deletesureplural'] = 'Jste si jistí, že chcete odstranit tento příspěvek a všechny odpovědi na něj? ({$a} příspěvků)';
$string['digestmailheader'] = 'Toto je váš denní souhrn nových příspěvků v diskusních fórech na stránkách {$a->sitename}. Chcete-li změnit nastaveni těchto odběrů, jděte na {$a->userprefs}.';
$string['digestmailpost'] = 'Změna nastavení preferencí souhrnu';
$string['digestmailprefs'] = 'vas uzivatelsky profil';
$string['digestmailsubject'] = '{$a}: souhrn novych prispevku';
$string['digestmailtime'] = 'Hodina odesílání souhrnných emailů';
$string['digestsentusers'] = 'Souhrnné e-maily úspěšně zaslány {$a} uživatelům.';
$string['disallowsubscribe'] = 'Odebírání e-mailem není povoleno.';
$string['disallowsubscribeteacher'] = 'Odebírání e-mailem není povoleno (s výjimkou učitelů).';
$string['discussion'] = 'Diskuse';
$string['discussionmoved'] = 'Tato diskuse byla přesunuta do \'{$a}\'.';
$string['discussionmovedpost'] = 'Diskuse byla přesunuta <a href="{$a->discusshref}">na jiné místo</a> do fóra <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Název diskuse';
$string['discussions'] = 'Diskuse';
$string['discussionsstartedby'] = 'Diskuse, které zahájil(a) {$a}';
$string['discussionsstartedbyrecent'] = 'Diskuse, které právě zahájil(a) {$a}';
$string['discussionsstartedbyuserincourse'] = 'Diskuse zahájené uživatelem {$a->fullname} v kurzu {$a->coursename}';
$string['discussthistopic'] = 'Zobrazit diskusi';
$string['displayend'] = 'Konec';
$string['displayend_help'] = '<p>Můžete si zvolit, zda se váš příspěvek bude zobrazovat od určitého data,
nebo do určitého data, nebo bude zobrazen pouze po určitou dobu.</p>

<p>Odškrtnutím pole "Zakázat" aktivujete datum pro začátek a/nebo konec
zobrazení.</p>

<p>Poznámka: Uživatelé, kteří mají práva správce, uvidí příspěvky před
stanoveným datem i po něm.</p>';
$string['displaymode'] = 'Režim zobrazení';
$string['displayperiod'] = 'Doba zobrazování příspěvku';
$string['displaystart'] = 'Začátek';
$string['displaystart_help'] = '<p>Můžete si zvolit, zda se váš příspěvek bude zobrazovat od určitého data,
nebo do určitého data, nebo bude zobrazen pouze po určitou dobu.</p>

<p>Odškrtnutím pole "Zakázat" aktivujete datum pro začátek a/nebo konec
zobrazení.</p>

<p>Poznámka: Uživatelé, kteří mají práva správce, uvidí příspěvky před
stanoveným datem i po něm.</p>';
$string['displaywordcount'] = 'Zobrazovat počet slov';
$string['displaywordcount_help'] = 'Zda se má zobrazovat počet slov v každém příspěvku.';
$string['eachuserforum'] = 'Každý může zahájit jedno téma diskuse';
$string['edit'] = 'Upravit';
$string['editedby'] = 'Dodatečně upravil/-a: {$a->name}; čas vložení původního příspěvku:  {$a->date}';
$string['editedpostupdated'] = 'Příspěvek uživatele {$a} byl aktualizován';
$string['editing'] = 'Úprava';
$string['emaildigest_0'] = 'K příspěvku na fóru obdržíte jeden e-mail.';
$string['emaildigest_1'] = 'Obdržíte jeden přehledový e-mail denně s úplným obsahem diskusních příspěvků.';
$string['emaildigest_2'] = 'Obdržíte jeden přehledový e-mail denně obsahující předměty diskusních příspěvků.';
$string['emaildigestcompleteshort'] = 'Dokončete příspěvky';
$string['emaildigestdefault'] = 'Výchozí  ({$a})';
$string['emaildigestoffshort'] = 'Bez souhrnu';
$string['emaildigestsubjectsshort'] = 'Pouze témata';
$string['emaildigesttype'] = 'Volby e-mailového souhrnu';
$string['emaildigestupdated'] = 'Volby e-mailového souhrnu byly změněny na "{$a->maildigesttitle}" pro fórum "{$a->forum}". {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'Vaše výchozí nastavení "{$a->maildigesttitle}" bylo nastaveno pro fórum "{$a->forum}". {$a->maildigestdescription}.';
$string['emptymessage'] = 'Ve vašem příspěvku je něco špatně. Možná jste nevyplnili některé povinné údaje, nebo byl přiložený soubor moc velký. Vaše úpravy NEBYLY ULOŽENY!';
$string['erroremptymessage'] = 'Text příspěvku nemůže být prázdný';
$string['erroremptysubject'] = 'Předmět příspěvku nemůže být prázdný';
$string['errorenrolmentrequired'] = 'Musíte být zapsáni v tomto kurzu pro přístup k danému obsahu';
$string['errorwhiledelete'] = 'Při mazání záznamu došlo k chybě.';
$string['everyonecanchoose'] = 'Odebírání příspěvků je volitelné';
$string['everyonecannowchoose'] = 'Nyní je odebírání příspěvků volitelné';
$string['everyoneisnowsubscribed'] = 'Nyní všichni odebírají příspěvky tohoto fóra';
$string['everyoneissubscribed'] = 'Všichni odebírají nové příspěvky';
$string['existingsubscribers'] = 'Stávající odběratelé';
$string['exportdiscussion'] = 'Exportovat celou diskusi';
$string['forcedreadtracking'] = 'Povolet vynucení sledování příspěvků';
$string['forcessubscribe'] = 'Toto fórum vynucuje odběr příspěvků';
$string['forum'] = 'Fórum';
$string['forum:addinstance'] = 'Přidat nové fórum';
$string['forum:addnews'] = 'Přidat novinky';
$string['forum:addquestion'] = 'Přidávat otázku';
$string['forum:allowforcesubscribe'] = 'Vnucovat odběr příspěvků';
$string['forumauthorhidden'] = 'Autor (nezveřejněno)';
$string['forumblockingalmosttoomanyposts'] = 'Blížíte se limitu pro počet vložených příspěvků. Za poslední {$a->blockperiod} jste do fóra vložili {$a->numposts} příspěvků, limit je {$a->blockafter}.';
$string['forumbodyhidden'] = 'Tento příspěvek si nemůžete momentálně prohlédnout. Zřejmě jste do diskuse ještě nevložili žádný příspěvek nebo ještě neuplynula lhůta pro úpravu příspěvku, diskuse nezačala nebo již vypršela její platnost.';
$string['forum:createattachment'] = 'Vkládat přílohy';
$string['forum:deleteanypost'] = 'Kdykoliv odstraňovat jakékoliv příspěvky';
$string['forum:deleteownpost'] = 'Odstraňovat vlastní příspěvky (během nastaveného limitu)';
$string['forum:editanypost'] = 'Upravovat libovolný příspěvek';
$string['forum:exportdiscussion'] = 'Exportovat celou diskusi';
$string['forum:exportownpost'] = 'Exportovat vlastní příspěvek';
$string['forum:exportpost'] = 'Exportovat příspěvek';
$string['forumintro'] = 'Popis';
$string['forum:managesubscriptions'] = 'Spravovat odebírání příspěvků';
$string['forum:movediscussions'] = 'Přesouvat diskuse';
$string['forumname'] = 'Název fóra';
$string['forumposts'] = 'Příspěvky ve fóru';
$string['forum:postwithoutthrottling'] = 'Ignorovat limit počtu příspěvků';
$string['forum:rate'] = 'Hodnotit příspěvky';
$string['forum:replynews'] = 'Odpovídat na novinky';
$string['forum:replypost'] = 'Odpovídat na příspěvky';
$string['forums'] = 'Fóra';
$string['forum:splitdiscussions'] = 'Rozdělovat diskusi';
$string['forum:startdiscussion'] = 'Začínat novou diskusi';
$string['forumsubjecthidden'] = 'Předmět  (nezveřejněno)';
$string['forumtracked'] = 'Sledovat nepřečtené příspěvky';
$string['forumtrackednot'] = 'Nesledovat nepřečtené příspěvky';
$string['forumtype'] = 'Typ fóra';
$string['forumtype_help'] = 'Můžete si vybrat z několika typů fór:

* Prostá diskuse - pouze jedno diskusní téma, na které mohou všichni odpovídat (nelze použít v režimu oddělených skupin)
* Každý může zahájit jedno téma diskuse - každý může začít právě jedno téma, na které pak mohou všichni odpovídat.
* Otázky a odpovědi - studenti musejí nejprve zaslat svou odpověď na vložený příspěvek předtím, než mohou vidět odpovědi ostatních.
Běžné fórum zobrazené jako blog - otevřené fórum, ve kterém může kdokoliv kdykoliv začít novou diskusi. Diskutovaná témata jsou zobrazena na jedné stránce, jako by se jednalo o společný blog.
* Běžné fórum pro obecné použití - otevřené fórum, ve kterém může kdokoliv kdykoliv začít novou diskusi a všichni mohou odpovídat.';
$string['forum:viewallratings'] = 'Zobrazit podrobné informace o hodnocení jednotlivými uživateli';
$string['forum:viewanyrating'] = 'Zobrazit celkový výsledek hodnocení libovolného uživatele';
$string['forum:viewdiscussion'] = 'Vidět diskuse';
$string['forum:viewhiddentimedposts'] = 'Vidět časově omezené příspěvky';
$string['forum:viewqandawithoutposting'] = 'Vždy vidí otázky (Q) a odpovědi (A)';
$string['forum:viewrating'] = 'Zobrazit celkové hodnocení vlastních příspěvků';
$string['forum:viewsubscribers'] = 'Vidět odběratele';
$string['generalforum'] = 'Běžné fórum pro obecné použití';
$string['generalforums'] = 'Obecná fóra';
$string['hiddenforumpost'] = 'Skrýt příspěvek';
$string['inforum'] = 'v {$a}';
$string['introblog'] = 'Příspěvky v tomto fóru byly do něj zkopírované automaticky z blogů uživatelů z tohoto kurzu, protože položky blogů již nejsou k dispozici.';
$string['intronews'] = 'Novinky a oznámení';
$string['introsocial'] = 'Otevřené fórum pro debaty na libovolné téma';
$string['introteacher'] = 'Uzavřené fórum pro učitele kurzu';
$string['invalidaccess'] = 'Neplatný přístup ke stránce';
$string['invaliddigestsetting'] = 'Pro nastavení výtahu příspěvků byl poskytnut neplatný mail';
$string['invaliddiscussionid'] = 'Neplatný identifikátor diskuse - diskuse mohla být odstraněna';
$string['invalidforcesubscribe'] = 'Neplatný způsob nuceného odebírání fór';
$string['invalidforumid'] = 'ID fóra bylo nesprávné';
$string['invalidparentpostid'] = 'Nadřízený ID příspěvku byl nesprávný';
$string['invalidpostid'] = 'Neplatné ID příspěvku - {$a}';
$string['lastpost'] = 'Poslední příspěvek';
$string['learningforums'] = 'Učební fóra';
$string['longpost'] = 'Dlouhý příspěvek';
$string['mailnow'] = 'Odeslat ihned e-mailem';
$string['manydiscussions'] = 'Počet diskusí na stránce';
$string['markalldread'] = 'Označit všechny příspěvky v této diskusi jako přečtené';
$string['markallread'] = 'Označit všechny příspěvky v tomto fóru jako přečtené';
$string['markread'] = 'Označit jako přečtené';
$string['markreadbutton'] = 'Označit jako<br />přečtené';
$string['markunread'] = 'Označit jako nepřečtené';
$string['markunreadbutton'] = 'Označit jako<br />nepřečtené';
$string['maxattachments'] = 'Maximální počet příloh';
$string['maxattachments_help'] = 'Toto nastavení určuje maximální počet příloh pro každý příspěvek.';
$string['maxattachmentsize'] = 'Maximální velikost přílohy';
$string['maxattachmentsize_help'] = '<p>Při zakládání fóra můžete určit, jaká bude maximální velikost přílohy,
kterou lze připojit k jednotlivým příspěvkům.</p>

<p>(Někdy se zdánlivě podaří přiložit soubor, který je větší, než je stanovené
maximum. Tento soubor však nebude uložen na server; uživatel o tom může být
informován chybovým hlášením.)</p>';
$string['maxtimehaspassed'] = 'Časový limit ({$a}) pro úpravu příspěvku bohužel vypršel!';
$string['message'] = 'Zpráva';
$string['messageprovider:digests'] = 'Odběr souhrnných přehledů z fóra';
$string['messageprovider:posts'] = 'Odběr jednotlivých příspěvků z fóra';
$string['missingsearchterms'] = 'Následující termíny se vyskytují pouze ve značkách jazyka HTML:';
$string['modeflatnewestfirst'] = 'Zobrazit odpovědi za sebou (nejnovější nahoře)';
$string['modeflatoldestfirst'] = 'Zobrazit odpovědi za sebou (nejstarší nahoře)';
$string['modenested'] = 'Zobrazit hierarchii odpovědí (včetně textu)';
$string['modethreaded'] = 'Zobrazit hierarchii odpovědí (pouze osnovu)';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = 'Modul Fórum nabízí možnost asynchronní komunikace účastníků kurzu.

K dispozici je několik typů fór: běžné fórum, kde může každý začínat nové diskuse a zapojit se do stávajících; fórum, v němž může každý student začít nejvýše jednu diskusi; nebo fórum, v němž musí student nejprve sám za sebe odpověď položené otázky před tím, než vidí odpovědi ostatních. K příspěvkům lze přikládat soubory jako přílohy.

Účastníci kurzu se mohou přihlásit k odběru nových příspěvků ve fórech. Toto upozorňování na nové příspěvky je možno vnutit i zakázat podle potřeby. Vyžadují-li to okolnosti, může být nastaven limit pro počet příspěvků za daný čas (slouží jako obrana před nežádoucí aktivitou jednotlivců, kteří by jinak svými příspěvky zahltili dané fórum).

Příspěvky ve fóru je možno hodnotit, a to i ostatními studenty (vzájemné hodnocení). Hodnocení se přepočítává na výslednou známku, která může být součástí klasifikace v kurzu.

Fórum lze použít např.

* jako prostor pro představení se ostatním účastníkům v kurzu
* jako nástěnka pro zveřejňování novinek a oznámení (s možností vnuceného upozorňování na nové příspěvky)
* jako nástroj podpory uživatelům vašeho serveru
* pro neformální sdílení obsahu mezi vašimi studenty, včetně možnosti vzájemného hodnocení
* jako prostor, v němž pokračuje výklad a diskuse po ukončení prezenční části kurzu
* jako uzavřený prostor pouze pro učitele daného kurzu k diskusím a výměně materiálů
* jako otevřený prostor pro neformální diskuse o tématech mimo rámec kurzu';
$string['modulenameplural'] = 'Fóra';
$string['more'] = 'více';
$string['movedmarker'] = '(Přesunuto)';
$string['movethisdiscussionto'] = 'Přesunout tuto diskusi do ...';
$string['mustprovidediscussionorpost'] = 'Pro export musíte zadat buď id diskuse nebo id příspěvku
';
$string['namenews'] = 'Novinky';
$string['namenews_help'] = '<p>Fórum Novinky je speciální fórum, určené pro vkládání obecných oznámení.
   Fórum se vytváří automaticky pro každý kurz i pro titulní stránku instalace.
   Každý kurz může obsahovat pouze jedno fórum Novinky.</p>

<p>Nejnovější diskuse založené ve fóru Novinky se zobrazují v&nbsp;bloku
   "Poslední novinky" (i pokud fórum přejmenujete). Jestliže jste fórum
   Novinky odstranili, vytvoří se automaticky znovu, pokud v&nbsp;kurzu použijete
   blok "Poslední novinky".</p>';
$string['namesocial'] = 'Společné fórum';
$string['nameteacher'] = 'Učitelské fórum';
$string['newforumposts'] = 'Nové příspěvky';
$string['noattachments'] = 'K tomuto příspěvku nejsou žádné přílohy';
$string['nodiscussions'] = 'V tomto fóru zatím nejsou žádná témata diskuse.';
$string['nodiscussionsstartedby'] = 'Uživatel {$a} nezahájil žádné diskuse';
$string['nodiscussionsstartedbyyou'] = 'Nezahájili jste žádné diskuse';
$string['noguestpost'] = 'Bohužel, hosté nemohou přispívat do diskuse.';
$string['noguesttracking'] = 'Bohužel, hosté si nemohou zapnout označování nepřečtených příspěvků.';
$string['nomorepostscontaining'] = 'Nebyly nalezeny žádné další příspěvky obsahující \'{$a}\'.';
$string['nonews'] = 'Dosud nebyly vloženy žádné novinky';
$string['noonecansubscribenow'] = 'Odběry jsou nyní zakázány';
$string['nopermissiontosubscribe'] = 'Nemáte oprávnění zobrazit odběratele fóra';
$string['nopermissiontoview'] = 'Nemáte oprávnění zobrazit tento příspěvek';
$string['nopostforum'] = 'Je nám líto, ale nemáte oprávnění přispívat do tohoto fóra';
$string['noposts'] = 'Bez příspěvků';
$string['nopostsmadebyuser'] = 'Uživatel {$a} nevložil žádný příspěvek';
$string['nopostsmadebyyou'] = 'Nevložili jste žádný příspěvek';
$string['noquestions'] = 'Do tohoto fóra zatím nebyla vložena žádná otázka.';
$string['nosubscribers'] = 'V tomto fóru zatím nikdo neodebírá nové příspěvky';
$string['notexists'] = 'Diskuse už neexistuje';
$string['nothingnew'] = 'Žádné nové zprávy';
$string['notingroup'] = 'Pro prohlížení tohoto fóra musíte být členem skupiny.';
$string['notinstalled'] = 'Modul fórum není nainstalován';
$string['notpartofdiscussion'] = 'Tento příspěvek není součástí diskuse!';
$string['notrackforum'] = 'Neoznačovat nepřečtené příspěvky';
$string['noviewdiscussionspermission'] = 'Nemáte oprávnění vidět diskuse probíhající v tomto fóru';
$string['nowallsubscribed'] = 'Odebírání příspěvků ze všech fór v kurzu {$a} zapnuto.';
$string['nowallunsubscribed'] = 'Odebírání příspěvků ze všech fór v kurzu \'{$a}\' vypnuto.';
$string['nownotsubscribed'] = '{$a->name}: odebírání příspěvků z fóra "{$a->forum}" VYPNUTO.';
$string['nownottracking'] = '{$a->name}: označování nepřečtených příspěvků ve fóru \'{$a->forum}\' VYPNUTO.';
$string['nowsubscribed'] = '{$a->name}: odebírání příspěvků z fóra "{$a->forum}" ZAPNUTO.';
$string['nowtracking'] = '{$a->name}: označování nepřečtených příspěvků ve fóru \'{$a->forum}\' ZAPNUTO.';
$string['numposts'] = '{$a} příspěvků';
$string['olderdiscussions'] = 'Starší diskuse';
$string['oldertopics'] = 'Starší témata';
$string['oldpostdays'] = 'Přečteno po kolika dnech';
$string['openmode0'] = 'Ani nová témata diskuse, ani odpovědi nejsou povoleny';
$string['openmode1'] = 'Bez témat diskuse, ale odpovědi jsou povoleny';
$string['openmode2'] = 'Nová témata diskuse i odpovědi jsou povoleny';
$string['overviewnumpostssince'] = '{$a} příspěvků od posledního přihlášení';
$string['overviewnumunread'] = '{$a} celkem nepřečteno';
$string['page-mod-forum-discuss'] = 'Stránka diskusního vlákna';
$string['page-mod-forum-view'] = 'Hlavní stránka fóra';
$string['page-mod-forum-x'] = 'Jakákoliv stránka fóra';
$string['parent'] = 'Ukázat předchůdce';
$string['parentofthispost'] = 'Předchůdce tohoto příspěvku';
$string['pluginadministration'] = 'Správa fóra';
$string['pluginname'] = 'Fórum';
$string['postadded'] = '<p>Váš příspěvek byl úspěšně přidán.</p><p>Na případné úpravy máte {$a}</p>';
$string['postaddedsuccess'] = 'Váš příspěvek byl úspěšně přidán.';
$string['postaddedtimeleft'] = 'Na případné úpravy máte {$a}';
$string['postbyuser'] = '{$a->post} od {$a->user}';
$string['postincontext'] = 'Ukázat příspěvek v kontextu';
$string['postmailinfo'] = 'Toto je kopie nového příspěvku ze stránek {$a}.

Chcete-li na příspěvek odpovědět, následujte tento odkaz:';
$string['postmailnow'] = '<p>Upozornění na tento příspěvek bude neprodleně odesláno všem odběratelům.</p>';
$string['postrating1'] = 'Vykazuje zejména individuální poznávání';
$string['postrating2'] = 'Rovnoměrně individuální i kolektivní';
$string['postrating3'] = 'Vykazuje zejména kolektivní poznávání';
$string['posts'] = 'Příspěvky';
$string['postsmadebyuser'] = 'Příspěvky uživatele {$a}';
$string['postsmadebyuserincourse'] = 'Příspěvky uživatele {$a->fullname} v kurzu {$a->coursename}';
$string['posttoforum'] = 'Poslat do fóra';
$string['postupdated'] = 'Váš příspěvek byl aktualizován';
$string['potentialsubscribers'] = 'Odběratelé k dispozici';
$string['processingdigest'] = 'Zpracovávám souhrnný e-mail pro uživatele {$a}';
$string['processingpost'] = 'Zpracovávám příspěvek {$a}';
$string['prune'] = 'Oddělit';
$string['prunedpost'] = 'Z příspěvku byla vytvořena nová diskuse';
$string['pruneheading'] = 'Oddělit a přesunout tento příspěvek do nové diskuse.';
$string['qandaforum'] = 'Otázky a odpovědi';
$string['qandanotify'] = 'Toto je fórum typu "Otázky a odpovědi". Chcete-li si prohlédnout odpovědi na vložené otázky, musíte nejdříve vložit svou odpověď.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Číst zbytek tohoto tématu';
$string['replies'] = 'Odpovědi';
$string['repliesmany'] = '{$a} odpovědí';
$string['repliesone'] = '{$a} odpověď';
$string['reply'] = 'Odpovědět';
$string['replyforum'] = 'Odpovědět do fóra';
$string['replytouser'] = 'Při odpovědi na příspěvek použij emailovou adresu autora';
$string['resetdigests'] = 'Odstranit všechny jednotlivé uživatele fóra s předvolbou výtahu';
$string['resetforums'] = 'Odstranit všechny příspěvky z';
$string['resetforumsall'] = 'Odstranit všechny příspěvky';
$string['resetsubscriptions'] = 'Odstranit všechna přihlášení k odběru příspěvků';
$string['resettrackprefs'] = 'Vypnout všechna označování nepřečtených příspěvků';
$string['rssarticles'] = 'Počet posledních RSS článků';
$string['rssarticles_help'] = '<p>Tato volba umožňuje nastavit počet článků, které mají být zahrnuty v RSS
kanálu.</p>

<p>Pro většinu fór je vhodný počet mezi 5 a 20 články. Pokud je fórum velmi
frekventované, můžete počet zvýšit.</p>';
$string['rsssubscriberssdiscussions'] = 'RSS zdroj diskusí';
$string['rsssubscriberssposts'] = 'RSS zdroj příspěvků';
$string['rsstype'] = 'RSS kanál pro tuto aktivitu';
$string['rsstype_help'] = '<p>Tato volba umožňuje aktivovat RSS kanál pro aktuální fórum.</p>

<p>Můžete zvolit jeden ze dvou typů RSS kanálu:</p>

<ul>
  <li><b>Diskuse</b> Pokud vyberete toto nastavení, kanál bude obsahovat nové
  diskuse ve fóru včetně prvního příspěvku.</li>

  <li><b>Příspěvky</b> Toto nastavení znamená, že kanál bude obsahovat všechny
  nové příspěvky ve fóru.</li>
</ul>';
$string['search'] = 'Hledat';
$string['searchdatefrom'] = 'Příspěvky musí být novější než';
$string['searchdateto'] = 'Příspěvky musí být starší než';
$string['searchforumintro'] = 'Prosím, vložte hledané termíny do jednoho nebo více následujících polí:';
$string['searchforums'] = 'Prohledat fóra';
$string['searchfullwords'] = 'Tato slova by se měla vyskytovat jako celá slova';
$string['searchnotwords'] = 'Tato slova by v příspěvku NEMĚLA být';
$string['searcholderposts'] = 'Prohledat starší příspěvky...';
$string['searchphrase'] = 'V příspěvku se musí vyskytovat přesně tato fráze';
$string['searchresults'] = 'Výsledky hledání';
$string['searchsubject'] = 'Tato slova by měla být v předmětu příspěvku';
$string['searchuser'] = 'Toto jméno by se mělo shodovat s autorem';
$string['searchuserid'] = 'Autorovo Moodle ID';
$string['searchwhichforums'] = 'Která fóra se mají prohledat';
$string['searchwords'] = 'Tato slova se mohou vyskytovat kdekoliv v příspěvku';
$string['seeallposts'] = 'Zobrazit všechny příspěvky tohoto uživatele';
$string['shortpost'] = 'Krátký příspěvek';
$string['showsubscribers'] = 'Ukázat/vybrat odběratele';
$string['singleforum'] = 'Prostá diskuse';
$string['smallmessage'] = 'Nový příspěvek od {$a->user} ve fóru {$a->forumname}';
$string['startedby'] = 'Zahájil/-a';
$string['subject'] = 'Předmět';
$string['subscribe'] = 'Odebírat nové příspěvky';
$string['subscribeall'] = 'Zapnout odebírání příspěvků všem';
$string['subscribed'] = 'Příspěvky odebírány';
$string['subscribeenrolledonly'] = 'Pouze zapsaní účastníci kurzu mohou být upozorňováni na nové příspěvky.';
$string['subscribenone'] = 'Vypnout odebírání příspěvků všem';
$string['subscribers'] = 'Odběratelé';
$string['subscribersto'] = 'Odběratelé fóra "{$a}"';
$string['subscribestart'] = 'Povolit zasílání upozornění na nové příspěvky v tomto fóru';
$string['subscribestop'] = 'Vypnout zasílání upozornění na nové příspěvky v tomto fóru';
$string['subscription'] = 'Odebírání';
$string['subscriptionandtracking'] = 'Odebírání a sledování';
$string['subscriptionauto'] = 'Automatické odebírání';
$string['subscriptiondisabled'] = 'Odebírání není možné';
$string['subscriptionforced'] = 'Vnucené odebírání';
$string['subscription_help'] = 'Jste-li přihlášeni k odběru příspěvků z určitého fóra, budou vám zasílána upozornění na nové příspěvky. Odebírání je většinou volitelné, v některých případech však může být vnuceno tak, že upozornění jsou automaticky zasílána všem.';
$string['subscriptionmode'] = 'Způsob odebírání';
$string['subscriptionmode_help'] = 'Pokud je účastník kurzu přihlášen k odebírání příspěvků z určitého fóra, bude mu zasláno upozornění na nové příspěvky.

K dispozici jsou čtyři režimy odebírání:

* Volitelné - účastníci sami si mohou nastavit odebírání příspěvků
* Vnucené - upozornění je odesíláno všem a účastníci nemohou toto odesílání v Moodle zrušit
* Automatické - účastníci jsou automaticky přihlášeni k odebírání příspěvků, ale mohou toto odebírání kdykoliv zrušit
* Zakázáno - odebírání příspěvků není vůbec povoleno

Poznámka: Jakákoliv změna v tomto nastavení ovlivní pouze uživatele, kteří budou do kurzu zapsáni v budoucnu. Nemá vliv na stávající účastníky kurzu.';
$string['subscriptionoptional'] = 'Volitelné odebírání';
$string['subscriptions'] = 'Odebírání';
$string['thisforumisthrottled'] = 'Do tohoto fóra můžete v určeném časovém období vložit jen omezený počet příspěvků. Současné nastavení je {$a->blockafter} příspěvků za {$a->blockperiod}.';
$string['timedposts'] = 'Termínované příspěvky';
$string['timestartenderror'] = 'Datum pro konec zobrazování příspěvku nemůže předcházet datu pro začátek zobrazování.';
$string['trackforum'] = 'Označovat nepřečtené příspěvky';
$string['tracking'] = 'Označování';
$string['trackingoff'] = 'Vypnuto';
$string['trackingon'] = 'Vnuceno';
$string['trackingoptional'] = 'Volitelné';
$string['trackingtype'] = 'Označování nepřečtených příspěvků';
$string['trackingtype_help'] = 'Zda se mají uživatelům označovat nepřečtené příspěvky.

* Volitelné - účastníci si mohou označování vypínat a zapínat podle vlastního uvážení.
* Zapnuto - označování je trvale zapnuto
* Vypnuto - označování je trvale vypnuto';
$string['unread'] = 'Nepřečteno';
$string['unreadposts'] = 'Nepřečtené příspěvky';
$string['unreadpostsnumber'] = 'Nepřečtené příspěvky: {$a}';
$string['unreadpostsone'] = 'Nepřečtené příspěvky: 1';
$string['unsubscribe'] = 'Neodebírat příspěvky z tohoto fóra';
$string['unsubscribeall'] = 'Neodebírat příspěvky z žádných fór';
$string['unsubscribeallconfirm'] = 'Nyní odebíráte příspěvky z celkového počtu {$a} diskusních fór. Opravdu si přejete zrušit všechna tato odebírání a zakázat automatické nastavení odebírání po vložení příspěvku?';
$string['unsubscribealldone'] = 'Všechna volitelná odebírání z diskusních fór byla odstraněna. Stále ještě můžete dostávat emaily s příspěvky z diskusních fór, u nichž je odebírání vynuceno. Pro nastavení upozornění zasílaných z těchto stránek navštivte sekci Zprávu v nastavení vašeho uživatelského profilu.';
$string['unsubscribeallempty'] = 'Neodebíráte příspěvky z žádného diskusního fóra na těchto stránkách. Pro zrušení všech upozornění zasílaných z těchto stránek navštivte sekci Zprávu v nastavení vašeho uživatelského profilu.';
$string['unsubscribed'] = 'Neodebíráno';
$string['unsubscribeshort'] = 'Neodebírat';
$string['usermarksread'] = 'Ruční označování příspěvku jako přečteného';
$string['viewalldiscussions'] = 'Zobrazit všechny diskuse';
$string['warnafter'] = 'Upozornit po překročení počtu příspěvků';
$string['warnafter_help'] = 'Účastníci kurzu mohou být upozorněni, pokud se blíží nejvyššímu povolenému počtu příspěvků do fóra za dané období. Toto nastavení určuje, při kolika příspěvcích je jim zasláno upozornění. Uživatelům s pravomocí ignorovat tento limit není upozorňování zasíláno.';
$string['warnformorepost'] = 'Varování! V tomto fóru je více diskusí - použijte novější';
$string['yournewquestion'] = 'Nová otázka';
$string['yournewtopic'] = 'Nové téma diskuse';
$string['yourreply'] = 'Vaše odpověď';
