<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   mnet
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutyourhost'] = 'ཁྱོད་རའི་server་གྱི་སྐོར་ལས།';
$string['accesslevel'] = 'འཛུལ་སྤྱོད་གནས་རིམ།';
$string['addhost'] = 'host་སྐོང་བརྐྱབ།';
$string['addnewhost'] = 'hostགསརཔ་ཅིག་ཁ་སྐོང་བརྐྱབ།';
$string['addtoacl'] = 'འཛུལ་སྤྱོད་ཚད་འཛིན་ལུ་ཁ་སྐོང་བརྐྱབ།';
$string['allhosts'] = 'hostsཆ་མཉམ།';
$string['allhosts_no_options'] = 'hostsསྣ་མང་བལྟ་བའི་ཚེ་ དགའ་གདམ་ཚུ་ཐོབ་མི་ཚུགས།';
$string['allow'] = 'བཅུག';
$string['applicationtype'] = 'གློག་རིམ་དབྱེ་བ།';
$string['authfail_nosessionexists'] = 'དབང་སྤྲོད་ལུ་འཐུས་ཤོར་བྱུང་ཡོདཔ་: mnet sessionའདི་མིན་འདུག།';
$string['authfail_sessiontimedout'] = 'དབང་སྤྲོད་ལུ་འཐུས་ཤོར་བྱུང་ཡོདཔ་: mnet sessionངལ་མཚམས་བྱུང་ཡོདཔ།';
$string['authfail_usermismatch'] = 'དབང་སྤྲོད་ལུ་འཐུས་ཤོར་བྱུང་ཡོདཔ་: ལག་ལེན་པ་མཐུན་སྒྲིག་མེདཔ།';
$string['authmnetdisabled'] = 'MNet་ཡོངས་འབྲེལ་ <em>དབང་སྤྲོད་ plugin་</em>འདི <strong>ལྕོགས་མིན་བཟོ་ཡོདཔ</strong>།';
$string['badcert'] = 'འདི་ནུས་ཅན་ལག་ཁྱེར་ཅིག་མེད་པས།';
$string['certdetails'] = 'Cert རྒྱས་བཤད་པཚུ';
$string['configmnet'] = 'MNet གྱིས་ འདི་server དང་ གཞན་server ཡང་ན་ ཞབས་ཏོག་ཚུ་ བརྡ་སྤྲོད་འབད་བཅུག་ཨིན།';
$string['couldnotgetcert'] = '<br />{$a} ལུ་ ལག་ཁྱེར་ཅིག་ཡང་མ་ཐོབ། <br /> ཧོསཊ་འདི་ཤུགས་མེདཔ་དང་ཡང་ན་ བདེན་མེདཔ་སྦེ་རིམ་སྒྲིག་འབད་འབདཝ་འོང་།';
$string['couldnotmatchcert'] = 'ལག་ཁྱེར་འདི་ ད་ལྟོ་ ཝེབ་སར་བར་གྱིས་དཔེ་སྐྲུན་འབད་མི་དང་གཅིག་ཁར་ མཐུན་སྒྲིག་མི་སྦེ་བས།';
$string['courses'] = 'སློབ་ཚན་ཚུ།';
$string['courseson'] = 'སློབ་ཚན་ཚུ་ ཡོདཔ་བཟོ།';
$string['currentkey'] = 'ད་ལྟོའི་མི་མང་ལྡེ་མིག་བུ།';
$string['current_transport'] = 'ད་ལྟོའིtransport';
$string['databaseerror'] = 'གནས་སྡུད་གཞི་རྟེན་ལུ་ཁ་གསལ་འབྲི་མ་ཚུགས།';
$string['deleteaserver'] = 'server་གཅིག་བཏོན་གཏང་དོ།';
$string['deletedhostinfo'] = 'host འདི་་ཏོན་གཏང་ཡོདཔ། ཁྱོད་བཏོན་བཤོལ་འབད་བ་ཅིན་ བཏོན་གཏང་ཡོདཔ་པའི་གནས་ཚད་འདི་ཕར་ལོག་\'མེན\'་ལུ་བཟོ།';
$string['deletedhosts'] = '{$a}:hosts་ཏོན་གཏང་ཡོདཔ།';
$string['deletehost'] = 'hostབཏོན་གཏང།';
$string['deletekeycheck'] = 'ལྡེ་མིག་འདི་བཏོན་གཏང་ནི་ལུ་ཁྱོད་ངེས་བདེན་ཨིན་ན?';
$string['deleteoutoftime'] = 'ལྡེ་མིག་བཏོན་གཏང་ནི་གི་དོན་ལུ་ ཁྱོད་ལུ་སྐར་ཆ་ ༦༠ ཡོད་མི་འདི་རྗོགས་ཡོདཔ་ལས་ ལོག་འགོ་བཙུགས་གནང་།';
$string['deleteuserrecord'] = 'SSO ACL: ལག་ལེན་པ་ \'{$a->user}\' ལས {$a->host} གི་དྲན་ཐོ་འདི་བཏོན་གཏང་།';
$string['deletewrongkeyvalue'] = 'འཛོལ་བ་ཅིག་བྱུང་ཡོདཔ། ཁྱོད་ཀྱིས་ ཁྱོད་རའི་ སར་བར་གྱི་ SSL ལྡེ་མིག་འདི་བཏོན་གཏང་ནི་ལུ་འབད་རྩོལ་མ་བསྐྱེད་པ་ཅིན་ ཁྱོད་ལུ་ངན་པའི་སྐྱོན་བརྐྱབ་ནིའི་ཉེན་ཁ་ཡོད། བྱེད་ལས་ཅིག་ཡང་མ་འབྱུང་བས།';
$string['deny'] = 'ཉན་མི་བཏུབ';
$string['description'] = 'འགྲེལ་བཤད།';
$string['duplicate_usernames'] = 'ང་བཅས་ཀྱིས་ ཁྱོད་ཀྱི་ལག་ལེན་པའི་ཐིག་ཁྲམ་ནང་ཡོད་པའི་ "mnethostid" དང་ "ལག་ལེན་པའི་མིང་" གུ་ ཟུར་ཐོ་ཅིག་གསར་བསྐྲུན་འབད་ནི་ལུ་འཐུས་ཤོར་བྱུང་ཡོད། <br />འདི་བཟུམ་ <a href="{$a}" target="_blank">ཁྱོད་ཀྱི་ལག་ལེན་པའི་ཐིག་ཁྲམ་ནང་ ལག་ལེན་པའི་མིང་རྫུན་མ་ཡོད་པ་ཅིན་འོང་སྲིད</a>། ཁྱོད་ཀྱི་དུས་མཐུན་བཟོ་ནི་འདི་ མཐར་འཁྱོལ་ཅན་སྦེ་རྫོགས་ཚུགས། <br />གོང་ལུ་ཡོད་པའི་འབྲེལ་ལམ་ལུ་ཨེབ་གཏང་སྦེ་དེ་ དཀའ་ངལ་འདི་སེལ་ཐབས་ཀྱི་བསླབ་སྟོན་འདི་ ཝིན་ཌོ་གསརཔ་ཅིག་ནང་འབྱུང་འོང། ཁྱོད་ཀྱིས་འདི་ དུས་མཐུན་བཟོ་བའི་མཇུག་ལུ་བལྟ་ད།<br />';
$string['enabled_for_all'] = '(ཞབས་ཏོག་འདི་ hostsཆ་མཉམ་གྱི་དོན་ལུ་ལྕོགས་ཅན་བཟོ་ཡོད)།';
$string['enterausername'] = 'ལྷོད་རྟགས་ཀྱིས་ཁ་ཕྱེ་སྟེ་ ལག་ལེན་པའི་མིང་ཡང་ན་ ལག་ལེན་པའི་མའི་ཚུ་གི་ཐོ་ཡིག་ཚུ་བཙུགས་གནང་།';
$string['error7020'] = 'འདི་བཟུམ་པའི་འཛོལ་བ་ སྤྱིར་གཏང་གི་ དཔེར་ན་ http://www.yoursite.com གི་ཚབ་ལུ་ http://yoursite.com བཟུམ་པའི་ཕྱི་འགྱུར་གྱི་དྲན་ཐོ་ཅིག་ཐག་རིང་གི་ས་ཁོངས་འདི་གིས་ ཁྱོད་ལུ་གསར་བསྐྲུན་འབད་བའི་སྐབས་ འབྱུངམ་ཨིན། ཁྱོད་ཀྱིས་ ཁྱོད་རའི་ wwwroot(config.php ནང་ཁ་གསལ་ལྟར་) དང་གཅིག་ཁར་ ཐག་རིང་ས་ཁོངས་ཀྱི་བདག་སྐྱོང་ལུ་ ཁྱོད་རའི་གནད་མཛོད་ཀྱི་དྲན་ཐོ་འདི་དུས་མཐུན་བཟོ་དགོ་པའི་སྐོར་ལས་སླབ་དགོ';
$string['error7022'] = 'ཁྱོད་ཀྱི་ ཐག་རིང་ས་ཁོངས་ལུ་གཏང་བའི་འཕྲིན་དོན་འདི་ གསང་བཟོ་ལེག་ཤོམ་སྦེ་བཟོ་ཡོད་རུང་ མིང་རྟགས་མ་བཀོད་པས། འ་ནི་འདི་མ་པ་ལས་མ་བསམ་མི་ཅིག་ཨིན་པས་ འདི་བཟུམ་འབྱུང་མ་ཅིན་ ཁྱོད་ཀྱིས་ (མུ་ཌེལ་ཐོན་རིམ་གྱི་སྐོར་ལས་ དྲི་བ་ཚུ་ནང་ཡང་ན་ལ་སོགས་པ་ཚུ་ནང་སྦེ་ བརྡ་དོན་གང་མང་བྱིན་ཏེ)རྐྱེན་ཅིག་བསྡུ་གསོག་འབད་དགོ';
$string['error7023'] = 'ཐག་རིང་ས་ཁོངས་འདི་གིས་ ཁྱོད་ཀྱི་འཕྲིན་དོན་འདི་ ཁྱོད་རའི་ས་ཁོངས་ཀྱི་དོན་ལུ་བཞག་ཡོད་པའི་དྲན་ཐོ་ནང་ཡོད་པའི་ལྡེ་ཡིག་ཆ་མཉམ་དང་གཅིག་ཁར་གསང་བཤོལ་འབད་ནི་ལུ་བརྩོན་ནུག། འདི་ཚུ་ག་ར་འཐུས་ཤོར་བྱུང་ནུག། ཁྱོད་ཀྱིས་ ཐག་རིང་ས་ཁོངས་དང་ཅིག་ཁར་ལག་ཐོག་སྦེ་ལྡེ་ཡིག་འབད་དེ་ དཀའ་ངལ་འདི་སེལ་ཚུགསཔ་འོང་། འ་ནི་འདི་ ཁྱོད་ ཐག་རིང་ས་ཁོངས་དང་གཅིག་ཁར་འབྲེལ་བ་ཟླཝ་སྦེ་བཞག་མ་ཚུགཔ་ད་འབྱུངམ་ཨིན།';
$string['error7024'] = 'ཁྱོད་ཀྱིས་ ཐག་རིང་ས་ཁོངས་ལུ་ གསང་བཟོ་མིན་པའི་འཕྲིན་དོན་ཅིག་གཏང་པ་ཅིན་ ཐག་རིང་ས་ཁོངས་ཀྱིས་ འཕྲིན་དོན་འདི་དང་ལེན་མི་འབད། འ་ནི་འདི་རེ་འདོད་མེད་མི་ཅིག་ཨིནམ་ལས་ འདི་བཟུམ་འབྱུང་བ་ཅིན་ ཁྱོད་ཀྱིས་བག་སྦེ་(དྲི་བ་ ལ་སོགས་པ་ཚུ་ནང་ མུ་ཌེལ་ཐོན་རིམ་དེའི་སྐོར་ལས་ བརྡ་དོན་གང་མང་བྱིན་ཏེ)སྙན་ཞུ་འབད་དགོ';
$string['error7026'] = 'ཁྱོད་ཀྱི་འཕྲིན་དོན་ལྡེ་ཡིག་དང་གཅིག་ཁར་རྟགས་བསྐལ་ཡོད་མི་འདི་ ཁྱོད་ཀྱི་སར་བར་གྱི་དོན་ལུ་ ཐག་རིང་གནད་མཛོད་གི་ཡིག་སྣོད་ནང་ཡོད་པའི་ལྡེ་ཡིག་དང་གཅིག་ཁར་མི་མཐུན་པས། ཨིན་རུང་ ཐག་རིང་གནད་མཛོད་གིས་ ཁྱོད་ཀྱི་ད་ལྟོའི་ལྡེ་ཡིག་འདི་ལེན་ནི་དཔའ་བཅམ་ཡོད་རུང་ འཐུས་ཤོར་བྱུང་ཡོད། དེ་འབད་བ་ལས་ ལག་ཐོག་ ཐག་རིང་གནད་མཛོད་དང་གཅིག་ཁར་ལྡེ་ཡིག་ལོག་བཙུགས་སྟེ་ བལྟ་གནང་།';
$string['error709'] = 'ཐག་རིང་ས་ཁོངས་འདི་གིས་ ཁྱོད་ལས་ SSL ལྡེ་ཡིག་ལེན་ནི་ལུ་འཐུས་ཤོར་བྱང་ཡོད།';
$string['expired'] = 'ལུ་ཡོལ་ཡོད་པའི་ལྡེ་ཡིག་འདི་';
$string['expires'] = 'ཚུན་ཚོད་ནུས་ཅན་འདུག།';
$string['expireyourkey'] = 'ལྡེ་ཡིག་འདི་བཏོན་གཏང།';
$string['expireyourkeyexplain'] = '(སྔོན་སྒྲིག་གིས་སྦེ་) ཁྱོད་ཀྱི་ལྡེ་ཡིག་ཚུ་ ཉིནམ་༢༨ ལུ་ཚར་རེ་ Moodle་གྱིས་རང་བཞིན་གྱིས་སྦེ་བསྒྱིར་འོང་ དེ་འབདཝ་ད་ ལྡེ་ཡིག་འདི་གི་ཚུ་ཚོད་འདི་ནམ་རང་དུས་ཡོལ་གཏང་དགོ་རུང་ ལག་ཐོག་ལུ་དུས་ཡོལ་གཏང་ནིའི <em>་གདམ་ཁ་</em>འདི་ཁྱོད་ལུ་ཡོད། ཁྱོད་ཀྱིས་ ལྡེ་ཡིག་འདི་ནང་འགྲིགས་འབད་ཡོདཔ་ཁས་ལེན་པ་ཅིན་རྐྱངམ་ཅིག་ཕན་ཐོགས་ཡོད། ཚབ་བཙུགས་ཅིག་འདི་འཕྲོ་ལས་རང་བཞིན་གྱིས་འཐོན་འོང་། <br /> ལྡེ་ཡིག་འདི་བཏོན་གཏང་པ་ཅིན་ ཁྱོད་ཀྱིས་ བདག་སྐྱོང་རེ་བཞིན་དང་འབྲེལ་བ་འཐབ་སྟེ་ ལྡེ་ཡིག་གསརཔ་འདི་མ་བྱིན་ཚུན་ མུ་ཌེལ་གཞན་ཚུ་གིས་ ཁྱོད་དང་གཅིག་ཁར་ བརྡ་དོན་སྤྲོད་མི་ཚུགས།';
$string['exportfields'] = 'ས་སྒོ་ཚུ་ཕྱིར་འདྲེན་འབད་ནི།';
$string['failedaclwrite'] = '\'{$a}\' ལག་ལེན་པའི་དོན་ལུ་ MNET མཛུལ་སྤྱོད་ཚད་འཛིན་ཐོ་ཡིག་འབྲི་ནི་ལུ་ འཐུས་ཤོར་བྱུང་ཡོད།';
$string['findlogin'] = 'ནང་བསྐྱོད་འཚོལ།';
$string['forbidden-function'] = 'ཨ་ཕི་ལས་འགན་འདི་ RPC གི་དོན་ལུ་ལྕོགས་ཅན་བཟོ་དེ་མེདཔ།';
$string['forbidden-transport'] = 'ཁྱོད་ཀྱིས་ སྐྱེལ་འདྲེན་ཐབས་ལམ་འདི་ལུ་བརྩོན་མི་འདི་ལུ་གནང་བ་མེད།';
$string['forcesavechanges'] = 'བསྒྱུར་བཅོས་ཚུ་སྲུང,་ནི་ལུ་བང་བཙོང་འབད།';
$string['helpnetworksettings'] = 'ནང་འཁྱོད་ MNet རྒྱུད་འབྲེལ་འཐབ་ནི་འདི་རིམ་སྒྲིག་འབད';
$string['hidelocal'] = 'ནང་འཁྱོད་ལག་ལེན་པ་ཚུ་སྦ་བཞག';
$string['hideremote'] = 'ཐག་རིང་ལག་ལེན་པ་ཚུ་སྦ་བཞག';
$string['host'] = 'གནསཔ།';
$string['hostcoursenotfound'] = 'Host ཡང་ན་སློབ་ཚན་འདི་འཚོལ་མ་ཐོབ།';
$string['hostdeleted'] = 'Hostབཏོན་གཏང་ཡོདཔ';
$string['hostexists'] = 'host དེ་དང་hostnameགཅིག་ཁར་ཡོད་པའི་དྲན་ཐོག་ཅིག་ཧེ་མ་ལས་རང་འདུག (ཡང་ན་བཏོན་གཏང་འིང་ག་མི་ཤེས) དྲན་ཐོག་དེ་ཞུན་དག་འབད་ནི་དོན་ལས་<a href="{$a}">ནཱ་ལུ་ཨེབ་གཏང</a>';
$string['hostlist'] = 'hostsཡོངས་འབྲེལ་ཐོ་བཀོད་ཡིདཔ།';
$string['hostname'] = 'གནསཔ་གི་མིང་།';
$string['hostnamehelp'] = 'The fully-qualified domain name of the remote host, e.g. www.example.com';
$string['hostnotconfiguredforsso'] = 'serverའདི་ ཐག་རིང་ནང་བསྐྱོད་ཀྱི་དོན་ལུ་རིམ་སྒྲིག་མ་འབད།';
$string['hostsettings'] = 'Host གཞི་སྒྲིག་ཚུ།';
$string['http_self_signed_help'] = 'hostཐག་རིང་གུ་ རང་གིས་རྟགས་བཀོད་ཡོད་མི་ DIY SSL ལག་ཁྱེར་ལག་ལེན་འཐབ་ཐོག་ལས་ འབྲེལ་མཐུད་འབད་ནིའི་གནང་བ་བྱིན';
$string['https_self_signed_help'] = 'host ཐག་རིང་གུ་ http གུ་ PHP ནང་ རང་གིས་རྟགས་བཀོད་ཡོད་མི་DIY SSL ལག་ལེན་འཐབ་ཐོག་ལས་ འབྲེལ་མཐུད་འབད་ནིའི་གནང་བ་བྱིན།';
$string['https_verified_help'] = 'hostཐག་རིང་གུ་ བདེན་སྦྱོར་འབད་ཡོད་མི་ SSL ལག་ཁྱེར་ལག་ལེན་འཐབ་ཐོག་ལས་་འབྲེལ་མཐུད་འབད་ནིའི་གནང་བ་བྱིན';
$string['http_verified_help'] = 'hostཐག་རིང་གུ་ PHP ནང་ བདེན་སྦྱོར་འབད་ཡོད་མི་ SSL ལག་ཁྱེར་ལག་ལེན་འཐབ་ཐོག་ལས་ འབྲེལ་མཐུན་འབད་ནིའི་གནང་བ་བྱིན་ དེ་འབདཝ་ད་ http (https མེན)';
$string['id'] = 'ངོ་རྟགས';
$string['idhelp'] = 'ཨང་རྩིས་འདི་རང་བཞིན་གྱིས་འགན་སྤྲོད་འབད་ཡོདཔ་དང་བསྒྱུར་བཅོས་འབད་མི་ཚུགས།';
$string['importfields'] = 'ས་སྒོ་ཚུ་ནང་འདྲེན་འབད་ནི།';
$string['inspect'] = 'ཞིབ་དཔྱད་འབད།';
$string['installnosuchfunction'] = 'Coding error!ག་ཅི་ཅིག་གི་ཡིག་སྣོད({$a->file})ལས་mnet xmlrpc function({$a->method})འདི་གཞི་བཙུགས་སྦེ་ནི་འབད་དོ་ འདི་འབདཝ་ད་འཚོལ་མེ་འཐོབ་བས!';
$string['installnosuchmethod'] = 'Coding error!ག་ཅི་ཅིག་གི་mnet xmlrpc function({$a->method})class({$a->class})གུ་ གཞི་བཙུགས་སྦེ་ནི་འབད་དོ་ འདི་འབདཝ་ད་འཚོལ་མེ་འཐོབ་བས!';
$string['installreflectionclasserror'] = 'Coding error!MNet introspection failed for method \'{$a->method}\' in class \'{$a->class}\'.\'{$a->error}\'་འདི་འཛོལ་བ་ངོ་མ་འཕྲིན་དོན་ཨིན།';
$string['installreflectionfunctionerror'] = 'Coding error!MNet introspection failed for method \'{$a->method}\' in file \'{$a->file}\'class.\'{$a->error}\'་འདི་འཛོལ་བ་ངོ་མ་འཕྲིན་དོན་ཨིན།';
$string['invalidaccessparam'] = 'ནུས་མེད་འཛུལ་སྤྱོད་ཚད་བཟུང་།';
$string['invalidactionparam'] = 'ནུས་མེད་བྱེད་ལས་ཚད་བཟུང་།';
$string['invalidhost'] = 'ནུས་ཅན་host་ངོས་འཛིན་འབད་མི་བྱིན་དགོ';
$string['invalidpubkey'] = 'ལྡེ་ཡིག་འདི་ནུས་ཅན་SSLལྡེ་ཡིག་མེན་མས({$a})';
$string['invalidurl'] = 'ནུས་མེད་URLལྡེ་ཡིག་';
$string['ipaddress'] = 'IPཁ་བྱང་';
$string['is_in_range'] = 'ཨའི་པི་ཁ་བྱང་ &nbsp;<code>{$a}</code>&nbsp; འདི་གིས་བློ་གཏད་ཅན་གྱི་ནུས་ཅན་host བརྡ་མཚོན་སྟོནམ་་ཨིན';
$string['ispublished'] = '{$a} གྱིས་ཁྱོད་ཀྱི་དོན་ལུ་ ཞབས་ཏོག་འདི་ལྕོགས་ཅན་བཟོ་ཡོདཔ།';
$string['issubscribed'] = '{$a} གྱིས་ཁྱོད་ཀྱི་ཧོསིཊི་གུ་ཞབས་ཏོག་འདི་ལུ་མཁོ་མངགས་འབད་དོ';
$string['keydeleted'] = 'ཁྱོད་ཀྱི་ལྡེ་ཡིག་འདི་ མཐར་འཁྱོལ་ཅན་སྦེ་བཏོན་གཏང་ཞིནམ་ལས་ཚབ་བཙུགས་ནུག';
$string['keymismatch'] = 'ཁྱོད་ཀྱིས་hostའདི་གི་དོན་ལུ་འཆང་མི་མི་མང་ལྡེ་ཡིག་འདི་ད་ལྟོ་པར་བསྐྲུན་འབད་མི་མི་མང་ལྡེ་ཡིག་དང་སོ་སོ་ཨིན';
$string['last_connect_time'] = 'འབྲེལ་མཐུད་ཀྱི་དུས་ཡུན་མཇུག';
$string['last_connect_time_help'] = 'ཁྱོད་ཀྱིས་hostའདི་ལུ་འབྲེལ་མཐུད་འབད་ཡོད་པའི་དུས་ཡུན་མཇུག';
$string['last_transport_help'] = 'ཁྱོད་ཀྱིས་host་འདི་ལུ་འབྲེལ་མཐུད་མཇུག་གི་དོན་ལུ་ལག་ལེན་འཐབ་ཡོད་མི་སྐྱེལ་འདྲེན';
$string['leavedefault'] = 'ཚབ་སྦེ་སྔོན་སྒྲིག་གཞི་སྒྲིག་ཚུ་ལག་ལེན་འཐབ།';
$string['listservices'] = 'ཐོ་བཀོད་ ཞབས་ཏོག་ཚུ།';
$string['loginlinkmnetuser'] = '<br /> ཁྱོད་ཐག་རིང་གི་MNetཡོངས་འབྲེལ་ལག་ལེན་པ་ཨིནམ་དང་ <a href="{$a}"> ནཱ་ལུ་གློག་འཕྲིན་ཁ་བྱང་ངེས་དཔྱད་འབད་ ཁྱོད་ནང་བསྐྱོད་ཤོག་ལེབ་ནང་སླར་ལོག་གཏང་འོང་།<br />';
$string['logs'] = 'དྲན་དེབ་ཚུ་';
$string['managemnetpeers'] = 'དོ་མཉམ་ཚུ་འཛིན་སྐྱོང་འཐབ།';
$string['method'] = 'ཐབས་ལམ།';
$string['methodhelp'] = '{$a}ལུ་གྲོགས་རམ་ཐབས་ལམ།';
$string['methodsavailableonhost'] = '{$a}གུ་ཐབས་ལམ་འཐོབ།';
$string['methodsavailableonhostinservice'] = '{$a->service}ལུ་ཐབས་ལམ་འཐོབ།';
$string['methodsignature'] = '{$a}ལུ་ཐབས་ལམ་མིང་རྟགས།';
$string['mnet'] = 'MNet';
$string['mnet_concatenate_strings'] = 'ཡིག་རྒྱུན་ ༣ (ཚུན་ཚོད་) རྒྱུན་མཐུད་འབད་ཞིནམ་ལས་ གྲུབ་འབྲས་ལོག་གཏང་།';
$string['mnetdisabled'] = 'MNetཡོངས་འབྲེལ་འདི་<strong>ལྕོགས་མིན་བཟོ་ཡོདཔ</strong>';
$string['mnetidprovider'] = 'MNet ID་བྱིན་མཁན།';
$string['mnetidproviderdesc'] = 'ཁྱོད་ཀྱི་གློག་འཕྲིན་ཁ་བྱང་ངེས་བདེན་འདི་ ཁྱོད་ཀྱི་ཧེ་མ་ལས་ལག་ལེན་པ་མིང་དེ་ནང་བསྐྱོད་འབད་བལྟ་མི་དེ་མཐུན་སྒྲིག་འབད་ཚུགས་པ་ཅིན་ མཐུན་རྐྱེན་ལག་ལེན་འཐབ་འབད་འབྲེལ་ལམ་སླར་འདྲེན་འབད་ཚུགས།';
$string['mnetidprovidermsg'] = 'ཁྱོད་ཀྱི་ {$a}བྱིན་མཁན་ ལུ་ནང་བསྐྱོད་འབད་ཚུགས།';
$string['mnetidprovidernotfound'] = 'དགོངམ་མ་ཁྲེལ།  དེ་འབདཝ་ད་ བརྡ་དོན་ཐེབས་ཐོབ་མ་ཚུགས།';
$string['mnetlog'] = 'དྲན་དེབ།';
$string['mnetpeers'] = 'དོ་མཉམ་ཚུ།';
$string['mnetservices'] = 'ཞབས་ཏོག་ཚུ།';
$string['mnet_session_prohibited'] = 'ཁྱོད་རའི་ཧོམ་སར་བར་ནང་ལས་ལག་ལེན་པ་ཚུ་ད་ལྟོ་ {$a} ལུ་ འགྱོ་ནིའི་གནང་བ་མེད';
$string['mnetsettings'] = 'MNetཡོངས་འབྲེལ་སྒྲིགས་སྟངས་ཚུ།';
$string['moodle_home_help'] = 'ཐག་རིང་ཧོསིཊི་གུ་ཡོད་མི་མ་ཤོག་གི་འགྲུལ་ལམ་ དཔེར་ན་/moodle/';
$string['name'] = 'མིང་།';
$string['net'] = 'ཡོངས་འབྲེལ';
$string['networksettings'] = 'ཡོངས་འབྲེལ་གྱི་གཞི་སྒྲིག་ཚུ།';
$string['never'] = 'ནམ་ཡང་';
$string['noaclentries'] = 'SSO འཛུལ་སྤྱོད་ཐོ་ཡིག་ནང་ཐོ་བཀོད་མིན་འདུག';
$string['noaddressforhost'] = 'དགོངམ་མ་ཁྲེལ། དེ་འབདཝ་ད་ hostname ({$a})དེ་མོས་མཐུན་འབད་མ་ཚུགས།';
$string['nocurl'] = 'PHP cURL དཔེ་མཛོད་གཞི་བཙུགས་མ་འབད་བས།';
$string['nolocaluser'] = 'ཐག་རིང་ལག་ལེན་པ་གི་དོན་ལུ་ ཉེ་གནས་དྲན་ཐོ་མིན་འདུག';
$string['nomodifyacl'] = 'ཁྱོད་ཀྱིས་ MNET འཛུལ་སྤྱོད་ཚད་འཛིན་ཐོ་བཀོད་ལེགས་བཅོས་འབད་མི་ཆོག';
$string['nonmatchingcert'] = 'ལག་ཁྱེར་གྱི་དོན་ཚན་: <br /><em>{$a->subject}</em><br /> འདི་ཁོརའི་host་དང་མཐུན་སྒྲིག་མི་འབད་བས:<br /><em>{$a->host}</em>.';
$string['nopubkey'] = 'མི་མང་ལྡེ་ཡིག་སླར་འདྲེན་འབད་ནི་ལུ་འཛོལ་བ་འདུག<br /> host་གིས་མུ་ཌེལ་ཡོངས་འབྲེལ་བཟོ་མ་བཅུགཔ་དང་ ཡང་ན་ ལྡེ་ཡིག་འདི་ནུས་མེད་ཨིནམ་བཟུམ་ཅིག་འདུག';
$string['nosite'] = 'ས་ཁོངས་-གནས་ཚད་ སློབ་ཚན་འཚོལ་མ་ཐོབ།';
$string['nosuchfile'] = 'ཡིག་སྣོད/ལས་འགན་{$a} མིན་འདུག';
$string['nosuchfunction'] = 'ལས་འགན་ག་ཡོད་འཚོལ་མ་ཐོབ་ ཡང་ན་ RPC གི་དོན་ལུ་ལས་འགན་ བཀག་དམ་འབད་ཡོདཔ།';
$string['nosuchmodule'] = 'ལས་འགན་འདི་བདེན་མེད་སྦེ་བྱིན་ཡོདཔ་ལས་ག་ཡོད་འཚོལ་མ་ཐོབ། mod/modulename/lib/functionname format ལག་ལེན་འཐབ་གནང་།';
$string['nosuchpublickey'] = 'མིང་རྟགས་བདེན་སྦྱོར་འབད་ནིའི་དོན་ལུ་ མི་མང་ལྡེ་ཡིག་ལེན་མ་ཚུགས།';
$string['nosuchservice'] = 'RPC ཞབས་ཏོག་འདི་ཧོསིཊི་འདི་གུ་ལཱ་མི་འབད་བས།';
$string['nosuchtransport'] = 'ID དེ་ ཡོད་མི་སྐྱེལ་འདྲེན་མིན་འདུག';
$string['notBASE64'] = 'ཡིག་རྒྱུན་འདི་ Base64 ཨིན་ཀོ་ཌེཌི་ རྩ་སྒྲིག་ནང་མིན་འདུག་ ནུས་ཅན་ལྡེ་ཡིག་མི་འོང་།';
$string['notenoughidpinfo'] = 'རྩིས་ཐོ་ནང་འཁོད་ནང་ གསར་བསྐྲུན་ ཡང་ན་ དུས་མཐུན་བཟོ་ནི་དོན་ལུ་ ཁྱོད་ཀྱི་ངོ་རྟགས་བྱིན་མཁན་གྱི་བརྡ་དོན་ལངམ་སྦེ་མི་བྱིན་ནོག། དགོངམ་མ་ཁྲེལ!';
$string['not_in_range'] = 'IP ཁ་བྱང་ &nbsp; <code>{$a}</code>&nbsp; ནུས་ཅན་ བློ་གཏད་ཡོད་མི་ཧོསིཊི་ བརྡ་མཚོན་མི་འབད་བས།';
$string['notinxmlrpcserver'] = 'XMLRPC server ལག་ལེན་འཐབ་ནི་སྐབས་སུ་མེན་པར་  MNetཐག་རིང་ཀྱི་ཞབས་ཏོག་སྤྱོད་མི་ ལུ་འཛུལ་སྤྱོད་འབད་ནི་དཔའ་བཅམ་ནུག།';
$string['notmoodleapplication'] = 'ཉེན་བརྡ: འདི་Moodleགི་གློག་རིམ་མེན་ དེ་འབདཝ་ལས་ ལ་ལུ་ཞིབ་དཔྱད་ཐབས་ལམ་ཚུ་ལཱ་མེད་འབད་ནི་བཟུམ་ཅིག་ཡོད།';
$string['notPEM'] = 'ལྡེ་ཡིག་འདི་ PEM རྩ་སྒྲིག་ནང་མེན་མས། འདི་ལཱ་འབད་མི་བཏུབ།';
$string['notpermittedtojump'] = 'ཁྱོད་ལུ་Moodleཧབ་འདི་ནང་ལས་ ཐག་རིང་ལཱ་ཡུན་འགོ་བཙུག་ནིའི་གནང་བ་མིན་འདུག';
$string['notpermittedtojumpas'] = 'གཞན་ཅིག་གི་ལག་ལེན་པའི་ནང་བསྐྱོད་སྐབས་ལུ་ ཁྱོད་ཀྱི་sessionཐག་རིང་འདི་འགོ་བཙུགས་མིད་ཚུགས།';
$string['notpermittedtoland'] = 'ཁྱོད་ལུ་ཐག་རིང་གི་ལས་ཡུན་འགོ་བཙུགས་ནིའི་གནང་བ་མེད';
$string['off'] = 'མེདཔ་བཟོ།';
$string['on'] = 'ཡོདཔ་བཟོ།';
$string['options'] = 'གདམ་ཁ་ཚུ།';
$string['peerprofilefielddesc'] = 'གསལ་སྡུད་ས་སྒོ་ཚུ་གཏང་འབད་ ནང་འདྲེན་འབད་ལག་ལེན་པ་གསརཔ་གསར་བསྐྲུན་འབད་ལུ་ཁྱོད་ཀྱི་སྤྱི་ཁྱབ་གཞི་སྒྲིག་ཚུ་ཚབ་སྲུང་འབད།';
$string['permittedtransports'] = 'གནང་བ་བྱིན་ཡོད་མི་སྐྱེལ་འདྲེན་ཚུ།';
$string['phperror'] = 'ནང་འཁོད་ PHP་གིས་ཁྱོད་ཀྱི་སྙན་ཞུ་གི་དོན་འགྲུབ་ནི་ལུ་བཀག་ཆ་འབད་ཡོདཔ།';
$string['position'] = 'གནས་ས།';
$string['postrequired'] = 'བཏོན་གཏང་ལས་འགན་འདི་ལུ་ བརྡ་འཕྲིན་ཞུ་བ་དགོ་པས།';
$string['profileexportfields'] = 'ས་སྒོ་ཚུ་གཏང་།';
$string['profilefielddesc'] = 'ལག་ལེན་པ་རྩིས་ཐོ་ཚུ་གསར་བསྐྲུན་འབད་ཡོདཔ་ ཡང་ན་ དུས་མཐུན་བཟོ་ཡོདཔ་ད་  གསལ་སྡུད་ས་སྒོ་ཚུ་གི་ཐོ་བཀོད་ཚུ་ MNet གུ་ལས་གཏང་ ལེན་སྦེ་རིམ་སྒྲིག་འབད་ཚུགས། ཁྱོདི་ཀྱི་MNet དོ་མཉམ་རེ་རེ་ལུ་དབང་ཐག་ཆོད་ཚུགས། {$a}:ས་སྒོ་ཚུ་འདི་ཨ་རྟག་རང་གཏང་ཨིན།';
$string['profilefields'] = 'གསལ་སྡུད་ས་སྒོ་ཚུ།';
$string['profileimportfields'] = 'ས་སྒོ་ཚུ་ནང་འདྲེན་འབད་ནི་ལུ།';
$string['promiscuous'] = 'སྣ་ཚོགས།';
$string['publickey'] = 'མི་མང་ལྡེ་ཡིག';
$string['publickey_help'] = 'མི་མང་ལྡེ་ཡིག་འདི་ཐག་རིང་སར་བར་ནང་ལས་རང་བཞིན་གྱིས་ཐོབ་ཡོདཔ།';
$string['publickeyrequired'] = 'མི་མང་ལྡེ་ཡིག་བྱིན་དགོ།';
$string['publish'] = 'པར་བསྐྲུན';
$string['reallydeleteserver'] = 'ཁྱོད་ སར་བར་བཏོན་གཏང་ནི་ངེས་བདེན་ཨིན་ན';
$string['receivedwarnings'] = 'འོག་གི་ཉེན་བརྡ་ཚུ་ཐོབ་ཡོདཔ།';
$string['recordnoexists'] = 'དྲན་ཐོ་མིན་འདུག';
$string['reenableserver'] = 'མེན - སར་བར་འདི་ལོག་ལྕོགས་ཅན་བཟོ་ནིའི་དོན་ལུ་གདམ་ཁ་འདི་སེལ་འཐུ་འབད';
$string['registerallhosts'] = 'host ཆ་མཉམ་ཐོ་བཀོད་འབད(<em>Hub mode</em>)';
$string['registerallhostsexplain'] = 'ཁྱོད་ཀྱིས་ཁྱོད་ལུ་འབྲེལ་མཐུད་འབད་ནིའི་འབད་རྩོལ་བསྐྱེད་མི་ཆ་མཉམ་ཐོ་བཀོད་འབད་ནིའི་གདམ་ཁ་བརྐྱབ་བཏུབ། འདི་གིས་དྲན་ཐོ་གཅིག་ཁྱོད་ལུ་འབྲེལ་མཐུད་འབད་མི་མུ་ཌེལ་ས་ཁོངས་དང་མི་མང་ལྡེ་ཡིག་ཞུ་བ་འབད་མི་གི་མི་གི་host་ཐོ་བཀོད་གང་རུང་གཅིག་ནང་འཐོན་ནི་ཨིན་པའི་བརྡ་མཚོན་སྟོནམ་ཨིན<br /> འོག་ལུ་\'host ཆ་མཉམ་\' གྱི་དོན་ལུ་ཞབས་ཏོག་རིམ་སྒྲིག་འབད་ནིའི་གདམ་ཁ་ཡོདཔ་དང་འདི་ནང་ལུ་ཞབས་ཏོག་ལ་ལོ་གཅིག་ལྕོགས་ཅན་བཟོ་ཐོག་ལས་ ཁྱོད་ཀྱིས་MNet་སར་བར་གང་རུང་ལུ་ ཞབས་ཏོག་ཚུ་ཕྱོགས་རི་མེད་པ་འབྱིན་ཚུགས།';
$string['registerhostsoff'] = 'hostཚུ་ཆ་མཉམ་ཐོ་འགོད་འབད་ནི་དོན་ལུ་ད་ལྟོ་<b>མེད</b>';
$string['registerhostson'] = 'hostཚུ་ཆ་མཉམ་ཐོ་འགོད་འབད་ནི་དོན་ལུ་ད་ལྟོ་<b>ཡོད</b>';
$string['remotecourses'] = 'ཐག་རིང་གི་སློབ་ཚན་ཚུ།';
$string['remotehost'] = 'ཐག་རིང་གི་ ཧབ།';
$string['remotehosts'] = 'ཐག་རིང་གི་hosts';
$string['remoteuserinfo'] = '<a href="{$a->remoteurl}">{$a->remotename}</a>ལས་ཐག་རིང་གི་{$a->remotetype} ལག་ལེན་པ - གསལ་སྡུད འཐོབ།';
$string['requiresopenssl'] = 'ཡོངས་འབྲེལ་བཟོ་བ་ལུ་ རང་དབང་OpenSSL ཤཱན་དགོ་པས།';
$string['restore'] = 'སོར་ཆུད';
$string['returnvalue'] = 'སླར་ལོག་ གནས་གོང་།';
$string['reviewhostdetails'] = 'hostརྒྱས་བཤད་བསྐྱར་ཞིབ་འབད';
$string['reviewhostservices'] = 'hostཞབས་ཏོག་ཚུ་བསྐྱར་ཞིབ་འབད';
$string['RPC_HTTP_PLAINTEXT'] = 'HTTP གསང་བཟོ་མེདཔ་';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP(རང་གིས་- མིང་རྟགས་བཀོད་ཡོདཔ་)';
$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (རང་གིས་- མིང་རྟགས་བཀོད་ཡོདཔ་)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (མིང་རྟགས་བཀོད་ཡོདཔ་)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP(མིང་རྟགས་བཀོད་ཡོདཔ་)';
$string['selectaccesslevel'] = 'ཐོ་བཀོད་ནང་ལས་འཛུལ་སྤྱོད་ཀྱི་གནས་རིམ་སེལ་འཐུ་འབད་གནང་།';
$string['selectahost'] = 'ཐག་རིང་གི་host སེལ་འཐུ་འབད་གནང་།';
$string['service'] = 'ཞབས་ཏོག་ མིང་།';
$string['serviceid'] = 'ཞབས་ཏོག་ ID';
$string['servicesavailableonhost'] = '{$a}ནང་ཞབས་ཏོག་འཐོབ་ཚུགས།';
$string['serviceswepublish'] = 'ང་བཅས་ཀྱིས་ {$a} ལུ་ པར་བསྐྲུན་འབད་མི་ཞབས་ཏོག';
$string['serviceswesubscribeto'] = '{$a} གུ་ ང་བཅས་ཀྱིས་མཁོ་མངགས་འབད་མི་ཞབས་ཏོག་';
$string['settings'] = 'གཞི་སྒྲིག';
$string['showlocal'] = 'ཉེ་གནས་ལག་ལེན་པ་ཚུ་སྟོན';
$string['showremote'] = 'ཐག་རིང་གི་ལག་ལེན་པ་ཚུ་སྟོན';
$string['ssl_acl_allow'] = 'SSO ACL: ལག་ལེན་པ་ཆོག{$a->user} from {$a->host}';
$string['ssl_acl_deny'] = 'SSO ACL:ལག་ལེན་པ་མི་ཆོག {$a->user} from {$a->host}';
$string['ssoaccesscontrol'] = 'SSO འཛུལ་སྤྱོད་ཚད་འཛིན';
$string['ssoacldescr'] = 'ཐག་རིང་MNet ཡོངས་འབྲེལ་ལས་དམིགས་བསལ་ལག་ལེན་པ་ཚུ་ལུ་འཛུལསྤྱོད་འབྱིན་ནི/བཀག་ནིའི་དོན་ལུ་ ཤོག་ལེབ་འདི་ལག་ལེན་འཐབ། འ་ནི་འདི་ཁྱོད་ཀྱིས་ཐག་རིང་ལག་ལེན་པ་ཚུ་ལུ་SSOཞབས་ཏོག་བྱིན་པའི་སྐབས་ལཱ་འདབ་བཏུབ་ཨིན་ ཁྱོད་རའི་<em>local</em>ལག་ལེན་པ་ཚུ་མུ་ཌེལ་ཡོངས་འབྲེལ་ཧོསིཊི་གཞན་ཚུ་ནང་བཤལ་འཁྱམ་འབད་ནིའི་ལྕོགས་གྲུབ་ཚད་འཛིན་འབད་ནིའི་དོན་ལུ་ ཁོང་ལུ་<em>mnetlogintoremote</em> ནུས་ཤུགས་བྱིན།';
$string['ssoaclneeds'] = 'ལས་འགན་འདི་ལཱ་འབད་བཏུབ་ནིའི་དོན་ལུ་ མུ་ཌེལ་ཡོངས་འབྲེལ་བཟོ་བ་ འོན་སྦེ་འོང་དགོཔ་དང་ MNetཡོངས་འབྲེལ་བདེན་བཤད་འབད་ནི་པ་ལག་ཨིན་འདི་ ལག་ལེན་པ་རང་བཞིན་གྱིས-ཁ་སྐོང་བརྐྱབ་ནི་ལྕོགས་ཅན་བཟོ་ཡོད་མི་དང་གཅིག་ཁར་ལྕོགས་ཅན་བཟོ་དེ་འོང་དགོ';
$string['strict'] = 'དམ་གྲགས།';
$string['subscribe'] = 'མཁོ་མངགས།';
$string['system'] = 'རིམ་ལུགས།';
$string['testclient'] = 'MNet test client';
$string['testtrustedhosts'] = 'ཁ་བྱང་བརྟག་ཞིབ་འབད';
$string['testtrustedhostsexplain'] = 'IP འདི་བློ་གཏན་ཅན་ཨིན་ན་བལྟ་ནིའི་དོན་ལུ་ ཨའི་པི་ཁ་བྱང་བཙུགས།';
$string['theypublish'] = 'ཁོང་གིས་དཔེ་བསྐྲུན་འབད་ཡོད།';
$string['theysubscribe'] = 'ཁོང་གིས་མཁོ་མངགས་འབད་ཡོད།';
$string['transport_help'] = 'གདམ་ཁ་འདི་ཚུ་ཕན་ཚུ་གཉིས་ཕན་ཨིནམ་ལས་ ཁྱོད་ཀྱི་སར་བར་ལུ་ཡང་ མི་རྟགས་བཀོད་ཡོད་མི་SSL ལག་ཁྱེར་ཡོད་པ་ཅིན་ ཁྱོད་ལུ་ཐག་རིང་གི་host་ལུ་མིང་རྟགས་བཀོད་ཡོད་མི་ SSL ལག་ཁྱེར་ལག་ལེན་འཐབ་བཅུག་ནིའི་དབང་ཚད་ཡོད';
$string['trustedhosts'] = 'XML-RPC hosts';
$string['trustedhostsexplain'] = '<p>བློ་གཏད་ཅན་གྱི་host་ཐབས་ལམ་འདི་གིས་དམིགས་བསལ་གློག་འཕྲུལ་ཚུ་ལུ་ Moodle API་གི་ཡན་ལག་གང་རུང་ལུ་ XML-RPCབརྒྱུད་དེ་ CALLS ལག་ལེན་འཐབ་བཅུགཔ་ཨིན་ འདི་Moodle་གྱི་བྱ་སྤྱོད་ཚད་འཛིན་འབད་ནིའི་ཡིག་ཚུགས་ཚུ་གི་དོན་ལུ་འཐོབ་ཚུགསཔ་དང་ ལྕོགས་ཅན་བཟོ་ནིའི་གདམ་ཁ་ཉེན་ཁ་ཅན་གཅིག་ཨིན་ དོགས་པ་ཡོད་པ་ཅིན་ ཨོཕ་སྦེ་བཞག་</p> <p>འདི་<strong>མེན་</strong> Moodle་ཡོངས་འབྲེལ་བཟོ་བ་གི་དོན་ལུ་<strong>མི་དགོ</strong></p> <p>ལྕོགས་ཅན་བཟོ་ནིའི་དོན་ལུ་  IP་ཁ་བྱང་ཚུ་དང་ཡོངས་འབྲེལ་གྱི་ཐོ་བཀོད་ནང་འཛུལ་ གྲལ་ཐིག་རེ་རེ་གུ་རེ་རེ། དཔེར་ན་ :</p>ཁྱོད་རའི་ཉེ་གནས་host:<br />127.0.0.1<br />ཁྱོད་རའི་ཉེས་གནས་host(ཡོངས་འབྲེལ་block་ཡོད་མི།):<br />127.0.0.1/32<br /> :<br />127.0.0.1/32<br />IP་ཁ་བྱང་ 192.168.0.7:<br />192.168.0.7/32<br />ཡོད་མི། ཨའི་པི་ཁ་བྱང་ 192.168.0.1 དང་ 192.168.0.255:<br />192.168.0.0/24གི་བར་ན་ཡོད་མི་host་གང་རངུ་<br />host་གང་རུང་:<br />192.168.0.0/0<br />མཇུག་གི་དཔེ་འདི་གསལ་ཏོག་ཏོ་སྦེ་ ངོ་སྦྱོར་འབད་<strong>མ་འབད་བའི་</strong>རིམ་སྒྲིག་གཅིག་ཨིན།';
$string['turnitoff'] = 'ཨ་ནི་འགྱུར་མ་བཏུབ་བཟོ།';
$string['turniton'] = 'ཨ་ནི་འགྱུར་བཏུབ་བཟོ།';
$string['type'] = 'དབྱེ་བ།';
$string['unknown'] = 'ཧ་མ་གོ།';
$string['unknownerror'] = 'བདེ་སྒྲིག་འབད་བའི་སྐབས་ མ་ཤེས་པའི་འཛོལ་བ་བྱུང་ཡོདཔ།';
$string['usercannotchangepassword'] = 'ཁྱོད་ཐག་རིང་གི་ལག་པ་ཨིནམ་ལས་ ཁྱོད་རའི་ཆོག་ཡིག་བསྒྱུར་བཅོས་འབད་མི་ཚུགས་པས།';
$string['userchangepasswordlink'] = 'br /> ཁྱོད་ཀྱི་ཆོག་ཡིག་འདི་<a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a> ནང་ བསྒྱུར་བཅོས་འབད་ཚུགསཔ་འོང་།';
$string['usernotfullysetup'] = 'ཁྱོད་ཀྱི་ལག་ལེན་པའི་རྩིས་ཐོ་དེ་ཆ་མ་ཚང་བས།་ལོག་སྟེ་<a href="{$a}">ཁྱོད་རའི་བྱིན་མཁན་</a>སྦེ་ས་འགྱོ་འབད་གསལ་སྡུད་ཚང་དགོ།  འཆར་སྣང་འབད་ནི་དོན་ལུ་ ཕྱིར་བསྐྱོད་འབད་འདི་ ནང་བསྐྱོད་འབད་དགོ།';
$string['usersareonline'] = 'ཉེན་བརྡ: ད་ལྟོ་ཨ་ཕི་སར་བར་ལས་{$a}ལག་ལེན་པ་ཚུ་ཁྱོད་ཀྱི་ས་ཁོངས་ནང་འཛུལ་སྤྱོད་འབད་དེ་འདུག';
$string['validated_by'] = '<code>{$a}</code>འདི་ཡོངས་འབྲེལ་གིས་ནུས་ལྡན་བཟོ་ཡོདཔ།';
$string['verifysignature-error'] = 'མིང་རྟགས་བདེན་སྦྱོར་འབད་ནི་འཐུས་ཤོར་བྱུང་ཡོདཔ། འཛོལ་བ་གཅིག་བྱུང་ནུག';
$string['verifysignature-invalid'] = 'མིང་རྟགས་བདེན་སྦྱོར་འབད་ནི་འཐུས་ཤོར་བྱུང་ཡོདཔ། པེ་ལོཌི་ འདི་ཁྱོད་ཀྱིས་མིང་རྟགས་བཀོད་དེ་མེདཔ་སྦེ་ཐོནམ་ཨིན་མས།';
$string['version'] = 'ཐོན་རིམ།';
$string['warning'] = 'ཉེན་བརྡ།';
$string['wrong-ip'] = 'ཁྱོད་ཀྱི་IP་ཁ་བྱང་འདི་ང་བཅས་ཀྱི་ཐོ་ཡིག་ནང་ཡོད་མི་ཁ་བྱང་དང་མི་མཐུན་པས།';
$string['xmlrpc-missing'] = 'ཁྱད་རྣམ་འདི་ལག་ལེན་འཐབ་ནིའི་དོན་ལུ་ ཁྱོད་རའི་PHP build ནང་ XML-RPC གཞི་བཙུགས་འབད་དེ་འོང་དགོ';
$string['yourhost'] = 'ཁྱོད་རའིhost';
$string['yourpeers'] = 'ཁྱོད་རའི་དོ་མཉམ་ཚུ།';
