<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'སྦྱོང་ལཱ་ཚུ།';
$string['addcategory'] = 'དབྱེ་རིམ་ ཁ་སྐོང་རྐྱབས།';
$string['addcategoryerror'] = 'དབྱེ་རིམ་ ཁ་སྐོང་རྐྱབ་མ་ཚུགས།';
$string['addexceptionerror'] = 'userid:gradeitem གི་དོན་ལུ་ དམིགས་བསལ་ཁ་སྐོང་རྐྱབ་པའི་སྐབས་ལུ་ འཛོལ་བ་བྱུང་ཡོདཔ།';
$string['addfeedback'] = 'བསམ་ལན་ ཁ་སྐོང་རྐྱབས།';
$string['addgradeletter'] = 'གནས་ཚད་ཀྱི་ཡིག་ ཁ་སྐོང་རྐྱབས།';
$string['addidnumbers'] = 'ID ཨང་ཚུ་ ཁ་སྐོང་རྐྱབས།';
$string['additem'] = 'གནས་ཚདཀྱི་ རྣམ་གྲངས་ ཁ་སྐོང་རྐྱབས།';
$string['addoutcome'] = 'གྲུབ་འབྲས་གཅིག་ ཁ་སྐོང་རྐྱབས།';
$string['addoutcomeitem'] = 'གྲུབ་འབྲས་ཀྱི་ རྣམ་གྲངས་ ཁ་སྐོང་རྐྱབས།';
$string['addscale'] = 'ཆ་ཚད་ ཁ་སྐོང་རྐྱབས།';
$string['aggregateextracreditmean'] = 'གནས་ཚད་ཚུ་ཀྱི་ འབྲིང་ཙམ་(་སྦྱོང་འཐུས་ཚུ་ཐེབས་དང་བཅས་པ)';
$string['aggregatemax'] = 'གནས་ཚད་ མཐོ་ཤོས།';
$string['aggregatemean'] = 'གནས་ཚད་ཚུ་ཀྱི་ འབྲིང་ཙམ།';
$string['aggregatemedian'] = 'གནས་ཚད་ བར་མ།';
$string['aggregatemin'] = 'གནས་ཚད་ དམའ་ཤོས།';
$string['aggregatemode'] = 'གནས་ཚད་ ལེ་ཤ་ཡོད་མི་འདི།';
$string['aggregateonlygraded'] = 'གནས་ཚད་སྟོངམ་མེན་མི་རྐྱངམ་ཅིག་ སྤྱི་བསྡོམས་འབད།';
$string['aggregateonlygraded_help'] = 'སྟོངམ་སྦེ་ཡོད་མི་སྐུགས་གི་ས་སྟོང་དེ་ སྐུགས་དེབ་ནང་མེད་མི་དེ་ཨིན། ཨ་ནི་འདི་ཡང་ཅིན་ ལས་འགུལ་སྐུགས་མ་བྱིན་འདི་ཨིནམ་འོང་ ཡང་ཅིན་ དྲི་ཐུང་ལན་མ་རྐྱབ་མི་དེ་ཨིནམ་འོང་། ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་ཀྱི་ས་སྟོང་དེ་ ཡང་ན་སྐུགས་བསྡོམས་ནང་ཚུད་མ་དགོཔ་ཨིན་ན་ ཡང་ན་སྐུགས་ཉུང་སུ་ཅིག་རྐྱངམ་ཅིག་འབགཔ་ཨིན་ན་གཏན་འབེབས་འབདཝ་ཨིན། དཔེ་འབད་བ་ཅིན་ སྐུགས་༠ དང་༡༠༠གི་བར་ན་ ༠་བྱིན་མི་འདི།';
$string['aggregateoutcomes'] = 'སྤྱི་བསྡོམས་གྲངས་སུ་ གྲུབ་འབྲས་བཙུགས་ནི།';
$string['aggregateoutcomes_help'] = 'ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ ཐོན་འབྲས་དེ་བསྡོམས་ནང་ཚུད་བཞག་ནི་དང་ ཨ་ནི་དེ་རེ་བ་མེད་པའི་དབྱེ་ཁག་ཡོངས་བསྡོམས་དེ་ཨིན།';
$string['aggregatesonly'] = 'སྤྱི་བསྡོམས་ རྐྱངམ་ཅིག།';
$string['aggregatesubcats'] = 'ཡན་ལག་དབྱེ་རིམ་དང་བཅས་ སྤྱི་བསྡོམས།';
$string['aggregatesubcats_help'] = 'ཨ ནི་གཞི་སྒྲིག་དེ་གིས་ ཡན་ལག་དབྱེ་ཁག་ནང་གི་སྐུགས་ཚུ་སྐུགས་བསྡོམས་ནང་ཚུད་མི་ཚུད་གཏན་འབེབས་འབདཝ་ཨིན།';
$string['aggregatesum'] = 'གནས་ཚད་ བསྡོམས།';
$string['aggregateweightedmean'] = 'མཐོ་དམན་ཅན་གྱི་ གནས་ཚད་ འབྲིང་ཙམ།';
$string['aggregateweightedmean2'] = 'མཐོ་དམན་ཅན་གྱི་ གནས་ཚད་ འབྲིང་ཙམ་འཇམ་སམ།';
$string['aggregation'] = 'སྤྱི་་བསྡོམས།';
$string['aggregationcoef'] = 'སྤྱི་བསྡོམས་ གྲངས་རྟགས།';
$string['aggregationcoefextra'] = 'སྦྱོང་འཐུས་ ཐེབས།';
$string['aggregationcoefextrasum'] = 'སྦྱོང་འཐུས་ ཐེབས།';
$string['aggregationcoefextrasum_help'] = 'ག་དེམ་ཅིག་སྦེ་སྐུགས་ཐོབ་སྒྲོམ་དེ་ ཨིན་རྟགས་བཀལ་ཏེ་ཡོད་པ་ཅིན་ དབྱེ་ཁག་དེ་གིས་སྐུགས་ཚད་ཀྱི་ སྐུགས་མཐོ་ཤོས་དེ་ཁ སྐོང་བཀལ་ཏེ་མེདཔ་ཨིན། ཨ་ནི་དེ་གིས་སྐུགས་མཐོ་ཤོས་དེ་ཐོབ་ནི་གིས་གོ་སྐབས་ཡོདཔ་ཨིན་ (གནས་ཁོངས་བདག་སྐྱོང་དེ་ནང་ལུ་ སྐུགས་མཐོ་ཤོས་ཀྱི་ཚད་མཐོཝ་སྦེ་འོང་ནི་ཉན་ཁཡོད) དེ་ཡང་ སྐུགས་མཐོ་ཤོས་མེད་པའི་སྐུགས་སྡེ་ཚུ་ནང་།';
$string['aggregationcoefextraweight'] = 'སྦྱོང་འཐུས་ ཐེབས་ཀྱི་ མཐོ་དམན།';
$string['aggregationcoefextraweight_help'] = 'ག་དེམ་ཅིག་སྦེ་སྐུགས་ཐོབ་ཚད་དེ་༠ལས་མཐོ་སོང་པ་ཅིན་ ཡོངས་བསྡོམས་ཀྱི་སྐབས་ལུ་ སྐུགས་དེ་གིས་སྐུགས་ཐེབ་སྦེ་སྡོདཔ་ཨིན། དབུས་དེ་རྩིཝ་ད་ལུ་ གྲངས་ཚད་དེགི་ཡོངས་བསྡོམས་ཀྱི་དོན་ལས་མ་བསྡོམས་པའི་ཧེ་མ་ སྒྱུར་རྩིས་རྐྱབ་ཨིན།';
$string['aggregationcoefweight'] = 'རྣམ་གྲངས་ མཐོ་དམན།';
$string['aggregationcoefweight_help'] = 'དངོས་གྲངས་ཚད་དེ་ དབྱེ་ཁག་ཡོངས་བསྡོམས་ནང་ དངོས་གྲངས་ཚུ་དབྱེ་ཁག་ཅིག་ནང་ཡོད་མི་ཚུའི་ཁག་ཆེ་ཧིང་བལྟ་ནི་ལུ་ལག་ལེན་འཐབ་ཨིན།';
$string['aggregation_help'] = 'ཡོངས་བསྡོམས་དེ་གིས་ དབྱེ་ཁག་ཅིག་ནང་གི་སྐུགས་དེ་ཚུ་ག་དེ་སྦེ་བསྡོམས་ནི་ཨིན་ན་  གཏན་འབེབས་འབདཝ་ཨིན། དཔེ་འབད་བ་ཅིན  * Mean of gradesདེ་ སྐུགས་ཡོངས་བསྡོམ་དེ་ སྐུགས་བྱིན་པའི་ཁ་གྲངས་གིས་གོ་ནི་དང * Median of grades དེ་སྐུགས་དེ་ཚུ་སྦོམ་ཆུང་དང་འཁྲིལ་སྒྲིག་ནི། Lowest grade * Highest grade * Mode of grades - དེ་སྐུགས་ག་དེ་མང་ཆེ་ཤོས་འཐོནམ་ཨིན་ན་དང་ * Sum of grades དེ་སྐུགས་བསྡོམས་དེ་ ཚད་དང་ལྡན་པའི་སྐུགས་བཀོག་བཞག་མི་ནང་གོ་ནི།';
$string['aggregationposition'] = 'སྤྱི་བསྡོམས་ གནས་ས།';
$string['aggregationposition_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་ཐོ་ནང་ལུ་ དབྱེ་ཁག་དང་སློབ་ཚན་གྱི་སྐུགས་དེ་ ཐོ་གཞུང་ནང་ལུ་ མགུ་ལུ་ཡོདཔ་ཨིན་ན་དང་ མཇུག་ལུ་ཡོདཔ་ཨིན་གཏན་འབེབས་འབདཝ་ཨིན།';
$string['aggregationsvisible'] = 'ཐོབ་ཚུགས་པའི་ སྤྱི་བསྡོམས་ དབྱེ་བ།';
$string['aggregationsvisiblehelp'] = 'ཐོབ་ཚུགསཔསྦེ་ཡོད་པའི་ སྤྱི་བསྡོམས་རིགས་ཆ་མཉམ་སེལ་འཐུ་འབད། སྣ་མང་རྣམ་གྲངས་སེལ་འཐུ་འབད་ནིའི་དོན་ལུ་ Ctrl key བཟུང་སྟེ་བཞག';
$string['allgrades'] = 'དབྱེ་རིམ་ཐོག་ གནས་ཚད་ ཆ་མཉམ།';
$string['allstudents'] = 'སློབ་ཕྲུག་ཚུ་ ཆ་མཉམ།';
$string['allusers'] = 'ལག་ལེན་པ་ཚུ་ ཆ་མཉམ།';
$string['autosort'] = 'རང་བཞིན་དབྱེ་སེལ།';
$string['availableidnumbers'] = 'ཐོབ་ཚུགས་པའི་ id ཨང་གྲངས་ཚུ།';
$string['average'] = 'ཆ་སྙོམས།';
$string['averagesdecimalpoints'] = 'ཀེར་ཐིག་ནང་ཡོད་པའི་ ཆ་སྙོམས་ཚུ་བཅུ་ཚག་ནང་བཞག།';
$string['averagesdecimalpoints_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་དཔྱ་སྙོམས་ཀྱི་ནང་ན་ ཚག་ག་དེ་ཅིག་དགོཔ་ཨིན་ན་དང་ ཡོངས་བསྡོམས་ཚག་གི་གཞི་སྒྲིག་དབྱེ་ཁག་དེ་ ལག་ལེན་འཐབ་ཨིན་ན་གཏན་འབེབས་འབདཝ་ཨིན།';
$string['averagesdisplaytype'] = 'ཆ་སྙོམས་ཚུའི་ ཀེར་ཐིག་ བཀྲམ་སྟོན་དབྱེ་བ།';
$string['averagesdisplaytype_help'] = 'ཨ་ནི་གཞི་སྒྲི་དེ་གིས་ དཔྱ་སྙོམསསྐུགས་དེ་ རྒྱ་ཆ་དང་ སྐུགས་ངོ་མ་ཡང་ན་ཡིག་འབྲུ་གཞན་ལག་ལེན་འཐབ་ནི་ཨིན་ན་གཏན་འབེབས་འབདཝ་ཨིན།';
$string['backupwithoutgradebook'] = 'ཡིག་སྣོད་རྒྱབ་སྣོན་ནང་ གནས་ཚད་ཀི་དེབ་ཀྱི་རིམ་སྒྲིག་མེད།';
$string['badgrade'] = 'བཀྲམ་སྤེལ་འབད་ཡོད་པའི་ གནས་ཚད་འདི་ ནུས་མེད་ཨིན་པས།';
$string['badlyformattedscale'] = 'ལྷོད་རྟགས་ཀྱིས་འཕྱལ་ཡོད་པའི་གནས་གོང་(ཉུང་ཤོས་གནས་གོང་གཉིས་དགོ་)་ཐོ་ཡིག་ཅིག་བཙུགས་གནང་།';
$string['baduser'] = 'བཀྲམ་སྤེལ་འབད་ཡོད་པའི་ ལག་ལེན་པ་འདི་ ནུས་མེད་ཨིན་པས།';
$string['bonuspoints'] = 'ཁེ་འཐུས་ སྐུགས།';
$string['bulkcheckboxes'] = 'སྦུང་ཚད་ཅན་གྱི་ དཔྱད་སྒྲོམ།';
$string['calculatedgrade'] = 'རྩིས་བཏོན་འབད་ཡོད་པའི་ གནས་ཚད།';
$string['calculation'] = 'རྩིས་ལས།';
$string['calculationadd'] = 'རྩིས་ལས་ ཁ་སྐོང་རྐྱབས།';
$string['calculationedit'] = 'རྩིས་ལས་ ཞུན་དག་འབད།';
$string['calculation_help'] = 'སྐུགས་རྩིས་ལུགས་དེ་གིས་ སྐུགས་གཏན་འབེབས་འབདཝ་ཨིན། ལུགས་དེ་ (=)འགོ་བཙུགས་དགོཔ་ཨིན། དེ་ལས་ ཨ་རྟག་རྩིའི་ནང་ལག་ལེན་འཐབ་མི་ ལུགས་ ཐོས་ཤོས་དང་ དམའ་ཤོས་ལ་སོགས་པ་ཚུ་ལག་ལེན་འཐབ་དགོ དགོ་པ་ཅིན་གཞན་མི་སྐུས་དབྱེ་ཚུ་ཡང་གུག་ཤད་གཉིས་ནང་ངོ་རྟགས་ཨང་བཙུགས་ཏེ་ཁ་སྐོང་བཀོད་བཏུབ།';
$string['calculationsaved'] = 'རྩིས་ལས་ སྲུངས་ཡོདཔ།';
$string['calculationview'] = 'རྩིས་ལས་ བཏོན།';
$string['cannotaccessgroup'] = 'དགོངསམ་མ་ཁྲེལ་ སེལ་འཐུ་འབད་ཡོད་པའི་སྡེ་ཚན་གྱི་གནས་ཚད་ལུ་འཛུལ་སྤྱོད་འབད་མི་ཚུགས།';
$string['categories'] = 'དབྱེ་རིམ་ཚུ།';
$string['categoriesanditems'] = 'དབྱེ་རིམ་ཚུ་་དང་རྣམ་་གྲངས་ཚུ།';
$string['categoriesedit'] = 'དབྱེ་རིམ་ཚུ་་དང་རྣམ་་གྲངས་ཚུ་ཞུན་དག་འབད།';
$string['category'] = 'དབྱེ་རིམ།';
$string['categoryedit'] = 'དབྱེ་རིམ་ཞུན་དག་འབད།';
$string['categoryname'] = 'དབྱེ་རིམ་མིང་།';
$string['categorytotal'] = 'དབྱེ་རིམ་བསྡོམས།';
$string['categorytotalfull'] = '{$a->category}་བསྡོམས།';
$string['categorytotalname'] = 'དབྱེ་རིམ་བསྡོམས་ མིང།';
$string['changedefaults'] = 'སྔོན་སྒྲིག་ཚུ་སོར།';
$string['changereportdefaults'] = 'སྙན་ཞུ་སྔོན་སྒྲིག་ཚུ་སོར།';
$string['chooseaction'] = 'བྱ་བ་གདམས...';
$string['choosecategory'] = 'དབྱེ་རིམ་སེལ་འཐུ་འབད།';
$string['combo'] = 'མཚམས་རྟགས་དང་གདམ་ཐོ་ དཀར་ཆག།';
$string['compact'] = 'སྲབ་ཆུང་།';
$string['componentcontrolsvisibility'] = 'གནས་ཚད་རྣམ་གྲངས་འདི་བཱ་བཞག་ཞགཔ་ཨིན་ན་དེ་སྦྱོང་ལཱ་གིས་གཞི་སྒྲིག་གི་ཚད་འཛིན་འབད་ཡོད།';
$string['contract'] = 'གན་འཛིན་དབྱེ་རིམ།';
$string['controls'] = 'ཚད་འཛིན་ཚུ།';
$string['courseavg'] = 'སློབ་ཚན་ ཆ་སྙོམས།';
$string['coursegradecategory'] = 'སློབ་ཚན་ གནས་ཚད་ དབྱེ་རིམ།';
$string['coursegradedisplaytype'] = 'སློབ་ཚན་ གནས་ཚད་ བཀྲམ་སྟོན་ དབྱེ་བ།';
$string['coursegradedisplayupdated'] = 'སློབ་ཚན་གནས་ཚད་བཀྲམ་སྟོན་དབྱེ་བ་འདི་ དུས་མཐུན་བཟོ་ནུག།';
$string['coursegradesettings'] = 'སློབ་ཚན་ གནས་ཚད་ གཞི་སྒྲིག་ཚུ།';
$string['coursename'] = 'སློབ་ཚན་མིང་།';
$string['coursescales'] = 'སློབ་ཚན་ཆ་ཚད་ཚུ།';
$string['coursesettings'] = 'སློབ་ཚན་གཞི་སྒྲིག་ཚུ།';
$string['coursesettingsexplanation'] = 'སློབ་ཚན་གཞི་སྒྲིག་ཚུ་གིས་ སློབ་ཚན་ནང་བཅའ་མར་གཏོགས་མི་ག་རའི་གནས་ཚད་ཀི་དེབ་འབྱུངམ་ཨིན་ན་ གཏན་འབེབས་བཟོཝ་ཨིན།';
$string['coursetotal'] = 'སློབ་ཚན་བསྡོམས།';
$string['createcategory'] = 'དབྱེ་རིམ་གསར་བསྐྲུན་འབད།';
$string['createcategoryerror'] = 'བྱེ་རིམ་གསརཔ་ཅིག་གསར་བསྐྲུན་འབད་མ་ཚུགས།';
$string['creatinggradebooksettings'] = 'སྡེ་རིམ་ཀི་དེབ་གཞི་སྒྲིག་གསར་བསྐྲུན་འབད་ནི།';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'ད་ལྟོའི་རྩ་ལག་སྤྱི་བསྡོམས།';
$string['curveto'] = 'གུག་གུགཔ།';
$string['decimalpoints'] = 'སྤྱིར་བཏང་བཅུ་ཚག།';
$string['decimalpoints_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ གནས་ཚད་ཀྱི་སྐུགས་ནང་ གྲངས་ཡིག་ལུ་ཚག་ག་དེ་ཅིག་དགོཔ་ཨིན་ན་བཟོཝ་ཨིན། ཨ་ནི་དེ་གིས་ ཚག་གི་ཤུལ་ལས་ ཡིག་གྲངས་ལྔ་བཟོ་ཡོད་མི་དེ་གིས་ གྲངས་རྩིས་སྟོན་ནི་ལུ་ གནོད་པ་མེདཔ་ཨིན།';
$string['default'] = 'སྔོན་སྒྲིག།';
$string['defaultprev'] = 'སྔོན་སྒྲིག་({$a})';
$string['deletecategory'] = 'དབྱེ་རིམ་བཏོན་བཏང་།';
$string['disablegradehistory'] = 'གནས་ཚད་སྤྱོད་ཤུལ་ལྕོགས་མིན་བཟོ།';
$string['disablegradehistory_help'] = 'ཧེ་མའི་ལཱ་ཚུ་ རྗེས་ཤུལ་བརྡ་ནི་ཚུ་ལྕོགས་མི་བཟོ། ཨ ནི་དེ་གིས་སར་བར་མགྱོགས་སུ་བཟོ་ནི་དང་ གཞི་གྲངས་མཛོད་ནང་ས་སྒོ་ཡོདཔ་བཟོ་ཚུགས།།';
$string['displaylettergrade'] = 'གནས་ཚད་ ཡིག་ བཀྲམ་སྟོན་འབད།';
$string['displaypercent'] = 'བརྒྱ་ཆ་ཙུ་བཀྲམ་སྟོན་འབད།';
$string['displaypoints'] = 'སྐུགས་བཀྲམ་སྟོན་འབད།';
$string['displayweighted'] = 'མཐོ་དམན་ཅན་གྱི་གནས་ཚད་བཀྲམསྟོན་འབད།';
$string['dropdown'] = 'གདམ་ཐོ་དཀར་ཆག།';
$string['droplow'] = 'དམའ་ཤོས་དེ་བཀོག་བཞག།';
$string['droplowestvalue'] = 'གནས་ཚད་གནས་གོང་དམའ་ཤོས་ བཀོག་བཞག་ནི་ གཞི་སྒྲིག་འབད།';
$string['droplow_help'] = 'ཨ ནི་གཞི་སྒྲིགདེ་གིས་ སྐུགས་དམའ་ཤོས་གཉིས་ཀྱི་གྲངས་ ཡོངས་བསྡོམས་ལས་ ཕྱིར་བཏོན་གཏང་ནི་ལུ་ལྕོགས་ཅན་བཟོཝ་ཨིན།་';
$string['dropped'] = 'བཀོག་བཞག་ཡོདཔ།';
$string['dropxlowest'] = 'X དམའ་ཤོས་བཀོག་བཞག';
$string['dropxlowestwarning'] = 'དྲན་འཛིན: ཁྱོད་ཀྱིས་ drop x དམའ་ཤོས་འདི་ལག་ལེན་འཐབ་པ་ཅིན་ སྡེ་རིམ་གྱིས་ དབྱེ་རིམ་ནང་ཡོད་པའི་དངོས་གྲངས་ག་ར་ལུ་ སྐུགས་ཀྱི་གནས་གོང་ ཡོད་པའི་དབང་ལུ་གཏང་འོང་། སྐུགས་ཀྱི་གནས་གོང་ སོར་སོ་ཨིན་པ་ཅིན་ གྲུབ་འབྲས་འདི་ག་ཅི་བཟུམ་འོང་ག་སླབ་མི་ཤེས།';
$string['duplicatescale'] = 'ཆ་ཚད་རྫུན་མ།';
$string['edit'] = 'ཞུན་དག།';
$string['editcalculation'] = 'རྩིས་ལས་ཞུན་དག་འབད།';
$string['editcalculationverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname}དོན་ལས་ རྩིས་ལས་ཞུན་དག་འབད།';
$string['editfeedback'] = 'བསམ་ལན་ཞུན་དག་འབད།';
$string['editgrade'] = 'གནས་ཚད་ཞུན་དག་འབད།';
$string['editgradeletters'] = 'གནས་ཚད་ཡིག་ཚུ་ཞུན་དག་འབད།';
$string['editoutcome'] = 'གྲུབ་འབྲས་ཞུན་དག་འབད།';
$string['editoutcomes'] = 'གྲུབ་འབྲས་ཚུ་ཞུན་དག་འབད།';
$string['editscale'] = 'ཆ་ཚད་ཞུན་དག་འབད།';
$string['edittree'] = 'དབྱེ་རིམ་དང་རྣམ་གྲངས།';
$string['editverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname}་ཞུན་དག་འབད།';
$string['enableajax'] = 'AJAX ལྕོགས་ཅན་བཟོ།';
$string['enableajax_help'] = 'སྐུགས་བྱིན་མི་གི་སྙན་ཞུ་ནང་ AJAX ལས་འགན་ཁ་སྐོང་བཀོདཔ་ཨིན། དེ་ཡང་སྤྱིར་གཏང་གི་ལས་འགན་ཚུ་མགྱོགས་སུ་དང་སྟབས་བདེ་ཏོག་ཏོ་བཟོ་སྟེ་འབདཝ་ཨིན། ཨ ནི་སྐབས་སུ་Javascriptསྟེག་ཡོདཔ་དང་མེདཔ་ལུ་རག་ལསཔ་ཨིན།';
$string['enableoutcomes'] = 'གྲུབ་འབྲས་ཚུ་ལྕོགས་ཅན་བཟོ།';
$string['enableoutcomes_help'] = 'གྲུབ་འབྲས་ལུ་རྒྱབ་སྐྱོར ༼དེ་ལུ་ ཁྱད་ཆོས དམིགས་གཏོད ཚད་གཞི་ཟེར་ཡང་སླབ་ཨིན༽ ཟེར་མི་དེ་ ང་བཅས་ཀྱིས་སྐུགས་ཚུ་ ཚད་གཞི་གཅིག་ལས་ལྷག་བཞག་སྟེ་བྱིན་ཚུགསཔ་ཨིན་མས། གྲུབ་འབྲས་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ དེ་བཟུམ་མའི་སྐུགས་བྱིན་ཐངས་ཚུ་ ས་ཁོངས་ག་ར་ནང་ བཏུབ་ཨིན།';
$string['encoding'] = 'Encoding';
$string['errorcalculationbroken'] = 'ཡང་ཅིན་རེས་འཁོར་རྒྱབ་རྟེན་དེ་ དང་ཡང་ཅིན་རྩིས་ཕབ་དེ་མེདཔ་ཐལ་སོངཔ་འོང་།';
$string['errorcalculationnoequal'] = 'མན་ངག་འདི་ སྙོམས་རྟགས་(=1+2) གིས་འགོ་བཙུགས་དགོ།';
$string['errorcalculationunknown'] = 'ནུས་མེད་མན་ངག།';
$string['errorgradevaluenonnumeric'] = 'གནས་ཚད་མཐོ་བ་ ཡང་ན་ དམའ་བ་གང་རུང་ལུ་ ཨང་མིན་མ་ ཐོབ་ཡོད།';
$string['errornocalculationallowed'] = 'རྣམ་གྲངས་འདི་ལུ་ རྩིས་བཏོན་མི་ཆོག།';
$string['errornocategorisedid'] = 'དབྱེ་རིམ་མ་བཟོ་བའི་ id ཐོབ་མ་ཚུགས!';
$string['errornocourse'] = 'སློབ་ཚན་བརྡ་དོན་ཐོབ་མ་ཚུགས།';
$string['errorreprintheadersnonnumeric'] = 'eprint-headers དོན་ལུ་ ཨང་ཡིག་མེན་པའིགནས་གོང་ཐོབ་ཅི།';
$string['errorsavegrade'] = 'དགོངསམ་མ་ཁྲེལ་ གནས་ཚད་སྲུང་མ་ཚུགས།';
$string['errorsettinggrade'] = 'ལག་ལེན་ངོ་རྟགས་{$a->userid} གི་སྐུགས་ "{$a->itemname}"སྲུང་ནི་དེ་ལུ་འཛོལ་བ་འདུག';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'གནས་ཚད་དབྱེ་རིམ་ID {$a->id}་གིས་གཞི་སྒྲིག་ དེ་གིས་ "གནས་ཚད་སྟོངམ་མེན་མི་རྐྱངམ་ཅིག་ སྤྱི་བསྡོམས་འབད་" ་དུས་མཐུན་བཟོ་བའི་བསྐབ་ འཛོལ་བ་འདུག།';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'གནས་ཚད་དབྱེ་རིམ་ID {$a->id}་གིས་གཞི་སྒྲིག་ དེ་གིས་ "སྤྱི་བསྡོམས་གྲངས་སུ་ གྲུབ་འབྲས་ཚུ་བཙུགས་ནི" ་དུས་མཐུན་བཟོ་བའི་བསྐབ་ འཛོལ་བ་འདུག།';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'གནས་ཚད་དབྱེ་རིམ་ID {$a->id}་གིས་གཞི་སྒྲིག་ དེ་གིས་ "སྤྱི་བསྡོམས་གྲངས་སུ་ གྲུབ་འབྲས་བཙུགས་ནི" ་དུས་མཐུན་བཟོ་བའི་བསྐབ་ འཛོལ་བ་འདུག།';
$string['errorupdatinggradecategoryaggregation'] = 'གནས་ཚད་དབྱེ་རིམ་ID {$a->id} གིས་སྤྱི་བསྡོམས་དབྱེ་བ་ དུས་མཐུན་བཟོ་བའི་བསྐབ་ འཛོལ་བ་འདུག།';
$string['errorupdatinggradeitemaggregationcoef'] = 'གནས་ཚད་རྣམ་གྲངས་ID {$a->id} གིས་སྤྱི་བསྡོམས་གྲངས་རྟགས་(མཐོ་དམན་ཡང་ན་སྦྱོང་འཐུས་ཐེབས) དུས་མཐུན་བཟོ་བའི་བསྐབ་ འཛོལ་བ་འདུག།';
$string['excluded'] = 'གྲངས་སུ་མེད་པ།';
$string['excluded_help'] = 'ག་དེམ་ཅིག་སྦེ་ ཨིན་རཏགས་བཀལ་ཡོད་པ་ཅིན་ སྐུགས་དེ་ བསྡོམས་རྩིས་ནང་མི་བཙུགས';
$string['expand'] = 'དབྱེ་རིམ་རྒྱ་བསྐྱེད་འབད།';
$string['export'] = 'ཕྱིར་འདྲེན།';
$string['exportalloutcomes'] = 'གྲུབ་འབྲས་ཚུ་ག་ར་ཕྱིར་འདྲེན་འབད།';
$string['exportfeedback'] = 'ཕྱིར་འདྲེན་ནང་ བསམ་ལན་བཙུགས།';
$string['exportonlyactive'] = 'ཕར་འཕུལ་རྐྱབ་མི་ལག་ལེན་ཚུ་བཀོག་བཞག';
$string['exportonlyactive_help'] = 'ལག་ལེན་དོས་སུ་འཐབ་མི་དང་ བཏོན་མ་གཏང་མི་སློབ་ཕྲུག་རྐྱངམ་ཅིག་ ཕྱིར་སྐྱོད་གྲངས་སུ་བཙུགས།';
$string['exportplugins'] = 'ཕྱིར་འདྲེན་ plugins';
$string['exportsettings'] = 'ཕྱིར་འདྲེན་གཞི་སྒྲིག་ཚུ།';
$string['exportto'] = 'ཕྱིར་འདྲེན་འབད་ས།';
$string['extracreditvalue'] = '{$a} གིས་དོན་ལུ་ སྦྱོང་འཐུས་གནས་གོང་ ཐེབས།';
$string['extracreditwarning'] = 'དྲན་འཛིན: དངོས་གྲངས་ཆ་མཉམ་དབྱེ་རིམ་ལས་ ཁྱད་བསྟོན་ཐེབས་ལུ་གཞི་སྒྲིག་འབད་བ་ཅིན་ དེ་ཚུ་ གནས་ཚད་རྩིས་ལས་ནང་ལས་རྩ་བསྐྲད་འགྱོ་འོང་། ག་ཅི་འབད་ཟེར་བ་ཅིན་ དེ་ནང་ སྐུགས་བསྡོམས་མེད།';
$string['feedback'] = 'བསམ་ལན།';
$string['feedbackadd'] = 'བསམ་ལན་ཁ་སྐོང་རྐྱབས།';
$string['feedbackedit'] = 'བསམ་ལན་ཞུན་དག་འབད།';
$string['feedbackforgradeitems'] = '{$a}་གི་བསམ་ལན།';
$string['feedback_help'] = 'ཨ ནི་སྒྲོམ་དེ་གིས་ སྐུགས་ཀྱི་སྐོར་ལས་ བསམ་འཆར་བཀོད་ནི་ཡོད་པ་ཅིན་ དེ་ལྕོགས་ཅན་བཟོཝ་ཨིན།';
$string['feedbacks'] = 'བསམ་ལན་ཚུ།';
$string['feedbacksaved'] = 'བསམ་ལན་སྲུངས་ཡོད།';
$string['feedbackview'] = 'བསམ་ལན་སྟོན།';
$string['finalgrade'] = 'གནས་ཚད་མཐའ་དཔྱད།';
$string['finalgrade_help'] = 'ག་དེམ་ཅིག་སྦེ་ མང་རབ་ཅིག་བྲིས་ཏེ་ཡོད་པའི་དཔྱད་སྒྲོམ་དེ་ ཨིན་རྟགས་བཀལ་ཡོད་པ་ཅིན་ སྐུགས་བསྡོམས་ནི་དང་ བཟོ་ནི་ཚུ་འབད་ཚུགས།';
$string['fixedstudents'] = 'འགྱུར་མེད་སློབ་ཕྲུག་གི་ཀེར་ཐིག།';
$string['fixedstudents_help'] = 'འགྱུར་མེད་སྦེ་བཞག་ཞྀནམ་ལས་ སློབ་ཕྲུག་ཕྲུག་ཐོངམ་སྦེ་རང་ སྐུགས་ཚུ་མར་ཁ སྦེ་ འགྱོ་བཅུགཔ་ཨིན།';
$string['forceoff'] = 'བང་བཙོང་སྟེ: མེདཔ་བཟོ།';
$string['forceon'] = 'བང་བཙོང་སྟེ: ཡོདཔ་བཟོ།';
$string['forelementtypes'] = 'སེལ་འཐུ་འབད་ཡོད་པའི་$a དོན་ལུ་';
$string['forstudents'] = 'སློབ་ཕྲུག་ཚུ་གི་དོན་ལུ།';
$string['full'] = 'ཆ་ཚང་།';
$string['fullmode'] = 'མཐོང་སྣང་ཆ་ཚང་།';
$string['fullview'] = 'མཐོང་སྣང་ཆ་ཚང་།';
$string['generalsettings'] = 'སྤྱིར་བཏང་གཞི་སྒྲིག།';
$string['grade'] = 'གནས་ཚད།';
$string['gradeadministration'] = 'གནས་ཚད་བདག་སྐྱོང༌།';
$string['gradeanalysis'] = 'གནས་ཚད་དཔྱད་ཞིབ།';
$string['gradebook'] = 'གནས་ཚད་ཀི་དེབ།';
$string['gradebookhiddenerror'] = 'གནས་ཚད་ཀི་དེབ་འདི་ ད་ལྟོ་ སློབ་ཕྲུག་ཚུ་གིས་མ་མཐོངམ་སྦེ་གཞི་སྒྲིག་འབད་ཡི།';
$string['gradebookhistories'] = 'གནས་ཚད་སྤྱོད་ཤུལ་ཚུ།';
$string['gradeboundary'] = 'གནས་ཚད་ཡིག་མཐའ་མཚམས།';
$string['gradeboundary_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་ཚུག་ཅིག་གི་ཐོག་་སྤྲོད་ནི་ཨིན་ན དེ་གི་རྒྱ་ཆ་ཉུང་ཤོས་སྟོན་ནི་ལུ་ཆ རོགས་འབདཝ་ཨིན།';
$string['gradecategories'] = 'གནས་ཚད་དབྱེ་རིམ་ཚུ།';
$string['gradecategory'] = 'གནས་ཚད་དབྱེ་རིམ།';
$string['gradecategoryonmodform'] = 'གནས་ཚད་དབྱེ་རིམ།';
$string['gradecategoryonmodform_help'] = 'ཨ ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་སྒྲོམ་ནང་ལུ་ སྐུགས་ཀྱི་དབྱེ་ཁ་ག་དེ་ཡོདཔ་ཨིན་ན་ འཛིན་སྐྱོང་འབདཝ་ཨིན།';
$string['gradecategorysettings'] = 'གནས་ཚད་དབྱེ་རིམ་གཞི་སྒྲིག་ཚུ།';
$string['gradedisplay'] = 'གནས་ཚད་བཀྲམ་སྟོན་འབད།';
$string['gradedisplaytype'] = 'གནས་ཚད་ བཀྲམ་སྟོན་ དབྱེ་བ།';
$string['gradedisplaytype_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་བྱིན་མི་དང་ ལག་ལེན་པ་གི་སྙན་ཞུ་ནང་ སྐུགས་ཚུ་ག་དེ་སྦེ་གསལ་སྟོན་འབད་ནི་ཨིན་ན་ གཏན་འབེབས་བཟོཝ་ཨིན། * ངོ་མ་ - སྐུགས་ངོ་མ། * རྒྱ་ཆ། སྐུགས་ཚད་གནས་རིམ་གྱི་དོན་ལུ་ ཡིག་འབྲུ་ཡང་ན་ ཡིག་གུ་ཚུ་ལག་ལེན་འཐབ་ཨིན།';
$string['gradedon'] = 'གནས་ཚད་བཀོད་ཡོདཔ་:{$a}';
$string['gradeexport'] = 'གནས་ཚད་ཕྱིར་འདྲེན།';
$string['gradeexportcustomprofilefields'] = 'གནས་ཚད་ཕྱིར་འདྲེན་སྲོལ་སྒྲིག་གསལ་སྡུད་ས་སྒོ་ཚུ།';
$string['gradeexportcustomprofilefields_desc'] = 'གནས་ཚད་ཕྱིར་འདྲེན་ ནང་ཡོད་མི་ སྲོལ་སྒྲིག་གསལ་སྡུད་ས་སྒོ་ཚུ་ལྷོད་རྟགས་ཀྱི་སོ་སོ་འཕྱལ་ཏེ་གྲངས་སུ་བཙུགས།';
$string['gradeexportdecimalpoints'] = 'གནས་ཚད་ཕྱིར་འདྲེན་བཅུ་ཚག་སྐུགས།';
$string['gradeexportdecimalpoints_desc'] = 'ཕྱིར་འདྲེན་ གྱི་དོན་ལུ་བཀྲམ་སྟོན་འབད་ནི་ བཅུ་ཚག་ཨང་གྲངས་ཚུ།';
$string['gradeexportdisplaytype'] = 'གནས་ཚད་ ཕྱིར་འདྲེན་བཀྲམ་སྟོན་དབྱེ་བ།';
$string['gradeexportdisplaytype_desc'] = 'ཕྱིར་འདྲེན་འབད་བའི་བསྒང་ གནས་ཚད་ཚུ་ གནས་ཚད་ངོ་མ་བརྒྱ་ཆ་ཚུ་སྦེ་(ཉུང་མཐའ་དང་མང་མཐའ་གནས་ཚད་ཚུ་ གཞི་བསྟུན་དང་འཁྲིལ་ཏེ) ཡང་ན་ཡི་གུ་ཚུ་སྦེ(A, B, C ལ་སོགས་པ)་སྟོན་བཏུབ། ཕྱིར་འདྲེན་འབད་བའི་བསྒང་ འདི་མེདཔ་གཏང་ཚུགས།';
$string['gradeexportuserprofilefields'] = 'གནས་ཚད་ ཕྱིར་འདྲེན་ལག་ལེན་པའི་གསལ་སྡུད་ས་སྒོ་བཀྲམ་སྟོན།';
$string['gradeexportuserprofilefields_desc'] = 'གནས་ཚད་ཕྱིར་འདྲེན་ ནང་ཡོད་མི་ ལག་ལེན་པའི་གསལ་སྡུད་ས་སྒོ་ཚུ་ ལྷོད་རྟགས་ཀྱི་སོ་སོ་འཕྱལ་ཏེ་ གྲངས་སུ་བཙུགས།';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'གནས་ཚད་གྲོགས་རམ།';
$string['gradehistorylifetime'] = 'གནས་ཚད་སྤྱོད་ཤུལ་ཡུན་གནས།';
$string['gradehistorylifetime_help'] = 'ཨ་ནི་དེ་གིས་ སྐུགས་གྱུར་བཅོས་ལུ་ དུས་ཡུན་ག་དེ་ཅི་བཞག་ནི་ཨིན་ན་གཏན་འབེབ་འབདཝ་ཨིན། དེ་ཡང་ག་དེ་རིངམ་བཞག་ཚུགསཔ་ཅིག་བཞག་པ་ཅིན་དྲག ག་དེམ་ཅིག་སྦེ་ ལཱ་གི་དཀའ་ངལ་དང་ གཞི་གྲངས་མཛོད་ནང་མ་ཤོང་པའི་དཀའ་ངལ་འཐོན་པ་ཅིན་ གྲངས་ཐང་དམའ་ཤོས་སྦེ་བཞག་དགོཔ་ཁག་ཆེ།';
$string['gradeimport'] = 'གནས་ཚད་ནང་འདྲེན་བཅུ་ཚག་སྐུགས།';
$string['gradeimportfailed'] = 'ལཱ་འབད་བའི་སྐབས་ལུ་ སྐུགས་ནང་འདྲེན་འབད་མ་ཚུགས། ཁ་གསལ་ཿ';
$string['gradeitem'] = 'གནས་ཚད་རྣམ་གྲངས།';
$string['gradeitemaddusers'] = 'གནས་ཚད གྲངས་སུ་མ་བརྩི།';
$string['gradeitemadvanced'] = 'གནས་ཚད་རྣམ་གྲངས་ གདམ་ཁ་རྒྱས་པ་ཚུ།';
$string['gradeitemadvanced_help'] = 'སྐུགས་ཀྱི་ཆ་ཤེས་ཚུ་ཞོུན་འབད་དགན་དག་འབད་བའི་སྐབས་ ག་དེ་སྦེ་གསལ་སྟོན་འབད་དགོཔ་ཨིན་ན་ དེ་ཚུ་གདམ་འཐུ་འབད།';
$string['gradeitemislocked'] = 'སྦྱོང་ལཱ་འདི་ གནས་ཚད་ཀི་དེབ་ནང་བསྡམ་བཞག་ནུག། སྦྱོང་ལཱ་འདི་ནང་ གནས་ཚད་ལུ་བསྒྱུར་བཅོས་ག་ཅི་ར་བཟོ་ཡོད་རུང་ ལྡེ་མིག་མ་ཕྱེ་ཚུན་ གནས་ཚད་ཀི་དེབ་ནང་ འདྲ་བཤུས་མི་འབད།';
$string['gradeitemlocked'] = 'གནས་ཚད་བསྡམ་བཞག་ཡོདཔ།';
$string['gradeitemmembersselected'] = 'གནས་ཚད་གྲལ་ལས་བཏོན་བཏང་ཡོདཔ།';
$string['gradeitemnonmembers'] = 'གནས་ཚད་ནང་བཙུགསཡོདཔ།';
$string['gradeitemremovemembers'] = 'གནས་ཚད་ནང་བཙུགས།';
$string['gradeitems'] = 'གནས་ཚད་རྣམ་གྲངས་ཚུ།';
$string['gradeitemsettings'] = 'གནས་ཚད་རྣམ་གྲངས་གྱི་གཞི་སྒྲིག་ཚུ།';
$string['gradeitemsinc'] = 'བཙུགས་དགོ་པའི་གནས་ཚད་རྣམ་གྲངས།';
$string['gradeletter'] = 'གནས་ཚད་ཡིག།';
$string['gradeletter_help'] = 'སྐུགས་ཀྱི་ཡིག་འབྲུ་ཚུ་ ཀ་ཁ་ག་་་་་ཡང་ན་ཚིག་ རབ། འབྲིང་། མཐར་འཁྱོལ་་་་་་ཚུ་སྐུགས་སྟོན་ནི་ལུ་ལག་ལེན་འཐབ་ཨིན།';
$string['gradeletternote'] = 'གནས་ཚད་ཡི་གུ་བཏོན་བཏང་ནི་གི་དོན་ལས་ <br />ཡི་གུའི་ཚིག་ཡིག་གསུམ་གྱི་ས་སྒོ་སྟོངམ་བཏོན་ཏེ་ སྤྲོད་ གུ་ཨེབ་གཏང་འབད།';
$string['gradeletters'] = 'གནས་ཚད་ཡིག་ཚུ།';
$string['gradelocked'] = 'གནས་ཚད་འདི་བསྡམ་བཞག་ནུག';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'གནས་ཚད་མཐོ་ཤོས།';
$string['grademax_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ གྲངས་ཡིག་ལག་ལེན་འཐབ་པའི་སྐབས་ སྐུགས་ཐོ་ཤཽས་གཏན་འབེབས་འབདཝ་ཨིན། སྦྱོང་ལཱ་་དེ་གི་སྐུགས་ཐོ་ཤོས་དེ་ སྦྱོང་ལཱ་རང་སོའི་ སྒྲིག་བཀོད་ཤོག་གུ་ཡོད།';
$string['grademin'] = 'གནས་ཚད་ཉུང་མཐའ།';
$string['grademin_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ རྩིས་བཅུད་ལག་ལེན་འཐབ་པའི་སྐབས་ སྐུགས་ཉུང་ཤོས་ག་ཨིན་ན་ གཏན་འབེབ་འབདཝ་ཨིན།';
$string['gradeoutcomeitem'] = 'གནས་ཚད་་གྲུབ་འབྲས་རྣམ་གྲངས།';
$string['gradeoutcomes'] = 'གྲུབ་འབྲས་ཚུ།';
$string['gradeoutcomescourses'] = 'སློབ་ཚན་གྲུབ་འབྲས་ཚུ།';
$string['gradepass'] = 'མཐར་འཁྱོལ་ནི་གནས་ཚད།';
$string['gradepass_help'] = 'ཨ་ནི་སྒྲིག་བཀོད་དེ་གིས་ མཐར་འཁྱོལ་ནི་གི་དོན་ལས་ སྐུགས་དམའ་ཤོས་ག་དེམ་ཅིག་དགོཔ་ཨིན་ན་གཏན་འབེབ་འབདཝ་ཨིན། རྩིས་བཅུད་དེ་སློབ་ཚན་མཇུག་བསྡུ་བའི་སྐབས་ སྐུགས་དེབ་ནང་ལག་ལེན་འཐབ་ཨིན། དེ་ཡང་མཐར་འཁྱོལ་མི་ལུ་ མདོག་ལྗང་ཁུ་དང་ མཁྱོལ་མི་ལུ་མདོག་ དམརཔོ་སྦེ་རྟགས་བཀལ་སྡོད་འོང་།';
$string['gradepreferences'] = 'གནས་ཚད་དགའ་གདམ་ཚུ།';
$string['gradepreferenceshelp'] = 'གནས་ཚད་དགའ་གདམ་ཚུའི་གྲོགས་རམ།';
$string['gradepublishing'] = 'དེབ་བསྐྲུན་ལྕོགས་ཅན་བཟོ།';
$string['gradereport'] = 'གནས་ཚད་སྙན་ཞུ།';
$string['graderreport'] = 'གནས་ཚད་ཕྱེ་མིའི་སྙན་ཞུ།';
$string['grades'] = 'གནས་ཚད་ཚུ།';
$string['gradesforuser'] = '{$a->user}གི་དོན་ལུ་ གནས་ཚད་ཚུ།';
$string['gradesonly'] = 'གནས་ཚད་ཚུ་རྐྱངམ་ཅིག།';
$string['gradessettings'] = 'གནས་ཚད་གཞི་སྒྲིག།';
$string['gradetype'] = 'གནས་ཚད་དབྱེ་བ།';
$string['gradeview'] = 'གནས་ཚད་བལྟ།';
$string['gradewasmodifiedduringediting'] = '{$a->itemname} for {$a->username} ལུ་སྐུགས་བཙུགས་མི་དེ་ མི་གཞན་མི་ཅིག་གིས་ དུས་མཐུན་ཕྲལ་ཁམས་ཅིག་ཁར་བཟོ་ཡོདཔ་ལས་ སྣང་མེད་སྦེ་བཞག་ཡོད།';
$string['gradeweighthelp'] = 'གནས་ཚད་མཐོ་དམན་གྲོགས་རམ།';
$string['groupavg'] = 'གནས་ཚད་ཆ་སྙོམས།';
$string['hidden'] = 'སྦ་ཡོདཔ།';
$string['hiddenasdate'] = 'སྦ་ཡོད་པའི་གནས་ཚད་ཚུ་གིས་དོན་ལུ་ སྤྲོད་ཡོད་པའི་ཚེས་གྲངས་སྟོན།';
$string['hiddenasdate_help'] = 'ལག་ལེན་པ་གིས་ སྦ་ཡོད་པའི་སྐུགས་དེ་མ་ཐོང་པ་ཅིན་ \'-\'་མེན་པར་སྤྲོད་ཡོད་པའི་ཟླ་ཚེས་དེ་སྟོན';
$string['hiddenuntil'] = 'ཚུན་ཚོད་སྦ་ཡོདཔ།';
$string['hiddenuntildate'] = '{$a}:ཚུན་ཚོད་སྦ་ཡོདཔ།';
$string['hideadvanced'] = 'མཐོ་རིམ་ཅན་གྱི་ཁྱད་ཆོས་ཚུ་སྦ་བཞག།';
$string['hideaverages'] = 'ཆ་སྙོམས་ཚུ་སྦ་བཞག།';
$string['hidecalculations'] = 'རྩིས་ལས་ཚུ་སྦ་བཞག།';
$string['hidecategory'] = 'སྦ་ཡོདཔ།';
$string['hideeyecons'] = 'ངོས་པར་སྟོན/སྦ་ སྦ་བཞག';
$string['hidefeedback'] = 'བསམ་ལན་སྦ་བཞག';
$string['hideforcedsettings'] = 'བང་ཅན་གཞི་སྒྲིག་ཚུ་སྦ་བཞག།';
$string['hideforcedsettings_help'] = 'སྐུགས་ཀྱི་UIཤུགས་ཅན་ཐོག་གཞི་སྒྲིག་འབད་མི་ཚུ་མ་སྟོན།';
$string['hidegroups'] = 'སྡེ་ཚན་ཚུ་སྦ་བཞག།';
$string['hidelocks'] = 'ལྡེ་མིག་ཚུ་སྦ་བཞག།';
$string['hidenooutcomes'] = 'གྲུབ་འབྲས་ཚུ་སྟོན།';
$string['hidequickfeedback'] = 'འཕྲལ་མགྱོགས་བསམ་ལན་སྦ་བཞག';
$string['hideranges'] = 'ཁྱབ་ཚད་ཚུ་སྦ་བཞག།';
$string['hidetotalifhiddenitems'] = 'བསྡོམས་ཚུ་ནང་་རྣམ་གྲངས་ཚུ་སྦ་བཞག་ཡོད་པ་ཅིན་ དེ་སྦ་བཞག།';
$string['hidetotalshowexhiddenitems'] = 'སྦ་བཞག་ཡོད་པའི་རྣམ་གྲངས་མ་བརྩི་བའི་ བསྡོམས་ཚུ་སྟོན།';
$string['hidetotalshowinchiddenitems'] = 'སྦ་བཞག་ཡོད་པའི་རྣམ་གྲངས་བརྩི་བའི་ བསྡོམས་ཚུ་སྟོན།';
$string['hideverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname}་སྦ།';
$string['highgradeascending'] = 'སྡེ་རིམ་ཡར་འཛེགས་མཐོ་བའི་སྒོ་ལས་དབྱེ་སེལ་འབད།';
$string['highgradedescending'] = 'གནས་ཚད་མར་འབབ་མཐོ་བའི་སྒོ་ལས་དབྱེ་སེལ་འབད།';
$string['highgradeletter'] = 'མཐོ་བ།';
$string['identifier'] = 'ལག་ལེན་པ་ངོས་འཛིན་འབད་མི།';
$string['idnumbers'] = 'Id ཨང་གྲངས་ཚུ།';
$string['ignore'] = 'སྣང་མེད་བསྐྱུར་བཞག';
$string['import'] = 'ནང་འདྲེན།';
$string['importcsv'] = 'CSV ནང་འདྲེན་འབད།';
$string['importcustom'] = 'སྲོལ་སྒྲིག་གྲུབ་འབྲས་སྦེ་ནང་འདྲེན་འབད་(སློབ་ཚན་འདི་རྐྱངམ་ཅིག་)།';
$string['importerror'] = 'script་འདི་ ཚད་བཟུང་དང་མ་ལྡནམ་ལས་ འཛོལ་བ་བྱུང་ཡོདཔ།';
$string['importfailed'] = 'ནང་འདྲེན་འཐུས་ཤོར་བྱུང་ཡོདཔ།';
$string['importfeedback'] = '་བསམ་ལན་ནང་འདྲེན་འབད།';
$string['importfile'] = 'ཡིག་སྣོད་ནང་འདྲེན་འབད།';
$string['importfilemissing'] = 'ཡིག་སྣོད་མ་ཐོབ་ལས་ བཀང་ཤོག་ལུ་ལོག་འགྱོ་སྟེ་ ནུས་ཅན་ཡིག་སྣོད་ཅིག་ སྐྱེལ་བཙུགས་འབད།';
$string['importfrom'] = 'ལས་ ནང་འདྲེན་འབད།';
$string['importoutcomenofile'] = 'སྐྱེལ་བཙུགས་འབད་ཡོད་པའི་ཡིག་སྣོད་འདི་སྟོངམ་ ཡང་ན་ མེདཔ་ཐལ་ཡོདཔ། འ་ནི་འདི་ ནུས་ཅན་ཡིག་སྣོད་སྦེ་བདེན་སྦྱོར་འབད་གནང་། དཀའ་ངལ་དེ་ཡང་ གྲལ་ཐིག་  {$a} ལུ་ སྐྱོན་འཛིན་བྱུང་ཡོདཔ་ཨིན། དེ་ཡང་ གྲལ་ཐིག་དང་པ་(མགོ་ཡིག་གྲལ་ཐིག་)ནང་བཟུམ་སྦེ་ ཀེར་ཐིག་ལེ་ཤ་མེད་མི་ ཡང་ན་ ནང་འདྲེན་ཅན་གྱི་ཡིག་སྣོད་ལུ་ རེ་འདོད་ཅན་གྱི་་མགོ་ཡིག་མེད་པ་ཅིན་ གནད་སྡུད་གྲལ་ཐིག་གིས་ འབད་བཅུགཔ་ཨིན། ནུས་ཅན་མགོ་ཡིག་དང་ལྡན་པའི་ཡིག་སྣོ་ད་ཀྱི་དཔེ་འདི་ ཕྱིར་འདྲེན་འབད་ཡོད་པའི་ཡིག་སྣོད་ལུ་བལྟ།';
$string['importoutcomes'] = 'གྲུབ་འབྲས་ཚུ་ནང་འདྲེན་འབད།';
$string['importoutcomesuccess'] = 'ནང་འདྲེན་འབད་ཡོད་པའི་གྲུབ་འབྲས་"{$a->name}" དང་ ID #{$a->id} བཅསཔ།';
$string['importplugins'] = 'plugins་ནང་འདྲེན་འབད།';
$string['importpreview'] = 'སྔོན་ལྟ་ནང་འདྲེན་འབད།';
$string['importsettings'] = 'གཞི་སྒྲིག་ཚུ་ནང་འདྲེན་འབད།';
$string['importskippednomanagescale'] = 'ཁྱོད་ལུ་ ཆ་ཚད་གསརཔ་ཁ་སྐོང་འབད་ནིའི་གནང་བ་མེད་པར་ ཆ་ཚད་གསརཔ་ཅིག་བཟོ་དགོཔ་་ལས་ གྲུབ་འབྲས་  "{$a}" འདི་ བགོམ་འགྱོ་ཡོདཔ་ཨིན།';
$string['importskippedoutcome'] = 'གྲུབ་འབྲས་མིང་ཐུང་ "{$a}"་འདི་ སྐབས་དོན་འདི་ནང་ ཧེ་མ་ལས་ཡོདཔ་ལས་བརྟེན་ ནང་འདྲེན་ཅན་གྱི་ཡིག་སྣོད་ནང་ཡོད་མི་གཅིགཔ་འདི་ གོམ་འགྱོ་ཡོདཔ་ཨིན།';
$string['importstandard'] = 'ཚད་ལྡན་གྲུབ་འབྲས་ཚུ་སྦེ་ ནང་འདྲེན་འབད།';
$string['importsuccess'] = 'གམས་ཚད་ནང་འདྲེན་མཐར་འཁྱོལ།';
$string['importxml'] = 'XML ནང་འདྲེན་འབད།';
$string['includescalesinaggregation'] = 'སྤྱི་བསྡོམས་ནང་ ཆ་ཚད་ཚུ་བཙུགས།';
$string['incorrectcourseid'] = 'སློབ་ཚན་ ID འདི་ འཛོལ་སོ་ནུག།';
$string['incorrectcustomscale'] = '(བདེན་མེད་སྲོལ་སྒྲིག་གནས་ཚད་ བསྒྱུར་བཅོས་འབད་གནང་)';
$string['incorrectminmax'] = 'ཉུང་མཐའ་འདི་ མང་མཐའ་ལས་དམའ་དགོ';
$string['inherit'] = 'འདྲ་འཛིན།';
$string['intersectioninfo'] = 'སློབ་ཕྲུག་/གནས་བརྡ་དོན།';
$string['item'] = 'རྣམ་གྲངས།';
$string['iteminfo'] = 'རྣམ་གྲངས་བརྡ་དོན།';
$string['itemname'] = 'རྣམ་གྲངས་མིང་།';
$string['itemnamehelp'] = 'ཚད་གཞི་གྱིས་བཙུགས་ཡོད་པའི་རྣམ་གྲངས་མིང་།';
$string['items'] = 'རྣམ་གྲངས་ཚུ།';
$string['itemsedit'] = 'གནས་ཚད་རྣམ་གྲངས་ཞུན་དག་འབད།';
$string['keephigh'] = 'མཐོ་ཤོས་འདི་བཞག།';
$string['keymanager'] = 'ལྡེ་ཡིག་འཛིན་སྐྱོང་པ།';
$string['lessthanmin'] = '{$a->itemname}གི་ {$a->itemname}དོན་ལུ་བཙུགས་ཡོད་པའི་སྡེ་རིམ་འདི་ གནང་བ་ཡོད་པའི་ཉུང་མཐའ་ལས་ཉུང་པས།';
$string['letter'] = 'ཡི་གུ།';
$string['lettergrade'] = 'གནས་ཚད་ཡི་གུ།';
$string['lettergradenonnumber'] = 'གནས་ཚད་དམའ་བ་/ཡང་ན་ མཐོ་བ་ཚུ་ ཨང་མིན་ཨིན།';
$string['letterpercentage'] = 'ཡི་གུ(བརྒྱ་ཆ)';
$string['letterreal'] = 'ཡི་གུ(ངོ་མ་)';
$string['letters'] = 'ཡི་གུ་ཚུ།';
$string['linkedactivity'] = 'འབྲེལ་མཐུད་ཅན་གྱི་སྦྱོང་ལཱ།';
$string['linktoactivity'] = '$a->name སྦྱོང་ལཱ་ལུ་འབྲེལ་ལམ་བཟོ།';
$string['lock'] = 'བསྡམ་བཞག།';
$string['locked'] = 'བསྡམ་བཞག་ཡོདཔ།';
$string['locktime'] = 'ཤུལ་ལས་བསྡམ་བཞག།';
$string['locktimedate'] = '{$a}ཤུལ་ལས་བསྡམ་བཞག་ཡོདཔ།';
$string['lockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname}བསྡམ་བཞག།';
$string['lowest'] = 'དམའ་ཤོས།';
$string['lowgradeletter'] = 'དམའ་བ།';
$string['manualitem'] = 'ལག་ཐོག་རྣམ་གྲངས།';
$string['mapfrom'] = 'འཆར་བཀོད་འབད་ཡུལ།';
$string['mappings'] = 'གནས་ཚད་རྣམ་གྲངས་འཆར་བཀོད།';
$string['mapto'] = 'འཆར་བཀོད་འབད་ས།';
$string['max'] = 'མཐོ་ཤོས།';
$string['maxgrade'] = 'གནས་ཚད་མཐོ་ཤོས།';
$string['meanall'] = 'གནས་ཚད་ཚུ་ཆ་མཉམ།';
$string['meangraded'] = 'སྟོངམ་མེན་པའི་གནས་ཚད་ཚུ།';
$string['meanselection'] = 'ཀེར་ཐིག་ཆ་སྙོམས་ཀྱི་དོན་ལུ་སེལ་འཐུ་འབད་ཡོད་པའི་སྡེ་རིམ།';
$string['median'] = 'གུང་ཐིག';
$string['min'] = 'དམའ་ཤོས།';
$string['missingscale'] = 'ཆ་ཚད་འདི་སེལ་འཐུ་འབད་དགོ';
$string['mode'] = 'ལེ་ཤ་ཡོད་མི་འདི།';
$string['morethanmax'] = '{$a->username}གི་  {$a->itemname}དོན་ལུ་བཙུགས་ཡོད་པའི་གནས་ཚད་འདི་ གནང་བ་ཡོད་པའི་མང་མཐའ་ལས་ལྷག་པས།';
$string['moveselectedto'] = 'སེལ་འཐུ་འབད་ཡོད་པའི་རྣམ་གྲངས་ཚུ་སྤོ་བཤུད་འབད།';
$string['movingelement'] = '$a སྤོ་བཤུད་འབད་ནི།';
$string['multfactor'] = 'སྒྱུར་བྱེད།';
$string['multfactorvalue'] = '{$a}་གིས་སྒྱུར་བྱེད་གནས་གོང།';
$string['mypreferences'] = 'ངེ་གི་དགའ་གདམ་ཚུ།';
$string['myreportpreferences'] = 'ངེའི་སྙན་ཞུ་དགའ་གདམ་ཚུ།';
$string['navmethod'] = 'འཛུལ་བསྐྱོད་ཐབས་ལམ།';
$string['neverdeletehistory'] = 'སྤྱོད་ཤུལ་ནམ་ཡང་བཏོན་མ་གཏང་།';
$string['newcategory'] = 'དབྱེ་རིམ་གསརཔ།';
$string['newitem'] = 'གནས་ཚད་རྣམ་གྲངས་གསརཔ།';
$string['newoutcomeitem'] = 'གྲུབ་འབྲས་རྣམ་གྲངས་གསརཔ།';
$string['no'] = 'མེད།';
$string['nocategories'] = 'སློབ་ཚན་འདི་གི་དོན་ལུ་ གནས་ཚད་དབྱེ་རིམ་ཁ་སྐོང་རྐྱབ་མ་ཚུགས་ ཡང་ན་ མ་ཐོབ།';
$string['nocategoryname'] = 'དབྱེ་རིམ་མིང་མ་བྱིན་པས།';
$string['nocategoryview'] = 'བལྟ་ནིའི་དབྱེ་རིམ་མིན་འདུག།';
$string['nocourses'] = 'ད་ལྟོ་ཚུན་ཚོད་ སློབ་ཚན་ཚུ་མེད།';
$string['noforce'] = 'བང་མ་བཙོང་།';
$string['nogradeletters'] = 'གནས་ཚད་ཡིག་ཚུ་གཞི་སྒྲིག་མ་འབད་བས།';
$string['nogradesreturned'] = 'གནས་ཚདཚུ་ལོག་མ་ལྷོད་པས།';
$string['noidnumber'] = 'id ཨང་མེད།';
$string['nolettergrade'] = 'དོན་ལུ་གནས་ཚད་ཡིག་མེད།';
$string['nomode'] = 'འཇུག་ཁྱབ་མེདཔ།';
$string['nonnumericweight'] = 'དོན་ལུ་ཨང་མིན་གནས་གོང་བེ་ལུ་ཐོབ་ཅི།';
$string['nonunlockableverbose'] = '{$a->itemname}འདི་ ལྡེ་མིག་མ་ཕྱེ་ཚུན་ སྡེ་རིམ་འདི་ ལྡེ་མིག་ཕྱེ་མི་ཚུགས།';
$string['nonweightedpct'] = 'མཐོ་དམན་མ་བལྟ་བའི་%';
$string['nooutcome'] = 'གྲུབ་འབྲས་མེད།';
$string['nooutcomes'] = 'གྲུབ་འབྲས་དངོས་གྲངས་ཚུ་ སློབ་ཚན་གྲུབ་འབྲས་དང་འབྲེལ་མཐུད་འབད་དགོཔ་ཨིན་རུང་ སློབ་ཚན་དེ་གི་དོན་ལུ་ གྲུབ་འབྲས་མིན་འདུག ཁྱོད་ཀྱིས་གཅིག་ ཁ་སྐོང་རྐྱབ་ནི་ཨིན་ན?';
$string['nopublish'] = 'དཔེ་བསྐྲུན་མ་འབད།';
$string['norolesdefined'] = 'བདག་སྐྱོང་>གནས་ཚད་>ཡོངས་ཁྱབ་གཞི་སྒྲིག་ཚུ་
>གདས་ཚད་ཡོད་པའི་ལས་འགན་ཚུ་ གིས་ནང་ལས་འགན་ངེས་འཛིན་མ་འབད';
$string['noscales'] = 'གྲུབ་འབྲས་ཚུ་ སློབ་ཚན་ཆ་ཚད་ ཡ་ང་ན་ རྒྱལ་སྤྱི་ཆ་ཚད་དང་འབྲེལ་མཐུད་འབད་དགོཔ་ཨིན་རུང་ ཅི་ཡང་མིན་འདུག ཁྱོད་ཀྱིས་གཅིག་ ཁ་སྐོང་རྐྱབ་ཨིན་ན?';
$string['noselectedcategories'] = 'དབྱེ་རིམ་སེལ་འཐུ་མ་འབད་བས།';
$string['noselecteditems'] = 'རྣམ་གྲངས་སེལ་འཐུ་མ་འབད་བས།';
$string['notteachererror'] = 'ཁྱད་ཆོས་འདི་ལག་ལེན་འཐབ་དགོ་པ་ཅིན་ ཁྱོད་སློབ་དཔོན་འབད་དགོ།';
$string['nousersloaded'] = 'ལག་ལེན་པ་ཚུ་མ་བཙུག་པས།';
$string['numberofgrades'] = 'གནས་ཚད་ཚུ་གིས་ཨང་གྲངས།';
$string['onascaleof'] = '{$a->grademin} ལུ་  {$a->grademax}་ཆ་ཚད་གུ།';
$string['operations'] = 'བཀོལ་སྤྱོད་ཚུ།';
$string['options'] = 'གདམ་ཁ་ཚུ།';
$string['others'] = 'གཞན།';
$string['outcome'] = 'གྲུབ་འབྲས།';
$string['outcomeassigntocourse'] = 'སློབ་ཚན་འདི་ལུ་ གྲུབ་འབྲས་སོར་སོ་འགན་སྤྲོད་འབད';
$string['outcomecategory'] = 'དབྱེ་རིམ་ནང་ལུ་ གྲུབ་འབྲས་ཚུ་གསར་བསྐྲུན་འབད།';
$string['outcomecategorynew'] = 'དབྱེ་རིམ་གསརཔ།';
$string['outcomeconfirmdelete'] = 'ཁྱོད་ཀྱིས་ "{$a}" བཏོན་གཏང་ནི་ཨིན་ན?';
$string['outcomecreate'] = 'གྲུབ་འབྲས་གསརཔ་་ཅིག་ཁ་སྐོང་རྐྱབས།';
$string['outcomedelete'] = 'གྲུབ་འབྲས་བཏོན་གཏང་།';
$string['outcomefullname'] = 'མིག་ཆ་ཚང་།';
$string['outcome_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་ཐོ་དེབ་ནང་ལུ་ ག་དེ་ཁྱད་ཚབ་འབད་ནིཨིན་ན་ གཏན་འབེབས་འབདཝ་ཨིན།';
$string['outcomeitem'] = 'གྲུབ་འབྲས་རྣམ་གྲངས།';
$string['outcomeitemsedit'] = 'གྲུབ་འབྲས་རྣམ་གྲངས་ཞུན་དག་འབད།';
$string['outcomereport'] = 'གྲུབ་འབྲས་སྙན་ཞུ།';
$string['outcomes'] = 'གྲུབ་འབྲས་ཚུ།';
$string['outcomescourse'] = 'སློབ་སྦྱོང་ནང་ལག་ལེན་འཐབ་ཡོད་པའི་གྲུབ་འབྲས་ཚུ།';
$string['outcomescoursecustom'] = 'སྲོལ་སྒྲིག་ལག་ལེན་འཐབ་ཡོད་(རྩ་བསྐྲད་མེད)';
$string['outcomescoursenotused'] = 'ཚད་ལྡན་ལག་ལེན་མ་འཐབ་འབད།';
$string['outcomescourseused'] = 'ཚད་ལྡན་ལག་ལེན་འཐབ་ཡོད་(རྩ་བསྐྲད་མེད)།';
$string['outcomescustom'] = 'སྲོལ་སྒྲིག་གྲུབ་འབྲས་ཚུ།';
$string['outcomeshortname'] = 'མིང་བསྡུསཔ།';
$string['outcomesstandard'] = 'ཚད་ལྡན་གྲུབ་འབྲས་ཚུ།';
$string['outcomesstandardavailable'] = 'ཐོབ་ཚུགས་པའི་ཚད་ལྡན་གྲུབ་འབྲས་ཚུ།';
$string['outcomestandard'] = 'ཚད་ལྡན་གྲུབ་འབྲས།';
$string['outcomestandard_help'] = 'སློབ་ཚན་ག་ར་གི་དོན་ལས་ གྲུབ་འབྲས་ཚད་གཞི་དང་ལྡནམ་ཅིག་་ ས་ཁོངས་ག་ར་ནང་ཡོད།';
$string['overallaverage'] = 'ཡོངས་བསྡོམས་ཆ་སྙོམས།';
$string['overridden'] = 'དབང་ཐག་ཆོད་ཡོདཔ།';
$string['overriddennotice'] = 'སྦྱོང་་ལཱ་ལས་བྱུང་བའི་མཐའ་མཇུག་གནས་ཚད་འདི་ ལག་ཐོག་ལས་བདེ་སྒྲིག་འབད་ནུག།';
$string['overridesitedefaultgradedisplaytype'] = 'དབང་ཐག་ཆོད་ཁོངས་སྔོན་སྒྲིག་ཚུ།';
$string['overridesitedefaultgradedisplaytype_help'] = 'ག་དེམ་ཅིག་སྦེ་ ཨིན་རྟགས་བཀལ་ཡོད་པ་ཅིན་ སློབ་ཚན་དེ་གི་ཡི་གུ་དང་ མཚམས་དེ་ཚུ་གཞི་སྒྲིག་འབད་ནི་མ་གཏོགས་ ས་ཁོངས་ཀྱི་སྔ་སྒྲིག་དེ་ཚུ་ལག་ལེན་འཐབ་མི་ཚཱུགས།';
$string['parentcategory'] = 'རྩ་ལག་དབྱེ་རིམ།';
$string['pctoftotalgrade'] = 'གནད་ཚད་བསྡོམས་ཀྱི་%';
$string['percent'] = 'བརྒྱ་ཆ།';
$string['percentage'] = 'བརྒྱ་ཆ།';
$string['percentageletter'] = 'བརྒྱ་ཆ་(ཡི་གུ་)';
$string['percentagereal'] = 'བརྒྱ་ཆ་(ངོ་མ)';
$string['percentascending'] = 'བརྒྱ་ཆ་ ཡར་འཛེགས་ཐོག་ལས་ དབྱེ་སེལ་འབད།';
$string['percentdescending'] = 'བརྒྱ་ཆ་ མར་འབབ་ཐོག་ལས་ དབྱེ་སེལ་འབད།';
$string['percentshort'] = '%';
$string['plusfactor'] = 'ནུས་པ་མེདཔ་བཟོ་ནི།';
$string['plusfactor_help'] = 'སྡེ་ཚན་གྱི་ཕྱི་ཁར་ཡོད་མི་དེ་ སྒྱུར་རྩིས་རྐྱབ་ཞིནམ་ལས་ སྐུགས་ག་ར་གི་ སྐུགས་གི་ཆ ཤད་ལུ་བསྡོམས་པའི་ཨང་གྲངས་ཅིག་ཨིན།';
$string['plusfactorvalue'] = '{$a} གིས་དོན་ལས་ Offset གནས་གོང་།';
$string['points'] = 'སྐུགས་ཚུ །';
$string['pointsascending'] = 'སྐུགས་ཚུ་ཡར་འཛེགས་ཐོག་ལས་དབྱེ་སེལ་འབད།';
$string['pointsdescending'] = 'སྐུགས་ཚུ་མར་འབབ་ཐོག་ལས་དབྱེ་སེལ་འབད།';
$string['positionfirst'] = 'དང་པ།';
$string['positionlast'] = 'མཇུག';
$string['preferences'] = 'དགའ་གདམ་ཚུ།';
$string['prefgeneral'] = 'སྤྱིར་བཏང་།';
$string['prefletters'] = 'གནས་ཚག་ཡིག་ཚུ་དང་མཐའ་མཚམས་ཚུ།';
$string['prefrows'] = 'དམིགས་བསལ་གྲལ་ཐིག་ཚུ།';
$string['prefshow'] = 'སོར་སྟོན་ཚུ་ སྟོན/སྦ།';
$string['previewrows'] = 'གྲལ་ཐིག་ཚུ་ སྔོན་ལྟ།';
$string['profilereport'] = 'ལག་ལེན་པའི་གསལ་སྡུད་ སྙན་ཞུ།';
$string['profilereport_help'] = 'སྐུགས་ཀྱི་གནས་རིམ་སྙན་ཞུ་ ལག་ལེན་པའི་ཤོག་གུ་ ལག་ལེན་འཐབ་ཡོད།';
$string['publishing'] = 'དཔེ་བསྐྲུན་འབད་ནི།';
$string['quickfeedback'] = 'འཕྲལ་མགྱོགས་ བསམ་ལན།';
$string['quickgrading'] = 'འཕྲལ་མགྱོགས་ གནས་ཚད་བཟོ་ནི།';
$string['range'] = 'ཁྱབ་ཚད།';
$string['rangedecimals'] = 'བཅུ་ཚག་ཚུ་གིས་ཁྱབ་ཚད།';
$string['rangedecimals_help'] = 'ཁྱབ་ཚད་ ཀྱི་་དོན་ལུ་བཀྲམ་སྟོན་འབད་ནི་ བཅུ་ཚག་ཨང་གྲངས་ཚུ།';
$string['rangesdecimalpoints'] = 'ཁྱབ་ཚད་ནང་སྟོན་ཡོད་པའི་བཅུ་ཚག།';
$string['rangesdecimalpoints_help'] = 'གཞི་སྒྲིག་དེ་གིས་ ཨང་གྲངས་དེ་ལུ་ ཚག་གི་ཤུལ་ལས་གྲངས་ག་དེམ་ཅིག་སྟོན་ནི་ཨིན་ན་དང་ ཡང་ན་ ཚག་ག་ར་ནང་ལག་ལེན་འཐབ་མ་འཐབ་གཏན་འབེབས་འབདཝ་ཨིན།';
$string['rangesdisplaytype'] = 'ཁྱབ་ཚད་བཀྲམ་སྟོན་དབྱེ་བ།';
$string['rangesdisplaytype_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་ཁྱད་པར་གྱི་ཚད་འདི་ སྐུགས་ངོ་མ་ རྒྱ་ཆ་ དེ་ལས་ ཡིག་ཐོག་སྦེ་སྟོན་མ་སྟོན་དང་ ཡང་ན་གསལ་སྟོན་གྱི་དོན་ལུ་ དབྱེ་ཁ་ལག་ལེན་འཐབ་མ་འཐབ་གཏན་འབེབ་འབདཝ་ཨིན།';
$string['rank'] = 'གྲལ་རིམ།';
$string['rawpct'] = '%མ་བཟོཝ།';
$string['real'] = 'ངོ་མ།';
$string['realletter'] = '(ཡི་གུ་)ངོ་མ།';
$string['realpercentage'] = '(བརྒྱ་ཆ་)ངོ་མ།';
$string['recovergradesdefault'] = 'སྔོན་སྒྲིག་ གནས་ཚད་ཚུ་ སླར་གསོ་འབད།';
$string['recovergradesdefault_help'] = 'ལག་ལེན་པ་ཅིག་ སློབ་ཚན་ཅིག་ནང་ ལོག་འཛུལ་ཞུགས་འབདཝ་ད་ སྐུགས་རྙིམ་ཚུ་རང་བཞིན་གྱིས་ལོག་ཚོལ་ཞིབ་འབད།';
$string['regradeanyway'] = 'ག་དེ་འབད་རུང་ གནས་ཚད་ལོག་ཕྱེ།';
$string['removeallcoursegrades'] = 'གནས་ཚད་ཚུ་ཆ་མཉམ་བཏོན་གཏང་།';
$string['removeallcourseitems'] = 'རྣམ་གྲངས་ཚུ་དབྱེ་རིམ་ཚུ་ཆ་མཉམ་བཏོན་གཏང་།';
$string['report'] = 'སྙན་ཞུ།';
$string['reportdefault'] = 'སྔོན་སྒྲིག་($a)སྙན་ཞུ་འབད།';
$string['reportplugins'] = 'སྙན་ཞུ་གིས་plugins';
$string['reportsettings'] = 'སྙན་ཞུ་ གཞི་སྒྲིག་ཚུ།';
$string['reprintheaders'] = 'མགོ་ཡིག་ཚུ་སླར་དཔར་བསྐྲུན་འབད།';
$string['respectingcurrentdata'] = 'ད་ལྟོའི་རིམ་སྒྲིག་འདི་ ལེགས་བཅོས་མ་འབད་བར་བཞག་ནི།';
$string['rowpreviewnum'] = 'གྲལ་ཐིག་ཚུ་ སྔོན་ལྟ།';
$string['savechanges'] = 'བསྒྱུར་བཅོས་ཚུ་སྲུངས།';
$string['savepreferences'] = 'དགའ་གདམ་ཚུ་སྲུངས།';
$string['scaleconfirmdelete'] = 'ཆ་ཚད་"{$a}"་དེ་སྟོན་བཏང་ནི་ངེས་གཏན་ཨིན་ན?';
$string['scaledpct'] = 'ཆ་ཚད་བཟོ་ཡོདཔ་%';
$string['seeallcoursegrades'] = 'སློབ་ཚན་གྱི་སྡེ་རིམ་ཚུ་ ཆ་མཉམ་སེལ་འཐུ་འབད།';
$string['select'] = '{$a} སེལ་འཐུ་འབད།';
$string['selectalloroneuser'] = 'ལག་ལེན་པ་ཆ་མཉམ་ ཡང་ན་ གཅིག་སེལ་འཐུ་འབད།';
$string['selectauser'] = 'ལག་ལེན་པ་ཅིག་སེལ་འཐུ་འབད།';
$string['selectdestination'] = '{$a}གི་བཞག་སྣོད་སེལ་འཐུ་འབད།';
$string['separator'] = 'དབྱེ་འཕྲུལ།';
$string['sepcolon'] = 'འབྱེད་རྟགས།';
$string['sepcomma'] = 'ལྷོད་རྟགས།';
$string['sepsemicolon'] = 'ཉེ་ཤད།';
$string['septab'] = 'མཚམས་རྟགས།';
$string['setcategories'] = 'དབྱེ་རིམ་ཚུ་གཞི་སྒྲིག་འབད།';
$string['setcategorieserror'] = 'ཁྱོད་ཀྱིས་ ཁོང་ཚུ་ལུ་ མཐོ་དམན་ཚུ་བྱིན་པའི་ཧེ་མ་ དང་པ་ར་ དབྱེ་རིམ་ཚུ་གཞི་སྒྲིག་འབད་དགོ།';
$string['setgradeletters'] = 'གནས་ཚད་ཀྱི་ཡིག་གཞི་སྒྲིག་འབད།';
$string['setpreferences'] = 'དགའ་གདམ་ཚུ་གཞི་སྒྲིག་འབད།';
$string['setting'] = 'གཞི་སྒྲིག།';
$string['settings'] = 'གཞི་སྒྲིག་ཚུ།';
$string['setweights'] = 'མཐོ་དམན་ཚུ་གཞི་སྒྲིག་འབད།';
$string['showactivityicons'] = 'སྦྱོང་ལཱ་གིས་ངོས་དཔར་ཚུ་སྟོན།';
$string['showactivityicons_help'] = 'ག་དེམ་ཅིག་སྦེ་ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ སྦྱོང་ལཱ་གི་རྟགས་ཚུ་ སྦྱོང་ལཱ་གི་མིང་གི་ཟུར་ཁ་འཐོན་སྡོད་འོང་།';
$string['showallhidden'] = 'སྦ་ཡོད་མི་སྟོན།';
$string['showallstudents'] = 'སློབ་ཕྲུགཚུ་་ཆ་མཉམ་སྟོན།';
$string['showanalysisicon'] = 'གཞས་ཚད་དཔྱད་ཞིབ་གིས་ངོས་དཔར་ཚུ་སྟོན།';
$string['showanalysisicon_desc'] = 'སྔོན་སྒྲིག་དེ་གིས་ གཞས་ཚད་དཔྱད་ཞིབ་གིས་ངོས་དཔར་ཚུ་སྟོན་ནི་ཨིན་ན?';
$string['showanalysisicon_help'] = 'ག་དེམ་ཅིག་སྦེ་ སྦྱོང་ལཱ་གི་སྦྱོང་ཚན་དེ་གིས་ ངོས་ལེན་ཡོད་པ་ཅིན་ སྐུགས་རྟག་དཔྱད་རྟགས་དེ་གིས་ རང་བཞིན་གྱིས་ སྐུགས་ཡོད་ས་དང་ སྐུགས་ག་དེ་སྦེ་ཐོབ་ཅི་ག་ ཁ་གསལ་ཡོད་པའི་གནས་ལུ་འཐུད་འོང་།';
$string['showaverage'] = 'ཆ་སྙོམས།';
$string['showaverage_help'] = 'དཔྱ་སྙོམས་ཡོད་པའི་ གྱལ་རིམ་ཅིག་སྟོན་ན་ ག་དེམ་ཅིག་སྦེ་དཔྱ་སྙོམས་དེ་སྐུགས་ཉུང་སུ་ཅིག་ལས་ སྟོན་པ་ཅིན་ སློབ་ཕྲུག་ཚུ་གིས་ སློབ་ཕྲུག་གཞན་མི་ཚུ་གི་སྐུགས་ཚད་དཔག་ཚུགས། བྱ་སྒོ་ལེགས་ཤོམ་གི་དོན་ལུ་ དཔྱ་སྙོམས་དེ་གཞན་ལུ་རྟེན་ཏེ་ སྟོན་པ་ཅིན་ མངམ་ཚོད་རྩིསའོང་།';
$string['showaverages'] = 'ཀེར་ཐིག་ཆ་སྙོམས་སྟོན།';
$string['showaverages_help'] = 'ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ སྐུགས་བྱིན་མི་གི་ སྙན་ཞུ་དེ་ནང་ལུ་ དབྱེ་ཁ་དང་ སྐུགས་ཚུ་གི་དཔྱ་སྙོམས་ཡོད་པའི་ གྱལ་རིམ་ཐེབས་ཅིག་འཐོན་འོང་།';
$string['showcalculations'] = 'རྩིས་ལས་ཚུ་སྟོན།';
$string['showeyecons'] = 'ངོས་དཔར་སྟོན/སྦ་སྟོན།';
$string['showeyecons_help'] = 'ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ ཞུན་དག་འབད་བའི་སྐབས་ལུ་ སྟོན/གཡིབ་ཀྱི་རྟགས་ཅིག་ སློབ་ཕྲུག་གི་འཐོང་མི་མཐོང་ འཛིན་སྐྱོང་འབད་ནིའི་དོན་ལུ་ སྐུགས་རེ་རེ་ལུ་གསལ་སྟོན་འབད་སྡོད་འོང་།';
$string['showfeedback'] = 'བསམ་ལན་སྟོན།';
$string['showfeedback_help'] = 'བསམ་ལན་གྱི་ཀེར་ཐིག་དེ་སྟོན?';
$string['showgrade'] = 'གནས་ཚད་ཚུ་སྟོན།';
$string['showgrade_help'] = 'གནས་ཚད་ཀྱི་ཀེར་ཐིག་དེ་སྟོན?';
$string['showgroups'] = 'སྡེ་ཚན་ཚུ་སྟོན།';
$string['showhiddenitems'] = 'སྦ་ཡོད་པའི་རྣམ་གྲངས་ཚུ་སྟོན།';
$string['showhiddenuntilonly'] = 'སྦ་ཡོད་པའི་བ་རྐྱངམ་ཅིག';
$string['showlettergrade'] = 'གནས་ཚད་ཡིག་སྟོན།';
$string['showlettergrade_help'] = 'གནས་ཚད་ཡིག་གི་ཀེར་ཐིག་དེ་སྟོན?';
$string['showlocks'] = 'ལྡེ་མིག་ཚུ་སྟོན།';
$string['showlocks_help'] = 'ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ ཞུན་དག་འབད་བའི་སྐབས་ ལྡེ་བསྡམ/ལྡེ་ཕྱེ་ཀྱི་རཏྒས་ཅིག་ སྐུགས་ཡར་དྲག་དུས་མཐུན་རང་བཞིན་གྱིས་འགྱོ་མ་འགྱོ་ལྟ་ནིའི་དོན་ལུ་ འཐོན་སྡོད་འོང་།';
$string['shownohidden'] = 'མ་སྟོན།';
$string['shownooutcomes'] = 'གྲུབ་འབྲས་ཚུ་སྦ་བཞག།';
$string['shownumberofgrades'] = 'ཆ་སྙོམས་ཚུ་ནང་ལུ་ གནས་ཚད་ཁ་གྱངས་སྟོན།';
$string['shownumberofgrades_help'] = 'ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ སྒུགས་ཀྱི་གྲངས་ཚུ་ དཔྱ་སྡོམས་སྟོན་ཚར་བའི་ཤུལ་ལས་ དཔྱ་སྡོམས་ཅིག་གུག་ཤད་ནང་འཐོན་སྡོད་འོང་།';
$string['showonlyactiveenrol'] = 'ལྒ་ལེན་འཐབ་བཞིན་པ་ཡོད་མི་ཐོ་བཀོད་རྐྱངམ་ཅིག་སྟོན།';
$string['showonlyactiveenrol_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ དངོས་སུ་ལག་ལེན་འཐབ་ཡོད་པའི་ཐོ་བཀོད་འབད་ཡོད་པའི་ལག་ལེན་པ་ཚུ་ སྐུགས་དེབ་སྙན་ཞུ་ནང་མཐོང་མ་མཐོང་གཏན་འབེབས་འབདཝ་ཨྀན། ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ མཚམས་བཞག་ཡོད་མི་ལག་ལེན་པ་ཚུ་ སྐུགས་དེབ་ནང་མི་སྟོན།';
$string['showpercentage'] = 'བརྒྱ་ཆ་སྟོན།';
$string['showpercentage_help'] = 'སྒུགས་དབྱེ་རེ་རེ་གི་རྒྱ་ཆ སྟོན་ག';
$string['showquickfeedback'] = 'འཕྲལ་མགྱོགས་བསམ་ལན་སྟོན།';
$string['showrange'] = 'ཁྱབ་ཚད་ཚུ་སྟོན།';
$string['showrange_help'] = 'ཁྱད་པར་གྱལ་རིམ་སྟོན་ག';
$string['showranges'] = 'ཁྱབ་ཚད་ཚུ།';
$string['showranges_help'] = 'ལྕོགས་ཅན་བཟོ་ད་པ་ཅིན་ སྐུགས་སྦྱིན་མི་གི་སྙན་ཞུ་དེ་ནང་ལུ་  དབྱེ་ཁ་རེ་རེ་ནང་གི་སྐུགས་ཁྱད་པར་གསལ་སྟོན་འབད་ཡོད་པའི་གྱལ་རིམ་ཐེབས་ཅིག་ཚུད་འོང་།';
$string['showrank'] = 'གྲལ་རིམ་སྟོན།';
$string['showrank_help'] = 'སློབ་ཁང་ནང་གི་གཞན་མི་སྐུགས་དང་འཁྲིལ་ སློབ་ཕྲུག་ཚུ་གི་རིམ་ཨང་སྟོན་ག';
$string['showuserimage'] = 'ལག་ལེན་པའི་གསལ་སྡུད་ནང་གི་གཟུགས་བརྙན་སྟོན།';
$string['showuserimage_help'] = 'ལག་ལེན་པའི་ གྲགས་པར་ཁོ་རའི་མིང་དང་གཅིག་ཁར་སྟོན་ན་མི་སྟོན';
$string['showverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} སྟོན།';
$string['showweight'] = 'མཐོ་དམན་་བྱིན་ཡོད་མི་ཚུསྟོན།';
$string['showweight_help'] = 'གནས་ཚད་མཐོ་དམན་ཀེར་ཐིག་ དེ་སྟོན།';
$string['simpleview'] = 'འཇམ་སམ་མཐོང་སྣང།';
$string['sitewide'] = 'ས་སཁོངས་-ཡོངས་ཆ་མཉམ།';
$string['sort'] = 'དབྱེ་སེལ།';
$string['sortasc'] = 'འཛེགས་རིམ་ལུ་དབྱེ་སེལ་འབད།';
$string['sortbyfirstname'] = 'འགོ་མིང་ཐོག་ལས་དབྱེ་སེལ་འབད།';
$string['sortbylastname'] = 'མཇུག་མིང་སྒོ་ལས་དབྱེ་སེལ་འབད།';
$string['sortdesc'] = 'འབབ་རིམ་ལུ་དབྱེ་སེལ་འབད།';
$string['standarddeviation'] = 'ཚད་ལྡན་ཁ་བསྒྱུར།';
$string['stats'] = 'ཚད་རྩིས་ཚུ།';
$string['statslink'] = 'ཚད་རྩིས།';
$string['student'] = 'སློབ་ཕྲུག';
$string['studentsperpage'] = 'ཤོག་ལེབ་རེ་ལུ་སློབ་ཕྲུག་རེ།';
$string['studentsperpage_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་བྱིན་མི་གི་དེབ་ནང་ལུ་ སློབ་ཕྲུག་གི་གྱངས་ཁ གསལ་སྟོན་འབད་མི་དེ་ གཏན་འབེབས་འབདཝ་ཨིན';
$string['studentsperpagereduced'] = '{$a->originalstudentsperpage} to {$a->studentsperpage}. ལས་སློབ་ཕྲུག་གྱངས་ཁ་མཐོ་ཤོས་ལས་ཕབ་ཕབ།  {$a->maxinputvars}.ལས་PHP གཞི་སྒྲིག་ཡར་འཕེལ་གཏང།';
$string['subcategory'] = 'སྤྱིར་བཏང་དབྱེ་རིམ།';
$string['submissions'] = 'སྤྲོད་ནི།';
$string['submittedon'] = '{$a}:སྤྲོད་ཡོདཔ།';
$string['switchtofullview'] = 'ཆ་ཚང་ལུ་སོར་བསྒྱུར་འབད།';
$string['switchtosimpleview'] = 'འཇམ་སམ་ལུ་སོར་བསྒྱུར་འབད།';
$string['tabs'] = 'མཚམས་རྟགས/མཆོང་ལྡེ།';
$string['topcategory'] = 'དབྱེ་རིམ་ཡང་དག';
$string['total'] = 'བསྡོམས།';
$string['totalweight100'] = 'ཡོངས་བསྡོམས་མཐོ་དམན་དེ་ ༡༠༠ དང་མཉམ་པས།';
$string['totalweightnot100'] = 'ཡོངས་བསྡོམས་མཐོ་དམན་དེ་ ༡༠༠ དང་མི་མཉམ་པས།';
$string['turnfeedbackoff'] = 'བསམ་ལན་ལེན་ནི་མེདཔ་བཟོ།';
$string['turnfeedbackon'] = 'བསམ་ལན་ལེན་ནི་ཡོདཔ་བཟོ།';
$string['typenone'] = 'ཅི་མེད།';
$string['typescale'] = 'ཆ་ཚད།';
$string['typescale_help'] = 'ཨ་ནི་གཞི་སྒྲིག་དེ་གིས་ སྐུགས་ཚད་ ཚད་གཞི་དབྱེ་བའི་སྐབས་ཚད་གཞི་ལག་ལེན་འཐབ་ཡོད་མི་དེ་ གཏན་འབེབས་འབདཝ་ཨིན། སྦྱོང་ལཱ་དང་འབྲེལ་བའི་ཚད་གཞི་གི་སྐུགས་ཚད་དེ་སྦྱོང་ལཱ་གི་ཤོག་གུ་ཡོད་མེད་གཏན་འབེབས་འབདཝ་ཨིན།';
$string['typetext'] = 'ཚིག་ཡིག';
$string['typevalue'] = 'གནས་གོང་།';
$string['uncategorised'] = 'དབྱེ་རིམ་མ་བཟོཝ།';
$string['unchangedgrade'] = 'གནས་ཚད་བསྒྱུར་བཅོས་མེད།';
$string['unenrolledusersinimport'] = 'ནང་འདྲེན་འདི་ནང་ འཕྲལ་གྱི་སློབ་ཚན་ནང་ཐོ་བཙུགས་མ་འབད་མི་ལག་ལེན་པ་ཚུ་གི་དོན་ལུ་ འོག་གི་སྡེ་རིམ་ཚུ་བཙུགས་ཏེ་་ཡོད་:{$a}';
$string['unlimitedgrades'] = 'ཚད་མེད་གནས་ཚད་ཚུ།';
$string['unlock'] = 'ལྡེ་མིག་ཕྱེ།';
$string['unlockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname}་ལྡེ་མིག་ཕྱེ།';
$string['unused'] = 'ལག་ལེན་མ་འཐབ་མི།';
$string['updatedgradesonly'] = 'གནས་ཚད་གསརཔ་ ཡང་ན་ དུས་མཐུན་འབད་ཡོད་མི་རྐྱངམ་ཅིག་ཕྱིར་འདྲེན་འབད།';
$string['uploadgrades'] = 'གནས་ཚད་སྐྱེལ་བཙུགས་འབད།';
$string['useadvanced'] = 'ཁྱད་ཆོས་རྒྱས་པ་ལག་ལེན་འཐབ།';
$string['usedcourses'] = 'ལག་ལེན་འཐབ་ཡོད་པའི་སློབ་ཚན།';
$string['usedgradeitem'] = 'གནས་ཚད་དངོས་གྲངས་ལག་ལེན་འཐབ།';
$string['usenooutcome'] = 'གྲུབ་འབྲས་ལག་ལེན་མ་འཐབ།';
$string['usenoscale'] = 'ཆ་ཚད་ལག་ལེན་མ་འཐབ།';
$string['usepercent'] = 'བརྒྱ་ཆ་ལག་ལེན་འཐབ།';
$string['user'] = 'ལག་ལེན་པ།';
$string['userenrolmentsuspended'] = 'ལག་ལེན་པའི་མཐོ་བཀོད་ཕར་འཕུལ་ཡོདཔ།';
$string['usergrade'] = 'དབྱེ་སྡེ་{$a->gradeidnumber}གུལག་ལེན་པ་ {$a->fullname} ({$a->useridnumber})';
$string['userid'] = 'ལག་ལེན་པའི་ངོ་རྟགས།';
$string['usermappingerror'] = 'ལག་ལེན་པ་ཚུའི་མཐུན་འབྲེལ་ལུ་འཛོལ་བ་འདུག ལག་ལེན་པ་{$a->field} of "{$a->value}"་ཡོད་མི་འཚོལ་མ་ཐོབ།';
$string['usermappingerrorcurrentgroup'] = 'ལག་ལེན་པ་དེ་ ད་ལྟོའི་སྡེ་ཚན་གྱི་ཐུས་མི་མེན་པས།';
$string['usermappingerrorusernotfound'] = 'ལག་ལེན་པ་ཚུའི་མཐུན་འབྲེལ་ལུ་འཛོལ་བ་འདུག ལག་ལེན་པ་འཚོལ་མ་ཐོབ།';
$string['userpreferences'] = 'ལག་ལེན་པའི་དགའ་གདམ།';
$string['useweighted'] = 'མཐོ་དམན་ཅན་ ལག་ལེན་འཐབ།';
$string['verbosescales'] = 'Verbose་ཆ་ཚད།';
$string['viewbygroup'] = 'སྡེ་ཚན།';
$string['viewgrades'] = 'སྡེ་རིམ་སྟོན།';
$string['warningexcludedsum'] = 'ཉེན་བརྡ་: གནས་ཚད་མ་བརྩི་བ་ཅིན་ ཡོངས་སྤྱི་བསྡོམས་དང་མཐུན་འགྱུར་མི་འོང་།';
$string['weight'] = 'མཐོ་དམན།';
$string['weightcourse'] = 'སློབ་ཚན་དོན་ལུ་ མཐོ་དམན་ཅན་གྱི་གནས་ཚད་ ཚུ་ལག་ལེན་འཐབ།';
$string['weightedascending'] = 'མཐོ་དམན་ཅན་གྱི་བརྒྱ་ཆ་ ཡར་འཛེགས་ཐོག་ལས་དབྱེ་སེལ་འབད།';
$string['weighteddescending'] = 'མཐོ་དམན་ཅན་གྱི་བརྒྱ་ཆ་ མར་འབབ་ཐོག་ལས་དབྱེ་སེལ་འབད།';
$string['weightedpct'] = 'མཐོ་དམན་ཅན་%';
$string['weightedpctcontribution'] = 'མཐོ་དམན་ཅན་གྱི་ %ཞལ་འདེབས།';
$string['weightorextracredit'] = 'མཐོ་དམན་ ཡང་ན་ སྦྱོང་འཐུས་ཐེབས།';
$string['weights'] = 'མཐོ་དམན་ཚུ།';
$string['weightsedit'] = 'མཐོ་དམན་ཚུ་དང་སྦྱོང་འཐུས་ཐེབས་ཚུ་ ཞུན་དག་འབད།';
$string['weightuc'] = 'མཐོ་དམན།';
$string['writinggradebookinfo'] = 'གནས་ཚད་ཀི་དེབ་གཞི་སྒྲིག་ཚུ་བྲིས་དོ།';
$string['xml'] = 'XML';
$string['yes'] = 'ཨིན།';
$string['yourgrade'] = 'ཁྱོད་ཀྱི་གནས་ཚད།';
