<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'dz', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'ཁྱོད་ལུ་ལས་འགུལ་དྲན་བཏོན་འབད་དགོ་འདུག།';
$string['addattempt'] = 'དཔའ་བཅམ་གཞན་ཅིག་འབད་བཅུག';
$string['addnewattempt'] = 'དཔའ་བཅམ་གཞན་ཅིག་བཀོད།';
$string['addnewattemptfromprevious'] = 'ཧེ་མ་སྤྲོད་ཡོད་མི་གཞི་བཞག་སྟེ་དཔའ་བཅམ་གཞན་ཅིག་བཀོད།';
$string['addnewattemptfromprevious_help'] = 'ཨ་ནཱ་འདི་གིས་ ཁྱོད་ཀྱི་ཧེ་མའི་ནང་དོན་ཞུ་འབུལ་འབད་མི་ཚུ་ འཕྲོ་མཐུད་དེ་ལཱ་འབད་ནི་གི་དོན་ལུ་ཞུ་འབུལ་གསརཔ་ནང་འདྲ་བཤུས་འབད་འོང་།';
$string['addnewattempt_help'] = 'འདི་གི་ལཱ་འཕྲོ་མཐུད་དེ་འབད་ནི་གི་དོན་ལུ་ ཞུ་འབུལ་ས་སྟོང་གསརཔ་ཅིག་གསར་སྐྲུན་འབད་འོང་།';
$string['addsubmission'] = 'ཞུ་འབུལ་ཁ་སྐོང་རྐྱབས།';
$string['allocatedmarker'] = 'བརྡ་མཚན་སྐལཝ་སྤྲོད་ཡོདཔ།';
$string['allocatedmarker_help'] = 'ཨ་ནི་སྤྲོད་ནི་གི་དོན་ལུ་བརྡ་མཚན་སྐལཝ་སྤྲོད་ཡོདཔ།';
$string['allowsubmissions'] = 'ལག་ལེན་པ་ལུ་ ལས་འགུལ་འདི་ལུ་ཞུ་འབུལ་ཚུ་བཟོ་ནི་འབད་བཅུག།';
$string['allowsubmissionsanddescriptionfromdatesummary'] = '<strong>{$a}</strong>
ལས་ ལས་འགུལ་འདི་གི་རྒྱས་བཤད་ཚུ་དང་ཞུ་འབུལ་འབྲི་ཤོག་འཐོབ་ཚུགས།';
$string['allowsubmissionsfromdate'] = 'ལས་ ཞུ་འབུལ་ཚུ་ཆོག།';
$string['allowsubmissionsfromdate_help'] = 'གལ་སྲིད་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ སློབ་ཕྲུག་ཚུ་གིས་ཟླ་ཚེས་འདི་གི་ཧེ་མ་ཕུལ་མི་ཚུགས། ལྕོགས་མིན་བཟོ་བ་ཅིན་ སློབ་ཕྲུག་ཚུ་གིས་དུས་འཕྲོ་ལས་ཕུལ་ཚུགས།';
$string['allowsubmissionsfromdatesummary'] = '<strong>{$a}</strong>
ལས་ ལས་འགུལ་འདི་གི་ ཞུ་འབུལ་ཚུ་དང་ལེན་འབད་འོང་།';
$string['allowsubmissionsshort'] = 'ཞུ་འབུལ་བསྒྱུར་བཅོས་ཚུ་འབད་བཅུག།';
$string['alwaysshowdescription'] = 'འགྲེལ་བཤད་ཨ་རྟག་རང་སྟོན།';
$string['alwaysshowdescription_help'] = 'གལ་སྲིད་ལྕོགས་མིན་བཟོ་བ་ཅིན་ གོང་ལུ་ཡོད་པའི་ལས་འགུལ་གསལ་བཤད་དེ་ སློབ་ཕྲུག་ཚུ་ལུ་ ཟླ་ཚེས་ \'ལས་ཞུ་འབུལ་འབད་བཅུག\' ཟེར་ཡོད་སར་རྐྱངམ་ཅིག་མཐོང་ཚུགས་།';
$string['applytoteam'] = 'སྡེ་ཚན་ཧྲིལ་བུ་ལུ་ གནས་ཚད་ཚུ་དང་བསམ་ལན་འཇུག་སྤྱོད་འབད།';
$string['assign:addinstance'] = 'ལས་འགུས་གསརཔ་གཅིག་ཁ་སྐོང་བརྐྱབ།';
$string['assign:exportownsubmission'] = 'རང་གི་ཞུ་འབུལ་ ཕྱིར་འདྲེན་འབད།';
$string['assignfeedback'] = 'བསམ་ལན་ plugin';
$string['assignfeedbackpluginname'] = 'བསམ་ལན་ plugin';
$string['assign:grade'] = 'ལས་འགུལ་ལུ་ སྐུགས་བྱིན།';
$string['assign:grantextension'] = 'ཕར་འགྱངས་གནང་།';
$string['assign:manageallocations'] = 'སྤྲོད་ནི་ལུ་སྤྲོད་ཡོད་པའི་བརྡ་མཚན་དེ་འཛིན་སྐྱོང་འབད།';
$string['assign:managegrades'] = 'བསྐྱར་བཞིབ་འབད་ཞིནམ་ལས་ སྐུགས་བྱིན།';
$string['assignmentisdue'] = 'ལས་འགུལ་དེ་སྤྲོད་རེན་ཡོད།';
$string['assignmentmail'] = '{$a->grader} ་གིས་ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་ \'{$a->assignment}\' དོན་ལུ་བསམ་བཀོད་དག་པ་ཅིག་ བརྡ་འཕྲིན་འབད་བཀོད་ནུག། ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་གུར་ ཆན་བཏགས་ཡོདཔ་མཐོང་་: {$a->url}';
$string['assignmentmailhtml'] = '{$a->grader}  གིས་ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་\'<i>{$a->assignment}</i>\'<br /><br />དོན་ལུ་བསམ་བཀོད་དག་པ་ཅིག་བརྡ་འཕྲིན་འབད་བཀོད་ནུག། དེ་ ཁྱོད་ཀྱིས་<a href="{$a->url}">ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་</a>གུར་ཆན་བཏགས་ཡོདཔ་མཐོང་་: {$a->url}';
$string['assignmentmailsmall'] = '{$a->grader} ་གིས་ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་ \'{$a->assignment}\' དོན་ལུ་བསམ་བཀོད་དག་པ་ཅིག་ བརྡ་འཕྲིན་འབད་བཀོད་ནུག། ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་གུར་ ཆན་བཏགས་ཡོདཔ་མཐོང་།';
$string['assignmentname'] = 'ལས་འགུལ་གྱི་མིང་།';
$string['assignmentplugins'] = 'ལས་འགུལ་plugins';
$string['assignmentsperpage'] = 'ཤོག་ལེབ་རེ་རེ་ནང་ ལས་འགུལ་ཚུ།';
$string['assign:releasegrades'] = 'སྐུགས་བྱིན།';
$string['assign:revealidentities'] = 'སློབ་ཕྲུག་གི་ངོ་རྟགས་ཚུ་ཕྱིར་གསལ་འབད།';
$string['assign:reviewgrades'] = 'སྐུགས་བསྐྱར་ཞིབ་འབད།';
$string['assignsubmission'] = 'ཞུ་འབུལ་plugin';
$string['assignsubmissionpluginname'] = 'ཞུ་འབུལ་plugin';
$string['assign:submit'] = 'ལས་འགུལ་ སྤྲོད།';
$string['assign:view'] = 'ལས་འགུལ་ ལྟ།';
$string['attemptheading'] = 'དཔའ་བཅམ་ {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'ཧེ་མའི་དཔའ་བཅམ།';
$string['attemptnumber'] = 'དཔའ་བཅམ་འབད་ཡོད་པའི་གྱངས་ཁ།';
$string['attemptreopenmethod'] = 'དཔའ་བཅམ་ལོག་ཕྱེ་ཡོདཔ།';
$string['attemptreopenmethod_manual'] = 'རང་ཤུགས་ཀྱིས།';
$string['attemptreopenmethod_none'] = 'ནམ་ཡང་མེདཔ།';
$string['attemptreopenmethod_untilpass'] = 'མཐར་མ་འཁྱོལ་ཚུན་རང་བཞིན་གྱིས།';
$string['attemptsettings'] = 'གཞི་སྒྲིག་ཚུ་ལུ་དཔའ་བཅམ།';
$string['availability'] = 'ཐོབ་ཚུགས་པའི།';
$string['backtoassignment'] = 'ལས་འགུལ་ལུ་ འགྱོ།';
$string['batchoperationconfirmaddattempt'] = 'གདམ་ཡོད་པའི་སྤྲོད་ཚུལ་ཚུ་གི་དོན་ལས་ དཔའ་བཅམ་གཞན་འབད་བཅུག';
$string['batchoperationconfirmgrantextension'] = 'སེལ་འཐུ་གྲུབ་པའི་ཞུ་འབུལ་ཆ་མཉམ་ཚུ་ལུ་ ཕར་འགྱངས་གནང་།';
$string['batchoperationconfirmlock'] = 'སེལ་འཐུ་གྲུབ་པའི་ཞུ་འབུལ་ཆ་མཉམ་ཚུ་ལུ་ བསྡམ་བཞག།';
$string['batchoperationconfirmreverttodraft'] = 'སེལ་འཐུ་གྲུབ་པའི་ཞུ་འབུལ་ཆ་ལུ་ ཟིན་བྲིས་ལུ་རྒྱབ་ལོག་བཏང་?';
$string['batchoperationconfirmsetmarkingallocation'] = 'གདམ་ཡོད་པའི་སྤྲོད་ཚུལ་ཚུ་གི་དོན་ལས་ སྐུགས་བྱིན་ནི་གི་གནས་གཞན་གཞི་སྒྲིག་འབད།';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'གདམ་ཡོད་པའི་སྤྲོད་ཚུལ་ཚུ་གི་དོན་ལས་ སྐུགས་བྱིན་ནི་གི་ལཱ་འབབ་གཞི་སྒྲིག་འབད།';
$string['batchoperationconfirmunlock'] = 'སེལ་འཐུ་གྲུབ་པའི་ཞུ་འབུལ་ཆ་མཉམ་ཚུ་ ལྡེ་མིག་ཕྱེ།';
$string['batchoperationlock'] = 'ཞུ་འབུལ་ཆ་མཉམ་ཚུ་ལུ་ བསྡམ་བཞག།';
$string['batchoperationreverttodraft'] = 'སེལ་འཐུ་གྲུབ་པའི་ཞུ་འབུལ་ཆ་ལུ་ ཟིན་བྲིས་ལུ་རྒྱབ་ལོག་བཏང་།';
$string['batchoperationsdescription'] = 'སེལ་འཐུ་གྲུབ་པའི་....';
$string['batchoperationunlock'] = 'ཞུ་འབུལ་ཚུ་ ལྡེ་མིག་ཕྱེ།';
$string['batchsetallocatedmarker'] = 'གདམ་ཡོད་པའི་ལག་ལེན་པ་ཚུ་གི་དོན་ལས་ སྐལཝ་སྤྲོད་པའི་་བརྡ་མཚན་ཅིག་གཞི་སྒྲིག་འབད།';
$string['batchsetmarkingworkflowstateforusers'] = 'གདམ་ཡོད་པའི་ལག་ལེན་པ་ཚུ་གི་དོན་ལས་ སྐལཝ་སྤྲོད་པའི་་བརྡ་མཚན་ལཱ་འབབ་ཅིག་གཞི་སྒྲིག་འབད།';
$string['blindmarking'] = 'སྐུགས་བྱིན་མི་ལུ་སློབ་ཕྲུག་གི་ངོ་རྟགས་སྦ་བཞག་ནི།';
$string['changegradewarning'] = 'ལས་འགུལ་ནང་ ཞུ་འབུལ་ཚུ་སྐུགས་བྱིན་ཡོད་ སྐུགས་འདི་བསྒྱུར་བཅོས་འབད་རུང་  ཡོད་པའི་ཞུ་འབུལ་གྱི་སྐུགས་དེ་ རང་བཞིན་གྱིས་སླར་རྩིས་བཏོན་མི་ཚུགས། འདི་བསྒྱུར་བཅོས་འབད་དགོ་པ་ཅིན་  ཡོད་པའི་ཞུ་འབུལ་ཚུ་གེ་ར་ལུ་ལོག་སྐུགས་བྱིན་དགོ།';
$string['choosegradingaction'] = 'སྐུགས་འབྱིན་ནི་བྱ་བ།ཞུ་འབུལ';
$string['choosemarker'] = 'གདམ་ཁ་འབད།';
$string['chooseoperation'] = 'བཀོལ་སྤྱོད་གདམ།';
$string['comment'] = 'བསམ་བཀོད།';
$string['completionsubmit'] = 'སློབ་ཕྲུག་གིས་ སྦྱོང་ལཱ་འདི་་མཇུག་བསྡུ་ནའི་དོན་ལུ་ སྤྲོད་དགོ།';
$string['configshowrecentsubmissions'] = 'འཕྲལ་གྱི་སྦྱོང་ལཱ་སྙན་ཞུ་སྤྲོད་དགོ་པའི་བརྡབསྐུལ་ གེ་ར་གིས་མཐོང་ཚུགས།';
$string['confirmbatchgradingoperation'] = 'ཁྱོད་ཀྱི་ སློབ་ཕྲུག་ཚུ་{$a->count}གི་དོན་ལུ་{$a->operation}
འབད་ནི་འཐད་རེ་བ་རེ་ཨིན་ན?';
$string['confirmsubmission'] = 'སྐུགས་ཀྱི་དོན་ལས་ཁྱོད་ཀྱི་ལཱ་དེ་སྤྲོད་ནི་ཨིནམ་གཏན་འཁེལ་ཨིན་ན།';
$string['conversionexception'] = 'ལས་འགུལ་ གཞི་བསྒྱུར་འབད་མ་ཚུགས། རྩིས་ཁར་མེད་མི་ {$a}་ཨིན།';
$string['couldnotconvertgrade'] = 'ལག་ལེན་པ་ {$a} ་དོན་ལུ་ ལས་འགུལ་ གྱི་སྐུགས་གཞི་བསྒྱུར་འབད་མ་ཚུགས།';
$string['couldnotconvertsubmission'] = 'ལག་ལེན་པ་ {$a} ་དོན་ལུ་ ལས་འགུལ་ གྱི་ཞུ་འབུལ་གཞི་བསྒྱུར་འབད་མ་ཚུགས།';
$string['couldnotcreatecoursemodule'] = 'སློབ་ཚན་ ཚད་གཞི་གསར་བསྐྲུན་འབད་མ་བཏུབ།';
$string['couldnotcreatenewassignmentinstance'] = 'ལས་འགུལ་གྱི་མཚོན་དཔེ་ཚད་གསརཔ་ གཞི་གསར་བསྐྲུན་འབད་མ་བཏུབ།';
$string['couldnotfindassignmenttoupgrade'] = 'ལས་འགུལ་གྱི་མཚོན་དཔེ་ཚད་རྙིངམ་ གཡར་བསྐྱེད་འབད་མ་བཏུབ།';
$string['currentattempt'] = '{$a}.འདི་དཔའ་བཅམ་ཨིན།';
$string['currentattemptof'] = '{$a->attemptnumber} ( {$a->maxattempts}attempts allowed ).འདི་དཔའ་བཅམ་ཨིན།';
$string['currentgrade'] = 'སྐུགས་ཀི་དེབ་ནང་ ད་ལྟོའི་སྐུགས།';
$string['cutoffdate'] = 'བཏོག་བཞག་པའི་ཚེས་གྲངས།';
$string['cutoffdatefromdatevalidation'] = 'བཏོག་བཞག་པའི་ཚེས་གྲངས་དེ་ ཚེས་གྲངས་འདི་ལས་ཞུ་འབུལ་ཚུ་འབད་ཆོག་པའི་ ཤུལ་མ་དགོ།';
$string['cutoffdate_help'] = 'གཞི་སྒྲིག་འབད་བ་ཅིན་ ལས་འགུལ་འདི་གིས་ ཞུ་འབུལ་ཚུ་དུས་ཚོད་ཀྱི་ཤུལ་ལས་ ངོས་ལེན་མི་འབད།';
$string['cutoffdatevalidation'] = 'ཏོག་བཞག་པའི་ཚེས་གྲངས་དེ་ རེན་པའི་ཚེས་གྲངས་ཀྱི་ ཤུལ་མ་དགོ།';
$string['defaultsettings'] = 'སྔོན་སྒྲིག་ ལས་འགུལ་གཞི་སྒྲིག་ཚུ།';
$string['defaultsettings_help'] = 'གཞི་སྒྲིག་འདི་ཚུ་གི་ལས་འགུལ་ཚུ་གེ་ར་གི་དོན་ལུ་ སྔོན་སྒྲིག་ཚུ་སྦེ་ངེས་འཛིན་འབད་ཨིན།';
$string['defaultteam'] = 'སྔོན་སྒྲིག་ སྡེ་ཚན།';
$string['deleteallsubmissions'] = 'སྤྲོད་ཡོད་མི་ཚུ་བཏོན་གཏང་།';
$string['description'] = 'འགྲེལ་བཤད།';
$string['downloadall'] = 'ལས་འགུལ་ཚུ་ག་ར་ཕབ་ལེན་འབད།';
$string['duedate'] = 'སྤྲོད་ཚེས་།';
$string['duedate_help'] = 'ཨ་ནཱི་འདི་ ལས་འགུལ་རནམ་ད་ཨིན། ཨིན་རུང་ལས་འགུལ་ཚུ་དུས་ཚོད་འདི་གི་ཤུལ་ལས་ ཞུ་འབུལ་འབད་རུང་བཏུབ། དེ་འབདཝ་ད་ལས་འགུལ་ཚུ་ག་ཨིན་རུང་ དུས་ཚོད་ཀྱི་ཤུལ་ལས་ཕུལ་བ་ཅིན་ཕྱིས་སུ་ཕུལ་ཡི་ཟེར་རྟགས་བཀོད་འོང་། ་དུས་ཚོད་བྱིན་ཡོད་པའི་ཤུལ་ལས་ཞུ་འབུལ་འབད་ནི་འདི་བཀག་ནིའི་དོན་ལུ་  ལས་འགུལ་ཟླ་ཚེས་ཕབ་ཆ་འདི་གཞི་སྒྲིག་འབད།';
$string['duedateno'] = 'སྤྲོད་ཚེས་མིན་འདུག།';
$string['duedatereached'] = 'ལས་འགུལ་འདི་ སྤྲོད་ཚེས་དེ་ད་ལྟོ་་རྫོགས་སོ་ཡི།';
$string['duedatevalidation'] = 'རན་པའི་ཚེས་གྲངས་དེ་ ཚེས་གྲངས་འདི་ལས་ཞུ་འབུལ་ཚུ་འབད་ཆོག་པའི་ ཤུལ་མ་དགོ།';
$string['editaction'] = 'བྱ་བ་ཚུ་....';
$string['editattemptfeedback'] = 'དཔའ་བཅམ་གྱངས་ཁ་{$a}.གི་དོན་ལས་ སྐུགས་དང་བསམ་ལན་ཚུ་ཞུན་དག་འབད།';
$string['editingpreviousfeedbackwarning'] = 'ཁྱོད་ད་ལྟོ་ ཧེ་མའི་དཔའ་བཅམ་གྱི་བསམ་ལན་ཚུ་ཞུན་དག་འབད་བའི་བསྒང་ཨིན། ད་ལྟོ་གི་དཔའ་བཅམ་དེ་{$a->totalattempts}.ལས་{$a->attemptnumber} ཅིག་ཨིན།';
$string['editingstatus'] = 'གནས་ཚད་ཞུན་དག་འབད་དོ།';
$string['editsubmission'] = 'སྤྲོད་མི་ཞུན་དག་འབད།';
$string['editsubmission_help'] = 'ཞུ་འབུལ་ལུ་བསྒྱུར་བཅོས་ཚུ་བཟོ།';
$string['enabled'] = 'ལྕོགས་ཅན་བཟོ་ཡོདཔ།';
$string['errornosubmissions'] = 'ཞུ་འབུལ་ཚུ་ཕབ་ལེན་འབད་ནི་མིན་འདུག།';
$string['errorquickgradingvsadvancedgrading'] = 'སྐུགས་ཚུ་སྲུངས་མ་ཚུགས་ ག་ཅི་སྦེ་ཟེར་བ་ཅིན་ ལས་འགུལ་འདི་ད་ལྟོ་སྐུགས་བྱིན་ནི་ཡར་འཕེལ་ཅན་ཨིན་མས།';
$string['errorrecordmodified'] = 'སྐུགས་ཚུ་སྲུངས་མ་ཚུགས་ ག་ཅི་སྦེ་ཟེར་བ་ཅིན་ མི་ཅིག་གི་དྲན་ཐོ་གཅིག་ཡང་ན་མངམ་ལེགས་བཅོས་འབད་ནུག།
when you loaded the page.';
$string['event_all_submissions_downloaded'] = 'སྤྲོད་ཡོད་མི་ཆ་མཉམ་ཕབ་ལེན་འབད་ཡོད།';
$string['event_assessable_submitted'] = 'སྤྲོད་ནི་ཡོད་མི་ཅིག་སྤྲོད་ཡོད།';
$string['event_extension_granted'] = 'དུས་ཚོད་ཕར་འཕུལ་ཅིག་ངེས་ལེན་འབད་ཡོད།';
$string['event_identities_revealed'] = 'ངོ་རྟགས་ཚུ་སྟོན་ཡོད།';
$string['event_marker_updated'] = 'སྐལཝ་སྤྲོད་མི་བརྡ་མཚན་ཚུ་དུས་མཐུན་བཟོ་ཡོད།';
$string['event_statement_accepted'] = 'ལག་ལེན་དེ་གིས་ སྤྲོད་ནི་གི་དོན་ལས་གསལ་བཤདལེན་ཡོད།';
$string['event_submission_duplicated'] = 'ལག་ལེན་པ་དེ་གིས་སྤྲོད་ནི་དེ་འདྲ་གཉིསམ་བཟོ་ཡོད།';
$string['event_submission_graded'] = 'སྤྲོད་ནི་དེ་དུས་མཐུན་བཟོ་ཡོད།';
$string['event_submission_locked'] = 'སྤྲོད་ནི་དེ་ལག་ལེན་པ་གཅིག་གི་དོན་ལས་མ་གཏོགས་ ལྡེ་བསྡམ་འབད་ཡོད།';
$string['event_submission_status_updated'] = 'སྤྲོད་ནི་གི་གནས་རིམ་དེ་ དུས་མཐུན་བཟོ་ཡོད།';
$string['event_submission_unlocked'] = 'སྤྲོད་ནི་དེ་ལག་ལེན་པ་གཅིག་གི་དོན་ལས་ ལྡེ་ཕྱེ་སྟེ་ཡོད།';
$string['event_submission_updated'] = 'ལག་ལེན་པ་དེ་གིས་ སྤྲོད་ནི་དེ་སྲུང་སྟེ་ཡོད།';
$string['event_workflow_state_updated'] = 'ལཱའབབ་ཀྱི་གནས་ཚད་དེ་དུས་མཐུན་བཟོ་ཡོད།';
$string['extensionduedate'] = 'ཕར་འགྱངས་ རན་པའི་ཚེས་གྲངས།';
$string['extensionnotafterduedate'] = 'ཕར་འགྱངས་ཚེས་གྲངས་འདི་ རེན་པའི་ཚེས་གྲངས་ཀྱི་ ཤུལ་མ་དགོ།';
$string['extensionnotafterfromdate'] = 'ཕར་འགྱངས་ཚེས་གྲངས་དེ་ ཚེས་གྲངས་འདི་ལས་ཞུ་འབུལ་ཚུ་འབད་ཆོག་པའི་ ཤུལ་མ་དགོ།';
$string['feedback'] = 'བསམ་ལན།';
$string['feedbackavailablehtml'] = '{$a->username}  གིས་ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་\'<i>{$a->assignment}</i>\'<br /><br />དོན་ལུ་བསམ་བཀོད་དག་པ་ཅིག་བརྡ་འཕྲིན་འབད་བཀོད་ནུག། དེ་ ཁྱོད་ཀྱིས་<a href="{$a->url}">ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་</a>གུར་ཆན་བཏགས་ཡོདཔ་མཐོང་།';
$string['feedbackavailablesmall'] = '{$a->username}  གིས་ཁྱོད་ཀྱིས་ལས་འགུལ་{$a->assignment}་དོན་ལུ་བསམ་བཀོད་བྱིན་ཡོད།';
$string['feedbackavailabletext'] = '{$a->username} གིས་ཁྱོད་ཀྱིས་ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་ \'{$a->assignment}\' དོན་ལུ་བསམ་བཀོད་དག་པ་ཅིག་བརྡ་འཕྲིན་འབད་བཀོད་ནུག། དེ་ ཁྱོད་ཀྱིས་ ཞུ་འབུལ་འབད་ཡོད་པའི་ལས་འགུལ་གུར་ཆན་བཏགས་ཡོདཔ་མཐོང་: {$a->url}';
$string['feedbackplugin'] = 'བསམ་བཀོད་plugin';
$string['feedbackpluginforgradebook'] = 'བསམ་བཀོད་ plugin དེ་གིས་ གནས་ཚད་ཀི་དེབ་ལུ་བསམ་བཀོད་ཚུ་འཕུལ་བཏང་འོང་།';
$string['feedbackpluginforgradebook_help'] = 'ལས་འགུལ་བསམ་བཀོད་ plugin ་ཙམ་ཅིག་གི་གནས་ཚད་ཀི་དེབ་ནང་ལུ་བསམ་བཀོད་འཕུལ་བཏང་ཚུགས།';
$string['feedbackplugins'] = 'བསམ་བཀོད་plugins';
$string['feedbacksettings'] = 'བསམ་བཀོད་ གཞི་སྒྲིག་ཚུ།';
$string['feedbacktypes'] = 'བསམ་ལན་གྱི་དབྱེ་བ།';
$string['filesubmissions'] = 'ཡེག་སྣོད་ཞུ་འབུལ་ཚུ།';
$string['filter'] = 'ཚགས་མ།';
$string['filternone'] = 'ཚགས་མ་མེད།';
$string['filterrequiregrading'] = 'སྐུགས་བྱིན་དགོས་མཁོ་ཡོདཔ།';
$string['filtersubmitted'] = 'སྤྲོད་ཡོདཔ།';
$string['gradeabovemaximum'] = 'སྐུགས་དེ་ {$a} ཤས་ཉུངམ་ཡང་ན་མཉམ་པ དགོ།';
$string['gradebelowzero'] = 'སྐུགས་དེ་  ཀླད་ཀོར་ ལས་སྦོམ་མི་ཡང་ན་མཉམ་པ དགོ།';
$string['gradecanbechanged'] = 'སྐུགས་ཚུ་སྒྱུར་བཏུབ།';
$string['graded'] = 'སྐུགས་བྱིན་ཡོདཔ།';
$string['gradedby'] = 'གིས་སྐུགས་བྱིན་ཡོདཔ།';
$string['gradedon'] = 'གུ་ལུ་སྐུགས་བྱིན་ཡོདཔ།';
$string['gradelocked'] = 'སྐུགས་དེ་སྐུགས་དེབ་ནང་ལུ་ལྡེ་བསྡམ་འབད་ཡོད།';
$string['gradeoutof'] = 'སྐུགས་ {$a}་ལས';
$string['gradeoutofhelp'] = 'སྐུགས';
$string['gradeoutofhelp_help'] = 'སློབ་ཕྲུག་ཚུ་གི་དོན་ལུ་ ཞུ་འབུལ་འབད་བའི་སྐུགས་ནཱ་ལུ་བཙུག ཁྱོད་ཀྱིས་བཅུ་ཚག་ཚུ་ཡང་ལག་ལེན་འཐབ་བཏུབ།';
$string['gradersubmissionupdatedhtml'] = '{$a->username} གིས་ཁོ་རའི ལས་འགུལ་ཞུ་འབུལ་ <i>\'{$a->assignment}\' དོན་ལུ་ {$a->timeupdated}</i><br /><br />ནང་དུས་མཐུན་བཟོ་ཡོད། དེ་<a href="{$a->url}">ཝེབ་ས་ཁོངས་ནང་</a>འཐོབ་ཚུགས།';
$string['gradersubmissionupdatedsmall'] = '{$a->username} གིས་ཁོ་རའི ལས་འགུལ་{$a->assignment}དོན་ལུ་ཞུ་འབུལ་ དུས་མཐུན་བཟོ་ཡོད།';
$string['gradersubmissionupdatedtext'] = '{$a->username} གིས་ཁོ་རའི ལས་འགུལ་ཞུ་འབུལ་ <i>\'{$a->assignment}\' དོན་ལུ་ {$a->timeupdated}</i><br /><br />ནང་དུས་མཐུན་བཟོ་ཡོད། དེ་{$a->url}་ན་ལུ་འཐོབ་ཚུགས།';
$string['gradestudent'] = 'སློབ་ཕྲུག་:(id={$a->id}, མིང་ཆ་ཚང་={$a->fullname}) ལུ་སྐུགས་བྱིན།';
$string['gradeuser'] = 'སྐུགས་{$a}';
$string['grading'] = 'སྐུགས་བྱིན་དོ།';
$string['gradingchangessaved'] = 'སྐུགས་སྒྱུར་བཅོས་འབད་མི་ཚུ་སྲུང་ཡོད།';
$string['gradingmethodpreview'] = 'སྐུགས་བྱིན་ནིའི་ཁྱད་ཚད།';
$string['gradingoptions'] = 'གདམ་ཁ་ཚུ།';
$string['gradingstatus'] = 'སྐུགས་བྱིན་ནིའི་གནས་ཚད།';
$string['gradingstudent'] = 'སློབ་ཕྲུག་ལུ་སྐུགས་བྱིན་བཞིན།';
$string['gradingsummary'] = 'སྐུགས་བྱིན་ནིའི་བཅུད་དོན།';
$string['grantextension'] = 'ཕར་འགྱངས་གནང་།';
$string['grantextensionforusers'] = 'སློབ་ཕྲུག་{$a}ཚུ་གི་དོན་ལུ་ཕར་འགྱངས་གནང་།';
$string['groupsubmissionsettings'] = 'སྡེ་ཚན་ནང་སྤྲོད་ནི་གི་གཞི་སྒྲིག';
$string['hiddenuser'] = 'བཅའ་མར་གཏོགས་མི།';
$string['hideshow'] = 'སྦ་/སྟོན་';
$string['instructionfiles'] = 'བསླབ་སྟོན་ཡིག་སྣོད་ཚུ།';
$string['invalidfloatforgrade'] = 'སྐུགས་བྱིན་ཏེ་ཡོད་མི་{$a}དེ་ཧ་གོ་མ་ཚུགས།';
$string['invalidgradeforscale'] = 'སྐུགས་བཀྲམ་སྤེལ་འབད་ཡོད་མི་འདི་ ད་ལྟོའི་ཆ་ཚད་དོན་ལུ་ནུས་མིན་འདུག།';
$string['lastmodifiedgrade'] = 'ལེགས་བཅོས་གྲུབ་པའི་(སྐུགས་)མཇུག་མམ།';
$string['lastmodifiedsubmission'] = 'ལེགས་བཅོས་གྲུབ་པའི་(ཞུ་འབུལ་་)མཇུག་མམ།';
$string['latesubmissions'] = 'ཕྱིས་པ་ཞུ་འབུལ་ཚུ།';
$string['latesubmissionsaccepted'] = 'ཕར་འགྱངས་གནང་ཡོད་པའི་སློབ་ཕྲུག་(ཚུ་)་ལས་འགུལ་ ད་ལྟོ་ཡང་སྤྲོད་ཚུགས།';
$string['locksubmissionforstudent'] = 'སློབ་ཕྲུག་(id={$a->id},མིང་ཆ་ཚང་
={$a->fullname}) ངི་དོན་ལུ་ཞུ་འབུལ་དེ་ལས་ལྷག་སྟེ་བཀག།';
$string['locksubmissions'] = 'ཞུ་འབུལ་ཆ་མཉམ་ཚུ་ལུ་ བསྡམ་བཞག།';
$string['manageassignfeedbackplugins'] = 'ལས་འགུལ་བསམ་ལན་ plugins འཛིན་སྐྱོང་འཐབ།';
$string['manageassignsubmissionplugins'] = 'ལས་འགུལ་བསམ་ལན་ plugins འཛིན་སྐྱོང་འཐབ།';
$string['marker'] = 'བརྡ་མཚན།';
$string['markerfilter'] = 'བརྡ་མཚན་བཙག་གཞི།';
$string['markingallocation'] = 'སྐུགས་བྱིན་ནི་གི་བགོ་སྐལ།';
$string['markingallocation_help'] = 'ག་དེམ་ཅིག་སྦེ་ ལཱ་རྒྱུན་གྱི་སྐུགས་དང་གཅིག་ཁར་ ལྕོགས་ཅན་བཟོ་བ་ཅིན་ བརྡ་མཚན་ཚུ་ སློབ་ཕྲུག་ངོ་རྐྱང་ལུ་ བགོ་སྐལ་འབད་བཏུབ།';
$string['markingworkflow'] = 'སྐུགས་བྱིན་ནི་གི་ལཱ་བབ་ལག་ལེན་འཐབ།';
$string['markingworkflow_help'] = 'གལ་སྲིད་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ སློབ་ཕྲུག་ཚུ་ལུ་མ་གཏང་བའི་ཧེ་མ་ སྐུགས་ཚུ་ལཱ་རྒྱུན་གྱི་གོ་རིམ་དང་འཁྲིལ་འགྱོ་འོང་། འདི་གིས་ཐེངས་མང་རབས་ཅིག་སྐུགས་བྱིན་པའི་ཁར་ སློབ་ཕྲུག་ཆ་མཉམ་ལུ་སྐུགས་ཚུ་དུས་ཚོད་གཅིག་ལུ་གཏང་བཅུག་འོང་།';
$string['markingworkflowstate'] = 'སྐུགས་བྱིན་ནི་གི་ལཱ་བབ་གནས་ཚད།';
$string['markingworkflowstateinmarking'] = 'སྐུགས་བྱིན་བཞིན་པ།';
$string['markingworkflowstateinreview'] = 'བསྐྱར་ཞིབ་འབད་བའི་བསྒང་།';
$string['markingworkflowstatenotmarked'] = 'སྐུགས་མ་བྱིན་པར་ཡོདཔ།';
$string['markingworkflowstatereadyforrelease'] = 'གཏང་ནི་གི་དོན་ལས་གྲ་སྒྲིག';
$string['markingworkflowstatereadyforreview'] = 'སྐུགས་བྱིན་ཚར་ཡོདཔ།';
$string['markingworkflowstatereleased'] = 'གཏང་ཡོདཔ།';
$string['maxattempts'] = 'དཔའ་བཅམ་མཐོ་ཤོས།';
$string['maxattempts_help'] = 'སློབ་ཕྲུག་གིས་ ཞུ་འབུལ་གྱི་དོན་ལུ་དཔའ་བཅམ་མཐོ་ཤོས་རང་བཟོ་ཚུགས།་འདི་གི་ཤུལ་ལས་དཔའ་བཅམ་ཚུ་བཟོ་ཞིནམ་ལས་ སློབ་ཕྲུག་གི་ཞུ་འབུལ་འདི་ལོག་ཁ་ཕྱེ་མི་བཏུབ།';
$string['maxgrade'] = 'སྐུགས་མཐོ་ཤོསྲ';
$string['messageprovider:assign_notification'] = 'ལས་འགུལ་བརྡ་བསྐུལ་ཚུ།';
$string['modulename'] = 'ལས་འགུལ།';
$string['modulenameplural'] = 'ལས་འགུལ་ཚུ།';
$string['moreusers'] = '{$a} ལེ་ཤ';
$string['mysubmission'] = 'ངེའི་ཞུ་འབུལ་:';
$string['newsubmissions'] = 'ལས་འགུལ་ཚུ་སྤྲོད་ཚར་ཡོད།';
$string['noattempt'] = 'བྲི་ནི་གི་དཔའ་རང་མ་བཅམ་པས།';
$string['nofiles'] = 'ཡིག་སྣོད་ཚུ་མེད།';
$string['nograde'] = 'སྐུགས་མེད།';
$string['nolatesubmissions'] = 'ཕྱིས་ཡོད་པི་ཞུ་འབུལ་ཚུ་ ངོས་ལེན་མ་འབད་བས།';
$string['nomoresubmissionsaccepted'] = 'དེ་ལས་ལྷག་སྟེ་ཞུ་འབུལ་ཚུ་ ངོས་ལེན་མ་འབད་བས།';
$string['noonlinesubmissions'] = 'ལས་འགུལ་འདི་ལུ་གློག་ལམ་ཐོག་ལུ་ག་ཅི་ཡང་སྤྲོད་ནི་དགོས་མཁོ་མེད།';
$string['nosavebutnext'] = 'ཤུལ་མམ།';
$string['nosubmission'] = 'ལས་འགུལ་འདི་དོན་ལུ་ག་ནི་ཡང་སྤྲོད་སྤྲོདཔ་མིན་འདུག།';
$string['nosubmissionsacceptedafter'] = 'དེ་ལས་ཕར་ཞུ་འབུལ་ཚུ་ ངོས་ལེན་མ་འབད་བས།';
$string['notgraded'] = 'སྐུགས་མ་བྱིན་པས།';
$string['notgradedyet'] = 'ད་ཚུན་སྐུགས་མ་བྱིན་པས།';
$string['notifications'] = 'བརྡ་བསྐུལ་ཚུ།';
$string['notsubmittedyet'] = 'ད་ཚུན་མ་སྤྲོད་པས།';
$string['nousersselected'] = 'ལག་ལེན་པ་ཚུ་སེལ་འཐུ་མ་གྲུབ།';
$string['numberofdraftsubmissions'] = 'ཟིན་བྲིས།';
$string['numberofparticipants'] = 'བཅའ་མར་གཏོགས་མི་ཚུ།';
$string['numberofsubmissionsneedgrading'] = 'སྐུགས་བྱིན་དགོཔ་པས།';
$string['numberofsubmittedassignments'] = 'སྤྲོད་ཡོད་པ།';
$string['numberofteams'] = 'སྡེ་ཚན་ཚུ།';
$string['offline'] = 'གློག་ལམ་ཐོག་ལུ་ ཞུ་འབུལ་ཚུ་དགོས་མཁོ་མེད།';
$string['open'] = 'ཁ་ཕྱེ།';
$string['outlinegrade'] = 'སྐུགས་:{$a}';
$string['outof'] = '{$a->total} ལས་ཕྱི་ཁར་ $a->current}';
$string['overdue'] = '<font color="red">ལས་འགུལ་འདི་ {$a} ལས་དུས་ཚད་རྫོགས་སོ་ནུག།</font>';
$string['page-mod-assign-view'] = 'ལས་འགུལ་ ཚད་གཞི་གཙོ་བོ་དང་ཞུ་འབུལ་ཤོག་ལེབ།';
$string['page-mod-assign-x'] = 'ལས་འགུལ་ ཚད་གཞི་ཤོག་ལེབ་ག་འབད་རུང་།';
$string['participant'] = 'བཅའ་མར་གཏོགས་མི།';
$string['pluginadministration'] = 'ལས་འགུལ་བདག་སྐྱོང།';
$string['pluginname'] = 'ལས་འགུལ་།';
$string['preventsubmissions'] = 'ལས་འགུལ་འདི་ལུ་ ལག་ལེན་པ་ཚུ་གིས་ དེ་ལས་ལྷག་སྟེ་ ཞུ་འབུལ་ཚུ་སྤྲོད་ནི་བཀག།';
$string['preventsubmissionsshort'] = 'ཞུ་འབུལ་གྱི་བསྒྱུར་བཅོས་ཚུ་བཀག།';
$string['previous'] = 'སྔོན་མ།';
$string['quickgrading'] = 'འཕྲལ་མགྱོགས་སྐུགས་བྱིན་ནི།';
$string['quickgradingchangessaved'] = 'སྐུགས་ཀྱི་བསྒྱུར་བཅོས་ཚུ་སྲུངས་བཞག།';
$string['quickgradingresult'] = 'འཕྲལ་མགྱོགས་སྐུགས་བྱིན་ནི།';
$string['recordid'] = 'ངོས་འཛིན་པ།';
$string['requireallteammemberssubmit'] = 'སྡེ་ཚན་ཆ་མཉམ་ཚུ་གི་སྤྲོད་ནི་ དགོས་མཁོ་ཡོདཔ།';
$string['requiresubmissionstatement'] = 'ཨ་ཕི་ སློབ་ཕྲུག་ཚུ་གིས་ ཞུ་འབུལ་གསལ་བཤད་
 ངོས་ལེན་འབད་ནི་དགོས་མཁོ་ཡོདཔ།';
$string['requiresubmissionstatement_help'] = 'ཨ་ཕི་ སློབ་ཕྲུག་ཚུ་གིས་ ཞུ་འབུལ་གསལ་བཤད་
 ངོས་ལེན་འབད་ནི་དགོས་མཁོ་ཡོདཔ།';
$string['revealidentities'] = 'སློབ་ཕྲུག་གི་ངོ་རྟགས་ཚུ་ཕྱིར་གསལ་འབད།';
$string['revealidentitiesconfirm'] = 'ལས་འགུལ་གྱི་དོན་ལུ་ སློབ་ཕྲུག་གི་ངོ་རྟགས་ཚུ་ཕྱིར་གསལ་འབད་ནི་ངེས་གཏན་ཨིན་ན། བཀོལ་སྤྱོད་འདི་ལོག་མེདཔ་གཏང་མི་བཏུབ། སློབ་ཕྲུག་གི་ངོ་རྟགས་ཚུ་ཚར་གཅིག་ཕྱིར་གསལ་འབད་པ་ཅིན་ སྐུགས་ཀྱི་ཀི་དེབ་ལུ་ སྐུགས་ཚུ་གསར་བཏོན་འབདཝ་ཨིན།';
$string['reverttodraft'] = 'ཞུ་འབུལ་དེ་ ཟིན་བྲིས་གནས་ཚད་ལུ་རྒྱབ་ལོག་བཏང་?';
$string['reverttodraftforstudent'] = 'ཞུ་འབུལ་དེ་ སློབ་ཕྲུག་(id={$a->id},མིང་ཆ་ཚང་
= {$a->fullname})གི་དོན་ལུ་ ཟིན་བྲིས་ལུ་རྒྱབ་ལོག་བཏང་།';
$string['reverttodraftshort'] = 'ཞུ་འབུལ་དེ་ ཟིན་བྲིས་ལུ་རྒྱབ་ལོག་བཏང་།';
$string['reviewed'] = 'བསྐྱར་ཞིབ་འབད་ཡོདཔ།';
$string['saveallquickgradingchanges'] = 'འཕྲལ་མགྱོགས་སྐུགས་བྱིན་ནི་བསྒྱུར་བཅོས་ཚུ་གེ་ར་ སྲུངས།';
$string['savechanges'] = 'བསྒྱུར་བཅོས་ཚུ་སྲུངས།';
$string['savegradingresult'] = 'སྐུགས།';
$string['savenext'] = 'སྲུངས་འབད་ ཤུལ་མམསྟོན།';
$string['scale'] = 'ཆ་ཚད།';
$string['selectedusers'] = 'གདམ་ཁ་འབད་ཡོད་པའི་ལག་ལེན་པ་ཚུ།';
$string['selectlink'] = 'སེལ་འཐུ་འབད་....';
$string['selectuser'] = '{$a} སེལ་འཐུ་འབད།';
$string['sendlatenotifications'] = 'ཕྱིས་ཡོད་པའི་ཞུ་འབུལ་ཚུ་གི་སྐོར་ལས་ སྐུགས་བྱིན་མི་ཚུ་ལུ་ བརྡ་བསྐུལ་འབད།';
$string['sendnotifications'] = 'ཞུ་འབུལ་ཚུ་གི་སྐོར་ལས་ སྐུགས་བྱིན་མི་ཚུ་ལུ་ བརྡ་བསྐུལ་འབད།';
$string['sendstudentnotifications'] = 'སློབ་ཕྲུག་ཚུ་ལུ་དྲན་སྐུལ་འབད།';
$string['sendstudentnotifications_help'] = 'གལ་སྲིད་ ལྕོགས་ཅན་བཟོ་བ་ཅིན་ སློབ་ཕྲུག་ཚུ་གིས་ སྐུགས་ ཡང་ན་ བསམ་ལེན་ དུས་མཐུན་བཟོ་ཡོད་པའི་སྐོར་ལས་ འཕྲིན་ཡིག་འཐོབ།';
$string['sendsubmissionreceipts'] = 'སློབ་ཕྲུག་ཚུ་ལུ་ ཞུ་འབུལ་གྱི་འབྱོར་རྟགས་གཏང་།';
$string['setmarkerallocationforlog'] = 'བརད་མཚན་$a->marker}). གི་སྐུགས་བརྡ་སྟོན་ནི་གི་ཚད་གཞི་བཟོ།';
$string['setmarkingallocation'] = 'སྐལཝ་སྤྲོད་ནི་གི་བརྡ་མཚན་གཞི་སྒྲིག་འབད།';
$string['setmarkingworkflowstate'] = 'སྐུགས་བྱིན་ནི་གི་ལཱ་འབབ་གནས་གཞི་གི་གཞི་སྒྲིག་འབད།';
$string['setmarkingworkflowstateforlog'] = '(id={$a->id}, fullname={$a->fullname}, state={$a->state}). གི་སྐུགས་བྱིན་ནི་གི་ལཱ་འབབ་གནས་གཞི་གི་གཞི་སྒྲིག་འབད།';
$string['settings'] = 'ལས་འགུལ་གཞི་སྒྲིགས་ཚུ།';
$string['showrecentsubmissions'] = 'འཕྲལ་སྐབས་སྤྲོད་ནི་ཚུ་དེ་སྟོན།';
$string['status'] = 'གནས་ཚད';
$string['submission'] = 'སྤྲོད་ནི།';
$string['submissioncopiedhtml'] = '<i>{$a->assignment}</i>\'.</p> <p>གི་དོན་ལས་ ཁྱོད་ཀྱིས་ ཧེ་མའི་ལས་འགུལ་སྤྲོད་ནི་གི་འདྲ་ཅིག་བཟོ་ནུག<a href="{$a->url}">assignment submission</a>.</p>གི་གནས་རིམ་དེ་ཁྱོད་ཀྱིས་བལྟ་ཚཱུགས།';
$string['submissioncopiedsmall'] = '{$a->assignment}གི་དོན་ལས་ཁྱོད་ཀྱིས་ ཧེ་མའི་ལས་འགུལ་སྤྲོད་ནི་གི་འདྲ་ཅིག་བཟོ་ནུག';
$string['submissioncopiedtext'] = '\'{$a->assignment}\'གི་དོན་ལས་ཁྱོད་ཀྱིས་ ཧེ་མའི་ལས་འགུལ་སྤྲོད་ནི་གི་འདྲ་ཅིག་བཟོ་ནུག  {$a->url} གི་ལས་འགུལ་སྤྲོད་ནི་གི་གནས་རིམ་དེ་ཁྱོད་ཀྱིས་བལྟ་ཚཱུགས།';
$string['submissiondrafts'] = 'སློབ་ཕྲུག་ཚུ་གིས་ སྤྲོད་ཨེབ་རྟ་ཨེབ་གཏང་ནི་དགོས་མཁོ་ཡོདཔ།';
$string['submissioneditable'] = 'སློབ་ཕྲུག་གི་ ཞུ་འབུལ་དེ་ཞུན་དག་འབད་ཚུགས།';
$string['submissionempty'] = 'ག་ནི་ཡང་མ་སྤྲོད་སྦེ།';
$string['submissionnotcopiedinvalidstatus'] = 'ཚར་ཅིག་ལོག་ཕྱི་ཞིནམ་ལས་ཞུན་དག་འབད་ཡོདཔ་ལས་ སྤྲོད་ནི་དེ་འདྲབཤུད་རྐྱབ་མི་བཏུབ་པས།';
$string['submissionnoteditable'] = 'སློབ་ཕྲུག་གི་ ཞུ་འབུལ་དེ་ཞུན་དག་འབད་མི་ཚུགས།';
$string['submissionnotready'] = 'ལས་འགུལ་འདི་སྤྲོད་ནི་ལུ་གྲ་སྒྲིག་མིན་འདུག:';
$string['submissionplugins'] = 'ཞུ་འབུལ་plugins';
$string['submissionreceipthtml'] = 'ཁྱོད་ཀྱི་ \'<i>{$a->assignment}</i>\'<br /><br />དོན་ལུ་ལས་འགུལ་ཞུ་འབུལ་ཅིག་སྤྲོད་ཡོད། ཁྱོད་ཀྱི་གི་<a href="{$a->url}">ལས་འགུལ་ཞུ་འབུལ</a> གི་གནས་ཚད་མཐོང་ཚུགས།';
$string['submissionreceipts'] = 'ཞུ་འབུལ་གྱི་འབྱོར་རྟགས་གཏང་།';
$string['submissionreceiptsmall'] = 'ཁྱོད་ཀྱི་ {$a->assignment}དོན་ལུ་ལས་འགུལ་ཞུ་འབུལ་ཅིག་སྤྲོད་ཡོད།';
$string['submissionreceipttext'] = 'ཁྱོད་ཀྱི་ \'{$a->assignment}\' གི་དོན་ལུ་ལས་འགུལ་ཞུ་འབུལ་ཅིག་སྤྲོད་ཡོད། ཁྱོད་ཀྱི་གི་ལས་འགུལ་ཞུ་འབུལ་ གི་གནས་ཚད་ {$a->url}་མཐོང་ཚུགས།';
$string['submissions'] = 'སྤྲོད་ནི་ཚུ';
$string['submissionsclosed'] = 'སྤྲོད་ནི་ཚུ་ ཁ་བསྡམས་ཡོད།';
$string['submissionsettings'] = 'སྤྲོད་ནི་ གཞི་སྒྲིག་ཚུ།';
$string['submissionslocked'] = 'ལས་འགུལ་འདི་གིས་ཞུ་འབུལ་ཚུ་དང་ལེན་མི་འབད་བས།';
$string['submissionslockedshort'] = 'ཞུ་འབུལ་བསྒྱུར་བཅོས་ཚུ་འབད་མི་ཆུག།';
$string['submissionsnotgraded'] = 'ཞུ་འབུལ་ཚུ་སྐུགས་མ་བྱིན་པས་: {$a}';
$string['submissionstatement'] = 'ཞུ་འབུལ་གསལ་བཤད།';
$string['submissionstatementacceptedlog'] = 'ལག་ལེན་པ་{$a}་དང་ལེན་འབད་ཡོད་པའི་ ཞུ་འབུལ་གསལ་བཤད།';
$string['submissionstatementdefault'] = 'ངོ་སྦྱོར་འབད་ཡོད་པའི་གཞན་གྱི་ལཱ་ཚུ་ ལག་ལེན་འཐབ་དེ་ཡོད་མི་མ་གཏོགས་ ལས་འགུལ་འདི་ ང་རའི་འབད་བའི་ལཱ་ཨིན།';
$string['submissionstatement_help'] = 'ལས་འགུལ་ཞུ་འབུལ་ ངེས་དཔྱད་གསལ་བཤད།';
$string['submissionstatus'] = 'ཞུ་འབུལ་གྱི་ གནས་ཚད།';
$string['submissionstatus_'] = 'ཞུ་འབུལ་མེད།';
$string['submissionstatus_draft'] = 'ཟིན་བྲིས་(མ་སྤྲོད་པས)';
$string['submissionstatusheading'] = 'ཞུ་འབུལ་གྱི་ གནས་ཚད།';
$string['submissionstatus_marked'] = 'སྐུགས་བྱིན་ཡོདཔ།';
$string['submissionstatus_new'] = 'ཞུ་འབུལ་གྱི་ གསརཔ།';
$string['submissionstatus_reopened'] = 'ལོག་ཕྱེ་ཡོདཔ།';
$string['submissionstatus_submitted'] = 'སྐུགས་ཀྱི་དོན་ལུ་སྤྲོད་ཡོད།';
$string['submissionsummary'] = '{$a->status}དེ་{$a->timemodified}སྒྲིག་བཅོས་འབད་ཡོདཔ།';
$string['submissionteam'] = 'སྡེ་ཚན།';
$string['submissiontypes'] = 'སྤྲོད་ནིའི་དབྱེ་བ།';
$string['submitaction'] = 'སྤྲོད་ནི།';
$string['submitassignment'] = 'ལས་འགུལ་ སྤྲོད།';
$string['submitassignment_help'] = 'ལས་འགུལ་འདི་ཚར་གཅིག་ཕུལ་ཞིནམ་ལས་ ད་རུང་ལོག་་བསྒྱུར་བཅོས་འབད་མི་བཏུབ།';
$string['submitted'] = 'སྤྲོད་ཡོད།';
$string['submittedearly'] = 'ལས་འགུལ་འདི་{$a}ཧ་སག་སྟེ་ སྤྲོད་ཡོད།';
$string['submittedlate'] = 'ལས་འགུལ་འདི་ {$a} ཕྱིས་སུ་ སྤྲོད་ཡོད།';
$string['submittedlateshort'] = '{$a} ཕྱིས་སུ་';
$string['subplugintype_assignfeedback'] = 'བསམ་ལེན་ པ་ལག་ཨིན།';
$string['subplugintype_assignfeedback_plural'] = 'བལམ་ལེན་ པ་ལག་ཨིན་ཚུ།';
$string['subplugintype_assignsubmission'] = 'ཞུ་འབུལ་ པ་ལག་ཨིན།';
$string['subplugintype_assignsubmission_plural'] = 'ཞུ་འབུལ་པ་ལག་ཨིན་ཚུ།';
$string['teamsubmission'] = 'སློབ་ཕྲུག་ཚུ་གི་སྡེ་ཚན་ཚུ་འབད་སྤྲོད།';
$string['teamsubmissiongroupingid'] = 'སློབ་ཕྲུག་གི་སྡེ་ཚན་ཚུ་དོན་ལུ་ སྡེ་བཟོ།';
$string['teamsubmissiongroupingid_help'] = 'ལས་འགུལ་གྱིས་ སློབ་ཕྲུག་ཚུ་གི་སྡེ་ཚན་གྱི་སྡེ་ཚན་ཚུ་འཚོལ་ཞིབ་འབད་ནི་ལུ་སྡེ་བཟོ་དེ་ལག་ལེན་འཐབ་འོང་། གཞི་སྒྲིག་མ་འབན་བ་ཅིན་ སྔོན་སྒྲིག་གཞི་སྒྲིག་གི་སྡེ་ཚན་ཚུ་ལག་ལེན་འཐབ་འོང་།';
$string['teamsubmission_help'] = 'གལ་སྲིད་ལྕོགས་ཅན་བཟོ་བ་ཅིན་ སློབ་ཕྲུག་ཚུ་སྡེ༌ཚན༌ནང༌ སྔོན་སྒྲིག་གཞི་སྒྲིག་གི་སྡེ་ཚན་ ཡང་ན་ སྲོལ་སྒྲིག་སྡེ་བཟོ་དང་འཁྲིལ་ བགོ་བཤའ་བརྐྱབ་འོང་། སྡེ་ཚན་ཞུ་འབུལ་འདི་ སྡེ་ཚན་གྱི་འཐུས་མི་དང་ སྡེ་ཚན་ནང་གི་འཐུས་མི་ག་ར་གིས་བར་ནང་ བགོ་བཤའ་བརྐྱབ་འོང་། གཅིག་གིས་གཅིག་ བསྒྱུར་བཅོས་བརྐྱབས་ཡོད་པའི་ཞུ་འབུལ་ཚུ་ཡང་མཐོང་ཚུགས།';
$string['teamsubmissionstatus'] = 'སྡེ་ཚན་ ཞུ་འབུལ་གྱི་ གནས་ཚད།';
$string['textinstructions'] = 'ལས་འགུལ་ཚུ་གིས་བསླབ་སྟོན།';
$string['timemodified'] = 'སྒྱུར་བཅོས་འབད་ཡོད་པའི་ མཇུག་མམ།';
$string['timeremaining'] = 'ལྷག་ལུས་ཆུ་ཚོད།';
$string['unlimitedattempts'] = 'ཚད་མེདཔའི་དཔའ་བཅམ་འབད་ཆོག';
$string['unlimitedattemptsallowed'] = 'ཚད་མེདཔའི་དཔའ་བཅམ་ཚུ་འབད་ཆོག';
$string['unlocksubmissionforstudent'] = 'སློན་ཕྲུག་(id={$a->id}, མིང་ཆ་ཚང་={$a->fullname})་གི་དོན་ལུ་ཞུ་འབུལ་འབད་བཅུག།';
$string['unlocksubmissions'] = 'ཞུ་འབུལ་ཚུ་ ལྡེ་མིག་ཕྱེ།';
$string['updategrade'] = 'སྐུགས་དུས་མཐུན་བཟོ་ནི།';
$string['updatetable'] = 'ཐིག་ཁྲམ་ སྲུངས་བཞག་སྦེ་དུས་མཐུན་བཟོ་ནི།';
$string['upgradenotimplemented'] = '་plugin ({$a->type} {$a->subtype}) ནང་ དུས་མཐུན་བཟོ་ནི་ ལག་ལེན་མ་འཐབ་པས།';
$string['userextensiondate'] = '{$a}ཚུན་ཚོད་ཕར་འགྱངས་གནང་ཡོད།';
$string['usergrade'] = 'ལག་ལེན་པའི་སྐུགས།';
$string['userswhoneedtosubmit'] = '{$a} སྤྲོད་ནི་ཡོད་མི་ལག་ལེན་པ་ཚུ།';
$string['validmarkingworkflowstates'] = 'ཁུངས་ཡོད་པའི་ལཱ་འབབ་བཟོ་ནིའི་གནས་རིམ་ཚུ།';
$string['viewbatchmarkingallocation'] = 'སྡེ་ཁག་བཟོ་བའི་སྐལ་འབད་མི་གི་ངོ་ཤོག་དེ་བལྟ།';
$string['viewbatchsetmarkingworkflowstate'] = 'སྡེ་ཁག་བཟོ་བའི་སྐལ་འབད་མི་ལཱ་འབབ་གནས་རིམ་གྱི་ངོ་ཤོག་དེ་བལྟ།';
$string['viewfeedback'] = 'བསམ་ལན་ལྟ།';
$string['viewfeedbackforuser'] = 'ལག་ལེན་པ་{$a}གི་དོན་ལུ་བསམ་ལན་ལྟ།';
$string['viewfull'] = 'ཆ་ཚང་བལྟ།';
$string['viewfullgradingpage'] = 'བསམ་ལན་བཀྲམ་ནི་དོན་ལུ་ སྐུགས་བྱིན་ནི་ཤོག་ལེབ་ཆ་ཚང་དེ་ཁ་ཕྱེ།';
$string['viewgradebook'] = 'སྐུགས་ཀྱི་ཀི་དེབ་ བལྟ།';
$string['viewgrading'] = 'ཞུ་འབུལ་ཚུ་གེ་ར་ བལྟ་/སྐུགས་བྱིན།';
$string['viewgradingformforstudent'] = 'སློབ་ཕྲུག་(id={$a->id}, མིང་ཆ་ཚང་={$a->fullname})་གི་དན་ལུ་སྐུགས་བྱིན་ནི་ཤོག་ལེབ་བལྟ།';
$string['viewownsubmissionform'] = 'རང་གི་སྤྲོད་ཡོད་མི་ལས་འགུལ་ཤོག་ལེབ་ བལྟ།';
$string['viewownsubmissionstatus'] = 'རང་གི་ཞུ་འབུལ་གནས་ཚད་ཤོག་ལེབ་ བལྟ།';
$string['viewrevealidentitiesconfirm'] = 'སློབ་ཕྲུག་གི་ངོ་རྟགས་ཚུ་ཕྱིར་གསལ་འབད་ནིའི་ ངེས་དཔྱད་ཤོག་ལེབ་ སྟོན།';
$string['viewsubmission'] = 'ཞུ་འབུལ་ བལྟ།';
$string['viewsubmissionforuser'] = 'ལག་ལེན་{$a}་དོན་ལུ་ཞུ་འབུལ་ བལྟ།';
$string['viewsubmissiongradingtable'] = 'ཞུ་འབུལ་ལུ་སྐུགས་བྱིན་ནིའི་ཐིག་ཁྲམ་ བལྟ།';
$string['viewsummary'] = 'བཅུད་བསྡུད་དེ་བལྟ།';
$string['workflowfilter'] = 'ལཱ་འབབ་ཀྱི་བཙག་ཆས།';
