<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Prvo upozorenje';
$string['alert2'] = 'Drugo upozorenje';
$string['alert3'] = 'Treće upozorenje';
$string['alert_general'] = 'Najava';
$string['alert_info'] = 'Informacije';
$string['alertsdesc'] = 'Ovo će vašim korisnicima prikazati upozorenje/a na naslovnoj stranici Moodlea. Nemojte zaboravite da ih isključite kada vam više nisu potrebna,';
$string['alertsheading'] = 'Upozorenja korisnicima';
$string['alertsheadingsub'] = 'Prikažite važne poruke vašim korisnicima na naslovnoj stranici';
$string['alerttext'] = 'Tekst upozorenja';
$string['alerttextdesc'] = 'Kako glasi tekst koji želite da prikažete u upozorenju.';
$string['alerttitle'] = 'Naslov';
$string['alerttitledesc'] = 'Glavni naslov vašeg upozorenja.';
$string['alerttype'] = 'Nivo';
$string['alerttypedesc'] = 'Podesite odgovarajući nivo/tip upozorenja kako biste najbolje informisali svoje korisnike.';
$string['alert_warning'] = 'Upozorenje';
$string['allclasses'] = 'Svi časovi';
$string['allcourses'] = 'Svi kursevi';
$string['allmodules'] = 'Svi moduli';
$string['allunits'] = 'Sve jedinice';
$string['alternativecolors'] = 'Alternativne boje {$a}';
$string['alternativethemecolor'] = 'Alternativna boja teme {$a}';
$string['alternativethemecolordesc'] = 'Koje boje bi trebalo da bude vaša tema za alternativne boje teme {$a}.';
$string['alternativethemecolorname'] = 'Naziv alternativnog skupa boja {$a}';
$string['alternativethemecolornamedesc'] = 'Obezbedite prepoznatljiv naziv za ovaj skup alternativnih boja teme';
$string['alternativethemecolors'] = 'Alternativne boje teme';
$string['alternativethemecolorsdesc'] = 'Definišite alternativne boje za vašu temu koje korisnik može da izabere.';
$string['alternativethemehovercolor'] = 'Alternativna lebdeća boja teme {$a}';
$string['alternativethemehovercolordesc'] = 'Koja boja bi trebalo da bude lebdeća boja u vašoj temi za alternativne boje teme {$a}.';
$string['alternativethemename'] = 'Naziv šeme boja';
$string['alternativethemenamedesc'] = 'Obezbedite naziv za vaše alternativne boje teme';
$string['alternativethemetextcolor'] = 'Boja alternativnog teksta {$a}';
$string['alternativethemetextcolordesc'] = 'Podesite boju za vaš alternativni tekst {$a}.';
$string['alternativethemeurlcolor'] = 'Boja alternativnog linka {$a}';
$string['alternativethemeurlcolordesc'] = 'Podesite boju za vaš alternativni linkovani tekst {$a}.';
$string['alwaysdisplay'] = 'Uvek prikaži';
$string['analytics'] = 'Analitika';
$string['analyticscleanurl'] = 'čiste URL adrese';
$string['analyticscleanurldesc'] = 'Generišite čistu URL adresu za napredno praćenje';
$string['analyticsdesc'] = 'Izaberite alat za Analitiku koji želite da umetnete i sačuvajte promena kako biste omogućili druge opcije.';
$string['analyticsenabled'] = 'Omogućeno';
$string['analyticsenableddesc'] = 'Omogući Analitiku za Moodle';
$string['analyticsguniversal'] = 'Google univerzalna analitika';
$string['analyticsheadingsub'] = 'Moćna analitika za Moodle';
$string['analyticsimagetrack'] = 'Praćenje slika';
$string['analyticsimagetrackdesc'] = 'Omogućite praćenje slika za veb čitače u kojima je isključen Javascript';
$string['analyticspiwik'] = 'Piwik';
$string['analyticssiteid'] = 'ID sajta';
$string['analyticssiteiddesc'] = 'Unesite ID vašeg sajta';
$string['analyticssiteurl'] = 'URL adresa alata za analitiku';
$string['analyticssiteurldesc'] = 'Unesite URL adresu vašeg Piwik Analytics alata bez http(s) odnosno kose crte. Na primer "mysite.com/analytics".';
$string['analyticstrackadmin'] = 'Praćenje administratora';
$string['analyticstrackadmindesc'] = 'Omogućite praćenje aktivnosti korisnika sa administratorskim nalogom (ne preporučuje se)';
$string['analyticstrackingid'] = 'ID sajta';
$string['analyticstrackingiddesc'] = 'Unesite svoj ID za praćenje';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Unesite URL adresu za vašu mobilnu aplikaciju u Google Play prodavnici. Ukoliko nemate svoju možete uneti adresu besplatne zvanične Moodle Mobile aplikacije (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['backgroundstylefixed'] = 'Fiksirano';
$string['backgroundstylestretch'] = 'Razvučeno';
$string['backgroundstyletiled'] = 'Popločano';
$string['backtotop'] = 'Nazad na vrh';
$string['badgepreferences'] = 'Bedž (parametri)';
$string['blogpreferences'] = 'Blog (parametri)';
$string['bootstrapcdn'] = 'FontAwesome sa CDN sistema za distribuciju sadržaja';
$string['bootstrapcdndesc'] = 'Ako je omogućeno, ovo će učitati FontAwesome sa onlajn Bootstrap CDN sistema za distribuciju sadržaja. Omogućite ovu opciju ukoliko imate problema sa prikazivanjem Font Awesome ikonica na svom sajtu,';
$string['breadcrumbsimple'] = 'Jednostavan';
$string['breadcrumbstyle'] = 'Stil navigacione putanje';
$string['breadcrumbstyled'] = 'Elegantan';
$string['breadcrumbstyledesc'] = 'Ovde možete da promenite stil navigacione putanje.';
$string['breadcrumbstylednocollapse'] = 'Elegantan bez skupljanja';
$string['breadcrumbthin'] = 'Proređen';
$string['cachesused'] = 'Korišćena keš memorija';
$string['categoryiconcategory'] = 'Ikonica za kategoriju: {$a->category}.';
$string['categoryicondesc'] = 'Ako omogućena ova opcija će vam dozvoliti da podesite ikonice za svaku kategoriju kursa.';
$string['categoryiconheading'] = 'Ikonice kategorija';
$string['categoryiconheadingsub'] = 'Koristite ikonice za prikazivanje vaših kategorija';
$string['categoryiconinfo'] = 'Podesite prilagođene ikonice kategorija';
$string['categoryiconinfodesc'] = 'Unesite naziv ikonice koju želite da koristite. Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza "fa-".';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>O temi Essential</h3>
<p>Essential se zasniva na temi Bootstrap, koja je kreirana za Moodle 2.5. Kreiranje teme su pomogli:<br> Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans</p>
<h3>Zasluge za temu</h3>
<p>Originalni autor: Julian Ridden<br>
Od jula 2014 razvoj teme su preuzeli:<br>
Gareth J. Barnard<br>
David Bezemer<br>
</p>
<h3>Donacije</h3>
<p>Ova tema je besplatna, i ukoliko želite da  iskažete svoju zahvalnost, molimo vas da razmotrite mogućnost slanja donacije
<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=themmai%40gmail%2ecom&lc=GB&item_name=Essential%20Theme%20Fund&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_LG%2egif%3aNonHosted" target="_blank">
tako što ćete kliknuti ovde.
</a><br>Donacije će nam omogućiti da za vas razvijemo temu, kako sa većim brojem tako i sa boljim funkcijama, za kraće vreme.</p>
</div></div>';
$string['colordesc'] = 'Ovde možete naći različita podešavanja za promenu mnogih boja u ovoj temi.';
$string['colorheading'] = 'Boje';
$string['colorheadingsub'] = 'Podesite boje koje se koriste u vašoj temi';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Kontakt informacije';
$string['contactinfodesc'] = 'Upišite svoje kontakt informacije';
$string['copyright'] = 'Autorsko pravo';
$string['copyrightdesc'] = 'Naziv vaše institucije/organizacije';
$string['coursegrades'] = 'Ocene na kursu';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcssdesc'] = 'Koja god CSS pravila dodate u ovo polje za tekst, ona će se reflektovati na sve stranice, što olakšava prilagođavanje ove teme.';
$string['dbqueries'] = 'Baza podataka - čitanje/upisivanje';
$string['defaultcategoryicon'] = 'Podrazumevane ikonice kategorija';
$string['defaultcategoryicondesc'] = 'Podesite podrazumevanu ikonicu kategorije';
$string['defaultcolors'] = 'Podrazumevane boje';
$string['displayafterlogin'] = 'Prikaži samo nakon prijave na sistem';
$string['displaybeforelogin'] = 'Prikaži samo pre prijave na sistem';
$string['displaymycourses'] = 'Prikaži upisane kurseve';
$string['displaymycoursesdesc'] = 'Prikaži korisnicima u prilagođenom meniju kurseve koje su upisali';
$string['donate_desc'] = 'Molimo';
$string['donate_desc2'] = 'kako biste pomogli dalji razvoj teme Essential ili jednostavno izrazili svoju zahvalnost.';
$string['donate_title'] = 'Donacije za temu Essential';
$string['dontdisplay'] = 'Nikad ne prikazuj';
$string['enablealert'] = 'Uključi upozorenja';
$string['enablealertdesc'] = 'Uključi ili isključi upozorenje';
$string['enablealternativethemecolors'] = 'Omogući alternativne boje teme {$a}';
$string['enablealternativethemecolorsdesc'] = 'Ako je ova opcija omogućena korisnik će moći da izabere boje teme {$a}';
$string['enablecategoryicon'] = 'Omogući ikonice kategorija';
$string['enablecategoryicondesc'] = 'Ako je omogućeno, moći ćete da izaberete ikonice kategorija nakon što kliknete na "Sačuvaj promene"';
$string['enablecustomcategoryicon'] = 'Omogući prilagođene ikonice kategorija';
$string['enablecustomcategoryicondesc'] = 'Ako je ova opcija omogućena. ispod ovog odeljka videćete kategorije sa podesivim opcijama pored svake kategorije. Molimo vas da sačuvate promene nakon što omogućite/onemogućite ovu opciju.';
$string['extperfinfoheading'] = 'Informacije o dodatnim performansama';
$string['facebook'] = 'Facebook URL adresa';
$string['facebookdesc'] = 'Unesite URL adresu vaše Facebook stranice (tj.http://www.facebook.com/mojaskola).';
$string['few'] = 'Nekoliko';
$string['fitvids'] = 'Koristi FitVids';
$string['fitvidsdesc'] = 'Omogućite FitVids (fitvidsjs.com) kako bi vaši video snimci bili prilagodljivi. Ako je FitVids uključen, i pritom želite da video snimak bude isključen, onda u HTML kôd dodajte \'class="fitvidsignore"\' unutar \'iframe\' oznake. Na primer: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fixedwidthnarrow'] = 'Fiksna širina - Usko';
$string['fixedwidthnormal'] = 'Fiksna širina - Normalno';
$string['fixedwidthwide'] = 'Fiksna širina - Široko';
$string['flattr_click'] = 'pomoću servisa Flattr';
$string['flattr_desc'] = '{$a->url}';
$string['flickr'] = 'Flickr URL adresa';
$string['flickrdesc'] = 'Unesite URL adresu vaše Flickr stranice (tj.http://www.flickr.com/mojaskola).';
$string['fontcharacterset'] = 'Додатан скуп карактера Google фонта';
$string['fontcharactersetcyrillic'] = 'Ćirilica';
$string['fontcharactersetcyrillicext'] = 'Проширена ћирилица';
$string['fontcharactersetdesc'] = 'Izaberite dodatni skupove karaktera za različite jezike.
Kako korišćenje više skupova karaktera može da uspori vaš Moodle izaberite samo one koji su vam stvarno potrebni.';
$string['fontcharactersetgreek'] = 'Grčki alfabet';
$string['fontcharactersetgreekext'] = 'Prošireni grčki alfabet';
$string['fontcharactersetlatinext'] = 'Proširena latinica';
$string['fontcharactersetvietnamese'] = 'Vijetnamski';
$string['fontfileeotbody'] = 'Datoteka osnovnog EOT fonta';
$string['fontfileeotheading'] = 'Datoteka EOT fonta naslova';
$string['fontfileotfbody'] = 'Datoteka osnovnog OTF fonta';
$string['fontfileotfheading'] = 'Datoteka OTF fonta naslova';
$string['fontfiles'] = 'Datoteke fontova';
$string['fontfilesdesc'] = 'Postavite ovde svoje datoteke fontova.';
$string['fontfilesvgbody'] = 'Datoteka osnovnog SVG fonta';
$string['fontfilesvgheading'] = 'Datoteka SVG fonta naslova';
$string['fontfilettfbody'] = 'Datoteka osnovnog TTF fonta';
$string['fontfilettfheading'] = 'Datoteka TTF fonta naslova';
$string['fontfilewoffbody'] = 'Datoteka osnovnog WOFF fonta';
$string['fontfilewoffheading'] = 'Datoteka WOFF fonta naslova';
$string['fontfilewofftwobody'] = 'Datoteka osnovnog WOFF2 fonta';
$string['fontfilewofftwoheading'] = 'Datoteka WOFF2 fonta naslova';
$string['fontheadingdesc'] = 'Izaberite i unesite fontove koje želite da koristite u svom Moodle okruženju.';
$string['fontheadingsub'] = 'Podešavanja fonta';
$string['fontnamebody'] = 'Font teksta';
$string['fontnamebodydesc'] = 'Unesite tačan naziv fonta koji želite da koristite za sav ostali tekst';
$string['fontnameheading'] = 'Font naslova';
$string['fontnameheadingdesc'] = 'Unesite tačan naziv fonta koji želite da koristite za naslove';
$string['fontselect'] = 'Birač tipa fonta';
$string['fontselectdesc'] = 'Izaberite sa spiska dostupnih tipova fontova. Molimo sačuvajte kako bi se prikazale opcije za tip fonta koji ste izabrali';
$string['fontsettings'] = 'Font';
$string['fonttypecustom'] = 'Nestandardni font';
$string['fonttypegoogle'] = 'Google  veb fontovi';
$string['fonttypestandard'] = 'Standardni fontovi';
$string['footercolor'] = 'Boja pozadine podnožja';
$string['footercolordesc'] = 'Podesite boju pozadine regiona koji se nalazi u podnožju stranice';
$string['footercolors'] = 'Boje podnožja';
$string['footercolorsdesc'] = 'Promenite boje podnožja stranice';
$string['footerheading'] = 'Podnožje stranice';
$string['footerheadingcolor'] = 'Boja naslova u podnožju stranice';
$string['footerheadingcolordesc'] = 'Podesite boju za naslove blokova u podnožju stranice.';
$string['footerhovercolor'] = 'Boja lebdećih linkova u podnožju stranice';
$string['footerhovercolordesc'] = 'Podesite boju za linkovani tekst u podnožja stranice prilikom prelaska mišem preko njega.';
$string['footersepcolor'] = 'Boja separatora u podnožju stranice';
$string['footersepcolordesc'] = 'Separatori su linije koje se koriste da bi se razdvojio sadržaj. Ovde podesite boju za separatore.';
$string['footertextcolor'] = 'Boja teksta u podnožju stranice';
$string['footertextcolordesc'] = 'Podesite boju kojom želite da bude prikazan tekst u podnožju stranice.';
$string['footerurlcolor'] = 'Boja linka u podnožju stranice';
$string['footerurlcolordesc'] = 'Podesite boju za vaš linkovani tekst u podnožju stranice.';
$string['footnote'] = 'Podnožje';
$string['footnotedesc'] = 'Sadržaj ovog polja za tekst biće prikazan u podnožju svake stranice vašeg Moodle sajta.';
$string['frontcontent'] = 'Omogući tekstualni blok na naslovnoj stranici';
$string['frontcontentarea'] = 'Sadržaj tekstualnog bloka na naslovnoj stranici';
$string['frontcontentareadesc'] = 'Sadržaj koji unesete u ovaj tekstualni blok biće prikazan čitavom širinom naslovne stranice u prostoru koji se nalazi između slajd prezentacije i promotivnih blokova.';
$string['frontcontentdesc'] = 'Ako je omogućeno, ovo dodaje tekstualni blok za vaš namenski prilagođeni sadržaj, smešten između slajd prezentacije i promotivnih blokova.';
$string['frontcontentheading'] = 'Tekstualni blok na naslovnoj stranici';
$string['frontpageblocks'] = 'Poravnanje blokova na naslovnoj stranici';
$string['frontpageblocksdesc'] = 'Ovde možete da odredite da li su blokovi na naslovnoj stranici poravnati na levo ili desno.';
$string['frontpageblocksheading'] = 'Blokovi naslovne stranice';
$string['frontpageheading'] = 'Naslovna stranica';
$string['frontpageheadingdesc'] = 'Podesite ovde koje dodatne stavke želite da prikažete na naslovnoj stranici.';
$string['frontpagemiddleblocks'] = 'Omogući središnje blokove na naslovnoj stranici';
$string['frontpagemiddleblocksdesc'] = 'Ako je omogućena, ova opcija će prikazati 3 nova bloka odmah ispod promotivnih blokova';
$string['fullname'] = 'Pun naziv sajta';
$string['fullnamesummary'] = 'Pun naziv sajta i rezime';
$string['generalheadingdesc'] = 'Konfigurišite ovde globalna podešavanja teme. Pronaćićete opcije za dozajn i vizuelni identitet stranice.';
$string['generalheadingsub'] = 'Opšta podešavanja';
$string['genericsettings'] = 'Opšte';
$string['googleplus'] = 'Google+ URL adresa';
$string['googleplusdesc'] = 'Unesite URL adresu vašeg Google+ profila (tj.http://plus.google.com/+mojaskola).';
$string['headerheading'] = 'Zaglavlje';
$string['headertitle'] = 'Naslov zaglavlja';
$string['headertitledesc'] = 'Podesite ovde naslov koji će se pojaviti u zaglavlju';
$string['helplink'] = 'Link za pomoć';
$string['helplinkdesc'] = 'Ako ste prethodno izabrali opciju "URL adresa" unesite kompletnu URL adresu sajta sa pomoćnim informacijama (adresa mora da sadrži prefiks http:// ili https://). Ako ste izabrali opciju "E-adresa" unesite svoju elektronsku adresu.';
$string['helplinktype'] = 'Omogući link za pomoć u meniju';
$string['helplinktypedesc'] = 'Izaberite da li želite da omogućite opciju za pomoći u korisničkom meniju, Možete da birate između URL adrese sajta sa pomoćnim informacije, koji će se otvarati u novom prozoru, i elektronske adrese.';
$string['hideonphone'] = 'Sakrij slajd-šou na mobilnim uređajima';
$string['hideonphonedesc'] = 'Izaberite da li želite da onemogućite slajd-šou na mobilnim uređajima.';
$string['hideontablet'] = 'Sakrij slajd-šou na mobilnim tabletima';
$string['hideontabletdesc'] = 'Izaberite da li želite da onemogućite slajd-šou na tabletima.';
$string['included'] = 'Datoteke uključene';
$string['instagram'] = 'Instagram URL adresa';
$string['instagramdesc'] = 'Unesite URL adresu vaše Instagram stranice (tj. http://web.stagram.com/mojaskola/)';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Unesite URL adresu za vašu mobilnu aplikaciju u Apple App prodavnici. Ukoliko nemate svoju možete uneti adresu besplatne zvanične mobilne aplikacije za Moodle (https://itunes.apple.com/en/app/moodle-mobile/id633359593)..';
$string['iosicon'] = 'Ikonice iOS početnog ekrana';
$string['iosicondesc'] = 'Tema obezbeđuje standardne ikonice za iOS i Android početne ekrane. Ako želite možete postaviti svoje prilagođene ikonice.';
$string['ipadicon'] = 'iPad ikonica (Non Retina)';
$string['ipadicondesc'] = 'Ikonica treba da bude PNG datoteka veličine 72 x 72 piksela.';
$string['ipadretinaicon'] = 'iPad ikonica (Retina)';
$string['ipadretinaicondesc'] = 'Иконица треба да буде PNG датотека величине 144 x 144 пиксела.';
$string['iphoneicon'] = 'iPhone/iPod Touch ikonica (Non Retina)';
$string['iphoneicondesc'] = 'Ikonica treba da bude PNG datoteka veličine 57 x 57 piksela.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch ikonica (Retina)';
$string['iphoneretinaicondesc'] = 'Ikonica treba da bude PNG datoteka veličine 114 x 114 piksela.';
$string['layout'] = 'Koristi standardni izgled kursa';
$string['layoutdesc'] = 'Ova teme je dizajnirana tako da oba stupca sa blokovima postavlja sa desne strane. Ukoliko preferirate standardni izgled Moodle kurseva možete da označite ovo polje za potvrdu kako biste koristili stari izgled kursa sa tri stupca.';
$string['left'] = 'Levo';
$string['linkedin'] = 'LinkedIn URL adresa';
$string['linkedindesc'] = 'Unesite URL adresu vašeg LinkedIn profila (tj.http://www.linkedin.com/company/mojaskola).';
$string['loadtime'] = 'Vreme učitavanja';
$string['loggedinas'] = 'prijavljen na sistem kao';
$string['loggedinfrom'] = 'Prijavljen na sistem sa';
$string['logo'] = 'Logotip';
$string['logodesc'] = 'Postavite ovde svoj prilagođeni logotip ako želite da ga dodate u zaglavlje.
<br>Slika treba da bude 65px visine i bilo koje razumne širine koja je odgovarajuća.
<br>Ako postavite logotip on će zameniti ikonicu i naziv koji se standardno prikazuju.';
$string['marketing1'] = 'Promotivni blok jedan';
$string['marketing2'] = 'Promotivni blok dva';
$string['marketing3'] = 'Promotivni blok tri';
$string['marketingbuttontext'] = 'Tekst linka';
$string['marketingbuttontextdesc'] = 'Tekst koji se pojavljuje na dugmetu';
$string['marketingbuttonurl'] = 'URL adresa linka';
$string['marketingbuttonurldesc'] = 'URL adresa sa kojom je dugme povezano';
$string['marketingcontent'] = 'Sadržaj';
$string['marketingcontentdesc'] = 'Tekst koji se prikazuje u promotivnom bloku. Treba da bude kratak i zanimljiv.';
$string['marketingdesc'] = 'Ova tema pruža opciju da na naslovnoj stranici postavite tri promotivna bloka ili oglasa, odmah ispod slajd-šou prezentacije. Ovo vam omogućava da svojim korisnicima lako naznačite najbitnije informacije i obezbedite odgovarajuće direktne linkove.';
$string['marketingheading'] = 'Promotivni blokovi';
$string['marketingheadingsub'] = 'Tri mesta na naslovnoj stranici sajta za dodatne informacije i linkove.';
$string['marketingheight'] = 'Visina slika u promotivnim blokovima';
$string['marketingheightdesc'] = 'Ako želite da prikažete slike u promotivnim blokovima ovde možete da odredite njihovu visinu.';
$string['marketingicon'] = 'Ikonica';
$string['marketingicondesc'] = 'Naziv ikonice koju želite da koristite. <br> Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza  "fa-",", npr.  "star".';
$string['marketingimage'] = 'Slika';
$string['marketingimagedesc'] = 'Ovo pruža mogućnost prikazivanja slike iznad teksta u promotivnom bloku';
$string['marketinginfodesc'] = 'Unesite podešavanja za vaš promotivni blok.';
$string['marketingtitle'] = 'Naslov';
$string['marketingtitledesc'] = 'Naslov koji će biti prikazan u ovom promotivnom bloku';
$string['marketingurltarget'] = 'Odredište linka';
$string['marketingurltargetdesc'] = 'Izaberite kako link treba da bude otvoren';
$string['marketingurltargetnew'] = 'Nova stranica';
$string['marketingurltargetparent'] = 'Matični okvir';
$string['marketingurltargetself'] = 'Tekuća stranica';
$string['memused'] = 'Korišćena memorija';
$string['messagepreferences'] = 'Poruke (parametri)';
$string['mobileappsdesc'] = 'Da li imate veb aplikaciju u Apple App ili Google Play prodavnici? Unesite ovde link kako bi vaši korisnici mogli da preuzmu aplikacije onlajn.';
$string['mobileappsheading'] = 'Mobilne aplikacije';
$string['mobileappsheadingsub'] = 'Link ka vašoj aplikacija za studente koji koriste mobilne uređaje.';
$string['myclasses'] = 'Moji časovi';
$string['mycourses'] = 'Moji kursevi';
$string['mycoursesinfo'] = 'Meni upisanih kurseva';
$string['mycoursesinfodesc'] = 'Prikazuje korisnicima dinamički spisak upisanih kurseva';
$string['mycoursetitle'] = 'Terminologija';
$string['mycoursetitledesc'] = 'Promenite terminologiju za link "Moji kursevi" u padajućem meniju';
$string['mygrades'] = 'Moje ocene';
$string['mymodules'] = 'Moji moduli';
$string['myunits'] = 'Moje jedinice';
$string['navbartitle'] = 'Naslov trake za navigaciju';
$string['navbartitledesc'] = 'Podesite ovde naslov koji će se pojaviti u taci za navigaciju';
$string['nextsection'] = 'Sledeća sekcija';
$string['nobreadcrumb'] = 'Sakrij';
$string['noenrolments'] = 'Trenutno nemate upise';
$string['nomessagesfound'] = 'Nije pronađena nijedna poruka';
$string['noslidetitle'] = 'Nema naslova za slajd {$a->slide}';
$string['notitle'] = 'Bez naslova';
$string['numberofslides'] = 'Broj slajdova';
$string['numberofslides_desc'] = 'Broj slajdova u okviru slajd prezentacije.';
$string['oldnavbar'] = 'Koristi stari položaj navigacione trake';
$string['oldnavbardesc'] = 'Omogućite ovu opciju kako biste koristili stari položaj navigacione trake.';
$string['pagebackground'] = 'Pozadinska slika stranice';
$string['pagebackgrounddesc'] = 'Postavite sopstvenu pozadinsku sliku. Izaberite stil slike.';
$string['pagebackgroundstyle'] = 'Stil pozadine stranice';
$string['pagebackgroundstyledesc'] = 'Izaberite stil postavljene slike';
$string['pagewidth'] = 'Podesi širinu stanice';
$string['pagewidthdesc'] = 'Izaberite sa spiska dostupnih širina stranice za vaš sajt';
$string['paypal_click'] = 'pošaljite donaciju pomoću servisa PayPal';
$string['paypal_desc'] = '{$a->url} ili';
$string['peakmem'] = 'Maksimum opterećenja memorije';
$string['perfinfo'] = 'Informacije o performansama';
$string['perfinfodesc'] = 'Mnogim sajtovima nisu potrebne detaljne informacije o performansama, posebno kada se posmatra iz ugla korisnika. Kada je omogućeno, ovo prikazuje osnovne informacije o učitavanju stranice.';
$string['perfinfoheading'] = 'Informacije o performansama';
$string['perf_max'] = 'Detaljno';
$string['perf_min'] = 'Minimalno';
$string['pinterest'] = 'Pinterest URL adresa';
$string['pinterestdesc'] = 'Unesite URL adresu vaše Pinterest stranice (tj.http://pinterest.com/mojaskola).';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Prethodna sekcija';
$string['profilebarcustomtitle'] = 'Traka profila - naslov prilagođenog blok';
$string['profilebarcustomtitledesc'] = 'Naslov za prilagođeni blok sa trakom profila';
$string['readme_click'] = 'kliknite za README.txt';
$string['readme_desc'] = 'Molimo {$a->url} datoteku koja sadrži više informacija o temi Essential.';
$string['readme_title'] = 'Essential read-me datoteka sa uputstvom';
$string['readmore'] = 'Pročitaj više';
$string['region-footer-left'] = 'Podnožje (levo)';
$string['region-footer-middle'] = 'Podnožje (sredina)';
$string['region-footer-right'] = 'Podnožje (desno)';
$string['region-hidden-dock'] = 'Sakriveno od korisnika';
$string['region-home-left'] = 'Početna stranica (levo)';
$string['region-home-middle'] = 'Početna stranica (sredina)';
$string['region-home-right'] = 'Početna stranica (desno)';
$string['region-side-post'] = 'Desno';
$string['region-side-pre'] = 'Levo';
$string['right'] = 'Desno';
$string['serverload'] = 'Opterećenje servera';
$string['sessionsize'] = 'Veličina sesije';
$string['shortname'] = 'Skraćeni naziv sajta';
$string['shortnamesummary'] = 'Skraćeni naziv  i rezime';
$string['siteicon'] = 'Ikonica sajta';
$string['siteicondesc'] = 'Nemate svoj logo? Unesite naziv ikonice koju želite da koristite. Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza "fa-".';
$string['skype'] = 'Skype nalog';
$string['skypedesc'] = 'Unesite korisničko ime za Skype nalog vaše institucije/organizacije.';
$string['slidebuttoncolor'] = 'Boja dugmeta na slajdu';
$string['slidebuttoncolordesc'] = 'Koje boje treba da bude navigaciono dugme na slajdu.';
$string['slidebuttonhovercolor'] = 'Lebdeća boja dugmeta na slajdu';
$string['slidebuttonhovercolordesc'] = 'Koje boje treba da bude lebdeća boja navigacionog dugmeta na slajdu.';
$string['slidecaption'] = 'Opis slajda';
$string['slidecaptionbelow'] = 'Opis slajda ispod slike';
$string['slidecaptionbelowdesc'] = 'Da li opis slajda treba da bude ispod slike';
$string['slidecaptioncentred'] = 'Opis slajda centriran';
$string['slidecaptioncentreddesc'] = 'Da li opis slajda treba da bude na sredini';
$string['slidecaptiondesc'] = 'Unesite tekst koji će se koristiti za opis slajda';
$string['slidecolor'] = 'Boja teksta slajda';
$string['slidecolordesc'] = 'Koje boje treba da bude tekst opisa slajda';
$string['slideimage'] = 'Slika slajda';
$string['slideimagedesc'] = 'Najbolje je koristiti transparentnu sliku.';
$string['slideinterval'] = 'Interval između slajdova';
$string['slideintervaldesc'] = 'Vreme prelaska sa jednog na drugi slajd u milisekundama.';
$string['slideno'] = 'Slajd {$a->slide}';
$string['slidenodesc'] = 'Unesite podešavanja za slajd {$a->slide}.';
$string['slideshowdesc'] = 'Ovo kreira dinamički slajd-šou od maksimalno 16 slajdova za promovisanje važnih stvari na vašem sajtu. Slajd-šou je prilagodljiv tako da se visina slike podešava prema veličini ekrana. Preporučena visina je 300 piksela. Širina je podešena na 100 % pa će zato stvarna visina slike biti manja ako je širina veća od veličine ekrana. Na ekranima manje veličine, visina se dinamički smanjuje, bez potrebe da se obezbede zasebne slike. Za ekrane čija je širina manja od 767 piksela visina će biti165 piksela, za ekrane čija je širina između 768 i 979 piksela, visina će biti 225piksela, dok će za ekrane širine veće od 980 piksela visina biti 300 piksela. Ako je nije izabrana nijedna slika za slajd, onda će se koristiti slika default_slide koja se nalazi u folderu pix.';
$string['slideshowheading'] = 'Slajd-šou';
$string['slideshowheadingsub'] = 'Dinamički slajd-šou na naslovnoj stranici';
$string['slidetitle'] = 'Naslov slajda';
$string['slidetitledesc'] = 'Unesite opisni naslov za vaš slajd';
$string['slideurl'] = 'Link slajda';
$string['slideurldesc'] = 'Unesite ciljno odredište linka prve slike slajda';
$string['slideurltarget'] = 'Odredište linka';
$string['slideurltargetdesc'] = 'Izaberite kako link treba da bude otvoren';
$string['slideurltargetnew'] = 'Nova stranica';
$string['slideurltargetparent'] = 'Matični okvir';
$string['slideurltargetself'] = 'Tekuća stranica';
$string['socialdesc'] = 'Unesite direktne linkove ka glavnim društvenim mrežama kako biste promovisali svoj sajt. Ovi linkovi će se pojavljivati u zaglavlju svake stranice.';
$string['socialheading'] = 'Društvene mreže';
$string['socialheadingsub'] = 'Animirajte svoje korisnike putem društvenih mreža';
$string['socialnetworks'] = 'Društvene mreže';
$string['themecolor'] = 'Boja teme';
$string['themecolordesc'] = 'Koje boje treba da bude vaša tema? Ovo će promeniti brojne komponente kako biste koristili boju koju želite na čitavom sajtu.';
$string['themecolors'] = 'Boje teme';
$string['themehovercolor'] = 'Boja lebdećih linkova teme';
$string['themehovercolordesc'] = 'Koja boje treba da bude lebdeća boja u vašoj temi. Ona se koristi za linkove, menije itd.';
$string['themeiconcolor'] = 'Boja ikonica';
$string['themeiconcolordesc'] = 'Podesite boju za sve ikonice';
$string['themenavcolor'] = 'Boja navigacije';
$string['themenavcolordesc'] = 'Podesite boju za navigaciju, imajući u vidu navigacionu traku i elegantni stil navigacione putanje.';
$string['themetextcolor'] = 'Boja teksta';
$string['themetextcolordesc'] = 'Podesite boju za vaš tekst.';
$string['themeurlcolor'] = 'Boja linka';
$string['themeurlcolordesc'] = 'Podesite boju za vaš linkovani tekst.';
$string['togglemarketing'] = 'Prekidač za prikaz promotivnih blokova';
$string['togglemarketingdesc'] = 'Izaberite da li želite da sakrijete ili prikažete tri promotivna bloka.';
$string['toggleslideshow'] = 'Slajd-šou - prekidač prikaza';
$string['toggleslideshowdesc'] = 'Izaberite da li želite da sakrijete ili prikažete slajd-šou.';
$string['twitter'] = 'Twitter URL adresa';
$string['twitterdesc'] = 'Unesite URL adresu vaše Twitter stranice (tj.http://www.twitter.com/mojaskola).';
$string['unreadnewnotification'] = 'Novo obaveštenje';
$string['usecategoryicon'] = 'Omogući ikonice kategorija';
$string['usecategoryicondesc'] = 'Koristi prilagođene ikonice za kategorije';
$string['variablewidth'] = 'Promenljiva širina';
$string['visibleadminonly'] = 'Blokovi premešteni u donji region biće vidljivi samo administratorima';
$string['vk'] = 'VKontakte URL adresa';
$string['vkdesc'] = 'Unesite URL adresu vaše Vkontakte stranice (tj.http://www.vk.com/mojaskola).';
$string['website'] = 'URL adresa veb sajta';
$string['websitedesc'] = 'Unesite URL adresu vašeg glavnog veb sajta (tj. http://www.mojfakultet.ac.rs ili http://www.mojaskola.edu.rs)';
$string['windows'] = 'Windows stoni računar';
$string['windowsdesc'] = 'Unesite URL adresu za vašu mobilnu aplikaciju u Windows prodavnici. Ukoliko nemate svoju možete uneti adresu besplatne zvanične mobilne aplikacije za Moodle (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc).';
$string['winphone'] = 'Windows mobilni uređaj';
$string['winphonedesc'] = 'Unesite URL adresu za vašu mobilnu aplikaciju u Google Play prodavnici. Ukoliko nemate svoju možete uneti adresu besplatne zvanične mobilne aplikacije za Moodle (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc).';
$string['youtube'] = 'YouTube URL adresa';
$string['youtubedesc'] = 'Unesite URL adresu vašeg YouTube kanala (tj.http://www.youtube.com/mojaskola).';
