<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Ima novih poruka na forumu';
$string['addanewdiscussion'] = 'Dodaj novu temu za diskusiju';
$string['addanewquestion'] = 'Dodaj novo pitanje';
$string['addanewtopic'] = 'Dodaj novu temu';
$string['advancedsearch'] = 'Napredno pretraživanje';
$string['allforums'] = 'Svi forumi';
$string['allowdiscussions'] = 'Da li {$a} može slati poruke na ovaj forum?';
$string['allowsallsubscribe'] = 'Ovaj forum dozvoljava svima da odaberu da li će se pretplatiti ili ne.';
$string['allowsdiscussions'] = 'Ovaj forum dozvoljava svakoj osobi da započne jednu diskusiju';
$string['allsubscribe'] = 'Prijavite se na sve forume';
$string['allunsubscribe'] = 'Odjavite se sa svih foruma.';
$string['alreadyfirstpost'] = 'Ovo je već prva poruka u diskusiji';
$string['anyfile'] = 'Bilo koja datoteka';
$string['areaattachment'] = 'Prilozi';
$string['areapost'] = 'Poruke';
$string['attachment'] = 'Prilog';
$string['attachment_help'] = 'Poruci možete da priložite jednu ili više datoteka. Ako priložite sliku, ona će biti prikazana na kraju poruke.';
$string['attachmentnopost'] = 'Ne možete da izvezete priloge bez identifikatora poruke';
$string['attachments'] = 'Prilozi';
$string['attachmentswordcount'] = 'Prilozi i broj reči';
$string['blockafter'] = 'Granična vrednost broja poruka koja dovodi do blokiranja';
$string['blockafter_help'] = 'Ovo podešavanje određuje maksimalan broj poruka koje korisnik može da postuje na forumu i datom vremenskom periodu. Ovo ograničenje ne važi za korisnike koji imaju ovlašćenja mod/forum:postwithoutthrottling.';
$string['blockperiod'] = 'Vremenski period nakon kog se vrši blokiranje';
$string['blockperioddisabled'] = 'Ne blokirati';
$string['blockperiod_help'] = 'Moguće je ograničiti broj poruka koje polaznici mogu poslati unutar datog vremenskog perioda. Ovo ograničenje ne važi za korisnike koji imaju ovlašćenja mod/forum:postwithoutthrottling.';
$string['blogforum'] = 'Standardni forum u obliku bloga';
$string['bynameondate'] = 'napisao/la {$a->name} - {$a->date}';
$string['cannotadd'] = 'Nije moguće dodati diskusiju na ovom forumu';
$string['cannotadddiscussion'] = 'Dodavanje diskusije u okviru ovog foruma zahteva grupno članstvo.';
$string['cannotadddiscussionall'] = 'Nemate dozvolu da dodajete novu temu za diskusiju za sve učesnike.';
$string['cannotaddsubscriber'] = 'Nije bilo moguće dodati pretplatnika sa identifikatorom {$a} na ovaj forum!';
$string['cannotaddteacherforumto'] = 'Nije bilo moguće dodati instancu izmenjenog foruma predavača u sekciju 0 ovoga kursa';
$string['cannotcreatediscussion'] = 'Nije bilo moguće otvoriti novu diskusiju';
$string['cannotcreateinstanceforteacher'] = 'Nije bilo moguće krerati novu instancu modula za predavački forum';
$string['cannotdeletepost'] = 'Ne možete da obrišete ovu poruku!';
$string['cannoteditposts'] = 'Ne možete da uređujete poruke drugih korisnika!';
$string['cannotfinddiscussion'] = 'Nije bilo moguće naći diskusiju na ovom forumu';
$string['cannotfindfirstpost'] = 'Nije bilo moguće naći prvu poruku na ovom forumu';
$string['cannotfindorcreateforum'] = 'Nije bilo moguće naći ili kreirati glavni forum za novosti na ovom sajtu';
$string['cannotfindparentpost'] = 'Nije bilo moguće naći nadređenu poruku za poruku {$a}';
$string['cannotmovefromsingleforum'] = 'Nije moguće premestiti diskusiju iz foruma tipa \'jedna obična diskusija\'';
$string['cannotmovenotvisible'] = 'Forum nije vidljiv';
$string['cannotmovetonotexist'] = 'Ne možete da premestite u taj forum jer on ne postoji!';
$string['cannotmovetonotfound'] = 'Ciljni forum nije pronađen na ovom kursu.';
$string['cannotmovetosingleforum'] = 'Nije moguće premestiti diskusiju u forum tipa jedna obična diskusija';
$string['cannotpurgecachedrss'] = 'Nije bilo moguće očistiti RSS dovode iz keša za izvorni i/ili odredišni(e) forum(e) - proverite Vašu datoteku za dozvole foruma';
$string['cannotremovesubscriber'] = 'Nije bilo moguće ukloniti pretplatnika sa identifikatorom {$a} sa ovog foruma!';
$string['cannotreply'] = 'Ne možete da odgovorite na ovu poruku';
$string['cannotsplit'] = 'Diskusije sa ovog foruma ne mogu biti razdvojene';
$string['cannotsubscribe'] = 'Oprostite ali morate biti član grupe da biste se prijavili';
$string['cannottrack'] = 'Nije moguće prestati s praćenjem ovog foruma';
$string['cannotunsubscribe'] = 'Nije moguće odjaviti se sa ovog foruma';
$string['cannotupdatepost'] = 'Ne možete da ažurirate ovu poruku';
$string['cannotviewpostyet'] = 'Još uvek ne možete da čitate pitanja drugih polaznika u ovoj diskusiji jer niste poslali nijednu poruku';
$string['cannotviewusersposts'] = 'Ne postoje poruke ovog korisnika koje možete da vidite';
$string['cleanreadtime'] = 'Vreme kada se stare poruke obeležavaju kao pročitane';
$string['completiondiscussions'] = 'Polaznik mora da kreira diskusiju:';
$string['completiondiscussionsgroup'] = 'Zahtevaj diskusiju';
$string['completiondiscussionshelp'] = 'neophodno je kreiranje diskusije za završetak aktivnosti';
$string['completionposts'] = 'Polaznik mora da pošalje poruku ili odgovor:';
$string['completionpostsgroup'] = 'Obavezno slanje poruke';
$string['completionpostshelp'] = 'neophodno je slanje poruke ili odgovora za završetak aktivnosti';
$string['completionreplies'] = 'Polaznik mora da pošalje odgovor:';
$string['completionrepliesgroup'] = 'Neophodan je odgovor na poruku';
$string['completionreplieshelp'] = 'neophodan je odgovor na poruku za završetak aktivnosti';
$string['configcleanreadtime'] = 'Vreme u toku dana kada se brišu stare poruke iz tabele "pročitano".';
$string['configdigestmailtime'] = 'Korisnici koji izaberu da im se poruke sa foruma šalju elektronskom poštom u skraćenom obliku, dobijaće jednu poruku dnevno. Ovo podešavanje zadaje vreme u toku dana kada će navedena poruka biti poslata (prvi sledeći kron koji se pokrene nakon zadatog vremena će ih poslati).';
$string['configdisplaymode'] = 'Podrazumevani način prikazivanja stranice sa diskusijama ukoliko isti nije podešen.';
$string['configenablerssfeeds'] = 'Ovaj prekidač će omogućiti korišćenja RSS servisa za sve forume. Ipak, moraćete ručno da uključite RSS podršku u podešavanjima za svaki forum posebno.';
$string['configenabletimedposts'] = 'Izaberite "da" ako želite da dozvolite podešavanje perioda prikazivanja poruke prilikom otvaranja nove diskusije na forumu (eksperimentalno, pošto još uvek nije potpuno testirano).';
$string['configlongpost'] = 'Bilo koja poruka duža od ove vrednosti (izražene u karakterima, ne računajući HTML oznake) smatra se predugom. Poruke prikazane na početnoj stranici sajta, stranice kurseva u društvenom formatu, ili korisnički profili se skraćuju prirodno na dužinu koja se kreće između vrednosti za forum_shortpost i forum_longpost.';
$string['configmanydiscussions'] = 'Maksimalan broj diskusija prikazanih na forumu po stranici';
$string['configmaxattachments'] = 'Podrazumevani maksimalni broj priloga dozvoljen po jednoj poruci.';
$string['configmaxbytes'] = 'Podrazumevana maksimalna veličina priloga za sve forume na sajtu (zavisno od ograničenja kurseva i ostalih lokalnih podešavanja)';
$string['configoldpostdays'] = 'Broj dana nakon kojeg se sve stare poruke smatraju pročitanim.';
$string['configreplytouser'] = 'Kada se poruka sa foruma šalje elektronskom poštom, hoće li ona sadržati elektronsku adresu autora poruke, tako da primalac poruke može na nju da odgovori lično a ne preko foruma? Čak i kada je ova opcija podešena na "Da", korisnici mogu da, u okviru svog korisničkog profila, odaberu da njihova elektronska adresa bude sakrivena od ostalih korisnika.';
$string['configshortpost'] = 'Svaka poruka kraća od ove dužine (ne uključujući HTML oznake) se smatra kratkom (vidi ispod).';
$string['configtrackingtype'] = 'Podrazumevano podešavanje za praćenje pročitanih/nepročitanih poruka?';
$string['configtrackreadposts'] = 'Podesite na "Da" ako želite da pratite pročitane/nepročitane poruke za svakog korisnika.';
$string['configusermarksread'] = 'Ako je izabrana opcija "da" korisnik mora ručno da obeleži poruku kao pročitanu, u suprotnom (opcija "ne") onog trenutka kada je korisnik video poruku ona će biti obeležena kao pročitana.';
$string['confirmsubscribe'] = 'Da li zaista želite da se prijavite na forum \'{$a}\'?';
$string['confirmunsubscribe'] = 'Da li zaista želite da se odjavite sa foruma \'{$a}\'?';
$string['couldnotadd'] = 'Nažalost, nije moguće dodati Vašu poruku zbog nepoznate greške';
$string['couldnotdeletereplies'] = 'Žao nam je, ova poruka se ne može obrisati pošto su drugi korisnici odgovorili na nju';
$string['couldnotupdate'] = 'Vaša poruka ne može biti ažurirana zbog nepoznate greške';
$string['delete'] = 'Obriši';
$string['deleteddiscussion'] = 'Ova tema je obrisana';
$string['deletedpost'] = 'Poruka je obrisana';
$string['deletedposts'] = 'Te poruke su obrisane';
$string['deletesure'] = 'Jeste li sigurni da želite da obrišete ovu poruku?';
$string['deletesureplural'] = 'Jeste li sigurni da želite da obrišete ovu poruku i SVE odgovore na nju? ({$a} poruka)';
$string['digestmailheader'] = 'Ovo je Vaš dnevni skraćeni prikaz novih poruka sa {$a->sitename} foruma. Da bi ste promenili način na koji će Vam biti slate poruke sa foruma idite na {$a->userprefs}.';
$string['digestmailpost'] = 'Promenite Vaše preferencije vezane za rezime poruka sa foruma';
$string['digestmailprefs'] = 'Vaš korisnički profil';
$string['digestmailsubject'] = '{$a}: skraćen prikaz poruka sa foruma';
$string['digestmailtime'] = 'Vreme za slanje e-pošte sa skraćenim izveštajima';
$string['digestsentusers'] = 'Skraćen prikaz poruka sa foruma uspešno je poslat na elektronske adrese {$a} korisnika';
$string['disallowsubscribe'] = 'Učlanjivanje nije dozvoljeno';
$string['disallowsubscribeteacher'] = 'Učlanjivanje nije dozvoljeno (osim predavačima)';
$string['discussion'] = 'Diskusija';
$string['discussionmoved'] = 'Ova diskusija je premeštena na \'{$a}\'.';
$string['discussionmovedpost'] = 'Ova diskusija je premeštena <a href="{$a->discusshref}">ovde</a> u forumu <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Naziv diskusije';
$string['discussions'] = 'Diskusije';
$string['discussionsstartedby'] = 'Diskusiju započeo/la {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusije koje je korisnik {$a} započeo u skorije vreme';
$string['discussionsstartedbyuserincourse'] = 'Diskusija koju je započeo/la {$a->fullname} na kursu {$a->coursename}';
$string['discussthistopic'] = 'Diskusija o ovoj temi';
$string['displayend'] = 'Kraj prikazivanja';
$string['displayend_help'] = 'Ovo podešavanje određuje da li će poruka na forumu biti sakrivene nakon određenog datuma. Napomena: administratori uvek mogu da vide poruke na forumu.';
$string['displaymode'] = 'Način prikazivanja';
$string['displayperiod'] = 'Period prikazivanja';
$string['displaystart'] = 'Početak prikazivanja';
$string['displaystart_help'] = 'Ovo podešavanje određuje da li će poruka na forumu biti prikazana od određenog datuma. Napomena: administratori uvek mogu da vide poruke na forumu.';
$string['displaywordcount'] = 'Prikaži broj reči';
$string['displaywordcount_help'] = 'Ovo podešavanje određuje da li treba prikazati broj reči svake poruke.';
$string['eachuserforum'] = 'Svaka osoba može započeti jednu diskusiju';
$string['edit'] = 'Uredi';
$string['editedby'] = 'Uredio/la  {$a->name} - izvorno objavljeno {$a->date}';
$string['editedpostupdated'] = 'Poruka koju je postovao/la {$a} je ažurirana';
$string['editing'] = 'Uređivanje';
$string['emaildigest_0'] = 'Dobijaćete jednu elektronsku poruku po objavi.';
$string['emaildigest_1'] = 'Dobijaćete po jednu elektronsku poruku na dan koja će sadržati kompletan sadržaj objava na forumu.';
$string['emaildigest_2'] = 'Dobijaćete po jednu elektronsku poruku na dan koja će sadržati samo naslove svih objava na forumu.';
$string['emaildigestcompleteshort'] = 'Kompletne poruke';
$string['emaildigestdefault'] = 'Podrazumevano ({$a})';
$string['emaildigestoffshort'] = 'Bez rezimea';
$string['emaildigestsubjectsshort'] = 'Samo naslovi';
$string['emaildigesttype'] = 'Opcije vezane za rezime koji se šalje elektronskom poštom';
$string['emaildigesttype_help'] = 'Tip obaveštenja koji ćete dobijati sa svakog foruma.

* Podrazumevani - pratiće se preferencije postavljene u Vašem korisničkom profilu. Ako ažurirate svoj profil promene će se odraziti i na ovo podešavanje;
* Bez rezimea - dobijaćete jednu elektronsku poruku po objavi na forumu;
* Rezime - kompletne objave - dobijaćete jednu elektronsku poruku na dan koja će sadržati kompletan sadržaj svih objava na forumu;
* Rezime - samo teme - dobijaćete jednu elektronsku poruku na dan koja će sadržati samo teme svih objava na forumu.';
$string['emaildigestupdated'] = 'Opcija vezana za rezime koji se šalje elektronskom poštom je izmenjena na \'{$a->maildigesttitle}\' za forum \'{$a->forum}\'. {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'Vaše podrazumevano podešavanje u profilu za \'{$a->maildigesttitle}\' je korišćeno za forum \'{$a->forum}\'. {$a->maildigestdescription}.';
$string['emptymessage'] = 'Nešto nije u redu sa vašom porukom. Možda ste ostavili prazna polja, ili je prilog bio prevelik. Vaše promene NISU sačuvane.';
$string['erroremptymessage'] = 'Telo poruke ne može biti prazno';
$string['erroremptysubject'] = 'Tema (naslov) poruke ne može biti prazna';
$string['errorenrolmentrequired'] = 'Da biste pristupili ovom sadržaju morate biti upisani na ovaj kurs';
$string['errorwhiledelete'] = 'Došlo je do greške u toku brisanja zapisa';
$string['event_assessable_uploaded'] = 'Objavljen je neki sadržaj.';
$string['everyonecanchoose'] = 'Svi mogu odabrati žele li biti učlanjeni na ovaj forum';
$string['everyonecannowchoose'] = 'Svako može sada da izabere da li će biti pretplaćen na ovaj forum';
$string['everyoneisnowsubscribed'] = 'Svi su sada pretplaćeni na ovaj forum';
$string['everyoneissubscribed'] = 'Svi su pretplaćeni na ovaj forum';
$string['existingsubscribers'] = 'Trenutni članovi';
$string['exportdiscussion'] = 'Izvezi celu diskusiju

';
$string['forcedreadtracking'] = 'Dozvoli obavezno praćenje pročitanih/nepročitanih poruka?';
$string['forcedreadtracking_desc'] = 'Ova opcija dozvoljava da forumi budu podešeni tako da se obavezno prate pročitane/nepročitane poruke. Ovo će dovesti do smanjenja performansi sistema za neke korisnike, naročito na kursevima sa velikim brojem foruma i poruka. Kada se isključi, svi forumi, prethodno podešeni na "obavezno", biće prebačeni na opciono praćenje pročitanih/nepročitanih poruka.';
$string['forcessubscribe'] = 'Učlanjivanje na ovaj forum je obavezno za sve.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Dodaj novi forum';
$string['forum:addnews'] = 'Dodaj vest';
$string['forum:addquestion'] = 'Dodaj pitanje';
$string['forum:allowforcesubscribe'] = 'Omogući prinudnu prijavu na forum';
$string['forumauthorhidden'] = 'Autor (skriveno)';
$string['forumblockingalmosttoomanyposts'] = 'Približavate se maksimalnom mogućem broju poruka na ovom forumu. Objavili ste {$a->numposts} poruka u poslednjih {$a->blockperiod} a limit je {$a->blockafter} poruka.';
$string['forumbodyhidden'] = 'Ovu poruku ne možete da vidite, verovatno zato što: još niste učestvovali u diskusiji, još nije isteklo maksimalno dozvoljeno vreme za uređivanje poruke, diskusija još nije započeta ili zato što je diskusija istekla.';
$string['forum:createattachment'] = 'Kreiraj priloge';
$string['forum:deleteanypost'] = 'Obriši sve poruke (u bilo koje vreme)';
$string['forum:deleteownpost'] = 'Obriši svoje poruke (u zadatom roku)';
$string['forum:editanypost'] = 'Uredi bilo koju poruku';
$string['forum:exportdiscussion'] = 'Izvezi kompletnu diskusiju';
$string['forum:exportownpost'] = 'Izvezi svoju poruku';
$string['forum:exportpost'] = 'Izvezi poruku';
$string['forumintro'] = 'Opis';
$string['forum:managesubscriptions'] = 'Upravljanje članstvima';
$string['forum:movediscussions'] = 'Premesti diskusije';
$string['forumname'] = 'Naziv foruma';
$string['forumposts'] = 'Poruke na forumu';
$string['forum:postwithoutthrottling'] = 'Izuzet od ograničenja broja poruka';
$string['forum:rate'] = 'Oceni poruke';
$string['forum:replynews'] = 'Odgovori na vesti';
$string['forum:replypost'] = 'Odgovori na poruke';
$string['forums'] = 'Forumi';
$string['forum:splitdiscussions'] = 'Podeli diskusije';
$string['forum:startdiscussion'] = 'Započni nove diskusije';
$string['forumsubjecthidden'] = 'Tema (skriveno)';
$string['forumtracked'] = 'Nepročitane poruke se prate';
$string['forumtrackednot'] = 'Nepročitane poruke se ne prate';
$string['forumtype'] = 'Tip foruma';
$string['forumtype_help'] = 'Postoji 5 tipova foruma:

* Jedna obična diskusija - forum u obliku samo jedne teme o kojoj svi mogu diskutovati i slati svoje odgovore (ne može se koristiti sa odvojenim grupama)
* Svaki učesnik pokreće jednu diskusiju - svaki polaznik može pokrenuti samo jednu novu temu za diskusiju, na koju svi mogu da odgovaraju
* Forum pitanja i odgovora - polaznici moraju prvo da pošalju svoj odgovor pre nego što vide odgovore drugih
* Standarni forum u obliku bloga - otvoreni forum u kojem svako u bilo kom trenutku može započeti novu diskusiju, i u kom su teme za diskusiju prikazane na jednoj stranici sa linkom "Diskutuj o ovoj temi"
* Standardni forum za opštu upotrebu - otvoreni forum u kojem svako može započeti novu diskusiju u bilo kom trenutku';
$string['forum:viewallratings'] = 'Pogledaj sve neobrađene ocene koje su dali pojedinci';
$string['forum:viewanyrating'] = 'Pogledaj sve ocene koje je dobio bilo ko';
$string['forum:viewdiscussion'] = 'Pregled diskusija';
$string['forum:viewhiddentimedposts'] = 'Pogledaj skrivene, vremenski ograničene poruke';
$string['forum:viewqandawithoutposting'] = 'Uvek vidi poruke na forumu "Pitanja i odgovori"';
$string['forum:viewrating'] = 'Pogledajte sve ocene koje ste dobili';
$string['forum:viewsubscribers'] = 'Pregled članova';
$string['generalforum'] = 'Standardni forum za opštu upotrebu';
$string['generalforums'] = 'Opšti forumi';
$string['hiddenforumpost'] = 'Skrivena poruka na forumu';
$string['inforum'] = 'u {$a}';
$string['introblog'] = 'Poruke u ovom forumu su automatski ovde kopirane iz bloga korisnika na ovom kursu zato što ti članci bloga nisu više dostupni';
$string['intronews'] = 'Opšte novosti i najave';
$string['introsocial'] = 'Otvoreni forum za razgovor o bilo kojoj temi';
$string['introteacher'] = 'Forum rezervisan za beleške i duskusije predavača';
$string['invalidaccess'] = 'Ovoj strani nije ispravno pristupljeno';
$string['invaliddigestsetting'] = 'Podešavanje rezimea objava koje se šalju elektronskom poštom koje je dato nije validno';
$string['invaliddiscussionid'] = 'Identifikator diskusije nije bio ispravan ili više ne postoji';
$string['invalidforcesubscribe'] = 'Neispravan način obavezne pretplate';
$string['invalidforumid'] = 'ID foruma nije bio tačan';
$string['invalidparentpostid'] = 'ID nadređene poruke je neispravan';
$string['invalidpostid'] = 'Neispravan ID poruke - {$a}';
$string['lastpost'] = 'Poslednja poruka';
$string['learningforums'] = 'Forumi za učenje';
$string['longpost'] = 'Dugačka poruka';
$string['mailnow'] = 'Pošalji odmah e-poštom';
$string['manydiscussions'] = 'Broj diskusija po stranici';
$string['markalldread'] = 'Označi sve poruke ove diskusije kao pročitane.';
$string['markallread'] = 'Označi sve poruke na ovom forumu kao pročitane.';
$string['markread'] = 'Označi kao pročitano';
$string['markreadbutton'] = 'Označi kao<br /> pročitano';
$string['markunread'] = 'Označi kao nepročitano';
$string['markunreadbutton'] = 'Označi kao<br /> nepročitano';
$string['maxattachments'] = 'Maksimalan broj priloga';
$string['maxattachments_help'] = 'Ovo podešavanje određuje maksimalan broj datoteka koje mogu biti priložene uz poruku.';
$string['maxattachmentsize'] = 'Maksimalna veličina priloga';
$string['maxattachmentsize_help'] = 'Ovo podešavanje određuje maksimalnu veličinu datoteke koja može biti priložena uz poruku.';
$string['maxtimehaspassed'] = 'Nažalost, maksimalno vreme za uređivanje ove poruke ({$a}) je isteklo!';
$string['message'] = 'Poruka';
$string['messageprovider:digests'] = 'Izvodi poruka sa foruma na koje ste pretplaćeni';
$string['messageprovider:posts'] = 'Poruke sa foruma na koje ste pretplaćeni';
$string['missingsearchterms'] = 'Sledeći traženi termini se javljaju isključivo unutar HTML oznaka ove poruke:';
$string['modeflatnewestfirst'] = 'Prikaz odgovora, počevši prvo s najnovijim';
$string['modeflatoldestfirst'] = 'Prikaz odgovora, počevši prvo s najstarijim';
$string['modenested'] = 'Prikaz odgovora u ugnežđenoj formi';
$string['modethreaded'] = 'Prikaz odgovora u nizu';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Modul aktivnosti \'Forum\' omogućava učesnicima da vode asinhrone diskusije tj, da diskutuju na različite teme u dužem vremenskom periodu.

Postoji nekoliko tipova forumu koji se mogu izabrati, kao što su standardni forumu gde svako može da započne novu diskusiju u bilo kom trenutku; forum gde svaki polaznik može da pokrene samo jednu diskusiju, ili forum \'Pitanje i odgovor\' gde polaznici moraju prvo da postave svoj odgovor pre nego što bude u mogućnosti da vide odgovore drugih polaznika. Predavač može da dozvoli polaznicima da uz svoje poruke dostavljaju datoteke u prilogu. Priložene slike se prikazuju unutar same poruke.

Učesnici mogu da se prijave (pretplate) na forumu kako bi redovno primali obaveštenja o novim porukama. Predavač može da podesi režim prijave na opcioni, obavezni ili automatski, ili da potpuno spreči mogućnost prijave na forum. Ako je potrebno, moguće je, takođe, sprečiti da polaznici šalju više od određenog broja poruka, u datom vremenskom periodu; na ovaj način može se sprečiti da pojedinci dominiraju diskusijama.

Poruke na forumima mogu biti  ocenjivane kako od strane predavača, tako i od strane polaznika (vršnjačka evaluacija). Ocene mogu da se sabiraju kako bi se formirala finalna ocena koja se beleži u knjigu ocena.

Forumi mogu da se koriste na vrlo različite načine, kao npr:

* društveni prostor za međusobno upoznavanje i druženje polaznika
* za objavljivanje važnih obaveštenja na kursu (koristeći forum \'Vesti\' na koji su, standardno, svi polaznici prijavljeni)
* za diskutovanje o sadržaju odnosno temama koje kurs pokriva
* za  nastavak diskusije u onlajn okruženju, o temama koje se prethodno započete u učionici
* za diskusije namenjene samo predavačima (koristeći opciju za sakrivanje foruma od polaznika)
- kao centar za pomoć, gde polaznici mogu da dobiju pomoć i savet od strane predavača i iskusnijih polaznika
* za dodatne aktivnosti, na primer \'mozgalice\' za polaznike o kojima oni treba da razmisle i ponude rešenja';
$string['modulenameplural'] = 'Forumi';
$string['more'] = 'još';
$string['movedmarker'] = '(Premešteno)';
$string['movethisdiscussionto'] = 'Premesti ovu diskusiju u ...';
$string['mustprovidediscussionorpost'] = 'Morate navesti identifikator diskusije ili poruke da biste ih izvezli';
$string['namenews'] = 'Forum vesti';
$string['namenews_help'] = '<p>Forum vesti je specijalni forum za najave i najnovije informacije koji se automatski kreira kada se otvara novi kurs. Kurs možete imati samo jedan ovakav forum.</p>

<p>Blok "Najnovije vesti" će prikazivati najnovije diskusije sa ovog foruma (čak i ako mu promenite ime).</p>';
$string['namesocial'] = 'Društveni forum';
$string['nameteacher'] = 'Forum predavača';
$string['newforumposts'] = 'Nove poruke na forumu';
$string['noattachments'] = 'Ova poruka nema priloga';
$string['nodiscussions'] = 'Još nema tema za diskusiju na ovom forumu';
$string['nodiscussionsstartedby'] = '{$a} nije započeo/la nijednu diskusiju';
$string['nodiscussionsstartedbyyou'] = 'Još niste započeli nijednu diksusiju';
$string['noguestpost'] = 'Nažalost, gostima nije dozvoljeno slanje poruka.';
$string['noguesttracking'] = 'Nažalost, gostima nije dozvoljeno da podešavaju opcije za praćenje poruka.';
$string['nomorepostscontaining'] = 'Nema više poruka koje sadrže \'{$a}\'';
$string['nonews'] = 'Trenutno nema novosti';
$string['noonecansubscribenow'] = 'Prijave trenutno nisu moguće';
$string['nopermissiontosubscribe'] = 'Nemate dozvolu da vidite ko se prijavio na forum';
$string['nopermissiontoview'] = 'Nemate dozvolu da vidite ovu poruku';
$string['nopostforum'] = 'Oprostite, ali nije vam dozvoljeno slanje poruka na ovaj forum';
$string['noposts'] = 'Nema poruka';
$string['nopostsmadebyuser'] = '{$a} nije poslao/la nijednu poruku';
$string['nopostsmadebyyou'] = 'Niste napisali nijednu poruku';
$string['noquestions'] = 'Još nema pitanja na ovom forumu';
$string['nosubscribers'] = 'Trenutno nema prijavljenih korisnika na ovom forumu';
$string['notexists'] = 'Diskusija više ne postoji';
$string['nothingnew'] = 'Ništa novo za {$a}';
$string['notingroup'] = 'Nažalost, morate biti deo grupe da biste videli ovaj forum.';
$string['notinstalled'] = 'Modul Forum nije instaliran';
$string['notpartofdiscussion'] = 'Ova poruka nije deo diskusije';
$string['notrackforum'] = 'Ne prati nepročitane poruke';
$string['noviewdiscussionspermission'] = 'Nemate dozvolu da vidite diskusije na ovom forumu';
$string['nowallsubscribed'] = 'Prijavljeni ste na sve forume u {$a}.';
$string['nowallunsubscribed'] = 'Odjavljeni ste sa svih foruma u {$a}.';
$string['nownotsubscribed'] = '{$a->name} NEĆE primati e-poruke sa kopijama poruka s foruma \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} više ne prati poruke na forumu \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} će primati e-poruke sa kopijama poruka s foruma \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} prati poruke na forumu \'{$a->forum}\'.';
$string['numposts'] = 'Broj poruka: {$a}';
$string['olderdiscussions'] = 'Starije diskusije';
$string['oldertopics'] = 'Starije teme';
$string['oldpostdays'] = 'Broj dana nakon kojih se stare poruke smatraju pročitanim';
$string['openmode0'] = 'Nema diskusija, nema odgovora';
$string['openmode1'] = 'Nema diskusija, ali odgovori su dozvoljeni';
$string['openmode2'] = 'Diskusije i odgovori su dozvoljeni';
$string['overviewnumpostssince'] = '{$a} poruka/e od poslednje prijave na sistem';
$string['overviewnumunread'] = 'ukupno nepročitanih: {$a}';
$string['page-mod-forum-discuss'] = 'Stranica sa diskusijom modula \'Forum\'';
$string['page-mod-forum-view'] = 'Glavna stranica foruma';
$string['page-mod-forum-x'] = 'Bilo koja stranica foruma';
$string['parent'] = 'Prikaži nadređenu poruku';
$string['parentofthispost'] = 'Poruka nadređena ovoj poruci';
$string['pluginadministration'] = 'Administracija foruma';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Vaša poruka je uspešno dodata.</p> <p>Imate {$a} za promenu sadržaja iste, ukoliko to želite.</p>';
$string['postaddedsuccess'] = 'Vaša poruka je uspešno dodata.';
$string['postaddedtimeleft'] = 'Imate {$a} minuta da uredite poruku ako želite da napravite bilo kakve izmene.';
$string['postbyuser'] = '{$a->post} napisao/la {$a->user}';
$string['postincontext'] = 'Pogledaj poruku u kontekstu';
$string['postmailinfo'] = 'Ovo je kopija poruke sa foruma na Web sajtu {$a}.

Da biste odgovorili na poruku kliknite na ovaj link:';
$string['postmailnow'] = '<p>Ova poruka će biti odmah poslata svima koji su prijavljeni na ovaj forum.</p>';
$string['postrating1'] = 'Uglavnom odvojeno znanje';
$string['postrating2'] = 'Odvojeno i povezano';
$string['postrating3'] = 'Uglavnom povezano znanje';
$string['posts'] = 'Poruke';
$string['postsmadebyuser'] = 'Poruka koju je poslao/la {$a}';
$string['postsmadebyuserincourse'] = 'Poruka koju je poslao/la {$a->fullname} na kursu {$a->coursename}';
$string['posttoforum'] = 'Pošalji poruku na forum';
$string['postupdated'] = 'Vaša poruka je ažurirana';
$string['potentialsubscribers'] = 'Potencijalni članovi';
$string['processingdigest'] = 'Slanje izvoda putem e-pošte korisniku {$a}';
$string['processingpost'] = 'Obrađuje se poruka {$a}';
$string['prune'] = 'Razdvoj';
$string['prunedpost'] = 'Od ove poruke kreirana je nova diskusija';
$string['pruneheading'] = 'Razdvoj diskusiju i premesti ovu poruku u novu diskusiju';
$string['qandaforum'] = 'Forum pitanja i odgovora';
$string['qandanotify'] = 'Ovo je forum pitanja i odgovora. Da biste videli odgovore drugih na ova pitanja, morate prvo poslati svoj odgovor';
$string['re'] = 'Odgovor:';
$string['readtherest'] = 'Pročitajte ostatak ove teme';
$string['replies'] = 'Odgovori';
$string['repliesmany'] = '{$a} odgovora do sada';
$string['repliesone'] = '{$a} odgovor do sada';
$string['reply'] = 'Odgovori';
$string['replyforum'] = 'Odgovori na forumu';
$string['replytouser'] = 'Koristi adresu e-pošte u odgovoru';
$string['resetdigests'] = 'Obriši sve preferencije vezane za slanje rezimea elektronskom poštom koje su postavljene na nivou korisnika';
$string['resetforums'] = 'Obriši poruke sa';
$string['resetforumsall'] = 'Obriši sve poruke';
$string['resetsubscriptions'] = 'Obriši sve prijave na forum';
$string['resettrackprefs'] = 'Obriši sva podešavanja za praćenje foruma';
$string['rssarticles'] = 'Broj skorašnjih RSS članaka';
$string['rssarticles_help'] = 'Ovo podešavanje određuje broj članaka (diskusija ili poruka) koji će biti uključeni u RSS izvor vesti. Za većinu foruma je prihvatljivo da to bude između 5 i 20 članaka.';
$string['rsssubscriberssdiscussions'] = 'RSS izvor diskusija';
$string['rsssubscriberssposts'] = 'RSS izvor poruka';
$string['rsstype'] = 'RSS izvor za ovu aktivnost';
$string['rsstype_help'] = 'Da biste uključili RSS izvor vesti za ovu aktivnost odaberite diskusije ili poruke koje će biti uključen u ovaj izvor.';
$string['search'] = 'Pretraživanje';
$string['searchdatefrom'] = 'Poruke moraju biti svežije od';
$string['searchdateto'] = 'Poruke moraju biti starije od';
$string['searchforumintro'] = 'Molimo da unesete termine pretraživanja u jedno ili više od sledećih polja:';
$string['searchforums'] = 'Pretraži forume';
$string['searchfullwords'] = 'Ove reči treba da se pojave kao cele reči';
$string['searchnotwords'] = 'Ove reči NE treba da budu uključene';
$string['searcholderposts'] = 'Pretraži starije poruke...';
$string['searchphrase'] = 'Ova konkretna fraza se mora naći u poruci';
$string['searchresults'] = 'Rezultati pretraživanja';
$string['searchsubject'] = 'Ove reči treba da budu u temi poruke';
$string['searchuser'] = 'Ovo ime treba da odgovara imenu autora poruke';
$string['searchuserid'] = 'Moodle identifikator autora poruke';
$string['searchwhichforums'] = 'Izaberite koje forume treba pretražiti';
$string['searchwords'] = 'Ove reči se mogu pojaviti bilo gde u poruci';
$string['seeallposts'] = 'Pogledaj sve poruke ovog korisnika';
$string['shortpost'] = 'Kratka poruka';
$string['showsubscribers'] = 'Prikaži/promeni spisak trenutnih članova';
$string['singleforum'] = 'Jedna obična diskusija';
$string['smallmessage'] = '{$a->user} je poslao/la poruku na {$a->forumname}';
$string['startedby'] = 'Započeo/la';
$string['subject'] = 'Tema';
$string['subscribe'] = 'Učlanite se u ovaj forum';
$string['subscribeall'] = 'Prijavi sve korisnike na ovaj forum';
$string['subscribed'] = 'Učlanjeni';
$string['subscribeenrolledonly'] = 'Oprostite, samo korisnici upisani na neki od kurseva imaju dozvolu da se prijave da primaju poruke sa foruma e-poštom.';
$string['subscribenone'] = 'Odjavi sve korisnike sa ovog foruma';
$string['subscribers'] = 'Članovi';
$string['subscribersto'] = 'Članovi na \'{$a}\'';
$string['subscribestart'] = 'Pošaljite mi obaveštenja o novim porukama na ovom forumu';
$string['subscribestop'] = 'Ne želim da dobijam obaveštenja o novim porukama na ovom forumu';
$string['subscription'] = 'Prijava';
$string['subscriptionandtracking'] = 'Prijava i praćenje';
$string['subscriptionauto'] = 'Automatska prijava';
$string['subscriptiondisabled'] = 'Prijava je onemogućena';
$string['subscriptionforced'] = 'Obavezna prijava';
$string['subscription_help'] = 'Kada ste prijavljeni na neki forum to znači da ćete primati obaveštenja o novim porukama na forumu. Najčešće možete da izaberete da li želite da se prijavite na forum. Međutim, ponekad predavač može podesiti da prijava bude obavezna. U tom slučaju svi korisnici će primati obaveštenja.';
$string['subscriptionmode'] = 'Način prijave';
$string['subscriptionmode_help'] = 'Kada je korisnik prijavljen na forum, to znači da će dobijati obaveštenja o porukama na forumu.
Postoje 4 moguća načina za pretplatu:

* Opciona prijava - korisnici mogu da izaberu da li žele da budu pretplaćeni na forum ili ne
* Obavezna pretplata - svi korisnici su pretplaćeni i ne mogu se odjaviti
* Automatska pretplata - svi korisnici su inicijalno pretplaćeni ali, ukoliko žele, mogu da izaberu da se odjave u bilo kom trenutku
* Pretplata onemogućena - pretplata na forum nije dozvoljena

Napomena: Bilo koja promena načina pretplate će imati dejstvo samo na nove korisnike koju će se posle nje upisati na kurs, ne i na postojeće korisnike.';
$string['subscriptionoptional'] = 'Opciona prijava';
$string['subscriptions'] = 'Prijave';
$string['thisforumisthrottled'] = 'Ovaj forum ima ograničenje u broju poruka koje možete poslati u datom vremenskom periodu - trenutno je ovo ograničenje podešeno na {$a->blockafter} poruka unutar {$a->blockperiod}';
$string['timedposts'] = 'Vremenski određeni postovi';
$string['timestartenderror'] = 'Kraj prikaza ne može biti podešen na datum raniji od početka prikaza';
$string['trackforum'] = 'Prati nepročitane poruke';
$string['tracking'] = 'Prati';
$string['trackingoff'] = 'Isključeno';
$string['trackingon'] = 'Обавезно';
$string['trackingoptional'] = 'Opciono';
$string['trackingtype'] = 'Praćenje pročitanih/nepročitanih porukana';
$string['trackingtype_help'] = 'Ako je ovo podešavanje omogućeno, učesnici mogu da prate pročitane i nepročitane poruke na forumu i unutar diskusija. Postoje tri mogućnosti:

* Opciono - učesnici mogu da izaberu da li će uključiti ili isključiti praćenje pročitanih i nepročitanih poruka putem linka u bloku za administraciju
* Obavezno - praćenje je uvek uključeno, bez obzira na podešavanja korisnika. Opcija je dostupna zavisno od podešavanja administratora.
* Isključeno -  pročitane i nepročitane poruke se ne prate';
$string['unread'] = 'Nepročitano';
$string['unreadposts'] = 'Nepročitane poruke';
$string['unreadpostsnumber'] = 'Broj nepročitanih poruka: {$a}';
$string['unreadpostsone'] = '1 nepročitana poruka';
$string['unsubscribe'] = 'Odjavite se sa ovog foruma';
$string['unsubscribeall'] = 'Odjavite se sa svih foruma';
$string['unsubscribeallconfirm'] = 'Trenutno ste prijavljeni na {$a} forum(a). Da li zaista želite da se odjavite sa svih foruma i da isključite automatsku prijavu na forume?';
$string['unsubscribealldone'] = 'Sve opcione prijave na forume su poništene. Još uvek ćete primati obaveštenja sa foruma na kojima je prijava obavezna. Da biste detaljnije podesili opcije vezane za poruke koje ćete primati odaberite opciju Poruke među onima koje se nude pri podešavanju korisničkog profila.';
$string['unsubscribeallempty'] = 'Niste prijavljeni ni na jedan forum. Ako ne želite više da dobijate e-poruke sa ovog servera odaberite opciju Poruke među onima koje se nude pri podešavanju korisničkog profila.';
$string['unsubscribed'] = 'Odjavljeni ste sa ovog foruma';
$string['unsubscribeshort'] = 'Odjavi se';
$string['usermarksread'] = 'Ručno obeležavanje pročitanih poruka';
$string['viewalldiscussions'] = 'Pogledaj sve diskusije';
$string['warnafter'] = 'Granična vrednost broja poruka za slanje upozorenja';
$string['warnafter_help'] = '<p>Polaznici mogu biti upozoreni kada se približe maksimalnom broju poruka dozvonjenih u datom vremenskom periodu. Ovo podešavanje određuje nakon koliko poruka će biti upozoreni.</p>

<p>Korisnici sa ovlašćenjem mod/forum:postwithoutthrottling su izuzeti od ovog ograničenja.</p>';
$string['warnformorepost'] = 'Upozorenje! Postoji više od jedne diskusije na ovom forumu - koristite najnoviju';
$string['yournewquestion'] = 'Vaše novo pitanje';
$string['yournewtopic'] = 'Vaša nova tema za diskusiju';
$string['yourreply'] = 'Vaš odgovor';
