<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Imate zadatke na koje treba obratiti pažnju';
$string['addattempt'] = 'Dozvolite drugi pokušaj';
$string['addnewattempt'] = 'Dodaj novi pokušaj';
$string['addnewattemptfromprevious'] = 'Dodaj novi pokušaj na osnovu prethodno predatog rada';
$string['addnewattemptfromprevious_help'] = 'Ovo će kopirati sadržaj vašeg prethodnog rada u novi kako biste mogli da radite na njemu.';
$string['addnewattempt_help'] = 'Ovo će kreirati novi prazan rad kako biste mogli da radite na njemu';
$string['addsubmission'] = 'Dodaj rad';
$string['allocatedmarker'] = 'Dodeljeni ocenjivač';
$string['allocatedmarker_help'] = 'Ocenjivač koji je dodeljen za ovaj rad';
$string['allowsubmissions'] = 'Dozvoli korisniku da nastavi  predaju radova na ovaj zadatak';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Detaljnije informacije o zadatku i obrazac za predaju radova biće dostupni od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Dozvoli predaju od';
$string['allowsubmissionsfromdate_help'] = 'Ako je ova opcija omogućena polaznici neće moći da predaju rad pre ovog datuma. Ako je onemogućena, polaznici će odmah moći da predaju rad.';
$string['allowsubmissionsfromdatesummary'] = 'Ovaj zadatak će prihvatiti predaju rada od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Dozvoli promene predatog rada';
$string['alwaysshowdescription'] = 'Uvek prikaži opis';
$string['alwaysshowdescription_help'] = 'Ako je ova opcija omogućena, \'Opis zadatka\' će postati vidljiv polaznicima tek od datuma navedenog za podešavanje "Dozvoli predaju od".';
$string['applytoteam'] = 'Primenite ocene i povratne informacije na celu grupu';
$string['assign:addinstance'] = 'Dodaj novi zadatak';
$string['assign:exportownsubmission'] = 'Izvoz sopstvenog rada';
$string['assignfeedback'] = 'Dodatak za povratne informacije';
$string['assignfeedbackpluginname'] = 'Dodatak za povratne informacije';
$string['assign:grade'] = 'Ocenjivanje zadatka';
$string['assign:grantextension'] = 'Odobri produžetak';
$string['assign:manageallocations'] = 'Upravljanje ocenjivačima dodeljenim predatim radovima';
$string['assign:managegrades'] = 'Pregledaj i objavi ocene';
$string['assignmentisdue'] = 'Krajnji rok za predaju je istekao';
$string['assignmentmail'] = '{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\'

Povratne informacije su pridružene vašem radu i možete ih pogledati  na:

{$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'<i>{$a->assignment}</i>\'.</p>
<p>Povratne informacije možete pogledati pridružene vašem <a href="{$a->url}">radu</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\' . Povratne informacije možete pogledati pridružene vašem radu.';
$string['assignmentname'] = 'Naziv zadatka';
$string['assignmentplugins'] = 'Dodaci za zadatak';
$string['assignmentsperpage'] = 'Zadaci po stranici';
$string['assign:releasegrades'] = 'Objavi ocene';
$string['assign:revealidentities'] = 'Otkrij identitet studenata';
$string['assign:reviewgrades'] = 'Pregledaj ocene';
$string['assignsubmission'] = 'Dodatak za predaju rada';
$string['assignsubmissionpluginname'] = 'Dodatak za predaju rada';
$string['assign:submit'] = 'Predaj zadatak';
$string['assign:view'] = 'Pregledaj zadatak';
$string['attemptheading'] = 'Pokušaj {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Prethodni pokušaji';
$string['attemptnumber'] = 'Broj pokušaja';
$string['attemptreopenmethod'] = 'Ponovno otvaranje rada';
$string['attemptreopenmethod_help'] = 'Ovo podešavanje određuje kako se studentski radovi ponovo otvaraju. Dostupne su sledeće opcije:
 <ul>
<li>Nikad - rad studenta ne može da se otvara ponovo.</li>
<li>Ručno - predavač može ponovo da otvori rad studenta./li>
<li>Automatski dok ne dobije prelaznu ocenu - rad se automatski ponovo otvara sve dok student, za ovaj zadatak,  ne postigne prelaznu ocenu koja je podešena u knjizi ocena (sekcija kategorija i stavki).</li>
</ul>';
$string['attemptreopenmethod_manual'] = 'Ručno';
$string['attemptreopenmethod_none'] = 'Nikad';
$string['attemptreopenmethod_untilpass'] = 'Automatski dok ne dobije prelaznu ocenu';
$string['attemptsettings'] = 'Podešavanja pokušaja';
$string['availability'] = 'Dostupnost';
$string['backtoassignment'] = 'Nazad na zadatak';
$string['batchoperationconfirmaddattempt'] = 'Dozvolite još jedan pokušaj za izabrane radove?';
$string['batchoperationconfirmgrantextension'] = 'Odobriti produženje roka svim izabranim radovima?';
$string['batchoperationconfirmlock'] = 'Zaključajte sve izabrane predate radove?';
$string['batchoperationconfirmreverttodraft'] = 'Vratite izabrane radove u status nacrta?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Dodelite ocenjivača za sve izabrane predate radove?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Podesiti stanje toka ocenjivanja za sve izabrane radove?';
$string['batchoperationconfirmunlock'] = 'Odključajte sve izabrane predate radove?';
$string['batchoperationlock'] = 'zaključaj predate radove';
$string['batchoperationreverttodraft'] = 'vratite predate radove u status nacrta';
$string['batchoperationsdescription'] = 'Sa izabranima...';
$string['batchoperationunlock'] = 'otključaj predate radove';
$string['batchsetallocatedmarker'] = 'Dodeli ocenjivača za sledeći broj odabranih korisnika: {$a} .';
$string['batchsetmarkingworkflowstateforusers'] = 'Podesi stanje toka ocenjivanja za sledeći broj izabranih korisnika: {$a}.';
$string['blindmarking'] = 'Slepo ocenjivanje';
$string['blindmarking_help'] = 'Slepo ocenjivanje skriva od ocenjivača identiteta studenata. Podešavanja za slepo ocenjivanje biće zaključana onog trenutka kada rad bude predat ili kada bude ocenjen.';
$string['changegradewarning'] = 'Ovaj zadatak sadrži ocenjene predate radove pa promena ocene neće automatski ponovo izračunati postojeće ocene radova. Morate ponovo oceniti sve postojeće radove ako želite da promenite ocenu.';
$string['choosegradingaction'] = 'Akcija ocenjivanja';
$string['choosemarker'] = 'Izaberi...';
$string['chooseoperation'] = 'Izaberite operaciju';
$string['comment'] = 'Komentar';
$string['completionsubmit'] = 'Student mora da preda ovu aktivnost kako bi je završio';
$string['configshowrecentsubmissions'] = 'Svi mogu da vide obaveštenje o predatim radovima u izveštaju o skorašnjim aktivnostima.';
$string['confirmbatchgradingoperation'] = 'Da li ste sigurni da želite da {$a->operation}  za {$a->count} polaznika?';
$string['confirmsubmission'] = 'Da li ste sigurni da želite da  predate svoj rad na ocenjivanje? Više nećete moći da ga menjate.';
$string['conversionexception'] = 'Nije moguće konvertovati rad. Izuzetak je glasio: {$a}.';
$string['couldnotconvertgrade'] = 'Nije moguće konvertovati ocenu zadatka za korisnika {$a}.';
$string['couldnotconvertsubmission'] = 'Nije moguće konvertovati predati rad za korisnika {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nije moguće kreirati modul kursa';
$string['couldnotcreatenewassignmentinstance'] = 'Nije moguće kreirati novu instancu zadatka';
$string['couldnotfindassignmenttoupgrade'] = 'Nije moguće naći staru instancu zadatka za nadogradnju';
$string['currentattempt'] = 'Ovo je pokušaj {$a}.';
$string['currentattemptof'] = 'Ovo je pokušaj {$a->attemptnumber} ( {$a->maxattempts} dozvoljena/ih pokušaja ).';
$string['currentgrade'] = 'Trenutna ocena u knjizi ocena';
$string['cutoffdate'] = 'Definitivni rok';
$string['cutoffdatefromdatevalidation'] = 'Definitivni rok za predaju mora biti nakon datuma od kog je dozvoljena predaja rada.';
$string['cutoffdate_help'] = 'Ако је подешен овај датум, након њега неће бити могуће предати рад без продужетка рока за предају.';
$string['cutoffdatevalidation'] = 'Definitivni rok ne može biti pre krajnjeg roka za predaju rada.';
$string['defaultsettings'] = 'Podrazumevana podešavanja zadatka';
$string['defaultsettings_help'] = 'Ova podešavanja definišu podrazmevane vrednosti za sve nove zadatke';
$string['defaultteam'] = 'Podrazumevana grupa';
$string['deleteallsubmissions'] = 'Obriši sve predate radove';
$string['description'] = 'Opis';
$string['downloadall'] = 'Preuzmi sve predate radove';
$string['duedate'] = 'Krajnji rok';
$string['duedate_help'] = 'Ovaj datum predstavlja krajnji rok za predaju zadatka. Predaja nakon ovog datuma će i dalje biti dozvoljena, ali će svi radovi predati nakon ovog datuma biti obeleženi kao zakasneli. Da biste sprečili predaju radova nakon određenog datuma - podesite definitivni rok za predaju rada.';
$string['duedateno'] = 'Nema krajnjeg roka';
$string['duedatereached'] = 'Krajnji rok za ovaj zadatak je sada istekao';
$string['duedatevalidation'] = 'Krajnji rok mora biti nakon datuma od kojeg je dozvoljena predaja';
$string['editaction'] = 'Akcije...';
$string['editattemptfeedback'] = 'Uredi ocenu i povratne informacije za pokušaj broj {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Uređujete povratne informacije za prethodni pokušaj. Ovo je pokušaj {$a->attemptnumber} od ukupno {$a->totalattempts}.';
$string['editingstatus'] = 'Status uređivanja';
$string['editsubmission'] = 'Uredi rad';
$string['editsubmission_help'] = 'Napravite promene u svom radu';
$string['enabled'] = 'Omogućeno';
$string['errornosubmissions'] = 'Nema predatih radova za preuzimanje';
$string['errorquickgradingvsadvancedgrading'] = 'Ocene nisu sačuvane zato što ovaj zadatak trenutno koristi napredno ocenjivanje';
$string['errorrecordmodified'] = 'Ocene nisu sačuvane zato što je neko izmenio jedan ili više zapisa nakon što ste učitali stranicu';
$string['event_all_submissions_downloaded'] = 'Svi predati radovi se preuzimaju.';
$string['event_assessable_submitted'] = 'Rad je predat.';
$string['event_extension_granted'] = 'Produženje je odobreno.';
$string['event_identities_revealed'] = 'Identiteti su otkriveni.';
$string['event_marker_updated'] = 'Dodeljeni ocenjivač je ažuriran.';
$string['event_statement_accepted'] = 'Korisnik je prihvatio izjavu o predaji rada.';
$string['event_submission_duplicated'] = 'Korisnik je predao duplikat svog rada.';
$string['event_submission_graded'] = 'Predati rad je ocenjen.';
$string['event_submission_locked'] = 'Predati radovi su zaključani za korisnika.';
$string['event_submission_status_updated'] = 'Status predatog rada je ažuriran.';
$string['event_submission_unlocked'] = 'Predati radovi su otključani za korisnika.';
$string['event_submission_updated'] = 'Korisnik je sačuvao predati rad.';
$string['event_workflow_state_updated'] = 'Stanje toka ocenjivanja je ažurirano.';
$string['extensionduedate'] = 'Produženi rok';
$string['extensionnotafterduedate'] = 'Produženi rok mora biti nakon krajnjeg rok za predaju rada.';
$string['extensionnotafterfromdate'] = 'Produženi rok mora biti nakon datuma od kog je dozvoljena predaja rešenja.';
$string['feedback'] = 'Povratne informacije';
$string['feedbackavailablehtml'] = '{$a->username} je poslao/la povratne informacije na rad koji ste predali za zadatak  \'<i>{$a->assignment}</i>\'<br /><br /> Povratne informacije možete pogledati pridružene vašem <a href="{$a->url}">predatom radu</a>.';
$string['feedbackavailablesmall'] = '{$a->username} je dao/la povratne informacije za zadatak {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\'

Povratne informacije su pridružene vašem radu i možete ih pogledati  na:

{$a->url}';
$string['feedbackplugin'] = 'Dodatak za povratne informacije';
$string['feedbackpluginforgradebook'] = 'Dodatak za povratne informacije koji će prebacivati komentare u knjigu ocena';
$string['feedbackpluginforgradebook_help'] = 'Samo jedan dodatak za povratne informacije zadatka može da prebaci povratne informacije u knjigu ocena.';
$string['feedbackplugins'] = 'Dodaci za povratne informacije';
$string['feedbacksettings'] = 'Podešavanja povratnih informacija';
$string['feedbacktypes'] = 'Vrste povratnih informacija';
$string['filesubmissions'] = 'Predaja datoteka';
$string['filter'] = 'Filter';
$string['filternone'] = 'Nema filtera';
$string['filterrequiregrading'] = 'Zahteva ocenjivanje';
$string['filtersubmitted'] = 'Predato';
$string['gradeabovemaximum'] = 'Ocena mora da bude manja od ili jednaka {$a}';
$string['gradebelowzero'] = 'Ocena mora biti veća od ili jednaka nuli';
$string['gradecanbechanged'] = 'Ocena može biti promenjena';
$string['graded'] = 'Ocenjeno';
$string['gradedby'] = 'Ocenio/la';
$string['gradedon'] = 'Ocenjeno';
$string['gradelocked'] = 'Ова оцена је закључана или преписана у књизи оцена.';
$string['gradeoutof'] = 'Ocena od {$a}';
$string['gradeoutofhelp'] = 'Ocena';
$string['gradeoutofhelp_help'] = 'Ovde unesite ocenu za rad polaznika. Možete uključiti decimale.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} je ažurirao/la svoje rešenje zadatka <i>\'{$a->assignment}\' u  {$a->timeupdated}</i><br /><br />
Rešenje je <a href="{$a->url}">dostupno na veb sajtu</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} je ažurirao/la svoj rad za zadatak za zadatak {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} je ažurirao/la svoj rad za zadatak \'{$a->assignment}\' u  {$a->timeupdated}

Rad je dostupno na sledećoj adresi:

{$a->url}';
$string['gradestudent'] = 'Oceni polaznika: (id={$a->id}, ime i prezim={$a->fullname}).';
$string['gradeuser'] = 'Ocena {$a}';
$string['grading'] = 'Ocenjivanje';
$string['gradingchangessaved'] = 'Promene ocena su sačuvane';
$string['gradingmethodpreview'] = 'Kriterijumi ocenjivanja';
$string['gradingoptions'] = 'Opcije';
$string['gradingstatus'] = 'Status ocenjivanja';
$string['gradingstudent'] = 'Ocenjivanje studenta';
$string['gradingsummary'] = 'Rezime ocenjivanja';
$string['grantextension'] = 'Odobri produžetak';
$string['grantextensionforusers'] = 'Odobri produžetak za {$a} studen(a)ta';
$string['groupsubmissionsettings'] = 'Podešavanja za grupnu predaju rada';
$string['hiddenuser'] = 'Učesnik';
$string['hideshow'] = 'Sakrij/Prikaži';
$string['instructionfiles'] = 'Datoteke sa instrukcijama';
$string['invalidfloatforgrade'] = 'Nije moguće razumeti ocenu koja je data: {$a}';
$string['invalidgradeforscale'] = 'Ocena koja je data nije ispravna za tekuću skalu';
$string['lastmodifiedgrade'] = 'Poslednje izmene (ocena)';
$string['lastmodifiedsubmission'] = 'Poslednje izmene (predati rad)';
$string['latesubmissions'] = 'Kasno predati radovi';
$string['latesubmissionsaccepted'] = 'Samo student/i kojima je dat dodatni rok mogu da predaju rad';
$string['locksubmissionforstudent'] = 'Spreči dalju predaju radova za polaznika: (id={$a->id}, fime i prezime={$a->fullname}).';
$string['locksubmissions'] = 'Zaključaj predate radove';
$string['manageassignfeedbackplugins'] = 'Upravljanje dodacima za povratne informacije';
$string['manageassignsubmissionplugins'] = 'Upravljanje dodacima za predaju radova';
$string['marker'] = 'Ocenjivač';
$string['markerfilter'] = 'Filter ocenjivača';
$string['markingallocation'] = 'Koristi raspodelu ocenjivanja';
$string['markingallocation_help'] = 'Ako je ovo podešavanje omogućeno, zajedno sa tokom ocenjivanja, ocenjivačima mogu biti dodeljeni  pojedini studenti.';
$string['markingworkflow'] = 'Koristi tok ocenjivanja';
$string['markingworkflow_help'] = 'Ako je ovo podešavanje omogućeno, ocene će proći kroz niz faza u procesu ocenjivanja pre nego što budu objavljene studentima. Ovo omogućava više krugova ocenjivanja, kao i da ocene budu objavljene studentima istovremeno.';
$string['markingworkflowstate'] = 'Stanje toka ocenjivanja';
$string['markingworkflowstate_help'] = 'Moguća stanja  toka ocenjivanja mogu da obuhvate (zavisno od vaših ovlašćenja):

* Neocenjeno - ocenjivač još nije započeo ocenjivanje
* Ocenjuje se - ocenjivač je započeo ocenjivanje ali ga još nije završio
* Ocenjivanje završeno . ocenjivač je završio ocenjivanje,  ali je možda potrebno da se vrati zbog provere/ispravki
* Na pregledu - ocenjivanje je sada kod nadležnog nastavnika odgovornog za proveru kvaliteta
* Spremno za objavljivanje - nadležni nastavnik je zadovoljan sa ocenjivanjem ali čeka pre nego što studentima dozvoli pristup ocenama
* Objavljeno - studenti mogu da pristupe ocenama/povratnim informacijama';
$string['markingworkflowstateinmarking'] = 'Ocenjuje se';
$string['markingworkflowstateinreview'] = 'Na pregledu';
$string['markingworkflowstatenotmarked'] = 'Nije ocenjeno';
$string['markingworkflowstatereadyforrelease'] = 'Spremno za objavu';
$string['markingworkflowstatereadyforreview'] = 'Ocenjivanje završeno';
$string['markingworkflowstatereleased'] = 'Objavljeno';
$string['maxattempts'] = 'Maksimalan broj pokušaja';
$string['maxattempts_help'] = 'Maksimalan broj dozvoljenih pokušaja predaje rada od strane studenta. Nakon ovog broja pokušaja studentov rad više neće moći da se ponovo otvori.';
$string['maxgrade'] = 'Maksimalna ocena';
$string['messageprovider:assign_notification'] = 'Obaveštenje o zadatku';
$string['modulename'] = 'Zadatak';
$string['modulename_help'] = 'Modul aktivnosti "Zadatak"  pruža mogućnost nastavniku da polaznicima  zadaje zadatke, prikuplja njihove radove, ocenjuje ih, kao i da im  šalje povratne informacije.

Polaznici, kao svoj rad, mogu da predaju različite digitalne sadržaje (datoteke), kao što su tekstualni dokumenti, proračunske tabele, slike, prezentacije ili audio i video klipovi. Alternativno, ili kao dodatak prethodnom, zadatak može da traži od polaznika da tekst unesu direktno u tekst editor. Zadatak, takođe, može da se koristi kao podsetnik polaznicima za „stvarni“ zadatak koji moraju da urade „oflajn“, van sajta, poput  recimo nekog umetničkog rada, crteža itd, a da se pri tome od njih ne zahteva slanje bilo kakvog digitalnog sadržaja. Polaznici mogu da predaju rad individualno ili kao članovi grupe.

Prilikom pregledanja zadataka, nastavnici mogu da ostavljaju komentare, povratne informacije i postavljaju datoteke, kao što su pregledani i  obeleženi radovi polaznika sa komentarima, zasebni dokumenati sa komentarima ili povratne informacije u govornom tj. audio formatu. Zadaci se ocenjuje brojčanom,  ili namenski prilagođenom, skalom za ocenjivanje, ili, korišćenjem naprednih metoda ocenjivanja kao što su rubrike. Završne ocene se zapisuju u knjigu ocena.';
$string['modulenameplural'] = 'Zadaci';
$string['moreusers'] = 'još {$a}...';
$string['mysubmission'] = 'Moji predati radovi';
$string['newsubmissions'] = 'Zadaci su predati';
$string['noattempt'] = 'Nema pokušaja';
$string['nofiles'] = 'Nema datoteka';
$string['nograde'] = 'Nema ocene';
$string['nolatesubmissions'] = 'Ne prihvata se zakasnela preda radova.';
$string['nomoresubmissionsaccepted'] = 'Zakasnela predaja radova se više ne prihvata';
$string['noonlinesubmissions'] = 'Ovaj zadatak ne traži od vas da bilo šta predate  onlajn';
$string['nosavebutnext'] = 'Sledeći';
$string['nosubmission'] = 'Za ovaj zadatak još ništa nije predato';
$string['nosubmissionsacceptedafter'] = 'Rešenja se ne prihvataju posle';
$string['notgraded'] = 'Nije ocenjeno';
$string['notgradedyet'] = 'Još nije ocenjeno';
$string['notifications'] = 'Obaveštenja';
$string['notsubmittedyet'] = 'Još nije predato';
$string['nousersselected'] = 'Nije izabran nijedan polaznik';
$string['numberofdraftsubmissions'] = 'Nacrti';
$string['numberofparticipants'] = 'Učesnici';
$string['numberofsubmissionsneedgrading'] = 'Traži ocenjivanje';
$string['numberofsubmittedassignments'] = 'Predato';
$string['numberofteams'] = 'Grupe';
$string['offline'] = 'Ne traži se onlajn predaja rada';
$string['open'] = 'Otvoreno';
$string['outlinegrade'] = 'Ocena: {$a}';
$string['outof'] = '{$a->current} od {$a->total}';
$string['overdue'] = '<font color="red">Krajnji rok za predaju rada je istekao pre: {$a}</font>';
$string['page-mod-assign-view'] = 'Glavna stranica modula \'Zadatak\'';
$string['page-mod-assign-x'] = 'Bilo koja stranica modula \'Zadatak\'';
$string['participant'] = 'Učesnik';
$string['pluginadministration'] = 'Administracija zadataka';
$string['pluginname'] = 'Zadatak';
$string['preventsubmissions'] = 'Spreči korisnika da više ne predaje svoje radove za ovaj zadatak.';
$string['preventsubmissionsshort'] = 'Spreči izmene predatih radova';
$string['previous'] = 'Prethodni';
$string['quickgrading'] = 'Brzo ocenjivanja';
$string['quickgradingchangessaved'] = 'Promene ocena su sačuvane';
$string['quickgrading_help'] = 'Brzo ocenjivanje vam dozvoljava da dodelite ocene (i ishode) direktno u tabeli predatih zadataka. Brzo ocenjivanje nije kompatibilno sa naprednim ocenjivanjem i ne preporučuje se kada postoji više ocenjivača.';
$string['quickgradingresult'] = 'Brzo ocenjivanje';
$string['recordid'] = 'Indetifikator';
$string['requireallteammemberssubmit'] = 'Neophodna je predaja rada od strane svih članova grupe';
$string['requireallteammemberssubmit_help'] = 'Ako je ova opcija omogućena svi članovi studentske grupe će morati da kliknu na dugme \'Predaj\' za ovaj zadatak, pre nego što grupni rad bude mogao da se smatra predatim. Ako je opcija onemogućena, grupni rad će se smatrati predatim onog momenta kada bilo ko od članova grupe klikne na dugme \'Predaj\'.';
$string['requiresubmissionstatement'] = 'Zahtevaj da studenti prihvate izjavu o predaji rada';
$string['requiresubmissionstatement_help'] = 'Zahtevaj da studenti prihvate izjavu o predaji rada za sve predate radove za ovaj zadatak.';
$string['revealidentities'] = 'Otkrij identitet studenata';
$string['revealidentitiesconfirm'] = 'Da li ste sigurni da želite da otkrijete identitet studenata za ovaj zadatak? Ova operacija ne može biti poništena, Jednom kada se identitet studenata otkrije ocene će biti objavljene u knjizi ocena.';
$string['reverttodraft'] = 'Vrati rad u status nacrta';
$string['reverttodraftforstudent'] = 'Vrati rad u status nacrta za polaznika: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['reverttodraftshort'] = 'Vrati rad u status nacrta';
$string['reviewed'] = 'Pregledano';
$string['saveallquickgradingchanges'] = 'Sačuvaj sve promene brzog ocenjivanja';
$string['savechanges'] = 'Sačuvaj promene';
$string['savegradingresult'] = 'Ocena';
$string['savenext'] = 'Sačuvaj i prikaži sledeći';
$string['scale'] = 'Skala';
$string['selectedusers'] = 'Odabrani korisnici';
$string['selectlink'] = 'Izaberi...';
$string['selectuser'] = 'Izaberi {$a}';
$string['sendlatenotifications'] = 'Obavesti ocenjivače o radovima koji su predati sa zakašnjenjem';
$string['sendlatenotifications_help'] = 'Ako je ova opcija omogućena, ocenjivači (obično predavači) će dobiti poruku kad god polaznik rad preda sa zakašnjenjem. Način slanja poruke se može podesiti.';
$string['sendnotifications'] = 'Obavesti ocenjivače o predatim radovima';
$string['sendnotifications_help'] = 'Ako je ova opcija omogućena, ocenjivači (obično predavači) će dobiti poruku kad god polaznik rad preda ranije, na vreme i sa zakašnjenjem. Način slanja poruke se može podesiti.';
$string['sendstudentnotifications'] = 'Obavesti studente';
$string['sendstudentnotifications_help'] = 'Ako je ova opcija omogućena studenti će primati poruku o ažuriranoj ocene ili povratnim informacijama.';
$string['sendsubmissionreceipts'] = 'Pošalji polaznicima potvrdu o predatom radu';
$string['sendsubmissionreceipts_help'] = 'Ovo omogućava slanje potvrdu o predatom radu. Polaznici će primiti obaveštenje svaki put kada uspešno predaju rad.';
$string['setmarkerallocationforlog'] = 'Podesi dodelu ocenjivanja : (id={$a->id}, ima i prezime={$a->fullname}, ocenjivač={$a->marker}).';
$string['setmarkingallocation'] = 'Podesi dodeljenog ocenjivača';
$string['setmarkingworkflowstate'] = 'Podesi stanje toka ocenjivanja';
$string['setmarkingworkflowstateforlog'] = 'Podesi stanje toka ocenjivanja : (id={$a->id}, ime i prezime={$a->fullname}, stanje={$a->state}).';
$string['settings'] = 'Podešavanja zadatka';
$string['showrecentsubmissions'] = 'Prikaži skoro predate radove';
$string['status'] = 'Status';
$string['submission'] = 'Predati rad';
$string['submissioncopiedhtml'] = '<p>Napravili ste kopiju svog prethodnog rada za zadatak \'<i>{$a->assignment}</i>\'.</p>
<p>Možete videti status svog <a href="{$a->url}">predatog rada</a>.</p>';
$string['submissioncopiedsmall'] = 'Kopirali ste svoj prethodni rad za zadatak {$a->assignment}';
$string['submissioncopiedtext'] = 'Napravili ste kopiju svog prethodnog rada za zadatak \'{$a->assignment}\'

Možete videti status svog predatog rada:

    {$a->url}';
$string['submissiondrafts'] = 'Zahtevaj da polaznici kliknu na dugme "Predaj\'';
$string['submissiondrafts_help'] = 'Ako je ova opcija omogućena polaznici će morati da kliknu na dugme \'Predaj\' kako bi svoj rad proglasili konačnim. Ovo omogućava polaznicima da unutar sistema čuvaju verziju nacrta svog rada. Ako se ovo podešavanje sa "Ne" promeni na "Da" nakon što su polaznici predali svoje radove te verzije njihovih radove će biti smatrane konačnim.';
$string['submissioneditable'] = 'Studenti mogu da uređuju ovaj zadatak';
$string['submissionempty'] = 'Ništa nije predato';
$string['submissionnotcopiedinvalidstatus'] = 'Rad nije kopiran zato što je promenjen od momenta kada je ponovo otvoren.';
$string['submissionnoteditable'] = 'Studenti ne mogu da uređuju ovaj zadatak';
$string['submissionnotready'] = 'Ovaj zadatak nije spreman za predaju radova:';
$string['submissionplugins'] = 'Dodaci za predaju radova';
$string['submissionreceipthtml'] = '<p>Predali ste svoj rad za zadatak \'<i>{$a->assignment}</i>\' </p>
<p>Možete videti status svog <a href="{$a->url}">predatog rada</a>.</p>';
$string['submissionreceipts'] = 'Pošalji potvrdu o predatom radu';
$string['submissionreceiptsmall'] = 'Predali ste svoj rad za zadatak {$a->assignment}';
$string['submissionreceipttext'] = 'Predali ste svoj rad za zadatak \'{$a->assignment}</i>\'

Možete videti status svog rada na sledećoj adresi:

   {$a->url}';
$string['submissions'] = 'Predati radovi';
$string['submissionsclosed'] = 'Predaja radova je zatvorena';
$string['submissionsettings'] = 'Podešavanja za predaju rada';
$string['submissionslocked'] = 'Ovaj zadatak ne prihvata predaju radova';
$string['submissionslockedshort'] = 'Promene predatih radova nisu dozvoljeno';
$string['submissionsnotgraded'] = 'Neocenjeni radovi: {$a}';
$string['submissionstatement'] = 'Izjava o predaji rada';
$string['submissionstatementacceptedlog'] = 'Korisnik {$a} je prihvatio/la izjavu o predaji rada';
$string['submissionstatementdefault'] = 'Ovaj rad je isključivo moj, osim segmenata u kojima je eksplicitno naglašeno da su korišćeni rezultati drugih ljudi.';
$string['submissionstatement_help'] = 'Potvrdna izjava o predaji rada';
$string['submissionstatus'] = 'Status predatog rada';
$string['submissionstatus_'] = 'Nema predatih radova';
$string['submissionstatus_draft'] = 'Nacrt rada (nije predato)';
$string['submissionstatusheading'] = 'Status predatog rada';
$string['submissionstatus_marked'] = 'Ocenjeno';
$string['submissionstatus_new'] = 'Novi predati rad';
$string['submissionstatus_reopened'] = 'Ponovo otvoreno';
$string['submissionstatus_submitted'] = 'Predato za ocenjivanje';
$string['submissionsummary'] = '{$a->status}. Poslednji put promenjeno {$a->timemodified}';
$string['submissionteam'] = 'Grupa';
$string['submissiontypes'] = 'Vrsta predatog rada';
$string['submitaction'] = 'Predaj';
$string['submitassignment'] = 'Predaj zadatak';
$string['submitassignment_help'] = 'Onog trenutka kada predate ovaj rad više nećete moći da ga menjate.';
$string['submitted'] = 'Predato';
$string['submittedearly'] = 'Zadatak je predat {$a} ranije';
$string['submittedlate'] = 'Zadatak je predat {$a} kasnije';
$string['submittedlateshort'] = '{$a} kasnije';
$string['subplugintype_assignfeedback'] = 'Dodatak za povratne informacije';
$string['subplugintype_assignfeedback_plural'] = 'Dodaci za povratne informacija';
$string['subplugintype_assignsubmission'] = 'Dodatak za predaju rada';
$string['subplugintype_assignsubmission_plural'] = 'Dodaci za predaju rada';
$string['teamsubmission'] = 'Studenti predaju radove u grupama';
$string['teamsubmissiongroupingid'] = 'Grupisanje za studentske grupe';
$string['teamsubmissiongroupingid_help'] = 'Ovo je grupisanje koje će Zadatak koristiti kako bi pronašao grupe za studentske grupe. Ukoliko nije podešeno koristiće se podrazumevani skup grupa.';
$string['teamsubmission_help'] = 'Ako je ova opcija omogućena studenti će biti podeljeni u grupe na osnovu podrazumevanog skupa grupa ili namenski prilagođenog grupisanja. Grupni rad će biti deljen između članova grupe i svi članovi grupe će videti promene u radu koje budu uneli drugi članovi grupe.';
$string['teamsubmissionstatus'] = 'Status grupnih radova';
$string['textinstructions'] = 'Uputstva za zadatak';
$string['timemodified'] = 'Poslednje izmene';
$string['timeremaining'] = 'Preostalo vreme';
$string['unlimitedattempts'] = 'Neograničeno';
$string['unlimitedattemptsallowed'] = 'Neograničen broj pokušaja';
$string['unlocksubmissionforstudent'] = 'Dozvoli predaju radova za polaznika: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['unlocksubmissions'] = 'Otključaj predate radove';
$string['updategrade'] = 'Ažuriraj ocenu';
$string['updatetable'] = 'Sačuvaj i ažuriraj tabelu';
$string['upgradenotimplemented'] = 'Nadogradnja nije implementirana u dodatku ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Produžetak je odobren do: {$a}';
$string['usergrade'] = 'Vodič za korisnike';
$string['userswhoneedtosubmit'] = 'Korisnici koji treba da predaju rešenje: {$a}';
$string['validmarkingworkflowstates'] = 'Ispravna stanja toka ocenjivanja';
$string['viewbatchmarkingallocation'] = 'Pogledaj stranicu za grupnu dodelu ocenjivača.';
$string['viewbatchsetmarkingworkflowstate'] = 'Pogledaj stranicu za grupno podešavanje toka ocenjivanja.';
$string['viewfeedback'] = 'Pogledajte povratne informacije';
$string['viewfeedbackforuser'] = 'Pogledajte povratne informacije za korisnika {$a}';
$string['viewfull'] = 'Prikaži sve';
$string['viewfullgradingpage'] = 'Otvorite stranicu za ocenjivanje u punom formatu kako biste dali povratne informacije';
$string['viewgradebook'] = 'Pogledaj knjigu ocena';
$string['viewgrading'] = 'Pogledaj/oceni sve predate radove';
$string['viewgradingformforstudent'] = 'Pogledajte stranicu za ocenjivanje za  polaznika: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Pogledajte stranicu za predaju sopstvenog rada';
$string['viewownsubmissionstatus'] = 'Pogledajte stranicu statusa sopstvenog rada';
$string['viewrevealidentitiesconfirm'] = 'Pogledaj stranicu sa potvrdom za otkrivanje identiteta studenata';
$string['viewsubmission'] = 'Pogledaj predati rad';
$string['viewsubmissionforuser'] = 'Pogledaj predati rad za korisnika: {$a}';
$string['viewsubmissiongradingtable'] = 'Pogledaj tabelu za ocenjivanje predatih radova';
$string['viewsummary'] = 'Prikaži sažetak';
$string['workflowfilter'] = 'Filter toka ocenjivanja';
