<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Kontrola pristupa';
$string['actionaftercorrectanswer'] = 'Nastavi nakon potvrdnog odgovora';
$string['actionaftercorrectanswer_help'] = 'Nakon tačnog odgovora na pitanje postoje 3 mogućnosti za prelazak na narednu stranicu: * Normalan - slijedi tok lekcije * Prikaži neprikazanu stranicu - stranice se prikazuju nasumično s tim da se svaka stranica prikazuje samo jedanput * Prikaži neodgovorenu stranicu - stranice se prikazuju nasumično s tim da se stranice sa pitanjima na koja nije odgovoreno ponavljaju';
$string['actions'] = 'Akcije';
$string['activitylink'] = 'Link do aktivnosti';
$string['activitylink_help'] = 'Ukoliko želite da na kraju lekcije prikažete link ka drugoj aktivnosti na kursu, izaberite aktivnost iz padajuće liste.';
$string['activitylinkname'] = 'Idi na {$a}';
$string['activityoverview'] = 'Imate časove koji su dospjeli';
$string['addabranchtable'] = 'Dodajte naslov dijela';
$string['addanendofbranch'] = 'Dodajte kraj dijela';
$string['addanewpage'] = 'Dodaj novu stranicu';
$string['addaquestionpage'] = 'Dodaj stranicu sa pitanjima';
$string['addaquestionpagehere'] = 'Dodaj ovdje stranicu sa pitanjem';
$string['addbranchtable'] = 'Dodaj stranicu sa sadržajem/grananjem';
$string['addcluster'] = 'Dodajte grupu';
$string['addedabranchtable'] = 'Dodana je stranica sa sadržajem/grananjem';
$string['addedanendofbranch'] = 'Dodan je kraj grane';
$string['addedaquestionpage'] = 'Dodana je stranica sa pitanjem';
$string['addedcluster'] = 'Dodana je grupa pitanja';
$string['addedendofcluster'] = 'Dodan je kraj grupe pitanja';
$string['addendofcluster'] = 'Dodajte kraj za grupu';
$string['addpage'] = 'Dodaj stranicu';
$string['anchortitle'] = 'Početak glavnog sadržaja';
$string['and'] = 'i';
$string['answer'] = 'Odgovor';
$string['answeredcorrectly'] = 'odgovori tačno.';
$string['answersfornumerical'] = 'Odgovori za numerička pitanja treba da budu uklopljeni parovi minimalnih i maksimalnih vrijednosti';
$string['arrangebuttonshorizontally'] = 'Poredaj dugmiće sadržaja horizontalno?';
$string['attempt'] = 'Pokušaj: {$a}';
$string['attempts'] = 'Pokušaji';
$string['attemptsdeleted'] = 'Izbrisani pokušaji';
$string['attemptsremaining'] = 'Ostalo Vam je još {$a} pokušaj/a';
$string['available'] = 'Dostupni iz';
$string['averagescore'] = 'Prosječan broj bodova';
$string['averagetime'] = 'Prosječno vrijeme';
$string['branch'] = 'Sadržaj sa grananjem';
$string['branchtable'] = 'Naslov dijela';
$string['cancel'] = 'Obustavi';
$string['cannotfindanswer'] = 'Greška: nije moguće naći odgovor';
$string['cannotfindattempt'] = 'Greška: nije moguće naći pokušaj';
$string['cannotfindessay'] = 'Greška: nije moguće naći esej';
$string['cannotfindfirstgrade'] = 'Greška: nije moguće naći ocjene';
$string['cannotfindfirstpage'] = 'Nije moguće naći prvu stranicu';
$string['cannotfindgrade'] = 'Nije moguće naći ocjene';
$string['cannotfindnewestgrade'] = 'Greška: nije moguće naći najnoviju ocjenu';
$string['cannotfindnextpage'] = 'Rezervna kopija lekcije: Sljedeća strana nije pronađena!';
$string['cannotfindpagerecord'] = 'Dodaj kraj grane: zapis o stranici nije pronađen';
$string['cannotfindpages'] = 'Nije moguće naći stranice lekcije';
$string['cannotfindpagetitle'] = 'Potvrda brisanja: naslov stranice nije pronađen';
$string['cannotfindpreattempt'] = 'Zapis o prethodnom pokušaju nije pronađen!';
$string['cannotfindrecords'] = 'Greška: nije moguće pronaći zapise lekcija';
$string['cannotfindtimer'] = 'Greška: nije moguće naći zapise iz tabele lesson_timer';
$string['cannotfinduser'] = 'Greška: nije moguće naći korisnike';
$string['canretake'] = '{$a} može ponovno uzeti';
$string['casesensitive'] = 'Mala slova';
$string['casesensitive_help'] = 'Označite polje za potvrdu ako želite da koristite regularne izraze za analizu odgovora';
$string['checkbranchtable'] = 'Provjera stranice sa sadržajem i grananjem';
$string['checkedthisone'] = 'Potvrdi ovo.';
$string['checknavigation'] = 'Provjeri navigaciju';
$string['checkquestion'] = 'Provjeri pitanje';
$string['classstats'] = 'Statistike učenja';
$string['clicktodownload'] = 'Kliknite na sljedeći link da biste preuzeli datoteku.';
$string['clicktopost'] = 'Kliknite ovdje da pošaljete svoju ocjenu na listu najboljih rezultata.';
$string['cluster'] = 'Grupa pitanja';
$string['clusterjump'] = 'Ne vidjeti pitanje unutar grupe';
$string['clustertitle'] = 'Grupa';
$string['collapsed'] = 'Skupljeno';
$string['comments'] = 'Vaš komentar';
$string['completed'] = 'Kompletirano';
$string['completederror'] = 'Završite lekciju';
$string['completethefollowingconditions'] = 'Morate da ispunite sljedeće uslove u lekciji <b>{$a}</b> da biste mogli da nastavite.';
$string['conditionsfordependency'] = 'Uslovi zavisnosti';
$string['configactionaftercorrectanswer'] = 'Zadana akcija koja će se izvršiti nakon tačnog odgovora';
$string['configmaxanswers'] = 'Zadani maksimalan broj odgovora po stranici';
$string['configmaxhighscores'] = 'Broj prikazanih najboljih rezultata';
$string['configmediaclose'] = 'Prikaži dugme za zatvaranje na pop-up prozoru koji sadrži link ka multimedijalnoj datoteci';
$string['configmediaheight'] = 'Određuje visinu pop-up prozora koji prikazuje link ka multimedijalnoj datoteci';
$string['configmediawidth'] = 'Određuje širinu pop-up prozora koji prikazuje link ka multimedijalnoj datoteci';
$string['configslideshowbgcolor'] = 'Boja pozadine za slideshow ukoliko je uključen';
$string['configslideshowheight'] = 'Određuje visinu za slideshow ukoliko je omogućen';
$string['configslideshowwidth'] = 'Određuje širinu za slideshow ukoliko je omogućen';
$string['confirmdelete'] = 'Izbriši stranicu';
$string['confirmdeletionofthispage'] = 'Potvrditi brisanje na stranici';
$string['congratulations'] = 'Svaka čast! Stigli ste do kraja lekcije.';
$string['continue'] = 'Nastavi';
$string['continuetoanswer'] = 'Nastavite da biste promijenili odgovore.';
$string['continuetonextpage'] = 'Idite na sljedeću stranicu';
$string['correctanswerjump'] = 'Preskoči tačan odgovor';
$string['correctanswerscore'] = 'Broj dobijenih bodova tačanih odgovora';
$string['correctresponse'] = 'Tačno odgovaranje';
$string['createaquestionpage'] = 'Kreiraj stranicu pitanja';
$string['credit'] = 'Bodovi';
$string['customscoring'] = 'Prilagođen broj dobijenih bodova';
$string['customscoring_help'] = 'Ako je ova opcija omogućena onda se svakom odgovoru može dodijeliti numerička vrijednost (pozitivna ili negativna)';
$string['deadline'] = 'Krajnji rok';
$string['defaultessayresponse'] = 'Vaš esej će pregledati predavač zadužen za ovaj kurs.';
$string['deleteallattempts'] = 'Izbriši sve pokušaje prolaska kroz lekciju';
$string['deletedefaults'] = 'Obrisano {$a} x zadano za lekciju';
$string['deletedpage'] = 'Stranica je izbrisana';
$string['deleting'] = 'Brisanje';
$string['deletingpage'] = 'Brisanje stranice: {$a}';
$string['dependencyon'] = 'Zavisno od';
$string['dependencyon_help'] = 'Ovo podešavanje dopušta da pristup ovoj lekciji zavisi od rezultata studenta u drugoj lekciji istog kursa. Može se koristiti bilo koja kombinacija sljedećih uslova: utrošenog vremena (vrijeme koje je student potrošio da bi uradio lekciju), završenosti (da li je student završio navedenu lekciju) i dobijene ocjene (da li je student dobio ocjenu veću od navedene).';
$string['description'] = 'Opis';
$string['detailedstats'] = 'Detaljna statistika';
$string['didnotanswerquestion'] = 'Niste odgovorili na ovo pitanje.';
$string['didnotreceivecredit'] = 'Niste dobili kredit';
$string['displaydefaultfeedback'] = 'Prikaz zadanih povratnih informacija';
$string['displaydefaultfeedback_help'] = 'Ako je ova opcija omogućena, onda će, u situaciji kada za neko pitanje ne postoji povratna informacija, biti prikazana zadana povratna informacija: "Tačan odgovor" odnosno "Pogrešan odgovor"';
$string['displayhighscores'] = 'Prikaži visoki broj dobijenih bodova';
$string['displayinleftmenu'] = 'Prikaz u meniju sa lijeve strane?';
$string['displayleftif'] = 'Prikaži meni sa lijeve strane samo ako je ocjena veća od';
$string['displayleftif_help'] = 'Ovo podešavanje određuje da li student mora da dobije određenu ocjenu kako bi vidio meni sa lijeve strane. Ovo podešavanje tjera studenta da prođe kroz cijelu lekciju prilikom prvog pokušaja. Tek nakon što student dobije potrebnu ocjenu može da koristi meni sa lijeve strane za pregled lekcije.';
$string['displayleftmenu'] = 'Prikaz menija sa lijeve strane';
$string['displayleftmenu_help'] = 'Ako je ova opcija omogućena, biće prikazan spisak stranica lekcije.';
$string['displayofgrade'] = 'Prikaz ocjena (samo za studente)';
$string['displayreview'] = 'Obezbijedite mogućnost za ponovni pokušaj';
$string['displayreview_help'] = 'Ako je ova opcija omogućena, u situaciji kada student pogrešno odgovori na pitanje, biće mu ponuđeno da pokuša ponovo da odgovori (bez mogućnosti da dobije poen) ili da nastavi sa lekcijom.';
$string['displayscorewithessays'] = 'Osvojili ste {$a->score} od maksimalnih {$a->tempmaxgrade} bodova za pitanja koja se automatski ocjenjuju.<br />Vaš {$a->essayquestions} odgovor na pitanja u formi eseja biće uskoro pregledan i ocijenjen a ocjena će biti dodana<br />dinalnom rezultatu.<br /><br />Vaša trenutna ocjena (bez eseja) je {$a->score} od {$a->grade}';
$string['displayscorewithoutessays'] = 'Vaš broj dobijenih bodova je {$a->score} (Van {$a->grade}).';
$string['edit'] = 'Uredi';
$string['editingquestionpage'] = 'Uređivanje {$a} stranice pitanja';
$string['editlessonsettings'] = 'Promijenite podešavanja ovih lekcija';
$string['editpage'] = 'Uredi sadržaj stranice';
$string['editpagecontent'] = 'Promijenite sadržinu ovih stranica';
$string['email'] = 'E-mail';
$string['emailallgradedessays'] = 'Pošalji SVE ocijenjene eseje';
$string['emailgradedessays'] = 'Pošalji ocijenjene eseje e-poštom';
$string['emailsuccess'] = 'E-mail poruka je uspješno poslana';
$string['emptypassword'] = 'Polje za lozinku ne može biti prazno';
$string['endofbranch'] = 'Kraj dijela';
$string['endofcluster'] = 'Kraj grupe pitanja';
$string['endofclustertitle'] = 'Kraj grupe';
$string['endoflesson'] = 'Kraj lekcije';
$string['enteredthis'] = 'je odabralo/unijelo ovaj odgovor';
$string['entername'] = 'Potvrdi nadimak za visoku listu broja osvojenih bodova';
$string['enterpassword'] = 'Molimo unesite šifru:';
$string['eolstudentoutoftime'] = 'Upozorenje: Isteklo Vam je vrijeme za ovu lekciju. Vaš posljednji odgovor možda nije uračunat ako je dat nakon isteka vremena.';
$string['eolstudentoutoftimenoanswers'] = 'Niste odgovorili ni na jedno pitanje. Vaša ocjena za ovu lekciju je 0.';
$string['essay'] = 'Lagan';
$string['essayemailmessage'] = '<p>Esej:<blockquote>{$a->question}</blockquote></p><p>Vaš odgovor:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentar predavača ({$a->teacher}\'s):<blockquote><em>{$a->comment}</em></blockquote></p><p>Dobili ste ocjenu {$a->earned} od maksimalno {$a->outof} za ovaj esej.</p><p>Vaša ocjena za ovu lekciju je promijenjena na {$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p>Esej:<blockquote>{$a->question}</blockquote></p><p>Vaš odgovor:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentrar ocjenjivača:<blockquote><em>{$a->comment}</em></blockquote></p><p>Dobili ste {$a->earned} od maksimalnih {$a->outof} za ovaj esej.</p><p>Vaša ocjena za ovu lekciju je promijenjena na {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Vaša ocjena za pitanje {$a}';
$string['essays'] = 'Lagano';
$string['essayscore'] = 'Lagano osvojeni broj bodova';
$string['fileformat'] = 'Format fajla';
$string['finish'] = 'Završi';
$string['firstanswershould'] = 'Prvi odgovor će otići na stranicu "Tačno"';
$string['firstwrong'] = 'Žao nam je, ne možete da osvojite ovaj bod, zato što je Vaš odgovor netačan. Želite li da pokušate ponovo kako biste učili (ali bez mogućnosti da osvojite neke bodove)';
$string['flowcontrol'] = 'Kontrola toka lekcije';
$string['full'] = 'Prošireno';
$string['general'] = 'Opća podešavanja';
$string['gotoendoflesson'] = 'Idi na kraj lekcije';
$string['grade'] = 'Ocjena';
$string['gradebetterthan'] = 'Ocjena viša od (%)';
$string['gradebetterthanerror'] = 'Osvojite ocjenu veću od {$a} procenata';
$string['gradeessay'] = 'Ocjeni odgovore na esejski tip pitanja({$a->notgradedcount} još nije ocijenjeno, a {$a->notsentcount} nije poslano)';
$string['gradeis'] = 'Ocjena je {$a}';
$string['gradeoptions'] = 'Opcije za ocjenjivanje';
$string['handlingofretakes'] = 'Uređivanje ponovnih uzimanja';
$string['handlingofretakes_help'] = 'Ako su ponovni pokušaji dozvoljeni, ovo podešavanje određuje da li je ocjena za lekciju jednaka prosječnoj ocjeni svih pokušaja ili najvećoj ocjeni.';
$string['havenotgradedyet'] = 'Još nije ocijenjeno.';
$string['here'] = 'ovdje';
$string['highscore'] = 'Visoki broj osvojenih bodova';
$string['highscores'] = 'Najbollji rezultati';
$string['hightime'] = 'Najbolje vrijeme';
$string['importcount'] = 'Unosi se {$a} pitanja';
$string['importquestions'] = 'Unos pitanja';
$string['importquestions_help'] = 'Ovo svojstvo omogućava da pitanja u različitim formatima, budu unesena putem tekstualne datoteke.';
$string['insertedpage'] = 'Stranica je umetnuta';
$string['invalidfile'] = 'Neispravna datoteka';
$string['invalidid'] = 'Nije proslijeđen ID modula ili lekcije';
$string['invalidlessonid'] = 'ID lekcije nije bio tačan';
$string['invalidpageid'] = 'Neispravan ID stranice';
$string['jump'] = 'Prijeđi';
$string['jumps'] = 'Prelazi';
$string['jumps_help'] = 'Svaki odgovor (za stranicu sa pitanjem) ili opis (za stranicu sa sadržajem) ima odgovarajući prelaz. Prelaz može biti relativan, kao na primjer "tekuća stranica" ili "slijedeća stranica", ili apsolutan tj. prelaz na bilo koju stranicu u lekciji.';
$string['jumpsto'] = 'Prelazi na <em>{$a}</em>';
$string['leftduringtimed'] = 'Napustili ste lekciju koja je vremenski ograničena.<br />Pritisnite tipku za nastavak da biste pogledali lekciju od početka.';
$string['leftduringtimednoretake'] = 'Napustili ste lekciju koja je vremenski ograničena i nije Vam <br /> dozvoljeno da nastavite ili počnete lekciju ispočetka.';
$string['lesson:addinstance'] = 'Dodaj novu lekciju';
$string['lessonattempted'] = 'Lekciji je pristupano';
$string['lessonclosed'] = 'Ova lekcija je zatvorena na {$a}.';
$string['lessoncloses'] = 'Lekcija se zatvara';
$string['lessoncloseson'] = 'Vrijeme zatvaranja lekcije: {$a}';
$string['lesson:edit'] = 'Uredi lekciju';
$string['lessonformating'] = 'Formatiranje lekcije';
$string['lesson:manage'] = 'Upravljaj lekcijom';
$string['lessonmenu'] = 'Meni lekcije';
$string['lessonnotready'] = 'Ova lekcija još nije spremna za korištenje. Molimo kontaktirajte svog {$a}.';
$string['lessonnotready2'] = 'Ova lekcija još nije spremna za korištenje';
$string['lessonopen'] = 'Ova lekcija će biti otvorena na {$a}.';
$string['lessonopens'] = 'Lekcija se otvara';
$string['lessonpagelinkingbroken'] = 'Nije pronađena prva stranica. Mora da je došlo do prekida linkova između stranica lekcije. Molimo kontaktirajte administratora.';
$string['lessonstats'] = 'Statistika lekcija';
$string['linkedmedia'] = 'Povezani mediji';
$string['loginfail'] = 'Ulazak nije dopušten, molimo Vas pokušajte ponovo...';
$string['lowscore'] = 'Najslabiji rezultat';
$string['lowtime'] = 'Najslabije vrijeme';
$string['manualgrading'] = 'Ocijeni eseje';
$string['matchesanswer'] = 'Poklapa šibice sa odgovorom';
$string['matching'] = 'Uparivanje';
$string['matchingpair'] = 'Uparivanje para {$a}';
$string['maxgrade'] = 'Maksimalna ocjena';
$string['maxgrade_help'] = 'Ovo podešavanje određuje najveću ocjenu za lekciju. Ukoliko je vrijednost podešena na 0 lekcija se neće pojaviti na stranici sa ocjenama.';
$string['maxhighscores'] = 'Broj za prikaz visokog broja osvojenih bodova';
$string['maximumnumberofanswersbranches'] = 'Maksimalan broj odgovora / područja';
$string['maximumnumberofanswersbranches_help'] = 'Ova vrijednost određuje maksimalni broj odgovora koji se mogu koristiti u lekciji. Ako se koriste samo TAČNO/NETAČNO pitanja tada je razumno postaviti ovu vrijednost na 2. Podešavanje se može promijeniti bila kada, jer utiče samo na način prikaza podataka nastavniku, ne i na same podatke.';
$string['maximumnumberofattempts'] = 'Maksimalan broj pokušaja';
$string['maximumnumberofattempts_help'] = 'Ovo podešavanje određuje maksimalan broj dozvoljenih pokušaja za svako pitanje. Ukoliko se netačni odgovori ponavljaju, kada se dostigne maksimalan broj pokušaja, biće prikazana sljedeća stranica lekcije.';
$string['maximumnumberofattemptsreached'] = 'Dostignut je maksimalan broj pokušaja - prelazi se na sljedeću stranicu';
$string['maxtime'] = 'Vremensko ograničenje (u minutama)';
$string['maxtimewarning'] = 'Imate {$a} minut(a) da završite lekciju.';
$string['mediaclose'] = 'Prikaz dugmeta za zatvaranje';
$string['mediafile'] = 'Pop-up prozor za prikaz datoteke ili web stranice';
$string['mediafile_help'] = 'Da biste na početku lekcije uključili pop-up prozor odaberite odgovarajuću datoteku za prikaz. Svaka stranica lekcije će sadržavati link za ponovno otvaranje pop-up prozora, ukoliko je to potrebno.';
$string['mediafilepopup'] = 'Kliknite ovdje za prikaz';
$string['mediaheight'] = 'Visina pop-up prozora:';
$string['mediawidth'] = 'Širina pop-up prozora:';
$string['messageprovider:graded_essay'] = 'Obavještenje o ocijenjenom eseju';
$string['minimumnumberofquestions'] = 'Minimalan broj pitanja';
$string['minimumnumberofquestions_help'] = 'Ovo podešavanje određuje najmanji broj pitanja koji će se koristiti za izračunavanje ocjene za aktivnost. Ukoliko lekcija sadrži jednu ili više stranica sadržaja (tabele grananja) minimalnu vrijednost bi trebalo postaviti na 0. Ukoliko postavite vrijednost na, recimo, 20 na uvodnoj stranici lekcije će se pojaviti sljedeći tekst: "U ovoj lekciji se očekuje da odgovorite na najmanje 20 pitanja. Ukoliko želite možete odgovoriti i na više. Međutim, ukoliko odgovorite na manje od 20 pitanja, Vaša ocjena će se računati kao da ste odgovorili na svih 20 pitanja."';
$string['missingname'] = 'Molimo unesite nadimak';
$string['modattempts'] = 'Dodati pregled studenta';
$string['modattempts_help'] = 'Ako je ova opcija omogućena, studenti će moći ponovo da pogledaju lekciju od početka.';
$string['modattemptsnoteacher'] = 'Studentski pregled funkcionira samo za studente';
$string['modulename'] = 'Lekcija';
$string['modulename_help'] = 'Modul \'Lekcija\' omogućava predavaču da prezentuje sadržaj i/ili praktične aktivnosti na interesantan i fleksibilan način. Predavač može da koristi lekciju kako bi kreirao linearni niz stranica sa sadržajem ili instrukcije koje nude različite putanje ili opcije za korisnika. U oba slučaja predavači mogu da povećaju angažman studenata i da obezbijede razumijevanje gradiva, tako što će na kraju stranice dodati različite tipove pitanja, uključujući višestruki izbor, sparivanje, kratak odgovor i dr. Zavisno od izabranog odgovora, kao i od toga kako je predavač organizovao lekciju, studenti mogu da napreduju na sljedeću stranicu, budu vraćeni na prethodnu ili preusmjereni na neku drugu stranicu lekcije. Lekcije mogu da se ocjenjuju, a ocjene upisuju u knjigu ocjena. Lekcija može da se koristi: * za samostalno učenje novih sadržaja * za scenarije ili simulacije/vježbe donošenja odluka * za ispravku naučenog gradiva, sa različitim setovima pitanja u zavisnosti od odgovora datih na početna pitanja';
$string['modulenameplural'] = 'Lekcije';
$string['move'] = 'Premjesti stranicu';
$string['movedpage'] = 'Stranica je premještena';
$string['movepagehere'] = 'Ovdje premjesti stranicu';
$string['moving'] = 'Premještanje stranice: {$a}';
$string['multianswer'] = 'Mogućnost više odgovora';
$string['multianswer_help'] = 'Označite ukoliko postoji više tačnih osgovora.';
$string['multichoice'] = 'Višestruki izbor';
$string['multipleanswer'] = 'Mogućnost više odgovora';
$string['nameapproved'] = 'Potvrđeno ime';
$string['namereject'] = 'Žao nam je, Vaše ime je odbijeno.<br />Molimo pokušajte sa drugim imenom.';
$string['new'] = 'novo';
$string['nextpage'] = 'Sljedeća stranica';
$string['noanswer'] = 'Nema datog odgovora. Molim Vas vratite se nazad i odaberite jedan od odgovora.';
$string['noattemptrecordsfound'] = 'Nema zabilježenih pokušaja: nije data nijedna ocjena';
$string['nobranchtablefound'] = 'Nije pronađena nijedna stranica sadržaja (tabela grananja)';
$string['nocommentyet'] = 'Još nema komentara.';
$string['nocoursemods'] = 'Nije pronađena nijedna aktivnost';
$string['nocredit'] = 'Bez bodova';
$string['nodeadline'] = 'Bez roka';
$string['noessayquestionsfound'] = 'U ovoj lekciji nisu pronađena pitanja koja zahtijevaju odgovor u formi eseja.';
$string['nohighscores'] = 'Nema visokog broja osvojenih bodova';
$string['nolessonattempts'] = 'Niko još nije pokušao da prođe kroz ovu lekciju.';
$string['nooneansweredcorrectly'] = 'Niko nije tačno odgovorio.';
$string['nooneansweredthisquestion'] = 'Niko nije odgovorio na ovo pitanje.';
$string['noonecheckedthis'] = 'Niko nije ovo provjerio.';
$string['nooneenteredthis'] = 'Niko nije ovo potvrdio.';
$string['noonehasanswered'] = 'Niko još nije odgovorio na esejsko pitanje.';
$string['noretake'] = 'Nije Vam dopušteno da ponovo uzmete ovu lekciju.';
$string['normal'] = 'Normalno - pratite putanju lekcije';
$string['notcompleted'] = 'Nije kompletirano';
$string['notdefined'] = 'Nije definirano';
$string['nothighscore'] = 'Vaš rezultat nije među prvih {$a} na popisu najboljih rezultata.';
$string['notitle'] = 'Nema naslova';
$string['numberofcorrectanswers'] = 'Broj tačnih odgovora: {$a}';
$string['numberofcorrectmatches'] = 'Broj tačnih podudaranja: {$a}';
$string['numberofpagestoshow'] = 'Prikaz broja stranica (Izvještaja)';
$string['numberofpagestoshow_help'] = '<p>Ovaj parametar se koristi samo u tipu lekcija sa Flash Karticama. Zadana vrijednost je nula, što znači da su sve stranice/kartice prikazane u lekciji. Postavljanje ovog parametra na ne-nula vrijednost prikazuje taj broj stranica. Nakon što je dosegnut taj broj stranica/kartica, dolazi se do završetka lekcije i studentu se prikazuje njegova ocjena.</p> <p>Ukoliko se ovaj parametar podesi na broj veći od broja stranica u lekciji onda se kraj lekcije dostiže kada se sve stranice prikažu.</p>';
$string['numberofpagesviewed'] = 'Broj pogledanih stranica: {$a}';
$string['numberofpagesviewednotice'] = 'Broj pitanja na koje je dat odgovor: {$a->nquestions}; (Trebalo bi ih biti bar: {$a->minquestions})';
$string['numerical'] = 'Brojčani';
$string['ongoing'] = 'Prikaz toka broja osvojenih bodova';
$string['ongoingcustom'] = 'Imate zarađen-o {$a->score} poen(a) van {$a->currenthigh} poen(a)do sada.';
$string['ongoing_help'] = 'Ako je ova opcija omogućena, na svakoj stranici će biti prikazan trenutni broj bodova od ukupnog broja koje je student do tada mogao da postigne.';
$string['ongoingnormal'] = 'Tačno ste odgovorili na {$a->correct} od {$a->viewed} pitanja koja ste vidjeli.';
$string['onpostperpage'] = 'Samo jedna poruka po ocjeni';
$string['options'] = 'Opcije';
$string['or'] = 'ILI';
$string['ordered'] = 'Poredano';
$string['other'] = 'Ostalo';
$string['outof'] = 'Izvan {$a}';
$string['overview'] = 'Gledište od početka do kraja';
$string['overview_help'] = 'Lekcija se sastoji od određenog broja stranica i, opciono, stranica sa sadržajem (tabela grananja). Stranica sadrži proizvoljnu količinu teksta i odgovarajućih ilustracija, i obično se završava pitanjem. Uz svaki odgovor na pitanje vezan je tzv. prelaz. Prelazi mogu biti relativni, kao na primjer “tekuća stranica” ili “sljedeća stranica”, ili apsolutni kada se navodi bilo koja stranica unutar lekcije. Stranica sa sadržajem (tabela grananja) je stranica koja sadrži niz linkova ka drugim stranicama u lekciji, kao na primjer "Tabela sadržaja".';
$string['page'] = 'Stranica: {$a}';
$string['pagecontents'] = 'Sadržaj stranice';
$string['page-mod-lesson-edit'] = 'Stranica za uređivanje lekcije';
$string['page-mod-lesson-view'] = 'Prikaži ili pregledaj stranicu lekcije';
$string['page-mod-lesson-x'] = 'Bilo koja stranica lekcije';
$string['pages'] = 'Stranice';
$string['pagetitle'] = 'Naziv stranice';
$string['password'] = 'Lozinka';
$string['passwordprotectedlesson'] = '{$a} je lekcija zaštićena lozinkom.';
$string['pleasecheckoneanswer'] = 'Potvrdite odgovor';
$string['pleasecheckoneormoreanswers'] = 'Potvrdite jedan ili više odgovora';
$string['pleaseenteryouranswerinthebox'] = 'Unesite odgovor u polje za unos';
$string['pleasematchtheabovepairs'] = 'Spojite parove iznad';
$string['pluginadministration'] = 'Administracija lekcije';
$string['pluginname'] = 'Lekcija';
$string['pointsearned'] = 'Zarađeni poeni';
$string['postprocesserror'] = 'Došlo je do greške tokom postprocesiranja!';
$string['postsuccess'] = 'Uspješno poslano';
$string['practice'] = 'Lekcija za vježbanje';
$string['practice_help'] = 'Lekcija za vježbu se ne prikazuje u dnevniku ocjena.';
$string['preprocesserror'] = 'Došlo je do greške tokom predprocesiranja!';
$string['preview'] = 'Pregled';
$string['previewlesson'] = 'Pregled {$a}';
$string['previouspage'] = 'Predhodna stranica';
$string['processerror'] = 'Došlo je do greške tokom procesiranja!';
$string['progressbar'] = 'Traka napredovanja kroz lekciju';
$string['progressbar_help'] = 'Ako je ova opcija omogućena, na dnu stranice biće prikazana traka koja prikazuje približan procenat završenosti lekcije (napredovanje studenta kroz lekciju).';
$string['progressbarteacherwarning'] = 'Traka napredovanja kroz lekciju se ne prikazuje za {$a}';
$string['progressbarteacherwarning2'] = 'Nećete vidjeti traku napredovanja zato što možete da uređujete ovu lekciju';
$string['progresscompleted'] = 'Završili ste {$a}% lekcije';
$string['qtype'] = 'Vrsta stranice';
$string['question'] = 'Pitanja';
$string['questionoption'] = 'Ponuđeni odgovori';
$string['questiontype'] = 'Otkucaj odgovor';
$string['randombranch'] = 'Nasumično odabrana stranica sa sadržajem i grananjem';
$string['randompageinbranch'] = 'Proizvoljno pitanje unutar područja';
$string['rank'] = 'Klasifikacija';
$string['rawgrade'] = 'Neobrađena ocjena';
$string['receivedcredit'] = 'Uobičajen kredit';
$string['redisplaypage'] = 'Osvježavanje prikaza stranice';
$string['report'] = 'Izvještaj';
$string['reports'] = 'Izvještaji';
$string['response'] = 'Odgovor';
$string['retakesallowed'] = 'Ponovni pregled lekcije je dozvoljen';
$string['retakesallowed_help'] = 'Ako je ova opcija omogućena, student može više puta da pogleda lekciju.';
$string['returnto'] = 'Vrati se na {$a}';
$string['returntocourse'] = 'Povratak na kurs';
$string['review'] = 'Pregled';
$string['reviewlesson'] = 'Ocjena lekcije';
$string['reviewquestionback'] = 'Da, volio/la bih da ponovo pokušam';
$string['reviewquestioncontinue'] = 'Ne, želim da pređem na sljedeće pitanje';
$string['sanitycheckfailed'] = 'Provjera nije uspjela. Pokušaj je izbrisan.';
$string['savechanges'] = 'Sačuvaj promjene';
$string['savechangesandeol'] = 'Sačuvaj sve promjene i idi na kraj lekcije.';
$string['savepage'] = 'Sačuvaj stranicu';
$string['score'] = 'Broj osvojenih bodova';
$string['scores'] = 'Brojevi osvojenih bodova';
$string['secondpluswrong'] = 'Nije potpuno.  Da li želite pokušati ponovo?';
$string['selectaqtype'] = 'Odaberite tip pitanja';
$string['shortanswer'] = 'Kratak odgovor';
$string['showanunansweredpage'] = 'Prikaži neodgovorenu stranu';
$string['showanunseenpage'] = 'Prikaži nepregledanu stranu';
$string['singleanswer'] = 'Pojedinačan odgovor';
$string['skip'] = 'Preskoči navigaciju';
$string['slideshow'] = 'Slideshow';
$string['slideshowbgcolor'] = 'Slideshow pozadinska boja';
$string['slideshowheight'] = 'Visina dijela za slideshow prikaz';
$string['slideshow_help'] = 'Ukoliko je podešavanje omogućeno, lekcija se prikazuje kao slideshow, sa fiksnom širinom i visinom.';
$string['slideshowwidth'] = 'Širina dijela za slideshow prikaz';
$string['startlesson'] = 'Pokrenite lekciju';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname}\'s pokušati brojeve {$a->attempt}';
$string['studentname'] = '{$a} Ime';
$string['studentoneminwarning'] = 'Upozorenje: imate manje od jedne minute da završite lekciju.';
$string['studentresponse'] = '{$a}\'i odgovor';
$string['submit'] = 'Pošalji';
$string['submitname'] = 'Potvrdite ime';
$string['teacherjumpwarning'] = 'U ovoj lekciji se koriste {$a->cluster} ili {$a->unseen} prelaz između stranica. Prelaz "Sljedeća stranica" će se koristiti umjesto njih tokom ovog prikaza. Za testiranje ovih prelaza prijavite se na sistem u ulozi studenta.';
$string['teacherongoingwarning'] = 'Napredovanje broja osvojenih bodova je jedino pregledno za studente. Prijavite se kao student da testirate napredovanje broja osvojenih bodova.';
$string['teachertimerwarning'] = 'Mjerač vremena mogu da vide samo studenti. Kako biste testirali mjerač vremena prijavite se na sistem u ulozi studenta.';
$string['thatsthecorrectanswer'] = 'Tačan odgovor';
$string['thatsthewronganswer'] = 'Pogrešan odgovor';
$string['thefollowingpagesjumptothispage'] = 'Sljedeće stranice vode do ove stranice';
$string['thispage'] = 'Ova stranica';
$string['timeremaining'] = 'Preostalo vrijeme';
$string['timespenterror'] = 'Provedite bar {$a} minuta pregledajući sadržaj lekcije';
$string['timespentminutes'] = 'Potrošeno vrijeme (u minutima)';
$string['timetaken'] = 'Potrošeno vrijeme';
$string['topscorestitle'] = 'Top {$a} broj osvojenih bodova za lekciju.';
$string['truefalse'] = 'Tačno/netačno';
$string['unabledtosavefile'] = 'Nije moguće sačuvati datoteku koji ste poslali.';
$string['unknownqtypesnotimported'] = 'Broj pitanja, sa nepodržanim tipom pitanja, koja nisu unesena: {$a}';
$string['unseenpageinbranch'] = 'Još neprikazano pitanje unutar stranice sa sadržajem i grananjem';
$string['unsupportedqtype'] = 'Tip pitanja koji nije podržan {$a}!';
$string['updatedpage'] = 'Stranica je ažurirana';
$string['updatefailed'] = 'Ažuriranje nije uspjelo';
$string['usemaximum'] = 'Koristi maksimalnu vrijednost';
$string['usemean'] = 'Koristi prosječnu vrijednost';
$string['usepassword'] = 'Lekcija zaštićena lozinkom';
$string['usepassword_help'] = 'Ukoliko je uključeno, za pristup lekciji neophodna je lozinka';
$string['viewgrades'] = 'Prikaz ocjena';
$string['viewhighscores'] = 'Vidi listu sa visokim brojem osvojenih bodova .';
$string['viewreports'] = 'Prikaz {$a->attempts} kompletnih pokušaja studenta {$a->student}';
$string['viewreports2'] = 'Pogledaj {$a} završenih pokušaja';
$string['welldone'] = 'Dobro urađeno!';
$string['whatdofirst'] = 'Šta želite prvo da uradite?';
$string['wronganswerjump'] = 'Preskok pogrešnog odgovora';
$string['wronganswerscore'] = 'Broj bodova koje nosi pogrešan odgovor';
$string['wrongresponse'] = 'Pogrešan odgovor';
$string['xattempts'] = '{$a} pokušaj(a)';
$string['youhaveseen'] = 'Već ste vidjeli više od jedne stranice ove lekcije.<br /> Želite li početi od posljednje stranice koju ste vidjeli?';
$string['youmadehighscore'] = 'Dospjeli ste na listu {$a} najboljih rezultata.';
$string['youranswer'] = 'Vaš odgovor';
$string['yourcurrentgradeis'] = 'Vaša trenutna ocjena je {$a}';
$string['yourcurrentgradeisoutof'] = 'Vaša trenutna ocjena je {$a->grade} od mogućih {$a->total}';
$string['youshouldview'] = 'Trebate pogledati barem: {$a}';
