<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresa';
$string['advanced:anchor_delta_height'] = 'Podesi visinu sidra';
$string['advanced:anchor_delta_width'] = 'Podesi širinu sidra';
$string['advanced:anchor_desc'] = 'Umetni/uredi sidro';
$string['advanced:backcolor_desc'] = 'Odaberite boju pozadine';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Citat';
$string['advanced:blockquote_desc'] = 'Citiraj';
$string['advanced:bold_desc'] = 'Podebljaj (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Neuređena lista';
$string['advanced:charmap_delta_height'] = 'Podesi visinu nestandardnog karaktera';
$string['advanced:charmap_delta_width'] = 'Podesi širinu nestandardnog karaktera';
$string['advanced:charmap_desc'] = 'Umetni vlastiti znak';
$string['advanced:cleanup_desc'] = 'Počisti kod';
$string['advanced:clipboard_msg'] = 'Komande Kopiraj/Isjeci/Nalijepi nisu dostupne u Mozilla Firefox-u. Da li želite više informacija o ovom problemu?';
$string['advanced:code'] = 'Kod';
$string['advanced:code_desc'] = 'Uredi HTML izvorni kod';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopiraj';
$string['advanced:custom1_desc'] = 'Vaš namjenski opis';
$string['advanced:cut_desc'] = 'Isjeci';
$string['advanced:dd'] = 'Opis definicije';
$string['advanced:div'] = 'Div';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'O programu';
$string['advanced_dlg:about_help'] = 'Pomoć';
$string['advanced_dlg:about_license'] = 'Licenca';
$string['advanced_dlg:about_loaded'] = 'Postojeći dodaci';
$string['advanced_dlg:about_plugin'] = 'Dodatak';
$string['advanced_dlg:about_plugins'] = 'Dodaci';
$string['advanced_dlg:about_title'] = 'TinyMCE';
$string['advanced_dlg:about_version'] = 'Verzija';
$string['advanced_dlg:accessibility_help'] = 'Dostupnost - pomoć';
$string['advanced_dlg:accessibility_usage_title'] = 'Općenita upotreba';
$string['advanced_dlg:anchor_invalid'] = 'Molimo navedite ispravno ime sidra.';
$string['advanced_dlg:anchor_name'] = 'Ime sidra';
$string['advanced_dlg:anchor_title'] = 'Umetni/uredi sidro';
$string['advanced_dlg:charmap_title'] = 'Odaberite znak';
$string['advanced_dlg:charmap_usage'] = 'Koristi lijevu i desnu strelicu za upravljanje.';
$string['advanced_dlg:code_title'] = 'HTML uređivač';
$string['advanced_dlg:code_wordwrap'] = 'Omatanje teksta';
$string['advanced_dlg:colorpicker_color'] = 'Boja:';
$string['advanced_dlg:colorpicker_name'] = 'Naziv:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Imenovano';
$string['advanced_dlg:colorpicker_named_title'] = 'Imenovane boje';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paleta boja';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Odabir';
$string['advanced_dlg:colorpicker_picker_title'] = 'Odabir boje';
$string['advanced_dlg:colorpicker_title'] = 'Izbor boje';
$string['advanced_dlg:image_align'] = 'Poravnavanje';
$string['advanced_dlg:image_align_baseline'] = 'Osnovna linija';
$string['advanced_dlg:image_align_bottom'] = 'Dno';
$string['advanced_dlg:image_align_left'] = 'Lijevo';
$string['advanced_dlg:image_align_middle'] = 'Sredina';
$string['advanced_dlg:image_align_right'] = 'Desno';
$string['advanced_dlg:image_align_textbottom'] = 'Dno teksta';
$string['advanced_dlg:image_align_texttop'] = 'Vrh teksta';
$string['advanced_dlg:image_align_top'] = 'Vrh';
$string['advanced_dlg:image_alt'] = 'Opis slike';
$string['advanced_dlg:image_border'] = 'Obrub';
$string['advanced_dlg:image_dimensions'] = 'Dimenzije';
$string['advanced_dlg:image_hspace'] = 'Vodoravni razmak';
$string['advanced_dlg:image_list'] = 'Lista slika';
$string['advanced_dlg:image_src'] = 'URL slike';
$string['advanced_dlg:image_title'] = 'Umetni/uredi sliku';
$string['advanced_dlg:image_vspace'] = 'Okomiti razmak';
$string['advanced_dlg:invalid_color_value'] = 'Neispravna vrijednost boje';
$string['advanced_dlg:link_is_email'] = 'URL adresa koju ste unijeli liči na e-mail adresu. Da li želite da dodate neophodni mailto: prefiks?';
$string['advanced_dlg:link_is_external'] = 'URL adresa koju ste unijeli liči na vanjski link. Da li želite da dodate neophodni http:// prefiks?';
$string['advanced_dlg:link_list'] = 'Lista poveznica';
$string['advanced_dlg:link_target'] = 'Meta';
$string['advanced_dlg:link_target_blank'] = 'Otvori poveznicu u novom prozoru';
$string['advanced_dlg:link_target_same'] = 'Otvori poveznicu u istom prozoru';
$string['advanced_dlg:link_title'] = 'Umetni/uredi poveznicu';
$string['advanced_dlg:link_titlefield'] = 'Naslov';
$string['advanced_dlg:link_url'] = 'Link URL';
$string['advanced:dt'] = 'Definicija pojma';
$string['advanced:fontdefault'] = 'Vrsta pisma';
$string['advanced:font_size'] = 'Veličina pisma';
$string['advanced:forecolor_desc'] = 'Odaberite boju teksta';
$string['advanced:h1'] = 'Naslov 1';
$string['advanced:h2'] = 'Naslov 2';
$string['advanced:h3'] = 'Naslov 3';
$string['advanced:h4'] = 'Naslov 4';
$string['advanced:h5'] = 'Naslov 5';
$string['advanced:h6'] = 'Naslov 6';
$string['advanced:help_desc'] = 'Pomoć';
$string['advanced:help_shortcut'] = 'Pritisnite ALT+F10 za toolbar. Pritisnite ALT+0 za pomoć.';
$string['advanced:hr_desc'] = 'Umetni vodoravnu crtu';
$string['advanced:image_delta_height'] = 'Podesi visinu slike';
$string['advanced:image_delta_width'] = 'Podesi širinu slike';
$string['advanced:image_desc'] = 'Umetni/uredi sliku';
$string['advanced:image_props_desc'] = 'Svojstva slike';
$string['advanced:indent_desc'] = 'Izvuci';
$string['advanced:italic_desc'] = 'Kurziv/nakošeno (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centriraj';
$string['advanced:justifyfull_desc'] = 'Poravnaj potpuno';
$string['advanced:justifyleft_desc'] = 'Poravnaj lijevo';
$string['advanced:justifyright_desc'] = 'Poravnaj desno';
$string['advanced:link_delta_height'] = 'Podesi visinu linka';
$string['advanced:link_delta_width'] = 'Podesi širinu linka';
$string['advanced:link_desc'] = 'Umetni/uredi poveznicu';
$string['advanced:more_colors'] = 'Više boja';
$string['advanced:newdocument'] = 'Da li ste sigurni da želite da uklonite cijeli sadržaj?';
$string['advanced:newdocument_desc'] = 'Novi dokument';
$string['advanced:numlist_desc'] = 'Uređena lista';
$string['advanced:outdent_desc'] = 'Uvuci';
$string['advanced:paragraph'] = 'Paragraf';
$string['advanced:paste_desc'] = 'Zalijepi';
$string['advanced:path'] = 'Staza';
$string['advanced:pre'] = 'Oblikovano';
$string['advanced:redo_desc'] = 'Ponovi posljednju radnju (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Poništi oblikovanje';
$string['advanced:rich_text_area'] = 'područje bogato tekstom';
$string['advanced:samp'] = 'Primjer koda';
$string['advanced:striketrough_desc'] = 'Precrtaj';
$string['advanced:style_select'] = 'Stilovi';
$string['advanced:sub_desc'] = 'Indeks';
$string['advanced:sup_desc'] = 'Eksponent';
$string['advanced:toolbar'] = 'Traka sa alatima';
$string['advanced:toolbar_focus'] = 'Prijeđi na alate - Alt+Q, Prijeđi na editor - Alt-Z, Prijeđi na putanju elementa - Alt-X';
$string['advanced:underline_desc'] = 'Podcrtaj (Ctrl+U)';
$string['advanced:undo_desc'] = 'Poništi posljednju radnju (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Poništi poveznicu';
$string['advanced:visualaid_desc'] = 'Uključi/isključi smjernice/nevidljivе elementе';
$string['advhr:advhr_desc'] = 'Vodoravna crta';
$string['advhr:delta_height'] = 'Visina';
$string['advhr:delta_width'] = 'Širina';
$string['advhr_dlg:normal'] = 'Normalno';
$string['advhr_dlg:noshade'] = 'Bez sjenke';
$string['advhr_dlg:size'] = 'Visina';
$string['advhr_dlg:width'] = 'Širina';
$string['advhr_dlg:widthunits'] = 'Jedinice';
$string['advimage:delta_height'] = 'Visina';
$string['advimage:delta_width'] = 'Širina';
$string['advimage_dlg:align'] = 'Poravnavanje';
$string['advimage_dlg:align_baseline'] = 'Osnovna linija';
$string['advimage_dlg:align_bottom'] = 'Dole';
$string['advimage_dlg:align_left'] = 'Lijevo';
$string['advimage_dlg:align_middle'] = 'Sredina';
$string['advimage_dlg:align_right'] = 'Desno';
$string['advimage_dlg:align_textbottom'] = 'Tekst dole';
$string['advimage_dlg:align_texttop'] = 'Vrh teksta';
$string['advimage_dlg:align_top'] = 'Vrh';
$string['advimage_dlg:alt'] = 'Opis slike';
$string['advimage_dlg:alt_image'] = 'Alternativna slika';
$string['advimage_dlg:border'] = 'Obrub';
$string['advimage_dlg:classes'] = 'Klase';
$string['advimage_dlg:constrain_proportions'] = 'Zadrži proporcije';
$string['advimage_dlg:dialog_title'] = 'Umetni/uredi sliku';
$string['advimage_dlg:dimensions'] = 'Dimenzije';
$string['advimage_dlg:example_img'] = 'Prikaz slike';
$string['advimage_dlg:general'] = 'Opće';
$string['advimage_dlg:height'] = 'Visina';
$string['advimage_dlg:hspace'] = 'Vodoravni razmak';
$string['advimage_dlg:id'] = 'ID broj';
$string['advimage_dlg:image_list'] = 'Lista slika';
$string['advimage_dlg:langcode'] = 'Kod jezika';
$string['advimage_dlg:langdir'] = 'Smjer jezika';
$string['advimage_dlg:list'] = 'Lista slika';
$string['advimage_dlg:long_desc'] = 'Poveznica dugog opisa';
$string['advimage_dlg:ltr'] = 'S lijeva na desno';
$string['advimage_dlg:map'] = 'Karta slike';
$string['advimage_dlg:misc'] = 'Razno';
$string['advimage_dlg:missing_alt'] = 'Da li ste sigurni da želite nastavite bez "Opisa slika"? Bez opisa slika neće biti dostupna pojedinim korisnicima sa problemom vida, onima koji koriste tekstualne Web pretraživače ili onima koji su u Web pretraživačima isključili opciju za slike.';
$string['advimage_dlg:mouseout'] = 'za izlazak miša van slike';
$string['advimage_dlg:mouseover'] = 'za prelazak miša preko slike';
$string['advimage_dlg:preview'] = 'Prikaz';
$string['advimage_dlg:rtl'] = 'S desna na lijevo';
$string['advimage_dlg:src'] = 'URL slike';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Izmjena slike';
$string['advimage_dlg:tab_advanced'] = 'Napredno';
$string['advimage_dlg:tab_appearance'] = 'Izgled';
$string['advimage_dlg:tab_general'] = 'Opće';
$string['advimage_dlg:title'] = 'Naslov';
$string['advimage_dlg:vspace'] = 'Okomiti razmak';
$string['advimage_dlg:width'] = 'Širina';
$string['advimage:image_desc'] = 'Umetni/uredi sliku';
$string['advlink:delta_height'] = 'Visina';
$string['advlink:delta_width'] = 'Širina';
$string['advlink_dlg:accesskey'] = 'Pristupni ključ';
$string['advlink_dlg:advanced_props'] = 'Napredna svojstva';
$string['advlink_dlg:advanced_tab'] = 'Napredno';
$string['advlink_dlg:anchor_names'] = 'Sidra';
$string['advlink_dlg:classes'] = 'Klasa';
$string['advlink_dlg:encoding'] = 'Kodiranje znakova';
$string['advlink_dlg:event_props'] = 'Događaji';
$string['advlink_dlg:events_tab'] = 'Događaj';
$string['advlink_dlg:general_props'] = 'Opća svojstva';
$string['advlink_dlg:general_tab'] = 'Opće';
$string['advlink_dlg:height'] = 'Visina';
$string['advlink_dlg:id'] = 'ID broj';
$string['advlink_dlg:is_email'] = 'Izgleda da je URL koji ste unijeli e-mail adresa. Da li želite da dodate neophodan prefiks mailto:';
$string['advlink_dlg:is_external'] = 'Izgleda da je URL koji ste unijeli vanjska veza. Da li želite da dodate neophodan prefiks http:// ?';
$string['advlink_dlg:langcode'] = 'Kod jezika';
$string['advlink_dlg:langdir'] = 'Smjer jezika';
$string['advlink_dlg:link_list'] = 'Lista poveznica';
$string['advlink_dlg:list'] = 'Lista poveznica';
$string['advlink_dlg:ltr'] = 'S lijeva na desno';
$string['advlink_dlg:mime'] = 'MIME tip';
$string['advlink_dlg:popup'] = 'Javascript popup';
$string['advlink_dlg:popup_dependent'] = 'Ovisan (samo za Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Pokaži traku lokacije';
$string['advlink_dlg:popup_menubar'] = 'Pokaži izbornik';
$string['advlink_dlg:popup_name'] = 'Ime prozora';
$string['advlink_dlg:popup_opts'] = 'Opcije';
$string['advlink_dlg:popup_position'] = 'Pozicija (X/Y)';
$string['advlink_dlg:popup_props'] = 'Pop-up svojstva';
$string['advlink_dlg:popup_resizable'] = 'Prozor promjenljive veličine';
$string['advlink_dlg:popup_return'] = 'Umetni \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Pokaži klizače';
$string['advlink_dlg:popup_size'] = 'Veličina';
$string['advlink_dlg:popup_statusbar'] = 'Pokaži statusnu traku';
$string['advlink_dlg:popup_tab'] = 'Pop-up';
$string['advlink_dlg:popup_toolbar'] = 'Pokaži alatne trake';
$string['advlink_dlg:popup_url'] = 'Pop-up URL';
$string['advlink_dlg:rel'] = 'Odnos stranice prema meti';
$string['advlink_dlg:rev'] = 'Odnos mete prema stranici';
$string['advlink_dlg:rtl'] = 'S desna na lijevo';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'Tabindex';
$string['advlink_dlg:target'] = 'Meta';
$string['advlink_dlg:target_blank'] = 'Otvori u novom prozoru';
$string['advlink_dlg:target_langcode'] = 'Jezik';
$string['advlink_dlg:target_name'] = 'Ime mete';
$string['advlink_dlg:target_parent'] = 'Otvori u izvornom prozoru / okvir';
$string['advlink_dlg:target_same'] = 'Otovori u novom prozoru / okviru';
$string['advlink_dlg:target_top'] = 'Otvori u gornjem okviru (zamjenjuje sve okvire)';
$string['advlink_dlg:title'] = 'Umetni/uredi poveznicu';
$string['advlink_dlg:titlefield'] = 'Naslov';
$string['advlink_dlg:url'] = 'URL poveznice';
$string['advlink_dlg:width'] = 'Širina';
$string['advlink:link_desc'] = 'Unesi/Uredi link';
$string['advlist:circle'] = 'Prazan krug';
$string['advlist:def'] = 'Zadano';
$string['advlist:disc'] = 'Pun krug (disk)';
$string['advlist:lower_alpha'] = 'Mala slova abecede';
$string['advlist:lower_greek'] = 'Mala slova grčkog alfabeta';
$string['advlist:lower_roman'] = 'Rimski brojevi malim slovima';
$string['advlist:square'] = 'Kvadrat';
$string['advlist:types'] = 'Tipovi';
$string['advlist:upper_alpha'] = 'Velika slova abecede';
$string['advlist:upper_roman'] = 'Rimski brojevi velikim slovima';
$string['aria:rich_text_area'] = 'Polje za tekst u RTF formatu';
$string['autosave:restore_content'] = 'Vraćanje automatski sačuvanog teksta';
$string['autosave:unload_msg'] = 'Izmjene koje ste napravili neće biti sačuvane ukoliko napustite ovu stranicu.';
$string['autosave:warning_message'] = 'Ako vratite sačuvani sadržaj, izgubićete sav sadržaj koji se trenutno nalazi u editoru.

Da li ste sigurni da želite da vratite sačuvani sadržaj?';
$string['availablebuttons'] = 'Dostupni dugmići';
$string['colors:000000'] = 'Crno';
$string['colors:000080'] = 'Mornarsko plava';
$string['colors:0000FF'] = 'Plava';
$string['colors:003300'] = 'Tamno zelena';
$string['colors:003366'] = 'Tamno neboplava';
$string['colors:008000'] = 'Zelena';
$string['colors:008080'] = 'Plavozelena';
$string['colors:00CCFF'] = 'Nebo plava';
$string['colors:00FF00'] = 'Žutozelena';
$string['colors:00FFFF'] = 'Akva (boja vode)';
$string['colors:333300'] = 'Tamno maslinasta';
$string['colors:333333'] = 'Veoma tamno siva';
$string['colors:333399'] = 'Indigoplava';
$string['colors:3366FF'] = 'Kraljevski plava';
$string['colors:339966'] = 'Morski zelena';
$string['colors:33CCCC'] = 'Tirkizna';
$string['colors:666699'] = 'Sivkasto plava';
$string['colors:800000'] = 'Kestenjastomrka';
$string['colors:800080'] = 'Purpurna';
$string['colors:808000'] = 'Maslinasta';
$string['colors:808080'] = 'Siva';
$string['colors:993300'] = 'Tamno narandžasta';
$string['colors:993366'] = 'Smeđa';
$string['colors:999999'] = 'Srednje siva';
$string['colors:99CC00'] = 'Žuto zelena';
$string['colors:99CCFF'] = 'Svetlo nebo plava';
$string['colors:C0C0C0'] = 'Srebrna';
$string['colors:CC99FF'] = 'Tamnoljubičasta';
$string['colors:CCFFCC'] = 'Svijetlozelena';
$string['colors:CCFFFF'] = 'Svijetlo plavozelena';
$string['colors:FF0000'] = 'Crvena';
$string['colors:FF00FF'] = 'Ciklama crvena';
$string['colors:FF6600'] = 'Narandžasta';
$string['colors:FF9900'] = 'Tamnožuta (boja ćilibara)';
$string['colors:FF99CC'] = 'Ružičasta';
$string['colors:FFCC00'] = 'Zlatna';
$string['colors:FFCC99'] = 'Boja breskve';
$string['colors:FFFF00'] = 'Žuta';
$string['colors:FFFF99'] = 'Svijetložuta';
$string['colors:FFFFFF'] = 'Bijela';
$string['common:apply'] = 'Primjeni';
$string['common:browse'] = 'Pregled';
$string['common:cancel'] = 'Odustani';
$string['common:class_name'] = 'Klasa';
$string['common:clipboard_msg'] = 'Kopiraj/Isjeci/Nalijepi nije dostupno u Web pretraživačima Mozilla Firefoxu. Da li želite više informacija o ovom problemu?';
$string['common:clipboard_no_support'] = 'Trenutno nije podržano od strane vašeg Web pretraživača. Umjesto toga koristite prečice sa tastature.';
$string['common:close'] = 'Zatvori';
$string['common:edit_confirm'] = 'Želite li koristiti WYSIWYG način rada za ovo tekstualno polje?';
$string['common:insert'] = 'Umetni';
$string['common:invalid_data'] = 'Greška: Unesene su neispravne vrijednosti, označene su crveno';
$string['common:invalid_data_min'] = '{#field} mora biti broj veći od {#min}';
$string['common:invalid_data_number'] = '{#field} mora biti broj';
$string['common:invalid_data_size'] = '{#field} mora biti broj ili procenat';
$string['common:more_colors'] = 'Više boja';
$string['common:not_set'] = '-- Nije postavljeno --';
$string['common:popup_blocked'] = 'Žao nam je, ali primijetili smo da Vaš Web pretraživač blokira pop-up prozor koji pruža funkcionalnost aplikacije. Moraćete da isključite blokiranje pop-up prozora na ovom sajtu kako biste mogli u potpunosti da koristite ovu alatku.';
$string['common:update'] = 'Osvježi';
$string['common:value'] = '(vrijednost)';
$string['contextmenu:align'] = 'Poravnavanje';
$string['contextmenu:center'] = 'Sredina';
$string['contextmenu:full'] = 'Puno';
$string['contextmenu:left'] = 'Lijevo';
$string['contextmenu:right'] = 'Desno';
$string['customconfig'] = 'Prilagođena konfiguracija';
$string['customconfig_desc'] = 'Napredno prilagođavanje TinyMCE konfiguracije u JSON formatu, na primjer: {"option1" : "value2", "option2" : "value2"}. Bilo koja opcija specifirana ovdje zamjenjuje konfiguraciju standarda i dodatka.';
$string['customtoolbar'] = 'Uređivačka alatna traka';
$string['customtoolbar_desc'] = 'Svaka linija sadrži listu imena dugmića odvojenih zarezima, koristi "|" kao separator grupa, prazne linije su ignorirane. Pogledaj <a href="{$a}" target="_blank">{$a}</a> za listu zadatih TinyMCE dugmića.';
$string['directionality:ltr_desc'] = 'Smjer lijevo na desno';
$string['directionality:rtl_desc'] = 'Smjer desno na lijevo';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Plač';
$string['emotions_dlg:desc'] = 'Emocije';
$string['emotions_dlg:embarassed'] = 'Sramim se';
$string['emotions_dlg:foot_in_mouth'] = 'Izletjelo mu';
$string['emotions_dlg:frown'] = 'Mršti se';
$string['emotions_dlg:innocent'] = 'Nevinašce';
$string['emotions_dlg:kiss'] = 'Poljubac';
$string['emotions_dlg:laughing'] = 'Smijanje';
$string['emotions_dlg:money_mouth'] = 'Bogataš';
$string['emotions_dlg:sealed'] = 'Šuti kao zaliven';
$string['emotions_dlg:smile'] = 'Osmijeh';
$string['emotions_dlg:surprised'] = 'Iznenađen';
$string['emotions_dlg:title'] = 'Umetni emociju';
$string['emotions_dlg:tongue_out'] = 'Belji se';
$string['emotions_dlg:undecided'] = 'Neodlučan';
$string['emotions_dlg:usage'] = 'Koristi lijevu i desnu strelicu za upravljanje.';
$string['emotions_dlg:wink'] = 'Namigiva';
$string['emotions_dlg:yell'] = 'Viče';
$string['emotions:emotions_desc'] = 'Emocije';
$string['fontselectlist'] = 'Spisak dostupnih fontova';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Svojstva dokumenta';
$string['fullpage_dlg:active_color'] = 'Boja aktivne poveznice';
$string['fullpage_dlg:add'] = 'Dodaj novi element';
$string['fullpage_dlg:add_base'] = 'Osnovni element';
$string['fullpage_dlg:add_comment'] = 'Komentar';
$string['fullpage_dlg:add_link'] = 'Element poveznice';
$string['fullpage_dlg:add_meta'] = 'Meta elemenat';
$string['fullpage_dlg:add_script'] = 'Skriptni element';
$string['fullpage_dlg:add_style'] = 'Sitlski element';
$string['fullpage_dlg:add_title'] = 'Naslovni element';
$string['fullpage_dlg:advanced_props'] = 'Napredno';
$string['fullpage_dlg:advanced_tab'] = 'Napredno';
$string['fullpage_dlg:appearance_bgprops'] = 'Svojstva pozadine';
$string['fullpage_dlg:appearance_linkprops'] = 'Boja poveznica';
$string['fullpage_dlg:appearance_marginprops'] = 'Margina';
$string['fullpage_dlg:appearance_style'] = 'CSS i svojstva stila';
$string['fullpage_dlg:appearance_tab'] = 'Izgled';
$string['fullpage_dlg:appearance_textprops'] = 'Svojstva teksta';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Osnovni element';
$string['fullpage_dlg:bgcolor'] = 'Boja pozadine';
$string['fullpage_dlg:bgimage'] = 'Pozadinska slika';
$string['fullpage_dlg:bottom_margin'] = 'Donja margina';
$string['fullpage_dlg:charset'] = 'Šema kodiranja';
$string['fullpage_dlg:comment_element'] = 'Komentar';
$string['fullpage_dlg:content'] = 'Sadržaj';
$string['fullpage_dlg:copyright'] = 'Autorska prava';
$string['fullpage_dlg:defer'] = 'Odloži';
$string['fullpage_dlg:doctypes'] = 'Tip dokumenta';
$string['fullpage_dlg:encoding'] = 'Kodiranje znakova';
$string['fullpage_dlg:fontface'] = 'Skupina pisama';
$string['fullpage_dlg:font_face'] = 'Pismo';
$string['fullpage_dlg:fontsize'] = 'Veličina pisma';
$string['fullpage_dlg:font_size'] = 'Veličina pisma';
$string['fullpage_dlg:general_props'] = 'Opće';
$string['fullpage_dlg:head_elements'] = 'Zaglavni elementi';
$string['fullpage_dlg:hover_color'] = 'Boja poveznice ispod miša';
$string['fullpage_dlg:href'] = 'Href';
$string['fullpage_dlg:hreflang'] = 'Href lang';
$string['fullpage_dlg:info'] = 'Informacije';
$string['fullpage_dlg:langcode'] = 'Kod jezika';
$string['fullpage_dlg:langdir'] = 'Smjer jezika';
$string['fullpage_dlg:langprops'] = 'Jezik i kodiranje';
$string['fullpage_dlg:language'] = 'Jezik';
$string['fullpage_dlg:left_margin'] = 'Lijeva margina';
$string['fullpage_dlg:link_color'] = 'Boja poveznice';
$string['fullpage_dlg:link_element'] = 'Element poveznice';
$string['fullpage_dlg:ltr'] = 'S lijeva na desno';
$string['fullpage_dlg:media'] = 'Medij';
$string['fullpage_dlg:meta_description'] = 'Opis';
$string['fullpage_dlg:meta_element'] = 'Meta elemenat';
$string['fullpage_dlg:meta_index_follow'] = 'Indeksiraj i slijedi veze';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indeksiraj i nemoj slijediti veze';
$string['fullpage_dlg:meta_keywords'] = 'Ključne riječi';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ne indeksiraj ali slijedi veze';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Neindeksiraj i nemoj slijediti veze';
$string['fullpage_dlg:meta_props'] = 'Meta informacije';
$string['fullpage_dlg:meta_robots'] = 'Roboti';
$string['fullpage_dlg:meta_tab'] = 'Opće';
$string['fullpage_dlg:meta_title'] = 'Naslov';
$string['fullpage_dlg:movedown'] = 'Premjesti izabrani element dole';
$string['fullpage_dlg:moveup'] = 'Premjesti izabrani element gore';
$string['fullpage_dlg:name'] = 'Ime';
$string['fullpage_dlg:properties'] = 'Svojstva';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Ukloni odabrani element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Desna margina';
$string['fullpage_dlg:rtl'] = 'S desna na lijevo';
$string['fullpage_dlg:script_element'] = 'Skriptni element';
$string['fullpage_dlg:src'] = 'Izvor';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Stilski element';
$string['fullpage_dlg:stylesheet'] = 'CSS';
$string['fullpage_dlg:target'] = 'Meta';
$string['fullpage_dlg:textcolor'] = 'Boja';
$string['fullpage_dlg:text_color'] = 'Boja teksta';
$string['fullpage_dlg:title'] = 'Svojstva dokumenta';
$string['fullpage_dlg:title_element'] = 'Naslovni element';
$string['fullpage_dlg:top_margin'] = 'Gornja margina';
$string['fullpage_dlg:type'] = 'Tip';
$string['fullpage_dlg:value'] = 'Vrijednost';
$string['fullpage_dlg:visited_color'] = 'Boja posjećenog linka';
$string['fullpage_dlg:xml_pi'] = 'XML deklaracija';
$string['fullscreen:desc'] = 'Uključi/isključi prikaz preko cijelog ekrana';
$string['iespell:download'] = 'Provjera pravopisa nije postaljena. Postaviti sada?';
$string['iespell:iespell_desc'] = 'Pokreni provjeru pravopisa';
$string['insertdatetime:date_fmt'] = '%d.%m.%Y.';
$string['insertdatetime:day_long'] = 'Nedjelja,Ponedjeljak,Utorak,Srijeda,Četvrtak,Petak,Subota,Nedjelja';
$string['insertdatetime:day_short'] = 'Ned,Pon,Uto,Sri,Čet,Pet,Sub,Ned';
$string['insertdatetime:insertdate_desc'] = 'Umetni datum';
$string['insertdatetime:inserttime_desc'] = 'Ubaci vrijeme';
$string['insertdatetime:months_long'] = 'Januar,Februar,Mart,April,Maj,Juni,Juli,August,Septembar,Oktobar,Novembar,Decembar';
$string['insertdatetime:months_short'] = 'Jan,Feb,Mar,Apr,Maj,Jun,Jul,Avg,Sept,Okt,Nov,Dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Uključi/isključi apsolutno pozicioniranje';
$string['layer:backward_desc'] = 'Pomakni natrag';
$string['layer:content'] = 'Novi sloj...';
$string['layer:forward_desc'] = 'Idi unaprijed';
$string['layer:insertlayer_desc'] = 'Umetni novi sloj';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Ubaci/uredi ugrađenu multimediju';
$string['media_dlg:advanced'] = 'Napredno';
$string['media_dlg:align'] = 'Poravnaj';
$string['media_dlg:align_bottom'] = 'Dole';
$string['media_dlg:align_bottom_left'] = 'Dole lijevo';
$string['media_dlg:align_bottom_right'] = 'Dole desno';
$string['media_dlg:align_center'] = 'Sredina';
$string['media_dlg:align_left'] = 'Lijevo';
$string['media_dlg:align_right'] = 'Desno';
$string['media_dlg:align_top'] = 'Vrh';
$string['media_dlg:align_top_left'] = 'Gore lijevo';
$string['media_dlg:align_top_right'] = 'Gore desno';
$string['media_dlg:altsource1'] = 'Alternativni izvor 1';
$string['media_dlg:altsource2'] = 'Alternativni izvor 2';
$string['media_dlg:autogotourl'] = 'Automatski prelazak na URL adresu';
$string['media_dlg:autohref'] = 'AutoHREF';
$string['media_dlg:autostart'] = 'Automatsko pokretanje';
$string['media_dlg:balance'] = 'Balans';
$string['media_dlg:base'] = 'Osnova';
$string['media_dlg:baseurl'] = 'Osnovni URL';
$string['media_dlg:bgcolor'] = 'Pozadina';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'ID naslova';
$string['media_dlg:center'] = 'Sredina';
$string['media_dlg:class_name'] = 'Klasa';
$string['media_dlg:console'] = 'Konzola';
$string['media_dlg:constrain_proportions'] = 'Zadrži proporcije';
$string['media_dlg:controller'] = 'Kontrolor';
$string['media_dlg:controls'] = 'Kontrole';
$string['media_dlg:correction'] = 'Bez korekcije';
$string['media_dlg:currentmarker'] = 'Trenutna oznaka';
$string['media_dlg:currentposition'] = 'Trenutna pozicija';
$string['media_dlg:defaultframe'] = 'Zadani okvir';
$string['media_dlg:embeddedaudio'] = 'Ugrađen audio';
$string['media_dlg:embedded_audio_options'] = 'Opcije ugrađenog audio zapisa';
$string['media_dlg:enabled'] = 'Omogućeno';
$string['media_dlg:enablejavascript'] = 'Omogući JavaScript';
$string['media_dlg:endtime'] = 'Vrijeme završetka';
$string['media_dlg:file'] = 'Datoteka/URL';
$string['media_dlg:flash_options'] = 'Opcije za Flash';
$string['media_dlg:flashvars'] = 'Flash promjenljive';
$string['media_dlg:fullscreen'] = 'Cijeli ekran';
$string['media_dlg:general'] = 'Opće';
$string['media_dlg:hidden'] = 'Skriveno';
$string['media_dlg:href'] = 'Href';
$string['media_dlg:hspace'] = 'Prostor po horizontali';
$string['media_dlg:html5_audio_options'] = 'Audio opcije';
$string['media_dlg:html5_video_options'] = 'HTML5 video opcije';
$string['media_dlg:id'] = 'ID broj';
$string['media_dlg:imagestatus'] = 'Status slike';
$string['media_dlg:invokeurls'] = 'Učitaj URL-ove';
$string['media_dlg:kioskmode'] = 'Kiosk režim';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Petlja';
$string['media_dlg:maintainaspect'] = 'Sačuvaj odnos širine i visine';
$string['media_dlg:menu'] = 'Prikaži meni';
$string['media_dlg:mute'] = 'Isključi zvuk';
$string['media_dlg:name'] = 'Naziv';
$string['media_dlg:nojava'] = 'Bez Java apleta';
$string['media_dlg:numloop'] = 'Broj petlji';
$string['media_dlg:play'] = 'Automatska reprodukcija';
$string['media_dlg:playcount'] = 'Broj ponavljanja';
$string['media_dlg:playeveryframe'] = 'Prikaži svaki kadar';
$string['media_dlg:prefetch'] = 'Prethodno preuzimanje';
$string['media_dlg:preload'] = 'Učitaj prije početka';
$string['media_dlg:preload_auto'] = 'Dopusti korisniku browsera da odluči';
$string['media_dlg:preload_metadata'] = 'Učitaj video metadatu prije početka';
$string['media_dlg:preload_none'] = 'Ne učitavaj prije početka';
$string['media_dlg:preview'] = 'Pregled';
$string['media_dlg:progress'] = 'Napredak';
$string['media_dlg:qt_options'] = 'Quicktime options';
$string['media_dlg:qtsrc'] = 'QT Src';
$string['media_dlg:qtsrcchokespeed'] = 'Brzina učitavanja';
$string['media_dlg:qt_stream_warn'] = 'Rtsp izvori za reproduciranje u realnom vremenu (striming) bi trebalo dodati u QT Src polje kartice \'Napredno\'. Također bi trebalo da dodate i nestrimovanu verziju u \'Src\' polje..';
$string['media_dlg:quality'] = 'Kvalitet';
$string['media_dlg:rate'] = 'Prosječna brzina';
$string['media_dlg:rmp_options'] = 'Opcije za Real media player';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Scale';
$string['media_dlg:scriptcallbacks'] = 'Skripte povratnog poziva';
$string['media_dlg:shockwave_options'] = 'Opcije za Shockwave';
$string['media_dlg:shuffle'] = 'Izmiješaj';
$string['media_dlg:size'] = 'Dimenzije';
$string['media_dlg:sound'] = 'Zvuk';
$string['media_dlg:source'] = 'Izvor';
$string['media_dlg:starttime'] = 'Vrijeme početka';
$string['media_dlg:stretchtofit'] = 'Razvuci da se uklopi';
$string['media_dlg:swstretchhalign'] = 'Razvuci horizontalno poravnanje';
$string['media_dlg:swstretchstyle'] = 'Način razvlačenja';
$string['media_dlg:swstretchvalign'] = 'Razvuci vertikalno poravnanje';
$string['media_dlg:target'] = 'Cilj';
$string['media_dlg:targetcache'] = 'Odabrani cache';
$string['media_dlg:title'] = 'Ubaci/uredi ugrađenu multimediju';
$string['media_dlg:type'] = 'Tip';
$string['media_dlg:uimode'] = 'Režim korisničkog interfejsa';
$string['media_dlg:volume'] = 'Jačina zvuka';
$string['media_dlg:vspace'] = 'Prostor po vertikali';
$string['media_dlg:windowlessvideo'] = 'Video bez prozora';
$string['media_dlg:wmode'] = 'WRežim';
$string['media_dlg:wmp_options'] = 'Opcije za Windows Media Player';
$string['media:edit'] = 'Uredi ugrađenu multimediju';
$string['nonbreaking:nonbreaking_desc'] = 'Umetni razmak';
$string['pagebreak:desc'] = 'Umetni prijelom.';
$string['paste_dlg:text_linebreaks'] = 'Zadrži prelome redova';
$string['paste_dlg:text_title'] = 'Upotrijebite kombinaciju tastera CTRL+V da biste nalijepili tekst u prozor';
$string['paste_dlg:word_title'] = 'Upotrijebite kombinaciju tastera CTRL+V da biste nalijepili tekst u prozor';
$string['paste:paste_text_desc'] = 'Zalijepi kao obični tekst';
$string['paste:paste_word_desc'] = 'Zalijepi iz Worda';
$string['paste:plaintext_mode'] = 'Komanda \'Nalijepi\' je trenutno u režimu običnog teksta. Kliknite ponovo kako biste se vratili u normalni režim.';
$string['paste:selectall_desc'] = 'Odaberi sve';
$string['pluginname'] = 'TinyMCE HTML editor';
$string['preview:preview_desc'] = 'Prikaz';
$string['print:print_desc'] = 'Printaj';
$string['save:cancel_desc'] = 'Otkaži sve promjene';
$string['save:save_desc'] = 'Spremi';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'Sva pojavljivanja traženog izraza biće zamijenjena';
$string['searchreplace_dlg:direction'] = 'Smjer';
$string['searchreplace_dlg:down'] = 'Dolje';
$string['searchreplace_dlg:findnext'] = 'Pronađi sljedeće';
$string['searchreplace_dlg:findwhat'] = 'Pronađi tekst';
$string['searchreplace_dlg:mcase'] = 'Pazi na VELIKA i mala slova';
$string['searchreplace_dlg:notfound'] = 'Pretraživanje je završeno. Traženi izraz nije mogao biti pronađen.';
$string['searchreplace_dlg:replace'] = 'Zamijeni';
$string['searchreplace_dlg:replaceall'] = 'Zamijeni sve';
$string['searchreplace_dlg:replace_title'] = 'Nađi/Zamijeni';
$string['searchreplace_dlg:replacewith'] = 'Zamijeni sa';
$string['searchreplace_dlg:searchnext_desc'] = 'Pronađi opet';
$string['searchreplace_dlg:search_title'] = 'Pronađi';
$string['searchreplace_dlg:up'] = 'Gore';
$string['searchreplace:replace_desc'] = 'Pronađi/Zamijeni';
$string['searchreplace:search_desc'] = 'Pronađi';
$string['settings'] = 'Opće postavke';
$string['simple:bold_desc'] = 'Boldirano (Ctrl+B)';
$string['simple:bullist_desc'] = 'Neuređena lista';
$string['simple:cleanup_desc'] = 'Očisti neuređeni kod';
$string['simple:italic_desc'] = 'Italic (Ctrl+I)';
$string['simple:numlist_desc'] = 'Uređena lista';
$string['simple:redo_desc'] = 'Ponovi posljednju akciju (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Precrtaj';
$string['simple:underline_desc'] = 'Podcrtaj (Ctrl+U)';
$string['simple:undo_desc'] = 'Poništi posljednju akciju (Ctrl+Z)';
$string['spellchecker:desc'] = 'Uključi/Isključi provjeru pravopisa';
$string['spellchecker:ignore_word'] = 'Ignoriši riječ';
$string['spellchecker:ignore_words'] = 'Zanemari sver';
$string['spellchecker:langs'] = 'Jezici';
$string['spellchecker:learn_word'] = 'Nauči riječ';
$string['spellchecker:menu'] = 'Podešavanje provjere pravopisa';
$string['spellchecker:no_mpell'] = 'Nije pronađena nijedna pravopisna greške.';
$string['spellchecker:no_sug'] = 'Nema prijedloga';
$string['spellchecker:sug'] = 'Prijedlozi';
$string['spellchecker:wait'] = 'Pričekajte...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Uredi CSS';
$string['style_dlg:apply'] = 'Primjeni';
$string['style_dlg:background'] = 'Pozadina';
$string['style_dlg:background_attachment'] = 'Prilog';
$string['style_dlg:background_color'] = 'Boja pozadine';
$string['style_dlg:background_hpos'] = 'Horizontalni položaj';
$string['style_dlg:background_image'] = 'Slika pozadine';
$string['style_dlg:background_repeat'] = 'Ponovi';
$string['style_dlg:background_tab'] = 'Pozadina';
$string['style_dlg:background_vpos'] = 'Vertikalni položaj';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Prikaži';
$string['style_dlg:block_letterspacing'] = 'Razmak između slova';
$string['style_dlg:block_tab'] = 'Blok';
$string['style_dlg:block_text_align'] = 'Poravnanje teksta';
$string['style_dlg:block_text_indent'] = 'Uvlačenje teksta';
$string['style_dlg:block_vertical_alignment'] = 'Vertikalno poravnanje';
$string['style_dlg:block_whitespace'] = 'Bjeli prostor';
$string['style_dlg:block_wordspacing'] = 'Razmak između riječi';
$string['style_dlg:border'] = 'Ivica';
$string['style_dlg:border_tab'] = 'Ivica';
$string['style_dlg:bottom'] = 'Dolje';
$string['style_dlg:box'] = 'Boks';
$string['style_dlg:box_clear'] = 'Očisti';
$string['style_dlg:box_float'] = 'Realan broj';
$string['style_dlg:box_height'] = 'Visina';
$string['style_dlg:box_tab'] = 'BoxC';
$string['style_dlg:box_width'] = 'Širina';
$string['style_dlg:bullet_image'] = 'Slika oznake za nabrajanje';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Boja';
$string['style_dlg:height'] = 'Visina';
$string['style_dlg:left'] = 'Lijevo';
$string['style_dlg:list'] = 'Lista';
$string['style_dlg:list_tab'] = 'Lista';
$string['style_dlg:list_type'] = 'Vrsta';
$string['style_dlg:margin'] = 'Margina';
$string['style_dlg:overflow'] = 'Prekoračenje';
$string['style_dlg:padding'] = 'Udaljenost od ivice';
$string['style_dlg:placement'] = 'Placement';
$string['style_dlg:position'] = 'Pozicija';
$string['style_dlg:positioning_tab'] = 'Pozicioniranje';
$string['style_dlg:positioning_type'] = 'Vrsta';
$string['style_dlg:right'] = 'Desno';
$string['style_dlg:same'] = 'Za sve isto';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text'] = 'Tekst';
$string['style_dlg:text_blink'] = 'Blink';
$string['style_dlg:text_case'] = 'VELIKA i mala slova';
$string['style_dlg:text_color'] = 'Boja';
$string['style_dlg:text_decoration'] = 'Dekoracija';
$string['style_dlg:text_font'] = 'Font';
$string['style_dlg:text_lineheight'] = 'Visina linije';
$string['style_dlg:text_none'] = 'Ništa';
$string['style_dlg:text_overline'] = 'Nadvučeno';
$string['style_dlg:text_props'] = 'Tekst';
$string['style_dlg:text_size'] = 'Veličina';
$string['style_dlg:text_striketrough'] = 'Precrtano';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Tekst';
$string['style_dlg:text_underline'] = 'Podvučeno';
$string['style_dlg:text_variant'] = 'Varijanta';
$string['style_dlg:text_weight'] = 'Debljina';
$string['style_dlg:title'] = 'Uredi CSS stil';
$string['style_dlg:toggle_insert_span'] = 'Ubaci razmak u izborniku';
$string['style_dlg:top'] = 'Gore';
$string['style_dlg:visibility'] = 'Vidljivost';
$string['style_dlg:width'] = 'Širina';
$string['style_dlg:zindex'] = 'Z-indeks';
$string['subplugintype_tinymce_plural'] = 'Dodaci';
$string['table:cell'] = 'Ćelija';
$string['table:cell_desc'] = 'Svojstva ćelije';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Stupac';
$string['table:col_after_desc'] = 'Ubaci kolonu poslije';
$string['table:col_before_desc'] = 'Ubaci kolonu prije';
$string['table:copy_row_desc'] = 'Kopiraj redak';
$string['table:cut_row_desc'] = 'Isjeci red';
$string['table:del'] = 'Izbriši tablicu';
$string['table:delete_col_desc'] = 'Ukloni stupac';
$string['table:delete_row_desc'] = 'Izbriši redak';
$string['table:desc'] = 'Nova tablica';
$string['table_dlg:advanced_props'] = 'Napredna svojstva';
$string['table_dlg:advanced_tab'] = 'Napredno';
$string['table_dlg:align'] = 'Poravnavanje';
$string['table_dlg:align_bottom'] = 'Dole';
$string['table_dlg:align_default'] = 'Zadano';
$string['table_dlg:align_left'] = 'Lijevo';
$string['table_dlg:align_middle'] = 'Sredina';
$string['table_dlg:align_right'] = 'Desno';
$string['table_dlg:align_top'] = 'Vrh';
$string['table_dlg:bgcolor'] = 'Boja pozadine';
$string['table_dlg:bgimage'] = 'Slika pozadine';
$string['table_dlg:border'] = 'Obrub';
$string['table_dlg:bordercolor'] = 'Boja obruba';
$string['table_dlg:caption'] = 'Opis tablice';
$string['table_dlg:cell_all'] = 'Primjeni na sve ćelije u tablici';
$string['table_dlg:cell_cell'] = 'Primjeni na odabranu ćeliju';
$string['table_dlg:cell_col'] = 'Ažuriraj sve ćelije u koloni';
$string['table_dlg:cell_limit'] = 'Premašili ste maksimalni broj ćelija ({$cells}).';
$string['table_dlg:cellpadding'] = 'Dopuna ćelije';
$string['table_dlg:cell_row'] = 'Primjeni na sve ćelije u retku';
$string['table_dlg:cellspacing'] = 'Razmak ćelija';
$string['table_dlg:cell_title'] = 'Svojstva ćelije';
$string['table_dlg:cell_type'] = 'Tip ćelije';
$string['table_dlg:colgroup'] = 'Grupa stupaca';
$string['table_dlg:col_limit'] = 'Premašili ste maksimalni broj stupaca ({$cols}).';
$string['table_dlg:cols'] = 'Stupaca';
$string['table_dlg:frame'] = 'Okvir';
$string['table_dlg:frame_all'] = 'sve';
$string['table_dlg:frame_cols'] = 'kolone';
$string['table_dlg:frame_groups'] = 'grupe';
$string['table_dlg:frame_none'] = 'ništa';
$string['table_dlg:frame_rows'] = 'redovi';
$string['table_dlg:general_props'] = 'Opća svojstva';
$string['table_dlg:general_tab'] = 'Opće';
$string['table_dlg:height'] = 'Visina';
$string['table_dlg:id'] = 'ID broj';
$string['table_dlg:langcode'] = 'Kod jezika';
$string['table_dlg:langdir'] = 'Smjer jezika';
$string['table_dlg:ltr'] = 'S lijeva na desno';
$string['table_dlg:merge_cells_title'] = 'Spoji ćelije';
$string['table_dlg:mime'] = 'MIME tip';
$string['table_dlg:missing_scope'] = 'Da li ste sigurni da želite da nastavite bez određivanja obima naslovne ćelije ove tabele. Bez toga, nekim korisnicima sa invaliditetom može biti teško da razumiju sadržaj ili podatke prikazane u tabeli.';
$string['table_dlg:row_all'] = 'Primjeni na sve retke u tablici';
$string['table_dlg:row_even'] = 'Primjeni na parne retke u tablici';
$string['table_dlg:rowgroup'] = 'Grupa redaka';
$string['table_dlg:row_limit'] = 'Premašili ste maksimalni broj redaka ({$rows}).';
$string['table_dlg:row_odd'] = 'Primjeni na neparne retke u tablici';
$string['table_dlg:row_row'] = 'Primjeni na odabrani redak';
$string['table_dlg:rows'] = 'Redaka';
$string['table_dlg:row_title'] = 'Svojstva retka';
$string['table_dlg:rowtype'] = 'Red u dijelu tabele';
$string['table_dlg:rtl'] = 'Sa desna na lijevo';
$string['table_dlg:rules'] = 'Pravila';
$string['table_dlg:rules_above'] = 'iznad';
$string['table_dlg:rules_below'] = 'ispod';
$string['table_dlg:rules_border'] = 'granica';
$string['table_dlg:rules_box'] = 'Box';
$string['table_dlg:rules_hsides'] = 'Gore i dole';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'ni sa jedne strane';
$string['table_dlg:rules_vsides'] = 'Lijevo i desno';
$string['table_dlg:scope'] = 'Obim';
$string['table_dlg:style'] = 'Stil';
$string['table_dlg:summary'] = 'Sažetak';
$string['table_dlg:tbody'] = 'Tijelo tabele';
$string['table_dlg:td'] = 'Podatkovna';
$string['table_dlg:tfoot'] = 'Podnožje tablice';
$string['table_dlg:th'] = 'Zaglavlje';
$string['table_dlg:thead'] = 'Zaglavlje tablice';
$string['table_dlg:title'] = 'Ubaci/Izmijeni tabelu';
$string['table_dlg:valign'] = 'Okomito poravnavanje';
$string['table_dlg:width'] = 'Širina';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Spoji ćelije';
$string['table:paste_row_after_desc'] = 'Nalijepi red poslije';
$string['table:paste_row_before_desc'] = 'Nalijepi red poslije';
$string['table:props_desc'] = 'Svojstva tablice';
$string['table:row'] = 'Redak';
$string['table:row_after_desc'] = 'Ubaci red poslije';
$string['table:row_before_desc'] = 'Ubaci red prije';
$string['table:row_desc'] = 'Svojstva retka';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Razdvoji spojene ćelije';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Ubaci predefinisani šablon sadržaja';
$string['template_dlg:cdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'Nedjelja,Ponedjeljak,Utorak,Srijeda,Četvrtak,Petak,Subota,Nedjelja';
$string['template_dlg:day_short'] = 'Ned,Pon,Uto,Sri,Čet,Pet,Sub,Ned';
$string['template_dlg:desc'] = 'Umetni sadržaj predloška';
$string['template_dlg:desc_label'] = 'Opis';
$string['template_dlg:label'] = 'Predložak';
$string['template_dlg:mdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Januar,Februar,Mart,April,Maj,Juni,Juli,August,Septembar,Oktobar,Novembar,Decembar';
$string['template_dlg:months_short'] = 'Jan,Feb,Ma,Apr,Maj,Jun,Jul,Aug,Sep,Okt,Nov,Dec';
$string['template_dlg:preview'] = 'Prikaz';
$string['template_dlg:select'] = 'Odaberite predložak';
$string['template_dlg:title'] = 'Predlošci';
$string['template_dlg:warning'] = 'Upozorenje: Ažuriranje jednog šablona sa drugim može dovesti do gubitka podataka.';
$string['visualblocks:desc'] = 'Prikaži/sakri elemente bloka';
$string['visualchars:desc'] = 'Vizualni kontrolni znakovi uključeni/isključeni.';
$string['wordcount:words'] = 'Riječi:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Kratica';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronim';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Umetni/uredi atribute';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Brisanje';
$string['xhtmlxtras_dlg:attribs_title'] = 'Umetni/uredi atribute';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributi';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributi';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Događaji';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'AccessKey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasa';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/Vrijeme';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID broj';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Jezik';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Smjer teksta';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Naslov';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Sa lijeva na desno';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Sa desna na lijevo';
$string['xhtmlxtras_dlg:events_tab'] = 'Događaji';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atributi elemenata';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Događaji elemenata';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Opća postavke';
$string['xhtmlxtras_dlg:general_tab'] = 'Opće';
$string['xhtmlxtras_dlg:insert_date'] = 'Ubaci tekući datum/vrijeme';
$string['xhtmlxtras_dlg:option_ltr'] = 'Sa lijeva na desno';
$string['xhtmlxtras_dlg:option_rtl'] = 'Sa desna na lijevo';
$string['xhtmlxtras_dlg:remove'] = 'Ukloni';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Element kratice';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Element akronima';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Element citata';
$string['xhtmlxtras_dlg:title_del_element'] = 'Element za brisanje';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Element za unos';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Unos';
