<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   auth_ldap
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Nije moguće kreirati novi račun u Aktivnom direktoriju. Provjerite da li su ispunjeni svi neophodni preduslovi (LDAP konekcija, vezani korisnici sa odgovarajućim pravima itd.)';
$string['auth_ldap_attrcreators'] = 'Spisak grupa ili konteksta čijim članovima je dozvonjeno da kreiraju atribute. Razdvojite višestruke grupe sa \';\'. Obično nešto poput \'cn=teachers,ou=staff,o=myorg';
$string['auth_ldap_attrcreators_key'] = 'Kreatori atributa';
$string['auth_ldap_auth_user_create_key'] = 'Kreiraj korisnike eksterno';
$string['auth_ldap_bind_dn'] = 'Ako želite da koristite veznog korisnika za pretragu korisnika, odredite to ovdje. Nešto nalik na \'cn=ldapuser,ou=public,o=org';
$string['auth_ldap_bind_dn_key'] = 'Jedinstveno prepoznatljivo ime';
$string['auth_ldap_bind_pw'] = 'Lozinka za vezanog korisnika';
$string['auth_ldap_bind_pw_key'] = 'Lozinka';
$string['auth_ldap_bind_settings'] = 'Podešavanja za vezivanje';
$string['auth_ldap_changepasswordurl_key'] = 'URL za promjenu lozinke';
$string['auth_ldap_contexts'] = 'Spisak konteksta u kojima se nalaze korisnici. Razdvojite različite kontekste sa \';\'. Na primjer: \'ou=users,o=org; ou=others,o=org';
$string['auth_ldap_contexts_key'] = 'Konteksti';
$string['auth_ldap_create_context'] = 'Ukoliko omogućite kreiranje korisnika pomoću potvrde putem e-mail adrese, navedite kontekst u kojem će korisnici biti kreirani. Ovaj kontekst treba da bude različit od drugih korisnika kako bi se spriječili sigurnosni problemi. Ne morate da dodajete ovaj kontekst ldap_context vraijabli. Moodle će tražiti korisnike iz ovog konteksta automatski.<br /><b>Napomena!</b> Morate da izmijenite metod user_create() u datoteci auth/ldap/auth.php kako bi ovaj način kreiranja korisnika funckionirao.';
$string['auth_ldap_create_context_key'] = 'Kontekst za nove korisnike';
$string['auth_ldap_create_error'] = 'Greška prilikom kreiranja novog  korisnika u LDAP serveru.';
$string['auth_ldap_creators'] = 'Spisak grupa ili konteksta čijim članovima je dozvoljeno da kreiraju nove kurseve. Razdvojite višestruke grupe sa \';\'. Obično nešto poput \'cn=teachers,ou=staff,o=myorg';
$string['auth_ldap_creators_key'] = 'Kreatori';
$string['auth_ldapdescription'] = 'Ovaj metod služi za provjeru identiteta od strane vanjskog LDAP servera. Ako su dodjeljeno korisničko ime i lozinka ispravni, Moodle kreira novu instancu korisnika u svojoj bazi podataka. Ovaj modul može da čita korisničke atribute sa LDAP-a i ispuni tražena polja u Moodleu. Prilikom narednih prijava na sistem provjeravaće se samo korisničko ime i lozinka.';
$string['auth_ldap_expiration_desc'] = 'Izaberite "Ne" da biste onemogućili provjeru isticanja lozinke ili da LDAP čita vrijeme isticanja lozinke direktno iz LDAP-a.';
$string['auth_ldap_expiration_key'] = 'Istek lozinke';
$string['auth_ldap_expiration_warning_desc'] = 'Koliko dana prije isteka lozinke će biti izdato upozorenje o tome.';
$string['auth_ldap_expiration_warning_key'] = 'Upozorenje o isteku lozinke';
$string['auth_ldap_expireattr_desc'] = 'Opciono: izmijenite ldap-atribut koji pohranjuje vrijeme isteka lozinke';
$string['auth_ldap_expireattr_key'] = 'Atribut isteka lozinke';
$string['auth_ldapextrafields'] = 'Ova polja nisu obavezna. Možete izabrati da ispunite neka Moodle korisnička polja sa informacijama iz <b>LDAP polja</b> koja ovdje odredite. <br />Ako polja ostavite prazna, onda se ništa neće prebaciti sa LDAP-a, tako da će biti korištene zadane Moodle vrijednosti.<br />U svakom slučaju, korisnici mogu da uređuju ova polja nakon pristupa sistemu.';
$string['auth_ldap_graceattr_desc'] = 'Opciono: Zaobiđite odgodu unosa atributa';
$string['auth_ldap_gracelogin_key'] = 'Atribut odložene prijave';
$string['auth_ldap_gracelogins_desc'] = 'Omogućite LDAP podršku za odgodu unosa. Nakom isteka lozinke korisnik može pristupati sistemu sve dok je iznos odgode unosa 0. Ako je lozinka istekla omogućite ova podešavanja za prikazivanje poruke odgode unosa.';
$string['auth_ldap_gracelogins_key'] = 'Odložene prijave';
$string['auth_ldap_groupecreators'] = 'Spisak grupa ili konteksta čijim članovima je dozvonjeno kreiranje grupa. Razdvojite višestruke grupe sa \';\'. Obično, nešto poput \'cn=teachers,ou=staff,o=myorg';
$string['auth_ldap_groupecreators_key'] = 'Kreatori grupa';
$string['auth_ldap_host_url'] = 'Navedite LDAP server u obliku URL adrese, kao npr. \'ldap://ldap.myorg.com/\' ili \'ldaps://ldap.myorg.com/\' Razdvojite multiple servere sa \';\' kako biste mogli da osigurate automatsko prebacivanje na drugi server ukoliko bude problem sa aktivnim serverom.';
$string['auth_ldap_host_url_key'] = 'URL LDAP računara';
$string['auth_ldap_ldap_encoding'] = 'Navedite kodni raspored koji će koristiti LDAP server. Najvjerovatnije utf-8. MS AD v2 koristi zadani kodni raspored platforme kao što je cp1252, cp1250 itd.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP kodni raspored';
$string['auth_ldap_login_settings'] = 'Podešavanja za prijavljivanje na sistem';
$string['auth_ldap_memberattribute'] = 'Opcionalno: Presnimiti atribut korisničkog člana, kada korisnik pripada grupi. Obično kao "član".';
$string['auth_ldap_memberattribute_isdn'] = 'Opciono: Redefinira rukovanje vrijednostima atributa članova, ili 0 ili 1';
$string['auth_ldap_memberattribute_isdn_key'] = 'Atribut člana koristi dn';
$string['auth_ldap_memberattribute_key'] = 'Atributi člana';
$string['auth_ldap_noconnect'] = 'LDAP-modul nije moguće povezati sa  serverom: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-modul nije moguće povezati sa bilo kojim serverom: {$a}';
$string['auth_ldap_noextension'] = '<em>Izgleda da PHP LDAP modul nije prisutan. Molimo, provjerite da li je modul instaliran i omogućen, ako želite da ga koristite kao dodatak za provjeru identiteta.</em>';
$string['auth_ldap_no_mbstring'] = 'Da biste kreirali korisnike u Aktivnom direktoriju potrebna Vam je mbstring ekstenzija.';
$string['auth_ldapnotinstalled'] = 'Nije moguće koristiti LDAP provjeru identiteta. PHP LDAP modul nije instaliran.';
$string['auth_ldap_objectclass'] = 'Opciono: Određuje objectClass koristeći ime/tražeći korisnika na ldap_user_type. Obično nema potrebe da ovo mjenjate.';
$string['auth_ldap_objectclass_key'] = 'Klase objekata';
$string['auth_ldap_opt_deref'] = 'Ustanovite kako upravljati usvojenim imenima u toku traženja. Izaberite jednu od pratećih vrijednosti: "Ne" (LDAP_DEREF_NEVER) ili "Da" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Opozovi usvojena imena';
$string['auth_ldap_passtype'] = 'Navedite format novih ili promijenjenih lozinki na LDAP serveru.';
$string['auth_ldap_passtype_key'] = 'Format lozinke';
$string['auth_ldap_passwdexpire_settings'] = 'Podešavanja LDAP isteka lozinke';
$string['auth_ldap_preventpassindb'] = 'Izaberite "Da" kako bi spriječili da se lozinke pohranjuju u bazi podataka Moodle-a.';
$string['auth_ldap_preventpassindb_key'] = 'Sakrij lozinke';
$string['auth_ldap_search_sub'] = 'Pretraži korisnike iz podkonteksta.';
$string['auth_ldap_search_sub_key'] = 'Pretraži podkontekst';
$string['auth_ldap_server_settings'] = 'Podešavanja LDAP servera';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() ne podržava izabrani tip korisnika: {$a}';
$string['auth_ldap_update_userinfo'] = 'Ažurirajte informacije korisnika (ime, prezime, adrese...) iz LDAP-a u Moodle. Specificirajte podešavanja za mapiranje podataka prema vlastitim potrebama.';
$string['auth_ldap_user_attribute'] = 'Atribut koji se koristi za ime/pretragu korisnika. Uglavnom je \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'Atributi korisnika';
$string['auth_ldap_user_exists'] = 'LDAP korisničko ime već postoji.';
$string['auth_ldap_user_settings'] = 'Podešavanja za pretraživanje korisnika';
$string['auth_ldap_user_type'] = 'Izaberite kako se korisnik čuva u LDAP-u. Ovo podešavanje također određuje kako će funkcionirati istek upisa, poček unosa i kreiranje korisnika.';
$string['auth_ldap_user_type_key'] = 'Tip korisnika';
$string['auth_ldap_usertypeundefined'] = 'config.user_type nije definiran ili funkcija ldap_expirationtime2unix ne podržava izabrani tip!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type nije definiran ili funkcija ldap_unixi2expirationtime ne podržava izabrani tip!';
$string['auth_ldap_version'] = 'Verzija LDAP protokola koju koristi Vaš server';
$string['auth_ldap_version_key'] = 'Verzija';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'Postavite na "Da" za pokušaj jedne prijave sa NTLM domenom. <strong>Napomena:</strong> da bi ovo radilo, zahtijevaju se dodatna podešavanja Web-servera, vidjeti <a href="http://docs.moodle.org/en/NTLM_authentication">http://docs.moodle.org/en/NTLM_authentication</a>';
$string['auth_ntlmsso_enabled_key'] = 'Omogući';
$string['auth_ntlmsso_ie_fastpath'] = 'Postavite na "Da" kako biste omogućili NTLM SSO fast path (zaobilazi određene korake i radi samo ako je Web pretraživač klijenta MS Internet Explorer).';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE brza putanja?';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Nemoguće izvući korisničko ime iz zaglavlja REMOTE_USER. Da li je format konfiguracije ispravan?';
$string['auth_ntlmsso_subnet'] = 'Ukoliko je podešeno, biće pokušana SSO konekcija samo sa klijentima u ovoj podmreži. Format: xxx.xxx.xxx.xxx/bitmask. Više podmreža razdvojite \',\' (zarezom).';
$string['auth_ntlmsso_subnet_key'] = 'Podmreža';
$string['auth_ntlmsso_type'] = 'Metod provjere identiteta konfiguriran na Web serveru za provjeru identiteta korisnika (ako ste u dilemi, izaberite NTUM)';
$string['auth_ntlmsso_type_key'] = 'Tip provjere identiteta';
$string['connectingldap'] = 'Povezivanje sa LDAP serverom...';
$string['creatingtemptable'] = 'Kreiranje privremene tabele {$a}';
$string['didntfindexpiretime'] = 'Funkcija password_expire() nije pronašla vrijeme isteka';
$string['didntgetusersfromldap'] = 'Nije dobijen nijedan korisnik sa LDAP-a -- greška? -- izlaz';
$string['gotcountrecordsfromldap'] = 'Broj zapisa dobijen sa LDAP-a: {$}';
$string['morethanoneuser'] = 'Neobično! Pronađeno je više od jednog korisnika na LDAP-u. Koristi se samo prvi.';
$string['needbcmath'] = 'Potrebna vam je BCMath ekstenzija kako biste mogli da koristite grace prijavljivanje (grace logins) sa аktivnim direktorijem (Active Directory)';
$string['needmbstring'] = 'Za promenu lozinke u аktivnom direktoriju, potrebna Vam je mbstring ekstenzija';
$string['nodnforusername'] = 'Greška u user_update_password(). Nema DN za: {$a->username}';
$string['noemail'] = 'Pokušaj da Vam se pošalje e-mail poruka nije uspio!';
$string['notcalledfromserver'] = 'Ne bi trebalo da bude pozivano sa Web servera!';
$string['noupdatestobedone'] = 'Nema ažuriranja koje treba obaviti';
$string['nouserentriestoremove'] = 'Nema korisničkih računa koje treba ukloniti';
$string['nouserentriestorevive'] = 'Nema korisničkih računa koje treba ponovo aktivirati';
$string['nouserstobeadded'] = 'Nijedan korisnik nije dodan';
$string['ntlmsso_attempting'] = 'Pokušava Single Sign On preko NTLM...';
$string['ntlmsso_failed'] = 'Automatska prijava na sistem nije uspjela. Pokušajte sa normalnom stranicom za prijavu...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO je onemogućen.';
$string['ntlmsso_unknowntype'] = 'Nepoznati ntlmsso tip!';
$string['pagedresultsnotsupp'] = 'LDAP traženi rezultati nisu podržani (ili ih vaša PHP verzija ne podržava ili ste konfigurisali Moodle da koristi LDAP protokol - verziju 2)';
$string['pagesize'] = 'Pobrinite se da je ova vrijednost manja od ograničenja veličini rezultata vašeg LDAP servera (maksimalni broj unosa koji se mogu dobiti jednim upitom)';
$string['pagesize_key'] = 'Veličina stranice';
$string['pluginname'] = 'LDAP server';
$string['pluginnotenabled'] = 'Dodatak nije omogućen!';
$string['renamingnotallowed'] = 'Promjena imena korisnika nije dozvoljena na LDAP-u';
$string['rootdseerror'] = 'Greška pri slanju upita rootDSE za aktivni direktorij';
$string['updatepasserror'] = 'Greška u user_update_password(). Kôd greške: {$a->errno}; Tekst greške: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Greška u user_update_password() prilikom čitanja vremena isteka lozinke. Kôd greške: {$a->errno}; Tekst greške: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Greška u user_update_password() prilikom promjene expirationtime i/ili gracelogins. Kôd greške: {$a->errno}; Tekst greške: {$a->errstring}';
$string['updateremfail'] = 'Greška prilikom ažuriranja LDAP zapisa. Kôd greške: {$a->errno}; Tekst greške: {$a->errstring}<br/>Ključ ({$a->key}) - stara moodle vrijednost: \'{$a->ouvalue}\' nova vrijednost: \'{$a->nuvalue}';
$string['updateremfailamb'] = 'Nije uspjelo ažuriranje LDAP-a sa dvosmislenim poljem {$a->key}; stara moodle vrijednost: \'{$a->ouvalue}\', nova vrijednost: \'{$a->nuvalue}';
$string['updateusernotfound'] = 'Nije bilo moguće pronaći korisnika prilikom ažuriranja vanjskog izvora. Slijede detalji: search base: \'{$a->userdn}\'; search filter: \'(objectClass=*)\'; search attributes: {$a->attribs}';
$string['useracctctrlerror'] = 'Greška pri dobijanju userAccountControl za {$a}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podržava izabrani tip korisnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ne podržava izabrani tip korisnika: {$a}';
$string['userentriestoadd'] = 'Korisnički računi koji će biti dodani: {$a}';
$string['userentriestoremove'] = 'Korisnički računi koji će biti uklonjeni: {$a}';
$string['userentriestorevive'] = 'Korisnički računi koji će biti ponovo aktivirani: {$a}';
$string['userentriestoupdate'] = 'Korisnički računi koji će biti ažurirani: {$a}';
$string['usernotfound'] = 'Korisnik nije pronađen u LDAP-u.';
