<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Imate zadataka koji zahtjevaju vašu pažnju';
$string['addsubmission'] = 'Dodaj rad';
$string['allowdeleting'] = 'Dozvoli brisanje';
$string['allowdeleting_help'] = 'Ako je ova opcija omogućena, studenti mogu da brišu postavljene datoteke u bilo kojem trenutku, prije nego što predaju rad za ocjenjivanje..';
$string['allowmaxfiles'] = 'Maksimalan broj postavljenih datoteka';
$string['allowmaxfiles_help'] = 'Maksimalan broj datoteka koji može biti postavljen. Kako se ovaj broj nigdje ne prikazuje studentima, potrebno je da u opisu zadatka obavezno navedete ovaj broj, kako bi studenti znali koliko datoteka mogu da postave.';
$string['allownotes'] = 'Dozvoli bilješke';
$string['allownotes_help'] = 'Ako je ova opcija omogućena, studenti će moći da unose bilješke u za to predviđeno polje za unos teksta, slično kao kod zadatka tipa \'Online tekst\'.';
$string['allowresubmit'] = 'Dozvoli ponovno podnošenje';
$string['allowresubmit_help'] = 'Ako je ova opcija omogućena, studentima će biti dozvoljeno da ponovo predaju svoje radove nakon što su prethodne verzije već ocijenjene (kako bi ih nastavnik ponovo ocijenio).';
$string['alreadygraded'] = 'Vaš zadatak je već ocijenjen i ponovno rješavanje zadatka nije dozvoljeno.';
$string['assignment:addinstance'] = 'Dodaj novi zadatak';
$string['assignmentdetails'] = 'Detalji zadatka';
$string['assignment:exportownsubmission'] = 'Prenos vlastitog rada';
$string['assignment:exportsubmission'] = 'Prenesi rad';
$string['assignment:grade'] = 'Ocijeni zadatak';
$string['assignmentmail'] = '{$a->teacher} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\'. Povratne informacije su pridružene Vašem radu i možete ih pogledati na: {$a->url}';
$string['assignmentmailhtml'] = '{$a->teacher} je poslao/la povratne informacije na rad koji ste predali za zadatak \'<i>{$a->assignment}</i>\'.<br /><br /> Povratne informacije možete pogledati pridružene Vašem <a href="{$a->url}">radu</a>.';
$string['assignmentmailsmall'] = '{$a->teacher} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\'. Povratne informacije možete pogledati pridružene Vašem radu.';
$string['assignmentname'] = 'Naziv zadatka';
$string['assignmentsubmission'] = 'Predani radovi';
$string['assignment:submit'] = 'Predaj zadatak';
$string['assignmenttype'] = 'Vrsta zadatka';
$string['assignment:view'] = 'Pregledaj zadatak';
$string['availabledate'] = 'Dostupan od';
$string['cannotdeletefiles'] = 'Došlo je do greške i datoteke se ne mogu obrisati.';
$string['cannotviewassignment'] = 'Ne možete pregledati ovaj zadatak';
$string['changegradewarning'] = 'Ovaj zadatak je ocjenio prosljeđene radove a promjena ocjene neće automatski re-kalkulisati postojeće ocjene raodova. Morate ponovno ocjeniti sve postojeće predate radove, ako želite da promjenite ocjenu.';
$string['closedassignment'] = 'Predaja radova za ovaj zadatak je završena';
$string['comment'] = 'Komentar';
$string['commentinline'] = 'Komentar unutar zadatka';
$string['commentinline_help'] = 'Ako je ova opcija omogućena, predani tekst rada će, prilikom ocijenjivanja, biti kopiran u polje za povratne informacije, kako bi nastavnik mogao lakše da ga komentira (korištenjem različite boje, na primjer) ili da uređuje originalni tekst.';
$string['configitemstocount'] = 'Vrsta priloga koji će se priznavati kao studentski radovi u online zadacima.';
$string['configmaxbytes'] = 'Zadana maksimalna veličina za sve zadatke na sajtu (vezano za ograničenje kursa i ostala lokalna podešavanja)';
$string['configshowrecentsubmissions'] = 'Svi mogu da vide obavještenje o predanim radovima u izvještaju o nedavnim aktivnostima.';
$string['confirmdeletefile'] = 'Da li ste potpuno sigurni da želite da obrišete ovu datoteku?<br /><strong>{$a}</strong>';
$string['coursemisconf'] = 'Kurs nije ispravno podešen';
$string['currentgrade'] = 'Trenutna ocjena u knjizi ocjena';
$string['deleteallsubmissions'] = 'Obriši sva predane radove';
$string['deletefilefailed'] = 'Brisanje datoteke nije uspjelo.';
$string['description'] = 'Opis';
$string['downloadall'] = 'Preuzmi sve zadatke kao zip arhivu';
$string['draft'] = 'Nacrt';
$string['due'] = 'Rok za predaju zadatka';
$string['duedate'] = 'Datum dospjeća';
$string['duedateno'] = 'Datum nedospjeća';
$string['early'] = '{$a} raniji';
$string['editmysubmission'] = 'Izmijeni moj rad';
$string['editthesefiles'] = 'Uredi ove datoteke';
$string['editthisfile'] = 'Ažuriraj ovu datoteku';
$string['emailstudents'] = 'Slanje upozorenja studentima e-mailom';
$string['emailteachermail'] = '{$a->username} je ažurirao/la svoj rad za zadatak \'{$a->assignment}\' u {$a->timeupdated} Rad je dostupan na sljedećoj adresi: {$a->url}';
$string['emailteachermailhtml'] = '{$a->username} je ažurirao/la svoj rad za zadatak <i>\'{$a->assignment}\' u {$a->timeupdated}</i><br /><br /> Rad je <a href="{$a->url}">dostupan na web sajtu</a>.';
$string['emailteachers'] = 'Slanje upozorenja predavačima e-mailom';
$string['emailteachers_help'] = 'Ako je ova opcija omogućena, kada god student preda ili ažurira svoj rad, nastavnici će biti obaviješteni e-mailom. Samo nastavnici koji mogu da ocijenjuju konkretan zadatak će dobiti ovo obavještenje. Tako na primjer, ako se kurs realizuje za odvojene grupe, nastavnici zaduženi za konkretne grupe neće primati nikakva obavještenja o studentima iz drugih grupa.';
$string['emptysubmission'] = 'Još uvijek niste ništa predali';
$string['enablenotification'] = 'Pošalji obavještenje';
$string['enablenotification_help'] = 'Ako je ova opcija omogućena studenti će dobijati obavještenje e-mailom kada njihovi radovi budu ocijenjeni.';
$string['errornosubmissions'] = 'Nema predanih radova za preuzimanje';
$string['existingfiledeleted'] = 'Postojeći direktorijum je obrisan: {$a}';
$string['failedupdatefeedback'] = 'Ažuriranje povratnih informacija za korisnika {$a} nije uspjelo.';
$string['feedback'] = 'Povratna sprega';
$string['feedbackfromteacher'] = 'Povratne informacije koje je poslao/la {$a}';
$string['feedbackupdated'] = 'Povratne informacije su poslane za {$a} korisnika';
$string['finalize'] = 'Spriječi ažuriranje zadatka';
$string['finalizeerror'] = 'Došlo je do greške i taj rad nije moguće dovršiti';
$string['futureaassignment'] = 'Ovaj zadatak još uvijek nije dostupan.';
$string['graded'] = 'Ocijenjeno';
$string['guestnosubmit'] = 'Žao nam je, ali gostima nije dozvoljeno da predaju svoj rad. Morate se registrirati/prijaviti kao registrirani korisnik da biste predali svoj rad.';
$string['guestnoupload'] = 'Žao nam je, ali gostima nije dozvoljeno da postavljaju datoteke';
$string['helpoffline'] = '<p>Ovaj tip zadatka je koristan kada se radi izvan Moodlea. To može biti negdje drugo na webu ili u učionici.</p><p>Studenti mogu da vide opis zadatka, ali ne mogu da uploaduju datoteke ili bilo šta drugo. Ocijenjivanje funkcioniše potpuno normalno, i studenti će dobiti obavještenje o svojim ocjenama.</p>';
$string['helponline'] = '<p>Ovaj tip zadatka traži od korisnika da napišu tekst koristeći običan editor teksta. Predavači mogu ne samo da ocijenjuju zadatke, online, već i da dodaju svoje komentare unutar samog teksta ili da ga mijenjaju.</p> <p>(Ukoliko ste upoznati sa starijim verzijama Moodle sistema, sjetićete se da ovaj tip zadatka ima istu namjenu koju je ranije imao stari modul Žurnal (Journal).)</p>';
$string['helpupload'] = '<p>Ova tip zadatka omogućava svakom studentu da postavi jednu ili više datoteka (u bilo kojem formatu).</p> <p>To mogu biti MS Word dokumenti, slike, arhivirani web sajtovi ili bilo šta drugo što ste tražili od studenata da predaju kao svoj rad.</p> <p>Ovaj tip zadatka Vam, također, dozvoljava da postavite više datoteka za odgovore. Datoteke za odgovor mogu biti postavljene i prije predaje rada, što možete iskoristiti kako biste svakom studentu dali da radi sa različitom datotekom.</p> <p>Učesnici također mogu da unose svoje bilješke koje opisuju predate datoteke, svoje napredovanje u radu na zadatku ili bilo kakve druge tekstualne informacije.</p> <p>Student mora ručno da završi predaju rada za ovaj tip zadatka. Možete pogledati trenutni status rada u bilo kojem trenutku, pri čemu su nezavršeni zadaci označeni kao \'Nacrt\'. Svaki neocijenjeni zadatak možete vratiti u status nacrta.</p>';
$string['helpuploadsingle'] = '<p>Ovaj tip zadatka omogućava svakom studentu da postavi jednu datoteku (bilo kog tipa).</p> <p>To može biti MS Word dokument, slika, arhivirani web sajt ili bilo šta drugo što ste tražili od studenata da predaju kao svoj rad.</p>';
$string['hideintro'] = 'Sakrij opis prije datuma kada zadatak postaje dostupan';
$string['hideintro_help'] = 'Ako je ova opcija omogućena, opis zadatka će biti sakriven sve do trenutka naznačenog u podešavanju "Dostupno od". Studenti će, do tada, moći da vide samo naziv zadatka.';
$string['invalidassignment'] = 'Neispravan zadatak';
$string['invalidfileandsubmissionid'] = 'Nedostaje datoteka ili ID predatog rada';
$string['invalidid'] = 'Neispravan ID zadatka';
$string['invalidsubmissionid'] = 'Neispravan ID predatog rada';
$string['invalidtype'] = 'Neispravan tip zadatka';
$string['invaliduserid'] = 'Neispravan korisnički ID';
$string['itemstocount'] = 'Broj';
$string['lastgrade'] = 'Posljednja ocjena';
$string['late'] = '{$a} kasnije';
$string['maximumgrade'] = 'Maksimalna ocjena';
$string['maximumsize'] = 'Maksimalna veličina';
$string['maxpublishstate'] = 'Najduža dostupnost blog članka prije isteka roka';
$string['messageprovider:assignment_updates'] = 'Obavještenja o zadatku (2.2)';
$string['modulename'] = 'Zadatak (2.2)';
$string['modulename_help'] = 'Modul \'Zadaci\' daje mogućnost nastavniku da odredi zadatak koji studenti riješavaju ili u online okruženju ili van njega. Nakon toga nastavnik može da ocijeni predate studentske radove.';
$string['modulenameplural'] = 'Zadaci';
$string['newsubmissions'] = 'Zadaci su predani';
$string['noassignments'] = 'Još uvijek nema zadataka';
$string['noattempts'] = 'Niko nije predao rad za ovaj zadatak';
$string['noblogs'] = 'Nemate nijedan blog članak za predaju!';
$string['nofiles'] = 'Nijedna datoteka nije predana';
$string['nofilesyet'] = 'Nijedna datoteka još nije predana';
$string['nomoresubmissions'] = 'Dalja predaja radova nije dozvoljena';
$string['norequiregrading'] = 'Nema zadataka koji zahtijevaju ocijenjivanje';
$string['nosubmisson'] = 'Nijedan zadatak nije predan';
$string['notavailableyet'] = 'Žao nam je, ali ovaj zadatak još nije dostupan.<br />Uputstva za zadatak će biti prikazana na ovom mjestu od dole navedenog datuma.';
$string['notes'] = 'Bilješke';
$string['notesempty'] = 'Nema unosa';
$string['notesupdateerror'] = 'Greška pri ažuriranju bilješki';
$string['notgradedyet'] = 'Još nije ocijenjeno';
$string['notsubmittedyet'] = 'Još nije predano';
$string['onceassignmentsent'] = 'Jednom kada predate rad na ocijenjivanje, više nećete moći da brišete ili dodajete datoteke. Da li želite da nastavite?';
$string['operation'] = 'Operacija';
$string['optionalsettings'] = 'Opciona podešavanja';
$string['overwritewarning'] = 'Upozorenje: ponovno postavljanje će ZAMIJENITI Vaš prethodno predani rad';
$string['page-mod-assignment-submissions'] = 'Stranica modula \'Zadatak\' za predaju rada';
$string['page-mod-assignment-view'] = 'Glavna stranica modula \'Zadatak';
$string['page-mod-assignment-x'] = 'Bilo koja stranica modula \'Zadatak';
$string['pagesize'] = 'Broj predanih radova po stranici';
$string['pluginadministration'] = 'Administracija zadataka';
$string['pluginname'] = 'Zadatak (2.2)';
$string['popupinnewwindow'] = 'Otvori u pop-up prozoru';
$string['preventlate'] = 'Spriječi kašnjenje';
$string['quickgrade'] = 'Dozvoli brzo ocijenjivanje';
$string['quickgrade_help'] = 'Ako je uključena ova opcija za brzo ocijenjivanje, predavač može da ocijeni više radova na jednoj stranici. Dodajete ocjene i komentare, a zatim kliknite na dugme "Sačuvaj sve moje povratne informacije" kako biste sačuvali sve promjene na toj stranici.';
$string['requiregrading'] = 'Zahtjeva ocijenjivanje';
$string['responsefiles'] = 'Datoteke sa odgovorima';
$string['reviewed'] = 'Pregledano';
$string['saveallfeedback'] = 'Sačuvaj sve moje odgovore';
$string['selectblog'] = 'Odaberite blog članak koji želite da predate';
$string['sendformarking'] = 'Pošalji na ocijenjivanje';
$string['showrecentsubmissions'] = 'Prikaži nedavno predane radove';
$string['submission'] = 'Predani rad';
$string['submissiondraft'] = 'Nacrt rada';
$string['submissionfeedback'] = 'Povratna informacija o potvrđivanju';
$string['submissions'] = 'Predani radovi';
$string['submissionsaved'] = 'Vaše promjene su sačuvane';
$string['submissionsnotgraded'] = 'Broj neocijenjenih radova: {$a}';
$string['submitassignment'] = 'Za slanje zadataka koristite ovu formu';
$string['submitedformarking'] = 'Rad je već predat na ocijenjivanje i ne može biti ažuriran';
$string['submitformarking'] = 'Finalna predaja rada na ocijenjivanje';
$string['submitted'] = 'Predano';
$string['submittedfiles'] = 'Predate datoteke';
$string['subplugintype_assignment'] = 'Vrsta zadatka';
$string['subplugintype_assignment_plural'] = 'Tipovi zadataka';
$string['trackdrafts'] = 'Uključi dugme "Pošalji na ocijenjivanje"';
$string['trackdrafts_help'] = 'Dugme "Pošalji na ocijenjivanje" dozvoljava studentima da jave predavaču da su završili rad na zadatku. Predavač može izabrati da rad vrati u status nacrta (ako, na primjer, poslani rad zahtjeva da se na njemu dodatno radi).';
$string['typeblog'] = 'Blog članak';
$string['typeoffline'] = 'Aktivnost izvan mreže (Offline)';
$string['typeonline'] = 'Online tekst';
$string['typeupload'] = 'Napredno postavljanje datoteka';
$string['typeuploadsingle'] = 'Dodajte datoteku';
$string['unfinalize'] = 'Vrati na status nacrta';
$string['unfinalizeerror'] = 'Došlo je do greške i taj rad nije moguće vratiti na verziju nacrta';
$string['unfinalize_help'] = 'Vraćanje u status nacrta omogućava studentu da dalje ažurira svoj rad';
$string['unsupportedsubplugin'] = 'Tip zadatka \'{$a}\' trenutno nije podržan. Možete sačekati dok ne postane raspoloživ ili obrisati zadatak.';
$string['upgradenotification'] = 'Ova aktivnost se zasniva na starijoj verziji modula \'Zadatak';
$string['uploadafile'] = 'Postavi datoteku';
$string['uploadbadname'] = 'Ova datoteka sadrži nedozvoljene karaktere i ne može biti dodana';
$string['uploadedfiles'] = 'Dodajte datoteke';
$string['uploaderror'] = 'Došlo je do greške prilikom pokušaja da se datoteka sačuva na serveru';
$string['uploadfailnoupdate'] = 'Datoteka je uspješno postavljena, ali nije bilo moguće zamijeniti Vaš prethodno predani rad!';
$string['uploadfiles'] = 'Postavi datoteke';
$string['uploadfiletoobig'] = 'Žao nam je, ali ova datoteka je prevelika (dozvoljena veličina datoteke je {$a} bytes)';
$string['uploadnofilefound'] = 'Datoteka nije pronađena - da li ste sigurni da ste izvršili ispravan izbor datoteke za dodavanje?';
$string['uploadnotregistered'] = 'Datoteke \'{$a}\' je uspješno postavljena, ali rad nije registriran!';
$string['uploadsuccess'] = 'Datoteka \'{$a}\' je uspješno postavljena';
$string['usermisconf'] = 'Korisnik nije ispravno podešen';
$string['usernosubmit'] = 'Nažalost, nije Vam dozvoljeno da predate rad';
$string['viewassignmentupgradetool'] = 'Pogledajte alatku za nadogradnju modula \'Zadatak';
$string['viewfeedback'] = 'Pogledajte ocjene i povratne informacije';
$string['viewmysubmission'] = 'Pogledaj moj rad';
$string['viewsubmissions'] = 'Pogledaj {$a} predan(r)/predanih rad(a)/ova';
$string['yoursubmission'] = 'Vaš predati rad';
