<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'et', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Tegevused';
$string['addcategory'] = 'Lisa kategooria';
$string['addcategoryerror'] = 'Ei saanud kategooriat lisada.';
$string['addexceptionerror'] = 'Viga erandi lisamisel userid:gradeitem jaoks.';
$string['addfeedback'] = 'Lisa tagasiside';
$string['addgradeletter'] = 'Lisa hindetäht';
$string['addidnumbers'] = 'Lisa ID-numbrid';
$string['additem'] = 'Lisa hindetulp';
$string['addoutcome'] = 'Lisa tulemus';
$string['addoutcomeitem'] = 'Lisa tulemus';
$string['addscale'] = 'Lisa skaala';
$string['aggregateextracreditmean'] = 'Hinnete keskmine (koos lisapunktidega)';
$string['aggregatemax'] = 'Kõrgeim hinne';
$string['aggregatemean'] = 'Hinnete keskmine';
$string['aggregatemedian'] = 'Hinnete mediaan';
$string['aggregatemin'] = 'Madalaim hinne';
$string['aggregatemode'] = 'Hinnete mood';
$string['aggregateonlygraded'] = 'Arvesta ainult hinnatud tegevusi';
$string['aggregateonlygraded_help'] = 'Tühi hinne on hinne, mis on puudu hinnetelehelt. See võib olla ülesande esituse , mis ei ole veel hinnatud või testist, mis ei ole veel kordagi sooritatud jne.

See seadistus määrab, kas tühjasid hindeid kaasatakse koondtulemuses või on arvestatud kui minimaalsed hinded, näiteks 0, kui ülesanne on hinnatud vahemikus 0 kuni 100.';
$string['aggregateoutcomes'] = 'Arvesta tulemused kategooriasse';
$string['aggregateoutcomes_help'] = 'Kui sisse lülitatud, tulemused on kaasatud koondtulemuses. Sellel võib tulemuseks olla ootamatud kategooria kogusumma.';
$string['aggregatesonly'] = 'Ainult kategooriad';
$string['aggregatesubcats'] = 'Koos alamkategooriatega';
$string['aggregatesubcats_help'] = 'Seaded määravad, kas hinded alamkategooriates on kaasatud koondtulemuses.';
$string['aggregatesum'] = 'Hinnete summa';
$string['aggregateweightedmean'] = 'Hinnete kaalutud keskmine';
$string['aggregateweightedmean2'] = 'Lihtne hinnete kaalutud keskmine';
$string['aggregation'] = 'Koondamine';
$string['aggregationcoef'] = 'Kategooria kaal';
$string['aggregationcoefextra'] = 'Lisapunkt';
$string['aggregationcoefextra_help'] = 'Kui kategooria tulemus on hinnete summa või lihtne kaalutud keskmine ja lisapunkti linnukese kast on märgitud, siis hinde elemendi maksimaalne hinne ei ole lisatud kategooria maksimaalsele hindele, tulemuseks maksimaalse hinde saamise tõenäosus (või hinded üle maksimumi kui sisse lülitatud saidi administraatori poolt) kategoorias ilma kõikides hinnete elementidest maksimumhindeid saamata.

Kui kategooria tulemus on hinnete keskmine (koos lisapunktidega) ja lisapunktide väärtued on seatud nullist suuremaks, siis lisapunktid on faktor, millega hinne on korrutatud enne selle lisades kogusummale pärast keskmine arvutamist.';
$string['aggregationcoefextrasum'] = 'Lisapunkt';
$string['aggregationcoefextrasum_help'] = 'Kui ekstra krediidi kasti pannakse linnuke, hinde elemendi maksimaalne hinne ei lisata kategooria maksimaalsele hindele, tullemuse on maksimaalse hinde saamise võimalus (või hinded üle maksimaalse, kui võimaldatud saidi administraatori poolt) kategoorias, saamata maksimaalsid hindeid kõikides hinnatavates elementides.';
$string['aggregationcoefextraweight'] = 'Ekstra krediidi kaal';
$string['aggregationcoefextraweight_help'] = 'Kui ekstra krediidi väärtus on seatud suurem kui null, hinne toimib kui ekstra krediit koondis. Number on faktor, millega hinne on korrutatud enne selle lisamist arvutusliku kogusumma keskmisele.';
$string['aggregationcoefweight'] = 'Objekti kaal';
$string['aggregationcoefweight_help'] = 'Hinnatava objekti kaalu kasutatakse, kategooria kokku arvestamisel, et mõjutada hinde olulisust, võrreldes teiste hinnatavate objektidega samas kategoorias.';
$string['aggregation_help'] = 'Kategooria tulemus määrab kuidas hinded kategoorias on kombineeritud,  selliselt kui

* Hinnete keskmine - kõikide hinnete summa jagatud hinnete hulk
* Hinnete mediaan - keskmine hinne, mis hinded on järjestatud suuruse järjekorras
* Madalaim hinne
* Kõrgeim hinne
* Hinnete mood - hinne, mida leidub kõige sagedamini
* Hinnete summa - kõikide hinnete väärtuste summa, skaala hindeid ignoreerides.';
$string['aggregationposition'] = 'Kategooria koondtulemuse asukoht';
$string['aggregationposition_help'] = 'See seadistus määrab kas kategooria ja kursuse kogusumma veerud on kuvatud esimesena või viimasena hinnetelehe raportis.';
$string['aggregationsvisible'] = 'Saadaval koondtulemuste tüübid';
$string['aggregationsvisiblehelp'] = 'Vali kõik koondtüübid, mis peaksid olema kättesaadaval. Hoia all Ctrl võtit valimaks mitut elementi.';
$string['allgrades'] = 'Kõik hinded kategooriate kaupa';
$string['allstudents'] = 'Kõik õppijad';
$string['allusers'] = 'Kõik kasutajad';
$string['autosort'] = 'Sorteeri';
$string['availableidnumbers'] = 'Id-numbrid';
$string['average'] = 'Keskmine';
$string['averagesdecimalpoints'] = 'Keskmise tulemuse komakohad';
$string['averagesdecimalpoints_help'] = 'See seade määrab ära kui mitu komakohta kuvatakse igas keskmises hindes või üleüldises kategoorias või hinde objektis(pärandatav).';
$string['averagesdisplaytype'] = 'Keskmise tulemuse kuvamise tüüp';
$string['averagesdisplaytype_help'] = 'See seadistus määrab kas keskmine on kuvatud reaalsete hinnetena, protsentides või tähtedes, või kas kategooria või hinde elementi kasutatakse (päritud).';
$string['backupwithoutgradebook'] = 'Tagavarakoopias ei sisaldu hinnetelehe seadistusi';
$string['badgrade'] = 'Hinne on vigane';
$string['badlyformattedscale'] = 'Palun sisesta komaga eraldatud väärtuste nimekiri (vähemalt kaks väärtust).';
$string['bonuspoints'] = 'Boonuspunktid';
$string['calculatedgrade'] = 'Arvutatud hinne';
$string['calculation'] = 'Arvutus';
$string['calculationadd'] = 'Lisa arvutustehe';
$string['calculationedit'] = 'Muuda arvutustehet';
$string['calculation_help'] = 'Hinde arvutus on valem, mida kasutatakse hinnete määramiseks. Valem peaks algama võrdusmärgiga (=) ja võidakse kasutada põhilisi matemaatilisi operaatoreid, nagu näiteks max, min ja sum. Kui soovitud, siis teised hinnete elemente võib kaasata arvutuses kirjutades ID-numbrid topelt nurksulgudes.
Muutujate eraldamiseks tuleb kasutada semikoolonit (;).';
$string['calculationsaved'] = 'Arvutustehe on salvestatud';
$string['calculationview'] = 'Vaata arvutustehet';
$string['cannotaccessgroup'] = 'Ei ole juurdepääsu
valitud grupi hinnetele, vabandust.';
$string['categories'] = 'Kategooriad';
$string['categoriesanditems'] = 'Kategooriad ja objektid';
$string['categoriesedit'] = 'Redigeeri kategooriaid ja objekte';
$string['category'] = 'Kategooria';
$string['categoryedit'] = 'Redigeeri kategooriat';
$string['categoryname'] = 'Kategooria nimi';
$string['categorytotal'] = 'Kategooria kokku';
$string['categorytotalfull'] = '{$a->category} kokku';
$string['categorytotalname'] = 'Kategooria täisnimi';
$string['changedefaults'] = 'Muuda seadeid';
$string['changereportdefaults'] = 'Muuda vaikimisi seadeid';
$string['chooseaction'] = 'Vali tegevus ...';
$string['choosecategory'] = 'Vali kategooria';
$string['combo'] = 'Sakid ja rippmenüü';
$string['compact'] = 'Kompaktne';
$string['contract'] = 'Lepingu kategooria';
$string['controls'] = 'Hinnatava tegevuse seaded';
$string['courseavg'] = 'Kursuse keskmine';
$string['coursegradecategory'] = 'Kursuse tulemuse kategooria';
$string['coursegradedisplaytype'] = 'Kursuse tulemuse kuvamise tüüp';
$string['coursegradesettings'] = 'Kursuse hinde seaded';
$string['coursename'] = 'Kursuse nimi';
$string['coursescales'] = 'Kursuse skaala';
$string['coursesettings'] = 'Kursuse seaded';
$string['coursesettingsexplanation'] = 'Kursuse sätted tingivad ka selle, kuidas hinneteleht kõigile kursusel osalejatele välja näeb.';
$string['coursetotal'] = 'Kogu kursus';
$string['createcategory'] = 'Loo kategooria';
$string['createcategoryerror'] = 'Ei saanud luua uut kategooriat';
$string['creatinggradebooksettings'] = 'Loon hinnetelehe sätteid';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Kategooria tulemus';
$string['curveto'] = 'Ümardus';
$string['decimalpoints'] = 'Komakohad';
$string['decimalpoints_help'] = 'See seade määrab ära kui mitu komakohta kuvatakse igas hindes. See ei oma effekti hinnete valemites arvutamisel, mida arvestatakse vaikimisi kuni 5 komakohaga.';
$string['default'] = 'Vaikimisi';
$string['defaultprev'] = 'Vaikimisi ({$a})';
$string['deletecategory'] = 'Kustuta kategooria';
$string['disablegradehistory'] = 'Mitte võimalda hinnete ajalugu';
$string['disablegradehistory_help'] = 'Keelata ära ajaloo jälgimine hinnetega seotud tabelites. See võib tõsta jõudlust ja hoida kokku ruumi andmebaasis.';
$string['displaylettergrade'] = 'Näita tähelisi hindeid';
$string['displaypercent'] = 'Näita protsente';
$string['displaypoints'] = 'Näita punkte';
$string['displayweighted'] = 'Näita kaalutud hindeid';
$string['dropdown'] = 'Rippmenüü';
$string['droplow'] = 'Eemalda madalaimad tulemused (mitu)';
$string['droplow_help'] = 'See seadistus määrab mitu vähimat hinnet jäetakse välja koondtulemustest.';
$string['dropped'] = 'Eemaldatud';
$string['dropxlowest'] = 'Eemalda X madalamat';
$string['dropxlowestwarning'] = 'Pane tähele: kui sa kasutad "Eemalda X madalamat", siis hindamine eeldab, et kõik objektid kategoorias on väärt sama palju punkte. Kui väärtused punktides erinevad, on tulemused ennustamatud.';
$string['duplicatescale'] = 'Kopeeri skaala';
$string['edit'] = 'Redigeeri';
$string['editcalculation'] = 'Muuda arvutusvalemit';
$string['editcalculationverbose'] = 'Muuda {$a->category} {$a->itemmodule} {$a->itemname} arvutusi';
$string['editfeedback'] = 'Redigeeri tagasisidet';
$string['editgrade'] = 'Redigeeri hinnet';
$string['editgradeletters'] = 'Muuda tähelist hinnet';
$string['editoutcome'] = 'Muuda tulemust';
$string['editoutcomes'] = 'Muuda tulemusi';
$string['editscale'] = 'Redigeeri skaalat';
$string['edittree'] = 'Kategooriad ja objektid';
$string['editverbose'] = 'Redigeeri {$a->category} {$a->itemmodule} {$a->itemname}\'i';
$string['enableajax'] = 'Võimalda AJAX';
$string['enableajax_help'] = 'Lisab AJAX funktsionaalsuse kihi hindaja raportile, lihtsustades ja kiirendades põhilisi operatsioone. Sõltub JavaScripti lubatusest kasutaja brauseri tasemel.';
$string['enableoutcomes'] = 'Võimalda tulemused';
$string['enableoutcomes_help'] = 'Tulemuste toetus (samuti teatud kui õppimiskompetentsus, eesmärgid, sandarid või kriteeriumid) tähendab, et me saame hinde asju kasutades ühte või enam skaalat, mis on seotud tulemuste teatistega. Tulemuste sisselülitamine, muudab sellise hindamise võimaliuks kogu saidil';
$string['encoding'] = 'Kodeering';
$string['errorcalculationnoequal'] = 'Valem peab algama võrdusmärgiga (=1+2)';
$string['errorcalculationunknown'] = 'Vigane valem';
$string['errorgradevaluenonnumeric'] = 'Saadud mitte-numbriline väärtus järgneva tähe madalaima või kõrgeima hinde jaoks:';
$string['errornocalculationallowed'] = 'Selle elemendi kohta ei ole arvutused lubatud';
$string['errornocourse'] = 'Ei saanud kursuse informatsiooni!';
$string['errorreprintheadersnonnumeric'] = 'Saadud mitte-numbriline väärtus päiste kordamisele.';
$string['errorsavegrade'] = 'Ei saanud hinnet salvestada, vabandust.';
$string['excluded'] = 'Välja arvatud';
$string['excluded_help'] = 'Kui valitud, siis ei kajastata hinnet üheski koondtulemuses.';
$string['expand'] = 'Ava kategooria';
$string['export'] = 'Ekspordi';
$string['exportalloutcomes'] = 'Ekspordi kõik tulemused';
$string['exportfeedback'] = 'Ekspordi koos tagasisidega';
$string['exportonlyactive'] = 'Jäta välja peatatud kasutajad';
$string['exportplugins'] = 'Ekspordi pluginad';
$string['exportsettings'] = 'Eksportimise seaded';
$string['exportto'] = 'Ekspordi';
$string['extracreditwarning'] = 'Pane tähele: määrates kõik kategooria elemendid lisapunktideks, eemaldatakse nad hinde arvutamisest. Samuti ei näidata punktide kogusummat.';
$string['feedback'] = 'Tagasiside';
$string['feedbackadd'] = 'Lisa tagasiside';
$string['feedbackedit'] = 'Redigeeri tagasisidet';
$string['feedbackforgradeitems'] = 'Tagasiside tegevusele {$a}';
$string['feedback_help'] = 'See kast võimaldab kommenteerida lisatud hinnet.';
$string['feedbacks'] = 'Tagasisided';
$string['feedbacksaved'] = 'Tagasiside salvestatud';
$string['feedbackview'] = 'Vaata tagasisidet';
$string['finalgrade'] = 'Lõpphinne';
$string['finalgrade_help'] = 'Kui ümber kehtestamise linnukene kastis, siis hinne võidakse lisada või asendada.';
$string['fixedstudents'] = 'Staatiline õpilaste veerg';
$string['fixedstudents_help'] = 'Muudab õppijate tulba staatiliseks ja lubab hindeid kerida horisontaalselt ilma, et õppijate tulp liiguks.';
$string['forceoff'] = 'Sunni: Väljas';
$string['forceon'] = 'Sunni: Sees';
$string['forstudents'] = 'Õppijatele';
$string['full'] = 'Täis';
$string['fullmode'] = 'Täisvaade';
$string['fullview'] = 'Täisvaade';
$string['generalsettings'] = 'Üldised seaded';
$string['grade'] = 'Hinne';
$string['gradeadministration'] = 'Hinde administreerimine';
$string['gradeanalysis'] = 'Hinde analüüs';
$string['gradebook'] = 'Hinneteleht';
$string['gradebookhiddenerror'] = 'See hinneteleht on hetkel seatud kõike õppijate eest varjama.';
$string['gradebookhistories'] = 'Hinnete ajalugu';
$string['gradeboundary'] = 'Alampiir tähelisele hindele';
$string['gradeboundary_help'] = 'See seadistus määrab minimaalse protsendi, üle mille hinnetele määratakse hinde täht.';
$string['gradecategories'] = 'Hinnete kategooriad';
$string['gradecategory'] = 'Hinde kategooria';
$string['gradecategoryonmodform'] = 'Hinde kategooria';
$string['gradecategoryonmodform_help'] = 'See seadistus kontrollid kategooriat, mis tegevuste hinded pannakse hinnetelehele.';
$string['gradecategorysettings'] = 'Hindamise kategooria seaded';
$string['gradedisplay'] = 'Hinde kuvamine';
$string['gradedisplaytype'] = 'Hinde kuvamise tüüp';
$string['gradedisplaytype_help'] = 'See seadistus määrab kuidas hinded kuvatakse hindaja ja kasutaja raportis.
* Tegelik - saadud hinded
* Protsendiline
* Täht - Tähti või sõnu kasutatakse näitamaks hinnete vahemikku';
$string['gradedon'] = 'Hinnatud $a';
$string['gradeexport'] = 'Hinnete eksport';
$string['gradeexportdecimalpoints'] = 'Eksporditavate hinnete komakohad';
$string['gradeexportdecimalpoints_desc'] = 'Mitu komakohta kuvatakse eksportimisel. Seda saab ümber kehtestada ekspordi ajal.';
$string['gradeexportdisplaytype'] = 'Hinnete ekspordi kuvamise tüüp';
$string['gradeexportdisplaytype_desc'] = 'Hindeid saab kuvada reaalsete hinnetena, protsendina (viidates minimaalsele ja maksimaalsele hindele) või tähtedena (A, B, C jne.) ekspordil. Seda saab ümber kehtestada ekspordi ajal.';
$string['gradehelp'] = 'Hinnetelehe abi';
$string['gradehistorylifetime'] = 'Hinnete ajalugu';
$string['gradehistorylifetime_help'] = 'See määrab ära aja, kui kaua hoida hinnetega seotud tabelite ajalugu. Soovitatav on hoida, seda nii kaua kui võimalik. Kui esineb jõudlus probleeme või kui on piiratud andmemahu ruum siis proovige määrata väiksem väärtus.';
$string['gradeimport'] = 'Hinnete import';
$string['gradeitem'] = 'Hindamise objekt';
$string['gradeitemaddusers'] = 'Eemalda hindamiselt';
$string['gradeitemadvanced'] = 'Hinnete lisaseaded';
$string['gradeitemadvanced_help'] = 'Vali kõik elemendid, mis peaksid olema kuvatud kui detailsed, mil muudetakse hindeid.';
$string['gradeitemislocked'] = 'See tegevus on hinnetelehel lukustatud. Tegevuse hinnetes tehtud muudatusi ei kopeerita hinnetelehele kuni see on lahti lukustamata.';
$string['gradeitemlocked'] = 'Hindamine lukustatud';
$string['gradeitemmembersselected'] = 'Hindamiselt eemaldatud';
$string['gradeitemnonmembers'] = 'Hindamisele lisatud';
$string['gradeitemremovemembers'] = 'Lisa hindamisele';
$string['gradeitems'] = 'Hindamise objektid';
$string['gradeitemsettings'] = 'Tulemuse seaded';
$string['gradeitemsinc'] = 'Lisatavad hinded';
$string['gradeletter'] = 'Täheline hinne';
$string['gradeletter_help'] = 'Tähelised hinded võivad olla A, B, C, ... või sõnad, näiteks arvestatud, mittearvestatud, ... selleks, et näidata hinnete vahemikku.';
$string['gradeletternote'] = 'Tähelise hinde kustutamiseks tühjenda<br/>üks selle tähe kohta käivatest tekstilahtritest ja salvesta muudatused.';
$string['gradeletters'] = 'Tähelised hinded';
$string['gradelocked'] = 'Hinne on lukus';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Maksimaalne hinne';
$string['grademax_help'] = 'See seadistus määrab maksimaalse hinde, mil kasutatakse väärtuse hinde tüüpi. Maksimaalne hinne tegevuse põhisele hindele on seatav tegevuste seadete lehel.';
$string['grademin'] = 'Minimaalne hinne';
$string['grademin_help'] = 'Seadistus määrab minimaalse hinde, kui kasutatakse väärtuselist hinde tüüpi.';
$string['gradeoutcomeitem'] = 'Tulemus';
$string['gradeoutcomes'] = 'Tulemused';
$string['gradeoutcomescourses'] = 'Kursuse tulemused';
$string['gradepass'] = 'Lävend';
$string['gradepass_help'] = 'See seadistus määrab minimaalse sooritamiseks nõutava hinde. Seda väärtust kasutatakse tegevuste ja kursuse sooritamise jäglimisel ning hinnetelehel, kus eduka sooritamise hinded on esile toodud rohelisega ja mitte-sooritatud hinded punasega.';
$string['gradepreferences'] = 'Hinnete eelistused';
$string['gradepreferenceshelp'] = 'Hindamise eelistuste abi';
$string['gradepublishing'] = 'Võimalda publitseerimine';
$string['gradepublishing_help'] = 'Sisse lülitamine publitseerimine eksportimistel ja importimistel: Eksporditud hinnetele saab ligi pääseda pöördudes URL-i poole, ilma sisse logimata Moodle saidile. Hindeid saab importida pöördudes sarnase URL-i poole (mis tähendab, et Moodle saiti importida muu saidi poolt publitseeritud hindeid). Vaikimisi ainult administraatorid saavad kasutada seda funktsiooni, palun hari kasutajaid enne lisades nõutud võimekuse muudele rollidele (kätkeb ohtu järjehoidjate jagamisel, allatõmbajate kiirendajate programmidega, IP-piirengud jne).';
$string['gradereport'] = 'Hinnete raport';
$string['graderreport'] = 'Hindaja raport';
$string['grades'] = 'Hinded';
$string['gradesforuser'] = '$a->tulemused';
$string['gradesonly'] = 'Ainult hinded';
$string['gradessettings'] = 'Hinnete seeaded';
$string['gradetype'] = 'Hinde tüüp';
$string['gradetype_help'] = 'On 4 hinde tüüpi:

* Pole - pole hindamine võimalik
* Väärtus - numbriline koos minimaalse ja maksimaalse väärtusega.
* Skaala - nimetused nimekirjast
* Tekst - ainult tagasiside

Ainult väärtus ja skaala hinde tüübid võidakse summeerida. Hinde tüüp tegevus-põhiseks hindeks määratakse tegevuste seadete lehel.';
$string['gradeview'] = 'Vaata hinnet';
$string['gradeweighthelp'] = 'Hinnete kaalude abi';
$string['groupavg'] = 'Rühm keskmiselt';
$string['hidden'] = 'Peidetud';
$string['hiddenasdate'] = 'Kuva postitamise kuupäeva peidetud hinnetele';
$string['hiddenasdate_help'] = 'Kui kasutaja ei saa näha peidetud hindeid, siis näita \'-\' asemel esitamise kuupäeva.';
$string['hidden_help'] = 'Kui märgitud, siis hinded on peidetud õpilaste eest. Peitmiseks kuni kuupäevani võib olla soov teha hinded avalikuks kui kogu hindamine on lõppenud.';
$string['hiddenuntil'] = 'Peidetud kuni';
$string['hiddenuntildate'] = 'Peidetud kuni: {$a}';
$string['hideadvanced'] = 'Peida täpsemad seadistused';
$string['hideaverages'] = 'Peida keskmised';
$string['hidecalculations'] = 'Peida arvutused';
$string['hidecategory'] = 'Peidetud';
$string['hideeyecons'] = 'Peida ikoonide näitamine/peitmine';
$string['hidefeedback'] = 'Peida tagasiside';
$string['hideforcedsettings'] = 'Peida sunnitud seaded';
$string['hideforcedsettings_help'] = 'Ära kuva peale sunnitud seadeid hindamise kasutajaliideses.';
$string['hidegroups'] = 'Peida rühmad';
$string['hidelocks'] = 'Peida lukud';
$string['hidenooutcomes'] = 'Näita tulemusi';
$string['hidequickfeedback'] = 'Peida tagasiside';
$string['hideranges'] = 'Peida vahemikud';
$string['hidetotalifhiddenitems'] = 'Peidetud tulemustega koondtulemuste näitamine';
$string['hidetotalifhiddenitems_help'] = 'See seadistus määrab kas kogusummad, mis sisaldavad peidetud hinnete elemente, kuvatakse õpilastele või asendatakse sidekriipsuga (-). Kui kuvatakse, siis kogusumma võidakse arvutada kas jättes välja või sisse peidetud elemendid.

Kui peidetud elemendid on välja jäetud, siis kogusumma saab olema erinev kogusummast nähtuna õpetaja poolt hindaja raportis, sest õpetaja alati näeb kogusummasid, mis kõikidest elementidest on arvutatud, peidetud või mitte peidetud. Kui peidetud elemendid on kaasatud, õpilased võivad olla võimelised arvutama peidetud elemente.';
$string['hidetotalshowexhiddenitems'] = 'Näita tulemust ilma peidetud hinneteta';
$string['hidetotalshowinchiddenitems'] = 'Näita tulemust koos peidetud hinnetega';
$string['hideverbose'] = 'Peida {$a->category}$a->itemmodule {$a->itemname}';
$string['highgradeascending'] = 'Sorteeri kasvavalt kõrgeima hinde järgi';
$string['highgradedescending'] = 'Sorteeri kahanevalt kõrgeima hinde järgi';
$string['highgradeletter'] = 'Kõrgeim';
$string['identifier'] = 'Identifitseeri kasutaja millega';
$string['idnumbers'] = 'ID-numbrid';
$string['import'] = 'Import';
$string['importcsv'] = 'Impordi CSV';
$string['importcustom'] = 'Impordi kui kohandatud tulemused (ainult see kursus)';
$string['importerror'] = 'Juhtus viga, seda skripti ei kutsutud õigete parameetritega.';
$string['importfailed'] = 'Import ebaõnnestus';
$string['importfeedback'] = 'Impordi tagasiside';
$string['importfile'] = 'Impordi fail';
$string['importfilemissing'] = 'Ei saadud faili, mine tagasi vormi juurde ja tee kindlaks kas laadisid üles õige faili.';
$string['importfrom'] = 'Impordi';
$string['importoutcomenofile'] = 'Üles laaditud fail oli tühi või rikutud. Palun veendu, et tegemist korrektse failiga. Probleem avastati real {$a}; see on põhjustatud sellest, et andmeread ei sisaldanud nii palju veergusid kui esimene rida (päise rida) või imporditud failis on puudu oodatavad päised. Vaata eksporditavaid faile, näiteks faili, millel on korrektne päis.';
$string['importoutcomes'] = 'Impordi tulemused';
$string['importoutcomes_help'] = 'Tulemusi saab importida CSV-failiga samasuguses formaadis tulemuste eksportimise CSV-failiga.';
$string['importoutcomesuccess'] = 'Imporditud tulemus "{$a->name}" ID-ga #{$a->id}';
$string['importplugins'] = 'Impordi pluginad';
$string['importpreview'] = 'Impordi eelvaade';
$string['importsettings'] = 'Impordi seaded';
$string['importskippednomanagescale'] = 'Sul ei ole õigust lisada uut skaalat, seeda tulemus "{$a}" on vahele jäetud, sest ta nõuab uut skaalat';
$string['importskippedoutcome'] = 'Tulemus lühinimega "{$a}" juba eksisteerib selles kontekstis, selle importimine jäeti vahele.';
$string['importstandard'] = 'Impordi standardtulemustena';
$string['importsuccess'] = 'Importimine õnnestus';
$string['importxml'] = 'Impordi XML';
$string['includescalesinaggregation'] = 'Kaasa skaalad koondtulemuses';
$string['includescalesinaggregation_help'] = 'Sa saad määrata, kas kõik hindeskaalad integreeritakse numbritena kõikidesse koondhinnetesse kõikide kursuste kõikides hinnetelehtedes.HOIATUS: selle seadistuse muutmine sunnib kõiki koondhindeid uuesti arvutama.';
$string['incorrectcourseid'] = 'Kursuse ID oli vigane';
$string['incorrectcustomscale'] = '(vigane kohandatud skaala, palun muuda.)';
$string['incorrectminmax'] = 'Miinimum peab olema väikem kui maksimum';
$string['inherit'] = 'Päri';
$string['intersectioninfo'] = 'Õppija/hinde info';
$string['item'] = 'Objekt';
$string['iteminfo'] = 'Objekti info';
$string['iteminfo_help'] = 'See seadistus pakub ruumi sisestamaks infot elemendi kohta. Infot ei kuvata mitte kuskil mujal.';
$string['itemname'] = 'Objekti nimi';
$string['items'] = 'Objektid';
$string['itemsedit'] = 'Muuda hinnet';
$string['keephigh'] = 'Säilita kõrgeim tulemus';
$string['keephigh_help'] = 'Kui seatud, siis see valik hoiab ainult X kõrgeimat hinnet. X valitakse väärtuseks sellele valikule.';
$string['keymanager'] = 'Võtme haldur';
$string['lessthanmin'] = '$a->itemname ($a->username) hinne on madalam kui lubatud';
$string['letter'] = 'Täht';
$string['lettergrade'] = 'Täheline hinne';
$string['lettergradenonnumber'] = 'Madalaim ja/või kõrgeim hinne oli mitte-numbriline järgmise tähe jaoks:';
$string['letterpercentage'] = 'Täheline hinne (%%)';
$string['letterreal'] = 'Täheline hinne (punktid)';
$string['letters'] = 'Tähed';
$string['linkedactivity'] = 'Seotud tegevus';
$string['linkedactivity_help'] = 'See seade määrab ära, mis tegevusega on see õpiväljund seotud. Seda võib kasutada, et saada ülevaade õppija oskustest mingis kriteeriumis, mitte lihtsalt tegevuse hinde põhjal.';
$string['linktoactivity'] = 'Link tegevusele {$a->name}';
$string['lock'] = 'Lukusta';
$string['locked'] = 'Lukustatud';
$string['locked_help'] = 'Kui valitud, siis ei saa hindega seotud tegevus seda enam automaatselt uuendada.';
$string['locktime'] = 'Lukus pärast';
$string['locktimedate'] = 'Lukus pärast: $a';
$string['lockverbose'] = 'Lukusta {$a->category}$a->itemmodule {$a->itemname}';
$string['lowest'] = 'Madalaim';
$string['lowgradeletter'] = 'Madalaim';
$string['manualitem'] = 'element käsitsi';
$string['mapfrom'] = 'Kaardista kust';
$string['mappings'] = 'Hinde elemendi sidumised';
$string['mapto'] = 'Kaardista kuhu';
$string['max'] = 'Kõrgeim';
$string['maxgrade'] = 'Kõrgeim hinne';
$string['meanall'] = 'Kõik hinded';
$string['meangraded'] = 'Saadud hindeid';
$string['meanselection'] = 'Kasuta keskmise arvutamiseks';
$string['meanselection_help'] = 'See seadistus määrab, kas arvestatakse hinneteta lahtreid, peaksid olema kaasatud arvutamaks iga kategooria või hindeelemendi arvutamisel.';
$string['median'] = 'Mediaan';
$string['min'] = 'Madalaim';
$string['missingscale'] = 'Skaala peab olema valitud';
$string['mode'] = 'Laad';
$string['morethanmax'] = 'Kasutaja {$a->username} töö {$a->itemname} hinne on kõrgem kui lubatud';
$string['moveselectedto'] = 'Liiguta valitud read kategooriasse';
$string['movingelement'] = '{$a} teisaldamine';
$string['multfactor'] = 'Korruta hinne läbi';
$string['multfactor_help'] = 'Kordaja on faktor, millega korrutatakse kõiki selle hindeelemendi hindeid, maksimaalseks väärtuseks saab olla maksimaalne hinne.Näiteks kui kordaja on 2 ja maksimum hinne on 100 siis kõik hinded vähem kui 50 korrutakse läbi 2-ga ja kõik hinded 50 ja suuremad muudetakse 100-ks.';
$string['mypreferences'] = 'Minu eelistused';
$string['myreportpreferences'] = 'Minu raporti eelistused';
$string['navmethod'] = 'Navigeerimise meetod';
$string['neverdeletehistory'] = 'Ära kunagi kustuta ajalugu';
$string['newcategory'] = 'Uus kategooria';
$string['newitem'] = 'Uus hinne';
$string['newoutcomeitem'] = 'Uus tulemuse element';
$string['no'] = 'ei';
$string['nocategories'] = 'Selle kursuse jaoks ei suudetud lisada või leida hindamise kategooriaid.';
$string['nocategoryname'] = 'Kategooria nime ei antud';
$string['nocategoryview'] = 'Pole ühtki kategooriat, mille järgi vaadata';
$string['nocourses'] = 'Siin ei ole veel ühtegi kursust';
$string['noforce'] = 'Ära sunni';
$string['nogradeletters'] = 'Tähelisi hindeid ei ole määratud';
$string['nogradesreturned'] = 'Ühtki hinnet ei tagastatud';
$string['noidnumber'] = 'ID-number puudub';
$string['nolettergrade'] = 'Pole tähelist hinnet:';
$string['nomode'] = 'pole';
$string['nonnumericweight'] = 'Saadud mitte-numbriline väärtus:';
$string['nonunlockableverbose'] = 'Hinnet ei saa lahti lukustada kuni {$a->itemname} on lahti lukustamata.';
$string['nonweightedpct'] = 'mitte-kaalutud %';
$string['nooutcome'] = 'Tulemust pole';
$string['nooutcomes'] = 'Tulemuse elemendid peavad olema seotud kursuse tulemusega, aga pole kursuse tulemusi. Kas sooviksid lisada?';
$string['nopublish'] = 'Ära publitseeri';
$string['norolesdefined'] = 'Rolle ei ole defineeritud: Administreerimine > Hinded > Üldised seaded > Hinnatavad rollid';
$string['noscales'] = 'Tulemused peavad olema seotud kursuse skaalaga või globaalse skaalaga, aga polnud kumbagi. Kas sooviksid lisada?';
$string['noselectedcategories'] = 'Ühtegi kategooriat ei ole valitud';
$string['noselecteditems'] = 'Ühtegi objekti ei ole valitud';
$string['notteachererror'] = 'Selle vahendi kasutamiseks peate olema õpetaja õigustes';
$string['numberofgrades'] = 'Hindeid';
$string['operations'] = 'Tegevused';
$string['options'] = 'Valikud';
$string['outcome'] = 'Hinne';
$string['outcomeassigntocourse'] = 'Määra muu tulemus sellele kursusele';
$string['outcomecategorynew'] = 'Uus kategooria';
$string['outcomeconfirmdelete'] = 'Oled sa kindel, et soovid kustutada tulemus "{$a}"?';
$string['outcomecreate'] = 'Lisa uus hinne';
$string['outcomedelete'] = 'Kustuta hinne';
$string['outcomefullname'] = 'Täisnimi';
$string['outcome_help'] = 'See seadistus määrab tulemuse, milline hinne esitatakse hinnetelehel.';
$string['outcomeitem'] = 'Hinde objekt';
$string['outcomeitemsedit'] = 'Muuda hinnet';
$string['outcomereport'] = 'Hinde ülevaade';
$string['outcomes'] = 'Hinded';
$string['outcomescourse'] = 'Kasutatud tulemusi kursuses';
$string['outcomescoursecustom'] = 'Kasutati kohandatud (ei saa eemaldada)';
$string['outcomescoursenotused'] = 'Standardit ei kasutata';
$string['outcomescourseused'] = 'Kasutati standartset (ei saa eemaldada)';
$string['outcomescustom'] = 'Kohandatud tulemused';
$string['outcomeshortname'] = 'Lühendnimi';
$string['outcomesstandard'] = 'Standardtulemused';
$string['outcomesstandardavailable'] = 'Saadaval standardtulemused';
$string['outcomestandard'] = 'Standardtulemus';
$string['outcomestandard_help'] = 'Standardtulemused on kättesaadavad saidiüleselt kõikide kursuste jaoks.';
$string['overallaverage'] = 'Üldine keskmine';
$string['overridden'] = 'Kirjuta hinne üle';
$string['overridden_help'] = 'Kui valitud, siis ei saa hinnet enam seotud tegevuse juures muuta.

Kui hinne on muudetud hindaja raportis, siis märgistatakse ümber kehtestatud kast automaatselt. Samas on võimalik siinne valik tühistada, et võimaldada hindega seotud tegevuse juures hinde muutmine.';
$string['overriddennotice'] = 'Sinu selle tegevuse lõpphinnet oli käsitsi kohandatud.';
$string['overridesitedefaultgradedisplaytype'] = 'Loon uued tähelised hinded';
$string['overridesitedefaultgradedisplaytype_help'] = 'Kui linnuke, siis hinde tähed ja piirväärtused kursusel on seatud, selle asemel, et kasutada saidi vaikeväärtusi.';
$string['parentcategory'] = 'Ülemkategooria';
$string['pctoftotalgrade'] = '% koguhindest';
$string['percent'] = 'Protsent';
$string['percentage'] = 'Protsent';
$string['percentageletter'] = 'Protsent (täheline hinne)';
$string['percentagereal'] = 'Protsent (punktid)';
$string['percentascending'] = 'Sorteeri kasvavalt protsendi järgi';
$string['percentdescending'] = 'Sorteeri kahanevalt protsendi järgi';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Liida hindele';
$string['plusfactor_help'] = 'Nihe on number, mis lisatakse igale hindele selle hinde elemendi kohta, pärast rakendatakse kordaja.';
$string['points'] = 'punktid';
$string['pointsascending'] = 'Sorteeri kasvavalt punktide järgi';
$string['pointsdescending'] = 'Sorteeri kahanevalt punktide järgi';
$string['positionfirst'] = 'Esimene';
$string['positionlast'] = 'Viimane';
$string['preferences'] = 'Eelistused';
$string['prefgeneral'] = 'Üldine';
$string['prefletters'] = 'Tähelised hinded ja nende piirid';
$string['prefrows'] = 'Spetsiaalread';
$string['prefshow'] = 'Kuvamine';
$string['previewrows'] = 'Vaata ridu';
$string['profilereport'] = 'Kasutaja profiili raport';
$string['profilereport_help'] = 'Hinde raportit kasutatakse kasutaja profiili lehel.';
$string['publishing'] = 'Publitseerimine';
$string['quickfeedback'] = 'Tagasiside';
$string['quickgrading'] = 'Hinnete sisestamine otse hindetabelisse';
$string['quickgrading_help'] = 'Kui sisse lülitatud, mil muutmne sisse lülitatud, siis tekstikast ilmub iga hinde juurde, võimaldades mitut hinnet muuta samal ajal. Muudatused on salvestatud ja esile toodud, kui on vajutatud uuendamise nuppu.

Muide, kui hinne on muudetud hindaja raportis, siis ümber kehtestatuse lipp seatakse püsti, mis tähendab, et hinnet ei saa muuta seotud tegevuste poolt.';
$string['range'] = 'Vahemik';
$string['rangedecimals'] = 'Komakoha ulatus';
$string['rangedecimals_help'] = 'Komakohtade arv näitamaks tulemuste ulatust';
$string['rangesdecimalpoints'] = 'Vahemiku komakohad';
$string['rangesdecimalpoints_help'] = 'See seadistus määrab komakohtade arvu kuvamaks igat ulatust või kas üldine komakoha seadistus kategooriale või hinde elemendile on kasutatud (pärandatud).';
$string['rangesdisplaytype'] = 'Vahemiku kuvamise tüüp';
$string['rangesdisplaytype_help'] = 'See seadistus määrab kas vahemik kuvatakse reaalsete hinnetena, protsentides võitähtedena või mis kuvamise tüüp on kasutusel kategooria või hinde elemendi kohta (pärandumine).';
$string['rank'] = 'Võrdlus teistega';
$string['rawpct'] = 'Puhas %';
$string['real'] = 'Punktid';
$string['realletter'] = 'Punktid (täheline hinne)';
$string['realpercentage'] = 'Punktid (%%)';
$string['regradeanyway'] = 'Hinda uuesti';
$string['removeallcoursegrades'] = 'Kustuta kõik hinded';
$string['removeallcourseitems'] = 'Kustuta kõik objektid ja kategooriad';
$string['report'] = 'Raport';
$string['reportdefault'] = 'Vaikimisi ($a)';
$string['reportsettings'] = 'Raportite seaded';
$string['reprintheaders'] = 'Päiste kordamine';
$string['respectingcurrentdata'] = 'Jätakse praegune seadistus muutmata';
$string['rowpreviewnum'] = 'Vaata ridu';
$string['savechanges'] = 'Salvesta muudatused';
$string['savepreferences'] = 'Salvesta eelistused';
$string['scaleconfirmdelete'] = 'Oled sa kindel, et soovid kustutada skaalat "{$a}"?';
$string['scaledpct'] = 'Skaala %';
$string['seeallcoursegrades'] = 'Mine hindetabelisse';
$string['select'] = 'Vali {$a}';
$string['selectalloroneuser'] = 'Vali kõik või üks kasutaja';
$string['selectauser'] = 'Vali kasutaja';
$string['separator'] = 'Eraldaja';
$string['sepcolon'] = 'Koolon';
$string['sepcomma'] = 'Koma';
$string['sepsemicolon'] = 'Semikoolon';
$string['septab'] = 'Tabulaator';
$string['setcategories'] = 'Määra kategooriad';
$string['setcategorieserror'] = 'Sa pead esmalt määrama oma kursusele kategooriad, enne kui saad neile kaalusid anda';
$string['setgradeletters'] = 'Määra tähelised hinded';
$string['setpreferences'] = 'Määra eelistused';
$string['setting'] = 'Seadistus';
$string['settings'] = 'Seadistused';
$string['setweights'] = 'Määra kaalud';
$string['showactivityicons'] = 'Näita tegevuste ikoone';
$string['showactivityicons_help'] = 'Kui sisse lülitatud, siis tegevuse ikoonid kuvatakse tegevuse nimede järel.';
$string['showallhidden'] = 'Kuva varjatud';
$string['showallstudents'] = 'Näita kõiki õppijaid';
$string['showaverage'] = 'Kuva keskmine';
$string['showaverage_help'] = 'Kas kuvada "Hinnete keskmine" tulp? Õppijatel on võimalik, ära arvata teiste õppijate hindeid kui keskmise arvutamiseks on vähe hindeid. Jõudluse põhjustel, keskmine hinne on umbkaudne kui see sõltub peidetud hinnetest.';
$string['showaverages'] = 'Kuva veergude keskmised';
$string['showaverages_help'] = 'Kui sisse lülitatud, siis hindaja raport sisaldab lisarida kuvamaks keskmist väärtus iga kategooria ja hinde elemendi kohta.';
$string['showcalculations'] = 'Kuva arvutused';
$string['showcalculations_help'] = 'Kui lubatud, siis muutmisel, kuvatakse kalkulaatori ikoon iga hinnatava objekti ja kategooria juures, vihjetega kalkuleeritavatest objektidest ja visuaalselt näitab ära, et hinnatavas tulbas on kasutatud valemeid.';
$string['showeyecons'] = 'Näita kuva/peida ikoone';
$string['showeyecons_help'] = 'Kui sisse lülitatud siis muutmine on sisse lülitatud kuva/peida ikooni kuvatakse iga hinde kohta kontrollimaks tema nähtavust õpilasele.';
$string['showfeedback'] = 'Kuva tagasiside';
$string['showfeedback_help'] = 'Kuvada tagasiside veerg?';
$string['showgrade'] = 'Kuva hinded';
$string['showgrade_help'] = 'Kuvada hinde veerg?';
$string['showgroups'] = 'Kuva grupid';
$string['showhiddenitems'] = 'Näita peidetud objekte';
$string['showhiddenitems_help'] = 'Kas peidetud hinded oleks täielikult peidetud või oleksid peidetud hinnete nimed näha õppijatele.

* Näita peidetuid - Peidetud hinnete nimesi kuvatakse aga õppijate hinded on peidetud.
* Peidetud kuni - Hinded on täielikult peidetud kuni määratud ajani, pärast mida muutuvad nähtavaks.
* Peidetud - Peidetud hinded on täielikult peidetud';
$string['showhiddenuntilonly'] = 'Peidetud määratud ajani';
$string['showlettergrade'] = 'Näita tähelised hinded';
$string['showlettergrade_help'] = 'Kuvada täheline hinde veerg?';
$string['showlocks'] = 'Näita lukke';
$string['showlocks_help'] = 'Kui sisse lülitatud, mil muutmne sisse lülitatud, lukusta/lukusta lahti ikoon kuvatakse iga hinde kohta kontrollimaks kas hinnet saab automaatselt uuendada seotud tegevuse poolt.';
$string['shownohidden'] = 'Pole peidetud';
$string['shownooutcomes'] = 'Peida hinded';
$string['shownumberofgrades'] = 'Näita keskmise arvutamiseks võetud hinnete <br>arvu';
$string['shownumberofgrades_help'] = 'Kui sisse lülitatud, siis hinnete kogus, mida kasutati keskmise arvutamiseks, kuvatakse keskmist hinnet sulgudes.';
$string['showpercentage'] = 'Protsendid';
$string['showpercentage_help'] = 'Kuvada protsentuaalsed väärtused igal hindel?';
$string['showquickfeedback'] = 'Näita sisestatud tagasisidet';
$string['showquickfeedback_help'] = 'Kui sisse lülitatud, mil muutmne sisse lülitatud, tagasiside teksti sisendkast täpilise servaga ilmub igale hindele, lubades tagasisidet mitmele hindele muuta samaaegselt. Muudatused salvestatakse ja esile tõstetud, mil uuendamise nuppu on vajutatud.

Muide, kui tasisidet on muudetud hindaja raportis, siis ümber kehtestatuse lipp seatakse püsti, mis tähendab, et tagasisidet ei saa muuta seotud tegevuste poolt.';
$string['showrange'] = 'Kuva vahemik';
$string['showrange_help'] = 'Kuvada vahemiku veerg?';
$string['showranges'] = 'Kuva vahemikud';
$string['showranges_help'] = 'Kui sisse lülitatu, siis hindaja raport sisaldab lisarida kuvamaks vahemikku iga kategooria ja hinde elemendi kohta.';
$string['showrank'] = 'Tulemus teistega võrreldes';
$string['showrank_help'] = 'Kuvada õpilase positsioon võrreldes teistega klassis iga hindeelemendi kohta?';
$string['showuserimage'] = 'Näita õppija pilti';
$string['showuserimage_help'] = 'Kas kuvatakse kasutaja profiili pilti nime järel hindaja raportis.';
$string['showverbose'] = 'Kuva {$a->category}$a->itemmodule {$a->itemname}';
$string['showweight'] = 'Kuva kaalud';
$string['showweight_help'] = 'Kuvada hinde kaalu veerg?';
$string['simpleview'] = 'Lihtne vaade';
$string['sitewide'] = 'Saidiülene';
$string['sort'] = 'sorteeri';
$string['sortasc'] = 'Sorteeri kasvavas järjekorras';
$string['sortbyfirstname'] = 'Sorteeri eesnime järgi';
$string['sortbylastname'] = 'Sorteeri perekonnanime järgi';
$string['sortdesc'] = 'Sorteeri kahanevas järjekorras';
$string['standarddeviation'] = 'Standardhälve';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Õppija';
$string['studentsperpage'] = 'Õpilasi lehe kohta';
$string['studentsperpage_help'] = 'See seadistus määrab minu õpilast kuvatakse lehe kohta hindaja raportis.';
$string['subcategory'] = 'Normaalne kategooria';
$string['submissions'] = 'Esitused';
$string['submittedon'] = 'Postitatud: {$a}';
$string['switchtofullview'] = 'Lülita täisvaatele';
$string['tabs'] = 'Sakid';
$string['total'] = 'Kokku';
$string['totalweight100'] = 'Kogukaal on 100';
$string['totalweightnot100'] = 'Kogukaal ei ole 100';
$string['turnfeedbackoff'] = 'Keera tagasiside sisse';
$string['turnfeedbackon'] = 'Keeta tagasiside välja';
$string['typenone'] = 'Pole';
$string['typescale'] = 'Skaala';
$string['typescale_help'] = 'See seadistus määrab kasutatava skaala, mil kasutatakse skaala hinde tüüpi. Skaala tegevuse põhisele hinde elemendile on seatud tegevuse seadete lehel.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Väärtus';
$string['uncategorised'] = 'Kategooriata';
$string['unchangedgrade'] = 'Hinne muutmatu';
$string['unenrolledusersinimport'] = 'See import sisaldas järgmiste kasutajate hindeid, kes ei ole praegu registreeritud kursusele: {$a}';
$string['unlimitedgrades'] = 'Piiramatud hinded';
$string['unlimitedgrades_help'] = 'Vaikimisi hinded on limiteeritud maksimaalse ja minimaalse hinde elemendi väärtuse poolt. Sisse lülitades selle seadistuse, eemaldatakse see limiit ja lubatakse üle 100%-lisi hindeid sisestada otse hinnetelehele. Soovitatav on seda seadistust sisse lülitada mitte tipptunni ajal, sest kõik hinded arvutatakse ümber, mis võib põhjustada serverile suurt koormust.';
$string['unlock'] = 'Ava';
$string['unlockverbose'] = 'Lukusta lahti {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Kasutamata';
$string['updatedgradesonly'] = 'Ekspordi ainult uued ja uuendatud hinded';
$string['uploadgrades'] = 'Laadi hinded üles';
$string['useadvanced'] = 'Kasuta täpsemat seadistust';
$string['usedcourses'] = 'Kasutatud kursused';
$string['usedgradeitem'] = 'Kasutatud hinde element';
$string['usenoscale'] = 'Ära kasuta skaalat';
$string['usepercent'] = 'Kasuta protsenti';
$string['user'] = 'Kasutaja';
$string['userenrolmentsuspended'] = 'Kasutaja registreerumine seisatatud';
$string['usergrade'] = 'Kasutaja {$a->fullname} ({$a->useridnumber}) elemendil {$a->gradeidnumber}';
$string['userpreferences'] = 'Kasutaja eelistused';
$string['useweighted'] = 'Kasuta kaalusid';
$string['verbosescales'] = 'Lisa kaalud';
$string['viewbygroup'] = 'Rühm';
$string['viewgrades'] = 'Vaata hindeid';
$string['warningexcludedsum'] = 'Hoiatus: hinnete välja jätmine ei ole ühilduv koondsummaga.';
$string['weight'] = 'kaal';
$string['weightedascending'] = 'Sorteeri kaalutud protsendi järgi kasvavalt';
$string['weighteddescending'] = 'Sorteeri kaalutud protsendi järgi kahanevalt';
$string['weightedpct'] = 'kaalutud %';
$string['weightedpctcontribution'] = 'kaalutud % toetus';
$string['weights'] = 'Kaalud';
$string['weightuc'] = 'Kaal';
$string['writinggradebookinfo'] = 'Kirjutan hinnetelehe seadeid';
$string['xml'] = 'XML';
$string['yes'] = 'jah';
$string['yourgrade'] = 'Sinu hinne';
